/*
 * Decompiled with CFR 0.152.
 */
package jnr.process;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import jnr.constants.platform.Signal;
import jnr.enxio.channels.NativeDeviceChannel;
import jnr.enxio.channels.NativeSelectorProvider;
import jnr.posix.POSIX;

public class Process {
    private final long pid;
    private final POSIX posix;
    private final NativeDeviceChannel out;
    private final NativeDeviceChannel in;
    private final NativeDeviceChannel err;
    long exitValue = -1L;

    public Process(POSIX posix, long pid, int out, int in, int err) {
        this.posix = posix;
        this.pid = pid;
        this.out = new NativeDeviceChannel(NativeSelectorProvider.getInstance(), out, 4);
        this.in = new NativeDeviceChannel(NativeSelectorProvider.getInstance(), in, 1);
        this.err = new NativeDeviceChannel(NativeSelectorProvider.getInstance(), err, 1);
    }

    public long getPid() {
        return this.pid;
    }

    public SelectableChannel getOut() {
        return this.out;
    }

    public OutputStream getOutputStream() {
        return Channels.newOutputStream((WritableByteChannel)this.out);
    }

    public SelectableChannel getIn() {
        return this.in;
    }

    public InputStream getInputStream() {
        return Channels.newInputStream((ReadableByteChannel)this.in);
    }

    public SelectableChannel getErr() {
        return this.err;
    }

    public InputStream getErrorStream() {
        return Channels.newInputStream((ReadableByteChannel)this.err);
    }

    public long waitFor() {
        if (this.exitValue != -1L) {
            return this.exitValue;
        }
        int[] status = new int[1];
        int ret = this.posix.waitpid(this.pid, status, 0);
        this.exitValue = status[0];
        return this.exitValue;
    }

    public int kill() {
        return this.kill(Signal.SIGKILL);
    }

    public int kill(Signal sig) {
        return this.posix.kill((int)this.pid, sig.intValue());
    }

    public int killProcessGroup() {
        return this.killProcessGroup(Signal.SIGKILL);
    }

    public int killProcessGroup(Signal sig) {
        return this.posix.kill((int)(-this.pid), sig.intValue());
    }

    public long exitValue() {
        if (this.exitValue == -1L) {
            throw new IllegalThreadStateException("subprocess has not yet completed");
        }
        return this.exitValue;
    }
}

