/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Collector;
import org.jsoup.select.Evaluator;

abstract class StructuralEvaluator
extends Evaluator {
    Evaluator evaluator;

    StructuralEvaluator() {
    }

    static class ImmediatePreviousSibling
    extends StructuralEvaluator {
        public ImmediatePreviousSibling(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public boolean matches(Element root2, Element element) {
            if (root2 == element) {
                return false;
            }
            Element prev2 = element.previousElementSibling();
            return prev2 != null && this.evaluator.matches(root2, prev2);
        }

        public String toString() {
            return String.format("%s + ", this.evaluator);
        }
    }

    static class PreviousSibling
    extends StructuralEvaluator {
        public PreviousSibling(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public boolean matches(Element root2, Element element) {
            if (root2 == element) {
                return false;
            }
            for (Element prev2 = element.previousElementSibling(); prev2 != null; prev2 = prev2.previousElementSibling()) {
                if (!this.evaluator.matches(root2, prev2)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return String.format("%s ~ ", this.evaluator);
        }
    }

    static class ImmediateParent
    extends StructuralEvaluator {
        public ImmediateParent(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public boolean matches(Element root2, Element element) {
            if (root2 == element) {
                return false;
            }
            Element parent = element.parent();
            return parent != null && this.evaluator.matches(root2, parent);
        }

        public String toString() {
            return String.format("%s > ", this.evaluator);
        }
    }

    static class Parent
    extends StructuralEvaluator {
        public Parent(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public boolean matches(Element root2, Element element) {
            if (root2 == element) {
                return false;
            }
            for (Element parent = element.parent(); parent != null; parent = parent.parent()) {
                if (this.evaluator.matches(root2, parent)) {
                    return true;
                }
                if (parent == root2) break;
            }
            return false;
        }

        public String toString() {
            return String.format("%s ", this.evaluator);
        }
    }

    static class Not
    extends StructuralEvaluator {
        public Not(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public boolean matches(Element root2, Element node2) {
            return !this.evaluator.matches(root2, node2);
        }

        public String toString() {
            return String.format(":not(%s)", this.evaluator);
        }
    }

    static class Has
    extends StructuralEvaluator {
        final Collector.FirstFinder finder;

        public Has(Evaluator evaluator) {
            this.evaluator = evaluator;
            this.finder = new Collector.FirstFinder(evaluator);
        }

        @Override
        public boolean matches(Element root2, Element element) {
            for (int i = 0; i < element.childNodeSize(); ++i) {
                Element match;
                Node node2 = element.childNode(i);
                if (!(node2 instanceof Element) || (match = this.finder.find(element, (Element)node2)) == null) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return String.format(":has(%s)", this.evaluator);
        }
    }

    static class Root
    extends Evaluator {
        Root() {
        }

        @Override
        public boolean matches(Element root2, Element element) {
            return root2 == element;
        }
    }
}

