(ns soothe.ru
  (:require
   [soothe.core :as sth]

   #?(:clj  [clojure.spec.alpha :as s]
      :cljs [cljs.spec.alpha :as s])

   #?(:cljs
      [soothe.js :refer [format]])))


(def presets
  {`seq?                "Значение должно быть последовательностью."
   `char?               "Значение должно быть буквой."
   `string?             "Значение должно быть строкой"
   `map?                "Значение должно быть словарём."
   `vector?             "Значение должно быть вектором."
   `nil?                "Значение должно быть nil."
   `false?              "Значение должно быть ложью."
   `true?               "Значение должно быть истиной."
   `boolean?            "Значение должно быть логического типа."
   `some?               "Значение не должно быть nil."
   `symbol?             "Значение должно быть символом"
   `keyword?            "Значение должно быть кейвордом."
   `delay?              "Значение должно быть Delayed-объектом."
   `zero?               "Значение должно быть равно нулю."
   `pos?                "Значение должно быть положительным числом."
   `neg?                "Значение должно быть отрицательным числом."
   `integer?            "Значение должно быть целым числом."
   `even?               "Значение должно быть чётным числом."
   `odd?                "Значение должно быть нечётным числом."
   `int?                "Значение должно быть целым числом."
   `pos-int?            "Значение должно быть положительным целым числом."
   `neg-int?            "Значение должно быть отрицательным целым числом."
   `nat-int?            "Значение должно быть натуральным целым числом."
   `double?             "Значение должно быть числом двойной точности."
   `map-entry?          "Значение должно быть элементом словаря."
   `ident?              "Значение должно быть символом или кейвордом."
   `simple-ident?       "Значение должно быть простым символом или кейвордом."
   `qualified-ident?    "Значение должно быть квалифицированным символом или кейвордом."
   `simple-symbol?      "Значение должно быть простым символом."
   `qualified-symbol?   "Значение должно быть квалифицированным символом."
   `simple-keyword?     "Значение должно быть простым кейвордом."
   `qualified-keyword?  "Значение должно быть квалифицированным кейвордом."
   `not-empty           "Значение должно быть не пустой коллекцией."
   `number?             "Значение должно быть числом."
   `ratio?              "Значение должно быть дробью."
   `decimal?            "Значение должно быть десятичным числом."
   `float?              "Значение должно быть числом с плавающей запятой."
   `rational?           "Значение должно быть рациональным числом."
   `set?                "Значение должно быть множеством."
   `special-symbol?     "Значение должно быть особым символом."
   `var?                "Значение должно быть объектом Var."
   `bytes?              "Значение должно быть массивом байтов."
   `class?              "Значение должно быть классом."
   `empty?              "Значение должно быть пустым."
   `coll?               "Значение должно быть коллекцией."
   `list?               "Значение должно быть списком."
   `seqable?            "Значение должно поддерживать преобразование в последовательность."
   `ifn?                "Значение должно быть вызываемым."
   `fn?                 "Значение должно быть функцией."
   `associative?        "Значение должно поддерживать ассоциативный доступ."
   `sequential?         "Значение должно поддерживать протокол Sequential."
   `sorted?             "Значение должно поддерживать сортировку."
   `counted?            "Значение должно поддерживать подсчет значений."
   `reversible?         "Значение должно поддерживать обратный порядок."
   `indexed?            "Значение должно поддерживать доступ по индексу."
   `future?             "Значение должно быть объектом Future."
   `inst?               "Значение должно быть датой."
   `uuid?               "Значение должно быть объектом UUID."

   ;; spec

   `s/spec?             "Значение должно быть объектом Spec."
   `s/regex?            "Значение должно быть регулярным выражением."

   ;; special cases

   ::sth/missing-key
   (fn [{:keys [key]}]
     (format "Отсутствует обязательный ключ'%s'."
             (-> key str (subs 1))))

   ::sth/default
   "Неверное значение."})


(sth/def-many presets)
