/*
 * Decompiled with CFR 0.152.
 */
package pg.migration;

import clojure.lang.AFn;
import clojure.lang.AReference;
import clojure.lang.Compiler;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.LockingTransaction;
import clojure.lang.Namespace;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Tuple;
import clojure.lang.Var;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import pg.migration.core$_migrate;
import pg.migration.core$_rollback;
import pg.migration.core$cleanup_slug;
import pg.migration.core$create_migration_files;
import pg.migration.core$ensure_table;
import pg.migration.core$error_BANG_;
import pg.migration.core$fn__2072;
import pg.migration.core$generate_datetime_id;
import pg.migration.core$get_applied_migration_ids;
import pg.migration.core$group_parsed_urls;
import pg.migration.core$letters;
import pg.migration.core$loading__6789__auto____499;
import pg.migration.core$log_connection_info;
import pg.migration.core$log_sql;
import pg.migration.core$make_file_name;
import pg.migration.core$make_scope;
import pg.migration.core$migrate_all;
import pg.migration.core$migrate_one;
import pg.migration.core$migrate_to;
import pg.migration.core$parse_name;
import pg.migration.core$parse_url;
import pg.migration.core$read_disk_migrations;
import pg.migration.core$rollback_all;
import pg.migration.core$rollback_one;
import pg.migration.core$rollback_to;
import pg.migration.core$text__GT_slug;
import pg.migration.core$url__GT_migrations;
import pg.migration.core$validate_conflicts_BANG_;
import pg.migration.core$validate_duplicates_BANG_;
import pg.migration.core$validate_migration_id_BANG_;

public class core__init {
    public static final Var const__0;
    public static final AFn const__1;
    public static final AFn const__3;
    public static final AFn const__4;
    public static final Var const__5;
    public static final Var const__6;
    public static final AFn const__12;
    public static final AFn const__16;
    public static final Var const__17;
    public static final AFn const__19;
    public static final Object const__20;
    public static final Var const__21;
    public static final AFn const__25;
    public static final Var const__26;
    public static final AFn const__30;
    public static final Var const__31;
    public static final AFn const__34;
    public static final Var const__35;
    public static final AFn const__38;
    public static final Var const__39;
    public static final AFn const__42;
    public static final Var const__43;
    public static final AFn const__46;
    public static final Var const__47;
    public static final AFn const__50;
    public static final Var const__51;
    public static final AFn const__54;
    public static final Var const__55;
    public static final AFn const__58;
    public static final Var const__59;
    public static final AFn const__62;
    public static final Var const__63;
    public static final AFn const__66;
    public static final Var const__67;
    public static final AFn const__70;
    public static final Var const__71;
    public static final AFn const__74;
    public static final Var const__75;
    public static final AFn const__78;
    public static final Var const__79;
    public static final AFn const__82;
    public static final Var const__83;
    public static final AFn const__86;
    public static final Var const__87;
    public static final AFn const__90;
    public static final Var const__91;
    public static final AFn const__94;
    public static final Var const__95;
    public static final AFn const__98;
    public static final Var const__99;
    public static final AFn const__102;
    public static final Var const__103;
    public static final AFn const__106;
    public static final Var const__107;
    public static final AFn const__110;
    public static final Var const__111;
    public static final AFn const__114;
    public static final Var const__115;
    public static final AFn const__118;
    public static final Var const__119;
    public static final AFn const__122;
    public static final Var const__123;
    public static final AFn const__126;
    public static final Var const__127;
    public static final AFn const__130;
    public static final Var const__131;
    public static final AFn const__134;
    public static final Var const__135;
    public static final AFn const__138;

    public static void load() {
        Object v3;
        Object object = ((IFn)const__0.getRawRoot()).invoke((Object)const__1);
        IPersistentMap iPersistentMap = ((AReference)Namespace.find((Symbol)((Symbol)const__1))).resetMeta((IPersistentMap)const__3);
        Object object2 = ((IFn)new core$loading__6789__auto____499()).invoke();
        if (((Symbol)const__1).equals((Object)const__4)) {
            v3 = null;
        } else {
            LockingTransaction.runInTransaction((Callable)((Callable)((Object)new core$fn__2072())));
            v3 = null;
        }
        Object object3 = const__5.set((Object)Boolean.TRUE);
        Var var = const__6;
        var.setMeta((IPersistentMap)const__12);
        Var var2 = var;
        var.bindRoot((Object)const__16);
        Var var3 = const__17;
        var3.setMeta((IPersistentMap)const__19);
        Var var4 = var3;
        var3.bindRoot(const__20);
        Var var5 = const__21;
        var5.setMeta((IPersistentMap)const__25);
        Var var6 = var5;
        var5.bindRoot((Object)new core$parse_name());
        Var var7 = const__26;
        var7.setMeta((IPersistentMap)const__30);
        Var var8 = var7;
        var7.bindRoot((Object)DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneOffset.UTC));
        Var var9 = const__31;
        var9.setMeta((IPersistentMap)const__34);
        Var var10 = var9;
        var9.bindRoot((Object)new core$error_BANG_());
        const__31.setMacro();
        Object v15 = null;
        Var var11 = const__31;
        Var var12 = const__35;
        var12.setMeta((IPersistentMap)const__38);
        Var var13 = var12;
        var12.bindRoot((Object)new core$letters());
        Var var14 = const__39;
        var14.setMeta((IPersistentMap)const__42);
        Var var15 = var14;
        var14.bindRoot((Object)new core$generate_datetime_id());
        Var var16 = const__43;
        var16.setMeta((IPersistentMap)const__46);
        Var var17 = var16;
        var16.bindRoot((Object)new core$text__GT_slug());
        Var var18 = const__47;
        var18.setMeta((IPersistentMap)const__50);
        Var var19 = var18;
        var18.bindRoot((Object)new core$make_file_name());
        Var var20 = const__51;
        var20.setMeta((IPersistentMap)const__54);
        Var var21 = var20;
        var20.bindRoot((Object)new core$create_migration_files());
        Var var22 = const__55;
        var22.setMeta((IPersistentMap)const__58);
        Var var23 = var22;
        var22.bindRoot((Object)new core$cleanup_slug());
        Var var24 = const__59;
        var24.setMeta((IPersistentMap)const__62);
        Var var25 = var24;
        var24.bindRoot((Object)new core$ensure_table());
        Var var26 = const__63;
        var26.setMeta((IPersistentMap)const__66);
        Var var27 = var26;
        var26.bindRoot((Object)new core$parse_url());
        Var var28 = const__67;
        var28.setMeta((IPersistentMap)const__70);
        Var var29 = var28;
        var28.bindRoot((Object)new core$group_parsed_urls());
        Var var30 = const__71;
        var30.setMeta((IPersistentMap)const__74);
        Var var31 = var30;
        var30.bindRoot((Object)new core$validate_duplicates_BANG_());
        Var var32 = const__75;
        var32.setMeta((IPersistentMap)const__78);
        Var var33 = var32;
        var32.bindRoot((Object)new core$url__GT_migrations());
        Var var34 = const__79;
        var34.setMeta((IPersistentMap)const__82);
        Var var35 = var34;
        var34.bindRoot((Object)new core$read_disk_migrations());
        Var var36 = const__83;
        var36.setMeta((IPersistentMap)const__86);
        Var var37 = var36;
        var36.bindRoot((Object)new core$get_applied_migration_ids());
        Var var38 = const__87;
        var38.setMeta((IPersistentMap)const__90);
        Var var39 = var38;
        var38.bindRoot((Object)new core$validate_conflicts_BANG_());
        Var var40 = const__91;
        var40.setMeta((IPersistentMap)const__94);
        Var var41 = var40;
        var40.bindRoot((Object)new core$validate_migration_id_BANG_());
        Var var42 = const__95;
        var42.setMeta((IPersistentMap)const__98);
        Var var43 = var42;
        var42.bindRoot((Object)new core$make_scope());
        Var var44 = const__99;
        var44.setMeta((IPersistentMap)const__102);
        Var var45 = var44;
        var44.bindRoot((Object)new core$log_connection_info());
        Var var46 = const__103;
        var46.setMeta((IPersistentMap)const__106);
        Var var47 = var46;
        var46.bindRoot((Object)new core$log_sql());
        Var var48 = const__107;
        var48.setMeta((IPersistentMap)const__110);
        Var var49 = var48;
        var48.bindRoot((Object)new core$_migrate());
        Var var50 = const__111;
        var50.setMeta((IPersistentMap)const__114);
        Var var51 = var50;
        var50.bindRoot((Object)new core$migrate_to());
        Var var52 = const__115;
        var52.setMeta((IPersistentMap)const__118);
        Var var53 = var52;
        var52.bindRoot((Object)new core$migrate_all());
        Var var54 = const__119;
        var54.setMeta((IPersistentMap)const__122);
        Var var55 = var54;
        var54.bindRoot((Object)new core$migrate_one());
        Var var56 = const__123;
        var56.setMeta((IPersistentMap)const__126);
        Var var57 = var56;
        var56.bindRoot((Object)new core$_rollback());
        Var var58 = const__127;
        var58.setMeta((IPersistentMap)const__130);
        Var var59 = var58;
        var58.bindRoot((Object)new core$rollback_to());
        Var var60 = const__131;
        var60.setMeta((IPersistentMap)const__134);
        Var var61 = var60;
        var60.bindRoot((Object)new core$rollback_all());
        Var var62 = const__135;
        var62.setMeta((IPersistentMap)const__138);
        Var var63 = var62;
        var62.bindRoot((Object)new core$rollback_one());
    }

    public static void __init0() {
        const__0 = RT.var((String)"clojure.core", (String)"in-ns");
        const__1 = (AFn)((IObj)Symbol.intern(null, (String)"pg.migration.core")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"doc"), "\n  Common migration functions.\n  "}));
        const__3 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"doc"), "\n  Common migration functions.\n  "});
        const__4 = (AFn)Symbol.intern(null, (String)"clojure.core");
        const__5 = RT.var((String)"clojure.core", (String)"*warn-on-reflection*");
        const__6 = RT.var((String)"pg.migration.core", (String)"DEFAULTS");
        const__12 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"line"), 24, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__16 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"migrations-table"), RT.keyword(null, (String)"migrations"), RT.keyword(null, (String)"migrations-path"), "migrations"});
        const__17 = RT.var((String)"pg.migration.core", (String)"RE_FILE");
        const__19 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"line"), 29, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__20 = Pattern.compile("(?i)(\\d+)\\.(.*?)\\.?(prev|next|up|down)\\.sql$");
        const__21 = RT.var((String)"pg.migration.core", (String)"parse-name");
        const__25 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)((IObj)Symbol.intern(null, (String)"file-name")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"String")}))))), RT.keyword(null, (String)"line"), 33, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__26 = RT.var((String)"pg.migration.core", (String)"DATETIME_PATTERN");
        const__30 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), RT.classForName((String)"java.time.format.DateTimeFormatter"), RT.keyword(null, (String)"line"), 37, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__31 = RT.var((String)"pg.migration.core", (String)"error!");
        const__34 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"template"), (Object)Symbol.intern(null, (String)"&"), (Object)Symbol.intern(null, (String)"args")))), RT.keyword(null, (String)"line"), 43, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__35 = RT.var((String)"pg.migration.core", (String)"letters");
        const__38 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"n")), Tuple.create((Object)Symbol.intern(null, (String)"n"), (Object)Symbol.intern(null, (String)"ch")))), RT.keyword(null, (String)"doc"), "\n  Repeat a certain string/character N times.\n  ", RT.keyword(null, (String)"line"), 47, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__39 = RT.var((String)"pg.migration.core", (String)"generate-datetime-id");
        const__42 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(((IObj)Tuple.create()).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"java.lang.Long")})))), RT.keyword(null, (String)"doc"), "\n  Generate a Long number based on the current UTC datetime\n  of a format YYYYmmddHHMMSS, e.g. 20240308154432.\n  ", RT.keyword(null, (String)"line"), 57, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__43 = RT.var((String)"pg.migration.core", (String)"text->slug");
        const__46 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(((IObj)Tuple.create((Object)((IObj)Symbol.intern(null, (String)"text")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"String")})))).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"java.lang.String")})))), RT.keyword(null, (String)"doc"), "\n  Turn a 'Human  Friendly Text ' into something like\n  'human-friendly-text' to be a part of a migration file.\n  ", RT.keyword(null, (String)"line"), 68, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__47 = RT.var((String)"pg.migration.core", (String)"make-file-name");
        const__50 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(((IObj)Tuple.create((Object)Symbol.intern(null, (String)"id"), (Object)Symbol.intern(null, (String)"text"), (Object)Symbol.intern(null, (String)"direction"))).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"java.lang.String")})))), RT.keyword(null, (String)"doc"), "\n  Compose a file name based on the id,\n  an optional slug, and the direction type.\n  ", RT.keyword(null, (String)"line"), 81, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__51 = RT.var((String)"pg.migration.core", (String)"create-migration-files");
        const__54 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"migrations-path")), Tuple.create((Object)Symbol.intern(null, (String)"migrations-path"), (Object)RT.map((Object[])new Object[]{RT.keyword(null, (String)"keys"), Tuple.create((Object)Symbol.intern(null, (String)"id"), (Object)Symbol.intern(null, (String)"slug"))})))), RT.keyword(null, (String)"doc"), "\n  Create a couple of new migration files, prev and next.\n  When not set, the id is generated from the current UTC time.\n  Return a pair of `File` objects, prev and next.\n  ", RT.keyword(null, (String)"line"), 101, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__55 = RT.var((String)"pg.migration.core", (String)"cleanup-slug");
        const__58 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(((IObj)Tuple.create((Object)((IObj)Symbol.intern(null, (String)"slug")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"String")})))).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"java.lang.String")})))), RT.keyword(null, (String)"doc"), "\n  Turn a slug fragment into a human-friendly text.\n  ", RT.keyword(null, (String)"line"), 136, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__59 = RT.var((String)"pg.migration.core", (String)"ensure-table");
        const__62 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)((IObj)Symbol.intern(null, (String)"conn")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"Connection")})), (Object)((IObj)Symbol.intern(null, (String)"migrations-table")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"Keyword")}))))), RT.keyword(null, (String)"doc"), "\n  Having a db connection and the name of the migrations table,\n  create a table if it doesn't exist.\n  ", RT.keyword(null, (String)"line"), 147, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__63 = RT.var((String)"pg.migration.core", (String)"parse-url");
        const__66 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)((IObj)Symbol.intern(null, (String)"url")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"URL")}))))), RT.keyword(null, (String)"doc"), "\n  Split a URL pointing to a migration file to various fields.\n  ", RT.keyword(null, (String)"line"), 162, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__67 = RT.var((String)"pg.migration.core", (String)"group-parsed-urls");
        const__70 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(((IObj)Tuple.create((Object)Symbol.intern(null, (String)"parsed-urls"))).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"clojure.lang.Sorted")})))), RT.keyword(null, (String)"doc"), "\n  Having a seq of maps (parsed URLs), unify them by id.\n  Return a sorted map, an instance of `clojure.lang.Sorted`.\n  ", RT.keyword(null, (String)"line"), 196, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__71 = RT.var((String)"pg.migration.core", (String)"validate-duplicates!");
        const__74 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"parsed-urls")))), RT.keyword(null, (String)"doc"), "\n  Having a seq of parsed URLs, find those that have the same\n  (id, direction) pair. If found, an exception is thrown.\n  ", RT.keyword(null, (String)"line"), 216, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__75 = RT.var((String)"pg.migration.core", (String)"url->migrations");
        const__78 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(((IObj)Tuple.create((Object)((IObj)Symbol.intern(null, (String)"url")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"URL")})))).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"clojure.lang.Sorted")})))), RT.keyword(null, (String)"doc"), "\n  Fetch all the migrations from the top-level URL.\n  Return a sorted map like (id => migration-map).\n  ", RT.keyword(null, (String)"line"), 243, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__79 = RT.var((String)"pg.migration.core", (String)"read-disk-migrations");
        const__82 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(((IObj)Tuple.create((Object)((IObj)Symbol.intern(null, (String)"path")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"String")})))).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"clojure.lang.Sorted")})))), RT.keyword(null, (String)"doc"), "\n  Read all the migrations from a resource.\n  ", RT.keyword(null, (String)"line"), 257, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__83 = RT.var((String)"pg.migration.core", (String)"get-applied-migration-ids");
        const__86 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)((IObj)Symbol.intern(null, (String)"conn")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"Connection")})), (Object)((IObj)Symbol.intern(null, (String)"table")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"Keyword")}))))), RT.keyword(null, (String)"doc"), "\n  Read all the applied migrations from the database\n  and return a set of their ids.\n  ", RT.keyword(null, (String)"line"), 267, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__87 = RT.var((String)"pg.migration.core", (String)"validate-conflicts!");
        const__90 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)((IObj)Symbol.intern(null, (String)"migrations")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"Sorted")}))))), RT.keyword(null, (String)"doc"), "\n  Try to find a situation when a migration with less ID\n  was applied before another migration with a greater ID.\n\n  For example:\n\n  id applied\n   1 yes\n   2 yes\n   3 no\n   4 yes\n\n  Above, 3 is less then 4 but 4 has been applied whereas 3 has not.\n  Usually it happens when two features get merged at the same time.\n  To fix it, rename the migration 3 to 5 as follows:\n\n  id applied\n   1 yes\n   2 yes\n   4 yes\n   5 no\n\n  ", RT.keyword(null, (String)"line"), 284, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__91 = RT.var((String)"pg.migration.core", (String)"validate-migration-id!");
        const__94 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)((IObj)Symbol.intern(null, (String)"migrations")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"Sorted")})), (Object)Symbol.intern(null, (String)"id")))), RT.keyword(null, (String)"doc"), "\n  Check if the migration map has a certain id.\n  ", RT.keyword(null, (String)"line"), 319, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__95 = RT.var((String)"pg.migration.core", (String)"make-scope");
        const__98 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"config")))), RT.keyword(null, (String)"doc"), "\n  Having a raw config map, do the following:\n  - apply config defautls\n  - build migrations map\n  - get applied migration IDs from the database\n  - mark applied migrations;\n  - detect the current migration;\n\n  Return a map of all these fields.\n  ", RT.keyword(null, (String)"line"), 328, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__99 = RT.var((String)"pg.migration.core", (String)"log-connection-info");
    }

    public static void __init1() {
        const__102 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"config")))), RT.keyword(null, (String)"doc"), "\n  Report the connection information.\n  ", RT.keyword(null, (String)"line"), 378, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__103 = RT.var((String)"pg.migration.core", (String)"log-sql");
        const__106 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)((IObj)Symbol.intern(null, (String)"url")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"URL")})), (Object)Symbol.intern(null, (String)"sql")))), RT.keyword(null, (String)"line"), 404, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__107 = RT.var((String)"pg.migration.core", (String)"-migrate");
        const__110 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"scope"), (Object)Symbol.intern(null, (String)"id-migration's")))), RT.keyword(null, (String)"doc"), "\n  A general migrate forward function. Don't use it directly.\n  Accepts the scope map and a seq of pairs (id, migration).\n  Runs the migrations one by one. Tracks the applied migrations\n  in the database.\n  ", RT.keyword(null, (String)"line"), 412, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__111 = RT.var((String)"pg.migration.core", (String)"migrate-to");
        const__114 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"config"), (Object)Symbol.intern(null, (String)"id-to")))), RT.keyword(null, (String)"doc"), "\n  Migrate forward to a certain migration by its ID.\n  ", RT.keyword(null, (String)"line"), 460, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__115 = RT.var((String)"pg.migration.core", (String)"migrate-all");
        const__118 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"config")))), RT.keyword(null, (String)"doc"), "\n  Migrate all the pending forward migrations.\n  ", RT.keyword(null, (String)"line"), 482, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__119 = RT.var((String)"pg.migration.core", (String)"migrate-one");
        const__122 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"config")))), RT.keyword(null, (String)"doc"), "\n  Apply the next single migration.\n  ", RT.keyword(null, (String)"line"), 500, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__123 = RT.var((String)"pg.migration.core", (String)"-rollback");
        const__126 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"scope"), (Object)Symbol.intern(null, (String)"id-migration's")))), RT.keyword(null, (String)"doc"), "\n  A general rollback function. Don't use it directly.\n  Accepts the scope map and a seq of pairs (id, migration).\n  Rolls back the migrations one by one. Removes the records\n  from the database.\n  ", RT.keyword(null, (String)"line"), 519, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__127 = RT.var((String)"pg.migration.core", (String)"rollback-to");
        const__130 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"config"), (Object)Symbol.intern(null, (String)"id-to")))), RT.keyword(null, (String)"doc"), "\n  Rollback to a certain migration by its ID.\n  ", RT.keyword(null, (String)"line"), 568, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__131 = RT.var((String)"pg.migration.core", (String)"rollback-all");
        const__134 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"config")))), RT.keyword(null, (String)"doc"), "\n  Rollback all the previous migrations.\n  ", RT.keyword(null, (String)"line"), 590, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
        const__135 = RT.var((String)"pg.migration.core", (String)"rollback-one");
        const__138 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"config")))), RT.keyword(null, (String)"doc"), "\n  Rollback the current migration.\n  ", RT.keyword(null, (String)"line"), 609, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "pg/migration/core.clj"});
    }

    static {
        core__init.__init0();
        core__init.__init1();
        Compiler.pushNSandLoader((ClassLoader)RT.classForName((String)"pg.migration.core__init").getClassLoader());
        try {
            core__init.load();
        }
        catch (Throwable throwable) {
            Var.popThreadBindings();
            throw throwable;
        }
        Var.popThreadBindings();
    }
}

