(defn show-gui [the-ns locals & [options]]

  (let [latch
        (promise)

        {:keys [form]}
        options

        lab-input
        (new JLabel "Input. Eval all forms or selected only. Press Enter + Shift/Control to eval")

        lab-output
        (new JLabel "Locals")

        lab-log
        (new JLabel "Log")

        frame
        (new JFrame (format "Bogus debugger: %s" (ns-name the-ns)))

        btn-eval
        (new JButton "Eval")

        btn-clear
        (new JButton "Clear")

        area-input
        (new JTextArea)

        area-output
        (new JTextArea)

        area-log
        (new JTextArea)

        scroll-input
        (new JScrollPane area-input)

        scroll-output
        (new JScrollPane area-output)

        scroll-log
        (new JScrollPane area-log)

        fn-close
        (fn []
          (deliver latch true))

        fn-clear
        (fn []
          (.setText area-input "")
          (.setText area-output "")
          (.setText area-log ""))

        fn-eval
        (fn []

          (let [input
                (str/trim
                 (or (.getSelectedText area-input)
                     (.getText area-input)))]

            (when-not (str/blank? input)
              (let [result
                    (try
                      (let [form
                            (read-string (wrap-do input))]
                        (eval+ the-ns locals form))
                      (catch Throwable e
                        e))

                    output
                    (with-out-str
                      (if (throwable? result)
                        (trace/print-stack-trace result)
                        (pprint/pprint result)))]

                (.setText area-output output)

                (.append area-log input)
                (.append area-log br)
                (.append area-log output)
                (.append area-log br)

                (.setCaretPosition area-log (.. area-log getDocument getLength))))))

        frame-listener
        (reify WindowListener

          (windowActivated [this e])

          (windowClosed [this e])

          (windowClosing [this e]
            (fn-close))

          (windowDeactivated [this e])

          (windowDeiconified [this e])

          (windowIconified [this e])

          (windowOpened [this e]))]

    (.addWindowListener frame frame-listener)

    (.addActionListener btn-eval
                        (reify ActionListener
                          (actionPerformed [this e]
                            (fn-eval))))

    (.addActionListener btn-clear
                        (reify ActionListener
                          (actionPerformed [this e]
                            (fn-clear))))


    (.addKeyListener area-input
                     (proxy [KeyListener] []
                       (keyReleased [e])
                       (keyTyped [e])
                       (keyPressed [^KeyEvent e]
                         (when (and
                                (or (.isShiftDown e)
                                    (.isControlDown e))
                                (= (.getKeyCode e) KeyEvent/VK_ENTER))
                           (fn-eval)))))

    (when form
      (.setText area-input
                (with-out-str
                  (pprint/pprint form))))

    (.setBounds btn-eval     20 130 100 50)
    (.setBounds btn-clear   350 130 100 50)

    (.setBounds scroll-input  20  25 460 100)
    (.setBounds scroll-output 20 205 460 175)
    (.setBounds scroll-log    20 405 460 350)

    (.setEditable area-output false)
    (.setEditable area-log false)

    (.setLabelFor lab-input area-input)
    (.setLabelFor lab-output area-output)
    (.setLabelFor lab-log area-log)

    (.setBounds lab-input  20   5 500 20)
    (.setBounds lab-output 20 185 100 20)
    (.setBounds lab-log    20 385 100 20)

    (.add frame lab-input)
    (.add frame lab-output)
    (.add frame lab-log)

    (.add frame btn-eval)
    (.add frame btn-clear)

    (.add frame scroll-input)
    ;; (.add frame scroll-output)
    (.add frame scroll-log)

    (let [locals-pane
          (new JScrollPane (new JTree ^TreeModel (inspector/tree-model locals)))]
      (.setBounds locals-pane 20 205 460 175)
      (.add frame locals-pane))

    (.setSize frame 500 800)
    (.setLayout frame nil)
    (.setVisible frame true)

    latch))


+   (javax.swing.tree TreeModel)
