/*
 * Decompiled with CFR 0.152.
 */
package ifesdjeen.blomstre;

import ifesdjeen.blomstre.BloomCalculations;
import ifesdjeen.blomstre.ConcurrentBitSet;
import ifesdjeen.blomstre.MurmurHash;
import java.nio.ByteBuffer;
import java.util.function.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BloomFilter<T> {
    private static final long BITSET_EXCESS = 20L;
    private final Function<T, ByteBuffer> converter;
    public final ConcurrentBitSet bitset;
    public final int hashCount;

    BloomFilter(Function<T, ByteBuffer> converter, int hashes, ConcurrentBitSet bitset) {
        this.converter = converter;
        this.hashCount = hashes;
        this.bitset = bitset;
    }

    private long[] getHashBuckets(ByteBuffer key) {
        return this.getHashBuckets(key, this.hashCount, this.bitset.capacity());
    }

    protected long[] hash(ByteBuffer b, long seed) {
        return MurmurHash.hash3_x64_128(b, 0, b.capacity(), seed);
    }

    long[] getHashBuckets(ByteBuffer b, int hashCount, long max) {
        long[] result = new long[hashCount];
        long[] hash = this.hash(b, 0L);
        for (int i = 0; i < hashCount; ++i) {
            result[i] = Math.abs((hash[0] + (long)i * hash[1]) % max);
        }
        return result;
    }

    public void add(T key) {
        this.add(this.converter.apply(key));
    }

    protected void add(ByteBuffer key) {
        for (long bucketIndex : this.getHashBuckets(key)) {
            this.bitset.set(bucketIndex);
        }
    }

    public boolean isPresent(T key) {
        return this.isPresent(this.converter.apply(key));
    }

    protected boolean isPresent(ByteBuffer key) {
        for (long bucketIndex : this.getHashBuckets(key)) {
            if (this.bitset.get(bucketIndex)) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.bitset.clear();
    }

    public static <T> BloomFilter<T> makeFilter(Function<T, ByteBuffer> converter, int numElements, double maxFalsePosProbability) {
        int maxBucketsPerElement = BloomCalculations.maxBucketsPerElement(numElements);
        BloomCalculations.BloomSpecification spec = BloomCalculations.computeBloomSpec(maxBucketsPerElement, maxFalsePosProbability);
        long numBits = (long)(numElements * spec.bucketsPerElement) + 20L;
        return new BloomFilter<T>(converter, spec.K, new ConcurrentBitSet(numBits));
    }
}

