/*
 * Decompiled with CFR 0.152.
 */
package com.ifesdjeen.blomstre;

import java.nio.ByteBuffer;
import java.util.function.Function;

public class Converters {
    public static IntToByteBuffer intToByteBufferConverter = new IntToByteBuffer();
    public static LongToByteBuffer longToByteBufferConverter = new LongToByteBuffer();
    public static StringToByteBuffer stringToByteBufferConverter = new StringToByteBuffer();

    static class StringToByteBuffer
    implements Function<String, ByteBuffer> {
        StringToByteBuffer() {
        }

        @Override
        public ByteBuffer apply(String data) {
            byte[] bytes = data.getBytes();
            ByteBuffer bb = ByteBuffer.allocateDirect(bytes.length);
            bb.put(bytes);
            return bb;
        }
    }

    static class LongToByteBuffer
    implements Function<Long, ByteBuffer> {
        LongToByteBuffer() {
        }

        @Override
        public ByteBuffer apply(Long data) {
            ByteBuffer bb = ByteBuffer.allocateDirect(8);
            bb.putLong(data);
            return bb;
        }
    }

    static class IntToByteBuffer
    implements Function<Integer, ByteBuffer> {
        IntToByteBuffer() {
        }

        @Override
        public ByteBuffer apply(Integer data) {
            ByteBuffer bb = ByteBuffer.allocateDirect(4);
            bb.putInt(data);
            return bb;
        }
    }
}

