/*
 * Decompiled with CFR 0.152.
 */
package com.ifesdjeen.blomstre;

import java.util.concurrent.atomic.AtomicLongArray;

public class ConcurrentBitSet {
    private static final int BASE = 64;
    private static final long MAX_UNSIGNED_LONG = -1L;
    private final AtomicLongArray buckets;

    public ConcurrentBitSet(long bitsCount) {
        int bucketsCount = (int)bitsCount / 64;
        this.buckets = new AtomicLongArray(bucketsCount);
        for (int i = 0; i < this.buckets.length(); ++i) {
            this.buckets.set(i, 0L);
        }
    }

    public void set(long idx) {
        int bucketIdx = (int)idx / 64;
        this.atomicSet(bucketIdx, (int)idx - 64 * bucketIdx);
    }

    public boolean get(long idx) {
        int bucketIdx = (int)idx / 64;
        return this.atomicGet(bucketIdx, (int)idx - 64 * bucketIdx);
    }

    public void clear() {
        throw new RuntimeException("not implemented");
    }

    public long capacity() {
        return this.buckets.length() * 64;
    }

    private boolean atomicGet(int bucketIdx, int toGet) {
        long idxMask;
        long l = this.buckets.get(bucketIdx);
        return (l & (idxMask = ConcurrentBitSet.mask(toGet))) == idxMask;
    }

    private void atomicSet(int bucketIdx, int toSet) {
        long l;
        while (!this.buckets.compareAndSet(bucketIdx, l = this.buckets.get(bucketIdx), l | ConcurrentBitSet.mask(toSet))) {
        }
    }

    private static long mask(int id) {
        return 1L << id;
    }

    public String longToBinaryStr(long num) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 64; ++i) {
            long idxMask = ConcurrentBitSet.mask(i);
            stringBuilder.append((num & idxMask) == idxMask ? "1" : "0");
        }
        return stringBuilder.toString();
    }
}

