/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.siddhi.utils;

import io.siddhi.query.api.SiddhiApp;
import io.siddhi.query.api.definition.StreamDefinition;
import io.siddhi.query.api.execution.ExecutionElement;
import io.siddhi.query.api.execution.partition.Partition;
import io.siddhi.query.api.execution.partition.ValuePartitionType;
import io.siddhi.query.api.execution.query.Query;
import io.siddhi.query.api.execution.query.input.handler.StreamHandler;
import io.siddhi.query.api.execution.query.input.handler.Window;
import io.siddhi.query.api.execution.query.input.stream.InputStream;
import io.siddhi.query.api.execution.query.input.stream.JoinInputStream;
import io.siddhi.query.api.execution.query.input.stream.SingleInputStream;
import io.siddhi.query.api.execution.query.input.stream.StateInputStream;
import io.siddhi.query.api.execution.query.output.stream.OutputStream;
import io.siddhi.query.api.execution.query.selection.OutputAttribute;
import io.siddhi.query.api.execution.query.selection.Selector;
import io.siddhi.query.api.expression.Expression;
import io.siddhi.query.api.expression.Variable;
import io.siddhi.query.compiler.SiddhiCompiler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.ListUtils;
import org.apache.flink.streaming.siddhi.schema.SiddhiStreamSchema;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiddhiExecutionPlanner {
    private static final Logger LOG = LoggerFactory.getLogger(SiddhiExecutionPlanner.class);
    private String executionPlan;
    private String enrichedExecutionPlan;
    private Map<String, StreamDefinition> inputStreams = new HashMap<String, StreamDefinition>();
    private Map<String, List<OutputAttribute>> outputStreams = new HashMap<String, List<OutputAttribute>>();
    private Map<String, StreamPartition> streamPartitions;

    public SiddhiExecutionPlanner(Map<String, SiddhiStreamSchema<?>> dataStreamSchemas, String executionPlan) {
        this.executionPlan = executionPlan;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, SiddhiStreamSchema<?>> entry : dataStreamSchemas.entrySet()) {
            sb.append(entry.getValue().getStreamDefinitionExpression(entry.getKey()));
        }
        sb.append(executionPlan);
        this.enrichedExecutionPlan = sb.toString();
    }

    public static SiddhiExecutionPlanner of(Map<String, SiddhiStreamSchema<?>> dataStreamSchemas, String executionPlan) {
        return new SiddhiExecutionPlanner(dataStreamSchemas, executionPlan);
    }

    public String getEnrichedExecutionPlan() {
        return this.enrichedExecutionPlan;
    }

    private void parse() throws Exception {
        SiddhiApp siddhiApp = SiddhiCompiler.parse((String)this.enrichedExecutionPlan);
        for (ExecutionElement executionElement : siddhiApp.getExecutionElementList()) {
            List groupBy;
            Map.Entry partitionType22;
            Query query;
            if (executionElement instanceof Query) {
                query = (Query)executionElement;
            } else {
                Partition partition = (Partition)executionElement;
                Map partitionTypeMap = partition.getPartitionTypeMap();
                query = (Query)partition.getQueryList().get(0);
                for (Map.Entry partitionType22 : partitionTypeMap.entrySet()) {
                    if (!(partitionType22.getValue() instanceof ValuePartitionType)) continue;
                    this.retrievePartition(this.findStreamPartition((String)partitionType22.getKey(), (ValuePartitionType)partitionType22.getValue()));
                }
            }
            InputStream inputStream = query.getInputStream();
            Selector selector = query.getSelector();
            HashMap<String, SingleInputStream> queryLevelAliasToStreamMapping = new HashMap<String, SingleInputStream>();
            partitionType22 = inputStream.getUniqueStreamIds().iterator();
            while (partitionType22.hasNext()) {
                String streamId = (String)partitionType22.next();
                if (this.inputStreams.containsKey(streamId)) continue;
                StreamDefinition streamDefinition = (StreamDefinition)siddhiApp.getStreamDefinitionMap().get(streamId);
                this.inputStreams.put(streamId, streamDefinition);
            }
            if (inputStream instanceof SingleInputStream) {
                this.retrieveAliasForQuery((SingleInputStream)inputStream, queryLevelAliasToStreamMapping);
                this.retrievePartition(this.findStreamPartition((SingleInputStream)inputStream, selector));
            } else if (inputStream instanceof JoinInputStream) {
                SingleInputStream leftSingleInputStream = (SingleInputStream)((JoinInputStream)inputStream).getLeftInputStream();
                this.retrieveAliasForQuery(leftSingleInputStream, queryLevelAliasToStreamMapping);
                this.retrievePartition(this.findStreamPartition(leftSingleInputStream, selector));
                SingleInputStream rightSingleInputStream = (SingleInputStream)((JoinInputStream)inputStream).getRightInputStream();
                this.retrieveAliasForQuery(rightSingleInputStream, queryLevelAliasToStreamMapping);
                this.retrievePartition(this.findStreamPartition(rightSingleInputStream, selector));
            } else if (inputStream instanceof StateInputStream && (groupBy = selector.getGroupByList()).size() > 0) {
                HashMap streamGroupBy = new HashMap();
                for (String string : inputStream.getUniqueStreamIds()) {
                    streamGroupBy.put(string, new ArrayList());
                }
                for (Variable variable : groupBy) {
                    if (variable.getStreamId() == null) {
                        for (String streamId : inputStream.getUniqueStreamIds()) {
                            ((List)streamGroupBy.get(streamId)).add(variable);
                        }
                        continue;
                    }
                    String streamId = this.retrieveStreamId(variable, queryLevelAliasToStreamMapping);
                    if (streamGroupBy.containsKey(streamId)) {
                        ((List)streamGroupBy.get(streamId)).add(variable);
                        continue;
                    }
                    throw new Exception(streamId + " is not defined!");
                }
                for (Map.Entry entry : streamGroupBy.entrySet()) {
                    if (((List)entry.getValue()).size() <= 0) continue;
                    this.retrievePartition(this.generatePartition((String)entry.getKey(), null, Arrays.asList(((List)entry.getValue()).toArray(new Variable[((List)entry.getValue()).size()]))));
                }
            }
            OutputStream outputStream = query.getOutputStream();
            this.outputStreams.put(outputStream.getId(), selector.getSelectionList());
        }
        for (String streamId : this.inputStreams.keySet()) {
            if (this.streamPartitions.containsKey(streamId)) continue;
            StreamPartition shufflePartition = new StreamPartition(streamId);
            shufflePartition.setType(StreamPartition.Type.SHUFFLE);
            this.streamPartitions.put(streamId, shufflePartition);
        }
    }

    private String retrieveStreamId(Variable variable, Map<String, SingleInputStream> aliasMap) throws Exception {
        Preconditions.checkNotNull((Object)variable.getStreamId(), (String)"streamId");
        if (this.inputStreams.containsKey(variable.getStreamId()) && aliasMap.containsKey(variable.getStreamId())) {
            throw new Exception("Duplicated streamId and alias: " + variable.getStreamId());
        }
        if (this.inputStreams.containsKey(variable.getStreamId())) {
            return variable.getStreamId();
        }
        if (aliasMap.containsKey(variable.getStreamId())) {
            return aliasMap.get(variable.getStreamId()).getStreamId();
        }
        throw new Exception(variable.getStreamId() + " does not exist!");
    }

    private void retrieveAliasForQuery(SingleInputStream inputStream, Map<String, SingleInputStream> aliasStreamMapping) throws Exception {
        if (inputStream.getStreamReferenceId() != null) {
            if (aliasStreamMapping.containsKey(inputStream.getStreamReferenceId())) {
                throw new Exception("Duplicated stream alias " + inputStream.getStreamId() + " -> " + inputStream);
            }
            aliasStreamMapping.put(inputStream.getStreamReferenceId(), inputStream);
        }
    }

    private void retrievePartition(StreamPartition partition) throws Exception {
        if (partition == null) {
            return;
        }
        if (!this.streamPartitions.containsKey(partition.getInputStreamId())) {
            this.streamPartitions.put(partition.getInputStreamId(), partition);
        } else {
            StreamPartition existingPartition = this.streamPartitions.get(partition.getInputStreamId());
            if (existingPartition.getType().equals((Object)partition.getType()) && ListUtils.isEqualList(existingPartition.getGroupByList(), partition.getGroupByList()) || existingPartition.getType().equals((Object)StreamPartition.Type.SHUFFLE) || existingPartition.getType().equals((Object)StreamPartition.Type.PARTITIONWITH)) {
                this.streamPartitions.put(partition.getInputStreamId(), partition);
            } else {
                throw new Exception("You have incompatible partitions on stream " + partition.getInputStreamId() + ": [1] " + this.streamPartitions.get(partition.getInputStreamId()).toString() + " [2] " + partition.toString() + "");
            }
        }
    }

    private StreamPartition findStreamPartition(SingleInputStream inputStream, Selector selector) {
        ArrayList<Window> windows = new ArrayList<Window>();
        for (StreamHandler streamHandler : inputStream.getStreamHandlers()) {
            if (!(streamHandler instanceof Window)) continue;
            windows.add((Window)streamHandler);
        }
        List groupBy = selector.getGroupByList();
        if (windows.size() > 0 || groupBy.size() > 0) {
            return this.generatePartition(inputStream.getStreamId(), windows, groupBy);
        }
        return null;
    }

    private StreamPartition findStreamPartition(String streamId, ValuePartitionType value) {
        Expression expression;
        StreamPartition partition = new StreamPartition(streamId);
        if (value != null && (expression = value.getExpression()) instanceof Variable) {
            String attributeName = ((Variable)expression).getAttributeName();
            partition.setPartitionWithList(Collections.singletonList(attributeName));
            partition.setType(StreamPartition.Type.PARTITIONWITH);
            return partition;
        }
        return null;
    }

    private StreamPartition generatePartition(String streamId, List<Window> windows, List<Variable> groupBy) {
        StreamPartition partition = new StreamPartition(streamId);
        if (windows == null || windows.size() > 0) {
            // empty if block
        }
        if (groupBy != null && groupBy.size() > 0) {
            partition.setGroupByList(groupBy.stream().map(Variable::getAttributeName).collect(Collectors.toList()));
            partition.setType(StreamPartition.Type.GROUPBY);
        } else {
            partition.setType(StreamPartition.Type.SHUFFLE);
        }
        return partition;
    }

    public Map<String, StreamPartition> getStreamPartitions() throws Exception {
        if (this.streamPartitions == null) {
            try {
                this.streamPartitions = new HashMap<String, StreamPartition>();
                this.parse();
            }
            catch (Exception ex) {
                LOG.error("Got error to parse policy execution plan: \n{}", (Object)this.executionPlan, (Object)ex);
                throw ex;
            }
        }
        return this.streamPartitions;
    }

    public static class StreamPartition {
        private String inputStreamId;
        private Type type;
        private List<String> groupByList = new ArrayList<String>();
        private List<String> partitionWithList = new ArrayList<String>();

        public StreamPartition(String inputStreamId) {
            this.inputStreamId = inputStreamId;
        }

        public String getInputStreamId() {
            return this.inputStreamId;
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public List<String> getGroupByList() {
            return this.groupByList;
        }

        public void setGroupByList(List<String> groupByList) {
            this.groupByList = groupByList;
        }

        public List<String> getPartitonWithList() {
            return this.partitionWithList;
        }

        public void setPartitionWithList(List<String> partitionWithList) {
            this.partitionWithList = partitionWithList;
        }

        public static enum Type {
            GROUPBY,
            SHUFFLE,
            PARTITIONWITH;

        }
    }
}

