/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.siddhi.router;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class StreamRoute
implements Serializable {
    private String inputStreamId;
    private Set<String> executionPlanIds = new HashSet<String>();
    private long partitionKey;
    private boolean broadCastPartitioning = false;

    public StreamRoute() {
    }

    public StreamRoute(String inputStreamId) {
        this.inputStreamId = inputStreamId;
    }

    public StreamRoute(String inputStreamId, String ... executionPlanIds) {
        this.inputStreamId = inputStreamId;
        this.executionPlanIds = new HashSet<String>(Arrays.asList(executionPlanIds));
    }

    public static StreamRoute of(String inputStreamId) {
        return new StreamRoute(inputStreamId);
    }

    public static StreamRoute of(String inputStreamId, String ... executionPlanIds) {
        return new StreamRoute(inputStreamId, executionPlanIds);
    }

    public String getInputStreamId() {
        return this.inputStreamId;
    }

    public void setInputStreamId(String inputStreamId) {
        this.inputStreamId = inputStreamId;
    }

    public Set<String> getExecutionPlanIds() {
        return this.executionPlanIds;
    }

    public void setExecutionPlanIds(Set<String> executionPlanIds) {
        this.executionPlanIds = executionPlanIds;
    }

    public long getPartitionKey() {
        return this.partitionKey;
    }

    public void setPartitionKey(long partitionKey) {
        this.partitionKey = partitionKey;
    }

    public void addExecutionPlanId(String executionPlanId) {
        this.executionPlanIds.add(executionPlanId);
    }

    public boolean isBroadCastPartitioning() {
        return this.broadCastPartitioning;
    }

    public void setBroadCastPartitioning(boolean broadCastPartitioning) {
        this.broadCastPartitioning = broadCastPartitioning;
    }
}

