/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.siddhi.control;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.flink.streaming.siddhi.control.ControlEvent;

public class MetadataControlEvent
extends ControlEvent {
    private Map<String, String> updatedExecutionPlanMap;
    private Map<String, String> addedExecutionPlanMap;
    private List<String> deletedExecutionPlanId;

    public Map<String, String> getUpdatedExecutionPlanMap() {
        return this.updatedExecutionPlanMap;
    }

    public MetadataControlEvent setUpdatedExecutionPlanMap(Map<String, String> updatedExecutionPlanMap) {
        this.updatedExecutionPlanMap = updatedExecutionPlanMap;
        return this;
    }

    public List<String> getDeletedExecutionPlanId() {
        return this.deletedExecutionPlanId;
    }

    public MetadataControlEvent setDeletedExecutionPlanId(List<String> deletedExecutionPlanId) {
        this.deletedExecutionPlanId = deletedExecutionPlanId;
        return this;
    }

    public Map<String, String> getAddedExecutionPlanMap() {
        return this.addedExecutionPlanMap;
    }

    public MetadataControlEvent setAddedExecutionPlanMap(Map<String, String> addedExecutionPlanMap) {
        this.addedExecutionPlanMap = addedExecutionPlanMap;
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getName() {
        return MetadataControlEvent.class.getSimpleName();
    }

    public static class Builder {
        private final MetadataControlEvent metadataControlEvent = new MetadataControlEvent();

        private Builder() {
            this.metadataControlEvent.setAddedExecutionPlanMap(new HashMap<String, String>());
            this.metadataControlEvent.setUpdatedExecutionPlanMap(new HashMap<String, String>());
            this.metadataControlEvent.setDeletedExecutionPlanId(new LinkedList<String>());
        }

        public static String nextExecutionPlanId() {
            return UUID.randomUUID().toString();
        }

        public Builder addExecutionPlan(String executionPlan) {
            this.metadataControlEvent.addedExecutionPlanMap.put(Builder.nextExecutionPlanId(), executionPlan);
            return this;
        }

        public Builder addExecutionPlan(String id, String executionPlan) {
            this.metadataControlEvent.addedExecutionPlanMap.put(id, executionPlan);
            return this;
        }

        public Builder removeExecutionPlan(String id) {
            this.metadataControlEvent.deletedExecutionPlanId.add(id);
            return this;
        }

        public Builder updateExecutionPlan(String id, String executionPlan) {
            this.metadataControlEvent.updatedExecutionPlanMap.put(id, executionPlan);
            return this;
        }

        public MetadataControlEvent build() {
            return this.metadataControlEvent;
        }
    }
}

