/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.siddhi.utils;

import io.siddhi.core.SiddhiAppRuntime;
import io.siddhi.core.SiddhiManager;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.siddhi.operator.SiddhiOperatorContext;
import org.apache.flink.streaming.siddhi.router.StreamRoute;
import org.apache.flink.streaming.siddhi.utils.GenericRecord;

public class SiddhiTypeFactory {
    private static final Map<Class<?>, Attribute.Type> JAVA_TO_SIDDHI_TYPE = new HashMap();
    private static final Map<Attribute.Type, Class<?>> SIDDHI_TO_JAVA_TYPE = new HashMap();
    private static final TypeInformation<GenericRecord> MAP_PROXY_TYPE_INFORMATION;

    public static void registerType(Class<?> javaType, Attribute.Type siddhiType) {
        if (JAVA_TO_SIDDHI_TYPE.containsKey(javaType)) {
            throw new IllegalArgumentException("Java type: " + javaType + " or siddhi type: " + siddhiType + " were already registered");
        }
        JAVA_TO_SIDDHI_TYPE.put(javaType, siddhiType);
        SIDDHI_TO_JAVA_TYPE.put(siddhiType, javaType);
    }

    public static AbstractDefinition getStreamDefinition(String executionPlan, String streamId) {
        SiddhiManager siddhiManager = null;
        SiddhiAppRuntime runtime = null;
        try {
            siddhiManager = new SiddhiManager();
            runtime = siddhiManager.createSiddhiAppRuntime(executionPlan);
            Map definitionMap = runtime.getStreamDefinitionMap();
            if (definitionMap.containsKey(streamId)) {
                AbstractDefinition abstractDefinition = (AbstractDefinition)definitionMap.get(streamId);
                return abstractDefinition;
            }
            throw new IllegalArgumentException("Unknown stream id " + streamId);
        }
        finally {
            if (runtime != null) {
                runtime.shutdown();
            }
            if (siddhiManager != null) {
                siddhiManager.shutdown();
            }
        }
    }

    public static AbstractDefinition getStreamDefinition(String executionPlan, String streamId, SiddhiOperatorContext siddhiOperatorContext) {
        SiddhiManager siddhiManager = null;
        SiddhiAppRuntime runtime = null;
        try {
            siddhiManager = new SiddhiManager();
            Map<String, Class<?>> extensions = siddhiOperatorContext.getExtensions();
            for (Map.Entry<String, Class<?>> entry : extensions.entrySet()) {
                siddhiManager.setExtension(entry.getKey(), entry.getValue());
            }
            runtime = siddhiManager.createSiddhiAppRuntime(executionPlan);
            Map definitionMap = runtime.getStreamDefinitionMap();
            if (definitionMap.containsKey(streamId)) {
                AbstractDefinition abstractDefinition = (AbstractDefinition)definitionMap.get(streamId);
                return abstractDefinition;
            }
            throw new IllegalArgumentException("Unknown stream id" + streamId);
        }
        finally {
            if (runtime != null) {
                runtime.shutdown();
            }
            if (siddhiManager != null) {
                siddhiManager.shutdown();
            }
        }
    }

    public static <T extends Tuple> TypeInformation<T> getTupleTypeInformation(AbstractDefinition definition) {
        ArrayList<TypeInformation> types = new ArrayList<TypeInformation>();
        for (Attribute attribute : definition.getAttributeList()) {
            types.add(TypeInformation.of(SiddhiTypeFactory.getJavaType(attribute.getType())));
        }
        try {
            return Types.TUPLE((TypeInformation[])types.toArray(new TypeInformation[0]));
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Unable to parse ", ex);
        }
    }

    public static <T extends Tuple> TypeInformation<T> getTupleTypeInformation(String executionPlan, String streamId) {
        return SiddhiTypeFactory.getTupleTypeInformation(SiddhiTypeFactory.getStreamDefinition(executionPlan, streamId));
    }

    public static <T extends Tuple> TypeInformation<T> getTupleTypeInformation(String executionPlan, String streamId, SiddhiOperatorContext siddhiOperatorContext) {
        return SiddhiTypeFactory.getTupleTypeInformation(SiddhiTypeFactory.getStreamDefinition(executionPlan, streamId, siddhiOperatorContext));
    }

    public static TypeInformation<GenericRecord> getMapTypeInformation() {
        return MAP_PROXY_TYPE_INFORMATION;
    }

    public static <F> Attribute.Type getAttributeType(TypeInformation<F> fieldType) {
        if (JAVA_TO_SIDDHI_TYPE.containsKey(fieldType.getTypeClass())) {
            return JAVA_TO_SIDDHI_TYPE.get(fieldType.getTypeClass());
        }
        return Attribute.Type.OBJECT;
    }

    public static Class<?> getJavaType(Attribute.Type attributeType) {
        if (!SIDDHI_TO_JAVA_TYPE.containsKey(attributeType)) {
            throw new IllegalArgumentException("Unable to get java type for siddhi attribute type: " + attributeType);
        }
        return SIDDHI_TO_JAVA_TYPE.get(attributeType);
    }

    public static <T> TypeInformation<Tuple2<StreamRoute, T>> getStreamTupleTypeInformation(TypeInformation<T> typeInformation) {
        return Types.TUPLE((TypeInformation[])new TypeInformation[]{TypeInformation.of(StreamRoute.class), typeInformation});
    }

    static {
        SiddhiTypeFactory.registerType(String.class, Attribute.Type.STRING);
        SiddhiTypeFactory.registerType(Integer.class, Attribute.Type.INT);
        SiddhiTypeFactory.registerType(Integer.TYPE, Attribute.Type.INT);
        SiddhiTypeFactory.registerType(Long.class, Attribute.Type.LONG);
        SiddhiTypeFactory.registerType(Long.TYPE, Attribute.Type.LONG);
        SiddhiTypeFactory.registerType(Float.class, Attribute.Type.FLOAT);
        SiddhiTypeFactory.registerType(Float.TYPE, Attribute.Type.FLOAT);
        SiddhiTypeFactory.registerType(Double.class, Attribute.Type.DOUBLE);
        SiddhiTypeFactory.registerType(Double.TYPE, Attribute.Type.DOUBLE);
        SiddhiTypeFactory.registerType(Boolean.class, Attribute.Type.BOOL);
        SiddhiTypeFactory.registerType(Boolean.TYPE, Attribute.Type.BOOL);
        MAP_PROXY_TYPE_INFORMATION = TypeExtractor.createTypeInfo(GenericRecord.class);
    }
}

