/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.siddhi.router;

import java.util.Random;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.siddhi.router.HashPartitioner;
import org.apache.flink.streaming.siddhi.router.StreamRoute;

public class DynamicPartitioner
extends StreamPartitioner<Tuple2<StreamRoute, Object>> {
    private final int[] returnChannels = new int[1];
    private Random random = new Random();
    private Partitioner<Long> partitioner = new HashPartitioner();

    public StreamPartitioner<Tuple2<StreamRoute, Object>> copy() {
        return new DynamicPartitioner();
    }

    public int[] selectChannels(SerializationDelegate<StreamRecord<Tuple2<StreamRoute, Object>>> streamRecordSerializationDelegate, int numberOfOutputChannels) {
        Tuple2 value = (Tuple2)((StreamRecord)streamRecordSerializationDelegate.getInstance()).getValue();
        if (((StreamRoute)value.f0).isBroadCastPartitioning()) {
            int[] channels = new int[numberOfOutputChannels];
            for (int i = 0; i < numberOfOutputChannels; ++i) {
                channels[i] = i;
            }
            return channels;
        }
        this.returnChannels[0] = ((StreamRoute)value.f0).getPartitionKey() == -1L ? this.random.nextInt(numberOfOutputChannels) : this.partitioner.partition((Object)((StreamRoute)value.f0).getPartitionKey(), numberOfOutputChannels);
        return this.returnChannels;
    }
}

