/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.siddhi.schema;

import java.io.Serializable;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.streaming.siddhi.schema.StreamSerializer;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamSchema<T>
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamSchema.class);
    private final TypeInformation<T> typeInfo;
    private final int[] fieldIndexes;
    private final String[] fieldNames;
    private TypeInformation[] fieldTypes;
    private final StreamSerializer<T> streamSerializer;
    private TypeSerializer<T> typeSerializer;

    public StreamSchema(TypeInformation<T> typeInfo, String ... fieldNames) {
        Preconditions.checkNotNull((Object)fieldNames, (String)"Field name is required");
        this.typeInfo = typeInfo;
        this.fieldNames = fieldNames;
        this.fieldIndexes = this.getFieldIndexes(typeInfo, fieldNames);
        this.fieldTypes = this.getFieldTypes(typeInfo, this.fieldIndexes, fieldNames);
        this.streamSerializer = new StreamSerializer(this);
    }

    public StreamSchema(TypeInformation<T> typeInfo, int[] fieldIndexes, String[] fieldNames) {
        this.typeInfo = typeInfo;
        this.fieldIndexes = fieldIndexes;
        this.fieldNames = fieldNames;
        this.fieldTypes = this.getFieldTypes(typeInfo, fieldIndexes, fieldNames);
        this.streamSerializer = new StreamSerializer(this);
    }

    public boolean isAtomicType() {
        return this.typeInfo instanceof AtomicType;
    }

    public boolean isTupleType() {
        return this.typeInfo instanceof TupleTypeInfo;
    }

    public boolean isRowType() {
        return this.typeInfo instanceof RowTypeInfo;
    }

    public boolean isPojoType() {
        return this.typeInfo instanceof PojoTypeInfo;
    }

    public boolean isCaseClassType() {
        return this.typeInfo instanceof CaseClassTypeInfo;
    }

    public boolean isCompositeType() {
        return this.typeInfo instanceof CompositeType;
    }

    private <E> int[] getFieldIndexes(TypeInformation<E> typeInfo, String ... fieldNames) {
        int[] result;
        if (this.isAtomicType()) {
            result = new int[]{0};
        } else if (this.isTupleType() || this.isRowType()) {
            result = new int[fieldNames.length];
            for (int i = 0; i < fieldNames.length; ++i) {
                result[i] = i;
            }
        } else if (this.isPojoType()) {
            result = new int[fieldNames.length];
            for (int i = 0; i < fieldNames.length; ++i) {
                int index = ((PojoTypeInfo)typeInfo).getFieldIndex(fieldNames[i]);
                if (index < 0) {
                    throw new IllegalArgumentException(fieldNames[i] + " is not a field of type " + typeInfo);
                }
                result[i] = index;
            }
        } else if (this.isCaseClassType()) {
            result = new int[fieldNames.length];
            for (int i = 0; i < fieldNames.length; ++i) {
                int index = ((CaseClassTypeInfo)typeInfo).getFieldIndex(fieldNames[i]);
                if (index < 0) {
                    throw new IllegalArgumentException(fieldNames[i] + " is not a field of type " + typeInfo);
                }
                result[i] = index;
            }
        } else {
            throw new IllegalArgumentException("Failed to get field index from " + typeInfo);
        }
        return result;
    }

    private <E> TypeInformation[] getFieldTypes(TypeInformation<E> typeInfo, int[] fieldIndexes, String[] fieldNames) {
        TypeInformation[] fieldTypes;
        if (this.isCompositeType()) {
            CompositeType cType = (CompositeType)typeInfo;
            if (fieldNames.length != cType.getArity()) {
                LOGGER.warn("Arity of type (" + cType.getFieldNames().length + ") not equal to number of field names " + fieldNames.length + ".");
            }
            fieldTypes = new TypeInformation[fieldIndexes.length];
            for (int i = 0; i < fieldIndexes.length; ++i) {
                fieldTypes[i] = cType.getTypeAt(fieldIndexes[i]);
            }
        } else if (this.isAtomicType()) {
            if (fieldIndexes.length != 1 || fieldIndexes[0] != 0) {
                throw new IllegalArgumentException("Non-composite input type may have only a single field and its index must be 0.");
            }
            fieldTypes = new TypeInformation[]{typeInfo};
        } else {
            throw new IllegalArgumentException("Illegal input type info");
        }
        return fieldTypes;
    }

    public TypeInformation<T> getTypeInfo() {
        return this.typeInfo;
    }

    public int[] getFieldIndexes() {
        return this.fieldIndexes;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public TypeInformation[] getFieldTypes() {
        return this.fieldTypes;
    }

    public StreamSerializer<T> getStreamSerializer() {
        return this.streamSerializer;
    }

    public TypeSerializer<T> getTypeSerializer() {
        return this.typeSerializer;
    }

    public void setTypeSerializer(TypeSerializer<T> typeSerializer) {
        this.typeSerializer = typeSerializer;
    }
}

