/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.siddhi.operator;

import java.util.Map;
import java.util.TreeMap;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.siddhi.utils.GenericRecord;
import org.apache.flink.streaming.siddhi.utils.SiddhiTupleFactory;
import org.apache.flink.types.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.output.StreamCallback;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;

public class StreamOutputHandler<R>
extends StreamCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamOutputHandler.class);
    private String outputStreamId;
    private final AbstractDefinition definition;
    private final Output<StreamRecord<R>> output;
    private final TypeInformation<R> typeInfo;
    private final ObjectMapper objectMapper;

    public StreamOutputHandler(String outputStreamId, TypeInformation<R> typeInfo, AbstractDefinition definition, Output<StreamRecord<R>> output) {
        this.outputStreamId = outputStreamId;
        this.typeInfo = typeInfo;
        this.definition = definition;
        this.output = output;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public void receive(Event[] events) {
        StreamRecord reusableRecord = new StreamRecord(null, 0L);
        for (Event event : events) {
            if (this.typeInfo == null || Map.class.isAssignableFrom(this.typeInfo.getTypeClass()) || GenericRecord.class.isAssignableFrom(this.typeInfo.getTypeClass())) {
                reusableRecord.replace((Object)Tuple2.of((Object)this.outputStreamId, (Object)new GenericRecord(this.buildMap(event))), event.getTimestamp());
                this.output.collect((Object)reusableRecord);
                continue;
            }
            if (Row.class.isAssignableFrom(this.typeInfo.getTypeClass())) {
                reusableRecord.replace((Object)Tuple2.of((Object)this.outputStreamId, (Object)this.buildRow(event)), event.getTimestamp());
                this.output.collect((Object)reusableRecord);
                continue;
            }
            if (this.typeInfo.isTupleType()) {
                Object tuple = this.toTuple(event);
                reusableRecord.replace((Object)Tuple2.of((Object)this.outputStreamId, tuple), event.getTimestamp());
                this.output.collect((Object)reusableRecord);
                continue;
            }
            if (this.typeInfo instanceof PojoTypeInfo) {
                Object obj;
                try {
                    obj = this.objectMapper.convertValue(this.buildMap(event), this.typeInfo.getTypeClass());
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.error("Failed to map event: " + event + " into type: " + this.typeInfo, (Throwable)ex);
                    throw ex;
                }
                reusableRecord.replace((Object)Tuple2.of((Object)this.outputStreamId, (Object)obj), event.getTimestamp());
                this.output.collect((Object)reusableRecord);
                continue;
            }
            throw new IllegalArgumentException("Unable to format " + event + " as type " + this.typeInfo);
        }
    }

    public synchronized void stopProcessing() {
        super.stopProcessing();
    }

    private Row buildRow(Event event) {
        return Row.of((Object[])event.getData());
    }

    private TreeMap<String, Object> buildMap(Event event) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (int i = 0; i < this.definition.getAttributeNameArray().length; ++i) {
            map.put(this.definition.getAttributeNameArray()[i], event.getData(i));
        }
        return map;
    }

    private <T extends Tuple> T toTuple(Event event) {
        return SiddhiTupleFactory.newTuple(event.getData());
    }
}

