/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.siddhi.operator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.siddhi.exception.UndefinedStreamException;
import org.apache.flink.streaming.siddhi.schema.SiddhiStreamSchema;
import org.apache.flink.streaming.siddhi.schema.StreamSchema;
import org.apache.flink.streaming.siddhi.utils.SiddhiExecutionPlanner;
import org.apache.flink.util.Preconditions;
import org.wso2.siddhi.core.SiddhiManager;

public class SiddhiOperatorContext
implements Serializable {
    private ExecutionConfig executionConfig;
    private Map<String, SiddhiStreamSchema<?>> inputStreamSchemas;
    private final Map<String, Class<?>> siddhiExtensions;
    private Map<String, TypeInformation> outputStreamTypes = new HashMap<String, TypeInformation>();
    private TimeCharacteristic timeCharacteristic;
    private String name;
    private String uuid = UUID.randomUUID().toString();
    private final Map<String, String> executionPlanMap = new ConcurrentHashMap<String, String>();

    public SiddhiOperatorContext() {
        this.inputStreamSchemas = new HashMap();
        this.siddhiExtensions = new HashMap();
    }

    public void setExtensions(Map<String, Class<?>> extensions) {
        Preconditions.checkNotNull(extensions, (String)"extensions");
        this.siddhiExtensions.putAll(extensions);
    }

    public Map<String, Class<?>> getExtensions() {
        return this.siddhiExtensions;
    }

    public String getName() {
        if (this.name == null) {
            return "CEP: Unnamed (" + this.uuid + ")";
        }
        return "CEP: " + this.name + " (" + this.uuid + ")";
    }

    public List<String> getInputStreams() {
        Object[] keys = this.inputStreamSchemas.keySet().toArray();
        ArrayList<String> result = new ArrayList<String>(keys.length);
        for (Object key : keys) {
            result.add((String)key);
        }
        return result;
    }

    public Map<String, String> getExecutionPlanMap() {
        return this.executionPlanMap;
    }

    public String getAllEnrichedExecutionPlan() {
        Preconditions.checkNotNull(this.executionPlanMap, (String)"Execution plan is not set");
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, SiddhiStreamSchema<?>> entry : this.inputStreamSchemas.entrySet()) {
            sb.append(entry.getValue().getStreamDefinitionExpression(entry.getKey()));
        }
        for (Map.Entry<String, Object> entry : this.getExecutionPlanMap().entrySet()) {
            sb.append((String)entry.getValue());
        }
        return sb.toString();
    }

    public String getEnrichedExecutionPlan(String id) {
        Preconditions.checkNotNull(this.executionPlanMap, (String)"Execution plan is not set");
        return SiddhiExecutionPlanner.of(this.inputStreamSchemas, this.getExecutionPlanMap().get(id)).getEnrichedExecutionPlan();
    }

    public TypeInformation getOutputStreamType(String outputStreamId) {
        return this.outputStreamTypes.get(outputStreamId);
    }

    public Map<String, TypeInformation> getOutputStreamTypes() {
        return this.outputStreamTypes;
    }

    public <IN> StreamSchema<IN> getInputStreamSchema(String inputStreamId) {
        Preconditions.checkNotNull((Object)inputStreamId, (String)"inputStreamId");
        if (!this.inputStreamSchemas.containsKey(inputStreamId)) {
            throw new UndefinedStreamException("Input stream: " + inputStreamId + " is not found");
        }
        return this.inputStreamSchemas.get(inputStreamId);
    }

    public void setOutputStreamType(String outputStreamId, TypeInformation outputStreamType) {
        Preconditions.checkNotNull((Object)outputStreamId, (String)"outputStreamId");
        Preconditions.checkNotNull((Object)outputStreamType, (String)"outputStreamType");
        this.outputStreamTypes.put(outputStreamId, outputStreamType);
    }

    public TimeCharacteristic getTimeCharacteristic() {
        return this.timeCharacteristic;
    }

    public void setTimeCharacteristic(TimeCharacteristic timeCharacteristic) {
        Preconditions.checkNotNull((Object)timeCharacteristic, (String)"timeCharacteristic");
        this.timeCharacteristic = timeCharacteristic;
    }

    public String addExecutionPlan(String executionPlan) {
        Preconditions.checkNotNull((Object)executionPlan, (String)"executionPlan");
        String id = UUID.randomUUID().toString();
        this.addExecutionPlan(id, executionPlan);
        return id;
    }

    public void addExecutionPlan(String id, String executionPlan) {
        this.executionPlanMap.put(id, executionPlan);
    }

    public Map<String, SiddhiStreamSchema<?>> getInputStreamSchemas() {
        return this.inputStreamSchemas;
    }

    public void setInputStreamSchemas(Map<String, SiddhiStreamSchema<?>> inputStreamSchemas) {
        Preconditions.checkNotNull(inputStreamSchemas, (String)"inputStreamSchemas");
        this.inputStreamSchemas = inputStreamSchemas;
    }

    public void setName(String name) {
        Preconditions.checkNotNull((Object)name, (String)"name");
        this.name = name;
    }

    public SiddhiManager createSiddhiManager() {
        SiddhiManager siddhiManager = new SiddhiManager();
        for (Map.Entry<String, Class<?>> entry : this.getExtensions().entrySet()) {
            siddhiManager.setExtension(entry.getKey(), entry.getValue());
        }
        return siddhiManager;
    }

    public ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    public void setExecutionConfig(ExecutionConfig executionConfig) {
        Preconditions.checkNotNull((Object)executionConfig, (String)"executionConfig");
        this.executionConfig = executionConfig;
    }

    public boolean removeExecutionPlan(String id) {
        return this.executionPlanMap.remove(id) != null;
    }

    public void updateExecutionPlan(String id, String executionPlan) {
        this.addExecutionPlan(id, executionPlan);
    }
}

