/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.siddhi.schema;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.siddhi.schema.StreamSchema;
import org.apache.flink.util.Preconditions;

public class StreamSerializer<T>
implements Serializable {
    private final StreamSchema<T> schema;

    public StreamSerializer(StreamSchema<T> schema) {
        this.schema = schema;
    }

    public Object[] getRow(T input) {
        Object[] data;
        Preconditions.checkArgument((input.getClass() == this.schema.getTypeInfo().getTypeClass() ? 1 : 0) != 0, (Object)("Invalid input type: " + input + ", expected: " + this.schema.getTypeInfo()));
        if (this.schema.isAtomicType()) {
            data = new Object[]{input};
        } else if (this.schema.isTupleType()) {
            Tuple tuple = (Tuple)input;
            data = new Object[this.schema.getFieldIndexes().length];
            for (int i = 0; i < this.schema.getFieldIndexes().length; ++i) {
                data[i] = tuple.getField(this.schema.getFieldIndexes()[i]);
            }
        } else if (this.schema.isPojoType() || this.schema.isCaseClassType()) {
            data = new Object[this.schema.getFieldIndexes().length];
            for (int i = 0; i < this.schema.getFieldNames().length; ++i) {
                data[i] = this.getFieldValue(this.schema.getFieldNames()[i], input);
            }
        } else {
            throw new IllegalArgumentException("Failed to get field values from " + this.schema.getTypeInfo());
        }
        return data;
    }

    private Object getFieldValue(String fieldName, T input) {
        Field field = TypeExtractor.getDeclaredField((Class)this.schema.getTypeInfo().getTypeClass(), (String)fieldName);
        if (field == null) {
            throw new IllegalArgumentException(fieldName + " is not found in " + this.schema.getTypeInfo());
        }
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            return field.get(input);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

