/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.siddhi.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.TypeInfoParser;
import org.wso2.siddhi.core.SiddhiAppRuntime;
import org.wso2.siddhi.core.SiddhiManager;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;

public class SiddhiTypeFactory {
    private static final Map<Class<?>, Attribute.Type> JAVA_TO_SIDDHI_TYPE = new HashMap();
    private static final Map<Attribute.Type, Class<?>> SIDDHI_TO_JAVA_TYPE = new HashMap();
    private static final TypeInformation<?> MAP_TYPE_INFORMATION;

    public static void registerType(Class<?> javaType, Attribute.Type siddhiType) {
        if (JAVA_TO_SIDDHI_TYPE.containsKey(javaType)) {
            throw new IllegalArgumentException("Java type: " + javaType + " or siddhi type: " + siddhiType + " were already registered");
        }
        JAVA_TO_SIDDHI_TYPE.put(javaType, siddhiType);
        SIDDHI_TO_JAVA_TYPE.put(siddhiType, javaType);
    }

    public static AbstractDefinition getStreamDefinition(String executionPlan, String streamId) {
        SiddhiManager siddhiManager = null;
        SiddhiAppRuntime runtime = null;
        try {
            siddhiManager = new SiddhiManager();
            runtime = siddhiManager.createSiddhiAppRuntime(executionPlan);
            Map definitionMap = runtime.getStreamDefinitionMap();
            if (definitionMap.containsKey(streamId)) {
                AbstractDefinition abstractDefinition = (AbstractDefinition)definitionMap.get(streamId);
                return abstractDefinition;
            }
            throw new IllegalArgumentException("Unknown stream id" + streamId);
        }
        finally {
            if (runtime != null) {
                runtime.shutdown();
            }
            if (siddhiManager != null) {
                siddhiManager.shutdown();
            }
        }
    }

    public static <T extends Tuple> TypeInformation<T> getTupleTypeInformation(AbstractDefinition definition) {
        int tupleSize = definition.getAttributeList().size();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tuple").append(tupleSize);
        stringBuilder.append("<");
        ArrayList<String> attributeTypes = new ArrayList<String>();
        for (Attribute attribute : definition.getAttributeList()) {
            attributeTypes.add(SiddhiTypeFactory.getJavaType(attribute.getType()).getName());
        }
        stringBuilder.append(StringUtils.join(attributeTypes, (String)","));
        stringBuilder.append(">");
        try {
            return TypeInfoParser.parse((String)stringBuilder.toString());
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Unable to parse " + stringBuilder.toString(), ex);
        }
    }

    public static <T extends Tuple> TypeInformation<T> getTupleTypeInformation(String executionPlan, String streamId) {
        return SiddhiTypeFactory.getTupleTypeInformation(SiddhiTypeFactory.getStreamDefinition(executionPlan, streamId));
    }

    public static TypeInformation<Map<String, Object>> getMapTypeInformation() {
        return MAP_TYPE_INFORMATION;
    }

    public static <F> Attribute.Type getAttributeType(TypeInformation<F> fieldType) {
        if (JAVA_TO_SIDDHI_TYPE.containsKey(fieldType.getTypeClass())) {
            return JAVA_TO_SIDDHI_TYPE.get(fieldType.getTypeClass());
        }
        return Attribute.Type.OBJECT;
    }

    public static Class<?> getJavaType(Attribute.Type attributeType) {
        if (!SIDDHI_TO_JAVA_TYPE.containsKey(attributeType)) {
            throw new IllegalArgumentException("Unable to get java type for siddhi attribute type: " + attributeType);
        }
        return SIDDHI_TO_JAVA_TYPE.get(attributeType);
    }

    public static <T> TypeInformation<Tuple2<String, T>> getStreamTupleTypeInformation(TypeInformation<T> typeInformation) {
        return TypeInfoParser.parse((String)("Tuple2<String," + typeInformation.getTypeClass().getName() + ">"));
    }

    static {
        SiddhiTypeFactory.registerType(String.class, Attribute.Type.STRING);
        SiddhiTypeFactory.registerType(Integer.class, Attribute.Type.INT);
        SiddhiTypeFactory.registerType(Integer.TYPE, Attribute.Type.INT);
        SiddhiTypeFactory.registerType(Long.class, Attribute.Type.LONG);
        SiddhiTypeFactory.registerType(Long.TYPE, Attribute.Type.LONG);
        SiddhiTypeFactory.registerType(Float.class, Attribute.Type.FLOAT);
        SiddhiTypeFactory.registerType(Float.TYPE, Attribute.Type.FLOAT);
        SiddhiTypeFactory.registerType(Double.class, Attribute.Type.DOUBLE);
        SiddhiTypeFactory.registerType(Double.TYPE, Attribute.Type.DOUBLE);
        SiddhiTypeFactory.registerType(Boolean.class, Attribute.Type.BOOL);
        SiddhiTypeFactory.registerType(Boolean.TYPE, Attribute.Type.BOOL);
        MAP_TYPE_INFORMATION = TypeExtractor.createTypeInfo(new HashMap().getClass());
    }
}

