/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.siddhi.schema;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.siddhi.schema.StreamSchema;
import org.apache.flink.streaming.siddhi.utils.SiddhiTypeFactory;
import org.apache.flink.util.Preconditions;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.StreamDefinition;

public class SiddhiStreamSchema<T>
extends StreamSchema<T> {
    private static final String DEFINE_STREAM_TEMPLATE = "define stream %s (%s);";

    public SiddhiStreamSchema(TypeInformation<T> typeInfo, String ... fieldNames) {
        super(typeInfo, fieldNames);
    }

    public SiddhiStreamSchema(TypeInformation<T> typeInfo, int[] fieldIndexes, String[] fieldNames) {
        super(typeInfo, fieldIndexes, fieldNames);
    }

    public StreamDefinition getStreamDefinition(String streamId) {
        StreamDefinition streamDefinition = StreamDefinition.id((String)streamId);
        for (int i = 0; i < this.getFieldNames().length; ++i) {
            streamDefinition.attribute(this.getFieldNames()[i], SiddhiTypeFactory.getAttributeType(this.getFieldTypes()[i]));
        }
        return streamDefinition;
    }

    public String getStreamDefinitionExpression(StreamDefinition streamDefinition) {
        ArrayList<String> columns = new ArrayList<String>();
        Preconditions.checkNotNull((Object)streamDefinition, (String)"StreamDefinition is null");
        for (Attribute attribute : streamDefinition.getAttributeList()) {
            columns.add(String.format("%s %s", attribute.getName(), attribute.getType().toString().toLowerCase()));
        }
        return String.format(DEFINE_STREAM_TEMPLATE, streamDefinition.getId(), StringUtils.join(columns, (String)","));
    }

    public String getStreamDefinitionExpression(String streamId) {
        StreamDefinition streamDefinition = this.getStreamDefinition(streamId);
        ArrayList<String> columns = new ArrayList<String>();
        Preconditions.checkNotNull((Object)streamDefinition, (String)"StreamDefinition is null");
        for (Attribute attribute : streamDefinition.getAttributeList()) {
            columns.add(String.format("%s %s", attribute.getName(), attribute.getType().toString().toLowerCase()));
        }
        return String.format(DEFINE_STREAM_TEMPLATE, streamDefinition.getId(), StringUtils.join(columns, (String)","));
    }
}

