/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.siddhi.operator;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.contrib.siddhi.utils.SiddhiTupleFactory;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.output.StreamCallback;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;

public class StreamInMemOutputHandler<R>
extends StreamCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamInMemOutputHandler.class);
    private final AbstractDefinition definition;
    private final TypeInformation<R> typeInfo;
    private final ObjectMapper objectMapper;
    private final LinkedList<StreamRecord<R>> collectedRecords;

    public StreamInMemOutputHandler(TypeInformation<R> typeInfo, AbstractDefinition definition) {
        this.typeInfo = typeInfo;
        this.definition = definition;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.collectedRecords = new LinkedList();
    }

    public void receive(Event[] events) {
        for (Event event : events) {
            if (this.typeInfo == null || Map.class.isAssignableFrom(this.typeInfo.getTypeClass())) {
                this.collectedRecords.add(new StreamRecord(this.toMap(event), event.getTimestamp()));
                continue;
            }
            if (this.typeInfo.isTupleType()) {
                Object tuple = this.toTuple(event);
                this.collectedRecords.add(new StreamRecord(tuple, event.getTimestamp()));
                continue;
            }
            if (this.typeInfo instanceof PojoTypeInfo) {
                Object obj;
                try {
                    obj = this.objectMapper.convertValue(this.toMap(event), this.typeInfo.getTypeClass());
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.error("Failed to map event: " + event + " into type: " + this.typeInfo, (Throwable)ex);
                    throw ex;
                }
                this.collectedRecords.add(new StreamRecord(obj, event.getTimestamp()));
                continue;
            }
            throw new IllegalArgumentException("Unable to format " + event + " as type " + this.typeInfo);
        }
    }

    public synchronized void stopProcessing() {
        super.stopProcessing();
        this.collectedRecords.clear();
    }

    private Map<String, Object> toMap(Event event) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (int i = 0; i < this.definition.getAttributeNameArray().length; ++i) {
            map.put(this.definition.getAttributeNameArray()[i], event.getData(i));
        }
        return map;
    }

    private <T extends Tuple> T toTuple(Event event) {
        return SiddhiTupleFactory.newTuple(event.getData());
    }

    public LinkedList<StreamRecord<R>> getCollectedRecords() {
        return this.collectedRecords;
    }
}

