/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.siddhi.operator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.contrib.siddhi.schema.SiddhiStreamSchema;
import org.apache.flink.contrib.siddhi.schema.StreamSchema;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.util.Preconditions;
import org.wso2.siddhi.core.SiddhiManager;

public class SiddhiOperatorContext
implements Serializable {
    private ExecutionConfig executionConfig;
    private Map<String, SiddhiStreamSchema<?>> inputStreamSchemas = new HashMap();
    private final Map<String, Class<?>> siddhiExtensions = new HashMap();
    private String outputStreamId;
    private TypeInformation outputStreamType;
    private TimeCharacteristic timeCharacteristic;
    private String name;
    private String executionPlan;

    public void setExtensions(Map<String, Class<?>> extensions) {
        Preconditions.checkNotNull(extensions);
        this.siddhiExtensions.putAll(extensions);
    }

    public Map<String, Class<?>> getExtensions() {
        return this.siddhiExtensions;
    }

    public String getName() {
        if (this.name == null) {
            if (this.executionPlan.length() > 100) {
                return String.format("Siddhi: %s ... (%s)", this.executionPlan.substring(0, 100), this.executionPlan.length() - 100);
            }
            return String.format("Siddhi: %s", this.executionPlan);
        }
        return this.name;
    }

    public List<String> getInputStreams() {
        Object[] keys = this.inputStreamSchemas.keySet().toArray();
        ArrayList<String> result = new ArrayList<String>(keys.length);
        for (Object key : keys) {
            result.add((String)key);
        }
        return result;
    }

    public String getExecutionPlan() {
        return this.executionPlan;
    }

    public String getFinalExecutionPlan() {
        Preconditions.checkNotNull((Object)this.executionPlan, (String)"Execution plan is not set");
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, SiddhiStreamSchema<?>> entry : this.inputStreamSchemas.entrySet()) {
            sb.append(entry.getValue().getStreamDefinitionExpression(entry.getKey()));
        }
        sb.append(this.getExecutionPlan());
        return sb.toString();
    }

    public TypeInformation getOutputStreamType() {
        return this.outputStreamType;
    }

    public String getOutputStreamId() {
        return this.outputStreamId;
    }

    public <IN> StreamSchema<IN> getInputStreamSchema(String inputStreamId) {
        if (!this.inputStreamSchemas.containsKey(inputStreamId)) {
            throw new IllegalArgumentException("Input stream: " + inputStreamId + " is not found");
        }
        return this.inputStreamSchemas.get(inputStreamId);
    }

    public void setOutputStreamId(String outputStreamId) {
        this.outputStreamId = outputStreamId;
    }

    public void setOutputStreamType(TypeInformation outputStreamType) {
        this.outputStreamType = outputStreamType;
    }

    public TimeCharacteristic getTimeCharacteristic() {
        return this.timeCharacteristic;
    }

    public void setTimeCharacteristic(TimeCharacteristic timeCharacteristic) {
        this.timeCharacteristic = timeCharacteristic;
    }

    public void setExecutionPlan(String executionPlan) {
        this.executionPlan = executionPlan;
    }

    public Map<String, SiddhiStreamSchema<?>> getInputStreamSchemas() {
        return this.inputStreamSchemas;
    }

    public void setInputStreamSchemas(Map<String, SiddhiStreamSchema<?>> inputStreamSchemas) {
        this.inputStreamSchemas = inputStreamSchemas;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SiddhiManager createSiddhiManager() {
        SiddhiManager siddhiManager = new SiddhiManager();
        for (Map.Entry<String, Class<?>> entry : this.getExtensions().entrySet()) {
            siddhiManager.setExtension(entry.getKey(), entry.getValue());
        }
        return siddhiManager;
    }

    public ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    public void setExecutionConfig(ExecutionConfig executionConfig) {
        this.executionConfig = executionConfig;
    }
}

