/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.siddhi;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.contrib.siddhi.SiddhiStream;
import org.apache.flink.contrib.siddhi.exception.DuplicatedStreamException;
import org.apache.flink.contrib.siddhi.exception.UndefinedStreamException;
import org.apache.flink.contrib.siddhi.schema.SiddhiStreamSchema;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;

@PublicEvolving
public class SiddhiCEP {
    private final StreamExecutionEnvironment executionEnvironment;
    private final Map<String, DataStream<?>> dataStreams = new HashMap();
    private final Map<String, SiddhiStreamSchema<?>> dataStreamSchemas = new HashMap();
    private final Map<String, Class<?>> extensions = new HashMap();

    public Map<String, DataStream<?>> getDataStreams() {
        return this.dataStreams;
    }

    public Map<String, SiddhiStreamSchema<?>> getDataStreamSchemas() {
        return this.dataStreamSchemas;
    }

    public boolean isStreamDefined(String streamId) {
        return this.dataStreams.containsKey(streamId);
    }

    public Map<String, Class<?>> getExtensions() {
        return this.extensions;
    }

    public void checkStreamDefined(String streamId) throws UndefinedStreamException {
        if (!this.isStreamDefined(streamId)) {
            throw new UndefinedStreamException("Stream (streamId: " + streamId + ") not defined");
        }
    }

    public SiddhiCEP(StreamExecutionEnvironment streamExecutionEnvironment) {
        this.executionEnvironment = streamExecutionEnvironment;
    }

    public static <T> SiddhiStream.SingleSiddhiStream<T> define(String streamId, DataStream<T> inStream, String ... fieldNames) {
        SiddhiCEP environment = SiddhiCEP.getSiddhiEnvironment(inStream.getExecutionEnvironment());
        return environment.from(streamId, inStream, fieldNames);
    }

    public <T> SiddhiStream.SingleSiddhiStream<T> from(String streamId, DataStream<T> inStream, String ... fieldNames) {
        this.registerStream(streamId, inStream, fieldNames);
        return new SiddhiStream.SingleSiddhiStream(streamId, this);
    }

    public <T> SiddhiStream.SingleSiddhiStream<T> from(String streamId) {
        return new SiddhiStream.SingleSiddhiStream(streamId, this);
    }

    public <T> SiddhiStream.UnionSiddhiStream<T> union(String firstStreamId, String ... unionStreamIds) {
        return new SiddhiStream.SingleSiddhiStream(firstStreamId, this).union(unionStreamIds);
    }

    public <T> void registerStream(String streamId, DataStream<T> dataStream, String ... fieldNames) {
        if (this.isStreamDefined(streamId)) {
            throw new DuplicatedStreamException("Input stream: " + streamId + " already exists");
        }
        this.dataStreams.put(streamId, dataStream);
        SiddhiStreamSchema schema = new SiddhiStreamSchema(dataStream.getType(), fieldNames);
        schema.setTypeSerializer(schema.getTypeInfo().createSerializer(dataStream.getExecutionConfig()));
        this.dataStreamSchemas.put(streamId, schema);
    }

    public StreamExecutionEnvironment getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public void registerExtension(String extensionName, Class<?> extensionClass) {
        if (this.extensions.containsKey(extensionName)) {
            throw new IllegalArgumentException("Extension named " + extensionName + " already registered");
        }
        this.extensions.put(extensionName, extensionClass);
    }

    public <T> DataStream<T> getDataStream(String streamId) {
        if (this.dataStreams.containsKey(streamId)) {
            return this.dataStreams.get(streamId);
        }
        throw new UndefinedStreamException("Undefined stream " + streamId);
    }

    public static SiddhiCEP getSiddhiEnvironment(StreamExecutionEnvironment streamExecutionEnvironment) {
        return new SiddhiCEP(streamExecutionEnvironment);
    }
}

