;; This file is autogenerated using vura.holidays.compile/-main

(ns vura.holiday.tr
  (:require
   [clojure.string]
   [vura.holiday :refer [is-holiday?]]
   [vura.holiday.util :refer [parse-definition
                              get-name]]
   [vura.holiday.compiler :as compiler]))

(def holidays
  {"10 Dhu al-Hijjah PT114H"
   {:name (partial get-name "10 Dhu al-Hijjah")},
   "07-15"
   {:name
    {:en "Democracy and National Unity Day",
     :tr "Demokrasi ve Millî Birlik Günü"}},
   "01-01" {:name (partial get-name "01-01")},
   "10-29" {:name {:en "Republic Day", :tr "Cumhuriyet Bayramı"}},
   "1 Shawwal PT90H" {:name (partial get-name "1 Shawwal")},
   "08-30" {:name {:en "Victory Day", :tr "Zafer Bayramı"}},
   "04-23"
   {:name
    {:en "National Sovereignty and Children's Day",
     :tr "Ulusal Egemenlik ve Çocuk Bayramı"}},
   "05-01"
   {"_name" "05-01",
    :name
    {:en "Labour and Solidarity Day", :tr "Emek ve Dayanışma Günü"}},
   "05-19"
   {:name
    {:en "Commemoration of Atatürk, Youth and Sports Day",
     :tr "Atatürk'ü Anma Gençlik ve Spor Bayramı"}}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :tr
  [_ context]
  (holiday? context))
