;; This file is autogenerated using vura.holidays.compile/-main

(ns vura.holiday.tc
  (:require
   [clojure.string]
   [vura.holiday :refer [is-holiday?]]
   [vura.holiday.util :refer [parse-definition
                              get-name]]
   [vura.holiday.compiler :as compiler]))

(def holidays
  {"1st Monday before 06-01" {:name {:en "National Heroes' Day"}},
   "12-26 and if Saturday then next Monday if Sunday then next Tuesday"
   {"substitute" true, :name (partial get-name "12-26")},
   "1st Friday before 10-01" {:name {:en "National Youth Day"}},
   "2nd Monday in October" {:name {:en "National Heritage Day"}},
   "2nd Monday after 06-02" {:name {:en "Queen's Birthday"}},
   "01-01 and if Saturday, Sunday then next Monday"
   {:name (partial get-name "01-01")},
   "easter" {"type" "observance", :name (partial get-name "easter")},
   "easter -2" {:name (partial get-name "easter -2")},
   "easter 1" {:name (partial get-name "easter 1")},
   "2nd Monday in March" {:name {:en "Commonwealth Day"}},
   "1st Monday in August" {:name {:en "Emancipation Day"}},
   "12-25 and if Saturday then next Monday if Sunday then next Tuesday"
   {"substitute" true, :name (partial get-name "12-25")},
   "4th Friday in November" {:name {:en "National Day of Thanksgiving"}}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :tc
  [_ context]
  (holiday? context))
