;; This file is autogenerated using vura.holidays.compile/-main

(ns vura.holiday.st
  (:require
   [clojure.string]
   [vura.holiday :refer [is-holiday?]]
   [vura.holiday.util :refer [parse-definition
                              get-name]]
   [vura.holiday.compiler :as compiler]))

(def holidays
  {"01-01 and if Saturday then previous Friday if Sunday then next Monday"
   {"substitute" true, :name (partial get-name "01-01")},
   "02-03 and if Saturday then previous Friday if Sunday then next Monday"
   {"substitute" true,
    :name {:en "Martyrs' Day", :pt "Dia dos Mártires"}},
   "05-01 and if Saturday then previous Friday if Sunday then next Monday"
   {"substitute" true, :name (partial get-name "05-01")},
   "07-12 and if Saturday then previous Friday if Sunday then next Monday"
   {"substitute" true, :name (partial get-name "Independence Day")},
   "09-06 and if Saturday then previous Friday if Sunday then next Monday"
   {"substitute" true,
    :name {:en "Armed Forces Day", :pt "Dia das Forças Armadas"}},
   "09-30 and if Saturday then previous Friday if Sunday then next Monday"
   {"substitute" true,
    :name {:en "Agricultural Reform Day", :pt "Dia da Reforma Agrária"}},
   "12-21 and if Saturday then previous Friday if Sunday then next Monday"
   {"substitute" true,
    :name {:en "São Tomé Day", :pt "Dia de São Tomé"}},
   "12-25 and if Saturday then previous Friday if Sunday then next Monday"
   {"substitute" true, :name (partial get-name "12-25")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :st
  [_ context]
  (holiday? context))
