;; This file is autogenerated using vura.holidays.compile/-main

(ns vura.holiday.sr
  (:require
   [clojure.string]
   [vura.holiday :refer [is-holiday?]]
   [vura.holiday.util :refer [parse-definition
                              get-name]]
   [vura.holiday.compiler :as compiler]))

(def holidays
  {"2030-10-25" {:name (partial get-name "Deepavali")},
   "2016-03-23" {:name (partial get-name "Holi")},
   "10 Dhu al-Hijjah" {:name (partial get-name "10 Dhu al-Hijjah")},
   "08-09"
   {:name {:nl "Dag der Inheemsen", :en "Indigenous People's Day"}},
   "2029-03-28" {:name (partial get-name "Holi")},
   "07-01"
   {:name
    {:nl "Dag der Vrijheden (Keti koti)",
     :srn "Keti koti",
     :en "Emancipation Day"}},
   "2028-10-17" {:name (partial get-name "Deepavali")},
   "01-01" {:name (partial get-name "01-01")},
   "2023-11-12" {:name (partial get-name "Deepavali")},
   "2016-10-30" {:name (partial get-name "Deepavali")},
   "2020-03-09" {:name (partial get-name "Holi")},
   "2030-03-19" {:name (partial get-name "Holi")},
   "2017-03-12" {:name (partial get-name "Holi")},
   "2025-03-14" {:name (partial get-name "Holi")},
   "2024-10-31" {:name (partial get-name "Deepavali")},
   "2015-11-11" {:name (partial get-name "Deepavali")},
   "2022-10-24" {:name (partial get-name "Deepavali")},
   "2021-03-28" {:name (partial get-name "Holi")},
   "02-25"
   {:name
    {:nl "Dag van Bevrijding en Vernieuwing",
     :en "Day of Liberation and Innovation"}},
   "10-10" {:name {:nl "Dag van de Marrons", :en "Day of the Maroons"}},
   "2027-10-28" {:name (partial get-name "Deepavali")},
   "2017-10-19" {:name (partial get-name "Deepavali")},
   "easter" {"type" "observance", :name (partial get-name "easter")},
   "chinese 01-0-01"
   {:name {:nl "Chinees Nieuwjaar", :en "Chinese New Year"}},
   "2029-11-05" {:name (partial get-name "Deepavali")},
   "2024-03-25" {:name (partial get-name "Holi")},
   "2019-03-21" {:name (partial get-name "Holi")},
   "2022-03-18" {:name (partial get-name "Holi")},
   "2027-03-22" {:name (partial get-name "Holi")},
   "easter -2" {:name (partial get-name "easter -2")},
   "1 Shawwal" {:name (partial get-name "1 Shawwal")},
   "2019-10-27" {:name (partial get-name "Deepavali")},
   "2015-03-06" {:name (partial get-name "Holi")},
   "2018-03-02" {:name (partial get-name "Holi")},
   "2020-11-14" {:name (partial get-name "Deepavali")},
   "11-25" {:name (partial get-name "Independence Day")},
   "2028-03-11" {:name (partial get-name "Holi")},
   "12-26" {:name (partial get-name "12-26")},
   "easter 1" {:name (partial get-name "easter 1")},
   "05-01" {:name (partial get-name "05-01")},
   "2018-11-07" {:name (partial get-name "Deepavali")},
   "2025-10-20" {:name (partial get-name "Deepavali")},
   "2014-10-23" {:name (partial get-name "Deepavali")},
   "2021-11-04" {:name (partial get-name "Deepavali")},
   "2023-03-07" {:name (partial get-name "Holi")},
   "2026-03-03" {:name (partial get-name "Holi")},
   "2026-11-08" {:name (partial get-name "Deepavali")},
   "12-25" {:name (partial get-name "12-25")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :sr
  [_ context]
  (holiday? context))
