;; This file is autogenerated using vura.holidays.compile/-main

(ns vura.holiday.sg
  (:require
   [clojure.string]
   [vura.holiday :refer [is-holiday?]]
   [vura.holiday.util :refer [parse-definition
                              get-name]]
   [vura.holiday.compiler :as compiler]))

(def holidays
  {"2030-10-25" {:name (partial get-name "Deepavali")},
   "2008-05-19" {:name (partial get-name "Vesak")},
   "2012-05-05" {:name (partial get-name "Vesak")},
   "10 Dhu al-Hijjah"
   {"_name" "10 Dhu al-Hijjah",
    "disable" ["2022-07-09" "2023-06-28" "2024-06-29" "2025-06-06"],
    "enable" ["2022-07-10" "2023-06-29" "2024-06-17" "2025-06-07"],
    :name {:en "Hari Raya Haji"}},
   "2020-05-07" {:name (partial get-name "Vesak")},
   "2005-05-23" {:name (partial get-name "Vesak")},
   "08-09" {:name {:en "National Day"}},
   "2010-11-05" {:name (partial get-name "Deepavali")},
   "2017-10-18" {:name (partial get-name "Deepavali")},
   "2007-05-31" {:name (partial get-name "Vesak")},
   "2001-05-07" {:name (partial get-name "Vesak")},
   "2012-11-13" {:name (partial get-name "Deepavali")},
   "01-01" {:name (partial get-name "01-01")},
   "2006-10-21" {:name (partial get-name "Deepavali")},
   "2003-05-15" {:name (partial get-name "Vesak")},
   "2007-11-08" {:name (partial get-name "Deepavali")},
   "2001-11-14" {:name (partial get-name "Deepavali")},
   "2024-10-31" {:name (partial get-name "Deepavali")},
   "2002-11-04"
   {"substitute" true, :name (partial get-name "Deepavali")},
   "2014-05-13" {:name (partial get-name "Vesak")},
   "2022-10-24" {:name (partial get-name "Deepavali")},
   "2013-11-04"
   {"substitute" true, :name (partial get-name "Deepavali")},
   "2018-11-06" {:name (partial get-name "Deepavali")},
   "substitutes 05-01 if sunday then next monday"
   {"substitute" true, :name (partial get-name "05-01")},
   "2015-11-10" {:name (partial get-name "Deepavali")},
   "2002-11-03" {:name (partial get-name "Deepavali")},
   "2028-11-15" {:name (partial get-name "Deepavali")},
   "2027-10-28" {:name (partial get-name "Deepavali")},
   "substitutes chinese 01-0-01 if sunday then next tuesday"
   {"substitute" true, :name {:en "Chinese New Year"}},
   "2025-05-12" {:name (partial get-name "Vesak")},
   "2015-06-01" {:name (partial get-name "Vesak")},
   "2026-11-09" {:name (partial get-name "Deepavali")},
   "substitutes 01-01 if sunday then next monday"
   {"substitute" true, :name (partial get-name "01-01")},
   "chinese 01-0-01" {:name {:en "Chinese New Year"}},
   "2013-05-24" {:name (partial get-name "Vesak")},
   "substitutes 08-09 if sunday then next monday"
   {"substitute" true, :name {:en "National Day"}},
   "2018-05-29" {:name (partial get-name "Vesak")},
   "2019-05-20" {"substitute" true, :name (partial get-name "Vesak")},
   "2029-11-05" {:name (partial get-name "Deepavali")},
   "substitutes chinese 01-0-02 if sunday then next monday"
   {"substitute" true, :name {:en "Chinese New Year"}},
   "2005-11-01" {:name (partial get-name "Deepavali")},
   "2023-06-02" {:name (partial get-name "Vesak")},
   "easter -2" {:name (partial get-name "easter -2")},
   "1 Shawwal"
   {"_name" "1 Shawwal",
    "disable" ["2022-05-02" "2023-04-21" "2024-04-09" "2025-03-30"],
    "enable" ["2022-05-03" "2023-04-22" "2024-04-10" "2025-03-31"],
    :name {:en "Hari Raya Puasa"}},
   "2019-10-27" {:name (partial get-name "Deepavali")},
   "2022-05-16" {"substitute" true, :name (partial get-name "Vesak")},
   "2016-05-21" {:name (partial get-name "Vesak")},
   "2009-05-09" {:name (partial get-name "Vesak")},
   "2017-05-10" {:name (partial get-name "Vesak")},
   "2008-10-27" {:name (partial get-name "Deepavali")},
   "2022-05-15" {:name (partial get-name "Vesak")},
   "2020-11-14" {:name (partial get-name "Deepavali")},
   "2002-05-27" {:name (partial get-name "Vesak")},
   "2011-05-17" {:name (partial get-name "Vesak")},
   "chinese 01-0-02" {:name {:en "Chinese New Year"}},
   "2013-11-03" {:name (partial get-name "Deepavali")},
   "2000-10-26" {:name (partial get-name "Deepavali")},
   "2019-10-28"
   {"substitute" true, :name (partial get-name "Deepavali")},
   "2004-11-11" {:name (partial get-name "Deepavali")},
   "2014-10-22" {:name (partial get-name "Deepavali")},
   "05-01" {:name (partial get-name "05-01")},
   "2021-05-26" {:name (partial get-name "Vesak")},
   "2025-10-20" {:name (partial get-name "Deepavali")},
   "2016-10-29" {:name (partial get-name "Deepavali")},
   "2023-11-13" {:name (partial get-name "Deepavali")},
   "2010-05-28" {:name (partial get-name "Vesak")},
   "2004-06-02" {:name (partial get-name "Vesak")},
   "2019-05-19" {:name (partial get-name "Vesak")},
   "substitutes 12-25 if sunday then next monday"
   {"substitute" true, :name (partial get-name "12-25")},
   "2003-10-23" {:name (partial get-name "Deepavali")},
   "2023-09-1"
   {"type" "public", :name {:en "Presidential Election Day"}},
   "2021-11-04" {:name (partial get-name "Deepavali")},
   "2009-10-17" {:name (partial get-name "Deepavali")},
   "2011-10-26" {:name (partial get-name "Deepavali")},
   "12-25" {:name (partial get-name "12-25")},
   "2024-05-22" {:name (partial get-name "Vesak")},
   "2006-05-12" {:name (partial get-name "Vesak")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :sg
  [_ context]
  (holiday? context))
