;; This file is autogenerated using vura.holidays.compile/-main

(ns vura.holiday.sd
  (:require
   [clojure.string]
   [vura.holiday :refer [is-holiday?]]
   [vura.holiday.util :refer [parse-definition
                              get-name]]
   [vura.holiday.compiler :as compiler]))

(def holidays
  {"01-01" {:name (partial get-name "Independence Day")},
   "12-19" {:name (partial get-name "Revolution Day")},
   "1 Muharram" {:name (partial get-name "1 Muharram")},
   "10 Dhu al-Hijjah P3D" {:name (partial get-name "10 Dhu al-Hijjah")},
   "julian 12-25"
   {"_name" "julian 12-25", :name {:en "Coptic Christmas"}},
   "orthodox" {"_name" "orthodox", :name {:en "Coptic Easter"}},
   "1 Shawwal P4D" {:name (partial get-name "1 Shawwal")},
   "12 Rabi al-awwal" {:name (partial get-name "12 Rabi al-awwal")},
   "12-25" {:name (partial get-name "12-25")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :sd
  [_ context]
  (holiday? context))
