;; This file is autogenerated using vura.holidays.compile/-main

(ns vura.holiday.sa
  (:require
   [clojure.string]
   [vura.holiday :refer [is-holiday?]]
   [vura.holiday.util :refer [parse-definition
                              get-name]]
   [vura.holiday.compiler :as compiler]))

(def holidays
  {"02-22 since 2022" {:name {:ar "يوم التأسيس", :en "Founding Day"}},
   "09-23 since 2005" {:name {:ar "اليوم الوطني", :en "National Day"}},
   "29 Ramadan P4D" {:name (partial get-name "1 Shawwal")},
   "9 Dhu al-Hijjah P4D" {:name (partial get-name "10 Dhu al-Hijjah")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :sa
  [_ context]
  (holiday? context))
