;; This file is autogenerated using vura.holidays.compile/-main

(ns vura.holiday.pe
  (:require
   [clojure.string]
   [vura.holiday :refer [is-holiday?]]
   [vura.holiday.util :refer [parse-definition
                              get-name]]
   [vura.holiday.compiler :as compiler]))

(def holidays
  {"12-08" {:name (partial get-name "12-08")},
   "01-01" {:name (partial get-name "01-01")},
   "06-29" {:name (partial get-name "06-29")},
   "11-01" {:name (partial get-name "11-01")},
   "10-08" {:name {:en "Battle of Angamos", :es "Combate de Angamos"}},
   "easter" {:name (partial get-name "easter")},
   "easter -2" {:name (partial get-name "easter -2")},
   "08-30"
   {:name {:en "Santa Rosa de Lima", :es "Día de Santa Rosa de Lima"}},
   "07-29" {:name (partial get-name "Independence Day")},
   "05-01" {:name (partial get-name "05-01")},
   "easter -3" {:name (partial get-name "easter -3")},
   "07-28" {:name (partial get-name "Independence Day")},
   "12-25" {:name (partial get-name "12-25")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :pe
  [_ context]
  (holiday? context))
