;; This file is autogenerated using vura.holidays.compile/-main

(ns vura.holiday.mq
  (:require
   [clojure.string]
   [vura.holiday :refer [is-holiday?]]
   [vura.holiday.util :refer [parse-definition
                              get-name]]
   [vura.holiday.compiler :as compiler]))

(def holidays
  {"easter -2" {:name (partial get-name "easter -2")},
   "05-22" {:name (partial get-name "Abolition of Slavery")},
   "07-21"
   {:name {:fr "Jour de Victor Schoelcher", :en "Victor Shoelcher Day"}}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :mq
  [_ context]
  (holiday? context))
