;; This file is autogenerated using vura.holidays.compile/-main

(ns vura.holiday.md
  (:require
   [clojure.string]
   [vura.holiday :refer [is-holiday?]]
   [vura.holiday.util :refer [parse-definition
                              get-name]]
   [vura.holiday.compiler :as compiler]))

(def holidays
  {"01-01" {:name (partial get-name "01-01")},
   "05-09" {:name {:ro "Ziua Victoriei", :en "Victory Day"}},
   "orthodox 8" {:name {:ro "Paştele Blăjinilor", :en "Memorial Day"}},
   "08-27" {:name (partial get-name "Independence Day")},
   "08-31" {:name {:ro "Limba noastră", :en "National Language Day"}},
   "03-08" {:name (partial get-name "03-08")},
   "05-01" {:name (partial get-name "05-01")},
   "1st saturday in October P2D"
   {"type" "observance",
    "active" [{"from" 2013}],
    :name {:ro "Ziua vinului", :en "Wine Day"}},
   "orthodox" {:name (partial get-name "easter")},
   "julian 12-25 P2D"
   {"_name" "julian 12-25", :name {:ro "Craciun pe Rit Vechi"}},
   "orthodox 1" {:name (partial get-name "easter 1")},
   "12-25" {"_name" "12-25", :name {:ro "Craciun pe stil Nou"}}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :md
  [_ context]
  (holiday? context))
