;; This file is autogenerated using vura.holidays.compile/-main

(ns vura.holiday.ly
  (:require
   [clojure.string]
   [vura.holiday :refer [is-holiday?]]
   [vura.holiday.util :refer [parse-definition
                              get-name]]
   [vura.holiday.compiler :as compiler]))

(def holidays
  {"10-23" {:name (partial get-name "Liberation Day")},
   "09-16" {:name {:ar "يوم الشهداء", :en "Martyrs' Day"}},
   "12-24" {:name (partial get-name "Independence Day")},
   "02-17" {:name (partial get-name "Revolution Day")},
   "1 Muharram" {:name (partial get-name "1 Muharram")},
   "1 Shawwal P3D" {:name (partial get-name "1 Shawwal")},
   "9 Dhu al-Hijjah" {:name (partial get-name "9 Dhu al-Hijjah")},
   "10 Dhu al-Hijjah P3D" {:name (partial get-name "10 Dhu al-Hijjah")},
   "05-01" {:name (partial get-name "05-01")},
   "12 Rabi al-awwal" {:name (partial get-name "12 Rabi al-awwal")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :ly
  [_ context]
  (holiday? context))
