;; This file is autogenerated using vura.holidays.compile/-main

(ns vura.holiday.km
  (:require
   [clojure.string]
   [vura.holiday :refer [is-holiday?]]
   [vura.holiday.util :refer [parse-definition
                              get-name]]
   [vura.holiday.compiler :as compiler]))

(def holidays
  {"03-18"
   {:name
    {:fr "Journée de Cheikh Al Maarouf", :en "Cheikh Al Maarouf Day"}},
   "01-01" {:name (partial get-name "01-01")},
   "27 Rajab" {:name (partial get-name "27 Rajab")},
   "10 Dhu al-Hijjah P2DT0H0M"
   {:name (partial get-name "10 Dhu al-Hijjah")},
   "1 Muharram" {:name (partial get-name "1 Muharram")},
   "07-06" {:name (partial get-name "Independence Day")},
   "11-12" {:name {:fr "Journée Maoré", :en "Maore Day"}},
   "05-01" {:name (partial get-name "05-01")},
   "12 Rabi al-awwal" {:name (partial get-name "12 Rabi al-awwal")},
   "1 Shawwal P3DT0H0M" {:name (partial get-name "1 Shawwal")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :km
  [_ context]
  (holiday? context))
