;; This file is autogenerated using vura.holidays.compile/-main

(ns vura.holiday.it
  (:require
   [clojure.string]
   [vura.holiday :refer [is-holiday?]]
   [vura.holiday.util :refer [parse-definition
                              get-name]]
   [vura.holiday.compiler :as compiler]))

(def holidays
  {"12-08" {:name (partial get-name "12-08")},
   "08-15" {:name (partial get-name "08-15")},
   "01-01" {:name (partial get-name "01-01")},
   "06-02" {:name {:it "Festa della Repubblica", :en "Republic Day"}},
   "11-01" {:name (partial get-name "11-01")},
   "easter" {:name (partial get-name "easter")},
   "2nd sunday in May"
   {"type" "observance", :name (partial get-name "Mothers Day")},
   "2011-03-17"
   {:name {:it "Festa Nazionale 2011", :en "National Day 2011"}},
   "12-26" {:name (partial get-name "12-26")},
   "easter 1" {:name (partial get-name "easter 1")},
   "05-01" {:name (partial get-name "05-01")},
   "01-06" {:name (partial get-name "01-06")},
   "04-25"
   {:name {:it "Anniversario della Liberazione", :en "Liberation Day"}},
   "12-25" {:name (partial get-name "12-25")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :it
  [_ context]
  (holiday? context))
