;; This file is autogenerated using vura.holidays.compile/-main

(ns vura.holiday.gy
  (:require
   [clojure.string]
   [vura.holiday :refer [is-holiday?]]
   [vura.holiday.util :refer [parse-definition
                              get-name]]
   [vura.holiday.compiler :as compiler]))

(def holidays
  {"2016-03-23" {:name {:en "Phagwah"}},
   "10 Dhu al-Hijjah"
   {"_name" "10 Dhu al-Hijjah",
    "note" "tentative",
    "disable" ["2015-09-23"],
    "enable" ["2015-09-24"],
    :name {:en "Eid Ul Adha"}},
   "2017-10-18" {:name {:en "Deepavali"}},
   "01-01" {:name (partial get-name "01-01")},
   "2023-11-12" {:name {:en "Deepavali"}},
   "2017-03-12" {:name {:en "Phagwah"}},
   "2024-10-31" {:name {:en "Deepavali"}},
   "2015-11-11" {:name {:en "Deepavali"}},
   "2015-03-05" {:name {:en "Phagwah"}},
   "2022-10-24" {:name {:en "Deepavali"}},
   "05-05" {:name {:en "Arrival Day"}},
   "monday after 07-01" {:name {:en "CARICOM Day"}},
   "05-26" {:name (partial get-name "Independence Day")},
   "2021-03-29" {:name {:en "Phagwah"}},
   "2024-03-25" {:name {:en "Phagwah"}},
   "2019-03-21" {:name {:en "Phagwah"}},
   "2022-03-18" {:name {:en "Phagwah"}},
   "easter -2" {:name (partial get-name "easter -2")},
   "2019-10-27" {:name {:en "Deepavali"}},
   "2018-03-02" {:name {:en "Phagwah"}},
   "2020-11-14" {:name {:en "Deepavali"}},
   "2020-03-10" {:name {:en "Phagwah"}},
   "12-26" {:name (partial get-name "12-26")},
   "2019-10-28" {"substitute" true, :name {:en "Deepavali"}},
   "08-01" {:name {:en "Emancipation Day"}},
   "2017-03-13" {"substitute" true, :name {:en "Phagwah"}},
   "easter 1" {:name (partial get-name "easter 1")},
   "05-01" {:name (partial get-name "05-01")},
   "2018-11-07" {:name {:en "Deepavali"}},
   "2023-11-13" {"substitute" true, :name {:en "Deepavali"}},
   "2021-11-04" {:name {:en "Deepavali"}},
   "12 Rabi al-awwal"
   {"_name" "12 Rabi al-awwal",
    "note" "tentative",
    "disable" ["2016-12-11" "2015-12-23" "2013-01-24"],
    "enable" ["2016-12-12" "2015-12-24" "2013-01-23"],
    :name {:en "Youman Nabi"}},
   "02-23" {:name {:en "Republic Day"}},
   "2023-03-07" {:name {:en "Phagwah"}},
   "12-25" {:name (partial get-name "12-25")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :gy
  [_ context]
  (holiday? context))
