;; This file is autogenerated using vura.holidays.compile/-main

(ns vura.holiday.ga
  (:require
   [clojure.string]
   [vura.holiday :refer [is-holiday?]]
   [vura.holiday.util :refer [parse-definition
                              get-name]]
   [vura.holiday.compiler :as compiler]))

(def holidays
  {"08-15" {:name (partial get-name "08-15")},
   "10 Dhu al-Hijjah" {:name (partial get-name "10 Dhu al-Hijjah")},
   "01-01" {:name (partial get-name "01-01")},
   "04-17"
   {:name {:fr "Journée des droits de la femme", :en "Women's Day"}},
   "11-01" {:name (partial get-name "11-01")},
   "easter 50" {:name (partial get-name "easter 50")},
   "1 Shawwal" {:name (partial get-name "1 Shawwal")},
   "easter 1" {:name (partial get-name "easter 1")},
   "05-01" {:name (partial get-name "05-01")},
   "08-16 P2D" {:name (partial get-name "Independence Day")},
   "12-25" {:name (partial get-name "12-25")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :ga
  [_ context]
  (holiday? context))
