;; This file is autogenerated using vura.holidays.compile/-main

(ns vura.holiday.cm
  (:require
   [clojure.string]
   [vura.holiday :refer [is-holiday?]]
   [vura.holiday.util :refer [parse-definition
                              get-name]]
   [vura.holiday.compiler :as compiler]))

(def holidays
  {"08-15" {:name (partial get-name "08-15")},
   "10 Dhu al-Hijjah" {:name (partial get-name "10 Dhu al-Hijjah")},
   "01-01" {:name (partial get-name "01-01")},
   "easter 39" {:name (partial get-name "easter 39")},
   "easter -2" {:name (partial get-name "easter -2")},
   "1 Shawwal" {:name (partial get-name "1 Shawwal")},
   "05-01 if sunday then next monday" {:name (partial get-name "05-01")},
   "02-11" {:name {:fr "Fête de la Jeunesse", :en "Youth Day"}},
   "05-20"
   {:name {:fr "Fête nationale ou de l'unité", :en "National Day"}},
   "12-25" {:name (partial get-name "12-25")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :cm
  [_ context]
  (holiday? context))
