;; This file is autogenerated using vura.holidays.compile/-main

(ns vura.holiday.ae
  (:require
   [clojure.string]
   [vura.holiday :refer [is-holiday?]]
   [vura.holiday.util :refer [parse-definition
                              get-name]]
   [vura.holiday.compiler :as compiler]))

(def holidays
  {"01-01" {"_name" "01-01", :name {:ar "رأس السنة الميلادية"}},
   "12-02" {:name {:en "National Day", :ar "اليوم الوطني"}},
   "1 Muharram" {:name (partial get-name "1 Muharram")},
   "1 Shawwal P3D" {:name (partial get-name "1 Shawwal")},
   "10 Dhu al-Hijjah P3D" {:name (partial get-name "10 Dhu al-Hijjah")},
   "27 Rajab" {:name (partial get-name "27 Rajab")},
   "1 Ramadan" {:name (partial get-name "1 Ramadan")},
   "12 Rabi al-awwal" {:name (partial get-name "12 Rabi al-awwal")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :ae
  [_ context]
  (holiday? context))
