// Compiled by ClojureScript 1.12.42 {:static-fns true, :optimizations :none}
goog.provide('cljs.core');
goog.require('goog.math.Integer');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.string.StringBuffer');
goog.require('goog.math.Long');
goog.scope(function(){
cljs.core.goog$module$goog$math$Long = goog.module.get('goog.math.Long');
});
goog.require('goog.object');
goog.scope(function(){
cljs.core.goog$module$goog$object = goog.module.get('goog.object');
});
goog.require('goog.array');
goog.scope(function(){
cljs.core.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core._STAR_clojurescript_version_STAR_ = "1.12.42";
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_unchecked_arrays_STAR_ = false;
cljs.core._STAR_warn_on_infer_STAR_ = false;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.PROTOCOL_SENTINEL !== 'undefined')){
} else {
cljs.core.PROTOCOL_SENTINEL = ({});
}
cljs.core.MODULE_URIS = null;
cljs.core.MODULE_INFOS = null;

/**
 * Var bound to the name value of the compiler build :target option.
 *   For example, if the compiler build :target is :nodejs, *target* will be bound
 *   to "nodejs". *target* is a Google Closure define and can be set by compiler
 *   :closure-defines option.
 * @define {string}
 */
cljs.core._STAR_target_STAR_ = goog.define("cljs.core._STAR_target_STAR_","default");

/**
 * Manually set the JavaScript global context. Only "window", "self"
 *   , and "global" supported. 
 * @define {string}
 */
cljs.core._STAR_global_STAR_ = goog.define("cljs.core._STAR_global_STAR_","default");
/**
 * Var bound to the current namespace. Only used for bootstrapping.
 * @type {*}
 */
cljs.core._STAR_ns_STAR_ = null;
/**
 * @type {*}
 */
cljs.core._STAR_out_STAR_ = null;
cljs.core._STAR_assert_STAR_ = true;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_print_fn_STAR_ !== 'undefined')){
} else {
/**
 * Each runtime environment provides a different way to print output.
 *   Whatever function *print-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_fn_STAR_ = null;
}
/**
 * Arranges to have tap functions executed via the supplied f, a
 *   function of no arguments. Returns true if successful, false otherwise.
 */
cljs.core._STAR_exec_tap_fn_STAR_ = (function cljs$core$_STAR_exec_tap_fn_STAR_(f){
return (((typeof setTimeout !== 'undefined')) && (cljs.core.boolean$(setTimeout(f,(0)))));
});
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_print_err_fn_STAR_ !== 'undefined')){
} else {
/**
 * Each runtime environment provides a different way to print error output.
 *   Whatever function *print-err-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_err_fn_STAR_ = null;
}
/**
 * Set *print-fn* to f.
 */
cljs.core.set_print_fn_BANG_ = (function cljs$core$set_print_fn_BANG_(f){
return (cljs.core._STAR_print_fn_STAR_ = f);
});
/**
 * Set *print-err-fn* to f.
 */
cljs.core.set_print_err_fn_BANG_ = (function cljs$core$set_print_err_fn_BANG_(f){
return (cljs.core._STAR_print_err_fn_STAR_ = f);
});
/**
 * When set to true, output will be flushed whenever a newline is printed.
 * 
 *   Defaults to true.
 */
cljs.core._STAR_flush_on_newline_STAR_ = true;
/**
 * When set to logical false will drop newlines from printing calls.
 *   This is to work around the implicit newlines emitted by standard JavaScript
 *   console objects.
 */
cljs.core._STAR_print_newline_STAR_ = true;
/**
 * When set to logical false, strings and characters will be printed with
 *   non-alphanumeric characters converted to the appropriate escape sequences.
 * 
 *   Defaults to true
 */
cljs.core._STAR_print_readably_STAR_ = true;
/**
 * If set to logical true, when printing an object, its metadata will also
 *   be printed in a form that can be read back by the reader.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_meta_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 *   their type when read in later.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_dup_STAR_ = false;
/**
 * *print-namespace-maps* controls whether the printer will print
 *   namespace map literal syntax.
 * 
 *   Defaults to false, but the REPL binds it to true.
 */
cljs.core._STAR_print_namespace_maps_STAR_ = false;
/**
 * *print-length* controls how many items of each collection the
 *   printer will print. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   number of items of each collection to print. If a collection contains
 *   more items, the printer will print items up to the limit followed by
 *   '...' to represent the remaining items. The root binding is nil
 *   indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_length_STAR_ = null;
/**
 * *print-level* controls how many levels deep the printer will
 *   print nested objects. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   level to print. Each argument to print is at level 0; if an argument is a
 *   collection, its items are at level 1; and so on. If an object is a
 *   collection and is at a level greater than or equal to the value bound to
 *   *print-level*, the printer prints '#' to represent it. The root binding
 *   is nil indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_level_STAR_ = null;
/**
 * *print-fns-bodies* controls whether functions print their source or
 *  only their names.
 */
cljs.core._STAR_print_fn_bodies_STAR_ = false;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_loaded_libs_STAR_ !== 'undefined')){
} else {
/**
 * @type {*}
 */
cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = (function cljs$core$pr_opts(){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939),cljs.core._STAR_flush_on_newline_STAR_,new cljs.core.Keyword(null,"readably","readably",1129599760),cljs.core._STAR_print_readably_STAR_,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core._STAR_print_meta_STAR_,new cljs.core.Keyword(null,"dup","dup",556298533),cljs.core._STAR_print_dup_STAR_,new cljs.core.Keyword(null,"print-length","print-length",1931866356),cljs.core._STAR_print_length_STAR_], null);
});
/**
 * Set *print-fn* to console.log
 */
cljs.core.enable_console_print_BANG_ = (function cljs$core$enable_console_print_BANG_(){
(cljs.core._STAR_print_newline_STAR_ = false);

cljs.core.set_print_fn_BANG_((function cljs$core$enable_console_print_BANG__$_fn_14161(){
var xs = arguments;
return console.log.apply(console,cljs.core.goog$module$goog$array.clone.call(null,xs));
}));

cljs.core.set_print_err_fn_BANG_((function cljs$core$enable_console_print_BANG__$_fn_14162(){
var xs = arguments;
return console.error.apply(console,cljs.core.goog$module$goog$array.clone.call(null,xs));
}));

return null;
});
/**
 * Internal - do not use!
 */
cljs.core.truth_ = (function cljs$core$truth_(x){
return (x != null && x !== false);
});
cljs.core.not_native = null;

/**
 * Tests if 2 arguments are the same object
 */
cljs.core.identical_QMARK_ = (function cljs$core$identical_QMARK_(x,y){
return (x === y);
});
/**
 * Returns true if x is nil, false otherwise.
 */
cljs.core.nil_QMARK_ = (function cljs$core$nil_QMARK_(x){
return (x == null);
});
/**
 * Returns true if x is a JavaScript array.
 */
cljs.core.array_QMARK_ = (function cljs$core$array_QMARK_(x){
if((cljs.core._STAR_target_STAR_ === "nodejs")){
return Array.isArray(x);
} else {
return (x instanceof Array);
}
});
/**
 * Returns true if x is a JavaScript number.
 */
cljs.core.number_QMARK_ = (function cljs$core$number_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true if x is logical false, false otherwise.
 */
cljs.core.not = (function cljs$core$not(x){
if((x == null)){
return true;
} else {
if(x === false){
return true;
} else {
return false;

}
}
});
/**
 * Returns true if x is not nil, false otherwise.
 */
cljs.core.some_QMARK_ = (function cljs$core$some_QMARK_(x){
return (!((x == null)));
});
/**
 * Returns true if x's constructor is Object
 */
cljs.core.object_QMARK_ = (function cljs$core$object_QMARK_(x){
if((!((x == null)))){
return (x.constructor === Object);
} else {
return false;
}
});
/**
 * Returns true if x is a JavaScript string.
 */
cljs.core.string_QMARK_ = (function cljs$core$string_QMARK_(x){
return ("string" === goog.typeOf(x));
});
/**
 * Returns true if x is a JavaScript string of length one.
 */
cljs.core.char_QMARK_ = (function cljs$core$char_QMARK_(x){
return ((typeof x === 'string') && (((1) === x.length)));
});
/**
 * Returns true if given any argument.
 */
cljs.core.any_QMARK_ = (function cljs$core$any_QMARK_(x){
return true;
});
/**
 * Internal - do not use!
 */
cljs.core.native_satisfies_QMARK_ = (function cljs$core$native_satisfies_QMARK_(p,x){
var x__$1 = (((x == null))?null:x);
if((p[goog.typeOf(x__$1)])){
return true;
} else {
if((p["_"])){
return true;
} else {
return false;

}
}
});
cljs.core.is_proto_ = (function cljs$core$is_proto_(x){
return (x.constructor.prototype === x);
});
/**
 * When compiled for a command-line target, whatever function
 *   *main-cli-fn* is set to will be called with the command-line
 *   argv as arguments
 */
cljs.core._STAR_main_cli_fn_STAR_ = null;
/**
 * A sequence of the supplied command line arguments, or nil if
 *   none were supplied
 */
cljs.core._STAR_command_line_args_STAR_ = null;
/**
 * Return x's constructor.
 */
cljs.core.type = (function cljs$core$type(x){
if((x == null)){
return null;
} else {
return x.constructor;
}
});
cljs.core.missing_protocol = (function cljs$core$missing_protocol(proto,obj){
var ty = cljs.core.type(obj);
var ty__$1 = (cljs.core.truth_((function (){var and__9578__auto__ = ty;
if(cljs.core.truth_(and__9578__auto__)){
return ty.cljs$lang$type;
} else {
return and__9578__auto__;
}
})())?ty.cljs$lang$ctorStr:goog.typeOf(obj));
return (new Error(["No protocol method ",proto," defined for type ",ty__$1,": ",obj].join("")));
});
cljs.core.type__GT_str = (function cljs$core$type__GT_str(ty){
var temp__5718__auto__ = ty.cljs$lang$ctorStr;
if(cljs.core.truth_(temp__5718__auto__)){
var s = temp__5718__auto__;
return s;
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(ty);
}
});
cljs.core.load_file = (function cljs$core$load_file(file){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
return goog.nodeGlobalRequire(file);
}
});
if((((typeof Symbol !== 'undefined')) && ((goog.typeOf(Symbol) === "function")))){
cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
cljs.core.ITER_SYMBOL = "@@iterator";
}
/**
 * @enum {string}
 */
cljs.core.CHAR_MAP = ({"]": "_RBRACK_", "'": "_SINGLEQUOTE_", "=": "_EQ_", "\"": "_DOUBLEQUOTE_", "!": "_BANG_", "*": "_STAR_", "%": "_PERCENT_", "|": "_BAR_", "~": "_TILDE_", "/": "_SLASH_", "\\": "_BSLASH_", "-": "_", "?": "_QMARK_", "&": "_AMPERSAND_", ":": "_COLON_", "<": "_LT_", "{": "_LBRACE_", "}": "_RBRACE_", "[": "_LBRACK_", "#": "_SHARP_", "^": "_CARET_", "+": "_PLUS_", "@": "_CIRCA_", ">": "_GT_"});
/**
 * @enum {string}
 */
cljs.core.DEMUNGE_MAP = ({"_RBRACE_": "}", "_COLON_": ":", "_BANG_": "!", "_QMARK_": "?", "_BSLASH_": "\\\\", "_SLASH_": "/", "_PERCENT_": "%", "_PLUS_": "+", "_SHARP_": "#", "_LBRACE_": "{", "_BAR_": "|", "_LBRACK_": "[", "_EQ_": "=", "_": "-", "_TILDE_": "~", "_RBRACK_": "]", "_GT_": ">", "_SINGLEQUOTE_": "'", "_CIRCA_": "@", "_AMPERSAND_": "&", "_DOUBLEQUOTE_": "\\\"", "_CARET_": "^", "_LT_": "<", "_STAR_": "*"});
cljs.core.DEMUNGE_PATTERN = null;
/**
 * Returns highest resolution time offered by host in milliseconds.
 */
cljs.core.system_time = (function cljs$core$system_time(){
if((((typeof performance !== 'undefined')) && ((!((performance.now == null)))))){
return performance.now();
} else {
if((((typeof process !== 'undefined')) && ((!((process.hrtime == null)))))){
var t = process.hrtime();
return ((((t[(0)]) * 1.0E9) + (t[(1)])) / 1000000.0);
} else {
return (new Date()).getTime();

}
}
});
/**
 * Construct a JavaScript array of the specified dimensions. Accepts ignored
 *   type argument for compatibility with Clojure. Note that there is no efficient
 *   way to allocate multi-dimensional arrays in JavaScript; as such, this function
 *   will run in polynomial time when called with 3 or more arguments.
 */
cljs.core.make_array = (function cljs$core$make_array(var_args){
var G__14167 = arguments.length;
switch (G__14167) {
case 1:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___14173 = arguments.length;
var i__10914__auto___14174 = (0);
while(true){
if((i__10914__auto___14174 < len__10913__auto___14173)){
args_arr__10942__auto__.push((arguments[i__10914__auto___14174]));

var G__14175 = (i__10914__auto___14174 + (1));
i__10914__auto___14174 = G__14175;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14168(size){
return (new Array(size));
}));

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14169(type,size){
return (new Array(size));
}));

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14170(type,size,more_sizes){
var dims = more_sizes;
var dimarray = (new Array(size));
var n__10672__auto___14176 = dimarray.length;
var i_14177 = (0);
while(true){
if((i_14177 < n__10672__auto___14176)){
(dimarray[i_14177] = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.make_array,null,dims));

var G__14178 = (i_14177 + (1));
i_14177 = G__14178;
continue;
} else {
}
break;
}

return dimarray;
}));

/** @this {Function} */
(cljs.core.make_array.cljs$lang$applyTo = (function cljs$core$fn_14171(seq14164){
var G__14165 = cljs.core.first(seq14164);
var seq14164__$1 = cljs.core.next(seq14164);
var G__14166 = cljs.core.first(seq14164__$1);
var seq14164__$2 = cljs.core.next(seq14164__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14165,G__14166,seq14164__$2);
}));

(cljs.core.make_array.cljs$lang$maxFixedArity = (2));

/**
 * Returns a javascript array, cloned from the passed in array
 */
cljs.core.aclone = (function cljs$core$aclone(arr){
var len = arr.length;
var new_arr = (new Array(len));
var n__10672__auto___14179 = len;
var i_14180 = (0);
while(true){
if((i_14180 < n__10672__auto___14179)){
(new_arr[i_14180] = (arr[i_14180]));

var G__14181 = (i_14180 + (1));
i_14180 = G__14181;
continue;
} else {
}
break;
}

return new_arr;
});
/**
 * Creates a new javascript array.
 * @param {...*} var_args
 */
cljs.core.array = (function cljs$core$array(var_args){
var a = (new Array(arguments.length));
var i = (0);
while(true){
if((i < a.length)){
(a[i] = (arguments[i]));

var G__14182 = (i + (1));
i = G__14182;
continue;
} else {
return a;
}
break;
}
});
cljs.core.maybe_warn = (function cljs$core$maybe_warn(e){
if(cljs.core.truth_(cljs.core._STAR_print_err_fn_STAR_)){
return (cljs.core._STAR_print_err_fn_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.core._STAR_print_err_fn_STAR_.cljs$core$IFn$_invoke$arity$1(e) : cljs.core._STAR_print_err_fn_STAR_.call(null,e));
} else {
return null;
}
});
cljs.core.checked_aget = (function cljs$core$checked_aget(var_args){
var G__14187 = arguments.length;
switch (G__14187) {
case 2:
return cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___14193 = arguments.length;
var i__10914__auto___14194 = (0);
while(true){
if((i__10914__auto___14194 < len__10913__auto___14193)){
args_arr__10942__auto__.push((arguments[i__10914__auto___14194]));

var G__14195 = (i__10914__auto___14194 + (1));
i__10914__auto___14194 = G__14195;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14188(array,idx){
try{if(cljs.core.truth_((function (){var or__9584__auto__ = cljs.core.array_QMARK_(array);
if(or__9584__auto__){
return or__9584__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}
}catch (e14189){var e_14196 = e14189;
cljs.core.maybe_warn(e_14196);
}
return (array[idx]);
}));

(cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14190(array,idx,idxs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.checked_aget,cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2(array,idx),idxs);
}));

/** @this {Function} */
(cljs.core.checked_aget.cljs$lang$applyTo = (function cljs$core$fn_14191(seq14184){
var G__14185 = cljs.core.first(seq14184);
var seq14184__$1 = cljs.core.next(seq14184);
var G__14186 = cljs.core.first(seq14184__$1);
var seq14184__$2 = cljs.core.next(seq14184__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14185,G__14186,seq14184__$2);
}));

(cljs.core.checked_aget.cljs$lang$maxFixedArity = (2));

cljs.core.checked_aset = (function cljs$core$checked_aset(var_args){
var G__14202 = arguments.length;
switch (G__14202) {
case 3:
return cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___14208 = arguments.length;
var i__10914__auto___14209 = (0);
while(true){
if((i__10914__auto___14209 < len__10913__auto___14208)){
args_arr__10942__auto__.push((arguments[i__10914__auto___14209]));

var G__14210 = (i__10914__auto___14209 + (1));
i__10914__auto___14209 = G__14210;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((3) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((3)),(0),null)):null);
return cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10943__auto__);

}
});

(cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14203(array,idx,val){
try{if(cljs.core.truth_((function (){var or__9584__auto__ = cljs.core.array_QMARK_(array);
if(or__9584__auto__){
return or__9584__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}
}catch (e14204){var e_14211 = e14204;
cljs.core.maybe_warn(e_14211);
}
return (array[idx] = val);
}));

(cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14205(array,idx,idx2,idxv){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.checked_aset,cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2(array,idx),idx2,idxv);
}));

/** @this {Function} */
(cljs.core.checked_aset.cljs$lang$applyTo = (function cljs$core$fn_14206(seq14198){
var G__14199 = cljs.core.first(seq14198);
var seq14198__$1 = cljs.core.next(seq14198);
var G__14200 = cljs.core.first(seq14198__$1);
var seq14198__$2 = cljs.core.next(seq14198__$1);
var G__14201 = cljs.core.first(seq14198__$2);
var seq14198__$3 = cljs.core.next(seq14198__$2);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14199,G__14200,G__14201,seq14198__$3);
}));

(cljs.core.checked_aset.cljs$lang$maxFixedArity = (3));

cljs.core.checked_aget_SINGLEQUOTE_ = (function cljs$core$checked_aget_SINGLEQUOTE_(var_args){
var G__14216 = arguments.length;
switch (G__14216) {
case 2:
return cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___14221 = arguments.length;
var i__10914__auto___14222 = (0);
while(true){
if((i__10914__auto___14222 < len__10913__auto___14221)){
args_arr__10942__auto__.push((arguments[i__10914__auto___14222]));

var G__14223 = (i__10914__auto___14222 + (1));
i__10914__auto___14222 = G__14223;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14217(array,idx){
if(cljs.core.truth_((function (){var or__9584__auto__ = cljs.core.array_QMARK_(array);
if(or__9584__auto__){
return or__9584__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}

return (array[idx]);
}));

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14218(array,idx,idxs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.checked_aget_SINGLEQUOTE_,cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(array,idx),idxs);
}));

/** @this {Function} */
(cljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$applyTo = (function cljs$core$fn_14219(seq14213){
var G__14214 = cljs.core.first(seq14213);
var seq14213__$1 = cljs.core.next(seq14213);
var G__14215 = cljs.core.first(seq14213__$1);
var seq14213__$2 = cljs.core.next(seq14213__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14214,G__14215,seq14213__$2);
}));

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$maxFixedArity = (2));

cljs.core.checked_aset_SINGLEQUOTE_ = (function cljs$core$checked_aset_SINGLEQUOTE_(var_args){
var G__14229 = arguments.length;
switch (G__14229) {
case 3:
return cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___14234 = arguments.length;
var i__10914__auto___14235 = (0);
while(true){
if((i__10914__auto___14235 < len__10913__auto___14234)){
args_arr__10942__auto__.push((arguments[i__10914__auto___14235]));

var G__14236 = (i__10914__auto___14235 + (1));
i__10914__auto___14235 = G__14236;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((3) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((3)),(0),null)):null);
return cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10943__auto__);

}
});

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14230(array,idx,val){
if(cljs.core.truth_((function (){var or__9584__auto__ = cljs.core.array_QMARK_(array);
if(or__9584__auto__){
return or__9584__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}

return (array[idx] = val);
}));

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14231(array,idx,idx2,idxv){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.checked_aset_SINGLEQUOTE_,cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(array,idx),idx2,idxv);
}));

/** @this {Function} */
(cljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$applyTo = (function cljs$core$fn_14232(seq14225){
var G__14226 = cljs.core.first(seq14225);
var seq14225__$1 = cljs.core.next(seq14225);
var G__14227 = cljs.core.first(seq14225__$1);
var seq14225__$2 = cljs.core.next(seq14225__$1);
var G__14228 = cljs.core.first(seq14225__$2);
var seq14225__$3 = cljs.core.next(seq14225__$2);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14226,G__14227,G__14228,seq14225__$3);
}));

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$maxFixedArity = (3));

/**
 * Returns the value at the index/indices. Works on JavaScript arrays.
 */
cljs.core.aget = (function cljs$core$aget(var_args){
var G__14241 = arguments.length;
switch (G__14241) {
case 2:
return cljs.core.aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___14246 = arguments.length;
var i__10914__auto___14247 = (0);
while(true){
if((i__10914__auto___14247 < len__10913__auto___14246)){
args_arr__10942__auto__.push((arguments[i__10914__auto___14247]));

var G__14248 = (i__10914__auto___14247 + (1));
i__10914__auto___14247 = G__14248;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14242(array,idx){
return (array[idx]);
}));

(cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14243(array,idx,idxs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.aget,(array[idx]),idxs);
}));

/** @this {Function} */
(cljs.core.aget.cljs$lang$applyTo = (function cljs$core$fn_14244(seq14238){
var G__14239 = cljs.core.first(seq14238);
var seq14238__$1 = cljs.core.next(seq14238);
var G__14240 = cljs.core.first(seq14238__$1);
var seq14238__$2 = cljs.core.next(seq14238__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14239,G__14240,seq14238__$2);
}));

(cljs.core.aget.cljs$lang$maxFixedArity = (2));

/**
 * Sets the value at the index/indices. Works on JavaScript arrays.
 *   Returns val.
 */
cljs.core.aset = (function cljs$core$aset(var_args){
var G__14254 = arguments.length;
switch (G__14254) {
case 3:
return cljs.core.aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___14259 = arguments.length;
var i__10914__auto___14260 = (0);
while(true){
if((i__10914__auto___14260 < len__10913__auto___14259)){
args_arr__10942__auto__.push((arguments[i__10914__auto___14260]));

var G__14261 = (i__10914__auto___14260 + (1));
i__10914__auto___14260 = G__14261;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((3) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((3)),(0),null)):null);
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10943__auto__);

}
});

(cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14255(array,idx,val){
return (array[idx] = val);
}));

(cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14256(array,idx,idx2,idxv){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.aset,(array[idx]),idx2,idxv);
}));

/** @this {Function} */
(cljs.core.aset.cljs$lang$applyTo = (function cljs$core$fn_14257(seq14250){
var G__14251 = cljs.core.first(seq14250);
var seq14250__$1 = cljs.core.next(seq14250);
var G__14252 = cljs.core.first(seq14250__$1);
var seq14250__$2 = cljs.core.next(seq14250__$1);
var G__14253 = cljs.core.first(seq14250__$2);
var seq14250__$3 = cljs.core.next(seq14250__$2);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14251,G__14252,G__14253,seq14250__$3);
}));

(cljs.core.aset.cljs$lang$maxFixedArity = (3));

/**
 * Returns the length of the array. Works on arrays of all types.
 */
cljs.core.alength = (function cljs$core$alength(array){
return array.length;
});
/**
 * Returns an array with components set to the values in aseq. Optional type
 *   argument accepted for compatibility with Clojure.
 */
cljs.core.into_array = (function cljs$core$into_array(var_args){
var G__14263 = arguments.length;
switch (G__14263) {
case 1:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14264(aseq){
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null,aseq);
}));

(cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14265(type,aseq){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function cljs$core$fn_14265_$_fn_14266(a,x){
a.push(x);

return a;
}),[],aseq);
}));

(cljs.core.into_array.cljs$lang$maxFixedArity = 2);

/**
 * Invoke JavaScript object method via string. Needed when the
 *   string is not a valid unquoted property name.
 */
cljs.core.js_invoke = (function cljs$core$js_invoke(var_args){
var args__10923__auto__ = [];
var len__10913__auto___14273 = arguments.length;
var i__10914__auto___14274 = (0);
while(true){
if((i__10914__auto___14274 < len__10913__auto___14273)){
args__10923__auto__.push((arguments[i__10914__auto___14274]));

var G__14275 = (i__10914__auto___14274 + (1));
i__10914__auto___14274 = G__14275;
continue;
} else {
}
break;
}

var argseq__10924__auto__ = ((((2) < args__10923__auto__.length))?(new cljs.core.IndexedSeq(args__10923__auto__.slice((2)),(0),null)):null);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10924__auto__);
});

(cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14271(obj,s,args){
return (obj[s]).apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
}));

(cljs.core.js_invoke.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(cljs.core.js_invoke.cljs$lang$applyTo = (function cljs$core$fn_14272(seq14268){
var G__14269 = cljs.core.first(seq14268);
var seq14268__$1 = cljs.core.next(seq14268);
var G__14270 = cljs.core.first(seq14268__$1);
var seq14268__$2 = cljs.core.next(seq14268__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14269,G__14270,seq14268__$2);
}));

/**
 * Returns true if x is an instance of Symbol
 */
cljs.core.js_symbol_QMARK_ = (function cljs$core$js_symbol_QMARK_(x){
return (((goog.typeOf(x) === "symbol")) || ((((typeof Symbol !== 'undefined')) && ((x instanceof Symbol)))));
});

/**
 * Marker protocol
 * @interface
 */
cljs.core.Fn = function(){};


/**
 * Protocol for adding the ability to invoke an object as a function.
 *   For example, a vector can also be used to look up a value:
 *   ([1 2 3 4] 1) => 2
 * @interface
 */
cljs.core.IFn = function(){};

var cljs$core$IFn$_invoke$dyn_14301 = (function() {
var cljs$core$fn_14276 = null;
var cljs$core$fn_14276__1 = (function (this$){
var x__10333__auto__ = (((this$ == null))?null:this$);
var m__10334__auto__ = (cljs.core._invoke[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__10334__auto__.call(null,this$));
} else {
var m__10332__auto__ = (cljs.core._invoke["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__10332__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14276__2 = (function (this$,a){
var x__10333__auto__ = (((this$ == null))?null:this$);
var m__10334__auto__ = (cljs.core._invoke[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__10334__auto__.call(null,this$,a));
} else {
var m__10332__auto__ = (cljs.core._invoke["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__10332__auto__.call(null,this$,a));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14276__3 = (function (this$,a,b){
var x__10333__auto__ = (((this$ == null))?null:this$);
var m__10334__auto__ = (cljs.core._invoke[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__10334__auto__.call(null,this$,a,b));
} else {
var m__10332__auto__ = (cljs.core._invoke["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__10332__auto__.call(null,this$,a,b));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14276__4 = (function (this$,a,b,c){
var x__10333__auto__ = (((this$ == null))?null:this$);
var m__10334__auto__ = (cljs.core._invoke[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$4 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__10334__auto__.call(null,this$,a,b,c));
} else {
var m__10332__auto__ = (cljs.core._invoke["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$4 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__10332__auto__.call(null,this$,a,b,c));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14276__5 = (function (this$,a,b,c,d){
var x__10333__auto__ = (((this$ == null))?null:this$);
var m__10334__auto__ = (cljs.core._invoke[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$5 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__10334__auto__.call(null,this$,a,b,c,d));
} else {
var m__10332__auto__ = (cljs.core._invoke["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$5 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__10332__auto__.call(null,this$,a,b,c,d));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14276__6 = (function (this$,a,b,c,d,e){
var x__10333__auto__ = (((this$ == null))?null:this$);
var m__10334__auto__ = (cljs.core._invoke[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$6 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__10334__auto__.call(null,this$,a,b,c,d,e));
} else {
var m__10332__auto__ = (cljs.core._invoke["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$6 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__10332__auto__.call(null,this$,a,b,c,d,e));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14276__7 = (function (this$,a,b,c,d,e,f){
var x__10333__auto__ = (((this$ == null))?null:this$);
var m__10334__auto__ = (cljs.core._invoke[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$7 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__10334__auto__.call(null,this$,a,b,c,d,e,f));
} else {
var m__10332__auto__ = (cljs.core._invoke["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$7 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__10332__auto__.call(null,this$,a,b,c,d,e,f));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14276__8 = (function (this$,a,b,c,d,e,f,g){
var x__10333__auto__ = (((this$ == null))?null:this$);
var m__10334__auto__ = (cljs.core._invoke[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$8 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__10334__auto__.call(null,this$,a,b,c,d,e,f,g));
} else {
var m__10332__auto__ = (cljs.core._invoke["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$8 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__10332__auto__.call(null,this$,a,b,c,d,e,f,g));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14276__9 = (function (this$,a,b,c,d,e,f,g,h){
var x__10333__auto__ = (((this$ == null))?null:this$);
var m__10334__auto__ = (cljs.core._invoke[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$9 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__10334__auto__.call(null,this$,a,b,c,d,e,f,g,h));
} else {
var m__10332__auto__ = (cljs.core._invoke["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$9 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__10332__auto__.call(null,this$,a,b,c,d,e,f,g,h));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14276__10 = (function (this$,a,b,c,d,e,f,g,h,i){
var x__10333__auto__ = (((this$ == null))?null:this$);
var m__10334__auto__ = (cljs.core._invoke[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$10 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__10334__auto__.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
var m__10332__auto__ = (cljs.core._invoke["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$10 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__10332__auto__.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14276__11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
var x__10333__auto__ = (((this$ == null))?null:this$);
var m__10334__auto__ = (cljs.core._invoke[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$11 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__10334__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
var m__10332__auto__ = (cljs.core._invoke["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$11 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__10332__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14276__12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
var x__10333__auto__ = (((this$ == null))?null:this$);
var m__10334__auto__ = (cljs.core._invoke[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$12 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__10334__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
var m__10332__auto__ = (cljs.core._invoke["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$12 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__10332__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14276__13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
var x__10333__auto__ = (((this$ == null))?null:this$);
var m__10334__auto__ = (cljs.core._invoke[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$13 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__10334__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
var m__10332__auto__ = (cljs.core._invoke["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$13 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__10332__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14276__14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
var x__10333__auto__ = (((this$ == null))?null:this$);
var m__10334__auto__ = (cljs.core._invoke[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$14 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__10334__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
var m__10332__auto__ = (cljs.core._invoke["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$14 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__10332__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14276__15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var x__10333__auto__ = (((this$ == null))?null:this$);
var m__10334__auto__ = (cljs.core._invoke[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$15 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__10334__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
var m__10332__auto__ = (cljs.core._invoke["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$15 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__10332__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14276__16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var x__10333__auto__ = (((this$ == null))?null:this$);
var m__10334__auto__ = (cljs.core._invoke[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$16 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__10334__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
var m__10332__auto__ = (cljs.core._invoke["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$16 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__10332__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14276__17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var x__10333__auto__ = (((this$ == null))?null:this$);
var m__10334__auto__ = (cljs.core._invoke[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$17 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__10334__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
var m__10332__auto__ = (cljs.core._invoke["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$17 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__10332__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14276__18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var x__10333__auto__ = (((this$ == null))?null:this$);
var m__10334__auto__ = (cljs.core._invoke[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$18 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__10334__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
var m__10332__auto__ = (cljs.core._invoke["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$18 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__10332__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14276__19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var x__10333__auto__ = (((this$ == null))?null:this$);
var m__10334__auto__ = (cljs.core._invoke[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$19 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__10334__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
var m__10332__auto__ = (cljs.core._invoke["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$19 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__10332__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14276__20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var x__10333__auto__ = (((this$ == null))?null:this$);
var m__10334__auto__ = (cljs.core._invoke[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$20 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__10334__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
var m__10332__auto__ = (cljs.core._invoke["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$20 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__10332__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14276__21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var x__10333__auto__ = (((this$ == null))?null:this$);
var m__10334__auto__ = (cljs.core._invoke[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$21 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__10334__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
var m__10332__auto__ = (cljs.core._invoke["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$21 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__10332__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14276__22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var x__10333__auto__ = (((this$ == null))?null:this$);
var m__10334__auto__ = (cljs.core._invoke[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$22 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__10334__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
var m__10332__auto__ = (cljs.core._invoke["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$22 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__10332__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
cljs$core$fn_14276 = function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return cljs$core$fn_14276__1.call(this,this$);
case 2:
return cljs$core$fn_14276__2.call(this,this$,a);
case 3:
return cljs$core$fn_14276__3.call(this,this$,a,b);
case 4:
return cljs$core$fn_14276__4.call(this,this$,a,b,c);
case 5:
return cljs$core$fn_14276__5.call(this,this$,a,b,c,d);
case 6:
return cljs$core$fn_14276__6.call(this,this$,a,b,c,d,e);
case 7:
return cljs$core$fn_14276__7.call(this,this$,a,b,c,d,e,f);
case 8:
return cljs$core$fn_14276__8.call(this,this$,a,b,c,d,e,f,g);
case 9:
return cljs$core$fn_14276__9.call(this,this$,a,b,c,d,e,f,g,h);
case 10:
return cljs$core$fn_14276__10.call(this,this$,a,b,c,d,e,f,g,h,i);
case 11:
return cljs$core$fn_14276__11.call(this,this$,a,b,c,d,e,f,g,h,i,j);
case 12:
return cljs$core$fn_14276__12.call(this,this$,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return cljs$core$fn_14276__13.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return cljs$core$fn_14276__14.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return cljs$core$fn_14276__15.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return cljs$core$fn_14276__16.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return cljs$core$fn_14276__17.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return cljs$core$fn_14276__18.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return cljs$core$fn_14276__19.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return cljs$core$fn_14276__20.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return cljs$core$fn_14276__21.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return cljs$core$fn_14276__22.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14276.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14276__1;
cljs$core$fn_14276.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14276__2;
cljs$core$fn_14276.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14276__3;
cljs$core$fn_14276.cljs$core$IFn$_invoke$arity$4 = cljs$core$fn_14276__4;
cljs$core$fn_14276.cljs$core$IFn$_invoke$arity$5 = cljs$core$fn_14276__5;
cljs$core$fn_14276.cljs$core$IFn$_invoke$arity$6 = cljs$core$fn_14276__6;
cljs$core$fn_14276.cljs$core$IFn$_invoke$arity$7 = cljs$core$fn_14276__7;
cljs$core$fn_14276.cljs$core$IFn$_invoke$arity$8 = cljs$core$fn_14276__8;
cljs$core$fn_14276.cljs$core$IFn$_invoke$arity$9 = cljs$core$fn_14276__9;
cljs$core$fn_14276.cljs$core$IFn$_invoke$arity$10 = cljs$core$fn_14276__10;
cljs$core$fn_14276.cljs$core$IFn$_invoke$arity$11 = cljs$core$fn_14276__11;
cljs$core$fn_14276.cljs$core$IFn$_invoke$arity$12 = cljs$core$fn_14276__12;
cljs$core$fn_14276.cljs$core$IFn$_invoke$arity$13 = cljs$core$fn_14276__13;
cljs$core$fn_14276.cljs$core$IFn$_invoke$arity$14 = cljs$core$fn_14276__14;
cljs$core$fn_14276.cljs$core$IFn$_invoke$arity$15 = cljs$core$fn_14276__15;
cljs$core$fn_14276.cljs$core$IFn$_invoke$arity$16 = cljs$core$fn_14276__16;
cljs$core$fn_14276.cljs$core$IFn$_invoke$arity$17 = cljs$core$fn_14276__17;
cljs$core$fn_14276.cljs$core$IFn$_invoke$arity$18 = cljs$core$fn_14276__18;
cljs$core$fn_14276.cljs$core$IFn$_invoke$arity$19 = cljs$core$fn_14276__19;
cljs$core$fn_14276.cljs$core$IFn$_invoke$arity$20 = cljs$core$fn_14276__20;
cljs$core$fn_14276.cljs$core$IFn$_invoke$arity$21 = cljs$core$fn_14276__21;
cljs$core$fn_14276.cljs$core$IFn$_invoke$arity$22 = cljs$core$fn_14276__22;
return cljs$core$fn_14276;
})()
;
cljs.core._invoke = (function cljs$core$_invoke(var_args){
var G__14278 = arguments.length;
switch (G__14278) {
case 1:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
case 9:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
case 11:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));

break;
case 12:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));

break;
case 13:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));

break;
case 14:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));

break;
case 15:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));

break;
case 16:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));

break;
case 17:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));

break;
case 18:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));

break;
case 19:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));

break;
case 20:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));

break;
case 21:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));

break;
case 22:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14279(this$){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$1 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$1(this$);
} else {
return cljs$core$IFn$_invoke$dyn_14301.cljs$core$IFn$_invoke$arity$1(this$);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14280(this$,a){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$2 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$2(this$,a);
} else {
return cljs$core$IFn$_invoke$dyn_14301.cljs$core$IFn$_invoke$arity$2(this$,a);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14281(this$,a,b){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$3 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);
} else {
return cljs$core$IFn$_invoke$dyn_14301.cljs$core$IFn$_invoke$arity$3(this$,a,b);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14282(this$,a,b,c){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$4 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
} else {
return cljs$core$IFn$_invoke$dyn_14301.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_14283(this$,a,b,c,d){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$5 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
} else {
return cljs$core$IFn$_invoke$dyn_14301.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_14284(this$,a,b,c,d,e){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$6 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
} else {
return cljs$core$IFn$_invoke$dyn_14301.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = (function cljs$core$fn_14285(this$,a,b,c,d,e,f){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$7 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
} else {
return cljs$core$IFn$_invoke$dyn_14301.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = (function cljs$core$fn_14286(this$,a,b,c,d,e,f,g){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$8 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
} else {
return cljs$core$IFn$_invoke$dyn_14301.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = (function cljs$core$fn_14287(this$,a,b,c,d,e,f,g,h){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$9 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
} else {
return cljs$core$IFn$_invoke$dyn_14301.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = (function cljs$core$fn_14288(this$,a,b,c,d,e,f,g,h,i){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$10 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
} else {
return cljs$core$IFn$_invoke$dyn_14301.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = (function cljs$core$fn_14289(this$,a,b,c,d,e,f,g,h,i,j){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$11 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
} else {
return cljs$core$IFn$_invoke$dyn_14301.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = (function cljs$core$fn_14290(this$,a,b,c,d,e,f,g,h,i,j,k){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$12 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
return cljs$core$IFn$_invoke$dyn_14301.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = (function cljs$core$fn_14291(this$,a,b,c,d,e,f,g,h,i,j,k,l){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$13 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
return cljs$core$IFn$_invoke$dyn_14301.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = (function cljs$core$fn_14292(this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$14 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
return cljs$core$IFn$_invoke$dyn_14301.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = (function cljs$core$fn_14293(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$15 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
return cljs$core$IFn$_invoke$dyn_14301.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = (function cljs$core$fn_14294(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$16 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
return cljs$core$IFn$_invoke$dyn_14301.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = (function cljs$core$fn_14295(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$17 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
return cljs$core$IFn$_invoke$dyn_14301.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = (function cljs$core$fn_14296(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$18 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
return cljs$core$IFn$_invoke$dyn_14301.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = (function cljs$core$fn_14297(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$19 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
return cljs$core$IFn$_invoke$dyn_14301.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = (function cljs$core$fn_14298(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$20 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
return cljs$core$IFn$_invoke$dyn_14301.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = (function cljs$core$fn_14299(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$21 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
return cljs$core$IFn$_invoke$dyn_14301.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = (function cljs$core$fn_14300(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$22 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
return cljs$core$IFn$_invoke$dyn_14301.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
}));

(cljs.core._invoke.cljs$lang$maxFixedArity = 22);



/**
 * Protocol for cloning a value.
 * @interface
 */
cljs.core.ICloneable = function(){};

var cljs$core$ICloneable$_clone$dyn_14304 = (function cljs$core$fn_14303(value){
var x__10333__auto__ = (((value == null))?null:value);
var m__10334__auto__ = (cljs.core._clone[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__10334__auto__.call(null,value));
} else {
var m__10332__auto__ = (cljs.core._clone["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__10332__auto__.call(null,value));
} else {
throw cljs.core.missing_protocol("ICloneable.-clone",value);
}
}
});
/**
 * Creates a clone of value.
 */
cljs.core._clone = (function cljs$core$_clone(value){
if((((!((value == null)))) && ((!((value.cljs$core$ICloneable$_clone$arity$1 == null)))))){
return value.cljs$core$ICloneable$_clone$arity$1(value);
} else {
return cljs$core$ICloneable$_clone$dyn_14304(value);
}
});


/**
 * Protocol for adding the ability to count a collection in constant time.
 * @interface
 */
cljs.core.ICounted = function(){};

var cljs$core$ICounted$_count$dyn_14306 = (function cljs$core$fn_14305(coll){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._count[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10334__auto__.call(null,coll));
} else {
var m__10332__auto__ = (cljs.core._count["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10332__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ICounted.-count",coll);
}
}
});
/**
 * Calculates the count of coll in constant time. Used by cljs.core/count.
 */
cljs.core._count = (function cljs$core$_count(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ICounted$_count$arity$1 == null)))))){
return coll.cljs$core$ICounted$_count$arity$1(coll);
} else {
return cljs$core$ICounted$_count$dyn_14306(coll);
}
});


/**
 * Protocol for creating an empty collection.
 * @interface
 */
cljs.core.IEmptyableCollection = function(){};

var cljs$core$IEmptyableCollection$_empty$dyn_14308 = (function cljs$core$fn_14307(coll){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._empty[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10334__auto__.call(null,coll));
} else {
var m__10332__auto__ = (cljs.core._empty["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10332__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEmptyableCollection.-empty",coll);
}
}
});
/**
 * Returns an empty collection of the same category as coll. Used
 *   by cljs.core/empty.
 */
cljs.core._empty = (function cljs$core$_empty(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IEmptyableCollection$_empty$arity$1 == null)))))){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else {
return cljs$core$IEmptyableCollection$_empty$dyn_14308(coll);
}
});


/**
 * Protocol for adding to a collection.
 * @interface
 */
cljs.core.ICollection = function(){};

var cljs$core$ICollection$_conj$dyn_14310 = (function cljs$core$fn_14309(coll,o){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._conj[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__10334__auto__.call(null,coll,o));
} else {
var m__10332__auto__ = (cljs.core._conj["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__10332__auto__.call(null,coll,o));
} else {
throw cljs.core.missing_protocol("ICollection.-conj",coll);
}
}
});
/**
 * Returns a new collection of coll with o added to it. The new item
 *   should be added to the most efficient place, e.g.
 *   (conj [1 2 3 4] 5) => [1 2 3 4 5]
 *   (conj '(2 3 4 5) 1) => '(1 2 3 4 5)
 */
cljs.core._conj = (function cljs$core$_conj(coll,o){
if((((!((coll == null)))) && ((!((coll.cljs$core$ICollection$_conj$arity$2 == null)))))){
return coll.cljs$core$ICollection$_conj$arity$2(coll,o);
} else {
return cljs$core$ICollection$_conj$dyn_14310(coll,o);
}
});


/**
 * Protocol for collections to provide indexed-based access to their items.
 * @interface
 */
cljs.core.IIndexed = function(){};

var cljs$core$IIndexed$_nth$dyn_14316 = (function() {
var cljs$core$fn_14311 = null;
var cljs$core$fn_14311__2 = (function (coll,n){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._nth[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__10334__auto__.call(null,coll,n));
} else {
var m__10332__auto__ = (cljs.core._nth["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__10332__auto__.call(null,coll,n));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
});
var cljs$core$fn_14311__3 = (function (coll,n,not_found){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._nth[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__10334__auto__.call(null,coll,n,not_found));
} else {
var m__10332__auto__ = (cljs.core._nth["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__10332__auto__.call(null,coll,n,not_found));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
});
cljs$core$fn_14311 = function(coll,n,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_14311__2.call(this,coll,n);
case 3:
return cljs$core$fn_14311__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14311.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14311__2;
cljs$core$fn_14311.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14311__3;
return cljs$core$fn_14311;
})()
;
/**
 * Returns the value at the index n in the collection coll.
 *   Returns not-found if index n is out of bounds and not-found is supplied.
 */
cljs.core._nth = (function cljs$core$_nth(var_args){
var G__14313 = arguments.length;
switch (G__14313) {
case 2:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14314(coll,n){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIndexed$_nth$arity$2 == null)))))){
return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else {
return cljs$core$IIndexed$_nth$dyn_14316.cljs$core$IFn$_invoke$arity$2(coll,n);
}
}));

(cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14315(coll,n,not_found){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIndexed$_nth$arity$3 == null)))))){
return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);
} else {
return cljs$core$IIndexed$_nth$dyn_14316.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
}
}));

(cljs.core._nth.cljs$lang$maxFixedArity = 3);



/**
 * Marker protocol indicating an array sequence.
 * @interface
 */
cljs.core.ASeq = function(){};


/**
 * Protocol for collections to provide access to their items as sequences.
 * @interface
 */
cljs.core.ISeq = function(){};

var cljs$core$ISeq$_first$dyn_14320 = (function cljs$core$fn_14318(coll){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._first[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10334__auto__.call(null,coll));
} else {
var m__10332__auto__ = (cljs.core._first["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10332__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-first",coll);
}
}
});
/**
 * Returns the first item in the collection coll. Used by cljs.core/first.
 */
cljs.core._first = (function cljs$core$_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISeq$_first$arity$1 == null)))))){
return coll.cljs$core$ISeq$_first$arity$1(coll);
} else {
return cljs$core$ISeq$_first$dyn_14320(coll);
}
});

var cljs$core$ISeq$_rest$dyn_14321 = (function cljs$core$fn_14319(coll){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._rest[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10334__auto__.call(null,coll));
} else {
var m__10332__auto__ = (cljs.core._rest["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10332__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-rest",coll);
}
}
});
/**
 * Returns a new collection of coll without the first item. It should
 *   always return a seq, e.g.
 *   (rest []) => ()
 *   (rest nil) => ()
 */
cljs.core._rest = (function cljs$core$_rest(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISeq$_rest$arity$1 == null)))))){
return coll.cljs$core$ISeq$_rest$arity$1(coll);
} else {
return cljs$core$ISeq$_rest$dyn_14321(coll);
}
});


/**
 * Protocol for accessing the next items of a collection.
 * @interface
 */
cljs.core.INext = function(){};

var cljs$core$INext$_next$dyn_14323 = (function cljs$core$fn_14322(coll){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._next[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10334__auto__.call(null,coll));
} else {
var m__10332__auto__ = (cljs.core._next["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10332__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("INext.-next",coll);
}
}
});
/**
 * Returns a new collection of coll without the first item. In contrast to
 *   rest, it should return nil if there are no more items, e.g.
 *   (next []) => nil
 *   (next nil) => nil
 */
cljs.core._next = (function cljs$core$_next(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$INext$_next$arity$1 == null)))))){
return coll.cljs$core$INext$_next$arity$1(coll);
} else {
return cljs$core$INext$_next$dyn_14323(coll);
}
});


/**
 * Protocol for looking up a value in a data structure.
 * @interface
 */
cljs.core.ILookup = function(){};

var cljs$core$ILookup$_lookup$dyn_14329 = (function() {
var cljs$core$fn_14324 = null;
var cljs$core$fn_14324__2 = (function (o,k){
var x__10333__auto__ = (((o == null))?null:o);
var m__10334__auto__ = (cljs.core._lookup[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__10334__auto__.call(null,o,k));
} else {
var m__10332__auto__ = (cljs.core._lookup["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__10332__auto__.call(null,o,k));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
});
var cljs$core$fn_14324__3 = (function (o,k,not_found){
var x__10333__auto__ = (((o == null))?null:o);
var m__10334__auto__ = (cljs.core._lookup[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__10334__auto__.call(null,o,k,not_found));
} else {
var m__10332__auto__ = (cljs.core._lookup["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__10332__auto__.call(null,o,k,not_found));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
});
cljs$core$fn_14324 = function(o,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_14324__2.call(this,o,k);
case 3:
return cljs$core$fn_14324__3.call(this,o,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14324.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14324__2;
cljs$core$fn_14324.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14324__3;
return cljs$core$fn_14324;
})()
;
/**
 * Use k to look up a value in o. If not-found is supplied and k is not
 *   a valid value that can be used for look up, not-found is returned.
 */
cljs.core._lookup = (function cljs$core$_lookup(var_args){
var G__14326 = arguments.length;
switch (G__14326) {
case 2:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14327(o,k){
if((((!((o == null)))) && ((!((o.cljs$core$ILookup$_lookup$arity$2 == null)))))){
return o.cljs$core$ILookup$_lookup$arity$2(o,k);
} else {
return cljs$core$ILookup$_lookup$dyn_14329.cljs$core$IFn$_invoke$arity$2(o,k);
}
}));

(cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14328(o,k,not_found){
if((((!((o == null)))) && ((!((o.cljs$core$ILookup$_lookup$arity$3 == null)))))){
return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);
} else {
return cljs$core$ILookup$_lookup$dyn_14329.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
}
}));

(cljs.core._lookup.cljs$lang$maxFixedArity = 3);



/**
 * Protocol for adding associativity to collections.
 * @interface
 */
cljs.core.IAssociative = function(){};

var cljs$core$IAssociative$_contains_key_QMARK_$dyn_14333 = (function cljs$core$fn_14331(coll,k){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._contains_key_QMARK_[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10334__auto__.call(null,coll,k));
} else {
var m__10332__auto__ = (cljs.core._contains_key_QMARK_["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10332__auto__.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IAssociative.-contains-key?",coll);
}
}
});
/**
 * Returns true if k is a key in coll.
 */
cljs.core._contains_key_QMARK_ = (function cljs$core$_contains_key_QMARK_(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 == null)))))){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);
} else {
return cljs$core$IAssociative$_contains_key_QMARK_$dyn_14333(coll,k);
}
});

var cljs$core$IAssociative$_assoc$dyn_14334 = (function cljs$core$fn_14332(coll,k,v){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._assoc[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__10334__auto__.call(null,coll,k,v));
} else {
var m__10332__auto__ = (cljs.core._assoc["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__10332__auto__.call(null,coll,k,v));
} else {
throw cljs.core.missing_protocol("IAssociative.-assoc",coll);
}
}
});
/**
 * Returns a new collection of coll with a mapping from key k to
 *   value v added to it.
 */
cljs.core._assoc = (function cljs$core$_assoc(coll,k,v){
if((((!((coll == null)))) && ((!((coll.cljs$core$IAssociative$_assoc$arity$3 == null)))))){
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);
} else {
return cljs$core$IAssociative$_assoc$dyn_14334(coll,k,v);
}
});


/**
 * Protocol for implementing entry finding in collections.
 * @interface
 */
cljs.core.IFind = function(){};

var cljs$core$IFind$_find$dyn_14336 = (function cljs$core$fn_14335(coll,k){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._find[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10334__auto__.call(null,coll,k));
} else {
var m__10332__auto__ = (cljs.core._find["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10332__auto__.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IFind.-find",coll);
}
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core._find = (function cljs$core$_find(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IFind$_find$arity$2 == null)))))){
return coll.cljs$core$IFind$_find$arity$2(coll,k);
} else {
return cljs$core$IFind$_find$dyn_14336(coll,k);
}
});


/**
 * Protocol for adding mapping functionality to collections.
 * @interface
 */
cljs.core.IMap = function(){};

var cljs$core$IMap$_dissoc$dyn_14338 = (function cljs$core$fn_14337(coll,k){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._dissoc[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10334__auto__.call(null,coll,k));
} else {
var m__10332__auto__ = (cljs.core._dissoc["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10332__auto__.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IMap.-dissoc",coll);
}
}
});
/**
 * Returns a new collection of coll without the mapping for key k.
 */
cljs.core._dissoc = (function cljs$core$_dissoc(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMap$_dissoc$arity$2 == null)))))){
return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);
} else {
return cljs$core$IMap$_dissoc$dyn_14338(coll,k);
}
});


/**
 * Protocol for examining a map entry.
 * @interface
 */
cljs.core.IMapEntry = function(){};

var cljs$core$IMapEntry$_key$dyn_14341 = (function cljs$core$fn_14339(coll){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._key[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10334__auto__.call(null,coll));
} else {
var m__10332__auto__ = (cljs.core._key["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10332__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-key",coll);
}
}
});
/**
 * Returns the key of the map entry.
 */
cljs.core._key = (function cljs$core$_key(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMapEntry$_key$arity$1 == null)))))){
return coll.cljs$core$IMapEntry$_key$arity$1(coll);
} else {
return cljs$core$IMapEntry$_key$dyn_14341(coll);
}
});

var cljs$core$IMapEntry$_val$dyn_14342 = (function cljs$core$fn_14340(coll){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._val[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10334__auto__.call(null,coll));
} else {
var m__10332__auto__ = (cljs.core._val["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10332__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-val",coll);
}
}
});
/**
 * Returns the value of the map entry.
 */
cljs.core._val = (function cljs$core$_val(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMapEntry$_val$arity$1 == null)))))){
return coll.cljs$core$IMapEntry$_val$arity$1(coll);
} else {
return cljs$core$IMapEntry$_val$dyn_14342(coll);
}
});


/**
 * Protocol for adding set functionality to a collection.
 * @interface
 */
cljs.core.ISet = function(){};

var cljs$core$ISet$_disjoin$dyn_14344 = (function cljs$core$fn_14343(coll,v){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._disjoin[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__10334__auto__.call(null,coll,v));
} else {
var m__10332__auto__ = (cljs.core._disjoin["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__10332__auto__.call(null,coll,v));
} else {
throw cljs.core.missing_protocol("ISet.-disjoin",coll);
}
}
});
/**
 * Returns a new collection of coll that does not contain v.
 */
cljs.core._disjoin = (function cljs$core$_disjoin(coll,v){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISet$_disjoin$arity$2 == null)))))){
return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);
} else {
return cljs$core$ISet$_disjoin$dyn_14344(coll,v);
}
});


/**
 * Protocol for collections to provide access to their items as stacks. The top
 *   of the stack should be accessed in the most efficient way for the different
 *   data structures.
 * @interface
 */
cljs.core.IStack = function(){};

var cljs$core$IStack$_peek$dyn_14347 = (function cljs$core$fn_14345(coll){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._peek[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10334__auto__.call(null,coll));
} else {
var m__10332__auto__ = (cljs.core._peek["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10332__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-peek",coll);
}
}
});
/**
 * Returns the item from the top of the stack. Is used by cljs.core/peek.
 */
cljs.core._peek = (function cljs$core$_peek(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IStack$_peek$arity$1 == null)))))){
return coll.cljs$core$IStack$_peek$arity$1(coll);
} else {
return cljs$core$IStack$_peek$dyn_14347(coll);
}
});

var cljs$core$IStack$_pop$dyn_14348 = (function cljs$core$fn_14346(coll){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._pop[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10334__auto__.call(null,coll));
} else {
var m__10332__auto__ = (cljs.core._pop["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10332__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-pop",coll);
}
}
});
/**
 * Returns a new stack without the item on top of the stack. Is used
 *   by cljs.core/pop.
 */
cljs.core._pop = (function cljs$core$_pop(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IStack$_pop$arity$1 == null)))))){
return coll.cljs$core$IStack$_pop$arity$1(coll);
} else {
return cljs$core$IStack$_pop$dyn_14348(coll);
}
});


/**
 * Protocol for adding vector functionality to collections.
 * @interface
 */
cljs.core.IVector = function(){};

var cljs$core$IVector$_assoc_n$dyn_14350 = (function cljs$core$fn_14349(coll,n,val){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._assoc_n[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__10334__auto__.call(null,coll,n,val));
} else {
var m__10332__auto__ = (cljs.core._assoc_n["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__10332__auto__.call(null,coll,n,val));
} else {
throw cljs.core.missing_protocol("IVector.-assoc-n",coll);
}
}
});
/**
 * Returns a new vector with value val added at position n.
 */
cljs.core._assoc_n = (function cljs$core$_assoc_n(coll,n,val){
if((((!((coll == null)))) && ((!((coll.cljs$core$IVector$_assoc_n$arity$3 == null)))))){
return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);
} else {
return cljs$core$IVector$_assoc_n$dyn_14350(coll,n,val);
}
});


/**
 * Protocol for adding dereference functionality to a reference.
 * @interface
 */
cljs.core.IDeref = function(){};

var cljs$core$IDeref$_deref$dyn_14352 = (function cljs$core$fn_14351(o){
var x__10333__auto__ = (((o == null))?null:o);
var m__10334__auto__ = (cljs.core._deref[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10334__auto__.call(null,o));
} else {
var m__10332__auto__ = (cljs.core._deref["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10332__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("IDeref.-deref",o);
}
}
});
/**
 * Returns the value of the reference o.
 */
cljs.core._deref = (function cljs$core$_deref(o){
if((((!((o == null)))) && ((!((o.cljs$core$IDeref$_deref$arity$1 == null)))))){
return o.cljs$core$IDeref$_deref$arity$1(o);
} else {
return cljs$core$IDeref$_deref$dyn_14352(o);
}
});


/**
 * @interface
 */
cljs.core.IDerefWithTimeout = function(){};

var cljs$core$IDerefWithTimeout$_deref_with_timeout$dyn_14354 = (function cljs$core$fn_14353(o,msec,timeout_val){
var x__10333__auto__ = (((o == null))?null:o);
var m__10334__auto__ = (cljs.core._deref_with_timeout[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__10334__auto__.call(null,o,msec,timeout_val));
} else {
var m__10332__auto__ = (cljs.core._deref_with_timeout["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__10332__auto__.call(null,o,msec,timeout_val));
} else {
throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout",o);
}
}
});
cljs.core._deref_with_timeout = (function cljs$core$_deref_with_timeout(o,msec,timeout_val){
if((((!((o == null)))) && ((!((o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3 == null)))))){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);
} else {
return cljs$core$IDerefWithTimeout$_deref_with_timeout$dyn_14354(o,msec,timeout_val);
}
});


/**
 * Protocol for accessing the metadata of an object.
 * @interface
 */
cljs.core.IMeta = function(){};

var cljs$core$IMeta$_meta$dyn_14356 = (function cljs$core$fn_14355(o){
var x__10333__auto__ = (((o == null))?null:o);
var m__10334__auto__ = (cljs.core._meta[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10334__auto__.call(null,o));
} else {
var m__10332__auto__ = (cljs.core._meta["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10332__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("IMeta.-meta",o);
}
}
});
/**
 * Returns the metadata of object o.
 */
cljs.core._meta = (function cljs$core$_meta(o){
if((((!((o == null)))) && ((!((o.cljs$core$IMeta$_meta$arity$1 == null)))))){
return o.cljs$core$IMeta$_meta$arity$1(o);
} else {
return cljs$core$IMeta$_meta$dyn_14356(o);
}
});


/**
 * Protocol for adding metadata to an object.
 * @interface
 */
cljs.core.IWithMeta = function(){};

var cljs$core$IWithMeta$_with_meta$dyn_14358 = (function cljs$core$fn_14357(o,meta){
var x__10333__auto__ = (((o == null))?null:o);
var m__10334__auto__ = (cljs.core._with_meta[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__10334__auto__.call(null,o,meta));
} else {
var m__10332__auto__ = (cljs.core._with_meta["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__10332__auto__.call(null,o,meta));
} else {
throw cljs.core.missing_protocol("IWithMeta.-with-meta",o);
}
}
});
/**
 * Returns a new object with value of o and metadata meta added to it.
 */
cljs.core._with_meta = (function cljs$core$_with_meta(o,meta){
if((((!((o == null)))) && ((!((o.cljs$core$IWithMeta$_with_meta$arity$2 == null)))))){
return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);
} else {
return cljs$core$IWithMeta$_with_meta$dyn_14358(o,meta);
}
});


/**
 * Protocol for seq types that can reduce themselves.
 *   Called by cljs.core/reduce.
 * @interface
 */
cljs.core.IReduce = function(){};

var cljs$core$IReduce$_reduce$dyn_14364 = (function() {
var cljs$core$fn_14359 = null;
var cljs$core$fn_14359__2 = (function (coll,f){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._reduce[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__10334__auto__.call(null,coll,f));
} else {
var m__10332__auto__ = (cljs.core._reduce["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__10332__auto__.call(null,coll,f));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
});
var cljs$core$fn_14359__3 = (function (coll,f,start){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._reduce[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__10334__auto__.call(null,coll,f,start));
} else {
var m__10332__auto__ = (cljs.core._reduce["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__10332__auto__.call(null,coll,f,start));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
});
cljs$core$fn_14359 = function(coll,f,start){
switch(arguments.length){
case 2:
return cljs$core$fn_14359__2.call(this,coll,f);
case 3:
return cljs$core$fn_14359__3.call(this,coll,f,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14359.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14359__2;
cljs$core$fn_14359.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14359__3;
return cljs$core$fn_14359;
})()
;
/**
 * f should be a function of 2 arguments. If start is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc.
 */
cljs.core._reduce = (function cljs$core$_reduce(var_args){
var G__14361 = arguments.length;
switch (G__14361) {
case 2:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14362(coll,f){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReduce$_reduce$arity$2 == null)))))){
return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);
} else {
return cljs$core$IReduce$_reduce$dyn_14364.cljs$core$IFn$_invoke$arity$2(coll,f);
}
}));

(cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14363(coll,f,start){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReduce$_reduce$arity$3 == null)))))){
return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);
} else {
return cljs$core$IReduce$_reduce$dyn_14364.cljs$core$IFn$_invoke$arity$3(coll,f,start);
}
}));

(cljs.core._reduce.cljs$lang$maxFixedArity = 3);



/**
 * Protocol for associative types that can reduce themselves
 *   via a function of key and val. Called by cljs.core/reduce-kv.
 * @interface
 */
cljs.core.IKVReduce = function(){};

var cljs$core$IKVReduce$_kv_reduce$dyn_14367 = (function cljs$core$fn_14366(coll,f,init){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._kv_reduce[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__10334__auto__.call(null,coll,f,init));
} else {
var m__10332__auto__ = (cljs.core._kv_reduce["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__10332__auto__.call(null,coll,f,init));
} else {
throw cljs.core.missing_protocol("IKVReduce.-kv-reduce",coll);
}
}
});
/**
 * Reduces an associative collection and returns the result. f should be
 *   a function that takes three arguments.
 */
cljs.core._kv_reduce = (function cljs$core$_kv_reduce(coll,f,init){
if((((!((coll == null)))) && ((!((coll.cljs$core$IKVReduce$_kv_reduce$arity$3 == null)))))){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);
} else {
return cljs$core$IKVReduce$_kv_reduce$dyn_14367(coll,f,init);
}
});


/**
 * Protocol for adding value comparison functionality to a type.
 * @interface
 */
cljs.core.IEquiv = function(){};

var cljs$core$IEquiv$_equiv$dyn_14369 = (function cljs$core$fn_14368(o,other){
var x__10333__auto__ = (((o == null))?null:o);
var m__10334__auto__ = (cljs.core._equiv[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__10334__auto__.call(null,o,other));
} else {
var m__10332__auto__ = (cljs.core._equiv["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__10332__auto__.call(null,o,other));
} else {
throw cljs.core.missing_protocol("IEquiv.-equiv",o);
}
}
});
/**
 * Returns true if o and other are equal, false otherwise.
 */
cljs.core._equiv = (function cljs$core$_equiv(o,other){
if((((!((o == null)))) && ((!((o.cljs$core$IEquiv$_equiv$arity$2 == null)))))){
return o.cljs$core$IEquiv$_equiv$arity$2(o,other);
} else {
return cljs$core$IEquiv$_equiv$dyn_14369(o,other);
}
});


/**
 * Protocol for adding hashing functionality to a type.
 * @interface
 */
cljs.core.IHash = function(){};

var cljs$core$IHash$_hash$dyn_14371 = (function cljs$core$fn_14370(o){
var x__10333__auto__ = (((o == null))?null:o);
var m__10334__auto__ = (cljs.core._hash[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10334__auto__.call(null,o));
} else {
var m__10332__auto__ = (cljs.core._hash["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10332__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("IHash.-hash",o);
}
}
});
/**
 * Returns the hash code of o.
 */
cljs.core._hash = (function cljs$core$_hash(o){
if((((!((o == null)))) && ((!((o.cljs$core$IHash$_hash$arity$1 == null)))))){
return o.cljs$core$IHash$_hash$arity$1(o);
} else {
return cljs$core$IHash$_hash$dyn_14371(o);
}
});


/**
 * Protocol for adding the ability to a type to be transformed into a sequence.
 * @interface
 */
cljs.core.ISeqable = function(){};

var cljs$core$ISeqable$_seq$dyn_14373 = (function cljs$core$fn_14372(o){
var x__10333__auto__ = (((o == null))?null:o);
var m__10334__auto__ = (cljs.core._seq[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10334__auto__.call(null,o));
} else {
var m__10332__auto__ = (cljs.core._seq["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10332__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("ISeqable.-seq",o);
}
}
});
/**
 * Returns a seq of o, or nil if o is empty.
 */
cljs.core._seq = (function cljs$core$_seq(o){
if((((!((o == null)))) && ((!((o.cljs$core$ISeqable$_seq$arity$1 == null)))))){
return o.cljs$core$ISeqable$_seq$arity$1(o);
} else {
return cljs$core$ISeqable$_seq$dyn_14373(o);
}
});


/**
 * Marker interface indicating a persistent collection of sequential items
 * @interface
 */
cljs.core.ISequential = function(){};


/**
 * Marker interface indicating a persistent list
 * @interface
 */
cljs.core.IList = function(){};


/**
 * Marker interface indicating a record object
 * @interface
 */
cljs.core.IRecord = function(){};


/**
 * Protocol for reversing a seq.
 * @interface
 */
cljs.core.IReversible = function(){};

var cljs$core$IReversible$_rseq$dyn_14375 = (function cljs$core$fn_14374(coll){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._rseq[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10334__auto__.call(null,coll));
} else {
var m__10332__auto__ = (cljs.core._rseq["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10332__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IReversible.-rseq",coll);
}
}
});
/**
 * Returns a seq of the items in coll in reversed order.
 */
cljs.core._rseq = (function cljs$core$_rseq(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReversible$_rseq$arity$1 == null)))))){
return coll.cljs$core$IReversible$_rseq$arity$1(coll);
} else {
return cljs$core$IReversible$_rseq$dyn_14375(coll);
}
});


/**
 * Protocol for a collection which can represent their items
 *   in a sorted manner. 
 * @interface
 */
cljs.core.ISorted = function(){};

var cljs$core$ISorted$_sorted_seq$dyn_14380 = (function cljs$core$fn_14376(coll,ascending_QMARK_){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._sorted_seq[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__10334__auto__.call(null,coll,ascending_QMARK_));
} else {
var m__10332__auto__ = (cljs.core._sorted_seq["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__10332__auto__.call(null,coll,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq",coll);
}
}
});
/**
 * Returns a sorted seq from coll in either ascending or descending order.
 */
cljs.core._sorted_seq = (function cljs$core$_sorted_seq(coll,ascending_QMARK_){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_sorted_seq$arity$2 == null)))))){
return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);
} else {
return cljs$core$ISorted$_sorted_seq$dyn_14380(coll,ascending_QMARK_);
}
});

var cljs$core$ISorted$_sorted_seq_from$dyn_14381 = (function cljs$core$fn_14377(coll,k,ascending_QMARK_){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._sorted_seq_from[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__10334__auto__.call(null,coll,k,ascending_QMARK_));
} else {
var m__10332__auto__ = (cljs.core._sorted_seq_from["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__10332__auto__.call(null,coll,k,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq-from",coll);
}
}
});
/**
 * Returns a sorted seq from coll in either ascending or descending order.
 *   If ascending is true, the result should contain all items which are > or >=
 *   than k. If ascending is false, the result should contain all items which
 *   are < or <= than k, e.g.
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)
 */
cljs.core._sorted_seq_from = (function cljs$core$_sorted_seq_from(coll,k,ascending_QMARK_){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_sorted_seq_from$arity$3 == null)))))){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);
} else {
return cljs$core$ISorted$_sorted_seq_from$dyn_14381(coll,k,ascending_QMARK_);
}
});

var cljs$core$ISorted$_entry_key$dyn_14382 = (function cljs$core$fn_14378(coll,entry){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._entry_key[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__10334__auto__.call(null,coll,entry));
} else {
var m__10332__auto__ = (cljs.core._entry_key["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__10332__auto__.call(null,coll,entry));
} else {
throw cljs.core.missing_protocol("ISorted.-entry-key",coll);
}
}
});
/**
 * Returns the key for entry.
 */
cljs.core._entry_key = (function cljs$core$_entry_key(coll,entry){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_entry_key$arity$2 == null)))))){
return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);
} else {
return cljs$core$ISorted$_entry_key$dyn_14382(coll,entry);
}
});

var cljs$core$ISorted$_comparator$dyn_14383 = (function cljs$core$fn_14379(coll){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._comparator[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10334__auto__.call(null,coll));
} else {
var m__10332__auto__ = (cljs.core._comparator["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10332__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISorted.-comparator",coll);
}
}
});
/**
 * Returns the comparator for coll.
 */
cljs.core._comparator = (function cljs$core$_comparator(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_comparator$arity$1 == null)))))){
return coll.cljs$core$ISorted$_comparator$arity$1(coll);
} else {
return cljs$core$ISorted$_comparator$dyn_14383(coll);
}
});


/**
 * Protocol for writing. Currently only implemented by StringBufferWriter.
 * @interface
 */
cljs.core.IWriter = function(){};

var cljs$core$IWriter$_write$dyn_14386 = (function cljs$core$fn_14384(writer,s){
var x__10333__auto__ = (((writer == null))?null:writer);
var m__10334__auto__ = (cljs.core._write[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__10334__auto__.call(null,writer,s));
} else {
var m__10332__auto__ = (cljs.core._write["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__10332__auto__.call(null,writer,s));
} else {
throw cljs.core.missing_protocol("IWriter.-write",writer);
}
}
});
/**
 * Writes s with writer and returns the result.
 */
cljs.core._write = (function cljs$core$_write(writer,s){
if((((!((writer == null)))) && ((!((writer.cljs$core$IWriter$_write$arity$2 == null)))))){
return writer.cljs$core$IWriter$_write$arity$2(writer,s);
} else {
return cljs$core$IWriter$_write$dyn_14386(writer,s);
}
});

var cljs$core$IWriter$_flush$dyn_14387 = (function cljs$core$fn_14385(writer){
var x__10333__auto__ = (((writer == null))?null:writer);
var m__10334__auto__ = (cljs.core._flush[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__10334__auto__.call(null,writer));
} else {
var m__10332__auto__ = (cljs.core._flush["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__10332__auto__.call(null,writer));
} else {
throw cljs.core.missing_protocol("IWriter.-flush",writer);
}
}
});
/**
 * Flush writer.
 */
cljs.core._flush = (function cljs$core$_flush(writer){
if((((!((writer == null)))) && ((!((writer.cljs$core$IWriter$_flush$arity$1 == null)))))){
return writer.cljs$core$IWriter$_flush$arity$1(writer);
} else {
return cljs$core$IWriter$_flush$dyn_14387(writer);
}
});


/**
 * The old IPrintable protocol's implementation consisted of building a giant
 * list of strings to concatenate.  This involved lots of concat calls,
 * intermediate vectors, and lazy-seqs, and was very slow in some older JS
 * engines.  IPrintWithWriter implements printing via the IWriter protocol, so it
 * be implemented efficiently in terms of e.g. a StringBuffer append.
 * @interface
 */
cljs.core.IPrintWithWriter = function(){};

var cljs$core$IPrintWithWriter$_pr_writer$dyn_14389 = (function cljs$core$fn_14388(o,writer,opts){
var x__10333__auto__ = (((o == null))?null:o);
var m__10334__auto__ = (cljs.core._pr_writer[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__10334__auto__.call(null,o,writer,opts));
} else {
var m__10332__auto__ = (cljs.core._pr_writer["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__10332__auto__.call(null,o,writer,opts));
} else {
throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer",o);
}
}
});
cljs.core._pr_writer = (function cljs$core$_pr_writer(o,writer,opts){
if((((!((o == null)))) && ((!((o.cljs$core$IPrintWithWriter$_pr_writer$arity$3 == null)))))){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);
} else {
return cljs$core$IPrintWithWriter$_pr_writer$dyn_14389(o,writer,opts);
}
});


/**
 * Protocol for types which can have a deferred realization. Currently only
 *   implemented by Delay and LazySeq.
 * @interface
 */
cljs.core.IPending = function(){};

var cljs$core$IPending$_realized_QMARK_$dyn_14391 = (function cljs$core$fn_14390(x){
var x__10333__auto__ = (((x == null))?null:x);
var m__10334__auto__ = (cljs.core._realized_QMARK_[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10334__auto__.call(null,x));
} else {
var m__10332__auto__ = (cljs.core._realized_QMARK_["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10332__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("IPending.-realized?",x);
}
}
});
/**
 * Returns true if a value for x has been produced, false otherwise.
 */
cljs.core._realized_QMARK_ = (function cljs$core$_realized_QMARK_(x){
if((((!((x == null)))) && ((!((x.cljs$core$IPending$_realized_QMARK_$arity$1 == null)))))){
return x.cljs$core$IPending$_realized_QMARK_$arity$1(x);
} else {
return cljs$core$IPending$_realized_QMARK_$dyn_14391(x);
}
});


/**
 * Protocol for types that can be watched. Currently only implemented by Atom.
 * @interface
 */
cljs.core.IWatchable = function(){};

var cljs$core$IWatchable$_notify_watches$dyn_14395 = (function cljs$core$fn_14392(this$,oldval,newval){
var x__10333__auto__ = (((this$ == null))?null:this$);
var m__10334__auto__ = (cljs.core._notify_watches[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__10334__auto__.call(null,this$,oldval,newval));
} else {
var m__10332__auto__ = (cljs.core._notify_watches["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__10332__auto__.call(null,this$,oldval,newval));
} else {
throw cljs.core.missing_protocol("IWatchable.-notify-watches",this$);
}
}
});
/**
 * Calls all watchers with this, oldval and newval.
 */
cljs.core._notify_watches = (function cljs$core$_notify_watches(this$,oldval,newval){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_notify_watches$arity$3 == null)))))){
return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);
} else {
return cljs$core$IWatchable$_notify_watches$dyn_14395(this$,oldval,newval);
}
});

var cljs$core$IWatchable$_add_watch$dyn_14396 = (function cljs$core$fn_14393(this$,key,f){
var x__10333__auto__ = (((this$ == null))?null:this$);
var m__10334__auto__ = (cljs.core._add_watch[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__10334__auto__.call(null,this$,key,f));
} else {
var m__10332__auto__ = (cljs.core._add_watch["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__10332__auto__.call(null,this$,key,f));
} else {
throw cljs.core.missing_protocol("IWatchable.-add-watch",this$);
}
}
});
/**
 * Adds a watcher function f to this. Keys must be unique per reference,
 *   and can be used to remove the watch with -remove-watch.
 */
cljs.core._add_watch = (function cljs$core$_add_watch(this$,key,f){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_add_watch$arity$3 == null)))))){
return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);
} else {
return cljs$core$IWatchable$_add_watch$dyn_14396(this$,key,f);
}
});

var cljs$core$IWatchable$_remove_watch$dyn_14397 = (function cljs$core$fn_14394(this$,key){
var x__10333__auto__ = (((this$ == null))?null:this$);
var m__10334__auto__ = (cljs.core._remove_watch[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__10334__auto__.call(null,this$,key));
} else {
var m__10332__auto__ = (cljs.core._remove_watch["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__10332__auto__.call(null,this$,key));
} else {
throw cljs.core.missing_protocol("IWatchable.-remove-watch",this$);
}
}
});
/**
 * Removes watcher that corresponds to key from this.
 */
cljs.core._remove_watch = (function cljs$core$_remove_watch(this$,key){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_remove_watch$arity$2 == null)))))){
return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);
} else {
return cljs$core$IWatchable$_remove_watch$dyn_14397(this$,key);
}
});


/**
 * Protocol for collections which can transformed to transients.
 * @interface
 */
cljs.core.IEditableCollection = function(){};

var cljs$core$IEditableCollection$_as_transient$dyn_14399 = (function cljs$core$fn_14398(coll){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._as_transient[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10334__auto__.call(null,coll));
} else {
var m__10332__auto__ = (cljs.core._as_transient["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10332__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEditableCollection.-as-transient",coll);
}
}
});
/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core._as_transient = (function cljs$core$_as_transient(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IEditableCollection$_as_transient$arity$1 == null)))))){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
} else {
return cljs$core$IEditableCollection$_as_transient$dyn_14399(coll);
}
});


/**
 * Protocol for adding basic functionality to transient collections.
 * @interface
 */
cljs.core.ITransientCollection = function(){};

var cljs$core$ITransientCollection$_conj_BANG_$dyn_14402 = (function cljs$core$fn_14400(tcoll,val){
var x__10333__auto__ = (((tcoll == null))?null:tcoll);
var m__10334__auto__ = (cljs.core._conj_BANG_[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__10334__auto__.call(null,tcoll,val));
} else {
var m__10332__auto__ = (cljs.core._conj_BANG_["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__10332__auto__.call(null,tcoll,val));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-conj!",tcoll);
}
}
});
/**
 * Adds value val to tcoll and returns tcoll.
 */
cljs.core._conj_BANG_ = (function cljs$core$_conj_BANG_(tcoll,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else {
return cljs$core$ITransientCollection$_conj_BANG_$dyn_14402(tcoll,val);
}
});

var cljs$core$ITransientCollection$_persistent_BANG_$dyn_14403 = (function cljs$core$fn_14401(tcoll){
var x__10333__auto__ = (((tcoll == null))?null:tcoll);
var m__10334__auto__ = (cljs.core._persistent_BANG_[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__10334__auto__.call(null,tcoll));
} else {
var m__10332__auto__ = (cljs.core._persistent_BANG_["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__10332__auto__.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-persistent!",tcoll);
}
}
});
/**
 * Creates a persistent data structure from tcoll and returns it.
 */
cljs.core._persistent_BANG_ = (function cljs$core$_persistent_BANG_(tcoll){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 == null)))))){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
} else {
return cljs$core$ITransientCollection$_persistent_BANG_$dyn_14403(tcoll);
}
});


/**
 * Protocol for adding associativity to transient collections.
 * @interface
 */
cljs.core.ITransientAssociative = function(){};

var cljs$core$ITransientAssociative$_assoc_BANG_$dyn_14405 = (function cljs$core$fn_14404(tcoll,key,val){
var x__10333__auto__ = (((tcoll == null))?null:tcoll);
var m__10334__auto__ = (cljs.core._assoc_BANG_[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__10334__auto__.call(null,tcoll,key,val));
} else {
var m__10332__auto__ = (cljs.core._assoc_BANG_["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__10332__auto__.call(null,tcoll,key,val));
} else {
throw cljs.core.missing_protocol("ITransientAssociative.-assoc!",tcoll);
}
}
});
/**
 * Returns a new transient collection of tcoll with a mapping from key to
 *   val added to it.
 */
cljs.core._assoc_BANG_ = (function cljs$core$_assoc_BANG_(tcoll,key,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 == null)))))){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);
} else {
return cljs$core$ITransientAssociative$_assoc_BANG_$dyn_14405(tcoll,key,val);
}
});


/**
 * Protocol for adding mapping functionality to transient collections.
 * @interface
 */
cljs.core.ITransientMap = function(){};

var cljs$core$ITransientMap$_dissoc_BANG_$dyn_14407 = (function cljs$core$fn_14406(tcoll,key){
var x__10333__auto__ = (((tcoll == null))?null:tcoll);
var m__10334__auto__ = (cljs.core._dissoc_BANG_[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__10334__auto__.call(null,tcoll,key));
} else {
var m__10332__auto__ = (cljs.core._dissoc_BANG_["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__10332__auto__.call(null,tcoll,key));
} else {
throw cljs.core.missing_protocol("ITransientMap.-dissoc!",tcoll);
}
}
});
/**
 * Returns a new transient collection of tcoll without the mapping for key.
 */
cljs.core._dissoc_BANG_ = (function cljs$core$_dissoc_BANG_(tcoll,key){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);
} else {
return cljs$core$ITransientMap$_dissoc_BANG_$dyn_14407(tcoll,key);
}
});


/**
 * Protocol for adding vector functionality to transient collections.
 * @interface
 */
cljs.core.ITransientVector = function(){};

var cljs$core$ITransientVector$_assoc_n_BANG_$dyn_14410 = (function cljs$core$fn_14408(tcoll,n,val){
var x__10333__auto__ = (((tcoll == null))?null:tcoll);
var m__10334__auto__ = (cljs.core._assoc_n_BANG_[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__10334__auto__.call(null,tcoll,n,val));
} else {
var m__10332__auto__ = (cljs.core._assoc_n_BANG_["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__10332__auto__.call(null,tcoll,n,val));
} else {
throw cljs.core.missing_protocol("ITransientVector.-assoc-n!",tcoll);
}
}
});
/**
 * Returns tcoll with value val added at position n.
 */
cljs.core._assoc_n_BANG_ = (function cljs$core$_assoc_n_BANG_(tcoll,n,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 == null)))))){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);
} else {
return cljs$core$ITransientVector$_assoc_n_BANG_$dyn_14410(tcoll,n,val);
}
});

var cljs$core$ITransientVector$_pop_BANG_$dyn_14411 = (function cljs$core$fn_14409(tcoll){
var x__10333__auto__ = (((tcoll == null))?null:tcoll);
var m__10334__auto__ = (cljs.core._pop_BANG_[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__10334__auto__.call(null,tcoll));
} else {
var m__10332__auto__ = (cljs.core._pop_BANG_["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__10332__auto__.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientVector.-pop!",tcoll);
}
}
});
/**
 * Returns tcoll with the last item removed from it.
 */
cljs.core._pop_BANG_ = (function cljs$core$_pop_BANG_(tcoll){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1 == null)))))){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
} else {
return cljs$core$ITransientVector$_pop_BANG_$dyn_14411(tcoll);
}
});


/**
 * Protocol for adding set functionality to a transient collection.
 * @interface
 */
cljs.core.ITransientSet = function(){};

var cljs$core$ITransientSet$_disjoin_BANG_$dyn_14413 = (function cljs$core$fn_14412(tcoll,v){
var x__10333__auto__ = (((tcoll == null))?null:tcoll);
var m__10334__auto__ = (cljs.core._disjoin_BANG_[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__10334__auto__.call(null,tcoll,v));
} else {
var m__10332__auto__ = (cljs.core._disjoin_BANG_["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__10332__auto__.call(null,tcoll,v));
} else {
throw cljs.core.missing_protocol("ITransientSet.-disjoin!",tcoll);
}
}
});
/**
 * Returns tcoll without v.
 */
cljs.core._disjoin_BANG_ = (function cljs$core$_disjoin_BANG_(tcoll,v){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);
} else {
return cljs$core$ITransientSet$_disjoin_BANG_$dyn_14413(tcoll,v);
}
});


/**
 * Protocol for values that can be compared.
 * @interface
 */
cljs.core.IComparable = function(){};

var cljs$core$IComparable$_compare$dyn_14415 = (function cljs$core$fn_14414(x,y){
var x__10333__auto__ = (((x == null))?null:x);
var m__10334__auto__ = (cljs.core._compare[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__10334__auto__.call(null,x,y));
} else {
var m__10332__auto__ = (cljs.core._compare["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__10332__auto__.call(null,x,y));
} else {
throw cljs.core.missing_protocol("IComparable.-compare",x);
}
}
});
/**
 * Returns a negative number, zero, or a positive number when x is logically
 *   'less than', 'equal to', or 'greater than' y.
 */
cljs.core._compare = (function cljs$core$_compare(x,y){
if((((!((x == null)))) && ((!((x.cljs$core$IComparable$_compare$arity$2 == null)))))){
return x.cljs$core$IComparable$_compare$arity$2(x,y);
} else {
return cljs$core$IComparable$_compare$dyn_14415(x,y);
}
});


/**
 * Protocol for accessing the items of a chunk.
 * @interface
 */
cljs.core.IChunk = function(){};

var cljs$core$IChunk$_drop_first$dyn_14417 = (function cljs$core$fn_14416(coll){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._drop_first[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10334__auto__.call(null,coll));
} else {
var m__10332__auto__ = (cljs.core._drop_first["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10332__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunk.-drop-first",coll);
}
}
});
/**
 * Return a new chunk of coll with the first item removed.
 */
cljs.core._drop_first = (function cljs$core$_drop_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunk$_drop_first$arity$1 == null)))))){
return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
} else {
return cljs$core$IChunk$_drop_first$dyn_14417(coll);
}
});


/**
 * Protocol for accessing a collection as sequential chunks.
 * @interface
 */
cljs.core.IChunkedSeq = function(){};

var cljs$core$IChunkedSeq$_chunked_first$dyn_14420 = (function cljs$core$fn_14418(coll){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._chunked_first[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10334__auto__.call(null,coll));
} else {
var m__10332__auto__ = (cljs.core._chunked_first["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10332__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first",coll);
}
}
});
/**
 * Returns the first chunk in coll.
 */
cljs.core._chunked_first = (function cljs$core$_chunked_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedSeq$_chunked_first$arity$1 == null)))))){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
} else {
return cljs$core$IChunkedSeq$_chunked_first$dyn_14420(coll);
}
});

var cljs$core$IChunkedSeq$_chunked_rest$dyn_14421 = (function cljs$core$fn_14419(coll){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._chunked_rest[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10334__auto__.call(null,coll));
} else {
var m__10332__auto__ = (cljs.core._chunked_rest["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10332__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest",coll);
}
}
});
/**
 * Return a new collection of coll with the first chunk removed.
 */
cljs.core._chunked_rest = (function cljs$core$_chunked_rest(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1 == null)))))){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
} else {
return cljs$core$IChunkedSeq$_chunked_rest$dyn_14421(coll);
}
});


/**
 * Protocol for accessing the chunks of a collection.
 * @interface
 */
cljs.core.IChunkedNext = function(){};

var cljs$core$IChunkedNext$_chunked_next$dyn_14423 = (function cljs$core$fn_14422(coll){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._chunked_next[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10334__auto__.call(null,coll));
} else {
var m__10332__auto__ = (cljs.core._chunked_next["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10332__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedNext.-chunked-next",coll);
}
}
});
/**
 * Returns a new collection of coll without the first chunk.
 */
cljs.core._chunked_next = (function cljs$core$_chunked_next(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedNext$_chunked_next$arity$1 == null)))))){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
} else {
return cljs$core$IChunkedNext$_chunked_next$dyn_14423(coll);
}
});


/**
 * Protocol for adding a name.
 * @interface
 */
cljs.core.INamed = function(){};

var cljs$core$INamed$_name$dyn_14426 = (function cljs$core$fn_14424(x){
var x__10333__auto__ = (((x == null))?null:x);
var m__10334__auto__ = (cljs.core._name[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10334__auto__.call(null,x));
} else {
var m__10332__auto__ = (cljs.core._name["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10332__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-name",x);
}
}
});
/**
 * Returns the name String of x.
 */
cljs.core._name = (function cljs$core$_name(x){
if((((!((x == null)))) && ((!((x.cljs$core$INamed$_name$arity$1 == null)))))){
return x.cljs$core$INamed$_name$arity$1(x);
} else {
return cljs$core$INamed$_name$dyn_14426(x);
}
});

var cljs$core$INamed$_namespace$dyn_14427 = (function cljs$core$fn_14425(x){
var x__10333__auto__ = (((x == null))?null:x);
var m__10334__auto__ = (cljs.core._namespace[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10334__auto__.call(null,x));
} else {
var m__10332__auto__ = (cljs.core._namespace["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10332__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-namespace",x);
}
}
});
/**
 * Returns the namespace String of x.
 */
cljs.core._namespace = (function cljs$core$_namespace(x){
if((((!((x == null)))) && ((!((x.cljs$core$INamed$_namespace$arity$1 == null)))))){
return x.cljs$core$INamed$_namespace$arity$1(x);
} else {
return cljs$core$INamed$_namespace$dyn_14427(x);
}
});


/**
 * Marker protocol indicating an atom.
 * @interface
 */
cljs.core.IAtom = function(){};


/**
 * Protocol for adding resetting functionality.
 * @interface
 */
cljs.core.IReset = function(){};

var cljs$core$IReset$_reset_BANG_$dyn_14429 = (function cljs$core$fn_14428(o,new_value){
var x__10333__auto__ = (((o == null))?null:o);
var m__10334__auto__ = (cljs.core._reset_BANG_[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__10334__auto__.call(null,o,new_value));
} else {
var m__10332__auto__ = (cljs.core._reset_BANG_["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__10332__auto__.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IReset.-reset!",o);
}
}
});
/**
 * Sets the value of o to new-value.
 */
cljs.core._reset_BANG_ = (function cljs$core$_reset_BANG_(o,new_value){
if((((!((o == null)))) && ((!((o.cljs$core$IReset$_reset_BANG_$arity$2 == null)))))){
return o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);
} else {
return cljs$core$IReset$_reset_BANG_$dyn_14429(o,new_value);
}
});


/**
 * Protocol for adding swapping functionality.
 * @interface
 */
cljs.core.ISwap = function(){};

var cljs$core$ISwap$_swap_BANG_$dyn_14437 = (function() {
var cljs$core$fn_14430 = null;
var cljs$core$fn_14430__2 = (function (o,f){
var x__10333__auto__ = (((o == null))?null:o);
var m__10334__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__10334__auto__.call(null,o,f));
} else {
var m__10332__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__10332__auto__.call(null,o,f));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
var cljs$core$fn_14430__3 = (function (o,f,a){
var x__10333__auto__ = (((o == null))?null:o);
var m__10334__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__10334__auto__.call(null,o,f,a));
} else {
var m__10332__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__10332__auto__.call(null,o,f,a));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
var cljs$core$fn_14430__4 = (function (o,f,a,b){
var x__10333__auto__ = (((o == null))?null:o);
var m__10334__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$4 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__10334__auto__.call(null,o,f,a,b));
} else {
var m__10332__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$4 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__10332__auto__.call(null,o,f,a,b));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
var cljs$core$fn_14430__5 = (function (o,f,a,b,xs){
var x__10333__auto__ = (((o == null))?null:o);
var m__10334__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$5 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__10334__auto__.call(null,o,f,a,b,xs));
} else {
var m__10332__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$5 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__10332__auto__.call(null,o,f,a,b,xs));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
cljs$core$fn_14430 = function(o,f,a,b,xs){
switch(arguments.length){
case 2:
return cljs$core$fn_14430__2.call(this,o,f);
case 3:
return cljs$core$fn_14430__3.call(this,o,f,a);
case 4:
return cljs$core$fn_14430__4.call(this,o,f,a,b);
case 5:
return cljs$core$fn_14430__5.call(this,o,f,a,b,xs);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14430.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14430__2;
cljs$core$fn_14430.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14430__3;
cljs$core$fn_14430.cljs$core$IFn$_invoke$arity$4 = cljs$core$fn_14430__4;
cljs$core$fn_14430.cljs$core$IFn$_invoke$arity$5 = cljs$core$fn_14430__5;
return cljs$core$fn_14430;
})()
;
/**
 * Swaps the value of o to be (apply f current-value-of-atom args).
 */
cljs.core._swap_BANG_ = (function cljs$core$_swap_BANG_(var_args){
var G__14432 = arguments.length;
switch (G__14432) {
case 2:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14433(o,f){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$2 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_14437.cljs$core$IFn$_invoke$arity$2(o,f);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14434(o,f,a){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$3 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_14437.cljs$core$IFn$_invoke$arity$3(o,f,a);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14435(o,f,a,b){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$4 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_14437.cljs$core$IFn$_invoke$arity$4(o,f,a,b);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_14436(o,f,a,b,xs){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$5 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_14437.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs);
}
}));

(cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5);



/**
 * Protocol for adding volatile functionality.
 * @interface
 */
cljs.core.IVolatile = function(){};

var cljs$core$IVolatile$_vreset_BANG_$dyn_14440 = (function cljs$core$fn_14439(o,new_value){
var x__10333__auto__ = (((o == null))?null:o);
var m__10334__auto__ = (cljs.core._vreset_BANG_[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__10334__auto__.call(null,o,new_value));
} else {
var m__10332__auto__ = (cljs.core._vreset_BANG_["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__10332__auto__.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IVolatile.-vreset!",o);
}
}
});
/**
 * Sets the value of volatile o to new-value without regard for the
 *   current value. Returns new-value.
 */
cljs.core._vreset_BANG_ = (function cljs$core$_vreset_BANG_(o,new_value){
if((((!((o == null)))) && ((!((o.cljs$core$IVolatile$_vreset_BANG_$arity$2 == null)))))){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);
} else {
return cljs$core$IVolatile$_vreset_BANG_$dyn_14440(o,new_value);
}
});


/**
 * Protocol for iterating over a collection.
 * @interface
 */
cljs.core.IIterable = function(){};

var cljs$core$IIterable$_iterator$dyn_14442 = (function cljs$core$fn_14441(coll){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._iterator[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10334__auto__.call(null,coll));
} else {
var m__10332__auto__ = (cljs.core._iterator["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10332__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IIterable.-iterator",coll);
}
}
});
/**
 * Returns an iterator for coll.
 */
cljs.core._iterator = (function cljs$core$_iterator(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIterable$_iterator$arity$1 == null)))))){
return coll.cljs$core$IIterable$_iterator$arity$1(coll);
} else {
return cljs$core$IIterable$_iterator$dyn_14442(coll);
}
});


/**
 * Protocol for persistent or algorithmically defined collections to provide a
 *   means of dropping N items that is more efficient than sequential walking.
 * @interface
 */
cljs.core.IDrop = function(){};

var cljs$core$IDrop$_drop$dyn_14444 = (function cljs$core$fn_14443(coll,n){
var x__10333__auto__ = (((coll == null))?null:coll);
var m__10334__auto__ = (cljs.core._drop[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__10334__auto__.call(null,coll,n));
} else {
var m__10332__auto__ = (cljs.core._drop["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__10332__auto__.call(null,coll,n));
} else {
throw cljs.core.missing_protocol("IDrop.-drop",coll);
}
}
});
/**
 * Returns a collection that is ISequential, ISeq, and IReduce, or nil if past
 *   the end. The number of items to drop n must be > 0. It is also useful if the
 *   returned coll implements IDrop for subsequent use in a partition-like scenario.
 */
cljs.core._drop = (function cljs$core$_drop(coll,n){
if((((!((coll == null)))) && ((!((coll.cljs$core$IDrop$_drop$arity$2 == null)))))){
return coll.cljs$core$IDrop$_drop$arity$2(coll,n);
} else {
return cljs$core$IDrop$_drop$dyn_14444(coll,n);
}
});


/**
* @constructor
 * @implements {cljs.core.IWriter}
*/
cljs.core.StringBufferWriter = (function (sb){
this.sb = sb;
this.cljs$lang$protocol_mask$partition0$ = 1073741824;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = (function cljs$core$fn_14445(_,s){
var self__ = this;
var ___$1 = this;
return self__.sb.append(s);
}));

(cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = (function cljs$core$fn_14446(_){
var self__ = this;
var ___$1 = this;
return null;
}));

(cljs.core.StringBufferWriter.getBasis = (function cljs$core$fn_14447(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"sb","sb",-1249746442,null)], null);
}));

(cljs.core.StringBufferWriter.cljs$lang$type = true);

(cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter");

(cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = (function cljs$core$fn_14448(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/StringBufferWriter");
}));

/**
 * Positional factory function for cljs.core/StringBufferWriter.
 */
cljs.core.__GT_StringBufferWriter = (function cljs$core$__GT_StringBufferWriter(sb){
return (new cljs.core.StringBufferWriter(sb));
});

/**
 * Support so that collections can implement toString without
 * loading all the printing machinery.
 */
cljs.core.pr_str_STAR_ = (function cljs$core$pr_str_STAR_(obj){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,cljs.core.pr_opts());

writer.cljs$core$IWriter$_flush$arity$1(null);

return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb);
});
cljs.core.int_rotate_left = (function cljs$core$int_rotate_left(x,n){
return ((x << n) | (x >>> (- n)));
});
if((((typeof Math !== 'undefined') && (typeof Math.imul !== 'undefined')) && ((!((Math.imul((4294967295),(5)) === (0))))))){
cljs.core.imul = (function cljs$core$imul(a,b){
return Math.imul(a,b);
});
} else {
cljs.core.imul = (function cljs$core$imul(a,b){
var ah = ((a >>> (16)) & (65535));
var al = (a & (65535));
var bh = ((b >>> (16)) & (65535));
var bl = (b & (65535));
return (((al * bl) + ((((ah * bl) + (al * bh)) << (16)) >>> (0))) | (0));
});
}
cljs.core.m3_seed = (0);
cljs.core.m3_C1 = ((3432918353) | (0));
cljs.core.m3_C2 = ((461845907) | (0));
cljs.core.m3_mix_K1 = (function cljs$core$m3_mix_K1(k1){
return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul((k1 | (0)),cljs.core.m3_C1),(15)),cljs.core.m3_C2);
});
cljs.core.m3_mix_H1 = (function cljs$core$m3_mix_H1(h1,k1){
return ((cljs.core.imul(cljs.core.int_rotate_left(((h1 | (0)) ^ (k1 | (0))),(13)),(5)) + ((3864292196) | (0))) | (0));
});
cljs.core.m3_fmix = (function cljs$core$m3_fmix(h1,len){
var h1__$1 = (h1 | (0));
var h1__$2 = (h1__$1 ^ len);
var h1__$3 = (h1__$2 ^ (h1__$2 >>> (16)));
var h1__$4 = cljs.core.imul(h1__$3,((2246822507) | (0)));
var h1__$5 = (h1__$4 ^ (h1__$4 >>> (13)));
var h1__$6 = cljs.core.imul(h1__$5,((3266489909) | (0)));
return (h1__$6 ^ (h1__$6 >>> (16)));
});
cljs.core.m3_hash_int = (function cljs$core$m3_hash_int(in$){
if((in$ === (0))){
return in$;
} else {
var k1 = cljs.core.m3_mix_K1(in$);
var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);
return cljs.core.m3_fmix(h1,(4));
}
});
cljs.core.hash_long = (function cljs$core$hash_long(high,low){
return (high ^ low);
});
cljs.core.hash_double = (function cljs$core$hash_double(f){
var arr = (function (){var G__14449 = (new Float64Array((1)));
(G__14449[(0)] = f);

return G__14449;
})();
var buf = arr.buffer;
var high = (new DataView(buf,(0),(4))).getInt32();
var low = (new DataView(buf,(4),(4))).getInt32();
return cljs.core.hash_long(high,low);
});
cljs.core.m3_hash_unencoded_chars = (function cljs$core$m3_hash_unencoded_chars(in$){
var h1 = (function (){var i = (1);
var h1 = cljs.core.m3_seed;
while(true){
if((i < in$.length)){
var G__14450 = (i + (2));
var G__14451 = cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1((in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) << (16)))));
i = G__14450;
h1 = G__14451;
continue;
} else {
return h1;
}
break;
}
})();
var h1__$1 = ((((in$.length & (1)) === (1)))?(h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt((in$.length - (1))))):h1);
return cljs.core.m3_fmix(h1__$1,cljs.core.imul((2),in$.length));
});



cljs.core.string_hash_cache = ({});
cljs.core.string_hash_cache_count = (0);
cljs.core.hash_string_STAR_ = (function cljs$core$hash_string_STAR_(s){
if((!((s == null)))){
var len = s.length;
if((len > (0))){
var i = (0);
var hash = (0);
while(true){
if((i < len)){
var G__14454 = (i + (1));
var G__14455 = (cljs.core.imul((31),hash) + s.charCodeAt(i));
i = G__14454;
hash = G__14455;
continue;
} else {
return hash;
}
break;
}
} else {
return (0);
}
} else {
return (0);
}
});
cljs.core.add_to_string_hash_cache = (function cljs$core$add_to_string_hash_cache(k){
var h = cljs.core.hash_string_STAR_(k);
cljs.core.goog$module$goog$object.set.call(null,cljs.core.string_hash_cache,k,h);

(cljs.core.string_hash_cache_count = (cljs.core.string_hash_cache_count + (1)));

return h;
});
cljs.core.hash_string = (function cljs$core$hash_string(k){
if((cljs.core.string_hash_cache_count > (255))){
(cljs.core.string_hash_cache = ({}));

(cljs.core.string_hash_cache_count = (0));
} else {
}

if((k == null)){
return (0);
} else {
var h = (cljs.core.string_hash_cache[k]);
if(typeof h === 'number'){
return h;
} else {
return cljs.core.add_to_string_hash_cache(k);
}
}
});
/**
 * Returns the hash code of its argument. Note this is the hash code
 * consistent with =.
 */
cljs.core.hash = (function cljs$core$hash(o){
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (4194304))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IHash$))))?true:false):false)){
return (o.cljs$core$IHash$_hash$arity$1(null) ^ (0));
} else {
if(typeof o === 'number'){
if(isFinite(o)){
if((!(Number.isSafeInteger(o)))){
return cljs.core.hash_double(o);
} else {
return (Math.floor(o) % (2147483647));
}
} else {
var G__14459 = o;
switch (G__14459) {
case Infinity:
return (2146435072);

break;
case -Infinity:
return (-1048576);

break;
default:
return (2146959360);

}
}
} else {
if(o === true){
return (1231);
} else {
if(o === false){
return (1237);
} else {
if(typeof o === 'string'){
return cljs.core.m3_hash_int(cljs.core.hash_string(o));
} else {
if((o instanceof Date)){
return (o.valueOf() ^ (0));
} else {
if((o == null)){
return (0);
} else {
return (cljs.core._hash(o) ^ (0));

}
}
}
}
}
}
}
});
cljs.core.hash_combine = (function cljs$core$hash_combine(seed,hash){
return (seed ^ (((hash + (2654435769)) + (seed << (6))) + (seed >> (2))));
});
/**
 * Evaluates x and tests if it is an instance of the type
 *   c. Returns true or false
 */
cljs.core.instance_QMARK_ = (function cljs$core$instance_QMARK_(c,x){
return (x instanceof c);
});
/**
 * Return true if x is a Symbol
 */
cljs.core.symbol_QMARK_ = (function cljs$core$symbol_QMARK_(x){
return (x instanceof cljs.core.Symbol);
});
cljs.core.hash_symbol = (function cljs$core$hash_symbol(sym){
return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns));
});
cljs.core.compare_symbols = (function cljs$core$compare_symbols(a,b){
if((a.str === b.str)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__9578__auto__ = cljs.core.not(a.ns);
if(and__9578__auto__){
return b.ns;
} else {
return and__9578__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__14461 = a.ns;
var G__14462 = b.ns;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__14461,G__14462);
})();
if(((0) === nsc)){
var G__14463 = a.name;
var G__14464 = b.name;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__14463,G__14464);
} else {
return nsc;
}
}
} else {
var G__14465 = a.name;
var G__14466 = b.name;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__14465,G__14466);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Symbol = (function (ns,name,str,_hash,_meta){
this.ns = ns;
this.name = name;
this.str = str;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2154168321;
this.cljs$lang$protocol_mask$partition1$ = 4096;
});
(cljs.core.Symbol.prototype.toString = (function cljs$core$fn_14468(){
var self__ = this;
var _ = this;
return self__.str;
}));

(cljs.core.Symbol.prototype.equiv = (function cljs$core$fn_14469(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_14470(_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Symbol)){
return (self__.str === other.str);
} else {
return false;
}
}));

(cljs.core.Symbol.prototype.call = (function() {
var cljs$core$fn_14471 = null;
var cljs$core$fn_14471__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym);
});
var cljs$core$fn_14471__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});
cljs$core$fn_14471 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_14471__2.call(this,self__,coll);
case 3:
return cljs$core$fn_14471__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_14471.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14471__2;
cljs$core$fn_14471.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14471__3;
return cljs$core$fn_14471;
})()
);

(cljs.core.Symbol.prototype.apply = (function cljs$core$fn_14472(self__,args14467){
var self__ = this;
var self____$1 = this;
var args__10187__auto__ = cljs.core.aclone(args14467);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10187__auto__.length > (20)))?(function (){var G__14473 = args__10187__auto__.slice((0),(20));
G__14473.push(args__10187__auto__.slice((20)));

return G__14473;
})():args__10187__auto__)));
}));

(cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14474(coll){
var self__ = this;
var sym = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym);
}));

(cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14475(coll,not_found){
var self__ = this;
var sym = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
}));

(cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_14476(_){
var self__ = this;
var ___$1 = this;
return self__._meta;
}));

(cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_14477(_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));
}));

(cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_14478(sym){
var self__ = this;
var sym__$1 = this;
var h__10045__auto__ = self__._hash;
if((!((h__10045__auto__ == null)))){
return h__10045__auto__;
} else {
var h__10045__auto____$1 = cljs.core.hash_symbol(sym__$1);
(self__._hash = h__10045__auto____$1);

return h__10045__auto____$1;
}
}));

(cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = (function cljs$core$fn_14479(_){
var self__ = this;
var ___$1 = this;
return self__.name;
}));

(cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = (function cljs$core$fn_14480(_){
var self__ = this;
var ___$1 = this;
return self__.ns;
}));

(cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function cljs$core$fn_14481(o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,self__.str);
}));

(cljs.core.Symbol.getBasis = (function cljs$core$fn_14482(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns","ns",2082130287,null),new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.Symbol.cljs$lang$type = true);

(cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol");

(cljs.core.Symbol.cljs$lang$ctorPrWriter = (function cljs$core$fn_14483(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/Symbol");
}));

/**
 * Positional factory function for cljs.core/Symbol.
 */
cljs.core.__GT_Symbol = (function cljs$core$__GT_Symbol(ns,name,str,_hash,_meta){
return (new cljs.core.Symbol(ns,name,str,_hash,_meta));
});

/**
 * Returns true if v is of type cljs.core.Var
 */
cljs.core.var_QMARK_ = (function cljs$core$var_QMARK_(v){
return (v instanceof cljs.core.Var);
});
/**
 * Returns a Symbol with the given namespace and name. Arity-1 works
 *   on strings, keywords, and vars.
 */
cljs.core.symbol = (function cljs$core$symbol(var_args){
var G__14485 = arguments.length;
switch (G__14485) {
case 1:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14486(name){
while(true){
if((name instanceof cljs.core.Symbol)){
return name;
} else {
if(typeof name === 'string'){
var idx = name.indexOf("/");
if((idx < (1))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null,name);
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(name.substring((0),idx),name.substring((idx + (1)),name.length));
}
} else {
if(cljs.core.var_QMARK_(name)){
return name.sym;
} else {
if((name instanceof cljs.core.Keyword)){
var G__14489 = name.fqn;
name = G__14489;
continue;
} else {
throw (new Error("no conversion to symbol"));

}
}
}
}
break;
}
}));

(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14487(ns,name){
var sym_str = (((!((ns == null))))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):name);
return (new cljs.core.Symbol(ns,name,sym_str,null,null));
}));

(cljs.core.symbol.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IDeref}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Var = (function (val,sym,_meta){
this.val = val;
this.sym = sym;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 6717441;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Var.prototype.isMacro = (function cljs$core$fn_14491(){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).cljs$lang$macro;
}));

(cljs.core.Var.prototype.toString = (function cljs$core$fn_14492(){
var self__ = this;
var _ = this;
return ["#'",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.sym)].join('');
}));

(cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = (function cljs$core$fn_14493(_){
var self__ = this;
var ___$1 = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
}));

(cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_14494(_){
var self__ = this;
var ___$1 = this;
return self__._meta;
}));

(cljs.core.Var.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_14495(_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Var(self__.val,self__.sym,new_meta));
}));

(cljs.core.Var.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_14496(this$,other){
var self__ = this;
var this$__$1 = this;
if((other instanceof cljs.core.Var)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this$__$1.sym,other.sym);
} else {
return false;
}
}));

(cljs.core.Var.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_14497(_){
var self__ = this;
var ___$1 = this;
return cljs.core.hash_symbol(self__.sym);
}));

(cljs.core.Var.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Var.prototype.call = (function() {
var cljs$core$fn_14498 = null;
var cljs$core$fn_14498__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14499 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14499.cljs$core$IFn$_invoke$arity$0 ? fexpr__14499.cljs$core$IFn$_invoke$arity$0() : fexpr__14499.call(null));
});
var cljs$core$fn_14498__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14500 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14500.cljs$core$IFn$_invoke$arity$1 ? fexpr__14500.cljs$core$IFn$_invoke$arity$1(a) : fexpr__14500.call(null,a));
});
var cljs$core$fn_14498__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14501 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14501.cljs$core$IFn$_invoke$arity$2 ? fexpr__14501.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__14501.call(null,a,b));
});
var cljs$core$fn_14498__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14502 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14502.cljs$core$IFn$_invoke$arity$3 ? fexpr__14502.cljs$core$IFn$_invoke$arity$3(a,b,c) : fexpr__14502.call(null,a,b,c));
});
var cljs$core$fn_14498__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14503 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14503.cljs$core$IFn$_invoke$arity$4 ? fexpr__14503.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : fexpr__14503.call(null,a,b,c,d));
});
var cljs$core$fn_14498__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14504 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14504.cljs$core$IFn$_invoke$arity$5 ? fexpr__14504.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : fexpr__14504.call(null,a,b,c,d,e));
});
var cljs$core$fn_14498__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14505 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14505.cljs$core$IFn$_invoke$arity$6 ? fexpr__14505.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : fexpr__14505.call(null,a,b,c,d,e,f));
});
var cljs$core$fn_14498__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14506 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14506.cljs$core$IFn$_invoke$arity$7 ? fexpr__14506.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : fexpr__14506.call(null,a,b,c,d,e,f,g));
});
var cljs$core$fn_14498__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14507 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14507.cljs$core$IFn$_invoke$arity$8 ? fexpr__14507.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : fexpr__14507.call(null,a,b,c,d,e,f,g,h));
});
var cljs$core$fn_14498__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14508 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14508.cljs$core$IFn$_invoke$arity$9 ? fexpr__14508.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : fexpr__14508.call(null,a,b,c,d,e,f,g,h,i));
});
var cljs$core$fn_14498__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14509 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14509.cljs$core$IFn$_invoke$arity$10 ? fexpr__14509.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : fexpr__14509.call(null,a,b,c,d,e,f,g,h,i,j));
});
var cljs$core$fn_14498__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14510 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14510.cljs$core$IFn$_invoke$arity$11 ? fexpr__14510.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : fexpr__14510.call(null,a,b,c,d,e,f,g,h,i,j,k));
});
var cljs$core$fn_14498__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14511 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14511.cljs$core$IFn$_invoke$arity$12 ? fexpr__14511.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : fexpr__14511.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});
var cljs$core$fn_14498__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14512 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14512.cljs$core$IFn$_invoke$arity$13 ? fexpr__14512.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : fexpr__14512.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});
var cljs$core$fn_14498__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14513 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14513.cljs$core$IFn$_invoke$arity$14 ? fexpr__14513.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : fexpr__14513.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});
var cljs$core$fn_14498__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14514 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14514.cljs$core$IFn$_invoke$arity$15 ? fexpr__14514.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : fexpr__14514.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});
var cljs$core$fn_14498__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14515 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14515.cljs$core$IFn$_invoke$arity$16 ? fexpr__14515.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : fexpr__14515.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});
var cljs$core$fn_14498__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14516 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14516.cljs$core$IFn$_invoke$arity$17 ? fexpr__14516.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : fexpr__14516.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});
var cljs$core$fn_14498__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14517 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14517.cljs$core$IFn$_invoke$arity$18 ? fexpr__14517.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : fexpr__14517.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});
var cljs$core$fn_14498__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14518 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14518.cljs$core$IFn$_invoke$arity$19 ? fexpr__14518.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : fexpr__14518.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});
var cljs$core$fn_14498__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14519 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14519.cljs$core$IFn$_invoke$arity$20 ? fexpr__14519.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : fexpr__14519.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});
var cljs$core$fn_14498__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)),a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
});
cljs$core$fn_14498 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return cljs$core$fn_14498__1.call(this,self__);
case 2:
return cljs$core$fn_14498__2.call(this,self__,a);
case 3:
return cljs$core$fn_14498__3.call(this,self__,a,b);
case 4:
return cljs$core$fn_14498__4.call(this,self__,a,b,c);
case 5:
return cljs$core$fn_14498__5.call(this,self__,a,b,c,d);
case 6:
return cljs$core$fn_14498__6.call(this,self__,a,b,c,d,e);
case 7:
return cljs$core$fn_14498__7.call(this,self__,a,b,c,d,e,f);
case 8:
return cljs$core$fn_14498__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return cljs$core$fn_14498__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return cljs$core$fn_14498__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return cljs$core$fn_14498__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return cljs$core$fn_14498__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return cljs$core$fn_14498__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return cljs$core$fn_14498__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return cljs$core$fn_14498__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return cljs$core$fn_14498__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return cljs$core$fn_14498__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return cljs$core$fn_14498__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return cljs$core$fn_14498__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return cljs$core$fn_14498__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return cljs$core$fn_14498__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return cljs$core$fn_14498__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_14498.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14498__1;
cljs$core$fn_14498.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14498__2;
cljs$core$fn_14498.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14498__3;
cljs$core$fn_14498.cljs$core$IFn$_invoke$arity$4 = cljs$core$fn_14498__4;
cljs$core$fn_14498.cljs$core$IFn$_invoke$arity$5 = cljs$core$fn_14498__5;
cljs$core$fn_14498.cljs$core$IFn$_invoke$arity$6 = cljs$core$fn_14498__6;
cljs$core$fn_14498.cljs$core$IFn$_invoke$arity$7 = cljs$core$fn_14498__7;
cljs$core$fn_14498.cljs$core$IFn$_invoke$arity$8 = cljs$core$fn_14498__8;
cljs$core$fn_14498.cljs$core$IFn$_invoke$arity$9 = cljs$core$fn_14498__9;
cljs$core$fn_14498.cljs$core$IFn$_invoke$arity$10 = cljs$core$fn_14498__10;
cljs$core$fn_14498.cljs$core$IFn$_invoke$arity$11 = cljs$core$fn_14498__11;
cljs$core$fn_14498.cljs$core$IFn$_invoke$arity$12 = cljs$core$fn_14498__12;
cljs$core$fn_14498.cljs$core$IFn$_invoke$arity$13 = cljs$core$fn_14498__13;
cljs$core$fn_14498.cljs$core$IFn$_invoke$arity$14 = cljs$core$fn_14498__14;
cljs$core$fn_14498.cljs$core$IFn$_invoke$arity$15 = cljs$core$fn_14498__15;
cljs$core$fn_14498.cljs$core$IFn$_invoke$arity$16 = cljs$core$fn_14498__16;
cljs$core$fn_14498.cljs$core$IFn$_invoke$arity$17 = cljs$core$fn_14498__17;
cljs$core$fn_14498.cljs$core$IFn$_invoke$arity$18 = cljs$core$fn_14498__18;
cljs$core$fn_14498.cljs$core$IFn$_invoke$arity$19 = cljs$core$fn_14498__19;
cljs$core$fn_14498.cljs$core$IFn$_invoke$arity$20 = cljs$core$fn_14498__20;
cljs$core$fn_14498.cljs$core$IFn$_invoke$arity$21 = cljs$core$fn_14498__21;
cljs$core$fn_14498.cljs$core$IFn$_invoke$arity$22 = cljs$core$fn_14498__22;
return cljs$core$fn_14498;
})()
);

(cljs.core.Var.prototype.apply = (function cljs$core$fn_14520(self__,args14490){
var self__ = this;
var self____$1 = this;
var args__10187__auto__ = cljs.core.aclone(args14490);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10187__auto__.length > (20)))?(function (){var G__14521 = args__10187__auto__.slice((0),(20));
G__14521.push(args__10187__auto__.slice((20)));

return G__14521;
})():args__10187__auto__)));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14522(){
var self__ = this;
var _ = this;
var fexpr__14523 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14523.cljs$core$IFn$_invoke$arity$0 ? fexpr__14523.cljs$core$IFn$_invoke$arity$0() : fexpr__14523.call(null));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14524(a){
var self__ = this;
var _ = this;
var fexpr__14525 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14525.cljs$core$IFn$_invoke$arity$1 ? fexpr__14525.cljs$core$IFn$_invoke$arity$1(a) : fexpr__14525.call(null,a));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14526(a,b){
var self__ = this;
var _ = this;
var fexpr__14527 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14527.cljs$core$IFn$_invoke$arity$2 ? fexpr__14527.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__14527.call(null,a,b));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14528(a,b,c){
var self__ = this;
var _ = this;
var fexpr__14529 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14529.cljs$core$IFn$_invoke$arity$3 ? fexpr__14529.cljs$core$IFn$_invoke$arity$3(a,b,c) : fexpr__14529.call(null,a,b,c));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14530(a,b,c,d){
var self__ = this;
var _ = this;
var fexpr__14531 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14531.cljs$core$IFn$_invoke$arity$4 ? fexpr__14531.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : fexpr__14531.call(null,a,b,c,d));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_14532(a,b,c,d,e){
var self__ = this;
var _ = this;
var fexpr__14533 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14533.cljs$core$IFn$_invoke$arity$5 ? fexpr__14533.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : fexpr__14533.call(null,a,b,c,d,e));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_14534(a,b,c,d,e,f){
var self__ = this;
var _ = this;
var fexpr__14535 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14535.cljs$core$IFn$_invoke$arity$6 ? fexpr__14535.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : fexpr__14535.call(null,a,b,c,d,e,f));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = (function cljs$core$fn_14536(a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
var fexpr__14537 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14537.cljs$core$IFn$_invoke$arity$7 ? fexpr__14537.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : fexpr__14537.call(null,a,b,c,d,e,f,g));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = (function cljs$core$fn_14538(a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
var fexpr__14539 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14539.cljs$core$IFn$_invoke$arity$8 ? fexpr__14539.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : fexpr__14539.call(null,a,b,c,d,e,f,g,h));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = (function cljs$core$fn_14540(a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
var fexpr__14541 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14541.cljs$core$IFn$_invoke$arity$9 ? fexpr__14541.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : fexpr__14541.call(null,a,b,c,d,e,f,g,h,i));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = (function cljs$core$fn_14542(a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
var fexpr__14543 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14543.cljs$core$IFn$_invoke$arity$10 ? fexpr__14543.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : fexpr__14543.call(null,a,b,c,d,e,f,g,h,i,j));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = (function cljs$core$fn_14544(a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
var fexpr__14545 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14545.cljs$core$IFn$_invoke$arity$11 ? fexpr__14545.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : fexpr__14545.call(null,a,b,c,d,e,f,g,h,i,j,k));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = (function cljs$core$fn_14546(a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
var fexpr__14547 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14547.cljs$core$IFn$_invoke$arity$12 ? fexpr__14547.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : fexpr__14547.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = (function cljs$core$fn_14548(a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
var fexpr__14549 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14549.cljs$core$IFn$_invoke$arity$13 ? fexpr__14549.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : fexpr__14549.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = (function cljs$core$fn_14550(a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
var fexpr__14551 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14551.cljs$core$IFn$_invoke$arity$14 ? fexpr__14551.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : fexpr__14551.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = (function cljs$core$fn_14552(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
var fexpr__14553 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14553.cljs$core$IFn$_invoke$arity$15 ? fexpr__14553.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : fexpr__14553.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = (function cljs$core$fn_14554(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
var fexpr__14555 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14555.cljs$core$IFn$_invoke$arity$16 ? fexpr__14555.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : fexpr__14555.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = (function cljs$core$fn_14556(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
var fexpr__14557 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14557.cljs$core$IFn$_invoke$arity$17 ? fexpr__14557.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : fexpr__14557.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = (function cljs$core$fn_14558(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
var fexpr__14559 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14559.cljs$core$IFn$_invoke$arity$18 ? fexpr__14559.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : fexpr__14559.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = (function cljs$core$fn_14560(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
var fexpr__14561 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14561.cljs$core$IFn$_invoke$arity$19 ? fexpr__14561.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : fexpr__14561.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = (function cljs$core$fn_14562(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
var fexpr__14563 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14563.cljs$core$IFn$_invoke$arity$20 ? fexpr__14563.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : fexpr__14563.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = (function cljs$core$fn_14564(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)),a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
}));

(cljs.core.Var.getBasis = (function cljs$core$fn_14565(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"sym","sym",195671222,null),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.Var.cljs$lang$type = true);

(cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var");

(cljs.core.Var.cljs$lang$ctorPrWriter = (function cljs$core$fn_14566(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/Var");
}));

/**
 * Positional factory function for cljs.core/Var.
 */
cljs.core.__GT_Var = (function cljs$core$__GT_Var(val,sym,_meta){
return (new cljs.core.Var(val,sym,_meta));
});



/**
 * Return true if x implements IIterable protocol.
 */
cljs.core.iterable_QMARK_ = (function cljs$core$iterable_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition1$ & (131072))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIterable$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
}
});
/**
 * Return true if x has a JavaScript iterator property
 */
cljs.core.js_iterable_QMARK_ = (function cljs$core$js_iterable_QMARK_(x){
return (((!((x == null)))) && ((!((x[cljs.core.ITER_SYMBOL] == null)))));
});
/**
 * Clone the supplied value which must implement ICloneable.
 */
cljs.core.clone = (function cljs$core$clone(value){
return cljs.core._clone(value);
});
/**
 * Return true if x implements ICloneable protocol.
 */
cljs.core.cloneable_QMARK_ = (function cljs$core$cloneable_QMARK_(value){
if((!((value == null)))){
if((((value.cljs$lang$protocol_mask$partition1$ & (8192))) || ((cljs.core.PROTOCOL_SENTINEL === value.cljs$core$ICloneable$)))){
return true;
} else {
if((!value.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
}
});
/**
 * Returns a seq on the collection. If the collection is
 *   empty, returns nil.  (seq nil) returns nil. seq also works on
 *   Strings.
 */
cljs.core.seq = (function cljs$core$seq(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$))))?true:false):false)){
return coll.cljs$core$ISeqable$_seq$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(typeof coll === 'string'){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(cljs.core.js_iterable_QMARK_(coll)){
return cljs.core.es6_iterator_seq(cljs.core.goog$module$goog$object.get.call(null,coll,cljs.core.ITER_SYMBOL).call(coll));
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,coll)){
return cljs.core._seq(coll);
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll)," is not ISeqable"].join('')));

}
}
}
}
}
}
});
/**
 * Returns the first item in the collection. Calls seq on its
 *   argument. If coll is nil, returns nil.
 */
cljs.core.first = (function cljs$core$first(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return coll.cljs$core$ISeq$_first$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if((s == null)){
return null;
} else {
return cljs.core._first(s);
}
}
}
});
/**
 * Returns a possibly empty seq of the items after the first. Calls seq on its
 *   argument.
 */
cljs.core.rest = (function cljs$core$rest(coll){
if((!((coll == null)))){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return coll.cljs$core$ISeq$_rest$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if(s){
return s.cljs$core$ISeq$_rest$arity$1(null);
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a seq of the items after the first. Calls seq on its
 *   argument.  If there are no more items, returns nil
 */
cljs.core.next = (function cljs$core$next(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$))))?true:false):false)){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
}
});
/**
 * Equality. Returns true if x equals y, false if not. Compares
 *   numbers and collections in a type-independent manner.  Clojure's immutable data
 *   structures define -equiv (and thus =) as a value, not an identity,
 *   comparison.
 */
cljs.core._EQ_ = (function cljs$core$_EQ_(var_args){
var G__14577 = arguments.length;
switch (G__14577) {
case 1:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___14583 = arguments.length;
var i__10914__auto___14584 = (0);
while(true){
if((i__10914__auto___14584 < len__10913__auto___14583)){
args_arr__10942__auto__.push((arguments[i__10914__auto___14584]));

var G__14585 = (i__10914__auto___14584 + (1));
i__10914__auto___14584 = G__14585;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14578(x){
return true;
}));

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14579(x,y){
if((x == null)){
return (y == null);
} else {
return (((x === y)) || (cljs.core._equiv(x,y)));
}
}));

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14580(x,y,more){
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__14586 = y;
var G__14587 = cljs.core.first(more);
var G__14588 = cljs.core.next(more);
x = G__14586;
y = G__14587;
more = G__14588;
continue;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._EQ_.cljs$lang$applyTo = (function cljs$core$fn_14581(seq14574){
var G__14575 = cljs.core.first(seq14574);
var seq14574__$1 = cljs.core.next(seq14574);
var G__14576 = cljs.core.first(seq14574__$1);
var seq14574__$2 = cljs.core.next(seq14574__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14575,G__14576,seq14574__$2);
}));

(cljs.core._EQ_.cljs$lang$maxFixedArity = (2));


/**
* @constructor
*/
cljs.core.ES6Iterator = (function (s){
this.s = s;
});
(cljs.core.ES6Iterator.prototype.next = (function cljs$core$fn_14589(){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var x = cljs.core.first(self__.s);
(self__.s = cljs.core.next(self__.s));

return ({"value": x, "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6Iterator.getBasis = (function cljs$core$fn_14590(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6Iterator.cljs$lang$type = true);

(cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator");

(cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_14591(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/ES6Iterator");
}));

/**
 * Positional factory function for cljs.core/ES6Iterator.
 */
cljs.core.__GT_ES6Iterator = (function cljs$core$__GT_ES6Iterator(s){
return (new cljs.core.ES6Iterator(s));
});

/**
 * Return a ES2015+ compatible iterator for coll.
 */
cljs.core.es6_iterator = (function cljs$core$es6_iterator(coll){
return (new cljs.core.ES6Iterator(cljs.core.seq(coll)));
});

/**
* @constructor
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
*/
cljs.core.ES6IteratorSeq = (function (value,iter,_rest){
this.value = value;
this.iter = iter;
this._rest = _rest;
this.cljs$lang$protocol_mask$partition0$ = 8388672;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_14592(this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_14593(_){
var self__ = this;
var ___$1 = this;
return self__.value;
}));

(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_14594(_){
var self__ = this;
var ___$1 = this;
if((self__._rest == null)){
(self__._rest = cljs.core.es6_iterator_seq(self__.iter));
} else {
}

return self__._rest;
}));

(cljs.core.ES6IteratorSeq.getBasis = (function cljs$core$fn_14595(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"value","value",1946509744,null),new cljs.core.Symbol(null,"iter","iter",-1346195486,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_rest","_rest",-2100466189,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6IteratorSeq.cljs$lang$type = true);

(cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq");

(cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_14596(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/ES6IteratorSeq");
}));

/**
 * Positional factory function for cljs.core/ES6IteratorSeq.
 */
cljs.core.__GT_ES6IteratorSeq = (function cljs$core$__GT_ES6IteratorSeq(value,iter,_rest){
return (new cljs.core.ES6IteratorSeq(value,iter,_rest));
});

/**
 * Given an ES2015+ compatible iterator return a seq.
 */
cljs.core.es6_iterator_seq = (function cljs$core$es6_iterator_seq(iter){
var v = iter.next();
if(cljs.core.truth_(v.done)){
return null;
} else {
return (new cljs.core.ES6IteratorSeq(v.value,iter,null));
}
});
/**
 * Mix final collection hash for ordered or unordered collections.
 * hash-basis is the combined collection hash, count is the number
 * of elements included in the basis. Note this is the hash code
 * consistent with =, different from .hashCode.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.mix_collection_hash = (function cljs$core$mix_collection_hash(hash_basis,count){
var h1 = cljs.core.m3_seed;
var k1 = cljs.core.m3_mix_K1(hash_basis);
var h1__$1 = cljs.core.m3_mix_H1(h1,k1);
return cljs.core.m3_fmix(h1__$1,count);
});
/**
 * Returns the hash code, consistent with =, for an external ordered
 * collection implementing Iterable.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_ordered_coll = (function cljs$core$hash_ordered_coll(coll){
var n = (0);
var hash_code = (1);
var coll__$1 = cljs.core.seq(coll);
while(true){
if((!((coll__$1 == null)))){
var G__14597 = (n + (1));
var G__14598 = ((cljs.core.imul((31),hash_code) + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__14599 = cljs.core.next(coll__$1);
n = G__14597;
hash_code = G__14598;
coll__$1 = G__14599;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash((1),(0));
/**
 * Returns the hash code, consistent with =, for an external unordered
 * collection implementing Iterable. For maps, the iterator should
 * return map entries whose hash is computed as
 *   (hash-ordered-coll [k v]).
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_unordered_coll = (function cljs$core$hash_unordered_coll(coll){
var n = (0);
var hash_code = (0);
var coll__$1 = cljs.core.seq(coll);
while(true){
if((!((coll__$1 == null)))){
var G__14600 = (n + (1));
var G__14601 = ((hash_code + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__14602 = cljs.core.next(coll__$1);
n = G__14600;
hash_code = G__14601;
coll__$1 = G__14602;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash((0),(0));


(cljs.core.ICounted["null"] = true);

(cljs.core._count["null"] = (function cljs$core$fn_14603(_){
return (0);
}));
(Date.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_14604(o,other){
var o__$1 = this;
return (((other instanceof Date)) && ((o__$1.valueOf() === other.valueOf())));
}));

(Date.prototype.cljs$core$IComparable$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$IComparable$_compare$arity$2 = (function cljs$core$fn_14605(this$,other){
var this$__$1 = this;
if((other instanceof Date)){
var G__14606 = this$__$1.valueOf();
var G__14607 = other.valueOf();
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__14606,G__14607);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(this$__$1)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(other)].join('')));
}
}));

/**
 * @interface
 */
cljs.core.Inst = function(){};

var cljs$core$Inst$inst_ms_STAR_$dyn_14609 = (function cljs$core$fn_14608(inst){
var x__10333__auto__ = (((inst == null))?null:inst);
var m__10334__auto__ = (cljs.core.inst_ms_STAR_[goog.typeOf(x__10333__auto__)]);
if((!((m__10334__auto__ == null)))){
return (m__10334__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10334__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__10334__auto__.call(null,inst));
} else {
var m__10332__auto__ = (cljs.core.inst_ms_STAR_["_"]);
if((!((m__10332__auto__ == null)))){
return (m__10332__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10332__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__10332__auto__.call(null,inst));
} else {
throw cljs.core.missing_protocol("Inst.inst-ms*",inst);
}
}
});
cljs.core.inst_ms_STAR_ = (function cljs$core$inst_ms_STAR_(inst){
if((((!((inst == null)))) && ((!((inst.cljs$core$Inst$inst_ms_STAR_$arity$1 == null)))))){
return inst.cljs$core$Inst$inst_ms_STAR_$arity$1(inst);
} else {
return cljs$core$Inst$inst_ms_STAR_$dyn_14609(inst);
}
});

(Date.prototype.cljs$core$Inst$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$Inst$inst_ms_STAR_$arity$1 = (function cljs$core$fn_14610(inst){
var inst__$1 = this;
return inst__$1.getTime();
}));
/**
 * Return the number of milliseconds since January 1, 1970, 00:00:00 GMT
 */
cljs.core.inst_ms = (function cljs$core$inst_ms(inst){
return cljs.core.inst_ms_STAR_(inst);
});
/**
 * Return true if x satisfies Inst
 */
cljs.core.inst_QMARK_ = (function cljs$core$inst_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$Inst$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);
}
});
(cljs.core.IEquiv["number"] = true);

(cljs.core._equiv["number"] = (function cljs$core$fn_14612(x,o){
return (x === o);
}));
(cljs.core.Fn["function"] = true);

(cljs.core.IMeta["function"] = true);

(cljs.core._meta["function"] = (function cljs$core$fn_14613(_){
return null;
}));
(cljs.core.IHash["_"] = true);

(cljs.core._hash["_"] = (function cljs$core$fn_14614(o){
return goog.getUid(o);
}));
(cljs.core.IHash["symbol"] = true);

(cljs.core._hash["symbol"] = (function cljs$core$fn_14615(o){
return cljs.core.hash(o.toString());
}));
/**
 * Returns a number one greater than num.
 */
cljs.core.inc = (function cljs$core$inc(x){
return (x + (1));
});

/**
* @constructor
 * @implements {cljs.core.IDeref}
*/
cljs.core.Reduced = (function (val){
this.val = val;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = (function cljs$core$fn_14616(o){
var self__ = this;
var o__$1 = this;
return self__.val;
}));

(cljs.core.Reduced.getBasis = (function cljs$core$fn_14617(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null)], null);
}));

(cljs.core.Reduced.cljs$lang$type = true);

(cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced");

(cljs.core.Reduced.cljs$lang$ctorPrWriter = (function cljs$core$fn_14618(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/Reduced");
}));

/**
 * Positional factory function for cljs.core/Reduced.
 */
cljs.core.__GT_Reduced = (function cljs$core$__GT_Reduced(val){
return (new cljs.core.Reduced(val));
});

/**
 * Wraps x in a way such that a reduce will terminate with the value x
 */
cljs.core.reduced = (function cljs$core$reduced(x){
return (new cljs.core.Reduced(x));
});
/**
 * Returns true if x is the result of a call to reduced
 */
cljs.core.reduced_QMARK_ = (function cljs$core$reduced_QMARK_(r){
return (r instanceof cljs.core.Reduced);
});
/**
 * If x is already reduced?, returns it, else returns (reduced x)
 */
cljs.core.ensure_reduced = (function cljs$core$ensure_reduced(x){
if(cljs.core.reduced_QMARK_(x)){
return x;
} else {
return cljs.core.reduced(x);
}
});
/**
 * If x is reduced?, returns (deref x), else returns x
 */
cljs.core.unreduced = (function cljs$core$unreduced(x){
if(cljs.core.reduced_QMARK_(x)){
return cljs.core.deref(x);
} else {
return x;
}
});
/**
 * Also reader macro: @var/@atom/@delay. Returns the
 * most-recently-committed value of ref. When applied to a var
 * or atom, returns its current state. When applied to a delay, forces
 * it if not already forced. See also - realized?.
 */
cljs.core.deref = (function cljs$core$deref(o){
return cljs.core._deref(o);
});
/**
 * Accepts any collection which satisfies the ICount and IIndexed protocols and
 * reduces them without incurring seq initialization
 */
cljs.core.ci_reduce = (function cljs$core$ci_reduce(var_args){
var G__14620 = arguments.length;
switch (G__14620) {
case 2:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14621(cicoll,f){
var cnt = cicoll.cljs$core$ICounted$_count$arity$1(null);
if((cnt === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = cicoll.cljs$core$IIndexed$_nth$arity$2(null,(0));
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__14622 = val;
var G__14623 = cicoll.cljs$core$IIndexed$_nth$arity$2(null,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14622,G__14623) : f.call(null,G__14622,G__14623));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14628 = nval;
var G__14629 = (n + (1));
val = G__14628;
n = G__14629;
continue;
}
} else {
return val;
}
break;
}
}
}));

(cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14624(cicoll,f,val){
var cnt = cicoll.cljs$core$ICounted$_count$arity$1(null);
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__14625 = val__$1;
var G__14626 = cicoll.cljs$core$IIndexed$_nth$arity$2(null,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14625,G__14626) : f.call(null,G__14625,G__14626));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14630 = nval;
var G__14631 = (n + (1));
val__$1 = G__14630;
n = G__14631;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.ci_reduce.cljs$lang$maxFixedArity = 3);

cljs.core.array_reduce = (function cljs$core$array_reduce(var_args){
var G__14633 = arguments.length;
switch (G__14633) {
case 2:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14634(arr,f){
var cnt = arr.length;
if((arr.length === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = (arr[(0)]);
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__14635 = val;
var G__14636 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14635,G__14636) : f.call(null,G__14635,G__14636));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14644 = nval;
var G__14645 = (n + (1));
val = G__14644;
n = G__14645;
continue;
}
} else {
return val;
}
break;
}
}
}));

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14637(arr,f,val){
var cnt = arr.length;
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__14638 = val__$1;
var G__14639 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14638,G__14639) : f.call(null,G__14638,G__14639));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14646 = nval;
var G__14647 = (n + (1));
val__$1 = G__14646;
n = G__14647;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14640(arr,f,val,idx){
var cnt = arr.length;
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__14641 = val__$1;
var G__14642 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14641,G__14642) : f.call(null,G__14641,G__14642));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14648 = nval;
var G__14649 = (n + (1));
val__$1 = G__14648;
n = G__14649;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.array_reduce.cljs$lang$maxFixedArity = 4);







/**
 * Returns true if coll implements count in constant time
 */
cljs.core.counted_QMARK_ = (function cljs$core$counted_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICounted$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
}
});
/**
 * Returns true if coll implements nth in constant time
 */
cljs.core.indexed_QMARK_ = (function cljs$core$indexed_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIndexed$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
}
});
cljs.core._indexOf = (function cljs$core$_indexOf(var_args){
var G__14653 = arguments.length;
switch (G__14653) {
case 2:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14654(coll,x){
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
}));

(cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14655(coll,x,start){
var len = cljs.core.count(coll);
if((start >= len)){
return (-1);
} else {
var idx = (((start > (0)))?start:(((start < (0)))?(function (){var x__9941__auto__ = (0);
var y__9942__auto__ = (start + len);
return ((x__9941__auto__ > y__9942__auto__) ? x__9941__auto__ : y__9942__auto__);
})():start
));
while(true){
if((idx < len)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx),x)){
return idx;
} else {
var G__14657 = (idx + (1));
idx = G__14657;
continue;
}
} else {
return (-1);
}
break;
}
}
}));

(cljs.core._indexOf.cljs$lang$maxFixedArity = 3);

cljs.core._lastIndexOf = (function cljs$core$_lastIndexOf(var_args){
var G__14659 = arguments.length;
switch (G__14659) {
case 2:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14660(coll,x){
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
}));

(cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14661(coll,x,start){
var len = cljs.core.count(coll);
if((len === (0))){
return (-1);
} else {
var idx = (((start > (0)))?(function (){var x__9948__auto__ = (len - (1));
var y__9949__auto__ = start;
return ((x__9948__auto__ < y__9949__auto__) ? x__9948__auto__ : y__9949__auto__);
})():(((start < (0)))?(len + start):start
));
while(true){
if((idx >= (0))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx),x)){
return idx;
} else {
var G__14663 = (idx - (1));
idx = G__14663;
continue;
}
} else {
return (-1);
}
break;
}
}
}));

(cljs.core._lastIndexOf.cljs$lang$maxFixedArity = 3);


/**
* @constructor
*/
cljs.core.IndexedSeqIterator = (function (arr,i){
this.arr = arr;
this.i = i;
});
(cljs.core.IndexedSeqIterator.prototype.hasNext = (function cljs$core$fn_14664(){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
}));

(cljs.core.IndexedSeqIterator.prototype.next = (function cljs$core$fn_14665(){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.IndexedSeqIterator.getBasis = (function cljs$core$fn_14666(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.IndexedSeqIterator.cljs$lang$type = true);

(cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator");

(cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_14667(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/IndexedSeqIterator");
}));

/**
 * Positional factory function for cljs.core/IndexedSeqIterator.
 */
cljs.core.__GT_IndexedSeqIterator = (function cljs$core$__GT_IndexedSeqIterator(arr,i){
return (new cljs.core.IndexedSeqIterator(arr,i));
});


/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.IndexedSeq = (function (arr,i,meta){
this.arr = arr;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 166592766;
this.cljs$lang$protocol_mask$partition1$ = 401408;
});
(cljs.core.IndexedSeq.prototype.toString = (function cljs$core$fn_14668(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.IndexedSeq.prototype.equiv = (function cljs$core$fn_14669(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.IndexedSeq.prototype.indexOf = (function() {
var cljs$core$fn_14670 = null;
var cljs$core$fn_14670__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_14670__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_14670 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_14670__1.call(this,x);
case 2:
return cljs$core$fn_14670__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14670.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14670__1;
cljs$core$fn_14670.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14670__2;
return cljs$core$fn_14670;
})()
);

(cljs.core.IndexedSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_14671 = null;
var cljs$core$fn_14671__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_14671__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_14671 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_14671__1.call(this,x);
case 2:
return cljs$core$fn_14671__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14671.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14671__1;
cljs$core$fn_14671.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14671__2;
return cljs$core$fn_14671;
})()
);

(cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_14672(coll,n){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if(((((0) <= i__$1)) && ((i__$1 < self__.arr.length)))){
return (self__.arr[i__$1]);
} else {
throw (new Error("Index out of bounds"));
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_14673(coll,n,not_found){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if(((((0) <= i__$1)) && ((i__$1 < self__.arr.length)))){
return (self__.arr[i__$1]);
} else {
return not_found;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_14674(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_14675(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_14676(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i,self__.meta));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_14677(_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_14678(_){
var self__ = this;
var ___$1 = this;
var x__9941__auto__ = (0);
var y__9942__auto__ = (self__.arr.length - self__.i);
return ((x__9941__auto__ > y__9942__auto__) ? x__9941__auto__ : y__9942__auto__);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_14679(coll){
var self__ = this;
var coll__$1 = this;
var c = coll__$1.cljs$core$ICounted$_count$arity$1(null);
if((c > (0))){
return (new cljs.core.RSeq(coll__$1,(c - (1)),null));
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_14680(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_14681(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_14682(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_14683(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_14684(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_14685(_){
var self__ = this;
var ___$1 = this;
return (self__.arr[self__.i]);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_14686(_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_14687(this$){
var self__ = this;
var this$__$1 = this;
if((self__.i < self__.arr.length)){
return this$__$1;
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_14688(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.IndexedSeq(self__.arr,self__.i,new_meta));
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_14689(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IDrop$_drop$arity$2 = (function cljs$core$fn_14690(coll,n){
var self__ = this;
var coll__$1 = this;
if((n > (0))){
if(((self__.i + n) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + n),null));
} else {
return null;
}
} else {
return coll__$1;
}
}));

(cljs.core.IndexedSeq.getBasis = (function cljs$core$fn_14691(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.IndexedSeq.cljs$lang$type = true);

(cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq");

(cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_14692(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/IndexedSeq");
}));

/**
 * Positional factory function for cljs.core/IndexedSeq.
 */
cljs.core.__GT_IndexedSeq = (function cljs$core$__GT_IndexedSeq(arr,i,meta){
return (new cljs.core.IndexedSeq(arr,i,meta));
});

(cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_14693(){
var this__10774__auto__ = this;
return cljs.core.es6_iterator(this__10774__auto__);
}));
/**
 * Create seq from a primitive JavaScript Array-like.
 */
cljs.core.prim_seq = (function cljs$core$prim_seq(var_args){
var G__14695 = arguments.length;
switch (G__14695) {
case 1:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14696(prim){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim,(0));
}));

(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14697(prim,i){
if((i < prim.length)){
return (new cljs.core.IndexedSeq(prim,i,null));
} else {
return null;
}
}));

(cljs.core.prim_seq.cljs$lang$maxFixedArity = 2);

/**
 * Create a seq from a JavaScript array.
 */
cljs.core.array_seq = (function cljs$core$array_seq(var_args){
var G__14700 = arguments.length;
switch (G__14700) {
case 1:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14701(array){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,(0));
}));

(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14702(array,i){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i);
}));

(cljs.core.array_seq.cljs$lang$maxFixedArity = 2);



/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RSeq = (function (ci,i,meta){
this.ci = ci;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.RSeq.prototype.toString = (function cljs$core$fn_14704(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.RSeq.prototype.equiv = (function cljs$core$fn_14705(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.RSeq.prototype.indexOf = (function() {
var cljs$core$fn_14706 = null;
var cljs$core$fn_14706__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_14706__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_14706 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_14706__1.call(this,x);
case 2:
return cljs$core$fn_14706__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14706.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14706__1;
cljs$core$fn_14706.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14706__2;
return cljs$core$fn_14706;
})()
);

(cljs.core.RSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_14707 = null;
var cljs$core$fn_14707__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_14707__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_14707 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_14707__1.call(this,x);
case 2:
return cljs$core$fn_14707__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14707.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14707__1;
cljs$core$fn_14707.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14707__2;
return cljs$core$fn_14707;
})()
);

(cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_14708(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_14709(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));
}));

(cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_14710(coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return null;
}
}));

(cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_14711(coll){
var self__ = this;
var coll__$1 = this;
return (self__.i + (1));
}));

(cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_14712(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_14713(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_14714(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_14715(col,f){
var self__ = this;
var col__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,col__$1);
}));

(cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_14716(col,f,start){
var self__ = this;
var col__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,col__$1);
}));

(cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_14717(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci,self__.i);
}));

(cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_14718(coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_14719(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_14720(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.RSeq(self__.ci,self__.i,new_meta));
}
}));

(cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_14721(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.RSeq.getBasis = (function cljs$core$fn_14722(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ci","ci",2049808339,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.RSeq.cljs$lang$type = true);

(cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq");

(cljs.core.RSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_14723(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/RSeq");
}));

/**
 * Positional factory function for cljs.core/RSeq.
 */
cljs.core.__GT_RSeq = (function cljs$core$__GT_RSeq(ci,i,meta){
return (new cljs.core.RSeq(ci,i,meta));
});

(cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_14724(){
var this__10774__auto__ = this;
return cljs.core.es6_iterator(this__10774__auto__);
}));
/**
 * Same as (first (next x))
 */
cljs.core.second = (function cljs$core$second(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (first (first x))
 */
cljs.core.ffirst = (function cljs$core$ffirst(coll){
return cljs.core.first(cljs.core.first(coll));
});
/**
 * Same as (next (first x))
 */
cljs.core.nfirst = (function cljs$core$nfirst(coll){
return cljs.core.next(cljs.core.first(coll));
});
/**
 * Same as (first (next x))
 */
cljs.core.fnext = (function cljs$core$fnext(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (next (next x))
 */
cljs.core.nnext = (function cljs$core$nnext(coll){
return cljs.core.next(cljs.core.next(coll));
});
/**
 * Return the last item in coll, in linear time
 */
cljs.core.last = (function cljs$core$last(s){
while(true){
var sn = cljs.core.next(s);
if((!((sn == null)))){
var G__14725 = sn;
s = G__14725;
continue;
} else {
return cljs.core.first(s);
}
break;
}
});
(cljs.core.IEquiv["_"] = true);

(cljs.core._equiv["_"] = (function cljs$core$fn_14726(x,o){
return (x === o);
}));
/**
 * conj[oin]. Returns a new collection with the xs
 *   'added'. (conj nil item) returns (item).
 *   (conj coll) returns coll. (conj) returns [].
 *   The 'addition' may happen at different 'places' depending
 *   on the concrete type.
 */
cljs.core.conj = (function cljs$core$conj(var_args){
var G__14731 = arguments.length;
switch (G__14731) {
case 0:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___14738 = arguments.length;
var i__10914__auto___14739 = (0);
while(true){
if((i__10914__auto___14739 < len__10913__auto___14738)){
args_arr__10942__auto__.push((arguments[i__10914__auto___14739]));

var G__14740 = (i__10914__auto___14739 + (1));
i__10914__auto___14739 = G__14740;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14732(){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14733(coll){
return coll;
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14734(coll,x){
if((!((coll == null)))){
return cljs.core._conj(coll,x);
} else {
return (new cljs.core.List(null,x,null,(1),null));
}
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14735(coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__14741 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
var G__14742 = cljs.core.first(xs);
var G__14743 = cljs.core.next(xs);
coll = G__14741;
x = G__14742;
xs = G__14743;
continue;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
break;
}
}));

/** @this {Function} */
(cljs.core.conj.cljs$lang$applyTo = (function cljs$core$fn_14736(seq14728){
var G__14729 = cljs.core.first(seq14728);
var seq14728__$1 = cljs.core.next(seq14728);
var G__14730 = cljs.core.first(seq14728__$1);
var seq14728__$2 = cljs.core.next(seq14728__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14729,G__14730,seq14728__$2);
}));

(cljs.core.conj.cljs$lang$maxFixedArity = (2));

/**
 * Returns an empty collection of the same category as coll, or nil
 */
cljs.core.empty = (function cljs$core$empty(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IEmptyableCollection$))))?true:false):false)){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(null);
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IEmptyableCollection$))))?true:(((!coll.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IEmptyableCollection,coll):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IEmptyableCollection,coll))){
return cljs.core._empty(coll);
} else {
return null;

}
}
}
});
cljs.core.accumulating_seq_count = (function cljs$core$accumulating_seq_count(coll){
var s = cljs.core.seq(coll);
var acc = (0);
while(true){
if(cljs.core.counted_QMARK_(s)){
return (acc + cljs.core._count(s));
} else {
var G__14746 = cljs.core.next(s);
var G__14747 = (acc + (1));
s = G__14746;
acc = G__14747;
continue;
}
break;
}
});
/**
 * Returns the number of items in the collection. (count nil) returns
 *   0.  Also works on strings, arrays, and Maps
 */
cljs.core.count = (function cljs$core$count(coll){
if((!((coll == null)))){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ICounted$))))?true:false):false)){
return coll.cljs$core$ICounted$_count$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
return coll.length;
} else {
if(typeof coll === 'string'){
return coll.length;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$))))?true:false):false)){
return cljs.core.accumulating_seq_count(coll);
} else {
return cljs.core._count(coll);

}
}
}
}
} else {
return (0);
}
});
cljs.core.linear_traversal_nth = (function cljs$core$linear_traversal_nth(var_args){
var G__14751 = arguments.length;
switch (G__14751) {
case 2:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14752(coll,n){
while(true){
if((coll == null)){
throw (new Error("Index out of bounds"));
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.seq(coll)){
var G__14755 = cljs.core.next(coll);
var G__14756 = (n - (1));
coll = G__14755;
n = G__14756;
continue;
} else {
throw (new Error("Index out of bounds"));

}
}
}
}
break;
}
}));

(cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14753(coll,n,not_found){
while(true){
if((coll == null)){
return not_found;
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
return not_found;
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.seq(coll)){
var G__14757 = cljs.core.next(coll);
var G__14758 = (n - (1));
var G__14759 = not_found;
coll = G__14757;
n = G__14758;
not_found = G__14759;
continue;
} else {
return not_found;

}
}
}
}
break;
}
}));

(cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3);

/**
 * Returns the value at the index. get returns nil if index out of
 *   bounds, nth throws an exception unless not-found is supplied.  nth
 *   also works for strings, arrays, regex Matchers and Lists, and,
 *   in O(n) time, for sequences.
 */
cljs.core.nth = (function cljs$core$nth(var_args){
var G__14761 = arguments.length;
switch (G__14761) {
case 2:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14762(coll,n){
if((!(typeof n === 'number'))){
throw (new Error("Index argument to nth must be a number"));
} else {
if((coll == null)){
return coll;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$))))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
if(cljs.core.array_QMARK_(coll)){
if(((((-1) < n)) && ((n < coll.length)))){
return (coll[(n | (0))]);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(typeof coll === 'string'){
if(((((-1) < n)) && ((n < coll.length)))){
return coll.charAt((n | (0)));
} else {
throw (new Error("Index out of bounds"));
}
} else {
if((function (){var or__9584__auto__ = (((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false);
if(or__9584__auto__){
return or__9584__auto__;
} else {
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISequential$)))){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
if((n < (0))){
throw (new Error("Index out of bounds"));
} else {
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error(["nth not supported on this type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
}));

(cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14766(coll,n,not_found){
if((!(typeof n === 'number'))){
throw (new Error("Index argument to nth must be a number."));
} else {
if((coll == null)){
return not_found;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$))))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$3(null,n,not_found);
} else {
if(cljs.core.array_QMARK_(coll)){
if(((((-1) < n)) && ((n < coll.length)))){
return (coll[(n | (0))]);
} else {
return not_found;
}
} else {
if(typeof coll === 'string'){
if(((((-1) < n)) && ((n < coll.length)))){
return coll.charAt((n | (0)));
} else {
return not_found;
}
} else {
if((function (){var or__9584__auto__ = (((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false);
if(or__9584__auto__){
return or__9584__auto__;
} else {
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISequential$)))){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
if((n < (0))){
return not_found;
} else {
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
throw (new Error(["nth not supported on this type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
}));

(cljs.core.nth.cljs$lang$maxFixedArity = 3);

/**
 * Returns the nth rest of coll, coll when n is 0.
 */
cljs.core.nthrest = (function cljs$core$nthrest(coll,n){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition1$ & (262144))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IDrop$))))?true:false):false)){
if((n > (0))){
var or__9584__auto__ = coll.cljs$core$IDrop$_drop$arity$2(null,Math.ceil(n));
if(cljs.core.truth_(or__9584__auto__)){
return or__9584__auto__;
} else {
return cljs.core.List.EMPTY;
}
} else {
return coll;
}
} else {
var n__$1 = n;
var xs = coll;
while(true){
var temp__5718__auto__ = (((n__$1 > (0))) && (cljs.core.seq(xs)));
if(temp__5718__auto__){
var xs__$1 = temp__5718__auto__;
var G__14772 = (n__$1 - (1));
var G__14773 = cljs.core.rest(xs__$1);
n__$1 = G__14772;
xs = G__14773;
continue;
} else {
return xs;
}
break;
}
}
});
/**
 * Returns the value mapped to key, not-found or nil if key not present
 *   in associative collection, set, string, array, or ILookup instance.
 */
cljs.core.get = (function cljs$core$get(var_args){
var G__14775 = arguments.length;
switch (G__14775) {
case 2:
return cljs.core.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.get.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14776(o,k){
if((o == null)){
return null;
} else {
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$))))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$2(null,k);
} else {
if(cljs.core.array_QMARK_(o)){
if((((!((k == null)))) && ((k < o.length)))){
return (o[(k | (0))]);
} else {
return null;
}
} else {
if(typeof o === 'string'){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return o.charAt((k | (0)));
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o,k);
} else {
return null;

}
}
}
}
}
}));

(cljs.core.get.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14778(o,k,not_found){
if((!((o == null)))){
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$))))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
} else {
if(cljs.core.array_QMARK_(o)){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return (o[(k | (0))]);
} else {
return not_found;
}
} else {
if(typeof o === 'string'){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return o.charAt((k | (0)));
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
} else {
return not_found;

}
}
}
}
} else {
return not_found;
}
}));

(cljs.core.get.cljs$lang$maxFixedArity = 3);



/**
 * assoc[iate]. When applied to a map, returns a new map of the
 * same (hashed/sorted) type, that contains the mapping of key(s) to
 * val(s). When applied to a vector, returns a new vector that
 * contains val at index. Note - index must be <= (count vector).
 */
cljs.core.assoc = (function cljs$core$assoc(var_args){
var G__14786 = arguments.length;
switch (G__14786) {
case 3:
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___14792 = arguments.length;
var i__10914__auto___14793 = (0);
while(true){
if((i__10914__auto___14793 < len__10913__auto___14792)){
args_arr__10942__auto__.push((arguments[i__10914__auto___14793]));

var G__14794 = (i__10914__auto___14793 + (1));
i__10914__auto___14793 = G__14794;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((3) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((3)),(0),null)):null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10943__auto__);

}
});

(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14787(coll,k,v){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IAssociative$))))?true:false):false)){
return coll.cljs$core$IAssociative$_assoc$arity$3(null,k,v);
} else {
if((!((coll == null)))){
return cljs.core._assoc(coll,k,v);
} else {
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k,v]);
}
}
}));

(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14789(coll,k,v,kvs){
while(true){
var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);
if(cljs.core.truth_(kvs)){
var G__14795 = ret;
var G__14796 = cljs.core.first(kvs);
var G__14797 = cljs.core.second(kvs);
var G__14798 = cljs.core.nnext(kvs);
coll = G__14795;
k = G__14796;
v = G__14797;
kvs = G__14798;
continue;
} else {
return ret;
}
break;
}
}));

/** @this {Function} */
(cljs.core.assoc.cljs$lang$applyTo = (function cljs$core$fn_14790(seq14782){
var G__14783 = cljs.core.first(seq14782);
var seq14782__$1 = cljs.core.next(seq14782);
var G__14784 = cljs.core.first(seq14782__$1);
var seq14782__$2 = cljs.core.next(seq14782__$1);
var G__14785 = cljs.core.first(seq14782__$2);
var seq14782__$3 = cljs.core.next(seq14782__$2);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14783,G__14784,G__14785,seq14782__$3);
}));

(cljs.core.assoc.cljs$lang$maxFixedArity = (3));

/**
 * dissoc[iate]. Returns a new map of the same (hashed/sorted) type,
 *   that does not contain a mapping for key(s).
 */
cljs.core.dissoc = (function cljs$core$dissoc(var_args){
var G__14803 = arguments.length;
switch (G__14803) {
case 1:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___14809 = arguments.length;
var i__10914__auto___14810 = (0);
while(true){
if((i__10914__auto___14810 < len__10913__auto___14809)){
args_arr__10942__auto__.push((arguments[i__10914__auto___14810]));

var G__14811 = (i__10914__auto___14810 + (1));
i__10914__auto___14810 = G__14811;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14804(coll){
return coll;
}));

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14805(coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._dissoc(coll,k);
}
}));

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14806(coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__14812 = ret;
var G__14813 = cljs.core.first(ks);
var G__14814 = cljs.core.next(ks);
coll = G__14812;
k = G__14813;
ks = G__14814;
continue;
} else {
return ret;
}
}
break;
}
}));

/** @this {Function} */
(cljs.core.dissoc.cljs$lang$applyTo = (function cljs$core$fn_14807(seq14800){
var G__14801 = cljs.core.first(seq14800);
var seq14800__$1 = cljs.core.next(seq14800);
var G__14802 = cljs.core.first(seq14800__$1);
var seq14800__$2 = cljs.core.next(seq14800__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14801,G__14802,seq14800__$2);
}));

(cljs.core.dissoc.cljs$lang$maxFixedArity = (2));

/**
 * Return true if f is a JavaScript function or satisfies the Fn protocol.
 */
cljs.core.fn_QMARK_ = (function cljs$core$fn_QMARK_(f){
var or__9584__auto__ = typeof f === 'function';
if(or__9584__auto__){
return or__9584__auto__;
} else {
if((!((f == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$Fn$)))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
}
}
});

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.MetaFn = (function (afn,meta){
this.afn = afn;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 393217;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_14817(_){
var self__ = this;
var ___$1 = this;
return self__.meta;
}));

(cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_14818(_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.MetaFn(self__.afn,new_meta));
}));

(cljs.core.MetaFn.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.MetaFn.prototype.call = (function() {
var cljs$core$fn_14819 = null;
var cljs$core$fn_14819__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});
var cljs$core$fn_14819__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));
});
var cljs$core$fn_14819__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));
});
var cljs$core$fn_14819__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));
});
var cljs$core$fn_14819__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));
});
var cljs$core$fn_14819__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));
});
var cljs$core$fn_14819__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));
});
var cljs$core$fn_14819__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));
});
var cljs$core$fn_14819__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));
});
var cljs$core$fn_14819__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));
});
var cljs$core$fn_14819__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));
});
var cljs$core$fn_14819__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));
});
var cljs$core$fn_14819__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});
var cljs$core$fn_14819__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});
var cljs$core$fn_14819__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});
var cljs$core$fn_14819__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});
var cljs$core$fn_14819__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});
var cljs$core$fn_14819__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});
var cljs$core$fn_14819__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});
var cljs$core$fn_14819__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});
var cljs$core$fn_14819__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});
var cljs$core$fn_14819__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(self__.afn,a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
});
cljs$core$fn_14819 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return cljs$core$fn_14819__1.call(this,self__);
case 2:
return cljs$core$fn_14819__2.call(this,self__,a);
case 3:
return cljs$core$fn_14819__3.call(this,self__,a,b);
case 4:
return cljs$core$fn_14819__4.call(this,self__,a,b,c);
case 5:
return cljs$core$fn_14819__5.call(this,self__,a,b,c,d);
case 6:
return cljs$core$fn_14819__6.call(this,self__,a,b,c,d,e);
case 7:
return cljs$core$fn_14819__7.call(this,self__,a,b,c,d,e,f);
case 8:
return cljs$core$fn_14819__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return cljs$core$fn_14819__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return cljs$core$fn_14819__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return cljs$core$fn_14819__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return cljs$core$fn_14819__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return cljs$core$fn_14819__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return cljs$core$fn_14819__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return cljs$core$fn_14819__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return cljs$core$fn_14819__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return cljs$core$fn_14819__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return cljs$core$fn_14819__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return cljs$core$fn_14819__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return cljs$core$fn_14819__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return cljs$core$fn_14819__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return cljs$core$fn_14819__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_14819.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14819__1;
cljs$core$fn_14819.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14819__2;
cljs$core$fn_14819.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14819__3;
cljs$core$fn_14819.cljs$core$IFn$_invoke$arity$4 = cljs$core$fn_14819__4;
cljs$core$fn_14819.cljs$core$IFn$_invoke$arity$5 = cljs$core$fn_14819__5;
cljs$core$fn_14819.cljs$core$IFn$_invoke$arity$6 = cljs$core$fn_14819__6;
cljs$core$fn_14819.cljs$core$IFn$_invoke$arity$7 = cljs$core$fn_14819__7;
cljs$core$fn_14819.cljs$core$IFn$_invoke$arity$8 = cljs$core$fn_14819__8;
cljs$core$fn_14819.cljs$core$IFn$_invoke$arity$9 = cljs$core$fn_14819__9;
cljs$core$fn_14819.cljs$core$IFn$_invoke$arity$10 = cljs$core$fn_14819__10;
cljs$core$fn_14819.cljs$core$IFn$_invoke$arity$11 = cljs$core$fn_14819__11;
cljs$core$fn_14819.cljs$core$IFn$_invoke$arity$12 = cljs$core$fn_14819__12;
cljs$core$fn_14819.cljs$core$IFn$_invoke$arity$13 = cljs$core$fn_14819__13;
cljs$core$fn_14819.cljs$core$IFn$_invoke$arity$14 = cljs$core$fn_14819__14;
cljs$core$fn_14819.cljs$core$IFn$_invoke$arity$15 = cljs$core$fn_14819__15;
cljs$core$fn_14819.cljs$core$IFn$_invoke$arity$16 = cljs$core$fn_14819__16;
cljs$core$fn_14819.cljs$core$IFn$_invoke$arity$17 = cljs$core$fn_14819__17;
cljs$core$fn_14819.cljs$core$IFn$_invoke$arity$18 = cljs$core$fn_14819__18;
cljs$core$fn_14819.cljs$core$IFn$_invoke$arity$19 = cljs$core$fn_14819__19;
cljs$core$fn_14819.cljs$core$IFn$_invoke$arity$20 = cljs$core$fn_14819__20;
cljs$core$fn_14819.cljs$core$IFn$_invoke$arity$21 = cljs$core$fn_14819__21;
cljs$core$fn_14819.cljs$core$IFn$_invoke$arity$22 = cljs$core$fn_14819__22;
return cljs$core$fn_14819;
})()
);

(cljs.core.MetaFn.prototype.apply = (function cljs$core$fn_14820(self__,args14816){
var self__ = this;
var self____$1 = this;
var args__10187__auto__ = cljs.core.aclone(args14816);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10187__auto__.length > (20)))?(function (){var G__14821 = args__10187__auto__.slice((0),(20));
G__14821.push(args__10187__auto__.slice((20)));

return G__14821;
})():args__10187__auto__)));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14822(){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14823(a){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14824(a,b){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14825(a,b,c){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14826(a,b,c,d){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_14827(a,b,c,d,e){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_14828(a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function cljs$core$fn_14829(a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function cljs$core$fn_14830(a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function cljs$core$fn_14831(a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function cljs$core$fn_14832(a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function cljs$core$fn_14833(a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function cljs$core$fn_14834(a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function cljs$core$fn_14835(a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function cljs$core$fn_14836(a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function cljs$core$fn_14837(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function cljs$core$fn_14838(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function cljs$core$fn_14839(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function cljs$core$fn_14840(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function cljs$core$fn_14841(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function cljs$core$fn_14842(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function cljs$core$fn_14843(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(self__.afn,a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
}));

(cljs.core.MetaFn.getBasis = (function cljs$core$fn_14844(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.MetaFn.cljs$lang$type = true);

(cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn");

(cljs.core.MetaFn.cljs$lang$ctorPrWriter = (function cljs$core$fn_14845(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/MetaFn");
}));

/**
 * Positional factory function for cljs.core/MetaFn.
 */
cljs.core.__GT_MetaFn = (function cljs$core$__GT_MetaFn(afn,meta){
return (new cljs.core.MetaFn(afn,meta));
});

/**
 * Returns an object of the same type and value as obj, with
 *   map m as its metadata.
 */
cljs.core.with_meta = (function cljs$core$with_meta(o,meta){
if(typeof o === 'function'){
return (new cljs.core.MetaFn(o,meta));
} else {
if((o == null)){
return null;
} else {
return cljs.core._with_meta(o,meta);
}
}
});
/**
 * Returns the metadata of obj, returns nil if there is no metadata.
 */
cljs.core.meta = (function cljs$core$meta(o){
if((function (){var and__9578__auto__ = (!((o == null)));
if(and__9578__auto__){
if((!((o == null)))){
if((((o.cljs$lang$protocol_mask$partition0$ & (131072))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMeta$)))){
return true;
} else {
if((!o.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
}
} else {
return and__9578__auto__;
}
})()){
return cljs.core._meta(o);
} else {
return null;
}
});
/**
 * For a list or queue, same as first, for a vector, same as, but much
 *   more efficient than, last. If the collection is empty, returns nil.
 */
cljs.core.peek = (function cljs$core$peek(coll){
if((coll == null)){
return null;
} else {
return cljs.core._peek(coll);
}
});
/**
 * For a list or queue, returns a new list/queue without the first
 *   item, for a vector, returns a new vector without the last item.
 *   Note - not the same as next/butlast.
 */
cljs.core.pop = (function cljs$core$pop(coll){
if((coll == null)){
return null;
} else {
return cljs.core._pop(coll);
}
});
/**
 * disj[oin]. Returns a new set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj = (function cljs$core$disj(var_args){
var G__14851 = arguments.length;
switch (G__14851) {
case 1:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___14857 = arguments.length;
var i__10914__auto___14858 = (0);
while(true){
if((i__10914__auto___14858 < len__10913__auto___14857)){
args_arr__10942__auto__.push((arguments[i__10914__auto___14858]));

var G__14859 = (i__10914__auto___14858 + (1));
i__10914__auto___14858 = G__14859;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14852(coll){
return coll;
}));

(cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14853(coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._disjoin(coll,k);
}
}));

(cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14854(coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__14860 = ret;
var G__14861 = cljs.core.first(ks);
var G__14862 = cljs.core.next(ks);
coll = G__14860;
k = G__14861;
ks = G__14862;
continue;
} else {
return ret;
}
}
break;
}
}));

/** @this {Function} */
(cljs.core.disj.cljs$lang$applyTo = (function cljs$core$fn_14855(seq14848){
var G__14849 = cljs.core.first(seq14848);
var seq14848__$1 = cljs.core.next(seq14848);
var G__14850 = cljs.core.first(seq14848__$1);
var seq14848__$2 = cljs.core.next(seq14848__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14849,G__14850,seq14848__$2);
}));

(cljs.core.disj.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if coll has no items. To check the emptiness of a seq,
 *   please use the idiom (seq x) rather than (not (empty? x))
 */
cljs.core.empty_QMARK_ = (function cljs$core$empty_QMARK_(coll){
if((coll == null)){
return true;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ICounted$))))?true:(((!coll.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,coll):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,coll))){
return (cljs.core._count(coll) === (0));
} else {
return cljs.core.not(cljs.core.seq(coll));

}
}
});
/**
 * Returns true if x satisfies ICollection
 */
cljs.core.coll_QMARK_ = (function cljs$core$coll_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (8))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICollection$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
}
}
});
/**
 * Returns true if x satisfies ISet
 */
cljs.core.set_QMARK_ = (function cljs$core$set_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
}
}
});
/**
 * Returns true if coll implements IAssociative
 */
cljs.core.associative_QMARK_ = (function cljs$core$associative_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IAssociative$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
}
});
/**
 * Returns true if coll implements IFind
 */
cljs.core.ifind_QMARK_ = (function cljs$core$ifind_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IFind$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x);
}
});
/**
 * Returns true if coll satisfies ISequential
 */
cljs.core.sequential_QMARK_ = (function cljs$core$sequential_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
}
});
/**
 * Returns true if coll satisfies ISorted
 */
cljs.core.sorted_QMARK_ = (function cljs$core$sorted_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (268435456))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISorted$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
}
});
/**
 * Returns true if coll satisfies IReduce
 */
cljs.core.reduceable_QMARK_ = (function cljs$core$reduceable_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IReduce$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
}
});
/**
 * Return true if x satisfies IMap
 */
cljs.core.map_QMARK_ = (function cljs$core$map_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
}
}
});
/**
 * Return true if x satisfies IRecord
 */
cljs.core.record_QMARK_ = (function cljs$core$record_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (67108864))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IRecord$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
}
});
/**
 * Return true if x satisfies IVector
 */
cljs.core.vector_QMARK_ = (function cljs$core$vector_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16384))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IVector$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
}
});

/**
 * Return true if x satisfies IChunkedSeq.
 */
cljs.core.chunked_seq_QMARK_ = (function cljs$core$chunked_seq_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition1$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IChunkedSeq$)))){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Create JavaSript object from an even number arguments representing
 *   interleaved keys and values.
 */
cljs.core.js_obj = (function cljs$core$js_obj(var_args){
var G__14877 = arguments.length;
switch (G__14877) {
case 0:
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___14884 = arguments.length;
var i__10914__auto___14885 = (0);
while(true){
if((i__10914__auto___14885 < len__10913__auto___14884)){
args_arr__10942__auto__.push((arguments[i__10914__auto___14885]));

var G__14886 = (i__10914__auto___14885 + (1));
i__10914__auto___14885 = G__14886;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((0) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((0)),(0),null)):null);
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__10943__auto__);

}
});

(cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14878(){
return ({});
}));

(cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14881(keyvals){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.goog$module$goog$object.create,keyvals);
}));

/** @this {Function} */
(cljs.core.js_obj.cljs$lang$applyTo = (function cljs$core$fn_14882(seq14876){
var self__10899__auto__ = this;
return self__10899__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq14876));
}));

(cljs.core.js_obj.cljs$lang$maxFixedArity = (0));

/**
 * Return the JavaScript keys for an object.
 */
cljs.core.js_keys = (function cljs$core$js_keys(obj){
return cljs.core.goog$module$goog$object.getKeys.call(null,obj);
});
/**
 * Delete a property from a JavaScript object.
 *   Returns true upon success, false otherwise.
 */
cljs.core.js_delete = (function cljs$core$js_delete(obj,key){
return delete obj[key];
});
cljs.core.array_copy = (function cljs$core$array_copy(from,i,to,j,len){
var i__$1 = i;
var j__$1 = j;
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__14887 = (i__$1 + (1));
var G__14888 = (j__$1 + (1));
var G__14889 = (len__$1 - (1));
i__$1 = G__14887;
j__$1 = G__14888;
len__$1 = G__14889;
continue;
}
break;
}
});
cljs.core.array_copy_downward = (function cljs$core$array_copy_downward(from,i,to,j,len){
var i__$1 = (i + (len - (1)));
var j__$1 = (j + (len - (1)));
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__14890 = (i__$1 - (1));
var G__14891 = (j__$1 - (1));
var G__14892 = (len__$1 - (1));
i__$1 = G__14890;
j__$1 = G__14891;
len__$1 = G__14892;
continue;
}
break;
}
});
cljs.core.lookup_sentinel = ({});
/**
 * Returns true if x is the value false, false otherwise.
 */
cljs.core.false_QMARK_ = (function cljs$core$false_QMARK_(x){
return x === false;
});
/**
 * Returns true if x is the value true, false otherwise.
 */
cljs.core.true_QMARK_ = (function cljs$core$true_QMARK_(x){
return x === true;
});
/**
 * Return true if x is a Boolean
 */
cljs.core.boolean_QMARK_ = (function cljs$core$boolean_QMARK_(x){
return ((x === true) || (x === false));
});
/**
 * Returns true if x identical to the JavaScript undefined value.
 */
cljs.core.undefined_QMARK_ = (function cljs$core$undefined_QMARK_(x){
return (void 0 === x);
});
/**
 * Return true if s satisfies ISeq
 */
cljs.core.seq_QMARK_ = (function cljs$core$seq_QMARK_(s){
if((s == null)){
return false;
} else {
if((!((s == null)))){
if((((s.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeq$)))){
return true;
} else {
if((!s.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
}
}
});
/**
 * Return true if the seq function is supported for s
 */
cljs.core.seqable_QMARK_ = (function cljs$core$seqable_QMARK_(s){
var or__9584__auto__ = (s == null);
if(or__9584__auto__){
return or__9584__auto__;
} else {
var or__9584__auto____$1 = (((!((s == null))))?(((((s.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeqable$))))?true:(((!s.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s));
if(or__9584__auto____$1){
return or__9584__auto____$1;
} else {
return ((cljs.core.js_iterable_QMARK_(s)) || (((cljs.core.array_QMARK_(s)) || (typeof s === 'string'))));
}
}
});
/**
 * Coerce to boolean
 */
cljs.core.boolean$ = (function cljs$core$boolean(x){
if((x == null)){
return false;
} else {
if(x === false){
return false;
} else {
return true;

}
}
});
/**
 * Returns true if f returns true for fn? or satisfies IFn.
 */
cljs.core.ifn_QMARK_ = (function cljs$core$ifn_QMARK_(f){
var or__9584__auto__ = cljs.core.fn_QMARK_(f);
if(or__9584__auto__){
return or__9584__auto__;
} else {
if((!((f == null)))){
if((((f.cljs$lang$protocol_mask$partition0$ & (1))) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$IFn$)))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
}
}
});
/**
 * Returns true if n is a JavaScript number with no decimal part.
 */
cljs.core.integer_QMARK_ = (function cljs$core$integer_QMARK_(n){
return ((typeof n === 'number') && ((((!(isNaN(n)))) && ((((!((n === Infinity)))) && ((parseFloat(n) === parseInt(n,(10)))))))));
});
/**
 * INTERNAL: do not use
 */
cljs.core.LongImpl = cljs.core.goog$module$goog$math$Long;
/**
 * Return true if x satisfies integer? or is an instance of goog.math.Integer
 * or goog.math.Long.
 */
cljs.core.int_QMARK_ = (function cljs$core$int_QMARK_(x){
return ((cljs.core.integer_QMARK_(x)) || ((((x instanceof goog.math.Integer)) || ((x instanceof cljs.core.goog$module$goog$math$Long)))));
});
/**
 * Return true if x satisfies int? and is positive.
 */
cljs.core.pos_int_QMARK_ = (function cljs$core$pos_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (x > (0));
} else {
if((x instanceof goog.math.Integer)){
return ((cljs.core.not(x.isNegative())) && (cljs.core.not(x.isZero())));
} else {
if((x instanceof cljs.core.goog$module$goog$math$Long)){
return ((cljs.core.not(x.isNegative())) && (cljs.core.not(x.isZero())));
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is negative.
 */
cljs.core.neg_int_QMARK_ = (function cljs$core$neg_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (x < (0));
} else {
if((x instanceof goog.math.Integer)){
return x.isNegative();
} else {
if((x instanceof cljs.core.goog$module$goog$math$Long)){
return x.isNegative();
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is a natural integer value.
 */
cljs.core.nat_int_QMARK_ = (function cljs$core$nat_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (!((x < (0))));
} else {
if((x instanceof goog.math.Integer)){
return cljs.core.not(x.isNegative());
} else {
if((x instanceof cljs.core.goog$module$goog$math$Long)){
return cljs.core.not(x.isNegative());
} else {
return false;

}
}
}
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.float_QMARK_ = (function cljs$core$float_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.double_QMARK_ = (function cljs$core$double_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for Infinity and -Infinity values.
 */
cljs.core.infinite_QMARK_ = (function cljs$core$infinite_QMARK_(x){
return (((x === Number.POSITIVE_INFINITY)) || ((x === Number.NEGATIVE_INFINITY)));
});
/**
 * Returns true if key is present in the given collection, otherwise
 *   returns false.  Note that for numerically indexed collections like
 *   vectors and arrays, this tests if the numeric key is within the
 *   range of indexes. 'contains?' operates constant or logarithmic time;
 *   it will not perform a linear search for a value.  See also 'some'.
 */
cljs.core.contains_QMARK_ = (function cljs$core$contains_QMARK_(coll,v){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IAssociative$))))?true:false):false)){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(null,v);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,coll)){
return cljs.core._contains_key_QMARK_(coll,v);
} else {
if((cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return false;
} else {
return true;

}
}
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core.find = (function cljs$core$find(coll,k){
if(cljs.core.ifind_QMARK_(coll)){
return cljs.core._find(coll,k);
} else {
if((((!((coll == null)))) && (((cljs.core.associative_QMARK_(coll)) && (cljs.core.contains_QMARK_(coll,k)))))){
return (new cljs.core.MapEntry(k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k),null));
} else {
return null;
}
}
});
/**
 * Returns true if no two of the arguments are =
 */
cljs.core.distinct_QMARK_ = (function cljs$core$distinct_QMARK_(var_args){
var G__14903 = arguments.length;
switch (G__14903) {
case 1:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___14909 = arguments.length;
var i__10914__auto___14910 = (0);
while(true){
if((i__10914__auto___14910 < len__10913__auto___14909)){
args_arr__10942__auto__.push((arguments[i__10914__auto___14910]));

var G__14911 = (i__10914__auto___14910 + (1));
i__10914__auto___14910 = G__14911;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14904(x){
return true;
}));

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14905(x,y){
return (!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)));
}));

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14906(x,y,more){
if((!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)))){
var s = cljs.core.PersistentHashSet.createAsIfByAssoc([x,y]);
var xs = more;
while(true){
var x__$1 = cljs.core.first(xs);
var etc = cljs.core.next(xs);
if(cljs.core.truth_(xs)){
if(cljs.core.contains_QMARK_(s,x__$1)){
return false;
} else {
var G__14912 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);
var G__14913 = etc;
s = G__14912;
xs = G__14913;
continue;
}
} else {
return true;
}
break;
}
} else {
return false;
}
}));

/** @this {Function} */
(cljs.core.distinct_QMARK_.cljs$lang$applyTo = (function cljs$core$fn_14907(seq14900){
var G__14901 = cljs.core.first(seq14900);
var seq14900__$1 = cljs.core.next(seq14900);
var G__14902 = cljs.core.first(seq14900__$1);
var seq14900__$2 = cljs.core.next(seq14900__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14901,G__14902,seq14900__$2);
}));

(cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = (2));

/**
 * Comparator. Returns a negative number, zero, or a positive number
 *   when x is logically 'less than', 'equal to', or 'greater than'
 *   y. Uses IComparable if available and google.array.defaultCompare for objects
 *  of the same type and special-cases nil to be less than any other object.
 */
cljs.core.compare = (function cljs$core$compare(x,y){
if((x === y)){
return (0);
} else {
if((x == null)){
return (-1);
} else {
if((y == null)){
return (1);
} else {
if(typeof x === 'number'){
if(typeof y === 'number'){
return cljs.core.goog$module$goog$array.defaultCompare.call(null,x,y);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join('')));
}
} else {
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition1$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IComparable$))))?true:(((!x.cljs$lang$protocol_mask$partition1$))?cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x))){
return cljs.core._compare(x,y);
} else {
if(((((typeof x === 'string') || (((cljs.core.array_QMARK_(x)) || (((x === true) || (x === false))))))) && ((cljs.core.type(x) === cljs.core.type(y))))){
return cljs.core.goog$module$goog$array.defaultCompare.call(null,x,y);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join('')));
}

}
}
}
}
}
});
/**
 * Compare indexed collection.
 */
cljs.core.compare_indexed = (function cljs$core$compare_indexed(var_args){
var G__14916 = arguments.length;
switch (G__14916) {
case 2:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14917(xs,ys){
var xl = cljs.core.count(xs);
var yl = cljs.core.count(ys);
if((xl < yl)){
return (-1);
} else {
if((xl > yl)){
return (1);
} else {
if((xl === (0))){
return (0);
} else {
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,(0));

}
}
}
}));

(cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14918(xs,ys,len,n){
while(true){
var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));
if((((d === (0))) && (((n + (1)) < len)))){
var G__14920 = xs;
var G__14921 = ys;
var G__14922 = len;
var G__14923 = (n + (1));
xs = G__14920;
ys = G__14921;
len = G__14922;
n = G__14923;
continue;
} else {
return d;
}
break;
}
}));

(cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4);

/**
 * Given a fn that might be boolean valued or a comparator,
 * return a fn that is a comparator.
 */
cljs.core.fn__GT_comparator = (function cljs$core$fn__GT_comparator(f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare)){
return cljs.core.compare;
} else {
return (function cljs$core$fn__GT_comparator_$_fn_14924(x,y){
var r = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
if(typeof r === 'number'){
return r;
} else {
if(cljs.core.truth_(r)){
return (-1);
} else {
if(cljs.core.truth_((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(y,x) : f.call(null,y,x)))){
return (1);
} else {
return (0);
}
}
}
});
}
});
/**
 * Returns a sorted sequence of the items in coll. Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort = (function cljs$core$sort(var_args){
var G__14926 = arguments.length;
switch (G__14926) {
case 1:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14927(coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll);
}));

(cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14928(comp,coll){
if(cljs.core.seq(coll)){
var a = cljs.core.to_array(coll);
var G__14929_14932 = a;
var G__14930_14933 = cljs.core.fn__GT_comparator(comp);
cljs.core.goog$module$goog$array.stableSort.call(null,G__14929_14932,G__14930_14933);

return cljs.core.with_meta(cljs.core.seq(a),cljs.core.meta(coll));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.sort.cljs$lang$maxFixedArity = 2);

/**
 * Returns a sorted sequence of the items in coll, where the sort
 * order is determined by comparing (keyfn item).  Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort_by = (function cljs$core$sort_by(var_args){
var G__14935 = arguments.length;
switch (G__14935) {
case 2:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14936(keyfn,coll){
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll);
}));

(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14937(keyfn,comp,coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function cljs$core$fn_14937_$_fn_14938(x,y){
var G__14940 = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(x) : keyfn.call(null,x));
var G__14941 = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(y) : keyfn.call(null,y));
var fexpr__14939 = cljs.core.fn__GT_comparator(comp);
return (fexpr__14939.cljs$core$IFn$_invoke$arity$2 ? fexpr__14939.cljs$core$IFn$_invoke$arity$2(G__14940,G__14941) : fexpr__14939.call(null,G__14940,G__14941));
}),coll);
}));

(cljs.core.sort_by.cljs$lang$maxFixedArity = 3);

cljs.core.seq_reduce = (function cljs$core$seq_reduce(var_args){
var G__14944 = arguments.length;
switch (G__14944) {
case 2:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14945(f,coll){
var temp__5718__auto__ = cljs.core.seq(coll);
if(temp__5718__auto__){
var s = temp__5718__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f,cljs.core.first(s),cljs.core.next(s));
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
}));

(cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14946(f,val,coll){
var val__$1 = val;
var coll__$1 = cljs.core.seq(coll);
while(true){
if(coll__$1){
var nval = (function (){var G__14947 = val__$1;
var G__14948 = cljs.core.first(coll__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14947,G__14948) : f.call(null,G__14947,G__14948));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14950 = nval;
var G__14951 = cljs.core.next(coll__$1);
val__$1 = G__14950;
coll__$1 = G__14951;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3);

/**
 * Return a random permutation of coll
 */
cljs.core.shuffle = (function cljs$core$shuffle(coll){
var a = cljs.core.to_array(coll);
cljs.core.goog$module$goog$array.shuffle.call(null,a);

return cljs.core.vec(a);
});
cljs.core.iter_reduce = (function cljs$core$iter_reduce(var_args){
var G__14953 = arguments.length;
switch (G__14953) {
case 2:
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14954(coll,f){
var iter = cljs.core._iterator(coll);
if(cljs.core.truth_(iter.hasNext())){
var init = iter.next();
var acc = init;
while(true){
if(iter.hasNext()){
var nacc = (function (){var G__14955 = acc;
var G__14956 = iter.next();
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14955,G__14956) : f.call(null,G__14955,G__14956));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__14961 = nacc;
acc = G__14961;
continue;
}
} else {
return acc;
}
break;
}
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
}));

(cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14957(coll,f,init){
var iter = cljs.core._iterator(coll);
var acc = init;
while(true){
if(iter.hasNext()){
var nacc = (function (){var G__14958 = acc;
var G__14959 = iter.next();
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14958,G__14959) : f.call(null,G__14958,G__14959));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__14962 = nacc;
acc = G__14962;
continue;
}
} else {
return acc;
}
break;
}
}));

(cljs.core.iter_reduce.cljs$lang$maxFixedArity = 3);

/**
 * f should be a function of 2 arguments. If val is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc. If coll contains no
 *   items, f must accept no arguments as well, and reduce returns the
 *   result of calling f with no arguments.  If coll has only 1 item, it
 *   is returned and f is not called.  If val is supplied, returns the
 *   result of applying f to val and the first item in coll, then
 *   applying f to that result and the 2nd item, etc. If coll contains no
 *   items, returns val and f is not called.
 */
cljs.core.reduce = (function cljs$core$reduce(var_args){
var G__14964 = arguments.length;
switch (G__14964) {
case 2:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14965(f,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$))))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$2(null,f);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll);

}
}
}
}
}
}));

(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14967(f,val,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$))))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$3(null,f,val);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll);

}
}
}
}
}
}));

(cljs.core.reduce.cljs$lang$maxFixedArity = 3);

/**
 * Reduces an associative collection. f should be a function of 3
 *   arguments. Returns the result of applying f to init, the first key
 *   and the first value in coll, then applying f to that result and the
 *   2nd key and value, etc. If coll contains no entries, returns init
 *   and f is not called. Note that reduce-kv is supported on vectors,
 *   where the keys will be the ordinals.
 */
cljs.core.reduce_kv = (function cljs$core$reduce_kv(f,init,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (1048576))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IKVReduce$))))?true:(((!coll.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,coll):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,coll))){
return cljs.core._kv_reduce(coll,f,init);
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function cljs$core$reduce_kv_$_fn_14971(ret,me){
var G__14972 = ret;
var G__14973 = cljs.core._key(me);
var G__14974 = cljs.core._val(me);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__14972,G__14973,G__14974) : f.call(null,G__14972,G__14973,G__14974));
}),init,coll);
}
});
/**
 * Returns its argument.
 */
cljs.core.identity = (function cljs$core$identity(x){
return x;
});
/**
 * Takes a reducing function f of 2 args and returns a fn suitable for
 *   transduce by adding an arity-1 signature that calls cf (default -
 *   identity) on the result argument.
 */
cljs.core.completing = (function cljs$core$completing(var_args){
var G__14976 = arguments.length;
switch (G__14976) {
case 1:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14977(f){
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity);
}));

(cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14978(f,cf){
return (function() {
var cljs$core$fn_14978_$_fn_14979 = null;
var cljs$core$fn_14978_$_fn_14979__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
var cljs$core$fn_14978_$_fn_14979__1 = (function (x){
return (cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(x) : cf.call(null,x));
});
var cljs$core$fn_14978_$_fn_14979__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
});
cljs$core$fn_14978_$_fn_14979 = function(x,y){
switch(arguments.length){
case 0:
return cljs$core$fn_14978_$_fn_14979__0.call(this);
case 1:
return cljs$core$fn_14978_$_fn_14979__1.call(this,x);
case 2:
return cljs$core$fn_14978_$_fn_14979__2.call(this,x,y);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14978_$_fn_14979.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_14978_$_fn_14979__0;
cljs$core$fn_14978_$_fn_14979.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14978_$_fn_14979__1;
cljs$core$fn_14978_$_fn_14979.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14978_$_fn_14979__2;
return cljs$core$fn_14978_$_fn_14979;
})()
}));

(cljs.core.completing.cljs$lang$maxFixedArity = 2);

/**
 * reduce with a transformation of f (xf). If init is not
 *   supplied, (f) will be called to produce it. f should be a reducing
 *   step function that accepts both 1 and 2 arguments, if it accepts
 *   only 2 you can add the arity-1 with 'completing'. Returns the result
 *   of applying (the transformed) xf to init and the first item in coll,
 *   then applying xf to that result and the 2nd item, etc. If coll
 *   contains no items, returns init and f is not called. Note that
 *   certain transforms may inject or skip items.
 */
cljs.core.transduce = (function cljs$core$transduce(var_args){
var G__14982 = arguments.length;
switch (G__14982) {
case 3:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14983(xform,f,coll){
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,f,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),coll);
}));

(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14984(xform,f,init,coll){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);
return (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(ret) : f__$1.call(null,ret));
}));

(cljs.core.transduce.cljs$lang$maxFixedArity = 4);

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core._PLUS_ = (function cljs$core$_PLUS_(var_args){
var G__14990 = arguments.length;
switch (G__14990) {
case 0:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___14997 = arguments.length;
var i__10914__auto___14998 = (0);
while(true){
if((i__10914__auto___14998 < len__10913__auto___14997)){
args_arr__10942__auto__.push((arguments[i__10914__auto___14998]));

var G__14999 = (i__10914__auto___14998 + (1));
i__10914__auto___14998 = G__14999;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14991(){
return (0);
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14992(x){
return x;
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14993(x,y){
return (x + y);
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14994(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(x + y),more);
}));

/** @this {Function} */
(cljs.core._PLUS_.cljs$lang$applyTo = (function cljs$core$fn_14995(seq14987){
var G__14988 = cljs.core.first(seq14987);
var seq14987__$1 = cljs.core.next(seq14987);
var G__14989 = cljs.core.first(seq14987__$1);
var seq14987__$2 = cljs.core.next(seq14987__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14988,G__14989,seq14987__$2);
}));

(cljs.core._PLUS_.cljs$lang$maxFixedArity = (2));

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core._ = (function cljs$core$_(var_args){
var G__15004 = arguments.length;
switch (G__15004) {
case 1:
return cljs.core._.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15010 = arguments.length;
var i__10914__auto___15011 = (0);
while(true){
if((i__10914__auto___15011 < len__10913__auto___15010)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15011]));

var G__15012 = (i__10914__auto___15011 + (1));
i__10914__auto___15011 = G__15012;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core._.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15005(x){
return (- x);
}));

(cljs.core._.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15006(x,y){
return (x - y);
}));

(cljs.core._.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15007(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,(x - y),more);
}));

/** @this {Function} */
(cljs.core._.cljs$lang$applyTo = (function cljs$core$fn_15008(seq15001){
var G__15002 = cljs.core.first(seq15001);
var seq15001__$1 = cljs.core.next(seq15001);
var G__15003 = cljs.core.first(seq15001__$1);
var seq15001__$2 = cljs.core.next(seq15001__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15002,G__15003,seq15001__$2);
}));

(cljs.core._.cljs$lang$maxFixedArity = (2));

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core._STAR_ = (function cljs$core$_STAR_(var_args){
var G__15017 = arguments.length;
switch (G__15017) {
case 0:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15024 = arguments.length;
var i__10914__auto___15025 = (0);
while(true){
if((i__10914__auto___15025 < len__10913__auto___15024)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15025]));

var G__15026 = (i__10914__auto___15025 + (1));
i__10914__auto___15025 = G__15026;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15018(){
return (1);
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15019(x){
return x;
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15020(x,y){
return (x * y);
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15021(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,(x * y),more);
}));

/** @this {Function} */
(cljs.core._STAR_.cljs$lang$applyTo = (function cljs$core$fn_15022(seq15014){
var G__15015 = cljs.core.first(seq15014);
var seq15014__$1 = cljs.core.next(seq15014);
var G__15016 = cljs.core.first(seq15014__$1);
var seq15014__$2 = cljs.core.next(seq15014__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15015,G__15016,seq15014__$2);
}));

(cljs.core._STAR_.cljs$lang$maxFixedArity = (2));

/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core._SLASH_ = (function cljs$core$_SLASH_(var_args){
var G__15031 = arguments.length;
switch (G__15031) {
case 1:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15037 = arguments.length;
var i__10914__auto___15038 = (0);
while(true){
if((i__10914__auto___15038 < len__10913__auto___15037)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15038]));

var G__15039 = (i__10914__auto___15038 + (1));
i__10914__auto___15038 = G__15039;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15032(x){
return ((1) / x);
}));

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15033(x,y){
return (x / y);
}));

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15034(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(x / y),more);
}));

/** @this {Function} */
(cljs.core._SLASH_.cljs$lang$applyTo = (function cljs$core$fn_15035(seq15028){
var G__15029 = cljs.core.first(seq15028);
var seq15028__$1 = cljs.core.next(seq15028);
var G__15030 = cljs.core.first(seq15028__$1);
var seq15028__$2 = cljs.core.next(seq15028__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15029,G__15030,seq15028__$2);
}));

(cljs.core._SLASH_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically increasing order,
 *   otherwise false.
 */
cljs.core._LT_ = (function cljs$core$_LT_(var_args){
var G__15044 = arguments.length;
switch (G__15044) {
case 1:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15050 = arguments.length;
var i__10914__auto___15051 = (0);
while(true){
if((i__10914__auto___15051 < len__10913__auto___15050)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15051]));

var G__15052 = (i__10914__auto___15051 + (1));
i__10914__auto___15051 = G__15052;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15045(x){
return true;
}));

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15046(x,y){
return (x < y);
}));

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15047(x,y,more){
while(true){
if((x < y)){
if(cljs.core.next(more)){
var G__15053 = y;
var G__15054 = cljs.core.first(more);
var G__15055 = cljs.core.next(more);
x = G__15053;
y = G__15054;
more = G__15055;
continue;
} else {
return (y < cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._LT_.cljs$lang$applyTo = (function cljs$core$fn_15048(seq15041){
var G__15042 = cljs.core.first(seq15041);
var seq15041__$1 = cljs.core.next(seq15041);
var G__15043 = cljs.core.first(seq15041__$1);
var seq15041__$2 = cljs.core.next(seq15041__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15042,G__15043,seq15041__$2);
}));

(cljs.core._LT_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 *   otherwise false.
 */
cljs.core._LT__EQ_ = (function cljs$core$_LT__EQ_(var_args){
var G__15060 = arguments.length;
switch (G__15060) {
case 1:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15066 = arguments.length;
var i__10914__auto___15067 = (0);
while(true){
if((i__10914__auto___15067 < len__10913__auto___15066)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15067]));

var G__15068 = (i__10914__auto___15067 + (1));
i__10914__auto___15067 = G__15068;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15061(x){
return true;
}));

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15062(x,y){
return (x <= y);
}));

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15063(x,y,more){
while(true){
if((x <= y)){
if(cljs.core.next(more)){
var G__15069 = y;
var G__15070 = cljs.core.first(more);
var G__15071 = cljs.core.next(more);
x = G__15069;
y = G__15070;
more = G__15071;
continue;
} else {
return (y <= cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._LT__EQ_.cljs$lang$applyTo = (function cljs$core$fn_15064(seq15057){
var G__15058 = cljs.core.first(seq15057);
var seq15057__$1 = cljs.core.next(seq15057);
var G__15059 = cljs.core.first(seq15057__$1);
var seq15057__$2 = cljs.core.next(seq15057__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15058,G__15059,seq15057__$2);
}));

(cljs.core._LT__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically decreasing order,
 *   otherwise false.
 */
cljs.core._GT_ = (function cljs$core$_GT_(var_args){
var G__15076 = arguments.length;
switch (G__15076) {
case 1:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15082 = arguments.length;
var i__10914__auto___15083 = (0);
while(true){
if((i__10914__auto___15083 < len__10913__auto___15082)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15083]));

var G__15084 = (i__10914__auto___15083 + (1));
i__10914__auto___15083 = G__15084;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15077(x){
return true;
}));

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15078(x,y){
return (x > y);
}));

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15079(x,y,more){
while(true){
if((x > y)){
if(cljs.core.next(more)){
var G__15085 = y;
var G__15086 = cljs.core.first(more);
var G__15087 = cljs.core.next(more);
x = G__15085;
y = G__15086;
more = G__15087;
continue;
} else {
return (y > cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._GT_.cljs$lang$applyTo = (function cljs$core$fn_15080(seq15073){
var G__15074 = cljs.core.first(seq15073);
var seq15073__$1 = cljs.core.next(seq15073);
var G__15075 = cljs.core.first(seq15073__$1);
var seq15073__$2 = cljs.core.next(seq15073__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15074,G__15075,seq15073__$2);
}));

(cljs.core._GT_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 *   otherwise false.
 */
cljs.core._GT__EQ_ = (function cljs$core$_GT__EQ_(var_args){
var G__15092 = arguments.length;
switch (G__15092) {
case 1:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15098 = arguments.length;
var i__10914__auto___15099 = (0);
while(true){
if((i__10914__auto___15099 < len__10913__auto___15098)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15099]));

var G__15100 = (i__10914__auto___15099 + (1));
i__10914__auto___15099 = G__15100;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15093(x){
return true;
}));

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15094(x,y){
return (x >= y);
}));

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15095(x,y,more){
while(true){
if((x >= y)){
if(cljs.core.next(more)){
var G__15101 = y;
var G__15102 = cljs.core.first(more);
var G__15103 = cljs.core.next(more);
x = G__15101;
y = G__15102;
more = G__15103;
continue;
} else {
return (y >= cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._GT__EQ_.cljs$lang$applyTo = (function cljs$core$fn_15096(seq15089){
var G__15090 = cljs.core.first(seq15089);
var seq15089__$1 = cljs.core.next(seq15089);
var G__15091 = cljs.core.first(seq15089__$1);
var seq15089__$2 = cljs.core.next(seq15089__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15090,G__15091,seq15089__$2);
}));

(cljs.core._GT__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns a number one less than num.
 */
cljs.core.dec = (function cljs$core$dec(x){
return (x - (1));
});
/**
 * Returns the absolute value of a.
 */
cljs.core.abs = (function cljs$core$abs(a){
return Math.abs(a);
});
/**
 * Returns the greatest of the nums.
 */
cljs.core.max = (function cljs$core$max(var_args){
var G__15108 = arguments.length;
switch (G__15108) {
case 1:
return cljs.core.max.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.max.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15114 = arguments.length;
var i__10914__auto___15115 = (0);
while(true){
if((i__10914__auto___15115 < len__10913__auto___15114)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15115]));

var G__15116 = (i__10914__auto___15115 + (1));
i__10914__auto___15115 = G__15116;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.max.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15109(x){
return x;
}));

(cljs.core.max.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15110(x,y){
var x__9941__auto__ = x;
var y__9942__auto__ = y;
return ((x__9941__auto__ > y__9942__auto__) ? x__9941__auto__ : y__9942__auto__);
}));

(cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15111(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(function (){var x__9941__auto__ = x;
var y__9942__auto__ = y;
return ((x__9941__auto__ > y__9942__auto__) ? x__9941__auto__ : y__9942__auto__);
})(),more);
}));

/** @this {Function} */
(cljs.core.max.cljs$lang$applyTo = (function cljs$core$fn_15112(seq15105){
var G__15106 = cljs.core.first(seq15105);
var seq15105__$1 = cljs.core.next(seq15105);
var G__15107 = cljs.core.first(seq15105__$1);
var seq15105__$2 = cljs.core.next(seq15105__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15106,G__15107,seq15105__$2);
}));

(cljs.core.max.cljs$lang$maxFixedArity = (2));

/**
 * Returns the least of the nums.
 */
cljs.core.min = (function cljs$core$min(var_args){
var G__15121 = arguments.length;
switch (G__15121) {
case 1:
return cljs.core.min.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.min.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15127 = arguments.length;
var i__10914__auto___15128 = (0);
while(true){
if((i__10914__auto___15128 < len__10913__auto___15127)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15128]));

var G__15129 = (i__10914__auto___15128 + (1));
i__10914__auto___15128 = G__15129;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.min.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15122(x){
return x;
}));

(cljs.core.min.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15123(x,y){
var x__9948__auto__ = x;
var y__9949__auto__ = y;
return ((x__9948__auto__ < y__9949__auto__) ? x__9948__auto__ : y__9949__auto__);
}));

(cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15124(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min,(function (){var x__9948__auto__ = x;
var y__9949__auto__ = y;
return ((x__9948__auto__ < y__9949__auto__) ? x__9948__auto__ : y__9949__auto__);
})(),more);
}));

/** @this {Function} */
(cljs.core.min.cljs$lang$applyTo = (function cljs$core$fn_15125(seq15118){
var G__15119 = cljs.core.first(seq15118);
var seq15118__$1 = cljs.core.next(seq15118);
var G__15120 = cljs.core.first(seq15118__$1);
var seq15118__$2 = cljs.core.next(seq15118__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15119,G__15120,seq15118__$2);
}));

(cljs.core.min.cljs$lang$maxFixedArity = (2));

cljs.core.byte$ = (function cljs$core$byte(x){
return x;
});
/**
 * Coerce to char
 */
cljs.core.char$ = (function cljs$core$char(x){
if(typeof x === 'number'){
return String.fromCharCode(x);
} else {
if(((typeof x === 'string') && ((x.length === (1))))){
return x;
} else {
throw (new Error("Argument to char must be a character or number"));

}
}
});
cljs.core.short$ = (function cljs$core$short(x){
return x;
});
cljs.core.float$ = (function cljs$core$float(x){
return x;
});
cljs.core.double$ = (function cljs$core$double(x){
return x;
});
cljs.core.unchecked_byte = (function cljs$core$unchecked_byte(x){
return x;
});
cljs.core.unchecked_char = (function cljs$core$unchecked_char(x){
return x;
});
cljs.core.unchecked_short = (function cljs$core$unchecked_short(x){
return x;
});
cljs.core.unchecked_float = (function cljs$core$unchecked_float(x){
return x;
});
cljs.core.unchecked_double = (function cljs$core$unchecked_double(x){
return x;
});
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add = (function cljs$core$unchecked_add(var_args){
var G__15134 = arguments.length;
switch (G__15134) {
case 0:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15141 = arguments.length;
var i__10914__auto___15142 = (0);
while(true){
if((i__10914__auto___15142 < len__10913__auto___15141)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15142]));

var G__15143 = (i__10914__auto___15142 + (1));
i__10914__auto___15142 = G__15143;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15135(){
return (0);
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15136(x){
return x;
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15137(x,y){
return (x + y);
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15138(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add,(x + y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_add.cljs$lang$applyTo = (function cljs$core$fn_15139(seq15131){
var G__15132 = cljs.core.first(seq15131);
var seq15131__$1 = cljs.core.next(seq15131);
var G__15133 = cljs.core.first(seq15131__$1);
var seq15131__$2 = cljs.core.next(seq15131__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15132,G__15133,seq15131__$2);
}));

(cljs.core.unchecked_add.cljs$lang$maxFixedArity = (2));

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add_int = (function cljs$core$unchecked_add_int(var_args){
var G__15148 = arguments.length;
switch (G__15148) {
case 0:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15155 = arguments.length;
var i__10914__auto___15156 = (0);
while(true){
if((i__10914__auto___15156 < len__10913__auto___15155)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15156]));

var G__15157 = (i__10914__auto___15156 + (1));
i__10914__auto___15156 = G__15157;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15149(){
return (0);
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15150(x){
return x;
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15151(x,y){
return (x + y);
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15152(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int,(x + y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_add_int.cljs$lang$applyTo = (function cljs$core$fn_15153(seq15145){
var G__15146 = cljs.core.first(seq15145);
var seq15145__$1 = cljs.core.next(seq15145);
var G__15147 = cljs.core.first(seq15145__$1);
var seq15145__$2 = cljs.core.next(seq15145__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15146,G__15147,seq15145__$2);
}));

(cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = (2));

/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec = (function cljs$core$unchecked_dec(x){
return (x - (1));
});
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec_int = (function cljs$core$unchecked_dec_int(x){
return (x - (1));
});
/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core.unchecked_divide_int = (function cljs$core$unchecked_divide_int(var_args){
var G__15162 = arguments.length;
switch (G__15162) {
case 1:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15168 = arguments.length;
var i__10914__auto___15169 = (0);
while(true){
if((i__10914__auto___15169 < len__10913__auto___15168)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15169]));

var G__15170 = (i__10914__auto___15169 + (1));
i__10914__auto___15169 = G__15170;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15163(x){
return ((1) / x);
}));

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15164(x,y){
return (x / y);
}));

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15165(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int,(x / y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_divide_int.cljs$lang$applyTo = (function cljs$core$fn_15166(seq15159){
var G__15160 = cljs.core.first(seq15159);
var seq15159__$1 = cljs.core.next(seq15159);
var G__15161 = cljs.core.first(seq15159__$1);
var seq15159__$2 = cljs.core.next(seq15159__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15160,G__15161,seq15159__$2);
}));

(cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = (2));

cljs.core.unchecked_inc = (function cljs$core$unchecked_inc(x){
return (x + (1));
});
cljs.core.unchecked_inc_int = (function cljs$core$unchecked_inc_int(x){
return (x + (1));
});
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply = (function cljs$core$unchecked_multiply(var_args){
var G__15175 = arguments.length;
switch (G__15175) {
case 0:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15182 = arguments.length;
var i__10914__auto___15183 = (0);
while(true){
if((i__10914__auto___15183 < len__10913__auto___15182)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15183]));

var G__15184 = (i__10914__auto___15183 + (1));
i__10914__auto___15183 = G__15184;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15176(){
return (1);
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15177(x){
return x;
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15178(x,y){
return (x * y);
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15179(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply,(x * y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_multiply.cljs$lang$applyTo = (function cljs$core$fn_15180(seq15172){
var G__15173 = cljs.core.first(seq15172);
var seq15172__$1 = cljs.core.next(seq15172);
var G__15174 = cljs.core.first(seq15172__$1);
var seq15172__$2 = cljs.core.next(seq15172__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15173,G__15174,seq15172__$2);
}));

(cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = (2));

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply_int = (function cljs$core$unchecked_multiply_int(var_args){
var G__15189 = arguments.length;
switch (G__15189) {
case 0:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15196 = arguments.length;
var i__10914__auto___15197 = (0);
while(true){
if((i__10914__auto___15197 < len__10913__auto___15196)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15197]));

var G__15198 = (i__10914__auto___15197 + (1));
i__10914__auto___15197 = G__15198;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15190(){
return (1);
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15191(x){
return x;
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15192(x,y){
return (x * y);
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15193(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int,(x * y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_multiply_int.cljs$lang$applyTo = (function cljs$core$fn_15194(seq15186){
var G__15187 = cljs.core.first(seq15186);
var seq15186__$1 = cljs.core.next(seq15186);
var G__15188 = cljs.core.first(seq15186__$1);
var seq15186__$2 = cljs.core.next(seq15186__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15187,G__15188,seq15186__$2);
}));

(cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = (2));

cljs.core.unchecked_negate = (function cljs$core$unchecked_negate(x){
return (- x);
});
cljs.core.unchecked_negate_int = (function cljs$core$unchecked_negate_int(x){
return (- x);
});
cljs.core.unchecked_remainder_int = (function cljs$core$unchecked_remainder_int(x,n){
return cljs.core.mod(x,n);
});
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract = (function cljs$core$unchecked_subtract(var_args){
var G__15203 = arguments.length;
switch (G__15203) {
case 1:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15209 = arguments.length;
var i__10914__auto___15210 = (0);
while(true){
if((i__10914__auto___15210 < len__10913__auto___15209)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15210]));

var G__15211 = (i__10914__auto___15210 + (1));
i__10914__auto___15210 = G__15211;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15204(x){
return (- x);
}));

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15205(x,y){
return (x - y);
}));

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15206(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract,(x - y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_subtract.cljs$lang$applyTo = (function cljs$core$fn_15207(seq15200){
var G__15201 = cljs.core.first(seq15200);
var seq15200__$1 = cljs.core.next(seq15200);
var G__15202 = cljs.core.first(seq15200__$1);
var seq15200__$2 = cljs.core.next(seq15200__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15201,G__15202,seq15200__$2);
}));

(cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = (2));

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract_int = (function cljs$core$unchecked_subtract_int(var_args){
var G__15216 = arguments.length;
switch (G__15216) {
case 1:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15222 = arguments.length;
var i__10914__auto___15223 = (0);
while(true){
if((i__10914__auto___15223 < len__10913__auto___15222)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15223]));

var G__15224 = (i__10914__auto___15223 + (1));
i__10914__auto___15223 = G__15224;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15217(x){
return (- x);
}));

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15218(x,y){
return (x - y);
}));

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15219(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int,(x - y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_subtract_int.cljs$lang$applyTo = (function cljs$core$fn_15220(seq15213){
var G__15214 = cljs.core.first(seq15213);
var seq15213__$1 = cljs.core.next(seq15213);
var G__15215 = cljs.core.first(seq15213__$1);
var seq15213__$2 = cljs.core.next(seq15213__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15214,G__15215,seq15213__$2);
}));

(cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = (2));

cljs.core.fix = (function cljs$core$fix(q){
if((q >= (0))){
return Math.floor(q);
} else {
return Math.ceil(q);
}
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.int$ = (function cljs$core$int(x){
return (x | (0));
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.unchecked_int = (function cljs$core$unchecked_int(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.long$ = (function cljs$core$long(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.unchecked_long = (function cljs$core$unchecked_long(x){
return cljs.core.fix(x);
});
cljs.core.booleans = (function cljs$core$booleans(x){
return x;
});
cljs.core.bytes = (function cljs$core$bytes(x){
return x;
});
cljs.core.chars = (function cljs$core$chars(x){
return x;
});
cljs.core.shorts = (function cljs$core$shorts(x){
return x;
});
cljs.core.ints = (function cljs$core$ints(x){
return x;
});
cljs.core.floats = (function cljs$core$floats(x){
return x;
});
cljs.core.doubles = (function cljs$core$doubles(x){
return x;
});
cljs.core.longs = (function cljs$core$longs(x){
return x;
});
/**
 * Modulus of num and div with original javascript behavior. i.e. bug for negative numbers
 */
cljs.core.js_mod = (function cljs$core$js_mod(n,d){
return (n % d);
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
cljs.core.mod = (function cljs$core$mod(n,d){
return (((n % d) + d) % d);
});
/**
 * quot[ient] of dividing numerator by denominator.
 */
cljs.core.quot = (function cljs$core$quot(n,d){
var rem = (n % d);
return cljs.core.fix(((n - rem) / d));
});
/**
 * remainder of dividing numerator by denominator.
 */
cljs.core.rem = (function cljs$core$rem(n,d){
var q = cljs.core.quot(n,d);
return (n - (d * q));
});
/**
 * Bitwise exclusive or
 */
cljs.core.bit_xor = (function cljs$core$bit_xor(var_args){
var G__15229 = arguments.length;
switch (G__15229) {
case 2:
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15234 = arguments.length;
var i__10914__auto___15235 = (0);
while(true){
if((i__10914__auto___15235 < len__10913__auto___15234)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15235]));

var G__15236 = (i__10914__auto___15235 + (1));
i__10914__auto___15235 = G__15236;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15230(x,y){
return (x ^ y);
}));

(cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15231(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor,(x ^ y),more);
}));

/** @this {Function} */
(cljs.core.bit_xor.cljs$lang$applyTo = (function cljs$core$fn_15232(seq15226){
var G__15227 = cljs.core.first(seq15226);
var seq15226__$1 = cljs.core.next(seq15226);
var G__15228 = cljs.core.first(seq15226__$1);
var seq15226__$2 = cljs.core.next(seq15226__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15227,G__15228,seq15226__$2);
}));

(cljs.core.bit_xor.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise and
 */
cljs.core.bit_and = (function cljs$core$bit_and(var_args){
var G__15241 = arguments.length;
switch (G__15241) {
case 2:
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15246 = arguments.length;
var i__10914__auto___15247 = (0);
while(true){
if((i__10914__auto___15247 < len__10913__auto___15246)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15247]));

var G__15248 = (i__10914__auto___15247 + (1));
i__10914__auto___15247 = G__15248;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15242(x,y){
return (x & y);
}));

(cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15243(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and,(x & y),more);
}));

/** @this {Function} */
(cljs.core.bit_and.cljs$lang$applyTo = (function cljs$core$fn_15244(seq15238){
var G__15239 = cljs.core.first(seq15238);
var seq15238__$1 = cljs.core.next(seq15238);
var G__15240 = cljs.core.first(seq15238__$1);
var seq15238__$2 = cljs.core.next(seq15238__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15239,G__15240,seq15238__$2);
}));

(cljs.core.bit_and.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise or
 */
cljs.core.bit_or = (function cljs$core$bit_or(var_args){
var G__15253 = arguments.length;
switch (G__15253) {
case 2:
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15258 = arguments.length;
var i__10914__auto___15259 = (0);
while(true){
if((i__10914__auto___15259 < len__10913__auto___15258)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15259]));

var G__15260 = (i__10914__auto___15259 + (1));
i__10914__auto___15259 = G__15260;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15254(x,y){
return (x | y);
}));

(cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15255(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or,(x | y),more);
}));

/** @this {Function} */
(cljs.core.bit_or.cljs$lang$applyTo = (function cljs$core$fn_15256(seq15250){
var G__15251 = cljs.core.first(seq15250);
var seq15250__$1 = cljs.core.next(seq15250);
var G__15252 = cljs.core.first(seq15250__$1);
var seq15250__$2 = cljs.core.next(seq15250__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15251,G__15252,seq15250__$2);
}));

(cljs.core.bit_or.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise and with complement
 */
cljs.core.bit_and_not = (function cljs$core$bit_and_not(var_args){
var G__15265 = arguments.length;
switch (G__15265) {
case 2:
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15270 = arguments.length;
var i__10914__auto___15271 = (0);
while(true){
if((i__10914__auto___15271 < len__10913__auto___15270)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15271]));

var G__15272 = (i__10914__auto___15271 + (1));
i__10914__auto___15271 = G__15272;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15266(x,y){
return (x & ~y);
}));

(cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15267(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not,(x & ~y),more);
}));

/** @this {Function} */
(cljs.core.bit_and_not.cljs$lang$applyTo = (function cljs$core$fn_15268(seq15262){
var G__15263 = cljs.core.first(seq15262);
var seq15262__$1 = cljs.core.next(seq15262);
var G__15264 = cljs.core.first(seq15262__$1);
var seq15262__$2 = cljs.core.next(seq15262__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15263,G__15264,seq15262__$2);
}));

(cljs.core.bit_and_not.cljs$lang$maxFixedArity = (2));

/**
 * Clear bit at index n
 */
cljs.core.bit_clear = (function cljs$core$bit_clear(x,n){
return (x & ~(1 << n));
});
/**
 * Flip bit at index n
 */
cljs.core.bit_flip = (function cljs$core$bit_flip(x,n){
return (x ^ (1 << n));
});
/**
 * Bitwise complement
 */
cljs.core.bit_not = (function cljs$core$bit_not(x){
return (~ x);
});
/**
 * Set bit at index n
 */
cljs.core.bit_set = (function cljs$core$bit_set(x,n){
return (x | (1 << n));
});
/**
 * Test bit at index n
 */
cljs.core.bit_test = (function cljs$core$bit_test(x,n){
return ((x & (1 << n)) != 0);
});
/**
 * Bitwise shift left
 */
cljs.core.bit_shift_left = (function cljs$core$bit_shift_left(x,n){
return (x << n);
});
/**
 * Bitwise shift right
 */
cljs.core.bit_shift_right = (function cljs$core$bit_shift_right(x,n){
return (x >> n);
});
/**
 * DEPRECATED: Bitwise shift right with zero fill
 */
cljs.core.bit_shift_right_zero_fill = (function cljs$core$bit_shift_right_zero_fill(x,n){
return (x >>> n);
});
/**
 * Bitwise shift right with zero fill
 */
cljs.core.unsigned_bit_shift_right = (function cljs$core$unsigned_bit_shift_right(x,n){
return (x >>> n);
});
/**
 * Counts the number of bits set in n
 */
cljs.core.bit_count = (function cljs$core$bit_count(v){
var v__$1 = (v - ((v >> (1)) & (1431655765)));
var v__$2 = ((v__$1 & (858993459)) + ((v__$1 >> (2)) & (858993459)));
return ((((v__$2 + (v__$2 >> (4))) & (252645135)) * (16843009)) >> (24));
});
/**
 * Returns non-nil if nums all have the equivalent
 *   value, otherwise false. Behavior on non nums is
 *   undefined.
 */
cljs.core._EQ__EQ_ = (function cljs$core$_EQ__EQ_(var_args){
var G__15277 = arguments.length;
switch (G__15277) {
case 1:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15283 = arguments.length;
var i__10914__auto___15284 = (0);
while(true){
if((i__10914__auto___15284 < len__10913__auto___15283)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15284]));

var G__15285 = (i__10914__auto___15284 + (1));
i__10914__auto___15284 = G__15285;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15278(x){
return true;
}));

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15279(x,y){
return cljs.core._equiv(x,y);
}));

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15280(x,y,more){
while(true){
if((x === y)){
if(cljs.core.next(more)){
var G__15286 = y;
var G__15287 = cljs.core.first(more);
var G__15288 = cljs.core.next(more);
x = G__15286;
y = G__15287;
more = G__15288;
continue;
} else {
return (y === cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._EQ__EQ_.cljs$lang$applyTo = (function cljs$core$fn_15281(seq15274){
var G__15275 = cljs.core.first(seq15274);
var seq15274__$1 = cljs.core.next(seq15274);
var G__15276 = cljs.core.first(seq15274__$1);
var seq15274__$2 = cljs.core.next(seq15274__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15275,G__15276,seq15274__$2);
}));

(cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if num is greater than zero, else false
 */
cljs.core.pos_QMARK_ = (function cljs$core$pos_QMARK_(x){
return (x > (0));
});
/**
 * Returns true if num is zero, else false
 */
cljs.core.zero_QMARK_ = (function cljs$core$zero_QMARK_(x){
return (x === (0));
});
/**
 * Returns true if num is less than zero, else false
 */
cljs.core.neg_QMARK_ = (function cljs$core$neg_QMARK_(x){
return (x < (0));
});
/**
 * Returns the nth next of coll, (seq coll) when n is 0.
 */
cljs.core.nthnext = (function cljs$core$nthnext(coll,n){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition1$ & (262144))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IDrop$))))?true:false):false)){
if((n > (0))){
return coll.cljs$core$IDrop$_drop$arity$2(null,Math.ceil(n));
} else {
return cljs.core.seq(coll);
}
} else {
var n__$1 = n;
var xs = cljs.core.seq(coll);
while(true){
if(((xs) && ((n__$1 > (0))))){
var G__15290 = (n__$1 - (1));
var G__15291 = cljs.core.next(xs);
n__$1 = G__15290;
xs = G__15291;
continue;
} else {
return xs;
}
break;
}
}
});
/**
 * With no args, returns the empty string. With one arg x, returns
 *   x.toString().  (str nil) returns the empty string. With more than
 *   one arg, returns the concatenation of the str values of the args.
 */
cljs.core.str = (function cljs$core$str(var_args){
var G__15295 = arguments.length;
switch (G__15295) {
case 0:
return cljs.core.str.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15301 = arguments.length;
var i__10914__auto___15302 = (0);
while(true){
if((i__10914__auto___15302 < len__10913__auto___15301)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15302]));

var G__15303 = (i__10914__auto___15302 + (1));
i__10914__auto___15302 = G__15303;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((1) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((1)),(0),null)):null);
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10943__auto__);

}
});

(cljs.core.str.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15296(){
return "";
}));

(cljs.core.str.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15297(x){
if((x == null)){
return "";
} else {
return [x].join("");
}
}));

(cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15298(x,ys){
var sb = (new goog.string.StringBuffer(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)));
var more = ys;
while(true){
if(cljs.core.truth_(more)){
var G__15304 = sb.append(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(more)));
var G__15305 = cljs.core.next(more);
sb = G__15304;
more = G__15305;
continue;
} else {
return sb.toString();
}
break;
}
}));

/** @this {Function} */
(cljs.core.str.cljs$lang$applyTo = (function cljs$core$fn_15299(seq15293){
var G__15294 = cljs.core.first(seq15293);
var seq15293__$1 = cljs.core.next(seq15293);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15294,seq15293__$1);
}));

(cljs.core.str.cljs$lang$maxFixedArity = (1));

/**
 * Returns the substring of s beginning at start inclusive, and ending
 *   at end (defaults to length of string), exclusive.
 */
cljs.core.subs = (function cljs$core$subs(var_args){
var G__15307 = arguments.length;
switch (G__15307) {
case 2:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15308(s,start){
return s.substring(start);
}));

(cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15309(s,start,end){
return s.substring(start,end);
}));

(cljs.core.subs.cljs$lang$maxFixedArity = 3);


/**
 * Assumes x is sequential. Returns true if x equals y, otherwise
 *   returns false.
 */
cljs.core.equiv_sequential = (function cljs$core$equiv_sequential(x,y){
return cljs.core.boolean$(((cljs.core.sequential_QMARK_(y))?((((cljs.core.counted_QMARK_(x)) && (((cljs.core.counted_QMARK_(y)) && ((!((cljs.core.count(x) === cljs.core.count(y)))))))))?false:(function (){var xs = cljs.core.seq(x);
var ys = cljs.core.seq(y);
while(true){
if((xs == null)){
return (ys == null);
} else {
if((ys == null)){
return false;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){
var G__15311 = cljs.core.next(xs);
var G__15312 = cljs.core.next(ys);
xs = G__15311;
ys = G__15312;
continue;
} else {
return false;

}
}
}
break;
}
})()):null));
});
cljs.core.hash_coll = (function cljs$core$hash_coll(coll){
if(cljs.core.seq(coll)){
var res = cljs.core.hash(cljs.core.first(coll));
var s = cljs.core.next(coll);
while(true){
if((s == null)){
return res;
} else {
var G__15313 = cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));
var G__15314 = cljs.core.next(s);
res = G__15313;
s = G__15314;
continue;
}
break;
}
} else {
return (0);
}
});

cljs.core.hash_imap = (function cljs$core$hash_imap(m){
var h = (0);
var s = cljs.core.seq(m);
while(true){
if(s){
var e = cljs.core.first(s);
var G__15315 = ((h + (cljs.core.hash(cljs.core.key(e)) ^ cljs.core.hash(cljs.core.val(e)))) % (4503599627370496));
var G__15316 = cljs.core.next(s);
h = G__15315;
s = G__15316;
continue;
} else {
return h;
}
break;
}
});
cljs.core.hash_iset = (function cljs$core$hash_iset(s){
var h = (0);
var s__$1 = cljs.core.seq(s);
while(true){
if(s__$1){
var e = cljs.core.first(s__$1);
var G__15317 = ((h + cljs.core.hash(e)) % (4503599627370496));
var G__15318 = cljs.core.next(s__$1);
h = G__15317;
s__$1 = G__15318;
continue;
} else {
return h;
}
break;
}
});


/**
 * Takes a JavaScript object and a map of names to functions and
 *   attaches said functions as methods on the object.  Any references to
 *   JavaScript's implicit this (via the this-as macro) will resolve to the
 *   object that the function is attached.
 */
cljs.core.extend_object_BANG_ = (function cljs$core$extend_object_BANG_(obj,fn_map){
var seq__15319_15335 = cljs.core.seq(fn_map);
var chunk__15320_15336 = null;
var count__15321_15337 = (0);
var i__15322_15338 = (0);
while(true){
if((i__15322_15338 < count__15321_15337)){
var vec__15329_15339 = chunk__15320_15336.cljs$core$IIndexed$_nth$arity$2(null,i__15322_15338);
var key_name_15340 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15329_15339,(0),null);
var f_15341 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15329_15339,(1),null);
var str_name_15342 = cljs.core.name(key_name_15340);
cljs.core.goog$module$goog$object.set.call(null,obj,str_name_15342,f_15341);


var G__15343 = seq__15319_15335;
var G__15344 = chunk__15320_15336;
var G__15345 = count__15321_15337;
var G__15346 = (i__15322_15338 + (1));
seq__15319_15335 = G__15343;
chunk__15320_15336 = G__15344;
count__15321_15337 = G__15345;
i__15322_15338 = G__15346;
continue;
} else {
var temp__5720__auto___15347 = cljs.core.seq(seq__15319_15335);
if(temp__5720__auto___15347){
var seq__15319_15348__$1 = temp__5720__auto___15347;
if(cljs.core.chunked_seq_QMARK_(seq__15319_15348__$1)){
var c__10556__auto___15349 = cljs.core.chunk_first(seq__15319_15348__$1);
var G__15350 = cljs.core.chunk_rest(seq__15319_15348__$1);
var G__15351 = c__10556__auto___15349;
var G__15352 = cljs.core.count(c__10556__auto___15349);
var G__15353 = (0);
seq__15319_15335 = G__15350;
chunk__15320_15336 = G__15351;
count__15321_15337 = G__15352;
i__15322_15338 = G__15353;
continue;
} else {
var vec__15332_15354 = cljs.core.first(seq__15319_15348__$1);
var key_name_15355 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15332_15354,(0),null);
var f_15356 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15332_15354,(1),null);
var str_name_15357 = cljs.core.name(key_name_15355);
cljs.core.goog$module$goog$object.set.call(null,obj,str_name_15357,f_15356);


var G__15358 = cljs.core.next(seq__15319_15348__$1);
var G__15359 = null;
var G__15360 = (0);
var G__15361 = (0);
seq__15319_15335 = G__15358;
chunk__15320_15336 = G__15359;
count__15321_15337 = G__15360;
i__15322_15338 = G__15361;
continue;
}
} else {
}
}
break;
}

return obj;
});

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.List = (function (meta,first,rest,count,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.count = count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65937646;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.List.prototype.toString = (function cljs$core$fn_15362(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.List.prototype.equiv = (function cljs$core$fn_15363(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.List.prototype.indexOf = (function() {
var cljs$core$fn_15364 = null;
var cljs$core$fn_15364__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_15364__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15364 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15364__1.call(this,x);
case 2:
return cljs$core$fn_15364__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15364.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15364__1;
cljs$core$fn_15364.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15364__2;
return cljs$core$fn_15364;
})()
);

(cljs.core.List.prototype.lastIndexOf = (function() {
var cljs$core$fn_15365 = null;
var cljs$core$fn_15365__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,self__.count);
});
var cljs$core$fn_15365__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15365 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15365__1.call(this,x);
case 2:
return cljs$core$fn_15365__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15365.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15365__1;
cljs$core$fn_15365.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15365__2;
return cljs$core$fn_15365;
})()
);

(cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15366(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_15367(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));
}));

(cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_15368(coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return null;
} else {
return self__.rest;
}
}));

(cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_15369(coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
}));

(cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_15370(coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_15371(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
}));

(cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15372(coll){
var self__ = this;
var coll__$1 = this;
var h__10045__auto__ = self__.__hash;
if((!((h__10045__auto__ == null)))){
return h__10045__auto__;
} else {
var h__10045__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10045__auto____$1);

return h__10045__auto____$1;
}
}));

(cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15373(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_15374(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_15375(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_15376(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_15377(coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_15378(coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
}));

(cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_15379(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_15380(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.List(new_meta,self__.first,self__.rest,self__.count,self__.__hash));
}
}));

(cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_15381(coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));
}));

(cljs.core.List.getBasis = (function cljs$core$fn_15382(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"count","count",-514511684,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.List.cljs$lang$type = true);

(cljs.core.List.cljs$lang$ctorStr = "cljs.core/List");

(cljs.core.List.cljs$lang$ctorPrWriter = (function cljs$core$fn_15383(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/List");
}));

/**
 * Positional factory function for cljs.core/List.
 */
cljs.core.__GT_List = (function cljs$core$__GT_List(meta,first,rest,count,__hash){
return (new cljs.core.List(meta,first,rest,count,__hash));
});

/**
 * Returns true if x implements IList
 */
cljs.core.list_QMARK_ = (function cljs$core$list_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (33554432))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IList$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
}
});
(cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15385(){
var this__10774__auto__ = this;
return cljs.core.es6_iterator(this__10774__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.EmptyList = (function (meta){
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 65937614;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.EmptyList.prototype.toString = (function cljs$core$fn_15386(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.EmptyList.prototype.equiv = (function cljs$core$fn_15387(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.EmptyList.prototype.indexOf = (function() {
var cljs$core$fn_15388 = null;
var cljs$core$fn_15388__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_15388__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15388 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15388__1.call(this,x);
case 2:
return cljs$core$fn_15388__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15388.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15388__1;
cljs$core$fn_15388.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15388__2;
return cljs$core$fn_15388;
})()
);

(cljs.core.EmptyList.prototype.lastIndexOf = (function() {
var cljs$core$fn_15389 = null;
var cljs$core$fn_15389__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_15389__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15389 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15389__1.call(this,x);
case 2:
return cljs$core$fn_15389__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15389.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15389__1;
cljs$core$fn_15389.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15389__2;
return cljs$core$fn_15389;
})()
);

(cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15390(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_15391(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.EmptyList(self__.meta));
}));

(cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_15392(coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_15393(coll){
var self__ = this;
var coll__$1 = this;
return (0);
}));

(cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_15394(coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_15395(coll){
var self__ = this;
var coll__$1 = this;
throw (new Error("Can't pop empty list"));
}));

(cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15396(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.empty_ordered_hash;
}));

(cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15397(coll,other){
var self__ = this;
var coll__$1 = this;
if(((cljs.core.list_QMARK_(other)) || (cljs.core.sequential_QMARK_(other)))){
return (cljs.core.seq(other) == null);
} else {
return false;
}
}));

(cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_15398(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_15399(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_15400(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_15401(coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_15402(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_15403(coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_15404(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.EmptyList(new_meta));
}
}));

(cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_15405(coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,null,(1),null));
}));

(cljs.core.EmptyList.getBasis = (function cljs$core$fn_15406(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.EmptyList.cljs$lang$type = true);

(cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList");

(cljs.core.EmptyList.cljs$lang$ctorPrWriter = (function cljs$core$fn_15407(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/EmptyList");
}));

/**
 * Positional factory function for cljs.core/EmptyList.
 */
cljs.core.__GT_EmptyList = (function cljs$core$__GT_EmptyList(meta){
return (new cljs.core.EmptyList(meta));
});

(cljs.core.List.EMPTY = (new cljs.core.EmptyList(null)));
(cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15408(){
var this__10774__auto__ = this;
return cljs.core.es6_iterator(this__10774__auto__);
}));
/**
 * Returns true if coll satisfies? IReversible.
 */
cljs.core.reversible_QMARK_ = (function cljs$core$reversible_QMARK_(coll){
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (134217728))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReversible$)))){
return true;
} else {
if((!coll.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
}
});
/**
 * Returns, in constant time, a seq of the items in rev (which
 *   can be a vector or sorted-map), in reverse order. If rev is empty returns nil
 */
cljs.core.rseq = (function cljs$core$rseq(rev){
return cljs.core._rseq(rev);
});
/**
 * Returns a seq of the items in coll in reverse order. Not lazy.
 */
cljs.core.reverse = (function cljs$core$reverse(coll){
if(cljs.core.reversible_QMARK_(coll)){
var or__9584__auto__ = cljs.core.rseq(coll);
if(or__9584__auto__){
return or__9584__auto__;
} else {
return cljs.core.List.EMPTY;
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll);
}
});
/**
 * Creates a new list containing the items.
 */
cljs.core.list = (function cljs$core$list(var_args){
var args__10923__auto__ = [];
var len__10913__auto___15413 = arguments.length;
var i__10914__auto___15414 = (0);
while(true){
if((i__10914__auto___15414 < len__10913__auto___15413)){
args__10923__auto__.push((arguments[i__10914__auto___15414]));

var G__15415 = (i__10914__auto___15414 + (1));
i__10914__auto___15414 = G__15415;
continue;
} else {
}
break;
}

var argseq__10924__auto__ = ((((0) < args__10923__auto__.length))?(new cljs.core.IndexedSeq(args__10923__auto__.slice((0)),(0),null)):null);
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__10924__auto__);
});

(cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15411(xs){
var arr = (((((xs instanceof cljs.core.IndexedSeq)) && ((xs.i === (0)))))?xs.arr:(function (){var arr = [];
var xs__$1 = xs;
while(true){
if((!((xs__$1 == null)))){
arr.push(cljs.core._first(xs__$1));

var G__15416 = cljs.core._next(xs__$1);
xs__$1 = G__15416;
continue;
} else {
return arr;
}
break;
}
})());
var i = arr.length;
var r = cljs.core.List.EMPTY;
while(true){
if((i > (0))){
var G__15417 = (i - (1));
var G__15418 = cljs.core._conj(r,(arr[(i - (1))]));
i = G__15417;
r = G__15418;
continue;
} else {
return r;
}
break;
}
}));

(cljs.core.list.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.list.cljs$lang$applyTo = (function cljs$core$fn_15412(seq15410){
var self__10899__auto__ = this;
return self__10899__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq15410));
}));


/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Cons = (function (meta,first,rest,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65929452;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.Cons.prototype.toString = (function cljs$core$fn_15419(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Cons.prototype.equiv = (function cljs$core$fn_15420(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Cons.prototype.indexOf = (function() {
var cljs$core$fn_15421 = null;
var cljs$core$fn_15421__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_15421__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15421 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15421__1.call(this,x);
case 2:
return cljs$core$fn_15421__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15421.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15421__1;
cljs$core$fn_15421.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15421__2;
return cljs$core$fn_15421;
})()
);

(cljs.core.Cons.prototype.lastIndexOf = (function() {
var cljs$core$fn_15422 = null;
var cljs$core$fn_15422__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_15422__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15422 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15422__1.call(this,x);
case 2:
return cljs$core$fn_15422__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15422.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15422__1;
cljs$core$fn_15422.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15422__2;
return cljs$core$fn_15422;
})()
);

(cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15423(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_15424(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));
}));

(cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_15425(coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return null;
} else {
return cljs.core.seq(self__.rest);
}
}));

(cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15426(coll){
var self__ = this;
var coll__$1 = this;
var h__10045__auto__ = self__.__hash;
if((!((h__10045__auto__ == null)))){
return h__10045__auto__;
} else {
var h__10045__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10045__auto____$1);

return h__10045__auto____$1;
}
}));

(cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15427(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_15428(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_15429(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_15430(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_15431(coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_15432(coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
}));

(cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_15433(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_15434(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Cons(new_meta,self__.first,self__.rest,self__.__hash));
}
}));

(cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_15435(coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(null,o,coll__$1,null));
}));

(cljs.core.Cons.getBasis = (function cljs$core$fn_15436(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rest","rest",398835108,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Cons.cljs$lang$type = true);

(cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons");

(cljs.core.Cons.cljs$lang$ctorPrWriter = (function cljs$core$fn_15437(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/Cons");
}));

/**
 * Positional factory function for cljs.core/Cons.
 */
cljs.core.__GT_Cons = (function cljs$core$__GT_Cons(meta,first,rest,__hash){
return (new cljs.core.Cons(meta,first,rest,__hash));
});

(cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15438(){
var this__10774__auto__ = this;
return cljs.core.es6_iterator(this__10774__auto__);
}));
/**
 * Returns a new seq where x is the first element and coll is the rest.
 */
cljs.core.cons = (function cljs$core$cons(x,coll){
if((coll == null)){
return (new cljs.core.List(null,x,null,(1),null));
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return (new cljs.core.Cons(null,x,coll,null));
} else {
return (new cljs.core.Cons(null,x,cljs.core.seq(coll),null));

}
}
});
cljs.core.hash_keyword = (function cljs$core$hash_keyword(k){
return ((cljs.core.hash_symbol(k) + (2654435769)) | (0));
});
cljs.core.compare_keywords = (function cljs$core$compare_keywords(a,b){
if((a.fqn === b.fqn)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__9578__auto__ = cljs.core.not(a.ns);
if(and__9578__auto__){
return b.ns;
} else {
return and__9578__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__15440 = a.ns;
var G__15441 = b.ns;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__15440,G__15441);
})();
if(((0) === nsc)){
var G__15442 = a.name;
var G__15443 = b.name;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__15442,G__15443);
} else {
return nsc;
}
}
} else {
var G__15444 = a.name;
var G__15445 = b.name;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__15444,G__15445);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IPrintWithWriter}
*/
cljs.core.Keyword = (function (ns,name,fqn,_hash){
this.ns = ns;
this.name = name;
this.fqn = fqn;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 2153775105;
this.cljs$lang$protocol_mask$partition1$ = 4096;
});
(cljs.core.Keyword.prototype.toString = (function cljs$core$fn_15447(){
var self__ = this;
var _ = this;
return [":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join('');
}));

(cljs.core.Keyword.prototype.equiv = (function cljs$core$fn_15448(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15449(_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Keyword)){
return (self__.fqn === other.fqn);
} else {
return false;
}
}));

(cljs.core.Keyword.prototype.call = (function() {
var cljs$core$fn_15450 = null;
var cljs$core$fn_15450__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});
var cljs$core$fn_15450__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});
cljs$core$fn_15450 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_15450__2.call(this,self__,coll);
case 3:
return cljs$core$fn_15450__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_15450.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15450__2;
cljs$core$fn_15450.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15450__3;
return cljs$core$fn_15450;
})()
);

(cljs.core.Keyword.prototype.apply = (function cljs$core$fn_15451(self__,args15446){
var self__ = this;
var self____$1 = this;
var args__10187__auto__ = cljs.core.aclone(args15446);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10187__auto__.length > (20)))?(function (){var G__15452 = args__10187__auto__.slice((0),(20));
G__15452.push(args__10187__auto__.slice((20)));

return G__15452;
})():args__10187__auto__)));
}));

(cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15453(coll){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
}));

(cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15454(coll,not_found){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
}));

(cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15455(this$){
var self__ = this;
var this$__$1 = this;
var h__10045__auto__ = self__._hash;
if((!((h__10045__auto__ == null)))){
return h__10045__auto__;
} else {
var h__10045__auto____$1 = cljs.core.hash_keyword(this$__$1);
(self__._hash = h__10045__auto____$1);

return h__10045__auto____$1;
}
}));

(cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = (function cljs$core$fn_15456(_){
var self__ = this;
var ___$1 = this;
return self__.name;
}));

(cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = (function cljs$core$fn_15457(_){
var self__ = this;
var ___$1 = this;
return self__.ns;
}));

(cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function cljs$core$fn_15458(o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join(''));
}));

(cljs.core.Keyword.getBasis = (function cljs$core$fn_15459(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns","ns",2082130287,null),new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"fqn","fqn",-1749334463,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Keyword.cljs$lang$type = true);

(cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword");

(cljs.core.Keyword.cljs$lang$ctorPrWriter = (function cljs$core$fn_15460(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/Keyword");
}));

/**
 * Positional factory function for cljs.core/Keyword.
 */
cljs.core.__GT_Keyword = (function cljs$core$__GT_Keyword(ns,name,fqn,_hash){
return (new cljs.core.Keyword(ns,name,fqn,_hash));
});

/**
 * Return true if x is a Keyword
 */
cljs.core.keyword_QMARK_ = (function cljs$core$keyword_QMARK_(x){
return (x instanceof cljs.core.Keyword);
});
/**
 * Efficient test to determine that two keywords are identical.
 */
cljs.core.keyword_identical_QMARK_ = (function cljs$core$keyword_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if((((x instanceof cljs.core.Keyword)) && ((y instanceof cljs.core.Keyword)))){
return (x.fqn === y.fqn);
} else {
return false;
}
}
});
/**
 * Efficient test to determine that two symbols are identical.
 */
cljs.core.symbol_identical_QMARK_ = (function cljs$core$symbol_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if((((x instanceof cljs.core.Symbol)) && ((y instanceof cljs.core.Symbol)))){
return (x.str === y.str);
} else {
return false;
}
}
});
/**
 * Returns the namespace String of a symbol or keyword, or nil if not present.
 */
cljs.core.namespace = (function cljs$core$namespace(x){
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition1$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$INamed$))))?true:false):false)){
return x.cljs$core$INamed$_namespace$arity$1(null);
} else {
throw (new Error(["Doesn't support namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('')));
}
});
/**
 * Return true if x is a symbol or keyword
 */
cljs.core.ident_QMARK_ = (function cljs$core$ident_QMARK_(x){
return (((x instanceof cljs.core.Keyword)) || ((x instanceof cljs.core.Symbol)));
});
/**
 * Return true if x is a symbol or keyword without a namespace
 */
cljs.core.simple_ident_QMARK_ = (function cljs$core$simple_ident_QMARK_(x){
return ((cljs.core.ident_QMARK_(x)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a symbol or keyword with a namespace
 */
cljs.core.qualified_ident_QMARK_ = (function cljs$core$qualified_ident_QMARK_(x){
return cljs.core.boolean$((function (){var and__9578__auto__ = cljs.core.ident_QMARK_(x);
if(and__9578__auto__){
var and__9578__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__9578__auto____$1)){
return true;
} else {
return and__9578__auto____$1;
}
} else {
return and__9578__auto__;
}
})());
});
/**
 * Return true if x is a symbol without a namespace
 */
cljs.core.simple_symbol_QMARK_ = (function cljs$core$simple_symbol_QMARK_(x){
return (((x instanceof cljs.core.Symbol)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a symbol with a namespace
 */
cljs.core.qualified_symbol_QMARK_ = (function cljs$core$qualified_symbol_QMARK_(x){
return cljs.core.boolean$((function (){var and__9578__auto__ = (x instanceof cljs.core.Symbol);
if(and__9578__auto__){
var and__9578__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__9578__auto____$1)){
return true;
} else {
return and__9578__auto____$1;
}
} else {
return and__9578__auto__;
}
})());
});
/**
 * Return true if x is a keyword without a namespace
 */
cljs.core.simple_keyword_QMARK_ = (function cljs$core$simple_keyword_QMARK_(x){
return (((x instanceof cljs.core.Keyword)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a keyword with a namespace
 */
cljs.core.qualified_keyword_QMARK_ = (function cljs$core$qualified_keyword_QMARK_(x){
return cljs.core.boolean$((function (){var and__9578__auto__ = (x instanceof cljs.core.Keyword);
if(and__9578__auto__){
var and__9578__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__9578__auto____$1)){
return true;
} else {
return and__9578__auto____$1;
}
} else {
return and__9578__auto__;
}
})());
});
/**
 * Returns a Keyword with the given namespace and name.  Do not use :
 *   in the keyword strings, it will be added automatically.
 */
cljs.core.keyword = (function cljs$core$keyword(var_args){
var G__15463 = arguments.length;
switch (G__15463) {
case 1:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15464(name){
if((name instanceof cljs.core.Keyword)){
return name;
} else {
if((name instanceof cljs.core.Symbol)){
return (new cljs.core.Keyword(cljs.core.namespace(name),cljs.core.name(name),name.str,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("/",name)){
return (new cljs.core.Keyword(null,name,name,null));
} else {
if(typeof name === 'string'){
var parts = name.split("/");
if((parts.length === (2))){
return (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));
} else {
return (new cljs.core.Keyword(null,(parts[(0)]),name,null));
}
} else {
return null;
}
}
}
}
}));

(cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15465(ns,name){
var ns__$1 = (((ns instanceof cljs.core.Keyword))?cljs.core.name(ns):(((ns instanceof cljs.core.Symbol))?cljs.core.name(ns):ns
));
var name__$1 = (((name instanceof cljs.core.Keyword))?cljs.core.name(name):(((name instanceof cljs.core.Symbol))?cljs.core.name(name):name
));
return (new cljs.core.Keyword(ns__$1,name__$1,[(cljs.core.truth_(ns__$1)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns__$1),"/"].join(''):null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(name__$1)].join(''),null));
}));

(cljs.core.keyword.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.LazySeq = (function (meta,fn,s,__hash){
this.meta = meta;
this.fn = fn;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.LazySeq.prototype.toString = (function cljs$core$fn_15467(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.LazySeq.prototype.equiv = (function cljs$core$fn_15468(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.LazySeq.prototype.sval = (function cljs$core$fn_15469(){
var self__ = this;
var coll = this;
if((self__.fn == null)){
return self__.s;
} else {
(self__.s = (self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null)));

(self__.fn = null);

return self__.s;
}
}));

(cljs.core.LazySeq.prototype.indexOf = (function() {
var cljs$core$fn_15470 = null;
var cljs$core$fn_15470__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_15470__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15470 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15470__1.call(this,x);
case 2:
return cljs$core$fn_15470__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15470.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15470__1;
cljs$core$fn_15470.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15470__2;
return cljs$core$fn_15470;
})()
);

(cljs.core.LazySeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_15471 = null;
var cljs$core$fn_15471__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_15471__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15471 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15471__1.call(this,x);
case 2:
return cljs$core$fn_15471__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15471.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15471__1;
cljs$core$fn_15471.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15471__2;
return cljs$core$fn_15471;
})()
);

(cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15472(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_15473(coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((self__.s == null)){
return null;
} else {
return cljs.core.next(self__.s);
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15474(coll){
var self__ = this;
var coll__$1 = this;
var h__10045__auto__ = self__.__hash;
if((!((h__10045__auto__ == null)))){
return h__10045__auto__;
} else {
var h__10045__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10045__auto____$1);

return h__10045__auto____$1;
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15475(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_15476(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.LazySeq.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function cljs$core$fn_15477(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.not(self__.fn);
}));

(cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_15478(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_15479(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_15480(coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((self__.s == null)){
return null;
} else {
return cljs.core.first(self__.s);
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_15481(coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((!((self__.s == null)))){
return cljs.core.rest(self__.s);
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_15482(coll){
var self__ = this;
var coll__$1 = this;
coll__$1.sval();

if((self__.s == null)){
return null;
} else {
var ls = self__.s;
while(true){
if((ls instanceof cljs.core.LazySeq)){
var G__15488 = ls.sval();
ls = G__15488;
continue;
} else {
(self__.s = ls);

return cljs.core.seq(self__.s);
}
break;
}
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_15483(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.LazySeq(new_meta,(function cljs$core$fn_15483_$_fn_15484(){
return coll__$1.cljs$core$ISeqable$_seq$arity$1(null);
}),null,self__.__hash));
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_15485(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.LazySeq.getBasis = (function cljs$core$fn_15486(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"fn","fn",465265323,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.LazySeq.cljs$lang$type = true);

(cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq");

(cljs.core.LazySeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_15487(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/LazySeq");
}));

/**
 * Positional factory function for cljs.core/LazySeq.
 */
cljs.core.__GT_LazySeq = (function cljs$core$__GT_LazySeq(meta,fn,s,__hash){
return (new cljs.core.LazySeq(meta,fn,s,__hash));
});

(cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15489(){
var this__10774__auto__ = this;
return cljs.core.es6_iterator(this__10774__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ICounted}
*/
cljs.core.ChunkBuffer = (function (buf,end){
this.buf = buf;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 2;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ChunkBuffer.prototype.add = (function cljs$core$fn_15490(o){
var self__ = this;
var _ = this;
(self__.buf[self__.end] = o);

return (self__.end = (self__.end + (1)));
}));

(cljs.core.ChunkBuffer.prototype.chunk = (function cljs$core$fn_15491(){
var self__ = this;
var _ = this;
var ret = (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));
(self__.buf = null);

return ret;
}));

(cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_15492(_){
var self__ = this;
var ___$1 = this;
return self__.end;
}));

(cljs.core.ChunkBuffer.getBasis = (function cljs$core$fn_15493(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"buf","buf",1426618187,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ChunkBuffer.cljs$lang$type = true);

(cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer");

(cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = (function cljs$core$fn_15494(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/ChunkBuffer");
}));

/**
 * Positional factory function for cljs.core/ChunkBuffer.
 */
cljs.core.__GT_ChunkBuffer = (function cljs$core$__GT_ChunkBuffer(buf,end){
return (new cljs.core.ChunkBuffer(buf,end));
});

cljs.core.chunk_buffer = (function cljs$core$chunk_buffer(capacity){
return (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.IChunk}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayChunk = (function (arr,off,end){
this.arr = arr;
this.off = off;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 524306;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_15495(_){
var self__ = this;
var ___$1 = this;
return (self__.end - self__.off);
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_15496(coll,i){
var self__ = this;
var coll__$1 = this;
return (self__.arr[(self__.off + i)]);
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_15497(coll,i,not_found){
var self__ = this;
var coll__$1 = this;
if((((i >= (0))) && ((i < (self__.end - self__.off))))){
return (self__.arr[(self__.off + i)]);
} else {
return not_found;
}
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function cljs$core$fn_15498(coll){
var self__ = this;
var coll__$1 = this;
if((self__.off === self__.end)){
throw (new Error("-drop-first of empty chunk"));
} else {
return (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));
}
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_15499(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_15500(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off);
}));

(cljs.core.ArrayChunk.getBasis = (function cljs$core$fn_15501(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null);
}));

(cljs.core.ArrayChunk.cljs$lang$type = true);

(cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk");

(cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = (function cljs$core$fn_15502(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/ArrayChunk");
}));

/**
 * Positional factory function for cljs.core/ArrayChunk.
 */
cljs.core.__GT_ArrayChunk = (function cljs$core$__GT_ArrayChunk(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk = (function cljs$core$array_chunk(var_args){
var G__15504 = arguments.length;
switch (G__15504) {
case 1:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15505(arr){
return (new cljs.core.ArrayChunk(arr,(0),arr.length));
}));

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15506(arr,off){
return (new cljs.core.ArrayChunk(arr,off,arr.length));
}));

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15507(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
}));

(cljs.core.array_chunk.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.ChunkedCons = (function (chunk,more,meta,__hash){
this.chunk = chunk;
this.more = more;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850732;
this.cljs$lang$protocol_mask$partition1$ = 1536;
});
(cljs.core.ChunkedCons.prototype.toString = (function cljs$core$fn_15509(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ChunkedCons.prototype.equiv = (function cljs$core$fn_15510(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ChunkedCons.prototype.indexOf = (function() {
var cljs$core$fn_15511 = null;
var cljs$core$fn_15511__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_15511__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15511 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15511__1.call(this,x);
case 2:
return cljs$core$fn_15511__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15511.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15511__1;
cljs$core$fn_15511.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15511__2;
return cljs$core$fn_15511;
})()
);

(cljs.core.ChunkedCons.prototype.lastIndexOf = (function() {
var cljs$core$fn_15512 = null;
var cljs$core$fn_15512__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_15512__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15512 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15512__1.call(this,x);
case 2:
return cljs$core$fn_15512__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15512.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15512__1;
cljs$core$fn_15512.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15512__2;
return cljs$core$fn_15512;
})()
);

(cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15513(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_15514(coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,null,null));
} else {
if((self__.more == null)){
return null;
} else {
return cljs.core._seq(self__.more);
}
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15515(coll){
var self__ = this;
var coll__$1 = this;
var h__10045__auto__ = self__.__hash;
if((!((h__10045__auto__ == null)))){
return h__10045__auto__;
} else {
var h__10045__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10045__auto____$1);

return h__10045__auto____$1;
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15516(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_15517(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_15518(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk,(0));
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_15519(coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,null,null));
} else {
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_15520(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function cljs$core$fn_15521(coll){
var self__ = this;
var coll__$1 = this;
return self__.chunk;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function cljs$core$fn_15522(coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_15523(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ChunkedCons(self__.chunk,self__.more,new_meta,self__.__hash));
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_15524(this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,this$__$1);
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function cljs$core$fn_15525(coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return null;
} else {
return self__.more;
}
}));

(cljs.core.ChunkedCons.getBasis = (function cljs$core$fn_15526(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"chunk","chunk",449371907,null),new cljs.core.Symbol(null,"more","more",-418290273,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ChunkedCons.cljs$lang$type = true);

(cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons");

(cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = (function cljs$core$fn_15527(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/ChunkedCons");
}));

/**
 * Positional factory function for cljs.core/ChunkedCons.
 */
cljs.core.__GT_ChunkedCons = (function cljs$core$__GT_ChunkedCons(chunk,more,meta,__hash){
return (new cljs.core.ChunkedCons(chunk,more,meta,__hash));
});

(cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15528(){
var this__10774__auto__ = this;
return cljs.core.es6_iterator(this__10774__auto__);
}));
cljs.core.chunk_cons = (function cljs$core$chunk_cons(chunk,rest){
if((cljs.core._count(chunk) === (0))){
return rest;
} else {
return (new cljs.core.ChunkedCons(chunk,rest,null,null));
}
});
cljs.core.chunk_append = (function cljs$core$chunk_append(b,x){
return b.add(x);
});
cljs.core.chunk = (function cljs$core$chunk(b){
return b.chunk();
});
cljs.core.chunk_first = (function cljs$core$chunk_first(s){
return cljs.core._chunked_first(s);
});
cljs.core.chunk_rest = (function cljs$core$chunk_rest(s){
return cljs.core._chunked_rest(s);
});
cljs.core.chunk_next = (function cljs$core$chunk_next(s){
if((((!((s == null))))?(((((s.cljs$lang$protocol_mask$partition1$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$IChunkedNext$))))?true:false):false)){
return s.cljs$core$IChunkedNext$_chunked_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core._chunked_rest(s));
}
});
/**
 * Returns an array containing the contents of coll.
 */
cljs.core.to_array = (function cljs$core$to_array(coll){
var ary = [];
var s = cljs.core.seq(coll);
while(true){
if((!((s == null)))){
ary.push(cljs.core.first(s));

var G__15530 = cljs.core.next(s);
s = G__15530;
continue;
} else {
return ary;
}
break;
}
});
/**
 * Returns a (potentially-ragged) 2-dimensional array
 *   containing the contents of coll.
 */
cljs.core.to_array_2d = (function cljs$core$to_array_2d(coll){
var ret = (new Array(cljs.core.count(coll)));
var i_15531 = (0);
var xs_15532 = cljs.core.seq(coll);
while(true){
if((xs_15532 == null)){
} else {
(ret[i_15531] = cljs.core.to_array(cljs.core.first(xs_15532)));

var G__15533 = (i_15531 + (1));
var G__15534 = cljs.core.next(xs_15532);
i_15531 = G__15533;
xs_15532 = G__15534;
continue;
}
break;
}

return ret;
});
/**
 * Creates an array of ints. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.int_array = (function cljs$core$int_array(var_args){
var G__15536 = arguments.length;
switch (G__15536) {
case 1:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15537(size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15538(size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__15540 = (i + (1));
var G__15541 = cljs.core.next(s__$1);
i = G__15540;
s__$1 = G__15541;
continue;
} else {
return a;
}
break;
}
} else {
var n__10672__auto___15542 = size;
var i_15543 = (0);
while(true){
if((i_15543 < n__10672__auto___15542)){
(a[i_15543] = init_val_or_seq);

var G__15544 = (i_15543 + (1));
i_15543 = G__15544;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.int_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of longs. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.long_array = (function cljs$core$long_array(var_args){
var G__15546 = arguments.length;
switch (G__15546) {
case 1:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15547(size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15548(size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__15550 = (i + (1));
var G__15551 = cljs.core.next(s__$1);
i = G__15550;
s__$1 = G__15551;
continue;
} else {
return a;
}
break;
}
} else {
var n__10672__auto___15552 = size;
var i_15553 = (0);
while(true){
if((i_15553 < n__10672__auto___15552)){
(a[i_15553] = init_val_or_seq);

var G__15554 = (i_15553 + (1));
i_15553 = G__15554;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.long_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of doubles. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.double_array = (function cljs$core$double_array(var_args){
var G__15556 = arguments.length;
switch (G__15556) {
case 1:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15557(size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15558(size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__15560 = (i + (1));
var G__15561 = cljs.core.next(s__$1);
i = G__15560;
s__$1 = G__15561;
continue;
} else {
return a;
}
break;
}
} else {
var n__10672__auto___15562 = size;
var i_15563 = (0);
while(true){
if((i_15563 < n__10672__auto___15562)){
(a[i_15563] = init_val_or_seq);

var G__15564 = (i_15563 + (1));
i_15563 = G__15564;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.double_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of objects. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.object_array = (function cljs$core$object_array(var_args){
var G__15566 = arguments.length;
switch (G__15566) {
case 1:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15567(size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15568(size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__15570 = (i + (1));
var G__15571 = cljs.core.next(s__$1);
i = G__15570;
s__$1 = G__15571;
continue;
} else {
return a;
}
break;
}
} else {
var n__10672__auto___15572 = size;
var i_15573 = (0);
while(true){
if((i_15573 < n__10672__auto___15572)){
(a[i_15573] = init_val_or_seq);

var G__15574 = (i_15573 + (1));
i_15573 = G__15574;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.object_array.cljs$lang$maxFixedArity = 2);

/**
 * If coll is counted? returns its count, else will count at most the first n
 * elements of coll using its seq
 */
cljs.core.bounded_count = (function cljs$core$bounded_count(n,coll){
if(cljs.core.counted_QMARK_(coll)){
return cljs.core.count(coll);
} else {
var i = (0);
var s = cljs.core.seq(coll);
while(true){
if((((!((s == null)))) && ((i < n)))){
var G__15575 = (i + (1));
var G__15576 = cljs.core.next(s);
i = G__15575;
s = G__15576;
continue;
} else {
return i;
}
break;
}
}
});
cljs.core.spread = (function cljs$core$spread(arglist){
if((arglist == null)){
return null;
} else {
var n = cljs.core.next(arglist);
if((n == null)){
return cljs.core.seq(cljs.core.first(arglist));
} else {
return cljs.core.cons(cljs.core.first(arglist),(cljs.core.spread.cljs$core$IFn$_invoke$arity$1 ? cljs.core.spread.cljs$core$IFn$_invoke$arity$1(n) : cljs.core.spread.call(null,n)));
}
}
});
/**
 * Returns a lazy seq representing the concatenation of the elements in the supplied colls.
 */
cljs.core.concat = (function cljs$core$concat(var_args){
var G__15581 = arguments.length;
switch (G__15581) {
case 0:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15592 = arguments.length;
var i__10914__auto___15593 = (0);
while(true){
if((i__10914__auto___15593 < len__10913__auto___15592)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15593]));

var G__15594 = (i__10914__auto___15593 + (1));
i__10914__auto___15593 = G__15594;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15582(){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15582_$_fn_15583(){
return null;
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15584(x){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15584_$_fn_15585(){
return x;
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15586(x,y){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15586_$_fn_15587(){
var s = cljs.core.seq(x);
if(s){
if(cljs.core.chunked_seq_QMARK_(s)){
return cljs.core.chunk_cons(cljs.core.chunk_first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));
} else {
return cljs.core.cons(cljs.core.first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));
}
} else {
return y;
}
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15588(x,y,zs){
var cat = (function cljs$core$fn_15588_$_cat(xys,zs__$1){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15588_$_cat_$_fn_15589(){
var xys__$1 = cljs.core.seq(xys);
if(xys__$1){
if(cljs.core.chunked_seq_QMARK_(xys__$1)){
return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cljs$core$fn_15588_$_cat(cljs.core.chunk_rest(xys__$1),zs__$1));
} else {
return cljs.core.cons(cljs.core.first(xys__$1),cljs$core$fn_15588_$_cat(cljs.core.rest(xys__$1),zs__$1));
}
} else {
if(cljs.core.truth_(zs__$1)){
return cljs$core$fn_15588_$_cat(cljs.core.first(zs__$1),cljs.core.next(zs__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x,y),zs);
}));

/** @this {Function} */
(cljs.core.concat.cljs$lang$applyTo = (function cljs$core$fn_15590(seq15578){
var G__15579 = cljs.core.first(seq15578);
var seq15578__$1 = cljs.core.next(seq15578);
var G__15580 = cljs.core.first(seq15578__$1);
var seq15578__$2 = cljs.core.next(seq15578__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15579,G__15580,seq15578__$2);
}));

(cljs.core.concat.cljs$lang$maxFixedArity = (2));

/**
 * Creates a new list containing the items prepended to the rest, the
 *   last of which will be treated as a sequence.
 */
cljs.core.list_STAR_ = (function cljs$core$list_STAR_(var_args){
var G__15601 = arguments.length;
switch (G__15601) {
case 1:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15609 = arguments.length;
var i__10914__auto___15610 = (0);
while(true){
if((i__10914__auto___15610 < len__10913__auto___15609)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15610]));

var G__15611 = (i__10914__auto___15610 + (1));
i__10914__auto___15610 = G__15611;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((4) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((4)),(0),null)):null);
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10943__auto__);

}
});

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15602(args){
return cljs.core.seq(args);
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15603(a,args){
return cljs.core.cons(a,args);
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15604(a,b,args){
return cljs.core.cons(a,cljs.core.cons(b,args));
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15605(a,b,c,args){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)));
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15606(a,b,c,d,more){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))));
}));

/** @this {Function} */
(cljs.core.list_STAR_.cljs$lang$applyTo = (function cljs$core$fn_15607(seq15596){
var G__15597 = cljs.core.first(seq15596);
var seq15596__$1 = cljs.core.next(seq15596);
var G__15598 = cljs.core.first(seq15596__$1);
var seq15596__$2 = cljs.core.next(seq15596__$1);
var G__15599 = cljs.core.first(seq15596__$2);
var seq15596__$3 = cljs.core.next(seq15596__$2);
var G__15600 = cljs.core.first(seq15596__$3);
var seq15596__$4 = cljs.core.next(seq15596__$3);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15597,G__15598,G__15599,G__15600,seq15596__$4);
}));

(cljs.core.list_STAR_.cljs$lang$maxFixedArity = (4));

/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core.transient$ = (function cljs$core$transient(coll){
return cljs.core._as_transient(coll);
});
/**
 * Returns a new, persistent version of the transient collection, in
 *   constant time. The transient collection cannot be used after this
 *   call, any such use will throw an exception.
 */
cljs.core.persistent_BANG_ = (function cljs$core$persistent_BANG_(tcoll){
return cljs.core._persistent_BANG_(tcoll);
});
/**
 * Adds val to the transient collection, and return tcoll. The 'addition'
 *   may happen at different 'places' depending on the concrete type.
 */
cljs.core.conj_BANG_ = (function cljs$core$conj_BANG_(var_args){
var G__15616 = arguments.length;
switch (G__15616) {
case 0:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15623 = arguments.length;
var i__10914__auto___15624 = (0);
while(true){
if((i__10914__auto___15624 < len__10913__auto___15623)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15624]));

var G__15625 = (i__10914__auto___15624 + (1));
i__10914__auto___15624 = G__15625;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15617(){
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15618(tcoll){
return tcoll;
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15619(tcoll,val){
return cljs.core._conj_BANG_(tcoll,val);
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15620(tcoll,val,vals){
while(true){
var ntcoll = cljs.core._conj_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__15626 = ntcoll;
var G__15627 = cljs.core.first(vals);
var G__15628 = cljs.core.next(vals);
tcoll = G__15626;
val = G__15627;
vals = G__15628;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.conj_BANG_.cljs$lang$applyTo = (function cljs$core$fn_15621(seq15613){
var G__15614 = cljs.core.first(seq15613);
var seq15613__$1 = cljs.core.next(seq15613);
var G__15615 = cljs.core.first(seq15613__$1);
var seq15613__$2 = cljs.core.next(seq15613__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15614,G__15615,seq15613__$2);
}));

(cljs.core.conj_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * When applied to a transient map, adds mapping of key(s) to
 *   val(s). When applied to a transient vector, sets the val at index.
 *   Note - index must be <= (count vector). Returns coll.
 */
cljs.core.assoc_BANG_ = (function cljs$core$assoc_BANG_(var_args){
var G__15634 = arguments.length;
switch (G__15634) {
case 3:
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15639 = arguments.length;
var i__10914__auto___15640 = (0);
while(true){
if((i__10914__auto___15640 < len__10913__auto___15639)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15640]));

var G__15641 = (i__10914__auto___15640 + (1));
i__10914__auto___15640 = G__15641;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((3) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((3)),(0),null)):null);
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10943__auto__);

}
});

(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15635(tcoll,key,val){
return cljs.core._assoc_BANG_(tcoll,key,val);
}));

(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15636(tcoll,key,val,kvs){
while(true){
var ntcoll = cljs.core._assoc_BANG_(tcoll,key,val);
if(cljs.core.truth_(kvs)){
var G__15642 = ntcoll;
var G__15643 = cljs.core.first(kvs);
var G__15644 = cljs.core.second(kvs);
var G__15645 = cljs.core.nnext(kvs);
tcoll = G__15642;
key = G__15643;
val = G__15644;
kvs = G__15645;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.assoc_BANG_.cljs$lang$applyTo = (function cljs$core$fn_15637(seq15630){
var G__15631 = cljs.core.first(seq15630);
var seq15630__$1 = cljs.core.next(seq15630);
var G__15632 = cljs.core.first(seq15630__$1);
var seq15630__$2 = cljs.core.next(seq15630__$1);
var G__15633 = cljs.core.first(seq15630__$2);
var seq15630__$3 = cljs.core.next(seq15630__$2);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15631,G__15632,G__15633,seq15630__$3);
}));

(cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = (3));

/**
 * Returns a transient map that doesn't contain a mapping for key(s).
 */
cljs.core.dissoc_BANG_ = (function cljs$core$dissoc_BANG_(var_args){
var G__15650 = arguments.length;
switch (G__15650) {
case 2:
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15655 = arguments.length;
var i__10914__auto___15656 = (0);
while(true){
if((i__10914__auto___15656 < len__10913__auto___15655)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15656]));

var G__15657 = (i__10914__auto___15656 + (1));
i__10914__auto___15656 = G__15657;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15651(tcoll,key){
return cljs.core._dissoc_BANG_(tcoll,key);
}));

(cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15652(tcoll,key,ks){
while(true){
var ntcoll = cljs.core._dissoc_BANG_(tcoll,key);
if(cljs.core.truth_(ks)){
var G__15658 = ntcoll;
var G__15659 = cljs.core.first(ks);
var G__15660 = cljs.core.next(ks);
tcoll = G__15658;
key = G__15659;
ks = G__15660;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.dissoc_BANG_.cljs$lang$applyTo = (function cljs$core$fn_15653(seq15647){
var G__15648 = cljs.core.first(seq15647);
var seq15647__$1 = cljs.core.next(seq15647);
var G__15649 = cljs.core.first(seq15647__$1);
var seq15647__$2 = cljs.core.next(seq15647__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15648,G__15649,seq15647__$2);
}));

(cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Removes the last item from a transient vector. If
 *   the collection is empty, throws an exception. Returns tcoll
 */
cljs.core.pop_BANG_ = (function cljs$core$pop_BANG_(tcoll){
return cljs.core._pop_BANG_(tcoll);
});
/**
 * disj[oin]. Returns a transient set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj_BANG_ = (function cljs$core$disj_BANG_(var_args){
var G__15665 = arguments.length;
switch (G__15665) {
case 2:
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15670 = arguments.length;
var i__10914__auto___15671 = (0);
while(true){
if((i__10914__auto___15671 < len__10913__auto___15670)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15671]));

var G__15672 = (i__10914__auto___15671 + (1));
i__10914__auto___15671 = G__15672;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15666(tcoll,val){
return cljs.core._disjoin_BANG_(tcoll,val);
}));

(cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15667(tcoll,val,vals){
while(true){
var ntcoll = cljs.core._disjoin_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__15673 = ntcoll;
var G__15674 = cljs.core.first(vals);
var G__15675 = cljs.core.next(vals);
tcoll = G__15673;
val = G__15674;
vals = G__15675;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.disj_BANG_.cljs$lang$applyTo = (function cljs$core$fn_15668(seq15662){
var G__15663 = cljs.core.first(seq15662);
var seq15662__$1 = cljs.core.next(seq15662);
var G__15664 = cljs.core.first(seq15662__$1);
var seq15662__$2 = cljs.core.next(seq15662__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15663,G__15664,seq15662__$2);
}));

(cljs.core.disj_BANG_.cljs$lang$maxFixedArity = (2));


cljs.core.apply_to = (function cljs$core$apply_to(f,argc,args){
var args__$1 = cljs.core.seq(args);
if((argc === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var a10716 = cljs.core._first(args__$1);
var args__$2 = cljs.core._rest(args__$1);
if((argc === (1))){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(a10716) : f.call(null,a10716));
} else {
var b10717 = cljs.core._first(args__$2);
var args__$3 = cljs.core._rest(args__$2);
if((argc === (2))){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(a10716,b10717) : f.call(null,a10716,b10717));
} else {
var c10718 = cljs.core._first(args__$3);
var args__$4 = cljs.core._rest(args__$3);
if((argc === (3))){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(a10716,b10717,c10718) : f.call(null,a10716,b10717,c10718));
} else {
var d10719 = cljs.core._first(args__$4);
var args__$5 = cljs.core._rest(args__$4);
if((argc === (4))){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(a10716,b10717,c10718,d10719) : f.call(null,a10716,b10717,c10718,d10719));
} else {
var e10720 = cljs.core._first(args__$5);
var args__$6 = cljs.core._rest(args__$5);
if((argc === (5))){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(a10716,b10717,c10718,d10719,e10720) : f.call(null,a10716,b10717,c10718,d10719,e10720));
} else {
var f10721 = cljs.core._first(args__$6);
var args__$7 = cljs.core._rest(args__$6);
if((argc === (6))){
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(a10716,b10717,c10718,d10719,e10720,f10721) : f.call(null,a10716,b10717,c10718,d10719,e10720,f10721));
} else {
var g10722 = cljs.core._first(args__$7);
var args__$8 = cljs.core._rest(args__$7);
if((argc === (7))){
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(a10716,b10717,c10718,d10719,e10720,f10721,g10722) : f.call(null,a10716,b10717,c10718,d10719,e10720,f10721,g10722));
} else {
var h10723 = cljs.core._first(args__$8);
var args__$9 = cljs.core._rest(args__$8);
if((argc === (8))){
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723) : f.call(null,a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723));
} else {
var i10724 = cljs.core._first(args__$9);
var args__$10 = cljs.core._rest(args__$9);
if((argc === (9))){
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723,i10724) : f.call(null,a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723,i10724));
} else {
var j10725 = cljs.core._first(args__$10);
var args__$11 = cljs.core._rest(args__$10);
if((argc === (10))){
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723,i10724,j10725) : f.call(null,a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723,i10724,j10725));
} else {
var k10726 = cljs.core._first(args__$11);
var args__$12 = cljs.core._rest(args__$11);
if((argc === (11))){
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723,i10724,j10725,k10726) : f.call(null,a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723,i10724,j10725,k10726));
} else {
var l10727 = cljs.core._first(args__$12);
var args__$13 = cljs.core._rest(args__$12);
if((argc === (12))){
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723,i10724,j10725,k10726,l10727) : f.call(null,a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723,i10724,j10725,k10726,l10727));
} else {
var m10728 = cljs.core._first(args__$13);
var args__$14 = cljs.core._rest(args__$13);
if((argc === (13))){
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723,i10724,j10725,k10726,l10727,m10728) : f.call(null,a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723,i10724,j10725,k10726,l10727,m10728));
} else {
var n10729 = cljs.core._first(args__$14);
var args__$15 = cljs.core._rest(args__$14);
if((argc === (14))){
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723,i10724,j10725,k10726,l10727,m10728,n10729) : f.call(null,a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723,i10724,j10725,k10726,l10727,m10728,n10729));
} else {
var o10730 = cljs.core._first(args__$15);
var args__$16 = cljs.core._rest(args__$15);
if((argc === (15))){
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723,i10724,j10725,k10726,l10727,m10728,n10729,o10730) : f.call(null,a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723,i10724,j10725,k10726,l10727,m10728,n10729,o10730));
} else {
var p10731 = cljs.core._first(args__$16);
var args__$17 = cljs.core._rest(args__$16);
if((argc === (16))){
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723,i10724,j10725,k10726,l10727,m10728,n10729,o10730,p10731) : f.call(null,a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723,i10724,j10725,k10726,l10727,m10728,n10729,o10730,p10731));
} else {
var q10732 = cljs.core._first(args__$17);
var args__$18 = cljs.core._rest(args__$17);
if((argc === (17))){
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723,i10724,j10725,k10726,l10727,m10728,n10729,o10730,p10731,q10732) : f.call(null,a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723,i10724,j10725,k10726,l10727,m10728,n10729,o10730,p10731,q10732));
} else {
var r10733 = cljs.core._first(args__$18);
var args__$19 = cljs.core._rest(args__$18);
if((argc === (18))){
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723,i10724,j10725,k10726,l10727,m10728,n10729,o10730,p10731,q10732,r10733) : f.call(null,a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723,i10724,j10725,k10726,l10727,m10728,n10729,o10730,p10731,q10732,r10733));
} else {
var s10734 = cljs.core._first(args__$19);
var args__$20 = cljs.core._rest(args__$19);
if((argc === (19))){
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723,i10724,j10725,k10726,l10727,m10728,n10729,o10730,p10731,q10732,r10733,s10734) : f.call(null,a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723,i10724,j10725,k10726,l10727,m10728,n10729,o10730,p10731,q10732,r10733,s10734));
} else {
var t10735 = cljs.core._first(args__$20);
var args__$21 = cljs.core._rest(args__$20);
if((argc === (20))){
return (f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723,i10724,j10725,k10726,l10727,m10728,n10729,o10730,p10731,q10732,r10733,s10734,t10735) : f.call(null,a10716,b10717,c10718,d10719,e10720,f10721,g10722,h10723,i10724,j10725,k10726,l10727,m10728,n10729,o10730,p10731,q10732,r10733,s10734,t10735));
} else {
throw (new Error("Only up to 20 arguments supported on functions"));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

/**
 * Internal. DO NOT USE! Next without the nil? check.
 */
cljs.core.next_STAR_ = (function cljs$core$next_STAR_(coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$))))?true:false):false)){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
});
/**
 * Internal. DO NOT USE!
 *   Assumes args was already called with seq beforehand!
 */
cljs.core.apply_to_simple = (function cljs$core$apply_to_simple(var_args){
var G__15678 = arguments.length;
switch (G__15678) {
case 2:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15679(f,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$0){
return f.cljs$core$IFn$_invoke$arity$0();
} else {
return f.call(f);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(f,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15680(f,a0,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$1){
return f.cljs$core$IFn$_invoke$arity$1(a0);
} else {
return f.call(f,a0);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(f,a0,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15681(f,a0,a1,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$2){
return f.cljs$core$IFn$_invoke$arity$2(a0,a1);
} else {
return f.call(f,a0,a1);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(f,a0,a1,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_15682(f,a0,a1,a2,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$3){
return f.cljs$core$IFn$_invoke$arity$3(a0,a1,a2);
} else {
return f.call(f,a0,a1,a2);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(f,a0,a1,a2,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_15683(f,a0,a1,a2,a3,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$4){
return f.cljs$core$IFn$_invoke$arity$4(a0,a1,a2,a3);
} else {
return f.call(f,a0,a1,a2,a3);
}
} else {
var a4 = cljs.core._first(args);
var next_4 = cljs.core.next(args);
if((next_4 == null)){
if(f.cljs$core$IFn$_invoke$arity$5){
return f.cljs$core$IFn$_invoke$arity$5(a0,a1,a2,a3,a4);
} else {
return f.call(f,a0,a1,a2,a3,a4);
}
} else {
var a5 = cljs.core._first(next_4);
var next_5 = cljs.core.next(next_4);
if((next_5 == null)){
if(f.cljs$core$IFn$_invoke$arity$6){
return f.cljs$core$IFn$_invoke$arity$6(a0,a1,a2,a3,a4,a5);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5);
}
} else {
var a6 = cljs.core._first(next_5);
var next_6 = cljs.core.next(next_5);
if((next_6 == null)){
if(f.cljs$core$IFn$_invoke$arity$7){
return f.cljs$core$IFn$_invoke$arity$7(a0,a1,a2,a3,a4,a5,a6);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6);
}
} else {
var a7 = cljs.core._first(next_6);
var next_7 = cljs.core.next(next_6);
if((next_7 == null)){
if(f.cljs$core$IFn$_invoke$arity$8){
return f.cljs$core$IFn$_invoke$arity$8(a0,a1,a2,a3,a4,a5,a6,a7);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7);
}
} else {
var a8 = cljs.core._first(next_7);
var next_8 = cljs.core.next(next_7);
if((next_8 == null)){
if(f.cljs$core$IFn$_invoke$arity$9){
return f.cljs$core$IFn$_invoke$arity$9(a0,a1,a2,a3,a4,a5,a6,a7,a8);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8);
}
} else {
var a9 = cljs.core._first(next_8);
var next_9 = cljs.core.next(next_8);
if((next_9 == null)){
if(f.cljs$core$IFn$_invoke$arity$10){
return f.cljs$core$IFn$_invoke$arity$10(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);
}
} else {
var a10 = cljs.core._first(next_9);
var next_10 = cljs.core.next(next_9);
if((next_10 == null)){
if(f.cljs$core$IFn$_invoke$arity$11){
return f.cljs$core$IFn$_invoke$arity$11(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
}
} else {
var a11 = cljs.core._first(next_10);
var next_11 = cljs.core.next(next_10);
if((next_11 == null)){
if(f.cljs$core$IFn$_invoke$arity$12){
return f.cljs$core$IFn$_invoke$arity$12(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
}
} else {
var a12 = cljs.core._first(next_11);
var next_12 = cljs.core.next(next_11);
if((next_12 == null)){
if(f.cljs$core$IFn$_invoke$arity$13){
return f.cljs$core$IFn$_invoke$arity$13(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);
}
} else {
var a13 = cljs.core._first(next_12);
var next_13 = cljs.core.next(next_12);
if((next_13 == null)){
if(f.cljs$core$IFn$_invoke$arity$14){
return f.cljs$core$IFn$_invoke$arity$14(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13);
}
} else {
var a14 = cljs.core._first(next_13);
var next_14 = cljs.core.next(next_13);
if((next_14 == null)){
if(f.cljs$core$IFn$_invoke$arity$15){
return f.cljs$core$IFn$_invoke$arity$15(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14);
}
} else {
var a15 = cljs.core._first(next_14);
var next_15 = cljs.core.next(next_14);
if((next_15 == null)){
if(f.cljs$core$IFn$_invoke$arity$16){
return f.cljs$core$IFn$_invoke$arity$16(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);
}
} else {
var a16 = cljs.core._first(next_15);
var next_16 = cljs.core.next(next_15);
if((next_16 == null)){
if(f.cljs$core$IFn$_invoke$arity$17){
return f.cljs$core$IFn$_invoke$arity$17(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16);
}
} else {
var a17 = cljs.core._first(next_16);
var next_17 = cljs.core.next(next_16);
if((next_17 == null)){
if(f.cljs$core$IFn$_invoke$arity$18){
return f.cljs$core$IFn$_invoke$arity$18(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17);
}
} else {
var a18 = cljs.core._first(next_17);
var next_18 = cljs.core.next(next_17);
if((next_18 == null)){
if(f.cljs$core$IFn$_invoke$arity$19){
return f.cljs$core$IFn$_invoke$arity$19(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18);
}
} else {
var a19 = cljs.core._first(next_18);
var next_19 = cljs.core.next(next_18);
if((next_19 == null)){
if(f.cljs$core$IFn$_invoke$arity$20){
return f.cljs$core$IFn$_invoke$arity$20(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19);
}
} else {
var arr__10744__auto__ = [a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19];
var s__10745__auto___15685 = next_19;
while(true){
if(s__10745__auto___15685){
arr__10744__auto__.push(cljs.core._first(s__10745__auto___15685));

var G__15686 = cljs.core.next(s__10745__auto___15685);
s__10745__auto___15685 = G__15686;
continue;
} else {
}
break;
}

return f.apply(f,arr__10744__auto__);
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(cljs.core.apply_to_simple.cljs$lang$maxFixedArity = 6);

/**
 * Applies fn f to the argument list formed by prepending intervening arguments to args.
 */
cljs.core.apply = (function cljs$core$apply(var_args){
var G__15694 = arguments.length;
switch (G__15694) {
case 2:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15702 = arguments.length;
var i__10914__auto___15703 = (0);
while(true){
if((i__10914__auto___15703 < len__10913__auto___15702)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15703]));

var G__15704 = (i__10914__auto___15703 + (1));
i__10914__auto___15703 = G__15704;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((5) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((5)),(0),null)):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__10943__auto__);

}
});

(cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15695(f,args){
if(f.cljs$lang$applyTo){
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = cljs.core.bounded_count((fixed_arity + (1)),args);
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,args);
} else {
return f.cljs$lang$applyTo(args);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2(f,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15696(f,x,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = (cljs.core.bounded_count(fixed_arity,args) + (1));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(f,x,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15697(f,x,y,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x,y,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((2) + cljs.core.bounded_count((fixed_arity - (1)),args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(f,x,y,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_15698(f,x,y,z,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x,y,z,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((3) + cljs.core.bounded_count((fixed_arity - (2)),args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(f,x,y,z,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15699(f,a,b,c,d,args){
if(f.cljs$lang$applyTo){
var spread_args = cljs.core.spread(args);
var arglist = cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,spread_args))));
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((4) + cljs.core.bounded_count((fixed_arity - (3)),spread_args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(f,a,b,c,d,cljs.core.spread(args));
}
}));

/** @this {Function} */
(cljs.core.apply.cljs$lang$applyTo = (function cljs$core$fn_15700(seq15688){
var G__15689 = cljs.core.first(seq15688);
var seq15688__$1 = cljs.core.next(seq15688);
var G__15690 = cljs.core.first(seq15688__$1);
var seq15688__$2 = cljs.core.next(seq15688__$1);
var G__15691 = cljs.core.first(seq15688__$2);
var seq15688__$3 = cljs.core.next(seq15688__$2);
var G__15692 = cljs.core.first(seq15688__$3);
var seq15688__$4 = cljs.core.next(seq15688__$3);
var G__15693 = cljs.core.first(seq15688__$4);
var seq15688__$5 = cljs.core.next(seq15688__$4);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15689,G__15690,G__15691,G__15692,G__15693,seq15688__$5);
}));

(cljs.core.apply.cljs$lang$maxFixedArity = (5));

cljs.core.__destructure_map = (function cljs$core$__destructure_map(gmap){
if((((!((gmap == null))))?(((((gmap.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === gmap.cljs$core$ISeq$))))?true:false):false)){
if(cljs.core.next(gmap)){
return cljs.core.PersistentArrayMap.createAsIfByAssoc(cljs.core.to_array(gmap));
} else {
if(cljs.core.seq(gmap)){
return cljs.core.first(gmap);
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
}
} else {
return gmap;
}
});
/**
 * Returns an object of the same type and value as obj, with
 *   (apply f (meta obj) args) as its metadata.
 */
cljs.core.vary_meta = (function cljs$core$vary_meta(var_args){
var G__15714 = arguments.length;
switch (G__15714) {
case 2:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15738 = arguments.length;
var i__10914__auto___15739 = (0);
while(true){
if((i__10914__auto___15739 < len__10913__auto___15738)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15739]));

var G__15740 = (i__10914__auto___15739 + (1));
i__10914__auto___15739 = G__15740;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((6) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((6)),(0),null)):null);
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__10943__auto__);

}
});

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15715(obj,f){
return cljs.core.with_meta(obj,(function (){var G__15716 = cljs.core.meta(obj);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15716) : f.call(null,G__15716));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15717(obj,f,a){
return cljs.core.with_meta(obj,(function (){var G__15718 = cljs.core.meta(obj);
var G__15719 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15718,G__15719) : f.call(null,G__15718,G__15719));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15720(obj,f,a,b){
return cljs.core.with_meta(obj,(function (){var G__15721 = cljs.core.meta(obj);
var G__15722 = a;
var G__15723 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15721,G__15722,G__15723) : f.call(null,G__15721,G__15722,G__15723));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_15724(obj,f,a,b,c){
return cljs.core.with_meta(obj,(function (){var G__15725 = cljs.core.meta(obj);
var G__15726 = a;
var G__15727 = b;
var G__15728 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__15725,G__15726,G__15727,G__15728) : f.call(null,G__15725,G__15726,G__15727,G__15728));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_15729(obj,f,a,b,c,d){
return cljs.core.with_meta(obj,(function (){var G__15730 = cljs.core.meta(obj);
var G__15731 = a;
var G__15732 = b;
var G__15733 = c;
var G__15734 = d;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__15730,G__15731,G__15732,G__15733,G__15734) : f.call(null,G__15730,G__15731,G__15732,G__15733,G__15734));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15735(obj,f,a,b,c,d,args){
return cljs.core.with_meta(obj,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.meta(obj),a,b,c,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([d,args], 0)));
}));

/** @this {Function} */
(cljs.core.vary_meta.cljs$lang$applyTo = (function cljs$core$fn_15736(seq15707){
var G__15708 = cljs.core.first(seq15707);
var seq15707__$1 = cljs.core.next(seq15707);
var G__15709 = cljs.core.first(seq15707__$1);
var seq15707__$2 = cljs.core.next(seq15707__$1);
var G__15710 = cljs.core.first(seq15707__$2);
var seq15707__$3 = cljs.core.next(seq15707__$2);
var G__15711 = cljs.core.first(seq15707__$3);
var seq15707__$4 = cljs.core.next(seq15707__$3);
var G__15712 = cljs.core.first(seq15707__$4);
var seq15707__$5 = cljs.core.next(seq15707__$4);
var G__15713 = cljs.core.first(seq15707__$5);
var seq15707__$6 = cljs.core.next(seq15707__$5);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15708,G__15709,G__15710,G__15711,G__15712,G__15713,seq15707__$6);
}));

(cljs.core.vary_meta.cljs$lang$maxFixedArity = (6));

/**
 * Same as (not (= obj1 obj2))
 */
cljs.core.not_EQ_ = (function cljs$core$not_EQ_(var_args){
var G__15745 = arguments.length;
switch (G__15745) {
case 1:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15751 = arguments.length;
var i__10914__auto___15752 = (0);
while(true){
if((i__10914__auto___15752 < len__10913__auto___15751)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15752]));

var G__15753 = (i__10914__auto___15752 + (1));
i__10914__auto___15752 = G__15753;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15746(x){
return false;
}));

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15747(x,y){
return (!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)));
}));

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15748(x,y,more){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more));
}));

/** @this {Function} */
(cljs.core.not_EQ_.cljs$lang$applyTo = (function cljs$core$fn_15749(seq15742){
var G__15743 = cljs.core.first(seq15742);
var seq15742__$1 = cljs.core.next(seq15742);
var G__15744 = cljs.core.first(seq15742__$1);
var seq15742__$2 = cljs.core.next(seq15742__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15743,G__15744,seq15742__$2);
}));

(cljs.core.not_EQ_.cljs$lang$maxFixedArity = (2));

/**
 * If coll is empty, returns nil, else coll
 */
cljs.core.not_empty = (function cljs$core$not_empty(coll){
if(cljs.core.seq(coll)){
return coll;
} else {
return null;
}
});
cljs.core.nil_iter = (function cljs$core$nil_iter(){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.t_cljs$core15754 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.t_cljs$core15754 = (function (meta15755){
this.meta15755 = meta15755;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.t_cljs$core15754.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$nil_iter_$_fn_15757(_15756,meta15755__$1){
var self__ = this;
var _15756__$1 = this;
return (new cljs.core.t_cljs$core15754(meta15755__$1));
}));

(cljs.core.t_cljs$core15754.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$nil_iter_$_fn_15758(_15756){
var self__ = this;
var _15756__$1 = this;
return self__.meta15755;
}));

(cljs.core.t_cljs$core15754.prototype.hasNext = (function cljs$core$nil_iter_$_fn_15759(){
var self__ = this;
var _ = this;
return false;
}));

(cljs.core.t_cljs$core15754.prototype.next = (function cljs$core$nil_iter_$_fn_15760(){
var self__ = this;
var _ = this;
return (new Error("No such element"));
}));

(cljs.core.t_cljs$core15754.prototype.remove = (function cljs$core$nil_iter_$_fn_15761(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.t_cljs$core15754.getBasis = (function cljs$core$nil_iter_$_fn_15762(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta15755","meta15755",884768607,null)], null);
}));

(cljs.core.t_cljs$core15754.cljs$lang$type = true);

(cljs.core.t_cljs$core15754.cljs$lang$ctorStr = "cljs.core/t_cljs$core15754");

(cljs.core.t_cljs$core15754.cljs$lang$ctorPrWriter = (function cljs$core$nil_iter_$_fn_15763(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/t_cljs$core15754");
}));

/**
 * Positional factory function for cljs.core/t_cljs$core15754.
 */
cljs.core.__GT_t_cljs$core15754 = (function cljs$core$nil_iter_$___GT_t_cljs$core15754(meta15755){
return (new cljs.core.t_cljs$core15754(meta15755));
});

}

return (new cljs.core.t_cljs$core15754(cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
*/
cljs.core.StringIter = (function (s,i){
this.s = s;
this.i = i;
});
(cljs.core.StringIter.prototype.hasNext = (function cljs$core$fn_15764(){
var self__ = this;
var _ = this;
return (self__.i < self__.s.length);
}));

(cljs.core.StringIter.prototype.next = (function cljs$core$fn_15765(){
var self__ = this;
var _ = this;
var ret = self__.s.charAt(self__.i);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.StringIter.prototype.remove = (function cljs$core$fn_15766(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.StringIter.getBasis = (function cljs$core$fn_15767(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.StringIter.cljs$lang$type = true);

(cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter");

(cljs.core.StringIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_15768(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/StringIter");
}));

/**
 * Positional factory function for cljs.core/StringIter.
 */
cljs.core.__GT_StringIter = (function cljs$core$__GT_StringIter(s,i){
return (new cljs.core.StringIter(s,i));
});

cljs.core.string_iter = (function cljs$core$string_iter(x){
return (new cljs.core.StringIter(x,(0)));
});

/**
* @constructor
*/
cljs.core.ArrayIter = (function (arr,i){
this.arr = arr;
this.i = i;
});
(cljs.core.ArrayIter.prototype.hasNext = (function cljs$core$fn_15769(){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
}));

(cljs.core.ArrayIter.prototype.next = (function cljs$core$fn_15770(){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.ArrayIter.prototype.remove = (function cljs$core$fn_15771(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.ArrayIter.getBasis = (function cljs$core$fn_15772(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayIter.cljs$lang$type = true);

(cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter");

(cljs.core.ArrayIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_15773(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/ArrayIter");
}));

/**
 * Positional factory function for cljs.core/ArrayIter.
 */
cljs.core.__GT_ArrayIter = (function cljs$core$__GT_ArrayIter(arr,i){
return (new cljs.core.ArrayIter(arr,i));
});

cljs.core.array_iter = (function cljs$core$array_iter(x){
return (new cljs.core.ArrayIter(x,(0)));
});
cljs.core.INIT = ({});
cljs.core.START = ({});

/**
* @constructor
*/
cljs.core.SeqIter = (function (_seq,_next){
this._seq = _seq;
this._next = _next;
});
(cljs.core.SeqIter.prototype.hasNext = (function cljs$core$fn_15774(){
var self__ = this;
var _ = this;
if((self__._seq === cljs.core.INIT)){
(self__._seq = cljs.core.START);

(self__._next = cljs.core.seq(self__._next));
} else {
if((self__._seq === self__._next)){
(self__._next = cljs.core.next(self__._seq));
} else {
}
}

return (!((self__._next == null)));
}));

(cljs.core.SeqIter.prototype.next = (function cljs$core$fn_15775(){
var self__ = this;
var this$ = this;
if((!(this$.hasNext()))){
throw (new Error("No such element"));
} else {
(self__._seq = self__._next);

return cljs.core.first(self__._next);
}
}));

(cljs.core.SeqIter.prototype.remove = (function cljs$core$fn_15776(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.SeqIter.getBasis = (function cljs$core$fn_15777(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"_seq","_seq",-449557847,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.SeqIter.cljs$lang$type = true);

(cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter");

(cljs.core.SeqIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_15778(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/SeqIter");
}));

/**
 * Positional factory function for cljs.core/SeqIter.
 */
cljs.core.__GT_SeqIter = (function cljs$core$__GT_SeqIter(_seq,_next){
return (new cljs.core.SeqIter(_seq,_next));
});

cljs.core.seq_iter = (function cljs$core$seq_iter(coll){
return (new cljs.core.SeqIter(cljs.core.INIT,coll));
});
cljs.core.iter = (function cljs$core$iter(coll){
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core._iterator(coll);
} else {
if((coll == null)){
return cljs.core.nil_iter();
} else {
if(typeof coll === 'string'){
return cljs.core.string_iter(coll);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_iter(coll);
} else {
if(cljs.core.seqable_QMARK_(coll)){
return cljs.core.seq_iter(coll);
} else {
throw (new Error(["Cannot create iterator from ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll)].join('')));

}
}
}
}
}
});

/**
* @constructor
*/
cljs.core.Many = (function (vals){
this.vals = vals;
});
(cljs.core.Many.prototype.add = (function cljs$core$fn_15779(o){
var self__ = this;
var this$ = this;
self__.vals.push(o);

return this$;
}));

(cljs.core.Many.prototype.remove = (function cljs$core$fn_15780(){
var self__ = this;
var this$ = this;
return self__.vals.shift();
}));

(cljs.core.Many.prototype.isEmpty = (function cljs$core$fn_15781(){
var self__ = this;
var this$ = this;
return (self__.vals.length === (0));
}));

(cljs.core.Many.prototype.toString = (function cljs$core$fn_15782(){
var self__ = this;
var this$ = this;
return ["Many: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.vals)].join('');
}));

(cljs.core.Many.getBasis = (function cljs$core$fn_15783(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"vals","vals",-1886377036,null)], null);
}));

(cljs.core.Many.cljs$lang$type = true);

(cljs.core.Many.cljs$lang$ctorStr = "cljs.core/Many");

(cljs.core.Many.cljs$lang$ctorPrWriter = (function cljs$core$fn_15784(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/Many");
}));

/**
 * Positional factory function for cljs.core/Many.
 */
cljs.core.__GT_Many = (function cljs$core$__GT_Many(vals){
return (new cljs.core.Many(vals));
});

cljs.core.NONE = ({});

/**
* @constructor
*/
cljs.core.Single = (function (val){
this.val = val;
});
(cljs.core.Single.prototype.add = (function cljs$core$fn_15785(o){
var self__ = this;
var this$ = this;
if((self__.val === cljs.core.NONE)){
(self__.val = o);

return this$;
} else {
return (new cljs.core.Many([self__.val,o]));
}
}));

(cljs.core.Single.prototype.remove = (function cljs$core$fn_15786(){
var self__ = this;
var this$ = this;
if((self__.val === cljs.core.NONE)){
throw (new Error("Removing object from empty buffer"));
} else {
var ret = self__.val;
(self__.val = cljs.core.NONE);

return ret;
}
}));

(cljs.core.Single.prototype.isEmpty = (function cljs$core$fn_15787(){
var self__ = this;
var this$ = this;
return (self__.val === cljs.core.NONE);
}));

(cljs.core.Single.prototype.toString = (function cljs$core$fn_15788(){
var self__ = this;
var this$ = this;
return ["Single: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.val)].join('');
}));

(cljs.core.Single.getBasis = (function cljs$core$fn_15789(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Single.cljs$lang$type = true);

(cljs.core.Single.cljs$lang$ctorStr = "cljs.core/Single");

(cljs.core.Single.cljs$lang$ctorPrWriter = (function cljs$core$fn_15790(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/Single");
}));

/**
 * Positional factory function for cljs.core/Single.
 */
cljs.core.__GT_Single = (function cljs$core$__GT_Single(val){
return (new cljs.core.Single(val));
});


/**
* @constructor
*/
cljs.core.Empty = (function (){
});
(cljs.core.Empty.prototype.add = (function cljs$core$fn_15791(o){
var self__ = this;
var this$ = this;
return (new cljs.core.Single(o));
}));

(cljs.core.Empty.prototype.remove = (function cljs$core$fn_15792(){
var self__ = this;
var this$ = this;
throw (new Error("Removing object from empty buffer"));
}));

(cljs.core.Empty.prototype.isEmpty = (function cljs$core$fn_15793(){
var self__ = this;
var this$ = this;
return true;
}));

(cljs.core.Empty.prototype.toString = (function cljs$core$fn_15794(){
var self__ = this;
var this$ = this;
return "Empty";
}));

(cljs.core.Empty.getBasis = (function cljs$core$fn_15795(){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.Empty.cljs$lang$type = true);

(cljs.core.Empty.cljs$lang$ctorStr = "cljs.core/Empty");

(cljs.core.Empty.cljs$lang$ctorPrWriter = (function cljs$core$fn_15796(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/Empty");
}));

/**
 * Positional factory function for cljs.core/Empty.
 */
cljs.core.__GT_Empty = (function cljs$core$__GT_Empty(){
return (new cljs.core.Empty());
});

cljs.core.EMPTY = (new cljs.core.Empty());

/**
* @constructor
*/
cljs.core.MultiIterator = (function (iters){
this.iters = iters;
});
(cljs.core.MultiIterator.prototype.hasNext = (function cljs$core$fn_15797(){
var self__ = this;
var _ = this;
var iters__$1 = cljs.core.seq(self__.iters);
while(true){
if((!((iters__$1 == null)))){
var iter = cljs.core.first(iters__$1);
if((!(iter.hasNext()))){
return false;
} else {
var G__15801 = cljs.core.next(iters__$1);
iters__$1 = G__15801;
continue;
}
} else {
return true;
}
break;
}
}));

(cljs.core.MultiIterator.prototype.next = (function cljs$core$fn_15798(){
var self__ = this;
var _ = this;
var nexts = [];
var n__10672__auto___15802 = self__.iters.length;
var i_15803 = (0);
while(true){
if((i_15803 < n__10672__auto___15802)){
(nexts[i_15803] = (self__.iters[i_15803]).next());

var G__15804 = (i_15803 + (1));
i_15803 = G__15804;
continue;
} else {
}
break;
}

return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(nexts,(0));
}));

(cljs.core.MultiIterator.getBasis = (function cljs$core$fn_15799(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"iters","iters",719353031,null)], null);
}));

(cljs.core.MultiIterator.cljs$lang$type = true);

(cljs.core.MultiIterator.cljs$lang$ctorStr = "cljs.core/MultiIterator");

(cljs.core.MultiIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_15800(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/MultiIterator");
}));

/**
 * Positional factory function for cljs.core/MultiIterator.
 */
cljs.core.__GT_MultiIterator = (function cljs$core$__GT_MultiIterator(iters){
return (new cljs.core.MultiIterator(iters));
});

cljs.core.chunkIteratorSeq = (function cljs$core$chunkIteratorSeq(iter){
return (new cljs.core.LazySeq(null,(function cljs$core$chunkIteratorSeq_$_fn_15805(){
if(iter.hasNext()){
var arr = [];
var n = (0);
while(true){
if(cljs.core.truth_((function (){var and__9578__auto__ = iter.hasNext();
if(cljs.core.truth_(and__9578__auto__)){
return (n < (32));
} else {
return and__9578__auto__;
}
})())){
(arr[n] = iter.next());

var G__15806 = (n + (1));
n = G__15806;
continue;
} else {
return cljs.core.chunk_cons(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3(arr,(0),n),(cljs.core.chunkIteratorSeq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunkIteratorSeq.cljs$core$IFn$_invoke$arity$1(iter) : cljs.core.chunkIteratorSeq.call(null,iter)));
}
break;
}
} else {
return null;
}
}),null,null));
});

/**
* @constructor
*/
cljs.core.TransformerIterator = (function (buffer,_next,completed,xf,sourceIter,multi){
this.buffer = buffer;
this._next = _next;
this.completed = completed;
this.xf = xf;
this.sourceIter = sourceIter;
this.multi = multi;
});
(cljs.core.TransformerIterator.prototype.step = (function cljs$core$fn_15807(){
var self__ = this;
var this$ = this;
if((!((self__._next === cljs.core.NONE)))){
return true;
} else {
while(true){
if((self__._next === cljs.core.NONE)){
if(self__.buffer.isEmpty()){
if(self__.completed){
return false;
} else {
if(self__.sourceIter.hasNext()){
var iter = ((self__.multi)?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xf,cljs.core.cons(null,self__.sourceIter.next())):(function (){var G__15808 = null;
var G__15809 = self__.sourceIter.next();
return (self__.xf.cljs$core$IFn$_invoke$arity$2 ? self__.xf.cljs$core$IFn$_invoke$arity$2(G__15808,G__15809) : self__.xf.call(null,G__15808,G__15809));
})());
if(cljs.core.reduced_QMARK_(iter)){
(self__.xf.cljs$core$IFn$_invoke$arity$1 ? self__.xf.cljs$core$IFn$_invoke$arity$1(null) : self__.xf.call(null,null));

(self__.completed = true);
} else {
}

continue;
} else {
(self__.xf.cljs$core$IFn$_invoke$arity$1 ? self__.xf.cljs$core$IFn$_invoke$arity$1(null) : self__.xf.call(null,null));

(self__.completed = true);

continue;
}
}
} else {
(self__._next = self__.buffer.remove());

continue;
}
} else {
return true;
}
break;
}
}
}));

(cljs.core.TransformerIterator.prototype.hasNext = (function cljs$core$fn_15810(){
var self__ = this;
var this$ = this;
return this$.step();
}));

(cljs.core.TransformerIterator.prototype.next = (function cljs$core$fn_15811(){
var self__ = this;
var this$ = this;
if(this$.hasNext()){
var ret = self__._next;
(self__._next = cljs.core.NONE);

return ret;
} else {
throw (new Error("No such element"));
}
}));

(cljs.core.TransformerIterator.prototype.remove = (function cljs$core$fn_15812(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.TransformerIterator.getBasis = (function cljs$core$fn_15813(){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"buffer","buffer",-2037140571,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"completed","completed",1154475024,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"xf","xf",2042434515,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"sourceIter","sourceIter",1068220306,null),new cljs.core.Symbol(null,"multi","multi",1450238522,null)], null);
}));

(cljs.core.TransformerIterator.cljs$lang$type = true);

(cljs.core.TransformerIterator.cljs$lang$ctorStr = "cljs.core/TransformerIterator");

(cljs.core.TransformerIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_15814(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/TransformerIterator");
}));

/**
 * Positional factory function for cljs.core/TransformerIterator.
 */
cljs.core.__GT_TransformerIterator = (function cljs$core$__GT_TransformerIterator(buffer,_next,completed,xf,sourceIter,multi){
return (new cljs.core.TransformerIterator(buffer,_next,completed,xf,sourceIter,multi));
});

(cljs.core.TransformerIterator.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15815(){
var this__10774__auto__ = this;
return cljs.core.es6_iterator(this__10774__auto__);
}));
cljs.core.transformer_iterator = (function cljs$core$transformer_iterator(xform,sourceIter,multi){
var iterator = (new cljs.core.TransformerIterator(cljs.core.EMPTY,cljs.core.NONE,false,null,sourceIter,multi));
(iterator.xf = (function (){var G__15816 = (function() {
var cljs$core$transformer_iterator_$_fn_15817 = null;
var cljs$core$transformer_iterator_$_fn_15817__0 = (function (){
return null;
});
var cljs$core$transformer_iterator_$_fn_15817__1 = (function (acc){
return acc;
});
var cljs$core$transformer_iterator_$_fn_15817__2 = (function (acc,o){
(iterator.buffer = iterator.buffer.add(o));

return acc;
});
cljs$core$transformer_iterator_$_fn_15817 = function(acc,o){
switch(arguments.length){
case 0:
return cljs$core$transformer_iterator_$_fn_15817__0.call(this);
case 1:
return cljs$core$transformer_iterator_$_fn_15817__1.call(this,acc);
case 2:
return cljs$core$transformer_iterator_$_fn_15817__2.call(this,acc,o);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$transformer_iterator_$_fn_15817.cljs$core$IFn$_invoke$arity$0 = cljs$core$transformer_iterator_$_fn_15817__0;
cljs$core$transformer_iterator_$_fn_15817.cljs$core$IFn$_invoke$arity$1 = cljs$core$transformer_iterator_$_fn_15817__1;
cljs$core$transformer_iterator_$_fn_15817.cljs$core$IFn$_invoke$arity$2 = cljs$core$transformer_iterator_$_fn_15817__2;
return cljs$core$transformer_iterator_$_fn_15817;
})()
;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__15816) : xform.call(null,G__15816));
})());

return iterator;
});
(cljs.core.TransformerIterator.create = (function cljs$core$fn_15818(xform,source){
return cljs.core.transformer_iterator(xform,source,false);
}));
(cljs.core.TransformerIterator.createMulti = (function cljs$core$fn_15819(xform,sources){
return cljs.core.transformer_iterator(xform,(new cljs.core.MultiIterator(cljs.core.to_array(sources))),true);
}));
/**
 * Coerces coll to a (possibly empty) sequence, if it is not already
 *   one. Will not force a lazy seq. (sequence nil) yields (), When a
 *   transducer is supplied, returns a lazy sequence of applications of
 *   the transform to the items in coll(s), i.e. to the set of first
 *   items of each coll, followed by the set of second
 *   items in each coll, until any one of the colls is exhausted.  Any
 *   remaining items in other colls are ignored. The transform should accept
 *   number-of-colls arguments
 */
cljs.core.sequence = (function cljs$core$sequence(var_args){
var G__15824 = arguments.length;
switch (G__15824) {
case 1:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15830 = arguments.length;
var i__10914__auto___15831 = (0);
while(true){
if((i__10914__auto___15831 < len__10913__auto___15830)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15831]));

var G__15832 = (i__10914__auto___15831 + (1));
i__10914__auto___15831 = G__15832;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15825(coll){
if(cljs.core.seq_QMARK_(coll)){
return coll;
} else {
var or__9584__auto__ = cljs.core.seq(coll);
if(or__9584__auto__){
return or__9584__auto__;
} else {
return cljs.core.List.EMPTY;
}
}
}));

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15826(xform,coll){
var or__9584__auto__ = cljs.core.chunkIteratorSeq(cljs.core.TransformerIterator.create(xform,cljs.core.iter(coll)));
if(cljs.core.truth_(or__9584__auto__)){
return or__9584__auto__;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15827(xform,coll,colls){
var or__9584__auto__ = cljs.core.chunkIteratorSeq(cljs.core.TransformerIterator.createMulti(xform,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.iter,cljs.core.cons(coll,colls))));
if(cljs.core.truth_(or__9584__auto__)){
return or__9584__auto__;
} else {
return cljs.core.List.EMPTY;
}
}));

/** @this {Function} */
(cljs.core.sequence.cljs$lang$applyTo = (function cljs$core$fn_15828(seq15821){
var G__15822 = cljs.core.first(seq15821);
var seq15821__$1 = cljs.core.next(seq15821);
var G__15823 = cljs.core.first(seq15821__$1);
var seq15821__$2 = cljs.core.next(seq15821__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15822,G__15823,seq15821__$2);
}));

(cljs.core.sequence.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if (pred x) is logical true for every x in coll, else
 *   false.
 */
cljs.core.every_QMARK_ = (function cljs$core$every_QMARK_(pred,coll){
while(true){
if((cljs.core.seq(coll) == null)){
return true;
} else {
if(cljs.core.truth_((function (){var G__15833 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__15833) : pred.call(null,G__15833));
})())){
var G__15834 = pred;
var G__15835 = cljs.core.next(coll);
pred = G__15834;
coll = G__15835;
continue;
} else {
return false;

}
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for every x in
 *   coll, else true.
 */
cljs.core.not_every_QMARK_ = (function cljs$core$not_every_QMARK_(pred,coll){
return (!(cljs.core.every_QMARK_(pred,coll)));
});
/**
 * Returns the first logical true value of (pred x) for any x in coll,
 *   else nil.  One common idiom is to use a set as pred, for example
 *   this will return :fred if :fred is in the sequence, otherwise nil:
 *   (some #{:fred} coll)
 */
cljs.core.some = (function cljs$core$some(pred,coll){
while(true){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
var or__9584__auto__ = (function (){var G__15836 = cljs.core.first(s);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__15836) : pred.call(null,G__15836));
})();
if(cljs.core.truth_(or__9584__auto__)){
return or__9584__auto__;
} else {
var G__15837 = pred;
var G__15838 = cljs.core.next(s);
pred = G__15837;
coll = G__15838;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for any x in coll,
 *   else true.
 */
cljs.core.not_any_QMARK_ = (function cljs$core$not_any_QMARK_(pred,coll){
return cljs.core.not(cljs.core.some(pred,coll));
});
/**
 * Returns true if n is even, throws an exception if n is not an integer
 */
cljs.core.even_QMARK_ = (function cljs$core$even_QMARK_(n){
if(cljs.core.integer_QMARK_(n)){
return ((n & (1)) === (0));
} else {
throw (new Error(["Argument must be an integer: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)].join('')));
}
});
/**
 * Returns true if n is odd, throws an exception if n is not an integer
 */
cljs.core.odd_QMARK_ = (function cljs$core$odd_QMARK_(n){
return (!(cljs.core.even_QMARK_(n)));
});
/**
 * Takes a fn f and returns a fn that takes the same arguments as f,
 *   has the same effects, if any, and returns the opposite truth value.
 */
cljs.core.complement = (function cljs$core$complement(f){
return (function() {
var cljs$core$complement_$_fn_15839 = null;
var cljs$core$complement_$_fn_15839__0 = (function (){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});
var cljs$core$complement_$_fn_15839__1 = (function (x){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)));
});
var cljs$core$complement_$_fn_15839__2 = (function (x,y){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y)));
});
var cljs$core$complement_$_fn_15839__3 = (function() { 
var G__15840__delegate = function (x,y,zs){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,x,y,zs));
};
var G__15840 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__15841__i = 0, G__15841__a = new Array(arguments.length -  2);
while (G__15841__i < G__15841__a.length) {G__15841__a[G__15841__i] = arguments[G__15841__i + 2]; ++G__15841__i;}
  zs = new cljs.core.IndexedSeq(G__15841__a,0,null);
} 
return G__15840__delegate.call(this,x,y,zs);};
G__15840.cljs$lang$maxFixedArity = 2;
G__15840.cljs$lang$applyTo = (function (arglist__15842){
var x = cljs.core.first(arglist__15842);
arglist__15842 = cljs.core.next(arglist__15842);
var y = cljs.core.first(arglist__15842);
var zs = cljs.core.rest(arglist__15842);
return G__15840__delegate(x,y,zs);
});
G__15840.cljs$core$IFn$_invoke$arity$variadic = G__15840__delegate;
return G__15840;
})()
;
cljs$core$complement_$_fn_15839 = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return cljs$core$complement_$_fn_15839__0.call(this);
case 1:
return cljs$core$complement_$_fn_15839__1.call(this,x);
case 2:
return cljs$core$complement_$_fn_15839__2.call(this,x,y);
default:
var G__15843 = null;
if (arguments.length > 2) {
var G__15844__i = 0, G__15844__a = new Array(arguments.length -  2);
while (G__15844__i < G__15844__a.length) {G__15844__a[G__15844__i] = arguments[G__15844__i + 2]; ++G__15844__i;}
G__15843 = new cljs.core.IndexedSeq(G__15844__a,0,null);
}
return cljs$core$complement_$_fn_15839__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__15843);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$complement_$_fn_15839.cljs$lang$maxFixedArity = 2;
cljs$core$complement_$_fn_15839.cljs$lang$applyTo = cljs$core$complement_$_fn_15839__3.cljs$lang$applyTo;
cljs$core$complement_$_fn_15839.cljs$core$IFn$_invoke$arity$0 = cljs$core$complement_$_fn_15839__0;
cljs$core$complement_$_fn_15839.cljs$core$IFn$_invoke$arity$1 = cljs$core$complement_$_fn_15839__1;
cljs$core$complement_$_fn_15839.cljs$core$IFn$_invoke$arity$2 = cljs$core$complement_$_fn_15839__2;
cljs$core$complement_$_fn_15839.cljs$core$IFn$_invoke$arity$variadic = cljs$core$complement_$_fn_15839__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$complement_$_fn_15839;
})()
});
/**
 * Returns a function that takes any number of arguments and returns x.
 */
cljs.core.constantly = (function cljs$core$constantly(x){
return (function() { 
var cljs$core$constantly_$_fn_15845__delegate = function (args){
return x;
};
var cljs$core$constantly_$_fn_15845 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__15846__i = 0, G__15846__a = new Array(arguments.length -  0);
while (G__15846__i < G__15846__a.length) {G__15846__a[G__15846__i] = arguments[G__15846__i + 0]; ++G__15846__i;}
  args = new cljs.core.IndexedSeq(G__15846__a,0,null);
} 
return cljs$core$constantly_$_fn_15845__delegate.call(this,args);};
cljs$core$constantly_$_fn_15845.cljs$lang$maxFixedArity = 0;
cljs$core$constantly_$_fn_15845.cljs$lang$applyTo = (function (arglist__15847){
var args = cljs.core.seq(arglist__15847);
return cljs$core$constantly_$_fn_15845__delegate(args);
});
cljs$core$constantly_$_fn_15845.cljs$core$IFn$_invoke$arity$variadic = cljs$core$constantly_$_fn_15845__delegate;
return cljs$core$constantly_$_fn_15845;
})()
;
});
/**
 * Takes a set of functions and returns a fn that is the composition
 *   of those fns.  The returned fn takes a variable number of args,
 *   applies the rightmost of fns to the args, the next
 *   fn (right-to-left) to the result, etc.
 */
cljs.core.comp = (function cljs$core$comp(var_args){
var G__15853 = arguments.length;
switch (G__15853) {
case 0:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15880 = arguments.length;
var i__10914__auto___15881 = (0);
while(true){
if((i__10914__auto___15881 < len__10913__auto___15880)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15881]));

var G__15882 = (i__10914__auto___15881 + (1));
i__10914__auto___15881 = G__15882;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((3) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((3)),(0),null)):null);
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10943__auto__);

}
});

(cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15854(){
return cljs.core.identity;
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15855(f){
return f;
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15856(f,g){
return (function() {
var cljs$core$fn_15856_$_fn_15857 = null;
var cljs$core$fn_15856_$_fn_15857__0 = (function (){
var G__15858 = (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15858) : f.call(null,G__15858));
});
var cljs$core$fn_15856_$_fn_15857__1 = (function (x){
var G__15859 = (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null,x));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15859) : f.call(null,G__15859));
});
var cljs$core$fn_15856_$_fn_15857__2 = (function (x,y){
var G__15860 = (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x,y) : g.call(null,x,y));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15860) : f.call(null,G__15860));
});
var cljs$core$fn_15856_$_fn_15857__3 = (function (x,y,z){
var G__15861 = (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x,y,z) : g.call(null,x,y,z));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15861) : f.call(null,G__15861));
});
var cljs$core$fn_15856_$_fn_15857__4 = (function() { 
var G__15883__delegate = function (x,y,z,args){
var G__15862 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15862) : f.call(null,G__15862));
};
var G__15883 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__15884__i = 0, G__15884__a = new Array(arguments.length -  3);
while (G__15884__i < G__15884__a.length) {G__15884__a[G__15884__i] = arguments[G__15884__i + 3]; ++G__15884__i;}
  args = new cljs.core.IndexedSeq(G__15884__a,0,null);
} 
return G__15883__delegate.call(this,x,y,z,args);};
G__15883.cljs$lang$maxFixedArity = 3;
G__15883.cljs$lang$applyTo = (function (arglist__15885){
var x = cljs.core.first(arglist__15885);
arglist__15885 = cljs.core.next(arglist__15885);
var y = cljs.core.first(arglist__15885);
arglist__15885 = cljs.core.next(arglist__15885);
var z = cljs.core.first(arglist__15885);
var args = cljs.core.rest(arglist__15885);
return G__15883__delegate(x,y,z,args);
});
G__15883.cljs$core$IFn$_invoke$arity$variadic = G__15883__delegate;
return G__15883;
})()
;
cljs$core$fn_15856_$_fn_15857 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_15856_$_fn_15857__0.call(this);
case 1:
return cljs$core$fn_15856_$_fn_15857__1.call(this,x);
case 2:
return cljs$core$fn_15856_$_fn_15857__2.call(this,x,y);
case 3:
return cljs$core$fn_15856_$_fn_15857__3.call(this,x,y,z);
default:
var G__15886 = null;
if (arguments.length > 3) {
var G__15887__i = 0, G__15887__a = new Array(arguments.length -  3);
while (G__15887__i < G__15887__a.length) {G__15887__a[G__15887__i] = arguments[G__15887__i + 3]; ++G__15887__i;}
G__15886 = new cljs.core.IndexedSeq(G__15887__a,0,null);
}
return cljs$core$fn_15856_$_fn_15857__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__15886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15856_$_fn_15857.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15856_$_fn_15857.cljs$lang$applyTo = cljs$core$fn_15856_$_fn_15857__4.cljs$lang$applyTo;
cljs$core$fn_15856_$_fn_15857.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15856_$_fn_15857__0;
cljs$core$fn_15856_$_fn_15857.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15856_$_fn_15857__1;
cljs$core$fn_15856_$_fn_15857.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15856_$_fn_15857__2;
cljs$core$fn_15856_$_fn_15857.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15856_$_fn_15857__3;
cljs$core$fn_15856_$_fn_15857.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15856_$_fn_15857__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15856_$_fn_15857;
})()
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15863(f,g,h){
return (function() {
var cljs$core$fn_15863_$_fn_15864 = null;
var cljs$core$fn_15863_$_fn_15864__0 = (function (){
var G__15865 = (function (){var G__15866 = (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15866) : g.call(null,G__15866));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15865) : f.call(null,G__15865));
});
var cljs$core$fn_15863_$_fn_15864__1 = (function (x){
var G__15867 = (function (){var G__15868 = (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(x) : h.call(null,x));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15868) : g.call(null,G__15868));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15867) : f.call(null,G__15867));
});
var cljs$core$fn_15863_$_fn_15864__2 = (function (x,y){
var G__15869 = (function (){var G__15870 = (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(x,y) : h.call(null,x,y));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15870) : g.call(null,G__15870));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15869) : f.call(null,G__15869));
});
var cljs$core$fn_15863_$_fn_15864__3 = (function (x,y,z){
var G__15871 = (function (){var G__15872 = (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(x,y,z) : h.call(null,x,y,z));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15872) : g.call(null,G__15872));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15871) : f.call(null,G__15871));
});
var cljs$core$fn_15863_$_fn_15864__4 = (function() { 
var G__15888__delegate = function (x,y,z,args){
var G__15873 = (function (){var G__15874 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args);
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15874) : g.call(null,G__15874));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15873) : f.call(null,G__15873));
};
var G__15888 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__15889__i = 0, G__15889__a = new Array(arguments.length -  3);
while (G__15889__i < G__15889__a.length) {G__15889__a[G__15889__i] = arguments[G__15889__i + 3]; ++G__15889__i;}
  args = new cljs.core.IndexedSeq(G__15889__a,0,null);
} 
return G__15888__delegate.call(this,x,y,z,args);};
G__15888.cljs$lang$maxFixedArity = 3;
G__15888.cljs$lang$applyTo = (function (arglist__15890){
var x = cljs.core.first(arglist__15890);
arglist__15890 = cljs.core.next(arglist__15890);
var y = cljs.core.first(arglist__15890);
arglist__15890 = cljs.core.next(arglist__15890);
var z = cljs.core.first(arglist__15890);
var args = cljs.core.rest(arglist__15890);
return G__15888__delegate(x,y,z,args);
});
G__15888.cljs$core$IFn$_invoke$arity$variadic = G__15888__delegate;
return G__15888;
})()
;
cljs$core$fn_15863_$_fn_15864 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_15863_$_fn_15864__0.call(this);
case 1:
return cljs$core$fn_15863_$_fn_15864__1.call(this,x);
case 2:
return cljs$core$fn_15863_$_fn_15864__2.call(this,x,y);
case 3:
return cljs$core$fn_15863_$_fn_15864__3.call(this,x,y,z);
default:
var G__15891 = null;
if (arguments.length > 3) {
var G__15892__i = 0, G__15892__a = new Array(arguments.length -  3);
while (G__15892__i < G__15892__a.length) {G__15892__a[G__15892__i] = arguments[G__15892__i + 3]; ++G__15892__i;}
G__15891 = new cljs.core.IndexedSeq(G__15892__a,0,null);
}
return cljs$core$fn_15863_$_fn_15864__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__15891);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15863_$_fn_15864.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15863_$_fn_15864.cljs$lang$applyTo = cljs$core$fn_15863_$_fn_15864__4.cljs$lang$applyTo;
cljs$core$fn_15863_$_fn_15864.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15863_$_fn_15864__0;
cljs$core$fn_15863_$_fn_15864.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15863_$_fn_15864__1;
cljs$core$fn_15863_$_fn_15864.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15863_$_fn_15864__2;
cljs$core$fn_15863_$_fn_15864.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15863_$_fn_15864__3;
cljs$core$fn_15863_$_fn_15864.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15863_$_fn_15864__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15863_$_fn_15864;
})()
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15875(f1,f2,f3,fs){
var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1,f2,f3,fs));
return (function() { 
var cljs$core$fn_15875_$_fn_15876__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1),args);
var fs__$2 = cljs.core.next(fs__$1);
while(true){
if(fs__$2){
var G__15893 = (function (){var fexpr__15877 = cljs.core.first(fs__$2);
return (fexpr__15877.cljs$core$IFn$_invoke$arity$1 ? fexpr__15877.cljs$core$IFn$_invoke$arity$1(ret) : fexpr__15877.call(null,ret));
})();
var G__15894 = cljs.core.next(fs__$2);
ret = G__15893;
fs__$2 = G__15894;
continue;
} else {
return ret;
}
break;
}
};
var cljs$core$fn_15875_$_fn_15876 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__15895__i = 0, G__15895__a = new Array(arguments.length -  0);
while (G__15895__i < G__15895__a.length) {G__15895__a[G__15895__i] = arguments[G__15895__i + 0]; ++G__15895__i;}
  args = new cljs.core.IndexedSeq(G__15895__a,0,null);
} 
return cljs$core$fn_15875_$_fn_15876__delegate.call(this,args);};
cljs$core$fn_15875_$_fn_15876.cljs$lang$maxFixedArity = 0;
cljs$core$fn_15875_$_fn_15876.cljs$lang$applyTo = (function (arglist__15896){
var args = cljs.core.seq(arglist__15896);
return cljs$core$fn_15875_$_fn_15876__delegate(args);
});
cljs$core$fn_15875_$_fn_15876.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15875_$_fn_15876__delegate;
return cljs$core$fn_15875_$_fn_15876;
})()
;
}));

/** @this {Function} */
(cljs.core.comp.cljs$lang$applyTo = (function cljs$core$fn_15878(seq15849){
var G__15850 = cljs.core.first(seq15849);
var seq15849__$1 = cljs.core.next(seq15849);
var G__15851 = cljs.core.first(seq15849__$1);
var seq15849__$2 = cljs.core.next(seq15849__$1);
var G__15852 = cljs.core.first(seq15849__$2);
var seq15849__$3 = cljs.core.next(seq15849__$2);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15850,G__15851,G__15852,seq15849__$3);
}));

(cljs.core.comp.cljs$lang$maxFixedArity = (3));

/**
 * Takes a function f and fewer than the normal arguments to f, and
 *   returns a fn that takes a variable number of additional args. When
 *   called, the returned function calls f with args + additional args.
 */
cljs.core.partial = (function cljs$core$partial(var_args){
var G__15903 = arguments.length;
switch (G__15903) {
case 1:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___15915 = arguments.length;
var i__10914__auto___15916 = (0);
while(true){
if((i__10914__auto___15916 < len__10913__auto___15915)){
args_arr__10942__auto__.push((arguments[i__10914__auto___15916]));

var G__15917 = (i__10914__auto___15916 + (1));
i__10914__auto___15916 = G__15917;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((4) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((4)),(0),null)):null);
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10943__auto__);

}
});

(cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15904(f){
return f;
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15905(f,arg1){
return (function() {
var cljs$core$fn_15905_$_fn_15906 = null;
var cljs$core$fn_15905_$_fn_15906__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(arg1) : f.call(null,arg1));
});
var cljs$core$fn_15905_$_fn_15906__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,x) : f.call(null,arg1,x));
});
var cljs$core$fn_15905_$_fn_15906__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,x,y) : f.call(null,arg1,x,y));
});
var cljs$core$fn_15905_$_fn_15906__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,x,y,z) : f.call(null,arg1,x,y,z));
});
var cljs$core$fn_15905_$_fn_15906__4 = (function() { 
var G__15918__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,x,y,z,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
};
var G__15918 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__15919__i = 0, G__15919__a = new Array(arguments.length -  3);
while (G__15919__i < G__15919__a.length) {G__15919__a[G__15919__i] = arguments[G__15919__i + 3]; ++G__15919__i;}
  args = new cljs.core.IndexedSeq(G__15919__a,0,null);
} 
return G__15918__delegate.call(this,x,y,z,args);};
G__15918.cljs$lang$maxFixedArity = 3;
G__15918.cljs$lang$applyTo = (function (arglist__15920){
var x = cljs.core.first(arglist__15920);
arglist__15920 = cljs.core.next(arglist__15920);
var y = cljs.core.first(arglist__15920);
arglist__15920 = cljs.core.next(arglist__15920);
var z = cljs.core.first(arglist__15920);
var args = cljs.core.rest(arglist__15920);
return G__15918__delegate(x,y,z,args);
});
G__15918.cljs$core$IFn$_invoke$arity$variadic = G__15918__delegate;
return G__15918;
})()
;
cljs$core$fn_15905_$_fn_15906 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_15905_$_fn_15906__0.call(this);
case 1:
return cljs$core$fn_15905_$_fn_15906__1.call(this,x);
case 2:
return cljs$core$fn_15905_$_fn_15906__2.call(this,x,y);
case 3:
return cljs$core$fn_15905_$_fn_15906__3.call(this,x,y,z);
default:
var G__15921 = null;
if (arguments.length > 3) {
var G__15922__i = 0, G__15922__a = new Array(arguments.length -  3);
while (G__15922__i < G__15922__a.length) {G__15922__a[G__15922__i] = arguments[G__15922__i + 3]; ++G__15922__i;}
G__15921 = new cljs.core.IndexedSeq(G__15922__a,0,null);
}
return cljs$core$fn_15905_$_fn_15906__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__15921);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15905_$_fn_15906.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15905_$_fn_15906.cljs$lang$applyTo = cljs$core$fn_15905_$_fn_15906__4.cljs$lang$applyTo;
cljs$core$fn_15905_$_fn_15906.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15905_$_fn_15906__0;
cljs$core$fn_15905_$_fn_15906.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15905_$_fn_15906__1;
cljs$core$fn_15905_$_fn_15906.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15905_$_fn_15906__2;
cljs$core$fn_15905_$_fn_15906.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15905_$_fn_15906__3;
cljs$core$fn_15905_$_fn_15906.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15905_$_fn_15906__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15905_$_fn_15906;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15907(f,arg1,arg2){
return (function() {
var cljs$core$fn_15907_$_fn_15908 = null;
var cljs$core$fn_15907_$_fn_15908__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,arg2) : f.call(null,arg1,arg2));
});
var cljs$core$fn_15907_$_fn_15908__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,x) : f.call(null,arg1,arg2,x));
});
var cljs$core$fn_15907_$_fn_15908__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,x,y) : f.call(null,arg1,arg2,x,y));
});
var cljs$core$fn_15907_$_fn_15908__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,x,y,z) : f.call(null,arg1,arg2,x,y,z));
});
var cljs$core$fn_15907_$_fn_15908__4 = (function() { 
var G__15923__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,x,y,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([z,args], 0));
};
var G__15923 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__15924__i = 0, G__15924__a = new Array(arguments.length -  3);
while (G__15924__i < G__15924__a.length) {G__15924__a[G__15924__i] = arguments[G__15924__i + 3]; ++G__15924__i;}
  args = new cljs.core.IndexedSeq(G__15924__a,0,null);
} 
return G__15923__delegate.call(this,x,y,z,args);};
G__15923.cljs$lang$maxFixedArity = 3;
G__15923.cljs$lang$applyTo = (function (arglist__15925){
var x = cljs.core.first(arglist__15925);
arglist__15925 = cljs.core.next(arglist__15925);
var y = cljs.core.first(arglist__15925);
arglist__15925 = cljs.core.next(arglist__15925);
var z = cljs.core.first(arglist__15925);
var args = cljs.core.rest(arglist__15925);
return G__15923__delegate(x,y,z,args);
});
G__15923.cljs$core$IFn$_invoke$arity$variadic = G__15923__delegate;
return G__15923;
})()
;
cljs$core$fn_15907_$_fn_15908 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_15907_$_fn_15908__0.call(this);
case 1:
return cljs$core$fn_15907_$_fn_15908__1.call(this,x);
case 2:
return cljs$core$fn_15907_$_fn_15908__2.call(this,x,y);
case 3:
return cljs$core$fn_15907_$_fn_15908__3.call(this,x,y,z);
default:
var G__15926 = null;
if (arguments.length > 3) {
var G__15927__i = 0, G__15927__a = new Array(arguments.length -  3);
while (G__15927__i < G__15927__a.length) {G__15927__a[G__15927__i] = arguments[G__15927__i + 3]; ++G__15927__i;}
G__15926 = new cljs.core.IndexedSeq(G__15927__a,0,null);
}
return cljs$core$fn_15907_$_fn_15908__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__15926);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15907_$_fn_15908.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15907_$_fn_15908.cljs$lang$applyTo = cljs$core$fn_15907_$_fn_15908__4.cljs$lang$applyTo;
cljs$core$fn_15907_$_fn_15908.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15907_$_fn_15908__0;
cljs$core$fn_15907_$_fn_15908.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15907_$_fn_15908__1;
cljs$core$fn_15907_$_fn_15908.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15907_$_fn_15908__2;
cljs$core$fn_15907_$_fn_15908.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15907_$_fn_15908__3;
cljs$core$fn_15907_$_fn_15908.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15907_$_fn_15908__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15907_$_fn_15908;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15909(f,arg1,arg2,arg3){
return (function() {
var cljs$core$fn_15909_$_fn_15910 = null;
var cljs$core$fn_15909_$_fn_15910__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,arg3) : f.call(null,arg1,arg2,arg3));
});
var cljs$core$fn_15909_$_fn_15910__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,arg3,x) : f.call(null,arg1,arg2,arg3,x));
});
var cljs$core$fn_15909_$_fn_15910__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,arg3,x,y) : f.call(null,arg1,arg2,arg3,x,y));
});
var cljs$core$fn_15909_$_fn_15910__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(arg1,arg2,arg3,x,y,z) : f.call(null,arg1,arg2,arg3,x,y,z));
});
var cljs$core$fn_15909_$_fn_15910__4 = (function() { 
var G__15928__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3,x,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([y,z,args], 0));
};
var G__15928 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__15929__i = 0, G__15929__a = new Array(arguments.length -  3);
while (G__15929__i < G__15929__a.length) {G__15929__a[G__15929__i] = arguments[G__15929__i + 3]; ++G__15929__i;}
  args = new cljs.core.IndexedSeq(G__15929__a,0,null);
} 
return G__15928__delegate.call(this,x,y,z,args);};
G__15928.cljs$lang$maxFixedArity = 3;
G__15928.cljs$lang$applyTo = (function (arglist__15930){
var x = cljs.core.first(arglist__15930);
arglist__15930 = cljs.core.next(arglist__15930);
var y = cljs.core.first(arglist__15930);
arglist__15930 = cljs.core.next(arglist__15930);
var z = cljs.core.first(arglist__15930);
var args = cljs.core.rest(arglist__15930);
return G__15928__delegate(x,y,z,args);
});
G__15928.cljs$core$IFn$_invoke$arity$variadic = G__15928__delegate;
return G__15928;
})()
;
cljs$core$fn_15909_$_fn_15910 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_15909_$_fn_15910__0.call(this);
case 1:
return cljs$core$fn_15909_$_fn_15910__1.call(this,x);
case 2:
return cljs$core$fn_15909_$_fn_15910__2.call(this,x,y);
case 3:
return cljs$core$fn_15909_$_fn_15910__3.call(this,x,y,z);
default:
var G__15931 = null;
if (arguments.length > 3) {
var G__15932__i = 0, G__15932__a = new Array(arguments.length -  3);
while (G__15932__i < G__15932__a.length) {G__15932__a[G__15932__i] = arguments[G__15932__i + 3]; ++G__15932__i;}
G__15931 = new cljs.core.IndexedSeq(G__15932__a,0,null);
}
return cljs$core$fn_15909_$_fn_15910__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__15931);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15909_$_fn_15910.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15909_$_fn_15910.cljs$lang$applyTo = cljs$core$fn_15909_$_fn_15910__4.cljs$lang$applyTo;
cljs$core$fn_15909_$_fn_15910.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15909_$_fn_15910__0;
cljs$core$fn_15909_$_fn_15910.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15909_$_fn_15910__1;
cljs$core$fn_15909_$_fn_15910.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15909_$_fn_15910__2;
cljs$core$fn_15909_$_fn_15910.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15909_$_fn_15910__3;
cljs$core$fn_15909_$_fn_15910.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15909_$_fn_15910__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15909_$_fn_15910;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15911(f,arg1,arg2,arg3,more){
return (function() { 
var cljs$core$fn_15911_$_fn_15912__delegate = function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,arg1,arg2,arg3,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more,args));
};
var cljs$core$fn_15911_$_fn_15912 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__15933__i = 0, G__15933__a = new Array(arguments.length -  0);
while (G__15933__i < G__15933__a.length) {G__15933__a[G__15933__i] = arguments[G__15933__i + 0]; ++G__15933__i;}
  args = new cljs.core.IndexedSeq(G__15933__a,0,null);
} 
return cljs$core$fn_15911_$_fn_15912__delegate.call(this,args);};
cljs$core$fn_15911_$_fn_15912.cljs$lang$maxFixedArity = 0;
cljs$core$fn_15911_$_fn_15912.cljs$lang$applyTo = (function (arglist__15934){
var args = cljs.core.seq(arglist__15934);
return cljs$core$fn_15911_$_fn_15912__delegate(args);
});
cljs$core$fn_15911_$_fn_15912.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15911_$_fn_15912__delegate;
return cljs$core$fn_15911_$_fn_15912;
})()
;
}));

/** @this {Function} */
(cljs.core.partial.cljs$lang$applyTo = (function cljs$core$fn_15913(seq15898){
var G__15899 = cljs.core.first(seq15898);
var seq15898__$1 = cljs.core.next(seq15898);
var G__15900 = cljs.core.first(seq15898__$1);
var seq15898__$2 = cljs.core.next(seq15898__$1);
var G__15901 = cljs.core.first(seq15898__$2);
var seq15898__$3 = cljs.core.next(seq15898__$2);
var G__15902 = cljs.core.first(seq15898__$3);
var seq15898__$4 = cljs.core.next(seq15898__$3);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15899,G__15900,G__15901,G__15902,seq15898__$4);
}));

(cljs.core.partial.cljs$lang$maxFixedArity = (4));

/**
 * Takes a function f, and returns a function that calls f, replacing
 *   a nil first argument to f with the supplied value x. Higher arity
 *   versions can replace arguments in the second and third
 *   positions (y, z). Note that the function f can take any number of
 *   arguments, not just the one(s) being nil-patched.
 */
cljs.core.fnil = (function cljs$core$fnil(var_args){
var G__15936 = arguments.length;
switch (G__15936) {
case 2:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15937(f,x){
return (function() {
var cljs$core$fn_15937_$_fn_15938 = null;
var cljs$core$fn_15937_$_fn_15938__1 = (function (a){
var G__15939 = (((a == null))?x:a);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15939) : f.call(null,G__15939));
});
var cljs$core$fn_15937_$_fn_15938__2 = (function (a,b){
var G__15940 = (((a == null))?x:a);
var G__15941 = b;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15940,G__15941) : f.call(null,G__15940,G__15941));
});
var cljs$core$fn_15937_$_fn_15938__3 = (function (a,b,c){
var G__15942 = (((a == null))?x:a);
var G__15943 = b;
var G__15944 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15942,G__15943,G__15944) : f.call(null,G__15942,G__15943,G__15944));
});
var cljs$core$fn_15937_$_fn_15938__4 = (function() { 
var G__15960__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),b,c,ds);
};
var G__15960 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__15961__i = 0, G__15961__a = new Array(arguments.length -  3);
while (G__15961__i < G__15961__a.length) {G__15961__a[G__15961__i] = arguments[G__15961__i + 3]; ++G__15961__i;}
  ds = new cljs.core.IndexedSeq(G__15961__a,0,null);
} 
return G__15960__delegate.call(this,a,b,c,ds);};
G__15960.cljs$lang$maxFixedArity = 3;
G__15960.cljs$lang$applyTo = (function (arglist__15962){
var a = cljs.core.first(arglist__15962);
arglist__15962 = cljs.core.next(arglist__15962);
var b = cljs.core.first(arglist__15962);
arglist__15962 = cljs.core.next(arglist__15962);
var c = cljs.core.first(arglist__15962);
var ds = cljs.core.rest(arglist__15962);
return G__15960__delegate(a,b,c,ds);
});
G__15960.cljs$core$IFn$_invoke$arity$variadic = G__15960__delegate;
return G__15960;
})()
;
cljs$core$fn_15937_$_fn_15938 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 1:
return cljs$core$fn_15937_$_fn_15938__1.call(this,a);
case 2:
return cljs$core$fn_15937_$_fn_15938__2.call(this,a,b);
case 3:
return cljs$core$fn_15937_$_fn_15938__3.call(this,a,b,c);
default:
var G__15963 = null;
if (arguments.length > 3) {
var G__15964__i = 0, G__15964__a = new Array(arguments.length -  3);
while (G__15964__i < G__15964__a.length) {G__15964__a[G__15964__i] = arguments[G__15964__i + 3]; ++G__15964__i;}
G__15963 = new cljs.core.IndexedSeq(G__15964__a,0,null);
}
return cljs$core$fn_15937_$_fn_15938__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__15963);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15937_$_fn_15938.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15937_$_fn_15938.cljs$lang$applyTo = cljs$core$fn_15937_$_fn_15938__4.cljs$lang$applyTo;
cljs$core$fn_15937_$_fn_15938.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15937_$_fn_15938__1;
cljs$core$fn_15937_$_fn_15938.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15937_$_fn_15938__2;
cljs$core$fn_15937_$_fn_15938.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15937_$_fn_15938__3;
cljs$core$fn_15937_$_fn_15938.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15937_$_fn_15938__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15937_$_fn_15938;
})()
}));

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15945(f,x,y){
return (function() {
var cljs$core$fn_15945_$_fn_15946 = null;
var cljs$core$fn_15945_$_fn_15946__2 = (function (a,b){
var G__15947 = (((a == null))?x:a);
var G__15948 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15947,G__15948) : f.call(null,G__15947,G__15948));
});
var cljs$core$fn_15945_$_fn_15946__3 = (function (a,b,c){
var G__15949 = (((a == null))?x:a);
var G__15950 = (((b == null))?y:b);
var G__15951 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15949,G__15950,G__15951) : f.call(null,G__15949,G__15950,G__15951));
});
var cljs$core$fn_15945_$_fn_15946__4 = (function() { 
var G__15965__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),c,ds);
};
var G__15965 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__15966__i = 0, G__15966__a = new Array(arguments.length -  3);
while (G__15966__i < G__15966__a.length) {G__15966__a[G__15966__i] = arguments[G__15966__i + 3]; ++G__15966__i;}
  ds = new cljs.core.IndexedSeq(G__15966__a,0,null);
} 
return G__15965__delegate.call(this,a,b,c,ds);};
G__15965.cljs$lang$maxFixedArity = 3;
G__15965.cljs$lang$applyTo = (function (arglist__15967){
var a = cljs.core.first(arglist__15967);
arglist__15967 = cljs.core.next(arglist__15967);
var b = cljs.core.first(arglist__15967);
arglist__15967 = cljs.core.next(arglist__15967);
var c = cljs.core.first(arglist__15967);
var ds = cljs.core.rest(arglist__15967);
return G__15965__delegate(a,b,c,ds);
});
G__15965.cljs$core$IFn$_invoke$arity$variadic = G__15965__delegate;
return G__15965;
})()
;
cljs$core$fn_15945_$_fn_15946 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return cljs$core$fn_15945_$_fn_15946__2.call(this,a,b);
case 3:
return cljs$core$fn_15945_$_fn_15946__3.call(this,a,b,c);
default:
var G__15968 = null;
if (arguments.length > 3) {
var G__15969__i = 0, G__15969__a = new Array(arguments.length -  3);
while (G__15969__i < G__15969__a.length) {G__15969__a[G__15969__i] = arguments[G__15969__i + 3]; ++G__15969__i;}
G__15968 = new cljs.core.IndexedSeq(G__15969__a,0,null);
}
return cljs$core$fn_15945_$_fn_15946__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__15968);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15945_$_fn_15946.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15945_$_fn_15946.cljs$lang$applyTo = cljs$core$fn_15945_$_fn_15946__4.cljs$lang$applyTo;
cljs$core$fn_15945_$_fn_15946.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15945_$_fn_15946__2;
cljs$core$fn_15945_$_fn_15946.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15945_$_fn_15946__3;
cljs$core$fn_15945_$_fn_15946.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15945_$_fn_15946__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15945_$_fn_15946;
})()
}));

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15952(f,x,y,z){
return (function() {
var cljs$core$fn_15952_$_fn_15953 = null;
var cljs$core$fn_15952_$_fn_15953__2 = (function (a,b){
var G__15954 = (((a == null))?x:a);
var G__15955 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15954,G__15955) : f.call(null,G__15954,G__15955));
});
var cljs$core$fn_15952_$_fn_15953__3 = (function (a,b,c){
var G__15956 = (((a == null))?x:a);
var G__15957 = (((b == null))?y:b);
var G__15958 = (((c == null))?z:c);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15956,G__15957,G__15958) : f.call(null,G__15956,G__15957,G__15958));
});
var cljs$core$fn_15952_$_fn_15953__4 = (function() { 
var G__15970__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c),ds);
};
var G__15970 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__15971__i = 0, G__15971__a = new Array(arguments.length -  3);
while (G__15971__i < G__15971__a.length) {G__15971__a[G__15971__i] = arguments[G__15971__i + 3]; ++G__15971__i;}
  ds = new cljs.core.IndexedSeq(G__15971__a,0,null);
} 
return G__15970__delegate.call(this,a,b,c,ds);};
G__15970.cljs$lang$maxFixedArity = 3;
G__15970.cljs$lang$applyTo = (function (arglist__15972){
var a = cljs.core.first(arglist__15972);
arglist__15972 = cljs.core.next(arglist__15972);
var b = cljs.core.first(arglist__15972);
arglist__15972 = cljs.core.next(arglist__15972);
var c = cljs.core.first(arglist__15972);
var ds = cljs.core.rest(arglist__15972);
return G__15970__delegate(a,b,c,ds);
});
G__15970.cljs$core$IFn$_invoke$arity$variadic = G__15970__delegate;
return G__15970;
})()
;
cljs$core$fn_15952_$_fn_15953 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return cljs$core$fn_15952_$_fn_15953__2.call(this,a,b);
case 3:
return cljs$core$fn_15952_$_fn_15953__3.call(this,a,b,c);
default:
var G__15973 = null;
if (arguments.length > 3) {
var G__15974__i = 0, G__15974__a = new Array(arguments.length -  3);
while (G__15974__i < G__15974__a.length) {G__15974__a[G__15974__i] = arguments[G__15974__i + 3]; ++G__15974__i;}
G__15973 = new cljs.core.IndexedSeq(G__15974__a,0,null);
}
return cljs$core$fn_15952_$_fn_15953__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__15973);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15952_$_fn_15953.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15952_$_fn_15953.cljs$lang$applyTo = cljs$core$fn_15952_$_fn_15953__4.cljs$lang$applyTo;
cljs$core$fn_15952_$_fn_15953.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15952_$_fn_15953__2;
cljs$core$fn_15952_$_fn_15953.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15952_$_fn_15953__3;
cljs$core$fn_15952_$_fn_15953.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15952_$_fn_15953__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15952_$_fn_15953;
})()
}));

(cljs.core.fnil.cljs$lang$maxFixedArity = 4);

/**
 * Returns a lazy sequence consisting of the result of applying f to 0
 *   and the first item of coll, followed by applying f to 1 and the second
 *   item in coll, etc, until coll is exhausted. Thus function f should
 *   accept 2 arguments, index and item. Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.map_indexed = (function cljs$core$map_indexed(var_args){
var G__15976 = arguments.length;
switch (G__15976) {
case 1:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15977(f){
return (function cljs$core$fn_15977_$_fn_15978(rf){
var i = cljs.core.volatile_BANG_((-1));
return (function() {
var cljs$core$fn_15977_$_fn_15978_$_fn_15979 = null;
var cljs$core$fn_15977_$_fn_15978_$_fn_15979__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_15977_$_fn_15978_$_fn_15979__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_15977_$_fn_15978_$_fn_15979__2 = (function (result,input){
var G__15980 = result;
var G__15981 = (function (){var G__15982 = i.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(i.cljs$core$IDeref$_deref$arity$1(null) + (1)));
var G__15983 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15982,G__15983) : f.call(null,G__15982,G__15983));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__15980,G__15981) : rf.call(null,G__15980,G__15981));
});
cljs$core$fn_15977_$_fn_15978_$_fn_15979 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_15977_$_fn_15978_$_fn_15979__0.call(this);
case 1:
return cljs$core$fn_15977_$_fn_15978_$_fn_15979__1.call(this,result);
case 2:
return cljs$core$fn_15977_$_fn_15978_$_fn_15979__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15977_$_fn_15978_$_fn_15979.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15977_$_fn_15978_$_fn_15979__0;
cljs$core$fn_15977_$_fn_15978_$_fn_15979.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15977_$_fn_15978_$_fn_15979__1;
cljs$core$fn_15977_$_fn_15978_$_fn_15979.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15977_$_fn_15978_$_fn_15979__2;
return cljs$core$fn_15977_$_fn_15978_$_fn_15979;
})()
});
}));

(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15984(f,coll){
var mapi = (function cljs$core$fn_15984_$_mapi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15984_$_mapi_$_fn_15990(){
var temp__5720__auto__ = cljs.core.seq(coll__$1);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__10672__auto___15996 = size;
var i_15997 = (0);
while(true){
if((i_15997 < n__10672__auto___15996)){
cljs.core.chunk_append(b,(function (){var G__15991 = (idx + i_15997);
var G__15992 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_15997);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15991,G__15992) : f.call(null,G__15991,G__15992));
})());

var G__15998 = (i_15997 + (1));
i_15997 = G__15998;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$fn_15984_$_mapi((idx + size),cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__15993 = idx;
var G__15994 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15993,G__15994) : f.call(null,G__15993,G__15994));
})(),cljs$core$fn_15984_$_mapi((idx + (1)),cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
return mapi((0),coll);
}));

(cljs.core.map_indexed.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the non-nil results of (f item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a transducer when no collection is provided.
 */
cljs.core.keep = (function cljs$core$keep(var_args){
var G__16000 = arguments.length;
switch (G__16000) {
case 1:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16001(f){
return (function cljs$core$fn_16001_$_fn_16002(rf){
return (function() {
var cljs$core$fn_16001_$_fn_16002_$_fn_16003 = null;
var cljs$core$fn_16001_$_fn_16002_$_fn_16003__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16001_$_fn_16002_$_fn_16003__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16001_$_fn_16002_$_fn_16003__2 = (function (result,input){
var v = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
cljs$core$fn_16001_$_fn_16002_$_fn_16003 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16001_$_fn_16002_$_fn_16003__0.call(this);
case 1:
return cljs$core$fn_16001_$_fn_16002_$_fn_16003__1.call(this,result);
case 2:
return cljs$core$fn_16001_$_fn_16002_$_fn_16003__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16001_$_fn_16002_$_fn_16003.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16001_$_fn_16002_$_fn_16003__0;
cljs$core$fn_16001_$_fn_16002_$_fn_16003.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16001_$_fn_16002_$_fn_16003__1;
cljs$core$fn_16001_$_fn_16002_$_fn_16003.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16001_$_fn_16002_$_fn_16003__2;
return cljs$core$fn_16001_$_fn_16002_$_fn_16003;
})()
});
}));

(cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16004(f,coll){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16004_$_fn_16005(){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__10672__auto___16009 = size;
var i_16010 = (0);
while(true){
if((i_16010 < n__10672__auto___16009)){
var x_16011 = (function (){var G__16006 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_16010);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16006) : f.call(null,G__16006));
})();
if((x_16011 == null)){
} else {
cljs.core.chunk_append(b,x_16011);
}

var G__16012 = (i_16010 + (1));
i_16010 = G__16012;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__16007 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16007) : f.call(null,G__16007));
})();
if((x == null)){
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.keep.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IWatchable}
 * @implements {cljs.core.IAtom}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Atom = (function (state,meta,validator,watches){
this.state = state;
this.meta = meta;
this.validator = validator;
this.watches = watches;
this.cljs$lang$protocol_mask$partition1$ = 16386;
this.cljs$lang$protocol_mask$partition0$ = 6455296;
});
(cljs.core.Atom.prototype.equiv = (function cljs$core$fn_16013(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16014(o,other){
var self__ = this;
var o__$1 = this;
return (o__$1 === other);
}));

(cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = (function cljs$core$fn_16015(_){
var self__ = this;
var ___$1 = this;
return self__.state;
}));

(cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16016(_){
var self__ = this;
var ___$1 = this;
return self__.meta;
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function cljs$core$fn_16017(this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
var seq__16018 = cljs.core.seq(self__.watches);
var chunk__16019 = null;
var count__16020 = (0);
var i__16021 = (0);
while(true){
if((i__16021 < count__16020)){
var vec__16028 = chunk__16019.cljs$core$IIndexed$_nth$arity$2(null,i__16021);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16028,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16028,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));


var G__16039 = seq__16018;
var G__16040 = chunk__16019;
var G__16041 = count__16020;
var G__16042 = (i__16021 + (1));
seq__16018 = G__16039;
chunk__16019 = G__16040;
count__16020 = G__16041;
i__16021 = G__16042;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__16018);
if(temp__5720__auto__){
var seq__16018__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__16018__$1)){
var c__10556__auto__ = cljs.core.chunk_first(seq__16018__$1);
var G__16043 = cljs.core.chunk_rest(seq__16018__$1);
var G__16044 = c__10556__auto__;
var G__16045 = cljs.core.count(c__10556__auto__);
var G__16046 = (0);
seq__16018 = G__16043;
chunk__16019 = G__16044;
count__16020 = G__16045;
i__16021 = G__16046;
continue;
} else {
var vec__16031 = cljs.core.first(seq__16018__$1);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16031,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16031,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));


var G__16047 = cljs.core.next(seq__16018__$1);
var G__16048 = null;
var G__16049 = (0);
var G__16050 = (0);
seq__16018 = G__16047;
chunk__16019 = G__16048;
count__16020 = G__16049;
i__16021 = G__16050;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function cljs$core$fn_16034(this$,key,f){
var self__ = this;
var this$__$1 = this;
(this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches,key,f));

return this$__$1;
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function cljs$core$fn_16035(this$,key){
var self__ = this;
var this$__$1 = this;
return (this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches,key));
}));

(cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16036(this$){
var self__ = this;
var this$__$1 = this;
return goog.getUid(this$__$1);
}));

(cljs.core.Atom.getBasis = (function cljs$core$fn_16037(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"validator","validator",-325659154,null),new cljs.core.Symbol(null,"watches","watches",1367433992,null)], null);
}));

(cljs.core.Atom.cljs$lang$type = true);

(cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom");

(cljs.core.Atom.cljs$lang$ctorPrWriter = (function cljs$core$fn_16038(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/Atom");
}));

/**
 * Positional factory function for cljs.core/Atom.
 */
cljs.core.__GT_Atom = (function cljs$core$__GT_Atom(state,meta,validator,watches){
return (new cljs.core.Atom(state,meta,validator,watches));
});

/**
 * Creates and returns an Atom with an initial value of x and zero or
 *   more options (in any order):
 * 
 *   :meta metadata-map
 * 
 *   :validator validate-fn
 * 
 *   If metadata-map is supplied, it will become the metadata on the
 *   atom. validate-fn must be nil or a side-effect-free fn of one
 *   argument, which will be passed the intended new state on any state
 *   change. If the new state is unacceptable, the validate-fn should
 *   return false or throw an Error.  If either of these error conditions
 *   occur, then the value of the atom will not change.
 */
cljs.core.atom = (function cljs$core$atom(var_args){
var G__16054 = arguments.length;
switch (G__16054) {
case 1:
return cljs.core.atom.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___16061 = arguments.length;
var i__10914__auto___16062 = (0);
while(true){
if((i__10914__auto___16062 < len__10913__auto___16061)){
args_arr__10942__auto__.push((arguments[i__10914__auto___16062]));

var G__16063 = (i__10914__auto___16062 + (1));
i__10914__auto___16062 = G__16063;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((1) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((1)),(0),null)):null);
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10943__auto__);

}
});

(cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16055(x){
return (new cljs.core.Atom(x,null,null,null));
}));

(cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16057(x,p__16056){
var map__16058 = p__16056;
var map__16058__$1 = cljs.core.__destructure_map(map__16058);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16058__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16058__$1,new cljs.core.Keyword(null,"validator","validator",-1966190681));
return (new cljs.core.Atom(x,meta,validator,null));
}));

/** @this {Function} */
(cljs.core.atom.cljs$lang$applyTo = (function cljs$core$fn_16059(seq16052){
var G__16053 = cljs.core.first(seq16052);
var seq16052__$1 = cljs.core.next(seq16052);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16053,seq16052__$1);
}));

(cljs.core.atom.cljs$lang$maxFixedArity = (1));

/**
 * Sets the value of atom to newval without regard for the
 *   current value. Returns new-value.
 */
cljs.core.reset_BANG_ = (function cljs$core$reset_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null,new_value)))){
} else {
throw (new Error("Validator rejected reference state"));
}
}

var old_value = a.state;
(a.state = new_value);

if((a.watches == null)){
} else {
a.cljs$core$IWatchable$_notify_watches$arity$3(null,old_value,new_value);
}

return new_value;
} else {
return cljs.core._reset_BANG_(a,new_value);
}
});
/**
 * Sets the value of atom to newval. Returns [old new], the value of the
 * atom before and after the reset.
 */
cljs.core.reset_vals_BANG_ = (function cljs$core$reset_vals_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null,new_value)))){
} else {
throw (new Error("Validator rejected reference state"));
}
}

var old_value = a.state;
(a.state = new_value);

if((a.watches == null)){
} else {
a.cljs$core$IWatchable$_notify_watches$arity$3(null,old_value,new_value);
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_value,new_value], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._reset_BANG_(a,new_value)], null);
}
});
/**
 * Atomically swaps the value of atom to be:
 *   (apply f current-value-of-atom args). Note that f may be called
 *   multiple times, and thus should be free of side effects.  Returns
 *   the value that was swapped in.
 */
cljs.core.swap_BANG_ = (function cljs$core$swap_BANG_(var_args){
var G__16070 = arguments.length;
switch (G__16070) {
case 2:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___16083 = arguments.length;
var i__10914__auto___16084 = (0);
while(true){
if((i__10914__auto___16084 < len__10913__auto___16083)){
args_arr__10942__auto__.push((arguments[i__10914__auto___16084]));

var G__16085 = (i__10914__auto___16084 + (1));
i__10914__auto___16084 = G__16085;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((4) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((4)),(0),null)):null);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10943__auto__);

}
});

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16071(a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__16072 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16072) : f.call(null,G__16072));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16073(a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__16074 = a.state;
var G__16075 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16074,G__16075) : f.call(null,G__16074,G__16075));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16076(a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__16077 = a.state;
var G__16078 = x;
var G__16079 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16077,G__16078,G__16079) : f.call(null,G__16077,G__16078,G__16079));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16080(a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more);
}
}));

/** @this {Function} */
(cljs.core.swap_BANG_.cljs$lang$applyTo = (function cljs$core$fn_16081(seq16065){
var G__16066 = cljs.core.first(seq16065);
var seq16065__$1 = cljs.core.next(seq16065);
var G__16067 = cljs.core.first(seq16065__$1);
var seq16065__$2 = cljs.core.next(seq16065__$1);
var G__16068 = cljs.core.first(seq16065__$2);
var seq16065__$3 = cljs.core.next(seq16065__$2);
var G__16069 = cljs.core.first(seq16065__$3);
var seq16065__$4 = cljs.core.next(seq16065__$3);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16066,G__16067,G__16068,G__16069,seq16065__$4);
}));

(cljs.core.swap_BANG_.cljs$lang$maxFixedArity = (4));

/**
 * Atomically swaps the value of atom to be:
 *   (apply f current-value-of-atom args). Note that f may be called
 *   multiple times, and thus should be free of side effects.
 *   Returns [old new], the value of the atom before and after the swap.
 */
cljs.core.swap_vals_BANG_ = (function cljs$core$swap_vals_BANG_(var_args){
var G__16092 = arguments.length;
switch (G__16092) {
case 2:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___16105 = arguments.length;
var i__10914__auto___16106 = (0);
while(true){
if((i__10914__auto___16106 < len__10913__auto___16105)){
args_arr__10942__auto__.push((arguments[i__10914__auto___16106]));

var G__16107 = (i__10914__auto___16106 + (1));
i__10914__auto___16106 = G__16107;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((4) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((4)),(0),null)):null);
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10943__auto__);

}
});

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16093(a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_vals_BANG_(a,(function (){var G__16094 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16094) : f.call(null,G__16094));
})());
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f)], null);
}
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16095(a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_vals_BANG_(a,(function (){var G__16096 = a.state;
var G__16097 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16096,G__16097) : f.call(null,G__16096,G__16097));
})());
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x)], null);
}
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16098(a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_vals_BANG_(a,(function (){var G__16099 = a.state;
var G__16100 = x;
var G__16101 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16099,G__16100,G__16101) : f.call(null,G__16099,G__16100,G__16101));
})());
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y)], null);
}
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16102(a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_vals_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more)], null);
}
}));

/** @this {Function} */
(cljs.core.swap_vals_BANG_.cljs$lang$applyTo = (function cljs$core$fn_16103(seq16087){
var G__16088 = cljs.core.first(seq16087);
var seq16087__$1 = cljs.core.next(seq16087);
var G__16089 = cljs.core.first(seq16087__$1);
var seq16087__$2 = cljs.core.next(seq16087__$1);
var G__16090 = cljs.core.first(seq16087__$2);
var seq16087__$3 = cljs.core.next(seq16087__$2);
var G__16091 = cljs.core.first(seq16087__$3);
var seq16087__$4 = cljs.core.next(seq16087__$3);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16088,G__16089,G__16090,G__16091,seq16087__$4);
}));

(cljs.core.swap_vals_BANG_.cljs$lang$maxFixedArity = (4));

/**
 * Atomically sets the value of atom to newval if and only if the
 *   current value of the atom is equal to oldval. Returns true if
 *   set happened, else false.
 */
cljs.core.compare_and_set_BANG_ = (function cljs$core$compare_and_set_BANG_(a,oldval,newval){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null),oldval)){
cljs.core.reset_BANG_(a,newval);

return true;
} else {
return false;
}
});
/**
 * Sets the validator-fn for an atom. validator-fn must be nil or a
 *   side-effect-free fn of one argument, which will be passed the intended
 *   new state on any state change. If the new state is unacceptable, the
 *   validator-fn should return false or throw an Error. If the current state
 *   is not acceptable to the new validator, an Error will be thrown and the
 *   validator will not be changed.
 */
cljs.core.set_validator_BANG_ = (function cljs$core$set_validator_BANG_(iref,val){
if((((!((val == null)))) && (cljs.core.not((function (){var G__16108 = cljs.core._deref(iref);
return (val.cljs$core$IFn$_invoke$arity$1 ? val.cljs$core$IFn$_invoke$arity$1(G__16108) : val.call(null,G__16108));
})())))){
throw (new Error("Validator rejected reference state"));
} else {
}

return (iref.validator = val);
});
/**
 * Gets the validator-fn for a var/ref/agent/atom.
 */
cljs.core.get_validator = (function cljs$core$get_validator(iref){
return iref.validator;
});

/**
* @constructor
 * @implements {cljs.core.IVolatile}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Volatile = (function (state){
this.state = state;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Volatile.prototype.cljs$core$IVolatile$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = (function cljs$core$fn_16109(_,new_state){
var self__ = this;
var ___$1 = this;
return (self__.state = new_state);
}));

(cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = (function cljs$core$fn_16110(_){
var self__ = this;
var ___$1 = this;
return self__.state;
}));

(cljs.core.Volatile.getBasis = (function cljs$core$fn_16111(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Volatile.cljs$lang$type = true);

(cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile");

(cljs.core.Volatile.cljs$lang$ctorPrWriter = (function cljs$core$fn_16112(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/Volatile");
}));

/**
 * Positional factory function for cljs.core/Volatile.
 */
cljs.core.__GT_Volatile = (function cljs$core$__GT_Volatile(state){
return (new cljs.core.Volatile(state));
});

/**
 * Creates and returns a Volatile with an initial value of val.
 */
cljs.core.volatile_BANG_ = (function cljs$core$volatile_BANG_(val){
return (new cljs.core.Volatile(val));
});
/**
 * Returns true if x is a volatile.
 */
cljs.core.volatile_QMARK_ = (function cljs$core$volatile_QMARK_(x){
return (x instanceof cljs.core.Volatile);
});
/**
 * Sets the value of volatile to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.vreset_BANG_ = (function cljs$core$vreset_BANG_(vol,newval){
return cljs.core._vreset_BANG_(vol,newval);
});
/**
 * Returns a lazy sequence of the non-nil results of (f index item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a stateful transducer when no collection is
 *   provided.
 */
cljs.core.keep_indexed = (function cljs$core$keep_indexed(var_args){
var G__16114 = arguments.length;
switch (G__16114) {
case 1:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16115(f){
return (function cljs$core$fn_16115_$_fn_16116(rf){
var ia = cljs.core.volatile_BANG_((-1));
return (function() {
var cljs$core$fn_16115_$_fn_16116_$_fn_16117 = null;
var cljs$core$fn_16115_$_fn_16116_$_fn_16117__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16115_$_fn_16116_$_fn_16117__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16115_$_fn_16116_$_fn_16117__2 = (function (result,input){
var i = ia.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(ia.cljs$core$IDeref$_deref$arity$1(null) + (1)));
var v = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(i,input) : f.call(null,i,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
cljs$core$fn_16115_$_fn_16116_$_fn_16117 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16115_$_fn_16116_$_fn_16117__0.call(this);
case 1:
return cljs$core$fn_16115_$_fn_16116_$_fn_16117__1.call(this,result);
case 2:
return cljs$core$fn_16115_$_fn_16116_$_fn_16117__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16115_$_fn_16116_$_fn_16117.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16115_$_fn_16116_$_fn_16117__0;
cljs$core$fn_16115_$_fn_16116_$_fn_16117.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16115_$_fn_16116_$_fn_16117__1;
cljs$core$fn_16115_$_fn_16116_$_fn_16117.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16115_$_fn_16116_$_fn_16117__2;
return cljs$core$fn_16115_$_fn_16116_$_fn_16117;
})()
});
}));

(cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16118(f,coll){
var keepi = (function cljs$core$fn_16118_$_keepi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16118_$_keepi_$_fn_16124(){
var temp__5720__auto__ = cljs.core.seq(coll__$1);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__10672__auto___16130 = size;
var i_16131 = (0);
while(true){
if((i_16131 < n__10672__auto___16130)){
var x_16132 = (function (){var G__16125 = (idx + i_16131);
var G__16126 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_16131);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16125,G__16126) : f.call(null,G__16125,G__16126));
})();
if((x_16132 == null)){
} else {
cljs.core.chunk_append(b,x_16132);
}

var G__16133 = (i_16131 + (1));
i_16131 = G__16133;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$fn_16118_$_keepi((idx + size),cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__16127 = idx;
var G__16128 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16127,G__16128) : f.call(null,G__16127,G__16128));
})();
if((x == null)){
return cljs$core$fn_16118_$_keepi((idx + (1)),cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs$core$fn_16118_$_keepi((idx + (1)),cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
return keepi((0),coll);
}));

(cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2);

/**
 * Takes a set of predicates and returns a function f that returns true if all of its
 *   composing predicates return a logical true value against all of its arguments, else it returns
 *   false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical false result against the original predicates.
 */
cljs.core.every_pred = (function cljs$core$every_pred(var_args){
var G__16145 = arguments.length;
switch (G__16145) {
case 1:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___16158 = arguments.length;
var i__10914__auto___16159 = (0);
while(true){
if((i__10914__auto___16159 < len__10913__auto___16158)){
args_arr__10942__auto__.push((arguments[i__10914__auto___16159]));

var G__16160 = (i__10914__auto___16159 + (1));
i__10914__auto___16159 = G__16160;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((3) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((3)),(0),null)):null);
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10943__auto__);

}
});

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16146(p){
return (function() {
var cljs$core$fn_16146_$_ep1 = null;
var cljs$core$fn_16146_$_ep1__0 = (function (){
return true;
});
var cljs$core$fn_16146_$_ep1__1 = (function (x){
return cljs.core.boolean$((p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x)));
});
var cljs$core$fn_16146_$_ep1__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__9578__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__9578__auto__)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
} else {
return and__9578__auto__;
}
})());
});
var cljs$core$fn_16146_$_ep1__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__9578__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__9578__auto__)){
var and__9578__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(and__9578__auto____$1)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
} else {
return and__9578__auto____$1;
}
} else {
return and__9578__auto__;
}
})());
});
var cljs$core$fn_16146_$_ep1__4 = (function() { 
var G__16161__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__9578__auto__ = cljs$core$fn_16146_$_ep1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__9578__auto__)){
return cljs.core.every_QMARK_(p,args);
} else {
return and__9578__auto__;
}
})());
};
var G__16161 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16162__i = 0, G__16162__a = new Array(arguments.length -  3);
while (G__16162__i < G__16162__a.length) {G__16162__a[G__16162__i] = arguments[G__16162__i + 3]; ++G__16162__i;}
  args = new cljs.core.IndexedSeq(G__16162__a,0,null);
} 
return G__16161__delegate.call(this,x,y,z,args);};
G__16161.cljs$lang$maxFixedArity = 3;
G__16161.cljs$lang$applyTo = (function (arglist__16163){
var x = cljs.core.first(arglist__16163);
arglist__16163 = cljs.core.next(arglist__16163);
var y = cljs.core.first(arglist__16163);
arglist__16163 = cljs.core.next(arglist__16163);
var z = cljs.core.first(arglist__16163);
var args = cljs.core.rest(arglist__16163);
return G__16161__delegate(x,y,z,args);
});
G__16161.cljs$core$IFn$_invoke$arity$variadic = G__16161__delegate;
return G__16161;
})()
;
cljs$core$fn_16146_$_ep1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16146_$_ep1__0.call(this);
case 1:
return cljs$core$fn_16146_$_ep1__1.call(this,x);
case 2:
return cljs$core$fn_16146_$_ep1__2.call(this,x,y);
case 3:
return cljs$core$fn_16146_$_ep1__3.call(this,x,y,z);
default:
var G__16164 = null;
if (arguments.length > 3) {
var G__16165__i = 0, G__16165__a = new Array(arguments.length -  3);
while (G__16165__i < G__16165__a.length) {G__16165__a[G__16165__i] = arguments[G__16165__i + 3]; ++G__16165__i;}
G__16164 = new cljs.core.IndexedSeq(G__16165__a,0,null);
}
return cljs$core$fn_16146_$_ep1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16164);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16146_$_ep1.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16146_$_ep1.cljs$lang$applyTo = cljs$core$fn_16146_$_ep1__4.cljs$lang$applyTo;
cljs$core$fn_16146_$_ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16146_$_ep1__0;
cljs$core$fn_16146_$_ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16146_$_ep1__1;
cljs$core$fn_16146_$_ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16146_$_ep1__2;
cljs$core$fn_16146_$_ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16146_$_ep1__3;
cljs$core$fn_16146_$_ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16146_$_ep1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16146_$_ep1;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16147(p1,p2){
return (function() {
var cljs$core$fn_16147_$_ep2 = null;
var cljs$core$fn_16147_$_ep2__0 = (function (){
return true;
});
var cljs$core$fn_16147_$_ep2__1 = (function (x){
return cljs.core.boolean$((function (){var and__9578__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9578__auto__)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
} else {
return and__9578__auto__;
}
})());
});
var cljs$core$fn_16147_$_ep2__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__9578__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9578__auto__)){
var and__9578__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__9578__auto____$1)){
var and__9578__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__9578__auto____$2)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
} else {
return and__9578__auto____$2;
}
} else {
return and__9578__auto____$1;
}
} else {
return and__9578__auto__;
}
})());
});
var cljs$core$fn_16147_$_ep2__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__9578__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9578__auto__)){
var and__9578__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__9578__auto____$1)){
var and__9578__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__9578__auto____$2)){
var and__9578__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__9578__auto____$3)){
var and__9578__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__9578__auto____$4)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
} else {
return and__9578__auto____$4;
}
} else {
return and__9578__auto____$3;
}
} else {
return and__9578__auto____$2;
}
} else {
return and__9578__auto____$1;
}
} else {
return and__9578__auto__;
}
})());
});
var cljs$core$fn_16147_$_ep2__4 = (function() { 
var G__16166__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__9578__auto__ = cljs$core$fn_16147_$_ep2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__9578__auto__)){
return cljs.core.every_QMARK_((function cljs$core$fn_16147_$_ep2_$_fn_16148(p1__16134_SHARP_){
var and__9578__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__16134_SHARP_) : p1.call(null,p1__16134_SHARP_));
if(cljs.core.truth_(and__9578__auto____$1)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__16134_SHARP_) : p2.call(null,p1__16134_SHARP_));
} else {
return and__9578__auto____$1;
}
}),args);
} else {
return and__9578__auto__;
}
})());
};
var G__16166 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16167__i = 0, G__16167__a = new Array(arguments.length -  3);
while (G__16167__i < G__16167__a.length) {G__16167__a[G__16167__i] = arguments[G__16167__i + 3]; ++G__16167__i;}
  args = new cljs.core.IndexedSeq(G__16167__a,0,null);
} 
return G__16166__delegate.call(this,x,y,z,args);};
G__16166.cljs$lang$maxFixedArity = 3;
G__16166.cljs$lang$applyTo = (function (arglist__16168){
var x = cljs.core.first(arglist__16168);
arglist__16168 = cljs.core.next(arglist__16168);
var y = cljs.core.first(arglist__16168);
arglist__16168 = cljs.core.next(arglist__16168);
var z = cljs.core.first(arglist__16168);
var args = cljs.core.rest(arglist__16168);
return G__16166__delegate(x,y,z,args);
});
G__16166.cljs$core$IFn$_invoke$arity$variadic = G__16166__delegate;
return G__16166;
})()
;
cljs$core$fn_16147_$_ep2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16147_$_ep2__0.call(this);
case 1:
return cljs$core$fn_16147_$_ep2__1.call(this,x);
case 2:
return cljs$core$fn_16147_$_ep2__2.call(this,x,y);
case 3:
return cljs$core$fn_16147_$_ep2__3.call(this,x,y,z);
default:
var G__16169 = null;
if (arguments.length > 3) {
var G__16170__i = 0, G__16170__a = new Array(arguments.length -  3);
while (G__16170__i < G__16170__a.length) {G__16170__a[G__16170__i] = arguments[G__16170__i + 3]; ++G__16170__i;}
G__16169 = new cljs.core.IndexedSeq(G__16170__a,0,null);
}
return cljs$core$fn_16147_$_ep2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16169);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16147_$_ep2.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16147_$_ep2.cljs$lang$applyTo = cljs$core$fn_16147_$_ep2__4.cljs$lang$applyTo;
cljs$core$fn_16147_$_ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16147_$_ep2__0;
cljs$core$fn_16147_$_ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16147_$_ep2__1;
cljs$core$fn_16147_$_ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16147_$_ep2__2;
cljs$core$fn_16147_$_ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16147_$_ep2__3;
cljs$core$fn_16147_$_ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16147_$_ep2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16147_$_ep2;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16149(p1,p2,p3){
return (function() {
var cljs$core$fn_16149_$_ep3 = null;
var cljs$core$fn_16149_$_ep3__0 = (function (){
return true;
});
var cljs$core$fn_16149_$_ep3__1 = (function (x){
return cljs.core.boolean$((function (){var and__9578__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9578__auto__)){
var and__9578__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__9578__auto____$1)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
} else {
return and__9578__auto____$1;
}
} else {
return and__9578__auto__;
}
})());
});
var cljs$core$fn_16149_$_ep3__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__9578__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9578__auto__)){
var and__9578__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__9578__auto____$1)){
var and__9578__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__9578__auto____$2)){
var and__9578__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__9578__auto____$3)){
var and__9578__auto____$4 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__9578__auto____$4)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
} else {
return and__9578__auto____$4;
}
} else {
return and__9578__auto____$3;
}
} else {
return and__9578__auto____$2;
}
} else {
return and__9578__auto____$1;
}
} else {
return and__9578__auto__;
}
})());
});
var cljs$core$fn_16149_$_ep3__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__9578__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9578__auto__)){
var and__9578__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__9578__auto____$1)){
var and__9578__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__9578__auto____$2)){
var and__9578__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__9578__auto____$3)){
var and__9578__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__9578__auto____$4)){
var and__9578__auto____$5 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(and__9578__auto____$5)){
var and__9578__auto____$6 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__9578__auto____$6)){
var and__9578__auto____$7 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(and__9578__auto____$7)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
} else {
return and__9578__auto____$7;
}
} else {
return and__9578__auto____$6;
}
} else {
return and__9578__auto____$5;
}
} else {
return and__9578__auto____$4;
}
} else {
return and__9578__auto____$3;
}
} else {
return and__9578__auto____$2;
}
} else {
return and__9578__auto____$1;
}
} else {
return and__9578__auto__;
}
})());
});
var cljs$core$fn_16149_$_ep3__4 = (function() { 
var G__16171__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__9578__auto__ = cljs$core$fn_16149_$_ep3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__9578__auto__)){
return cljs.core.every_QMARK_((function cljs$core$fn_16149_$_ep3_$_fn_16150(p1__16135_SHARP_){
var and__9578__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__16135_SHARP_) : p1.call(null,p1__16135_SHARP_));
if(cljs.core.truth_(and__9578__auto____$1)){
var and__9578__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__16135_SHARP_) : p2.call(null,p1__16135_SHARP_));
if(cljs.core.truth_(and__9578__auto____$2)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__16135_SHARP_) : p3.call(null,p1__16135_SHARP_));
} else {
return and__9578__auto____$2;
}
} else {
return and__9578__auto____$1;
}
}),args);
} else {
return and__9578__auto__;
}
})());
};
var G__16171 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16172__i = 0, G__16172__a = new Array(arguments.length -  3);
while (G__16172__i < G__16172__a.length) {G__16172__a[G__16172__i] = arguments[G__16172__i + 3]; ++G__16172__i;}
  args = new cljs.core.IndexedSeq(G__16172__a,0,null);
} 
return G__16171__delegate.call(this,x,y,z,args);};
G__16171.cljs$lang$maxFixedArity = 3;
G__16171.cljs$lang$applyTo = (function (arglist__16173){
var x = cljs.core.first(arglist__16173);
arglist__16173 = cljs.core.next(arglist__16173);
var y = cljs.core.first(arglist__16173);
arglist__16173 = cljs.core.next(arglist__16173);
var z = cljs.core.first(arglist__16173);
var args = cljs.core.rest(arglist__16173);
return G__16171__delegate(x,y,z,args);
});
G__16171.cljs$core$IFn$_invoke$arity$variadic = G__16171__delegate;
return G__16171;
})()
;
cljs$core$fn_16149_$_ep3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16149_$_ep3__0.call(this);
case 1:
return cljs$core$fn_16149_$_ep3__1.call(this,x);
case 2:
return cljs$core$fn_16149_$_ep3__2.call(this,x,y);
case 3:
return cljs$core$fn_16149_$_ep3__3.call(this,x,y,z);
default:
var G__16174 = null;
if (arguments.length > 3) {
var G__16175__i = 0, G__16175__a = new Array(arguments.length -  3);
while (G__16175__i < G__16175__a.length) {G__16175__a[G__16175__i] = arguments[G__16175__i + 3]; ++G__16175__i;}
G__16174 = new cljs.core.IndexedSeq(G__16175__a,0,null);
}
return cljs$core$fn_16149_$_ep3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16174);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16149_$_ep3.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16149_$_ep3.cljs$lang$applyTo = cljs$core$fn_16149_$_ep3__4.cljs$lang$applyTo;
cljs$core$fn_16149_$_ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16149_$_ep3__0;
cljs$core$fn_16149_$_ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16149_$_ep3__1;
cljs$core$fn_16149_$_ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16149_$_ep3__2;
cljs$core$fn_16149_$_ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16149_$_ep3__3;
cljs$core$fn_16149_$_ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16149_$_ep3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16149_$_ep3;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16151(p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return (function() {
var cljs$core$fn_16151_$_epn = null;
var cljs$core$fn_16151_$_epn__0 = (function (){
return true;
});
var cljs$core$fn_16151_$_epn__1 = (function (x){
return cljs.core.every_QMARK_((function cljs$core$fn_16151_$_epn_$_fn_16152(p1__16136_SHARP_){
return (p1__16136_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16136_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16136_SHARP_.call(null,x));
}),ps__$1);
});
var cljs$core$fn_16151_$_epn__2 = (function (x,y){
return cljs.core.every_QMARK_((function cljs$core$fn_16151_$_epn_$_fn_16153(p1__16137_SHARP_){
var and__9578__auto__ = (p1__16137_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16137_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16137_SHARP_.call(null,x));
if(cljs.core.truth_(and__9578__auto__)){
return (p1__16137_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16137_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__16137_SHARP_.call(null,y));
} else {
return and__9578__auto__;
}
}),ps__$1);
});
var cljs$core$fn_16151_$_epn__3 = (function (x,y,z){
return cljs.core.every_QMARK_((function cljs$core$fn_16151_$_epn_$_fn_16154(p1__16138_SHARP_){
var and__9578__auto__ = (p1__16138_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16138_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16138_SHARP_.call(null,x));
if(cljs.core.truth_(and__9578__auto__)){
var and__9578__auto____$1 = (p1__16138_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16138_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__16138_SHARP_.call(null,y));
if(cljs.core.truth_(and__9578__auto____$1)){
return (p1__16138_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16138_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__16138_SHARP_.call(null,z));
} else {
return and__9578__auto____$1;
}
} else {
return and__9578__auto__;
}
}),ps__$1);
});
var cljs$core$fn_16151_$_epn__4 = (function() { 
var G__16176__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__9578__auto__ = cljs$core$fn_16151_$_epn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__9578__auto__)){
return cljs.core.every_QMARK_((function cljs$core$fn_16151_$_epn_$_fn_16155(p1__16139_SHARP_){
return cljs.core.every_QMARK_(p1__16139_SHARP_,args);
}),ps__$1);
} else {
return and__9578__auto__;
}
})());
};
var G__16176 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16177__i = 0, G__16177__a = new Array(arguments.length -  3);
while (G__16177__i < G__16177__a.length) {G__16177__a[G__16177__i] = arguments[G__16177__i + 3]; ++G__16177__i;}
  args = new cljs.core.IndexedSeq(G__16177__a,0,null);
} 
return G__16176__delegate.call(this,x,y,z,args);};
G__16176.cljs$lang$maxFixedArity = 3;
G__16176.cljs$lang$applyTo = (function (arglist__16178){
var x = cljs.core.first(arglist__16178);
arglist__16178 = cljs.core.next(arglist__16178);
var y = cljs.core.first(arglist__16178);
arglist__16178 = cljs.core.next(arglist__16178);
var z = cljs.core.first(arglist__16178);
var args = cljs.core.rest(arglist__16178);
return G__16176__delegate(x,y,z,args);
});
G__16176.cljs$core$IFn$_invoke$arity$variadic = G__16176__delegate;
return G__16176;
})()
;
cljs$core$fn_16151_$_epn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16151_$_epn__0.call(this);
case 1:
return cljs$core$fn_16151_$_epn__1.call(this,x);
case 2:
return cljs$core$fn_16151_$_epn__2.call(this,x,y);
case 3:
return cljs$core$fn_16151_$_epn__3.call(this,x,y,z);
default:
var G__16179 = null;
if (arguments.length > 3) {
var G__16180__i = 0, G__16180__a = new Array(arguments.length -  3);
while (G__16180__i < G__16180__a.length) {G__16180__a[G__16180__i] = arguments[G__16180__i + 3]; ++G__16180__i;}
G__16179 = new cljs.core.IndexedSeq(G__16180__a,0,null);
}
return cljs$core$fn_16151_$_epn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16179);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16151_$_epn.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16151_$_epn.cljs$lang$applyTo = cljs$core$fn_16151_$_epn__4.cljs$lang$applyTo;
cljs$core$fn_16151_$_epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16151_$_epn__0;
cljs$core$fn_16151_$_epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16151_$_epn__1;
cljs$core$fn_16151_$_epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16151_$_epn__2;
cljs$core$fn_16151_$_epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16151_$_epn__3;
cljs$core$fn_16151_$_epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16151_$_epn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16151_$_epn;
})()
}));

/** @this {Function} */
(cljs.core.every_pred.cljs$lang$applyTo = (function cljs$core$fn_16156(seq16141){
var G__16142 = cljs.core.first(seq16141);
var seq16141__$1 = cljs.core.next(seq16141);
var G__16143 = cljs.core.first(seq16141__$1);
var seq16141__$2 = cljs.core.next(seq16141__$1);
var G__16144 = cljs.core.first(seq16141__$2);
var seq16141__$3 = cljs.core.next(seq16141__$2);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16142,G__16143,G__16144,seq16141__$3);
}));

(cljs.core.every_pred.cljs$lang$maxFixedArity = (3));

/**
 * Takes a set of predicates and returns a function f that returns the first logical true value
 *   returned by one of its composing predicates against any of its arguments, else it returns
 *   logical false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical true result against the original predicates.
 */
cljs.core.some_fn = (function cljs$core$some_fn(var_args){
var G__16192 = arguments.length;
switch (G__16192) {
case 1:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___16205 = arguments.length;
var i__10914__auto___16206 = (0);
while(true){
if((i__10914__auto___16206 < len__10913__auto___16205)){
args_arr__10942__auto__.push((arguments[i__10914__auto___16206]));

var G__16207 = (i__10914__auto___16206 + (1));
i__10914__auto___16206 = G__16207;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((3) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((3)),(0),null)):null);
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10943__auto__);

}
});

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16193(p){
return (function() {
var cljs$core$fn_16193_$_sp1 = null;
var cljs$core$fn_16193_$_sp1__0 = (function (){
return null;
});
var cljs$core$fn_16193_$_sp1__1 = (function (x){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
});
var cljs$core$fn_16193_$_sp1__2 = (function (x,y){
var or__9584__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__9584__auto__)){
return or__9584__auto__;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
}
});
var cljs$core$fn_16193_$_sp1__3 = (function (x,y,z){
var or__9584__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__9584__auto__)){
return or__9584__auto__;
} else {
var or__9584__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(or__9584__auto____$1)){
return or__9584__auto____$1;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
}
}
});
var cljs$core$fn_16193_$_sp1__4 = (function() { 
var G__16208__delegate = function (x,y,z,args){
var or__9584__auto__ = cljs$core$fn_16193_$_sp1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__9584__auto__)){
return or__9584__auto__;
} else {
return cljs.core.some(p,args);
}
};
var G__16208 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16209__i = 0, G__16209__a = new Array(arguments.length -  3);
while (G__16209__i < G__16209__a.length) {G__16209__a[G__16209__i] = arguments[G__16209__i + 3]; ++G__16209__i;}
  args = new cljs.core.IndexedSeq(G__16209__a,0,null);
} 
return G__16208__delegate.call(this,x,y,z,args);};
G__16208.cljs$lang$maxFixedArity = 3;
G__16208.cljs$lang$applyTo = (function (arglist__16210){
var x = cljs.core.first(arglist__16210);
arglist__16210 = cljs.core.next(arglist__16210);
var y = cljs.core.first(arglist__16210);
arglist__16210 = cljs.core.next(arglist__16210);
var z = cljs.core.first(arglist__16210);
var args = cljs.core.rest(arglist__16210);
return G__16208__delegate(x,y,z,args);
});
G__16208.cljs$core$IFn$_invoke$arity$variadic = G__16208__delegate;
return G__16208;
})()
;
cljs$core$fn_16193_$_sp1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16193_$_sp1__0.call(this);
case 1:
return cljs$core$fn_16193_$_sp1__1.call(this,x);
case 2:
return cljs$core$fn_16193_$_sp1__2.call(this,x,y);
case 3:
return cljs$core$fn_16193_$_sp1__3.call(this,x,y,z);
default:
var G__16211 = null;
if (arguments.length > 3) {
var G__16212__i = 0, G__16212__a = new Array(arguments.length -  3);
while (G__16212__i < G__16212__a.length) {G__16212__a[G__16212__i] = arguments[G__16212__i + 3]; ++G__16212__i;}
G__16211 = new cljs.core.IndexedSeq(G__16212__a,0,null);
}
return cljs$core$fn_16193_$_sp1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16193_$_sp1.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16193_$_sp1.cljs$lang$applyTo = cljs$core$fn_16193_$_sp1__4.cljs$lang$applyTo;
cljs$core$fn_16193_$_sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16193_$_sp1__0;
cljs$core$fn_16193_$_sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16193_$_sp1__1;
cljs$core$fn_16193_$_sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16193_$_sp1__2;
cljs$core$fn_16193_$_sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16193_$_sp1__3;
cljs$core$fn_16193_$_sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16193_$_sp1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16193_$_sp1;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16194(p1,p2){
return (function() {
var cljs$core$fn_16194_$_sp2 = null;
var cljs$core$fn_16194_$_sp2__0 = (function (){
return null;
});
var cljs$core$fn_16194_$_sp2__1 = (function (x){
var or__9584__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9584__auto__)){
return or__9584__auto__;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
}
});
var cljs$core$fn_16194_$_sp2__2 = (function (x,y){
var or__9584__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9584__auto__)){
return or__9584__auto__;
} else {
var or__9584__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__9584__auto____$1)){
return or__9584__auto____$1;
} else {
var or__9584__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__9584__auto____$2)){
return or__9584__auto____$2;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
}
}
}
});
var cljs$core$fn_16194_$_sp2__3 = (function (x,y,z){
var or__9584__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9584__auto__)){
return or__9584__auto__;
} else {
var or__9584__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__9584__auto____$1)){
return or__9584__auto____$1;
} else {
var or__9584__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__9584__auto____$2)){
return or__9584__auto____$2;
} else {
var or__9584__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__9584__auto____$3)){
return or__9584__auto____$3;
} else {
var or__9584__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__9584__auto____$4)){
return or__9584__auto____$4;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
}
}
}
}
}
});
var cljs$core$fn_16194_$_sp2__4 = (function() { 
var G__16213__delegate = function (x,y,z,args){
var or__9584__auto__ = cljs$core$fn_16194_$_sp2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__9584__auto__)){
return or__9584__auto__;
} else {
return cljs.core.some((function cljs$core$fn_16194_$_sp2_$_fn_16195(p1__16181_SHARP_){
var or__9584__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__16181_SHARP_) : p1.call(null,p1__16181_SHARP_));
if(cljs.core.truth_(or__9584__auto____$1)){
return or__9584__auto____$1;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__16181_SHARP_) : p2.call(null,p1__16181_SHARP_));
}
}),args);
}
};
var G__16213 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16214__i = 0, G__16214__a = new Array(arguments.length -  3);
while (G__16214__i < G__16214__a.length) {G__16214__a[G__16214__i] = arguments[G__16214__i + 3]; ++G__16214__i;}
  args = new cljs.core.IndexedSeq(G__16214__a,0,null);
} 
return G__16213__delegate.call(this,x,y,z,args);};
G__16213.cljs$lang$maxFixedArity = 3;
G__16213.cljs$lang$applyTo = (function (arglist__16215){
var x = cljs.core.first(arglist__16215);
arglist__16215 = cljs.core.next(arglist__16215);
var y = cljs.core.first(arglist__16215);
arglist__16215 = cljs.core.next(arglist__16215);
var z = cljs.core.first(arglist__16215);
var args = cljs.core.rest(arglist__16215);
return G__16213__delegate(x,y,z,args);
});
G__16213.cljs$core$IFn$_invoke$arity$variadic = G__16213__delegate;
return G__16213;
})()
;
cljs$core$fn_16194_$_sp2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16194_$_sp2__0.call(this);
case 1:
return cljs$core$fn_16194_$_sp2__1.call(this,x);
case 2:
return cljs$core$fn_16194_$_sp2__2.call(this,x,y);
case 3:
return cljs$core$fn_16194_$_sp2__3.call(this,x,y,z);
default:
var G__16216 = null;
if (arguments.length > 3) {
var G__16217__i = 0, G__16217__a = new Array(arguments.length -  3);
while (G__16217__i < G__16217__a.length) {G__16217__a[G__16217__i] = arguments[G__16217__i + 3]; ++G__16217__i;}
G__16216 = new cljs.core.IndexedSeq(G__16217__a,0,null);
}
return cljs$core$fn_16194_$_sp2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16194_$_sp2.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16194_$_sp2.cljs$lang$applyTo = cljs$core$fn_16194_$_sp2__4.cljs$lang$applyTo;
cljs$core$fn_16194_$_sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16194_$_sp2__0;
cljs$core$fn_16194_$_sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16194_$_sp2__1;
cljs$core$fn_16194_$_sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16194_$_sp2__2;
cljs$core$fn_16194_$_sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16194_$_sp2__3;
cljs$core$fn_16194_$_sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16194_$_sp2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16194_$_sp2;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16196(p1,p2,p3){
return (function() {
var cljs$core$fn_16196_$_sp3 = null;
var cljs$core$fn_16196_$_sp3__0 = (function (){
return null;
});
var cljs$core$fn_16196_$_sp3__1 = (function (x){
var or__9584__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9584__auto__)){
return or__9584__auto__;
} else {
var or__9584__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__9584__auto____$1)){
return or__9584__auto____$1;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
}
}
});
var cljs$core$fn_16196_$_sp3__2 = (function (x,y){
var or__9584__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9584__auto__)){
return or__9584__auto__;
} else {
var or__9584__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__9584__auto____$1)){
return or__9584__auto____$1;
} else {
var or__9584__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__9584__auto____$2)){
return or__9584__auto____$2;
} else {
var or__9584__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__9584__auto____$3)){
return or__9584__auto____$3;
} else {
var or__9584__auto____$4 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__9584__auto____$4)){
return or__9584__auto____$4;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
}
}
}
}
}
});
var cljs$core$fn_16196_$_sp3__3 = (function (x,y,z){
var or__9584__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9584__auto__)){
return or__9584__auto__;
} else {
var or__9584__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__9584__auto____$1)){
return or__9584__auto____$1;
} else {
var or__9584__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__9584__auto____$2)){
return or__9584__auto____$2;
} else {
var or__9584__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__9584__auto____$3)){
return or__9584__auto____$3;
} else {
var or__9584__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__9584__auto____$4)){
return or__9584__auto____$4;
} else {
var or__9584__auto____$5 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(or__9584__auto____$5)){
return or__9584__auto____$5;
} else {
var or__9584__auto____$6 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__9584__auto____$6)){
return or__9584__auto____$6;
} else {
var or__9584__auto____$7 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(or__9584__auto____$7)){
return or__9584__auto____$7;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
}
}
}
}
}
}
}
}
});
var cljs$core$fn_16196_$_sp3__4 = (function() { 
var G__16218__delegate = function (x,y,z,args){
var or__9584__auto__ = cljs$core$fn_16196_$_sp3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__9584__auto__)){
return or__9584__auto__;
} else {
return cljs.core.some((function cljs$core$fn_16196_$_sp3_$_fn_16197(p1__16182_SHARP_){
var or__9584__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__16182_SHARP_) : p1.call(null,p1__16182_SHARP_));
if(cljs.core.truth_(or__9584__auto____$1)){
return or__9584__auto____$1;
} else {
var or__9584__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__16182_SHARP_) : p2.call(null,p1__16182_SHARP_));
if(cljs.core.truth_(or__9584__auto____$2)){
return or__9584__auto____$2;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__16182_SHARP_) : p3.call(null,p1__16182_SHARP_));
}
}
}),args);
}
};
var G__16218 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16219__i = 0, G__16219__a = new Array(arguments.length -  3);
while (G__16219__i < G__16219__a.length) {G__16219__a[G__16219__i] = arguments[G__16219__i + 3]; ++G__16219__i;}
  args = new cljs.core.IndexedSeq(G__16219__a,0,null);
} 
return G__16218__delegate.call(this,x,y,z,args);};
G__16218.cljs$lang$maxFixedArity = 3;
G__16218.cljs$lang$applyTo = (function (arglist__16220){
var x = cljs.core.first(arglist__16220);
arglist__16220 = cljs.core.next(arglist__16220);
var y = cljs.core.first(arglist__16220);
arglist__16220 = cljs.core.next(arglist__16220);
var z = cljs.core.first(arglist__16220);
var args = cljs.core.rest(arglist__16220);
return G__16218__delegate(x,y,z,args);
});
G__16218.cljs$core$IFn$_invoke$arity$variadic = G__16218__delegate;
return G__16218;
})()
;
cljs$core$fn_16196_$_sp3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16196_$_sp3__0.call(this);
case 1:
return cljs$core$fn_16196_$_sp3__1.call(this,x);
case 2:
return cljs$core$fn_16196_$_sp3__2.call(this,x,y);
case 3:
return cljs$core$fn_16196_$_sp3__3.call(this,x,y,z);
default:
var G__16221 = null;
if (arguments.length > 3) {
var G__16222__i = 0, G__16222__a = new Array(arguments.length -  3);
while (G__16222__i < G__16222__a.length) {G__16222__a[G__16222__i] = arguments[G__16222__i + 3]; ++G__16222__i;}
G__16221 = new cljs.core.IndexedSeq(G__16222__a,0,null);
}
return cljs$core$fn_16196_$_sp3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16221);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16196_$_sp3.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16196_$_sp3.cljs$lang$applyTo = cljs$core$fn_16196_$_sp3__4.cljs$lang$applyTo;
cljs$core$fn_16196_$_sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16196_$_sp3__0;
cljs$core$fn_16196_$_sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16196_$_sp3__1;
cljs$core$fn_16196_$_sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16196_$_sp3__2;
cljs$core$fn_16196_$_sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16196_$_sp3__3;
cljs$core$fn_16196_$_sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16196_$_sp3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16196_$_sp3;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16198(p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return (function() {
var cljs$core$fn_16198_$_spn = null;
var cljs$core$fn_16198_$_spn__0 = (function (){
return null;
});
var cljs$core$fn_16198_$_spn__1 = (function (x){
return cljs.core.some((function cljs$core$fn_16198_$_spn_$_fn_16199(p1__16183_SHARP_){
return (p1__16183_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16183_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16183_SHARP_.call(null,x));
}),ps__$1);
});
var cljs$core$fn_16198_$_spn__2 = (function (x,y){
return cljs.core.some((function cljs$core$fn_16198_$_spn_$_fn_16200(p1__16184_SHARP_){
var or__9584__auto__ = (p1__16184_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16184_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16184_SHARP_.call(null,x));
if(cljs.core.truth_(or__9584__auto__)){
return or__9584__auto__;
} else {
return (p1__16184_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16184_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__16184_SHARP_.call(null,y));
}
}),ps__$1);
});
var cljs$core$fn_16198_$_spn__3 = (function (x,y,z){
return cljs.core.some((function cljs$core$fn_16198_$_spn_$_fn_16201(p1__16185_SHARP_){
var or__9584__auto__ = (p1__16185_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16185_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16185_SHARP_.call(null,x));
if(cljs.core.truth_(or__9584__auto__)){
return or__9584__auto__;
} else {
var or__9584__auto____$1 = (p1__16185_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16185_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__16185_SHARP_.call(null,y));
if(cljs.core.truth_(or__9584__auto____$1)){
return or__9584__auto____$1;
} else {
return (p1__16185_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16185_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__16185_SHARP_.call(null,z));
}
}
}),ps__$1);
});
var cljs$core$fn_16198_$_spn__4 = (function() { 
var G__16223__delegate = function (x,y,z,args){
var or__9584__auto__ = cljs$core$fn_16198_$_spn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__9584__auto__)){
return or__9584__auto__;
} else {
return cljs.core.some((function cljs$core$fn_16198_$_spn_$_fn_16202(p1__16186_SHARP_){
return cljs.core.some(p1__16186_SHARP_,args);
}),ps__$1);
}
};
var G__16223 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16224__i = 0, G__16224__a = new Array(arguments.length -  3);
while (G__16224__i < G__16224__a.length) {G__16224__a[G__16224__i] = arguments[G__16224__i + 3]; ++G__16224__i;}
  args = new cljs.core.IndexedSeq(G__16224__a,0,null);
} 
return G__16223__delegate.call(this,x,y,z,args);};
G__16223.cljs$lang$maxFixedArity = 3;
G__16223.cljs$lang$applyTo = (function (arglist__16225){
var x = cljs.core.first(arglist__16225);
arglist__16225 = cljs.core.next(arglist__16225);
var y = cljs.core.first(arglist__16225);
arglist__16225 = cljs.core.next(arglist__16225);
var z = cljs.core.first(arglist__16225);
var args = cljs.core.rest(arglist__16225);
return G__16223__delegate(x,y,z,args);
});
G__16223.cljs$core$IFn$_invoke$arity$variadic = G__16223__delegate;
return G__16223;
})()
;
cljs$core$fn_16198_$_spn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16198_$_spn__0.call(this);
case 1:
return cljs$core$fn_16198_$_spn__1.call(this,x);
case 2:
return cljs$core$fn_16198_$_spn__2.call(this,x,y);
case 3:
return cljs$core$fn_16198_$_spn__3.call(this,x,y,z);
default:
var G__16226 = null;
if (arguments.length > 3) {
var G__16227__i = 0, G__16227__a = new Array(arguments.length -  3);
while (G__16227__i < G__16227__a.length) {G__16227__a[G__16227__i] = arguments[G__16227__i + 3]; ++G__16227__i;}
G__16226 = new cljs.core.IndexedSeq(G__16227__a,0,null);
}
return cljs$core$fn_16198_$_spn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16226);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16198_$_spn.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16198_$_spn.cljs$lang$applyTo = cljs$core$fn_16198_$_spn__4.cljs$lang$applyTo;
cljs$core$fn_16198_$_spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16198_$_spn__0;
cljs$core$fn_16198_$_spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16198_$_spn__1;
cljs$core$fn_16198_$_spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16198_$_spn__2;
cljs$core$fn_16198_$_spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16198_$_spn__3;
cljs$core$fn_16198_$_spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16198_$_spn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16198_$_spn;
})()
}));

/** @this {Function} */
(cljs.core.some_fn.cljs$lang$applyTo = (function cljs$core$fn_16203(seq16188){
var G__16189 = cljs.core.first(seq16188);
var seq16188__$1 = cljs.core.next(seq16188);
var G__16190 = cljs.core.first(seq16188__$1);
var seq16188__$2 = cljs.core.next(seq16188__$1);
var G__16191 = cljs.core.first(seq16188__$2);
var seq16188__$3 = cljs.core.next(seq16188__$2);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16189,G__16190,G__16191,seq16188__$3);
}));

(cljs.core.some_fn.cljs$lang$maxFixedArity = (3));

/**
 * Returns a lazy sequence consisting of the result of applying f to
 *   the set of first items of each coll, followed by applying f to the
 *   set of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments. Returns a transducer when
 *   no collection is provided.
 */
cljs.core.map = (function cljs$core$map(var_args){
var G__16235 = arguments.length;
switch (G__16235) {
case 1:
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.map.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___16261 = arguments.length;
var i__10914__auto___16262 = (0);
while(true){
if((i__10914__auto___16262 < len__10913__auto___16261)){
args_arr__10942__auto__.push((arguments[i__10914__auto___16262]));

var G__16263 = (i__10914__auto___16262 + (1));
i__10914__auto___16262 = G__16263;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((4) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((4)),(0),null)):null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10943__auto__);

}
});

(cljs.core.map.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16236(f){
return (function cljs$core$fn_16236_$_fn_16237(rf){
return (function() {
var cljs$core$fn_16236_$_fn_16237_$_fn_16238 = null;
var cljs$core$fn_16236_$_fn_16237_$_fn_16238__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16236_$_fn_16237_$_fn_16238__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16236_$_fn_16237_$_fn_16238__2 = (function (result,input){
var G__16239 = result;
var G__16240 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__16239,G__16240) : rf.call(null,G__16239,G__16240));
});
var cljs$core$fn_16236_$_fn_16237_$_fn_16238__3 = (function() { 
var G__16264__delegate = function (result,input,inputs){
var G__16241 = result;
var G__16242 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,input,inputs);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__16241,G__16242) : rf.call(null,G__16241,G__16242));
};
var G__16264 = function (result,input,var_args){
var inputs = null;
if (arguments.length > 2) {
var G__16265__i = 0, G__16265__a = new Array(arguments.length -  2);
while (G__16265__i < G__16265__a.length) {G__16265__a[G__16265__i] = arguments[G__16265__i + 2]; ++G__16265__i;}
  inputs = new cljs.core.IndexedSeq(G__16265__a,0,null);
} 
return G__16264__delegate.call(this,result,input,inputs);};
G__16264.cljs$lang$maxFixedArity = 2;
G__16264.cljs$lang$applyTo = (function (arglist__16266){
var result = cljs.core.first(arglist__16266);
arglist__16266 = cljs.core.next(arglist__16266);
var input = cljs.core.first(arglist__16266);
var inputs = cljs.core.rest(arglist__16266);
return G__16264__delegate(result,input,inputs);
});
G__16264.cljs$core$IFn$_invoke$arity$variadic = G__16264__delegate;
return G__16264;
})()
;
cljs$core$fn_16236_$_fn_16237_$_fn_16238 = function(result,input,var_args){
var inputs = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16236_$_fn_16237_$_fn_16238__0.call(this);
case 1:
return cljs$core$fn_16236_$_fn_16237_$_fn_16238__1.call(this,result);
case 2:
return cljs$core$fn_16236_$_fn_16237_$_fn_16238__2.call(this,result,input);
default:
var G__16267 = null;
if (arguments.length > 2) {
var G__16268__i = 0, G__16268__a = new Array(arguments.length -  2);
while (G__16268__i < G__16268__a.length) {G__16268__a[G__16268__i] = arguments[G__16268__i + 2]; ++G__16268__i;}
G__16267 = new cljs.core.IndexedSeq(G__16268__a,0,null);
}
return cljs$core$fn_16236_$_fn_16237_$_fn_16238__3.cljs$core$IFn$_invoke$arity$variadic(result,input, G__16267);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16236_$_fn_16237_$_fn_16238.cljs$lang$maxFixedArity = 2;
cljs$core$fn_16236_$_fn_16237_$_fn_16238.cljs$lang$applyTo = cljs$core$fn_16236_$_fn_16237_$_fn_16238__3.cljs$lang$applyTo;
cljs$core$fn_16236_$_fn_16237_$_fn_16238.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16236_$_fn_16237_$_fn_16238__0;
cljs$core$fn_16236_$_fn_16237_$_fn_16238.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16236_$_fn_16237_$_fn_16238__1;
cljs$core$fn_16236_$_fn_16237_$_fn_16238.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16236_$_fn_16237_$_fn_16238__2;
cljs$core$fn_16236_$_fn_16237_$_fn_16238.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16236_$_fn_16237_$_fn_16238__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16236_$_fn_16237_$_fn_16238;
})()
});
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16243(f,coll){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16243_$_fn_16244(){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__10672__auto___16269 = size;
var i_16270 = (0);
while(true){
if((i_16270 < n__10672__auto___16269)){
cljs.core.chunk_append(b,(function (){var G__16245 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_16270);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16245) : f.call(null,G__16245));
})());

var G__16271 = (i_16270 + (1));
i_16270 = G__16271;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__16246 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16246) : f.call(null,G__16246));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16247(f,c1,c2){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16247_$_fn_16248(){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if(((s1) && (s2))){
return cljs.core.cons((function (){var G__16249 = cljs.core.first(s1);
var G__16250 = cljs.core.first(s2);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16249,G__16250) : f.call(null,G__16249,G__16250));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,cljs.core.rest(s1),cljs.core.rest(s2)));
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16251(f,c1,c2,c3){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16251_$_fn_16252(){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
var s3 = cljs.core.seq(c3);
if(((s1) && (((s2) && (s3))))){
return cljs.core.cons((function (){var G__16253 = cljs.core.first(s1);
var G__16254 = cljs.core.first(s2);
var G__16255 = cljs.core.first(s3);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16253,G__16254,G__16255) : f.call(null,G__16253,G__16254,G__16255));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,cljs.core.rest(s1),cljs.core.rest(s2),cljs.core.rest(s3)));
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16256(f,c1,c2,c3,colls){
var step = (function cljs$core$fn_16256_$_step(cs){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16256_$_step_$_fn_16257(){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cs);
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs$core$fn_16256_$_step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function cljs$core$fn_16256_$_fn_16258(p1__16228_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,p1__16228_SHARP_);
}),step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c3,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c2,c1], 0))));
}));

/** @this {Function} */
(cljs.core.map.cljs$lang$applyTo = (function cljs$core$fn_16259(seq16230){
var G__16231 = cljs.core.first(seq16230);
var seq16230__$1 = cljs.core.next(seq16230);
var G__16232 = cljs.core.first(seq16230__$1);
var seq16230__$2 = cljs.core.next(seq16230__$1);
var G__16233 = cljs.core.first(seq16230__$2);
var seq16230__$3 = cljs.core.next(seq16230__$2);
var G__16234 = cljs.core.first(seq16230__$3);
var seq16230__$4 = cljs.core.next(seq16230__$3);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16231,G__16232,G__16233,G__16234,seq16230__$4);
}));

(cljs.core.map.cljs$lang$maxFixedArity = (4));

/**
 * Returns a lazy sequence of the first n items in coll, or all items if
 *   there are fewer than n.  Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.take = (function cljs$core$take(var_args){
var G__16273 = arguments.length;
switch (G__16273) {
case 1:
return cljs.core.take.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.take.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16274(n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function cljs$core$fn_16274_$_fn_16275(rf){
var na = cljs.core.volatile_BANG_(n);
return (function() {
var cljs$core$fn_16274_$_fn_16275_$_fn_16276 = null;
var cljs$core$fn_16274_$_fn_16275_$_fn_16276__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16274_$_fn_16275_$_fn_16276__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16274_$_fn_16275_$_fn_16276__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
var nn = na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));
var result__$1 = (((n__$1 > (0)))?(rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input)):result);
if((!((nn > (0))))){
return cljs.core.ensure_reduced(result__$1);
} else {
return result__$1;
}
});
cljs$core$fn_16274_$_fn_16275_$_fn_16276 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16274_$_fn_16275_$_fn_16276__0.call(this);
case 1:
return cljs$core$fn_16274_$_fn_16275_$_fn_16276__1.call(this,result);
case 2:
return cljs$core$fn_16274_$_fn_16275_$_fn_16276__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16274_$_fn_16275_$_fn_16276.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16274_$_fn_16275_$_fn_16276__0;
cljs$core$fn_16274_$_fn_16275_$_fn_16276.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16274_$_fn_16275_$_fn_16276__1;
cljs$core$fn_16274_$_fn_16275_$_fn_16276.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16274_$_fn_16275_$_fn_16276__2;
return cljs$core$fn_16274_$_fn_16275_$_fn_16276;
})()
});
}));

(cljs.core.take.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16277(n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (new cljs.core.LazySeq(null,(function cljs$core$fn_16277_$_fn_16278(){
if((n > (0))){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
return cljs.core.cons(cljs.core.first(s),cljs.core.take.cljs$core$IFn$_invoke$arity$2((n - (1)),cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.take.cljs$lang$maxFixedArity = 2);

/**
 * Returns a laziness-preserving sequence of all but the first n items in coll.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.drop = (function cljs$core$drop(var_args){
var G__16281 = arguments.length;
switch (G__16281) {
case 1:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16282(n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function cljs$core$fn_16282_$_fn_16283(rf){
var na = cljs.core.volatile_BANG_(n);
return (function() {
var cljs$core$fn_16282_$_fn_16283_$_fn_16284 = null;
var cljs$core$fn_16282_$_fn_16283_$_fn_16284__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16282_$_fn_16283_$_fn_16284__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16282_$_fn_16283_$_fn_16284__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));

if((n__$1 > (0))){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
cljs$core$fn_16282_$_fn_16283_$_fn_16284 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16282_$_fn_16283_$_fn_16284__0.call(this);
case 1:
return cljs$core$fn_16282_$_fn_16283_$_fn_16284__1.call(this,result);
case 2:
return cljs$core$fn_16282_$_fn_16283_$_fn_16284__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16282_$_fn_16283_$_fn_16284.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16282_$_fn_16283_$_fn_16284__0;
cljs$core$fn_16282_$_fn_16283_$_fn_16284.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16282_$_fn_16283_$_fn_16284__1;
cljs$core$fn_16282_$_fn_16283_$_fn_16284.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16282_$_fn_16283_$_fn_16284__2;
return cljs$core$fn_16282_$_fn_16283_$_fn_16284;
})()
});
}));

(cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16285(n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition1$ & (262144))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IDrop$))))?true:false):false)){
var or__9584__auto__ = (((n > (0)))?coll.cljs$core$IDrop$_drop$arity$2(null,Math.ceil(n)):cljs.core.seq(coll));
if(cljs.core.truth_(or__9584__auto__)){
return or__9584__auto__;
} else {
return cljs.core.List.EMPTY;
}
} else {
var step = (function cljs$core$fn_16285_$_fn_16287(n__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if((((n__$1 > (0))) && (s))){
var G__16290 = (n__$1 - (1));
var G__16291 = cljs.core.rest(s);
n__$1 = G__16290;
coll__$1 = G__16291;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16285_$_fn_16288(){
return step(n,coll);
}),null,null));
}
}));

(cljs.core.drop.cljs$lang$maxFixedArity = 2);

/**
 * Return a lazy sequence of all but the last n (default 1) items in coll
 */
cljs.core.drop_last = (function cljs$core$drop_last(var_args){
var G__16293 = arguments.length;
switch (G__16293) {
case 1:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16294(s){
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((1),s);
}));

(cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16295(n,s){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((function cljs$core$fn_16295_$_fn_16296(x,_){
return x;
}),s,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s));
}));

(cljs.core.drop_last.cljs$lang$maxFixedArity = 2);

/**
 * Returns a seq of the last n items in coll.  Depending on the type
 *   of coll may be no better than linear time.  For vectors, see also subvec.
 */
cljs.core.take_last = (function cljs$core$take_last(n,coll){
var s = cljs.core.seq(coll);
var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll));
while(true){
if(lead){
var G__16298 = cljs.core.next(s);
var G__16299 = cljs.core.next(lead);
s = G__16298;
lead = G__16299;
continue;
} else {
return s;
}
break;
}
});
/**
 * Returns a lazy sequence of the items in coll starting from the
 *   first item for which (pred item) returns logical false.  Returns a
 *   stateful transducer when no collection is provided.
 */
cljs.core.drop_while = (function cljs$core$drop_while(var_args){
var G__16301 = arguments.length;
switch (G__16301) {
case 1:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16302(pred){
return (function cljs$core$fn_16302_$_fn_16303(rf){
var da = cljs.core.volatile_BANG_(true);
return (function() {
var cljs$core$fn_16302_$_fn_16303_$_fn_16304 = null;
var cljs$core$fn_16302_$_fn_16303_$_fn_16304__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16302_$_fn_16303_$_fn_16304__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16302_$_fn_16303_$_fn_16304__2 = (function (result,input){
var drop_QMARK_ = cljs.core.deref(da);
if(cljs.core.truth_((function (){var and__9578__auto__ = drop_QMARK_;
if(cljs.core.truth_(and__9578__auto__)){
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input));
} else {
return and__9578__auto__;
}
})())){
return result;
} else {
cljs.core.vreset_BANG_(da,null);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
cljs$core$fn_16302_$_fn_16303_$_fn_16304 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16302_$_fn_16303_$_fn_16304__0.call(this);
case 1:
return cljs$core$fn_16302_$_fn_16303_$_fn_16304__1.call(this,result);
case 2:
return cljs$core$fn_16302_$_fn_16303_$_fn_16304__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16302_$_fn_16303_$_fn_16304.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16302_$_fn_16303_$_fn_16304__0;
cljs$core$fn_16302_$_fn_16303_$_fn_16304.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16302_$_fn_16303_$_fn_16304__1;
cljs$core$fn_16302_$_fn_16303_$_fn_16304.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16302_$_fn_16303_$_fn_16304__2;
return cljs$core$fn_16302_$_fn_16303_$_fn_16304;
})()
});
}));

(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16305(pred,coll){
var step = (function cljs$core$fn_16305_$_fn_16306(pred__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(cljs.core.truth_((function (){var and__9578__auto__ = s;
if(and__9578__auto__){
var G__16307 = cljs.core.first(s);
return (pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__16307) : pred__$1.call(null,G__16307));
} else {
return and__9578__auto__;
}
})())){
var G__16310 = pred__$1;
var G__16311 = cljs.core.rest(s);
pred__$1 = G__16310;
coll__$1 = G__16311;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16305_$_fn_16308(){
return step(pred,coll);
}),null,null));
}));

(cljs.core.drop_while.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Cycle = (function (meta,all,prev,current,_next){
this.meta = meta;
this.all = all;
this.prev = prev;
this.current = current;
this._next = _next;
this.cljs$lang$protocol_mask$partition0$ = 26083532;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.Cycle.prototype.toString = (function cljs$core$fn_16312(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Cycle.prototype.currentval = (function cljs$core$fn_16313(){
var self__ = this;
var coll = this;
if(self__.current){
} else {
var temp__5718__auto___16333 = cljs.core.next(self__.prev);
if(temp__5718__auto___16333){
var c_16334 = temp__5718__auto___16333;
(self__.current = c_16334);
} else {
(self__.current = self__.all);
}
}

return self__.current;
}));

(cljs.core.Cycle.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16314(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Cycle.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16315(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
}));

(cljs.core.Cycle.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16316(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Cycle.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function cljs$core$fn_16317(coll){
var self__ = this;
var coll__$1 = this;
return (!((self__.current == null)));
}));

(cljs.core.Cycle.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16318(coll,f){
var self__ = this;
var coll__$1 = this;
var s = coll__$1.currentval();
var ret = cljs.core.first(s);
while(true){
var s__$1 = (function (){var or__9584__auto__ = cljs.core.next(s);
if(or__9584__auto__){
return or__9584__auto__;
} else {
return self__.all;
}
})();
var ret__$1 = (function (){var G__16321 = ret;
var G__16322 = cljs.core.first(s__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16321,G__16322) : f.call(null,G__16321,G__16322));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__16335 = s__$1;
var G__16336 = ret__$1;
s = G__16335;
ret = G__16336;
continue;
}
break;
}
}));

(cljs.core.Cycle.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16323(coll,f,start){
var self__ = this;
var coll__$1 = this;
var s = coll__$1.currentval();
var ret = start;
while(true){
var ret__$1 = (function (){var G__16324 = ret;
var G__16325 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16324,G__16325) : f.call(null,G__16324,G__16325));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__16337 = (function (){var or__9584__auto__ = cljs.core.next(s);
if(or__9584__auto__){
return or__9584__auto__;
} else {
return self__.all;
}
})();
var G__16338 = ret__$1;
s = G__16337;
ret = G__16338;
continue;
}
break;
}
}));

(cljs.core.Cycle.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16326(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(coll__$1.currentval());
}));

(cljs.core.Cycle.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16327(coll){
var self__ = this;
var coll__$1 = this;
if((self__._next == null)){
(self__._next = (new cljs.core.Cycle(null,self__.all,coll__$1.currentval(),null,null)));
} else {
}

return self__._next;
}));

(cljs.core.Cycle.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16328(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Cycle.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16329(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Cycle(new_meta,self__.all,self__.prev,self__.current,self__._next));
}
}));

(cljs.core.Cycle.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16330(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.Cycle.getBasis = (function cljs$core$fn_16331(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"all","all",-1762306027,null),new cljs.core.Symbol(null,"prev","prev",43462301,null),cljs.core.with_meta(new cljs.core.Symbol(null,"current","current",552492924,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Cycle.cljs$lang$type = true);

(cljs.core.Cycle.cljs$lang$ctorStr = "cljs.core/Cycle");

(cljs.core.Cycle.cljs$lang$ctorPrWriter = (function cljs$core$fn_16332(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/Cycle");
}));

/**
 * Positional factory function for cljs.core/Cycle.
 */
cljs.core.__GT_Cycle = (function cljs$core$__GT_Cycle(meta,all,prev,current,_next){
return (new cljs.core.Cycle(meta,all,prev,current,_next));
});

/**
 * Returns a lazy (infinite!) sequence of repetitions of the items in coll.
 */
cljs.core.cycle = (function cljs$core$cycle(coll){
var temp__5718__auto__ = cljs.core.seq(coll);
if(temp__5718__auto__){
var vals = temp__5718__auto__;
return (new cljs.core.Cycle(null,vals,null,vals,null));
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a vector of [(take n coll) (drop n coll)]
 */
cljs.core.split_at = (function cljs$core$split_at(n,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll),cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll)], null);
});

/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Repeat = (function (meta,count,val,next,__hash){
this.meta = meta;
this.count = count;
this.val = val;
this.next = next;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 262145;
});
(cljs.core.Repeat.prototype.toString = (function cljs$core$fn_16339(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Repeat.prototype.equiv = (function cljs$core$fn_16340(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Repeat.prototype.indexOf = (function() {
var cljs$core$fn_16341 = null;
var cljs$core$fn_16341__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16341__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16341 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16341__1.call(this,x);
case 2:
return cljs$core$fn_16341__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16341.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16341__1;
cljs$core$fn_16341.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16341__2;
return cljs$core$fn_16341;
})()
);

(cljs.core.Repeat.prototype.lastIndexOf = (function() {
var cljs$core$fn_16342 = null;
var cljs$core$fn_16342__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,self__.count);
});
var cljs$core$fn_16342__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16342 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16342__1.call(this,x);
case 2:
return cljs$core$fn_16342__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16342.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16342__1;
cljs$core$fn_16342.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16342__2;
return cljs$core$fn_16342;
})()
);

(cljs.core.Repeat.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16343(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Repeat.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16344(coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
if((self__.count > (1))){
(self__.next = (new cljs.core.Repeat(null,(self__.count - (1)),self__.val,null,null)));

return self__.next;
} else {
if(((-1) === self__.count)){
return coll__$1;
} else {
return null;
}
}
} else {
return self__.next;
}
}));

(cljs.core.Repeat.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16345(coll){
var self__ = this;
var coll__$1 = this;
var h__10045__auto__ = self__.__hash;
if((!((h__10045__auto__ == null)))){
return h__10045__auto__;
} else {
var h__10045__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10045__auto____$1);

return h__10045__auto____$1;
}
}));

(cljs.core.Repeat.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16346(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.Repeat.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16347(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Repeat.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function cljs$core$fn_16348(coll){
var self__ = this;
var coll__$1 = this;
return false;
}));

(cljs.core.Repeat.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16349(coll,f){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
var ret = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(self__.val,self__.val) : f.call(null,self__.val,self__.val));
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var G__16359 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
ret = G__16359;
continue;
}
break;
}
} else {
var i = (1);
var ret = self__.val;
while(true){
if((i < self__.count)){
var ret__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__16360 = (i + (1));
var G__16361 = ret__$1;
i = G__16360;
ret = G__16361;
continue;
}
} else {
return ret;
}
break;
}
}
}));

(cljs.core.Repeat.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16350(coll,f,start){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
var ret = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(start,self__.val) : f.call(null,start,self__.val));
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var G__16362 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
ret = G__16362;
continue;
}
break;
}
} else {
var i = (0);
var ret = start;
while(true){
if((i < self__.count)){
var ret__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__16363 = (i + (1));
var G__16364 = ret__$1;
i = G__16363;
ret = G__16364;
continue;
}
} else {
return ret;
}
break;
}
}
}));

(cljs.core.Repeat.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16351(coll){
var self__ = this;
var coll__$1 = this;
return self__.val;
}));

(cljs.core.Repeat.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16352(coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
if((self__.count > (1))){
(self__.next = (new cljs.core.Repeat(null,(self__.count - (1)),self__.val,null,null)));

return self__.next;
} else {
if(((-1) === self__.count)){
return coll__$1;
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return self__.next;
}
}));

(cljs.core.Repeat.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16353(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Repeat.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16354(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Repeat(new_meta,self__.count,self__.val,self__.next,null));
}
}));

(cljs.core.Repeat.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16355(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.Repeat.prototype.cljs$core$IDrop$_drop$arity$2 = (function cljs$core$fn_16356(coll,n){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
return coll__$1;
} else {
var dropped_count = (self__.count - n);
if((dropped_count > (0))){
return (new cljs.core.Repeat(null,dropped_count,self__.val,null,null));
} else {
return null;
}
}
}));

(cljs.core.Repeat.getBasis = (function cljs$core$fn_16357(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.with_meta(new cljs.core.Symbol(null,"next","next",1522830042,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Repeat.cljs$lang$type = true);

(cljs.core.Repeat.cljs$lang$ctorStr = "cljs.core/Repeat");

(cljs.core.Repeat.cljs$lang$ctorPrWriter = (function cljs$core$fn_16358(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/Repeat");
}));

/**
 * Positional factory function for cljs.core/Repeat.
 */
cljs.core.__GT_Repeat = (function cljs$core$__GT_Repeat(meta,count,val,next,__hash){
return (new cljs.core.Repeat(meta,count,val,next,__hash));
});

/**
 * Returns a lazy (infinite!, or length n if supplied) sequence of xs.
 */
cljs.core.repeat = (function cljs$core$repeat(var_args){
var G__16366 = arguments.length;
switch (G__16366) {
case 1:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16367(x){
return (new cljs.core.Repeat(null,(-1),x,null,null));
}));

(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16368(n,x){
if((n > (0))){
return (new cljs.core.Repeat(null,n,x,null,null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.repeat.cljs$lang$maxFixedArity = 2);

/**
 * DEPRECATED: Use 'repeat' instead.
 *   Returns a lazy seq of n xs.
 */
cljs.core.replicate = (function cljs$core$replicate(n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});
/**
 * Takes a function of no args, presumably with side effects, and
 *   returns an infinite (or length n if supplied) lazy sequence of calls
 *   to it
 */
cljs.core.repeatedly = (function cljs$core$repeatedly(var_args){
var G__16371 = arguments.length;
switch (G__16371) {
case 1:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16372(f){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16372_$_fn_16373(){
return cljs.core.cons((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}),null,null));
}));

(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16374(n,f){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}));

(cljs.core.repeatedly.cljs$lang$maxFixedArity = 2);

cljs.core.UNREALIZED_SEED = ({});

/**
* @constructor
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Iterate = (function (meta,f,prev_seed,seed,next){
this.meta = meta;
this.f = f;
this.prev_seed = prev_seed;
this.seed = seed;
this.next = next;
this.cljs$lang$protocol_mask$partition0$ = 26083532;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.Iterate.prototype.toString = (function cljs$core$fn_16376(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Iterate.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16377(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Iterate.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16378(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
}));

(cljs.core.Iterate.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16379(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Iterate.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function cljs$core$fn_16380(coll){
var self__ = this;
var coll__$1 = this;
return (!((self__.seed === cljs.core.UNREALIZED_SEED)));
}));

(cljs.core.Iterate.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16381(coll,rf){
var self__ = this;
var coll__$1 = this;
var first = coll__$1.cljs$core$ISeq$_first$arity$1(null);
var v = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(first) : self__.f.call(null,first));
var ret = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(first,v) : rf.call(null,first,v));
var v__$1 = v;
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var v__$2 = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(v__$1) : self__.f.call(null,v__$1));
var G__16390 = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(ret,v__$2) : rf.call(null,ret,v__$2));
var G__16391 = v__$2;
ret = G__16390;
v__$1 = G__16391;
continue;
}
break;
}
}));

(cljs.core.Iterate.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16382(coll,rf,start){
var self__ = this;
var coll__$1 = this;
var v = coll__$1.cljs$core$ISeq$_first$arity$1(null);
var ret = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(start,v) : rf.call(null,start,v));
var v__$1 = v;
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var v__$2 = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(v__$1) : self__.f.call(null,v__$1));
var G__16392 = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(ret,v__$2) : rf.call(null,ret,v__$2));
var G__16393 = v__$2;
ret = G__16392;
v__$1 = G__16393;
continue;
}
break;
}
}));

(cljs.core.Iterate.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16383(coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.UNREALIZED_SEED === self__.seed)){
(self__.seed = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(self__.prev_seed) : self__.f.call(null,self__.prev_seed)));
} else {
}

return self__.seed;
}));

(cljs.core.Iterate.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16384(coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
(self__.next = (new cljs.core.Iterate(null,self__.f,coll__$1.cljs$core$ISeq$_first$arity$1(null),cljs.core.UNREALIZED_SEED,null)));
} else {
}

return self__.next;
}));

(cljs.core.Iterate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16385(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Iterate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16386(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Iterate(new_meta,self__.f,self__.prev_seed,self__.seed,self__.next));
}
}));

(cljs.core.Iterate.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16387(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.Iterate.getBasis = (function cljs$core$fn_16388(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"prev-seed","prev-seed",2126381367,null),cljs.core.with_meta(new cljs.core.Symbol(null,"seed","seed",1709144854,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next","next",1522830042,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Iterate.cljs$lang$type = true);

(cljs.core.Iterate.cljs$lang$ctorStr = "cljs.core/Iterate");

(cljs.core.Iterate.cljs$lang$ctorPrWriter = (function cljs$core$fn_16389(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/Iterate");
}));

/**
 * Positional factory function for cljs.core/Iterate.
 */
cljs.core.__GT_Iterate = (function cljs$core$__GT_Iterate(meta,f,prev_seed,seed,next){
return (new cljs.core.Iterate(meta,f,prev_seed,seed,next));
});

/**
 * Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects
 */
cljs.core.iterate = (function cljs$core$iterate(f,x){
return (new cljs.core.Iterate(null,f,null,x,null));
});
/**
 * Returns a lazy seq of the first item in each coll, then the second etc.
 */
cljs.core.interleave = (function cljs$core$interleave(var_args){
var G__16398 = arguments.length;
switch (G__16398) {
case 0:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___16408 = arguments.length;
var i__10914__auto___16409 = (0);
while(true){
if((i__10914__auto___16409 < len__10913__auto___16408)){
args_arr__10942__auto__.push((arguments[i__10914__auto___16409]));

var G__16410 = (i__10914__auto___16409 + (1));
i__10914__auto___16409 = G__16410;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((2) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((2)),(0),null)):null);
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10943__auto__);

}
});

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_16399(){
return cljs.core.List.EMPTY;
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16400(c1){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16400_$_fn_16401(){
return c1;
}),null,null));
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16402(c1,c2){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16402_$_fn_16403(){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if(((s1) && (s2))){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
return null;
}
}),null,null));
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16404(c1,c2,colls){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16404_$_fn_16405(){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c1], 0)));
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
}));

/** @this {Function} */
(cljs.core.interleave.cljs$lang$applyTo = (function cljs$core$fn_16406(seq16395){
var G__16396 = cljs.core.first(seq16395);
var seq16395__$1 = cljs.core.next(seq16395);
var G__16397 = cljs.core.first(seq16395__$1);
var seq16395__$2 = cljs.core.next(seq16395__$1);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16396,G__16397,seq16395__$2);
}));

(cljs.core.interleave.cljs$lang$maxFixedArity = (2));

/**
 * Returns a lazy seq of the elements of coll separated by sep.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.interpose = (function cljs$core$interpose(var_args){
var G__16412 = arguments.length;
switch (G__16412) {
case 1:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16413(sep){
return (function cljs$core$fn_16413_$_fn_16414(rf){
var started = cljs.core.volatile_BANG_(false);
return (function() {
var cljs$core$fn_16413_$_fn_16414_$_fn_16415 = null;
var cljs$core$fn_16413_$_fn_16414_$_fn_16415__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16413_$_fn_16414_$_fn_16415__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16413_$_fn_16414_$_fn_16415__2 = (function (result,input){
if(cljs.core.truth_(cljs.core.deref(started))){
var sepr = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,sep) : rf.call(null,result,sep));
if(cljs.core.reduced_QMARK_(sepr)){
return sepr;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(sepr,input) : rf.call(null,sepr,input));
}
} else {
cljs.core.vreset_BANG_(started,true);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
cljs$core$fn_16413_$_fn_16414_$_fn_16415 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16413_$_fn_16414_$_fn_16415__0.call(this);
case 1:
return cljs$core$fn_16413_$_fn_16414_$_fn_16415__1.call(this,result);
case 2:
return cljs$core$fn_16413_$_fn_16414_$_fn_16415__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16413_$_fn_16414_$_fn_16415.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16413_$_fn_16414_$_fn_16415__0;
cljs$core$fn_16413_$_fn_16414_$_fn_16415.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16413_$_fn_16414_$_fn_16415__1;
cljs$core$fn_16413_$_fn_16414_$_fn_16415.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16413_$_fn_16414_$_fn_16415__2;
return cljs$core$fn_16413_$_fn_16414_$_fn_16415;
})()
});
}));

(cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16416(sep,coll){
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep),coll));
}));

(cljs.core.interpose.cljs$lang$maxFixedArity = 2);

/**
 * Take a collection of collections, and return a lazy seq
 *   of items from the inner collection
 */
cljs.core.flatten1 = (function cljs$core$flatten1(colls){
var cat = (function cljs$core$flatten1_$_cat(coll,colls__$1){
return (new cljs.core.LazySeq(null,(function cljs$core$flatten1_$_cat_$_fn_16418(){
var temp__5718__auto__ = cljs.core.seq(coll);
if(temp__5718__auto__){
var coll__$1 = temp__5718__auto__;
return cljs.core.cons(cljs.core.first(coll__$1),cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1),colls__$1));
} else {
if(cljs.core.seq(colls__$1)){
return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1),cljs.core.rest(colls__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(null,colls);
});
/**
 * Returns the result of applying concat to the result of applying map
 *   to f and colls.  Thus function f should return a collection. Returns
 *   a transducer when no collections are provided
 */
cljs.core.mapcat = (function cljs$core$mapcat(var_args){
var G__16422 = arguments.length;
switch (G__16422) {
case 1:
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___16427 = arguments.length;
var i__10914__auto___16428 = (0);
while(true){
if((i__10914__auto___16428 < len__10913__auto___16427)){
args_arr__10942__auto__.push((arguments[i__10914__auto___16428]));

var G__16429 = (i__10914__auto___16428 + (1));
i__10914__auto___16428 = G__16429;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((1) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((1)),(0),null)):null);
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10943__auto__);

}
});

(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16423(f){
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f),cljs.core.cat);
}));

(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16424(f,colls){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map,f,colls));
}));

/** @this {Function} */
(cljs.core.mapcat.cljs$lang$applyTo = (function cljs$core$fn_16425(seq16420){
var G__16421 = cljs.core.first(seq16420);
var seq16420__$1 = cljs.core.next(seq16420);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16421,seq16420__$1);
}));

(cljs.core.mapcat.cljs$lang$maxFixedArity = (1));

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns logical true. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.filter = (function cljs$core$filter(var_args){
var G__16431 = arguments.length;
switch (G__16431) {
case 1:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16432(pred){
return (function cljs$core$fn_16432_$_fn_16433(rf){
return (function() {
var cljs$core$fn_16432_$_fn_16433_$_fn_16434 = null;
var cljs$core$fn_16432_$_fn_16433_$_fn_16434__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16432_$_fn_16433_$_fn_16434__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16432_$_fn_16433_$_fn_16434__2 = (function (result,input){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input)))){
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
} else {
return result;
}
});
cljs$core$fn_16432_$_fn_16433_$_fn_16434 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16432_$_fn_16433_$_fn_16434__0.call(this);
case 1:
return cljs$core$fn_16432_$_fn_16433_$_fn_16434__1.call(this,result);
case 2:
return cljs$core$fn_16432_$_fn_16433_$_fn_16434__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16432_$_fn_16433_$_fn_16434.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16432_$_fn_16433_$_fn_16434__0;
cljs$core$fn_16432_$_fn_16433_$_fn_16434.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16432_$_fn_16433_$_fn_16434__1;
cljs$core$fn_16432_$_fn_16433_$_fn_16434.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16432_$_fn_16433_$_fn_16434__2;
return cljs$core$fn_16432_$_fn_16433_$_fn_16434;
})()
});
}));

(cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16435(pred,coll){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16435_$_fn_16436(){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__10672__auto___16439 = size;
var i_16440 = (0);
while(true){
if((i_16440 < n__10672__auto___16439)){
if(cljs.core.truth_((function (){var G__16437 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_16440);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__16437) : pred.call(null,G__16437));
})())){
cljs.core.chunk_append(b,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_16440));
} else {
}

var G__16441 = (i_16440 + (1));
i_16440 = G__16441;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.chunk_rest(s)));
} else {
var f = cljs.core.first(s);
var r = cljs.core.rest(s);
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(f) : pred.call(null,f)))){
return cljs.core.cons(f,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r));
} else {
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r);
}
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.filter.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns logical false. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.remove = (function cljs$core$remove(var_args){
var G__16443 = arguments.length;
switch (G__16443) {
case 1:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16444(pred){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
}));

(cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16445(pred,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred),coll);
}));

(cljs.core.remove.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the nodes in a tree, via a depth-first walk.
 *   branch? must be a fn of one arg that returns true if passed a node
 *   that can have children (but may not).  children must be a fn of one
 *   arg that returns a sequence of the children. Will only be called on
 *   nodes for which branch? returns true. Root is the root node of the
 *   tree.
 */
cljs.core.tree_seq = (function cljs$core$tree_seq(branch_QMARK_,children,root){
var walk = (function cljs$core$tree_seq_$_walk(node){
return (new cljs.core.LazySeq(null,(function cljs$core$tree_seq_$_walk_$_fn_16447(){
return cljs.core.cons(node,(cljs.core.truth_((branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(node) : branch_QMARK_.call(null,node)))?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(node) : children.call(null,node))], 0)):null));
}),null,null));
});
return walk(root);
});
/**
 * Takes any nested combination of sequential things (lists, vectors,
 *   etc.) and returns their contents as a single, flat sequence.
 *   (flatten nil) returns nil.
 */
cljs.core.flatten = (function cljs$core$flatten(x){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function cljs$core$flatten_$_fn_16449(p1__16448_SHARP_){
return (!(cljs.core.sequential_QMARK_(p1__16448_SHARP_)));
}),cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_,cljs.core.seq,x)));
});
/**
 * Returns a new coll consisting of to-coll with all of the items of
 *   from-coll conjoined. A transducer may be supplied.
 */
cljs.core.into = (function cljs$core$into(var_args){
var G__16451 = arguments.length;
switch (G__16451) {
case 0:
return cljs.core.into.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.into.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.into.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.into.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_16452(){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16453(to){
return to;
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16454(to,from){
if((!((to == null)))){
if((((!((to == null))))?(((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$))))?true:false):false)){
return cljs.core._with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,to,from);
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,to,from);
}
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16456(to,xform,from){
if((((!((to == null))))?(((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$))))?true:false):false)){
var tm = cljs.core.meta(to);
var rf = (function() {
var cljs$core$fn_16456_$_fn_16458 = null;
var cljs$core$fn_16456_$_fn_16458__1 = (function (coll){
return cljs.core._with_meta(cljs.core.persistent_BANG_(coll),tm);
});
var cljs$core$fn_16456_$_fn_16458__2 = (function (coll,v){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(coll,v);
});
cljs$core$fn_16456_$_fn_16458 = function(coll,v){
switch(arguments.length){
case 1:
return cljs$core$fn_16456_$_fn_16458__1.call(this,coll);
case 2:
return cljs$core$fn_16456_$_fn_16458__2.call(this,coll,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16456_$_fn_16458.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16456_$_fn_16458__1;
cljs$core$fn_16456_$_fn_16458.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16456_$_fn_16458__2;
return cljs$core$fn_16456_$_fn_16458;
})()
;
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,rf,cljs.core.transient$(to),from);
} else {
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj,to,from);
}
}));

(cljs.core.into.cljs$lang$maxFixedArity = 3);

/**
 * Returns a vector consisting of the result of applying f to the
 *   set of first items of each coll, followed by applying f to the set
 *   of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments.
 */
cljs.core.mapv = (function cljs$core$mapv(var_args){
var G__16466 = arguments.length;
switch (G__16466) {
case 2:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___16474 = arguments.length;
var i__10914__auto___16475 = (0);
while(true){
if((i__10914__auto___16475 < len__10913__auto___16474)){
args_arr__10942__auto__.push((arguments[i__10914__auto___16475]));

var G__16476 = (i__10914__auto___16475 + (1));
i__10914__auto___16475 = G__16476;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((4) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((4)),(0),null)):null);
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10943__auto__);

}
});

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16467(f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function cljs$core$fn_16467_$_fn_16468(v,o){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(o) : f.call(null,o)));
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16469(f,c1,c2){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,c1,c2));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16470(f,c1,c2,c3){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,c1,c2,c3));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16471(f,c1,c2,c3,colls){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,f,c1,c2,c3,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([colls], 0)));
}));

/** @this {Function} */
(cljs.core.mapv.cljs$lang$applyTo = (function cljs$core$fn_16472(seq16461){
var G__16462 = cljs.core.first(seq16461);
var seq16461__$1 = cljs.core.next(seq16461);
var G__16463 = cljs.core.first(seq16461__$1);
var seq16461__$2 = cljs.core.next(seq16461__$1);
var G__16464 = cljs.core.first(seq16461__$2);
var seq16461__$3 = cljs.core.next(seq16461__$2);
var G__16465 = cljs.core.first(seq16461__$3);
var seq16461__$4 = cljs.core.next(seq16461__$3);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16462,G__16463,G__16464,G__16465,seq16461__$4);
}));

(cljs.core.mapv.cljs$lang$maxFixedArity = (4));

/**
 * Returns a vector of the items in coll for which
 *   (pred item) returns logical true. pred must be free of side-effects.
 */
cljs.core.filterv = (function cljs$core$filterv(pred,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function cljs$core$filterv_$_fn_16477(v,o){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(o) : pred.call(null,o)))){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,o);
} else {
return v;
}
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
/**
 * Returns a lazy sequence of lists of n items each, at offsets step
 *   apart. If step is not supplied, defaults to n, i.e. the partitions
 *   do not overlap. If a pad collection is supplied, use its elements as
 *   necessary to complete last partition up to n items. In case there are
 *   not enough padding elements, return a partition with less than n items.
 */
cljs.core.partition = (function cljs$core$partition(var_args){
var G__16479 = arguments.length;
switch (G__16479) {
case 2:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16480(n,coll){
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,n,coll);
}));

(cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16481(n,step,coll){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16481_$_fn_16482(){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16483(n,step,pad,coll){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16483_$_fn_16484(){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n,step,pad,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return (new cljs.core.List(null,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p,pad)),null,(1),null));
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.partition.cljs$lang$maxFixedArity = 4);

/**
 * Returns the value in a nested associative structure,
 *   where ks is a sequence of keys. Returns nil if the key is not present,
 *   or the not-found value if supplied.
 */
cljs.core.get_in = (function cljs$core$get_in(var_args){
var G__16487 = arguments.length;
switch (G__16487) {
case 2:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16488(m,ks){
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if((ks__$1 == null)){
return m__$1;
} else {
var G__16491 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m__$1,cljs.core.first(ks__$1));
var G__16492 = cljs.core.next(ks__$1);
m__$1 = G__16491;
ks__$1 = G__16492;
continue;
}
break;
}
}));

(cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16489(m,ks,not_found){
var sentinel = cljs.core.lookup_sentinel;
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if((!((ks__$1 == null)))){
var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.first(ks__$1),sentinel);
if((sentinel === m__$2)){
return not_found;
} else {
var G__16493 = sentinel;
var G__16494 = m__$2;
var G__16495 = cljs.core.next(ks__$1);
sentinel = G__16493;
m__$1 = G__16494;
ks__$1 = G__16495;
continue;
}
} else {
return m__$1;
}
break;
}
}));

(cljs.core.get_in.cljs$lang$maxFixedArity = 3);

/**
 * Associates a value in a nested associative structure, where ks is a
 *   sequence of keys and v is the new value and returns a new nested structure.
 *   If any levels do not exist, hash-maps will be created.
 */
cljs.core.assoc_in = (function cljs$core$assoc_in(m,p__16496,v){
var vec__16497 = p__16496;
var seq__16498 = cljs.core.seq(vec__16497);
var first__16499 = cljs.core.first(seq__16498);
var seq__16498__$1 = cljs.core.next(seq__16498);
var k = first__16499;
var ks = seq__16498__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16500 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16501 = ks;
var G__16502 = v;
return (cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3 ? cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3(G__16500,G__16501,G__16502) : cljs.core.assoc_in.call(null,G__16500,G__16501,G__16502));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
/**
 * 'Updates' a value in a nested associative structure, where ks is a
 *   sequence of keys and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   nested structure.  If any levels do not exist, hash-maps will be
 *   created.
 */
cljs.core.update_in = (function cljs$core$update_in(var_args){
var G__16511 = arguments.length;
switch (G__16511) {
case 3:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___16549 = arguments.length;
var i__10914__auto___16550 = (0);
while(true){
if((i__10914__auto___16550 < len__10913__auto___16549)){
args_arr__10942__auto__.push((arguments[i__10914__auto___16550]));

var G__16551 = (i__10914__auto___16550 + (1));
i__10914__auto___16550 = G__16551;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((6) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((6)),(0),null)):null);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__10943__auto__);

}
});

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16513(m,p__16512,f){
var vec__16514 = p__16512;
var seq__16515 = cljs.core.seq(vec__16514);
var first__16516 = cljs.core.first(seq__16515);
var seq__16515__$1 = cljs.core.next(seq__16515);
var k = first__16516;
var ks = seq__16515__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16517 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16517) : f.call(null,G__16517));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16519(m,p__16518,f,a){
var vec__16520 = p__16518;
var seq__16521 = cljs.core.seq(vec__16520);
var first__16522 = cljs.core.first(seq__16521);
var seq__16521__$1 = cljs.core.next(seq__16521);
var k = first__16522;
var ks = seq__16521__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16523 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16524 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16523,G__16524) : f.call(null,G__16523,G__16524));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_16526(m,p__16525,f,a,b){
var vec__16527 = p__16525;
var seq__16528 = cljs.core.seq(vec__16527);
var first__16529 = cljs.core.first(seq__16528);
var seq__16528__$1 = cljs.core.next(seq__16528);
var k = first__16529;
var ks = seq__16528__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16530 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16531 = a;
var G__16532 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16530,G__16531,G__16532) : f.call(null,G__16530,G__16531,G__16532));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_16534(m,p__16533,f,a,b,c){
var vec__16535 = p__16533;
var seq__16536 = cljs.core.seq(vec__16535);
var first__16537 = cljs.core.first(seq__16536);
var seq__16536__$1 = cljs.core.next(seq__16536);
var k = first__16537;
var ks = seq__16536__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b,c));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16538 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16539 = a;
var G__16540 = b;
var G__16541 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__16538,G__16539,G__16540,G__16541) : f.call(null,G__16538,G__16539,G__16540,G__16541));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16543(m,p__16542,f,a,b,c,args){
var vec__16544 = p__16542;
var seq__16545 = cljs.core.seq(vec__16544);
var first__16546 = cljs.core.first(seq__16545);
var seq__16545__$1 = cljs.core.next(seq__16545);
var k = first__16546;
var ks = seq__16545__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([b,c,args], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),a,b,c,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0)));
}
}));

/** @this {Function} */
(cljs.core.update_in.cljs$lang$applyTo = (function cljs$core$fn_16547(seq16504){
var G__16505 = cljs.core.first(seq16504);
var seq16504__$1 = cljs.core.next(seq16504);
var G__16506 = cljs.core.first(seq16504__$1);
var seq16504__$2 = cljs.core.next(seq16504__$1);
var G__16507 = cljs.core.first(seq16504__$2);
var seq16504__$3 = cljs.core.next(seq16504__$2);
var G__16508 = cljs.core.first(seq16504__$3);
var seq16504__$4 = cljs.core.next(seq16504__$3);
var G__16509 = cljs.core.first(seq16504__$4);
var seq16504__$5 = cljs.core.next(seq16504__$4);
var G__16510 = cljs.core.first(seq16504__$5);
var seq16504__$6 = cljs.core.next(seq16504__$5);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16505,G__16506,G__16507,G__16508,G__16509,G__16510,seq16504__$6);
}));

(cljs.core.update_in.cljs$lang$maxFixedArity = (6));

/**
 * 'Updates' a value in an associative structure, where k is a
 *   key and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   structure.  If the key does not exist, nil is passed as the old value.
 */
cljs.core.update = (function cljs$core$update(var_args){
var G__16560 = arguments.length;
switch (G__16560) {
case 3:
return cljs.core.update.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__10942__auto__ = [];
var len__10913__auto___16578 = arguments.length;
var i__10914__auto___16579 = (0);
while(true){
if((i__10914__auto___16579 < len__10913__auto___16578)){
args_arr__10942__auto__.push((arguments[i__10914__auto___16579]));

var G__16580 = (i__10914__auto___16579 + (1));
i__10914__auto___16579 = G__16580;
continue;
} else {
}
break;
}

var argseq__10943__auto__ = ((((6) < args_arr__10942__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10942__auto__.slice((6)),(0),null)):null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__10943__auto__);

}
});

(cljs.core.update.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16561(m,k,f){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16562 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16562) : f.call(null,G__16562));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16563(m,k,f,x){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16564 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16565 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16564,G__16565) : f.call(null,G__16564,G__16565));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_16566(m,k,f,x,y){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16567 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16568 = x;
var G__16569 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16567,G__16568,G__16569) : f.call(null,G__16567,G__16568,G__16569));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_16570(m,k,f,x,y,z){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16571 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16572 = x;
var G__16573 = y;
var G__16574 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__16571,G__16572,G__16573,G__16574) : f.call(null,G__16571,G__16572,G__16573,G__16574));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16575(m,k,f,x,y,z,more){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),x,y,z,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([more], 0)));
}));

/** @this {Function} */
(cljs.core.update.cljs$lang$applyTo = (function cljs$core$fn_16576(seq16553){
var G__16554 = cljs.core.first(seq16553);
var seq16553__$1 = cljs.core.next(seq16553);
var G__16555 = cljs.core.first(seq16553__$1);
var seq16553__$2 = cljs.core.next(seq16553__$1);
var G__16556 = cljs.core.first(seq16553__$2);
var seq16553__$3 = cljs.core.next(seq16553__$2);
var G__16557 = cljs.core.first(seq16553__$3);
var seq16553__$4 = cljs.core.next(seq16553__$3);
var G__16558 = cljs.core.first(seq16553__$4);
var seq16553__$5 = cljs.core.next(seq16553__$4);
var G__16559 = cljs.core.first(seq16553__$5);
var seq16553__$6 = cljs.core.next(seq16553__$5);
var self__10898__auto__ = this;
return self__10898__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16554,G__16555,G__16556,G__16557,G__16558,G__16559,seq16553__$6);
}));

(cljs.core.update.cljs$lang$maxFixedArity = (6));


/**
* @constructor
*/
cljs.core.VectorNode = (function (edit,arr){
this.edit = edit;
this.arr = arr;
});

(cljs.core.VectorNode.getBasis = (function cljs$core$fn_16581(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null);
}));

(cljs.core.VectorNode.cljs$lang$type = true);

(cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode");

(cljs.core.VectorNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_16582(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/VectorNode");
}));

/**
 * Positional factory function for cljs.core/VectorNode.
 */
cljs.core.__GT_VectorNode = (function cljs$core$__GT_VectorNode(edit,arr){
return (new cljs.core.VectorNode(edit,arr));
});

cljs.core.pv_fresh_node = (function cljs$core$pv_fresh_node(edit){
return (new cljs.core.VectorNode(edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
});
cljs.core.pv_aget = (function cljs$core$pv_aget(node,idx){
return (node.arr[idx]);
});
cljs.core.pv_aset = (function cljs$core$pv_aset(node,idx,val){
return (node.arr[idx] = val);
});
cljs.core.pv_clone_node = (function cljs$core$pv_clone_node(node){
return (new cljs.core.VectorNode(node.edit,cljs.core.aclone(node.arr)));
});
cljs.core.tail_off = (function cljs$core$tail_off(pv){
var cnt = pv.cnt;
if((cnt < (32))){
return (0);
} else {
return (((cnt - (1)) >>> (5)) << (5));
}
});
cljs.core.new_path = (function cljs$core$new_path(edit,level,node){
var ll = level;
var ret = node;
while(true){
if((ll === (0))){
return ret;
} else {
var embed = ret;
var r = cljs.core.pv_fresh_node(edit);
var _ = cljs.core.pv_aset(r,(0),embed);
var G__16583 = (ll - (5));
var G__16584 = r;
ll = G__16583;
ret = G__16584;
continue;
}
break;
}
});
cljs.core.push_tail = (function cljs$core$push_tail(pv,level,parent,tailnode){
var ret = cljs.core.pv_clone_node(parent);
var subidx = (((pv.cnt - (1)) >>> level) & (31));
if(((5) === level)){
cljs.core.pv_aset(ret,subidx,tailnode);

return ret;
} else {
var child = cljs.core.pv_aget(parent,subidx);
if((!((child == null)))){
var node_to_insert = (function (){var G__16585 = pv;
var G__16586 = (level - (5));
var G__16587 = child;
var G__16588 = tailnode;
return (cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4(G__16585,G__16586,G__16587,G__16588) : cljs.core.push_tail.call(null,G__16585,G__16586,G__16587,G__16588));
})();
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
} else {
var node_to_insert = cljs.core.new_path(null,(level - (5)),tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
}
}
});
cljs.core.vector_index_out_of_bounds = (function cljs$core$vector_index_out_of_bounds(i,cnt){
throw (new Error(["No item ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i)," in vector of length ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cnt)].join('')));
});
cljs.core.first_array_for_longvec = (function cljs$core$first_array_for_longvec(pv){
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__16589 = cljs.core.pv_aget(node,(0));
var G__16590 = (level - (5));
node = G__16589;
level = G__16590;
continue;
} else {
return node.arr;
}
break;
}
});
cljs.core.unchecked_array_for = (function cljs$core$unchecked_array_for(pv,i){
if((i >= cljs.core.tail_off(pv))){
return pv.tail;
} else {
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__16591 = cljs.core.pv_aget(node,((i >>> level) & (31)));
var G__16592 = (level - (5));
node = G__16591;
level = G__16592;
continue;
} else {
return node.arr;
}
break;
}
}
});
cljs.core.array_for = (function cljs$core$array_for(pv,i){
if(((((0) <= i)) && ((i < pv.cnt)))){
return cljs.core.unchecked_array_for(pv,i);
} else {
return cljs.core.vector_index_out_of_bounds(i,pv.cnt);
}
});
cljs.core.do_assoc = (function cljs$core$do_assoc(pv,level,node,i,val){
var ret = cljs.core.pv_clone_node(node);
if((level === (0))){
cljs.core.pv_aset(ret,(i & (31)),val);

return ret;
} else {
var subidx = ((i >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(function (){var G__16593 = pv;
var G__16594 = (level - (5));
var G__16595 = cljs.core.pv_aget(node,subidx);
var G__16596 = i;
var G__16597 = val;
return (cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5 ? cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5(G__16593,G__16594,G__16595,G__16596,G__16597) : cljs.core.do_assoc.call(null,G__16593,G__16594,G__16595,G__16596,G__16597));
})());

return ret;
}
});
cljs.core.pop_tail = (function cljs$core$pop_tail(pv,level,node){
var subidx = (((pv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = (function (){var G__16598 = pv;
var G__16599 = (level - (5));
var G__16600 = cljs.core.pv_aget(node,subidx);
return (cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3(G__16598,G__16599,G__16600) : cljs.core.pop_tail.call(null,G__16598,G__16599,G__16600));
})();
if((((new_child == null)) && ((subidx === (0))))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,new_child);

return ret;
}
} else {
if((subidx === (0))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,null);

return ret;

}
}
});

/**
* @constructor
*/
cljs.core.RangedIterator = (function (i,base,arr,v,start,end){
this.i = i;
this.base = base;
this.arr = arr;
this.v = v;
this.start = start;
this.end = end;
});
(cljs.core.RangedIterator.prototype.hasNext = (function cljs$core$fn_16601(){
var self__ = this;
var this$ = this;
return (self__.i < self__.end);
}));

(cljs.core.RangedIterator.prototype.next = (function cljs$core$fn_16602(){
var self__ = this;
var this$ = this;
if(((self__.i - self__.base) === (32))){
(self__.arr = cljs.core.unchecked_array_for(self__.v,self__.i));

(self__.base = (self__.base + (32)));
} else {
}

var ret = (self__.arr[(self__.i & (31))]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.RangedIterator.getBasis = (function cljs$core$fn_16603(){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"base","base",1825810849,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null);
}));

(cljs.core.RangedIterator.cljs$lang$type = true);

(cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator");

(cljs.core.RangedIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_16604(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/RangedIterator");
}));

/**
 * Positional factory function for cljs.core/RangedIterator.
 */
cljs.core.__GT_RangedIterator = (function cljs$core$__GT_RangedIterator(i,base,arr,v,start,end){
return (new cljs.core.RangedIterator(i,base,arr,v,start,end));
});

cljs.core.ranged_iterator = (function cljs$core$ranged_iterator(v,start,end){
var i = start;
return (new cljs.core.RangedIterator(i,(i - (i % (32))),(((start < cljs.core.count(v)))?cljs.core.unchecked_array_for(v,i):null),v,start,end));
});
cljs.core.pv_reduce = (function cljs$core$pv_reduce(var_args){
var G__16606 = arguments.length;
switch (G__16606) {
case 4:
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16607(pv,f,start,end){
if((start < end)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(pv,f,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pv,start),(start + (1)),end);
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
}));

(cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_16608(pv,f,init,start,end){
var acc = init;
var i = start;
var arr = cljs.core.unchecked_array_for(pv,start);
while(true){
if((i < end)){
var j = (i & (31));
var arr__$1 = (((j === (0)))?cljs.core.unchecked_array_for(pv,i):arr);
var nacc = (function (){var G__16609 = acc;
var G__16610 = (arr__$1[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16609,G__16610) : f.call(null,G__16609,G__16610));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__16612 = nacc;
var G__16613 = (i + (1));
var G__16614 = arr__$1;
acc = G__16612;
i = G__16613;
arr = G__16614;
continue;
}
} else {
return acc;
}
break;
}
}));

(cljs.core.pv_reduce.cljs$lang$maxFixedArity = 5);







/**
 * Marker protocol
 * @interface
 */
cljs.core.APersistentVector = function(){};


/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.APersistentVector}
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentVector = (function (meta,cnt,shift,root,tail,__hash){
this.meta = meta;
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 401412;
});
(cljs.core.PersistentVector.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_16616(coll,n){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return (new cljs.core.MapEntry(n,(cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]),null));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.toString = (function cljs$core$fn_16617(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentVector.prototype.equiv = (function cljs$core$fn_16618(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentVector.prototype.indexOf = (function() {
var cljs$core$fn_16619 = null;
var cljs$core$fn_16619__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16619__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16619 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16619__1.call(this,x);
case 2:
return cljs$core$fn_16619__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16619.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16619__1;
cljs$core$fn_16619.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16619__2;
return cljs$core$fn_16619;
})()
);

(cljs.core.PersistentVector.prototype.lastIndexOf = (function() {
var cljs$core$fn_16620 = null;
var cljs$core$fn_16620__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16620__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16620 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16620__1.call(this,x);
case 2:
return cljs$core$fn_16620__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16620.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16620__1;
cljs$core$fn_16620.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16620__2;
return cljs$core$fn_16620;
})()
);

(cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16621(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16622(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function cljs$core$fn_16623(v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__16624 = init__$2;
var G__16625 = (j + i);
var G__16626 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16624,G__16625,G__16626) : f.call(null,G__16624,G__16625,G__16626));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__16657 = (j + (1));
var G__16658 = init__$3;
j = G__16657;
init__$2 = G__16658;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__16659 = (i + len);
var G__16660 = init__$2;
i = G__16659;
init__$1 = G__16660;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$APersistentVector$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_16627(coll,n){
var self__ = this;
var coll__$1 = this;
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_16628(coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return (cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]);
} else {
return not_found;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function cljs$core$fn_16629(coll,n,val){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
if((cljs.core.tail_off(coll__$1) <= n)){
var new_tail = cljs.core.aclone(self__.tail);
(new_tail[(n & (31))] = val);

return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,cljs.core.do_assoc(coll__$1,self__.shift,self__.root,n,val),self__.tail,null));
}
} else {
if((n === self__.cnt)){
return coll__$1.cljs$core$ICollection$_conj$arity$2(null,val);
} else {
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds  [0,",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt),"]"].join('')));

}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_16630(this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.ranged_iterator(this$__$1,(0),self__.cnt);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16631(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_16632(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16633(coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_16634(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return coll__$1.cljs$core$IIndexed$_nth$arity$2(null,(self__.cnt - (1)));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_16635(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
} else {
if(((1) < (self__.cnt - cljs.core.tail_off(coll__$1)))){
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt - (1)),self__.shift,self__.root,self__.tail.slice((0),(-1)),null));
} else {
var new_tail = cljs.core.unchecked_array_for(coll__$1,(self__.cnt - (2)));
var nr = cljs.core.pop_tail(coll__$1,self__.shift,self__.root);
var new_root = (((nr == null))?cljs.core.PersistentVector.EMPTY_NODE:nr);
var cnt_1 = (self__.cnt - (1));
if(((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null)))){
return (new cljs.core.PersistentVector(self__.meta,cnt_1,(self__.shift - (5)),cljs.core.pv_aget(new_root,(0)),new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift,new_root,new_tail,null));
}

}
}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_16636(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return (new cljs.core.RSeq(coll__$1,(self__.cnt - (1)),null));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16637(coll){
var self__ = this;
var coll__$1 = this;
var h__10045__auto__ = self__.__hash;
if((!((h__10045__auto__ == null)))){
return h__10045__auto__;
} else {
var h__10045__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10045__auto____$1);

return h__10045__auto____$1;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16638(coll,other){
var self__ = this;
var coll__$1 = this;
if((other instanceof cljs.core.PersistentVector)){
if((self__.cnt === cljs.core.count(other))){
var me_iter = coll__$1.cljs$core$IIterable$_iterator$arity$1(null);
var you_iter = other.cljs$core$IIterable$_iterator$arity$1(null);
while(true){
if(me_iter.hasNext()){
var x = me_iter.next();
var y = you_iter.next();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_sequential(coll__$1,other);
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function cljs$core$fn_16639(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientVector(self__.cnt,self__.shift,cljs.core.tv_editable_root(self__.root),cljs.core.tv_editable_tail(self__.tail)));
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16640(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16641(v,f){
var self__ = this;
var v__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(v__$1,f,(0),self__.cnt);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16642(v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__16643 = init__$2;
var G__16644 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16643,G__16644) : f.call(null,G__16643,G__16644));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__16661 = (j + (1));
var G__16662 = init__$3;
j = G__16661;
init__$2 = G__16662;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__16663 = (i + len);
var G__16664 = init__$2;
i = G__16663;
init__$1 = G__16664;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_16645(coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IVector$_assoc_n$arity$3(null,k,v);
} else {
throw (new Error("Vector's key for assoc must be a number."));
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_16646(coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.integer_QMARK_(k)){
return ((((0) <= k)) && ((k < self__.cnt)));
} else {
return false;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16647(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
return null;
} else {
if((self__.cnt <= (32))){
return (new cljs.core.IndexedSeq(self__.tail,(0),null));
} else {
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(coll__$1,cljs.core.first_array_for_longvec(coll__$1),(0),(0));

}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16648(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentVector(new_meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16649(coll,o){
var self__ = this;
var coll__$1 = this;
if(((self__.cnt - cljs.core.tail_off(coll__$1)) < (32))){
var len = self__.tail.length;
var new_tail = (new Array((len + (1))));
var n__10672__auto___16665 = len;
var i_16666 = (0);
while(true){
if((i_16666 < n__10672__auto___16665)){
(new_tail[i_16666] = (self__.tail[i_16666]));

var G__16667 = (i_16666 + (1));
i_16666 = G__16667;
continue;
} else {
}
break;
}

(new_tail[len] = o);

return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),self__.shift,self__.root,new_tail,null));
} else {
var root_overflow_QMARK_ = ((self__.cnt >>> (5)) > ((1) << self__.shift));
var new_shift = ((root_overflow_QMARK_)?(self__.shift + (5)):self__.shift);
var new_root = ((root_overflow_QMARK_)?(function (){var n_r = cljs.core.pv_fresh_node(null);
cljs.core.pv_aset(n_r,(0),self__.root);

cljs.core.pv_aset(n_r,(1),cljs.core.new_path(null,self__.shift,(new cljs.core.VectorNode(null,self__.tail))));

return n_r;
})():cljs.core.push_tail(coll__$1,self__.shift,self__.root,(new cljs.core.VectorNode(null,self__.tail))));
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),new_shift,new_root,[o],null));
}
}));

(cljs.core.PersistentVector.prototype.call = (function cljs$core$fn_16650(self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
if(typeof k === 'number'){
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
} else {
throw (new Error("Key must be integer"));
}
}));

(cljs.core.PersistentVector.prototype.apply = (function cljs$core$fn_16651(self__,args16615){
var self__ = this;
var self____$1 = this;
var args__10187__auto__ = cljs.core.aclone(args16615);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10187__auto__.length > (20)))?(function (){var G__16652 = args__10187__auto__.slice((0),(20));
G__16652.push(args__10187__auto__.slice((20)));

return G__16652;
})():args__10187__auto__)));
}));

(cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16653(k){
var self__ = this;
var coll = this;
if(typeof k === 'number'){
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
} else {
throw (new Error("Key must be integer"));
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IDrop$_drop$arity$2 = (function cljs$core$fn_16654(coll,n){
var self__ = this;
var coll__$1 = this;
if((n < self__.cnt)){
var offset = (n % (32));
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(coll__$1,cljs.core.unchecked_array_for(coll__$1,n),(n - offset),offset);
} else {
return null;
}
}));

(cljs.core.PersistentVector.getBasis = (function cljs$core$fn_16655(){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"tail","tail",494507963,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentVector.cljs$lang$type = true);

(cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector");

(cljs.core.PersistentVector.cljs$lang$ctorPrWriter = (function cljs$core$fn_16656(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/PersistentVector");
}));

/**
 * Positional factory function for cljs.core/PersistentVector.
 */
cljs.core.__GT_PersistentVector = (function cljs$core$__GT_PersistentVector(meta,cnt,shift,root,tail,__hash){
return (new cljs.core.PersistentVector(meta,cnt,shift,root,tail,__hash));
});

(cljs.core.PersistentVector.EMPTY_NODE = (new cljs.core.VectorNode(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null])));
(cljs.core.PersistentVector.EMPTY = (new cljs.core.PersistentVector(null,(0),(5),cljs.core.PersistentVector.EMPTY_NODE,[],cljs.core.empty_ordered_hash)));
(cljs.core.PersistentVector.fromArray = (function cljs$core$fn_16668(xs,no_clone){
var l = xs.length;
var xs__$1 = ((no_clone)?xs:cljs.core.aclone(xs));
if((l < (32))){
return (new cljs.core.PersistentVector(null,l,(5),cljs.core.PersistentVector.EMPTY_NODE,xs__$1,null));
} else {
var node = xs__$1.slice((0),(32));
var v = (new cljs.core.PersistentVector(null,(32),(5),cljs.core.PersistentVector.EMPTY_NODE,node,null));
var i = (32);
var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
while(true){
if((i < l)){
var G__16669 = (i + (1));
var G__16670 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out,(xs__$1[i]));
i = G__16669;
out = G__16670;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}
}));
(cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16671(){
var this__10774__auto__ = this;
return cljs.core.es6_iterator(this__10774__auto__);
}));
/**
 * Creates a new vector containing the contents of coll. JavaScript arrays
 *   will be aliased and should not be modified.
 */
cljs.core.vec = (function cljs$core$vec(coll){
if(cljs.core.map_entry_QMARK_(coll)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.key(coll),cljs.core.val(coll)], null);
} else {
if(cljs.core.vector_QMARK_(coll)){
return cljs.core.with_meta(coll,null);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.PersistentVector.fromArray(coll,true);
} else {
return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core._as_transient(cljs.core.PersistentVector.EMPTY),coll));

}
}
}
});
/**
 * Creates a new vector containing the args.
 */
cljs.core.vector = (function cljs$core$vector(var_args){
var args__10923__auto__ = [];
var len__10913__auto___16675 = arguments.length;
var i__10914__auto___16676 = (0);
while(true){
if((i__10914__auto___16676 < len__10913__auto___16675)){
args__10923__auto__.push((arguments[i__10914__auto___16676]));

var G__16677 = (i__10914__auto___16676 + (1));
i__10914__auto___16676 = G__16677;
continue;
} else {
}
break;
}

var argseq__10924__auto__ = ((((0) < args__10923__auto__.length))?(new cljs.core.IndexedSeq(args__10923__auto__.slice((0)),(0),null)):null);
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__10924__auto__);
});

(cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16673(args){
if((((args instanceof cljs.core.IndexedSeq)) && ((args.i === (0))))){
return cljs.core.PersistentVector.fromArray(args.arr,(!(cljs.core.array_QMARK_(args.arr))));
} else {
return cljs.core.vec(args);
}
}));

(cljs.core.vector.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.vector.cljs$lang$applyTo = (function cljs$core$fn_16674(seq16672){
var self__10899__auto__ = this;
return self__10899__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq16672));
}));


/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ChunkedSeq = (function (vec,node,i,off,meta,__hash){
this.vec = vec;
this.node = node;
this.i = i;
this.off = off;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375020;
this.cljs$lang$protocol_mask$partition1$ = 263680;
});
(cljs.core.ChunkedSeq.prototype.toString = (function cljs$core$fn_16678(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ChunkedSeq.prototype.equiv = (function cljs$core$fn_16679(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ChunkedSeq.prototype.indexOf = (function() {
var cljs$core$fn_16680 = null;
var cljs$core$fn_16680__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16680__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16680 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16680__1.call(this,x);
case 2:
return cljs$core$fn_16680__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16680.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16680__1;
cljs$core$fn_16680.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16680__2;
return cljs$core$fn_16680;
})()
);

(cljs.core.ChunkedSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_16681 = null;
var cljs$core$fn_16681__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16681__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16681 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16681__1.call(this,x);
case 2:
return cljs$core$fn_16681__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16681.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16681__1;
cljs$core$fn_16681.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16681__2;
return cljs$core$fn_16681;
})()
);

(cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16682(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16683(coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,self__.node,self__.i,(self__.off + (1)));
if((s == null)){
return null;
} else {
return s;
}
} else {
return coll__$1.cljs$core$IChunkedNext$_chunked_next$arity$1(null);
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16684(coll){
var self__ = this;
var coll__$1 = this;
var h__10045__auto__ = self__.__hash;
if((!((h__10045__auto__ == null)))){
return h__10045__auto__;
} else {
var h__10045__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10045__auto____$1);

return h__10045__auto____$1;
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16685(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16686(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16687(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(self__.vec,f,(self__.i + self__.off),cljs.core.count(self__.vec));
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16688(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(self__.vec,f,start,(self__.i + self__.off),cljs.core.count(self__.vec));
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16689(coll){
var self__ = this;
var coll__$1 = this;
return (self__.node[self__.off]);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16690(coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,self__.node,self__.i,(self__.off + (1)));
if((s == null)){
return cljs.core.List.EMPTY;
} else {
return s;
}
} else {
return coll__$1.cljs$core$IChunkedSeq$_chunked_rest$arity$1(null);
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16691(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function cljs$core$fn_16692(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node,self__.off);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function cljs$core$fn_16693(coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,cljs.core.unchecked_array_for(self__.vec,end),end,(0));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16694(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(self__.vec,self__.node,self__.i,self__.off,new_meta);
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16695(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IDrop$_drop$arity$2 = (function cljs$core$fn_16696(coll,n){
var self__ = this;
var coll__$1 = this;
var o = (self__.off + n);
if((o < self__.node.length)){
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,self__.node,self__.i,o);
} else {
var i__$1 = (self__.i + o);
if((i__$1 < cljs.core._count(self__.vec))){
var new_offset = (i__$1 % (32));
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,cljs.core.unchecked_array_for(self__.vec,i__$1),(i__$1 - new_offset),new_offset);
} else {
return null;
}
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function cljs$core$fn_16697(coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,cljs.core.unchecked_array_for(self__.vec,end),end,(0));
} else {
return null;
}
}));

(cljs.core.ChunkedSeq.getBasis = (function cljs$core$fn_16698(){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"vec","vec",982683596,null),new cljs.core.Symbol(null,"node","node",-2073234571,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ChunkedSeq.cljs$lang$type = true);

(cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq");

(cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_16699(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/ChunkedSeq");
}));

/**
 * Positional factory function for cljs.core/ChunkedSeq.
 */
cljs.core.__GT_ChunkedSeq = (function cljs$core$__GT_ChunkedSeq(vec,node,i,off,meta,__hash){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,__hash));
});

(cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16700(){
var this__10774__auto__ = this;
return cljs.core.es6_iterator(this__10774__auto__);
}));
cljs.core.chunked_seq = (function cljs$core$chunked_seq(var_args){
var G__16702 = arguments.length;
switch (G__16702) {
case 3:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16703(vec,i,off){
return (new cljs.core.ChunkedSeq(vec,cljs.core.array_for(vec,i),i,off,null,null));
}));

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16704(vec,node,i,off){
return (new cljs.core.ChunkedSeq(vec,node,i,off,null,null));
}));

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_16705(vec,node,i,off,meta){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,null));
}));

(cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5);


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Subvec = (function (meta,v,start,end,__hash){
this.meta = meta;
this.v = v;
this.start = start;
this.end = end;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(cljs.core.Subvec.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Subvec.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_16708(coll,n){
var self__ = this;
var coll__$1 = this;
if((n < (0))){
return null;
} else {
var idx = (self__.start + n);
if((idx < self__.end)){
return (new cljs.core.MapEntry(n,cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.v,idx),null));
} else {
return null;
}
}
}));

(cljs.core.Subvec.prototype.toString = (function cljs$core$fn_16709(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Subvec.prototype.equiv = (function cljs$core$fn_16710(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Subvec.prototype.indexOf = (function() {
var cljs$core$fn_16711 = null;
var cljs$core$fn_16711__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16711__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
cljs$core$fn_16711 = function(x,start__$1){
switch(arguments.length){
case 1:
return cljs$core$fn_16711__1.call(this,x);
case 2:
return cljs$core$fn_16711__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16711.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16711__1;
cljs$core$fn_16711.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16711__2;
return cljs$core$fn_16711;
})()
);

(cljs.core.Subvec.prototype.lastIndexOf = (function() {
var cljs$core$fn_16712 = null;
var cljs$core$fn_16712__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16712__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
cljs$core$fn_16712 = function(x,start__$1){
switch(arguments.length){
case 1:
return cljs$core$fn_16712__1.call(this,x);
case 2:
return cljs$core$fn_16712__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16712.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16712__1;
cljs$core$fn_16712.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16712__2;
return cljs$core$fn_16712;
})()
);

(cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16713(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16714(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function cljs$core$fn_16715(coll,f,init){
var self__ = this;
var coll__$1 = this;
var i = self__.start;
var j = (0);
var init__$1 = init;
while(true){
if((i < self__.end)){
var init__$2 = (function (){var G__16716 = init__$1;
var G__16717 = j;
var G__16718 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16716,G__16717,G__16718) : f.call(null,G__16716,G__16717,G__16718));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__16750 = (i + (1));
var G__16751 = (j + (1));
var G__16752 = init__$2;
i = G__16750;
j = G__16751;
init__$1 = G__16752;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_16719(coll,n){
var self__ = this;
var coll__$1 = this;
if((((n < (0))) || ((self__.end <= (self__.start + n))))){
return cljs.core.vector_index_out_of_bounds(n,(self__.end - self__.start));
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.start + n));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_16720(coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((n < (0))) || ((self__.end <= (self__.start + n))))){
return not_found;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v,(self__.start + n),not_found);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function cljs$core$fn_16721(coll,n,val){
var self__ = this;
var coll__$1 = this;
var v_pos = (self__.start + n);
if((((n < (0))) || (((self__.end + (1)) <= v_pos)))){
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds [0,",cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll__$1.cljs$core$ICounted$_count$arity$1(null)),"]"].join('')));
} else {
return cljs.core.build_subvec(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v,v_pos,val),self__.start,(function (){var x__9941__auto__ = self__.end;
var y__9942__auto__ = (v_pos + (1));
return ((x__9941__auto__ > y__9942__auto__) ? x__9941__auto__ : y__9942__auto__);
})(),null);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_16722(coll){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.ranged_iterator(self__.v,self__.start,self__.end);
} else {
return cljs.core.seq_iter(coll__$1);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16724(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_16725(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Subvec(self__.meta,self__.v,self__.start,self__.end,self__.__hash));
}));

(cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16726(coll){
var self__ = this;
var coll__$1 = this;
return (self__.end - self__.start);
}));

(cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_16727(coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
return null;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.end - (1)));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_16728(coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
throw (new Error("Can't pop empty vector"));
} else {
return cljs.core.build_subvec(self__.meta,self__.v,self__.start,(self__.end - (1)),null);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_16729(coll){
var self__ = this;
var coll__$1 = this;
if((!((self__.start === self__.end)))){
return (new cljs.core.RSeq(coll__$1,((self__.end - self__.start) - (1)),null));
} else {
return null;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16730(coll){
var self__ = this;
var coll__$1 = this;
var h__10045__auto__ = self__.__hash;
if((!((h__10045__auto__ == null)))){
return h__10045__auto__;
} else {
var h__10045__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10045__auto____$1);

return h__10045__auto____$1;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16731(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16732(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
}));

(cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16733(coll,f){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(self__.v,f,self__.start,self__.end);
} else {
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16735(coll,f,init){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(self__.v,f,init,self__.start,self__.end);
} else {
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,init);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_16737(coll,key,val){
var self__ = this;
var coll__$1 = this;
if(typeof key === 'number'){
return coll__$1.cljs$core$IVector$_assoc_n$arity$3(null,key,val);
} else {
throw (new Error("Subvec's key for assoc must be a number."));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_16738(coll,key){
var self__ = this;
var coll__$1 = this;
if(cljs.core.integer_QMARK_(key)){
return ((((0) <= key)) && ((key < (self__.end - self__.start))));
} else {
return false;
}
}));

(cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16739(coll){
var self__ = this;
var coll__$1 = this;
var subvec_seq = (function cljs$core$fn_16739_$_subvec_seq(i){
if((i === self__.end)){
return null;
} else {
return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i),(new cljs.core.LazySeq(null,(function cljs$core$fn_16739_$_subvec_seq_$_fn_16740(){
return cljs$core$fn_16739_$_subvec_seq((i + (1)));
}),null,null)));
}
});
return subvec_seq(self__.start);
}));

(cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16741(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return cljs.core.build_subvec(new_meta,self__.v,self__.start,self__.end,self__.__hash);
}
}));

(cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16742(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.build_subvec(self__.meta,cljs.core._assoc_n(self__.v,self__.end,o),self__.start,(self__.end + (1)),null);
}));

(cljs.core.Subvec.prototype.call = (function() {
var cljs$core$fn_16743 = null;
var cljs$core$fn_16743__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var cljs$core$fn_16743__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
cljs$core$fn_16743 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_16743__2.call(this,self__,k);
case 3:
return cljs$core$fn_16743__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_16743.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16743__2;
cljs$core$fn_16743.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16743__3;
return cljs$core$fn_16743;
})()
);

(cljs.core.Subvec.prototype.apply = (function cljs$core$fn_16744(self__,args16707){
var self__ = this;
var self____$1 = this;
var args__10187__auto__ = cljs.core.aclone(args16707);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10187__auto__.length > (20)))?(function (){var G__16745 = args__10187__auto__.slice((0),(20));
G__16745.push(args__10187__auto__.slice((20)));

return G__16745;
})():args__10187__auto__)));
}));

(cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16746(k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16747(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.Subvec.getBasis = (function cljs$core$fn_16748(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Subvec.cljs$lang$type = true);

(cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec");

(cljs.core.Subvec.cljs$lang$ctorPrWriter = (function cljs$core$fn_16749(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/Subvec");
}));

/**
 * Positional factory function for cljs.core/Subvec.
 */
cljs.core.__GT_Subvec = (function cljs$core$__GT_Subvec(meta,v,start,end,__hash){
return (new cljs.core.Subvec(meta,v,start,end,__hash));
});

(cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16753(){
var this__10774__auto__ = this;
return cljs.core.es6_iterator(this__10774__auto__);
}));
cljs.core.build_subvec = (function cljs$core$build_subvec(meta,v,start,end,__hash){
while(true){
if((v instanceof cljs.core.Subvec)){
var G__16754 = meta;
var G__16755 = v.v;
var G__16756 = (v.start + start);
var G__16757 = (v.start + end);
var G__16758 = __hash;
meta = G__16754;
v = G__16755;
start = G__16756;
end = G__16757;
__hash = G__16758;
continue;
} else {
if(cljs.core.vector_QMARK_(v)){
} else {
throw (new Error("v must satisfy IVector"));
}

if((((start < (0))) || ((((end < start)) || ((end > cljs.core.count(v))))))){
throw (new Error("Index out of bounds"));
} else {
}

return (new cljs.core.Subvec(meta,v,start,end,__hash));
}
break;
}
});
/**
 * Returns a persistent vector of the items in vector from
 *   start (inclusive) to end (exclusive).  If end is not supplied,
 *   defaults to (count vector). This operation is O(1) and very fast, as
 *   the resulting vector shares structure with the original and no
 *   trimming is done.
 */
cljs.core.subvec = (function cljs$core$subvec(var_args){
var G__16760 = arguments.length;
switch (G__16760) {
case 2:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16761(v,start){
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v,start,cljs.core.count(v));
}));

(cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16762(v,start,end){
if((((!((start == null)))) && ((!((end == null)))))){
} else {
throw (new Error("Assert failed: (and (not (nil? start)) (not (nil? end)))"));
}

return cljs.core.build_subvec(null,v,(start | (0)),(end | (0)),null);
}));

(cljs.core.subvec.cljs$lang$maxFixedArity = 3);

cljs.core.tv_ensure_editable = (function cljs$core$tv_ensure_editable(edit,node){
if((edit === node.edit)){
return node;
} else {
return (new cljs.core.VectorNode(edit,cljs.core.aclone(node.arr)));
}
});
cljs.core.tv_editable_root = (function cljs$core$tv_editable_root(node){
return (new cljs.core.VectorNode(({}),cljs.core.aclone(node.arr)));
});
cljs.core.tv_editable_tail = (function cljs$core$tv_editable_tail(tl){
var ret = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
cljs.core.array_copy(tl,(0),ret,(0),tl.length);

return ret;
});
cljs.core.tv_push_tail = (function cljs$core$tv_push_tail(tv,level,parent,tail_node){
var ret = cljs.core.tv_ensure_editable(tv.root.edit,parent);
var subidx = (((tv.cnt - (1)) >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(((level === (5)))?tail_node:(function (){var child = cljs.core.pv_aget(ret,subidx);
if((!((child == null)))){
var G__16766 = tv;
var G__16767 = (level - (5));
var G__16768 = child;
var G__16769 = tail_node;
return (cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4(G__16766,G__16767,G__16768,G__16769) : cljs.core.tv_push_tail.call(null,G__16766,G__16767,G__16768,G__16769));
} else {
return cljs.core.new_path(tv.root.edit,(level - (5)),tail_node);
}
})()));

return ret;
});
cljs.core.tv_pop_tail = (function cljs$core$tv_pop_tail(tv,level,node){
var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit,node);
var subidx = (((tv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = (function (){var G__16770 = tv;
var G__16771 = (level - (5));
var G__16772 = cljs.core.pv_aget(node__$1,subidx);
return (cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3(G__16770,G__16771,G__16772) : cljs.core.tv_pop_tail.call(null,G__16770,G__16771,G__16772));
})();
if((((new_child == null)) && ((subidx === (0))))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,new_child);

return node__$1;
}
} else {
if((subidx === (0))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,null);

return node__$1;

}
}
});
cljs.core.unchecked_editable_array_for = (function cljs$core$unchecked_editable_array_for(tv,i){
if((i >= cljs.core.tail_off(tv))){
return tv.tail;
} else {
var root = tv.root;
var node = root;
var level = tv.shift;
while(true){
if((level > (0))){
var G__16773 = cljs.core.tv_ensure_editable(root.edit,cljs.core.pv_aget(node,((i >>> level) & (31))));
var G__16774 = (level - (5));
node = G__16773;
level = G__16774;
continue;
} else {
return node.arr;
}
break;
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientVector}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientVector = (function (cnt,shift,root,tail){
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.cljs$lang$protocol_mask$partition1$ = 88;
this.cljs$lang$protocol_mask$partition0$ = 275;
});
(cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function cljs$core$fn_16776(tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((self__.cnt - cljs.core.tail_off(tcoll__$1)) < (32))){
(self__.tail[(self__.cnt & (31))] = o);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
} else {
var tail_node = (new cljs.core.VectorNode(self__.root.edit,self__.tail));
var new_tail = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(new_tail[(0)] = o);

(self__.tail = new_tail);

if(((self__.cnt >>> (5)) > ((1) << self__.shift))){
var new_root_array = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var new_shift = (self__.shift + (5));
(new_root_array[(0)] = self__.root);

(new_root_array[(1)] = cljs.core.new_path(self__.root.edit,self__.shift,tail_node));

(self__.root = (new cljs.core.VectorNode(self__.root.edit,new_root_array)));

(self__.shift = new_shift);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
} else {
var new_root = cljs.core.tv_push_tail(tcoll__$1,self__.shift,self__.root,tail_node);
(self__.root = new_root);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function cljs$core$fn_16777(tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
(self__.root.edit = null);

var len = (self__.cnt - cljs.core.tail_off(tcoll__$1));
var trimmed_tail = (new Array(len));
cljs.core.array_copy(self__.tail,(0),trimmed_tail,(0),len);

return (new cljs.core.PersistentVector(null,self__.cnt,self__.shift,self__.root,trimmed_tail,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function cljs$core$fn_16778(tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(typeof key === 'number'){
return tcoll__$1.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(null,key,val);
} else {
throw (new Error("TransientVector's key for assoc! must be a number."));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = (function cljs$core$fn_16779(tcoll,n,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((((0) <= n)) && ((n < self__.cnt)))){
if((cljs.core.tail_off(tcoll__$1) <= n)){
(self__.tail[(n & (31))] = val);

return tcoll__$1;
} else {
var new_root = (function (){var fexpr__16780 = (function cljs$core$fn_16779_$_go(level,node){
var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit,node);
if((level === (0))){
cljs.core.pv_aset(node__$1,(n & (31)),val);

return node__$1;
} else {
var subidx = ((n >>> level) & (31));
cljs.core.pv_aset(node__$1,subidx,cljs$core$fn_16779_$_go((level - (5)),cljs.core.pv_aget(node__$1,subidx)));

return node__$1;
}
});
return fexpr__16780(self__.shift,self__.root);
})();
(self__.root = new_root);

return tcoll__$1;
}
} else {
if((n === self__.cnt)){
return tcoll__$1.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,val);
} else {
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds for TransientVector of length",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt)].join('')));

}
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = (function cljs$core$fn_16781(tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
(self__.cnt = (0));

return tcoll__$1;
} else {
if((((self__.cnt - (1)) & (31)) > (0))){
(self__.cnt = (self__.cnt - (1)));

return tcoll__$1;
} else {
var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1,(self__.cnt - (2)));
var new_root = (function (){var nr = cljs.core.tv_pop_tail(tcoll__$1,self__.shift,self__.root);
if((!((nr == null)))){
return nr;
} else {
return (new cljs.core.VectorNode(self__.root.edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
}
})();
if(((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null)))){
var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit,cljs.core.pv_aget(new_root,(0)));
(self__.root = new_root__$1);

(self__.shift = (self__.shift - (5)));

(self__.cnt = (self__.cnt - (1)));

(self__.tail = new_tail);

return tcoll__$1;
} else {
(self__.root = new_root);

(self__.cnt = (self__.cnt - (1)));

(self__.tail = new_tail);

return tcoll__$1;
}

}
}
}
} else {
throw (new Error("pop! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16782(coll){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return self__.cnt;
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_16783(coll,n){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
} else {
throw (new Error("nth after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_16784(coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return coll__$1.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
return not_found;
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16785(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16786(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((!(self__.root.edit))){
throw (new Error("lookup after persistent!"));
} else {
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;

}
}
}));

(cljs.core.TransientVector.prototype.call = (function() {
var cljs$core$fn_16787 = null;
var cljs$core$fn_16787__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var cljs$core$fn_16787__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
cljs$core$fn_16787 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_16787__2.call(this,self__,k);
case 3:
return cljs$core$fn_16787__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_16787.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16787__2;
cljs$core$fn_16787.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16787__3;
return cljs$core$fn_16787;
})()
);

(cljs.core.TransientVector.prototype.apply = (function cljs$core$fn_16788(self__,args16775){
var self__ = this;
var self____$1 = this;
var args__10187__auto__ = cljs.core.aclone(args16775);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10187__auto__.length > (20)))?(function (){var G__16789 = args__10187__auto__.slice((0),(20));
G__16789.push(args__10187__auto__.slice((20)));

return G__16789;
})():args__10187__auto__)));
}));

(cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16790(k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16791(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.TransientVector.getBasis = (function cljs$core$fn_16792(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"tail","tail",494507963,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.TransientVector.cljs$lang$type = true);

(cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector");

(cljs.core.TransientVector.cljs$lang$ctorPrWriter = (function cljs$core$fn_16793(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/TransientVector");
}));

/**
 * Positional factory function for cljs.core/TransientVector.
 */
cljs.core.__GT_TransientVector = (function cljs$core$__GT_TransientVector(cnt,shift,root,tail){
return (new cljs.core.TransientVector(cnt,shift,root,tail));
});


/**
* @constructor
*/
cljs.core.PersistentQueueIter = (function (fseq,riter){
this.fseq = fseq;
this.riter = riter;
});
(cljs.core.PersistentQueueIter.prototype.hasNext = (function cljs$core$fn_16794(){
var self__ = this;
var _ = this;
var or__9584__auto__ = (((!((self__.fseq == null)))) && (cljs.core.seq(self__.fseq)));
if(or__9584__auto__){
return or__9584__auto__;
} else {
var and__9578__auto__ = (!((self__.riter == null)));
if(and__9578__auto__){
return self__.riter.hasNext();
} else {
return and__9578__auto__;
}
}
}));

(cljs.core.PersistentQueueIter.prototype.next = (function cljs$core$fn_16795(){
var self__ = this;
var _ = this;
if((!((self__.fseq == null)))){
var ret = cljs.core.first(self__.fseq);
(self__.fseq = cljs.core.next(self__.fseq));

return ret;
} else {
if((((!((self__.riter == null)))) && (self__.riter.hasNext()))){
return self__.riter.next();
} else {
throw (new Error("No such element"));

}
}
}));

(cljs.core.PersistentQueueIter.prototype.remove = (function cljs$core$fn_16796(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.PersistentQueueIter.getBasis = (function cljs$core$fn_16797(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fseq","fseq",-1466412450,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"riter","riter",-237834262,null)], null);
}));

(cljs.core.PersistentQueueIter.cljs$lang$type = true);

(cljs.core.PersistentQueueIter.cljs$lang$ctorStr = "cljs.core/PersistentQueueIter");

(cljs.core.PersistentQueueIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_16798(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/PersistentQueueIter");
}));

/**
 * Positional factory function for cljs.core/PersistentQueueIter.
 */
cljs.core.__GT_PersistentQueueIter = (function cljs$core$__GT_PersistentQueueIter(fseq,riter){
return (new cljs.core.PersistentQueueIter(fseq,riter));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueueSeq = (function (meta,front,rear,__hash){
this.meta = meta;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850700;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.PersistentQueueSeq.prototype.toString = (function cljs$core$fn_16799(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentQueueSeq.prototype.equiv = (function cljs$core$fn_16800(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentQueueSeq.prototype.indexOf = (function() {
var cljs$core$fn_16801 = null;
var cljs$core$fn_16801__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16801__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16801 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16801__1.call(this,x);
case 2:
return cljs$core$fn_16801__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16801.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16801__1;
cljs$core$fn_16801.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16801__2;
return cljs$core$fn_16801;
})()
);

(cljs.core.PersistentQueueSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_16802 = null;
var cljs$core$fn_16802__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16802__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16802 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16802__1.call(this,x);
case 2:
return cljs$core$fn_16802__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16802.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16802__1;
cljs$core$fn_16802.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16802__2;
return cljs$core$fn_16802;
})()
);

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16803(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16804(coll){
var self__ = this;
var coll__$1 = this;
var temp__5718__auto__ = cljs.core.next(self__.front);
if(temp__5718__auto__){
var f1 = temp__5718__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((!((self__.rear == null)))){
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
} else {
return null;
}
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16805(coll){
var self__ = this;
var coll__$1 = this;
var h__10045__auto__ = self__.__hash;
if((!((h__10045__auto__ == null)))){
return h__10045__auto__;
} else {
var h__10045__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10045__auto____$1);

return h__10045__auto____$1;
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16806(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16807(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16808(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16809(coll){
var self__ = this;
var coll__$1 = this;
var temp__5718__auto__ = cljs.core.next(self__.front);
if(temp__5718__auto__){
var f1 = temp__5718__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((self__.rear == null)){
return coll__$1.cljs$core$IEmptyableCollection$_empty$arity$1(null);
} else {
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
}
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16810(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16811(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentQueueSeq(new_meta,self__.front,self__.rear,self__.__hash));
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16812(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.PersistentQueueSeq.getBasis = (function cljs$core$fn_16813(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"front","front",117022539,null),new cljs.core.Symbol(null,"rear","rear",-900164830,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentQueueSeq.cljs$lang$type = true);

(cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq");

(cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_16814(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/PersistentQueueSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentQueueSeq.
 */
cljs.core.__GT_PersistentQueueSeq = (function cljs$core$__GT_PersistentQueueSeq(meta,front,rear,__hash){
return (new cljs.core.PersistentQueueSeq(meta,front,rear,__hash));
});

(cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16815(){
var this__10774__auto__ = this;
return cljs.core.es6_iterator(this__10774__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueue = (function (meta,count,front,rear,__hash){
this.meta = meta;
this.count = count;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 139264;
this.cljs$lang$protocol_mask$partition0$ = 31858766;
});
(cljs.core.PersistentQueue.prototype.toString = (function cljs$core$fn_16816(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentQueue.prototype.equiv = (function cljs$core$fn_16817(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentQueue.prototype.indexOf = (function() {
var cljs$core$fn_16818 = null;
var cljs$core$fn_16818__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16818__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16818 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16818__1.call(this,x);
case 2:
return cljs$core$fn_16818__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16818.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16818__1;
cljs$core$fn_16818.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16818__2;
return cljs$core$fn_16818;
})()
);

(cljs.core.PersistentQueue.prototype.lastIndexOf = (function() {
var cljs$core$fn_16819 = null;
var cljs$core$fn_16819__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(self__.count.cljs$core$IFn$_invoke$arity$1 ? self__.count.cljs$core$IFn$_invoke$arity$1(coll) : self__.count.call(null,coll)));
});
var cljs$core$fn_16819__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16819 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16819__1.call(this,x);
case 2:
return cljs$core$fn_16819__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16819.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16819__1;
cljs$core$fn_16819.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16819__2;
return cljs$core$fn_16819;
})()
);

(cljs.core.PersistentQueue.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_16820(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueIter(self__.front,cljs.core._iterator(self__.rear)));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16821(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_16822(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(self__.meta,self__.count,self__.front,self__.rear,self__.__hash));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16823(coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_16824(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_16825(coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
var temp__5718__auto__ = cljs.core.next(self__.front);
if(temp__5718__auto__){
var f1 = temp__5718__auto__;
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),f1,self__.rear,null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),cljs.core.seq(self__.rear),cljs.core.PersistentVector.EMPTY,null));
}
} else {
return coll__$1;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16826(coll){
var self__ = this;
var coll__$1 = this;
var h__10045__auto__ = self__.__hash;
if((!((h__10045__auto__ == null)))){
return h__10045__auto__;
} else {
var h__10045__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10045__auto____$1);

return h__10045__auto____$1;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16827(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16828(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentQueue.EMPTY,self__.meta);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16829(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16830(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.rest(cljs.core.seq(coll__$1));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16831(coll){
var self__ = this;
var coll__$1 = this;
var rear__$1 = cljs.core.seq(self__.rear);
if(cljs.core.truth_((function (){var or__9584__auto__ = self__.front;
if(cljs.core.truth_(or__9584__auto__)){
return or__9584__auto__;
} else {
return rear__$1;
}
})())){
return (new cljs.core.PersistentQueueSeq(null,self__.front,cljs.core.seq(rear__$1),null));
} else {
return null;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16832(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentQueue(new_meta,self__.count,self__.front,self__.rear,self__.__hash));
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16833(coll,o){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),self__.front,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__9584__auto__ = self__.rear;
if(cljs.core.truth_(or__9584__auto__)){
return or__9584__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),o),null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front,o),cljs.core.PersistentVector.EMPTY,null));
}
}));

(cljs.core.PersistentQueue.getBasis = (function cljs$core$fn_16834(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"front","front",117022539,null),new cljs.core.Symbol(null,"rear","rear",-900164830,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentQueue.cljs$lang$type = true);

(cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue");

(cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = (function cljs$core$fn_16835(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/PersistentQueue");
}));

/**
 * Positional factory function for cljs.core/PersistentQueue.
 */
cljs.core.__GT_PersistentQueue = (function cljs$core$__GT_PersistentQueue(meta,count,front,rear,__hash){
return (new cljs.core.PersistentQueue(meta,count,front,rear,__hash));
});

(cljs.core.PersistentQueue.EMPTY = (new cljs.core.PersistentQueue(null,(0),null,cljs.core.PersistentVector.EMPTY,cljs.core.empty_ordered_hash)));
(cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16836(){
var this__10774__auto__ = this;
return cljs.core.es6_iterator(this__10774__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
*/
cljs.core.NeverEquiv = (function (){
this.cljs$lang$protocol_mask$partition0$ = 2097152;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.NeverEquiv.prototype.equiv = (function cljs$core$fn_16837(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16838(o,other){
var self__ = this;
var o__$1 = this;
return false;
}));

(cljs.core.NeverEquiv.getBasis = (function cljs$core$fn_16839(){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.NeverEquiv.cljs$lang$type = true);

(cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv");

(cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = (function cljs$core$fn_16840(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/NeverEquiv");
}));

/**
 * Positional factory function for cljs.core/NeverEquiv.
 */
cljs.core.__GT_NeverEquiv = (function cljs$core$__GT_NeverEquiv(){
return (new cljs.core.NeverEquiv());
});

cljs.core.never_equiv = (new cljs.core.NeverEquiv());
/**
 * Test map equivalence. Returns true if x equals y, otherwise returns false.
 */
cljs.core.equiv_map = (function cljs$core$equiv_map(x,y){
return cljs.core.boolean$(((((cljs.core.map_QMARK_(y)) && ((!(cljs.core.record_QMARK_(y))))))?(((cljs.core.count(x) === cljs.core.count(y)))?(((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition0$ & (1048576))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IKVReduce$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,x)))?cljs.core.reduce_kv((function cljs$core$equiv_map_$_fn_16842(_,k,v){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,k,cljs.core.never_equiv),v)){
return true;
} else {
return cljs.core.reduced(false);
}
}),true,x):cljs.core.every_QMARK_((function cljs$core$equiv_map_$_fn_16843(xkv){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,cljs.core.first(xkv),cljs.core.never_equiv),cljs.core.second(xkv));
}),x)):null):null));
});
cljs.core.scan_array = (function cljs$core$scan_array(incr,k,array){
var len = array.length;
var i = (0);
while(true){
if((i < len)){
if((k === (array[i]))){
return i;
} else {
var G__16844 = (i + incr);
i = G__16844;
continue;
}
} else {
return null;
}
break;
}
});
cljs.core.obj_map_compare_keys = (function cljs$core$obj_map_compare_keys(a,b){
var a__$1 = cljs.core.hash(a);
var b__$1 = cljs.core.hash(b);
if((a__$1 < b__$1)){
return (-1);
} else {
if((a__$1 > b__$1)){
return (1);
} else {
return (0);

}
}
});
cljs.core.obj_map__GT_hash_map = (function cljs$core$obj_map__GT_hash_map(m,k,v){
var ks = m.keys;
var len = ks.length;
var so = m.strobj;
var mm = cljs.core.meta(m);
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var k__$1 = (ks[i]);
var G__16845 = (i + (1));
var G__16846 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k__$1,cljs.core.goog$module$goog$object.get.call(null,so,k__$1));
i = G__16845;
out = G__16846;
continue;
} else {
return cljs.core._with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k,v)),mm);
}
break;
}
});
cljs.core.obj_clone = (function cljs$core$obj_clone(obj,ks){
var new_obj = ({});
var l = ks.length;
var i_16852 = (0);
while(true){
if((i_16852 < l)){
var k_16853 = (ks[i_16852]);
var G__16849_16854 = new_obj;
var G__16850_16855 = k_16853;
var G__16851_16856 = cljs.core.goog$module$goog$object.get.call(null,obj,k_16853);
cljs.core.goog$module$goog$object.set.call(null,G__16849_16854,G__16850_16855,G__16851_16856);

var G__16857 = (i_16852 + (1));
i_16852 = G__16857;
continue;
} else {
}
break;
}

return new_obj;
});

/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.ObjMap = (function (meta,keys,strobj,update_count,__hash){
this.meta = meta;
this.keys = keys;
this.strobj = strobj;
this.update_count = update_count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 4;
});
(cljs.core.ObjMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.ObjMap.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_16860(coll,k){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return (new cljs.core.MapEntry(k,(self__.strobj[k]),null));
} else {
return null;
}
}));

(cljs.core.ObjMap.prototype.toString = (function cljs$core$fn_16861(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ObjMap.prototype.equiv = (function cljs$core$fn_16862(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16863(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16864(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return (self__.strobj[k]);
} else {
return not_found;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function cljs$core$fn_16865(coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.keys.length;
var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
var init__$1 = init;
while(true){
if(cljs.core.seq(keys__$1)){
var k = cljs.core.first(keys__$1);
var init__$2 = (function (){var G__16866 = init__$1;
var G__16867 = k;
var G__16868 = (self__.strobj[k]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16866,G__16867,G__16868) : f.call(null,G__16866,G__16867,G__16868));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__16889 = cljs.core.rest(keys__$1);
var G__16890 = init__$2;
keys__$1 = G__16889;
init__$1 = G__16890;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16869(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16870(coll){
var self__ = this;
var coll__$1 = this;
return self__.keys.length;
}));

(cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16871(coll){
var self__ = this;
var coll__$1 = this;
var h__10045__auto__ = self__.__hash;
if((!((h__10045__auto__ == null)))){
return h__10045__auto__;
} else {
var h__10045__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__10045__auto____$1);

return h__10045__auto____$1;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16872(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
}));

(cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function cljs$core$fn_16873(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1));
}));

(cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16874(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.ObjMap.EMPTY,self__.meta);
}));

(cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function cljs$core$fn_16875(coll,k){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
var new_keys = cljs.core.aclone(self__.keys);
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
new_keys.splice(cljs.core.scan_array((1),k,new_keys),(1));

delete new_strobj[k];

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
} else {
return coll__$1;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_16876(coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'string'){
if((((self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD)) || ((self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD)))){
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
} else {
if((!((cljs.core.scan_array((1),k,self__.keys) == null)))){
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
cljs.core.goog$module$goog$object.set.call(null,new_strobj,k,v);

return (new cljs.core.ObjMap(self__.meta,self__.keys,new_strobj,(self__.update_count + (1)),null));
} else {
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
var new_keys = cljs.core.aclone(self__.keys);
cljs.core.goog$module$goog$object.set.call(null,new_strobj,k,v);

new_keys.push(k);

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
}
}
} else {
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_16877(coll,k){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return true;
} else {
return false;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16878(coll){
var self__ = this;
var coll__$1 = this;
if((self__.keys.length > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function cljs$core$fn_16878_$_fn_16879(p1__16858_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__16858_SHARP_,(self__.strobj[p1__16858_SHARP_])],null));
}),self__.keys.sort(cljs.core.obj_map_compare_keys));
} else {
return null;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16880(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ObjMap(new_meta,self__.keys,self__.strobj,self__.update_count,self__.__hash));
}
}));

(cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16881(coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,coll__$1,entry);
}
}));

(cljs.core.ObjMap.prototype.call = (function() {
var cljs$core$fn_16882 = null;
var cljs$core$fn_16882__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var cljs$core$fn_16882__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
cljs$core$fn_16882 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_16882__2.call(this,self__,k);
case 3:
return cljs$core$fn_16882__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_16882.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16882__2;
cljs$core$fn_16882.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16882__3;
return cljs$core$fn_16882;
})()
);

(cljs.core.ObjMap.prototype.apply = (function cljs$core$fn_16883(self__,args16859){
var self__ = this;
var self____$1 = this;
var args__10187__auto__ = cljs.core.aclone(args16859);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10187__auto__.length > (20)))?(function (){var G__16884 = args__10187__auto__.slice((0),(20));
G__16884.push(args__10187__auto__.slice((20)));

return G__16884;
})():args__10187__auto__)));
}));

(cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16885(k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16886(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.ObjMap.getBasis = (function cljs$core$fn_16887(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"keys","keys",-1586012071,null),new cljs.core.Symbol(null,"strobj","strobj",1088091283,null),new cljs.core.Symbol(null,"update-count","update-count",-411982269,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ObjMap.cljs$lang$type = true);

(cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap");

(cljs.core.ObjMap.cljs$lang$ctorPrWriter = (function cljs$core$fn_16888(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/ObjMap");
}));

/**
 * Positional factory function for cljs.core/ObjMap.
 */
cljs.core.__GT_ObjMap = (function cljs$core$__GT_ObjMap(meta,keys,strobj,update_count,__hash){
return (new cljs.core.ObjMap(meta,keys,strobj,update_count,__hash));
});

(cljs.core.ObjMap.EMPTY = (new cljs.core.ObjMap(null,[],({}),(0),cljs.core.empty_unordered_hash)));
(cljs.core.ObjMap.HASHMAP_THRESHOLD = (8));
(cljs.core.ObjMap.fromObject = (function cljs$core$fn_16893(ks,obj){
return (new cljs.core.ObjMap(null,ks,obj,(0),null));
}));

/**
* @constructor
*/
cljs.core.RecordIter = (function (i,record,base_count,fields,ext_map_iter){
this.i = i;
this.record = record;
this.base_count = base_count;
this.fields = fields;
this.ext_map_iter = ext_map_iter;
});
(cljs.core.RecordIter.prototype.hasNext = (function cljs$core$fn_16894(){
var self__ = this;
var _ = this;
var or__9584__auto__ = (self__.i < self__.base_count);
if(or__9584__auto__){
return or__9584__auto__;
} else {
return self__.ext_map_iter.hasNext();
}
}));

(cljs.core.RecordIter.prototype.next = (function cljs$core$fn_16895(){
var self__ = this;
var _ = this;
if((self__.i < self__.base_count)){
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.fields,self__.i);
(self__.i = (self__.i + (1)));

return (new cljs.core.MapEntry(k,cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.record,k),null));
} else {
return self__.ext_map_iter.next();
}
}));

(cljs.core.RecordIter.prototype.remove = (function cljs$core$fn_16896(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.RecordIter.getBasis = (function cljs$core$fn_16897(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"record","record",861424668,null),new cljs.core.Symbol(null,"base-count","base-count",-1180647182,null),new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.Symbol(null,"ext-map-iter","ext-map-iter",-1215982757,null)], null);
}));

(cljs.core.RecordIter.cljs$lang$type = true);

(cljs.core.RecordIter.cljs$lang$ctorStr = "cljs.core/RecordIter");

(cljs.core.RecordIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_16898(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/RecordIter");
}));

/**
 * Positional factory function for cljs.core/RecordIter.
 */
cljs.core.__GT_RecordIter = (function cljs$core$__GT_RecordIter(i,record,base_count,fields,ext_map_iter){
return (new cljs.core.RecordIter(i,record,base_count,fields,ext_map_iter));
});


/**
* @constructor
*/
cljs.core.ES6EntriesIterator = (function (s){
this.s = s;
});
(cljs.core.ES6EntriesIterator.prototype.next = (function cljs$core$fn_16899(){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var vec__16900 = cljs.core.first(self__.s);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16900,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16900,(1),null);
(self__.s = cljs.core.next(self__.s));

return ({"value": [k,v], "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6EntriesIterator.getBasis = (function cljs$core$fn_16903(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6EntriesIterator.cljs$lang$type = true);

(cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator");

(cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_16904(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/ES6EntriesIterator");
}));

/**
 * Positional factory function for cljs.core/ES6EntriesIterator.
 */
cljs.core.__GT_ES6EntriesIterator = (function cljs$core$__GT_ES6EntriesIterator(s){
return (new cljs.core.ES6EntriesIterator(s));
});

cljs.core.es6_entries_iterator = (function cljs$core$es6_entries_iterator(coll){
return (new cljs.core.ES6EntriesIterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6SetEntriesIterator = (function (s){
this.s = s;
});
(cljs.core.ES6SetEntriesIterator.prototype.next = (function cljs$core$fn_16905(){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var x = cljs.core.first(self__.s);
(self__.s = cljs.core.next(self__.s));

return ({"value": [x,x], "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6SetEntriesIterator.getBasis = (function cljs$core$fn_16906(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6SetEntriesIterator.cljs$lang$type = true);

(cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator");

(cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_16907(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/ES6SetEntriesIterator");
}));

/**
 * Positional factory function for cljs.core/ES6SetEntriesIterator.
 */
cljs.core.__GT_ES6SetEntriesIterator = (function cljs$core$__GT_ES6SetEntriesIterator(s){
return (new cljs.core.ES6SetEntriesIterator(s));
});

cljs.core.es6_set_entries_iterator = (function cljs$core$es6_set_entries_iterator(coll){
return (new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll)));
});
cljs.core.array_index_of_nil_QMARK_ = (function cljs$core$array_index_of_nil_QMARK_(arr){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((arr[i]) == null)){
return i;
} else {
var G__16908 = (i + (2));
i = G__16908;
continue;

}
}
break;
}
});
cljs.core.array_index_of_keyword_QMARK_ = (function cljs$core$array_index_of_keyword_QMARK_(arr,k){
var len = arr.length;
var kstr = k.fqn;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((((arr[i]) instanceof cljs.core.Keyword)) && ((kstr === (arr[i]).fqn)))){
return i;
} else {
var G__16909 = (i + (2));
i = G__16909;
continue;

}
}
break;
}
});
cljs.core.array_index_of_symbol_QMARK_ = (function cljs$core$array_index_of_symbol_QMARK_(arr,k){
var len = arr.length;
var kstr = k.str;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((((arr[i]) instanceof cljs.core.Symbol)) && ((kstr === (arr[i]).str)))){
return i;
} else {
var G__16910 = (i + (2));
i = G__16910;
continue;

}
}
break;
}
});
cljs.core.array_index_of_identical_QMARK_ = (function cljs$core$array_index_of_identical_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((k === (arr[i]))){
return i;
} else {
var G__16911 = (i + (2));
i = G__16911;
continue;

}
}
break;
}
});
cljs.core.array_index_of_equiv_QMARK_ = (function cljs$core$array_index_of_equiv_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(arr[i]))){
return i;
} else {
var G__16912 = (i + (2));
i = G__16912;
continue;

}
}
break;
}
});
cljs.core.array_index_of = (function cljs$core$array_index_of(arr,k){
if((k instanceof cljs.core.Keyword)){
return cljs.core.array_index_of_keyword_QMARK_(arr,k);
} else {
if(((typeof k === 'string') || (typeof k === 'number'))){
return cljs.core.array_index_of_identical_QMARK_(arr,k);
} else {
if((k instanceof cljs.core.Symbol)){
return cljs.core.array_index_of_symbol_QMARK_(arr,k);
} else {
if((k == null)){
return cljs.core.array_index_of_nil_QMARK_(arr);
} else {
return cljs.core.array_index_of_equiv_QMARK_(arr,k);

}
}
}
}
});
cljs.core.array_map_index_of = (function cljs$core$array_map_index_of(m,k){
return cljs.core.array_index_of(m.arr,k);
});
cljs.core.array_extend_kv = (function cljs$core$array_extend_kv(arr,k,v){
var l = arr.length;
var narr = (new Array((l + (2))));
var i_16913 = (0);
while(true){
if((i_16913 < l)){
(narr[i_16913] = (arr[i_16913]));

var G__16914 = (i_16913 + (1));
i_16913 = G__16914;
continue;
} else {
}
break;
}

(narr[l] = k);

(narr[(l + (1))] = v);

return narr;
});
cljs.core.array_map_extend_kv = (function cljs$core$array_map_extend_kv(m,k,v){
return cljs.core.array_extend_kv(m.arr,k,v);
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.MapEntry = (function (key,val,__hash){
this.key = key;
this.val = val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.MapEntry.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.MapEntry.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_16916(node,k){
var self__ = this;
var node__$1 = this;
var G__16917 = k;
switch (G__16917) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.MapEntry.prototype.indexOf = (function() {
var cljs$core$fn_16918 = null;
var cljs$core$fn_16918__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16918__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16918 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16918__1.call(this,x);
case 2:
return cljs$core$fn_16918__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16918.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16918__1;
cljs$core$fn_16918.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16918__2;
return cljs$core$fn_16918;
})()
);

(cljs.core.MapEntry.prototype.lastIndexOf = (function() {
var cljs$core$fn_16919 = null;
var cljs$core$fn_16919__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16919__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16919 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16919__1.call(this,x);
case 2:
return cljs$core$fn_16919__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16919.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16919__1;
cljs$core$fn_16919.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16919__2;
return cljs$core$fn_16919;
})()
);

(cljs.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16920(node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
}));

(cljs.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16921(node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.MapEntry.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_16922(node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_16923(node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function cljs$core$fn_16924(node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
}));

(cljs.core.MapEntry.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16925(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.MapEntry.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16926(node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.MapEntry.prototype.cljs$core$IMapEntry$_key$arity$1 = (function cljs$core$fn_16927(node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.MapEntry.prototype.cljs$core$IMapEntry$_val$arity$1 = (function cljs$core$fn_16928(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.MapEntry.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_16929(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.MapEntry.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_16930(node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.MapEntry.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_16931(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.MapEntry.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16932(coll){
var self__ = this;
var coll__$1 = this;
var h__10045__auto__ = self__.__hash;
if((!((h__10045__auto__ == null)))){
return h__10045__auto__;
} else {
var h__10045__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10045__auto____$1);

return h__10045__auto____$1;
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16933(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.MapEntry.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16934(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.MapEntry.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16935(node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
}));

(cljs.core.MapEntry.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16936(node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
}));

(cljs.core.MapEntry.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_16937(node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.MapEntry.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_16938(node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.MapEntry.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16939(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.MapEntry.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16940(node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.MapEntry.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16941(node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.MapEntry.prototype.call = (function() {
var cljs$core$fn_16942 = null;
var cljs$core$fn_16942__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var cljs$core$fn_16942__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
cljs$core$fn_16942 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_16942__2.call(this,self__,k);
case 3:
return cljs$core$fn_16942__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_16942.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16942__2;
cljs$core$fn_16942.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16942__3;
return cljs$core$fn_16942;
})()
);

(cljs.core.MapEntry.prototype.apply = (function cljs$core$fn_16943(self__,args16915){
var self__ = this;
var self____$1 = this;
var args__10187__auto__ = cljs.core.aclone(args16915);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10187__auto__.length > (20)))?(function (){var G__16944 = args__10187__auto__.slice((0),(20));
G__16944.push(args__10187__auto__.slice((20)));

return G__16944;
})():args__10187__auto__)));
}));

(cljs.core.MapEntry.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16945(k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.MapEntry.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16946(k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.MapEntry.getBasis = (function cljs$core$fn_16947(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.MapEntry.cljs$lang$type = true);

(cljs.core.MapEntry.cljs$lang$ctorStr = "cljs.core/MapEntry");

(cljs.core.MapEntry.cljs$lang$ctorPrWriter = (function cljs$core$fn_16948(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/MapEntry");
}));

/**
 * Positional factory function for cljs.core/MapEntry.
 */
cljs.core.__GT_MapEntry = (function cljs$core$__GT_MapEntry(key,val,__hash){
return (new cljs.core.MapEntry(key,val,__hash));
});

/**
 * Returns true if x satisfies IMapEntry
 */
cljs.core.map_entry_QMARK_ = (function cljs$core$map_entry_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMapEntry$)))){
return true;
} else {
return false;
}
} else {
return false;
}
});

/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMapSeq = (function (arr,i,_meta){
this.arr = arr;
this.i = i;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 262144;
});
(cljs.core.PersistentArrayMapSeq.prototype.toString = (function cljs$core$fn_16951(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentArrayMapSeq.prototype.equiv = (function cljs$core$fn_16952(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentArrayMapSeq.prototype.indexOf = (function() {
var cljs$core$fn_16953 = null;
var cljs$core$fn_16953__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16953__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16953 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16953__1.call(this,x);
case 2:
return cljs$core$fn_16953__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16953.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16953__1;
cljs$core$fn_16953.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16953__2;
return cljs$core$fn_16953;
})()
);

(cljs.core.PersistentArrayMapSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_16954 = null;
var cljs$core$fn_16954__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16954__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16954 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16954__1.call(this,x);
case 2:
return cljs$core$fn_16954__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16954.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16954__1;
cljs$core$fn_16954.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16954__2;
return cljs$core$fn_16954;
})()
);

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16955(coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16956(coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),null));
} else {
return null;
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16957(coll){
var self__ = this;
var coll__$1 = this;
return ((self__.arr.length - self__.i) / (2));
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16958(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16959(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16960(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16961(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16962(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16963(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.MapEntry((self__.arr[self__.i]),(self__.arr[(self__.i + (1))]),null));
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16964(coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16965(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16966(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__._meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentArrayMapSeq(self__.arr,self__.i,new_meta));
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16967(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IDrop$_drop$arity$2 = (function cljs$core$fn_16968(coll,n){
var self__ = this;
var coll__$1 = this;
if((n < coll__$1.cljs$core$ICounted$_count$arity$1(null))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + ((2) * n)),null));
} else {
return null;
}
}));

(cljs.core.PersistentArrayMapSeq.getBasis = (function cljs$core$fn_16969(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.PersistentArrayMapSeq.cljs$lang$type = true);

(cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq");

(cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_16970(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/PersistentArrayMapSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMapSeq.
 */
cljs.core.__GT_PersistentArrayMapSeq = (function cljs$core$__GT_PersistentArrayMapSeq(arr,i,_meta){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
});

(cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16971(){
var this__10774__auto__ = this;
return cljs.core.es6_iterator(this__10774__auto__);
}));
cljs.core.persistent_array_map_seq = (function cljs$core$persistent_array_map_seq(arr,i,_meta){
if((i <= (arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
} else {
return null;
}
});


/**
* @constructor
*/
cljs.core.PersistentArrayMapIterator = (function (arr,i,cnt){
this.arr = arr;
this.i = i;
this.cnt = cnt;
});
(cljs.core.PersistentArrayMapIterator.prototype.hasNext = (function cljs$core$fn_16972(){
var self__ = this;
var _ = this;
return (self__.i < self__.cnt);
}));

(cljs.core.PersistentArrayMapIterator.prototype.next = (function cljs$core$fn_16973(){
var self__ = this;
var _ = this;
var ret = (new cljs.core.MapEntry((self__.arr[self__.i]),(self__.arr[(self__.i + (1))]),null));
(self__.i = (self__.i + (2)));

return ret;
}));

(cljs.core.PersistentArrayMapIterator.getBasis = (function cljs$core$fn_16974(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null)], null);
}));

(cljs.core.PersistentArrayMapIterator.cljs$lang$type = true);

(cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator");

(cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_16975(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/PersistentArrayMapIterator");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMapIterator.
 */
cljs.core.__GT_PersistentArrayMapIterator = (function cljs$core$__GT_PersistentArrayMapIterator(arr,i,cnt){
return (new cljs.core.PersistentArrayMapIterator(arr,i,cnt));
});


/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMap = (function (meta,cnt,arr,__hash){
this.meta = meta;
this.cnt = cnt;
this.arr = arr;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16647951;
this.cljs$lang$protocol_mask$partition1$ = 401412;
});
(cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_16977(coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return null;
} else {
return (new cljs.core.MapEntry((self__.arr[idx]),(self__.arr[(idx + (1))]),null));
}
}));

(cljs.core.PersistentArrayMap.prototype.toString = (function cljs$core$fn_16978(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentArrayMap.prototype.equiv = (function cljs$core$fn_16979(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentArrayMap.prototype.keys = (function cljs$core$fn_16980(){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.keys(coll));
}));

(cljs.core.PersistentArrayMap.prototype.entries = (function cljs$core$fn_16981(){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentArrayMap.prototype.values = (function cljs$core$fn_16982(){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.vals(coll));
}));

(cljs.core.PersistentArrayMap.prototype.has = (function cljs$core$fn_16983(k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
}));

(cljs.core.PersistentArrayMap.prototype.get = (function cljs$core$fn_16984(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentArrayMap.prototype.forEach = (function cljs$core$fn_16985(f){
var self__ = this;
var coll = this;
var seq__16986 = cljs.core.seq(coll);
var chunk__16987 = null;
var count__16988 = (0);
var i__16989 = (0);
while(true){
if((i__16989 < count__16988)){
var vec__16996 = chunk__16987.cljs$core$IIndexed$_nth$arity$2(null,i__16989);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16996,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16996,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__17035 = seq__16986;
var G__17036 = chunk__16987;
var G__17037 = count__16988;
var G__17038 = (i__16989 + (1));
seq__16986 = G__17035;
chunk__16987 = G__17036;
count__16988 = G__17037;
i__16989 = G__17038;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__16986);
if(temp__5720__auto__){
var seq__16986__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__16986__$1)){
var c__10556__auto__ = cljs.core.chunk_first(seq__16986__$1);
var G__17039 = cljs.core.chunk_rest(seq__16986__$1);
var G__17040 = c__10556__auto__;
var G__17041 = cljs.core.count(c__10556__auto__);
var G__17042 = (0);
seq__16986 = G__17039;
chunk__16987 = G__17040;
count__16988 = G__17041;
i__16989 = G__17042;
continue;
} else {
var vec__16999 = cljs.core.first(seq__16986__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16999,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16999,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__17043 = cljs.core.next(seq__16986__$1);
var G__17044 = null;
var G__17045 = (0);
var G__17046 = (0);
seq__16986 = G__17043;
chunk__16987 = G__17044;
count__16988 = G__17045;
i__16989 = G__17046;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_17002(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_17003(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function cljs$core$fn_17004(coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var G__17005 = init__$1;
var G__17006 = (self__.arr[i]);
var G__17007 = (self__.arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17005,G__17006,G__17007) : f.call(null,G__17005,G__17006,G__17007));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__17047 = (i + (2));
var G__17048 = init__$2;
i = G__17047;
init__$1 = G__17048;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_17008(this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.PersistentArrayMapIterator(self__.arr,(0),(self__.cnt * (2))));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17009(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_17010(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,self__.arr,self__.__hash));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17011(coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17012(coll){
var self__ = this;
var coll__$1 = this;
var h__10045__auto__ = self__.__hash;
if((!((h__10045__auto__ == null)))){
return h__10045__auto__;
} else {
var h__10045__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__10045__auto____$1);

return h__10045__auto____$1;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17013(coll,other){
var self__ = this;
var coll__$1 = this;
if(((cljs.core.map_QMARK_(other)) && ((!(cljs.core.record_QMARK_(other)))))){
var alen = self__.arr.length;
var other__$1 = other;
if((self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null))){
var i = (0);
while(true){
if((i < alen)){
var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null,(self__.arr[i]),cljs.core.lookup_sentinel);
if((!((v === cljs.core.lookup_sentinel)))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(i + (1))]),v)){
var G__17049 = (i + (2));
i = G__17049;
continue;
} else {
return false;
}
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return false;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function cljs$core$fn_17014(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientArrayMap(({}),self__.arr.length,cljs.core.aclone(self__.arr)));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17017(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY,self__.meta);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17018(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17019(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,start);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function cljs$core$fn_17020(coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx >= (0))){
var len = self__.arr.length;
var new_len = (len - (2));
if((new_len === (0))){
return coll__$1.cljs$core$IEmptyableCollection$_empty$arity$1(null);
} else {
var new_arr = (new Array(new_len));
var s = (0);
var d = (0);
while(true){
if((s >= len)){
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt - (1)),new_arr,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(self__.arr[s]))){
var G__17050 = (s + (2));
var G__17051 = d;
s = G__17050;
d = G__17051;
continue;
} else {
(new_arr[d] = (self__.arr[s]));

(new_arr[(d + (1))] = (self__.arr[(s + (1))]));

var G__17052 = (s + (2));
var G__17053 = (d + (2));
s = G__17052;
d = G__17053;
continue;

}
}
break;
}
}
} else {
return coll__$1;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_17021(coll,k,v){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
if((self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr__$1 = cljs.core.array_map_extend_kv(coll__$1,k,v);
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt + (1)),arr__$1,null));
} else {
return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1),k,v),self__.meta);
}
} else {
if((v === (self__.arr[(idx + (1))]))){
return coll__$1;
} else {
var arr__$1 = (function (){var G__17022 = cljs.core.aclone(self__.arr);
(G__17022[(idx + (1))] = v);

return G__17022;
})();
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,arr__$1,null));

}
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_17023(coll,k){
var self__ = this;
var coll__$1 = this;
return (!((cljs.core.array_map_index_of(coll__$1,k) === (-1))));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17024(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.persistent_array_map_seq(self__.arr,(0),null);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17025(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentArrayMap(new_meta,self__.cnt,self__.arr,self__.__hash));
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17026(coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__17054 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__17055 = cljs.core.next(es);
ret = G__17054;
es = G__17055;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
}));

(cljs.core.PersistentArrayMap.prototype.call = (function() {
var cljs$core$fn_17027 = null;
var cljs$core$fn_17027__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var cljs$core$fn_17027__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
cljs$core$fn_17027 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_17027__2.call(this,self__,k);
case 3:
return cljs$core$fn_17027__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_17027.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17027__2;
cljs$core$fn_17027.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_17027__3;
return cljs$core$fn_17027;
})()
);

(cljs.core.PersistentArrayMap.prototype.apply = (function cljs$core$fn_17028(self__,args16976){
var self__ = this;
var self____$1 = this;
var args__10187__auto__ = cljs.core.aclone(args16976);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10187__auto__.length > (20)))?(function (){var G__17029 = args__10187__auto__.slice((0),(20));
G__17029.push(args__10187__auto__.slice((20)));

return G__17029;
})():args__10187__auto__)));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17030(k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_17031(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IDrop$_drop$arity$2 = (function cljs$core$fn_17032(coll,n){
var self__ = this;
var coll__$1 = this;
var temp__5724__auto__ = coll__$1.cljs$core$ISeqable$_seq$arity$1(null);
if((temp__5724__auto__ == null)){
return null;
} else {
var s = temp__5724__auto__;
return cljs.core._drop(s,n);
}
}));

(cljs.core.PersistentArrayMap.getBasis = (function cljs$core$fn_17033(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentArrayMap.cljs$lang$type = true);

(cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap");

(cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = (function cljs$core$fn_17034(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/PersistentArrayMap");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMap.
 */
cljs.core.__GT_PersistentArrayMap = (function cljs$core$__GT_PersistentArrayMap(meta,cnt,arr,__hash){
return (new cljs.core.PersistentArrayMap(meta,cnt,arr,__hash));
});

(cljs.core.PersistentArrayMap.EMPTY = (new cljs.core.PersistentArrayMap(null,(0),[],cljs.core.empty_unordered_hash)));
(cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = (8));
(cljs.core.PersistentArrayMap.fromArray = (function cljs$core$fn_17056(arr,no_clone,no_check){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var arr__$2 = ((no_check)?arr__$1:(function (){var ret = [];
var i_17057 = (0);
while(true){
if((i_17057 < arr__$1.length)){
var k_17058 = (arr__$1[i_17057]);
var v_17059 = (arr__$1[(i_17057 + (1))]);
var idx_17060 = cljs.core.array_index_of(ret,k_17058);
if((idx_17060 === (-1))){
ret.push(k_17058);

ret.push(v_17059);
} else {
}

var G__17061 = (i_17057 + (2));
i_17057 = G__17061;
continue;
} else {
}
break;
}

return ret;
})());
var cnt = (arr__$2.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr__$2,null));
}));
(cljs.core.PersistentArrayMap.createWithCheck = (function cljs$core$fn_17062(arr){
var ret = [];
var i_17064 = (0);
while(true){
if((i_17064 < arr.length)){
var k_17065 = (arr[i_17064]);
var v_17066 = (arr[(i_17064 + (1))]);
var idx_17067 = cljs.core.array_index_of(ret,k_17065);
if((idx_17067 === (-1))){
var G__17063_17068 = ret;
G__17063_17068.push(k_17065);

G__17063_17068.push(v_17066);

} else {
throw (new Error(["Duplicate key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k_17065)].join('')));
}

var G__17069 = (i_17064 + (2));
i_17064 = G__17069;
continue;
} else {
}
break;
}

var cnt = (arr.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr,null));
}));
cljs.core.key_test = (function cljs$core$key_test(key,other){
if((key === other)){
return true;
} else {
if(cljs.core.keyword_identical_QMARK_(key,other)){
return true;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,other);

}
}
});
cljs.core.pam_dupes_QMARK_ = (function cljs$core$pam_dupes_QMARK_(arr){
var i = (0);
while(true){
if((i < arr.length)){
var dupe_QMARK_ = (function (){var j = (0);
while(true){
if((j < i)){
var or__9584__auto__ = cljs.core.key_test((arr[i]),(arr[j]));
if(or__9584__auto__){
return or__9584__auto__;
} else {
var G__17070 = ((2) + j);
j = G__17070;
continue;
}
} else {
return false;
}
break;
}
})();
var or__9584__auto__ = dupe_QMARK_;
if(or__9584__auto__){
return or__9584__auto__;
} else {
var G__17071 = ((2) + i);
i = G__17071;
continue;
}
} else {
return false;
}
break;
}
});
cljs.core.pam_new_size = (function cljs$core$pam_new_size(arr){
var i = (0);
var n = (0);
while(true){
if((i < arr.length)){
var dupe_QMARK_ = (function (){var j = (0);
while(true){
if((j < i)){
var or__9584__auto__ = cljs.core.key_test((arr[i]),(arr[j]));
if(or__9584__auto__){
return or__9584__auto__;
} else {
var G__17072 = ((2) + j);
j = G__17072;
continue;
}
} else {
return false;
}
break;
}
})();
var G__17073 = ((2) + i);
var G__17074 = ((dupe_QMARK_)?n:(n + (2)));
i = G__17073;
n = G__17074;
continue;
} else {
return n;
}
break;
}
});
cljs.core.pam_grow_seed_array = (function cljs$core$pam_grow_seed_array(seed,trailing){
var seed_cnt = (seed.length - (1));
var extra_kvs = cljs.core.seq(trailing);
var ret = (new Array((seed_cnt + ((2) * cljs.core.count(extra_kvs)))));
var ret__$1 = cljs.core.array_copy(seed,(0),ret,(0),seed_cnt);
var i = seed_cnt;
var extra_kvs__$1 = extra_kvs;
while(true){
if(extra_kvs__$1){
var kv = cljs.core.first(extra_kvs__$1);
(ret__$1[i] = cljs.core._key(kv));

(ret__$1[(i + (1))] = cljs.core._val(kv));

var G__17075 = ((2) + i);
var G__17076 = cljs.core.next(extra_kvs__$1);
i = G__17075;
extra_kvs__$1 = G__17076;
continue;
} else {
return ret__$1;
}
break;
}
});
(cljs.core.PersistentArrayMap.createAsIfByAssoc = (function cljs$core$fn_17077(init){
var len = init.length;
var has_trailing_QMARK_ = ((1) === (len & (1)));
if((!(((has_trailing_QMARK_) || (cljs.core.pam_dupes_QMARK_(init)))))){
return (new cljs.core.PersistentArrayMap(null,(len / (2)),init,null));
} else {
return cljs.core.PersistentArrayMap.createAsIfByAssocComplexPath(init,has_trailing_QMARK_);
}
}));
(cljs.core.PersistentArrayMap.createAsIfByAssocComplexPath = (function cljs$core$fn_17078(init,has_trailing_QMARK_){
var init__$1 = ((has_trailing_QMARK_)?cljs.core.pam_grow_seed_array(init,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(init[(init.length - (1))]))):init);
var n = cljs.core.pam_new_size(init__$1);
var len = init__$1.length;
if((n < len)){
var nodups = (new Array(n));
var i_17079 = (0);
var m_17080 = (0);
while(true){
if((i_17079 < len)){
var dupe_QMARK__17081 = (function (){var j = (0);
while(true){
if((j < m_17080)){
var or__9584__auto__ = cljs.core.key_test((init__$1[i_17079]),(init__$1[j]));
if(or__9584__auto__){
return or__9584__auto__;
} else {
var G__17082 = ((2) + j);
j = G__17082;
continue;
}
} else {
return false;
}
break;
}
})();
if((!(dupe_QMARK__17081))){
var j_17083 = (function (){var j_17083 = (len - (2));
while(true){
if((j_17083 >= i_17079)){
if(cljs.core.key_test((init__$1[i_17079]),(init__$1[j_17083]))){
return j_17083;
} else {
var G__17084 = (j_17083 - (2));
j_17083 = G__17084;
continue;
}
} else {
return j_17083;
}
break;
}
})();
(nodups[m_17080] = (init__$1[i_17079]));

(nodups[(m_17080 + (1))] = (init__$1[(j_17083 + (1))]));

var G__17085 = ((2) + i_17079);
var G__17086 = ((2) + m_17080);
i_17079 = G__17085;
m_17080 = G__17086;
continue;
} else {
var G__17087 = ((2) + i_17079);
var G__17088 = m_17080;
i_17079 = G__17087;
m_17080 = G__17088;
continue;
}
} else {
}
break;
}

return (new cljs.core.PersistentArrayMap(null,(nodups.length / (2)),nodups,null));
} else {
return (new cljs.core.PersistentArrayMap(null,(init__$1.length / (2)),init__$1,null));
}
}));
(cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17089(){
var this__10774__auto__ = this;
return cljs.core.es6_iterator(this__10774__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientArrayMap = (function (editable_QMARK_,len,arr){
this.editable_QMARK_ = editable_QMARK_;
this.len = len;
this.arr = arr;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 56;
});
(cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17091(tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
return cljs.core.quot(self__.len,(2));
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_17092(tcoll,k){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_17093(tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of(tcoll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
} else {
throw (new Error("lookup after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function cljs$core$fn_17094(tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
if(cljs.core.map_entry_QMARK_(o)){
return tcoll__$1.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,cljs.core.key(o),cljs.core.val(o));
} else {
if(cljs.core.vector_QMARK_(o)){
return tcoll__$1.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((0)) : o.call(null,(0))),(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((1)) : o.call(null,(1))));
} else {
var es = cljs.core.seq(o);
var tcoll__$2 = tcoll__$1;
while(true){
var temp__5718__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__5718__auto__)){
var e = temp__5718__auto__;
var G__17106 = cljs.core.next(es);
var G__17107 = cljs.core._assoc_BANG_(tcoll__$2,cljs.core.key(e),cljs.core.val(e));
es = G__17106;
tcoll__$2 = G__17107;
continue;
} else {
return tcoll__$2;
}
break;
}

}
}
} else {
throw (new Error("conj! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function cljs$core$fn_17095(tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
(self__.editable_QMARK_ = false);

return (new cljs.core.PersistentArrayMap(null,cljs.core.quot(self__.len,(2)),self__.arr,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function cljs$core$fn_17096(tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx === (-1))){
if(((self__.len + (2)) <= ((2) * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD))){
(self__.len = (self__.len + (2)));

self__.arr.push(key);

self__.arr.push(val);

return tcoll__$1;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.array__GT_transient_hash_map(self__.len,self__.arr),key,val);
}
} else {
if((val === (self__.arr[(idx + (1))]))){
return tcoll__$1;
} else {
(self__.arr[(idx + (1))] = val);

return tcoll__$1;
}
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function cljs$core$fn_17097(tcoll,key){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx >= (0))){
(self__.arr[idx] = (self__.arr[(self__.len - (2))]));

(self__.arr[(idx + (1))] = (self__.arr[(self__.len - (1))]));

var G__17098_17108 = self__.arr;
G__17098_17108.pop();

G__17098_17108.pop();


(self__.len = (self__.len - (2)));
} else {
}

return tcoll__$1;
} else {
throw (new Error("dissoc! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.call = (function() {
var cljs$core$fn_17099 = null;
var cljs$core$fn_17099__2 = (function (self__,key){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,null);
});
var cljs$core$fn_17099__3 = (function (self__,key,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
});
cljs$core$fn_17099 = function(self__,key,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_17099__2.call(this,self__,key);
case 3:
return cljs$core$fn_17099__3.call(this,self__,key,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_17099.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17099__2;
cljs$core$fn_17099.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_17099__3;
return cljs$core$fn_17099;
})()
);

(cljs.core.TransientArrayMap.prototype.apply = (function cljs$core$fn_17100(self__,args17090){
var self__ = this;
var self____$1 = this;
var args__10187__auto__ = cljs.core.aclone(args17090);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10187__auto__.length > (20)))?(function (){var G__17101 = args__10187__auto__.slice((0),(20));
G__17101.push(args__10187__auto__.slice((20)));

return G__17101;
})():args__10187__auto__)));
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17102(key){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,null);
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_17103(key,not_found){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
}));

(cljs.core.TransientArrayMap.getBasis = (function cljs$core$fn_17104(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"editable?","editable?",-164945806,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"len","len",-1230778691,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null);
}));

(cljs.core.TransientArrayMap.cljs$lang$type = true);

(cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap");

(cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = (function cljs$core$fn_17105(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/TransientArrayMap");
}));

/**
 * Positional factory function for cljs.core/TransientArrayMap.
 */
cljs.core.__GT_TransientArrayMap = (function cljs$core$__GT_TransientArrayMap(editable_QMARK_,len,arr){
return (new cljs.core.TransientArrayMap(editable_QMARK_,len,arr));
});

cljs.core.array__GT_transient_hash_map = (function cljs$core$array__GT_transient_hash_map(len,arr){
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i = (0);
while(true){
if((i < len)){
var G__17109 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,(arr[i]),(arr[(i + (1))]));
var G__17110 = (i + (2));
out = G__17109;
i = G__17110;
continue;
} else {
return out;
}
break;
}
});

/**
* @constructor
*/
cljs.core.Box = (function (val){
this.val = val;
});

(cljs.core.Box.getBasis = (function cljs$core$fn_17111(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Box.cljs$lang$type = true);

(cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box");

(cljs.core.Box.cljs$lang$ctorPrWriter = (function cljs$core$fn_17112(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/Box");
}));

/**
 * Positional factory function for cljs.core/Box.
 */
cljs.core.__GT_Box = (function cljs$core$__GT_Box(val){
return (new cljs.core.Box(val));
});



cljs.core.mask = (function cljs$core$mask(hash,shift){
return ((hash >>> shift) & (31));
});
cljs.core.clone_and_set = (function cljs$core$clone_and_set(var_args){
var G__17114 = arguments.length;
switch (G__17114) {
case 3:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_17115(arr,i,a){
var G__17116 = cljs.core.aclone(arr);
(G__17116[i] = a);

return G__17116;
}));

(cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_17117(arr,i,a,j,b){
var G__17118 = cljs.core.aclone(arr);
(G__17118[i] = a);

(G__17118[j] = b);

return G__17118;
}));

(cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5);

cljs.core.remove_pair = (function cljs$core$remove_pair(arr,i){
var new_arr = (new Array((arr.length - (2))));
cljs.core.array_copy(arr,(0),new_arr,(0),((2) * i));

cljs.core.array_copy(arr,((2) * (i + (1))),new_arr,((2) * i),(new_arr.length - ((2) * i)));

return new_arr;
});
cljs.core.bitmap_indexed_node_index = (function cljs$core$bitmap_indexed_node_index(bitmap,bit){
return cljs.core.bit_count((bitmap & (bit - (1))));
});
cljs.core.bitpos = (function cljs$core$bitpos(hash,shift){
return ((1) << ((hash >>> shift) & 0x01f));
});
cljs.core.edit_and_set = (function cljs$core$edit_and_set(var_args){
var G__17121 = arguments.length;
switch (G__17121) {
case 4:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_17122(inode,edit,i,a){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

return editable;
}));

(cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_17123(inode,edit,i,a,j,b){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

(editable.arr[j] = b);

return editable;
}));

(cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6);

cljs.core.inode_kv_reduce = (function cljs$core$inode_kv_reduce(arr,f,init){
var len = arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var k = (arr[i]);
if((!((k == null)))){
var G__17125 = init__$1;
var G__17126 = k;
var G__17127 = (arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17125,G__17126,G__17127) : f.call(null,G__17125,G__17126,G__17127));
} else {
var node = (arr[(i + (1))]);
if((!((node == null)))){
return node.kv_reduce(f,init__$1);
} else {
return init__$1;
}
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
var G__17128 = (i + (2));
var G__17129 = init__$2;
i = G__17128;
init__$1 = G__17129;
continue;
}
} else {
return init__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.NodeIterator = (function (arr,i,next_entry,next_iter){
this.arr = arr;
this.i = i;
this.next_entry = next_entry;
this.next_iter = next_iter;
});
(cljs.core.NodeIterator.prototype.advance = (function cljs$core$fn_17130(){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if((self__.i < len)){
var key = (self__.arr[self__.i]);
var node_or_val = (self__.arr[(self__.i + (1))]);
var found = (((!((key == null))))?(self__.next_entry = (new cljs.core.MapEntry(key,node_or_val,null))):(((!((node_or_val == null))))?(function (){var new_iter = cljs.core._iterator(node_or_val);
if(new_iter.hasNext()){
return (self__.next_iter = new_iter);
} else {
return false;
}
})():false
));
(self__.i = (self__.i + (2)));

if(found){
return true;
} else {
continue;
}
} else {
return false;
}
break;
}
}));

(cljs.core.NodeIterator.prototype.hasNext = (function cljs$core$fn_17131(){
var self__ = this;
var this$ = this;
var or__9584__auto__ = (!((self__.next_entry == null)));
if(or__9584__auto__){
return or__9584__auto__;
} else {
var or__9584__auto____$1 = (!((self__.next_iter == null)));
if(or__9584__auto____$1){
return or__9584__auto____$1;
} else {
return this$.advance();
}
}
}));

(cljs.core.NodeIterator.prototype.next = (function cljs$core$fn_17132(){
var self__ = this;
var this$ = this;
if((!((self__.next_entry == null)))){
var ret = self__.next_entry;
(self__.next_entry = null);

return ret;
} else {
if((!((self__.next_iter == null)))){
var ret = self__.next_iter.next();
if(self__.next_iter.hasNext()){
} else {
(self__.next_iter = null);
}

return ret;
} else {
if(this$.advance()){
return this$.next();
} else {
throw (new Error("No such element"));

}
}
}
}));

(cljs.core.NodeIterator.prototype.remove = (function cljs$core$fn_17133(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.NodeIterator.getBasis = (function cljs$core$fn_17134(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-entry","next-entry",1091342476,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-iter","next-iter",1526626239,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.NodeIterator.cljs$lang$type = true);

(cljs.core.NodeIterator.cljs$lang$ctorStr = "cljs.core/NodeIterator");

(cljs.core.NodeIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_17135(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/NodeIterator");
}));

/**
 * Positional factory function for cljs.core/NodeIterator.
 */
cljs.core.__GT_NodeIterator = (function cljs$core$__GT_NodeIterator(arr,i,next_entry,next_iter){
return (new cljs.core.NodeIterator(arr,i,next_entry,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.BitmapIndexedNode = (function (edit,bitmap,arr){
this.edit = edit;
this.bitmap = bitmap;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.BitmapIndexedNode.prototype.ensure_editable = (function cljs$core$fn_17136(e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var n = cljs.core.bit_count(self__.bitmap);
var new_arr = (new Array((((n < (0)))?(4):((2) * (n + (1))))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * n));

return (new cljs.core.BitmapIndexedNode(e,self__.bitmap,new_arr));
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = (function cljs$core$fn_17137(edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
if((!((n == null)))){
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
} else {
if((self__.bitmap === bit)){
return null;
} else {
return inode.edit_and_remove_pair(edit__$1,bit,idx);

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
(removed_leaf_QMARK_.val = true);

return inode.edit_and_remove_pair(edit__$1,bit,idx);
} else {
return inode;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = (function cljs$core$fn_17138(e,bit,i){
var self__ = this;
var inode = this;
if((self__.bitmap === bit)){
return null;
} else {
var editable = inode.ensure_editable(e);
var earr = editable.arr;
var len = earr.length;
(editable.bitmap = (bit ^ editable.bitmap));

cljs.core.array_copy(earr,((2) * (i + (1))),earr,((2) * i),(len - ((2) * (i + (1)))));

(earr[(len - (2))] = null);

(earr[(len - (1))] = null);

return editable;
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_seq = (function cljs$core$fn_17139(){
var self__ = this;
var inode = this;
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr);
}));

(cljs.core.BitmapIndexedNode.prototype.kv_reduce = (function cljs$core$fn_17140(f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
}));

(cljs.core.BitmapIndexedNode.prototype.inode_lookup = (function cljs$core$fn_17141(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return val_or_node;
} else {
return not_found;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = (function cljs$core$fn_17142(edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((((2) * n) < self__.arr.length)){
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(added_leaf_QMARK_.val = true);

cljs.core.array_copy_downward(earr,((2) * idx),earr,((2) * (idx + (1))),((2) * (n - idx)));

(earr[((2) * idx)] = key);

(earr[(((2) * idx) + (1))] = val);

(editable.bitmap = (editable.bitmap | bit));

return editable;
} else {
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_17149 = (0);
var j_17150 = (0);
while(true){
if((i_17149 < (32))){
if((((self__.bitmap >>> i_17149) & (1)) === (0))){
var G__17151 = (i_17149 + (1));
var G__17152 = j_17150;
i_17149 = G__17151;
j_17150 = G__17152;
continue;
} else {
(nodes[i_17149] = (((!(((self__.arr[j_17150]) == null))))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),cljs.core.hash((self__.arr[j_17150])),(self__.arr[j_17150]),(self__.arr[(j_17150 + (1))]),added_leaf_QMARK_):(self__.arr[(j_17150 + (1))])));

var G__17153 = (i_17149 + (1));
var G__17154 = (j_17150 + (2));
i_17149 = G__17153;
j_17150 = G__17154;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(edit__$1,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (4)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

(added_leaf_QMARK_.val = true);

var editable = inode.ensure_editable(edit__$1);
(editable.arr = new_arr);

(editable.bitmap = (editable.bitmap | bit));

return editable;

}
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),val);
}
} else {
(added_leaf_QMARK_.val = true);

return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * idx),null,(((2) * idx) + (1)),cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(edit__$1,(shift + (5)),key_or_nil,val_or_node,hash,key,val));

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_assoc = (function cljs$core$fn_17143(shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_17155 = (0);
var j_17156 = (0);
while(true){
if((i_17155 < (32))){
if((((self__.bitmap >>> i_17155) & (1)) === (0))){
var G__17157 = (i_17155 + (1));
var G__17158 = j_17156;
i_17155 = G__17157;
j_17156 = G__17158;
continue;
} else {
(nodes[i_17155] = (((!(((self__.arr[j_17156]) == null))))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),cljs.core.hash((self__.arr[j_17156])),(self__.arr[j_17156]),(self__.arr[(j_17156 + (1))]),added_leaf_QMARK_):(self__.arr[(j_17156 + (1))])));

var G__17159 = (i_17155 + (1));
var G__17160 = (j_17156 + (2));
i_17155 = G__17159;
j_17156 = G__17160;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(null,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

(added_leaf_QMARK_.val = true);

return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap | bit),new_arr));
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),val)));
}
} else {
(added_leaf_QMARK_.val = true);

return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr,((2) * idx),null,(((2) * idx) + (1)),cljs.core.create_node.cljs$core$IFn$_invoke$arity$6((shift + (5)),key_or_nil,val_or_node,hash,key,val))));

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_find = (function cljs$core$fn_17144(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_find((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return (new cljs.core.MapEntry(key_or_nil,val_or_node,null));
} else {
return not_found;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_without = (function cljs$core$fn_17145(shift,hash,key){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without((shift + (5)),hash,key);
if((n === val_or_node)){
return inode;
} else {
if((!((n == null)))){
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
} else {
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));
}
} else {
return inode;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_17146(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
}));

(cljs.core.BitmapIndexedNode.getBasis = (function cljs$core$fn_17147(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"bitmap","bitmap",501334601,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.BitmapIndexedNode.cljs$lang$type = true);

(cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode");

(cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_17148(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/BitmapIndexedNode");
}));

/**
 * Positional factory function for cljs.core/BitmapIndexedNode.
 */
cljs.core.__GT_BitmapIndexedNode = (function cljs$core$__GT_BitmapIndexedNode(edit,bitmap,arr){
return (new cljs.core.BitmapIndexedNode(edit,bitmap,arr));
});

(cljs.core.BitmapIndexedNode.EMPTY = (new cljs.core.BitmapIndexedNode(null,(0),[])));
cljs.core.pack_array_node = (function cljs$core$pack_array_node(array_node,edit,idx){
var arr = array_node.arr;
var len = arr.length;
var new_arr = (new Array(((2) * (array_node.cnt - (1)))));
var i = (0);
var j = (1);
var bitmap = (0);
while(true){
if((i < len)){
if((((!((i === idx)))) && ((!(((arr[i]) == null)))))){
(new_arr[j] = (arr[i]));

var G__17161 = (i + (1));
var G__17162 = (j + (2));
var G__17163 = (bitmap | ((1) << i));
i = G__17161;
j = G__17162;
bitmap = G__17163;
continue;
} else {
var G__17164 = (i + (1));
var G__17165 = j;
var G__17166 = bitmap;
i = G__17164;
j = G__17165;
bitmap = G__17166;
continue;
}
} else {
return (new cljs.core.BitmapIndexedNode(edit,bitmap,new_arr));
}
break;
}
});

/**
* @constructor
*/
cljs.core.ArrayNodeIterator = (function (arr,i,next_iter){
this.arr = arr;
this.i = i;
this.next_iter = next_iter;
});
(cljs.core.ArrayNodeIterator.prototype.hasNext = (function cljs$core$fn_17167(){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if((!((((!((self__.next_iter == null)))) && (self__.next_iter.hasNext()))))){
if((self__.i < len)){
var node = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

if((!((node == null)))){
(self__.next_iter = cljs.core._iterator(node));
} else {
}

continue;
} else {
return false;
}
} else {
return true;
}
break;
}
}));

(cljs.core.ArrayNodeIterator.prototype.next = (function cljs$core$fn_17168(){
var self__ = this;
var this$ = this;
if(this$.hasNext()){
return self__.next_iter.next();
} else {
throw (new Error("No such element"));
}
}));

(cljs.core.ArrayNodeIterator.prototype.remove = (function cljs$core$fn_17169(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.ArrayNodeIterator.getBasis = (function cljs$core$fn_17170(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-iter","next-iter",1526626239,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayNodeIterator.cljs$lang$type = true);

(cljs.core.ArrayNodeIterator.cljs$lang$ctorStr = "cljs.core/ArrayNodeIterator");

(cljs.core.ArrayNodeIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_17171(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/ArrayNodeIterator");
}));

/**
 * Positional factory function for cljs.core/ArrayNodeIterator.
 */
cljs.core.__GT_ArrayNodeIterator = (function cljs$core$__GT_ArrayNodeIterator(arr,i,next_iter){
return (new cljs.core.ArrayNodeIterator(arr,i,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.ArrayNode = (function (edit,cnt,arr){
this.edit = edit;
this.cnt = cnt;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.ArrayNode.prototype.ensure_editable = (function cljs$core$fn_17172(e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
return (new cljs.core.ArrayNode(e,self__.cnt,cljs.core.aclone(self__.arr)));
}
}));

(cljs.core.ArrayNode.prototype.inode_without_BANG_ = (function cljs$core$fn_17173(edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return inode;
} else {
var n = node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,edit__$1,idx);
} else {
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
(editable.cnt = (editable.cnt - (1)));

return editable;
}
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);

}
}
}
}));

(cljs.core.ArrayNode.prototype.inode_seq = (function cljs$core$fn_17174(){
var self__ = this;
var inode = this;
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(self__.arr);
}));

(cljs.core.ArrayNode.prototype.kv_reduce = (function cljs$core$fn_17175(f,init){
var self__ = this;
var inode = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var node = (self__.arr[i]);
if((!((node == null)))){
var init__$2 = node.kv_reduce(f,init__$1);
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
var G__17184 = (i + (1));
var G__17185 = init__$2;
i = G__17184;
init__$1 = G__17185;
continue;
}
} else {
var G__17186 = (i + (1));
var G__17187 = init__$1;
i = G__17186;
init__$1 = G__17187;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.ArrayNode.prototype.inode_lookup = (function cljs$core$fn_17176(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
return node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
}));

(cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = (function cljs$core$fn_17177(edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));
(editable.cnt = (editable.cnt + (1)));

return editable;
} else {
var n = node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
}
}
}));

(cljs.core.ArrayNode.prototype.inode_assoc = (function cljs$core$fn_17178(shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return (new cljs.core.ArrayNode(null,(self__.cnt + (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_))));
} else {
var n = node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
}
}));

(cljs.core.ArrayNode.prototype.inode_find = (function cljs$core$fn_17179(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
return node.inode_find((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
}));

(cljs.core.ArrayNode.prototype.inode_without = (function cljs$core$fn_17180(shift,hash,key){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
var n = node.inode_without((shift + (5)),hash,key);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,null,idx);
} else {
return (new cljs.core.ArrayNode(null,(self__.cnt - (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));

}
}
} else {
return inode;
}
}));

(cljs.core.ArrayNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_17181(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeIterator(self__.arr,(0),null));
}));

(cljs.core.ArrayNode.getBasis = (function cljs$core$fn_17182(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayNode.cljs$lang$type = true);

(cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode");

(cljs.core.ArrayNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_17183(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/ArrayNode");
}));

/**
 * Positional factory function for cljs.core/ArrayNode.
 */
cljs.core.__GT_ArrayNode = (function cljs$core$__GT_ArrayNode(edit,cnt,arr){
return (new cljs.core.ArrayNode(edit,cnt,arr));
});

cljs.core.hash_collision_node_find_index = (function cljs$core$hash_collision_node_find_index(arr,cnt,key){
var lim = ((2) * cnt);
var i = (0);
while(true){
if((i < lim)){
if(cljs.core.key_test(key,(arr[i]))){
return i;
} else {
var G__17188 = (i + (2));
i = G__17188;
continue;
}
} else {
return (-1);
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.HashCollisionNode = (function (edit,collision_hash,cnt,arr){
this.edit = edit;
this.collision_hash = collision_hash;
this.cnt = cnt;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.HashCollisionNode.prototype.ensure_editable = (function cljs$core$fn_17189(e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var new_arr = (new Array(((2) * (self__.cnt + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * self__.cnt));

return (new cljs.core.HashCollisionNode(e,self__.collision_hash,self__.cnt,new_arr));
}
}));

(cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = (function cljs$core$fn_17190(edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
(removed_leaf_QMARK_.val = true);

if((self__.cnt === (1))){
return null;
} else {
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(earr[idx] = (earr[(((2) * self__.cnt) - (2))]));

(earr[(idx + (1))] = (earr[(((2) * self__.cnt) - (1))]));

(earr[(((2) * self__.cnt) - (1))] = null);

(earr[(((2) * self__.cnt) - (2))] = null);

(editable.cnt = (editable.cnt - (1)));

return editable;
}
}
}));

(cljs.core.HashCollisionNode.prototype.inode_seq = (function cljs$core$fn_17191(){
var self__ = this;
var inode = this;
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr);
}));

(cljs.core.HashCollisionNode.prototype.kv_reduce = (function cljs$core$fn_17192(f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
}));

(cljs.core.HashCollisionNode.prototype.inode_lookup = (function cljs$core$fn_17193(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);

}
}));

(cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = (function cljs$core$fn_17194(edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
if((self__.arr.length > ((2) * self__.cnt))){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * self__.cnt),key,(((2) * self__.cnt) + (1)),val);
(added_leaf_QMARK_.val = true);

(editable.cnt = (editable.cnt + (1)));

return editable;
} else {
var len = self__.arr.length;
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

(added_leaf_QMARK_.val = true);

return inode.ensure_editable_array(edit__$1,(self__.cnt + (1)),new_arr);
}
} else {
if(((self__.arr[(idx + (1))]) === val)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(idx + (1)),val);
}
}
} else {
return (new cljs.core.BitmapIndexedNode(edit__$1,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode,null,null])).inode_assoc_BANG_(edit__$1,shift,hash,key,val,added_leaf_QMARK_);
}
}));

(cljs.core.HashCollisionNode.prototype.inode_assoc = (function cljs$core$fn_17195(shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
var len = ((2) * self__.cnt);
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

(added_leaf_QMARK_.val = true);

return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt + (1)),new_arr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(idx + (1))]),val)){
return inode;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(idx + (1)),val)));
}
}
} else {
return (new cljs.core.BitmapIndexedNode(null,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode])).inode_assoc(shift,hash,key,val,added_leaf_QMARK_);
}
}));

(cljs.core.HashCollisionNode.prototype.ensure_editable_array = (function cljs$core$fn_17196(e,count,array){
var self__ = this;
var inode = this;
if((e === self__.edit)){
(self__.arr = array);

(self__.cnt = count);

return inode;
} else {
return (new cljs.core.HashCollisionNode(self__.edit,self__.collision_hash,count,array));
}
}));

(cljs.core.HashCollisionNode.prototype.inode_find = (function cljs$core$fn_17197(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
return (new cljs.core.MapEntry((self__.arr[idx]),(self__.arr[(idx + (1))]),null));

}
}));

(cljs.core.HashCollisionNode.prototype.inode_without = (function cljs$core$fn_17198(shift,hash,key){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
if((self__.cnt === (1))){
return null;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt - (1)),cljs.core.remove_pair(self__.arr,cljs.core.quot(idx,(2)))));

}
}
}));

(cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_17199(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
}));

(cljs.core.HashCollisionNode.getBasis = (function cljs$core$fn_17200(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"collision-hash","collision-hash",-35831342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.HashCollisionNode.cljs$lang$type = true);

(cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode");

(cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_17201(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/HashCollisionNode");
}));

/**
 * Positional factory function for cljs.core/HashCollisionNode.
 */
cljs.core.__GT_HashCollisionNode = (function cljs$core$__GT_HashCollisionNode(edit,collision_hash,cnt,arr){
return (new cljs.core.HashCollisionNode(edit,collision_hash,cnt,arr));
});

cljs.core.create_node = (function cljs$core$create_node(var_args){
var G__17203 = arguments.length;
switch (G__17203) {
case 6:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_17204(shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc(shift,key2hash,key2,val2,added_leaf_QMARK_);
}
}));

(cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = (function cljs$core$fn_17205(edit,shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc_BANG_(edit,shift,key2hash,key2,val2,added_leaf_QMARK_);
}
}));

(cljs.core.create_node.cljs$lang$maxFixedArity = 7);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.NodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.NodeSeq.prototype.toString = (function cljs$core$fn_17207(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.NodeSeq.prototype.equiv = (function cljs$core$fn_17208(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.NodeSeq.prototype.indexOf = (function() {
var cljs$core$fn_17209 = null;
var cljs$core$fn_17209__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_17209__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17209 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17209__1.call(this,x);
case 2:
return cljs$core$fn_17209__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17209.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17209__1;
cljs$core$fn_17209.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17209__2;
return cljs$core$fn_17209;
})()
);

(cljs.core.NodeSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_17210 = null;
var cljs$core$fn_17210__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_17210__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17210 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17210__1.call(this,x);
case 2:
return cljs$core$fn_17210__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17210.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17210__1;
cljs$core$fn_17210.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17210__2;
return cljs$core$fn_17210;
})()
);

(cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17211(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.NodeSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_17212(coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,(self__.i + (2)),null);
} else {
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s));
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17213(coll){
var self__ = this;
var coll__$1 = this;
var h__10045__auto__ = self__.__hash;
if((!((h__10045__auto__ == null)))){
return h__10045__auto__;
} else {
var h__10045__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10045__auto____$1);

return h__10045__auto____$1;
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17214(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17215(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17216(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17217(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_17218(coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return (new cljs.core.MapEntry((self__.nodes[self__.i]),(self__.nodes[(self__.i + (1))]),null));
} else {
return cljs.core.first(self__.s);
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_17219(coll){
var self__ = this;
var coll__$1 = this;
var ret = (((self__.s == null))?cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,(self__.i + (2)),null):cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s)));
if((!((ret == null)))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17220(this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17221(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.NodeSeq(new_meta,self__.nodes,self__.i,self__.s,self__.__hash));
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17222(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.NodeSeq.getBasis = (function cljs$core$fn_17223(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"nodes","nodes",-459054278,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.NodeSeq.cljs$lang$type = true);

(cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq");

(cljs.core.NodeSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_17224(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/NodeSeq");
}));

/**
 * Positional factory function for cljs.core/NodeSeq.
 */
cljs.core.__GT_NodeSeq = (function cljs$core$__GT_NodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.NodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17225(){
var this__10774__auto__ = this;
return cljs.core.es6_iterator(this__10774__auto__);
}));
cljs.core.create_inode_seq = (function cljs$core$create_inode_seq(var_args){
var G__17227 = arguments.length;
switch (G__17227) {
case 1:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17228(nodes){
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
}));

(cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_17229(nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
if((!(((nodes[j]) == null)))){
return (new cljs.core.NodeSeq(null,nodes,j,null,null));
} else {
var temp__5718__auto__ = (nodes[(j + (1))]);
if(cljs.core.truth_(temp__5718__auto__)){
var node = temp__5718__auto__;
var temp__5718__auto____$1 = node.inode_seq();
if(cljs.core.truth_(temp__5718__auto____$1)){
var node_seq = temp__5718__auto____$1;
return (new cljs.core.NodeSeq(null,nodes,(j + (2)),node_seq,null));
} else {
var G__17231 = (j + (2));
j = G__17231;
continue;
}
} else {
var G__17232 = (j + (2));
j = G__17232;
continue;
}
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.NodeSeq(null,nodes,i,s,null));
}
}));

(cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayNodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ArrayNodeSeq.prototype.toString = (function cljs$core$fn_17233(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ArrayNodeSeq.prototype.equiv = (function cljs$core$fn_17234(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ArrayNodeSeq.prototype.indexOf = (function() {
var cljs$core$fn_17235 = null;
var cljs$core$fn_17235__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_17235__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17235 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17235__1.call(this,x);
case 2:
return cljs$core$fn_17235__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17235.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17235__1;
cljs$core$fn_17235.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17235__2;
return cljs$core$fn_17235;
})()
);

(cljs.core.ArrayNodeSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_17236 = null;
var cljs$core$fn_17236__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_17236__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17236 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17236__1.call(this,x);
case 2:
return cljs$core$fn_17236__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17236.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17236__1;
cljs$core$fn_17236.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17236__2;
return cljs$core$fn_17236;
})()
);

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17237(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_17238(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s));
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17239(coll){
var self__ = this;
var coll__$1 = this;
var h__10045__auto__ = self__.__hash;
if((!((h__10045__auto__ == null)))){
return h__10045__auto__;
} else {
var h__10045__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10045__auto____$1);

return h__10045__auto____$1;
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17240(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17241(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17242(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17243(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_17244(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.s);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_17245(coll){
var self__ = this;
var coll__$1 = this;
var ret = cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s));
if((!((ret == null)))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17246(this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17247(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ArrayNodeSeq(new_meta,self__.nodes,self__.i,self__.s,self__.__hash));
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17248(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.ArrayNodeSeq.getBasis = (function cljs$core$fn_17249(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"nodes","nodes",-459054278,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayNodeSeq.cljs$lang$type = true);

(cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq");

(cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_17250(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/ArrayNodeSeq");
}));

/**
 * Positional factory function for cljs.core/ArrayNodeSeq.
 */
cljs.core.__GT_ArrayNodeSeq = (function cljs$core$__GT_ArrayNodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17251(){
var this__10774__auto__ = this;
return cljs.core.es6_iterator(this__10774__auto__);
}));
cljs.core.create_array_node_seq = (function cljs$core$create_array_node_seq(var_args){
var G__17253 = arguments.length;
switch (G__17253) {
case 1:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17254(nodes){
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
}));

(cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_17255(nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
var temp__5718__auto__ = (nodes[j]);
if(cljs.core.truth_(temp__5718__auto__)){
var nj = temp__5718__auto__;
var temp__5718__auto____$1 = nj.inode_seq();
if(cljs.core.truth_(temp__5718__auto____$1)){
var ns = temp__5718__auto____$1;
return (new cljs.core.ArrayNodeSeq(null,nodes,(j + (1)),ns,null));
} else {
var G__17257 = (j + (1));
j = G__17257;
continue;
}
} else {
var G__17258 = (j + (1));
j = G__17258;
continue;
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.ArrayNodeSeq(null,nodes,i,s,null));
}
}));

(cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 3);


/**
* @constructor
*/
cljs.core.HashMapIter = (function (nil_val,root_iter,seen){
this.nil_val = nil_val;
this.root_iter = root_iter;
this.seen = seen;
});
(cljs.core.HashMapIter.prototype.hasNext = (function cljs$core$fn_17259(){
var self__ = this;
var _ = this;
return (((!(self__.seen))) || (self__.root_iter.hasNext()));
}));

(cljs.core.HashMapIter.prototype.next = (function cljs$core$fn_17260(){
var self__ = this;
var _ = this;
if((!(self__.seen))){
(self__.seen = true);

return (new cljs.core.MapEntry(null,self__.nil_val,null));
} else {
return self__.root_iter.next();
}
}));

(cljs.core.HashMapIter.prototype.remove = (function cljs$core$fn_17261(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.HashMapIter.getBasis = (function cljs$core$fn_17262(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),new cljs.core.Symbol(null,"root-iter","root-iter",1974672108,null),cljs.core.with_meta(new cljs.core.Symbol(null,"seen","seen",1121531738,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.HashMapIter.cljs$lang$type = true);

(cljs.core.HashMapIter.cljs$lang$ctorStr = "cljs.core/HashMapIter");

(cljs.core.HashMapIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_17263(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/HashMapIter");
}));

/**
 * Positional factory function for cljs.core/HashMapIter.
 */
cljs.core.__GT_HashMapIter = (function cljs$core$__GT_HashMapIter(nil_val,root_iter,seen){
return (new cljs.core.HashMapIter(nil_val,root_iter,seen));
});


/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentHashMap = (function (meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
this.meta = meta;
this.cnt = cnt;
this.root = root;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 139268;
});
(cljs.core.PersistentHashMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentHashMap.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_17265(coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.MapEntry(null,self__.nil_val,null));
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_find((0),cljs.core.hash(k),k,null);

}
}
}));

(cljs.core.PersistentHashMap.prototype.toString = (function cljs$core$fn_17266(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentHashMap.prototype.equiv = (function cljs$core$fn_17267(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentHashMap.prototype.keys = (function cljs$core$fn_17268(){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.keys(coll));
}));

(cljs.core.PersistentHashMap.prototype.entries = (function cljs$core$fn_17269(){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentHashMap.prototype.values = (function cljs$core$fn_17270(){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.vals(coll));
}));

(cljs.core.PersistentHashMap.prototype.has = (function cljs$core$fn_17271(k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
}));

(cljs.core.PersistentHashMap.prototype.get = (function cljs$core$fn_17272(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentHashMap.prototype.forEach = (function cljs$core$fn_17273(f){
var self__ = this;
var coll = this;
var seq__17274 = cljs.core.seq(coll);
var chunk__17275 = null;
var count__17276 = (0);
var i__17277 = (0);
while(true){
if((i__17277 < count__17276)){
var vec__17284 = chunk__17275.cljs$core$IIndexed$_nth$arity$2(null,i__17277);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17284,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17284,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__17316 = seq__17274;
var G__17317 = chunk__17275;
var G__17318 = count__17276;
var G__17319 = (i__17277 + (1));
seq__17274 = G__17316;
chunk__17275 = G__17317;
count__17276 = G__17318;
i__17277 = G__17319;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__17274);
if(temp__5720__auto__){
var seq__17274__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__17274__$1)){
var c__10556__auto__ = cljs.core.chunk_first(seq__17274__$1);
var G__17320 = cljs.core.chunk_rest(seq__17274__$1);
var G__17321 = c__10556__auto__;
var G__17322 = cljs.core.count(c__10556__auto__);
var G__17323 = (0);
seq__17274 = G__17320;
chunk__17275 = G__17321;
count__17276 = G__17322;
i__17277 = G__17323;
continue;
} else {
var vec__17287 = cljs.core.first(seq__17274__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17287,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17287,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__17324 = cljs.core.next(seq__17274__$1);
var G__17325 = null;
var G__17326 = (0);
var G__17327 = (0);
seq__17274 = G__17324;
chunk__17275 = G__17325;
count__17276 = G__17326;
i__17277 = G__17327;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_17290(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_17291(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function cljs$core$fn_17292(coll,f,init){
var self__ = this;
var coll__$1 = this;
var init__$1 = ((self__.has_nil_QMARK_)?(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(init,null,self__.nil_val) : f.call(null,init,null,self__.nil_val)):init);
if(cljs.core.reduced_QMARK_(init__$1)){
return cljs.core.deref(init__$1);
} else {
if((!((self__.root == null)))){
return cljs.core.unreduced(self__.root.kv_reduce(f,init__$1));
} else {
return init__$1;

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_17293(coll){
var self__ = this;
var coll__$1 = this;
var root_iter = ((self__.root)?cljs.core._iterator(self__.root):cljs.core.nil_iter());
if(self__.has_nil_QMARK_){
return (new cljs.core.HashMapIter(self__.nil_val,root_iter,false));
} else {
return root_iter;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17294(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_17295(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashMap(self__.meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17296(coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17297(coll){
var self__ = this;
var coll__$1 = this;
var h__10045__auto__ = self__.__hash;
if((!((h__10045__auto__ == null)))){
return h__10045__auto__;
} else {
var h__10045__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__10045__auto____$1);

return h__10045__auto____$1;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17298(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function cljs$core$fn_17299(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashMap(({}),self__.root,self__.cnt,self__.has_nil_QMARK_,self__.nil_val));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17302(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY,self__.meta);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function cljs$core$fn_17303(coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),self__.root,false,null,null));
} else {
return coll__$1;
}
} else {
if((self__.root == null)){
return coll__$1;
} else {
var new_root = self__.root.inode_without((0),cljs.core.hash(k),k);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_17304(coll,k,v){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(((self__.has_nil_QMARK_) && ((v === self__.nil_val)))){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((self__.has_nil_QMARK_)?self__.cnt:(self__.cnt + (1))),self__.root,true,v,null));
}
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var new_root = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc((0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((added_leaf_QMARK_.val)?(self__.cnt + (1)):self__.cnt),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_17305(coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
return self__.has_nil_QMARK_;
} else {
if((self__.root == null)){
return false;
} else {
return (!((self__.root.inode_lookup((0),cljs.core.hash(k),k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)));

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17306(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var s = (((!((self__.root == null))))?self__.root.inode_seq():null);
if(self__.has_nil_QMARK_){
return cljs.core.cons((new cljs.core.MapEntry(null,self__.nil_val,null)),s);
} else {
return s;
}
} else {
return null;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17307(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(new_meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17308(coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__17328 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__17329 = cljs.core.next(es);
ret = G__17328;
es = G__17329;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
}));

(cljs.core.PersistentHashMap.prototype.call = (function() {
var cljs$core$fn_17309 = null;
var cljs$core$fn_17309__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var cljs$core$fn_17309__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
cljs$core$fn_17309 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_17309__2.call(this,self__,k);
case 3:
return cljs$core$fn_17309__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_17309.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17309__2;
cljs$core$fn_17309.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_17309__3;
return cljs$core$fn_17309;
})()
);

(cljs.core.PersistentHashMap.prototype.apply = (function cljs$core$fn_17310(self__,args17264){
var self__ = this;
var self____$1 = this;
var args__10187__auto__ = cljs.core.aclone(args17264);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10187__auto__.length > (20)))?(function (){var G__17311 = args__10187__auto__.slice((0),(20));
G__17311.push(args__10187__auto__.slice((20)));

return G__17311;
})():args__10187__auto__)));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17312(k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_17313(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentHashMap.getBasis = (function cljs$core$fn_17314(){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"root","root",1191874074,null),cljs.core.with_meta(new cljs.core.Symbol(null,"has-nil?","has-nil?",825886722,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)], null)),new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentHashMap.cljs$lang$type = true);

(cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap");

(cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = (function cljs$core$fn_17315(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/PersistentHashMap");
}));

/**
 * Positional factory function for cljs.core/PersistentHashMap.
 */
cljs.core.__GT_PersistentHashMap = (function cljs$core$__GT_PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
return (new cljs.core.PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash));
});

(cljs.core.PersistentHashMap.EMPTY = (new cljs.core.PersistentHashMap(null,(0),null,false,null,cljs.core.empty_unordered_hash)));
(cljs.core.PersistentHashMap.fromArray = (function cljs$core$fn_17330(arr,no_clone){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__17331 = (i + (2));
var G__17332 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__17331;
ret = G__17332;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
}));
(cljs.core.PersistentHashMap.fromArrays = (function cljs$core$fn_17333(ks,vs){
var len = ks.length;
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
if((vs.length <= i)){
throw (new Error(["No value supplied for key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((ks[i]))].join('')));
} else {
var G__17334 = (i + (1));
var G__17335 = cljs.core._assoc_BANG_(out,(ks[i]),(vs[i]));
i = G__17334;
out = G__17335;
continue;
}
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}));
(cljs.core.PersistentHashMap.createWithCheck = (function cljs$core$fn_17336(arr){
var len = arr.length;
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i_17337 = (0);
while(true){
if((i_17337 < len)){
cljs.core._assoc_BANG_(ret,(arr[i_17337]),(arr[(i_17337 + (1))]));

if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core._count(ret),((i_17337 / (2)) + (1)))){
throw (new Error(["Duplicate key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arr[i_17337]))].join('')));
} else {
var G__17338 = (i_17337 + (2));
i_17337 = G__17338;
continue;
}
} else {
}
break;
}

return cljs.core._persistent_BANG_(ret);
}));
(cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17339(){
var this__10774__auto__ = this;
return cljs.core.es6_iterator(this__10774__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientHashMap = (function (edit,root,count,has_nil_QMARK_,nil_val){
this.edit = edit;
this.root = root;
this.count = count;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 56;
});
(cljs.core.TransientHashMap.prototype.conj_BANG_ = (function cljs$core$fn_17341(o){
var self__ = this;
var tcoll = this;
if(self__.edit){
if(cljs.core.map_entry_QMARK_(o)){
return tcoll.assoc_BANG_(cljs.core.key(o),cljs.core.val(o));
} else {
if(cljs.core.vector_QMARK_(o)){
return tcoll.assoc_BANG_((o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((0)) : o.call(null,(0))),(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((1)) : o.call(null,(1))));
} else {
var es = cljs.core.seq(o);
var tcoll__$1 = tcoll;
while(true){
var temp__5718__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__5718__auto__)){
var e = temp__5718__auto__;
var G__17359 = cljs.core.next(es);
var G__17360 = tcoll__$1.assoc_BANG_(cljs.core.key(e),cljs.core.val(e));
es = G__17359;
tcoll__$1 = G__17360;
continue;
} else {
return tcoll__$1;
}
break;
}

}
}
} else {
throw (new Error("conj! after persistent"));
}
}));

(cljs.core.TransientHashMap.prototype.assoc_BANG_ = (function cljs$core$fn_17342(k,v){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if((self__.nil_val === v)){
} else {
(self__.nil_val = v);
}

if(self__.has_nil_QMARK_){
} else {
(self__.count = (self__.count + (1)));

(self__.has_nil_QMARK_ = true);
}

return tcoll;
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var node = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc_BANG_(self__.edit,(0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((node === self__.root)){
} else {
(self__.root = node);
}

if(added_leaf_QMARK_.val){
(self__.count = (self__.count + (1)));
} else {
}

return tcoll;
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.without_BANG_ = (function cljs$core$fn_17343(k){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if(self__.has_nil_QMARK_){
(self__.has_nil_QMARK_ = false);

(self__.nil_val = null);

(self__.count = (self__.count - (1)));

return tcoll;
} else {
return tcoll;
}
} else {
if((self__.root == null)){
return tcoll;
} else {
var removed_leaf_QMARK_ = (new cljs.core.Box(false));
var node = self__.root.inode_without_BANG_(self__.edit,(0),cljs.core.hash(k),k,removed_leaf_QMARK_);
if((node === self__.root)){
} else {
(self__.root = node);
}

if(removed_leaf_QMARK_.val){
(self__.count = (self__.count - (1)));
} else {
}

return tcoll;
}
}
} else {
throw (new Error("dissoc! after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.persistent_BANG_ = (function cljs$core$fn_17344(){
var self__ = this;
var tcoll = this;
if(self__.edit){
(self__.edit = null);

return (new cljs.core.PersistentHashMap(null,self__.count,self__.root,self__.has_nil_QMARK_,self__.nil_val,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17345(coll){
var self__ = this;
var coll__$1 = this;
if(self__.edit){
return self__.count;
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_17346(tcoll,k){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k);
}
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_17347(tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);
}
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function cljs$core$fn_17348(tcoll,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.conj_BANG_(val);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function cljs$core$fn_17349(tcoll){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.persistent_BANG_();
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function cljs$core$fn_17350(tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.assoc_BANG_(key,val);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function cljs$core$fn_17351(tcoll,key){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.without_BANG_(key);
}));

(cljs.core.TransientHashMap.prototype.call = (function() {
var cljs$core$fn_17352 = null;
var cljs$core$fn_17352__2 = (function (self__,key){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$2(null,key);
});
var cljs$core$fn_17352__3 = (function (self__,key,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
});
cljs$core$fn_17352 = function(self__,key,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_17352__2.call(this,self__,key);
case 3:
return cljs$core$fn_17352__3.call(this,self__,key,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_17352.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17352__2;
cljs$core$fn_17352.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_17352__3;
return cljs$core$fn_17352;
})()
);

(cljs.core.TransientHashMap.prototype.apply = (function cljs$core$fn_17353(self__,args17340){
var self__ = this;
var self____$1 = this;
var args__10187__auto__ = cljs.core.aclone(args17340);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10187__auto__.length > (20)))?(function (){var G__17354 = args__10187__auto__.slice((0),(20));
G__17354.push(args__10187__auto__.slice((20)));

return G__17354;
})():args__10187__auto__)));
}));

(cljs.core.TransientHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17355(key){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$2(null,key);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_17356(key,not_found){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
}));

(cljs.core.TransientHashMap.getBasis = (function cljs$core$fn_17357(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"has-nil?","has-nil?",825886722,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.TransientHashMap.cljs$lang$type = true);

(cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap");

(cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = (function cljs$core$fn_17358(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/TransientHashMap");
}));

/**
 * Positional factory function for cljs.core/TransientHashMap.
 */
cljs.core.__GT_TransientHashMap = (function cljs$core$__GT_TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val){
return (new cljs.core.TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val));
});

cljs.core.tree_map_seq_push = (function cljs$core$tree_map_seq_push(node,stack,ascending_QMARK_){
var t = node;
var stack__$1 = stack;
while(true){
if((!((t == null)))){
var G__17361 = ((ascending_QMARK_)?t.left:t.right);
var G__17362 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1,t);
t = G__17361;
stack__$1 = G__17362;
continue;
} else {
return stack__$1;
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentTreeMapSeq = (function (meta,stack,ascending_QMARK_,cnt,__hash){
this.meta = meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.PersistentTreeMapSeq.prototype.toString = (function cljs$core$fn_17363(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentTreeMapSeq.prototype.equiv = (function cljs$core$fn_17364(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentTreeMapSeq.prototype.indexOf = (function() {
var cljs$core$fn_17365 = null;
var cljs$core$fn_17365__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_17365__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17365 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17365__1.call(this,x);
case 2:
return cljs$core$fn_17365__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17365.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17365__1;
cljs$core$fn_17365.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17365__2;
return cljs$core$fn_17365;
})()
);

(cljs.core.PersistentTreeMapSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_17366 = null;
var cljs$core$fn_17366__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_17366__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17366 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17366__1.call(this,x);
case 2:
return cljs$core$fn_17366__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17366.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17366__1;
cljs$core$fn_17366.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17366__2;
return cljs$core$fn_17366;
})()
);

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17367(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_17368(this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if((next_stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17369(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt < (0))){
return (cljs.core.count(cljs.core.next(coll__$1)) + (1));
} else {
return self__.cnt;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17370(coll){
var self__ = this;
var coll__$1 = this;
var h__10045__auto__ = self__.__hash;
if((!((h__10045__auto__ == null)))){
return h__10045__auto__;
} else {
var h__10045__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10045__auto____$1);

return h__10045__auto____$1;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17371(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17372(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17373(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17374(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_17375(this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.peek(self__.stack);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_17376(this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if((!((next_stack == null)))){
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17377(this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17378(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMapSeq(new_meta,self__.stack,self__.ascending_QMARK_,self__.cnt,self__.__hash));
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17379(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.getBasis = (function cljs$core$fn_17380(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"stack","stack",847125597,null),cljs.core.with_meta(new cljs.core.Symbol(null,"ascending?","ascending?",-1938452653,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)], null)),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentTreeMapSeq.cljs$lang$type = true);

(cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq");

(cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_17381(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/PersistentTreeMapSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentTreeMapSeq.
 */
cljs.core.__GT_PersistentTreeMapSeq = (function cljs$core$__GT_PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash){
return (new cljs.core.PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash));
});

(cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17382(){
var this__10774__auto__ = this;
return cljs.core.es6_iterator(this__10774__auto__);
}));
cljs.core.create_tree_map_seq = (function cljs$core$create_tree_map_seq(tree,ascending_QMARK_,cnt){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.tree_map_seq_push(tree,null,ascending_QMARK_),ascending_QMARK_,cnt,null));
});

cljs.core.balance_left = (function cljs$core$balance_left(key,val,ins,right){
if((ins instanceof cljs.core.RedNode)){
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,ins.left.blacken(),(new cljs.core.BlackNode(key,val,ins.right,right,null)),null));
} else {
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.right.key,ins.right.val,(new cljs.core.BlackNode(ins.key,ins.val,ins.left,ins.right.left,null)),(new cljs.core.BlackNode(key,val,ins.right.right,right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));
}
});
cljs.core.balance_right = (function cljs$core$balance_right(key,val,left,ins){
if((ins instanceof cljs.core.RedNode)){
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,(new cljs.core.BlackNode(key,val,left,ins.left,null)),ins.right.blacken(),null));
} else {
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.left.key,ins.left.val,(new cljs.core.BlackNode(key,val,left,ins.left.left,null)),(new cljs.core.BlackNode(ins.key,ins.val,ins.left.right,ins.right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));
}
});
cljs.core.balance_left_del = (function cljs$core$balance_left_del(key,val,del,right){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,del.blacken(),right,null));
} else {
if((right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right(key,val,del,right.redden());
} else {
if((((right instanceof cljs.core.RedNode)) && ((right.left instanceof cljs.core.BlackNode)))){
return (new cljs.core.RedNode(right.left.key,right.left.val,(new cljs.core.BlackNode(key,val,del,right.left.left,null)),cljs.core.balance_right(right.key,right.val,right.left.right,right.right.redden()),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.balance_right_del = (function cljs$core$balance_right_del(key,val,left,del){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,left,del.blacken(),null));
} else {
if((left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left(key,val,left.redden(),del);
} else {
if((((left instanceof cljs.core.RedNode)) && ((left.right instanceof cljs.core.BlackNode)))){
return (new cljs.core.RedNode(left.right.key,left.right.val,cljs.core.balance_left(left.key,left.val,left.left.redden(),left.right.left),(new cljs.core.BlackNode(key,val,left.right.right,del,null)),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.tree_map_kv_reduce = (function cljs$core$tree_map_kv_reduce(node,f,init){
var init__$1 = (((!((node.left == null))))?(function (){var G__17383 = node.left;
var G__17384 = f;
var G__17385 = init;
return (cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__17383,G__17384,G__17385) : cljs.core.tree_map_kv_reduce.call(null,G__17383,G__17384,G__17385));
})():init);
if(cljs.core.reduced_QMARK_(init__$1)){
return init__$1;
} else {
var init__$2 = (function (){var G__17386 = init__$1;
var G__17387 = node.key;
var G__17388 = node.val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17386,G__17387,G__17388) : f.call(null,G__17386,G__17387,G__17388));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
if((!((node.right == null)))){
var G__17389 = node.right;
var G__17390 = f;
var G__17391 = init__$2;
return (cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__17389,G__17390,G__17391) : cljs.core.tree_map_kv_reduce.call(null,G__17389,G__17390,G__17391));
} else {
return init__$2;
}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.BlackNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.BlackNode.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.BlackNode.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_17393(node,k){
var self__ = this;
var node__$1 = this;
var G__17394 = k;
switch (G__17394) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.BlackNode.prototype.lastIndexOf = (function() {
var cljs$core$fn_17395 = null;
var cljs$core$fn_17395__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_17395__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17395 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17395__1.call(this,x);
case 2:
return cljs$core$fn_17395__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17395.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17395__1;
cljs$core$fn_17395.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17395__2;
return cljs$core$fn_17395;
})()
);

(cljs.core.BlackNode.prototype.indexOf = (function() {
var cljs$core$fn_17396 = null;
var cljs$core$fn_17396__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_17396__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17396 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17396__1.call(this,x);
case 2:
return cljs$core$fn_17396__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17396.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17396__1;
cljs$core$fn_17396.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17396__2;
return cljs$core$fn_17396;
})()
);

(cljs.core.BlackNode.prototype.add_right = (function cljs$core$fn_17397(ins){
var self__ = this;
var node = this;
return ins.balance_right(node);
}));

(cljs.core.BlackNode.prototype.redden = (function cljs$core$fn_17398(){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,self__.right,null));
}));

(cljs.core.BlackNode.prototype.blacken = (function cljs$core$fn_17399(){
var self__ = this;
var node = this;
return node;
}));

(cljs.core.BlackNode.prototype.add_left = (function cljs$core$fn_17400(ins){
var self__ = this;
var node = this;
return ins.balance_left(node);
}));

(cljs.core.BlackNode.prototype.replace = (function cljs$core$fn_17401(key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(key__$1,val__$1,left__$1,right__$1,null));
}));

(cljs.core.BlackNode.prototype.balance_left = (function cljs$core$fn_17402(parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));
}));

(cljs.core.BlackNode.prototype.balance_right = (function cljs$core$fn_17403(parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));
}));

(cljs.core.BlackNode.prototype.remove_left = (function cljs$core$fn_17404(del){
var self__ = this;
var node = this;
return cljs.core.balance_left_del(self__.key,self__.val,del,self__.right);
}));

(cljs.core.BlackNode.prototype.kv_reduce = (function cljs$core$fn_17405(f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
}));

(cljs.core.BlackNode.prototype.remove_right = (function cljs$core$fn_17406(del){
var self__ = this;
var node = this;
return cljs.core.balance_right_del(self__.key,self__.val,self__.left,del);
}));

(cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_17407(node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
}));

(cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_17408(node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_17409(node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_17410(node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function cljs$core$fn_17411(node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
}));

(cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17412(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17413(node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function cljs$core$fn_17414(node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function cljs$core$fn_17415(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_17416(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_17417(node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.BlackNode.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_17418(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17419(coll){
var self__ = this;
var coll__$1 = this;
var h__10045__auto__ = self__.__hash;
if((!((h__10045__auto__ == null)))){
return h__10045__auto__;
} else {
var h__10045__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10045__auto____$1);

return h__10045__auto____$1;
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17420(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17421(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17422(node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
}));

(cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17423(node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
}));

(cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_17424(node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.BlackNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_17425(node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17426(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17427(node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core._with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17428(node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.BlackNode.prototype.call = (function() {
var cljs$core$fn_17429 = null;
var cljs$core$fn_17429__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var cljs$core$fn_17429__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
cljs$core$fn_17429 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_17429__2.call(this,self__,k);
case 3:
return cljs$core$fn_17429__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_17429.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17429__2;
cljs$core$fn_17429.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_17429__3;
return cljs$core$fn_17429;
})()
);

(cljs.core.BlackNode.prototype.apply = (function cljs$core$fn_17430(self__,args17392){
var self__ = this;
var self____$1 = this;
var args__10187__auto__ = cljs.core.aclone(args17392);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10187__auto__.length > (20)))?(function (){var G__17431 = args__10187__auto__.slice((0),(20));
G__17431.push(args__10187__auto__.slice((20)));

return G__17431;
})():args__10187__auto__)));
}));

(cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17432(k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_17433(k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.BlackNode.getBasis = (function cljs$core$fn_17434(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"left","left",1241415590,null),new cljs.core.Symbol(null,"right","right",1187949694,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.BlackNode.cljs$lang$type = true);

(cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode");

(cljs.core.BlackNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_17435(this__10261__auto__,writer__10262__auto__,opt__10263__auto__){
return cljs.core._write(writer__10262__auto__,"cljs.core/BlackNode");
}));

/**
 * Positional factory function for cljs.core/BlackNode.
 */
cljs.core.__GT_BlackNode = (function cljs$core$__GT_BlackNode(key,val,left,right,__hash){
return (new cljs.core.BlackNode(key,val,left,right,__hash));
});

(cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17437(){
var this__10774__auto__ = this;
return cljs.core.es6_iterator(this__10774__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RedNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.RedNode.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.RedNode.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_17439(node,k){
var self__ = this;
var node__$1 = this;
var G__17440 = k;
switch (G__17440) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.RedNode.prototype.lastIndexOf = (function() {
var cljs$core$fn_17441 = null;
var cljs$core$fn_17441__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_17441__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17441 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17441__1.call(this,x);
case 2:
return cljs$core$fn_17441__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17441.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17441__1;
cljs$core$fn_17441.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17441__2;
return cljs$core$fn_17441;
})()
);

(cljs.core.RedNode.prototype.indexOf = (function() {
var cljs$core$fn_17442 = null;
var cljs$core$fn_17442__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_17442__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17442 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17442__1.call(this,x);
case 2:
return cljs$core$fn_17442__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17442.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17442__1;
cljs$core$fn_17442.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17442__2;
return cljs$core$fn_17442;
})()
);

(cljs.core.RedNode.prototype.add_right = (function cljs$core$fn_17443(ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,ins,null));
}));

(cljs.core.RedNode.prototype.redden = (function cljs$core$fn_17444(){
var self__ = this;
var node = this;
throw (new Error("red-black tree invariant violation"));
}));

(cljs.core.RedNode.prototype.blacken = (function cljs$core$fn_17445(){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right,null));
}));

(cljs.core.RedNode.prototype.add_left = (function cljs$core$fn_17446(ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,ins,self__.right,null));
}));

(cljs.core.RedNode.prototype.replace = (function cljs$core$fn_17447(key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(key__$1,val__$1,left__$1,right__$1,null));
}));

(cljs.core.RedNode.prototype.balance_left = (function cljs$core$fn_17448(parent){
var self__ = this;
var node = this;
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,self__.left.blacken(),(new cljs.core.BlackNode(parent.key,parent.val,self__.right,parent.right,null)),null));
} else {
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.right.key,self__.right.val,(new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right.left,null)),(new cljs.core.BlackNode(parent.key,parent.val,self__.right.right,parent.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));

}
}
}));

(cljs.core.RedNode.prototype.balance_right = (function cljs$core$fn_17449(parent){
var self__ = this;
var node = this;
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left,null)),self__.right.blacken(),null));
} else {
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.left.key,self__.left.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left.left,null)),(new cljs.core.BlackNode(self__.key,self__.val,self__.left.right,self__.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));

}
}
}));

(cljs.core.RedNode.prototype.remove_left = (function cljs$core$fn_17450(del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,del,self__.right,null));
}));

(cljs.core.RedNode.prototype.kv_reduce = (function cljs$core$fn_17451(f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
}));

(cljs.core.RedNode.prototype.remove_right = (function cljs$core$fn_17452(del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,del,null));
}));

(cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_17453(node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
}));

(cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_17454(node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_17455(node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_17456(node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function cljs$core$fn_17457(node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
}));

(cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17458(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17459(node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function cljs$core$fn_17460(node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function cljs$core$fn_17461(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_17462(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_17463(node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.RedNode.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_17464(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17465(coll){
var self__ = this;
var coll__$1 = this;
var h__10045__auto__ = self__.__hash;
if((!((h__10045__auto__ == null)))){
return h__10045__auto__;
} else {
var h__10045__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10045__auto____$1);

return h__10045__auto____$1;
}
}));

(cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17466(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17467(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17468(node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
}));

(cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17469(node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
}));

(cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_17470(node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.RedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_17471(node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17472(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17473(node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core._with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17474(node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.RedNode.prototype.call = (function() {
var cljs$core$fn_17475 = null;
var cljs$core$fn_17475__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var cljs$core$fn_17475__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
cljs$core$fn_17475 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_17475__2.call(this,self__,k);
case 3:
return cljs$core$fn_17475__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_17475.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17475__2;
cljs$core$fn_17475.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_17475__3;
return cljs$core$fn_17475;
})()
);

(cljs.core.RedNode.prototype.apply = (function cljs$core$fn_17476(self__,args17438){
var self__ = this;
var self____$1 = this;
var args__10187__auto__ = cljs.core.aclone(args17438);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10187__auto__.length > (20)))?(function (){var G__17477 = args__10187__auto__.slice((0),(20));
G__17477.push(args__10187__auto__.slice((20)));

return G__17477;
})():args__10187__auto__)));
}));

(cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17478(k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_17479(k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.RedNode.getBasis = (function cljs$core$fn_17480(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null)