;; Copyright (c) Rich Hickey. All rights reserved.
;; The use and distribution terms for this software are covered by the
;; Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
;; which can be found in the file epl-v10.html at the root of this distribution.
;; By using this software in any fashion, you are agreeing to be bound by
;; the terms of this license.
;; You must not remove this notice, or any other, from this software.

(ns cljs.analyzer.passes.lite
  (:refer-clojure :exclude [var?]))

(defn var? [ast]
  (= :var (:op ast)))

(def ctor->ctor-lite
  '{cljs.core/vector cljs.core/vector-lite
    cljs.core/vec    cljs.core/vec-lite})

(defn update-var [{:keys [name] :as ast}]
  (let [replacement (get ctor->ctor-lite name)]
    (-> ast
      (assoc :name replacement)
      (assoc-in [:info :name] replacement))))

(defn replace-var? [ast]
  (and (var? ast)
       (contains? ctor->ctor-lite (:name ast))))

(defn use-lite-types
  [env ast _]
  (cond-> ast
    (replace-var? ast) update-var))
