// Compiled by ClojureScript 1.11.132 {:static-fns true, :optimizations :none}
goog.provide('cljs.core');
goog.require('goog.math.Integer');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.string.StringBuffer');
goog.require('goog.math.Long');
goog.scope(function(){
cljs.core.goog$module$goog$math$Long = goog.module.get('goog.math.Long');
});
goog.require('goog.object');
goog.scope(function(){
cljs.core.goog$module$goog$object = goog.module.get('goog.object');
});
goog.require('goog.array');
goog.scope(function(){
cljs.core.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core._STAR_clojurescript_version_STAR_ = "1.11.132";
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_unchecked_arrays_STAR_ = false;
cljs.core._STAR_warn_on_infer_STAR_ = false;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.PROTOCOL_SENTINEL !== 'undefined')){
} else {
cljs.core.PROTOCOL_SENTINEL = ({});
}
cljs.core.MODULE_URIS = null;
cljs.core.MODULE_INFOS = null;

/**
 * Var bound to the name value of the compiler build :target option.
 *   For example, if the compiler build :target is :nodejs, *target* will be bound
 *   to "nodejs". *target* is a Google Closure define and can be set by compiler
 *   :closure-defines option.
 * @define {string}
 */
cljs.core._STAR_target_STAR_ = goog.define("cljs.core._STAR_target_STAR_","default");

/**
 * Manually set the JavaScript global context. Only "window", "self"
 *   , and "global" supported. 
 * @define {string}
 */
cljs.core._STAR_global_STAR_ = goog.define("cljs.core._STAR_global_STAR_","default");
/**
 * Var bound to the current namespace. Only used for bootstrapping.
 * @type {*}
 */
cljs.core._STAR_ns_STAR_ = null;
/**
 * @type {*}
 */
cljs.core._STAR_out_STAR_ = null;
cljs.core._STAR_assert_STAR_ = true;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_print_fn_STAR_ !== 'undefined')){
} else {
/**
 * Each runtime environment provides a different way to print output.
 *   Whatever function *print-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_fn_STAR_ = null;
}
/**
 * Arranges to have tap functions executed via the supplied f, a
 *   function of no arguments. Returns true if successful, false otherwise.
 */
cljs.core._STAR_exec_tap_fn_STAR_ = (function cljs$core$_STAR_exec_tap_fn_STAR_(f){
return (((typeof setTimeout !== 'undefined')) && (cljs.core.boolean$(setTimeout(f,(0)))));
});
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_print_err_fn_STAR_ !== 'undefined')){
} else {
/**
 * Each runtime environment provides a different way to print error output.
 *   Whatever function *print-err-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_err_fn_STAR_ = null;
}
/**
 * Set *print-fn* to f.
 */
cljs.core.set_print_fn_BANG_ = (function cljs$core$set_print_fn_BANG_(f){
return (cljs.core._STAR_print_fn_STAR_ = f);
});
/**
 * Set *print-err-fn* to f.
 */
cljs.core.set_print_err_fn_BANG_ = (function cljs$core$set_print_err_fn_BANG_(f){
return (cljs.core._STAR_print_err_fn_STAR_ = f);
});
/**
 * When set to true, output will be flushed whenever a newline is printed.
 * 
 *   Defaults to true.
 */
cljs.core._STAR_flush_on_newline_STAR_ = true;
/**
 * When set to logical false will drop newlines from printing calls.
 *   This is to work around the implicit newlines emitted by standard JavaScript
 *   console objects.
 */
cljs.core._STAR_print_newline_STAR_ = true;
/**
 * When set to logical false, strings and characters will be printed with
 *   non-alphanumeric characters converted to the appropriate escape sequences.
 * 
 *   Defaults to true
 */
cljs.core._STAR_print_readably_STAR_ = true;
/**
 * If set to logical true, when printing an object, its metadata will also
 *   be printed in a form that can be read back by the reader.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_meta_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 *   their type when read in later.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_dup_STAR_ = false;
/**
 * *print-namespace-maps* controls whether the printer will print
 *   namespace map literal syntax.
 * 
 *   Defaults to false, but the REPL binds it to true.
 */
cljs.core._STAR_print_namespace_maps_STAR_ = false;
/**
 * *print-length* controls how many items of each collection the
 *   printer will print. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   number of items of each collection to print. If a collection contains
 *   more items, the printer will print items up to the limit followed by
 *   '...' to represent the remaining items. The root binding is nil
 *   indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_length_STAR_ = null;
/**
 * *print-level* controls how many levels deep the printer will
 *   print nested objects. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   level to print. Each argument to print is at level 0; if an argument is a
 *   collection, its items are at level 1; and so on. If an object is a
 *   collection and is at a level greater than or equal to the value bound to
 *   *print-level*, the printer prints '#' to represent it. The root binding
 *   is nil indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_level_STAR_ = null;
/**
 * *print-fns-bodies* controls whether functions print their source or
 *  only their names.
 */
cljs.core._STAR_print_fn_bodies_STAR_ = false;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_loaded_libs_STAR_ !== 'undefined')){
} else {
/**
 * @type {*}
 */
cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = (function cljs$core$pr_opts(){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939),cljs.core._STAR_flush_on_newline_STAR_,new cljs.core.Keyword(null,"readably","readably",1129599760),cljs.core._STAR_print_readably_STAR_,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core._STAR_print_meta_STAR_,new cljs.core.Keyword(null,"dup","dup",556298533),cljs.core._STAR_print_dup_STAR_,new cljs.core.Keyword(null,"print-length","print-length",1931866356),cljs.core._STAR_print_length_STAR_], null);
});
/**
 * Set *print-fn* to console.log
 */
cljs.core.enable_console_print_BANG_ = (function cljs$core$enable_console_print_BANG_(){
(cljs.core._STAR_print_newline_STAR_ = false);

cljs.core.set_print_fn_BANG_((function cljs$core$enable_console_print_BANG__$_fn_14111(){
var xs = arguments;
return console.log.apply(console,cljs.core.goog$module$goog$array.clone.call(null,xs));
}));

cljs.core.set_print_err_fn_BANG_((function cljs$core$enable_console_print_BANG__$_fn_14112(){
var xs = arguments;
return console.error.apply(console,cljs.core.goog$module$goog$array.clone.call(null,xs));
}));

return null;
});
/**
 * Internal - do not use!
 */
cljs.core.truth_ = (function cljs$core$truth_(x){
return (x != null && x !== false);
});
cljs.core.not_native = null;

/**
 * Tests if 2 arguments are the same object
 */
cljs.core.identical_QMARK_ = (function cljs$core$identical_QMARK_(x,y){
return (x === y);
});
/**
 * Returns true if x is nil, false otherwise.
 */
cljs.core.nil_QMARK_ = (function cljs$core$nil_QMARK_(x){
return (x == null);
});
/**
 * Returns true if x is a JavaScript array.
 */
cljs.core.array_QMARK_ = (function cljs$core$array_QMARK_(x){
if((cljs.core._STAR_target_STAR_ === "nodejs")){
return Array.isArray(x);
} else {
return (x instanceof Array);
}
});
/**
 * Returns true if x is a JavaScript number.
 */
cljs.core.number_QMARK_ = (function cljs$core$number_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true if x is logical false, false otherwise.
 */
cljs.core.not = (function cljs$core$not(x){
if((x == null)){
return true;
} else {
if(x === false){
return true;
} else {
return false;

}
}
});
/**
 * Returns true if x is not nil, false otherwise.
 */
cljs.core.some_QMARK_ = (function cljs$core$some_QMARK_(x){
return (!((x == null)));
});
/**
 * Returns true if x's constructor is Object
 */
cljs.core.object_QMARK_ = (function cljs$core$object_QMARK_(x){
if((!((x == null)))){
return (x.constructor === Object);
} else {
return false;
}
});
/**
 * Returns true if x is a JavaScript string.
 */
cljs.core.string_QMARK_ = (function cljs$core$string_QMARK_(x){
return ("string" === goog.typeOf(x));
});
/**
 * Returns true if x is a JavaScript string of length one.
 */
cljs.core.char_QMARK_ = (function cljs$core$char_QMARK_(x){
return ((typeof x === 'string') && (((1) === x.length)));
});
/**
 * Returns true if given any argument.
 */
cljs.core.any_QMARK_ = (function cljs$core$any_QMARK_(x){
return true;
});
/**
 * Internal - do not use!
 */
cljs.core.native_satisfies_QMARK_ = (function cljs$core$native_satisfies_QMARK_(p,x){
var x__$1 = (((x == null))?null:x);
if((p[goog.typeOf(x__$1)])){
return true;
} else {
if((p["_"])){
return true;
} else {
return false;

}
}
});
cljs.core.is_proto_ = (function cljs$core$is_proto_(x){
return (x.constructor.prototype === x);
});
/**
 * When compiled for a command-line target, whatever function
 *   *main-cli-fn* is set to will be called with the command-line
 *   argv as arguments
 */
cljs.core._STAR_main_cli_fn_STAR_ = null;
/**
 * A sequence of the supplied command line arguments, or nil if
 *   none were supplied
 */
cljs.core._STAR_command_line_args_STAR_ = null;
/**
 * Return x's constructor.
 */
cljs.core.type = (function cljs$core$type(x){
if((x == null)){
return null;
} else {
return x.constructor;
}
});
cljs.core.missing_protocol = (function cljs$core$missing_protocol(proto,obj){
var ty = cljs.core.type(obj);
var ty__$1 = (cljs.core.truth_((function (){var and__9540__auto__ = ty;
if(cljs.core.truth_(and__9540__auto__)){
return ty.cljs$lang$type;
} else {
return and__9540__auto__;
}
})())?ty.cljs$lang$ctorStr:goog.typeOf(obj));
return (new Error(["No protocol method ",proto," defined for type ",ty__$1,": ",obj].join("")));
});
cljs.core.type__GT_str = (function cljs$core$type__GT_str(ty){
var temp__5718__auto__ = ty.cljs$lang$ctorStr;
if(cljs.core.truth_(temp__5718__auto__)){
var s = temp__5718__auto__;
return s;
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(ty);
}
});
cljs.core.load_file = (function cljs$core$load_file(file){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
return goog.nodeGlobalRequire(file);
}
});
if((((typeof Symbol !== 'undefined')) && ((goog.typeOf(Symbol) === "function")))){
cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
cljs.core.ITER_SYMBOL = "@@iterator";
}
/**
 * @enum {string}
 */
cljs.core.CHAR_MAP = ({"]": "_RBRACK_", "'": "_SINGLEQUOTE_", "=": "_EQ_", "\"": "_DOUBLEQUOTE_", "!": "_BANG_", "*": "_STAR_", "%": "_PERCENT_", "|": "_BAR_", "~": "_TILDE_", "/": "_SLASH_", "\\": "_BSLASH_", "-": "_", "?": "_QMARK_", "&": "_AMPERSAND_", ":": "_COLON_", "<": "_LT_", "{": "_LBRACE_", "}": "_RBRACE_", "[": "_LBRACK_", "#": "_SHARP_", "^": "_CARET_", "+": "_PLUS_", "@": "_CIRCA_", ">": "_GT_"});
/**
 * @enum {string}
 */
cljs.core.DEMUNGE_MAP = ({"_RBRACE_": "}", "_COLON_": ":", "_BANG_": "!", "_QMARK_": "?", "_BSLASH_": "\\\\", "_SLASH_": "/", "_PERCENT_": "%", "_PLUS_": "+", "_SHARP_": "#", "_LBRACE_": "{", "_BAR_": "|", "_LBRACK_": "[", "_EQ_": "=", "_": "-", "_TILDE_": "~", "_RBRACK_": "]", "_GT_": ">", "_SINGLEQUOTE_": "'", "_CIRCA_": "@", "_AMPERSAND_": "&", "_DOUBLEQUOTE_": "\\\"", "_CARET_": "^", "_LT_": "<", "_STAR_": "*"});
cljs.core.DEMUNGE_PATTERN = null;
/**
 * Returns highest resolution time offered by host in milliseconds.
 */
cljs.core.system_time = (function cljs$core$system_time(){
if((((typeof performance !== 'undefined')) && ((!((performance.now == null)))))){
return performance.now();
} else {
if((((typeof process !== 'undefined')) && ((!((process.hrtime == null)))))){
var t = process.hrtime();
return ((((t[(0)]) * 1.0E9) + (t[(1)])) / 1000000.0);
} else {
return (new Date()).getTime();

}
}
});
/**
 * Construct a JavaScript array of the specified dimensions. Accepts ignored
 *   type argument for compatibility with Clojure. Note that there is no efficient
 *   way to allocate multi-dimensional arrays in JavaScript; as such, this function
 *   will run in polynomial time when called with 3 or more arguments.
 */
cljs.core.make_array = (function cljs$core$make_array(var_args){
var G__14117 = arguments.length;
switch (G__14117) {
case 1:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___14123 = arguments.length;
var i__10876__auto___14124 = (0);
while(true){
if((i__10876__auto___14124 < len__10875__auto___14123)){
args_arr__10904__auto__.push((arguments[i__10876__auto___14124]));

var G__14125 = (i__10876__auto___14124 + (1));
i__10876__auto___14124 = G__14125;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14118(size){
return (new Array(size));
}));

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14119(type,size){
return (new Array(size));
}));

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14120(type,size,more_sizes){
var dims = more_sizes;
var dimarray = (new Array(size));
var n__10634__auto___14126 = dimarray.length;
var i_14127 = (0);
while(true){
if((i_14127 < n__10634__auto___14126)){
(dimarray[i_14127] = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.make_array,null,dims));

var G__14128 = (i_14127 + (1));
i_14127 = G__14128;
continue;
} else {
}
break;
}

return dimarray;
}));

/** @this {Function} */
(cljs.core.make_array.cljs$lang$applyTo = (function cljs$core$fn_14121(seq14114){
var G__14115 = cljs.core.first(seq14114);
var seq14114__$1 = cljs.core.next(seq14114);
var G__14116 = cljs.core.first(seq14114__$1);
var seq14114__$2 = cljs.core.next(seq14114__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14115,G__14116,seq14114__$2);
}));

(cljs.core.make_array.cljs$lang$maxFixedArity = (2));

/**
 * Returns a javascript array, cloned from the passed in array
 */
cljs.core.aclone = (function cljs$core$aclone(arr){
var len = arr.length;
var new_arr = (new Array(len));
var n__10634__auto___14129 = len;
var i_14130 = (0);
while(true){
if((i_14130 < n__10634__auto___14129)){
(new_arr[i_14130] = (arr[i_14130]));

var G__14131 = (i_14130 + (1));
i_14130 = G__14131;
continue;
} else {
}
break;
}

return new_arr;
});
/**
 * Creates a new javascript array.
 * @param {...*} var_args
 */
cljs.core.array = (function cljs$core$array(var_args){
var a = (new Array(arguments.length));
var i = (0);
while(true){
if((i < a.length)){
(a[i] = (arguments[i]));

var G__14132 = (i + (1));
i = G__14132;
continue;
} else {
return a;
}
break;
}
});
cljs.core.maybe_warn = (function cljs$core$maybe_warn(e){
if(cljs.core.truth_(cljs.core._STAR_print_err_fn_STAR_)){
return (cljs.core._STAR_print_err_fn_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.core._STAR_print_err_fn_STAR_.cljs$core$IFn$_invoke$arity$1(e) : cljs.core._STAR_print_err_fn_STAR_.call(null,e));
} else {
return null;
}
});
cljs.core.checked_aget = (function cljs$core$checked_aget(var_args){
var G__14137 = arguments.length;
switch (G__14137) {
case 2:
return cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___14143 = arguments.length;
var i__10876__auto___14144 = (0);
while(true){
if((i__10876__auto___14144 < len__10875__auto___14143)){
args_arr__10904__auto__.push((arguments[i__10876__auto___14144]));

var G__14145 = (i__10876__auto___14144 + (1));
i__10876__auto___14144 = G__14145;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14138(array,idx){
try{if(cljs.core.truth_((function (){var or__9546__auto__ = cljs.core.array_QMARK_(array);
if(or__9546__auto__){
return or__9546__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}
}catch (e14139){var e_14146 = e14139;
cljs.core.maybe_warn(e_14146);
}
return (array[idx]);
}));

(cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14140(array,idx,idxs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.checked_aget,cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2(array,idx),idxs);
}));

/** @this {Function} */
(cljs.core.checked_aget.cljs$lang$applyTo = (function cljs$core$fn_14141(seq14134){
var G__14135 = cljs.core.first(seq14134);
var seq14134__$1 = cljs.core.next(seq14134);
var G__14136 = cljs.core.first(seq14134__$1);
var seq14134__$2 = cljs.core.next(seq14134__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14135,G__14136,seq14134__$2);
}));

(cljs.core.checked_aget.cljs$lang$maxFixedArity = (2));

cljs.core.checked_aset = (function cljs$core$checked_aset(var_args){
var G__14152 = arguments.length;
switch (G__14152) {
case 3:
return cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___14158 = arguments.length;
var i__10876__auto___14159 = (0);
while(true){
if((i__10876__auto___14159 < len__10875__auto___14158)){
args_arr__10904__auto__.push((arguments[i__10876__auto___14159]));

var G__14160 = (i__10876__auto___14159 + (1));
i__10876__auto___14159 = G__14160;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((3) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((3)),(0),null)):null);
return cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10905__auto__);

}
});

(cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14153(array,idx,val){
try{if(cljs.core.truth_((function (){var or__9546__auto__ = cljs.core.array_QMARK_(array);
if(or__9546__auto__){
return or__9546__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}
}catch (e14154){var e_14161 = e14154;
cljs.core.maybe_warn(e_14161);
}
return (array[idx] = val);
}));

(cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14155(array,idx,idx2,idxv){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.checked_aset,cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2(array,idx),idx2,idxv);
}));

/** @this {Function} */
(cljs.core.checked_aset.cljs$lang$applyTo = (function cljs$core$fn_14156(seq14148){
var G__14149 = cljs.core.first(seq14148);
var seq14148__$1 = cljs.core.next(seq14148);
var G__14150 = cljs.core.first(seq14148__$1);
var seq14148__$2 = cljs.core.next(seq14148__$1);
var G__14151 = cljs.core.first(seq14148__$2);
var seq14148__$3 = cljs.core.next(seq14148__$2);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14149,G__14150,G__14151,seq14148__$3);
}));

(cljs.core.checked_aset.cljs$lang$maxFixedArity = (3));

cljs.core.checked_aget_SINGLEQUOTE_ = (function cljs$core$checked_aget_SINGLEQUOTE_(var_args){
var G__14166 = arguments.length;
switch (G__14166) {
case 2:
return cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___14171 = arguments.length;
var i__10876__auto___14172 = (0);
while(true){
if((i__10876__auto___14172 < len__10875__auto___14171)){
args_arr__10904__auto__.push((arguments[i__10876__auto___14172]));

var G__14173 = (i__10876__auto___14172 + (1));
i__10876__auto___14172 = G__14173;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14167(array,idx){
if(cljs.core.truth_((function (){var or__9546__auto__ = cljs.core.array_QMARK_(array);
if(or__9546__auto__){
return or__9546__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}

return (array[idx]);
}));

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14168(array,idx,idxs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.checked_aget_SINGLEQUOTE_,cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(array,idx),idxs);
}));

/** @this {Function} */
(cljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$applyTo = (function cljs$core$fn_14169(seq14163){
var G__14164 = cljs.core.first(seq14163);
var seq14163__$1 = cljs.core.next(seq14163);
var G__14165 = cljs.core.first(seq14163__$1);
var seq14163__$2 = cljs.core.next(seq14163__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14164,G__14165,seq14163__$2);
}));

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$maxFixedArity = (2));

cljs.core.checked_aset_SINGLEQUOTE_ = (function cljs$core$checked_aset_SINGLEQUOTE_(var_args){
var G__14179 = arguments.length;
switch (G__14179) {
case 3:
return cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___14184 = arguments.length;
var i__10876__auto___14185 = (0);
while(true){
if((i__10876__auto___14185 < len__10875__auto___14184)){
args_arr__10904__auto__.push((arguments[i__10876__auto___14185]));

var G__14186 = (i__10876__auto___14185 + (1));
i__10876__auto___14185 = G__14186;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((3) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((3)),(0),null)):null);
return cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10905__auto__);

}
});

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14180(array,idx,val){
if(cljs.core.truth_((function (){var or__9546__auto__ = cljs.core.array_QMARK_(array);
if(or__9546__auto__){
return or__9546__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}

return (array[idx] = val);
}));

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14181(array,idx,idx2,idxv){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.checked_aset_SINGLEQUOTE_,cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(array,idx),idx2,idxv);
}));

/** @this {Function} */
(cljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$applyTo = (function cljs$core$fn_14182(seq14175){
var G__14176 = cljs.core.first(seq14175);
var seq14175__$1 = cljs.core.next(seq14175);
var G__14177 = cljs.core.first(seq14175__$1);
var seq14175__$2 = cljs.core.next(seq14175__$1);
var G__14178 = cljs.core.first(seq14175__$2);
var seq14175__$3 = cljs.core.next(seq14175__$2);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14176,G__14177,G__14178,seq14175__$3);
}));

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$maxFixedArity = (3));

/**
 * Returns the value at the index/indices. Works on JavaScript arrays.
 */
cljs.core.aget = (function cljs$core$aget(var_args){
var G__14191 = arguments.length;
switch (G__14191) {
case 2:
return cljs.core.aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___14196 = arguments.length;
var i__10876__auto___14197 = (0);
while(true){
if((i__10876__auto___14197 < len__10875__auto___14196)){
args_arr__10904__auto__.push((arguments[i__10876__auto___14197]));

var G__14198 = (i__10876__auto___14197 + (1));
i__10876__auto___14197 = G__14198;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14192(array,idx){
return (array[idx]);
}));

(cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14193(array,idx,idxs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.aget,(array[idx]),idxs);
}));

/** @this {Function} */
(cljs.core.aget.cljs$lang$applyTo = (function cljs$core$fn_14194(seq14188){
var G__14189 = cljs.core.first(seq14188);
var seq14188__$1 = cljs.core.next(seq14188);
var G__14190 = cljs.core.first(seq14188__$1);
var seq14188__$2 = cljs.core.next(seq14188__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14189,G__14190,seq14188__$2);
}));

(cljs.core.aget.cljs$lang$maxFixedArity = (2));

/**
 * Sets the value at the index/indices. Works on JavaScript arrays.
 *   Returns val.
 */
cljs.core.aset = (function cljs$core$aset(var_args){
var G__14204 = arguments.length;
switch (G__14204) {
case 3:
return cljs.core.aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___14209 = arguments.length;
var i__10876__auto___14210 = (0);
while(true){
if((i__10876__auto___14210 < len__10875__auto___14209)){
args_arr__10904__auto__.push((arguments[i__10876__auto___14210]));

var G__14211 = (i__10876__auto___14210 + (1));
i__10876__auto___14210 = G__14211;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((3) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((3)),(0),null)):null);
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10905__auto__);

}
});

(cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14205(array,idx,val){
return (array[idx] = val);
}));

(cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14206(array,idx,idx2,idxv){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.aset,(array[idx]),idx2,idxv);
}));

/** @this {Function} */
(cljs.core.aset.cljs$lang$applyTo = (function cljs$core$fn_14207(seq14200){
var G__14201 = cljs.core.first(seq14200);
var seq14200__$1 = cljs.core.next(seq14200);
var G__14202 = cljs.core.first(seq14200__$1);
var seq14200__$2 = cljs.core.next(seq14200__$1);
var G__14203 = cljs.core.first(seq14200__$2);
var seq14200__$3 = cljs.core.next(seq14200__$2);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14201,G__14202,G__14203,seq14200__$3);
}));

(cljs.core.aset.cljs$lang$maxFixedArity = (3));

/**
 * Returns the length of the array. Works on arrays of all types.
 */
cljs.core.alength = (function cljs$core$alength(array){
return array.length;
});
/**
 * Returns an array with components set to the values in aseq. Optional type
 *   argument accepted for compatibility with Clojure.
 */
cljs.core.into_array = (function cljs$core$into_array(var_args){
var G__14213 = arguments.length;
switch (G__14213) {
case 1:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14214(aseq){
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null,aseq);
}));

(cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14215(type,aseq){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function cljs$core$fn_14215_$_fn_14216(a,x){
a.push(x);

return a;
}),[],aseq);
}));

(cljs.core.into_array.cljs$lang$maxFixedArity = 2);

/**
 * Invoke JavaScript object method via string. Needed when the
 *   string is not a valid unquoted property name.
 */
cljs.core.js_invoke = (function cljs$core$js_invoke(var_args){
var args__10885__auto__ = [];
var len__10875__auto___14223 = arguments.length;
var i__10876__auto___14224 = (0);
while(true){
if((i__10876__auto___14224 < len__10875__auto___14223)){
args__10885__auto__.push((arguments[i__10876__auto___14224]));

var G__14225 = (i__10876__auto___14224 + (1));
i__10876__auto___14224 = G__14225;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args__10885__auto__.length))?(new cljs.core.IndexedSeq(args__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);
});

(cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14221(obj,s,args){
return (obj[s]).apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
}));

(cljs.core.js_invoke.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(cljs.core.js_invoke.cljs$lang$applyTo = (function cljs$core$fn_14222(seq14218){
var G__14219 = cljs.core.first(seq14218);
var seq14218__$1 = cljs.core.next(seq14218);
var G__14220 = cljs.core.first(seq14218__$1);
var seq14218__$2 = cljs.core.next(seq14218__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14219,G__14220,seq14218__$2);
}));

/**
 * Returns true if x is an instance of Symbol
 */
cljs.core.js_symbol_QMARK_ = (function cljs$core$js_symbol_QMARK_(x){
return (((goog.typeOf(x) === "symbol")) || ((((typeof Symbol !== 'undefined')) && ((x instanceof Symbol)))));
});

/**
 * Marker protocol
 * @interface
 */
cljs.core.Fn = function(){};


/**
 * Protocol for adding the ability to invoke an object as a function.
 *   For example, a vector can also be used to look up a value:
 *   ([1 2 3 4] 1) => 2
 * @interface
 */
cljs.core.IFn = function(){};

var cljs$core$IFn$_invoke$dyn_14251 = (function() {
var cljs$core$fn_14226 = null;
var cljs$core$fn_14226__1 = (function (this$){
var x__10295__auto__ = (((this$ == null))?null:this$);
var m__10296__auto__ = (cljs.core._invoke[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__10296__auto__.call(null,this$));
} else {
var m__10294__auto__ = (cljs.core._invoke["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__10294__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14226__2 = (function (this$,a){
var x__10295__auto__ = (((this$ == null))?null:this$);
var m__10296__auto__ = (cljs.core._invoke[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__10296__auto__.call(null,this$,a));
} else {
var m__10294__auto__ = (cljs.core._invoke["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__10294__auto__.call(null,this$,a));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14226__3 = (function (this$,a,b){
var x__10295__auto__ = (((this$ == null))?null:this$);
var m__10296__auto__ = (cljs.core._invoke[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__10296__auto__.call(null,this$,a,b));
} else {
var m__10294__auto__ = (cljs.core._invoke["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__10294__auto__.call(null,this$,a,b));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14226__4 = (function (this$,a,b,c){
var x__10295__auto__ = (((this$ == null))?null:this$);
var m__10296__auto__ = (cljs.core._invoke[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$4 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__10296__auto__.call(null,this$,a,b,c));
} else {
var m__10294__auto__ = (cljs.core._invoke["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$4 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__10294__auto__.call(null,this$,a,b,c));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14226__5 = (function (this$,a,b,c,d){
var x__10295__auto__ = (((this$ == null))?null:this$);
var m__10296__auto__ = (cljs.core._invoke[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$5 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__10296__auto__.call(null,this$,a,b,c,d));
} else {
var m__10294__auto__ = (cljs.core._invoke["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$5 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__10294__auto__.call(null,this$,a,b,c,d));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14226__6 = (function (this$,a,b,c,d,e){
var x__10295__auto__ = (((this$ == null))?null:this$);
var m__10296__auto__ = (cljs.core._invoke[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$6 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__10296__auto__.call(null,this$,a,b,c,d,e));
} else {
var m__10294__auto__ = (cljs.core._invoke["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$6 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__10294__auto__.call(null,this$,a,b,c,d,e));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14226__7 = (function (this$,a,b,c,d,e,f){
var x__10295__auto__ = (((this$ == null))?null:this$);
var m__10296__auto__ = (cljs.core._invoke[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$7 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__10296__auto__.call(null,this$,a,b,c,d,e,f));
} else {
var m__10294__auto__ = (cljs.core._invoke["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$7 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__10294__auto__.call(null,this$,a,b,c,d,e,f));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14226__8 = (function (this$,a,b,c,d,e,f,g){
var x__10295__auto__ = (((this$ == null))?null:this$);
var m__10296__auto__ = (cljs.core._invoke[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$8 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__10296__auto__.call(null,this$,a,b,c,d,e,f,g));
} else {
var m__10294__auto__ = (cljs.core._invoke["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$8 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__10294__auto__.call(null,this$,a,b,c,d,e,f,g));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14226__9 = (function (this$,a,b,c,d,e,f,g,h){
var x__10295__auto__ = (((this$ == null))?null:this$);
var m__10296__auto__ = (cljs.core._invoke[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$9 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__10296__auto__.call(null,this$,a,b,c,d,e,f,g,h));
} else {
var m__10294__auto__ = (cljs.core._invoke["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$9 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__10294__auto__.call(null,this$,a,b,c,d,e,f,g,h));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14226__10 = (function (this$,a,b,c,d,e,f,g,h,i){
var x__10295__auto__ = (((this$ == null))?null:this$);
var m__10296__auto__ = (cljs.core._invoke[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$10 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__10296__auto__.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
var m__10294__auto__ = (cljs.core._invoke["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$10 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__10294__auto__.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14226__11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
var x__10295__auto__ = (((this$ == null))?null:this$);
var m__10296__auto__ = (cljs.core._invoke[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$11 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__10296__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
var m__10294__auto__ = (cljs.core._invoke["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$11 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__10294__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14226__12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
var x__10295__auto__ = (((this$ == null))?null:this$);
var m__10296__auto__ = (cljs.core._invoke[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$12 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__10296__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
var m__10294__auto__ = (cljs.core._invoke["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$12 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__10294__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14226__13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
var x__10295__auto__ = (((this$ == null))?null:this$);
var m__10296__auto__ = (cljs.core._invoke[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$13 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__10296__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
var m__10294__auto__ = (cljs.core._invoke["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$13 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__10294__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14226__14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
var x__10295__auto__ = (((this$ == null))?null:this$);
var m__10296__auto__ = (cljs.core._invoke[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$14 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__10296__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
var m__10294__auto__ = (cljs.core._invoke["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$14 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__10294__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14226__15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var x__10295__auto__ = (((this$ == null))?null:this$);
var m__10296__auto__ = (cljs.core._invoke[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$15 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__10296__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
var m__10294__auto__ = (cljs.core._invoke["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$15 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__10294__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14226__16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var x__10295__auto__ = (((this$ == null))?null:this$);
var m__10296__auto__ = (cljs.core._invoke[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$16 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__10296__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
var m__10294__auto__ = (cljs.core._invoke["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$16 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__10294__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14226__17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var x__10295__auto__ = (((this$ == null))?null:this$);
var m__10296__auto__ = (cljs.core._invoke[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$17 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__10296__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
var m__10294__auto__ = (cljs.core._invoke["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$17 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__10294__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14226__18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var x__10295__auto__ = (((this$ == null))?null:this$);
var m__10296__auto__ = (cljs.core._invoke[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$18 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__10296__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
var m__10294__auto__ = (cljs.core._invoke["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$18 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__10294__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14226__19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var x__10295__auto__ = (((this$ == null))?null:this$);
var m__10296__auto__ = (cljs.core._invoke[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$19 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__10296__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
var m__10294__auto__ = (cljs.core._invoke["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$19 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__10294__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14226__20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var x__10295__auto__ = (((this$ == null))?null:this$);
var m__10296__auto__ = (cljs.core._invoke[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$20 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__10296__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
var m__10294__auto__ = (cljs.core._invoke["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$20 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__10294__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14226__21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var x__10295__auto__ = (((this$ == null))?null:this$);
var m__10296__auto__ = (cljs.core._invoke[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$21 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__10296__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
var m__10294__auto__ = (cljs.core._invoke["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$21 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__10294__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14226__22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var x__10295__auto__ = (((this$ == null))?null:this$);
var m__10296__auto__ = (cljs.core._invoke[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$22 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__10296__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
var m__10294__auto__ = (cljs.core._invoke["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$22 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__10294__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
cljs$core$fn_14226 = function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return cljs$core$fn_14226__1.call(this,this$);
case 2:
return cljs$core$fn_14226__2.call(this,this$,a);
case 3:
return cljs$core$fn_14226__3.call(this,this$,a,b);
case 4:
return cljs$core$fn_14226__4.call(this,this$,a,b,c);
case 5:
return cljs$core$fn_14226__5.call(this,this$,a,b,c,d);
case 6:
return cljs$core$fn_14226__6.call(this,this$,a,b,c,d,e);
case 7:
return cljs$core$fn_14226__7.call(this,this$,a,b,c,d,e,f);
case 8:
return cljs$core$fn_14226__8.call(this,this$,a,b,c,d,e,f,g);
case 9:
return cljs$core$fn_14226__9.call(this,this$,a,b,c,d,e,f,g,h);
case 10:
return cljs$core$fn_14226__10.call(this,this$,a,b,c,d,e,f,g,h,i);
case 11:
return cljs$core$fn_14226__11.call(this,this$,a,b,c,d,e,f,g,h,i,j);
case 12:
return cljs$core$fn_14226__12.call(this,this$,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return cljs$core$fn_14226__13.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return cljs$core$fn_14226__14.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return cljs$core$fn_14226__15.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return cljs$core$fn_14226__16.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return cljs$core$fn_14226__17.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return cljs$core$fn_14226__18.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return cljs$core$fn_14226__19.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return cljs$core$fn_14226__20.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return cljs$core$fn_14226__21.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return cljs$core$fn_14226__22.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14226.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14226__1;
cljs$core$fn_14226.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14226__2;
cljs$core$fn_14226.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14226__3;
cljs$core$fn_14226.cljs$core$IFn$_invoke$arity$4 = cljs$core$fn_14226__4;
cljs$core$fn_14226.cljs$core$IFn$_invoke$arity$5 = cljs$core$fn_14226__5;
cljs$core$fn_14226.cljs$core$IFn$_invoke$arity$6 = cljs$core$fn_14226__6;
cljs$core$fn_14226.cljs$core$IFn$_invoke$arity$7 = cljs$core$fn_14226__7;
cljs$core$fn_14226.cljs$core$IFn$_invoke$arity$8 = cljs$core$fn_14226__8;
cljs$core$fn_14226.cljs$core$IFn$_invoke$arity$9 = cljs$core$fn_14226__9;
cljs$core$fn_14226.cljs$core$IFn$_invoke$arity$10 = cljs$core$fn_14226__10;
cljs$core$fn_14226.cljs$core$IFn$_invoke$arity$11 = cljs$core$fn_14226__11;
cljs$core$fn_14226.cljs$core$IFn$_invoke$arity$12 = cljs$core$fn_14226__12;
cljs$core$fn_14226.cljs$core$IFn$_invoke$arity$13 = cljs$core$fn_14226__13;
cljs$core$fn_14226.cljs$core$IFn$_invoke$arity$14 = cljs$core$fn_14226__14;
cljs$core$fn_14226.cljs$core$IFn$_invoke$arity$15 = cljs$core$fn_14226__15;
cljs$core$fn_14226.cljs$core$IFn$_invoke$arity$16 = cljs$core$fn_14226__16;
cljs$core$fn_14226.cljs$core$IFn$_invoke$arity$17 = cljs$core$fn_14226__17;
cljs$core$fn_14226.cljs$core$IFn$_invoke$arity$18 = cljs$core$fn_14226__18;
cljs$core$fn_14226.cljs$core$IFn$_invoke$arity$19 = cljs$core$fn_14226__19;
cljs$core$fn_14226.cljs$core$IFn$_invoke$arity$20 = cljs$core$fn_14226__20;
cljs$core$fn_14226.cljs$core$IFn$_invoke$arity$21 = cljs$core$fn_14226__21;
cljs$core$fn_14226.cljs$core$IFn$_invoke$arity$22 = cljs$core$fn_14226__22;
return cljs$core$fn_14226;
})()
;
cljs.core._invoke = (function cljs$core$_invoke(var_args){
var G__14228 = arguments.length;
switch (G__14228) {
case 1:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
case 9:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
case 11:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));

break;
case 12:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));

break;
case 13:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));

break;
case 14:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));

break;
case 15:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));

break;
case 16:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));

break;
case 17:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));

break;
case 18:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));

break;
case 19:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));

break;
case 20:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));

break;
case 21:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));

break;
case 22:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14229(this$){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$1 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$1(this$);
} else {
return cljs$core$IFn$_invoke$dyn_14251.cljs$core$IFn$_invoke$arity$1(this$);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14230(this$,a){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$2 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$2(this$,a);
} else {
return cljs$core$IFn$_invoke$dyn_14251.cljs$core$IFn$_invoke$arity$2(this$,a);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14231(this$,a,b){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$3 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);
} else {
return cljs$core$IFn$_invoke$dyn_14251.cljs$core$IFn$_invoke$arity$3(this$,a,b);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14232(this$,a,b,c){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$4 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
} else {
return cljs$core$IFn$_invoke$dyn_14251.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_14233(this$,a,b,c,d){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$5 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
} else {
return cljs$core$IFn$_invoke$dyn_14251.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_14234(this$,a,b,c,d,e){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$6 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
} else {
return cljs$core$IFn$_invoke$dyn_14251.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = (function cljs$core$fn_14235(this$,a,b,c,d,e,f){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$7 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
} else {
return cljs$core$IFn$_invoke$dyn_14251.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = (function cljs$core$fn_14236(this$,a,b,c,d,e,f,g){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$8 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
} else {
return cljs$core$IFn$_invoke$dyn_14251.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = (function cljs$core$fn_14237(this$,a,b,c,d,e,f,g,h){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$9 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
} else {
return cljs$core$IFn$_invoke$dyn_14251.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = (function cljs$core$fn_14238(this$,a,b,c,d,e,f,g,h,i){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$10 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
} else {
return cljs$core$IFn$_invoke$dyn_14251.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = (function cljs$core$fn_14239(this$,a,b,c,d,e,f,g,h,i,j){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$11 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
} else {
return cljs$core$IFn$_invoke$dyn_14251.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = (function cljs$core$fn_14240(this$,a,b,c,d,e,f,g,h,i,j,k){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$12 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
return cljs$core$IFn$_invoke$dyn_14251.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = (function cljs$core$fn_14241(this$,a,b,c,d,e,f,g,h,i,j,k,l){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$13 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
return cljs$core$IFn$_invoke$dyn_14251.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = (function cljs$core$fn_14242(this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$14 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
return cljs$core$IFn$_invoke$dyn_14251.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = (function cljs$core$fn_14243(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$15 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
return cljs$core$IFn$_invoke$dyn_14251.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = (function cljs$core$fn_14244(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$16 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
return cljs$core$IFn$_invoke$dyn_14251.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = (function cljs$core$fn_14245(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$17 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
return cljs$core$IFn$_invoke$dyn_14251.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = (function cljs$core$fn_14246(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$18 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
return cljs$core$IFn$_invoke$dyn_14251.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = (function cljs$core$fn_14247(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$19 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
return cljs$core$IFn$_invoke$dyn_14251.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = (function cljs$core$fn_14248(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$20 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
return cljs$core$IFn$_invoke$dyn_14251.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = (function cljs$core$fn_14249(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$21 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
return cljs$core$IFn$_invoke$dyn_14251.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = (function cljs$core$fn_14250(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$22 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
return cljs$core$IFn$_invoke$dyn_14251.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
}));

(cljs.core._invoke.cljs$lang$maxFixedArity = 22);



/**
 * Protocol for cloning a value.
 * @interface
 */
cljs.core.ICloneable = function(){};

var cljs$core$ICloneable$_clone$dyn_14254 = (function cljs$core$fn_14253(value){
var x__10295__auto__ = (((value == null))?null:value);
var m__10296__auto__ = (cljs.core._clone[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__10296__auto__.call(null,value));
} else {
var m__10294__auto__ = (cljs.core._clone["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__10294__auto__.call(null,value));
} else {
throw cljs.core.missing_protocol("ICloneable.-clone",value);
}
}
});
/**
 * Creates a clone of value.
 */
cljs.core._clone = (function cljs$core$_clone(value){
if((((!((value == null)))) && ((!((value.cljs$core$ICloneable$_clone$arity$1 == null)))))){
return value.cljs$core$ICloneable$_clone$arity$1(value);
} else {
return cljs$core$ICloneable$_clone$dyn_14254(value);
}
});


/**
 * Protocol for adding the ability to count a collection in constant time.
 * @interface
 */
cljs.core.ICounted = function(){};

var cljs$core$ICounted$_count$dyn_14256 = (function cljs$core$fn_14255(coll){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._count[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10296__auto__.call(null,coll));
} else {
var m__10294__auto__ = (cljs.core._count["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10294__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ICounted.-count",coll);
}
}
});
/**
 * Calculates the count of coll in constant time. Used by cljs.core/count.
 */
cljs.core._count = (function cljs$core$_count(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ICounted$_count$arity$1 == null)))))){
return coll.cljs$core$ICounted$_count$arity$1(coll);
} else {
return cljs$core$ICounted$_count$dyn_14256(coll);
}
});


/**
 * Protocol for creating an empty collection.
 * @interface
 */
cljs.core.IEmptyableCollection = function(){};

var cljs$core$IEmptyableCollection$_empty$dyn_14258 = (function cljs$core$fn_14257(coll){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._empty[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10296__auto__.call(null,coll));
} else {
var m__10294__auto__ = (cljs.core._empty["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10294__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEmptyableCollection.-empty",coll);
}
}
});
/**
 * Returns an empty collection of the same category as coll. Used
 *   by cljs.core/empty.
 */
cljs.core._empty = (function cljs$core$_empty(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IEmptyableCollection$_empty$arity$1 == null)))))){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else {
return cljs$core$IEmptyableCollection$_empty$dyn_14258(coll);
}
});


/**
 * Protocol for adding to a collection.
 * @interface
 */
cljs.core.ICollection = function(){};

var cljs$core$ICollection$_conj$dyn_14260 = (function cljs$core$fn_14259(coll,o){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._conj[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__10296__auto__.call(null,coll,o));
} else {
var m__10294__auto__ = (cljs.core._conj["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__10294__auto__.call(null,coll,o));
} else {
throw cljs.core.missing_protocol("ICollection.-conj",coll);
}
}
});
/**
 * Returns a new collection of coll with o added to it. The new item
 *   should be added to the most efficient place, e.g.
 *   (conj [1 2 3 4] 5) => [1 2 3 4 5]
 *   (conj '(2 3 4 5) 1) => '(1 2 3 4 5)
 */
cljs.core._conj = (function cljs$core$_conj(coll,o){
if((((!((coll == null)))) && ((!((coll.cljs$core$ICollection$_conj$arity$2 == null)))))){
return coll.cljs$core$ICollection$_conj$arity$2(coll,o);
} else {
return cljs$core$ICollection$_conj$dyn_14260(coll,o);
}
});


/**
 * Protocol for collections to provide indexed-based access to their items.
 * @interface
 */
cljs.core.IIndexed = function(){};

var cljs$core$IIndexed$_nth$dyn_14266 = (function() {
var cljs$core$fn_14261 = null;
var cljs$core$fn_14261__2 = (function (coll,n){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._nth[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__10296__auto__.call(null,coll,n));
} else {
var m__10294__auto__ = (cljs.core._nth["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__10294__auto__.call(null,coll,n));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
});
var cljs$core$fn_14261__3 = (function (coll,n,not_found){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._nth[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__10296__auto__.call(null,coll,n,not_found));
} else {
var m__10294__auto__ = (cljs.core._nth["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__10294__auto__.call(null,coll,n,not_found));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
});
cljs$core$fn_14261 = function(coll,n,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_14261__2.call(this,coll,n);
case 3:
return cljs$core$fn_14261__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14261.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14261__2;
cljs$core$fn_14261.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14261__3;
return cljs$core$fn_14261;
})()
;
/**
 * Returns the value at the index n in the collection coll.
 *   Returns not-found if index n is out of bounds and not-found is supplied.
 */
cljs.core._nth = (function cljs$core$_nth(var_args){
var G__14263 = arguments.length;
switch (G__14263) {
case 2:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14264(coll,n){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIndexed$_nth$arity$2 == null)))))){
return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else {
return cljs$core$IIndexed$_nth$dyn_14266.cljs$core$IFn$_invoke$arity$2(coll,n);
}
}));

(cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14265(coll,n,not_found){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIndexed$_nth$arity$3 == null)))))){
return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);
} else {
return cljs$core$IIndexed$_nth$dyn_14266.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
}
}));

(cljs.core._nth.cljs$lang$maxFixedArity = 3);



/**
 * Marker protocol indicating an array sequence.
 * @interface
 */
cljs.core.ASeq = function(){};


/**
 * Protocol for collections to provide access to their items as sequences.
 * @interface
 */
cljs.core.ISeq = function(){};

var cljs$core$ISeq$_first$dyn_14270 = (function cljs$core$fn_14268(coll){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._first[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10296__auto__.call(null,coll));
} else {
var m__10294__auto__ = (cljs.core._first["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10294__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-first",coll);
}
}
});
/**
 * Returns the first item in the collection coll. Used by cljs.core/first.
 */
cljs.core._first = (function cljs$core$_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISeq$_first$arity$1 == null)))))){
return coll.cljs$core$ISeq$_first$arity$1(coll);
} else {
return cljs$core$ISeq$_first$dyn_14270(coll);
}
});

var cljs$core$ISeq$_rest$dyn_14271 = (function cljs$core$fn_14269(coll){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._rest[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10296__auto__.call(null,coll));
} else {
var m__10294__auto__ = (cljs.core._rest["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10294__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-rest",coll);
}
}
});
/**
 * Returns a new collection of coll without the first item. It should
 *   always return a seq, e.g.
 *   (rest []) => ()
 *   (rest nil) => ()
 */
cljs.core._rest = (function cljs$core$_rest(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISeq$_rest$arity$1 == null)))))){
return coll.cljs$core$ISeq$_rest$arity$1(coll);
} else {
return cljs$core$ISeq$_rest$dyn_14271(coll);
}
});


/**
 * Protocol for accessing the next items of a collection.
 * @interface
 */
cljs.core.INext = function(){};

var cljs$core$INext$_next$dyn_14273 = (function cljs$core$fn_14272(coll){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._next[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10296__auto__.call(null,coll));
} else {
var m__10294__auto__ = (cljs.core._next["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10294__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("INext.-next",coll);
}
}
});
/**
 * Returns a new collection of coll without the first item. In contrast to
 *   rest, it should return nil if there are no more items, e.g.
 *   (next []) => nil
 *   (next nil) => nil
 */
cljs.core._next = (function cljs$core$_next(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$INext$_next$arity$1 == null)))))){
return coll.cljs$core$INext$_next$arity$1(coll);
} else {
return cljs$core$INext$_next$dyn_14273(coll);
}
});


/**
 * Protocol for looking up a value in a data structure.
 * @interface
 */
cljs.core.ILookup = function(){};

var cljs$core$ILookup$_lookup$dyn_14279 = (function() {
var cljs$core$fn_14274 = null;
var cljs$core$fn_14274__2 = (function (o,k){
var x__10295__auto__ = (((o == null))?null:o);
var m__10296__auto__ = (cljs.core._lookup[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__10296__auto__.call(null,o,k));
} else {
var m__10294__auto__ = (cljs.core._lookup["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__10294__auto__.call(null,o,k));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
});
var cljs$core$fn_14274__3 = (function (o,k,not_found){
var x__10295__auto__ = (((o == null))?null:o);
var m__10296__auto__ = (cljs.core._lookup[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__10296__auto__.call(null,o,k,not_found));
} else {
var m__10294__auto__ = (cljs.core._lookup["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__10294__auto__.call(null,o,k,not_found));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
});
cljs$core$fn_14274 = function(o,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_14274__2.call(this,o,k);
case 3:
return cljs$core$fn_14274__3.call(this,o,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14274.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14274__2;
cljs$core$fn_14274.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14274__3;
return cljs$core$fn_14274;
})()
;
/**
 * Use k to look up a value in o. If not-found is supplied and k is not
 *   a valid value that can be used for look up, not-found is returned.
 */
cljs.core._lookup = (function cljs$core$_lookup(var_args){
var G__14276 = arguments.length;
switch (G__14276) {
case 2:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14277(o,k){
if((((!((o == null)))) && ((!((o.cljs$core$ILookup$_lookup$arity$2 == null)))))){
return o.cljs$core$ILookup$_lookup$arity$2(o,k);
} else {
return cljs$core$ILookup$_lookup$dyn_14279.cljs$core$IFn$_invoke$arity$2(o,k);
}
}));

(cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14278(o,k,not_found){
if((((!((o == null)))) && ((!((o.cljs$core$ILookup$_lookup$arity$3 == null)))))){
return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);
} else {
return cljs$core$ILookup$_lookup$dyn_14279.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
}
}));

(cljs.core._lookup.cljs$lang$maxFixedArity = 3);



/**
 * Protocol for adding associativity to collections.
 * @interface
 */
cljs.core.IAssociative = function(){};

var cljs$core$IAssociative$_contains_key_QMARK_$dyn_14283 = (function cljs$core$fn_14281(coll,k){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._contains_key_QMARK_[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10296__auto__.call(null,coll,k));
} else {
var m__10294__auto__ = (cljs.core._contains_key_QMARK_["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10294__auto__.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IAssociative.-contains-key?",coll);
}
}
});
/**
 * Returns true if k is a key in coll.
 */
cljs.core._contains_key_QMARK_ = (function cljs$core$_contains_key_QMARK_(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 == null)))))){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);
} else {
return cljs$core$IAssociative$_contains_key_QMARK_$dyn_14283(coll,k);
}
});

var cljs$core$IAssociative$_assoc$dyn_14284 = (function cljs$core$fn_14282(coll,k,v){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._assoc[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__10296__auto__.call(null,coll,k,v));
} else {
var m__10294__auto__ = (cljs.core._assoc["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__10294__auto__.call(null,coll,k,v));
} else {
throw cljs.core.missing_protocol("IAssociative.-assoc",coll);
}
}
});
/**
 * Returns a new collection of coll with a mapping from key k to
 *   value v added to it.
 */
cljs.core._assoc = (function cljs$core$_assoc(coll,k,v){
if((((!((coll == null)))) && ((!((coll.cljs$core$IAssociative$_assoc$arity$3 == null)))))){
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);
} else {
return cljs$core$IAssociative$_assoc$dyn_14284(coll,k,v);
}
});


/**
 * Protocol for implementing entry finding in collections.
 * @interface
 */
cljs.core.IFind = function(){};

var cljs$core$IFind$_find$dyn_14286 = (function cljs$core$fn_14285(coll,k){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._find[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10296__auto__.call(null,coll,k));
} else {
var m__10294__auto__ = (cljs.core._find["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10294__auto__.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IFind.-find",coll);
}
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core._find = (function cljs$core$_find(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IFind$_find$arity$2 == null)))))){
return coll.cljs$core$IFind$_find$arity$2(coll,k);
} else {
return cljs$core$IFind$_find$dyn_14286(coll,k);
}
});


/**
 * Protocol for adding mapping functionality to collections.
 * @interface
 */
cljs.core.IMap = function(){};

var cljs$core$IMap$_dissoc$dyn_14288 = (function cljs$core$fn_14287(coll,k){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._dissoc[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10296__auto__.call(null,coll,k));
} else {
var m__10294__auto__ = (cljs.core._dissoc["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10294__auto__.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IMap.-dissoc",coll);
}
}
});
/**
 * Returns a new collection of coll without the mapping for key k.
 */
cljs.core._dissoc = (function cljs$core$_dissoc(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMap$_dissoc$arity$2 == null)))))){
return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);
} else {
return cljs$core$IMap$_dissoc$dyn_14288(coll,k);
}
});


/**
 * Protocol for examining a map entry.
 * @interface
 */
cljs.core.IMapEntry = function(){};

var cljs$core$IMapEntry$_key$dyn_14291 = (function cljs$core$fn_14289(coll){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._key[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10296__auto__.call(null,coll));
} else {
var m__10294__auto__ = (cljs.core._key["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10294__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-key",coll);
}
}
});
/**
 * Returns the key of the map entry.
 */
cljs.core._key = (function cljs$core$_key(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMapEntry$_key$arity$1 == null)))))){
return coll.cljs$core$IMapEntry$_key$arity$1(coll);
} else {
return cljs$core$IMapEntry$_key$dyn_14291(coll);
}
});

var cljs$core$IMapEntry$_val$dyn_14292 = (function cljs$core$fn_14290(coll){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._val[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10296__auto__.call(null,coll));
} else {
var m__10294__auto__ = (cljs.core._val["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10294__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-val",coll);
}
}
});
/**
 * Returns the value of the map entry.
 */
cljs.core._val = (function cljs$core$_val(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMapEntry$_val$arity$1 == null)))))){
return coll.cljs$core$IMapEntry$_val$arity$1(coll);
} else {
return cljs$core$IMapEntry$_val$dyn_14292(coll);
}
});


/**
 * Protocol for adding set functionality to a collection.
 * @interface
 */
cljs.core.ISet = function(){};

var cljs$core$ISet$_disjoin$dyn_14294 = (function cljs$core$fn_14293(coll,v){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._disjoin[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__10296__auto__.call(null,coll,v));
} else {
var m__10294__auto__ = (cljs.core._disjoin["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__10294__auto__.call(null,coll,v));
} else {
throw cljs.core.missing_protocol("ISet.-disjoin",coll);
}
}
});
/**
 * Returns a new collection of coll that does not contain v.
 */
cljs.core._disjoin = (function cljs$core$_disjoin(coll,v){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISet$_disjoin$arity$2 == null)))))){
return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);
} else {
return cljs$core$ISet$_disjoin$dyn_14294(coll,v);
}
});


/**
 * Protocol for collections to provide access to their items as stacks. The top
 *   of the stack should be accessed in the most efficient way for the different
 *   data structures.
 * @interface
 */
cljs.core.IStack = function(){};

var cljs$core$IStack$_peek$dyn_14297 = (function cljs$core$fn_14295(coll){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._peek[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10296__auto__.call(null,coll));
} else {
var m__10294__auto__ = (cljs.core._peek["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10294__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-peek",coll);
}
}
});
/**
 * Returns the item from the top of the stack. Is used by cljs.core/peek.
 */
cljs.core._peek = (function cljs$core$_peek(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IStack$_peek$arity$1 == null)))))){
return coll.cljs$core$IStack$_peek$arity$1(coll);
} else {
return cljs$core$IStack$_peek$dyn_14297(coll);
}
});

var cljs$core$IStack$_pop$dyn_14298 = (function cljs$core$fn_14296(coll){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._pop[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10296__auto__.call(null,coll));
} else {
var m__10294__auto__ = (cljs.core._pop["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10294__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-pop",coll);
}
}
});
/**
 * Returns a new stack without the item on top of the stack. Is used
 *   by cljs.core/pop.
 */
cljs.core._pop = (function cljs$core$_pop(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IStack$_pop$arity$1 == null)))))){
return coll.cljs$core$IStack$_pop$arity$1(coll);
} else {
return cljs$core$IStack$_pop$dyn_14298(coll);
}
});


/**
 * Protocol for adding vector functionality to collections.
 * @interface
 */
cljs.core.IVector = function(){};

var cljs$core$IVector$_assoc_n$dyn_14300 = (function cljs$core$fn_14299(coll,n,val){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._assoc_n[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__10296__auto__.call(null,coll,n,val));
} else {
var m__10294__auto__ = (cljs.core._assoc_n["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__10294__auto__.call(null,coll,n,val));
} else {
throw cljs.core.missing_protocol("IVector.-assoc-n",coll);
}
}
});
/**
 * Returns a new vector with value val added at position n.
 */
cljs.core._assoc_n = (function cljs$core$_assoc_n(coll,n,val){
if((((!((coll == null)))) && ((!((coll.cljs$core$IVector$_assoc_n$arity$3 == null)))))){
return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);
} else {
return cljs$core$IVector$_assoc_n$dyn_14300(coll,n,val);
}
});


/**
 * Protocol for adding dereference functionality to a reference.
 * @interface
 */
cljs.core.IDeref = function(){};

var cljs$core$IDeref$_deref$dyn_14302 = (function cljs$core$fn_14301(o){
var x__10295__auto__ = (((o == null))?null:o);
var m__10296__auto__ = (cljs.core._deref[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10296__auto__.call(null,o));
} else {
var m__10294__auto__ = (cljs.core._deref["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10294__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("IDeref.-deref",o);
}
}
});
/**
 * Returns the value of the reference o.
 */
cljs.core._deref = (function cljs$core$_deref(o){
if((((!((o == null)))) && ((!((o.cljs$core$IDeref$_deref$arity$1 == null)))))){
return o.cljs$core$IDeref$_deref$arity$1(o);
} else {
return cljs$core$IDeref$_deref$dyn_14302(o);
}
});


/**
 * @interface
 */
cljs.core.IDerefWithTimeout = function(){};

var cljs$core$IDerefWithTimeout$_deref_with_timeout$dyn_14304 = (function cljs$core$fn_14303(o,msec,timeout_val){
var x__10295__auto__ = (((o == null))?null:o);
var m__10296__auto__ = (cljs.core._deref_with_timeout[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__10296__auto__.call(null,o,msec,timeout_val));
} else {
var m__10294__auto__ = (cljs.core._deref_with_timeout["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__10294__auto__.call(null,o,msec,timeout_val));
} else {
throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout",o);
}
}
});
cljs.core._deref_with_timeout = (function cljs$core$_deref_with_timeout(o,msec,timeout_val){
if((((!((o == null)))) && ((!((o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3 == null)))))){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);
} else {
return cljs$core$IDerefWithTimeout$_deref_with_timeout$dyn_14304(o,msec,timeout_val);
}
});


/**
 * Protocol for accessing the metadata of an object.
 * @interface
 */
cljs.core.IMeta = function(){};

var cljs$core$IMeta$_meta$dyn_14306 = (function cljs$core$fn_14305(o){
var x__10295__auto__ = (((o == null))?null:o);
var m__10296__auto__ = (cljs.core._meta[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10296__auto__.call(null,o));
} else {
var m__10294__auto__ = (cljs.core._meta["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10294__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("IMeta.-meta",o);
}
}
});
/**
 * Returns the metadata of object o.
 */
cljs.core._meta = (function cljs$core$_meta(o){
if((((!((o == null)))) && ((!((o.cljs$core$IMeta$_meta$arity$1 == null)))))){
return o.cljs$core$IMeta$_meta$arity$1(o);
} else {
return cljs$core$IMeta$_meta$dyn_14306(o);
}
});


/**
 * Protocol for adding metadata to an object.
 * @interface
 */
cljs.core.IWithMeta = function(){};

var cljs$core$IWithMeta$_with_meta$dyn_14308 = (function cljs$core$fn_14307(o,meta){
var x__10295__auto__ = (((o == null))?null:o);
var m__10296__auto__ = (cljs.core._with_meta[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__10296__auto__.call(null,o,meta));
} else {
var m__10294__auto__ = (cljs.core._with_meta["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__10294__auto__.call(null,o,meta));
} else {
throw cljs.core.missing_protocol("IWithMeta.-with-meta",o);
}
}
});
/**
 * Returns a new object with value of o and metadata meta added to it.
 */
cljs.core._with_meta = (function cljs$core$_with_meta(o,meta){
if((((!((o == null)))) && ((!((o.cljs$core$IWithMeta$_with_meta$arity$2 == null)))))){
return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);
} else {
return cljs$core$IWithMeta$_with_meta$dyn_14308(o,meta);
}
});


/**
 * Protocol for seq types that can reduce themselves.
 *   Called by cljs.core/reduce.
 * @interface
 */
cljs.core.IReduce = function(){};

var cljs$core$IReduce$_reduce$dyn_14314 = (function() {
var cljs$core$fn_14309 = null;
var cljs$core$fn_14309__2 = (function (coll,f){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._reduce[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__10296__auto__.call(null,coll,f));
} else {
var m__10294__auto__ = (cljs.core._reduce["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__10294__auto__.call(null,coll,f));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
});
var cljs$core$fn_14309__3 = (function (coll,f,start){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._reduce[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__10296__auto__.call(null,coll,f,start));
} else {
var m__10294__auto__ = (cljs.core._reduce["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__10294__auto__.call(null,coll,f,start));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
});
cljs$core$fn_14309 = function(coll,f,start){
switch(arguments.length){
case 2:
return cljs$core$fn_14309__2.call(this,coll,f);
case 3:
return cljs$core$fn_14309__3.call(this,coll,f,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14309.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14309__2;
cljs$core$fn_14309.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14309__3;
return cljs$core$fn_14309;
})()
;
/**
 * f should be a function of 2 arguments. If start is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc.
 */
cljs.core._reduce = (function cljs$core$_reduce(var_args){
var G__14311 = arguments.length;
switch (G__14311) {
case 2:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14312(coll,f){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReduce$_reduce$arity$2 == null)))))){
return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);
} else {
return cljs$core$IReduce$_reduce$dyn_14314.cljs$core$IFn$_invoke$arity$2(coll,f);
}
}));

(cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14313(coll,f,start){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReduce$_reduce$arity$3 == null)))))){
return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);
} else {
return cljs$core$IReduce$_reduce$dyn_14314.cljs$core$IFn$_invoke$arity$3(coll,f,start);
}
}));

(cljs.core._reduce.cljs$lang$maxFixedArity = 3);



/**
 * Protocol for associative types that can reduce themselves
 *   via a function of key and val. Called by cljs.core/reduce-kv.
 * @interface
 */
cljs.core.IKVReduce = function(){};

var cljs$core$IKVReduce$_kv_reduce$dyn_14317 = (function cljs$core$fn_14316(coll,f,init){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._kv_reduce[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__10296__auto__.call(null,coll,f,init));
} else {
var m__10294__auto__ = (cljs.core._kv_reduce["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__10294__auto__.call(null,coll,f,init));
} else {
throw cljs.core.missing_protocol("IKVReduce.-kv-reduce",coll);
}
}
});
/**
 * Reduces an associative collection and returns the result. f should be
 *   a function that takes three arguments.
 */
cljs.core._kv_reduce = (function cljs$core$_kv_reduce(coll,f,init){
if((((!((coll == null)))) && ((!((coll.cljs$core$IKVReduce$_kv_reduce$arity$3 == null)))))){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);
} else {
return cljs$core$IKVReduce$_kv_reduce$dyn_14317(coll,f,init);
}
});


/**
 * Protocol for adding value comparison functionality to a type.
 * @interface
 */
cljs.core.IEquiv = function(){};

var cljs$core$IEquiv$_equiv$dyn_14319 = (function cljs$core$fn_14318(o,other){
var x__10295__auto__ = (((o == null))?null:o);
var m__10296__auto__ = (cljs.core._equiv[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__10296__auto__.call(null,o,other));
} else {
var m__10294__auto__ = (cljs.core._equiv["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__10294__auto__.call(null,o,other));
} else {
throw cljs.core.missing_protocol("IEquiv.-equiv",o);
}
}
});
/**
 * Returns true if o and other are equal, false otherwise.
 */
cljs.core._equiv = (function cljs$core$_equiv(o,other){
if((((!((o == null)))) && ((!((o.cljs$core$IEquiv$_equiv$arity$2 == null)))))){
return o.cljs$core$IEquiv$_equiv$arity$2(o,other);
} else {
return cljs$core$IEquiv$_equiv$dyn_14319(o,other);
}
});


/**
 * Protocol for adding hashing functionality to a type.
 * @interface
 */
cljs.core.IHash = function(){};

var cljs$core$IHash$_hash$dyn_14321 = (function cljs$core$fn_14320(o){
var x__10295__auto__ = (((o == null))?null:o);
var m__10296__auto__ = (cljs.core._hash[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10296__auto__.call(null,o));
} else {
var m__10294__auto__ = (cljs.core._hash["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10294__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("IHash.-hash",o);
}
}
});
/**
 * Returns the hash code of o.
 */
cljs.core._hash = (function cljs$core$_hash(o){
if((((!((o == null)))) && ((!((o.cljs$core$IHash$_hash$arity$1 == null)))))){
return o.cljs$core$IHash$_hash$arity$1(o);
} else {
return cljs$core$IHash$_hash$dyn_14321(o);
}
});


/**
 * Protocol for adding the ability to a type to be transformed into a sequence.
 * @interface
 */
cljs.core.ISeqable = function(){};

var cljs$core$ISeqable$_seq$dyn_14323 = (function cljs$core$fn_14322(o){
var x__10295__auto__ = (((o == null))?null:o);
var m__10296__auto__ = (cljs.core._seq[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10296__auto__.call(null,o));
} else {
var m__10294__auto__ = (cljs.core._seq["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10294__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("ISeqable.-seq",o);
}
}
});
/**
 * Returns a seq of o, or nil if o is empty.
 */
cljs.core._seq = (function cljs$core$_seq(o){
if((((!((o == null)))) && ((!((o.cljs$core$ISeqable$_seq$arity$1 == null)))))){
return o.cljs$core$ISeqable$_seq$arity$1(o);
} else {
return cljs$core$ISeqable$_seq$dyn_14323(o);
}
});


/**
 * Marker interface indicating a persistent collection of sequential items
 * @interface
 */
cljs.core.ISequential = function(){};


/**
 * Marker interface indicating a persistent list
 * @interface
 */
cljs.core.IList = function(){};


/**
 * Marker interface indicating a record object
 * @interface
 */
cljs.core.IRecord = function(){};


/**
 * Protocol for reversing a seq.
 * @interface
 */
cljs.core.IReversible = function(){};

var cljs$core$IReversible$_rseq$dyn_14325 = (function cljs$core$fn_14324(coll){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._rseq[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10296__auto__.call(null,coll));
} else {
var m__10294__auto__ = (cljs.core._rseq["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10294__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IReversible.-rseq",coll);
}
}
});
/**
 * Returns a seq of the items in coll in reversed order.
 */
cljs.core._rseq = (function cljs$core$_rseq(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReversible$_rseq$arity$1 == null)))))){
return coll.cljs$core$IReversible$_rseq$arity$1(coll);
} else {
return cljs$core$IReversible$_rseq$dyn_14325(coll);
}
});


/**
 * Protocol for a collection which can represent their items
 *   in a sorted manner. 
 * @interface
 */
cljs.core.ISorted = function(){};

var cljs$core$ISorted$_sorted_seq$dyn_14330 = (function cljs$core$fn_14326(coll,ascending_QMARK_){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._sorted_seq[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__10296__auto__.call(null,coll,ascending_QMARK_));
} else {
var m__10294__auto__ = (cljs.core._sorted_seq["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__10294__auto__.call(null,coll,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq",coll);
}
}
});
/**
 * Returns a sorted seq from coll in either ascending or descending order.
 */
cljs.core._sorted_seq = (function cljs$core$_sorted_seq(coll,ascending_QMARK_){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_sorted_seq$arity$2 == null)))))){
return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);
} else {
return cljs$core$ISorted$_sorted_seq$dyn_14330(coll,ascending_QMARK_);
}
});

var cljs$core$ISorted$_sorted_seq_from$dyn_14331 = (function cljs$core$fn_14327(coll,k,ascending_QMARK_){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._sorted_seq_from[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__10296__auto__.call(null,coll,k,ascending_QMARK_));
} else {
var m__10294__auto__ = (cljs.core._sorted_seq_from["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__10294__auto__.call(null,coll,k,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq-from",coll);
}
}
});
/**
 * Returns a sorted seq from coll in either ascending or descending order.
 *   If ascending is true, the result should contain all items which are > or >=
 *   than k. If ascending is false, the result should contain all items which
 *   are < or <= than k, e.g.
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)
 */
cljs.core._sorted_seq_from = (function cljs$core$_sorted_seq_from(coll,k,ascending_QMARK_){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_sorted_seq_from$arity$3 == null)))))){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);
} else {
return cljs$core$ISorted$_sorted_seq_from$dyn_14331(coll,k,ascending_QMARK_);
}
});

var cljs$core$ISorted$_entry_key$dyn_14332 = (function cljs$core$fn_14328(coll,entry){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._entry_key[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__10296__auto__.call(null,coll,entry));
} else {
var m__10294__auto__ = (cljs.core._entry_key["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__10294__auto__.call(null,coll,entry));
} else {
throw cljs.core.missing_protocol("ISorted.-entry-key",coll);
}
}
});
/**
 * Returns the key for entry.
 */
cljs.core._entry_key = (function cljs$core$_entry_key(coll,entry){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_entry_key$arity$2 == null)))))){
return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);
} else {
return cljs$core$ISorted$_entry_key$dyn_14332(coll,entry);
}
});

var cljs$core$ISorted$_comparator$dyn_14333 = (function cljs$core$fn_14329(coll){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._comparator[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10296__auto__.call(null,coll));
} else {
var m__10294__auto__ = (cljs.core._comparator["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10294__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISorted.-comparator",coll);
}
}
});
/**
 * Returns the comparator for coll.
 */
cljs.core._comparator = (function cljs$core$_comparator(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_comparator$arity$1 == null)))))){
return coll.cljs$core$ISorted$_comparator$arity$1(coll);
} else {
return cljs$core$ISorted$_comparator$dyn_14333(coll);
}
});


/**
 * Protocol for writing. Currently only implemented by StringBufferWriter.
 * @interface
 */
cljs.core.IWriter = function(){};

var cljs$core$IWriter$_write$dyn_14336 = (function cljs$core$fn_14334(writer,s){
var x__10295__auto__ = (((writer == null))?null:writer);
var m__10296__auto__ = (cljs.core._write[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__10296__auto__.call(null,writer,s));
} else {
var m__10294__auto__ = (cljs.core._write["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__10294__auto__.call(null,writer,s));
} else {
throw cljs.core.missing_protocol("IWriter.-write",writer);
}
}
});
/**
 * Writes s with writer and returns the result.
 */
cljs.core._write = (function cljs$core$_write(writer,s){
if((((!((writer == null)))) && ((!((writer.cljs$core$IWriter$_write$arity$2 == null)))))){
return writer.cljs$core$IWriter$_write$arity$2(writer,s);
} else {
return cljs$core$IWriter$_write$dyn_14336(writer,s);
}
});

var cljs$core$IWriter$_flush$dyn_14337 = (function cljs$core$fn_14335(writer){
var x__10295__auto__ = (((writer == null))?null:writer);
var m__10296__auto__ = (cljs.core._flush[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__10296__auto__.call(null,writer));
} else {
var m__10294__auto__ = (cljs.core._flush["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__10294__auto__.call(null,writer));
} else {
throw cljs.core.missing_protocol("IWriter.-flush",writer);
}
}
});
/**
 * Flush writer.
 */
cljs.core._flush = (function cljs$core$_flush(writer){
if((((!((writer == null)))) && ((!((writer.cljs$core$IWriter$_flush$arity$1 == null)))))){
return writer.cljs$core$IWriter$_flush$arity$1(writer);
} else {
return cljs$core$IWriter$_flush$dyn_14337(writer);
}
});


/**
 * The old IPrintable protocol's implementation consisted of building a giant
 * list of strings to concatenate.  This involved lots of concat calls,
 * intermediate vectors, and lazy-seqs, and was very slow in some older JS
 * engines.  IPrintWithWriter implements printing via the IWriter protocol, so it
 * be implemented efficiently in terms of e.g. a StringBuffer append.
 * @interface
 */
cljs.core.IPrintWithWriter = function(){};

var cljs$core$IPrintWithWriter$_pr_writer$dyn_14339 = (function cljs$core$fn_14338(o,writer,opts){
var x__10295__auto__ = (((o == null))?null:o);
var m__10296__auto__ = (cljs.core._pr_writer[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__10296__auto__.call(null,o,writer,opts));
} else {
var m__10294__auto__ = (cljs.core._pr_writer["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__10294__auto__.call(null,o,writer,opts));
} else {
throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer",o);
}
}
});
cljs.core._pr_writer = (function cljs$core$_pr_writer(o,writer,opts){
if((((!((o == null)))) && ((!((o.cljs$core$IPrintWithWriter$_pr_writer$arity$3 == null)))))){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);
} else {
return cljs$core$IPrintWithWriter$_pr_writer$dyn_14339(o,writer,opts);
}
});


/**
 * Protocol for types which can have a deferred realization. Currently only
 *   implemented by Delay and LazySeq.
 * @interface
 */
cljs.core.IPending = function(){};

var cljs$core$IPending$_realized_QMARK_$dyn_14341 = (function cljs$core$fn_14340(x){
var x__10295__auto__ = (((x == null))?null:x);
var m__10296__auto__ = (cljs.core._realized_QMARK_[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10296__auto__.call(null,x));
} else {
var m__10294__auto__ = (cljs.core._realized_QMARK_["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10294__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("IPending.-realized?",x);
}
}
});
/**
 * Returns true if a value for x has been produced, false otherwise.
 */
cljs.core._realized_QMARK_ = (function cljs$core$_realized_QMARK_(x){
if((((!((x == null)))) && ((!((x.cljs$core$IPending$_realized_QMARK_$arity$1 == null)))))){
return x.cljs$core$IPending$_realized_QMARK_$arity$1(x);
} else {
return cljs$core$IPending$_realized_QMARK_$dyn_14341(x);
}
});


/**
 * Protocol for types that can be watched. Currently only implemented by Atom.
 * @interface
 */
cljs.core.IWatchable = function(){};

var cljs$core$IWatchable$_notify_watches$dyn_14345 = (function cljs$core$fn_14342(this$,oldval,newval){
var x__10295__auto__ = (((this$ == null))?null:this$);
var m__10296__auto__ = (cljs.core._notify_watches[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__10296__auto__.call(null,this$,oldval,newval));
} else {
var m__10294__auto__ = (cljs.core._notify_watches["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__10294__auto__.call(null,this$,oldval,newval));
} else {
throw cljs.core.missing_protocol("IWatchable.-notify-watches",this$);
}
}
});
/**
 * Calls all watchers with this, oldval and newval.
 */
cljs.core._notify_watches = (function cljs$core$_notify_watches(this$,oldval,newval){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_notify_watches$arity$3 == null)))))){
return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);
} else {
return cljs$core$IWatchable$_notify_watches$dyn_14345(this$,oldval,newval);
}
});

var cljs$core$IWatchable$_add_watch$dyn_14346 = (function cljs$core$fn_14343(this$,key,f){
var x__10295__auto__ = (((this$ == null))?null:this$);
var m__10296__auto__ = (cljs.core._add_watch[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__10296__auto__.call(null,this$,key,f));
} else {
var m__10294__auto__ = (cljs.core._add_watch["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__10294__auto__.call(null,this$,key,f));
} else {
throw cljs.core.missing_protocol("IWatchable.-add-watch",this$);
}
}
});
/**
 * Adds a watcher function f to this. Keys must be unique per reference,
 *   and can be used to remove the watch with -remove-watch.
 */
cljs.core._add_watch = (function cljs$core$_add_watch(this$,key,f){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_add_watch$arity$3 == null)))))){
return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);
} else {
return cljs$core$IWatchable$_add_watch$dyn_14346(this$,key,f);
}
});

var cljs$core$IWatchable$_remove_watch$dyn_14347 = (function cljs$core$fn_14344(this$,key){
var x__10295__auto__ = (((this$ == null))?null:this$);
var m__10296__auto__ = (cljs.core._remove_watch[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__10296__auto__.call(null,this$,key));
} else {
var m__10294__auto__ = (cljs.core._remove_watch["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__10294__auto__.call(null,this$,key));
} else {
throw cljs.core.missing_protocol("IWatchable.-remove-watch",this$);
}
}
});
/**
 * Removes watcher that corresponds to key from this.
 */
cljs.core._remove_watch = (function cljs$core$_remove_watch(this$,key){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_remove_watch$arity$2 == null)))))){
return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);
} else {
return cljs$core$IWatchable$_remove_watch$dyn_14347(this$,key);
}
});


/**
 * Protocol for collections which can transformed to transients.
 * @interface
 */
cljs.core.IEditableCollection = function(){};

var cljs$core$IEditableCollection$_as_transient$dyn_14349 = (function cljs$core$fn_14348(coll){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._as_transient[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10296__auto__.call(null,coll));
} else {
var m__10294__auto__ = (cljs.core._as_transient["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10294__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEditableCollection.-as-transient",coll);
}
}
});
/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core._as_transient = (function cljs$core$_as_transient(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IEditableCollection$_as_transient$arity$1 == null)))))){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
} else {
return cljs$core$IEditableCollection$_as_transient$dyn_14349(coll);
}
});


/**
 * Protocol for adding basic functionality to transient collections.
 * @interface
 */
cljs.core.ITransientCollection = function(){};

var cljs$core$ITransientCollection$_conj_BANG_$dyn_14352 = (function cljs$core$fn_14350(tcoll,val){
var x__10295__auto__ = (((tcoll == null))?null:tcoll);
var m__10296__auto__ = (cljs.core._conj_BANG_[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__10296__auto__.call(null,tcoll,val));
} else {
var m__10294__auto__ = (cljs.core._conj_BANG_["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__10294__auto__.call(null,tcoll,val));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-conj!",tcoll);
}
}
});
/**
 * Adds value val to tcoll and returns tcoll.
 */
cljs.core._conj_BANG_ = (function cljs$core$_conj_BANG_(tcoll,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else {
return cljs$core$ITransientCollection$_conj_BANG_$dyn_14352(tcoll,val);
}
});

var cljs$core$ITransientCollection$_persistent_BANG_$dyn_14353 = (function cljs$core$fn_14351(tcoll){
var x__10295__auto__ = (((tcoll == null))?null:tcoll);
var m__10296__auto__ = (cljs.core._persistent_BANG_[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__10296__auto__.call(null,tcoll));
} else {
var m__10294__auto__ = (cljs.core._persistent_BANG_["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__10294__auto__.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-persistent!",tcoll);
}
}
});
/**
 * Creates a persistent data structure from tcoll and returns it.
 */
cljs.core._persistent_BANG_ = (function cljs$core$_persistent_BANG_(tcoll){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 == null)))))){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
} else {
return cljs$core$ITransientCollection$_persistent_BANG_$dyn_14353(tcoll);
}
});


/**
 * Protocol for adding associativity to transient collections.
 * @interface
 */
cljs.core.ITransientAssociative = function(){};

var cljs$core$ITransientAssociative$_assoc_BANG_$dyn_14355 = (function cljs$core$fn_14354(tcoll,key,val){
var x__10295__auto__ = (((tcoll == null))?null:tcoll);
var m__10296__auto__ = (cljs.core._assoc_BANG_[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__10296__auto__.call(null,tcoll,key,val));
} else {
var m__10294__auto__ = (cljs.core._assoc_BANG_["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__10294__auto__.call(null,tcoll,key,val));
} else {
throw cljs.core.missing_protocol("ITransientAssociative.-assoc!",tcoll);
}
}
});
/**
 * Returns a new transient collection of tcoll with a mapping from key to
 *   val added to it.
 */
cljs.core._assoc_BANG_ = (function cljs$core$_assoc_BANG_(tcoll,key,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 == null)))))){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);
} else {
return cljs$core$ITransientAssociative$_assoc_BANG_$dyn_14355(tcoll,key,val);
}
});


/**
 * Protocol for adding mapping functionality to transient collections.
 * @interface
 */
cljs.core.ITransientMap = function(){};

var cljs$core$ITransientMap$_dissoc_BANG_$dyn_14357 = (function cljs$core$fn_14356(tcoll,key){
var x__10295__auto__ = (((tcoll == null))?null:tcoll);
var m__10296__auto__ = (cljs.core._dissoc_BANG_[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__10296__auto__.call(null,tcoll,key));
} else {
var m__10294__auto__ = (cljs.core._dissoc_BANG_["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__10294__auto__.call(null,tcoll,key));
} else {
throw cljs.core.missing_protocol("ITransientMap.-dissoc!",tcoll);
}
}
});
/**
 * Returns a new transient collection of tcoll without the mapping for key.
 */
cljs.core._dissoc_BANG_ = (function cljs$core$_dissoc_BANG_(tcoll,key){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);
} else {
return cljs$core$ITransientMap$_dissoc_BANG_$dyn_14357(tcoll,key);
}
});


/**
 * Protocol for adding vector functionality to transient collections.
 * @interface
 */
cljs.core.ITransientVector = function(){};

var cljs$core$ITransientVector$_assoc_n_BANG_$dyn_14360 = (function cljs$core$fn_14358(tcoll,n,val){
var x__10295__auto__ = (((tcoll == null))?null:tcoll);
var m__10296__auto__ = (cljs.core._assoc_n_BANG_[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__10296__auto__.call(null,tcoll,n,val));
} else {
var m__10294__auto__ = (cljs.core._assoc_n_BANG_["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__10294__auto__.call(null,tcoll,n,val));
} else {
throw cljs.core.missing_protocol("ITransientVector.-assoc-n!",tcoll);
}
}
});
/**
 * Returns tcoll with value val added at position n.
 */
cljs.core._assoc_n_BANG_ = (function cljs$core$_assoc_n_BANG_(tcoll,n,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 == null)))))){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);
} else {
return cljs$core$ITransientVector$_assoc_n_BANG_$dyn_14360(tcoll,n,val);
}
});

var cljs$core$ITransientVector$_pop_BANG_$dyn_14361 = (function cljs$core$fn_14359(tcoll){
var x__10295__auto__ = (((tcoll == null))?null:tcoll);
var m__10296__auto__ = (cljs.core._pop_BANG_[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__10296__auto__.call(null,tcoll));
} else {
var m__10294__auto__ = (cljs.core._pop_BANG_["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__10294__auto__.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientVector.-pop!",tcoll);
}
}
});
/**
 * Returns tcoll with the last item removed from it.
 */
cljs.core._pop_BANG_ = (function cljs$core$_pop_BANG_(tcoll){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1 == null)))))){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
} else {
return cljs$core$ITransientVector$_pop_BANG_$dyn_14361(tcoll);
}
});


/**
 * Protocol for adding set functionality to a transient collection.
 * @interface
 */
cljs.core.ITransientSet = function(){};

var cljs$core$ITransientSet$_disjoin_BANG_$dyn_14363 = (function cljs$core$fn_14362(tcoll,v){
var x__10295__auto__ = (((tcoll == null))?null:tcoll);
var m__10296__auto__ = (cljs.core._disjoin_BANG_[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__10296__auto__.call(null,tcoll,v));
} else {
var m__10294__auto__ = (cljs.core._disjoin_BANG_["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__10294__auto__.call(null,tcoll,v));
} else {
throw cljs.core.missing_protocol("ITransientSet.-disjoin!",tcoll);
}
}
});
/**
 * Returns tcoll without v.
 */
cljs.core._disjoin_BANG_ = (function cljs$core$_disjoin_BANG_(tcoll,v){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);
} else {
return cljs$core$ITransientSet$_disjoin_BANG_$dyn_14363(tcoll,v);
}
});


/**
 * Protocol for values that can be compared.
 * @interface
 */
cljs.core.IComparable = function(){};

var cljs$core$IComparable$_compare$dyn_14365 = (function cljs$core$fn_14364(x,y){
var x__10295__auto__ = (((x == null))?null:x);
var m__10296__auto__ = (cljs.core._compare[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__10296__auto__.call(null,x,y));
} else {
var m__10294__auto__ = (cljs.core._compare["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__10294__auto__.call(null,x,y));
} else {
throw cljs.core.missing_protocol("IComparable.-compare",x);
}
}
});
/**
 * Returns a negative number, zero, or a positive number when x is logically
 *   'less than', 'equal to', or 'greater than' y.
 */
cljs.core._compare = (function cljs$core$_compare(x,y){
if((((!((x == null)))) && ((!((x.cljs$core$IComparable$_compare$arity$2 == null)))))){
return x.cljs$core$IComparable$_compare$arity$2(x,y);
} else {
return cljs$core$IComparable$_compare$dyn_14365(x,y);
}
});


/**
 * Protocol for accessing the items of a chunk.
 * @interface
 */
cljs.core.IChunk = function(){};

var cljs$core$IChunk$_drop_first$dyn_14367 = (function cljs$core$fn_14366(coll){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._drop_first[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10296__auto__.call(null,coll));
} else {
var m__10294__auto__ = (cljs.core._drop_first["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10294__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunk.-drop-first",coll);
}
}
});
/**
 * Return a new chunk of coll with the first item removed.
 */
cljs.core._drop_first = (function cljs$core$_drop_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunk$_drop_first$arity$1 == null)))))){
return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
} else {
return cljs$core$IChunk$_drop_first$dyn_14367(coll);
}
});


/**
 * Protocol for accessing a collection as sequential chunks.
 * @interface
 */
cljs.core.IChunkedSeq = function(){};

var cljs$core$IChunkedSeq$_chunked_first$dyn_14370 = (function cljs$core$fn_14368(coll){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._chunked_first[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10296__auto__.call(null,coll));
} else {
var m__10294__auto__ = (cljs.core._chunked_first["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10294__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first",coll);
}
}
});
/**
 * Returns the first chunk in coll.
 */
cljs.core._chunked_first = (function cljs$core$_chunked_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedSeq$_chunked_first$arity$1 == null)))))){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
} else {
return cljs$core$IChunkedSeq$_chunked_first$dyn_14370(coll);
}
});

var cljs$core$IChunkedSeq$_chunked_rest$dyn_14371 = (function cljs$core$fn_14369(coll){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._chunked_rest[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10296__auto__.call(null,coll));
} else {
var m__10294__auto__ = (cljs.core._chunked_rest["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10294__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest",coll);
}
}
});
/**
 * Return a new collection of coll with the first chunk removed.
 */
cljs.core._chunked_rest = (function cljs$core$_chunked_rest(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1 == null)))))){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
} else {
return cljs$core$IChunkedSeq$_chunked_rest$dyn_14371(coll);
}
});


/**
 * Protocol for accessing the chunks of a collection.
 * @interface
 */
cljs.core.IChunkedNext = function(){};

var cljs$core$IChunkedNext$_chunked_next$dyn_14373 = (function cljs$core$fn_14372(coll){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._chunked_next[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10296__auto__.call(null,coll));
} else {
var m__10294__auto__ = (cljs.core._chunked_next["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10294__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedNext.-chunked-next",coll);
}
}
});
/**
 * Returns a new collection of coll without the first chunk.
 */
cljs.core._chunked_next = (function cljs$core$_chunked_next(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedNext$_chunked_next$arity$1 == null)))))){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
} else {
return cljs$core$IChunkedNext$_chunked_next$dyn_14373(coll);
}
});


/**
 * Protocol for adding a name.
 * @interface
 */
cljs.core.INamed = function(){};

var cljs$core$INamed$_name$dyn_14376 = (function cljs$core$fn_14374(x){
var x__10295__auto__ = (((x == null))?null:x);
var m__10296__auto__ = (cljs.core._name[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10296__auto__.call(null,x));
} else {
var m__10294__auto__ = (cljs.core._name["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10294__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-name",x);
}
}
});
/**
 * Returns the name String of x.
 */
cljs.core._name = (function cljs$core$_name(x){
if((((!((x == null)))) && ((!((x.cljs$core$INamed$_name$arity$1 == null)))))){
return x.cljs$core$INamed$_name$arity$1(x);
} else {
return cljs$core$INamed$_name$dyn_14376(x);
}
});

var cljs$core$INamed$_namespace$dyn_14377 = (function cljs$core$fn_14375(x){
var x__10295__auto__ = (((x == null))?null:x);
var m__10296__auto__ = (cljs.core._namespace[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10296__auto__.call(null,x));
} else {
var m__10294__auto__ = (cljs.core._namespace["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10294__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-namespace",x);
}
}
});
/**
 * Returns the namespace String of x.
 */
cljs.core._namespace = (function cljs$core$_namespace(x){
if((((!((x == null)))) && ((!((x.cljs$core$INamed$_namespace$arity$1 == null)))))){
return x.cljs$core$INamed$_namespace$arity$1(x);
} else {
return cljs$core$INamed$_namespace$dyn_14377(x);
}
});


/**
 * Marker protocol indicating an atom.
 * @interface
 */
cljs.core.IAtom = function(){};


/**
 * Protocol for adding resetting functionality.
 * @interface
 */
cljs.core.IReset = function(){};

var cljs$core$IReset$_reset_BANG_$dyn_14379 = (function cljs$core$fn_14378(o,new_value){
var x__10295__auto__ = (((o == null))?null:o);
var m__10296__auto__ = (cljs.core._reset_BANG_[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__10296__auto__.call(null,o,new_value));
} else {
var m__10294__auto__ = (cljs.core._reset_BANG_["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__10294__auto__.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IReset.-reset!",o);
}
}
});
/**
 * Sets the value of o to new-value.
 */
cljs.core._reset_BANG_ = (function cljs$core$_reset_BANG_(o,new_value){
if((((!((o == null)))) && ((!((o.cljs$core$IReset$_reset_BANG_$arity$2 == null)))))){
return o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);
} else {
return cljs$core$IReset$_reset_BANG_$dyn_14379(o,new_value);
}
});


/**
 * Protocol for adding swapping functionality.
 * @interface
 */
cljs.core.ISwap = function(){};

var cljs$core$ISwap$_swap_BANG_$dyn_14387 = (function() {
var cljs$core$fn_14380 = null;
var cljs$core$fn_14380__2 = (function (o,f){
var x__10295__auto__ = (((o == null))?null:o);
var m__10296__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__10296__auto__.call(null,o,f));
} else {
var m__10294__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__10294__auto__.call(null,o,f));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
var cljs$core$fn_14380__3 = (function (o,f,a){
var x__10295__auto__ = (((o == null))?null:o);
var m__10296__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__10296__auto__.call(null,o,f,a));
} else {
var m__10294__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__10294__auto__.call(null,o,f,a));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
var cljs$core$fn_14380__4 = (function (o,f,a,b){
var x__10295__auto__ = (((o == null))?null:o);
var m__10296__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$4 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__10296__auto__.call(null,o,f,a,b));
} else {
var m__10294__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$4 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__10294__auto__.call(null,o,f,a,b));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
var cljs$core$fn_14380__5 = (function (o,f,a,b,xs){
var x__10295__auto__ = (((o == null))?null:o);
var m__10296__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$5 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__10296__auto__.call(null,o,f,a,b,xs));
} else {
var m__10294__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$5 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__10294__auto__.call(null,o,f,a,b,xs));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
cljs$core$fn_14380 = function(o,f,a,b,xs){
switch(arguments.length){
case 2:
return cljs$core$fn_14380__2.call(this,o,f);
case 3:
return cljs$core$fn_14380__3.call(this,o,f,a);
case 4:
return cljs$core$fn_14380__4.call(this,o,f,a,b);
case 5:
return cljs$core$fn_14380__5.call(this,o,f,a,b,xs);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14380.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14380__2;
cljs$core$fn_14380.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14380__3;
cljs$core$fn_14380.cljs$core$IFn$_invoke$arity$4 = cljs$core$fn_14380__4;
cljs$core$fn_14380.cljs$core$IFn$_invoke$arity$5 = cljs$core$fn_14380__5;
return cljs$core$fn_14380;
})()
;
/**
 * Swaps the value of o to be (apply f current-value-of-atom args).
 */
cljs.core._swap_BANG_ = (function cljs$core$_swap_BANG_(var_args){
var G__14382 = arguments.length;
switch (G__14382) {
case 2:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14383(o,f){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$2 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_14387.cljs$core$IFn$_invoke$arity$2(o,f);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14384(o,f,a){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$3 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_14387.cljs$core$IFn$_invoke$arity$3(o,f,a);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14385(o,f,a,b){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$4 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_14387.cljs$core$IFn$_invoke$arity$4(o,f,a,b);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_14386(o,f,a,b,xs){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$5 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_14387.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs);
}
}));

(cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5);



/**
 * Protocol for adding volatile functionality.
 * @interface
 */
cljs.core.IVolatile = function(){};

var cljs$core$IVolatile$_vreset_BANG_$dyn_14390 = (function cljs$core$fn_14389(o,new_value){
var x__10295__auto__ = (((o == null))?null:o);
var m__10296__auto__ = (cljs.core._vreset_BANG_[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__10296__auto__.call(null,o,new_value));
} else {
var m__10294__auto__ = (cljs.core._vreset_BANG_["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__10294__auto__.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IVolatile.-vreset!",o);
}
}
});
/**
 * Sets the value of volatile o to new-value without regard for the
 *   current value. Returns new-value.
 */
cljs.core._vreset_BANG_ = (function cljs$core$_vreset_BANG_(o,new_value){
if((((!((o == null)))) && ((!((o.cljs$core$IVolatile$_vreset_BANG_$arity$2 == null)))))){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);
} else {
return cljs$core$IVolatile$_vreset_BANG_$dyn_14390(o,new_value);
}
});


/**
 * Protocol for iterating over a collection.
 * @interface
 */
cljs.core.IIterable = function(){};

var cljs$core$IIterable$_iterator$dyn_14392 = (function cljs$core$fn_14391(coll){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._iterator[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10296__auto__.call(null,coll));
} else {
var m__10294__auto__ = (cljs.core._iterator["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10294__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IIterable.-iterator",coll);
}
}
});
/**
 * Returns an iterator for coll.
 */
cljs.core._iterator = (function cljs$core$_iterator(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIterable$_iterator$arity$1 == null)))))){
return coll.cljs$core$IIterable$_iterator$arity$1(coll);
} else {
return cljs$core$IIterable$_iterator$dyn_14392(coll);
}
});


/**
 * Protocol for persistent or algorithmically defined collections to provide a
 *   means of dropping N items that is more efficient than sequential walking.
 * @interface
 */
cljs.core.IDrop = function(){};

var cljs$core$IDrop$_drop$dyn_14394 = (function cljs$core$fn_14393(coll,n){
var x__10295__auto__ = (((coll == null))?null:coll);
var m__10296__auto__ = (cljs.core._drop[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__10296__auto__.call(null,coll,n));
} else {
var m__10294__auto__ = (cljs.core._drop["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__10294__auto__.call(null,coll,n));
} else {
throw cljs.core.missing_protocol("IDrop.-drop",coll);
}
}
});
/**
 * Returns a collection that is ISequential, ISeq, and IReduce, or nil if past
 *   the end. The number of items to drop n must be > 0. It is also useful if the
 *   returned coll implements IDrop for subsequent use in a partition-like scenario.
 */
cljs.core._drop = (function cljs$core$_drop(coll,n){
if((((!((coll == null)))) && ((!((coll.cljs$core$IDrop$_drop$arity$2 == null)))))){
return coll.cljs$core$IDrop$_drop$arity$2(coll,n);
} else {
return cljs$core$IDrop$_drop$dyn_14394(coll,n);
}
});


/**
* @constructor
 * @implements {cljs.core.IWriter}
*/
cljs.core.StringBufferWriter = (function (sb){
this.sb = sb;
this.cljs$lang$protocol_mask$partition0$ = 1073741824;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = (function cljs$core$fn_14395(_,s){
var self__ = this;
var ___$1 = this;
return self__.sb.append(s);
}));

(cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = (function cljs$core$fn_14396(_){
var self__ = this;
var ___$1 = this;
return null;
}));

(cljs.core.StringBufferWriter.getBasis = (function cljs$core$fn_14397(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"sb","sb",-1249746442,null)], null);
}));

(cljs.core.StringBufferWriter.cljs$lang$type = true);

(cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter");

(cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = (function cljs$core$fn_14398(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/StringBufferWriter");
}));

/**
 * Positional factory function for cljs.core/StringBufferWriter.
 */
cljs.core.__GT_StringBufferWriter = (function cljs$core$__GT_StringBufferWriter(sb){
return (new cljs.core.StringBufferWriter(sb));
});

/**
 * Support so that collections can implement toString without
 * loading all the printing machinery.
 */
cljs.core.pr_str_STAR_ = (function cljs$core$pr_str_STAR_(obj){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,cljs.core.pr_opts());

writer.cljs$core$IWriter$_flush$arity$1(null);

return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb);
});
cljs.core.int_rotate_left = (function cljs$core$int_rotate_left(x,n){
return ((x << n) | (x >>> (- n)));
});
if((((typeof Math !== 'undefined') && (typeof Math.imul !== 'undefined')) && ((!((Math.imul((4294967295),(5)) === (0))))))){
cljs.core.imul = (function cljs$core$imul(a,b){
return Math.imul(a,b);
});
} else {
cljs.core.imul = (function cljs$core$imul(a,b){
var ah = ((a >>> (16)) & (65535));
var al = (a & (65535));
var bh = ((b >>> (16)) & (65535));
var bl = (b & (65535));
return (((al * bl) + ((((ah * bl) + (al * bh)) << (16)) >>> (0))) | (0));
});
}
cljs.core.m3_seed = (0);
cljs.core.m3_C1 = ((3432918353) | (0));
cljs.core.m3_C2 = ((461845907) | (0));
cljs.core.m3_mix_K1 = (function cljs$core$m3_mix_K1(k1){
return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul((k1 | (0)),cljs.core.m3_C1),(15)),cljs.core.m3_C2);
});
cljs.core.m3_mix_H1 = (function cljs$core$m3_mix_H1(h1,k1){
return ((cljs.core.imul(cljs.core.int_rotate_left(((h1 | (0)) ^ (k1 | (0))),(13)),(5)) + ((3864292196) | (0))) | (0));
});
cljs.core.m3_fmix = (function cljs$core$m3_fmix(h1,len){
var h1__$1 = (h1 | (0));
var h1__$2 = (h1__$1 ^ len);
var h1__$3 = (h1__$2 ^ (h1__$2 >>> (16)));
var h1__$4 = cljs.core.imul(h1__$3,((2246822507) | (0)));
var h1__$5 = (h1__$4 ^ (h1__$4 >>> (13)));
var h1__$6 = cljs.core.imul(h1__$5,((3266489909) | (0)));
return (h1__$6 ^ (h1__$6 >>> (16)));
});
cljs.core.m3_hash_int = (function cljs$core$m3_hash_int(in$){
if((in$ === (0))){
return in$;
} else {
var k1 = cljs.core.m3_mix_K1(in$);
var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);
return cljs.core.m3_fmix(h1,(4));
}
});
cljs.core.hash_long = (function cljs$core$hash_long(high,low){
return (high ^ low);
});
cljs.core.hash_double = (function cljs$core$hash_double(f){
var arr = (function (){var G__14399 = (new Float64Array((1)));
(G__14399[(0)] = f);

return G__14399;
})();
var buf = arr.buffer;
var high = (new DataView(buf,(0),(4))).getInt32();
var low = (new DataView(buf,(4),(4))).getInt32();
return cljs.core.hash_long(high,low);
});
cljs.core.m3_hash_unencoded_chars = (function cljs$core$m3_hash_unencoded_chars(in$){
var h1 = (function (){var i = (1);
var h1 = cljs.core.m3_seed;
while(true){
if((i < in$.length)){
var G__14400 = (i + (2));
var G__14401 = cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1((in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) << (16)))));
i = G__14400;
h1 = G__14401;
continue;
} else {
return h1;
}
break;
}
})();
var h1__$1 = ((((in$.length & (1)) === (1)))?(h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt((in$.length - (1))))):h1);
return cljs.core.m3_fmix(h1__$1,cljs.core.imul((2),in$.length));
});



cljs.core.string_hash_cache = ({});
cljs.core.string_hash_cache_count = (0);
cljs.core.hash_string_STAR_ = (function cljs$core$hash_string_STAR_(s){
if((!((s == null)))){
var len = s.length;
if((len > (0))){
var i = (0);
var hash = (0);
while(true){
if((i < len)){
var G__14404 = (i + (1));
var G__14405 = (cljs.core.imul((31),hash) + s.charCodeAt(i));
i = G__14404;
hash = G__14405;
continue;
} else {
return hash;
}
break;
}
} else {
return (0);
}
} else {
return (0);
}
});
cljs.core.add_to_string_hash_cache = (function cljs$core$add_to_string_hash_cache(k){
var h = cljs.core.hash_string_STAR_(k);
cljs.core.goog$module$goog$object.set.call(null,cljs.core.string_hash_cache,k,h);

(cljs.core.string_hash_cache_count = (cljs.core.string_hash_cache_count + (1)));

return h;
});
cljs.core.hash_string = (function cljs$core$hash_string(k){
if((cljs.core.string_hash_cache_count > (255))){
(cljs.core.string_hash_cache = ({}));

(cljs.core.string_hash_cache_count = (0));
} else {
}

if((k == null)){
return (0);
} else {
var h = (cljs.core.string_hash_cache[k]);
if(typeof h === 'number'){
return h;
} else {
return cljs.core.add_to_string_hash_cache(k);
}
}
});
/**
 * Returns the hash code of its argument. Note this is the hash code
 * consistent with =.
 */
cljs.core.hash = (function cljs$core$hash(o){
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (4194304))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IHash$))))?true:false):false)){
return (o.cljs$core$IHash$_hash$arity$1(null) ^ (0));
} else {
if(typeof o === 'number'){
if(isFinite(o)){
if((!(Number.isSafeInteger(o)))){
return cljs.core.hash_double(o);
} else {
return (Math.floor(o) % (2147483647));
}
} else {
var G__14409 = o;
switch (G__14409) {
case Infinity:
return (2146435072);

break;
case -Infinity:
return (-1048576);

break;
default:
return (2146959360);

}
}
} else {
if(o === true){
return (1231);
} else {
if(o === false){
return (1237);
} else {
if(typeof o === 'string'){
return cljs.core.m3_hash_int(cljs.core.hash_string(o));
} else {
if((o instanceof Date)){
return (o.valueOf() ^ (0));
} else {
if((o == null)){
return (0);
} else {
return (cljs.core._hash(o) ^ (0));

}
}
}
}
}
}
}
});
cljs.core.hash_combine = (function cljs$core$hash_combine(seed,hash){
return (seed ^ (((hash + (2654435769)) + (seed << (6))) + (seed >> (2))));
});
/**
 * Evaluates x and tests if it is an instance of the type
 *   c. Returns true or false
 */
cljs.core.instance_QMARK_ = (function cljs$core$instance_QMARK_(c,x){
return (x instanceof c);
});
/**
 * Return true if x is a Symbol
 */
cljs.core.symbol_QMARK_ = (function cljs$core$symbol_QMARK_(x){
return (x instanceof cljs.core.Symbol);
});
cljs.core.hash_symbol = (function cljs$core$hash_symbol(sym){
return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns));
});
cljs.core.compare_symbols = (function cljs$core$compare_symbols(a,b){
if((a.str === b.str)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__9540__auto__ = cljs.core.not(a.ns);
if(and__9540__auto__){
return b.ns;
} else {
return and__9540__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__14411 = a.ns;
var G__14412 = b.ns;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__14411,G__14412);
})();
if(((0) === nsc)){
var G__14413 = a.name;
var G__14414 = b.name;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__14413,G__14414);
} else {
return nsc;
}
}
} else {
var G__14415 = a.name;
var G__14416 = b.name;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__14415,G__14416);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Symbol = (function (ns,name,str,_hash,_meta){
this.ns = ns;
this.name = name;
this.str = str;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2154168321;
this.cljs$lang$protocol_mask$partition1$ = 4096;
});
(cljs.core.Symbol.prototype.toString = (function cljs$core$fn_14418(){
var self__ = this;
var _ = this;
return self__.str;
}));

(cljs.core.Symbol.prototype.equiv = (function cljs$core$fn_14419(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_14420(_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Symbol)){
return (self__.str === other.str);
} else {
return false;
}
}));

(cljs.core.Symbol.prototype.call = (function() {
var cljs$core$fn_14421 = null;
var cljs$core$fn_14421__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym);
});
var cljs$core$fn_14421__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});
cljs$core$fn_14421 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_14421__2.call(this,self__,coll);
case 3:
return cljs$core$fn_14421__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_14421.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14421__2;
cljs$core$fn_14421.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14421__3;
return cljs$core$fn_14421;
})()
);

(cljs.core.Symbol.prototype.apply = (function cljs$core$fn_14422(self__,args14417){
var self__ = this;
var self____$1 = this;
var args__10149__auto__ = cljs.core.aclone(args14417);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10149__auto__.length > (20)))?(function (){var G__14423 = args__10149__auto__.slice((0),(20));
G__14423.push(args__10149__auto__.slice((20)));

return G__14423;
})():args__10149__auto__)));
}));

(cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14424(coll){
var self__ = this;
var sym = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym);
}));

(cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14425(coll,not_found){
var self__ = this;
var sym = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
}));

(cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_14426(_){
var self__ = this;
var ___$1 = this;
return self__._meta;
}));

(cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_14427(_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));
}));

(cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_14428(sym){
var self__ = this;
var sym__$1 = this;
var h__10007__auto__ = self__._hash;
if((!((h__10007__auto__ == null)))){
return h__10007__auto__;
} else {
var h__10007__auto____$1 = cljs.core.hash_symbol(sym__$1);
(self__._hash = h__10007__auto____$1);

return h__10007__auto____$1;
}
}));

(cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = (function cljs$core$fn_14429(_){
var self__ = this;
var ___$1 = this;
return self__.name;
}));

(cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = (function cljs$core$fn_14430(_){
var self__ = this;
var ___$1 = this;
return self__.ns;
}));

(cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function cljs$core$fn_14431(o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,self__.str);
}));

(cljs.core.Symbol.getBasis = (function cljs$core$fn_14432(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns","ns",2082130287,null),new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.Symbol.cljs$lang$type = true);

(cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol");

(cljs.core.Symbol.cljs$lang$ctorPrWriter = (function cljs$core$fn_14433(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/Symbol");
}));

/**
 * Positional factory function for cljs.core/Symbol.
 */
cljs.core.__GT_Symbol = (function cljs$core$__GT_Symbol(ns,name,str,_hash,_meta){
return (new cljs.core.Symbol(ns,name,str,_hash,_meta));
});

/**
 * Returns true if v is of type cljs.core.Var
 */
cljs.core.var_QMARK_ = (function cljs$core$var_QMARK_(v){
return (v instanceof cljs.core.Var);
});
/**
 * Returns a Symbol with the given namespace and name. Arity-1 works
 *   on strings, keywords, and vars.
 */
cljs.core.symbol = (function cljs$core$symbol(var_args){
var G__14435 = arguments.length;
switch (G__14435) {
case 1:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14436(name){
while(true){
if((name instanceof cljs.core.Symbol)){
return name;
} else {
if(typeof name === 'string'){
var idx = name.indexOf("/");
if((idx < (1))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null,name);
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(name.substring((0),idx),name.substring((idx + (1)),name.length));
}
} else {
if(cljs.core.var_QMARK_(name)){
return name.sym;
} else {
if((name instanceof cljs.core.Keyword)){
var G__14439 = name.fqn;
name = G__14439;
continue;
} else {
throw (new Error("no conversion to symbol"));

}
}
}
}
break;
}
}));

(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14437(ns,name){
var sym_str = (((!((ns == null))))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):name);
return (new cljs.core.Symbol(ns,name,sym_str,null,null));
}));

(cljs.core.symbol.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IDeref}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Var = (function (val,sym,_meta){
this.val = val;
this.sym = sym;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 6717441;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Var.prototype.isMacro = (function cljs$core$fn_14441(){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).cljs$lang$macro;
}));

(cljs.core.Var.prototype.toString = (function cljs$core$fn_14442(){
var self__ = this;
var _ = this;
return ["#'",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.sym)].join('');
}));

(cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = (function cljs$core$fn_14443(_){
var self__ = this;
var ___$1 = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
}));

(cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_14444(_){
var self__ = this;
var ___$1 = this;
return self__._meta;
}));

(cljs.core.Var.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_14445(_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Var(self__.val,self__.sym,new_meta));
}));

(cljs.core.Var.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_14446(this$,other){
var self__ = this;
var this$__$1 = this;
if((other instanceof cljs.core.Var)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this$__$1.sym,other.sym);
} else {
return false;
}
}));

(cljs.core.Var.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_14447(_){
var self__ = this;
var ___$1 = this;
return cljs.core.hash_symbol(self__.sym);
}));

(cljs.core.Var.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Var.prototype.call = (function() {
var cljs$core$fn_14448 = null;
var cljs$core$fn_14448__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14449 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14449.cljs$core$IFn$_invoke$arity$0 ? fexpr__14449.cljs$core$IFn$_invoke$arity$0() : fexpr__14449.call(null));
});
var cljs$core$fn_14448__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14450 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14450.cljs$core$IFn$_invoke$arity$1 ? fexpr__14450.cljs$core$IFn$_invoke$arity$1(a) : fexpr__14450.call(null,a));
});
var cljs$core$fn_14448__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14451 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14451.cljs$core$IFn$_invoke$arity$2 ? fexpr__14451.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__14451.call(null,a,b));
});
var cljs$core$fn_14448__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14452 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14452.cljs$core$IFn$_invoke$arity$3 ? fexpr__14452.cljs$core$IFn$_invoke$arity$3(a,b,c) : fexpr__14452.call(null,a,b,c));
});
var cljs$core$fn_14448__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14453 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14453.cljs$core$IFn$_invoke$arity$4 ? fexpr__14453.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : fexpr__14453.call(null,a,b,c,d));
});
var cljs$core$fn_14448__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14454 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14454.cljs$core$IFn$_invoke$arity$5 ? fexpr__14454.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : fexpr__14454.call(null,a,b,c,d,e));
});
var cljs$core$fn_14448__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14455 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14455.cljs$core$IFn$_invoke$arity$6 ? fexpr__14455.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : fexpr__14455.call(null,a,b,c,d,e,f));
});
var cljs$core$fn_14448__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14456 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14456.cljs$core$IFn$_invoke$arity$7 ? fexpr__14456.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : fexpr__14456.call(null,a,b,c,d,e,f,g));
});
var cljs$core$fn_14448__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14457 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14457.cljs$core$IFn$_invoke$arity$8 ? fexpr__14457.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : fexpr__14457.call(null,a,b,c,d,e,f,g,h));
});
var cljs$core$fn_14448__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14458 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14458.cljs$core$IFn$_invoke$arity$9 ? fexpr__14458.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : fexpr__14458.call(null,a,b,c,d,e,f,g,h,i));
});
var cljs$core$fn_14448__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14459 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14459.cljs$core$IFn$_invoke$arity$10 ? fexpr__14459.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : fexpr__14459.call(null,a,b,c,d,e,f,g,h,i,j));
});
var cljs$core$fn_14448__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14460 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14460.cljs$core$IFn$_invoke$arity$11 ? fexpr__14460.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : fexpr__14460.call(null,a,b,c,d,e,f,g,h,i,j,k));
});
var cljs$core$fn_14448__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14461 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14461.cljs$core$IFn$_invoke$arity$12 ? fexpr__14461.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : fexpr__14461.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});
var cljs$core$fn_14448__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14462 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14462.cljs$core$IFn$_invoke$arity$13 ? fexpr__14462.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : fexpr__14462.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});
var cljs$core$fn_14448__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14463 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14463.cljs$core$IFn$_invoke$arity$14 ? fexpr__14463.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : fexpr__14463.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});
var cljs$core$fn_14448__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14464 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14464.cljs$core$IFn$_invoke$arity$15 ? fexpr__14464.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : fexpr__14464.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});
var cljs$core$fn_14448__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14465 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14465.cljs$core$IFn$_invoke$arity$16 ? fexpr__14465.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : fexpr__14465.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});
var cljs$core$fn_14448__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14466 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14466.cljs$core$IFn$_invoke$arity$17 ? fexpr__14466.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : fexpr__14466.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});
var cljs$core$fn_14448__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14467 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14467.cljs$core$IFn$_invoke$arity$18 ? fexpr__14467.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : fexpr__14467.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});
var cljs$core$fn_14448__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14468 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14468.cljs$core$IFn$_invoke$arity$19 ? fexpr__14468.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : fexpr__14468.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});
var cljs$core$fn_14448__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14469 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14469.cljs$core$IFn$_invoke$arity$20 ? fexpr__14469.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : fexpr__14469.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});
var cljs$core$fn_14448__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)),a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
});
cljs$core$fn_14448 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return cljs$core$fn_14448__1.call(this,self__);
case 2:
return cljs$core$fn_14448__2.call(this,self__,a);
case 3:
return cljs$core$fn_14448__3.call(this,self__,a,b);
case 4:
return cljs$core$fn_14448__4.call(this,self__,a,b,c);
case 5:
return cljs$core$fn_14448__5.call(this,self__,a,b,c,d);
case 6:
return cljs$core$fn_14448__6.call(this,self__,a,b,c,d,e);
case 7:
return cljs$core$fn_14448__7.call(this,self__,a,b,c,d,e,f);
case 8:
return cljs$core$fn_14448__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return cljs$core$fn_14448__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return cljs$core$fn_14448__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return cljs$core$fn_14448__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return cljs$core$fn_14448__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return cljs$core$fn_14448__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return cljs$core$fn_14448__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return cljs$core$fn_14448__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return cljs$core$fn_14448__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return cljs$core$fn_14448__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return cljs$core$fn_14448__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return cljs$core$fn_14448__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return cljs$core$fn_14448__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return cljs$core$fn_14448__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return cljs$core$fn_14448__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_14448.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14448__1;
cljs$core$fn_14448.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14448__2;
cljs$core$fn_14448.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14448__3;
cljs$core$fn_14448.cljs$core$IFn$_invoke$arity$4 = cljs$core$fn_14448__4;
cljs$core$fn_14448.cljs$core$IFn$_invoke$arity$5 = cljs$core$fn_14448__5;
cljs$core$fn_14448.cljs$core$IFn$_invoke$arity$6 = cljs$core$fn_14448__6;
cljs$core$fn_14448.cljs$core$IFn$_invoke$arity$7 = cljs$core$fn_14448__7;
cljs$core$fn_14448.cljs$core$IFn$_invoke$arity$8 = cljs$core$fn_14448__8;
cljs$core$fn_14448.cljs$core$IFn$_invoke$arity$9 = cljs$core$fn_14448__9;
cljs$core$fn_14448.cljs$core$IFn$_invoke$arity$10 = cljs$core$fn_14448__10;
cljs$core$fn_14448.cljs$core$IFn$_invoke$arity$11 = cljs$core$fn_14448__11;
cljs$core$fn_14448.cljs$core$IFn$_invoke$arity$12 = cljs$core$fn_14448__12;
cljs$core$fn_14448.cljs$core$IFn$_invoke$arity$13 = cljs$core$fn_14448__13;
cljs$core$fn_14448.cljs$core$IFn$_invoke$arity$14 = cljs$core$fn_14448__14;
cljs$core$fn_14448.cljs$core$IFn$_invoke$arity$15 = cljs$core$fn_14448__15;
cljs$core$fn_14448.cljs$core$IFn$_invoke$arity$16 = cljs$core$fn_14448__16;
cljs$core$fn_14448.cljs$core$IFn$_invoke$arity$17 = cljs$core$fn_14448__17;
cljs$core$fn_14448.cljs$core$IFn$_invoke$arity$18 = cljs$core$fn_14448__18;
cljs$core$fn_14448.cljs$core$IFn$_invoke$arity$19 = cljs$core$fn_14448__19;
cljs$core$fn_14448.cljs$core$IFn$_invoke$arity$20 = cljs$core$fn_14448__20;
cljs$core$fn_14448.cljs$core$IFn$_invoke$arity$21 = cljs$core$fn_14448__21;
cljs$core$fn_14448.cljs$core$IFn$_invoke$arity$22 = cljs$core$fn_14448__22;
return cljs$core$fn_14448;
})()
);

(cljs.core.Var.prototype.apply = (function cljs$core$fn_14470(self__,args14440){
var self__ = this;
var self____$1 = this;
var args__10149__auto__ = cljs.core.aclone(args14440);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10149__auto__.length > (20)))?(function (){var G__14471 = args__10149__auto__.slice((0),(20));
G__14471.push(args__10149__auto__.slice((20)));

return G__14471;
})():args__10149__auto__)));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14472(){
var self__ = this;
var _ = this;
var fexpr__14473 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14473.cljs$core$IFn$_invoke$arity$0 ? fexpr__14473.cljs$core$IFn$_invoke$arity$0() : fexpr__14473.call(null));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14474(a){
var self__ = this;
var _ = this;
var fexpr__14475 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14475.cljs$core$IFn$_invoke$arity$1 ? fexpr__14475.cljs$core$IFn$_invoke$arity$1(a) : fexpr__14475.call(null,a));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14476(a,b){
var self__ = this;
var _ = this;
var fexpr__14477 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14477.cljs$core$IFn$_invoke$arity$2 ? fexpr__14477.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__14477.call(null,a,b));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14478(a,b,c){
var self__ = this;
var _ = this;
var fexpr__14479 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14479.cljs$core$IFn$_invoke$arity$3 ? fexpr__14479.cljs$core$IFn$_invoke$arity$3(a,b,c) : fexpr__14479.call(null,a,b,c));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14480(a,b,c,d){
var self__ = this;
var _ = this;
var fexpr__14481 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14481.cljs$core$IFn$_invoke$arity$4 ? fexpr__14481.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : fexpr__14481.call(null,a,b,c,d));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_14482(a,b,c,d,e){
var self__ = this;
var _ = this;
var fexpr__14483 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14483.cljs$core$IFn$_invoke$arity$5 ? fexpr__14483.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : fexpr__14483.call(null,a,b,c,d,e));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_14484(a,b,c,d,e,f){
var self__ = this;
var _ = this;
var fexpr__14485 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14485.cljs$core$IFn$_invoke$arity$6 ? fexpr__14485.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : fexpr__14485.call(null,a,b,c,d,e,f));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = (function cljs$core$fn_14486(a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
var fexpr__14487 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14487.cljs$core$IFn$_invoke$arity$7 ? fexpr__14487.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : fexpr__14487.call(null,a,b,c,d,e,f,g));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = (function cljs$core$fn_14488(a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
var fexpr__14489 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14489.cljs$core$IFn$_invoke$arity$8 ? fexpr__14489.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : fexpr__14489.call(null,a,b,c,d,e,f,g,h));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = (function cljs$core$fn_14490(a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
var fexpr__14491 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14491.cljs$core$IFn$_invoke$arity$9 ? fexpr__14491.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : fexpr__14491.call(null,a,b,c,d,e,f,g,h,i));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = (function cljs$core$fn_14492(a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
var fexpr__14493 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14493.cljs$core$IFn$_invoke$arity$10 ? fexpr__14493.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : fexpr__14493.call(null,a,b,c,d,e,f,g,h,i,j));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = (function cljs$core$fn_14494(a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
var fexpr__14495 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14495.cljs$core$IFn$_invoke$arity$11 ? fexpr__14495.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : fexpr__14495.call(null,a,b,c,d,e,f,g,h,i,j,k));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = (function cljs$core$fn_14496(a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
var fexpr__14497 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14497.cljs$core$IFn$_invoke$arity$12 ? fexpr__14497.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : fexpr__14497.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = (function cljs$core$fn_14498(a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
var fexpr__14499 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14499.cljs$core$IFn$_invoke$arity$13 ? fexpr__14499.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : fexpr__14499.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = (function cljs$core$fn_14500(a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
var fexpr__14501 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14501.cljs$core$IFn$_invoke$arity$14 ? fexpr__14501.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : fexpr__14501.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = (function cljs$core$fn_14502(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
var fexpr__14503 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14503.cljs$core$IFn$_invoke$arity$15 ? fexpr__14503.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : fexpr__14503.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = (function cljs$core$fn_14504(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
var fexpr__14505 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14505.cljs$core$IFn$_invoke$arity$16 ? fexpr__14505.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : fexpr__14505.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = (function cljs$core$fn_14506(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
var fexpr__14507 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14507.cljs$core$IFn$_invoke$arity$17 ? fexpr__14507.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : fexpr__14507.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = (function cljs$core$fn_14508(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
var fexpr__14509 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14509.cljs$core$IFn$_invoke$arity$18 ? fexpr__14509.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : fexpr__14509.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = (function cljs$core$fn_14510(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
var fexpr__14511 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14511.cljs$core$IFn$_invoke$arity$19 ? fexpr__14511.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : fexpr__14511.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = (function cljs$core$fn_14512(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
var fexpr__14513 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14513.cljs$core$IFn$_invoke$arity$20 ? fexpr__14513.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : fexpr__14513.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = (function cljs$core$fn_14514(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)),a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
}));

(cljs.core.Var.getBasis = (function cljs$core$fn_14515(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"sym","sym",195671222,null),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.Var.cljs$lang$type = true);

(cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var");

(cljs.core.Var.cljs$lang$ctorPrWriter = (function cljs$core$fn_14516(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/Var");
}));

/**
 * Positional factory function for cljs.core/Var.
 */
cljs.core.__GT_Var = (function cljs$core$__GT_Var(val,sym,_meta){
return (new cljs.core.Var(val,sym,_meta));
});



/**
 * Return true if x implements IIterable protocol.
 */
cljs.core.iterable_QMARK_ = (function cljs$core$iterable_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition1$ & (131072))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIterable$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
}
});
/**
 * Return true if x has a JavaScript iterator property
 */
cljs.core.js_iterable_QMARK_ = (function cljs$core$js_iterable_QMARK_(x){
return (((!((x == null)))) && ((!((x[cljs.core.ITER_SYMBOL] == null)))));
});
/**
 * Clone the supplied value which must implement ICloneable.
 */
cljs.core.clone = (function cljs$core$clone(value){
return cljs.core._clone(value);
});
/**
 * Return true if x implements ICloneable protocol.
 */
cljs.core.cloneable_QMARK_ = (function cljs$core$cloneable_QMARK_(value){
if((!((value == null)))){
if((((value.cljs$lang$protocol_mask$partition1$ & (8192))) || ((cljs.core.PROTOCOL_SENTINEL === value.cljs$core$ICloneable$)))){
return true;
} else {
if((!value.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
}
});
/**
 * Returns a seq on the collection. If the collection is
 *   empty, returns nil.  (seq nil) returns nil. seq also works on
 *   Strings.
 */
cljs.core.seq = (function cljs$core$seq(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$))))?true:false):false)){
return coll.cljs$core$ISeqable$_seq$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(typeof coll === 'string'){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(cljs.core.js_iterable_QMARK_(coll)){
return cljs.core.es6_iterator_seq(cljs.core.goog$module$goog$object.get.call(null,coll,cljs.core.ITER_SYMBOL).call(coll));
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,coll)){
return cljs.core._seq(coll);
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll)," is not ISeqable"].join('')));

}
}
}
}
}
}
});
/**
 * Returns the first item in the collection. Calls seq on its
 *   argument. If coll is nil, returns nil.
 */
cljs.core.first = (function cljs$core$first(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return coll.cljs$core$ISeq$_first$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if((s == null)){
return null;
} else {
return cljs.core._first(s);
}
}
}
});
/**
 * Returns a possibly empty seq of the items after the first. Calls seq on its
 *   argument.
 */
cljs.core.rest = (function cljs$core$rest(coll){
if((!((coll == null)))){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return coll.cljs$core$ISeq$_rest$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if(s){
return s.cljs$core$ISeq$_rest$arity$1(null);
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a seq of the items after the first. Calls seq on its
 *   argument.  If there are no more items, returns nil
 */
cljs.core.next = (function cljs$core$next(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$))))?true:false):false)){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
}
});
/**
 * Equality. Returns true if x equals y, false if not. Compares
 *   numbers and collections in a type-independent manner.  Clojure's immutable data
 *   structures define -equiv (and thus =) as a value, not an identity,
 *   comparison.
 */
cljs.core._EQ_ = (function cljs$core$_EQ_(var_args){
var G__14527 = arguments.length;
switch (G__14527) {
case 1:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___14533 = arguments.length;
var i__10876__auto___14534 = (0);
while(true){
if((i__10876__auto___14534 < len__10875__auto___14533)){
args_arr__10904__auto__.push((arguments[i__10876__auto___14534]));

var G__14535 = (i__10876__auto___14534 + (1));
i__10876__auto___14534 = G__14535;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14528(x){
return true;
}));

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14529(x,y){
if((x == null)){
return (y == null);
} else {
return (((x === y)) || (cljs.core._equiv(x,y)));
}
}));

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14530(x,y,more){
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__14536 = y;
var G__14537 = cljs.core.first(more);
var G__14538 = cljs.core.next(more);
x = G__14536;
y = G__14537;
more = G__14538;
continue;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._EQ_.cljs$lang$applyTo = (function cljs$core$fn_14531(seq14524){
var G__14525 = cljs.core.first(seq14524);
var seq14524__$1 = cljs.core.next(seq14524);
var G__14526 = cljs.core.first(seq14524__$1);
var seq14524__$2 = cljs.core.next(seq14524__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14525,G__14526,seq14524__$2);
}));

(cljs.core._EQ_.cljs$lang$maxFixedArity = (2));


/**
* @constructor
*/
cljs.core.ES6Iterator = (function (s){
this.s = s;
});
(cljs.core.ES6Iterator.prototype.next = (function cljs$core$fn_14539(){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var x = cljs.core.first(self__.s);
(self__.s = cljs.core.next(self__.s));

return ({"value": x, "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6Iterator.getBasis = (function cljs$core$fn_14540(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6Iterator.cljs$lang$type = true);

(cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator");

(cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_14541(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/ES6Iterator");
}));

/**
 * Positional factory function for cljs.core/ES6Iterator.
 */
cljs.core.__GT_ES6Iterator = (function cljs$core$__GT_ES6Iterator(s){
return (new cljs.core.ES6Iterator(s));
});

/**
 * Return a ES2015+ compatible iterator for coll.
 */
cljs.core.es6_iterator = (function cljs$core$es6_iterator(coll){
return (new cljs.core.ES6Iterator(cljs.core.seq(coll)));
});

/**
* @constructor
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
*/
cljs.core.ES6IteratorSeq = (function (value,iter,_rest){
this.value = value;
this.iter = iter;
this._rest = _rest;
this.cljs$lang$protocol_mask$partition0$ = 8388672;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_14542(this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_14543(_){
var self__ = this;
var ___$1 = this;
return self__.value;
}));

(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_14544(_){
var self__ = this;
var ___$1 = this;
if((self__._rest == null)){
(self__._rest = cljs.core.es6_iterator_seq(self__.iter));
} else {
}

return self__._rest;
}));

(cljs.core.ES6IteratorSeq.getBasis = (function cljs$core$fn_14545(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"value","value",1946509744,null),new cljs.core.Symbol(null,"iter","iter",-1346195486,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_rest","_rest",-2100466189,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6IteratorSeq.cljs$lang$type = true);

(cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq");

(cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_14546(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/ES6IteratorSeq");
}));

/**
 * Positional factory function for cljs.core/ES6IteratorSeq.
 */
cljs.core.__GT_ES6IteratorSeq = (function cljs$core$__GT_ES6IteratorSeq(value,iter,_rest){
return (new cljs.core.ES6IteratorSeq(value,iter,_rest));
});

/**
 * Given an ES2015+ compatible iterator return a seq.
 */
cljs.core.es6_iterator_seq = (function cljs$core$es6_iterator_seq(iter){
var v = iter.next();
if(cljs.core.truth_(v.done)){
return null;
} else {
return (new cljs.core.ES6IteratorSeq(v.value,iter,null));
}
});
/**
 * Mix final collection hash for ordered or unordered collections.
 * hash-basis is the combined collection hash, count is the number
 * of elements included in the basis. Note this is the hash code
 * consistent with =, different from .hashCode.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.mix_collection_hash = (function cljs$core$mix_collection_hash(hash_basis,count){
var h1 = cljs.core.m3_seed;
var k1 = cljs.core.m3_mix_K1(hash_basis);
var h1__$1 = cljs.core.m3_mix_H1(h1,k1);
return cljs.core.m3_fmix(h1__$1,count);
});
/**
 * Returns the hash code, consistent with =, for an external ordered
 * collection implementing Iterable.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_ordered_coll = (function cljs$core$hash_ordered_coll(coll){
var n = (0);
var hash_code = (1);
var coll__$1 = cljs.core.seq(coll);
while(true){
if((!((coll__$1 == null)))){
var G__14547 = (n + (1));
var G__14548 = ((cljs.core.imul((31),hash_code) + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__14549 = cljs.core.next(coll__$1);
n = G__14547;
hash_code = G__14548;
coll__$1 = G__14549;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash((1),(0));
/**
 * Returns the hash code, consistent with =, for an external unordered
 * collection implementing Iterable. For maps, the iterator should
 * return map entries whose hash is computed as
 *   (hash-ordered-coll [k v]).
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_unordered_coll = (function cljs$core$hash_unordered_coll(coll){
var n = (0);
var hash_code = (0);
var coll__$1 = cljs.core.seq(coll);
while(true){
if((!((coll__$1 == null)))){
var G__14550 = (n + (1));
var G__14551 = ((hash_code + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__14552 = cljs.core.next(coll__$1);
n = G__14550;
hash_code = G__14551;
coll__$1 = G__14552;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash((0),(0));


(cljs.core.ICounted["null"] = true);

(cljs.core._count["null"] = (function cljs$core$fn_14553(_){
return (0);
}));
(Date.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_14554(o,other){
var o__$1 = this;
return (((other instanceof Date)) && ((o__$1.valueOf() === other.valueOf())));
}));

(Date.prototype.cljs$core$IComparable$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$IComparable$_compare$arity$2 = (function cljs$core$fn_14555(this$,other){
var this$__$1 = this;
if((other instanceof Date)){
var G__14556 = this$__$1.valueOf();
var G__14557 = other.valueOf();
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__14556,G__14557);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(this$__$1)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(other)].join('')));
}
}));

/**
 * @interface
 */
cljs.core.Inst = function(){};

var cljs$core$Inst$inst_ms_STAR_$dyn_14559 = (function cljs$core$fn_14558(inst){
var x__10295__auto__ = (((inst == null))?null:inst);
var m__10296__auto__ = (cljs.core.inst_ms_STAR_[goog.typeOf(x__10295__auto__)]);
if((!((m__10296__auto__ == null)))){
return (m__10296__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10296__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__10296__auto__.call(null,inst));
} else {
var m__10294__auto__ = (cljs.core.inst_ms_STAR_["_"]);
if((!((m__10294__auto__ == null)))){
return (m__10294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10294__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__10294__auto__.call(null,inst));
} else {
throw cljs.core.missing_protocol("Inst.inst-ms*",inst);
}
}
});
cljs.core.inst_ms_STAR_ = (function cljs$core$inst_ms_STAR_(inst){
if((((!((inst == null)))) && ((!((inst.cljs$core$Inst$inst_ms_STAR_$arity$1 == null)))))){
return inst.cljs$core$Inst$inst_ms_STAR_$arity$1(inst);
} else {
return cljs$core$Inst$inst_ms_STAR_$dyn_14559(inst);
}
});

(Date.prototype.cljs$core$Inst$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$Inst$inst_ms_STAR_$arity$1 = (function cljs$core$fn_14560(inst){
var inst__$1 = this;
return inst__$1.getTime();
}));
/**
 * Return the number of milliseconds since January 1, 1970, 00:00:00 GMT
 */
cljs.core.inst_ms = (function cljs$core$inst_ms(inst){
return cljs.core.inst_ms_STAR_(inst);
});
/**
 * Return true if x satisfies Inst
 */
cljs.core.inst_QMARK_ = (function cljs$core$inst_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$Inst$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);
}
});
(cljs.core.IEquiv["number"] = true);

(cljs.core._equiv["number"] = (function cljs$core$fn_14562(x,o){
return (x === o);
}));
(cljs.core.Fn["function"] = true);

(cljs.core.IMeta["function"] = true);

(cljs.core._meta["function"] = (function cljs$core$fn_14563(_){
return null;
}));
(cljs.core.IHash["_"] = true);

(cljs.core._hash["_"] = (function cljs$core$fn_14564(o){
return goog.getUid(o);
}));
/**
 * Returns a number one greater than num.
 */
cljs.core.inc = (function cljs$core$inc(x){
return (x + (1));
});

/**
* @constructor
 * @implements {cljs.core.IDeref}
*/
cljs.core.Reduced = (function (val){
this.val = val;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = (function cljs$core$fn_14565(o){
var self__ = this;
var o__$1 = this;
return self__.val;
}));

(cljs.core.Reduced.getBasis = (function cljs$core$fn_14566(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null)], null);
}));

(cljs.core.Reduced.cljs$lang$type = true);

(cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced");

(cljs.core.Reduced.cljs$lang$ctorPrWriter = (function cljs$core$fn_14567(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/Reduced");
}));

/**
 * Positional factory function for cljs.core/Reduced.
 */
cljs.core.__GT_Reduced = (function cljs$core$__GT_Reduced(val){
return (new cljs.core.Reduced(val));
});

/**
 * Wraps x in a way such that a reduce will terminate with the value x
 */
cljs.core.reduced = (function cljs$core$reduced(x){
return (new cljs.core.Reduced(x));
});
/**
 * Returns true if x is the result of a call to reduced
 */
cljs.core.reduced_QMARK_ = (function cljs$core$reduced_QMARK_(r){
return (r instanceof cljs.core.Reduced);
});
/**
 * If x is already reduced?, returns it, else returns (reduced x)
 */
cljs.core.ensure_reduced = (function cljs$core$ensure_reduced(x){
if(cljs.core.reduced_QMARK_(x)){
return x;
} else {
return cljs.core.reduced(x);
}
});
/**
 * If x is reduced?, returns (deref x), else returns x
 */
cljs.core.unreduced = (function cljs$core$unreduced(x){
if(cljs.core.reduced_QMARK_(x)){
return cljs.core.deref(x);
} else {
return x;
}
});
/**
 * Also reader macro: @var/@atom/@delay. Returns the
 * most-recently-committed value of ref. When applied to a var
 * or atom, returns its current state. When applied to a delay, forces
 * it if not already forced. See also - realized?.
 */
cljs.core.deref = (function cljs$core$deref(o){
return cljs.core._deref(o);
});
/**
 * Accepts any collection which satisfies the ICount and IIndexed protocols and
 * reduces them without incurring seq initialization
 */
cljs.core.ci_reduce = (function cljs$core$ci_reduce(var_args){
var G__14569 = arguments.length;
switch (G__14569) {
case 2:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14570(cicoll,f){
var cnt = cicoll.cljs$core$ICounted$_count$arity$1(null);
if((cnt === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = cicoll.cljs$core$IIndexed$_nth$arity$2(null,(0));
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__14571 = val;
var G__14572 = cicoll.cljs$core$IIndexed$_nth$arity$2(null,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14571,G__14572) : f.call(null,G__14571,G__14572));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14577 = nval;
var G__14578 = (n + (1));
val = G__14577;
n = G__14578;
continue;
}
} else {
return val;
}
break;
}
}
}));

(cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14573(cicoll,f,val){
var cnt = cicoll.cljs$core$ICounted$_count$arity$1(null);
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__14574 = val__$1;
var G__14575 = cicoll.cljs$core$IIndexed$_nth$arity$2(null,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14574,G__14575) : f.call(null,G__14574,G__14575));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14579 = nval;
var G__14580 = (n + (1));
val__$1 = G__14579;
n = G__14580;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.ci_reduce.cljs$lang$maxFixedArity = 3);

cljs.core.array_reduce = (function cljs$core$array_reduce(var_args){
var G__14582 = arguments.length;
switch (G__14582) {
case 2:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14583(arr,f){
var cnt = arr.length;
if((arr.length === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = (arr[(0)]);
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__14584 = val;
var G__14585 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14584,G__14585) : f.call(null,G__14584,G__14585));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14593 = nval;
var G__14594 = (n + (1));
val = G__14593;
n = G__14594;
continue;
}
} else {
return val;
}
break;
}
}
}));

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14586(arr,f,val){
var cnt = arr.length;
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__14587 = val__$1;
var G__14588 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14587,G__14588) : f.call(null,G__14587,G__14588));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14595 = nval;
var G__14596 = (n + (1));
val__$1 = G__14595;
n = G__14596;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14589(arr,f,val,idx){
var cnt = arr.length;
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__14590 = val__$1;
var G__14591 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14590,G__14591) : f.call(null,G__14590,G__14591));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14597 = nval;
var G__14598 = (n + (1));
val__$1 = G__14597;
n = G__14598;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.array_reduce.cljs$lang$maxFixedArity = 4);







/**
 * Returns true if coll implements count in constant time
 */
cljs.core.counted_QMARK_ = (function cljs$core$counted_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICounted$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
}
});
/**
 * Returns true if coll implements nth in constant time
 */
cljs.core.indexed_QMARK_ = (function cljs$core$indexed_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIndexed$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
}
});
cljs.core._indexOf = (function cljs$core$_indexOf(var_args){
var G__14602 = arguments.length;
switch (G__14602) {
case 2:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14603(coll,x){
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
}));

(cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14604(coll,x,start){
var len = cljs.core.count(coll);
if((start >= len)){
return (-1);
} else {
var idx = (((start > (0)))?start:(((start < (0)))?(function (){var x__9903__auto__ = (0);
var y__9904__auto__ = (start + len);
return ((x__9903__auto__ > y__9904__auto__) ? x__9903__auto__ : y__9904__auto__);
})():start
));
while(true){
if((idx < len)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx),x)){
return idx;
} else {
var G__14606 = (idx + (1));
idx = G__14606;
continue;
}
} else {
return (-1);
}
break;
}
}
}));

(cljs.core._indexOf.cljs$lang$maxFixedArity = 3);

cljs.core._lastIndexOf = (function cljs$core$_lastIndexOf(var_args){
var G__14608 = arguments.length;
switch (G__14608) {
case 2:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14609(coll,x){
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
}));

(cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14610(coll,x,start){
var len = cljs.core.count(coll);
if((len === (0))){
return (-1);
} else {
var idx = (((start > (0)))?(function (){var x__9910__auto__ = (len - (1));
var y__9911__auto__ = start;
return ((x__9910__auto__ < y__9911__auto__) ? x__9910__auto__ : y__9911__auto__);
})():(((start < (0)))?(len + start):start
));
while(true){
if((idx >= (0))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx),x)){
return idx;
} else {
var G__14612 = (idx - (1));
idx = G__14612;
continue;
}
} else {
return (-1);
}
break;
}
}
}));

(cljs.core._lastIndexOf.cljs$lang$maxFixedArity = 3);


/**
* @constructor
*/
cljs.core.IndexedSeqIterator = (function (arr,i){
this.arr = arr;
this.i = i;
});
(cljs.core.IndexedSeqIterator.prototype.hasNext = (function cljs$core$fn_14613(){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
}));

(cljs.core.IndexedSeqIterator.prototype.next = (function cljs$core$fn_14614(){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.IndexedSeqIterator.getBasis = (function cljs$core$fn_14615(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.IndexedSeqIterator.cljs$lang$type = true);

(cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator");

(cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_14616(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/IndexedSeqIterator");
}));

/**
 * Positional factory function for cljs.core/IndexedSeqIterator.
 */
cljs.core.__GT_IndexedSeqIterator = (function cljs$core$__GT_IndexedSeqIterator(arr,i){
return (new cljs.core.IndexedSeqIterator(arr,i));
});


/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.IndexedSeq = (function (arr,i,meta){
this.arr = arr;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 166592766;
this.cljs$lang$protocol_mask$partition1$ = 401408;
});
(cljs.core.IndexedSeq.prototype.toString = (function cljs$core$fn_14617(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.IndexedSeq.prototype.equiv = (function cljs$core$fn_14618(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.IndexedSeq.prototype.indexOf = (function() {
var cljs$core$fn_14619 = null;
var cljs$core$fn_14619__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_14619__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_14619 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_14619__1.call(this,x);
case 2:
return cljs$core$fn_14619__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14619.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14619__1;
cljs$core$fn_14619.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14619__2;
return cljs$core$fn_14619;
})()
);

(cljs.core.IndexedSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_14620 = null;
var cljs$core$fn_14620__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_14620__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_14620 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_14620__1.call(this,x);
case 2:
return cljs$core$fn_14620__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14620.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14620__1;
cljs$core$fn_14620.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14620__2;
return cljs$core$fn_14620;
})()
);

(cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_14621(coll,n){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if(((((0) <= i__$1)) && ((i__$1 < self__.arr.length)))){
return (self__.arr[i__$1]);
} else {
throw (new Error("Index out of bounds"));
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_14622(coll,n,not_found){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if(((((0) <= i__$1)) && ((i__$1 < self__.arr.length)))){
return (self__.arr[i__$1]);
} else {
return not_found;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_14623(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_14624(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_14625(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i,self__.meta));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_14626(_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_14627(_){
var self__ = this;
var ___$1 = this;
var x__9903__auto__ = (0);
var y__9904__auto__ = (self__.arr.length - self__.i);
return ((x__9903__auto__ > y__9904__auto__) ? x__9903__auto__ : y__9904__auto__);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_14628(coll){
var self__ = this;
var coll__$1 = this;
var c = coll__$1.cljs$core$ICounted$_count$arity$1(null);
if((c > (0))){
return (new cljs.core.RSeq(coll__$1,(c - (1)),null));
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_14629(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_14630(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_14631(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_14632(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_14633(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_14634(_){
var self__ = this;
var ___$1 = this;
return (self__.arr[self__.i]);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_14635(_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_14636(this$){
var self__ = this;
var this$__$1 = this;
if((self__.i < self__.arr.length)){
return this$__$1;
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_14637(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.IndexedSeq(self__.arr,self__.i,new_meta));
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_14638(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IDrop$_drop$arity$2 = (function cljs$core$fn_14639(coll,n){
var self__ = this;
var coll__$1 = this;
if((n > (0))){
if(((self__.i + n) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + n),null));
} else {
return null;
}
} else {
return coll__$1;
}
}));

(cljs.core.IndexedSeq.getBasis = (function cljs$core$fn_14640(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.IndexedSeq.cljs$lang$type = true);

(cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq");

(cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_14641(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/IndexedSeq");
}));

/**
 * Positional factory function for cljs.core/IndexedSeq.
 */
cljs.core.__GT_IndexedSeq = (function cljs$core$__GT_IndexedSeq(arr,i,meta){
return (new cljs.core.IndexedSeq(arr,i,meta));
});

(cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_14642(){
var this__10736__auto__ = this;
return cljs.core.es6_iterator(this__10736__auto__);
}));
/**
 * Create seq from a primitive JavaScript Array-like.
 */
cljs.core.prim_seq = (function cljs$core$prim_seq(var_args){
var G__14644 = arguments.length;
switch (G__14644) {
case 1:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14645(prim){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim,(0));
}));

(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14646(prim,i){
if((i < prim.length)){
return (new cljs.core.IndexedSeq(prim,i,null));
} else {
return null;
}
}));

(cljs.core.prim_seq.cljs$lang$maxFixedArity = 2);

/**
 * Create a seq from a JavaScript array.
 */
cljs.core.array_seq = (function cljs$core$array_seq(var_args){
var G__14649 = arguments.length;
switch (G__14649) {
case 1:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14650(array){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,(0));
}));

(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14651(array,i){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i);
}));

(cljs.core.array_seq.cljs$lang$maxFixedArity = 2);



/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RSeq = (function (ci,i,meta){
this.ci = ci;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.RSeq.prototype.toString = (function cljs$core$fn_14653(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.RSeq.prototype.equiv = (function cljs$core$fn_14654(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.RSeq.prototype.indexOf = (function() {
var cljs$core$fn_14655 = null;
var cljs$core$fn_14655__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_14655__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_14655 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_14655__1.call(this,x);
case 2:
return cljs$core$fn_14655__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14655.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14655__1;
cljs$core$fn_14655.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14655__2;
return cljs$core$fn_14655;
})()
);

(cljs.core.RSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_14656 = null;
var cljs$core$fn_14656__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_14656__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_14656 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_14656__1.call(this,x);
case 2:
return cljs$core$fn_14656__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14656.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14656__1;
cljs$core$fn_14656.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14656__2;
return cljs$core$fn_14656;
})()
);

(cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_14657(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_14658(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));
}));

(cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_14659(coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return null;
}
}));

(cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_14660(coll){
var self__ = this;
var coll__$1 = this;
return (self__.i + (1));
}));

(cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_14661(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_14662(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_14663(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_14664(col,f){
var self__ = this;
var col__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,col__$1);
}));

(cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_14665(col,f,start){
var self__ = this;
var col__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,col__$1);
}));

(cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_14666(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci,self__.i);
}));

(cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_14667(coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_14668(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_14669(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.RSeq(self__.ci,self__.i,new_meta));
}
}));

(cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_14670(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.RSeq.getBasis = (function cljs$core$fn_14671(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ci","ci",2049808339,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.RSeq.cljs$lang$type = true);

(cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq");

(cljs.core.RSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_14672(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/RSeq");
}));

/**
 * Positional factory function for cljs.core/RSeq.
 */
cljs.core.__GT_RSeq = (function cljs$core$__GT_RSeq(ci,i,meta){
return (new cljs.core.RSeq(ci,i,meta));
});

(cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_14673(){
var this__10736__auto__ = this;
return cljs.core.es6_iterator(this__10736__auto__);
}));
/**
 * Same as (first (next x))
 */
cljs.core.second = (function cljs$core$second(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (first (first x))
 */
cljs.core.ffirst = (function cljs$core$ffirst(coll){
return cljs.core.first(cljs.core.first(coll));
});
/**
 * Same as (next (first x))
 */
cljs.core.nfirst = (function cljs$core$nfirst(coll){
return cljs.core.next(cljs.core.first(coll));
});
/**
 * Same as (first (next x))
 */
cljs.core.fnext = (function cljs$core$fnext(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (next (next x))
 */
cljs.core.nnext = (function cljs$core$nnext(coll){
return cljs.core.next(cljs.core.next(coll));
});
/**
 * Return the last item in coll, in linear time
 */
cljs.core.last = (function cljs$core$last(s){
while(true){
var sn = cljs.core.next(s);
if((!((sn == null)))){
var G__14674 = sn;
s = G__14674;
continue;
} else {
return cljs.core.first(s);
}
break;
}
});
(cljs.core.IEquiv["_"] = true);

(cljs.core._equiv["_"] = (function cljs$core$fn_14675(x,o){
return (x === o);
}));
/**
 * conj[oin]. Returns a new collection with the xs
 *   'added'. (conj nil item) returns (item).
 *   (conj coll) returns coll. (conj) returns [].
 *   The 'addition' may happen at different 'places' depending
 *   on the concrete type.
 */
cljs.core.conj = (function cljs$core$conj(var_args){
var G__14680 = arguments.length;
switch (G__14680) {
case 0:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___14687 = arguments.length;
var i__10876__auto___14688 = (0);
while(true){
if((i__10876__auto___14688 < len__10875__auto___14687)){
args_arr__10904__auto__.push((arguments[i__10876__auto___14688]));

var G__14689 = (i__10876__auto___14688 + (1));
i__10876__auto___14688 = G__14689;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14681(){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14682(coll){
return coll;
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14683(coll,x){
if((!((coll == null)))){
return cljs.core._conj(coll,x);
} else {
return (new cljs.core.List(null,x,null,(1),null));
}
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14684(coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__14690 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
var G__14691 = cljs.core.first(xs);
var G__14692 = cljs.core.next(xs);
coll = G__14690;
x = G__14691;
xs = G__14692;
continue;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
break;
}
}));

/** @this {Function} */
(cljs.core.conj.cljs$lang$applyTo = (function cljs$core$fn_14685(seq14677){
var G__14678 = cljs.core.first(seq14677);
var seq14677__$1 = cljs.core.next(seq14677);
var G__14679 = cljs.core.first(seq14677__$1);
var seq14677__$2 = cljs.core.next(seq14677__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14678,G__14679,seq14677__$2);
}));

(cljs.core.conj.cljs$lang$maxFixedArity = (2));

/**
 * Returns an empty collection of the same category as coll, or nil
 */
cljs.core.empty = (function cljs$core$empty(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IEmptyableCollection$))))?true:false):false)){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(null);
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IEmptyableCollection$))))?true:(((!coll.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IEmptyableCollection,coll):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IEmptyableCollection,coll))){
return cljs.core._empty(coll);
} else {
return null;

}
}
}
});
cljs.core.accumulating_seq_count = (function cljs$core$accumulating_seq_count(coll){
var s = cljs.core.seq(coll);
var acc = (0);
while(true){
if(cljs.core.counted_QMARK_(s)){
return (acc + cljs.core._count(s));
} else {
var G__14695 = cljs.core.next(s);
var G__14696 = (acc + (1));
s = G__14695;
acc = G__14696;
continue;
}
break;
}
});
/**
 * Returns the number of items in the collection. (count nil) returns
 *   0.  Also works on strings, arrays, and Maps
 */
cljs.core.count = (function cljs$core$count(coll){
if((!((coll == null)))){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ICounted$))))?true:false):false)){
return coll.cljs$core$ICounted$_count$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
return coll.length;
} else {
if(typeof coll === 'string'){
return coll.length;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$))))?true:false):false)){
return cljs.core.accumulating_seq_count(coll);
} else {
return cljs.core._count(coll);

}
}
}
}
} else {
return (0);
}
});
cljs.core.linear_traversal_nth = (function cljs$core$linear_traversal_nth(var_args){
var G__14700 = arguments.length;
switch (G__14700) {
case 2:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14701(coll,n){
while(true){
if((coll == null)){
throw (new Error("Index out of bounds"));
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.seq(coll)){
var G__14704 = cljs.core.next(coll);
var G__14705 = (n - (1));
coll = G__14704;
n = G__14705;
continue;
} else {
throw (new Error("Index out of bounds"));

}
}
}
}
break;
}
}));

(cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14702(coll,n,not_found){
while(true){
if((coll == null)){
return not_found;
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
return not_found;
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.seq(coll)){
var G__14706 = cljs.core.next(coll);
var G__14707 = (n - (1));
var G__14708 = not_found;
coll = G__14706;
n = G__14707;
not_found = G__14708;
continue;
} else {
return not_found;

}
}
}
}
break;
}
}));

(cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3);

/**
 * Returns the value at the index. get returns nil if index out of
 *   bounds, nth throws an exception unless not-found is supplied.  nth
 *   also works for strings, arrays, regex Matchers and Lists, and,
 *   in O(n) time, for sequences.
 */
cljs.core.nth = (function cljs$core$nth(var_args){
var G__14710 = arguments.length;
switch (G__14710) {
case 2:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14711(coll,n){
if((!(typeof n === 'number'))){
throw (new Error("Index argument to nth must be a number"));
} else {
if((coll == null)){
return coll;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$))))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
if(cljs.core.array_QMARK_(coll)){
if(((((-1) < n)) && ((n < coll.length)))){
return (coll[(n | (0))]);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(typeof coll === 'string'){
if(((((-1) < n)) && ((n < coll.length)))){
return coll.charAt((n | (0)));
} else {
throw (new Error("Index out of bounds"));
}
} else {
if((function (){var or__9546__auto__ = (((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false);
if(or__9546__auto__){
return or__9546__auto__;
} else {
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISequential$)))){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
if((n < (0))){
throw (new Error("Index out of bounds"));
} else {
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error(["nth not supported on this type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
}));

(cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14715(coll,n,not_found){
if((!(typeof n === 'number'))){
throw (new Error("Index argument to nth must be a number."));
} else {
if((coll == null)){
return not_found;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$))))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$3(null,n,not_found);
} else {
if(cljs.core.array_QMARK_(coll)){
if(((((-1) < n)) && ((n < coll.length)))){
return (coll[(n | (0))]);
} else {
return not_found;
}
} else {
if(typeof coll === 'string'){
if(((((-1) < n)) && ((n < coll.length)))){
return coll.charAt((n | (0)));
} else {
return not_found;
}
} else {
if((function (){var or__9546__auto__ = (((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false);
if(or__9546__auto__){
return or__9546__auto__;
} else {
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISequential$)))){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
if((n < (0))){
return not_found;
} else {
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
throw (new Error(["nth not supported on this type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
}));

(cljs.core.nth.cljs$lang$maxFixedArity = 3);

/**
 * Returns the nth rest of coll, coll when n is 0.
 */
cljs.core.nthrest = (function cljs$core$nthrest(coll,n){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition1$ & (262144))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IDrop$))))?true:false):false)){
if((n > (0))){
var or__9546__auto__ = coll.cljs$core$IDrop$_drop$arity$2(null,Math.ceil(n));
if(cljs.core.truth_(or__9546__auto__)){
return or__9546__auto__;
} else {
return cljs.core.List.EMPTY;
}
} else {
return coll;
}
} else {
var n__$1 = n;
var xs = coll;
while(true){
var temp__5718__auto__ = (((n__$1 > (0))) && (cljs.core.seq(xs)));
if(temp__5718__auto__){
var xs__$1 = temp__5718__auto__;
var G__14721 = (n__$1 - (1));
var G__14722 = cljs.core.rest(xs__$1);
n__$1 = G__14721;
xs = G__14722;
continue;
} else {
return xs;
}
break;
}
}
});
/**
 * Returns the value mapped to key, not-found or nil if key not present
 *   in associative collection, set, string, array, or ILookup instance.
 */
cljs.core.get = (function cljs$core$get(var_args){
var G__14724 = arguments.length;
switch (G__14724) {
case 2:
return cljs.core.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.get.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14725(o,k){
if((o == null)){
return null;
} else {
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$))))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$2(null,k);
} else {
if(cljs.core.array_QMARK_(o)){
if((((!((k == null)))) && ((k < o.length)))){
return (o[(k | (0))]);
} else {
return null;
}
} else {
if(typeof o === 'string'){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return o.charAt((k | (0)));
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o,k);
} else {
return null;

}
}
}
}
}
}));

(cljs.core.get.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14727(o,k,not_found){
if((!((o == null)))){
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$))))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
} else {
if(cljs.core.array_QMARK_(o)){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return (o[(k | (0))]);
} else {
return not_found;
}
} else {
if(typeof o === 'string'){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return o.charAt((k | (0)));
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
} else {
return not_found;

}
}
}
}
} else {
return not_found;
}
}));

(cljs.core.get.cljs$lang$maxFixedArity = 3);



/**
 * assoc[iate]. When applied to a map, returns a new map of the
 * same (hashed/sorted) type, that contains the mapping of key(s) to
 * val(s). When applied to a vector, returns a new vector that
 * contains val at index. Note - index must be <= (count vector).
 */
cljs.core.assoc = (function cljs$core$assoc(var_args){
var G__14735 = arguments.length;
switch (G__14735) {
case 3:
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___14741 = arguments.length;
var i__10876__auto___14742 = (0);
while(true){
if((i__10876__auto___14742 < len__10875__auto___14741)){
args_arr__10904__auto__.push((arguments[i__10876__auto___14742]));

var G__14743 = (i__10876__auto___14742 + (1));
i__10876__auto___14742 = G__14743;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((3) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((3)),(0),null)):null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10905__auto__);

}
});

(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14736(coll,k,v){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IAssociative$))))?true:false):false)){
return coll.cljs$core$IAssociative$_assoc$arity$3(null,k,v);
} else {
if((!((coll == null)))){
return cljs.core._assoc(coll,k,v);
} else {
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k,v]);
}
}
}));

(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14738(coll,k,v,kvs){
while(true){
var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);
if(cljs.core.truth_(kvs)){
var G__14744 = ret;
var G__14745 = cljs.core.first(kvs);
var G__14746 = cljs.core.second(kvs);
var G__14747 = cljs.core.nnext(kvs);
coll = G__14744;
k = G__14745;
v = G__14746;
kvs = G__14747;
continue;
} else {
return ret;
}
break;
}
}));

/** @this {Function} */
(cljs.core.assoc.cljs$lang$applyTo = (function cljs$core$fn_14739(seq14731){
var G__14732 = cljs.core.first(seq14731);
var seq14731__$1 = cljs.core.next(seq14731);
var G__14733 = cljs.core.first(seq14731__$1);
var seq14731__$2 = cljs.core.next(seq14731__$1);
var G__14734 = cljs.core.first(seq14731__$2);
var seq14731__$3 = cljs.core.next(seq14731__$2);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14732,G__14733,G__14734,seq14731__$3);
}));

(cljs.core.assoc.cljs$lang$maxFixedArity = (3));

/**
 * dissoc[iate]. Returns a new map of the same (hashed/sorted) type,
 *   that does not contain a mapping for key(s).
 */
cljs.core.dissoc = (function cljs$core$dissoc(var_args){
var G__14752 = arguments.length;
switch (G__14752) {
case 1:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___14758 = arguments.length;
var i__10876__auto___14759 = (0);
while(true){
if((i__10876__auto___14759 < len__10875__auto___14758)){
args_arr__10904__auto__.push((arguments[i__10876__auto___14759]));

var G__14760 = (i__10876__auto___14759 + (1));
i__10876__auto___14759 = G__14760;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14753(coll){
return coll;
}));

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14754(coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._dissoc(coll,k);
}
}));

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14755(coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__14761 = ret;
var G__14762 = cljs.core.first(ks);
var G__14763 = cljs.core.next(ks);
coll = G__14761;
k = G__14762;
ks = G__14763;
continue;
} else {
return ret;
}
}
break;
}
}));

/** @this {Function} */
(cljs.core.dissoc.cljs$lang$applyTo = (function cljs$core$fn_14756(seq14749){
var G__14750 = cljs.core.first(seq14749);
var seq14749__$1 = cljs.core.next(seq14749);
var G__14751 = cljs.core.first(seq14749__$1);
var seq14749__$2 = cljs.core.next(seq14749__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14750,G__14751,seq14749__$2);
}));

(cljs.core.dissoc.cljs$lang$maxFixedArity = (2));

/**
 * Return true if f is a JavaScript function or satisfies the Fn protocol.
 */
cljs.core.fn_QMARK_ = (function cljs$core$fn_QMARK_(f){
var or__9546__auto__ = typeof f === 'function';
if(or__9546__auto__){
return or__9546__auto__;
} else {
if((!((f == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$Fn$)))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
}
}
});

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.MetaFn = (function (afn,meta){
this.afn = afn;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 393217;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_14766(_){
var self__ = this;
var ___$1 = this;
return self__.meta;
}));

(cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_14767(_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.MetaFn(self__.afn,new_meta));
}));

(cljs.core.MetaFn.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.MetaFn.prototype.call = (function() {
var cljs$core$fn_14768 = null;
var cljs$core$fn_14768__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});
var cljs$core$fn_14768__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));
});
var cljs$core$fn_14768__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));
});
var cljs$core$fn_14768__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));
});
var cljs$core$fn_14768__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));
});
var cljs$core$fn_14768__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));
});
var cljs$core$fn_14768__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));
});
var cljs$core$fn_14768__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));
});
var cljs$core$fn_14768__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));
});
var cljs$core$fn_14768__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));
});
var cljs$core$fn_14768__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));
});
var cljs$core$fn_14768__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));
});
var cljs$core$fn_14768__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});
var cljs$core$fn_14768__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});
var cljs$core$fn_14768__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});
var cljs$core$fn_14768__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});
var cljs$core$fn_14768__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});
var cljs$core$fn_14768__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});
var cljs$core$fn_14768__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});
var cljs$core$fn_14768__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});
var cljs$core$fn_14768__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});
var cljs$core$fn_14768__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(self__.afn,a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
});
cljs$core$fn_14768 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return cljs$core$fn_14768__1.call(this,self__);
case 2:
return cljs$core$fn_14768__2.call(this,self__,a);
case 3:
return cljs$core$fn_14768__3.call(this,self__,a,b);
case 4:
return cljs$core$fn_14768__4.call(this,self__,a,b,c);
case 5:
return cljs$core$fn_14768__5.call(this,self__,a,b,c,d);
case 6:
return cljs$core$fn_14768__6.call(this,self__,a,b,c,d,e);
case 7:
return cljs$core$fn_14768__7.call(this,self__,a,b,c,d,e,f);
case 8:
return cljs$core$fn_14768__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return cljs$core$fn_14768__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return cljs$core$fn_14768__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return cljs$core$fn_14768__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return cljs$core$fn_14768__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return cljs$core$fn_14768__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return cljs$core$fn_14768__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return cljs$core$fn_14768__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return cljs$core$fn_14768__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return cljs$core$fn_14768__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return cljs$core$fn_14768__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return cljs$core$fn_14768__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return cljs$core$fn_14768__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return cljs$core$fn_14768__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return cljs$core$fn_14768__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_14768.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14768__1;
cljs$core$fn_14768.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14768__2;
cljs$core$fn_14768.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14768__3;
cljs$core$fn_14768.cljs$core$IFn$_invoke$arity$4 = cljs$core$fn_14768__4;
cljs$core$fn_14768.cljs$core$IFn$_invoke$arity$5 = cljs$core$fn_14768__5;
cljs$core$fn_14768.cljs$core$IFn$_invoke$arity$6 = cljs$core$fn_14768__6;
cljs$core$fn_14768.cljs$core$IFn$_invoke$arity$7 = cljs$core$fn_14768__7;
cljs$core$fn_14768.cljs$core$IFn$_invoke$arity$8 = cljs$core$fn_14768__8;
cljs$core$fn_14768.cljs$core$IFn$_invoke$arity$9 = cljs$core$fn_14768__9;
cljs$core$fn_14768.cljs$core$IFn$_invoke$arity$10 = cljs$core$fn_14768__10;
cljs$core$fn_14768.cljs$core$IFn$_invoke$arity$11 = cljs$core$fn_14768__11;
cljs$core$fn_14768.cljs$core$IFn$_invoke$arity$12 = cljs$core$fn_14768__12;
cljs$core$fn_14768.cljs$core$IFn$_invoke$arity$13 = cljs$core$fn_14768__13;
cljs$core$fn_14768.cljs$core$IFn$_invoke$arity$14 = cljs$core$fn_14768__14;
cljs$core$fn_14768.cljs$core$IFn$_invoke$arity$15 = cljs$core$fn_14768__15;
cljs$core$fn_14768.cljs$core$IFn$_invoke$arity$16 = cljs$core$fn_14768__16;
cljs$core$fn_14768.cljs$core$IFn$_invoke$arity$17 = cljs$core$fn_14768__17;
cljs$core$fn_14768.cljs$core$IFn$_invoke$arity$18 = cljs$core$fn_14768__18;
cljs$core$fn_14768.cljs$core$IFn$_invoke$arity$19 = cljs$core$fn_14768__19;
cljs$core$fn_14768.cljs$core$IFn$_invoke$arity$20 = cljs$core$fn_14768__20;
cljs$core$fn_14768.cljs$core$IFn$_invoke$arity$21 = cljs$core$fn_14768__21;
cljs$core$fn_14768.cljs$core$IFn$_invoke$arity$22 = cljs$core$fn_14768__22;
return cljs$core$fn_14768;
})()
);

(cljs.core.MetaFn.prototype.apply = (function cljs$core$fn_14769(self__,args14765){
var self__ = this;
var self____$1 = this;
var args__10149__auto__ = cljs.core.aclone(args14765);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10149__auto__.length > (20)))?(function (){var G__14770 = args__10149__auto__.slice((0),(20));
G__14770.push(args__10149__auto__.slice((20)));

return G__14770;
})():args__10149__auto__)));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14771(){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14772(a){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14773(a,b){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14774(a,b,c){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14775(a,b,c,d){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_14776(a,b,c,d,e){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_14777(a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function cljs$core$fn_14778(a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function cljs$core$fn_14779(a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function cljs$core$fn_14780(a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function cljs$core$fn_14781(a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function cljs$core$fn_14782(a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function cljs$core$fn_14783(a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function cljs$core$fn_14784(a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function cljs$core$fn_14785(a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function cljs$core$fn_14786(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function cljs$core$fn_14787(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function cljs$core$fn_14788(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function cljs$core$fn_14789(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function cljs$core$fn_14790(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function cljs$core$fn_14791(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function cljs$core$fn_14792(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(self__.afn,a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
}));

(cljs.core.MetaFn.getBasis = (function cljs$core$fn_14793(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.MetaFn.cljs$lang$type = true);

(cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn");

(cljs.core.MetaFn.cljs$lang$ctorPrWriter = (function cljs$core$fn_14794(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/MetaFn");
}));

/**
 * Positional factory function for cljs.core/MetaFn.
 */
cljs.core.__GT_MetaFn = (function cljs$core$__GT_MetaFn(afn,meta){
return (new cljs.core.MetaFn(afn,meta));
});

/**
 * Returns an object of the same type and value as obj, with
 *   map m as its metadata.
 */
cljs.core.with_meta = (function cljs$core$with_meta(o,meta){
if(typeof o === 'function'){
return (new cljs.core.MetaFn(o,meta));
} else {
if((o == null)){
return null;
} else {
return cljs.core._with_meta(o,meta);
}
}
});
/**
 * Returns the metadata of obj, returns nil if there is no metadata.
 */
cljs.core.meta = (function cljs$core$meta(o){
if((function (){var and__9540__auto__ = (!((o == null)));
if(and__9540__auto__){
if((!((o == null)))){
if((((o.cljs$lang$protocol_mask$partition0$ & (131072))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMeta$)))){
return true;
} else {
if((!o.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
}
} else {
return and__9540__auto__;
}
})()){
return cljs.core._meta(o);
} else {
return null;
}
});
/**
 * For a list or queue, same as first, for a vector, same as, but much
 *   more efficient than, last. If the collection is empty, returns nil.
 */
cljs.core.peek = (function cljs$core$peek(coll){
if((coll == null)){
return null;
} else {
return cljs.core._peek(coll);
}
});
/**
 * For a list or queue, returns a new list/queue without the first
 *   item, for a vector, returns a new vector without the last item.
 *   Note - not the same as next/butlast.
 */
cljs.core.pop = (function cljs$core$pop(coll){
if((coll == null)){
return null;
} else {
return cljs.core._pop(coll);
}
});
/**
 * disj[oin]. Returns a new set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj = (function cljs$core$disj(var_args){
var G__14800 = arguments.length;
switch (G__14800) {
case 1:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___14806 = arguments.length;
var i__10876__auto___14807 = (0);
while(true){
if((i__10876__auto___14807 < len__10875__auto___14806)){
args_arr__10904__auto__.push((arguments[i__10876__auto___14807]));

var G__14808 = (i__10876__auto___14807 + (1));
i__10876__auto___14807 = G__14808;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14801(coll){
return coll;
}));

(cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14802(coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._disjoin(coll,k);
}
}));

(cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14803(coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__14809 = ret;
var G__14810 = cljs.core.first(ks);
var G__14811 = cljs.core.next(ks);
coll = G__14809;
k = G__14810;
ks = G__14811;
continue;
} else {
return ret;
}
}
break;
}
}));

/** @this {Function} */
(cljs.core.disj.cljs$lang$applyTo = (function cljs$core$fn_14804(seq14797){
var G__14798 = cljs.core.first(seq14797);
var seq14797__$1 = cljs.core.next(seq14797);
var G__14799 = cljs.core.first(seq14797__$1);
var seq14797__$2 = cljs.core.next(seq14797__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14798,G__14799,seq14797__$2);
}));

(cljs.core.disj.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if coll has no items. To check the emptiness of a seq,
 *   please use the idiom (seq x) rather than (not (empty? x))
 */
cljs.core.empty_QMARK_ = (function cljs$core$empty_QMARK_(coll){
if((coll == null)){
return true;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ICounted$))))?true:(((!coll.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,coll):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,coll))){
return (cljs.core._count(coll) === (0));
} else {
return cljs.core.not(cljs.core.seq(coll));

}
}
});
/**
 * Returns true if x satisfies ICollection
 */
cljs.core.coll_QMARK_ = (function cljs$core$coll_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (8))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICollection$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
}
}
});
/**
 * Returns true if x satisfies ISet
 */
cljs.core.set_QMARK_ = (function cljs$core$set_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
}
}
});
/**
 * Returns true if coll implements IAssociative
 */
cljs.core.associative_QMARK_ = (function cljs$core$associative_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IAssociative$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
}
});
/**
 * Returns true if coll implements IFind
 */
cljs.core.ifind_QMARK_ = (function cljs$core$ifind_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IFind$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x);
}
});
/**
 * Returns true if coll satisfies ISequential
 */
cljs.core.sequential_QMARK_ = (function cljs$core$sequential_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
}
});
/**
 * Returns true if coll satisfies ISorted
 */
cljs.core.sorted_QMARK_ = (function cljs$core$sorted_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (268435456))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISorted$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
}
});
/**
 * Returns true if coll satisfies IReduce
 */
cljs.core.reduceable_QMARK_ = (function cljs$core$reduceable_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IReduce$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
}
});
/**
 * Return true if x satisfies IMap
 */
cljs.core.map_QMARK_ = (function cljs$core$map_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
}
}
});
/**
 * Return true if x satisfies IRecord
 */
cljs.core.record_QMARK_ = (function cljs$core$record_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (67108864))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IRecord$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
}
});
/**
 * Return true if x satisfies IVector
 */
cljs.core.vector_QMARK_ = (function cljs$core$vector_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16384))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IVector$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
}
});

/**
 * Return true if x satisfies IChunkedSeq.
 */
cljs.core.chunked_seq_QMARK_ = (function cljs$core$chunked_seq_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition1$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IChunkedSeq$)))){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Create JavaSript object from an even number arguments representing
 *   interleaved keys and values.
 */
cljs.core.js_obj = (function cljs$core$js_obj(var_args){
var G__14826 = arguments.length;
switch (G__14826) {
case 0:
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___14833 = arguments.length;
var i__10876__auto___14834 = (0);
while(true){
if((i__10876__auto___14834 < len__10875__auto___14833)){
args_arr__10904__auto__.push((arguments[i__10876__auto___14834]));

var G__14835 = (i__10876__auto___14834 + (1));
i__10876__auto___14834 = G__14835;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((0) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((0)),(0),null)):null);
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__10905__auto__);

}
});

(cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14827(){
return ({});
}));

(cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14830(keyvals){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.goog$module$goog$object.create,keyvals);
}));

/** @this {Function} */
(cljs.core.js_obj.cljs$lang$applyTo = (function cljs$core$fn_14831(seq14825){
var self__10861__auto__ = this;
return self__10861__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq14825));
}));

(cljs.core.js_obj.cljs$lang$maxFixedArity = (0));

/**
 * Return the JavaScript keys for an object.
 */
cljs.core.js_keys = (function cljs$core$js_keys(obj){
return cljs.core.goog$module$goog$object.getKeys.call(null,obj);
});
/**
 * Delete a property from a JavaScript object.
 *   Returns true upon success, false otherwise.
 */
cljs.core.js_delete = (function cljs$core$js_delete(obj,key){
return delete obj[key];
});
cljs.core.array_copy = (function cljs$core$array_copy(from,i,to,j,len){
var i__$1 = i;
var j__$1 = j;
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__14836 = (i__$1 + (1));
var G__14837 = (j__$1 + (1));
var G__14838 = (len__$1 - (1));
i__$1 = G__14836;
j__$1 = G__14837;
len__$1 = G__14838;
continue;
}
break;
}
});
cljs.core.array_copy_downward = (function cljs$core$array_copy_downward(from,i,to,j,len){
var i__$1 = (i + (len - (1)));
var j__$1 = (j + (len - (1)));
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__14839 = (i__$1 - (1));
var G__14840 = (j__$1 - (1));
var G__14841 = (len__$1 - (1));
i__$1 = G__14839;
j__$1 = G__14840;
len__$1 = G__14841;
continue;
}
break;
}
});
cljs.core.lookup_sentinel = ({});
/**
 * Returns true if x is the value false, false otherwise.
 */
cljs.core.false_QMARK_ = (function cljs$core$false_QMARK_(x){
return x === false;
});
/**
 * Returns true if x is the value true, false otherwise.
 */
cljs.core.true_QMARK_ = (function cljs$core$true_QMARK_(x){
return x === true;
});
/**
 * Return true if x is a Boolean
 */
cljs.core.boolean_QMARK_ = (function cljs$core$boolean_QMARK_(x){
return ((x === true) || (x === false));
});
/**
 * Returns true if x identical to the JavaScript undefined value.
 */
cljs.core.undefined_QMARK_ = (function cljs$core$undefined_QMARK_(x){
return (void 0 === x);
});
/**
 * Return true if s satisfies ISeq
 */
cljs.core.seq_QMARK_ = (function cljs$core$seq_QMARK_(s){
if((s == null)){
return false;
} else {
if((!((s == null)))){
if((((s.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeq$)))){
return true;
} else {
if((!s.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
}
}
});
/**
 * Return true if the seq function is supported for s
 */
cljs.core.seqable_QMARK_ = (function cljs$core$seqable_QMARK_(s){
var or__9546__auto__ = (s == null);
if(or__9546__auto__){
return or__9546__auto__;
} else {
var or__9546__auto____$1 = (((!((s == null))))?(((((s.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeqable$))))?true:(((!s.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s));
if(or__9546__auto____$1){
return or__9546__auto____$1;
} else {
return ((cljs.core.array_QMARK_(s)) || (typeof s === 'string'));
}
}
});
/**
 * Coerce to boolean
 */
cljs.core.boolean$ = (function cljs$core$boolean(x){
if((x == null)){
return false;
} else {
if(x === false){
return false;
} else {
return true;

}
}
});
/**
 * Returns true if f returns true for fn? or satisfies IFn.
 */
cljs.core.ifn_QMARK_ = (function cljs$core$ifn_QMARK_(f){
var or__9546__auto__ = cljs.core.fn_QMARK_(f);
if(or__9546__auto__){
return or__9546__auto__;
} else {
if((!((f == null)))){
if((((f.cljs$lang$protocol_mask$partition0$ & (1))) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$IFn$)))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
}
}
});
/**
 * Returns true if n is a JavaScript number with no decimal part.
 */
cljs.core.integer_QMARK_ = (function cljs$core$integer_QMARK_(n){
return ((typeof n === 'number') && ((((!(isNaN(n)))) && ((((!((n === Infinity)))) && ((parseFloat(n) === parseInt(n,(10)))))))));
});
/**
 * INTERNAL: do not use
 */
cljs.core.LongImpl = cljs.core.goog$module$goog$math$Long;
/**
 * Return true if x satisfies integer? or is an instance of goog.math.Integer
 * or goog.math.Long.
 */
cljs.core.int_QMARK_ = (function cljs$core$int_QMARK_(x){
return ((cljs.core.integer_QMARK_(x)) || ((((x instanceof goog.math.Integer)) || ((x instanceof cljs.core.goog$module$goog$math$Long)))));
});
/**
 * Return true if x satisfies int? and is positive.
 */
cljs.core.pos_int_QMARK_ = (function cljs$core$pos_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (x > (0));
} else {
if((x instanceof goog.math.Integer)){
return ((cljs.core.not(x.isNegative())) && (cljs.core.not(x.isZero())));
} else {
if((x instanceof cljs.core.goog$module$goog$math$Long)){
return ((cljs.core.not(x.isNegative())) && (cljs.core.not(x.isZero())));
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is negative.
 */
cljs.core.neg_int_QMARK_ = (function cljs$core$neg_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (x < (0));
} else {
if((x instanceof goog.math.Integer)){
return x.isNegative();
} else {
if((x instanceof cljs.core.goog$module$goog$math$Long)){
return x.isNegative();
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is a natural integer value.
 */
cljs.core.nat_int_QMARK_ = (function cljs$core$nat_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (!((x < (0))));
} else {
if((x instanceof goog.math.Integer)){
return cljs.core.not(x.isNegative());
} else {
if((x instanceof cljs.core.goog$module$goog$math$Long)){
return cljs.core.not(x.isNegative());
} else {
return false;

}
}
}
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.float_QMARK_ = (function cljs$core$float_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.double_QMARK_ = (function cljs$core$double_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for Infinity and -Infinity values.
 */
cljs.core.infinite_QMARK_ = (function cljs$core$infinite_QMARK_(x){
return (((x === Number.POSITIVE_INFINITY)) || ((x === Number.NEGATIVE_INFINITY)));
});
/**
 * Returns true if key is present in the given collection, otherwise
 *   returns false.  Note that for numerically indexed collections like
 *   vectors and arrays, this tests if the numeric key is within the
 *   range of indexes. 'contains?' operates constant or logarithmic time;
 *   it will not perform a linear search for a value.  See also 'some'.
 */
cljs.core.contains_QMARK_ = (function cljs$core$contains_QMARK_(coll,v){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IAssociative$))))?true:false):false)){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(null,v);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,coll)){
return cljs.core._contains_key_QMARK_(coll,v);
} else {
if((cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return false;
} else {
return true;

}
}
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core.find = (function cljs$core$find(coll,k){
if(cljs.core.ifind_QMARK_(coll)){
return cljs.core._find(coll,k);
} else {
if((((!((coll == null)))) && (((cljs.core.associative_QMARK_(coll)) && (cljs.core.contains_QMARK_(coll,k)))))){
return (new cljs.core.MapEntry(k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k),null));
} else {
return null;
}
}
});
/**
 * Returns true if no two of the arguments are =
 */
cljs.core.distinct_QMARK_ = (function cljs$core$distinct_QMARK_(var_args){
var G__14852 = arguments.length;
switch (G__14852) {
case 1:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___14858 = arguments.length;
var i__10876__auto___14859 = (0);
while(true){
if((i__10876__auto___14859 < len__10875__auto___14858)){
args_arr__10904__auto__.push((arguments[i__10876__auto___14859]));

var G__14860 = (i__10876__auto___14859 + (1));
i__10876__auto___14859 = G__14860;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14853(x){
return true;
}));

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14854(x,y){
return (!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)));
}));

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14855(x,y,more){
if((!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)))){
var s = cljs.core.PersistentHashSet.createAsIfByAssoc([x,y]);
var xs = more;
while(true){
var x__$1 = cljs.core.first(xs);
var etc = cljs.core.next(xs);
if(cljs.core.truth_(xs)){
if(cljs.core.contains_QMARK_(s,x__$1)){
return false;
} else {
var G__14861 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);
var G__14862 = etc;
s = G__14861;
xs = G__14862;
continue;
}
} else {
return true;
}
break;
}
} else {
return false;
}
}));

/** @this {Function} */
(cljs.core.distinct_QMARK_.cljs$lang$applyTo = (function cljs$core$fn_14856(seq14849){
var G__14850 = cljs.core.first(seq14849);
var seq14849__$1 = cljs.core.next(seq14849);
var G__14851 = cljs.core.first(seq14849__$1);
var seq14849__$2 = cljs.core.next(seq14849__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14850,G__14851,seq14849__$2);
}));

(cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = (2));

/**
 * Comparator. Returns a negative number, zero, or a positive number
 *   when x is logically 'less than', 'equal to', or 'greater than'
 *   y. Uses IComparable if available and google.array.defaultCompare for objects
 *  of the same type and special-cases nil to be less than any other object.
 */
cljs.core.compare = (function cljs$core$compare(x,y){
if((x === y)){
return (0);
} else {
if((x == null)){
return (-1);
} else {
if((y == null)){
return (1);
} else {
if(typeof x === 'number'){
if(typeof y === 'number'){
return cljs.core.goog$module$goog$array.defaultCompare.call(null,x,y);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join('')));
}
} else {
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition1$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IComparable$))))?true:(((!x.cljs$lang$protocol_mask$partition1$))?cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x))){
return cljs.core._compare(x,y);
} else {
if(((((typeof x === 'string') || (((cljs.core.array_QMARK_(x)) || (((x === true) || (x === false))))))) && ((cljs.core.type(x) === cljs.core.type(y))))){
return cljs.core.goog$module$goog$array.defaultCompare.call(null,x,y);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join('')));
}

}
}
}
}
}
});
/**
 * Compare indexed collection.
 */
cljs.core.compare_indexed = (function cljs$core$compare_indexed(var_args){
var G__14865 = arguments.length;
switch (G__14865) {
case 2:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14866(xs,ys){
var xl = cljs.core.count(xs);
var yl = cljs.core.count(ys);
if((xl < yl)){
return (-1);
} else {
if((xl > yl)){
return (1);
} else {
if((xl === (0))){
return (0);
} else {
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,(0));

}
}
}
}));

(cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14867(xs,ys,len,n){
while(true){
var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));
if((((d === (0))) && (((n + (1)) < len)))){
var G__14869 = xs;
var G__14870 = ys;
var G__14871 = len;
var G__14872 = (n + (1));
xs = G__14869;
ys = G__14870;
len = G__14871;
n = G__14872;
continue;
} else {
return d;
}
break;
}
}));

(cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4);

/**
 * Given a fn that might be boolean valued or a comparator,
 * return a fn that is a comparator.
 */
cljs.core.fn__GT_comparator = (function cljs$core$fn__GT_comparator(f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare)){
return cljs.core.compare;
} else {
return (function cljs$core$fn__GT_comparator_$_fn_14873(x,y){
var r = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
if(typeof r === 'number'){
return r;
} else {
if(cljs.core.truth_(r)){
return (-1);
} else {
if(cljs.core.truth_((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(y,x) : f.call(null,y,x)))){
return (1);
} else {
return (0);
}
}
}
});
}
});
/**
 * Returns a sorted sequence of the items in coll. Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort = (function cljs$core$sort(var_args){
var G__14875 = arguments.length;
switch (G__14875) {
case 1:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14876(coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll);
}));

(cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14877(comp,coll){
if(cljs.core.seq(coll)){
var a = cljs.core.to_array(coll);
var G__14878_14881 = a;
var G__14879_14882 = cljs.core.fn__GT_comparator(comp);
cljs.core.goog$module$goog$array.stableSort.call(null,G__14878_14881,G__14879_14882);

return cljs.core.with_meta(cljs.core.seq(a),cljs.core.meta(coll));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.sort.cljs$lang$maxFixedArity = 2);

/**
 * Returns a sorted sequence of the items in coll, where the sort
 * order is determined by comparing (keyfn item).  Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort_by = (function cljs$core$sort_by(var_args){
var G__14884 = arguments.length;
switch (G__14884) {
case 2:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14885(keyfn,coll){
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll);
}));

(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14886(keyfn,comp,coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function cljs$core$fn_14886_$_fn_14887(x,y){
var G__14889 = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(x) : keyfn.call(null,x));
var G__14890 = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(y) : keyfn.call(null,y));
var fexpr__14888 = cljs.core.fn__GT_comparator(comp);
return (fexpr__14888.cljs$core$IFn$_invoke$arity$2 ? fexpr__14888.cljs$core$IFn$_invoke$arity$2(G__14889,G__14890) : fexpr__14888.call(null,G__14889,G__14890));
}),coll);
}));

(cljs.core.sort_by.cljs$lang$maxFixedArity = 3);

cljs.core.seq_reduce = (function cljs$core$seq_reduce(var_args){
var G__14893 = arguments.length;
switch (G__14893) {
case 2:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14894(f,coll){
var temp__5718__auto__ = cljs.core.seq(coll);
if(temp__5718__auto__){
var s = temp__5718__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f,cljs.core.first(s),cljs.core.next(s));
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
}));

(cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14895(f,val,coll){
var val__$1 = val;
var coll__$1 = cljs.core.seq(coll);
while(true){
if(coll__$1){
var nval = (function (){var G__14896 = val__$1;
var G__14897 = cljs.core.first(coll__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14896,G__14897) : f.call(null,G__14896,G__14897));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14899 = nval;
var G__14900 = cljs.core.next(coll__$1);
val__$1 = G__14899;
coll__$1 = G__14900;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3);

/**
 * Return a random permutation of coll
 */
cljs.core.shuffle = (function cljs$core$shuffle(coll){
var a = cljs.core.to_array(coll);
cljs.core.goog$module$goog$array.shuffle.call(null,a);

return cljs.core.vec(a);
});
cljs.core.iter_reduce = (function cljs$core$iter_reduce(var_args){
var G__14902 = arguments.length;
switch (G__14902) {
case 2:
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14903(coll,f){
var iter = cljs.core._iterator(coll);
if(cljs.core.truth_(iter.hasNext())){
var init = iter.next();
var acc = init;
while(true){
if(iter.hasNext()){
var nacc = (function (){var G__14904 = acc;
var G__14905 = iter.next();
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14904,G__14905) : f.call(null,G__14904,G__14905));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__14910 = nacc;
acc = G__14910;
continue;
}
} else {
return acc;
}
break;
}
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
}));

(cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14906(coll,f,init){
var iter = cljs.core._iterator(coll);
var acc = init;
while(true){
if(iter.hasNext()){
var nacc = (function (){var G__14907 = acc;
var G__14908 = iter.next();
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14907,G__14908) : f.call(null,G__14907,G__14908));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__14911 = nacc;
acc = G__14911;
continue;
}
} else {
return acc;
}
break;
}
}));

(cljs.core.iter_reduce.cljs$lang$maxFixedArity = 3);

/**
 * f should be a function of 2 arguments. If val is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc. If coll contains no
 *   items, f must accept no arguments as well, and reduce returns the
 *   result of calling f with no arguments.  If coll has only 1 item, it
 *   is returned and f is not called.  If val is supplied, returns the
 *   result of applying f to val and the first item in coll, then
 *   applying f to that result and the 2nd item, etc. If coll contains no
 *   items, returns val and f is not called.
 */
cljs.core.reduce = (function cljs$core$reduce(var_args){
var G__14913 = arguments.length;
switch (G__14913) {
case 2:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14914(f,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$))))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$2(null,f);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll);

}
}
}
}
}
}));

(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14916(f,val,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$))))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$3(null,f,val);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll);

}
}
}
}
}
}));

(cljs.core.reduce.cljs$lang$maxFixedArity = 3);

/**
 * Reduces an associative collection. f should be a function of 3
 *   arguments. Returns the result of applying f to init, the first key
 *   and the first value in coll, then applying f to that result and the
 *   2nd key and value, etc. If coll contains no entries, returns init
 *   and f is not called. Note that reduce-kv is supported on vectors,
 *   where the keys will be the ordinals.
 */
cljs.core.reduce_kv = (function cljs$core$reduce_kv(f,init,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (1048576))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IKVReduce$))))?true:(((!coll.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,coll):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,coll))){
return cljs.core._kv_reduce(coll,f,init);
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function cljs$core$reduce_kv_$_fn_14920(ret,me){
var G__14921 = ret;
var G__14922 = cljs.core._key(me);
var G__14923 = cljs.core._val(me);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__14921,G__14922,G__14923) : f.call(null,G__14921,G__14922,G__14923));
}),init,coll);
}
});
/**
 * Returns its argument.
 */
cljs.core.identity = (function cljs$core$identity(x){
return x;
});
/**
 * Takes a reducing function f of 2 args and returns a fn suitable for
 *   transduce by adding an arity-1 signature that calls cf (default -
 *   identity) on the result argument.
 */
cljs.core.completing = (function cljs$core$completing(var_args){
var G__14925 = arguments.length;
switch (G__14925) {
case 1:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14926(f){
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity);
}));

(cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14927(f,cf){
return (function() {
var cljs$core$fn_14927_$_fn_14928 = null;
var cljs$core$fn_14927_$_fn_14928__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
var cljs$core$fn_14927_$_fn_14928__1 = (function (x){
return (cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(x) : cf.call(null,x));
});
var cljs$core$fn_14927_$_fn_14928__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
});
cljs$core$fn_14927_$_fn_14928 = function(x,y){
switch(arguments.length){
case 0:
return cljs$core$fn_14927_$_fn_14928__0.call(this);
case 1:
return cljs$core$fn_14927_$_fn_14928__1.call(this,x);
case 2:
return cljs$core$fn_14927_$_fn_14928__2.call(this,x,y);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14927_$_fn_14928.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_14927_$_fn_14928__0;
cljs$core$fn_14927_$_fn_14928.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14927_$_fn_14928__1;
cljs$core$fn_14927_$_fn_14928.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14927_$_fn_14928__2;
return cljs$core$fn_14927_$_fn_14928;
})()
}));

(cljs.core.completing.cljs$lang$maxFixedArity = 2);

/**
 * reduce with a transformation of f (xf). If init is not
 *   supplied, (f) will be called to produce it. f should be a reducing
 *   step function that accepts both 1 and 2 arguments, if it accepts
 *   only 2 you can add the arity-1 with 'completing'. Returns the result
 *   of applying (the transformed) xf to init and the first item in coll,
 *   then applying xf to that result and the 2nd item, etc. If coll
 *   contains no items, returns init and f is not called. Note that
 *   certain transforms may inject or skip items.
 */
cljs.core.transduce = (function cljs$core$transduce(var_args){
var G__14931 = arguments.length;
switch (G__14931) {
case 3:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14932(xform,f,coll){
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,f,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),coll);
}));

(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14933(xform,f,init,coll){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);
return (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(ret) : f__$1.call(null,ret));
}));

(cljs.core.transduce.cljs$lang$maxFixedArity = 4);

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core._PLUS_ = (function cljs$core$_PLUS_(var_args){
var G__14939 = arguments.length;
switch (G__14939) {
case 0:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___14946 = arguments.length;
var i__10876__auto___14947 = (0);
while(true){
if((i__10876__auto___14947 < len__10875__auto___14946)){
args_arr__10904__auto__.push((arguments[i__10876__auto___14947]));

var G__14948 = (i__10876__auto___14947 + (1));
i__10876__auto___14947 = G__14948;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14940(){
return (0);
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14941(x){
return x;
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14942(x,y){
return (x + y);
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14943(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(x + y),more);
}));

/** @this {Function} */
(cljs.core._PLUS_.cljs$lang$applyTo = (function cljs$core$fn_14944(seq14936){
var G__14937 = cljs.core.first(seq14936);
var seq14936__$1 = cljs.core.next(seq14936);
var G__14938 = cljs.core.first(seq14936__$1);
var seq14936__$2 = cljs.core.next(seq14936__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14937,G__14938,seq14936__$2);
}));

(cljs.core._PLUS_.cljs$lang$maxFixedArity = (2));

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core._ = (function cljs$core$_(var_args){
var G__14953 = arguments.length;
switch (G__14953) {
case 1:
return cljs.core._.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___14959 = arguments.length;
var i__10876__auto___14960 = (0);
while(true){
if((i__10876__auto___14960 < len__10875__auto___14959)){
args_arr__10904__auto__.push((arguments[i__10876__auto___14960]));

var G__14961 = (i__10876__auto___14960 + (1));
i__10876__auto___14960 = G__14961;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core._.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14954(x){
return (- x);
}));

(cljs.core._.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14955(x,y){
return (x - y);
}));

(cljs.core._.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14956(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,(x - y),more);
}));

/** @this {Function} */
(cljs.core._.cljs$lang$applyTo = (function cljs$core$fn_14957(seq14950){
var G__14951 = cljs.core.first(seq14950);
var seq14950__$1 = cljs.core.next(seq14950);
var G__14952 = cljs.core.first(seq14950__$1);
var seq14950__$2 = cljs.core.next(seq14950__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14951,G__14952,seq14950__$2);
}));

(cljs.core._.cljs$lang$maxFixedArity = (2));

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core._STAR_ = (function cljs$core$_STAR_(var_args){
var G__14966 = arguments.length;
switch (G__14966) {
case 0:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___14973 = arguments.length;
var i__10876__auto___14974 = (0);
while(true){
if((i__10876__auto___14974 < len__10875__auto___14973)){
args_arr__10904__auto__.push((arguments[i__10876__auto___14974]));

var G__14975 = (i__10876__auto___14974 + (1));
i__10876__auto___14974 = G__14975;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14967(){
return (1);
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14968(x){
return x;
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14969(x,y){
return (x * y);
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14970(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,(x * y),more);
}));

/** @this {Function} */
(cljs.core._STAR_.cljs$lang$applyTo = (function cljs$core$fn_14971(seq14963){
var G__14964 = cljs.core.first(seq14963);
var seq14963__$1 = cljs.core.next(seq14963);
var G__14965 = cljs.core.first(seq14963__$1);
var seq14963__$2 = cljs.core.next(seq14963__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14964,G__14965,seq14963__$2);
}));

(cljs.core._STAR_.cljs$lang$maxFixedArity = (2));

/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core._SLASH_ = (function cljs$core$_SLASH_(var_args){
var G__14980 = arguments.length;
switch (G__14980) {
case 1:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___14986 = arguments.length;
var i__10876__auto___14987 = (0);
while(true){
if((i__10876__auto___14987 < len__10875__auto___14986)){
args_arr__10904__auto__.push((arguments[i__10876__auto___14987]));

var G__14988 = (i__10876__auto___14987 + (1));
i__10876__auto___14987 = G__14988;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14981(x){
return ((1) / x);
}));

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14982(x,y){
return (x / y);
}));

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14983(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(x / y),more);
}));

/** @this {Function} */
(cljs.core._SLASH_.cljs$lang$applyTo = (function cljs$core$fn_14984(seq14977){
var G__14978 = cljs.core.first(seq14977);
var seq14977__$1 = cljs.core.next(seq14977);
var G__14979 = cljs.core.first(seq14977__$1);
var seq14977__$2 = cljs.core.next(seq14977__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14978,G__14979,seq14977__$2);
}));

(cljs.core._SLASH_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically increasing order,
 *   otherwise false.
 */
cljs.core._LT_ = (function cljs$core$_LT_(var_args){
var G__14993 = arguments.length;
switch (G__14993) {
case 1:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___14999 = arguments.length;
var i__10876__auto___15000 = (0);
while(true){
if((i__10876__auto___15000 < len__10875__auto___14999)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15000]));

var G__15001 = (i__10876__auto___15000 + (1));
i__10876__auto___15000 = G__15001;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14994(x){
return true;
}));

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14995(x,y){
return (x < y);
}));

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14996(x,y,more){
while(true){
if((x < y)){
if(cljs.core.next(more)){
var G__15002 = y;
var G__15003 = cljs.core.first(more);
var G__15004 = cljs.core.next(more);
x = G__15002;
y = G__15003;
more = G__15004;
continue;
} else {
return (y < cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._LT_.cljs$lang$applyTo = (function cljs$core$fn_14997(seq14990){
var G__14991 = cljs.core.first(seq14990);
var seq14990__$1 = cljs.core.next(seq14990);
var G__14992 = cljs.core.first(seq14990__$1);
var seq14990__$2 = cljs.core.next(seq14990__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14991,G__14992,seq14990__$2);
}));

(cljs.core._LT_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 *   otherwise false.
 */
cljs.core._LT__EQ_ = (function cljs$core$_LT__EQ_(var_args){
var G__15009 = arguments.length;
switch (G__15009) {
case 1:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15015 = arguments.length;
var i__10876__auto___15016 = (0);
while(true){
if((i__10876__auto___15016 < len__10875__auto___15015)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15016]));

var G__15017 = (i__10876__auto___15016 + (1));
i__10876__auto___15016 = G__15017;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15010(x){
return true;
}));

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15011(x,y){
return (x <= y);
}));

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15012(x,y,more){
while(true){
if((x <= y)){
if(cljs.core.next(more)){
var G__15018 = y;
var G__15019 = cljs.core.first(more);
var G__15020 = cljs.core.next(more);
x = G__15018;
y = G__15019;
more = G__15020;
continue;
} else {
return (y <= cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._LT__EQ_.cljs$lang$applyTo = (function cljs$core$fn_15013(seq15006){
var G__15007 = cljs.core.first(seq15006);
var seq15006__$1 = cljs.core.next(seq15006);
var G__15008 = cljs.core.first(seq15006__$1);
var seq15006__$2 = cljs.core.next(seq15006__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15007,G__15008,seq15006__$2);
}));

(cljs.core._LT__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically decreasing order,
 *   otherwise false.
 */
cljs.core._GT_ = (function cljs$core$_GT_(var_args){
var G__15025 = arguments.length;
switch (G__15025) {
case 1:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15031 = arguments.length;
var i__10876__auto___15032 = (0);
while(true){
if((i__10876__auto___15032 < len__10875__auto___15031)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15032]));

var G__15033 = (i__10876__auto___15032 + (1));
i__10876__auto___15032 = G__15033;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15026(x){
return true;
}));

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15027(x,y){
return (x > y);
}));

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15028(x,y,more){
while(true){
if((x > y)){
if(cljs.core.next(more)){
var G__15034 = y;
var G__15035 = cljs.core.first(more);
var G__15036 = cljs.core.next(more);
x = G__15034;
y = G__15035;
more = G__15036;
continue;
} else {
return (y > cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._GT_.cljs$lang$applyTo = (function cljs$core$fn_15029(seq15022){
var G__15023 = cljs.core.first(seq15022);
var seq15022__$1 = cljs.core.next(seq15022);
var G__15024 = cljs.core.first(seq15022__$1);
var seq15022__$2 = cljs.core.next(seq15022__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15023,G__15024,seq15022__$2);
}));

(cljs.core._GT_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 *   otherwise false.
 */
cljs.core._GT__EQ_ = (function cljs$core$_GT__EQ_(var_args){
var G__15041 = arguments.length;
switch (G__15041) {
case 1:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15047 = arguments.length;
var i__10876__auto___15048 = (0);
while(true){
if((i__10876__auto___15048 < len__10875__auto___15047)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15048]));

var G__15049 = (i__10876__auto___15048 + (1));
i__10876__auto___15048 = G__15049;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15042(x){
return true;
}));

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15043(x,y){
return (x >= y);
}));

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15044(x,y,more){
while(true){
if((x >= y)){
if(cljs.core.next(more)){
var G__15050 = y;
var G__15051 = cljs.core.first(more);
var G__15052 = cljs.core.next(more);
x = G__15050;
y = G__15051;
more = G__15052;
continue;
} else {
return (y >= cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._GT__EQ_.cljs$lang$applyTo = (function cljs$core$fn_15045(seq15038){
var G__15039 = cljs.core.first(seq15038);
var seq15038__$1 = cljs.core.next(seq15038);
var G__15040 = cljs.core.first(seq15038__$1);
var seq15038__$2 = cljs.core.next(seq15038__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15039,G__15040,seq15038__$2);
}));

(cljs.core._GT__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns a number one less than num.
 */
cljs.core.dec = (function cljs$core$dec(x){
return (x - (1));
});
/**
 * Returns the absolute value of a.
 */
cljs.core.abs = (function cljs$core$abs(a){
return Math.abs(a);
});
/**
 * Returns the greatest of the nums.
 */
cljs.core.max = (function cljs$core$max(var_args){
var G__15057 = arguments.length;
switch (G__15057) {
case 1:
return cljs.core.max.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.max.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15063 = arguments.length;
var i__10876__auto___15064 = (0);
while(true){
if((i__10876__auto___15064 < len__10875__auto___15063)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15064]));

var G__15065 = (i__10876__auto___15064 + (1));
i__10876__auto___15064 = G__15065;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.max.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15058(x){
return x;
}));

(cljs.core.max.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15059(x,y){
var x__9903__auto__ = x;
var y__9904__auto__ = y;
return ((x__9903__auto__ > y__9904__auto__) ? x__9903__auto__ : y__9904__auto__);
}));

(cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15060(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(function (){var x__9903__auto__ = x;
var y__9904__auto__ = y;
return ((x__9903__auto__ > y__9904__auto__) ? x__9903__auto__ : y__9904__auto__);
})(),more);
}));

/** @this {Function} */
(cljs.core.max.cljs$lang$applyTo = (function cljs$core$fn_15061(seq15054){
var G__15055 = cljs.core.first(seq15054);
var seq15054__$1 = cljs.core.next(seq15054);
var G__15056 = cljs.core.first(seq15054__$1);
var seq15054__$2 = cljs.core.next(seq15054__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15055,G__15056,seq15054__$2);
}));

(cljs.core.max.cljs$lang$maxFixedArity = (2));

/**
 * Returns the least of the nums.
 */
cljs.core.min = (function cljs$core$min(var_args){
var G__15070 = arguments.length;
switch (G__15070) {
case 1:
return cljs.core.min.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.min.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15076 = arguments.length;
var i__10876__auto___15077 = (0);
while(true){
if((i__10876__auto___15077 < len__10875__auto___15076)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15077]));

var G__15078 = (i__10876__auto___15077 + (1));
i__10876__auto___15077 = G__15078;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.min.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15071(x){
return x;
}));

(cljs.core.min.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15072(x,y){
var x__9910__auto__ = x;
var y__9911__auto__ = y;
return ((x__9910__auto__ < y__9911__auto__) ? x__9910__auto__ : y__9911__auto__);
}));

(cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15073(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min,(function (){var x__9910__auto__ = x;
var y__9911__auto__ = y;
return ((x__9910__auto__ < y__9911__auto__) ? x__9910__auto__ : y__9911__auto__);
})(),more);
}));

/** @this {Function} */
(cljs.core.min.cljs$lang$applyTo = (function cljs$core$fn_15074(seq15067){
var G__15068 = cljs.core.first(seq15067);
var seq15067__$1 = cljs.core.next(seq15067);
var G__15069 = cljs.core.first(seq15067__$1);
var seq15067__$2 = cljs.core.next(seq15067__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15068,G__15069,seq15067__$2);
}));

(cljs.core.min.cljs$lang$maxFixedArity = (2));

cljs.core.byte$ = (function cljs$core$byte(x){
return x;
});
/**
 * Coerce to char
 */
cljs.core.char$ = (function cljs$core$char(x){
if(typeof x === 'number'){
return String.fromCharCode(x);
} else {
if(((typeof x === 'string') && ((x.length === (1))))){
return x;
} else {
throw (new Error("Argument to char must be a character or number"));

}
}
});
cljs.core.short$ = (function cljs$core$short(x){
return x;
});
cljs.core.float$ = (function cljs$core$float(x){
return x;
});
cljs.core.double$ = (function cljs$core$double(x){
return x;
});
cljs.core.unchecked_byte = (function cljs$core$unchecked_byte(x){
return x;
});
cljs.core.unchecked_char = (function cljs$core$unchecked_char(x){
return x;
});
cljs.core.unchecked_short = (function cljs$core$unchecked_short(x){
return x;
});
cljs.core.unchecked_float = (function cljs$core$unchecked_float(x){
return x;
});
cljs.core.unchecked_double = (function cljs$core$unchecked_double(x){
return x;
});
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add = (function cljs$core$unchecked_add(var_args){
var G__15083 = arguments.length;
switch (G__15083) {
case 0:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15090 = arguments.length;
var i__10876__auto___15091 = (0);
while(true){
if((i__10876__auto___15091 < len__10875__auto___15090)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15091]));

var G__15092 = (i__10876__auto___15091 + (1));
i__10876__auto___15091 = G__15092;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15084(){
return (0);
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15085(x){
return x;
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15086(x,y){
return (x + y);
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15087(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add,(x + y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_add.cljs$lang$applyTo = (function cljs$core$fn_15088(seq15080){
var G__15081 = cljs.core.first(seq15080);
var seq15080__$1 = cljs.core.next(seq15080);
var G__15082 = cljs.core.first(seq15080__$1);
var seq15080__$2 = cljs.core.next(seq15080__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15081,G__15082,seq15080__$2);
}));

(cljs.core.unchecked_add.cljs$lang$maxFixedArity = (2));

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add_int = (function cljs$core$unchecked_add_int(var_args){
var G__15097 = arguments.length;
switch (G__15097) {
case 0:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15104 = arguments.length;
var i__10876__auto___15105 = (0);
while(true){
if((i__10876__auto___15105 < len__10875__auto___15104)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15105]));

var G__15106 = (i__10876__auto___15105 + (1));
i__10876__auto___15105 = G__15106;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15098(){
return (0);
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15099(x){
return x;
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15100(x,y){
return (x + y);
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15101(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int,(x + y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_add_int.cljs$lang$applyTo = (function cljs$core$fn_15102(seq15094){
var G__15095 = cljs.core.first(seq15094);
var seq15094__$1 = cljs.core.next(seq15094);
var G__15096 = cljs.core.first(seq15094__$1);
var seq15094__$2 = cljs.core.next(seq15094__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15095,G__15096,seq15094__$2);
}));

(cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = (2));

/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec = (function cljs$core$unchecked_dec(x){
return (x - (1));
});
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec_int = (function cljs$core$unchecked_dec_int(x){
return (x - (1));
});
/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core.unchecked_divide_int = (function cljs$core$unchecked_divide_int(var_args){
var G__15111 = arguments.length;
switch (G__15111) {
case 1:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15117 = arguments.length;
var i__10876__auto___15118 = (0);
while(true){
if((i__10876__auto___15118 < len__10875__auto___15117)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15118]));

var G__15119 = (i__10876__auto___15118 + (1));
i__10876__auto___15118 = G__15119;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15112(x){
return ((1) / x);
}));

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15113(x,y){
return (x / y);
}));

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15114(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int,(x / y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_divide_int.cljs$lang$applyTo = (function cljs$core$fn_15115(seq15108){
var G__15109 = cljs.core.first(seq15108);
var seq15108__$1 = cljs.core.next(seq15108);
var G__15110 = cljs.core.first(seq15108__$1);
var seq15108__$2 = cljs.core.next(seq15108__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15109,G__15110,seq15108__$2);
}));

(cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = (2));

cljs.core.unchecked_inc = (function cljs$core$unchecked_inc(x){
return (x + (1));
});
cljs.core.unchecked_inc_int = (function cljs$core$unchecked_inc_int(x){
return (x + (1));
});
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply = (function cljs$core$unchecked_multiply(var_args){
var G__15124 = arguments.length;
switch (G__15124) {
case 0:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15131 = arguments.length;
var i__10876__auto___15132 = (0);
while(true){
if((i__10876__auto___15132 < len__10875__auto___15131)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15132]));

var G__15133 = (i__10876__auto___15132 + (1));
i__10876__auto___15132 = G__15133;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15125(){
return (1);
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15126(x){
return x;
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15127(x,y){
return (x * y);
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15128(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply,(x * y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_multiply.cljs$lang$applyTo = (function cljs$core$fn_15129(seq15121){
var G__15122 = cljs.core.first(seq15121);
var seq15121__$1 = cljs.core.next(seq15121);
var G__15123 = cljs.core.first(seq15121__$1);
var seq15121__$2 = cljs.core.next(seq15121__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15122,G__15123,seq15121__$2);
}));

(cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = (2));

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply_int = (function cljs$core$unchecked_multiply_int(var_args){
var G__15138 = arguments.length;
switch (G__15138) {
case 0:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15145 = arguments.length;
var i__10876__auto___15146 = (0);
while(true){
if((i__10876__auto___15146 < len__10875__auto___15145)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15146]));

var G__15147 = (i__10876__auto___15146 + (1));
i__10876__auto___15146 = G__15147;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15139(){
return (1);
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15140(x){
return x;
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15141(x,y){
return (x * y);
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15142(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int,(x * y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_multiply_int.cljs$lang$applyTo = (function cljs$core$fn_15143(seq15135){
var G__15136 = cljs.core.first(seq15135);
var seq15135__$1 = cljs.core.next(seq15135);
var G__15137 = cljs.core.first(seq15135__$1);
var seq15135__$2 = cljs.core.next(seq15135__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15136,G__15137,seq15135__$2);
}));

(cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = (2));

cljs.core.unchecked_negate = (function cljs$core$unchecked_negate(x){
return (- x);
});
cljs.core.unchecked_negate_int = (function cljs$core$unchecked_negate_int(x){
return (- x);
});
cljs.core.unchecked_remainder_int = (function cljs$core$unchecked_remainder_int(x,n){
return cljs.core.mod(x,n);
});
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract = (function cljs$core$unchecked_subtract(var_args){
var G__15152 = arguments.length;
switch (G__15152) {
case 1:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15158 = arguments.length;
var i__10876__auto___15159 = (0);
while(true){
if((i__10876__auto___15159 < len__10875__auto___15158)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15159]));

var G__15160 = (i__10876__auto___15159 + (1));
i__10876__auto___15159 = G__15160;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15153(x){
return (- x);
}));

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15154(x,y){
return (x - y);
}));

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15155(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract,(x - y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_subtract.cljs$lang$applyTo = (function cljs$core$fn_15156(seq15149){
var G__15150 = cljs.core.first(seq15149);
var seq15149__$1 = cljs.core.next(seq15149);
var G__15151 = cljs.core.first(seq15149__$1);
var seq15149__$2 = cljs.core.next(seq15149__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15150,G__15151,seq15149__$2);
}));

(cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = (2));

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract_int = (function cljs$core$unchecked_subtract_int(var_args){
var G__15165 = arguments.length;
switch (G__15165) {
case 1:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15171 = arguments.length;
var i__10876__auto___15172 = (0);
while(true){
if((i__10876__auto___15172 < len__10875__auto___15171)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15172]));

var G__15173 = (i__10876__auto___15172 + (1));
i__10876__auto___15172 = G__15173;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15166(x){
return (- x);
}));

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15167(x,y){
return (x - y);
}));

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15168(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int,(x - y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_subtract_int.cljs$lang$applyTo = (function cljs$core$fn_15169(seq15162){
var G__15163 = cljs.core.first(seq15162);
var seq15162__$1 = cljs.core.next(seq15162);
var G__15164 = cljs.core.first(seq15162__$1);
var seq15162__$2 = cljs.core.next(seq15162__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15163,G__15164,seq15162__$2);
}));

(cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = (2));

cljs.core.fix = (function cljs$core$fix(q){
if((q >= (0))){
return Math.floor(q);
} else {
return Math.ceil(q);
}
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.int$ = (function cljs$core$int(x){
return (x | (0));
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.unchecked_int = (function cljs$core$unchecked_int(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.long$ = (function cljs$core$long(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.unchecked_long = (function cljs$core$unchecked_long(x){
return cljs.core.fix(x);
});
cljs.core.booleans = (function cljs$core$booleans(x){
return x;
});
cljs.core.bytes = (function cljs$core$bytes(x){
return x;
});
cljs.core.chars = (function cljs$core$chars(x){
return x;
});
cljs.core.shorts = (function cljs$core$shorts(x){
return x;
});
cljs.core.ints = (function cljs$core$ints(x){
return x;
});
cljs.core.floats = (function cljs$core$floats(x){
return x;
});
cljs.core.doubles = (function cljs$core$doubles(x){
return x;
});
cljs.core.longs = (function cljs$core$longs(x){
return x;
});
/**
 * Modulus of num and div with original javascript behavior. i.e. bug for negative numbers
 */
cljs.core.js_mod = (function cljs$core$js_mod(n,d){
return (n % d);
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
cljs.core.mod = (function cljs$core$mod(n,d){
return (((n % d) + d) % d);
});
/**
 * quot[ient] of dividing numerator by denominator.
 */
cljs.core.quot = (function cljs$core$quot(n,d){
var rem = (n % d);
return cljs.core.fix(((n - rem) / d));
});
/**
 * remainder of dividing numerator by denominator.
 */
cljs.core.rem = (function cljs$core$rem(n,d){
var q = cljs.core.quot(n,d);
return (n - (d * q));
});
/**
 * Bitwise exclusive or
 */
cljs.core.bit_xor = (function cljs$core$bit_xor(var_args){
var G__15178 = arguments.length;
switch (G__15178) {
case 2:
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15183 = arguments.length;
var i__10876__auto___15184 = (0);
while(true){
if((i__10876__auto___15184 < len__10875__auto___15183)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15184]));

var G__15185 = (i__10876__auto___15184 + (1));
i__10876__auto___15184 = G__15185;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15179(x,y){
return (x ^ y);
}));

(cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15180(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor,(x ^ y),more);
}));

/** @this {Function} */
(cljs.core.bit_xor.cljs$lang$applyTo = (function cljs$core$fn_15181(seq15175){
var G__15176 = cljs.core.first(seq15175);
var seq15175__$1 = cljs.core.next(seq15175);
var G__15177 = cljs.core.first(seq15175__$1);
var seq15175__$2 = cljs.core.next(seq15175__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15176,G__15177,seq15175__$2);
}));

(cljs.core.bit_xor.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise and
 */
cljs.core.bit_and = (function cljs$core$bit_and(var_args){
var G__15190 = arguments.length;
switch (G__15190) {
case 2:
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15195 = arguments.length;
var i__10876__auto___15196 = (0);
while(true){
if((i__10876__auto___15196 < len__10875__auto___15195)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15196]));

var G__15197 = (i__10876__auto___15196 + (1));
i__10876__auto___15196 = G__15197;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15191(x,y){
return (x & y);
}));

(cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15192(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and,(x & y),more);
}));

/** @this {Function} */
(cljs.core.bit_and.cljs$lang$applyTo = (function cljs$core$fn_15193(seq15187){
var G__15188 = cljs.core.first(seq15187);
var seq15187__$1 = cljs.core.next(seq15187);
var G__15189 = cljs.core.first(seq15187__$1);
var seq15187__$2 = cljs.core.next(seq15187__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15188,G__15189,seq15187__$2);
}));

(cljs.core.bit_and.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise or
 */
cljs.core.bit_or = (function cljs$core$bit_or(var_args){
var G__15202 = arguments.length;
switch (G__15202) {
case 2:
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15207 = arguments.length;
var i__10876__auto___15208 = (0);
while(true){
if((i__10876__auto___15208 < len__10875__auto___15207)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15208]));

var G__15209 = (i__10876__auto___15208 + (1));
i__10876__auto___15208 = G__15209;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15203(x,y){
return (x | y);
}));

(cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15204(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or,(x | y),more);
}));

/** @this {Function} */
(cljs.core.bit_or.cljs$lang$applyTo = (function cljs$core$fn_15205(seq15199){
var G__15200 = cljs.core.first(seq15199);
var seq15199__$1 = cljs.core.next(seq15199);
var G__15201 = cljs.core.first(seq15199__$1);
var seq15199__$2 = cljs.core.next(seq15199__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15200,G__15201,seq15199__$2);
}));

(cljs.core.bit_or.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise and with complement
 */
cljs.core.bit_and_not = (function cljs$core$bit_and_not(var_args){
var G__15214 = arguments.length;
switch (G__15214) {
case 2:
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15219 = arguments.length;
var i__10876__auto___15220 = (0);
while(true){
if((i__10876__auto___15220 < len__10875__auto___15219)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15220]));

var G__15221 = (i__10876__auto___15220 + (1));
i__10876__auto___15220 = G__15221;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15215(x,y){
return (x & ~y);
}));

(cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15216(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not,(x & ~y),more);
}));

/** @this {Function} */
(cljs.core.bit_and_not.cljs$lang$applyTo = (function cljs$core$fn_15217(seq15211){
var G__15212 = cljs.core.first(seq15211);
var seq15211__$1 = cljs.core.next(seq15211);
var G__15213 = cljs.core.first(seq15211__$1);
var seq15211__$2 = cljs.core.next(seq15211__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15212,G__15213,seq15211__$2);
}));

(cljs.core.bit_and_not.cljs$lang$maxFixedArity = (2));

/**
 * Clear bit at index n
 */
cljs.core.bit_clear = (function cljs$core$bit_clear(x,n){
return (x & ~(1 << n));
});
/**
 * Flip bit at index n
 */
cljs.core.bit_flip = (function cljs$core$bit_flip(x,n){
return (x ^ (1 << n));
});
/**
 * Bitwise complement
 */
cljs.core.bit_not = (function cljs$core$bit_not(x){
return (~ x);
});
/**
 * Set bit at index n
 */
cljs.core.bit_set = (function cljs$core$bit_set(x,n){
return (x | (1 << n));
});
/**
 * Test bit at index n
 */
cljs.core.bit_test = (function cljs$core$bit_test(x,n){
return ((x & (1 << n)) != 0);
});
/**
 * Bitwise shift left
 */
cljs.core.bit_shift_left = (function cljs$core$bit_shift_left(x,n){
return (x << n);
});
/**
 * Bitwise shift right
 */
cljs.core.bit_shift_right = (function cljs$core$bit_shift_right(x,n){
return (x >> n);
});
/**
 * DEPRECATED: Bitwise shift right with zero fill
 */
cljs.core.bit_shift_right_zero_fill = (function cljs$core$bit_shift_right_zero_fill(x,n){
return (x >>> n);
});
/**
 * Bitwise shift right with zero fill
 */
cljs.core.unsigned_bit_shift_right = (function cljs$core$unsigned_bit_shift_right(x,n){
return (x >>> n);
});
/**
 * Counts the number of bits set in n
 */
cljs.core.bit_count = (function cljs$core$bit_count(v){
var v__$1 = (v - ((v >> (1)) & (1431655765)));
var v__$2 = ((v__$1 & (858993459)) + ((v__$1 >> (2)) & (858993459)));
return ((((v__$2 + (v__$2 >> (4))) & (252645135)) * (16843009)) >> (24));
});
/**
 * Returns non-nil if nums all have the equivalent
 *   value, otherwise false. Behavior on non nums is
 *   undefined.
 */
cljs.core._EQ__EQ_ = (function cljs$core$_EQ__EQ_(var_args){
var G__15226 = arguments.length;
switch (G__15226) {
case 1:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15232 = arguments.length;
var i__10876__auto___15233 = (0);
while(true){
if((i__10876__auto___15233 < len__10875__auto___15232)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15233]));

var G__15234 = (i__10876__auto___15233 + (1));
i__10876__auto___15233 = G__15234;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15227(x){
return true;
}));

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15228(x,y){
return cljs.core._equiv(x,y);
}));

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15229(x,y,more){
while(true){
if((x === y)){
if(cljs.core.next(more)){
var G__15235 = y;
var G__15236 = cljs.core.first(more);
var G__15237 = cljs.core.next(more);
x = G__15235;
y = G__15236;
more = G__15237;
continue;
} else {
return (y === cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._EQ__EQ_.cljs$lang$applyTo = (function cljs$core$fn_15230(seq15223){
var G__15224 = cljs.core.first(seq15223);
var seq15223__$1 = cljs.core.next(seq15223);
var G__15225 = cljs.core.first(seq15223__$1);
var seq15223__$2 = cljs.core.next(seq15223__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15224,G__15225,seq15223__$2);
}));

(cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if num is greater than zero, else false
 */
cljs.core.pos_QMARK_ = (function cljs$core$pos_QMARK_(x){
return (x > (0));
});
/**
 * Returns true if num is zero, else false
 */
cljs.core.zero_QMARK_ = (function cljs$core$zero_QMARK_(x){
return (x === (0));
});
/**
 * Returns true if num is less than zero, else false
 */
cljs.core.neg_QMARK_ = (function cljs$core$neg_QMARK_(x){
return (x < (0));
});
/**
 * Returns the nth next of coll, (seq coll) when n is 0.
 */
cljs.core.nthnext = (function cljs$core$nthnext(coll,n){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition1$ & (262144))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IDrop$))))?true:false):false)){
if((n > (0))){
return coll.cljs$core$IDrop$_drop$arity$2(null,Math.ceil(n));
} else {
return cljs.core.seq(coll);
}
} else {
var n__$1 = n;
var xs = cljs.core.seq(coll);
while(true){
if(((xs) && ((n__$1 > (0))))){
var G__15239 = (n__$1 - (1));
var G__15240 = cljs.core.next(xs);
n__$1 = G__15239;
xs = G__15240;
continue;
} else {
return xs;
}
break;
}
}
});
/**
 * With no args, returns the empty string. With one arg x, returns
 *   x.toString().  (str nil) returns the empty string. With more than
 *   one arg, returns the concatenation of the str values of the args.
 */
cljs.core.str = (function cljs$core$str(var_args){
var G__15244 = arguments.length;
switch (G__15244) {
case 0:
return cljs.core.str.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15250 = arguments.length;
var i__10876__auto___15251 = (0);
while(true){
if((i__10876__auto___15251 < len__10875__auto___15250)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15251]));

var G__15252 = (i__10876__auto___15251 + (1));
i__10876__auto___15251 = G__15252;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((1) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((1)),(0),null)):null);
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10905__auto__);

}
});

(cljs.core.str.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15245(){
return "";
}));

(cljs.core.str.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15246(x){
if((x == null)){
return "";
} else {
return [x].join("");
}
}));

(cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15247(x,ys){
var sb = (new goog.string.StringBuffer(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)));
var more = ys;
while(true){
if(cljs.core.truth_(more)){
var G__15253 = sb.append(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(more)));
var G__15254 = cljs.core.next(more);
sb = G__15253;
more = G__15254;
continue;
} else {
return sb.toString();
}
break;
}
}));

/** @this {Function} */
(cljs.core.str.cljs$lang$applyTo = (function cljs$core$fn_15248(seq15242){
var G__15243 = cljs.core.first(seq15242);
var seq15242__$1 = cljs.core.next(seq15242);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15243,seq15242__$1);
}));

(cljs.core.str.cljs$lang$maxFixedArity = (1));

/**
 * Returns the substring of s beginning at start inclusive, and ending
 *   at end (defaults to length of string), exclusive.
 */
cljs.core.subs = (function cljs$core$subs(var_args){
var G__15256 = arguments.length;
switch (G__15256) {
case 2:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15257(s,start){
return s.substring(start);
}));

(cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15258(s,start,end){
return s.substring(start,end);
}));

(cljs.core.subs.cljs$lang$maxFixedArity = 3);


/**
 * Assumes x is sequential. Returns true if x equals y, otherwise
 *   returns false.
 */
cljs.core.equiv_sequential = (function cljs$core$equiv_sequential(x,y){
return cljs.core.boolean$(((cljs.core.sequential_QMARK_(y))?((((cljs.core.counted_QMARK_(x)) && (((cljs.core.counted_QMARK_(y)) && ((!((cljs.core.count(x) === cljs.core.count(y)))))))))?false:(function (){var xs = cljs.core.seq(x);
var ys = cljs.core.seq(y);
while(true){
if((xs == null)){
return (ys == null);
} else {
if((ys == null)){
return false;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){
var G__15260 = cljs.core.next(xs);
var G__15261 = cljs.core.next(ys);
xs = G__15260;
ys = G__15261;
continue;
} else {
return false;

}
}
}
break;
}
})()):null));
});
cljs.core.hash_coll = (function cljs$core$hash_coll(coll){
if(cljs.core.seq(coll)){
var res = cljs.core.hash(cljs.core.first(coll));
var s = cljs.core.next(coll);
while(true){
if((s == null)){
return res;
} else {
var G__15262 = cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));
var G__15263 = cljs.core.next(s);
res = G__15262;
s = G__15263;
continue;
}
break;
}
} else {
return (0);
}
});

cljs.core.hash_imap = (function cljs$core$hash_imap(m){
var h = (0);
var s = cljs.core.seq(m);
while(true){
if(s){
var e = cljs.core.first(s);
var G__15264 = ((h + (cljs.core.hash(cljs.core.key(e)) ^ cljs.core.hash(cljs.core.val(e)))) % (4503599627370496));
var G__15265 = cljs.core.next(s);
h = G__15264;
s = G__15265;
continue;
} else {
return h;
}
break;
}
});
cljs.core.hash_iset = (function cljs$core$hash_iset(s){
var h = (0);
var s__$1 = cljs.core.seq(s);
while(true){
if(s__$1){
var e = cljs.core.first(s__$1);
var G__15266 = ((h + cljs.core.hash(e)) % (4503599627370496));
var G__15267 = cljs.core.next(s__$1);
h = G__15266;
s__$1 = G__15267;
continue;
} else {
return h;
}
break;
}
});


/**
 * Takes a JavaScript object and a map of names to functions and
 *   attaches said functions as methods on the object.  Any references to
 *   JavaScript's implicit this (via the this-as macro) will resolve to the
 *   object that the function is attached.
 */
cljs.core.extend_object_BANG_ = (function cljs$core$extend_object_BANG_(obj,fn_map){
var seq__15268_15284 = cljs.core.seq(fn_map);
var chunk__15269_15285 = null;
var count__15270_15286 = (0);
var i__15271_15287 = (0);
while(true){
if((i__15271_15287 < count__15270_15286)){
var vec__15278_15288 = chunk__15269_15285.cljs$core$IIndexed$_nth$arity$2(null,i__15271_15287);
var key_name_15289 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15278_15288,(0),null);
var f_15290 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15278_15288,(1),null);
var str_name_15291 = cljs.core.name(key_name_15289);
cljs.core.goog$module$goog$object.set.call(null,obj,str_name_15291,f_15290);


var G__15292 = seq__15268_15284;
var G__15293 = chunk__15269_15285;
var G__15294 = count__15270_15286;
var G__15295 = (i__15271_15287 + (1));
seq__15268_15284 = G__15292;
chunk__15269_15285 = G__15293;
count__15270_15286 = G__15294;
i__15271_15287 = G__15295;
continue;
} else {
var temp__5720__auto___15296 = cljs.core.seq(seq__15268_15284);
if(temp__5720__auto___15296){
var seq__15268_15297__$1 = temp__5720__auto___15296;
if(cljs.core.chunked_seq_QMARK_(seq__15268_15297__$1)){
var c__10518__auto___15298 = cljs.core.chunk_first(seq__15268_15297__$1);
var G__15299 = cljs.core.chunk_rest(seq__15268_15297__$1);
var G__15300 = c__10518__auto___15298;
var G__15301 = cljs.core.count(c__10518__auto___15298);
var G__15302 = (0);
seq__15268_15284 = G__15299;
chunk__15269_15285 = G__15300;
count__15270_15286 = G__15301;
i__15271_15287 = G__15302;
continue;
} else {
var vec__15281_15303 = cljs.core.first(seq__15268_15297__$1);
var key_name_15304 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15281_15303,(0),null);
var f_15305 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15281_15303,(1),null);
var str_name_15306 = cljs.core.name(key_name_15304);
cljs.core.goog$module$goog$object.set.call(null,obj,str_name_15306,f_15305);


var G__15307 = cljs.core.next(seq__15268_15297__$1);
var G__15308 = null;
var G__15309 = (0);
var G__15310 = (0);
seq__15268_15284 = G__15307;
chunk__15269_15285 = G__15308;
count__15270_15286 = G__15309;
i__15271_15287 = G__15310;
continue;
}
} else {
}
}
break;
}

return obj;
});

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.List = (function (meta,first,rest,count,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.count = count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65937646;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.List.prototype.toString = (function cljs$core$fn_15311(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.List.prototype.equiv = (function cljs$core$fn_15312(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.List.prototype.indexOf = (function() {
var cljs$core$fn_15313 = null;
var cljs$core$fn_15313__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_15313__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15313 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15313__1.call(this,x);
case 2:
return cljs$core$fn_15313__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15313.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15313__1;
cljs$core$fn_15313.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15313__2;
return cljs$core$fn_15313;
})()
);

(cljs.core.List.prototype.lastIndexOf = (function() {
var cljs$core$fn_15314 = null;
var cljs$core$fn_15314__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,self__.count);
});
var cljs$core$fn_15314__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15314 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15314__1.call(this,x);
case 2:
return cljs$core$fn_15314__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15314.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15314__1;
cljs$core$fn_15314.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15314__2;
return cljs$core$fn_15314;
})()
);

(cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15315(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_15316(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));
}));

(cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_15317(coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return null;
} else {
return self__.rest;
}
}));

(cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_15318(coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
}));

(cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_15319(coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_15320(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
}));

(cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15321(coll){
var self__ = this;
var coll__$1 = this;
var h__10007__auto__ = self__.__hash;
if((!((h__10007__auto__ == null)))){
return h__10007__auto__;
} else {
var h__10007__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10007__auto____$1);

return h__10007__auto____$1;
}
}));

(cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15322(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_15323(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_15324(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_15325(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_15326(coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_15327(coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
}));

(cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_15328(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_15329(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.List(new_meta,self__.first,self__.rest,self__.count,self__.__hash));
}
}));

(cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_15330(coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));
}));

(cljs.core.List.getBasis = (function cljs$core$fn_15331(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"count","count",-514511684,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.List.cljs$lang$type = true);

(cljs.core.List.cljs$lang$ctorStr = "cljs.core/List");

(cljs.core.List.cljs$lang$ctorPrWriter = (function cljs$core$fn_15332(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/List");
}));

/**
 * Positional factory function for cljs.core/List.
 */
cljs.core.__GT_List = (function cljs$core$__GT_List(meta,first,rest,count,__hash){
return (new cljs.core.List(meta,first,rest,count,__hash));
});

/**
 * Returns true if x implements IList
 */
cljs.core.list_QMARK_ = (function cljs$core$list_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (33554432))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IList$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
}
});
(cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15334(){
var this__10736__auto__ = this;
return cljs.core.es6_iterator(this__10736__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.EmptyList = (function (meta){
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 65937614;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.EmptyList.prototype.toString = (function cljs$core$fn_15335(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.EmptyList.prototype.equiv = (function cljs$core$fn_15336(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.EmptyList.prototype.indexOf = (function() {
var cljs$core$fn_15337 = null;
var cljs$core$fn_15337__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_15337__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15337 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15337__1.call(this,x);
case 2:
return cljs$core$fn_15337__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15337.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15337__1;
cljs$core$fn_15337.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15337__2;
return cljs$core$fn_15337;
})()
);

(cljs.core.EmptyList.prototype.lastIndexOf = (function() {
var cljs$core$fn_15338 = null;
var cljs$core$fn_15338__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_15338__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15338 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15338__1.call(this,x);
case 2:
return cljs$core$fn_15338__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15338.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15338__1;
cljs$core$fn_15338.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15338__2;
return cljs$core$fn_15338;
})()
);

(cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15339(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_15340(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.EmptyList(self__.meta));
}));

(cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_15341(coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_15342(coll){
var self__ = this;
var coll__$1 = this;
return (0);
}));

(cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_15343(coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_15344(coll){
var self__ = this;
var coll__$1 = this;
throw (new Error("Can't pop empty list"));
}));

(cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15345(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.empty_ordered_hash;
}));

(cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15346(coll,other){
var self__ = this;
var coll__$1 = this;
if(((cljs.core.list_QMARK_(other)) || (cljs.core.sequential_QMARK_(other)))){
return (cljs.core.seq(other) == null);
} else {
return false;
}
}));

(cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_15347(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_15348(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_15349(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_15350(coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_15351(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_15352(coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_15353(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.EmptyList(new_meta));
}
}));

(cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_15354(coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,null,(1),null));
}));

(cljs.core.EmptyList.getBasis = (function cljs$core$fn_15355(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.EmptyList.cljs$lang$type = true);

(cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList");

(cljs.core.EmptyList.cljs$lang$ctorPrWriter = (function cljs$core$fn_15356(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/EmptyList");
}));

/**
 * Positional factory function for cljs.core/EmptyList.
 */
cljs.core.__GT_EmptyList = (function cljs$core$__GT_EmptyList(meta){
return (new cljs.core.EmptyList(meta));
});

(cljs.core.List.EMPTY = (new cljs.core.EmptyList(null)));
(cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15357(){
var this__10736__auto__ = this;
return cljs.core.es6_iterator(this__10736__auto__);
}));
/**
 * Returns true if coll satisfies? IReversible.
 */
cljs.core.reversible_QMARK_ = (function cljs$core$reversible_QMARK_(coll){
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (134217728))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReversible$)))){
return true;
} else {
if((!coll.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
}
});
/**
 * Returns, in constant time, a seq of the items in rev (which
 *   can be a vector or sorted-map), in reverse order. If rev is empty returns nil
 */
cljs.core.rseq = (function cljs$core$rseq(rev){
return cljs.core._rseq(rev);
});
/**
 * Returns a seq of the items in coll in reverse order. Not lazy.
 */
cljs.core.reverse = (function cljs$core$reverse(coll){
if(cljs.core.reversible_QMARK_(coll)){
var or__9546__auto__ = cljs.core.rseq(coll);
if(or__9546__auto__){
return or__9546__auto__;
} else {
return cljs.core.List.EMPTY;
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll);
}
});
/**
 * Creates a new list containing the items.
 */
cljs.core.list = (function cljs$core$list(var_args){
var args__10885__auto__ = [];
var len__10875__auto___15362 = arguments.length;
var i__10876__auto___15363 = (0);
while(true){
if((i__10876__auto___15363 < len__10875__auto___15362)){
args__10885__auto__.push((arguments[i__10876__auto___15363]));

var G__15364 = (i__10876__auto___15363 + (1));
i__10876__auto___15363 = G__15364;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((0) < args__10885__auto__.length))?(new cljs.core.IndexedSeq(args__10885__auto__.slice((0)),(0),null)):null);
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__10886__auto__);
});

(cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15360(xs){
var arr = (((((xs instanceof cljs.core.IndexedSeq)) && ((xs.i === (0)))))?xs.arr:(function (){var arr = [];
var xs__$1 = xs;
while(true){
if((!((xs__$1 == null)))){
arr.push(cljs.core._first(xs__$1));

var G__15365 = cljs.core._next(xs__$1);
xs__$1 = G__15365;
continue;
} else {
return arr;
}
break;
}
})());
var i = arr.length;
var r = cljs.core.List.EMPTY;
while(true){
if((i > (0))){
var G__15366 = (i - (1));
var G__15367 = cljs.core._conj(r,(arr[(i - (1))]));
i = G__15366;
r = G__15367;
continue;
} else {
return r;
}
break;
}
}));

(cljs.core.list.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.list.cljs$lang$applyTo = (function cljs$core$fn_15361(seq15359){
var self__10861__auto__ = this;
return self__10861__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq15359));
}));


/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Cons = (function (meta,first,rest,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65929452;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.Cons.prototype.toString = (function cljs$core$fn_15368(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Cons.prototype.equiv = (function cljs$core$fn_15369(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Cons.prototype.indexOf = (function() {
var cljs$core$fn_15370 = null;
var cljs$core$fn_15370__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_15370__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15370 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15370__1.call(this,x);
case 2:
return cljs$core$fn_15370__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15370.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15370__1;
cljs$core$fn_15370.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15370__2;
return cljs$core$fn_15370;
})()
);

(cljs.core.Cons.prototype.lastIndexOf = (function() {
var cljs$core$fn_15371 = null;
var cljs$core$fn_15371__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_15371__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15371 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15371__1.call(this,x);
case 2:
return cljs$core$fn_15371__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15371.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15371__1;
cljs$core$fn_15371.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15371__2;
return cljs$core$fn_15371;
})()
);

(cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15372(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_15373(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));
}));

(cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_15374(coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return null;
} else {
return cljs.core.seq(self__.rest);
}
}));

(cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15375(coll){
var self__ = this;
var coll__$1 = this;
var h__10007__auto__ = self__.__hash;
if((!((h__10007__auto__ == null)))){
return h__10007__auto__;
} else {
var h__10007__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10007__auto____$1);

return h__10007__auto____$1;
}
}));

(cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15376(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_15377(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_15378(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_15379(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_15380(coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_15381(coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
}));

(cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_15382(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_15383(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Cons(new_meta,self__.first,self__.rest,self__.__hash));
}
}));

(cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_15384(coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(null,o,coll__$1,null));
}));

(cljs.core.Cons.getBasis = (function cljs$core$fn_15385(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rest","rest",398835108,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Cons.cljs$lang$type = true);

(cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons");

(cljs.core.Cons.cljs$lang$ctorPrWriter = (function cljs$core$fn_15386(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/Cons");
}));

/**
 * Positional factory function for cljs.core/Cons.
 */
cljs.core.__GT_Cons = (function cljs$core$__GT_Cons(meta,first,rest,__hash){
return (new cljs.core.Cons(meta,first,rest,__hash));
});

(cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15387(){
var this__10736__auto__ = this;
return cljs.core.es6_iterator(this__10736__auto__);
}));
/**
 * Returns a new seq where x is the first element and coll is the rest.
 */
cljs.core.cons = (function cljs$core$cons(x,coll){
if((coll == null)){
return (new cljs.core.List(null,x,null,(1),null));
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return (new cljs.core.Cons(null,x,coll,null));
} else {
return (new cljs.core.Cons(null,x,cljs.core.seq(coll),null));

}
}
});
cljs.core.hash_keyword = (function cljs$core$hash_keyword(k){
return ((cljs.core.hash_symbol(k) + (2654435769)) | (0));
});
cljs.core.compare_keywords = (function cljs$core$compare_keywords(a,b){
if((a.fqn === b.fqn)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__9540__auto__ = cljs.core.not(a.ns);
if(and__9540__auto__){
return b.ns;
} else {
return and__9540__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__15389 = a.ns;
var G__15390 = b.ns;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__15389,G__15390);
})();
if(((0) === nsc)){
var G__15391 = a.name;
var G__15392 = b.name;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__15391,G__15392);
} else {
return nsc;
}
}
} else {
var G__15393 = a.name;
var G__15394 = b.name;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__15393,G__15394);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IPrintWithWriter}
*/
cljs.core.Keyword = (function (ns,name,fqn,_hash){
this.ns = ns;
this.name = name;
this.fqn = fqn;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 2153775105;
this.cljs$lang$protocol_mask$partition1$ = 4096;
});
(cljs.core.Keyword.prototype.toString = (function cljs$core$fn_15396(){
var self__ = this;
var _ = this;
return [":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join('');
}));

(cljs.core.Keyword.prototype.equiv = (function cljs$core$fn_15397(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15398(_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Keyword)){
return (self__.fqn === other.fqn);
} else {
return false;
}
}));

(cljs.core.Keyword.prototype.call = (function() {
var cljs$core$fn_15399 = null;
var cljs$core$fn_15399__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});
var cljs$core$fn_15399__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});
cljs$core$fn_15399 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_15399__2.call(this,self__,coll);
case 3:
return cljs$core$fn_15399__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_15399.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15399__2;
cljs$core$fn_15399.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15399__3;
return cljs$core$fn_15399;
})()
);

(cljs.core.Keyword.prototype.apply = (function cljs$core$fn_15400(self__,args15395){
var self__ = this;
var self____$1 = this;
var args__10149__auto__ = cljs.core.aclone(args15395);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10149__auto__.length > (20)))?(function (){var G__15401 = args__10149__auto__.slice((0),(20));
G__15401.push(args__10149__auto__.slice((20)));

return G__15401;
})():args__10149__auto__)));
}));

(cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15402(coll){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
}));

(cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15403(coll,not_found){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
}));

(cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15404(this$){
var self__ = this;
var this$__$1 = this;
var h__10007__auto__ = self__._hash;
if((!((h__10007__auto__ == null)))){
return h__10007__auto__;
} else {
var h__10007__auto____$1 = cljs.core.hash_keyword(this$__$1);
(self__._hash = h__10007__auto____$1);

return h__10007__auto____$1;
}
}));

(cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = (function cljs$core$fn_15405(_){
var self__ = this;
var ___$1 = this;
return self__.name;
}));

(cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = (function cljs$core$fn_15406(_){
var self__ = this;
var ___$1 = this;
return self__.ns;
}));

(cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function cljs$core$fn_15407(o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join(''));
}));

(cljs.core.Keyword.getBasis = (function cljs$core$fn_15408(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns","ns",2082130287,null),new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"fqn","fqn",-1749334463,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Keyword.cljs$lang$type = true);

(cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword");

(cljs.core.Keyword.cljs$lang$ctorPrWriter = (function cljs$core$fn_15409(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/Keyword");
}));

/**
 * Positional factory function for cljs.core/Keyword.
 */
cljs.core.__GT_Keyword = (function cljs$core$__GT_Keyword(ns,name,fqn,_hash){
return (new cljs.core.Keyword(ns,name,fqn,_hash));
});

/**
 * Return true if x is a Keyword
 */
cljs.core.keyword_QMARK_ = (function cljs$core$keyword_QMARK_(x){
return (x instanceof cljs.core.Keyword);
});
/**
 * Efficient test to determine that two keywords are identical.
 */
cljs.core.keyword_identical_QMARK_ = (function cljs$core$keyword_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if((((x instanceof cljs.core.Keyword)) && ((y instanceof cljs.core.Keyword)))){
return (x.fqn === y.fqn);
} else {
return false;
}
}
});
/**
 * Efficient test to determine that two symbols are identical.
 */
cljs.core.symbol_identical_QMARK_ = (function cljs$core$symbol_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if((((x instanceof cljs.core.Symbol)) && ((y instanceof cljs.core.Symbol)))){
return (x.str === y.str);
} else {
return false;
}
}
});
/**
 * Returns the namespace String of a symbol or keyword, or nil if not present.
 */
cljs.core.namespace = (function cljs$core$namespace(x){
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition1$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$INamed$))))?true:false):false)){
return x.cljs$core$INamed$_namespace$arity$1(null);
} else {
throw (new Error(["Doesn't support namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('')));
}
});
/**
 * Return true if x is a symbol or keyword
 */
cljs.core.ident_QMARK_ = (function cljs$core$ident_QMARK_(x){
return (((x instanceof cljs.core.Keyword)) || ((x instanceof cljs.core.Symbol)));
});
/**
 * Return true if x is a symbol or keyword without a namespace
 */
cljs.core.simple_ident_QMARK_ = (function cljs$core$simple_ident_QMARK_(x){
return ((cljs.core.ident_QMARK_(x)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a symbol or keyword with a namespace
 */
cljs.core.qualified_ident_QMARK_ = (function cljs$core$qualified_ident_QMARK_(x){
return cljs.core.boolean$((function (){var and__9540__auto__ = cljs.core.ident_QMARK_(x);
if(and__9540__auto__){
var and__9540__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__9540__auto____$1)){
return true;
} else {
return and__9540__auto____$1;
}
} else {
return and__9540__auto__;
}
})());
});
/**
 * Return true if x is a symbol without a namespace
 */
cljs.core.simple_symbol_QMARK_ = (function cljs$core$simple_symbol_QMARK_(x){
return (((x instanceof cljs.core.Symbol)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a symbol with a namespace
 */
cljs.core.qualified_symbol_QMARK_ = (function cljs$core$qualified_symbol_QMARK_(x){
return cljs.core.boolean$((function (){var and__9540__auto__ = (x instanceof cljs.core.Symbol);
if(and__9540__auto__){
var and__9540__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__9540__auto____$1)){
return true;
} else {
return and__9540__auto____$1;
}
} else {
return and__9540__auto__;
}
})());
});
/**
 * Return true if x is a keyword without a namespace
 */
cljs.core.simple_keyword_QMARK_ = (function cljs$core$simple_keyword_QMARK_(x){
return (((x instanceof cljs.core.Keyword)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a keyword with a namespace
 */
cljs.core.qualified_keyword_QMARK_ = (function cljs$core$qualified_keyword_QMARK_(x){
return cljs.core.boolean$((function (){var and__9540__auto__ = (x instanceof cljs.core.Keyword);
if(and__9540__auto__){
var and__9540__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__9540__auto____$1)){
return true;
} else {
return and__9540__auto____$1;
}
} else {
return and__9540__auto__;
}
})());
});
/**
 * Returns a Keyword with the given namespace and name.  Do not use :
 *   in the keyword strings, it will be added automatically.
 */
cljs.core.keyword = (function cljs$core$keyword(var_args){
var G__15412 = arguments.length;
switch (G__15412) {
case 1:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15413(name){
if((name instanceof cljs.core.Keyword)){
return name;
} else {
if((name instanceof cljs.core.Symbol)){
return (new cljs.core.Keyword(cljs.core.namespace(name),cljs.core.name(name),name.str,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("/",name)){
return (new cljs.core.Keyword(null,name,name,null));
} else {
if(typeof name === 'string'){
var parts = name.split("/");
if((parts.length === (2))){
return (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));
} else {
return (new cljs.core.Keyword(null,(parts[(0)]),name,null));
}
} else {
return null;
}
}
}
}
}));

(cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15414(ns,name){
var ns__$1 = (((ns instanceof cljs.core.Keyword))?cljs.core.name(ns):(((ns instanceof cljs.core.Symbol))?cljs.core.name(ns):ns
));
var name__$1 = (((name instanceof cljs.core.Keyword))?cljs.core.name(name):(((name instanceof cljs.core.Symbol))?cljs.core.name(name):name
));
return (new cljs.core.Keyword(ns__$1,name__$1,[(cljs.core.truth_(ns__$1)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns__$1),"/"].join(''):null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(name__$1)].join(''),null));
}));

(cljs.core.keyword.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.LazySeq = (function (meta,fn,s,__hash){
this.meta = meta;
this.fn = fn;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.LazySeq.prototype.toString = (function cljs$core$fn_15416(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.LazySeq.prototype.equiv = (function cljs$core$fn_15417(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.LazySeq.prototype.sval = (function cljs$core$fn_15418(){
var self__ = this;
var coll = this;
if((self__.fn == null)){
return self__.s;
} else {
(self__.s = (self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null)));

(self__.fn = null);

return self__.s;
}
}));

(cljs.core.LazySeq.prototype.indexOf = (function() {
var cljs$core$fn_15419 = null;
var cljs$core$fn_15419__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_15419__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15419 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15419__1.call(this,x);
case 2:
return cljs$core$fn_15419__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15419.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15419__1;
cljs$core$fn_15419.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15419__2;
return cljs$core$fn_15419;
})()
);

(cljs.core.LazySeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_15420 = null;
var cljs$core$fn_15420__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_15420__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15420 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15420__1.call(this,x);
case 2:
return cljs$core$fn_15420__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15420.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15420__1;
cljs$core$fn_15420.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15420__2;
return cljs$core$fn_15420;
})()
);

(cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15421(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_15422(coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((self__.s == null)){
return null;
} else {
return cljs.core.next(self__.s);
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15423(coll){
var self__ = this;
var coll__$1 = this;
var h__10007__auto__ = self__.__hash;
if((!((h__10007__auto__ == null)))){
return h__10007__auto__;
} else {
var h__10007__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10007__auto____$1);

return h__10007__auto____$1;
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15424(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_15425(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.LazySeq.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function cljs$core$fn_15426(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.not(self__.fn);
}));

(cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_15427(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_15428(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_15429(coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((self__.s == null)){
return null;
} else {
return cljs.core.first(self__.s);
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_15430(coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((!((self__.s == null)))){
return cljs.core.rest(self__.s);
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_15431(coll){
var self__ = this;
var coll__$1 = this;
coll__$1.sval();

if((self__.s == null)){
return null;
} else {
var ls = self__.s;
while(true){
if((ls instanceof cljs.core.LazySeq)){
var G__15437 = ls.sval();
ls = G__15437;
continue;
} else {
(self__.s = ls);

return cljs.core.seq(self__.s);
}
break;
}
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_15432(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.LazySeq(new_meta,(function cljs$core$fn_15432_$_fn_15433(){
return coll__$1.cljs$core$ISeqable$_seq$arity$1(null);
}),null,self__.__hash));
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_15434(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.LazySeq.getBasis = (function cljs$core$fn_15435(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"fn","fn",465265323,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.LazySeq.cljs$lang$type = true);

(cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq");

(cljs.core.LazySeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_15436(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/LazySeq");
}));

/**
 * Positional factory function for cljs.core/LazySeq.
 */
cljs.core.__GT_LazySeq = (function cljs$core$__GT_LazySeq(meta,fn,s,__hash){
return (new cljs.core.LazySeq(meta,fn,s,__hash));
});

(cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15438(){
var this__10736__auto__ = this;
return cljs.core.es6_iterator(this__10736__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ICounted}
*/
cljs.core.ChunkBuffer = (function (buf,end){
this.buf = buf;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 2;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ChunkBuffer.prototype.add = (function cljs$core$fn_15439(o){
var self__ = this;
var _ = this;
(self__.buf[self__.end] = o);

return (self__.end = (self__.end + (1)));
}));

(cljs.core.ChunkBuffer.prototype.chunk = (function cljs$core$fn_15440(){
var self__ = this;
var _ = this;
var ret = (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));
(self__.buf = null);

return ret;
}));

(cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_15441(_){
var self__ = this;
var ___$1 = this;
return self__.end;
}));

(cljs.core.ChunkBuffer.getBasis = (function cljs$core$fn_15442(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"buf","buf",1426618187,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ChunkBuffer.cljs$lang$type = true);

(cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer");

(cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = (function cljs$core$fn_15443(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/ChunkBuffer");
}));

/**
 * Positional factory function for cljs.core/ChunkBuffer.
 */
cljs.core.__GT_ChunkBuffer = (function cljs$core$__GT_ChunkBuffer(buf,end){
return (new cljs.core.ChunkBuffer(buf,end));
});

cljs.core.chunk_buffer = (function cljs$core$chunk_buffer(capacity){
return (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.IChunk}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayChunk = (function (arr,off,end){
this.arr = arr;
this.off = off;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 524306;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_15444(_){
var self__ = this;
var ___$1 = this;
return (self__.end - self__.off);
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_15445(coll,i){
var self__ = this;
var coll__$1 = this;
return (self__.arr[(self__.off + i)]);
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_15446(coll,i,not_found){
var self__ = this;
var coll__$1 = this;
if((((i >= (0))) && ((i < (self__.end - self__.off))))){
return (self__.arr[(self__.off + i)]);
} else {
return not_found;
}
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function cljs$core$fn_15447(coll){
var self__ = this;
var coll__$1 = this;
if((self__.off === self__.end)){
throw (new Error("-drop-first of empty chunk"));
} else {
return (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));
}
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_15448(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_15449(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off);
}));

(cljs.core.ArrayChunk.getBasis = (function cljs$core$fn_15450(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null);
}));

(cljs.core.ArrayChunk.cljs$lang$type = true);

(cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk");

(cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = (function cljs$core$fn_15451(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/ArrayChunk");
}));

/**
 * Positional factory function for cljs.core/ArrayChunk.
 */
cljs.core.__GT_ArrayChunk = (function cljs$core$__GT_ArrayChunk(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk = (function cljs$core$array_chunk(var_args){
var G__15453 = arguments.length;
switch (G__15453) {
case 1:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15454(arr){
return (new cljs.core.ArrayChunk(arr,(0),arr.length));
}));

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15455(arr,off){
return (new cljs.core.ArrayChunk(arr,off,arr.length));
}));

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15456(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
}));

(cljs.core.array_chunk.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.ChunkedCons = (function (chunk,more,meta,__hash){
this.chunk = chunk;
this.more = more;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850732;
this.cljs$lang$protocol_mask$partition1$ = 1536;
});
(cljs.core.ChunkedCons.prototype.toString = (function cljs$core$fn_15458(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ChunkedCons.prototype.equiv = (function cljs$core$fn_15459(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ChunkedCons.prototype.indexOf = (function() {
var cljs$core$fn_15460 = null;
var cljs$core$fn_15460__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_15460__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15460 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15460__1.call(this,x);
case 2:
return cljs$core$fn_15460__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15460.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15460__1;
cljs$core$fn_15460.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15460__2;
return cljs$core$fn_15460;
})()
);

(cljs.core.ChunkedCons.prototype.lastIndexOf = (function() {
var cljs$core$fn_15461 = null;
var cljs$core$fn_15461__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_15461__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15461 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15461__1.call(this,x);
case 2:
return cljs$core$fn_15461__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15461.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15461__1;
cljs$core$fn_15461.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15461__2;
return cljs$core$fn_15461;
})()
);

(cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15462(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_15463(coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,null,null));
} else {
if((self__.more == null)){
return null;
} else {
return cljs.core._seq(self__.more);
}
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15464(coll){
var self__ = this;
var coll__$1 = this;
var h__10007__auto__ = self__.__hash;
if((!((h__10007__auto__ == null)))){
return h__10007__auto__;
} else {
var h__10007__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10007__auto____$1);

return h__10007__auto____$1;
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15465(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_15466(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_15467(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk,(0));
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_15468(coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,null,null));
} else {
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_15469(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function cljs$core$fn_15470(coll){
var self__ = this;
var coll__$1 = this;
return self__.chunk;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function cljs$core$fn_15471(coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_15472(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ChunkedCons(self__.chunk,self__.more,new_meta,self__.__hash));
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_15473(this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,this$__$1);
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function cljs$core$fn_15474(coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return null;
} else {
return self__.more;
}
}));

(cljs.core.ChunkedCons.getBasis = (function cljs$core$fn_15475(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"chunk","chunk",449371907,null),new cljs.core.Symbol(null,"more","more",-418290273,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ChunkedCons.cljs$lang$type = true);

(cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons");

(cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = (function cljs$core$fn_15476(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/ChunkedCons");
}));

/**
 * Positional factory function for cljs.core/ChunkedCons.
 */
cljs.core.__GT_ChunkedCons = (function cljs$core$__GT_ChunkedCons(chunk,more,meta,__hash){
return (new cljs.core.ChunkedCons(chunk,more,meta,__hash));
});

(cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15477(){
var this__10736__auto__ = this;
return cljs.core.es6_iterator(this__10736__auto__);
}));
cljs.core.chunk_cons = (function cljs$core$chunk_cons(chunk,rest){
if((cljs.core._count(chunk) === (0))){
return rest;
} else {
return (new cljs.core.ChunkedCons(chunk,rest,null,null));
}
});
cljs.core.chunk_append = (function cljs$core$chunk_append(b,x){
return b.add(x);
});
cljs.core.chunk = (function cljs$core$chunk(b){
return b.chunk();
});
cljs.core.chunk_first = (function cljs$core$chunk_first(s){
return cljs.core._chunked_first(s);
});
cljs.core.chunk_rest = (function cljs$core$chunk_rest(s){
return cljs.core._chunked_rest(s);
});
cljs.core.chunk_next = (function cljs$core$chunk_next(s){
if((((!((s == null))))?(((((s.cljs$lang$protocol_mask$partition1$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$IChunkedNext$))))?true:false):false)){
return s.cljs$core$IChunkedNext$_chunked_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core._chunked_rest(s));
}
});
/**
 * Returns an array containing the contents of coll.
 */
cljs.core.to_array = (function cljs$core$to_array(coll){
var ary = [];
var s = cljs.core.seq(coll);
while(true){
if((!((s == null)))){
ary.push(cljs.core.first(s));

var G__15479 = cljs.core.next(s);
s = G__15479;
continue;
} else {
return ary;
}
break;
}
});
/**
 * Returns a (potentially-ragged) 2-dimensional array
 *   containing the contents of coll.
 */
cljs.core.to_array_2d = (function cljs$core$to_array_2d(coll){
var ret = (new Array(cljs.core.count(coll)));
var i_15480 = (0);
var xs_15481 = cljs.core.seq(coll);
while(true){
if((xs_15481 == null)){
} else {
(ret[i_15480] = cljs.core.to_array(cljs.core.first(xs_15481)));

var G__15482 = (i_15480 + (1));
var G__15483 = cljs.core.next(xs_15481);
i_15480 = G__15482;
xs_15481 = G__15483;
continue;
}
break;
}

return ret;
});
/**
 * Creates an array of ints. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.int_array = (function cljs$core$int_array(var_args){
var G__15485 = arguments.length;
switch (G__15485) {
case 1:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15486(size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15487(size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__15489 = (i + (1));
var G__15490 = cljs.core.next(s__$1);
i = G__15489;
s__$1 = G__15490;
continue;
} else {
return a;
}
break;
}
} else {
var n__10634__auto___15491 = size;
var i_15492 = (0);
while(true){
if((i_15492 < n__10634__auto___15491)){
(a[i_15492] = init_val_or_seq);

var G__15493 = (i_15492 + (1));
i_15492 = G__15493;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.int_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of longs. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.long_array = (function cljs$core$long_array(var_args){
var G__15495 = arguments.length;
switch (G__15495) {
case 1:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15496(size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15497(size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__15499 = (i + (1));
var G__15500 = cljs.core.next(s__$1);
i = G__15499;
s__$1 = G__15500;
continue;
} else {
return a;
}
break;
}
} else {
var n__10634__auto___15501 = size;
var i_15502 = (0);
while(true){
if((i_15502 < n__10634__auto___15501)){
(a[i_15502] = init_val_or_seq);

var G__15503 = (i_15502 + (1));
i_15502 = G__15503;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.long_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of doubles. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.double_array = (function cljs$core$double_array(var_args){
var G__15505 = arguments.length;
switch (G__15505) {
case 1:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15506(size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15507(size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__15509 = (i + (1));
var G__15510 = cljs.core.next(s__$1);
i = G__15509;
s__$1 = G__15510;
continue;
} else {
return a;
}
break;
}
} else {
var n__10634__auto___15511 = size;
var i_15512 = (0);
while(true){
if((i_15512 < n__10634__auto___15511)){
(a[i_15512] = init_val_or_seq);

var G__15513 = (i_15512 + (1));
i_15512 = G__15513;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.double_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of objects. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.object_array = (function cljs$core$object_array(var_args){
var G__15515 = arguments.length;
switch (G__15515) {
case 1:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15516(size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15517(size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__15519 = (i + (1));
var G__15520 = cljs.core.next(s__$1);
i = G__15519;
s__$1 = G__15520;
continue;
} else {
return a;
}
break;
}
} else {
var n__10634__auto___15521 = size;
var i_15522 = (0);
while(true){
if((i_15522 < n__10634__auto___15521)){
(a[i_15522] = init_val_or_seq);

var G__15523 = (i_15522 + (1));
i_15522 = G__15523;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.object_array.cljs$lang$maxFixedArity = 2);

/**
 * If coll is counted? returns its count, else will count at most the first n
 * elements of coll using its seq
 */
cljs.core.bounded_count = (function cljs$core$bounded_count(n,coll){
if(cljs.core.counted_QMARK_(coll)){
return cljs.core.count(coll);
} else {
var i = (0);
var s = cljs.core.seq(coll);
while(true){
if((((!((s == null)))) && ((i < n)))){
var G__15524 = (i + (1));
var G__15525 = cljs.core.next(s);
i = G__15524;
s = G__15525;
continue;
} else {
return i;
}
break;
}
}
});
cljs.core.spread = (function cljs$core$spread(arglist){
if((arglist == null)){
return null;
} else {
var n = cljs.core.next(arglist);
if((n == null)){
return cljs.core.seq(cljs.core.first(arglist));
} else {
return cljs.core.cons(cljs.core.first(arglist),(cljs.core.spread.cljs$core$IFn$_invoke$arity$1 ? cljs.core.spread.cljs$core$IFn$_invoke$arity$1(n) : cljs.core.spread.call(null,n)));
}
}
});
/**
 * Returns a lazy seq representing the concatenation of the elements in the supplied colls.
 */
cljs.core.concat = (function cljs$core$concat(var_args){
var G__15530 = arguments.length;
switch (G__15530) {
case 0:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15541 = arguments.length;
var i__10876__auto___15542 = (0);
while(true){
if((i__10876__auto___15542 < len__10875__auto___15541)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15542]));

var G__15543 = (i__10876__auto___15542 + (1));
i__10876__auto___15542 = G__15543;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15531(){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15531_$_fn_15532(){
return null;
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15533(x){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15533_$_fn_15534(){
return x;
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15535(x,y){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15535_$_fn_15536(){
var s = cljs.core.seq(x);
if(s){
if(cljs.core.chunked_seq_QMARK_(s)){
return cljs.core.chunk_cons(cljs.core.chunk_first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));
} else {
return cljs.core.cons(cljs.core.first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));
}
} else {
return y;
}
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15537(x,y,zs){
var cat = (function cljs$core$fn_15537_$_cat(xys,zs__$1){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15537_$_cat_$_fn_15538(){
var xys__$1 = cljs.core.seq(xys);
if(xys__$1){
if(cljs.core.chunked_seq_QMARK_(xys__$1)){
return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cljs$core$fn_15537_$_cat(cljs.core.chunk_rest(xys__$1),zs__$1));
} else {
return cljs.core.cons(cljs.core.first(xys__$1),cljs$core$fn_15537_$_cat(cljs.core.rest(xys__$1),zs__$1));
}
} else {
if(cljs.core.truth_(zs__$1)){
return cljs$core$fn_15537_$_cat(cljs.core.first(zs__$1),cljs.core.next(zs__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x,y),zs);
}));

/** @this {Function} */
(cljs.core.concat.cljs$lang$applyTo = (function cljs$core$fn_15539(seq15527){
var G__15528 = cljs.core.first(seq15527);
var seq15527__$1 = cljs.core.next(seq15527);
var G__15529 = cljs.core.first(seq15527__$1);
var seq15527__$2 = cljs.core.next(seq15527__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15528,G__15529,seq15527__$2);
}));

(cljs.core.concat.cljs$lang$maxFixedArity = (2));

/**
 * Creates a new list containing the items prepended to the rest, the
 *   last of which will be treated as a sequence.
 */
cljs.core.list_STAR_ = (function cljs$core$list_STAR_(var_args){
var G__15550 = arguments.length;
switch (G__15550) {
case 1:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15558 = arguments.length;
var i__10876__auto___15559 = (0);
while(true){
if((i__10876__auto___15559 < len__10875__auto___15558)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15559]));

var G__15560 = (i__10876__auto___15559 + (1));
i__10876__auto___15559 = G__15560;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((4) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((4)),(0),null)):null);
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10905__auto__);

}
});

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15551(args){
return cljs.core.seq(args);
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15552(a,args){
return cljs.core.cons(a,args);
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15553(a,b,args){
return cljs.core.cons(a,cljs.core.cons(b,args));
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15554(a,b,c,args){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)));
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15555(a,b,c,d,more){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))));
}));

/** @this {Function} */
(cljs.core.list_STAR_.cljs$lang$applyTo = (function cljs$core$fn_15556(seq15545){
var G__15546 = cljs.core.first(seq15545);
var seq15545__$1 = cljs.core.next(seq15545);
var G__15547 = cljs.core.first(seq15545__$1);
var seq15545__$2 = cljs.core.next(seq15545__$1);
var G__15548 = cljs.core.first(seq15545__$2);
var seq15545__$3 = cljs.core.next(seq15545__$2);
var G__15549 = cljs.core.first(seq15545__$3);
var seq15545__$4 = cljs.core.next(seq15545__$3);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15546,G__15547,G__15548,G__15549,seq15545__$4);
}));

(cljs.core.list_STAR_.cljs$lang$maxFixedArity = (4));

/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core.transient$ = (function cljs$core$transient(coll){
return cljs.core._as_transient(coll);
});
/**
 * Returns a new, persistent version of the transient collection, in
 *   constant time. The transient collection cannot be used after this
 *   call, any such use will throw an exception.
 */
cljs.core.persistent_BANG_ = (function cljs$core$persistent_BANG_(tcoll){
return cljs.core._persistent_BANG_(tcoll);
});
/**
 * Adds val to the transient collection, and return tcoll. The 'addition'
 *   may happen at different 'places' depending on the concrete type.
 */
cljs.core.conj_BANG_ = (function cljs$core$conj_BANG_(var_args){
var G__15565 = arguments.length;
switch (G__15565) {
case 0:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15572 = arguments.length;
var i__10876__auto___15573 = (0);
while(true){
if((i__10876__auto___15573 < len__10875__auto___15572)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15573]));

var G__15574 = (i__10876__auto___15573 + (1));
i__10876__auto___15573 = G__15574;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15566(){
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15567(tcoll){
return tcoll;
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15568(tcoll,val){
return cljs.core._conj_BANG_(tcoll,val);
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15569(tcoll,val,vals){
while(true){
var ntcoll = cljs.core._conj_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__15575 = ntcoll;
var G__15576 = cljs.core.first(vals);
var G__15577 = cljs.core.next(vals);
tcoll = G__15575;
val = G__15576;
vals = G__15577;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.conj_BANG_.cljs$lang$applyTo = (function cljs$core$fn_15570(seq15562){
var G__15563 = cljs.core.first(seq15562);
var seq15562__$1 = cljs.core.next(seq15562);
var G__15564 = cljs.core.first(seq15562__$1);
var seq15562__$2 = cljs.core.next(seq15562__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15563,G__15564,seq15562__$2);
}));

(cljs.core.conj_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * When applied to a transient map, adds mapping of key(s) to
 *   val(s). When applied to a transient vector, sets the val at index.
 *   Note - index must be <= (count vector). Returns coll.
 */
cljs.core.assoc_BANG_ = (function cljs$core$assoc_BANG_(var_args){
var G__15583 = arguments.length;
switch (G__15583) {
case 3:
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15588 = arguments.length;
var i__10876__auto___15589 = (0);
while(true){
if((i__10876__auto___15589 < len__10875__auto___15588)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15589]));

var G__15590 = (i__10876__auto___15589 + (1));
i__10876__auto___15589 = G__15590;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((3) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((3)),(0),null)):null);
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10905__auto__);

}
});

(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15584(tcoll,key,val){
return cljs.core._assoc_BANG_(tcoll,key,val);
}));

(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15585(tcoll,key,val,kvs){
while(true){
var ntcoll = cljs.core._assoc_BANG_(tcoll,key,val);
if(cljs.core.truth_(kvs)){
var G__15591 = ntcoll;
var G__15592 = cljs.core.first(kvs);
var G__15593 = cljs.core.second(kvs);
var G__15594 = cljs.core.nnext(kvs);
tcoll = G__15591;
key = G__15592;
val = G__15593;
kvs = G__15594;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.assoc_BANG_.cljs$lang$applyTo = (function cljs$core$fn_15586(seq15579){
var G__15580 = cljs.core.first(seq15579);
var seq15579__$1 = cljs.core.next(seq15579);
var G__15581 = cljs.core.first(seq15579__$1);
var seq15579__$2 = cljs.core.next(seq15579__$1);
var G__15582 = cljs.core.first(seq15579__$2);
var seq15579__$3 = cljs.core.next(seq15579__$2);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15580,G__15581,G__15582,seq15579__$3);
}));

(cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = (3));

/**
 * Returns a transient map that doesn't contain a mapping for key(s).
 */
cljs.core.dissoc_BANG_ = (function cljs$core$dissoc_BANG_(var_args){
var G__15599 = arguments.length;
switch (G__15599) {
case 2:
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15604 = arguments.length;
var i__10876__auto___15605 = (0);
while(true){
if((i__10876__auto___15605 < len__10875__auto___15604)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15605]));

var G__15606 = (i__10876__auto___15605 + (1));
i__10876__auto___15605 = G__15606;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15600(tcoll,key){
return cljs.core._dissoc_BANG_(tcoll,key);
}));

(cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15601(tcoll,key,ks){
while(true){
var ntcoll = cljs.core._dissoc_BANG_(tcoll,key);
if(cljs.core.truth_(ks)){
var G__15607 = ntcoll;
var G__15608 = cljs.core.first(ks);
var G__15609 = cljs.core.next(ks);
tcoll = G__15607;
key = G__15608;
ks = G__15609;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.dissoc_BANG_.cljs$lang$applyTo = (function cljs$core$fn_15602(seq15596){
var G__15597 = cljs.core.first(seq15596);
var seq15596__$1 = cljs.core.next(seq15596);
var G__15598 = cljs.core.first(seq15596__$1);
var seq15596__$2 = cljs.core.next(seq15596__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15597,G__15598,seq15596__$2);
}));

(cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Removes the last item from a transient vector. If
 *   the collection is empty, throws an exception. Returns tcoll
 */
cljs.core.pop_BANG_ = (function cljs$core$pop_BANG_(tcoll){
return cljs.core._pop_BANG_(tcoll);
});
/**
 * disj[oin]. Returns a transient set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj_BANG_ = (function cljs$core$disj_BANG_(var_args){
var G__15614 = arguments.length;
switch (G__15614) {
case 2:
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15619 = arguments.length;
var i__10876__auto___15620 = (0);
while(true){
if((i__10876__auto___15620 < len__10875__auto___15619)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15620]));

var G__15621 = (i__10876__auto___15620 + (1));
i__10876__auto___15620 = G__15621;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15615(tcoll,val){
return cljs.core._disjoin_BANG_(tcoll,val);
}));

(cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15616(tcoll,val,vals){
while(true){
var ntcoll = cljs.core._disjoin_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__15622 = ntcoll;
var G__15623 = cljs.core.first(vals);
var G__15624 = cljs.core.next(vals);
tcoll = G__15622;
val = G__15623;
vals = G__15624;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.disj_BANG_.cljs$lang$applyTo = (function cljs$core$fn_15617(seq15611){
var G__15612 = cljs.core.first(seq15611);
var seq15611__$1 = cljs.core.next(seq15611);
var G__15613 = cljs.core.first(seq15611__$1);
var seq15611__$2 = cljs.core.next(seq15611__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15612,G__15613,seq15611__$2);
}));

(cljs.core.disj_BANG_.cljs$lang$maxFixedArity = (2));


cljs.core.apply_to = (function cljs$core$apply_to(f,argc,args){
var args__$1 = cljs.core.seq(args);
if((argc === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var a10678 = cljs.core._first(args__$1);
var args__$2 = cljs.core._rest(args__$1);
if((argc === (1))){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(a10678) : f.call(null,a10678));
} else {
var b10679 = cljs.core._first(args__$2);
var args__$3 = cljs.core._rest(args__$2);
if((argc === (2))){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(a10678,b10679) : f.call(null,a10678,b10679));
} else {
var c10680 = cljs.core._first(args__$3);
var args__$4 = cljs.core._rest(args__$3);
if((argc === (3))){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(a10678,b10679,c10680) : f.call(null,a10678,b10679,c10680));
} else {
var d10681 = cljs.core._first(args__$4);
var args__$5 = cljs.core._rest(args__$4);
if((argc === (4))){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(a10678,b10679,c10680,d10681) : f.call(null,a10678,b10679,c10680,d10681));
} else {
var e10682 = cljs.core._first(args__$5);
var args__$6 = cljs.core._rest(args__$5);
if((argc === (5))){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(a10678,b10679,c10680,d10681,e10682) : f.call(null,a10678,b10679,c10680,d10681,e10682));
} else {
var f10683 = cljs.core._first(args__$6);
var args__$7 = cljs.core._rest(args__$6);
if((argc === (6))){
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(a10678,b10679,c10680,d10681,e10682,f10683) : f.call(null,a10678,b10679,c10680,d10681,e10682,f10683));
} else {
var g10684 = cljs.core._first(args__$7);
var args__$8 = cljs.core._rest(args__$7);
if((argc === (7))){
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(a10678,b10679,c10680,d10681,e10682,f10683,g10684) : f.call(null,a10678,b10679,c10680,d10681,e10682,f10683,g10684));
} else {
var h10685 = cljs.core._first(args__$8);
var args__$9 = cljs.core._rest(args__$8);
if((argc === (8))){
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685) : f.call(null,a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685));
} else {
var i10686 = cljs.core._first(args__$9);
var args__$10 = cljs.core._rest(args__$9);
if((argc === (9))){
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685,i10686) : f.call(null,a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685,i10686));
} else {
var j10687 = cljs.core._first(args__$10);
var args__$11 = cljs.core._rest(args__$10);
if((argc === (10))){
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685,i10686,j10687) : f.call(null,a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685,i10686,j10687));
} else {
var k10688 = cljs.core._first(args__$11);
var args__$12 = cljs.core._rest(args__$11);
if((argc === (11))){
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685,i10686,j10687,k10688) : f.call(null,a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685,i10686,j10687,k10688));
} else {
var l10689 = cljs.core._first(args__$12);
var args__$13 = cljs.core._rest(args__$12);
if((argc === (12))){
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685,i10686,j10687,k10688,l10689) : f.call(null,a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685,i10686,j10687,k10688,l10689));
} else {
var m10690 = cljs.core._first(args__$13);
var args__$14 = cljs.core._rest(args__$13);
if((argc === (13))){
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685,i10686,j10687,k10688,l10689,m10690) : f.call(null,a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685,i10686,j10687,k10688,l10689,m10690));
} else {
var n10691 = cljs.core._first(args__$14);
var args__$15 = cljs.core._rest(args__$14);
if((argc === (14))){
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685,i10686,j10687,k10688,l10689,m10690,n10691) : f.call(null,a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685,i10686,j10687,k10688,l10689,m10690,n10691));
} else {
var o10692 = cljs.core._first(args__$15);
var args__$16 = cljs.core._rest(args__$15);
if((argc === (15))){
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685,i10686,j10687,k10688,l10689,m10690,n10691,o10692) : f.call(null,a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685,i10686,j10687,k10688,l10689,m10690,n10691,o10692));
} else {
var p10693 = cljs.core._first(args__$16);
var args__$17 = cljs.core._rest(args__$16);
if((argc === (16))){
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685,i10686,j10687,k10688,l10689,m10690,n10691,o10692,p10693) : f.call(null,a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685,i10686,j10687,k10688,l10689,m10690,n10691,o10692,p10693));
} else {
var q10694 = cljs.core._first(args__$17);
var args__$18 = cljs.core._rest(args__$17);
if((argc === (17))){
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685,i10686,j10687,k10688,l10689,m10690,n10691,o10692,p10693,q10694) : f.call(null,a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685,i10686,j10687,k10688,l10689,m10690,n10691,o10692,p10693,q10694));
} else {
var r10695 = cljs.core._first(args__$18);
var args__$19 = cljs.core._rest(args__$18);
if((argc === (18))){
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685,i10686,j10687,k10688,l10689,m10690,n10691,o10692,p10693,q10694,r10695) : f.call(null,a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685,i10686,j10687,k10688,l10689,m10690,n10691,o10692,p10693,q10694,r10695));
} else {
var s10696 = cljs.core._first(args__$19);
var args__$20 = cljs.core._rest(args__$19);
if((argc === (19))){
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685,i10686,j10687,k10688,l10689,m10690,n10691,o10692,p10693,q10694,r10695,s10696) : f.call(null,a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685,i10686,j10687,k10688,l10689,m10690,n10691,o10692,p10693,q10694,r10695,s10696));
} else {
var t10697 = cljs.core._first(args__$20);
var args__$21 = cljs.core._rest(args__$20);
if((argc === (20))){
return (f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685,i10686,j10687,k10688,l10689,m10690,n10691,o10692,p10693,q10694,r10695,s10696,t10697) : f.call(null,a10678,b10679,c10680,d10681,e10682,f10683,g10684,h10685,i10686,j10687,k10688,l10689,m10690,n10691,o10692,p10693,q10694,r10695,s10696,t10697));
} else {
throw (new Error("Only up to 20 arguments supported on functions"));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

/**
 * Internal. DO NOT USE! Next without the nil? check.
 */
cljs.core.next_STAR_ = (function cljs$core$next_STAR_(coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$))))?true:false):false)){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
});
/**
 * Internal. DO NOT USE!
 *   Assumes args was already called with seq beforehand!
 */
cljs.core.apply_to_simple = (function cljs$core$apply_to_simple(var_args){
var G__15627 = arguments.length;
switch (G__15627) {
case 2:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15628(f,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$0){
return f.cljs$core$IFn$_invoke$arity$0();
} else {
return f.call(f);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(f,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15629(f,a0,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$1){
return f.cljs$core$IFn$_invoke$arity$1(a0);
} else {
return f.call(f,a0);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(f,a0,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15630(f,a0,a1,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$2){
return f.cljs$core$IFn$_invoke$arity$2(a0,a1);
} else {
return f.call(f,a0,a1);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(f,a0,a1,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_15631(f,a0,a1,a2,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$3){
return f.cljs$core$IFn$_invoke$arity$3(a0,a1,a2);
} else {
return f.call(f,a0,a1,a2);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(f,a0,a1,a2,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_15632(f,a0,a1,a2,a3,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$4){
return f.cljs$core$IFn$_invoke$arity$4(a0,a1,a2,a3);
} else {
return f.call(f,a0,a1,a2,a3);
}
} else {
var a4 = cljs.core._first(args);
var next_4 = cljs.core.next(args);
if((next_4 == null)){
if(f.cljs$core$IFn$_invoke$arity$5){
return f.cljs$core$IFn$_invoke$arity$5(a0,a1,a2,a3,a4);
} else {
return f.call(f,a0,a1,a2,a3,a4);
}
} else {
var a5 = cljs.core._first(next_4);
var next_5 = cljs.core.next(next_4);
if((next_5 == null)){
if(f.cljs$core$IFn$_invoke$arity$6){
return f.cljs$core$IFn$_invoke$arity$6(a0,a1,a2,a3,a4,a5);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5);
}
} else {
var a6 = cljs.core._first(next_5);
var next_6 = cljs.core.next(next_5);
if((next_6 == null)){
if(f.cljs$core$IFn$_invoke$arity$7){
return f.cljs$core$IFn$_invoke$arity$7(a0,a1,a2,a3,a4,a5,a6);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6);
}
} else {
var a7 = cljs.core._first(next_6);
var next_7 = cljs.core.next(next_6);
if((next_7 == null)){
if(f.cljs$core$IFn$_invoke$arity$8){
return f.cljs$core$IFn$_invoke$arity$8(a0,a1,a2,a3,a4,a5,a6,a7);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7);
}
} else {
var a8 = cljs.core._first(next_7);
var next_8 = cljs.core.next(next_7);
if((next_8 == null)){
if(f.cljs$core$IFn$_invoke$arity$9){
return f.cljs$core$IFn$_invoke$arity$9(a0,a1,a2,a3,a4,a5,a6,a7,a8);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8);
}
} else {
var a9 = cljs.core._first(next_8);
var next_9 = cljs.core.next(next_8);
if((next_9 == null)){
if(f.cljs$core$IFn$_invoke$arity$10){
return f.cljs$core$IFn$_invoke$arity$10(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);
}
} else {
var a10 = cljs.core._first(next_9);
var next_10 = cljs.core.next(next_9);
if((next_10 == null)){
if(f.cljs$core$IFn$_invoke$arity$11){
return f.cljs$core$IFn$_invoke$arity$11(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
}
} else {
var a11 = cljs.core._first(next_10);
var next_11 = cljs.core.next(next_10);
if((next_11 == null)){
if(f.cljs$core$IFn$_invoke$arity$12){
return f.cljs$core$IFn$_invoke$arity$12(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
}
} else {
var a12 = cljs.core._first(next_11);
var next_12 = cljs.core.next(next_11);
if((next_12 == null)){
if(f.cljs$core$IFn$_invoke$arity$13){
return f.cljs$core$IFn$_invoke$arity$13(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);
}
} else {
var a13 = cljs.core._first(next_12);
var next_13 = cljs.core.next(next_12);
if((next_13 == null)){
if(f.cljs$core$IFn$_invoke$arity$14){
return f.cljs$core$IFn$_invoke$arity$14(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13);
}
} else {
var a14 = cljs.core._first(next_13);
var next_14 = cljs.core.next(next_13);
if((next_14 == null)){
if(f.cljs$core$IFn$_invoke$arity$15){
return f.cljs$core$IFn$_invoke$arity$15(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14);
}
} else {
var a15 = cljs.core._first(next_14);
var next_15 = cljs.core.next(next_14);
if((next_15 == null)){
if(f.cljs$core$IFn$_invoke$arity$16){
return f.cljs$core$IFn$_invoke$arity$16(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);
}
} else {
var a16 = cljs.core._first(next_15);
var next_16 = cljs.core.next(next_15);
if((next_16 == null)){
if(f.cljs$core$IFn$_invoke$arity$17){
return f.cljs$core$IFn$_invoke$arity$17(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16);
}
} else {
var a17 = cljs.core._first(next_16);
var next_17 = cljs.core.next(next_16);
if((next_17 == null)){
if(f.cljs$core$IFn$_invoke$arity$18){
return f.cljs$core$IFn$_invoke$arity$18(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17);
}
} else {
var a18 = cljs.core._first(next_17);
var next_18 = cljs.core.next(next_17);
if((next_18 == null)){
if(f.cljs$core$IFn$_invoke$arity$19){
return f.cljs$core$IFn$_invoke$arity$19(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18);
}
} else {
var a19 = cljs.core._first(next_18);
var next_19 = cljs.core.next(next_18);
if((next_19 == null)){
if(f.cljs$core$IFn$_invoke$arity$20){
return f.cljs$core$IFn$_invoke$arity$20(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19);
}
} else {
var arr__10706__auto__ = [a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19];
var s__10707__auto___15634 = next_19;
while(true){
if(s__10707__auto___15634){
arr__10706__auto__.push(cljs.core._first(s__10707__auto___15634));

var G__15635 = cljs.core.next(s__10707__auto___15634);
s__10707__auto___15634 = G__15635;
continue;
} else {
}
break;
}

return f.apply(f,arr__10706__auto__);
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(cljs.core.apply_to_simple.cljs$lang$maxFixedArity = 6);

/**
 * Applies fn f to the argument list formed by prepending intervening arguments to args.
 */
cljs.core.apply = (function cljs$core$apply(var_args){
var G__15643 = arguments.length;
switch (G__15643) {
case 2:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15651 = arguments.length;
var i__10876__auto___15652 = (0);
while(true){
if((i__10876__auto___15652 < len__10875__auto___15651)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15652]));

var G__15653 = (i__10876__auto___15652 + (1));
i__10876__auto___15652 = G__15653;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((5) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((5)),(0),null)):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__10905__auto__);

}
});

(cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15644(f,args){
if(f.cljs$lang$applyTo){
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = cljs.core.bounded_count((fixed_arity + (1)),args);
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,args);
} else {
return f.cljs$lang$applyTo(args);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2(f,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15645(f,x,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = (cljs.core.bounded_count(fixed_arity,args) + (1));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(f,x,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15646(f,x,y,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x,y,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((2) + cljs.core.bounded_count((fixed_arity - (1)),args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(f,x,y,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_15647(f,x,y,z,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x,y,z,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((3) + cljs.core.bounded_count((fixed_arity - (2)),args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(f,x,y,z,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15648(f,a,b,c,d,args){
if(f.cljs$lang$applyTo){
var spread_args = cljs.core.spread(args);
var arglist = cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,spread_args))));
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((4) + cljs.core.bounded_count((fixed_arity - (3)),spread_args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(f,a,b,c,d,cljs.core.spread(args));
}
}));

/** @this {Function} */
(cljs.core.apply.cljs$lang$applyTo = (function cljs$core$fn_15649(seq15637){
var G__15638 = cljs.core.first(seq15637);
var seq15637__$1 = cljs.core.next(seq15637);
var G__15639 = cljs.core.first(seq15637__$1);
var seq15637__$2 = cljs.core.next(seq15637__$1);
var G__15640 = cljs.core.first(seq15637__$2);
var seq15637__$3 = cljs.core.next(seq15637__$2);
var G__15641 = cljs.core.first(seq15637__$3);
var seq15637__$4 = cljs.core.next(seq15637__$3);
var G__15642 = cljs.core.first(seq15637__$4);
var seq15637__$5 = cljs.core.next(seq15637__$4);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15638,G__15639,G__15640,G__15641,G__15642,seq15637__$5);
}));

(cljs.core.apply.cljs$lang$maxFixedArity = (5));

cljs.core.__destructure_map = (function cljs$core$__destructure_map(gmap){
if((((!((gmap == null))))?(((((gmap.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === gmap.cljs$core$ISeq$))))?true:false):false)){
if(cljs.core.next(gmap)){
return cljs.core.PersistentArrayMap.createAsIfByAssoc(cljs.core.to_array(gmap));
} else {
if(cljs.core.seq(gmap)){
return cljs.core.first(gmap);
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
}
} else {
return gmap;
}
});
/**
 * Returns an object of the same type and value as obj, with
 *   (apply f (meta obj) args) as its metadata.
 */
cljs.core.vary_meta = (function cljs$core$vary_meta(var_args){
var G__15663 = arguments.length;
switch (G__15663) {
case 2:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15687 = arguments.length;
var i__10876__auto___15688 = (0);
while(true){
if((i__10876__auto___15688 < len__10875__auto___15687)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15688]));

var G__15689 = (i__10876__auto___15688 + (1));
i__10876__auto___15688 = G__15689;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((6) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((6)),(0),null)):null);
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__10905__auto__);

}
});

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15664(obj,f){
return cljs.core.with_meta(obj,(function (){var G__15665 = cljs.core.meta(obj);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15665) : f.call(null,G__15665));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15666(obj,f,a){
return cljs.core.with_meta(obj,(function (){var G__15667 = cljs.core.meta(obj);
var G__15668 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15667,G__15668) : f.call(null,G__15667,G__15668));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15669(obj,f,a,b){
return cljs.core.with_meta(obj,(function (){var G__15670 = cljs.core.meta(obj);
var G__15671 = a;
var G__15672 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15670,G__15671,G__15672) : f.call(null,G__15670,G__15671,G__15672));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_15673(obj,f,a,b,c){
return cljs.core.with_meta(obj,(function (){var G__15674 = cljs.core.meta(obj);
var G__15675 = a;
var G__15676 = b;
var G__15677 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__15674,G__15675,G__15676,G__15677) : f.call(null,G__15674,G__15675,G__15676,G__15677));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_15678(obj,f,a,b,c,d){
return cljs.core.with_meta(obj,(function (){var G__15679 = cljs.core.meta(obj);
var G__15680 = a;
var G__15681 = b;
var G__15682 = c;
var G__15683 = d;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__15679,G__15680,G__15681,G__15682,G__15683) : f.call(null,G__15679,G__15680,G__15681,G__15682,G__15683));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15684(obj,f,a,b,c,d,args){
return cljs.core.with_meta(obj,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.meta(obj),a,b,c,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([d,args], 0)));
}));

/** @this {Function} */
(cljs.core.vary_meta.cljs$lang$applyTo = (function cljs$core$fn_15685(seq15656){
var G__15657 = cljs.core.first(seq15656);
var seq15656__$1 = cljs.core.next(seq15656);
var G__15658 = cljs.core.first(seq15656__$1);
var seq15656__$2 = cljs.core.next(seq15656__$1);
var G__15659 = cljs.core.first(seq15656__$2);
var seq15656__$3 = cljs.core.next(seq15656__$2);
var G__15660 = cljs.core.first(seq15656__$3);
var seq15656__$4 = cljs.core.next(seq15656__$3);
var G__15661 = cljs.core.first(seq15656__$4);
var seq15656__$5 = cljs.core.next(seq15656__$4);
var G__15662 = cljs.core.first(seq15656__$5);
var seq15656__$6 = cljs.core.next(seq15656__$5);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15657,G__15658,G__15659,G__15660,G__15661,G__15662,seq15656__$6);
}));

(cljs.core.vary_meta.cljs$lang$maxFixedArity = (6));

/**
 * Same as (not (= obj1 obj2))
 */
cljs.core.not_EQ_ = (function cljs$core$not_EQ_(var_args){
var G__15694 = arguments.length;
switch (G__15694) {
case 1:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15700 = arguments.length;
var i__10876__auto___15701 = (0);
while(true){
if((i__10876__auto___15701 < len__10875__auto___15700)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15701]));

var G__15702 = (i__10876__auto___15701 + (1));
i__10876__auto___15701 = G__15702;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15695(x){
return false;
}));

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15696(x,y){
return (!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)));
}));

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15697(x,y,more){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more));
}));

/** @this {Function} */
(cljs.core.not_EQ_.cljs$lang$applyTo = (function cljs$core$fn_15698(seq15691){
var G__15692 = cljs.core.first(seq15691);
var seq15691__$1 = cljs.core.next(seq15691);
var G__15693 = cljs.core.first(seq15691__$1);
var seq15691__$2 = cljs.core.next(seq15691__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15692,G__15693,seq15691__$2);
}));

(cljs.core.not_EQ_.cljs$lang$maxFixedArity = (2));

/**
 * If coll is empty, returns nil, else coll
 */
cljs.core.not_empty = (function cljs$core$not_empty(coll){
if(cljs.core.seq(coll)){
return coll;
} else {
return null;
}
});
cljs.core.nil_iter = (function cljs$core$nil_iter(){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.t_cljs$core15703 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.t_cljs$core15703 = (function (meta15704){
this.meta15704 = meta15704;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.t_cljs$core15703.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$nil_iter_$_fn_15706(_15705,meta15704__$1){
var self__ = this;
var _15705__$1 = this;
return (new cljs.core.t_cljs$core15703(meta15704__$1));
}));

(cljs.core.t_cljs$core15703.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$nil_iter_$_fn_15707(_15705){
var self__ = this;
var _15705__$1 = this;
return self__.meta15704;
}));

(cljs.core.t_cljs$core15703.prototype.hasNext = (function cljs$core$nil_iter_$_fn_15708(){
var self__ = this;
var _ = this;
return false;
}));

(cljs.core.t_cljs$core15703.prototype.next = (function cljs$core$nil_iter_$_fn_15709(){
var self__ = this;
var _ = this;
return (new Error("No such element"));
}));

(cljs.core.t_cljs$core15703.prototype.remove = (function cljs$core$nil_iter_$_fn_15710(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.t_cljs$core15703.getBasis = (function cljs$core$nil_iter_$_fn_15711(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta15704","meta15704",1394015477,null)], null);
}));

(cljs.core.t_cljs$core15703.cljs$lang$type = true);

(cljs.core.t_cljs$core15703.cljs$lang$ctorStr = "cljs.core/t_cljs$core15703");

(cljs.core.t_cljs$core15703.cljs$lang$ctorPrWriter = (function cljs$core$nil_iter_$_fn_15712(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/t_cljs$core15703");
}));

/**
 * Positional factory function for cljs.core/t_cljs$core15703.
 */
cljs.core.__GT_t_cljs$core15703 = (function cljs$core$nil_iter_$___GT_t_cljs$core15703(meta15704){
return (new cljs.core.t_cljs$core15703(meta15704));
});

}

return (new cljs.core.t_cljs$core15703(cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
*/
cljs.core.StringIter = (function (s,i){
this.s = s;
this.i = i;
});
(cljs.core.StringIter.prototype.hasNext = (function cljs$core$fn_15713(){
var self__ = this;
var _ = this;
return (self__.i < self__.s.length);
}));

(cljs.core.StringIter.prototype.next = (function cljs$core$fn_15714(){
var self__ = this;
var _ = this;
var ret = self__.s.charAt(self__.i);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.StringIter.prototype.remove = (function cljs$core$fn_15715(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.StringIter.getBasis = (function cljs$core$fn_15716(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.StringIter.cljs$lang$type = true);

(cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter");

(cljs.core.StringIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_15717(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/StringIter");
}));

/**
 * Positional factory function for cljs.core/StringIter.
 */
cljs.core.__GT_StringIter = (function cljs$core$__GT_StringIter(s,i){
return (new cljs.core.StringIter(s,i));
});

cljs.core.string_iter = (function cljs$core$string_iter(x){
return (new cljs.core.StringIter(x,(0)));
});

/**
* @constructor
*/
cljs.core.ArrayIter = (function (arr,i){
this.arr = arr;
this.i = i;
});
(cljs.core.ArrayIter.prototype.hasNext = (function cljs$core$fn_15718(){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
}));

(cljs.core.ArrayIter.prototype.next = (function cljs$core$fn_15719(){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.ArrayIter.prototype.remove = (function cljs$core$fn_15720(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.ArrayIter.getBasis = (function cljs$core$fn_15721(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayIter.cljs$lang$type = true);

(cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter");

(cljs.core.ArrayIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_15722(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/ArrayIter");
}));

/**
 * Positional factory function for cljs.core/ArrayIter.
 */
cljs.core.__GT_ArrayIter = (function cljs$core$__GT_ArrayIter(arr,i){
return (new cljs.core.ArrayIter(arr,i));
});

cljs.core.array_iter = (function cljs$core$array_iter(x){
return (new cljs.core.ArrayIter(x,(0)));
});
cljs.core.INIT = ({});
cljs.core.START = ({});

/**
* @constructor
*/
cljs.core.SeqIter = (function (_seq,_next){
this._seq = _seq;
this._next = _next;
});
(cljs.core.SeqIter.prototype.hasNext = (function cljs$core$fn_15723(){
var self__ = this;
var _ = this;
if((self__._seq === cljs.core.INIT)){
(self__._seq = cljs.core.START);

(self__._next = cljs.core.seq(self__._next));
} else {
if((self__._seq === self__._next)){
(self__._next = cljs.core.next(self__._seq));
} else {
}
}

return (!((self__._next == null)));
}));

(cljs.core.SeqIter.prototype.next = (function cljs$core$fn_15724(){
var self__ = this;
var this$ = this;
if((!(this$.hasNext()))){
throw (new Error("No such element"));
} else {
(self__._seq = self__._next);

return cljs.core.first(self__._next);
}
}));

(cljs.core.SeqIter.prototype.remove = (function cljs$core$fn_15725(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.SeqIter.getBasis = (function cljs$core$fn_15726(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"_seq","_seq",-449557847,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.SeqIter.cljs$lang$type = true);

(cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter");

(cljs.core.SeqIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_15727(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/SeqIter");
}));

/**
 * Positional factory function for cljs.core/SeqIter.
 */
cljs.core.__GT_SeqIter = (function cljs$core$__GT_SeqIter(_seq,_next){
return (new cljs.core.SeqIter(_seq,_next));
});

cljs.core.seq_iter = (function cljs$core$seq_iter(coll){
return (new cljs.core.SeqIter(cljs.core.INIT,coll));
});
cljs.core.iter = (function cljs$core$iter(coll){
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core._iterator(coll);
} else {
if((coll == null)){
return cljs.core.nil_iter();
} else {
if(typeof coll === 'string'){
return cljs.core.string_iter(coll);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_iter(coll);
} else {
if(cljs.core.seqable_QMARK_(coll)){
return cljs.core.seq_iter(coll);
} else {
throw (new Error(["Cannot create iterator from ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll)].join('')));

}
}
}
}
}
});

/**
* @constructor
*/
cljs.core.Many = (function (vals){
this.vals = vals;
});
(cljs.core.Many.prototype.add = (function cljs$core$fn_15728(o){
var self__ = this;
var this$ = this;
self__.vals.push(o);

return this$;
}));

(cljs.core.Many.prototype.remove = (function cljs$core$fn_15729(){
var self__ = this;
var this$ = this;
return self__.vals.shift();
}));

(cljs.core.Many.prototype.isEmpty = (function cljs$core$fn_15730(){
var self__ = this;
var this$ = this;
return (self__.vals.length === (0));
}));

(cljs.core.Many.prototype.toString = (function cljs$core$fn_15731(){
var self__ = this;
var this$ = this;
return ["Many: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.vals)].join('');
}));

(cljs.core.Many.getBasis = (function cljs$core$fn_15732(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"vals","vals",-1886377036,null)], null);
}));

(cljs.core.Many.cljs$lang$type = true);

(cljs.core.Many.cljs$lang$ctorStr = "cljs.core/Many");

(cljs.core.Many.cljs$lang$ctorPrWriter = (function cljs$core$fn_15733(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/Many");
}));

/**
 * Positional factory function for cljs.core/Many.
 */
cljs.core.__GT_Many = (function cljs$core$__GT_Many(vals){
return (new cljs.core.Many(vals));
});

cljs.core.NONE = ({});

/**
* @constructor
*/
cljs.core.Single = (function (val){
this.val = val;
});
(cljs.core.Single.prototype.add = (function cljs$core$fn_15734(o){
var self__ = this;
var this$ = this;
if((self__.val === cljs.core.NONE)){
(self__.val = o);

return this$;
} else {
return (new cljs.core.Many([self__.val,o]));
}
}));

(cljs.core.Single.prototype.remove = (function cljs$core$fn_15735(){
var self__ = this;
var this$ = this;
if((self__.val === cljs.core.NONE)){
throw (new Error("Removing object from empty buffer"));
} else {
var ret = self__.val;
(self__.val = cljs.core.NONE);

return ret;
}
}));

(cljs.core.Single.prototype.isEmpty = (function cljs$core$fn_15736(){
var self__ = this;
var this$ = this;
return (self__.val === cljs.core.NONE);
}));

(cljs.core.Single.prototype.toString = (function cljs$core$fn_15737(){
var self__ = this;
var this$ = this;
return ["Single: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.val)].join('');
}));

(cljs.core.Single.getBasis = (function cljs$core$fn_15738(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Single.cljs$lang$type = true);

(cljs.core.Single.cljs$lang$ctorStr = "cljs.core/Single");

(cljs.core.Single.cljs$lang$ctorPrWriter = (function cljs$core$fn_15739(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/Single");
}));

/**
 * Positional factory function for cljs.core/Single.
 */
cljs.core.__GT_Single = (function cljs$core$__GT_Single(val){
return (new cljs.core.Single(val));
});


/**
* @constructor
*/
cljs.core.Empty = (function (){
});
(cljs.core.Empty.prototype.add = (function cljs$core$fn_15740(o){
var self__ = this;
var this$ = this;
return (new cljs.core.Single(o));
}));

(cljs.core.Empty.prototype.remove = (function cljs$core$fn_15741(){
var self__ = this;
var this$ = this;
throw (new Error("Removing object from empty buffer"));
}));

(cljs.core.Empty.prototype.isEmpty = (function cljs$core$fn_15742(){
var self__ = this;
var this$ = this;
return true;
}));

(cljs.core.Empty.prototype.toString = (function cljs$core$fn_15743(){
var self__ = this;
var this$ = this;
return "Empty";
}));

(cljs.core.Empty.getBasis = (function cljs$core$fn_15744(){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.Empty.cljs$lang$type = true);

(cljs.core.Empty.cljs$lang$ctorStr = "cljs.core/Empty");

(cljs.core.Empty.cljs$lang$ctorPrWriter = (function cljs$core$fn_15745(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/Empty");
}));

/**
 * Positional factory function for cljs.core/Empty.
 */
cljs.core.__GT_Empty = (function cljs$core$__GT_Empty(){
return (new cljs.core.Empty());
});

cljs.core.EMPTY = (new cljs.core.Empty());

/**
* @constructor
*/
cljs.core.MultiIterator = (function (iters){
this.iters = iters;
});
(cljs.core.MultiIterator.prototype.hasNext = (function cljs$core$fn_15746(){
var self__ = this;
var _ = this;
var iters__$1 = cljs.core.seq(self__.iters);
while(true){
if((!((iters__$1 == null)))){
var iter = cljs.core.first(iters__$1);
if((!(iter.hasNext()))){
return false;
} else {
var G__15750 = cljs.core.next(iters__$1);
iters__$1 = G__15750;
continue;
}
} else {
return true;
}
break;
}
}));

(cljs.core.MultiIterator.prototype.next = (function cljs$core$fn_15747(){
var self__ = this;
var _ = this;
var nexts = [];
var n__10634__auto___15751 = self__.iters.length;
var i_15752 = (0);
while(true){
if((i_15752 < n__10634__auto___15751)){
(nexts[i_15752] = (self__.iters[i_15752]).next());

var G__15753 = (i_15752 + (1));
i_15752 = G__15753;
continue;
} else {
}
break;
}

return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(nexts,(0));
}));

(cljs.core.MultiIterator.getBasis = (function cljs$core$fn_15748(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"iters","iters",719353031,null)], null);
}));

(cljs.core.MultiIterator.cljs$lang$type = true);

(cljs.core.MultiIterator.cljs$lang$ctorStr = "cljs.core/MultiIterator");

(cljs.core.MultiIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_15749(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/MultiIterator");
}));

/**
 * Positional factory function for cljs.core/MultiIterator.
 */
cljs.core.__GT_MultiIterator = (function cljs$core$__GT_MultiIterator(iters){
return (new cljs.core.MultiIterator(iters));
});

cljs.core.chunkIteratorSeq = (function cljs$core$chunkIteratorSeq(iter){
return (new cljs.core.LazySeq(null,(function cljs$core$chunkIteratorSeq_$_fn_15754(){
if(iter.hasNext()){
var arr = [];
var n = (0);
while(true){
if(cljs.core.truth_((function (){var and__9540__auto__ = iter.hasNext();
if(cljs.core.truth_(and__9540__auto__)){
return (n < (32));
} else {
return and__9540__auto__;
}
})())){
(arr[n] = iter.next());

var G__15755 = (n + (1));
n = G__15755;
continue;
} else {
return cljs.core.chunk_cons(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3(arr,(0),n),(cljs.core.chunkIteratorSeq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunkIteratorSeq.cljs$core$IFn$_invoke$arity$1(iter) : cljs.core.chunkIteratorSeq.call(null,iter)));
}
break;
}
} else {
return null;
}
}),null,null));
});

/**
* @constructor
*/
cljs.core.TransformerIterator = (function (buffer,_next,completed,xf,sourceIter,multi){
this.buffer = buffer;
this._next = _next;
this.completed = completed;
this.xf = xf;
this.sourceIter = sourceIter;
this.multi = multi;
});
(cljs.core.TransformerIterator.prototype.step = (function cljs$core$fn_15756(){
var self__ = this;
var this$ = this;
if((!((self__._next === cljs.core.NONE)))){
return true;
} else {
while(true){
if((self__._next === cljs.core.NONE)){
if(self__.buffer.isEmpty()){
if(self__.completed){
return false;
} else {
if(self__.sourceIter.hasNext()){
var iter = ((self__.multi)?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xf,cljs.core.cons(null,self__.sourceIter.next())):(function (){var G__15757 = null;
var G__15758 = self__.sourceIter.next();
return (self__.xf.cljs$core$IFn$_invoke$arity$2 ? self__.xf.cljs$core$IFn$_invoke$arity$2(G__15757,G__15758) : self__.xf.call(null,G__15757,G__15758));
})());
if(cljs.core.reduced_QMARK_(iter)){
(self__.xf.cljs$core$IFn$_invoke$arity$1 ? self__.xf.cljs$core$IFn$_invoke$arity$1(null) : self__.xf.call(null,null));

(self__.completed = true);
} else {
}

continue;
} else {
(self__.xf.cljs$core$IFn$_invoke$arity$1 ? self__.xf.cljs$core$IFn$_invoke$arity$1(null) : self__.xf.call(null,null));

(self__.completed = true);

continue;
}
}
} else {
(self__._next = self__.buffer.remove());

continue;
}
} else {
return true;
}
break;
}
}
}));

(cljs.core.TransformerIterator.prototype.hasNext = (function cljs$core$fn_15759(){
var self__ = this;
var this$ = this;
return this$.step();
}));

(cljs.core.TransformerIterator.prototype.next = (function cljs$core$fn_15760(){
var self__ = this;
var this$ = this;
if(this$.hasNext()){
var ret = self__._next;
(self__._next = cljs.core.NONE);

return ret;
} else {
throw (new Error("No such element"));
}
}));

(cljs.core.TransformerIterator.prototype.remove = (function cljs$core$fn_15761(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.TransformerIterator.getBasis = (function cljs$core$fn_15762(){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"buffer","buffer",-2037140571,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"completed","completed",1154475024,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"xf","xf",2042434515,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"sourceIter","sourceIter",1068220306,null),new cljs.core.Symbol(null,"multi","multi",1450238522,null)], null);
}));

(cljs.core.TransformerIterator.cljs$lang$type = true);

(cljs.core.TransformerIterator.cljs$lang$ctorStr = "cljs.core/TransformerIterator");

(cljs.core.TransformerIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_15763(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/TransformerIterator");
}));

/**
 * Positional factory function for cljs.core/TransformerIterator.
 */
cljs.core.__GT_TransformerIterator = (function cljs$core$__GT_TransformerIterator(buffer,_next,completed,xf,sourceIter,multi){
return (new cljs.core.TransformerIterator(buffer,_next,completed,xf,sourceIter,multi));
});

(cljs.core.TransformerIterator.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15764(){
var this__10736__auto__ = this;
return cljs.core.es6_iterator(this__10736__auto__);
}));
cljs.core.transformer_iterator = (function cljs$core$transformer_iterator(xform,sourceIter,multi){
var iterator = (new cljs.core.TransformerIterator(cljs.core.EMPTY,cljs.core.NONE,false,null,sourceIter,multi));
(iterator.xf = (function (){var G__15765 = (function() {
var cljs$core$transformer_iterator_$_fn_15766 = null;
var cljs$core$transformer_iterator_$_fn_15766__0 = (function (){
return null;
});
var cljs$core$transformer_iterator_$_fn_15766__1 = (function (acc){
return acc;
});
var cljs$core$transformer_iterator_$_fn_15766__2 = (function (acc,o){
(iterator.buffer = iterator.buffer.add(o));

return acc;
});
cljs$core$transformer_iterator_$_fn_15766 = function(acc,o){
switch(arguments.length){
case 0:
return cljs$core$transformer_iterator_$_fn_15766__0.call(this);
case 1:
return cljs$core$transformer_iterator_$_fn_15766__1.call(this,acc);
case 2:
return cljs$core$transformer_iterator_$_fn_15766__2.call(this,acc,o);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$transformer_iterator_$_fn_15766.cljs$core$IFn$_invoke$arity$0 = cljs$core$transformer_iterator_$_fn_15766__0;
cljs$core$transformer_iterator_$_fn_15766.cljs$core$IFn$_invoke$arity$1 = cljs$core$transformer_iterator_$_fn_15766__1;
cljs$core$transformer_iterator_$_fn_15766.cljs$core$IFn$_invoke$arity$2 = cljs$core$transformer_iterator_$_fn_15766__2;
return cljs$core$transformer_iterator_$_fn_15766;
})()
;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__15765) : xform.call(null,G__15765));
})());

return iterator;
});
(cljs.core.TransformerIterator.create = (function cljs$core$fn_15767(xform,source){
return cljs.core.transformer_iterator(xform,source,false);
}));
(cljs.core.TransformerIterator.createMulti = (function cljs$core$fn_15768(xform,sources){
return cljs.core.transformer_iterator(xform,(new cljs.core.MultiIterator(cljs.core.to_array(sources))),true);
}));
/**
 * Coerces coll to a (possibly empty) sequence, if it is not already
 *   one. Will not force a lazy seq. (sequence nil) yields (), When a
 *   transducer is supplied, returns a lazy sequence of applications of
 *   the transform to the items in coll(s), i.e. to the set of first
 *   items of each coll, followed by the set of second
 *   items in each coll, until any one of the colls is exhausted.  Any
 *   remaining items in other colls are ignored. The transform should accept
 *   number-of-colls arguments
 */
cljs.core.sequence = (function cljs$core$sequence(var_args){
var G__15773 = arguments.length;
switch (G__15773) {
case 1:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15779 = arguments.length;
var i__10876__auto___15780 = (0);
while(true){
if((i__10876__auto___15780 < len__10875__auto___15779)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15780]));

var G__15781 = (i__10876__auto___15780 + (1));
i__10876__auto___15780 = G__15781;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15774(coll){
if(cljs.core.seq_QMARK_(coll)){
return coll;
} else {
var or__9546__auto__ = cljs.core.seq(coll);
if(or__9546__auto__){
return or__9546__auto__;
} else {
return cljs.core.List.EMPTY;
}
}
}));

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15775(xform,coll){
var or__9546__auto__ = cljs.core.chunkIteratorSeq(cljs.core.TransformerIterator.create(xform,cljs.core.iter(coll)));
if(cljs.core.truth_(or__9546__auto__)){
return or__9546__auto__;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15776(xform,coll,colls){
var or__9546__auto__ = cljs.core.chunkIteratorSeq(cljs.core.TransformerIterator.createMulti(xform,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.iter,cljs.core.cons(coll,colls))));
if(cljs.core.truth_(or__9546__auto__)){
return or__9546__auto__;
} else {
return cljs.core.List.EMPTY;
}
}));

/** @this {Function} */
(cljs.core.sequence.cljs$lang$applyTo = (function cljs$core$fn_15777(seq15770){
var G__15771 = cljs.core.first(seq15770);
var seq15770__$1 = cljs.core.next(seq15770);
var G__15772 = cljs.core.first(seq15770__$1);
var seq15770__$2 = cljs.core.next(seq15770__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15771,G__15772,seq15770__$2);
}));

(cljs.core.sequence.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if (pred x) is logical true for every x in coll, else
 *   false.
 */
cljs.core.every_QMARK_ = (function cljs$core$every_QMARK_(pred,coll){
while(true){
if((cljs.core.seq(coll) == null)){
return true;
} else {
if(cljs.core.truth_((function (){var G__15782 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__15782) : pred.call(null,G__15782));
})())){
var G__15783 = pred;
var G__15784 = cljs.core.next(coll);
pred = G__15783;
coll = G__15784;
continue;
} else {
return false;

}
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for every x in
 *   coll, else true.
 */
cljs.core.not_every_QMARK_ = (function cljs$core$not_every_QMARK_(pred,coll){
return (!(cljs.core.every_QMARK_(pred,coll)));
});
/**
 * Returns the first logical true value of (pred x) for any x in coll,
 *   else nil.  One common idiom is to use a set as pred, for example
 *   this will return :fred if :fred is in the sequence, otherwise nil:
 *   (some #{:fred} coll)
 */
cljs.core.some = (function cljs$core$some(pred,coll){
while(true){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
var or__9546__auto__ = (function (){var G__15785 = cljs.core.first(s);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__15785) : pred.call(null,G__15785));
})();
if(cljs.core.truth_(or__9546__auto__)){
return or__9546__auto__;
} else {
var G__15786 = pred;
var G__15787 = cljs.core.next(s);
pred = G__15786;
coll = G__15787;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for any x in coll,
 *   else true.
 */
cljs.core.not_any_QMARK_ = (function cljs$core$not_any_QMARK_(pred,coll){
return cljs.core.not(cljs.core.some(pred,coll));
});
/**
 * Returns true if n is even, throws an exception if n is not an integer
 */
cljs.core.even_QMARK_ = (function cljs$core$even_QMARK_(n){
if(cljs.core.integer_QMARK_(n)){
return ((n & (1)) === (0));
} else {
throw (new Error(["Argument must be an integer: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)].join('')));
}
});
/**
 * Returns true if n is odd, throws an exception if n is not an integer
 */
cljs.core.odd_QMARK_ = (function cljs$core$odd_QMARK_(n){
return (!(cljs.core.even_QMARK_(n)));
});
/**
 * Takes a fn f and returns a fn that takes the same arguments as f,
 *   has the same effects, if any, and returns the opposite truth value.
 */
cljs.core.complement = (function cljs$core$complement(f){
return (function() {
var cljs$core$complement_$_fn_15788 = null;
var cljs$core$complement_$_fn_15788__0 = (function (){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});
var cljs$core$complement_$_fn_15788__1 = (function (x){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)));
});
var cljs$core$complement_$_fn_15788__2 = (function (x,y){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y)));
});
var cljs$core$complement_$_fn_15788__3 = (function() { 
var G__15789__delegate = function (x,y,zs){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,x,y,zs));
};
var G__15789 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__15790__i = 0, G__15790__a = new Array(arguments.length -  2);
while (G__15790__i < G__15790__a.length) {G__15790__a[G__15790__i] = arguments[G__15790__i + 2]; ++G__15790__i;}
  zs = new cljs.core.IndexedSeq(G__15790__a,0,null);
} 
return G__15789__delegate.call(this,x,y,zs);};
G__15789.cljs$lang$maxFixedArity = 2;
G__15789.cljs$lang$applyTo = (function (arglist__15791){
var x = cljs.core.first(arglist__15791);
arglist__15791 = cljs.core.next(arglist__15791);
var y = cljs.core.first(arglist__15791);
var zs = cljs.core.rest(arglist__15791);
return G__15789__delegate(x,y,zs);
});
G__15789.cljs$core$IFn$_invoke$arity$variadic = G__15789__delegate;
return G__15789;
})()
;
cljs$core$complement_$_fn_15788 = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return cljs$core$complement_$_fn_15788__0.call(this);
case 1:
return cljs$core$complement_$_fn_15788__1.call(this,x);
case 2:
return cljs$core$complement_$_fn_15788__2.call(this,x,y);
default:
var G__15792 = null;
if (arguments.length > 2) {
var G__15793__i = 0, G__15793__a = new Array(arguments.length -  2);
while (G__15793__i < G__15793__a.length) {G__15793__a[G__15793__i] = arguments[G__15793__i + 2]; ++G__15793__i;}
G__15792 = new cljs.core.IndexedSeq(G__15793__a,0,null);
}
return cljs$core$complement_$_fn_15788__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__15792);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$complement_$_fn_15788.cljs$lang$maxFixedArity = 2;
cljs$core$complement_$_fn_15788.cljs$lang$applyTo = cljs$core$complement_$_fn_15788__3.cljs$lang$applyTo;
cljs$core$complement_$_fn_15788.cljs$core$IFn$_invoke$arity$0 = cljs$core$complement_$_fn_15788__0;
cljs$core$complement_$_fn_15788.cljs$core$IFn$_invoke$arity$1 = cljs$core$complement_$_fn_15788__1;
cljs$core$complement_$_fn_15788.cljs$core$IFn$_invoke$arity$2 = cljs$core$complement_$_fn_15788__2;
cljs$core$complement_$_fn_15788.cljs$core$IFn$_invoke$arity$variadic = cljs$core$complement_$_fn_15788__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$complement_$_fn_15788;
})()
});
/**
 * Returns a function that takes any number of arguments and returns x.
 */
cljs.core.constantly = (function cljs$core$constantly(x){
return (function() { 
var cljs$core$constantly_$_fn_15794__delegate = function (args){
return x;
};
var cljs$core$constantly_$_fn_15794 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__15795__i = 0, G__15795__a = new Array(arguments.length -  0);
while (G__15795__i < G__15795__a.length) {G__15795__a[G__15795__i] = arguments[G__15795__i + 0]; ++G__15795__i;}
  args = new cljs.core.IndexedSeq(G__15795__a,0,null);
} 
return cljs$core$constantly_$_fn_15794__delegate.call(this,args);};
cljs$core$constantly_$_fn_15794.cljs$lang$maxFixedArity = 0;
cljs$core$constantly_$_fn_15794.cljs$lang$applyTo = (function (arglist__15796){
var args = cljs.core.seq(arglist__15796);
return cljs$core$constantly_$_fn_15794__delegate(args);
});
cljs$core$constantly_$_fn_15794.cljs$core$IFn$_invoke$arity$variadic = cljs$core$constantly_$_fn_15794__delegate;
return cljs$core$constantly_$_fn_15794;
})()
;
});
/**
 * Takes a set of functions and returns a fn that is the composition
 *   of those fns.  The returned fn takes a variable number of args,
 *   applies the rightmost of fns to the args, the next
 *   fn (right-to-left) to the result, etc.
 */
cljs.core.comp = (function cljs$core$comp(var_args){
var G__15802 = arguments.length;
switch (G__15802) {
case 0:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15829 = arguments.length;
var i__10876__auto___15830 = (0);
while(true){
if((i__10876__auto___15830 < len__10875__auto___15829)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15830]));

var G__15831 = (i__10876__auto___15830 + (1));
i__10876__auto___15830 = G__15831;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((3) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((3)),(0),null)):null);
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10905__auto__);

}
});

(cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15803(){
return cljs.core.identity;
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15804(f){
return f;
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15805(f,g){
return (function() {
var cljs$core$fn_15805_$_fn_15806 = null;
var cljs$core$fn_15805_$_fn_15806__0 = (function (){
var G__15807 = (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15807) : f.call(null,G__15807));
});
var cljs$core$fn_15805_$_fn_15806__1 = (function (x){
var G__15808 = (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null,x));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15808) : f.call(null,G__15808));
});
var cljs$core$fn_15805_$_fn_15806__2 = (function (x,y){
var G__15809 = (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x,y) : g.call(null,x,y));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15809) : f.call(null,G__15809));
});
var cljs$core$fn_15805_$_fn_15806__3 = (function (x,y,z){
var G__15810 = (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x,y,z) : g.call(null,x,y,z));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15810) : f.call(null,G__15810));
});
var cljs$core$fn_15805_$_fn_15806__4 = (function() { 
var G__15832__delegate = function (x,y,z,args){
var G__15811 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15811) : f.call(null,G__15811));
};
var G__15832 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__15833__i = 0, G__15833__a = new Array(arguments.length -  3);
while (G__15833__i < G__15833__a.length) {G__15833__a[G__15833__i] = arguments[G__15833__i + 3]; ++G__15833__i;}
  args = new cljs.core.IndexedSeq(G__15833__a,0,null);
} 
return G__15832__delegate.call(this,x,y,z,args);};
G__15832.cljs$lang$maxFixedArity = 3;
G__15832.cljs$lang$applyTo = (function (arglist__15834){
var x = cljs.core.first(arglist__15834);
arglist__15834 = cljs.core.next(arglist__15834);
var y = cljs.core.first(arglist__15834);
arglist__15834 = cljs.core.next(arglist__15834);
var z = cljs.core.first(arglist__15834);
var args = cljs.core.rest(arglist__15834);
return G__15832__delegate(x,y,z,args);
});
G__15832.cljs$core$IFn$_invoke$arity$variadic = G__15832__delegate;
return G__15832;
})()
;
cljs$core$fn_15805_$_fn_15806 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_15805_$_fn_15806__0.call(this);
case 1:
return cljs$core$fn_15805_$_fn_15806__1.call(this,x);
case 2:
return cljs$core$fn_15805_$_fn_15806__2.call(this,x,y);
case 3:
return cljs$core$fn_15805_$_fn_15806__3.call(this,x,y,z);
default:
var G__15835 = null;
if (arguments.length > 3) {
var G__15836__i = 0, G__15836__a = new Array(arguments.length -  3);
while (G__15836__i < G__15836__a.length) {G__15836__a[G__15836__i] = arguments[G__15836__i + 3]; ++G__15836__i;}
G__15835 = new cljs.core.IndexedSeq(G__15836__a,0,null);
}
return cljs$core$fn_15805_$_fn_15806__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__15835);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15805_$_fn_15806.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15805_$_fn_15806.cljs$lang$applyTo = cljs$core$fn_15805_$_fn_15806__4.cljs$lang$applyTo;
cljs$core$fn_15805_$_fn_15806.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15805_$_fn_15806__0;
cljs$core$fn_15805_$_fn_15806.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15805_$_fn_15806__1;
cljs$core$fn_15805_$_fn_15806.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15805_$_fn_15806__2;
cljs$core$fn_15805_$_fn_15806.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15805_$_fn_15806__3;
cljs$core$fn_15805_$_fn_15806.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15805_$_fn_15806__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15805_$_fn_15806;
})()
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15812(f,g,h){
return (function() {
var cljs$core$fn_15812_$_fn_15813 = null;
var cljs$core$fn_15812_$_fn_15813__0 = (function (){
var G__15814 = (function (){var G__15815 = (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15815) : g.call(null,G__15815));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15814) : f.call(null,G__15814));
});
var cljs$core$fn_15812_$_fn_15813__1 = (function (x){
var G__15816 = (function (){var G__15817 = (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(x) : h.call(null,x));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15817) : g.call(null,G__15817));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15816) : f.call(null,G__15816));
});
var cljs$core$fn_15812_$_fn_15813__2 = (function (x,y){
var G__15818 = (function (){var G__15819 = (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(x,y) : h.call(null,x,y));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15819) : g.call(null,G__15819));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15818) : f.call(null,G__15818));
});
var cljs$core$fn_15812_$_fn_15813__3 = (function (x,y,z){
var G__15820 = (function (){var G__15821 = (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(x,y,z) : h.call(null,x,y,z));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15821) : g.call(null,G__15821));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15820) : f.call(null,G__15820));
});
var cljs$core$fn_15812_$_fn_15813__4 = (function() { 
var G__15837__delegate = function (x,y,z,args){
var G__15822 = (function (){var G__15823 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args);
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15823) : g.call(null,G__15823));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15822) : f.call(null,G__15822));
};
var G__15837 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__15838__i = 0, G__15838__a = new Array(arguments.length -  3);
while (G__15838__i < G__15838__a.length) {G__15838__a[G__15838__i] = arguments[G__15838__i + 3]; ++G__15838__i;}
  args = new cljs.core.IndexedSeq(G__15838__a,0,null);
} 
return G__15837__delegate.call(this,x,y,z,args);};
G__15837.cljs$lang$maxFixedArity = 3;
G__15837.cljs$lang$applyTo = (function (arglist__15839){
var x = cljs.core.first(arglist__15839);
arglist__15839 = cljs.core.next(arglist__15839);
var y = cljs.core.first(arglist__15839);
arglist__15839 = cljs.core.next(arglist__15839);
var z = cljs.core.first(arglist__15839);
var args = cljs.core.rest(arglist__15839);
return G__15837__delegate(x,y,z,args);
});
G__15837.cljs$core$IFn$_invoke$arity$variadic = G__15837__delegate;
return G__15837;
})()
;
cljs$core$fn_15812_$_fn_15813 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_15812_$_fn_15813__0.call(this);
case 1:
return cljs$core$fn_15812_$_fn_15813__1.call(this,x);
case 2:
return cljs$core$fn_15812_$_fn_15813__2.call(this,x,y);
case 3:
return cljs$core$fn_15812_$_fn_15813__3.call(this,x,y,z);
default:
var G__15840 = null;
if (arguments.length > 3) {
var G__15841__i = 0, G__15841__a = new Array(arguments.length -  3);
while (G__15841__i < G__15841__a.length) {G__15841__a[G__15841__i] = arguments[G__15841__i + 3]; ++G__15841__i;}
G__15840 = new cljs.core.IndexedSeq(G__15841__a,0,null);
}
return cljs$core$fn_15812_$_fn_15813__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__15840);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15812_$_fn_15813.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15812_$_fn_15813.cljs$lang$applyTo = cljs$core$fn_15812_$_fn_15813__4.cljs$lang$applyTo;
cljs$core$fn_15812_$_fn_15813.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15812_$_fn_15813__0;
cljs$core$fn_15812_$_fn_15813.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15812_$_fn_15813__1;
cljs$core$fn_15812_$_fn_15813.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15812_$_fn_15813__2;
cljs$core$fn_15812_$_fn_15813.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15812_$_fn_15813__3;
cljs$core$fn_15812_$_fn_15813.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15812_$_fn_15813__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15812_$_fn_15813;
})()
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15824(f1,f2,f3,fs){
var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1,f2,f3,fs));
return (function() { 
var cljs$core$fn_15824_$_fn_15825__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1),args);
var fs__$2 = cljs.core.next(fs__$1);
while(true){
if(fs__$2){
var G__15842 = (function (){var fexpr__15826 = cljs.core.first(fs__$2);
return (fexpr__15826.cljs$core$IFn$_invoke$arity$1 ? fexpr__15826.cljs$core$IFn$_invoke$arity$1(ret) : fexpr__15826.call(null,ret));
})();
var G__15843 = cljs.core.next(fs__$2);
ret = G__15842;
fs__$2 = G__15843;
continue;
} else {
return ret;
}
break;
}
};
var cljs$core$fn_15824_$_fn_15825 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__15844__i = 0, G__15844__a = new Array(arguments.length -  0);
while (G__15844__i < G__15844__a.length) {G__15844__a[G__15844__i] = arguments[G__15844__i + 0]; ++G__15844__i;}
  args = new cljs.core.IndexedSeq(G__15844__a,0,null);
} 
return cljs$core$fn_15824_$_fn_15825__delegate.call(this,args);};
cljs$core$fn_15824_$_fn_15825.cljs$lang$maxFixedArity = 0;
cljs$core$fn_15824_$_fn_15825.cljs$lang$applyTo = (function (arglist__15845){
var args = cljs.core.seq(arglist__15845);
return cljs$core$fn_15824_$_fn_15825__delegate(args);
});
cljs$core$fn_15824_$_fn_15825.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15824_$_fn_15825__delegate;
return cljs$core$fn_15824_$_fn_15825;
})()
;
}));

/** @this {Function} */
(cljs.core.comp.cljs$lang$applyTo = (function cljs$core$fn_15827(seq15798){
var G__15799 = cljs.core.first(seq15798);
var seq15798__$1 = cljs.core.next(seq15798);
var G__15800 = cljs.core.first(seq15798__$1);
var seq15798__$2 = cljs.core.next(seq15798__$1);
var G__15801 = cljs.core.first(seq15798__$2);
var seq15798__$3 = cljs.core.next(seq15798__$2);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15799,G__15800,G__15801,seq15798__$3);
}));

(cljs.core.comp.cljs$lang$maxFixedArity = (3));

/**
 * Takes a function f and fewer than the normal arguments to f, and
 *   returns a fn that takes a variable number of additional args. When
 *   called, the returned function calls f with args + additional args.
 */
cljs.core.partial = (function cljs$core$partial(var_args){
var G__15852 = arguments.length;
switch (G__15852) {
case 1:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___15864 = arguments.length;
var i__10876__auto___15865 = (0);
while(true){
if((i__10876__auto___15865 < len__10875__auto___15864)){
args_arr__10904__auto__.push((arguments[i__10876__auto___15865]));

var G__15866 = (i__10876__auto___15865 + (1));
i__10876__auto___15865 = G__15866;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((4) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((4)),(0),null)):null);
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10905__auto__);

}
});

(cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15853(f){
return f;
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15854(f,arg1){
return (function() {
var cljs$core$fn_15854_$_fn_15855 = null;
var cljs$core$fn_15854_$_fn_15855__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(arg1) : f.call(null,arg1));
});
var cljs$core$fn_15854_$_fn_15855__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,x) : f.call(null,arg1,x));
});
var cljs$core$fn_15854_$_fn_15855__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,x,y) : f.call(null,arg1,x,y));
});
var cljs$core$fn_15854_$_fn_15855__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,x,y,z) : f.call(null,arg1,x,y,z));
});
var cljs$core$fn_15854_$_fn_15855__4 = (function() { 
var G__15867__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,x,y,z,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
};
var G__15867 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__15868__i = 0, G__15868__a = new Array(arguments.length -  3);
while (G__15868__i < G__15868__a.length) {G__15868__a[G__15868__i] = arguments[G__15868__i + 3]; ++G__15868__i;}
  args = new cljs.core.IndexedSeq(G__15868__a,0,null);
} 
return G__15867__delegate.call(this,x,y,z,args);};
G__15867.cljs$lang$maxFixedArity = 3;
G__15867.cljs$lang$applyTo = (function (arglist__15869){
var x = cljs.core.first(arglist__15869);
arglist__15869 = cljs.core.next(arglist__15869);
var y = cljs.core.first(arglist__15869);
arglist__15869 = cljs.core.next(arglist__15869);
var z = cljs.core.first(arglist__15869);
var args = cljs.core.rest(arglist__15869);
return G__15867__delegate(x,y,z,args);
});
G__15867.cljs$core$IFn$_invoke$arity$variadic = G__15867__delegate;
return G__15867;
})()
;
cljs$core$fn_15854_$_fn_15855 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_15854_$_fn_15855__0.call(this);
case 1:
return cljs$core$fn_15854_$_fn_15855__1.call(this,x);
case 2:
return cljs$core$fn_15854_$_fn_15855__2.call(this,x,y);
case 3:
return cljs$core$fn_15854_$_fn_15855__3.call(this,x,y,z);
default:
var G__15870 = null;
if (arguments.length > 3) {
var G__15871__i = 0, G__15871__a = new Array(arguments.length -  3);
while (G__15871__i < G__15871__a.length) {G__15871__a[G__15871__i] = arguments[G__15871__i + 3]; ++G__15871__i;}
G__15870 = new cljs.core.IndexedSeq(G__15871__a,0,null);
}
return cljs$core$fn_15854_$_fn_15855__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__15870);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15854_$_fn_15855.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15854_$_fn_15855.cljs$lang$applyTo = cljs$core$fn_15854_$_fn_15855__4.cljs$lang$applyTo;
cljs$core$fn_15854_$_fn_15855.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15854_$_fn_15855__0;
cljs$core$fn_15854_$_fn_15855.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15854_$_fn_15855__1;
cljs$core$fn_15854_$_fn_15855.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15854_$_fn_15855__2;
cljs$core$fn_15854_$_fn_15855.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15854_$_fn_15855__3;
cljs$core$fn_15854_$_fn_15855.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15854_$_fn_15855__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15854_$_fn_15855;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15856(f,arg1,arg2){
return (function() {
var cljs$core$fn_15856_$_fn_15857 = null;
var cljs$core$fn_15856_$_fn_15857__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,arg2) : f.call(null,arg1,arg2));
});
var cljs$core$fn_15856_$_fn_15857__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,x) : f.call(null,arg1,arg2,x));
});
var cljs$core$fn_15856_$_fn_15857__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,x,y) : f.call(null,arg1,arg2,x,y));
});
var cljs$core$fn_15856_$_fn_15857__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,x,y,z) : f.call(null,arg1,arg2,x,y,z));
});
var cljs$core$fn_15856_$_fn_15857__4 = (function() { 
var G__15872__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,x,y,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([z,args], 0));
};
var G__15872 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__15873__i = 0, G__15873__a = new Array(arguments.length -  3);
while (G__15873__i < G__15873__a.length) {G__15873__a[G__15873__i] = arguments[G__15873__i + 3]; ++G__15873__i;}
  args = new cljs.core.IndexedSeq(G__15873__a,0,null);
} 
return G__15872__delegate.call(this,x,y,z,args);};
G__15872.cljs$lang$maxFixedArity = 3;
G__15872.cljs$lang$applyTo = (function (arglist__15874){
var x = cljs.core.first(arglist__15874);
arglist__15874 = cljs.core.next(arglist__15874);
var y = cljs.core.first(arglist__15874);
arglist__15874 = cljs.core.next(arglist__15874);
var z = cljs.core.first(arglist__15874);
var args = cljs.core.rest(arglist__15874);
return G__15872__delegate(x,y,z,args);
});
G__15872.cljs$core$IFn$_invoke$arity$variadic = G__15872__delegate;
return G__15872;
})()
;
cljs$core$fn_15856_$_fn_15857 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_15856_$_fn_15857__0.call(this);
case 1:
return cljs$core$fn_15856_$_fn_15857__1.call(this,x);
case 2:
return cljs$core$fn_15856_$_fn_15857__2.call(this,x,y);
case 3:
return cljs$core$fn_15856_$_fn_15857__3.call(this,x,y,z);
default:
var G__15875 = null;
if (arguments.length > 3) {
var G__15876__i = 0, G__15876__a = new Array(arguments.length -  3);
while (G__15876__i < G__15876__a.length) {G__15876__a[G__15876__i] = arguments[G__15876__i + 3]; ++G__15876__i;}
G__15875 = new cljs.core.IndexedSeq(G__15876__a,0,null);
}
return cljs$core$fn_15856_$_fn_15857__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__15875);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15856_$_fn_15857.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15856_$_fn_15857.cljs$lang$applyTo = cljs$core$fn_15856_$_fn_15857__4.cljs$lang$applyTo;
cljs$core$fn_15856_$_fn_15857.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15856_$_fn_15857__0;
cljs$core$fn_15856_$_fn_15857.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15856_$_fn_15857__1;
cljs$core$fn_15856_$_fn_15857.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15856_$_fn_15857__2;
cljs$core$fn_15856_$_fn_15857.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15856_$_fn_15857__3;
cljs$core$fn_15856_$_fn_15857.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15856_$_fn_15857__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15856_$_fn_15857;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15858(f,arg1,arg2,arg3){
return (function() {
var cljs$core$fn_15858_$_fn_15859 = null;
var cljs$core$fn_15858_$_fn_15859__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,arg3) : f.call(null,arg1,arg2,arg3));
});
var cljs$core$fn_15858_$_fn_15859__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,arg3,x) : f.call(null,arg1,arg2,arg3,x));
});
var cljs$core$fn_15858_$_fn_15859__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,arg3,x,y) : f.call(null,arg1,arg2,arg3,x,y));
});
var cljs$core$fn_15858_$_fn_15859__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(arg1,arg2,arg3,x,y,z) : f.call(null,arg1,arg2,arg3,x,y,z));
});
var cljs$core$fn_15858_$_fn_15859__4 = (function() { 
var G__15877__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3,x,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([y,z,args], 0));
};
var G__15877 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__15878__i = 0, G__15878__a = new Array(arguments.length -  3);
while (G__15878__i < G__15878__a.length) {G__15878__a[G__15878__i] = arguments[G__15878__i + 3]; ++G__15878__i;}
  args = new cljs.core.IndexedSeq(G__15878__a,0,null);
} 
return G__15877__delegate.call(this,x,y,z,args);};
G__15877.cljs$lang$maxFixedArity = 3;
G__15877.cljs$lang$applyTo = (function (arglist__15879){
var x = cljs.core.first(arglist__15879);
arglist__15879 = cljs.core.next(arglist__15879);
var y = cljs.core.first(arglist__15879);
arglist__15879 = cljs.core.next(arglist__15879);
var z = cljs.core.first(arglist__15879);
var args = cljs.core.rest(arglist__15879);
return G__15877__delegate(x,y,z,args);
});
G__15877.cljs$core$IFn$_invoke$arity$variadic = G__15877__delegate;
return G__15877;
})()
;
cljs$core$fn_15858_$_fn_15859 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_15858_$_fn_15859__0.call(this);
case 1:
return cljs$core$fn_15858_$_fn_15859__1.call(this,x);
case 2:
return cljs$core$fn_15858_$_fn_15859__2.call(this,x,y);
case 3:
return cljs$core$fn_15858_$_fn_15859__3.call(this,x,y,z);
default:
var G__15880 = null;
if (arguments.length > 3) {
var G__15881__i = 0, G__15881__a = new Array(arguments.length -  3);
while (G__15881__i < G__15881__a.length) {G__15881__a[G__15881__i] = arguments[G__15881__i + 3]; ++G__15881__i;}
G__15880 = new cljs.core.IndexedSeq(G__15881__a,0,null);
}
return cljs$core$fn_15858_$_fn_15859__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__15880);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15858_$_fn_15859.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15858_$_fn_15859.cljs$lang$applyTo = cljs$core$fn_15858_$_fn_15859__4.cljs$lang$applyTo;
cljs$core$fn_15858_$_fn_15859.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15858_$_fn_15859__0;
cljs$core$fn_15858_$_fn_15859.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15858_$_fn_15859__1;
cljs$core$fn_15858_$_fn_15859.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15858_$_fn_15859__2;
cljs$core$fn_15858_$_fn_15859.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15858_$_fn_15859__3;
cljs$core$fn_15858_$_fn_15859.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15858_$_fn_15859__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15858_$_fn_15859;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15860(f,arg1,arg2,arg3,more){
return (function() { 
var cljs$core$fn_15860_$_fn_15861__delegate = function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,arg1,arg2,arg3,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more,args));
};
var cljs$core$fn_15860_$_fn_15861 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__15882__i = 0, G__15882__a = new Array(arguments.length -  0);
while (G__15882__i < G__15882__a.length) {G__15882__a[G__15882__i] = arguments[G__15882__i + 0]; ++G__15882__i;}
  args = new cljs.core.IndexedSeq(G__15882__a,0,null);
} 
return cljs$core$fn_15860_$_fn_15861__delegate.call(this,args);};
cljs$core$fn_15860_$_fn_15861.cljs$lang$maxFixedArity = 0;
cljs$core$fn_15860_$_fn_15861.cljs$lang$applyTo = (function (arglist__15883){
var args = cljs.core.seq(arglist__15883);
return cljs$core$fn_15860_$_fn_15861__delegate(args);
});
cljs$core$fn_15860_$_fn_15861.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15860_$_fn_15861__delegate;
return cljs$core$fn_15860_$_fn_15861;
})()
;
}));

/** @this {Function} */
(cljs.core.partial.cljs$lang$applyTo = (function cljs$core$fn_15862(seq15847){
var G__15848 = cljs.core.first(seq15847);
var seq15847__$1 = cljs.core.next(seq15847);
var G__15849 = cljs.core.first(seq15847__$1);
var seq15847__$2 = cljs.core.next(seq15847__$1);
var G__15850 = cljs.core.first(seq15847__$2);
var seq15847__$3 = cljs.core.next(seq15847__$2);
var G__15851 = cljs.core.first(seq15847__$3);
var seq15847__$4 = cljs.core.next(seq15847__$3);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15848,G__15849,G__15850,G__15851,seq15847__$4);
}));

(cljs.core.partial.cljs$lang$maxFixedArity = (4));

/**
 * Takes a function f, and returns a function that calls f, replacing
 *   a nil first argument to f with the supplied value x. Higher arity
 *   versions can replace arguments in the second and third
 *   positions (y, z). Note that the function f can take any number of
 *   arguments, not just the one(s) being nil-patched.
 */
cljs.core.fnil = (function cljs$core$fnil(var_args){
var G__15885 = arguments.length;
switch (G__15885) {
case 2:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15886(f,x){
return (function() {
var cljs$core$fn_15886_$_fn_15887 = null;
var cljs$core$fn_15886_$_fn_15887__1 = (function (a){
var G__15888 = (((a == null))?x:a);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15888) : f.call(null,G__15888));
});
var cljs$core$fn_15886_$_fn_15887__2 = (function (a,b){
var G__15889 = (((a == null))?x:a);
var G__15890 = b;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15889,G__15890) : f.call(null,G__15889,G__15890));
});
var cljs$core$fn_15886_$_fn_15887__3 = (function (a,b,c){
var G__15891 = (((a == null))?x:a);
var G__15892 = b;
var G__15893 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15891,G__15892,G__15893) : f.call(null,G__15891,G__15892,G__15893));
});
var cljs$core$fn_15886_$_fn_15887__4 = (function() { 
var G__15909__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),b,c,ds);
};
var G__15909 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__15910__i = 0, G__15910__a = new Array(arguments.length -  3);
while (G__15910__i < G__15910__a.length) {G__15910__a[G__15910__i] = arguments[G__15910__i + 3]; ++G__15910__i;}
  ds = new cljs.core.IndexedSeq(G__15910__a,0,null);
} 
return G__15909__delegate.call(this,a,b,c,ds);};
G__15909.cljs$lang$maxFixedArity = 3;
G__15909.cljs$lang$applyTo = (function (arglist__15911){
var a = cljs.core.first(arglist__15911);
arglist__15911 = cljs.core.next(arglist__15911);
var b = cljs.core.first(arglist__15911);
arglist__15911 = cljs.core.next(arglist__15911);
var c = cljs.core.first(arglist__15911);
var ds = cljs.core.rest(arglist__15911);
return G__15909__delegate(a,b,c,ds);
});
G__15909.cljs$core$IFn$_invoke$arity$variadic = G__15909__delegate;
return G__15909;
})()
;
cljs$core$fn_15886_$_fn_15887 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 1:
return cljs$core$fn_15886_$_fn_15887__1.call(this,a);
case 2:
return cljs$core$fn_15886_$_fn_15887__2.call(this,a,b);
case 3:
return cljs$core$fn_15886_$_fn_15887__3.call(this,a,b,c);
default:
var G__15912 = null;
if (arguments.length > 3) {
var G__15913__i = 0, G__15913__a = new Array(arguments.length -  3);
while (G__15913__i < G__15913__a.length) {G__15913__a[G__15913__i] = arguments[G__15913__i + 3]; ++G__15913__i;}
G__15912 = new cljs.core.IndexedSeq(G__15913__a,0,null);
}
return cljs$core$fn_15886_$_fn_15887__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__15912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15886_$_fn_15887.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15886_$_fn_15887.cljs$lang$applyTo = cljs$core$fn_15886_$_fn_15887__4.cljs$lang$applyTo;
cljs$core$fn_15886_$_fn_15887.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15886_$_fn_15887__1;
cljs$core$fn_15886_$_fn_15887.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15886_$_fn_15887__2;
cljs$core$fn_15886_$_fn_15887.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15886_$_fn_15887__3;
cljs$core$fn_15886_$_fn_15887.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15886_$_fn_15887__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15886_$_fn_15887;
})()
}));

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15894(f,x,y){
return (function() {
var cljs$core$fn_15894_$_fn_15895 = null;
var cljs$core$fn_15894_$_fn_15895__2 = (function (a,b){
var G__15896 = (((a == null))?x:a);
var G__15897 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15896,G__15897) : f.call(null,G__15896,G__15897));
});
var cljs$core$fn_15894_$_fn_15895__3 = (function (a,b,c){
var G__15898 = (((a == null))?x:a);
var G__15899 = (((b == null))?y:b);
var G__15900 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15898,G__15899,G__15900) : f.call(null,G__15898,G__15899,G__15900));
});
var cljs$core$fn_15894_$_fn_15895__4 = (function() { 
var G__15914__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),c,ds);
};
var G__15914 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__15915__i = 0, G__15915__a = new Array(arguments.length -  3);
while (G__15915__i < G__15915__a.length) {G__15915__a[G__15915__i] = arguments[G__15915__i + 3]; ++G__15915__i;}
  ds = new cljs.core.IndexedSeq(G__15915__a,0,null);
} 
return G__15914__delegate.call(this,a,b,c,ds);};
G__15914.cljs$lang$maxFixedArity = 3;
G__15914.cljs$lang$applyTo = (function (arglist__15916){
var a = cljs.core.first(arglist__15916);
arglist__15916 = cljs.core.next(arglist__15916);
var b = cljs.core.first(arglist__15916);
arglist__15916 = cljs.core.next(arglist__15916);
var c = cljs.core.first(arglist__15916);
var ds = cljs.core.rest(arglist__15916);
return G__15914__delegate(a,b,c,ds);
});
G__15914.cljs$core$IFn$_invoke$arity$variadic = G__15914__delegate;
return G__15914;
})()
;
cljs$core$fn_15894_$_fn_15895 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return cljs$core$fn_15894_$_fn_15895__2.call(this,a,b);
case 3:
return cljs$core$fn_15894_$_fn_15895__3.call(this,a,b,c);
default:
var G__15917 = null;
if (arguments.length > 3) {
var G__15918__i = 0, G__15918__a = new Array(arguments.length -  3);
while (G__15918__i < G__15918__a.length) {G__15918__a[G__15918__i] = arguments[G__15918__i + 3]; ++G__15918__i;}
G__15917 = new cljs.core.IndexedSeq(G__15918__a,0,null);
}
return cljs$core$fn_15894_$_fn_15895__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__15917);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15894_$_fn_15895.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15894_$_fn_15895.cljs$lang$applyTo = cljs$core$fn_15894_$_fn_15895__4.cljs$lang$applyTo;
cljs$core$fn_15894_$_fn_15895.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15894_$_fn_15895__2;
cljs$core$fn_15894_$_fn_15895.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15894_$_fn_15895__3;
cljs$core$fn_15894_$_fn_15895.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15894_$_fn_15895__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15894_$_fn_15895;
})()
}));

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15901(f,x,y,z){
return (function() {
var cljs$core$fn_15901_$_fn_15902 = null;
var cljs$core$fn_15901_$_fn_15902__2 = (function (a,b){
var G__15903 = (((a == null))?x:a);
var G__15904 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15903,G__15904) : f.call(null,G__15903,G__15904));
});
var cljs$core$fn_15901_$_fn_15902__3 = (function (a,b,c){
var G__15905 = (((a == null))?x:a);
var G__15906 = (((b == null))?y:b);
var G__15907 = (((c == null))?z:c);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15905,G__15906,G__15907) : f.call(null,G__15905,G__15906,G__15907));
});
var cljs$core$fn_15901_$_fn_15902__4 = (function() { 
var G__15919__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c),ds);
};
var G__15919 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__15920__i = 0, G__15920__a = new Array(arguments.length -  3);
while (G__15920__i < G__15920__a.length) {G__15920__a[G__15920__i] = arguments[G__15920__i + 3]; ++G__15920__i;}
  ds = new cljs.core.IndexedSeq(G__15920__a,0,null);
} 
return G__15919__delegate.call(this,a,b,c,ds);};
G__15919.cljs$lang$maxFixedArity = 3;
G__15919.cljs$lang$applyTo = (function (arglist__15921){
var a = cljs.core.first(arglist__15921);
arglist__15921 = cljs.core.next(arglist__15921);
var b = cljs.core.first(arglist__15921);
arglist__15921 = cljs.core.next(arglist__15921);
var c = cljs.core.first(arglist__15921);
var ds = cljs.core.rest(arglist__15921);
return G__15919__delegate(a,b,c,ds);
});
G__15919.cljs$core$IFn$_invoke$arity$variadic = G__15919__delegate;
return G__15919;
})()
;
cljs$core$fn_15901_$_fn_15902 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return cljs$core$fn_15901_$_fn_15902__2.call(this,a,b);
case 3:
return cljs$core$fn_15901_$_fn_15902__3.call(this,a,b,c);
default:
var G__15922 = null;
if (arguments.length > 3) {
var G__15923__i = 0, G__15923__a = new Array(arguments.length -  3);
while (G__15923__i < G__15923__a.length) {G__15923__a[G__15923__i] = arguments[G__15923__i + 3]; ++G__15923__i;}
G__15922 = new cljs.core.IndexedSeq(G__15923__a,0,null);
}
return cljs$core$fn_15901_$_fn_15902__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__15922);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15901_$_fn_15902.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15901_$_fn_15902.cljs$lang$applyTo = cljs$core$fn_15901_$_fn_15902__4.cljs$lang$applyTo;
cljs$core$fn_15901_$_fn_15902.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15901_$_fn_15902__2;
cljs$core$fn_15901_$_fn_15902.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15901_$_fn_15902__3;
cljs$core$fn_15901_$_fn_15902.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15901_$_fn_15902__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15901_$_fn_15902;
})()
}));

(cljs.core.fnil.cljs$lang$maxFixedArity = 4);

/**
 * Returns a lazy sequence consisting of the result of applying f to 0
 *   and the first item of coll, followed by applying f to 1 and the second
 *   item in coll, etc, until coll is exhausted. Thus function f should
 *   accept 2 arguments, index and item. Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.map_indexed = (function cljs$core$map_indexed(var_args){
var G__15925 = arguments.length;
switch (G__15925) {
case 1:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15926(f){
return (function cljs$core$fn_15926_$_fn_15927(rf){
var i = cljs.core.volatile_BANG_((-1));
return (function() {
var cljs$core$fn_15926_$_fn_15927_$_fn_15928 = null;
var cljs$core$fn_15926_$_fn_15927_$_fn_15928__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_15926_$_fn_15927_$_fn_15928__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_15926_$_fn_15927_$_fn_15928__2 = (function (result,input){
var G__15929 = result;
var G__15930 = (function (){var G__15931 = i.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(i.cljs$core$IDeref$_deref$arity$1(null) + (1)));
var G__15932 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15931,G__15932) : f.call(null,G__15931,G__15932));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__15929,G__15930) : rf.call(null,G__15929,G__15930));
});
cljs$core$fn_15926_$_fn_15927_$_fn_15928 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_15926_$_fn_15927_$_fn_15928__0.call(this);
case 1:
return cljs$core$fn_15926_$_fn_15927_$_fn_15928__1.call(this,result);
case 2:
return cljs$core$fn_15926_$_fn_15927_$_fn_15928__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15926_$_fn_15927_$_fn_15928.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15926_$_fn_15927_$_fn_15928__0;
cljs$core$fn_15926_$_fn_15927_$_fn_15928.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15926_$_fn_15927_$_fn_15928__1;
cljs$core$fn_15926_$_fn_15927_$_fn_15928.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15926_$_fn_15927_$_fn_15928__2;
return cljs$core$fn_15926_$_fn_15927_$_fn_15928;
})()
});
}));

(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15933(f,coll){
var mapi = (function cljs$core$fn_15933_$_mapi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15933_$_mapi_$_fn_15939(){
var temp__5720__auto__ = cljs.core.seq(coll__$1);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__10634__auto___15945 = size;
var i_15946 = (0);
while(true){
if((i_15946 < n__10634__auto___15945)){
cljs.core.chunk_append(b,(function (){var G__15940 = (idx + i_15946);
var G__15941 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_15946);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15940,G__15941) : f.call(null,G__15940,G__15941));
})());

var G__15947 = (i_15946 + (1));
i_15946 = G__15947;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$fn_15933_$_mapi((idx + size),cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__15942 = idx;
var G__15943 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15942,G__15943) : f.call(null,G__15942,G__15943));
})(),cljs$core$fn_15933_$_mapi((idx + (1)),cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
return mapi((0),coll);
}));

(cljs.core.map_indexed.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the non-nil results of (f item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a transducer when no collection is provided.
 */
cljs.core.keep = (function cljs$core$keep(var_args){
var G__15949 = arguments.length;
switch (G__15949) {
case 1:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15950(f){
return (function cljs$core$fn_15950_$_fn_15951(rf){
return (function() {
var cljs$core$fn_15950_$_fn_15951_$_fn_15952 = null;
var cljs$core$fn_15950_$_fn_15951_$_fn_15952__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_15950_$_fn_15951_$_fn_15952__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_15950_$_fn_15951_$_fn_15952__2 = (function (result,input){
var v = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
cljs$core$fn_15950_$_fn_15951_$_fn_15952 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_15950_$_fn_15951_$_fn_15952__0.call(this);
case 1:
return cljs$core$fn_15950_$_fn_15951_$_fn_15952__1.call(this,result);
case 2:
return cljs$core$fn_15950_$_fn_15951_$_fn_15952__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15950_$_fn_15951_$_fn_15952.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15950_$_fn_15951_$_fn_15952__0;
cljs$core$fn_15950_$_fn_15951_$_fn_15952.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15950_$_fn_15951_$_fn_15952__1;
cljs$core$fn_15950_$_fn_15951_$_fn_15952.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15950_$_fn_15951_$_fn_15952__2;
return cljs$core$fn_15950_$_fn_15951_$_fn_15952;
})()
});
}));

(cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15953(f,coll){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15953_$_fn_15954(){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__10634__auto___15958 = size;
var i_15959 = (0);
while(true){
if((i_15959 < n__10634__auto___15958)){
var x_15960 = (function (){var G__15955 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_15959);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15955) : f.call(null,G__15955));
})();
if((x_15960 == null)){
} else {
cljs.core.chunk_append(b,x_15960);
}

var G__15961 = (i_15959 + (1));
i_15959 = G__15961;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__15956 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15956) : f.call(null,G__15956));
})();
if((x == null)){
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.keep.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IWatchable}
 * @implements {cljs.core.IAtom}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Atom = (function (state,meta,validator,watches){
this.state = state;
this.meta = meta;
this.validator = validator;
this.watches = watches;
this.cljs$lang$protocol_mask$partition1$ = 16386;
this.cljs$lang$protocol_mask$partition0$ = 6455296;
});
(cljs.core.Atom.prototype.equiv = (function cljs$core$fn_15962(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15963(o,other){
var self__ = this;
var o__$1 = this;
return (o__$1 === other);
}));

(cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = (function cljs$core$fn_15964(_){
var self__ = this;
var ___$1 = this;
return self__.state;
}));

(cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15965(_){
var self__ = this;
var ___$1 = this;
return self__.meta;
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function cljs$core$fn_15966(this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
var seq__15967 = cljs.core.seq(self__.watches);
var chunk__15968 = null;
var count__15969 = (0);
var i__15970 = (0);
while(true){
if((i__15970 < count__15969)){
var vec__15977 = chunk__15968.cljs$core$IIndexed$_nth$arity$2(null,i__15970);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15977,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15977,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));


var G__15988 = seq__15967;
var G__15989 = chunk__15968;
var G__15990 = count__15969;
var G__15991 = (i__15970 + (1));
seq__15967 = G__15988;
chunk__15968 = G__15989;
count__15969 = G__15990;
i__15970 = G__15991;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__15967);
if(temp__5720__auto__){
var seq__15967__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15967__$1)){
var c__10518__auto__ = cljs.core.chunk_first(seq__15967__$1);
var G__15992 = cljs.core.chunk_rest(seq__15967__$1);
var G__15993 = c__10518__auto__;
var G__15994 = cljs.core.count(c__10518__auto__);
var G__15995 = (0);
seq__15967 = G__15992;
chunk__15968 = G__15993;
count__15969 = G__15994;
i__15970 = G__15995;
continue;
} else {
var vec__15980 = cljs.core.first(seq__15967__$1);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15980,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15980,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));


var G__15996 = cljs.core.next(seq__15967__$1);
var G__15997 = null;
var G__15998 = (0);
var G__15999 = (0);
seq__15967 = G__15996;
chunk__15968 = G__15997;
count__15969 = G__15998;
i__15970 = G__15999;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function cljs$core$fn_15983(this$,key,f){
var self__ = this;
var this$__$1 = this;
(this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches,key,f));

return this$__$1;
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function cljs$core$fn_15984(this$,key){
var self__ = this;
var this$__$1 = this;
return (this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches,key));
}));

(cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15985(this$){
var self__ = this;
var this$__$1 = this;
return goog.getUid(this$__$1);
}));

(cljs.core.Atom.getBasis = (function cljs$core$fn_15986(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"validator","validator",-325659154,null),new cljs.core.Symbol(null,"watches","watches",1367433992,null)], null);
}));

(cljs.core.Atom.cljs$lang$type = true);

(cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom");

(cljs.core.Atom.cljs$lang$ctorPrWriter = (function cljs$core$fn_15987(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/Atom");
}));

/**
 * Positional factory function for cljs.core/Atom.
 */
cljs.core.__GT_Atom = (function cljs$core$__GT_Atom(state,meta,validator,watches){
return (new cljs.core.Atom(state,meta,validator,watches));
});

/**
 * Creates and returns an Atom with an initial value of x and zero or
 *   more options (in any order):
 * 
 *   :meta metadata-map
 * 
 *   :validator validate-fn
 * 
 *   If metadata-map is supplied, it will become the metadata on the
 *   atom. validate-fn must be nil or a side-effect-free fn of one
 *   argument, which will be passed the intended new state on any state
 *   change. If the new state is unacceptable, the validate-fn should
 *   return false or throw an Error.  If either of these error conditions
 *   occur, then the value of the atom will not change.
 */
cljs.core.atom = (function cljs$core$atom(var_args){
var G__16003 = arguments.length;
switch (G__16003) {
case 1:
return cljs.core.atom.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___16010 = arguments.length;
var i__10876__auto___16011 = (0);
while(true){
if((i__10876__auto___16011 < len__10875__auto___16010)){
args_arr__10904__auto__.push((arguments[i__10876__auto___16011]));

var G__16012 = (i__10876__auto___16011 + (1));
i__10876__auto___16011 = G__16012;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((1) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((1)),(0),null)):null);
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10905__auto__);

}
});

(cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16004(x){
return (new cljs.core.Atom(x,null,null,null));
}));

(cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16006(x,p__16005){
var map__16007 = p__16005;
var map__16007__$1 = cljs.core.__destructure_map(map__16007);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16007__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16007__$1,new cljs.core.Keyword(null,"validator","validator",-1966190681));
return (new cljs.core.Atom(x,meta,validator,null));
}));

/** @this {Function} */
(cljs.core.atom.cljs$lang$applyTo = (function cljs$core$fn_16008(seq16001){
var G__16002 = cljs.core.first(seq16001);
var seq16001__$1 = cljs.core.next(seq16001);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16002,seq16001__$1);
}));

(cljs.core.atom.cljs$lang$maxFixedArity = (1));

/**
 * Sets the value of atom to newval without regard for the
 *   current value. Returns new-value.
 */
cljs.core.reset_BANG_ = (function cljs$core$reset_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null,new_value)))){
} else {
throw (new Error("Validator rejected reference state"));
}
}

var old_value = a.state;
(a.state = new_value);

if((a.watches == null)){
} else {
a.cljs$core$IWatchable$_notify_watches$arity$3(null,old_value,new_value);
}

return new_value;
} else {
return cljs.core._reset_BANG_(a,new_value);
}
});
/**
 * Sets the value of atom to newval. Returns [old new], the value of the
 * atom before and after the reset.
 */
cljs.core.reset_vals_BANG_ = (function cljs$core$reset_vals_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null,new_value)))){
} else {
throw (new Error("Validator rejected reference state"));
}
}

var old_value = a.state;
(a.state = new_value);

if((a.watches == null)){
} else {
a.cljs$core$IWatchable$_notify_watches$arity$3(null,old_value,new_value);
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_value,new_value], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._reset_BANG_(a,new_value)], null);
}
});
/**
 * Atomically swaps the value of atom to be:
 *   (apply f current-value-of-atom args). Note that f may be called
 *   multiple times, and thus should be free of side effects.  Returns
 *   the value that was swapped in.
 */
cljs.core.swap_BANG_ = (function cljs$core$swap_BANG_(var_args){
var G__16019 = arguments.length;
switch (G__16019) {
case 2:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___16032 = arguments.length;
var i__10876__auto___16033 = (0);
while(true){
if((i__10876__auto___16033 < len__10875__auto___16032)){
args_arr__10904__auto__.push((arguments[i__10876__auto___16033]));

var G__16034 = (i__10876__auto___16033 + (1));
i__10876__auto___16033 = G__16034;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((4) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((4)),(0),null)):null);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10905__auto__);

}
});

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16020(a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__16021 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16021) : f.call(null,G__16021));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16022(a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__16023 = a.state;
var G__16024 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16023,G__16024) : f.call(null,G__16023,G__16024));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16025(a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__16026 = a.state;
var G__16027 = x;
var G__16028 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16026,G__16027,G__16028) : f.call(null,G__16026,G__16027,G__16028));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16029(a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more);
}
}));

/** @this {Function} */
(cljs.core.swap_BANG_.cljs$lang$applyTo = (function cljs$core$fn_16030(seq16014){
var G__16015 = cljs.core.first(seq16014);
var seq16014__$1 = cljs.core.next(seq16014);
var G__16016 = cljs.core.first(seq16014__$1);
var seq16014__$2 = cljs.core.next(seq16014__$1);
var G__16017 = cljs.core.first(seq16014__$2);
var seq16014__$3 = cljs.core.next(seq16014__$2);
var G__16018 = cljs.core.first(seq16014__$3);
var seq16014__$4 = cljs.core.next(seq16014__$3);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16015,G__16016,G__16017,G__16018,seq16014__$4);
}));

(cljs.core.swap_BANG_.cljs$lang$maxFixedArity = (4));

/**
 * Atomically swaps the value of atom to be:
 *   (apply f current-value-of-atom args). Note that f may be called
 *   multiple times, and thus should be free of side effects.
 *   Returns [old new], the value of the atom before and after the swap.
 */
cljs.core.swap_vals_BANG_ = (function cljs$core$swap_vals_BANG_(var_args){
var G__16041 = arguments.length;
switch (G__16041) {
case 2:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___16054 = arguments.length;
var i__10876__auto___16055 = (0);
while(true){
if((i__10876__auto___16055 < len__10875__auto___16054)){
args_arr__10904__auto__.push((arguments[i__10876__auto___16055]));

var G__16056 = (i__10876__auto___16055 + (1));
i__10876__auto___16055 = G__16056;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((4) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((4)),(0),null)):null);
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10905__auto__);

}
});

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16042(a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_vals_BANG_(a,(function (){var G__16043 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16043) : f.call(null,G__16043));
})());
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f)], null);
}
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16044(a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_vals_BANG_(a,(function (){var G__16045 = a.state;
var G__16046 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16045,G__16046) : f.call(null,G__16045,G__16046));
})());
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x)], null);
}
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16047(a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_vals_BANG_(a,(function (){var G__16048 = a.state;
var G__16049 = x;
var G__16050 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16048,G__16049,G__16050) : f.call(null,G__16048,G__16049,G__16050));
})());
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y)], null);
}
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16051(a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_vals_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more)], null);
}
}));

/** @this {Function} */
(cljs.core.swap_vals_BANG_.cljs$lang$applyTo = (function cljs$core$fn_16052(seq16036){
var G__16037 = cljs.core.first(seq16036);
var seq16036__$1 = cljs.core.next(seq16036);
var G__16038 = cljs.core.first(seq16036__$1);
var seq16036__$2 = cljs.core.next(seq16036__$1);
var G__16039 = cljs.core.first(seq16036__$2);
var seq16036__$3 = cljs.core.next(seq16036__$2);
var G__16040 = cljs.core.first(seq16036__$3);
var seq16036__$4 = cljs.core.next(seq16036__$3);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16037,G__16038,G__16039,G__16040,seq16036__$4);
}));

(cljs.core.swap_vals_BANG_.cljs$lang$maxFixedArity = (4));

/**
 * Atomically sets the value of atom to newval if and only if the
 *   current value of the atom is equal to oldval. Returns true if
 *   set happened, else false.
 */
cljs.core.compare_and_set_BANG_ = (function cljs$core$compare_and_set_BANG_(a,oldval,newval){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null),oldval)){
cljs.core.reset_BANG_(a,newval);

return true;
} else {
return false;
}
});
/**
 * Sets the validator-fn for an atom. validator-fn must be nil or a
 *   side-effect-free fn of one argument, which will be passed the intended
 *   new state on any state change. If the new state is unacceptable, the
 *   validator-fn should return false or throw an Error. If the current state
 *   is not acceptable to the new validator, an Error will be thrown and the
 *   validator will not be changed.
 */
cljs.core.set_validator_BANG_ = (function cljs$core$set_validator_BANG_(iref,val){
if((((!((val == null)))) && (cljs.core.not((function (){var G__16057 = cljs.core._deref(iref);
return (val.cljs$core$IFn$_invoke$arity$1 ? val.cljs$core$IFn$_invoke$arity$1(G__16057) : val.call(null,G__16057));
})())))){
throw (new Error("Validator rejected reference state"));
} else {
}

return (iref.validator = val);
});
/**
 * Gets the validator-fn for a var/ref/agent/atom.
 */
cljs.core.get_validator = (function cljs$core$get_validator(iref){
return iref.validator;
});

/**
* @constructor
 * @implements {cljs.core.IVolatile}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Volatile = (function (state){
this.state = state;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Volatile.prototype.cljs$core$IVolatile$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = (function cljs$core$fn_16058(_,new_state){
var self__ = this;
var ___$1 = this;
return (self__.state = new_state);
}));

(cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = (function cljs$core$fn_16059(_){
var self__ = this;
var ___$1 = this;
return self__.state;
}));

(cljs.core.Volatile.getBasis = (function cljs$core$fn_16060(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Volatile.cljs$lang$type = true);

(cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile");

(cljs.core.Volatile.cljs$lang$ctorPrWriter = (function cljs$core$fn_16061(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/Volatile");
}));

/**
 * Positional factory function for cljs.core/Volatile.
 */
cljs.core.__GT_Volatile = (function cljs$core$__GT_Volatile(state){
return (new cljs.core.Volatile(state));
});

/**
 * Creates and returns a Volatile with an initial value of val.
 */
cljs.core.volatile_BANG_ = (function cljs$core$volatile_BANG_(val){
return (new cljs.core.Volatile(val));
});
/**
 * Returns true if x is a volatile.
 */
cljs.core.volatile_QMARK_ = (function cljs$core$volatile_QMARK_(x){
return (x instanceof cljs.core.Volatile);
});
/**
 * Sets the value of volatile to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.vreset_BANG_ = (function cljs$core$vreset_BANG_(vol,newval){
return cljs.core._vreset_BANG_(vol,newval);
});
/**
 * Returns a lazy sequence of the non-nil results of (f index item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a stateful transducer when no collection is
 *   provided.
 */
cljs.core.keep_indexed = (function cljs$core$keep_indexed(var_args){
var G__16063 = arguments.length;
switch (G__16063) {
case 1:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16064(f){
return (function cljs$core$fn_16064_$_fn_16065(rf){
var ia = cljs.core.volatile_BANG_((-1));
return (function() {
var cljs$core$fn_16064_$_fn_16065_$_fn_16066 = null;
var cljs$core$fn_16064_$_fn_16065_$_fn_16066__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16064_$_fn_16065_$_fn_16066__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16064_$_fn_16065_$_fn_16066__2 = (function (result,input){
var i = ia.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(ia.cljs$core$IDeref$_deref$arity$1(null) + (1)));
var v = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(i,input) : f.call(null,i,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
cljs$core$fn_16064_$_fn_16065_$_fn_16066 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16064_$_fn_16065_$_fn_16066__0.call(this);
case 1:
return cljs$core$fn_16064_$_fn_16065_$_fn_16066__1.call(this,result);
case 2:
return cljs$core$fn_16064_$_fn_16065_$_fn_16066__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16064_$_fn_16065_$_fn_16066.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16064_$_fn_16065_$_fn_16066__0;
cljs$core$fn_16064_$_fn_16065_$_fn_16066.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16064_$_fn_16065_$_fn_16066__1;
cljs$core$fn_16064_$_fn_16065_$_fn_16066.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16064_$_fn_16065_$_fn_16066__2;
return cljs$core$fn_16064_$_fn_16065_$_fn_16066;
})()
});
}));

(cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16067(f,coll){
var keepi = (function cljs$core$fn_16067_$_keepi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16067_$_keepi_$_fn_16073(){
var temp__5720__auto__ = cljs.core.seq(coll__$1);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__10634__auto___16079 = size;
var i_16080 = (0);
while(true){
if((i_16080 < n__10634__auto___16079)){
var x_16081 = (function (){var G__16074 = (idx + i_16080);
var G__16075 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_16080);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16074,G__16075) : f.call(null,G__16074,G__16075));
})();
if((x_16081 == null)){
} else {
cljs.core.chunk_append(b,x_16081);
}

var G__16082 = (i_16080 + (1));
i_16080 = G__16082;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$fn_16067_$_keepi((idx + size),cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__16076 = idx;
var G__16077 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16076,G__16077) : f.call(null,G__16076,G__16077));
})();
if((x == null)){
return cljs$core$fn_16067_$_keepi((idx + (1)),cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs$core$fn_16067_$_keepi((idx + (1)),cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
return keepi((0),coll);
}));

(cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2);

/**
 * Takes a set of predicates and returns a function f that returns true if all of its
 *   composing predicates return a logical true value against all of its arguments, else it returns
 *   false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical false result against the original predicates.
 */
cljs.core.every_pred = (function cljs$core$every_pred(var_args){
var G__16094 = arguments.length;
switch (G__16094) {
case 1:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___16107 = arguments.length;
var i__10876__auto___16108 = (0);
while(true){
if((i__10876__auto___16108 < len__10875__auto___16107)){
args_arr__10904__auto__.push((arguments[i__10876__auto___16108]));

var G__16109 = (i__10876__auto___16108 + (1));
i__10876__auto___16108 = G__16109;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((3) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((3)),(0),null)):null);
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10905__auto__);

}
});

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16095(p){
return (function() {
var cljs$core$fn_16095_$_ep1 = null;
var cljs$core$fn_16095_$_ep1__0 = (function (){
return true;
});
var cljs$core$fn_16095_$_ep1__1 = (function (x){
return cljs.core.boolean$((p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x)));
});
var cljs$core$fn_16095_$_ep1__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__9540__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__9540__auto__)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
} else {
return and__9540__auto__;
}
})());
});
var cljs$core$fn_16095_$_ep1__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__9540__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__9540__auto__)){
var and__9540__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(and__9540__auto____$1)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
} else {
return and__9540__auto____$1;
}
} else {
return and__9540__auto__;
}
})());
});
var cljs$core$fn_16095_$_ep1__4 = (function() { 
var G__16110__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__9540__auto__ = cljs$core$fn_16095_$_ep1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__9540__auto__)){
return cljs.core.every_QMARK_(p,args);
} else {
return and__9540__auto__;
}
})());
};
var G__16110 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16111__i = 0, G__16111__a = new Array(arguments.length -  3);
while (G__16111__i < G__16111__a.length) {G__16111__a[G__16111__i] = arguments[G__16111__i + 3]; ++G__16111__i;}
  args = new cljs.core.IndexedSeq(G__16111__a,0,null);
} 
return G__16110__delegate.call(this,x,y,z,args);};
G__16110.cljs$lang$maxFixedArity = 3;
G__16110.cljs$lang$applyTo = (function (arglist__16112){
var x = cljs.core.first(arglist__16112);
arglist__16112 = cljs.core.next(arglist__16112);
var y = cljs.core.first(arglist__16112);
arglist__16112 = cljs.core.next(arglist__16112);
var z = cljs.core.first(arglist__16112);
var args = cljs.core.rest(arglist__16112);
return G__16110__delegate(x,y,z,args);
});
G__16110.cljs$core$IFn$_invoke$arity$variadic = G__16110__delegate;
return G__16110;
})()
;
cljs$core$fn_16095_$_ep1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16095_$_ep1__0.call(this);
case 1:
return cljs$core$fn_16095_$_ep1__1.call(this,x);
case 2:
return cljs$core$fn_16095_$_ep1__2.call(this,x,y);
case 3:
return cljs$core$fn_16095_$_ep1__3.call(this,x,y,z);
default:
var G__16113 = null;
if (arguments.length > 3) {
var G__16114__i = 0, G__16114__a = new Array(arguments.length -  3);
while (G__16114__i < G__16114__a.length) {G__16114__a[G__16114__i] = arguments[G__16114__i + 3]; ++G__16114__i;}
G__16113 = new cljs.core.IndexedSeq(G__16114__a,0,null);
}
return cljs$core$fn_16095_$_ep1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16113);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16095_$_ep1.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16095_$_ep1.cljs$lang$applyTo = cljs$core$fn_16095_$_ep1__4.cljs$lang$applyTo;
cljs$core$fn_16095_$_ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16095_$_ep1__0;
cljs$core$fn_16095_$_ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16095_$_ep1__1;
cljs$core$fn_16095_$_ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16095_$_ep1__2;
cljs$core$fn_16095_$_ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16095_$_ep1__3;
cljs$core$fn_16095_$_ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16095_$_ep1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16095_$_ep1;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16096(p1,p2){
return (function() {
var cljs$core$fn_16096_$_ep2 = null;
var cljs$core$fn_16096_$_ep2__0 = (function (){
return true;
});
var cljs$core$fn_16096_$_ep2__1 = (function (x){
return cljs.core.boolean$((function (){var and__9540__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9540__auto__)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
} else {
return and__9540__auto__;
}
})());
});
var cljs$core$fn_16096_$_ep2__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__9540__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9540__auto__)){
var and__9540__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__9540__auto____$1)){
var and__9540__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__9540__auto____$2)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
} else {
return and__9540__auto____$2;
}
} else {
return and__9540__auto____$1;
}
} else {
return and__9540__auto__;
}
})());
});
var cljs$core$fn_16096_$_ep2__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__9540__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9540__auto__)){
var and__9540__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__9540__auto____$1)){
var and__9540__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__9540__auto____$2)){
var and__9540__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__9540__auto____$3)){
var and__9540__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__9540__auto____$4)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
} else {
return and__9540__auto____$4;
}
} else {
return and__9540__auto____$3;
}
} else {
return and__9540__auto____$2;
}
} else {
return and__9540__auto____$1;
}
} else {
return and__9540__auto__;
}
})());
});
var cljs$core$fn_16096_$_ep2__4 = (function() { 
var G__16115__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__9540__auto__ = cljs$core$fn_16096_$_ep2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__9540__auto__)){
return cljs.core.every_QMARK_((function cljs$core$fn_16096_$_ep2_$_fn_16097(p1__16083_SHARP_){
var and__9540__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__16083_SHARP_) : p1.call(null,p1__16083_SHARP_));
if(cljs.core.truth_(and__9540__auto____$1)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__16083_SHARP_) : p2.call(null,p1__16083_SHARP_));
} else {
return and__9540__auto____$1;
}
}),args);
} else {
return and__9540__auto__;
}
})());
};
var G__16115 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16116__i = 0, G__16116__a = new Array(arguments.length -  3);
while (G__16116__i < G__16116__a.length) {G__16116__a[G__16116__i] = arguments[G__16116__i + 3]; ++G__16116__i;}
  args = new cljs.core.IndexedSeq(G__16116__a,0,null);
} 
return G__16115__delegate.call(this,x,y,z,args);};
G__16115.cljs$lang$maxFixedArity = 3;
G__16115.cljs$lang$applyTo = (function (arglist__16117){
var x = cljs.core.first(arglist__16117);
arglist__16117 = cljs.core.next(arglist__16117);
var y = cljs.core.first(arglist__16117);
arglist__16117 = cljs.core.next(arglist__16117);
var z = cljs.core.first(arglist__16117);
var args = cljs.core.rest(arglist__16117);
return G__16115__delegate(x,y,z,args);
});
G__16115.cljs$core$IFn$_invoke$arity$variadic = G__16115__delegate;
return G__16115;
})()
;
cljs$core$fn_16096_$_ep2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16096_$_ep2__0.call(this);
case 1:
return cljs$core$fn_16096_$_ep2__1.call(this,x);
case 2:
return cljs$core$fn_16096_$_ep2__2.call(this,x,y);
case 3:
return cljs$core$fn_16096_$_ep2__3.call(this,x,y,z);
default:
var G__16118 = null;
if (arguments.length > 3) {
var G__16119__i = 0, G__16119__a = new Array(arguments.length -  3);
while (G__16119__i < G__16119__a.length) {G__16119__a[G__16119__i] = arguments[G__16119__i + 3]; ++G__16119__i;}
G__16118 = new cljs.core.IndexedSeq(G__16119__a,0,null);
}
return cljs$core$fn_16096_$_ep2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16096_$_ep2.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16096_$_ep2.cljs$lang$applyTo = cljs$core$fn_16096_$_ep2__4.cljs$lang$applyTo;
cljs$core$fn_16096_$_ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16096_$_ep2__0;
cljs$core$fn_16096_$_ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16096_$_ep2__1;
cljs$core$fn_16096_$_ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16096_$_ep2__2;
cljs$core$fn_16096_$_ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16096_$_ep2__3;
cljs$core$fn_16096_$_ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16096_$_ep2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16096_$_ep2;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16098(p1,p2,p3){
return (function() {
var cljs$core$fn_16098_$_ep3 = null;
var cljs$core$fn_16098_$_ep3__0 = (function (){
return true;
});
var cljs$core$fn_16098_$_ep3__1 = (function (x){
return cljs.core.boolean$((function (){var and__9540__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9540__auto__)){
var and__9540__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__9540__auto____$1)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
} else {
return and__9540__auto____$1;
}
} else {
return and__9540__auto__;
}
})());
});
var cljs$core$fn_16098_$_ep3__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__9540__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9540__auto__)){
var and__9540__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__9540__auto____$1)){
var and__9540__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__9540__auto____$2)){
var and__9540__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__9540__auto____$3)){
var and__9540__auto____$4 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__9540__auto____$4)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
} else {
return and__9540__auto____$4;
}
} else {
return and__9540__auto____$3;
}
} else {
return and__9540__auto____$2;
}
} else {
return and__9540__auto____$1;
}
} else {
return and__9540__auto__;
}
})());
});
var cljs$core$fn_16098_$_ep3__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__9540__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9540__auto__)){
var and__9540__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__9540__auto____$1)){
var and__9540__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__9540__auto____$2)){
var and__9540__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__9540__auto____$3)){
var and__9540__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__9540__auto____$4)){
var and__9540__auto____$5 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(and__9540__auto____$5)){
var and__9540__auto____$6 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__9540__auto____$6)){
var and__9540__auto____$7 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(and__9540__auto____$7)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
} else {
return and__9540__auto____$7;
}
} else {
return and__9540__auto____$6;
}
} else {
return and__9540__auto____$5;
}
} else {
return and__9540__auto____$4;
}
} else {
return and__9540__auto____$3;
}
} else {
return and__9540__auto____$2;
}
} else {
return and__9540__auto____$1;
}
} else {
return and__9540__auto__;
}
})());
});
var cljs$core$fn_16098_$_ep3__4 = (function() { 
var G__16120__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__9540__auto__ = cljs$core$fn_16098_$_ep3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__9540__auto__)){
return cljs.core.every_QMARK_((function cljs$core$fn_16098_$_ep3_$_fn_16099(p1__16084_SHARP_){
var and__9540__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__16084_SHARP_) : p1.call(null,p1__16084_SHARP_));
if(cljs.core.truth_(and__9540__auto____$1)){
var and__9540__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__16084_SHARP_) : p2.call(null,p1__16084_SHARP_));
if(cljs.core.truth_(and__9540__auto____$2)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__16084_SHARP_) : p3.call(null,p1__16084_SHARP_));
} else {
return and__9540__auto____$2;
}
} else {
return and__9540__auto____$1;
}
}),args);
} else {
return and__9540__auto__;
}
})());
};
var G__16120 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16121__i = 0, G__16121__a = new Array(arguments.length -  3);
while (G__16121__i < G__16121__a.length) {G__16121__a[G__16121__i] = arguments[G__16121__i + 3]; ++G__16121__i;}
  args = new cljs.core.IndexedSeq(G__16121__a,0,null);
} 
return G__16120__delegate.call(this,x,y,z,args);};
G__16120.cljs$lang$maxFixedArity = 3;
G__16120.cljs$lang$applyTo = (function (arglist__16122){
var x = cljs.core.first(arglist__16122);
arglist__16122 = cljs.core.next(arglist__16122);
var y = cljs.core.first(arglist__16122);
arglist__16122 = cljs.core.next(arglist__16122);
var z = cljs.core.first(arglist__16122);
var args = cljs.core.rest(arglist__16122);
return G__16120__delegate(x,y,z,args);
});
G__16120.cljs$core$IFn$_invoke$arity$variadic = G__16120__delegate;
return G__16120;
})()
;
cljs$core$fn_16098_$_ep3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16098_$_ep3__0.call(this);
case 1:
return cljs$core$fn_16098_$_ep3__1.call(this,x);
case 2:
return cljs$core$fn_16098_$_ep3__2.call(this,x,y);
case 3:
return cljs$core$fn_16098_$_ep3__3.call(this,x,y,z);
default:
var G__16123 = null;
if (arguments.length > 3) {
var G__16124__i = 0, G__16124__a = new Array(arguments.length -  3);
while (G__16124__i < G__16124__a.length) {G__16124__a[G__16124__i] = arguments[G__16124__i + 3]; ++G__16124__i;}
G__16123 = new cljs.core.IndexedSeq(G__16124__a,0,null);
}
return cljs$core$fn_16098_$_ep3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16123);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16098_$_ep3.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16098_$_ep3.cljs$lang$applyTo = cljs$core$fn_16098_$_ep3__4.cljs$lang$applyTo;
cljs$core$fn_16098_$_ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16098_$_ep3__0;
cljs$core$fn_16098_$_ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16098_$_ep3__1;
cljs$core$fn_16098_$_ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16098_$_ep3__2;
cljs$core$fn_16098_$_ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16098_$_ep3__3;
cljs$core$fn_16098_$_ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16098_$_ep3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16098_$_ep3;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16100(p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return (function() {
var cljs$core$fn_16100_$_epn = null;
var cljs$core$fn_16100_$_epn__0 = (function (){
return true;
});
var cljs$core$fn_16100_$_epn__1 = (function (x){
return cljs.core.every_QMARK_((function cljs$core$fn_16100_$_epn_$_fn_16101(p1__16085_SHARP_){
return (p1__16085_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16085_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16085_SHARP_.call(null,x));
}),ps__$1);
});
var cljs$core$fn_16100_$_epn__2 = (function (x,y){
return cljs.core.every_QMARK_((function cljs$core$fn_16100_$_epn_$_fn_16102(p1__16086_SHARP_){
var and__9540__auto__ = (p1__16086_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16086_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16086_SHARP_.call(null,x));
if(cljs.core.truth_(and__9540__auto__)){
return (p1__16086_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16086_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__16086_SHARP_.call(null,y));
} else {
return and__9540__auto__;
}
}),ps__$1);
});
var cljs$core$fn_16100_$_epn__3 = (function (x,y,z){
return cljs.core.every_QMARK_((function cljs$core$fn_16100_$_epn_$_fn_16103(p1__16087_SHARP_){
var and__9540__auto__ = (p1__16087_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16087_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16087_SHARP_.call(null,x));
if(cljs.core.truth_(and__9540__auto__)){
var and__9540__auto____$1 = (p1__16087_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16087_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__16087_SHARP_.call(null,y));
if(cljs.core.truth_(and__9540__auto____$1)){
return (p1__16087_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16087_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__16087_SHARP_.call(null,z));
} else {
return and__9540__auto____$1;
}
} else {
return and__9540__auto__;
}
}),ps__$1);
});
var cljs$core$fn_16100_$_epn__4 = (function() { 
var G__16125__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__9540__auto__ = cljs$core$fn_16100_$_epn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__9540__auto__)){
return cljs.core.every_QMARK_((function cljs$core$fn_16100_$_epn_$_fn_16104(p1__16088_SHARP_){
return cljs.core.every_QMARK_(p1__16088_SHARP_,args);
}),ps__$1);
} else {
return and__9540__auto__;
}
})());
};
var G__16125 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16126__i = 0, G__16126__a = new Array(arguments.length -  3);
while (G__16126__i < G__16126__a.length) {G__16126__a[G__16126__i] = arguments[G__16126__i + 3]; ++G__16126__i;}
  args = new cljs.core.IndexedSeq(G__16126__a,0,null);
} 
return G__16125__delegate.call(this,x,y,z,args);};
G__16125.cljs$lang$maxFixedArity = 3;
G__16125.cljs$lang$applyTo = (function (arglist__16127){
var x = cljs.core.first(arglist__16127);
arglist__16127 = cljs.core.next(arglist__16127);
var y = cljs.core.first(arglist__16127);
arglist__16127 = cljs.core.next(arglist__16127);
var z = cljs.core.first(arglist__16127);
var args = cljs.core.rest(arglist__16127);
return G__16125__delegate(x,y,z,args);
});
G__16125.cljs$core$IFn$_invoke$arity$variadic = G__16125__delegate;
return G__16125;
})()
;
cljs$core$fn_16100_$_epn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16100_$_epn__0.call(this);
case 1:
return cljs$core$fn_16100_$_epn__1.call(this,x);
case 2:
return cljs$core$fn_16100_$_epn__2.call(this,x,y);
case 3:
return cljs$core$fn_16100_$_epn__3.call(this,x,y,z);
default:
var G__16128 = null;
if (arguments.length > 3) {
var G__16129__i = 0, G__16129__a = new Array(arguments.length -  3);
while (G__16129__i < G__16129__a.length) {G__16129__a[G__16129__i] = arguments[G__16129__i + 3]; ++G__16129__i;}
G__16128 = new cljs.core.IndexedSeq(G__16129__a,0,null);
}
return cljs$core$fn_16100_$_epn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16128);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16100_$_epn.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16100_$_epn.cljs$lang$applyTo = cljs$core$fn_16100_$_epn__4.cljs$lang$applyTo;
cljs$core$fn_16100_$_epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16100_$_epn__0;
cljs$core$fn_16100_$_epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16100_$_epn__1;
cljs$core$fn_16100_$_epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16100_$_epn__2;
cljs$core$fn_16100_$_epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16100_$_epn__3;
cljs$core$fn_16100_$_epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16100_$_epn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16100_$_epn;
})()
}));

/** @this {Function} */
(cljs.core.every_pred.cljs$lang$applyTo = (function cljs$core$fn_16105(seq16090){
var G__16091 = cljs.core.first(seq16090);
var seq16090__$1 = cljs.core.next(seq16090);
var G__16092 = cljs.core.first(seq16090__$1);
var seq16090__$2 = cljs.core.next(seq16090__$1);
var G__16093 = cljs.core.first(seq16090__$2);
var seq16090__$3 = cljs.core.next(seq16090__$2);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16091,G__16092,G__16093,seq16090__$3);
}));

(cljs.core.every_pred.cljs$lang$maxFixedArity = (3));

/**
 * Takes a set of predicates and returns a function f that returns the first logical true value
 *   returned by one of its composing predicates against any of its arguments, else it returns
 *   logical false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical true result against the original predicates.
 */
cljs.core.some_fn = (function cljs$core$some_fn(var_args){
var G__16141 = arguments.length;
switch (G__16141) {
case 1:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___16154 = arguments.length;
var i__10876__auto___16155 = (0);
while(true){
if((i__10876__auto___16155 < len__10875__auto___16154)){
args_arr__10904__auto__.push((arguments[i__10876__auto___16155]));

var G__16156 = (i__10876__auto___16155 + (1));
i__10876__auto___16155 = G__16156;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((3) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((3)),(0),null)):null);
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10905__auto__);

}
});

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16142(p){
return (function() {
var cljs$core$fn_16142_$_sp1 = null;
var cljs$core$fn_16142_$_sp1__0 = (function (){
return null;
});
var cljs$core$fn_16142_$_sp1__1 = (function (x){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
});
var cljs$core$fn_16142_$_sp1__2 = (function (x,y){
var or__9546__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__9546__auto__)){
return or__9546__auto__;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
}
});
var cljs$core$fn_16142_$_sp1__3 = (function (x,y,z){
var or__9546__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__9546__auto__)){
return or__9546__auto__;
} else {
var or__9546__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(or__9546__auto____$1)){
return or__9546__auto____$1;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
}
}
});
var cljs$core$fn_16142_$_sp1__4 = (function() { 
var G__16157__delegate = function (x,y,z,args){
var or__9546__auto__ = cljs$core$fn_16142_$_sp1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__9546__auto__)){
return or__9546__auto__;
} else {
return cljs.core.some(p,args);
}
};
var G__16157 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16158__i = 0, G__16158__a = new Array(arguments.length -  3);
while (G__16158__i < G__16158__a.length) {G__16158__a[G__16158__i] = arguments[G__16158__i + 3]; ++G__16158__i;}
  args = new cljs.core.IndexedSeq(G__16158__a,0,null);
} 
return G__16157__delegate.call(this,x,y,z,args);};
G__16157.cljs$lang$maxFixedArity = 3;
G__16157.cljs$lang$applyTo = (function (arglist__16159){
var x = cljs.core.first(arglist__16159);
arglist__16159 = cljs.core.next(arglist__16159);
var y = cljs.core.first(arglist__16159);
arglist__16159 = cljs.core.next(arglist__16159);
var z = cljs.core.first(arglist__16159);
var args = cljs.core.rest(arglist__16159);
return G__16157__delegate(x,y,z,args);
});
G__16157.cljs$core$IFn$_invoke$arity$variadic = G__16157__delegate;
return G__16157;
})()
;
cljs$core$fn_16142_$_sp1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16142_$_sp1__0.call(this);
case 1:
return cljs$core$fn_16142_$_sp1__1.call(this,x);
case 2:
return cljs$core$fn_16142_$_sp1__2.call(this,x,y);
case 3:
return cljs$core$fn_16142_$_sp1__3.call(this,x,y,z);
default:
var G__16160 = null;
if (arguments.length > 3) {
var G__16161__i = 0, G__16161__a = new Array(arguments.length -  3);
while (G__16161__i < G__16161__a.length) {G__16161__a[G__16161__i] = arguments[G__16161__i + 3]; ++G__16161__i;}
G__16160 = new cljs.core.IndexedSeq(G__16161__a,0,null);
}
return cljs$core$fn_16142_$_sp1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16160);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16142_$_sp1.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16142_$_sp1.cljs$lang$applyTo = cljs$core$fn_16142_$_sp1__4.cljs$lang$applyTo;
cljs$core$fn_16142_$_sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16142_$_sp1__0;
cljs$core$fn_16142_$_sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16142_$_sp1__1;
cljs$core$fn_16142_$_sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16142_$_sp1__2;
cljs$core$fn_16142_$_sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16142_$_sp1__3;
cljs$core$fn_16142_$_sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16142_$_sp1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16142_$_sp1;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16143(p1,p2){
return (function() {
var cljs$core$fn_16143_$_sp2 = null;
var cljs$core$fn_16143_$_sp2__0 = (function (){
return null;
});
var cljs$core$fn_16143_$_sp2__1 = (function (x){
var or__9546__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9546__auto__)){
return or__9546__auto__;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
}
});
var cljs$core$fn_16143_$_sp2__2 = (function (x,y){
var or__9546__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9546__auto__)){
return or__9546__auto__;
} else {
var or__9546__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__9546__auto____$1)){
return or__9546__auto____$1;
} else {
var or__9546__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__9546__auto____$2)){
return or__9546__auto____$2;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
}
}
}
});
var cljs$core$fn_16143_$_sp2__3 = (function (x,y,z){
var or__9546__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9546__auto__)){
return or__9546__auto__;
} else {
var or__9546__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__9546__auto____$1)){
return or__9546__auto____$1;
} else {
var or__9546__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__9546__auto____$2)){
return or__9546__auto____$2;
} else {
var or__9546__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__9546__auto____$3)){
return or__9546__auto____$3;
} else {
var or__9546__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__9546__auto____$4)){
return or__9546__auto____$4;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
}
}
}
}
}
});
var cljs$core$fn_16143_$_sp2__4 = (function() { 
var G__16162__delegate = function (x,y,z,args){
var or__9546__auto__ = cljs$core$fn_16143_$_sp2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__9546__auto__)){
return or__9546__auto__;
} else {
return cljs.core.some((function cljs$core$fn_16143_$_sp2_$_fn_16144(p1__16130_SHARP_){
var or__9546__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__16130_SHARP_) : p1.call(null,p1__16130_SHARP_));
if(cljs.core.truth_(or__9546__auto____$1)){
return or__9546__auto____$1;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__16130_SHARP_) : p2.call(null,p1__16130_SHARP_));
}
}),args);
}
};
var G__16162 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16163__i = 0, G__16163__a = new Array(arguments.length -  3);
while (G__16163__i < G__16163__a.length) {G__16163__a[G__16163__i] = arguments[G__16163__i + 3]; ++G__16163__i;}
  args = new cljs.core.IndexedSeq(G__16163__a,0,null);
} 
return G__16162__delegate.call(this,x,y,z,args);};
G__16162.cljs$lang$maxFixedArity = 3;
G__16162.cljs$lang$applyTo = (function (arglist__16164){
var x = cljs.core.first(arglist__16164);
arglist__16164 = cljs.core.next(arglist__16164);
var y = cljs.core.first(arglist__16164);
arglist__16164 = cljs.core.next(arglist__16164);
var z = cljs.core.first(arglist__16164);
var args = cljs.core.rest(arglist__16164);
return G__16162__delegate(x,y,z,args);
});
G__16162.cljs$core$IFn$_invoke$arity$variadic = G__16162__delegate;
return G__16162;
})()
;
cljs$core$fn_16143_$_sp2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16143_$_sp2__0.call(this);
case 1:
return cljs$core$fn_16143_$_sp2__1.call(this,x);
case 2:
return cljs$core$fn_16143_$_sp2__2.call(this,x,y);
case 3:
return cljs$core$fn_16143_$_sp2__3.call(this,x,y,z);
default:
var G__16165 = null;
if (arguments.length > 3) {
var G__16166__i = 0, G__16166__a = new Array(arguments.length -  3);
while (G__16166__i < G__16166__a.length) {G__16166__a[G__16166__i] = arguments[G__16166__i + 3]; ++G__16166__i;}
G__16165 = new cljs.core.IndexedSeq(G__16166__a,0,null);
}
return cljs$core$fn_16143_$_sp2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16143_$_sp2.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16143_$_sp2.cljs$lang$applyTo = cljs$core$fn_16143_$_sp2__4.cljs$lang$applyTo;
cljs$core$fn_16143_$_sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16143_$_sp2__0;
cljs$core$fn_16143_$_sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16143_$_sp2__1;
cljs$core$fn_16143_$_sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16143_$_sp2__2;
cljs$core$fn_16143_$_sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16143_$_sp2__3;
cljs$core$fn_16143_$_sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16143_$_sp2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16143_$_sp2;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16145(p1,p2,p3){
return (function() {
var cljs$core$fn_16145_$_sp3 = null;
var cljs$core$fn_16145_$_sp3__0 = (function (){
return null;
});
var cljs$core$fn_16145_$_sp3__1 = (function (x){
var or__9546__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9546__auto__)){
return or__9546__auto__;
} else {
var or__9546__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__9546__auto____$1)){
return or__9546__auto____$1;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
}
}
});
var cljs$core$fn_16145_$_sp3__2 = (function (x,y){
var or__9546__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9546__auto__)){
return or__9546__auto__;
} else {
var or__9546__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__9546__auto____$1)){
return or__9546__auto____$1;
} else {
var or__9546__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__9546__auto____$2)){
return or__9546__auto____$2;
} else {
var or__9546__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__9546__auto____$3)){
return or__9546__auto____$3;
} else {
var or__9546__auto____$4 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__9546__auto____$4)){
return or__9546__auto____$4;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
}
}
}
}
}
});
var cljs$core$fn_16145_$_sp3__3 = (function (x,y,z){
var or__9546__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9546__auto__)){
return or__9546__auto__;
} else {
var or__9546__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__9546__auto____$1)){
return or__9546__auto____$1;
} else {
var or__9546__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__9546__auto____$2)){
return or__9546__auto____$2;
} else {
var or__9546__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__9546__auto____$3)){
return or__9546__auto____$3;
} else {
var or__9546__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__9546__auto____$4)){
return or__9546__auto____$4;
} else {
var or__9546__auto____$5 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(or__9546__auto____$5)){
return or__9546__auto____$5;
} else {
var or__9546__auto____$6 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__9546__auto____$6)){
return or__9546__auto____$6;
} else {
var or__9546__auto____$7 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(or__9546__auto____$7)){
return or__9546__auto____$7;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
}
}
}
}
}
}
}
}
});
var cljs$core$fn_16145_$_sp3__4 = (function() { 
var G__16167__delegate = function (x,y,z,args){
var or__9546__auto__ = cljs$core$fn_16145_$_sp3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__9546__auto__)){
return or__9546__auto__;
} else {
return cljs.core.some((function cljs$core$fn_16145_$_sp3_$_fn_16146(p1__16131_SHARP_){
var or__9546__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__16131_SHARP_) : p1.call(null,p1__16131_SHARP_));
if(cljs.core.truth_(or__9546__auto____$1)){
return or__9546__auto____$1;
} else {
var or__9546__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__16131_SHARP_) : p2.call(null,p1__16131_SHARP_));
if(cljs.core.truth_(or__9546__auto____$2)){
return or__9546__auto____$2;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__16131_SHARP_) : p3.call(null,p1__16131_SHARP_));
}
}
}),args);
}
};
var G__16167 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16168__i = 0, G__16168__a = new Array(arguments.length -  3);
while (G__16168__i < G__16168__a.length) {G__16168__a[G__16168__i] = arguments[G__16168__i + 3]; ++G__16168__i;}
  args = new cljs.core.IndexedSeq(G__16168__a,0,null);
} 
return G__16167__delegate.call(this,x,y,z,args);};
G__16167.cljs$lang$maxFixedArity = 3;
G__16167.cljs$lang$applyTo = (function (arglist__16169){
var x = cljs.core.first(arglist__16169);
arglist__16169 = cljs.core.next(arglist__16169);
var y = cljs.core.first(arglist__16169);
arglist__16169 = cljs.core.next(arglist__16169);
var z = cljs.core.first(arglist__16169);
var args = cljs.core.rest(arglist__16169);
return G__16167__delegate(x,y,z,args);
});
G__16167.cljs$core$IFn$_invoke$arity$variadic = G__16167__delegate;
return G__16167;
})()
;
cljs$core$fn_16145_$_sp3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16145_$_sp3__0.call(this);
case 1:
return cljs$core$fn_16145_$_sp3__1.call(this,x);
case 2:
return cljs$core$fn_16145_$_sp3__2.call(this,x,y);
case 3:
return cljs$core$fn_16145_$_sp3__3.call(this,x,y,z);
default:
var G__16170 = null;
if (arguments.length > 3) {
var G__16171__i = 0, G__16171__a = new Array(arguments.length -  3);
while (G__16171__i < G__16171__a.length) {G__16171__a[G__16171__i] = arguments[G__16171__i + 3]; ++G__16171__i;}
G__16170 = new cljs.core.IndexedSeq(G__16171__a,0,null);
}
return cljs$core$fn_16145_$_sp3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16170);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16145_$_sp3.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16145_$_sp3.cljs$lang$applyTo = cljs$core$fn_16145_$_sp3__4.cljs$lang$applyTo;
cljs$core$fn_16145_$_sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16145_$_sp3__0;
cljs$core$fn_16145_$_sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16145_$_sp3__1;
cljs$core$fn_16145_$_sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16145_$_sp3__2;
cljs$core$fn_16145_$_sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16145_$_sp3__3;
cljs$core$fn_16145_$_sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16145_$_sp3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16145_$_sp3;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16147(p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return (function() {
var cljs$core$fn_16147_$_spn = null;
var cljs$core$fn_16147_$_spn__0 = (function (){
return null;
});
var cljs$core$fn_16147_$_spn__1 = (function (x){
return cljs.core.some((function cljs$core$fn_16147_$_spn_$_fn_16148(p1__16132_SHARP_){
return (p1__16132_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16132_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16132_SHARP_.call(null,x));
}),ps__$1);
});
var cljs$core$fn_16147_$_spn__2 = (function (x,y){
return cljs.core.some((function cljs$core$fn_16147_$_spn_$_fn_16149(p1__16133_SHARP_){
var or__9546__auto__ = (p1__16133_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16133_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16133_SHARP_.call(null,x));
if(cljs.core.truth_(or__9546__auto__)){
return or__9546__auto__;
} else {
return (p1__16133_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16133_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__16133_SHARP_.call(null,y));
}
}),ps__$1);
});
var cljs$core$fn_16147_$_spn__3 = (function (x,y,z){
return cljs.core.some((function cljs$core$fn_16147_$_spn_$_fn_16150(p1__16134_SHARP_){
var or__9546__auto__ = (p1__16134_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16134_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16134_SHARP_.call(null,x));
if(cljs.core.truth_(or__9546__auto__)){
return or__9546__auto__;
} else {
var or__9546__auto____$1 = (p1__16134_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16134_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__16134_SHARP_.call(null,y));
if(cljs.core.truth_(or__9546__auto____$1)){
return or__9546__auto____$1;
} else {
return (p1__16134_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16134_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__16134_SHARP_.call(null,z));
}
}
}),ps__$1);
});
var cljs$core$fn_16147_$_spn__4 = (function() { 
var G__16172__delegate = function (x,y,z,args){
var or__9546__auto__ = cljs$core$fn_16147_$_spn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__9546__auto__)){
return or__9546__auto__;
} else {
return cljs.core.some((function cljs$core$fn_16147_$_spn_$_fn_16151(p1__16135_SHARP_){
return cljs.core.some(p1__16135_SHARP_,args);
}),ps__$1);
}
};
var G__16172 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16173__i = 0, G__16173__a = new Array(arguments.length -  3);
while (G__16173__i < G__16173__a.length) {G__16173__a[G__16173__i] = arguments[G__16173__i + 3]; ++G__16173__i;}
  args = new cljs.core.IndexedSeq(G__16173__a,0,null);
} 
return G__16172__delegate.call(this,x,y,z,args);};
G__16172.cljs$lang$maxFixedArity = 3;
G__16172.cljs$lang$applyTo = (function (arglist__16174){
var x = cljs.core.first(arglist__16174);
arglist__16174 = cljs.core.next(arglist__16174);
var y = cljs.core.first(arglist__16174);
arglist__16174 = cljs.core.next(arglist__16174);
var z = cljs.core.first(arglist__16174);
var args = cljs.core.rest(arglist__16174);
return G__16172__delegate(x,y,z,args);
});
G__16172.cljs$core$IFn$_invoke$arity$variadic = G__16172__delegate;
return G__16172;
})()
;
cljs$core$fn_16147_$_spn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16147_$_spn__0.call(this);
case 1:
return cljs$core$fn_16147_$_spn__1.call(this,x);
case 2:
return cljs$core$fn_16147_$_spn__2.call(this,x,y);
case 3:
return cljs$core$fn_16147_$_spn__3.call(this,x,y,z);
default:
var G__16175 = null;
if (arguments.length > 3) {
var G__16176__i = 0, G__16176__a = new Array(arguments.length -  3);
while (G__16176__i < G__16176__a.length) {G__16176__a[G__16176__i] = arguments[G__16176__i + 3]; ++G__16176__i;}
G__16175 = new cljs.core.IndexedSeq(G__16176__a,0,null);
}
return cljs$core$fn_16147_$_spn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16175);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16147_$_spn.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16147_$_spn.cljs$lang$applyTo = cljs$core$fn_16147_$_spn__4.cljs$lang$applyTo;
cljs$core$fn_16147_$_spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16147_$_spn__0;
cljs$core$fn_16147_$_spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16147_$_spn__1;
cljs$core$fn_16147_$_spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16147_$_spn__2;
cljs$core$fn_16147_$_spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16147_$_spn__3;
cljs$core$fn_16147_$_spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16147_$_spn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16147_$_spn;
})()
}));

/** @this {Function} */
(cljs.core.some_fn.cljs$lang$applyTo = (function cljs$core$fn_16152(seq16137){
var G__16138 = cljs.core.first(seq16137);
var seq16137__$1 = cljs.core.next(seq16137);
var G__16139 = cljs.core.first(seq16137__$1);
var seq16137__$2 = cljs.core.next(seq16137__$1);
var G__16140 = cljs.core.first(seq16137__$2);
var seq16137__$3 = cljs.core.next(seq16137__$2);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16138,G__16139,G__16140,seq16137__$3);
}));

(cljs.core.some_fn.cljs$lang$maxFixedArity = (3));

/**
 * Returns a lazy sequence consisting of the result of applying f to
 *   the set of first items of each coll, followed by applying f to the
 *   set of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments. Returns a transducer when
 *   no collection is provided.
 */
cljs.core.map = (function cljs$core$map(var_args){
var G__16184 = arguments.length;
switch (G__16184) {
case 1:
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.map.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___16210 = arguments.length;
var i__10876__auto___16211 = (0);
while(true){
if((i__10876__auto___16211 < len__10875__auto___16210)){
args_arr__10904__auto__.push((arguments[i__10876__auto___16211]));

var G__16212 = (i__10876__auto___16211 + (1));
i__10876__auto___16211 = G__16212;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((4) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((4)),(0),null)):null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10905__auto__);

}
});

(cljs.core.map.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16185(f){
return (function cljs$core$fn_16185_$_fn_16186(rf){
return (function() {
var cljs$core$fn_16185_$_fn_16186_$_fn_16187 = null;
var cljs$core$fn_16185_$_fn_16186_$_fn_16187__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16185_$_fn_16186_$_fn_16187__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16185_$_fn_16186_$_fn_16187__2 = (function (result,input){
var G__16188 = result;
var G__16189 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__16188,G__16189) : rf.call(null,G__16188,G__16189));
});
var cljs$core$fn_16185_$_fn_16186_$_fn_16187__3 = (function() { 
var G__16213__delegate = function (result,input,inputs){
var G__16190 = result;
var G__16191 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,input,inputs);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__16190,G__16191) : rf.call(null,G__16190,G__16191));
};
var G__16213 = function (result,input,var_args){
var inputs = null;
if (arguments.length > 2) {
var G__16214__i = 0, G__16214__a = new Array(arguments.length -  2);
while (G__16214__i < G__16214__a.length) {G__16214__a[G__16214__i] = arguments[G__16214__i + 2]; ++G__16214__i;}
  inputs = new cljs.core.IndexedSeq(G__16214__a,0,null);
} 
return G__16213__delegate.call(this,result,input,inputs);};
G__16213.cljs$lang$maxFixedArity = 2;
G__16213.cljs$lang$applyTo = (function (arglist__16215){
var result = cljs.core.first(arglist__16215);
arglist__16215 = cljs.core.next(arglist__16215);
var input = cljs.core.first(arglist__16215);
var inputs = cljs.core.rest(arglist__16215);
return G__16213__delegate(result,input,inputs);
});
G__16213.cljs$core$IFn$_invoke$arity$variadic = G__16213__delegate;
return G__16213;
})()
;
cljs$core$fn_16185_$_fn_16186_$_fn_16187 = function(result,input,var_args){
var inputs = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16185_$_fn_16186_$_fn_16187__0.call(this);
case 1:
return cljs$core$fn_16185_$_fn_16186_$_fn_16187__1.call(this,result);
case 2:
return cljs$core$fn_16185_$_fn_16186_$_fn_16187__2.call(this,result,input);
default:
var G__16216 = null;
if (arguments.length > 2) {
var G__16217__i = 0, G__16217__a = new Array(arguments.length -  2);
while (G__16217__i < G__16217__a.length) {G__16217__a[G__16217__i] = arguments[G__16217__i + 2]; ++G__16217__i;}
G__16216 = new cljs.core.IndexedSeq(G__16217__a,0,null);
}
return cljs$core$fn_16185_$_fn_16186_$_fn_16187__3.cljs$core$IFn$_invoke$arity$variadic(result,input, G__16216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16185_$_fn_16186_$_fn_16187.cljs$lang$maxFixedArity = 2;
cljs$core$fn_16185_$_fn_16186_$_fn_16187.cljs$lang$applyTo = cljs$core$fn_16185_$_fn_16186_$_fn_16187__3.cljs$lang$applyTo;
cljs$core$fn_16185_$_fn_16186_$_fn_16187.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16185_$_fn_16186_$_fn_16187__0;
cljs$core$fn_16185_$_fn_16186_$_fn_16187.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16185_$_fn_16186_$_fn_16187__1;
cljs$core$fn_16185_$_fn_16186_$_fn_16187.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16185_$_fn_16186_$_fn_16187__2;
cljs$core$fn_16185_$_fn_16186_$_fn_16187.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16185_$_fn_16186_$_fn_16187__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16185_$_fn_16186_$_fn_16187;
})()
});
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16192(f,coll){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16192_$_fn_16193(){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__10634__auto___16218 = size;
var i_16219 = (0);
while(true){
if((i_16219 < n__10634__auto___16218)){
cljs.core.chunk_append(b,(function (){var G__16194 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_16219);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16194) : f.call(null,G__16194));
})());

var G__16220 = (i_16219 + (1));
i_16219 = G__16220;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__16195 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16195) : f.call(null,G__16195));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16196(f,c1,c2){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16196_$_fn_16197(){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if(((s1) && (s2))){
return cljs.core.cons((function (){var G__16198 = cljs.core.first(s1);
var G__16199 = cljs.core.first(s2);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16198,G__16199) : f.call(null,G__16198,G__16199));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,cljs.core.rest(s1),cljs.core.rest(s2)));
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16200(f,c1,c2,c3){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16200_$_fn_16201(){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
var s3 = cljs.core.seq(c3);
if(((s1) && (((s2) && (s3))))){
return cljs.core.cons((function (){var G__16202 = cljs.core.first(s1);
var G__16203 = cljs.core.first(s2);
var G__16204 = cljs.core.first(s3);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16202,G__16203,G__16204) : f.call(null,G__16202,G__16203,G__16204));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,cljs.core.rest(s1),cljs.core.rest(s2),cljs.core.rest(s3)));
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16205(f,c1,c2,c3,colls){
var step = (function cljs$core$fn_16205_$_step(cs){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16205_$_step_$_fn_16206(){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cs);
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs$core$fn_16205_$_step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function cljs$core$fn_16205_$_fn_16207(p1__16177_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,p1__16177_SHARP_);
}),step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c3,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c2,c1], 0))));
}));

/** @this {Function} */
(cljs.core.map.cljs$lang$applyTo = (function cljs$core$fn_16208(seq16179){
var G__16180 = cljs.core.first(seq16179);
var seq16179__$1 = cljs.core.next(seq16179);
var G__16181 = cljs.core.first(seq16179__$1);
var seq16179__$2 = cljs.core.next(seq16179__$1);
var G__16182 = cljs.core.first(seq16179__$2);
var seq16179__$3 = cljs.core.next(seq16179__$2);
var G__16183 = cljs.core.first(seq16179__$3);
var seq16179__$4 = cljs.core.next(seq16179__$3);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16180,G__16181,G__16182,G__16183,seq16179__$4);
}));

(cljs.core.map.cljs$lang$maxFixedArity = (4));

/**
 * Returns a lazy sequence of the first n items in coll, or all items if
 *   there are fewer than n.  Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.take = (function cljs$core$take(var_args){
var G__16222 = arguments.length;
switch (G__16222) {
case 1:
return cljs.core.take.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.take.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16223(n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function cljs$core$fn_16223_$_fn_16224(rf){
var na = cljs.core.volatile_BANG_(n);
return (function() {
var cljs$core$fn_16223_$_fn_16224_$_fn_16225 = null;
var cljs$core$fn_16223_$_fn_16224_$_fn_16225__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16223_$_fn_16224_$_fn_16225__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16223_$_fn_16224_$_fn_16225__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
var nn = na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));
var result__$1 = (((n__$1 > (0)))?(rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input)):result);
if((!((nn > (0))))){
return cljs.core.ensure_reduced(result__$1);
} else {
return result__$1;
}
});
cljs$core$fn_16223_$_fn_16224_$_fn_16225 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16223_$_fn_16224_$_fn_16225__0.call(this);
case 1:
return cljs$core$fn_16223_$_fn_16224_$_fn_16225__1.call(this,result);
case 2:
return cljs$core$fn_16223_$_fn_16224_$_fn_16225__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16223_$_fn_16224_$_fn_16225.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16223_$_fn_16224_$_fn_16225__0;
cljs$core$fn_16223_$_fn_16224_$_fn_16225.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16223_$_fn_16224_$_fn_16225__1;
cljs$core$fn_16223_$_fn_16224_$_fn_16225.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16223_$_fn_16224_$_fn_16225__2;
return cljs$core$fn_16223_$_fn_16224_$_fn_16225;
})()
});
}));

(cljs.core.take.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16226(n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (new cljs.core.LazySeq(null,(function cljs$core$fn_16226_$_fn_16227(){
if((n > (0))){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
return cljs.core.cons(cljs.core.first(s),cljs.core.take.cljs$core$IFn$_invoke$arity$2((n - (1)),cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.take.cljs$lang$maxFixedArity = 2);

/**
 * Returns a laziness-preserving sequence of all but the first n items in coll.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.drop = (function cljs$core$drop(var_args){
var G__16230 = arguments.length;
switch (G__16230) {
case 1:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16231(n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function cljs$core$fn_16231_$_fn_16232(rf){
var na = cljs.core.volatile_BANG_(n);
return (function() {
var cljs$core$fn_16231_$_fn_16232_$_fn_16233 = null;
var cljs$core$fn_16231_$_fn_16232_$_fn_16233__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16231_$_fn_16232_$_fn_16233__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16231_$_fn_16232_$_fn_16233__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));

if((n__$1 > (0))){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
cljs$core$fn_16231_$_fn_16232_$_fn_16233 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16231_$_fn_16232_$_fn_16233__0.call(this);
case 1:
return cljs$core$fn_16231_$_fn_16232_$_fn_16233__1.call(this,result);
case 2:
return cljs$core$fn_16231_$_fn_16232_$_fn_16233__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16231_$_fn_16232_$_fn_16233.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16231_$_fn_16232_$_fn_16233__0;
cljs$core$fn_16231_$_fn_16232_$_fn_16233.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16231_$_fn_16232_$_fn_16233__1;
cljs$core$fn_16231_$_fn_16232_$_fn_16233.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16231_$_fn_16232_$_fn_16233__2;
return cljs$core$fn_16231_$_fn_16232_$_fn_16233;
})()
});
}));

(cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16234(n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition1$ & (262144))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IDrop$))))?true:false):false)){
var or__9546__auto__ = (((n > (0)))?coll.cljs$core$IDrop$_drop$arity$2(null,Math.ceil(n)):cljs.core.seq(coll));
if(cljs.core.truth_(or__9546__auto__)){
return or__9546__auto__;
} else {
return cljs.core.List.EMPTY;
}
} else {
var step = (function cljs$core$fn_16234_$_fn_16236(n__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if((((n__$1 > (0))) && (s))){
var G__16239 = (n__$1 - (1));
var G__16240 = cljs.core.rest(s);
n__$1 = G__16239;
coll__$1 = G__16240;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16234_$_fn_16237(){
return step(n,coll);
}),null,null));
}
}));

(cljs.core.drop.cljs$lang$maxFixedArity = 2);

/**
 * Return a lazy sequence of all but the last n (default 1) items in coll
 */
cljs.core.drop_last = (function cljs$core$drop_last(var_args){
var G__16242 = arguments.length;
switch (G__16242) {
case 1:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16243(s){
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((1),s);
}));

(cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16244(n,s){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((function cljs$core$fn_16244_$_fn_16245(x,_){
return x;
}),s,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s));
}));

(cljs.core.drop_last.cljs$lang$maxFixedArity = 2);

/**
 * Returns a seq of the last n items in coll.  Depending on the type
 *   of coll may be no better than linear time.  For vectors, see also subvec.
 */
cljs.core.take_last = (function cljs$core$take_last(n,coll){
var s = cljs.core.seq(coll);
var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll));
while(true){
if(lead){
var G__16247 = cljs.core.next(s);
var G__16248 = cljs.core.next(lead);
s = G__16247;
lead = G__16248;
continue;
} else {
return s;
}
break;
}
});
/**
 * Returns a lazy sequence of the items in coll starting from the
 *   first item for which (pred item) returns logical false.  Returns a
 *   stateful transducer when no collection is provided.
 */
cljs.core.drop_while = (function cljs$core$drop_while(var_args){
var G__16250 = arguments.length;
switch (G__16250) {
case 1:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16251(pred){
return (function cljs$core$fn_16251_$_fn_16252(rf){
var da = cljs.core.volatile_BANG_(true);
return (function() {
var cljs$core$fn_16251_$_fn_16252_$_fn_16253 = null;
var cljs$core$fn_16251_$_fn_16252_$_fn_16253__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16251_$_fn_16252_$_fn_16253__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16251_$_fn_16252_$_fn_16253__2 = (function (result,input){
var drop_QMARK_ = cljs.core.deref(da);
if(cljs.core.truth_((function (){var and__9540__auto__ = drop_QMARK_;
if(cljs.core.truth_(and__9540__auto__)){
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input));
} else {
return and__9540__auto__;
}
})())){
return result;
} else {
cljs.core.vreset_BANG_(da,null);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
cljs$core$fn_16251_$_fn_16252_$_fn_16253 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16251_$_fn_16252_$_fn_16253__0.call(this);
case 1:
return cljs$core$fn_16251_$_fn_16252_$_fn_16253__1.call(this,result);
case 2:
return cljs$core$fn_16251_$_fn_16252_$_fn_16253__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16251_$_fn_16252_$_fn_16253.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16251_$_fn_16252_$_fn_16253__0;
cljs$core$fn_16251_$_fn_16252_$_fn_16253.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16251_$_fn_16252_$_fn_16253__1;
cljs$core$fn_16251_$_fn_16252_$_fn_16253.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16251_$_fn_16252_$_fn_16253__2;
return cljs$core$fn_16251_$_fn_16252_$_fn_16253;
})()
});
}));

(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16254(pred,coll){
var step = (function cljs$core$fn_16254_$_fn_16255(pred__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(cljs.core.truth_((function (){var and__9540__auto__ = s;
if(and__9540__auto__){
var G__16256 = cljs.core.first(s);
return (pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__16256) : pred__$1.call(null,G__16256));
} else {
return and__9540__auto__;
}
})())){
var G__16259 = pred__$1;
var G__16260 = cljs.core.rest(s);
pred__$1 = G__16259;
coll__$1 = G__16260;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16254_$_fn_16257(){
return step(pred,coll);
}),null,null));
}));

(cljs.core.drop_while.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Cycle = (function (meta,all,prev,current,_next){
this.meta = meta;
this.all = all;
this.prev = prev;
this.current = current;
this._next = _next;
this.cljs$lang$protocol_mask$partition0$ = 26083532;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.Cycle.prototype.toString = (function cljs$core$fn_16261(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Cycle.prototype.currentval = (function cljs$core$fn_16262(){
var self__ = this;
var coll = this;
if(self__.current){
} else {
var temp__5718__auto___16282 = cljs.core.next(self__.prev);
if(temp__5718__auto___16282){
var c_16283 = temp__5718__auto___16282;
(self__.current = c_16283);
} else {
(self__.current = self__.all);
}
}

return self__.current;
}));

(cljs.core.Cycle.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16263(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Cycle.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16264(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
}));

(cljs.core.Cycle.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16265(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Cycle.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function cljs$core$fn_16266(coll){
var self__ = this;
var coll__$1 = this;
return (!((self__.current == null)));
}));

(cljs.core.Cycle.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16267(coll,f){
var self__ = this;
var coll__$1 = this;
var s = coll__$1.currentval();
var ret = cljs.core.first(s);
while(true){
var s__$1 = (function (){var or__9546__auto__ = cljs.core.next(s);
if(or__9546__auto__){
return or__9546__auto__;
} else {
return self__.all;
}
})();
var ret__$1 = (function (){var G__16270 = ret;
var G__16271 = cljs.core.first(s__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16270,G__16271) : f.call(null,G__16270,G__16271));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__16284 = s__$1;
var G__16285 = ret__$1;
s = G__16284;
ret = G__16285;
continue;
}
break;
}
}));

(cljs.core.Cycle.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16272(coll,f,start){
var self__ = this;
var coll__$1 = this;
var s = coll__$1.currentval();
var ret = start;
while(true){
var ret__$1 = (function (){var G__16273 = ret;
var G__16274 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16273,G__16274) : f.call(null,G__16273,G__16274));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__16286 = (function (){var or__9546__auto__ = cljs.core.next(s);
if(or__9546__auto__){
return or__9546__auto__;
} else {
return self__.all;
}
})();
var G__16287 = ret__$1;
s = G__16286;
ret = G__16287;
continue;
}
break;
}
}));

(cljs.core.Cycle.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16275(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(coll__$1.currentval());
}));

(cljs.core.Cycle.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16276(coll){
var self__ = this;
var coll__$1 = this;
if((self__._next == null)){
(self__._next = (new cljs.core.Cycle(null,self__.all,coll__$1.currentval(),null,null)));
} else {
}

return self__._next;
}));

(cljs.core.Cycle.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16277(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Cycle.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16278(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Cycle(new_meta,self__.all,self__.prev,self__.current,self__._next));
}
}));

(cljs.core.Cycle.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16279(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.Cycle.getBasis = (function cljs$core$fn_16280(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"all","all",-1762306027,null),new cljs.core.Symbol(null,"prev","prev",43462301,null),cljs.core.with_meta(new cljs.core.Symbol(null,"current","current",552492924,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Cycle.cljs$lang$type = true);

(cljs.core.Cycle.cljs$lang$ctorStr = "cljs.core/Cycle");

(cljs.core.Cycle.cljs$lang$ctorPrWriter = (function cljs$core$fn_16281(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/Cycle");
}));

/**
 * Positional factory function for cljs.core/Cycle.
 */
cljs.core.__GT_Cycle = (function cljs$core$__GT_Cycle(meta,all,prev,current,_next){
return (new cljs.core.Cycle(meta,all,prev,current,_next));
});

/**
 * Returns a lazy (infinite!) sequence of repetitions of the items in coll.
 */
cljs.core.cycle = (function cljs$core$cycle(coll){
var temp__5718__auto__ = cljs.core.seq(coll);
if(temp__5718__auto__){
var vals = temp__5718__auto__;
return (new cljs.core.Cycle(null,vals,null,vals,null));
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a vector of [(take n coll) (drop n coll)]
 */
cljs.core.split_at = (function cljs$core$split_at(n,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll),cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll)], null);
});

/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Repeat = (function (meta,count,val,next,__hash){
this.meta = meta;
this.count = count;
this.val = val;
this.next = next;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 262145;
});
(cljs.core.Repeat.prototype.toString = (function cljs$core$fn_16288(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Repeat.prototype.equiv = (function cljs$core$fn_16289(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Repeat.prototype.indexOf = (function() {
var cljs$core$fn_16290 = null;
var cljs$core$fn_16290__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16290__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16290 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16290__1.call(this,x);
case 2:
return cljs$core$fn_16290__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16290.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16290__1;
cljs$core$fn_16290.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16290__2;
return cljs$core$fn_16290;
})()
);

(cljs.core.Repeat.prototype.lastIndexOf = (function() {
var cljs$core$fn_16291 = null;
var cljs$core$fn_16291__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,self__.count);
});
var cljs$core$fn_16291__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16291 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16291__1.call(this,x);
case 2:
return cljs$core$fn_16291__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16291.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16291__1;
cljs$core$fn_16291.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16291__2;
return cljs$core$fn_16291;
})()
);

(cljs.core.Repeat.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16292(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Repeat.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16293(coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
if((self__.count > (1))){
(self__.next = (new cljs.core.Repeat(null,(self__.count - (1)),self__.val,null,null)));

return self__.next;
} else {
if(((-1) === self__.count)){
return coll__$1;
} else {
return null;
}
}
} else {
return self__.next;
}
}));

(cljs.core.Repeat.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16294(coll){
var self__ = this;
var coll__$1 = this;
var h__10007__auto__ = self__.__hash;
if((!((h__10007__auto__ == null)))){
return h__10007__auto__;
} else {
var h__10007__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10007__auto____$1);

return h__10007__auto____$1;
}
}));

(cljs.core.Repeat.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16295(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.Repeat.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16296(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Repeat.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function cljs$core$fn_16297(coll){
var self__ = this;
var coll__$1 = this;
return false;
}));

(cljs.core.Repeat.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16298(coll,f){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
var ret = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(self__.val,self__.val) : f.call(null,self__.val,self__.val));
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var G__16308 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
ret = G__16308;
continue;
}
break;
}
} else {
var i = (1);
var ret = self__.val;
while(true){
if((i < self__.count)){
var ret__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__16309 = (i + (1));
var G__16310 = ret__$1;
i = G__16309;
ret = G__16310;
continue;
}
} else {
return ret;
}
break;
}
}
}));

(cljs.core.Repeat.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16299(coll,f,start){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
var ret = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(start,self__.val) : f.call(null,start,self__.val));
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var G__16311 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
ret = G__16311;
continue;
}
break;
}
} else {
var i = (0);
var ret = start;
while(true){
if((i < self__.count)){
var ret__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__16312 = (i + (1));
var G__16313 = ret__$1;
i = G__16312;
ret = G__16313;
continue;
}
} else {
return ret;
}
break;
}
}
}));

(cljs.core.Repeat.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16300(coll){
var self__ = this;
var coll__$1 = this;
return self__.val;
}));

(cljs.core.Repeat.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16301(coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
if((self__.count > (1))){
(self__.next = (new cljs.core.Repeat(null,(self__.count - (1)),self__.val,null,null)));

return self__.next;
} else {
if(((-1) === self__.count)){
return coll__$1;
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return self__.next;
}
}));

(cljs.core.Repeat.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16302(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Repeat.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16303(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Repeat(new_meta,self__.count,self__.val,self__.next,null));
}
}));

(cljs.core.Repeat.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16304(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.Repeat.prototype.cljs$core$IDrop$_drop$arity$2 = (function cljs$core$fn_16305(coll,n){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
return coll__$1;
} else {
var dropped_count = (self__.count - n);
if((dropped_count > (0))){
return (new cljs.core.Repeat(null,dropped_count,self__.val,null,null));
} else {
return null;
}
}
}));

(cljs.core.Repeat.getBasis = (function cljs$core$fn_16306(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.with_meta(new cljs.core.Symbol(null,"next","next",1522830042,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Repeat.cljs$lang$type = true);

(cljs.core.Repeat.cljs$lang$ctorStr = "cljs.core/Repeat");

(cljs.core.Repeat.cljs$lang$ctorPrWriter = (function cljs$core$fn_16307(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/Repeat");
}));

/**
 * Positional factory function for cljs.core/Repeat.
 */
cljs.core.__GT_Repeat = (function cljs$core$__GT_Repeat(meta,count,val,next,__hash){
return (new cljs.core.Repeat(meta,count,val,next,__hash));
});

/**
 * Returns a lazy (infinite!, or length n if supplied) sequence of xs.
 */
cljs.core.repeat = (function cljs$core$repeat(var_args){
var G__16315 = arguments.length;
switch (G__16315) {
case 1:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16316(x){
return (new cljs.core.Repeat(null,(-1),x,null,null));
}));

(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16317(n,x){
if((n > (0))){
return (new cljs.core.Repeat(null,n,x,null,null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.repeat.cljs$lang$maxFixedArity = 2);

/**
 * DEPRECATED: Use 'repeat' instead.
 *   Returns a lazy seq of n xs.
 */
cljs.core.replicate = (function cljs$core$replicate(n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});
/**
 * Takes a function of no args, presumably with side effects, and
 *   returns an infinite (or length n if supplied) lazy sequence of calls
 *   to it
 */
cljs.core.repeatedly = (function cljs$core$repeatedly(var_args){
var G__16320 = arguments.length;
switch (G__16320) {
case 1:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16321(f){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16321_$_fn_16322(){
return cljs.core.cons((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}),null,null));
}));

(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16323(n,f){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}));

(cljs.core.repeatedly.cljs$lang$maxFixedArity = 2);

cljs.core.UNREALIZED_SEED = ({});

/**
* @constructor
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Iterate = (function (meta,f,prev_seed,seed,next){
this.meta = meta;
this.f = f;
this.prev_seed = prev_seed;
this.seed = seed;
this.next = next;
this.cljs$lang$protocol_mask$partition0$ = 26083532;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.Iterate.prototype.toString = (function cljs$core$fn_16325(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Iterate.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16326(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Iterate.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16327(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
}));

(cljs.core.Iterate.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16328(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Iterate.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function cljs$core$fn_16329(coll){
var self__ = this;
var coll__$1 = this;
return (!((self__.seed === cljs.core.UNREALIZED_SEED)));
}));

(cljs.core.Iterate.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16330(coll,rf){
var self__ = this;
var coll__$1 = this;
var first = coll__$1.cljs$core$ISeq$_first$arity$1(null);
var v = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(first) : self__.f.call(null,first));
var ret = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(first,v) : rf.call(null,first,v));
var v__$1 = v;
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var v__$2 = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(v__$1) : self__.f.call(null,v__$1));
var G__16339 = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(ret,v__$2) : rf.call(null,ret,v__$2));
var G__16340 = v__$2;
ret = G__16339;
v__$1 = G__16340;
continue;
}
break;
}
}));

(cljs.core.Iterate.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16331(coll,rf,start){
var self__ = this;
var coll__$1 = this;
var v = coll__$1.cljs$core$ISeq$_first$arity$1(null);
var ret = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(start,v) : rf.call(null,start,v));
var v__$1 = v;
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var v__$2 = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(v__$1) : self__.f.call(null,v__$1));
var G__16341 = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(ret,v__$2) : rf.call(null,ret,v__$2));
var G__16342 = v__$2;
ret = G__16341;
v__$1 = G__16342;
continue;
}
break;
}
}));

(cljs.core.Iterate.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16332(coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.UNREALIZED_SEED === self__.seed)){
(self__.seed = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(self__.prev_seed) : self__.f.call(null,self__.prev_seed)));
} else {
}

return self__.seed;
}));

(cljs.core.Iterate.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16333(coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
(self__.next = (new cljs.core.Iterate(null,self__.f,coll__$1.cljs$core$ISeq$_first$arity$1(null),cljs.core.UNREALIZED_SEED,null)));
} else {
}

return self__.next;
}));

(cljs.core.Iterate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16334(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Iterate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16335(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Iterate(new_meta,self__.f,self__.prev_seed,self__.seed,self__.next));
}
}));

(cljs.core.Iterate.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16336(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.Iterate.getBasis = (function cljs$core$fn_16337(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"prev-seed","prev-seed",2126381367,null),cljs.core.with_meta(new cljs.core.Symbol(null,"seed","seed",1709144854,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next","next",1522830042,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Iterate.cljs$lang$type = true);

(cljs.core.Iterate.cljs$lang$ctorStr = "cljs.core/Iterate");

(cljs.core.Iterate.cljs$lang$ctorPrWriter = (function cljs$core$fn_16338(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/Iterate");
}));

/**
 * Positional factory function for cljs.core/Iterate.
 */
cljs.core.__GT_Iterate = (function cljs$core$__GT_Iterate(meta,f,prev_seed,seed,next){
return (new cljs.core.Iterate(meta,f,prev_seed,seed,next));
});

/**
 * Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects
 */
cljs.core.iterate = (function cljs$core$iterate(f,x){
return (new cljs.core.Iterate(null,f,null,x,null));
});
/**
 * Returns a lazy seq of the first item in each coll, then the second etc.
 */
cljs.core.interleave = (function cljs$core$interleave(var_args){
var G__16347 = arguments.length;
switch (G__16347) {
case 0:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___16357 = arguments.length;
var i__10876__auto___16358 = (0);
while(true){
if((i__10876__auto___16358 < len__10875__auto___16357)){
args_arr__10904__auto__.push((arguments[i__10876__auto___16358]));

var G__16359 = (i__10876__auto___16358 + (1));
i__10876__auto___16358 = G__16359;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((2) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((2)),(0),null)):null);
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10905__auto__);

}
});

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_16348(){
return cljs.core.List.EMPTY;
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16349(c1){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16349_$_fn_16350(){
return c1;
}),null,null));
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16351(c1,c2){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16351_$_fn_16352(){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if(((s1) && (s2))){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
return null;
}
}),null,null));
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16353(c1,c2,colls){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16353_$_fn_16354(){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c1], 0)));
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
}));

/** @this {Function} */
(cljs.core.interleave.cljs$lang$applyTo = (function cljs$core$fn_16355(seq16344){
var G__16345 = cljs.core.first(seq16344);
var seq16344__$1 = cljs.core.next(seq16344);
var G__16346 = cljs.core.first(seq16344__$1);
var seq16344__$2 = cljs.core.next(seq16344__$1);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16345,G__16346,seq16344__$2);
}));

(cljs.core.interleave.cljs$lang$maxFixedArity = (2));

/**
 * Returns a lazy seq of the elements of coll separated by sep.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.interpose = (function cljs$core$interpose(var_args){
var G__16361 = arguments.length;
switch (G__16361) {
case 1:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16362(sep){
return (function cljs$core$fn_16362_$_fn_16363(rf){
var started = cljs.core.volatile_BANG_(false);
return (function() {
var cljs$core$fn_16362_$_fn_16363_$_fn_16364 = null;
var cljs$core$fn_16362_$_fn_16363_$_fn_16364__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16362_$_fn_16363_$_fn_16364__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16362_$_fn_16363_$_fn_16364__2 = (function (result,input){
if(cljs.core.truth_(cljs.core.deref(started))){
var sepr = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,sep) : rf.call(null,result,sep));
if(cljs.core.reduced_QMARK_(sepr)){
return sepr;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(sepr,input) : rf.call(null,sepr,input));
}
} else {
cljs.core.vreset_BANG_(started,true);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
cljs$core$fn_16362_$_fn_16363_$_fn_16364 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16362_$_fn_16363_$_fn_16364__0.call(this);
case 1:
return cljs$core$fn_16362_$_fn_16363_$_fn_16364__1.call(this,result);
case 2:
return cljs$core$fn_16362_$_fn_16363_$_fn_16364__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16362_$_fn_16363_$_fn_16364.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16362_$_fn_16363_$_fn_16364__0;
cljs$core$fn_16362_$_fn_16363_$_fn_16364.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16362_$_fn_16363_$_fn_16364__1;
cljs$core$fn_16362_$_fn_16363_$_fn_16364.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16362_$_fn_16363_$_fn_16364__2;
return cljs$core$fn_16362_$_fn_16363_$_fn_16364;
})()
});
}));

(cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16365(sep,coll){
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep),coll));
}));

(cljs.core.interpose.cljs$lang$maxFixedArity = 2);

/**
 * Take a collection of collections, and return a lazy seq
 *   of items from the inner collection
 */
cljs.core.flatten1 = (function cljs$core$flatten1(colls){
var cat = (function cljs$core$flatten1_$_cat(coll,colls__$1){
return (new cljs.core.LazySeq(null,(function cljs$core$flatten1_$_cat_$_fn_16367(){
var temp__5718__auto__ = cljs.core.seq(coll);
if(temp__5718__auto__){
var coll__$1 = temp__5718__auto__;
return cljs.core.cons(cljs.core.first(coll__$1),cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1),colls__$1));
} else {
if(cljs.core.seq(colls__$1)){
return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1),cljs.core.rest(colls__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(null,colls);
});
/**
 * Returns the result of applying concat to the result of applying map
 *   to f and colls.  Thus function f should return a collection. Returns
 *   a transducer when no collections are provided
 */
cljs.core.mapcat = (function cljs$core$mapcat(var_args){
var G__16371 = arguments.length;
switch (G__16371) {
case 1:
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___16376 = arguments.length;
var i__10876__auto___16377 = (0);
while(true){
if((i__10876__auto___16377 < len__10875__auto___16376)){
args_arr__10904__auto__.push((arguments[i__10876__auto___16377]));

var G__16378 = (i__10876__auto___16377 + (1));
i__10876__auto___16377 = G__16378;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((1) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((1)),(0),null)):null);
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10905__auto__);

}
});

(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16372(f){
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f),cljs.core.cat);
}));

(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16373(f,colls){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map,f,colls));
}));

/** @this {Function} */
(cljs.core.mapcat.cljs$lang$applyTo = (function cljs$core$fn_16374(seq16369){
var G__16370 = cljs.core.first(seq16369);
var seq16369__$1 = cljs.core.next(seq16369);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16370,seq16369__$1);
}));

(cljs.core.mapcat.cljs$lang$maxFixedArity = (1));

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns logical true. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.filter = (function cljs$core$filter(var_args){
var G__16380 = arguments.length;
switch (G__16380) {
case 1:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16381(pred){
return (function cljs$core$fn_16381_$_fn_16382(rf){
return (function() {
var cljs$core$fn_16381_$_fn_16382_$_fn_16383 = null;
var cljs$core$fn_16381_$_fn_16382_$_fn_16383__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16381_$_fn_16382_$_fn_16383__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16381_$_fn_16382_$_fn_16383__2 = (function (result,input){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input)))){
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
} else {
return result;
}
});
cljs$core$fn_16381_$_fn_16382_$_fn_16383 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16381_$_fn_16382_$_fn_16383__0.call(this);
case 1:
return cljs$core$fn_16381_$_fn_16382_$_fn_16383__1.call(this,result);
case 2:
return cljs$core$fn_16381_$_fn_16382_$_fn_16383__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16381_$_fn_16382_$_fn_16383.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16381_$_fn_16382_$_fn_16383__0;
cljs$core$fn_16381_$_fn_16382_$_fn_16383.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16381_$_fn_16382_$_fn_16383__1;
cljs$core$fn_16381_$_fn_16382_$_fn_16383.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16381_$_fn_16382_$_fn_16383__2;
return cljs$core$fn_16381_$_fn_16382_$_fn_16383;
})()
});
}));

(cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16384(pred,coll){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16384_$_fn_16385(){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__10634__auto___16388 = size;
var i_16389 = (0);
while(true){
if((i_16389 < n__10634__auto___16388)){
if(cljs.core.truth_((function (){var G__16386 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_16389);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__16386) : pred.call(null,G__16386));
})())){
cljs.core.chunk_append(b,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_16389));
} else {
}

var G__16390 = (i_16389 + (1));
i_16389 = G__16390;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.chunk_rest(s)));
} else {
var f = cljs.core.first(s);
var r = cljs.core.rest(s);
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(f) : pred.call(null,f)))){
return cljs.core.cons(f,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r));
} else {
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r);
}
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.filter.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns logical false. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.remove = (function cljs$core$remove(var_args){
var G__16392 = arguments.length;
switch (G__16392) {
case 1:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16393(pred){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
}));

(cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16394(pred,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred),coll);
}));

(cljs.core.remove.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the nodes in a tree, via a depth-first walk.
 *   branch? must be a fn of one arg that returns true if passed a node
 *   that can have children (but may not).  children must be a fn of one
 *   arg that returns a sequence of the children. Will only be called on
 *   nodes for which branch? returns true. Root is the root node of the
 *   tree.
 */
cljs.core.tree_seq = (function cljs$core$tree_seq(branch_QMARK_,children,root){
var walk = (function cljs$core$tree_seq_$_walk(node){
return (new cljs.core.LazySeq(null,(function cljs$core$tree_seq_$_walk_$_fn_16396(){
return cljs.core.cons(node,(cljs.core.truth_((branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(node) : branch_QMARK_.call(null,node)))?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(node) : children.call(null,node))], 0)):null));
}),null,null));
});
return walk(root);
});
/**
 * Takes any nested combination of sequential things (lists, vectors,
 *   etc.) and returns their contents as a single, flat sequence.
 *   (flatten nil) returns nil.
 */
cljs.core.flatten = (function cljs$core$flatten(x){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function cljs$core$flatten_$_fn_16398(p1__16397_SHARP_){
return (!(cljs.core.sequential_QMARK_(p1__16397_SHARP_)));
}),cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_,cljs.core.seq,x)));
});
/**
 * Returns a new coll consisting of to-coll with all of the items of
 *   from-coll conjoined. A transducer may be supplied.
 */
cljs.core.into = (function cljs$core$into(var_args){
var G__16400 = arguments.length;
switch (G__16400) {
case 0:
return cljs.core.into.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.into.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.into.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.into.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_16401(){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16402(to){
return to;
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16403(to,from){
if((!((to == null)))){
if((((!((to == null))))?(((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$))))?true:false):false)){
return cljs.core._with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,to,from);
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,to,from);
}
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16405(to,xform,from){
if((((!((to == null))))?(((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$))))?true:false):false)){
var tm = cljs.core.meta(to);
var rf = (function() {
var cljs$core$fn_16405_$_fn_16407 = null;
var cljs$core$fn_16405_$_fn_16407__1 = (function (coll){
return cljs.core._with_meta(cljs.core.persistent_BANG_(coll),tm);
});
var cljs$core$fn_16405_$_fn_16407__2 = (function (coll,v){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(coll,v);
});
cljs$core$fn_16405_$_fn_16407 = function(coll,v){
switch(arguments.length){
case 1:
return cljs$core$fn_16405_$_fn_16407__1.call(this,coll);
case 2:
return cljs$core$fn_16405_$_fn_16407__2.call(this,coll,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16405_$_fn_16407.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16405_$_fn_16407__1;
cljs$core$fn_16405_$_fn_16407.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16405_$_fn_16407__2;
return cljs$core$fn_16405_$_fn_16407;
})()
;
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,rf,cljs.core.transient$(to),from);
} else {
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj,to,from);
}
}));

(cljs.core.into.cljs$lang$maxFixedArity = 3);

/**
 * Returns a vector consisting of the result of applying f to the
 *   set of first items of each coll, followed by applying f to the set
 *   of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments.
 */
cljs.core.mapv = (function cljs$core$mapv(var_args){
var G__16415 = arguments.length;
switch (G__16415) {
case 2:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___16423 = arguments.length;
var i__10876__auto___16424 = (0);
while(true){
if((i__10876__auto___16424 < len__10875__auto___16423)){
args_arr__10904__auto__.push((arguments[i__10876__auto___16424]));

var G__16425 = (i__10876__auto___16424 + (1));
i__10876__auto___16424 = G__16425;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((4) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((4)),(0),null)):null);
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10905__auto__);

}
});

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16416(f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function cljs$core$fn_16416_$_fn_16417(v,o){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(o) : f.call(null,o)));
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16418(f,c1,c2){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,c1,c2));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16419(f,c1,c2,c3){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,c1,c2,c3));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16420(f,c1,c2,c3,colls){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,f,c1,c2,c3,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([colls], 0)));
}));

/** @this {Function} */
(cljs.core.mapv.cljs$lang$applyTo = (function cljs$core$fn_16421(seq16410){
var G__16411 = cljs.core.first(seq16410);
var seq16410__$1 = cljs.core.next(seq16410);
var G__16412 = cljs.core.first(seq16410__$1);
var seq16410__$2 = cljs.core.next(seq16410__$1);
var G__16413 = cljs.core.first(seq16410__$2);
var seq16410__$3 = cljs.core.next(seq16410__$2);
var G__16414 = cljs.core.first(seq16410__$3);
var seq16410__$4 = cljs.core.next(seq16410__$3);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16411,G__16412,G__16413,G__16414,seq16410__$4);
}));

(cljs.core.mapv.cljs$lang$maxFixedArity = (4));

/**
 * Returns a vector of the items in coll for which
 *   (pred item) returns logical true. pred must be free of side-effects.
 */
cljs.core.filterv = (function cljs$core$filterv(pred,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function cljs$core$filterv_$_fn_16426(v,o){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(o) : pred.call(null,o)))){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,o);
} else {
return v;
}
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
/**
 * Returns a lazy sequence of lists of n items each, at offsets step
 *   apart. If step is not supplied, defaults to n, i.e. the partitions
 *   do not overlap. If a pad collection is supplied, use its elements as
 *   necessary to complete last partition up to n items. In case there are
 *   not enough padding elements, return a partition with less than n items.
 */
cljs.core.partition = (function cljs$core$partition(var_args){
var G__16428 = arguments.length;
switch (G__16428) {
case 2:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16429(n,coll){
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,n,coll);
}));

(cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16430(n,step,coll){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16430_$_fn_16431(){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16432(n,step,pad,coll){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16432_$_fn_16433(){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n,step,pad,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return (new cljs.core.List(null,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p,pad)),null,(1),null));
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.partition.cljs$lang$maxFixedArity = 4);

/**
 * Returns the value in a nested associative structure,
 *   where ks is a sequence of keys. Returns nil if the key is not present,
 *   or the not-found value if supplied.
 */
cljs.core.get_in = (function cljs$core$get_in(var_args){
var G__16436 = arguments.length;
switch (G__16436) {
case 2:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16437(m,ks){
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if((ks__$1 == null)){
return m__$1;
} else {
var G__16440 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m__$1,cljs.core.first(ks__$1));
var G__16441 = cljs.core.next(ks__$1);
m__$1 = G__16440;
ks__$1 = G__16441;
continue;
}
break;
}
}));

(cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16438(m,ks,not_found){
var sentinel = cljs.core.lookup_sentinel;
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if((!((ks__$1 == null)))){
var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.first(ks__$1),sentinel);
if((sentinel === m__$2)){
return not_found;
} else {
var G__16442 = sentinel;
var G__16443 = m__$2;
var G__16444 = cljs.core.next(ks__$1);
sentinel = G__16442;
m__$1 = G__16443;
ks__$1 = G__16444;
continue;
}
} else {
return m__$1;
}
break;
}
}));

(cljs.core.get_in.cljs$lang$maxFixedArity = 3);

/**
 * Associates a value in a nested associative structure, where ks is a
 *   sequence of keys and v is the new value and returns a new nested structure.
 *   If any levels do not exist, hash-maps will be created.
 */
cljs.core.assoc_in = (function cljs$core$assoc_in(m,p__16445,v){
var vec__16446 = p__16445;
var seq__16447 = cljs.core.seq(vec__16446);
var first__16448 = cljs.core.first(seq__16447);
var seq__16447__$1 = cljs.core.next(seq__16447);
var k = first__16448;
var ks = seq__16447__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16449 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16450 = ks;
var G__16451 = v;
return (cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3 ? cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3(G__16449,G__16450,G__16451) : cljs.core.assoc_in.call(null,G__16449,G__16450,G__16451));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
/**
 * 'Updates' a value in a nested associative structure, where ks is a
 *   sequence of keys and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   nested structure.  If any levels do not exist, hash-maps will be
 *   created.
 */
cljs.core.update_in = (function cljs$core$update_in(var_args){
var G__16460 = arguments.length;
switch (G__16460) {
case 3:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___16498 = arguments.length;
var i__10876__auto___16499 = (0);
while(true){
if((i__10876__auto___16499 < len__10875__auto___16498)){
args_arr__10904__auto__.push((arguments[i__10876__auto___16499]));

var G__16500 = (i__10876__auto___16499 + (1));
i__10876__auto___16499 = G__16500;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((6) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((6)),(0),null)):null);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__10905__auto__);

}
});

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16462(m,p__16461,f){
var vec__16463 = p__16461;
var seq__16464 = cljs.core.seq(vec__16463);
var first__16465 = cljs.core.first(seq__16464);
var seq__16464__$1 = cljs.core.next(seq__16464);
var k = first__16465;
var ks = seq__16464__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16466 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16466) : f.call(null,G__16466));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16468(m,p__16467,f,a){
var vec__16469 = p__16467;
var seq__16470 = cljs.core.seq(vec__16469);
var first__16471 = cljs.core.first(seq__16470);
var seq__16470__$1 = cljs.core.next(seq__16470);
var k = first__16471;
var ks = seq__16470__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16472 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16473 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16472,G__16473) : f.call(null,G__16472,G__16473));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_16475(m,p__16474,f,a,b){
var vec__16476 = p__16474;
var seq__16477 = cljs.core.seq(vec__16476);
var first__16478 = cljs.core.first(seq__16477);
var seq__16477__$1 = cljs.core.next(seq__16477);
var k = first__16478;
var ks = seq__16477__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16479 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16480 = a;
var G__16481 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16479,G__16480,G__16481) : f.call(null,G__16479,G__16480,G__16481));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_16483(m,p__16482,f,a,b,c){
var vec__16484 = p__16482;
var seq__16485 = cljs.core.seq(vec__16484);
var first__16486 = cljs.core.first(seq__16485);
var seq__16485__$1 = cljs.core.next(seq__16485);
var k = first__16486;
var ks = seq__16485__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b,c));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16487 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16488 = a;
var G__16489 = b;
var G__16490 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__16487,G__16488,G__16489,G__16490) : f.call(null,G__16487,G__16488,G__16489,G__16490));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16492(m,p__16491,f,a,b,c,args){
var vec__16493 = p__16491;
var seq__16494 = cljs.core.seq(vec__16493);
var first__16495 = cljs.core.first(seq__16494);
var seq__16494__$1 = cljs.core.next(seq__16494);
var k = first__16495;
var ks = seq__16494__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([b,c,args], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),a,b,c,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0)));
}
}));

/** @this {Function} */
(cljs.core.update_in.cljs$lang$applyTo = (function cljs$core$fn_16496(seq16453){
var G__16454 = cljs.core.first(seq16453);
var seq16453__$1 = cljs.core.next(seq16453);
var G__16455 = cljs.core.first(seq16453__$1);
var seq16453__$2 = cljs.core.next(seq16453__$1);
var G__16456 = cljs.core.first(seq16453__$2);
var seq16453__$3 = cljs.core.next(seq16453__$2);
var G__16457 = cljs.core.first(seq16453__$3);
var seq16453__$4 = cljs.core.next(seq16453__$3);
var G__16458 = cljs.core.first(seq16453__$4);
var seq16453__$5 = cljs.core.next(seq16453__$4);
var G__16459 = cljs.core.first(seq16453__$5);
var seq16453__$6 = cljs.core.next(seq16453__$5);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16454,G__16455,G__16456,G__16457,G__16458,G__16459,seq16453__$6);
}));

(cljs.core.update_in.cljs$lang$maxFixedArity = (6));

/**
 * 'Updates' a value in an associative structure, where k is a
 *   key and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   structure.  If the key does not exist, nil is passed as the old value.
 */
cljs.core.update = (function cljs$core$update(var_args){
var G__16509 = arguments.length;
switch (G__16509) {
case 3:
return cljs.core.update.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__10904__auto__ = [];
var len__10875__auto___16527 = arguments.length;
var i__10876__auto___16528 = (0);
while(true){
if((i__10876__auto___16528 < len__10875__auto___16527)){
args_arr__10904__auto__.push((arguments[i__10876__auto___16528]));

var G__16529 = (i__10876__auto___16528 + (1));
i__10876__auto___16528 = G__16529;
continue;
} else {
}
break;
}

var argseq__10905__auto__ = ((((6) < args_arr__10904__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10904__auto__.slice((6)),(0),null)):null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__10905__auto__);

}
});

(cljs.core.update.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16510(m,k,f){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16511 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16511) : f.call(null,G__16511));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16512(m,k,f,x){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16513 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16514 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16513,G__16514) : f.call(null,G__16513,G__16514));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_16515(m,k,f,x,y){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16516 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16517 = x;
var G__16518 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16516,G__16517,G__16518) : f.call(null,G__16516,G__16517,G__16518));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_16519(m,k,f,x,y,z){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16520 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16521 = x;
var G__16522 = y;
var G__16523 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__16520,G__16521,G__16522,G__16523) : f.call(null,G__16520,G__16521,G__16522,G__16523));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16524(m,k,f,x,y,z,more){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),x,y,z,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([more], 0)));
}));

/** @this {Function} */
(cljs.core.update.cljs$lang$applyTo = (function cljs$core$fn_16525(seq16502){
var G__16503 = cljs.core.first(seq16502);
var seq16502__$1 = cljs.core.next(seq16502);
var G__16504 = cljs.core.first(seq16502__$1);
var seq16502__$2 = cljs.core.next(seq16502__$1);
var G__16505 = cljs.core.first(seq16502__$2);
var seq16502__$3 = cljs.core.next(seq16502__$2);
var G__16506 = cljs.core.first(seq16502__$3);
var seq16502__$4 = cljs.core.next(seq16502__$3);
var G__16507 = cljs.core.first(seq16502__$4);
var seq16502__$5 = cljs.core.next(seq16502__$4);
var G__16508 = cljs.core.first(seq16502__$5);
var seq16502__$6 = cljs.core.next(seq16502__$5);
var self__10860__auto__ = this;
return self__10860__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16503,G__16504,G__16505,G__16506,G__16507,G__16508,seq16502__$6);
}));

(cljs.core.update.cljs$lang$maxFixedArity = (6));


/**
* @constructor
*/
cljs.core.VectorNode = (function (edit,arr){
this.edit = edit;
this.arr = arr;
});

(cljs.core.VectorNode.getBasis = (function cljs$core$fn_16530(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null);
}));

(cljs.core.VectorNode.cljs$lang$type = true);

(cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode");

(cljs.core.VectorNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_16531(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/VectorNode");
}));

/**
 * Positional factory function for cljs.core/VectorNode.
 */
cljs.core.__GT_VectorNode = (function cljs$core$__GT_VectorNode(edit,arr){
return (new cljs.core.VectorNode(edit,arr));
});

cljs.core.pv_fresh_node = (function cljs$core$pv_fresh_node(edit){
return (new cljs.core.VectorNode(edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
});
cljs.core.pv_aget = (function cljs$core$pv_aget(node,idx){
return (node.arr[idx]);
});
cljs.core.pv_aset = (function cljs$core$pv_aset(node,idx,val){
return (node.arr[idx] = val);
});
cljs.core.pv_clone_node = (function cljs$core$pv_clone_node(node){
return (new cljs.core.VectorNode(node.edit,cljs.core.aclone(node.arr)));
});
cljs.core.tail_off = (function cljs$core$tail_off(pv){
var cnt = pv.cnt;
if((cnt < (32))){
return (0);
} else {
return (((cnt - (1)) >>> (5)) << (5));
}
});
cljs.core.new_path = (function cljs$core$new_path(edit,level,node){
var ll = level;
var ret = node;
while(true){
if((ll === (0))){
return ret;
} else {
var embed = ret;
var r = cljs.core.pv_fresh_node(edit);
var _ = cljs.core.pv_aset(r,(0),embed);
var G__16532 = (ll - (5));
var G__16533 = r;
ll = G__16532;
ret = G__16533;
continue;
}
break;
}
});
cljs.core.push_tail = (function cljs$core$push_tail(pv,level,parent,tailnode){
var ret = cljs.core.pv_clone_node(parent);
var subidx = (((pv.cnt - (1)) >>> level) & (31));
if(((5) === level)){
cljs.core.pv_aset(ret,subidx,tailnode);

return ret;
} else {
var child = cljs.core.pv_aget(parent,subidx);
if((!((child == null)))){
var node_to_insert = (function (){var G__16534 = pv;
var G__16535 = (level - (5));
var G__16536 = child;
var G__16537 = tailnode;
return (cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4(G__16534,G__16535,G__16536,G__16537) : cljs.core.push_tail.call(null,G__16534,G__16535,G__16536,G__16537));
})();
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
} else {
var node_to_insert = cljs.core.new_path(null,(level - (5)),tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
}
}
});
cljs.core.vector_index_out_of_bounds = (function cljs$core$vector_index_out_of_bounds(i,cnt){
throw (new Error(["No item ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i)," in vector of length ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cnt)].join('')));
});
cljs.core.first_array_for_longvec = (function cljs$core$first_array_for_longvec(pv){
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__16538 = cljs.core.pv_aget(node,(0));
var G__16539 = (level - (5));
node = G__16538;
level = G__16539;
continue;
} else {
return node.arr;
}
break;
}
});
cljs.core.unchecked_array_for = (function cljs$core$unchecked_array_for(pv,i){
if((i >= cljs.core.tail_off(pv))){
return pv.tail;
} else {
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__16540 = cljs.core.pv_aget(node,((i >>> level) & (31)));
var G__16541 = (level - (5));
node = G__16540;
level = G__16541;
continue;
} else {
return node.arr;
}
break;
}
}
});
cljs.core.array_for = (function cljs$core$array_for(pv,i){
if(((((0) <= i)) && ((i < pv.cnt)))){
return cljs.core.unchecked_array_for(pv,i);
} else {
return cljs.core.vector_index_out_of_bounds(i,pv.cnt);
}
});
cljs.core.do_assoc = (function cljs$core$do_assoc(pv,level,node,i,val){
var ret = cljs.core.pv_clone_node(node);
if((level === (0))){
cljs.core.pv_aset(ret,(i & (31)),val);

return ret;
} else {
var subidx = ((i >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(function (){var G__16542 = pv;
var G__16543 = (level - (5));
var G__16544 = cljs.core.pv_aget(node,subidx);
var G__16545 = i;
var G__16546 = val;
return (cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5 ? cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5(G__16542,G__16543,G__16544,G__16545,G__16546) : cljs.core.do_assoc.call(null,G__16542,G__16543,G__16544,G__16545,G__16546));
})());

return ret;
}
});
cljs.core.pop_tail = (function cljs$core$pop_tail(pv,level,node){
var subidx = (((pv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = (function (){var G__16547 = pv;
var G__16548 = (level - (5));
var G__16549 = cljs.core.pv_aget(node,subidx);
return (cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3(G__16547,G__16548,G__16549) : cljs.core.pop_tail.call(null,G__16547,G__16548,G__16549));
})();
if((((new_child == null)) && ((subidx === (0))))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,new_child);

return ret;
}
} else {
if((subidx === (0))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,null);

return ret;

}
}
});

/**
* @constructor
*/
cljs.core.RangedIterator = (function (i,base,arr,v,start,end){
this.i = i;
this.base = base;
this.arr = arr;
this.v = v;
this.start = start;
this.end = end;
});
(cljs.core.RangedIterator.prototype.hasNext = (function cljs$core$fn_16550(){
var self__ = this;
var this$ = this;
return (self__.i < self__.end);
}));

(cljs.core.RangedIterator.prototype.next = (function cljs$core$fn_16551(){
var self__ = this;
var this$ = this;
if(((self__.i - self__.base) === (32))){
(self__.arr = cljs.core.unchecked_array_for(self__.v,self__.i));

(self__.base = (self__.base + (32)));
} else {
}

var ret = (self__.arr[(self__.i & (31))]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.RangedIterator.getBasis = (function cljs$core$fn_16552(){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"base","base",1825810849,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null);
}));

(cljs.core.RangedIterator.cljs$lang$type = true);

(cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator");

(cljs.core.RangedIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_16553(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/RangedIterator");
}));

/**
 * Positional factory function for cljs.core/RangedIterator.
 */
cljs.core.__GT_RangedIterator = (function cljs$core$__GT_RangedIterator(i,base,arr,v,start,end){
return (new cljs.core.RangedIterator(i,base,arr,v,start,end));
});

cljs.core.ranged_iterator = (function cljs$core$ranged_iterator(v,start,end){
var i = start;
return (new cljs.core.RangedIterator(i,(i - (i % (32))),(((start < cljs.core.count(v)))?cljs.core.unchecked_array_for(v,i):null),v,start,end));
});
cljs.core.pv_reduce = (function cljs$core$pv_reduce(var_args){
var G__16555 = arguments.length;
switch (G__16555) {
case 4:
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16556(pv,f,start,end){
if((start < end)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(pv,f,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pv,start),(start + (1)),end);
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
}));

(cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_16557(pv,f,init,start,end){
var acc = init;
var i = start;
var arr = cljs.core.unchecked_array_for(pv,start);
while(true){
if((i < end)){
var j = (i & (31));
var arr__$1 = (((j === (0)))?cljs.core.unchecked_array_for(pv,i):arr);
var nacc = (function (){var G__16558 = acc;
var G__16559 = (arr__$1[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16558,G__16559) : f.call(null,G__16558,G__16559));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__16561 = nacc;
var G__16562 = (i + (1));
var G__16563 = arr__$1;
acc = G__16561;
i = G__16562;
arr = G__16563;
continue;
}
} else {
return acc;
}
break;
}
}));

(cljs.core.pv_reduce.cljs$lang$maxFixedArity = 5);







/**
 * Marker protocol
 * @interface
 */
cljs.core.APersistentVector = function(){};


/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.APersistentVector}
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentVector = (function (meta,cnt,shift,root,tail,__hash){
this.meta = meta;
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 401412;
});
(cljs.core.PersistentVector.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_16565(coll,n){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return (new cljs.core.MapEntry(n,(cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]),null));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.toString = (function cljs$core$fn_16566(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentVector.prototype.equiv = (function cljs$core$fn_16567(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentVector.prototype.indexOf = (function() {
var cljs$core$fn_16568 = null;
var cljs$core$fn_16568__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16568__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16568 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16568__1.call(this,x);
case 2:
return cljs$core$fn_16568__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16568.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16568__1;
cljs$core$fn_16568.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16568__2;
return cljs$core$fn_16568;
})()
);

(cljs.core.PersistentVector.prototype.lastIndexOf = (function() {
var cljs$core$fn_16569 = null;
var cljs$core$fn_16569__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16569__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16569 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16569__1.call(this,x);
case 2:
return cljs$core$fn_16569__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16569.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16569__1;
cljs$core$fn_16569.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16569__2;
return cljs$core$fn_16569;
})()
);

(cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16570(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16571(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function cljs$core$fn_16572(v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__16573 = init__$2;
var G__16574 = (j + i);
var G__16575 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16573,G__16574,G__16575) : f.call(null,G__16573,G__16574,G__16575));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__16606 = (j + (1));
var G__16607 = init__$3;
j = G__16606;
init__$2 = G__16607;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__16608 = (i + len);
var G__16609 = init__$2;
i = G__16608;
init__$1 = G__16609;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$APersistentVector$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_16576(coll,n){
var self__ = this;
var coll__$1 = this;
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_16577(coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return (cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]);
} else {
return not_found;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function cljs$core$fn_16578(coll,n,val){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
if((cljs.core.tail_off(coll__$1) <= n)){
var new_tail = cljs.core.aclone(self__.tail);
(new_tail[(n & (31))] = val);

return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,cljs.core.do_assoc(coll__$1,self__.shift,self__.root,n,val),self__.tail,null));
}
} else {
if((n === self__.cnt)){
return coll__$1.cljs$core$ICollection$_conj$arity$2(null,val);
} else {
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds  [0,",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt),"]"].join('')));

}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_16579(this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.ranged_iterator(this$__$1,(0),self__.cnt);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16580(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_16581(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16582(coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_16583(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return coll__$1.cljs$core$IIndexed$_nth$arity$2(null,(self__.cnt - (1)));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_16584(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
} else {
if(((1) < (self__.cnt - cljs.core.tail_off(coll__$1)))){
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt - (1)),self__.shift,self__.root,self__.tail.slice((0),(-1)),null));
} else {
var new_tail = cljs.core.unchecked_array_for(coll__$1,(self__.cnt - (2)));
var nr = cljs.core.pop_tail(coll__$1,self__.shift,self__.root);
var new_root = (((nr == null))?cljs.core.PersistentVector.EMPTY_NODE:nr);
var cnt_1 = (self__.cnt - (1));
if(((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null)))){
return (new cljs.core.PersistentVector(self__.meta,cnt_1,(self__.shift - (5)),cljs.core.pv_aget(new_root,(0)),new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift,new_root,new_tail,null));
}

}
}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_16585(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return (new cljs.core.RSeq(coll__$1,(self__.cnt - (1)),null));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16586(coll){
var self__ = this;
var coll__$1 = this;
var h__10007__auto__ = self__.__hash;
if((!((h__10007__auto__ == null)))){
return h__10007__auto__;
} else {
var h__10007__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10007__auto____$1);

return h__10007__auto____$1;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16587(coll,other){
var self__ = this;
var coll__$1 = this;
if((other instanceof cljs.core.PersistentVector)){
if((self__.cnt === cljs.core.count(other))){
var me_iter = coll__$1.cljs$core$IIterable$_iterator$arity$1(null);
var you_iter = other.cljs$core$IIterable$_iterator$arity$1(null);
while(true){
if(me_iter.hasNext()){
var x = me_iter.next();
var y = you_iter.next();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_sequential(coll__$1,other);
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function cljs$core$fn_16588(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientVector(self__.cnt,self__.shift,cljs.core.tv_editable_root(self__.root),cljs.core.tv_editable_tail(self__.tail)));
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16589(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16590(v,f){
var self__ = this;
var v__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(v__$1,f,(0),self__.cnt);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16591(v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__16592 = init__$2;
var G__16593 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16592,G__16593) : f.call(null,G__16592,G__16593));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__16610 = (j + (1));
var G__16611 = init__$3;
j = G__16610;
init__$2 = G__16611;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__16612 = (i + len);
var G__16613 = init__$2;
i = G__16612;
init__$1 = G__16613;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_16594(coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IVector$_assoc_n$arity$3(null,k,v);
} else {
throw (new Error("Vector's key for assoc must be a number."));
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_16595(coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.integer_QMARK_(k)){
return ((((0) <= k)) && ((k < self__.cnt)));
} else {
return false;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16596(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
return null;
} else {
if((self__.cnt <= (32))){
return (new cljs.core.IndexedSeq(self__.tail,(0),null));
} else {
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(coll__$1,cljs.core.first_array_for_longvec(coll__$1),(0),(0));

}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16597(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentVector(new_meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16598(coll,o){
var self__ = this;
var coll__$1 = this;
if(((self__.cnt - cljs.core.tail_off(coll__$1)) < (32))){
var len = self__.tail.length;
var new_tail = (new Array((len + (1))));
var n__10634__auto___16614 = len;
var i_16615 = (0);
while(true){
if((i_16615 < n__10634__auto___16614)){
(new_tail[i_16615] = (self__.tail[i_16615]));

var G__16616 = (i_16615 + (1));
i_16615 = G__16616;
continue;
} else {
}
break;
}

(new_tail[len] = o);

return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),self__.shift,self__.root,new_tail,null));
} else {
var root_overflow_QMARK_ = ((self__.cnt >>> (5)) > ((1) << self__.shift));
var new_shift = ((root_overflow_QMARK_)?(self__.shift + (5)):self__.shift);
var new_root = ((root_overflow_QMARK_)?(function (){var n_r = cljs.core.pv_fresh_node(null);
cljs.core.pv_aset(n_r,(0),self__.root);

cljs.core.pv_aset(n_r,(1),cljs.core.new_path(null,self__.shift,(new cljs.core.VectorNode(null,self__.tail))));

return n_r;
})():cljs.core.push_tail(coll__$1,self__.shift,self__.root,(new cljs.core.VectorNode(null,self__.tail))));
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),new_shift,new_root,[o],null));
}
}));

(cljs.core.PersistentVector.prototype.call = (function cljs$core$fn_16599(self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
if(typeof k === 'number'){
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
} else {
throw (new Error("Key must be integer"));
}
}));

(cljs.core.PersistentVector.prototype.apply = (function cljs$core$fn_16600(self__,args16564){
var self__ = this;
var self____$1 = this;
var args__10149__auto__ = cljs.core.aclone(args16564);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10149__auto__.length > (20)))?(function (){var G__16601 = args__10149__auto__.slice((0),(20));
G__16601.push(args__10149__auto__.slice((20)));

return G__16601;
})():args__10149__auto__)));
}));

(cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16602(k){
var self__ = this;
var coll = this;
if(typeof k === 'number'){
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
} else {
throw (new Error("Key must be integer"));
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IDrop$_drop$arity$2 = (function cljs$core$fn_16603(coll,n){
var self__ = this;
var coll__$1 = this;
if((n < self__.cnt)){
var offset = (n % (32));
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(coll__$1,cljs.core.unchecked_array_for(coll__$1,n),(n - offset),offset);
} else {
return null;
}
}));

(cljs.core.PersistentVector.getBasis = (function cljs$core$fn_16604(){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"tail","tail",494507963,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentVector.cljs$lang$type = true);

(cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector");

(cljs.core.PersistentVector.cljs$lang$ctorPrWriter = (function cljs$core$fn_16605(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/PersistentVector");
}));

/**
 * Positional factory function for cljs.core/PersistentVector.
 */
cljs.core.__GT_PersistentVector = (function cljs$core$__GT_PersistentVector(meta,cnt,shift,root,tail,__hash){
return (new cljs.core.PersistentVector(meta,cnt,shift,root,tail,__hash));
});

(cljs.core.PersistentVector.EMPTY_NODE = (new cljs.core.VectorNode(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null])));
(cljs.core.PersistentVector.EMPTY = (new cljs.core.PersistentVector(null,(0),(5),cljs.core.PersistentVector.EMPTY_NODE,[],cljs.core.empty_ordered_hash)));
(cljs.core.PersistentVector.fromArray = (function cljs$core$fn_16617(xs,no_clone){
var l = xs.length;
var xs__$1 = ((no_clone)?xs:cljs.core.aclone(xs));
if((l < (32))){
return (new cljs.core.PersistentVector(null,l,(5),cljs.core.PersistentVector.EMPTY_NODE,xs__$1,null));
} else {
var node = xs__$1.slice((0),(32));
var v = (new cljs.core.PersistentVector(null,(32),(5),cljs.core.PersistentVector.EMPTY_NODE,node,null));
var i = (32);
var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
while(true){
if((i < l)){
var G__16618 = (i + (1));
var G__16619 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out,(xs__$1[i]));
i = G__16618;
out = G__16619;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}
}));
(cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16620(){
var this__10736__auto__ = this;
return cljs.core.es6_iterator(this__10736__auto__);
}));
/**
 * Creates a new vector containing the contents of coll. JavaScript arrays
 *   will be aliased and should not be modified.
 */
cljs.core.vec = (function cljs$core$vec(coll){
if(cljs.core.map_entry_QMARK_(coll)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.key(coll),cljs.core.val(coll)], null);
} else {
if(cljs.core.vector_QMARK_(coll)){
return cljs.core.with_meta(coll,null);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.PersistentVector.fromArray(coll,true);
} else {
return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core._as_transient(cljs.core.PersistentVector.EMPTY),coll));

}
}
}
});
/**
 * Creates a new vector containing the args.
 */
cljs.core.vector = (function cljs$core$vector(var_args){
var args__10885__auto__ = [];
var len__10875__auto___16624 = arguments.length;
var i__10876__auto___16625 = (0);
while(true){
if((i__10876__auto___16625 < len__10875__auto___16624)){
args__10885__auto__.push((arguments[i__10876__auto___16625]));

var G__16626 = (i__10876__auto___16625 + (1));
i__10876__auto___16625 = G__16626;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((0) < args__10885__auto__.length))?(new cljs.core.IndexedSeq(args__10885__auto__.slice((0)),(0),null)):null);
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__10886__auto__);
});

(cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16622(args){
if((((args instanceof cljs.core.IndexedSeq)) && ((args.i === (0))))){
return cljs.core.PersistentVector.fromArray(args.arr,(!(cljs.core.array_QMARK_(args.arr))));
} else {
return cljs.core.vec(args);
}
}));

(cljs.core.vector.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.vector.cljs$lang$applyTo = (function cljs$core$fn_16623(seq16621){
var self__10861__auto__ = this;
return self__10861__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq16621));
}));


/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ChunkedSeq = (function (vec,node,i,off,meta,__hash){
this.vec = vec;
this.node = node;
this.i = i;
this.off = off;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375020;
this.cljs$lang$protocol_mask$partition1$ = 263680;
});
(cljs.core.ChunkedSeq.prototype.toString = (function cljs$core$fn_16627(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ChunkedSeq.prototype.equiv = (function cljs$core$fn_16628(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ChunkedSeq.prototype.indexOf = (function() {
var cljs$core$fn_16629 = null;
var cljs$core$fn_16629__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16629__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16629 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16629__1.call(this,x);
case 2:
return cljs$core$fn_16629__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16629.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16629__1;
cljs$core$fn_16629.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16629__2;
return cljs$core$fn_16629;
})()
);

(cljs.core.ChunkedSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_16630 = null;
var cljs$core$fn_16630__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16630__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16630 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16630__1.call(this,x);
case 2:
return cljs$core$fn_16630__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16630.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16630__1;
cljs$core$fn_16630.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16630__2;
return cljs$core$fn_16630;
})()
);

(cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16631(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16632(coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,self__.node,self__.i,(self__.off + (1)));
if((s == null)){
return null;
} else {
return s;
}
} else {
return coll__$1.cljs$core$IChunkedNext$_chunked_next$arity$1(null);
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16633(coll){
var self__ = this;
var coll__$1 = this;
var h__10007__auto__ = self__.__hash;
if((!((h__10007__auto__ == null)))){
return h__10007__auto__;
} else {
var h__10007__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10007__auto____$1);

return h__10007__auto____$1;
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16634(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16635(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16636(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(self__.vec,f,(self__.i + self__.off),cljs.core.count(self__.vec));
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16637(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(self__.vec,f,start,(self__.i + self__.off),cljs.core.count(self__.vec));
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16638(coll){
var self__ = this;
var coll__$1 = this;
return (self__.node[self__.off]);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16639(coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,self__.node,self__.i,(self__.off + (1)));
if((s == null)){
return cljs.core.List.EMPTY;
} else {
return s;
}
} else {
return coll__$1.cljs$core$IChunkedSeq$_chunked_rest$arity$1(null);
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16640(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function cljs$core$fn_16641(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node,self__.off);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function cljs$core$fn_16642(coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,cljs.core.unchecked_array_for(self__.vec,end),end,(0));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16643(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(self__.vec,self__.node,self__.i,self__.off,new_meta);
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16644(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IDrop$_drop$arity$2 = (function cljs$core$fn_16645(coll,n){
var self__ = this;
var coll__$1 = this;
var o = (self__.off + n);
if((o < self__.node.length)){
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,self__.node,self__.i,o);
} else {
var i__$1 = (self__.i + o);
if((i__$1 < cljs.core._count(self__.vec))){
var new_offset = (i__$1 % (32));
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,cljs.core.unchecked_array_for(self__.vec,i__$1),(i__$1 - new_offset),new_offset);
} else {
return null;
}
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function cljs$core$fn_16646(coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,cljs.core.unchecked_array_for(self__.vec,end),end,(0));
} else {
return null;
}
}));

(cljs.core.ChunkedSeq.getBasis = (function cljs$core$fn_16647(){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"vec","vec",982683596,null),new cljs.core.Symbol(null,"node","node",-2073234571,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ChunkedSeq.cljs$lang$type = true);

(cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq");

(cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_16648(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/ChunkedSeq");
}));

/**
 * Positional factory function for cljs.core/ChunkedSeq.
 */
cljs.core.__GT_ChunkedSeq = (function cljs$core$__GT_ChunkedSeq(vec,node,i,off,meta,__hash){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,__hash));
});

(cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16649(){
var this__10736__auto__ = this;
return cljs.core.es6_iterator(this__10736__auto__);
}));
cljs.core.chunked_seq = (function cljs$core$chunked_seq(var_args){
var G__16651 = arguments.length;
switch (G__16651) {
case 3:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16652(vec,i,off){
return (new cljs.core.ChunkedSeq(vec,cljs.core.array_for(vec,i),i,off,null,null));
}));

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16653(vec,node,i,off){
return (new cljs.core.ChunkedSeq(vec,node,i,off,null,null));
}));

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_16654(vec,node,i,off,meta){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,null));
}));

(cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5);


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Subvec = (function (meta,v,start,end,__hash){
this.meta = meta;
this.v = v;
this.start = start;
this.end = end;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(cljs.core.Subvec.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Subvec.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_16657(coll,n){
var self__ = this;
var coll__$1 = this;
if((n < (0))){
return null;
} else {
var idx = (self__.start + n);
if((idx < self__.end)){
return (new cljs.core.MapEntry(n,cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.v,idx),null));
} else {
return null;
}
}
}));

(cljs.core.Subvec.prototype.toString = (function cljs$core$fn_16658(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Subvec.prototype.equiv = (function cljs$core$fn_16659(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Subvec.prototype.indexOf = (function() {
var cljs$core$fn_16660 = null;
var cljs$core$fn_16660__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16660__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
cljs$core$fn_16660 = function(x,start__$1){
switch(arguments.length){
case 1:
return cljs$core$fn_16660__1.call(this,x);
case 2:
return cljs$core$fn_16660__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16660.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16660__1;
cljs$core$fn_16660.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16660__2;
return cljs$core$fn_16660;
})()
);

(cljs.core.Subvec.prototype.lastIndexOf = (function() {
var cljs$core$fn_16661 = null;
var cljs$core$fn_16661__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16661__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
cljs$core$fn_16661 = function(x,start__$1){
switch(arguments.length){
case 1:
return cljs$core$fn_16661__1.call(this,x);
case 2:
return cljs$core$fn_16661__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16661.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16661__1;
cljs$core$fn_16661.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16661__2;
return cljs$core$fn_16661;
})()
);

(cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16662(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16663(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function cljs$core$fn_16664(coll,f,init){
var self__ = this;
var coll__$1 = this;
var i = self__.start;
var j = (0);
var init__$1 = init;
while(true){
if((i < self__.end)){
var init__$2 = (function (){var G__16665 = init__$1;
var G__16666 = j;
var G__16667 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16665,G__16666,G__16667) : f.call(null,G__16665,G__16666,G__16667));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__16699 = (i + (1));
var G__16700 = (j + (1));
var G__16701 = init__$2;
i = G__16699;
j = G__16700;
init__$1 = G__16701;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_16668(coll,n){
var self__ = this;
var coll__$1 = this;
if((((n < (0))) || ((self__.end <= (self__.start + n))))){
return cljs.core.vector_index_out_of_bounds(n,(self__.end - self__.start));
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.start + n));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_16669(coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((n < (0))) || ((self__.end <= (self__.start + n))))){
return not_found;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v,(self__.start + n),not_found);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function cljs$core$fn_16670(coll,n,val){
var self__ = this;
var coll__$1 = this;
var v_pos = (self__.start + n);
if((((n < (0))) || (((self__.end + (1)) <= v_pos)))){
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds [0,",cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll__$1.cljs$core$ICounted$_count$arity$1(null)),"]"].join('')));
} else {
return cljs.core.build_subvec(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v,v_pos,val),self__.start,(function (){var x__9903__auto__ = self__.end;
var y__9904__auto__ = (v_pos + (1));
return ((x__9903__auto__ > y__9904__auto__) ? x__9903__auto__ : y__9904__auto__);
})(),null);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_16671(coll){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.ranged_iterator(self__.v,self__.start,self__.end);
} else {
return cljs.core.seq_iter(coll__$1);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16673(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_16674(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Subvec(self__.meta,self__.v,self__.start,self__.end,self__.__hash));
}));

(cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16675(coll){
var self__ = this;
var coll__$1 = this;
return (self__.end - self__.start);
}));

(cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_16676(coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
return null;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.end - (1)));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_16677(coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
throw (new Error("Can't pop empty vector"));
} else {
return cljs.core.build_subvec(self__.meta,self__.v,self__.start,(self__.end - (1)),null);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_16678(coll){
var self__ = this;
var coll__$1 = this;
if((!((self__.start === self__.end)))){
return (new cljs.core.RSeq(coll__$1,((self__.end - self__.start) - (1)),null));
} else {
return null;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16679(coll){
var self__ = this;
var coll__$1 = this;
var h__10007__auto__ = self__.__hash;
if((!((h__10007__auto__ == null)))){
return h__10007__auto__;
} else {
var h__10007__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10007__auto____$1);

return h__10007__auto____$1;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16680(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16681(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
}));

(cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16682(coll,f){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(self__.v,f,self__.start,self__.end);
} else {
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16684(coll,f,init){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(self__.v,f,init,self__.start,self__.end);
} else {
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,init);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_16686(coll,key,val){
var self__ = this;
var coll__$1 = this;
if(typeof key === 'number'){
return coll__$1.cljs$core$IVector$_assoc_n$arity$3(null,key,val);
} else {
throw (new Error("Subvec's key for assoc must be a number."));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_16687(coll,key){
var self__ = this;
var coll__$1 = this;
if(cljs.core.integer_QMARK_(key)){
return ((((0) <= key)) && ((key < (self__.end - self__.start))));
} else {
return false;
}
}));

(cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16688(coll){
var self__ = this;
var coll__$1 = this;
var subvec_seq = (function cljs$core$fn_16688_$_subvec_seq(i){
if((i === self__.end)){
return null;
} else {
return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i),(new cljs.core.LazySeq(null,(function cljs$core$fn_16688_$_subvec_seq_$_fn_16689(){
return cljs$core$fn_16688_$_subvec_seq((i + (1)));
}),null,null)));
}
});
return subvec_seq(self__.start);
}));

(cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16690(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return cljs.core.build_subvec(new_meta,self__.v,self__.start,self__.end,self__.__hash);
}
}));

(cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16691(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.build_subvec(self__.meta,cljs.core._assoc_n(self__.v,self__.end,o),self__.start,(self__.end + (1)),null);
}));

(cljs.core.Subvec.prototype.call = (function() {
var cljs$core$fn_16692 = null;
var cljs$core$fn_16692__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var cljs$core$fn_16692__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
cljs$core$fn_16692 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_16692__2.call(this,self__,k);
case 3:
return cljs$core$fn_16692__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_16692.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16692__2;
cljs$core$fn_16692.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16692__3;
return cljs$core$fn_16692;
})()
);

(cljs.core.Subvec.prototype.apply = (function cljs$core$fn_16693(self__,args16656){
var self__ = this;
var self____$1 = this;
var args__10149__auto__ = cljs.core.aclone(args16656);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10149__auto__.length > (20)))?(function (){var G__16694 = args__10149__auto__.slice((0),(20));
G__16694.push(args__10149__auto__.slice((20)));

return G__16694;
})():args__10149__auto__)));
}));

(cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16695(k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16696(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.Subvec.getBasis = (function cljs$core$fn_16697(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Subvec.cljs$lang$type = true);

(cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec");

(cljs.core.Subvec.cljs$lang$ctorPrWriter = (function cljs$core$fn_16698(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/Subvec");
}));

/**
 * Positional factory function for cljs.core/Subvec.
 */
cljs.core.__GT_Subvec = (function cljs$core$__GT_Subvec(meta,v,start,end,__hash){
return (new cljs.core.Subvec(meta,v,start,end,__hash));
});

(cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16702(){
var this__10736__auto__ = this;
return cljs.core.es6_iterator(this__10736__auto__);
}));
cljs.core.build_subvec = (function cljs$core$build_subvec(meta,v,start,end,__hash){
while(true){
if((v instanceof cljs.core.Subvec)){
var G__16703 = meta;
var G__16704 = v.v;
var G__16705 = (v.start + start);
var G__16706 = (v.start + end);
var G__16707 = __hash;
meta = G__16703;
v = G__16704;
start = G__16705;
end = G__16706;
__hash = G__16707;
continue;
} else {
if(cljs.core.vector_QMARK_(v)){
} else {
throw (new Error("v must satisfy IVector"));
}

if((((start < (0))) || ((((end < start)) || ((end > cljs.core.count(v))))))){
throw (new Error("Index out of bounds"));
} else {
}

return (new cljs.core.Subvec(meta,v,start,end,__hash));
}
break;
}
});
/**
 * Returns a persistent vector of the items in vector from
 *   start (inclusive) to end (exclusive).  If end is not supplied,
 *   defaults to (count vector). This operation is O(1) and very fast, as
 *   the resulting vector shares structure with the original and no
 *   trimming is done.
 */
cljs.core.subvec = (function cljs$core$subvec(var_args){
var G__16709 = arguments.length;
switch (G__16709) {
case 2:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16710(v,start){
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v,start,cljs.core.count(v));
}));

(cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16711(v,start,end){
if((((!((start == null)))) && ((!((end == null)))))){
} else {
throw (new Error("Assert failed: (and (not (nil? start)) (not (nil? end)))"));
}

return cljs.core.build_subvec(null,v,(start | (0)),(end | (0)),null);
}));

(cljs.core.subvec.cljs$lang$maxFixedArity = 3);

cljs.core.tv_ensure_editable = (function cljs$core$tv_ensure_editable(edit,node){
if((edit === node.edit)){
return node;
} else {
return (new cljs.core.VectorNode(edit,cljs.core.aclone(node.arr)));
}
});
cljs.core.tv_editable_root = (function cljs$core$tv_editable_root(node){
return (new cljs.core.VectorNode(({}),cljs.core.aclone(node.arr)));
});
cljs.core.tv_editable_tail = (function cljs$core$tv_editable_tail(tl){
var ret = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
cljs.core.array_copy(tl,(0),ret,(0),tl.length);

return ret;
});
cljs.core.tv_push_tail = (function cljs$core$tv_push_tail(tv,level,parent,tail_node){
var ret = cljs.core.tv_ensure_editable(tv.root.edit,parent);
var subidx = (((tv.cnt - (1)) >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(((level === (5)))?tail_node:(function (){var child = cljs.core.pv_aget(ret,subidx);
if((!((child == null)))){
var G__16715 = tv;
var G__16716 = (level - (5));
var G__16717 = child;
var G__16718 = tail_node;
return (cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4(G__16715,G__16716,G__16717,G__16718) : cljs.core.tv_push_tail.call(null,G__16715,G__16716,G__16717,G__16718));
} else {
return cljs.core.new_path(tv.root.edit,(level - (5)),tail_node);
}
})()));

return ret;
});
cljs.core.tv_pop_tail = (function cljs$core$tv_pop_tail(tv,level,node){
var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit,node);
var subidx = (((tv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = (function (){var G__16719 = tv;
var G__16720 = (level - (5));
var G__16721 = cljs.core.pv_aget(node__$1,subidx);
return (cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3(G__16719,G__16720,G__16721) : cljs.core.tv_pop_tail.call(null,G__16719,G__16720,G__16721));
})();
if((((new_child == null)) && ((subidx === (0))))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,new_child);

return node__$1;
}
} else {
if((subidx === (0))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,null);

return node__$1;

}
}
});
cljs.core.unchecked_editable_array_for = (function cljs$core$unchecked_editable_array_for(tv,i){
if((i >= cljs.core.tail_off(tv))){
return tv.tail;
} else {
var root = tv.root;
var node = root;
var level = tv.shift;
while(true){
if((level > (0))){
var G__16722 = cljs.core.tv_ensure_editable(root.edit,cljs.core.pv_aget(node,((i >>> level) & (31))));
var G__16723 = (level - (5));
node = G__16722;
level = G__16723;
continue;
} else {
return node.arr;
}
break;
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientVector}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientVector = (function (cnt,shift,root,tail){
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.cljs$lang$protocol_mask$partition1$ = 88;
this.cljs$lang$protocol_mask$partition0$ = 275;
});
(cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function cljs$core$fn_16725(tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((self__.cnt - cljs.core.tail_off(tcoll__$1)) < (32))){
(self__.tail[(self__.cnt & (31))] = o);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
} else {
var tail_node = (new cljs.core.VectorNode(self__.root.edit,self__.tail));
var new_tail = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(new_tail[(0)] = o);

(self__.tail = new_tail);

if(((self__.cnt >>> (5)) > ((1) << self__.shift))){
var new_root_array = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var new_shift = (self__.shift + (5));
(new_root_array[(0)] = self__.root);

(new_root_array[(1)] = cljs.core.new_path(self__.root.edit,self__.shift,tail_node));

(self__.root = (new cljs.core.VectorNode(self__.root.edit,new_root_array)));

(self__.shift = new_shift);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
} else {
var new_root = cljs.core.tv_push_tail(tcoll__$1,self__.shift,self__.root,tail_node);
(self__.root = new_root);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function cljs$core$fn_16726(tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
(self__.root.edit = null);

var len = (self__.cnt - cljs.core.tail_off(tcoll__$1));
var trimmed_tail = (new Array(len));
cljs.core.array_copy(self__.tail,(0),trimmed_tail,(0),len);

return (new cljs.core.PersistentVector(null,self__.cnt,self__.shift,self__.root,trimmed_tail,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function cljs$core$fn_16727(tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(typeof key === 'number'){
return tcoll__$1.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(null,key,val);
} else {
throw (new Error("TransientVector's key for assoc! must be a number."));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = (function cljs$core$fn_16728(tcoll,n,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((((0) <= n)) && ((n < self__.cnt)))){
if((cljs.core.tail_off(tcoll__$1) <= n)){
(self__.tail[(n & (31))] = val);

return tcoll__$1;
} else {
var new_root = (function (){var fexpr__16729 = (function cljs$core$fn_16728_$_go(level,node){
var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit,node);
if((level === (0))){
cljs.core.pv_aset(node__$1,(n & (31)),val);

return node__$1;
} else {
var subidx = ((n >>> level) & (31));
cljs.core.pv_aset(node__$1,subidx,cljs$core$fn_16728_$_go((level - (5)),cljs.core.pv_aget(node__$1,subidx)));

return node__$1;
}
});
return fexpr__16729(self__.shift,self__.root);
})();
(self__.root = new_root);

return tcoll__$1;
}
} else {
if((n === self__.cnt)){
return tcoll__$1.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,val);
} else {
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds for TransientVector of length",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt)].join('')));

}
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = (function cljs$core$fn_16730(tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
(self__.cnt = (0));

return tcoll__$1;
} else {
if((((self__.cnt - (1)) & (31)) > (0))){
(self__.cnt = (self__.cnt - (1)));

return tcoll__$1;
} else {
var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1,(self__.cnt - (2)));
var new_root = (function (){var nr = cljs.core.tv_pop_tail(tcoll__$1,self__.shift,self__.root);
if((!((nr == null)))){
return nr;
} else {
return (new cljs.core.VectorNode(self__.root.edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
}
})();
if(((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null)))){
var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit,cljs.core.pv_aget(new_root,(0)));
(self__.root = new_root__$1);

(self__.shift = (self__.shift - (5)));

(self__.cnt = (self__.cnt - (1)));

(self__.tail = new_tail);

return tcoll__$1;
} else {
(self__.root = new_root);

(self__.cnt = (self__.cnt - (1)));

(self__.tail = new_tail);

return tcoll__$1;
}

}
}
}
} else {
throw (new Error("pop! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16731(coll){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return self__.cnt;
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_16732(coll,n){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
} else {
throw (new Error("nth after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_16733(coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return coll__$1.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
return not_found;
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16734(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16735(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((!(self__.root.edit))){
throw (new Error("lookup after persistent!"));
} else {
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;

}
}
}));

(cljs.core.TransientVector.prototype.call = (function() {
var cljs$core$fn_16736 = null;
var cljs$core$fn_16736__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var cljs$core$fn_16736__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
cljs$core$fn_16736 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_16736__2.call(this,self__,k);
case 3:
return cljs$core$fn_16736__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_16736.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16736__2;
cljs$core$fn_16736.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16736__3;
return cljs$core$fn_16736;
})()
);

(cljs.core.TransientVector.prototype.apply = (function cljs$core$fn_16737(self__,args16724){
var self__ = this;
var self____$1 = this;
var args__10149__auto__ = cljs.core.aclone(args16724);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10149__auto__.length > (20)))?(function (){var G__16738 = args__10149__auto__.slice((0),(20));
G__16738.push(args__10149__auto__.slice((20)));

return G__16738;
})():args__10149__auto__)));
}));

(cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16739(k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16740(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.TransientVector.getBasis = (function cljs$core$fn_16741(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"tail","tail",494507963,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.TransientVector.cljs$lang$type = true);

(cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector");

(cljs.core.TransientVector.cljs$lang$ctorPrWriter = (function cljs$core$fn_16742(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/TransientVector");
}));

/**
 * Positional factory function for cljs.core/TransientVector.
 */
cljs.core.__GT_TransientVector = (function cljs$core$__GT_TransientVector(cnt,shift,root,tail){
return (new cljs.core.TransientVector(cnt,shift,root,tail));
});


/**
* @constructor
*/
cljs.core.PersistentQueueIter = (function (fseq,riter){
this.fseq = fseq;
this.riter = riter;
});
(cljs.core.PersistentQueueIter.prototype.hasNext = (function cljs$core$fn_16743(){
var self__ = this;
var _ = this;
var or__9546__auto__ = (((!((self__.fseq == null)))) && (cljs.core.seq(self__.fseq)));
if(or__9546__auto__){
return or__9546__auto__;
} else {
var and__9540__auto__ = (!((self__.riter == null)));
if(and__9540__auto__){
return self__.riter.hasNext();
} else {
return and__9540__auto__;
}
}
}));

(cljs.core.PersistentQueueIter.prototype.next = (function cljs$core$fn_16744(){
var self__ = this;
var _ = this;
if((!((self__.fseq == null)))){
var ret = cljs.core.first(self__.fseq);
(self__.fseq = cljs.core.next(self__.fseq));

return ret;
} else {
if((((!((self__.riter == null)))) && (self__.riter.hasNext()))){
return self__.riter.next();
} else {
throw (new Error("No such element"));

}
}
}));

(cljs.core.PersistentQueueIter.prototype.remove = (function cljs$core$fn_16745(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.PersistentQueueIter.getBasis = (function cljs$core$fn_16746(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fseq","fseq",-1466412450,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"riter","riter",-237834262,null)], null);
}));

(cljs.core.PersistentQueueIter.cljs$lang$type = true);

(cljs.core.PersistentQueueIter.cljs$lang$ctorStr = "cljs.core/PersistentQueueIter");

(cljs.core.PersistentQueueIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_16747(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/PersistentQueueIter");
}));

/**
 * Positional factory function for cljs.core/PersistentQueueIter.
 */
cljs.core.__GT_PersistentQueueIter = (function cljs$core$__GT_PersistentQueueIter(fseq,riter){
return (new cljs.core.PersistentQueueIter(fseq,riter));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueueSeq = (function (meta,front,rear,__hash){
this.meta = meta;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850700;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.PersistentQueueSeq.prototype.toString = (function cljs$core$fn_16748(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentQueueSeq.prototype.equiv = (function cljs$core$fn_16749(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentQueueSeq.prototype.indexOf = (function() {
var cljs$core$fn_16750 = null;
var cljs$core$fn_16750__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16750__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16750 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16750__1.call(this,x);
case 2:
return cljs$core$fn_16750__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16750.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16750__1;
cljs$core$fn_16750.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16750__2;
return cljs$core$fn_16750;
})()
);

(cljs.core.PersistentQueueSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_16751 = null;
var cljs$core$fn_16751__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16751__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16751 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16751__1.call(this,x);
case 2:
return cljs$core$fn_16751__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16751.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16751__1;
cljs$core$fn_16751.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16751__2;
return cljs$core$fn_16751;
})()
);

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16752(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16753(coll){
var self__ = this;
var coll__$1 = this;
var temp__5718__auto__ = cljs.core.next(self__.front);
if(temp__5718__auto__){
var f1 = temp__5718__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((!((self__.rear == null)))){
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
} else {
return null;
}
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16754(coll){
var self__ = this;
var coll__$1 = this;
var h__10007__auto__ = self__.__hash;
if((!((h__10007__auto__ == null)))){
return h__10007__auto__;
} else {
var h__10007__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10007__auto____$1);

return h__10007__auto____$1;
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16755(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16756(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16757(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16758(coll){
var self__ = this;
var coll__$1 = this;
var temp__5718__auto__ = cljs.core.next(self__.front);
if(temp__5718__auto__){
var f1 = temp__5718__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((self__.rear == null)){
return coll__$1.cljs$core$IEmptyableCollection$_empty$arity$1(null);
} else {
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
}
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16759(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16760(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentQueueSeq(new_meta,self__.front,self__.rear,self__.__hash));
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16761(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.PersistentQueueSeq.getBasis = (function cljs$core$fn_16762(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"front","front",117022539,null),new cljs.core.Symbol(null,"rear","rear",-900164830,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentQueueSeq.cljs$lang$type = true);

(cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq");

(cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_16763(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/PersistentQueueSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentQueueSeq.
 */
cljs.core.__GT_PersistentQueueSeq = (function cljs$core$__GT_PersistentQueueSeq(meta,front,rear,__hash){
return (new cljs.core.PersistentQueueSeq(meta,front,rear,__hash));
});

(cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16764(){
var this__10736__auto__ = this;
return cljs.core.es6_iterator(this__10736__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueue = (function (meta,count,front,rear,__hash){
this.meta = meta;
this.count = count;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 139264;
this.cljs$lang$protocol_mask$partition0$ = 31858766;
});
(cljs.core.PersistentQueue.prototype.toString = (function cljs$core$fn_16765(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentQueue.prototype.equiv = (function cljs$core$fn_16766(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentQueue.prototype.indexOf = (function() {
var cljs$core$fn_16767 = null;
var cljs$core$fn_16767__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16767__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16767 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16767__1.call(this,x);
case 2:
return cljs$core$fn_16767__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16767.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16767__1;
cljs$core$fn_16767.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16767__2;
return cljs$core$fn_16767;
})()
);

(cljs.core.PersistentQueue.prototype.lastIndexOf = (function() {
var cljs$core$fn_16768 = null;
var cljs$core$fn_16768__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(self__.count.cljs$core$IFn$_invoke$arity$1 ? self__.count.cljs$core$IFn$_invoke$arity$1(coll) : self__.count.call(null,coll)));
});
var cljs$core$fn_16768__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16768 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16768__1.call(this,x);
case 2:
return cljs$core$fn_16768__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16768.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16768__1;
cljs$core$fn_16768.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16768__2;
return cljs$core$fn_16768;
})()
);

(cljs.core.PersistentQueue.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_16769(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueIter(self__.front,cljs.core._iterator(self__.rear)));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16770(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_16771(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(self__.meta,self__.count,self__.front,self__.rear,self__.__hash));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16772(coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_16773(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_16774(coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
var temp__5718__auto__ = cljs.core.next(self__.front);
if(temp__5718__auto__){
var f1 = temp__5718__auto__;
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),f1,self__.rear,null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),cljs.core.seq(self__.rear),cljs.core.PersistentVector.EMPTY,null));
}
} else {
return coll__$1;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16775(coll){
var self__ = this;
var coll__$1 = this;
var h__10007__auto__ = self__.__hash;
if((!((h__10007__auto__ == null)))){
return h__10007__auto__;
} else {
var h__10007__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10007__auto____$1);

return h__10007__auto____$1;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16776(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16777(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentQueue.EMPTY,self__.meta);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16778(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16779(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.rest(cljs.core.seq(coll__$1));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16780(coll){
var self__ = this;
var coll__$1 = this;
var rear__$1 = cljs.core.seq(self__.rear);
if(cljs.core.truth_((function (){var or__9546__auto__ = self__.front;
if(cljs.core.truth_(or__9546__auto__)){
return or__9546__auto__;
} else {
return rear__$1;
}
})())){
return (new cljs.core.PersistentQueueSeq(null,self__.front,cljs.core.seq(rear__$1),null));
} else {
return null;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16781(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentQueue(new_meta,self__.count,self__.front,self__.rear,self__.__hash));
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16782(coll,o){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),self__.front,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__9546__auto__ = self__.rear;
if(cljs.core.truth_(or__9546__auto__)){
return or__9546__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),o),null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front,o),cljs.core.PersistentVector.EMPTY,null));
}
}));

(cljs.core.PersistentQueue.getBasis = (function cljs$core$fn_16783(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"front","front",117022539,null),new cljs.core.Symbol(null,"rear","rear",-900164830,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentQueue.cljs$lang$type = true);

(cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue");

(cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = (function cljs$core$fn_16784(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/PersistentQueue");
}));

/**
 * Positional factory function for cljs.core/PersistentQueue.
 */
cljs.core.__GT_PersistentQueue = (function cljs$core$__GT_PersistentQueue(meta,count,front,rear,__hash){
return (new cljs.core.PersistentQueue(meta,count,front,rear,__hash));
});

(cljs.core.PersistentQueue.EMPTY = (new cljs.core.PersistentQueue(null,(0),null,cljs.core.PersistentVector.EMPTY,cljs.core.empty_ordered_hash)));
(cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16785(){
var this__10736__auto__ = this;
return cljs.core.es6_iterator(this__10736__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
*/
cljs.core.NeverEquiv = (function (){
this.cljs$lang$protocol_mask$partition0$ = 2097152;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.NeverEquiv.prototype.equiv = (function cljs$core$fn_16786(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16787(o,other){
var self__ = this;
var o__$1 = this;
return false;
}));

(cljs.core.NeverEquiv.getBasis = (function cljs$core$fn_16788(){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.NeverEquiv.cljs$lang$type = true);

(cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv");

(cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = (function cljs$core$fn_16789(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/NeverEquiv");
}));

/**
 * Positional factory function for cljs.core/NeverEquiv.
 */
cljs.core.__GT_NeverEquiv = (function cljs$core$__GT_NeverEquiv(){
return (new cljs.core.NeverEquiv());
});

cljs.core.never_equiv = (new cljs.core.NeverEquiv());
/**
 * Test map equivalence. Returns true if x equals y, otherwise returns false.
 */
cljs.core.equiv_map = (function cljs$core$equiv_map(x,y){
return cljs.core.boolean$(((((cljs.core.map_QMARK_(y)) && ((!(cljs.core.record_QMARK_(y))))))?(((cljs.core.count(x) === cljs.core.count(y)))?(((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition0$ & (1048576))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IKVReduce$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,x)))?cljs.core.reduce_kv((function cljs$core$equiv_map_$_fn_16791(_,k,v){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,k,cljs.core.never_equiv),v)){
return true;
} else {
return cljs.core.reduced(false);
}
}),true,x):cljs.core.every_QMARK_((function cljs$core$equiv_map_$_fn_16792(xkv){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,cljs.core.first(xkv),cljs.core.never_equiv),cljs.core.second(xkv));
}),x)):null):null));
});
cljs.core.scan_array = (function cljs$core$scan_array(incr,k,array){
var len = array.length;
var i = (0);
while(true){
if((i < len)){
if((k === (array[i]))){
return i;
} else {
var G__16793 = (i + incr);
i = G__16793;
continue;
}
} else {
return null;
}
break;
}
});
cljs.core.obj_map_compare_keys = (function cljs$core$obj_map_compare_keys(a,b){
var a__$1 = cljs.core.hash(a);
var b__$1 = cljs.core.hash(b);
if((a__$1 < b__$1)){
return (-1);
} else {
if((a__$1 > b__$1)){
return (1);
} else {
return (0);

}
}
});
cljs.core.obj_map__GT_hash_map = (function cljs$core$obj_map__GT_hash_map(m,k,v){
var ks = m.keys;
var len = ks.length;
var so = m.strobj;
var mm = cljs.core.meta(m);
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var k__$1 = (ks[i]);
var G__16794 = (i + (1));
var G__16795 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k__$1,cljs.core.goog$module$goog$object.get.call(null,so,k__$1));
i = G__16794;
out = G__16795;
continue;
} else {
return cljs.core._with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k,v)),mm);
}
break;
}
});
cljs.core.obj_clone = (function cljs$core$obj_clone(obj,ks){
var new_obj = ({});
var l = ks.length;
var i_16801 = (0);
while(true){
if((i_16801 < l)){
var k_16802 = (ks[i_16801]);
var G__16798_16803 = new_obj;
var G__16799_16804 = k_16802;
var G__16800_16805 = cljs.core.goog$module$goog$object.get.call(null,obj,k_16802);
cljs.core.goog$module$goog$object.set.call(null,G__16798_16803,G__16799_16804,G__16800_16805);

var G__16806 = (i_16801 + (1));
i_16801 = G__16806;
continue;
} else {
}
break;
}

return new_obj;
});

/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.ObjMap = (function (meta,keys,strobj,update_count,__hash){
this.meta = meta;
this.keys = keys;
this.strobj = strobj;
this.update_count = update_count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 4;
});
(cljs.core.ObjMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.ObjMap.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_16809(coll,k){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return (new cljs.core.MapEntry(k,(self__.strobj[k]),null));
} else {
return null;
}
}));

(cljs.core.ObjMap.prototype.toString = (function cljs$core$fn_16810(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ObjMap.prototype.equiv = (function cljs$core$fn_16811(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16812(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16813(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return (self__.strobj[k]);
} else {
return not_found;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function cljs$core$fn_16814(coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.keys.length;
var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
var init__$1 = init;
while(true){
if(cljs.core.seq(keys__$1)){
var k = cljs.core.first(keys__$1);
var init__$2 = (function (){var G__16815 = init__$1;
var G__16816 = k;
var G__16817 = (self__.strobj[k]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16815,G__16816,G__16817) : f.call(null,G__16815,G__16816,G__16817));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__16838 = cljs.core.rest(keys__$1);
var G__16839 = init__$2;
keys__$1 = G__16838;
init__$1 = G__16839;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16818(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16819(coll){
var self__ = this;
var coll__$1 = this;
return self__.keys.length;
}));

(cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16820(coll){
var self__ = this;
var coll__$1 = this;
var h__10007__auto__ = self__.__hash;
if((!((h__10007__auto__ == null)))){
return h__10007__auto__;
} else {
var h__10007__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__10007__auto____$1);

return h__10007__auto____$1;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16821(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
}));

(cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function cljs$core$fn_16822(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1));
}));

(cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16823(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.ObjMap.EMPTY,self__.meta);
}));

(cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function cljs$core$fn_16824(coll,k){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
var new_keys = cljs.core.aclone(self__.keys);
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
new_keys.splice(cljs.core.scan_array((1),k,new_keys),(1));

delete new_strobj[k];

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
} else {
return coll__$1;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_16825(coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'string'){
if((((self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD)) || ((self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD)))){
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
} else {
if((!((cljs.core.scan_array((1),k,self__.keys) == null)))){
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
cljs.core.goog$module$goog$object.set.call(null,new_strobj,k,v);

return (new cljs.core.ObjMap(self__.meta,self__.keys,new_strobj,(self__.update_count + (1)),null));
} else {
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
var new_keys = cljs.core.aclone(self__.keys);
cljs.core.goog$module$goog$object.set.call(null,new_strobj,k,v);

new_keys.push(k);

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
}
}
} else {
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_16826(coll,k){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return true;
} else {
return false;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16827(coll){
var self__ = this;
var coll__$1 = this;
if((self__.keys.length > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function cljs$core$fn_16827_$_fn_16828(p1__16807_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__16807_SHARP_,(self__.strobj[p1__16807_SHARP_])],null));
}),self__.keys.sort(cljs.core.obj_map_compare_keys));
} else {
return null;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16829(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ObjMap(new_meta,self__.keys,self__.strobj,self__.update_count,self__.__hash));
}
}));

(cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16830(coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,coll__$1,entry);
}
}));

(cljs.core.ObjMap.prototype.call = (function() {
var cljs$core$fn_16831 = null;
var cljs$core$fn_16831__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var cljs$core$fn_16831__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
cljs$core$fn_16831 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_16831__2.call(this,self__,k);
case 3:
return cljs$core$fn_16831__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_16831.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16831__2;
cljs$core$fn_16831.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16831__3;
return cljs$core$fn_16831;
})()
);

(cljs.core.ObjMap.prototype.apply = (function cljs$core$fn_16832(self__,args16808){
var self__ = this;
var self____$1 = this;
var args__10149__auto__ = cljs.core.aclone(args16808);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10149__auto__.length > (20)))?(function (){var G__16833 = args__10149__auto__.slice((0),(20));
G__16833.push(args__10149__auto__.slice((20)));

return G__16833;
})():args__10149__auto__)));
}));

(cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16834(k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16835(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.ObjMap.getBasis = (function cljs$core$fn_16836(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"keys","keys",-1586012071,null),new cljs.core.Symbol(null,"strobj","strobj",1088091283,null),new cljs.core.Symbol(null,"update-count","update-count",-411982269,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ObjMap.cljs$lang$type = true);

(cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap");

(cljs.core.ObjMap.cljs$lang$ctorPrWriter = (function cljs$core$fn_16837(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/ObjMap");
}));

/**
 * Positional factory function for cljs.core/ObjMap.
 */
cljs.core.__GT_ObjMap = (function cljs$core$__GT_ObjMap(meta,keys,strobj,update_count,__hash){
return (new cljs.core.ObjMap(meta,keys,strobj,update_count,__hash));
});

(cljs.core.ObjMap.EMPTY = (new cljs.core.ObjMap(null,[],({}),(0),cljs.core.empty_unordered_hash)));
(cljs.core.ObjMap.HASHMAP_THRESHOLD = (8));
(cljs.core.ObjMap.fromObject = (function cljs$core$fn_16842(ks,obj){
return (new cljs.core.ObjMap(null,ks,obj,(0),null));
}));

/**
* @constructor
*/
cljs.core.RecordIter = (function (i,record,base_count,fields,ext_map_iter){
this.i = i;
this.record = record;
this.base_count = base_count;
this.fields = fields;
this.ext_map_iter = ext_map_iter;
});
(cljs.core.RecordIter.prototype.hasNext = (function cljs$core$fn_16843(){
var self__ = this;
var _ = this;
var or__9546__auto__ = (self__.i < self__.base_count);
if(or__9546__auto__){
return or__9546__auto__;
} else {
return self__.ext_map_iter.hasNext();
}
}));

(cljs.core.RecordIter.prototype.next = (function cljs$core$fn_16844(){
var self__ = this;
var _ = this;
if((self__.i < self__.base_count)){
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.fields,self__.i);
(self__.i = (self__.i + (1)));

return (new cljs.core.MapEntry(k,cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.record,k),null));
} else {
return self__.ext_map_iter.next();
}
}));

(cljs.core.RecordIter.prototype.remove = (function cljs$core$fn_16845(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.RecordIter.getBasis = (function cljs$core$fn_16846(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"record","record",861424668,null),new cljs.core.Symbol(null,"base-count","base-count",-1180647182,null),new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.Symbol(null,"ext-map-iter","ext-map-iter",-1215982757,null)], null);
}));

(cljs.core.RecordIter.cljs$lang$type = true);

(cljs.core.RecordIter.cljs$lang$ctorStr = "cljs.core/RecordIter");

(cljs.core.RecordIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_16847(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/RecordIter");
}));

/**
 * Positional factory function for cljs.core/RecordIter.
 */
cljs.core.__GT_RecordIter = (function cljs$core$__GT_RecordIter(i,record,base_count,fields,ext_map_iter){
return (new cljs.core.RecordIter(i,record,base_count,fields,ext_map_iter));
});


/**
* @constructor
*/
cljs.core.ES6EntriesIterator = (function (s){
this.s = s;
});
(cljs.core.ES6EntriesIterator.prototype.next = (function cljs$core$fn_16848(){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var vec__16849 = cljs.core.first(self__.s);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16849,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16849,(1),null);
(self__.s = cljs.core.next(self__.s));

return ({"value": [k,v], "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6EntriesIterator.getBasis = (function cljs$core$fn_16852(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6EntriesIterator.cljs$lang$type = true);

(cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator");

(cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_16853(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/ES6EntriesIterator");
}));

/**
 * Positional factory function for cljs.core/ES6EntriesIterator.
 */
cljs.core.__GT_ES6EntriesIterator = (function cljs$core$__GT_ES6EntriesIterator(s){
return (new cljs.core.ES6EntriesIterator(s));
});

cljs.core.es6_entries_iterator = (function cljs$core$es6_entries_iterator(coll){
return (new cljs.core.ES6EntriesIterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6SetEntriesIterator = (function (s){
this.s = s;
});
(cljs.core.ES6SetEntriesIterator.prototype.next = (function cljs$core$fn_16854(){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var x = cljs.core.first(self__.s);
(self__.s = cljs.core.next(self__.s));

return ({"value": [x,x], "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6SetEntriesIterator.getBasis = (function cljs$core$fn_16855(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6SetEntriesIterator.cljs$lang$type = true);

(cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator");

(cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_16856(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/ES6SetEntriesIterator");
}));

/**
 * Positional factory function for cljs.core/ES6SetEntriesIterator.
 */
cljs.core.__GT_ES6SetEntriesIterator = (function cljs$core$__GT_ES6SetEntriesIterator(s){
return (new cljs.core.ES6SetEntriesIterator(s));
});

cljs.core.es6_set_entries_iterator = (function cljs$core$es6_set_entries_iterator(coll){
return (new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll)));
});
cljs.core.array_index_of_nil_QMARK_ = (function cljs$core$array_index_of_nil_QMARK_(arr){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((arr[i]) == null)){
return i;
} else {
var G__16857 = (i + (2));
i = G__16857;
continue;

}
}
break;
}
});
cljs.core.array_index_of_keyword_QMARK_ = (function cljs$core$array_index_of_keyword_QMARK_(arr,k){
var len = arr.length;
var kstr = k.fqn;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((((arr[i]) instanceof cljs.core.Keyword)) && ((kstr === (arr[i]).fqn)))){
return i;
} else {
var G__16858 = (i + (2));
i = G__16858;
continue;

}
}
break;
}
});
cljs.core.array_index_of_symbol_QMARK_ = (function cljs$core$array_index_of_symbol_QMARK_(arr,k){
var len = arr.length;
var kstr = k.str;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((((arr[i]) instanceof cljs.core.Symbol)) && ((kstr === (arr[i]).str)))){
return i;
} else {
var G__16859 = (i + (2));
i = G__16859;
continue;

}
}
break;
}
});
cljs.core.array_index_of_identical_QMARK_ = (function cljs$core$array_index_of_identical_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((k === (arr[i]))){
return i;
} else {
var G__16860 = (i + (2));
i = G__16860;
continue;

}
}
break;
}
});
cljs.core.array_index_of_equiv_QMARK_ = (function cljs$core$array_index_of_equiv_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(arr[i]))){
return i;
} else {
var G__16861 = (i + (2));
i = G__16861;
continue;

}
}
break;
}
});
cljs.core.array_index_of = (function cljs$core$array_index_of(arr,k){
if((k instanceof cljs.core.Keyword)){
return cljs.core.array_index_of_keyword_QMARK_(arr,k);
} else {
if(((typeof k === 'string') || (typeof k === 'number'))){
return cljs.core.array_index_of_identical_QMARK_(arr,k);
} else {
if((k instanceof cljs.core.Symbol)){
return cljs.core.array_index_of_symbol_QMARK_(arr,k);
} else {
if((k == null)){
return cljs.core.array_index_of_nil_QMARK_(arr);
} else {
return cljs.core.array_index_of_equiv_QMARK_(arr,k);

}
}
}
}
});
cljs.core.array_map_index_of = (function cljs$core$array_map_index_of(m,k){
return cljs.core.array_index_of(m.arr,k);
});
cljs.core.array_extend_kv = (function cljs$core$array_extend_kv(arr,k,v){
var l = arr.length;
var narr = (new Array((l + (2))));
var i_16862 = (0);
while(true){
if((i_16862 < l)){
(narr[i_16862] = (arr[i_16862]));

var G__16863 = (i_16862 + (1));
i_16862 = G__16863;
continue;
} else {
}
break;
}

(narr[l] = k);

(narr[(l + (1))] = v);

return narr;
});
cljs.core.array_map_extend_kv = (function cljs$core$array_map_extend_kv(m,k,v){
return cljs.core.array_extend_kv(m.arr,k,v);
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.MapEntry = (function (key,val,__hash){
this.key = key;
this.val = val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.MapEntry.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.MapEntry.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_16865(node,k){
var self__ = this;
var node__$1 = this;
var G__16866 = k;
switch (G__16866) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.MapEntry.prototype.indexOf = (function() {
var cljs$core$fn_16867 = null;
var cljs$core$fn_16867__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16867__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16867 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16867__1.call(this,x);
case 2:
return cljs$core$fn_16867__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16867.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16867__1;
cljs$core$fn_16867.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16867__2;
return cljs$core$fn_16867;
})()
);

(cljs.core.MapEntry.prototype.lastIndexOf = (function() {
var cljs$core$fn_16868 = null;
var cljs$core$fn_16868__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16868__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16868 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16868__1.call(this,x);
case 2:
return cljs$core$fn_16868__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16868.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16868__1;
cljs$core$fn_16868.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16868__2;
return cljs$core$fn_16868;
})()
);

(cljs.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16869(node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
}));

(cljs.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16870(node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.MapEntry.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_16871(node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_16872(node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function cljs$core$fn_16873(node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
}));

(cljs.core.MapEntry.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16874(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.MapEntry.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16875(node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.MapEntry.prototype.cljs$core$IMapEntry$_key$arity$1 = (function cljs$core$fn_16876(node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.MapEntry.prototype.cljs$core$IMapEntry$_val$arity$1 = (function cljs$core$fn_16877(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.MapEntry.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_16878(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.MapEntry.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_16879(node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.MapEntry.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_16880(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.MapEntry.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16881(coll){
var self__ = this;
var coll__$1 = this;
var h__10007__auto__ = self__.__hash;
if((!((h__10007__auto__ == null)))){
return h__10007__auto__;
} else {
var h__10007__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10007__auto____$1);

return h__10007__auto____$1;
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16882(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.MapEntry.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16883(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.MapEntry.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16884(node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
}));

(cljs.core.MapEntry.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16885(node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
}));

(cljs.core.MapEntry.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_16886(node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.MapEntry.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_16887(node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.MapEntry.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16888(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.MapEntry.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16889(node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.MapEntry.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16890(node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.MapEntry.prototype.call = (function() {
var cljs$core$fn_16891 = null;
var cljs$core$fn_16891__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var cljs$core$fn_16891__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
cljs$core$fn_16891 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_16891__2.call(this,self__,k);
case 3:
return cljs$core$fn_16891__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_16891.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16891__2;
cljs$core$fn_16891.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16891__3;
return cljs$core$fn_16891;
})()
);

(cljs.core.MapEntry.prototype.apply = (function cljs$core$fn_16892(self__,args16864){
var self__ = this;
var self____$1 = this;
var args__10149__auto__ = cljs.core.aclone(args16864);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10149__auto__.length > (20)))?(function (){var G__16893 = args__10149__auto__.slice((0),(20));
G__16893.push(args__10149__auto__.slice((20)));

return G__16893;
})():args__10149__auto__)));
}));

(cljs.core.MapEntry.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16894(k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.MapEntry.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16895(k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.MapEntry.getBasis = (function cljs$core$fn_16896(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.MapEntry.cljs$lang$type = true);

(cljs.core.MapEntry.cljs$lang$ctorStr = "cljs.core/MapEntry");

(cljs.core.MapEntry.cljs$lang$ctorPrWriter = (function cljs$core$fn_16897(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/MapEntry");
}));

/**
 * Positional factory function for cljs.core/MapEntry.
 */
cljs.core.__GT_MapEntry = (function cljs$core$__GT_MapEntry(key,val,__hash){
return (new cljs.core.MapEntry(key,val,__hash));
});

/**
 * Returns true if x satisfies IMapEntry
 */
cljs.core.map_entry_QMARK_ = (function cljs$core$map_entry_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMapEntry$)))){
return true;
} else {
return false;
}
} else {
return false;
}
});

/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMapSeq = (function (arr,i,_meta){
this.arr = arr;
this.i = i;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 262144;
});
(cljs.core.PersistentArrayMapSeq.prototype.toString = (function cljs$core$fn_16900(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentArrayMapSeq.prototype.equiv = (function cljs$core$fn_16901(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentArrayMapSeq.prototype.indexOf = (function() {
var cljs$core$fn_16902 = null;
var cljs$core$fn_16902__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16902__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16902 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16902__1.call(this,x);
case 2:
return cljs$core$fn_16902__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16902.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16902__1;
cljs$core$fn_16902.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16902__2;
return cljs$core$fn_16902;
})()
);

(cljs.core.PersistentArrayMapSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_16903 = null;
var cljs$core$fn_16903__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16903__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16903 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16903__1.call(this,x);
case 2:
return cljs$core$fn_16903__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16903.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16903__1;
cljs$core$fn_16903.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16903__2;
return cljs$core$fn_16903;
})()
);

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16904(coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16905(coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),null));
} else {
return null;
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16906(coll){
var self__ = this;
var coll__$1 = this;
return ((self__.arr.length - self__.i) / (2));
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16907(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16908(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16909(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16910(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16911(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16912(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.MapEntry((self__.arr[self__.i]),(self__.arr[(self__.i + (1))]),null));
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16913(coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16914(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16915(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__._meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentArrayMapSeq(self__.arr,self__.i,new_meta));
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16916(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IDrop$_drop$arity$2 = (function cljs$core$fn_16917(coll,n){
var self__ = this;
var coll__$1 = this;
if((n < coll__$1.cljs$core$ICounted$_count$arity$1(null))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + ((2) * n)),null));
} else {
return null;
}
}));

(cljs.core.PersistentArrayMapSeq.getBasis = (function cljs$core$fn_16918(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.PersistentArrayMapSeq.cljs$lang$type = true);

(cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq");

(cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_16919(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/PersistentArrayMapSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMapSeq.
 */
cljs.core.__GT_PersistentArrayMapSeq = (function cljs$core$__GT_PersistentArrayMapSeq(arr,i,_meta){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
});

(cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16920(){
var this__10736__auto__ = this;
return cljs.core.es6_iterator(this__10736__auto__);
}));
cljs.core.persistent_array_map_seq = (function cljs$core$persistent_array_map_seq(arr,i,_meta){
if((i <= (arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
} else {
return null;
}
});


/**
* @constructor
*/
cljs.core.PersistentArrayMapIterator = (function (arr,i,cnt){
this.arr = arr;
this.i = i;
this.cnt = cnt;
});
(cljs.core.PersistentArrayMapIterator.prototype.hasNext = (function cljs$core$fn_16921(){
var self__ = this;
var _ = this;
return (self__.i < self__.cnt);
}));

(cljs.core.PersistentArrayMapIterator.prototype.next = (function cljs$core$fn_16922(){
var self__ = this;
var _ = this;
var ret = (new cljs.core.MapEntry((self__.arr[self__.i]),(self__.arr[(self__.i + (1))]),null));
(self__.i = (self__.i + (2)));

return ret;
}));

(cljs.core.PersistentArrayMapIterator.getBasis = (function cljs$core$fn_16923(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null)], null);
}));

(cljs.core.PersistentArrayMapIterator.cljs$lang$type = true);

(cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator");

(cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_16924(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/PersistentArrayMapIterator");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMapIterator.
 */
cljs.core.__GT_PersistentArrayMapIterator = (function cljs$core$__GT_PersistentArrayMapIterator(arr,i,cnt){
return (new cljs.core.PersistentArrayMapIterator(arr,i,cnt));
});


/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMap = (function (meta,cnt,arr,__hash){
this.meta = meta;
this.cnt = cnt;
this.arr = arr;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16647951;
this.cljs$lang$protocol_mask$partition1$ = 401412;
});
(cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_16926(coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return null;
} else {
return (new cljs.core.MapEntry((self__.arr[idx]),(self__.arr[(idx + (1))]),null));
}
}));

(cljs.core.PersistentArrayMap.prototype.toString = (function cljs$core$fn_16927(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentArrayMap.prototype.equiv = (function cljs$core$fn_16928(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentArrayMap.prototype.keys = (function cljs$core$fn_16929(){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.keys(coll));
}));

(cljs.core.PersistentArrayMap.prototype.entries = (function cljs$core$fn_16930(){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentArrayMap.prototype.values = (function cljs$core$fn_16931(){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.vals(coll));
}));

(cljs.core.PersistentArrayMap.prototype.has = (function cljs$core$fn_16932(k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
}));

(cljs.core.PersistentArrayMap.prototype.get = (function cljs$core$fn_16933(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentArrayMap.prototype.forEach = (function cljs$core$fn_16934(f){
var self__ = this;
var coll = this;
var seq__16935 = cljs.core.seq(coll);
var chunk__16936 = null;
var count__16937 = (0);
var i__16938 = (0);
while(true){
if((i__16938 < count__16937)){
var vec__16945 = chunk__16936.cljs$core$IIndexed$_nth$arity$2(null,i__16938);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16945,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16945,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__16984 = seq__16935;
var G__16985 = chunk__16936;
var G__16986 = count__16937;
var G__16987 = (i__16938 + (1));
seq__16935 = G__16984;
chunk__16936 = G__16985;
count__16937 = G__16986;
i__16938 = G__16987;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__16935);
if(temp__5720__auto__){
var seq__16935__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__16935__$1)){
var c__10518__auto__ = cljs.core.chunk_first(seq__16935__$1);
var G__16988 = cljs.core.chunk_rest(seq__16935__$1);
var G__16989 = c__10518__auto__;
var G__16990 = cljs.core.count(c__10518__auto__);
var G__16991 = (0);
seq__16935 = G__16988;
chunk__16936 = G__16989;
count__16937 = G__16990;
i__16938 = G__16991;
continue;
} else {
var vec__16948 = cljs.core.first(seq__16935__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16948,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16948,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__16992 = cljs.core.next(seq__16935__$1);
var G__16993 = null;
var G__16994 = (0);
var G__16995 = (0);
seq__16935 = G__16992;
chunk__16936 = G__16993;
count__16937 = G__16994;
i__16938 = G__16995;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16951(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16952(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function cljs$core$fn_16953(coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var G__16954 = init__$1;
var G__16955 = (self__.arr[i]);
var G__16956 = (self__.arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16954,G__16955,G__16956) : f.call(null,G__16954,G__16955,G__16956));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__16996 = (i + (2));
var G__16997 = init__$2;
i = G__16996;
init__$1 = G__16997;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_16957(this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.PersistentArrayMapIterator(self__.arr,(0),(self__.cnt * (2))));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16958(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_16959(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,self__.arr,self__.__hash));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16960(coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16961(coll){
var self__ = this;
var coll__$1 = this;
var h__10007__auto__ = self__.__hash;
if((!((h__10007__auto__ == null)))){
return h__10007__auto__;
} else {
var h__10007__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__10007__auto____$1);

return h__10007__auto____$1;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16962(coll,other){
var self__ = this;
var coll__$1 = this;
if(((cljs.core.map_QMARK_(other)) && ((!(cljs.core.record_QMARK_(other)))))){
var alen = self__.arr.length;
var other__$1 = other;
if((self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null))){
var i = (0);
while(true){
if((i < alen)){
var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null,(self__.arr[i]),cljs.core.lookup_sentinel);
if((!((v === cljs.core.lookup_sentinel)))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(i + (1))]),v)){
var G__16998 = (i + (2));
i = G__16998;
continue;
} else {
return false;
}
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return false;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function cljs$core$fn_16963(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientArrayMap(({}),self__.arr.length,cljs.core.aclone(self__.arr)));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16966(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY,self__.meta);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16967(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16968(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,start);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function cljs$core$fn_16969(coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx >= (0))){
var len = self__.arr.length;
var new_len = (len - (2));
if((new_len === (0))){
return coll__$1.cljs$core$IEmptyableCollection$_empty$arity$1(null);
} else {
var new_arr = (new Array(new_len));
var s = (0);
var d = (0);
while(true){
if((s >= len)){
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt - (1)),new_arr,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(self__.arr[s]))){
var G__16999 = (s + (2));
var G__17000 = d;
s = G__16999;
d = G__17000;
continue;
} else {
(new_arr[d] = (self__.arr[s]));

(new_arr[(d + (1))] = (self__.arr[(s + (1))]));

var G__17001 = (s + (2));
var G__17002 = (d + (2));
s = G__17001;
d = G__17002;
continue;

}
}
break;
}
}
} else {
return coll__$1;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_16970(coll,k,v){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
if((self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr__$1 = cljs.core.array_map_extend_kv(coll__$1,k,v);
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt + (1)),arr__$1,null));
} else {
return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1),k,v),self__.meta);
}
} else {
if((v === (self__.arr[(idx + (1))]))){
return coll__$1;
} else {
var arr__$1 = (function (){var G__16971 = cljs.core.aclone(self__.arr);
(G__16971[(idx + (1))] = v);

return G__16971;
})();
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,arr__$1,null));

}
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_16972(coll,k){
var self__ = this;
var coll__$1 = this;
return (!((cljs.core.array_map_index_of(coll__$1,k) === (-1))));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16973(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.persistent_array_map_seq(self__.arr,(0),null);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16974(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentArrayMap(new_meta,self__.cnt,self__.arr,self__.__hash));
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16975(coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__17003 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__17004 = cljs.core.next(es);
ret = G__17003;
es = G__17004;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
}));

(cljs.core.PersistentArrayMap.prototype.call = (function() {
var cljs$core$fn_16976 = null;
var cljs$core$fn_16976__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var cljs$core$fn_16976__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
cljs$core$fn_16976 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_16976__2.call(this,self__,k);
case 3:
return cljs$core$fn_16976__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_16976.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16976__2;
cljs$core$fn_16976.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16976__3;
return cljs$core$fn_16976;
})()
);

(cljs.core.PersistentArrayMap.prototype.apply = (function cljs$core$fn_16977(self__,args16925){
var self__ = this;
var self____$1 = this;
var args__10149__auto__ = cljs.core.aclone(args16925);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10149__auto__.length > (20)))?(function (){var G__16978 = args__10149__auto__.slice((0),(20));
G__16978.push(args__10149__auto__.slice((20)));

return G__16978;
})():args__10149__auto__)));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16979(k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16980(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IDrop$_drop$arity$2 = (function cljs$core$fn_16981(coll,n){
var self__ = this;
var coll__$1 = this;
var temp__5724__auto__ = coll__$1.cljs$core$ISeqable$_seq$arity$1(null);
if((temp__5724__auto__ == null)){
return null;
} else {
var s = temp__5724__auto__;
return cljs.core._drop(s,n);
}
}));

(cljs.core.PersistentArrayMap.getBasis = (function cljs$core$fn_16982(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentArrayMap.cljs$lang$type = true);

(cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap");

(cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = (function cljs$core$fn_16983(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/PersistentArrayMap");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMap.
 */
cljs.core.__GT_PersistentArrayMap = (function cljs$core$__GT_PersistentArrayMap(meta,cnt,arr,__hash){
return (new cljs.core.PersistentArrayMap(meta,cnt,arr,__hash));
});

(cljs.core.PersistentArrayMap.EMPTY = (new cljs.core.PersistentArrayMap(null,(0),[],cljs.core.empty_unordered_hash)));
(cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = (8));
(cljs.core.PersistentArrayMap.fromArray = (function cljs$core$fn_17005(arr,no_clone,no_check){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var arr__$2 = ((no_check)?arr__$1:(function (){var ret = [];
var i_17006 = (0);
while(true){
if((i_17006 < arr__$1.length)){
var k_17007 = (arr__$1[i_17006]);
var v_17008 = (arr__$1[(i_17006 + (1))]);
var idx_17009 = cljs.core.array_index_of(ret,k_17007);
if((idx_17009 === (-1))){
ret.push(k_17007);

ret.push(v_17008);
} else {
}

var G__17010 = (i_17006 + (2));
i_17006 = G__17010;
continue;
} else {
}
break;
}

return ret;
})());
var cnt = (arr__$2.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr__$2,null));
}));
(cljs.core.PersistentArrayMap.createWithCheck = (function cljs$core$fn_17011(arr){
var ret = [];
var i_17013 = (0);
while(true){
if((i_17013 < arr.length)){
var k_17014 = (arr[i_17013]);
var v_17015 = (arr[(i_17013 + (1))]);
var idx_17016 = cljs.core.array_index_of(ret,k_17014);
if((idx_17016 === (-1))){
var G__17012_17017 = ret;
G__17012_17017.push(k_17014);

G__17012_17017.push(v_17015);

} else {
throw (new Error(["Duplicate key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k_17014)].join('')));
}

var G__17018 = (i_17013 + (2));
i_17013 = G__17018;
continue;
} else {
}
break;
}

var cnt = (arr.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr,null));
}));
cljs.core.key_test = (function cljs$core$key_test(key,other){
if((key === other)){
return true;
} else {
if(cljs.core.keyword_identical_QMARK_(key,other)){
return true;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,other);

}
}
});
cljs.core.pam_dupes_QMARK_ = (function cljs$core$pam_dupes_QMARK_(arr){
var i = (0);
while(true){
if((i < arr.length)){
var dupe_QMARK_ = (function (){var j = (0);
while(true){
if((j < i)){
var or__9546__auto__ = cljs.core.key_test((arr[i]),(arr[j]));
if(or__9546__auto__){
return or__9546__auto__;
} else {
var G__17019 = ((2) + j);
j = G__17019;
continue;
}
} else {
return false;
}
break;
}
})();
var or__9546__auto__ = dupe_QMARK_;
if(or__9546__auto__){
return or__9546__auto__;
} else {
var G__17020 = ((2) + i);
i = G__17020;
continue;
}
} else {
return false;
}
break;
}
});
cljs.core.pam_new_size = (function cljs$core$pam_new_size(arr){
var i = (0);
var n = (0);
while(true){
if((i < arr.length)){
var dupe_QMARK_ = (function (){var j = (0);
while(true){
if((j < i)){
var or__9546__auto__ = cljs.core.key_test((arr[i]),(arr[j]));
if(or__9546__auto__){
return or__9546__auto__;
} else {
var G__17021 = ((2) + j);
j = G__17021;
continue;
}
} else {
return false;
}
break;
}
})();
var G__17022 = ((2) + i);
var G__17023 = ((dupe_QMARK_)?n:(n + (2)));
i = G__17022;
n = G__17023;
continue;
} else {
return n;
}
break;
}
});
cljs.core.pam_grow_seed_array = (function cljs$core$pam_grow_seed_array(seed,trailing){
var seed_cnt = (seed.length - (1));
var extra_kvs = cljs.core.seq(trailing);
var ret = (new Array((seed_cnt + ((2) * cljs.core.count(extra_kvs)))));
var ret__$1 = cljs.core.array_copy(seed,(0),ret,(0),seed_cnt);
var i = seed_cnt;
var extra_kvs__$1 = extra_kvs;
while(true){
if(extra_kvs__$1){
var kv = cljs.core.first(extra_kvs__$1);
(ret__$1[i] = cljs.core._key(kv));

(ret__$1[(i + (1))] = cljs.core._val(kv));

var G__17024 = ((2) + seed_cnt);
var G__17025 = cljs.core.next(extra_kvs__$1);
i = G__17024;
extra_kvs__$1 = G__17025;
continue;
} else {
return ret__$1;
}
break;
}
});
(cljs.core.PersistentArrayMap.createAsIfByAssoc = (function cljs$core$fn_17026(init){
var len = init.length;
var has_trailing_QMARK_ = ((1) === (len & (1)));
if((!(((has_trailing_QMARK_) || (cljs.core.pam_dupes_QMARK_(init)))))){
return (new cljs.core.PersistentArrayMap(null,(len / (2)),init,null));
} else {
return cljs.core.PersistentArrayMap.createAsIfByAssocComplexPath(init,has_trailing_QMARK_);
}
}));
(cljs.core.PersistentArrayMap.createAsIfByAssocComplexPath = (function cljs$core$fn_17027(init,has_trailing_QMARK_){
var init__$1 = ((has_trailing_QMARK_)?cljs.core.pam_grow_seed_array(init,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(init[(init.length - (1))]))):init);
var n = cljs.core.pam_new_size(init__$1);
var len = init__$1.length;
if((n < len)){
var nodups = (new Array(n));
var i_17028 = (0);
var m_17029 = (0);
while(true){
if((i_17028 < len)){
var dupe_QMARK__17030 = (function (){var j = (0);
while(true){
if((j < m_17029)){
var or__9546__auto__ = cljs.core.key_test((init__$1[i_17028]),(init__$1[j]));
if(or__9546__auto__){
return or__9546__auto__;
} else {
var G__17031 = ((2) + j);
j = G__17031;
continue;
}
} else {
return false;
}
break;
}
})();
if((!(dupe_QMARK__17030))){
var j_17032 = (function (){var j_17032 = (len - (2));
while(true){
if((j_17032 >= i_17028)){
if(cljs.core.key_test((init__$1[i_17028]),(init__$1[j_17032]))){
return j_17032;
} else {
var G__17033 = (j_17032 - (2));
j_17032 = G__17033;
continue;
}
} else {
return j_17032;
}
break;
}
})();
(nodups[m_17029] = (init__$1[i_17028]));

(nodups[(m_17029 + (1))] = (init__$1[(j_17032 + (1))]));

var G__17034 = ((2) + i_17028);
var G__17035 = ((2) + m_17029);
i_17028 = G__17034;
m_17029 = G__17035;
continue;
} else {
var G__17036 = ((2) + i_17028);
var G__17037 = m_17029;
i_17028 = G__17036;
m_17029 = G__17037;
continue;
}
} else {
}
break;
}

return (new cljs.core.PersistentArrayMap(null,(nodups.length / (2)),nodups,null));
} else {
return (new cljs.core.PersistentArrayMap(null,(init__$1.length / (2)),init__$1,null));
}
}));
(cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17038(){
var this__10736__auto__ = this;
return cljs.core.es6_iterator(this__10736__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientArrayMap = (function (editable_QMARK_,len,arr){
this.editable_QMARK_ = editable_QMARK_;
this.len = len;
this.arr = arr;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 56;
});
(cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17040(tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
return cljs.core.quot(self__.len,(2));
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_17041(tcoll,k){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_17042(tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of(tcoll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
} else {
throw (new Error("lookup after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function cljs$core$fn_17043(tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
if(cljs.core.map_entry_QMARK_(o)){
return tcoll__$1.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,cljs.core.key(o),cljs.core.val(o));
} else {
if(cljs.core.vector_QMARK_(o)){
return tcoll__$1.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((0)) : o.call(null,(0))),(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((1)) : o.call(null,(1))));
} else {
var es = cljs.core.seq(o);
var tcoll__$2 = tcoll__$1;
while(true){
var temp__5718__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__5718__auto__)){
var e = temp__5718__auto__;
var G__17055 = cljs.core.next(es);
var G__17056 = cljs.core._assoc_BANG_(tcoll__$2,cljs.core.key(e),cljs.core.val(e));
es = G__17055;
tcoll__$2 = G__17056;
continue;
} else {
return tcoll__$2;
}
break;
}

}
}
} else {
throw (new Error("conj! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function cljs$core$fn_17044(tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
(self__.editable_QMARK_ = false);

return (new cljs.core.PersistentArrayMap(null,cljs.core.quot(self__.len,(2)),self__.arr,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function cljs$core$fn_17045(tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx === (-1))){
if(((self__.len + (2)) <= ((2) * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD))){
(self__.len = (self__.len + (2)));

self__.arr.push(key);

self__.arr.push(val);

return tcoll__$1;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.array__GT_transient_hash_map(self__.len,self__.arr),key,val);
}
} else {
if((val === (self__.arr[(idx + (1))]))){
return tcoll__$1;
} else {
(self__.arr[(idx + (1))] = val);

return tcoll__$1;
}
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function cljs$core$fn_17046(tcoll,key){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx >= (0))){
(self__.arr[idx] = (self__.arr[(self__.len - (2))]));

(self__.arr[(idx + (1))] = (self__.arr[(self__.len - (1))]));

var G__17047_17057 = self__.arr;
G__17047_17057.pop();

G__17047_17057.pop();


(self__.len = (self__.len - (2)));
} else {
}

return tcoll__$1;
} else {
throw (new Error("dissoc! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.call = (function() {
var cljs$core$fn_17048 = null;
var cljs$core$fn_17048__2 = (function (self__,key){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,null);
});
var cljs$core$fn_17048__3 = (function (self__,key,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
});
cljs$core$fn_17048 = function(self__,key,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_17048__2.call(this,self__,key);
case 3:
return cljs$core$fn_17048__3.call(this,self__,key,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_17048.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17048__2;
cljs$core$fn_17048.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_17048__3;
return cljs$core$fn_17048;
})()
);

(cljs.core.TransientArrayMap.prototype.apply = (function cljs$core$fn_17049(self__,args17039){
var self__ = this;
var self____$1 = this;
var args__10149__auto__ = cljs.core.aclone(args17039);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10149__auto__.length > (20)))?(function (){var G__17050 = args__10149__auto__.slice((0),(20));
G__17050.push(args__10149__auto__.slice((20)));

return G__17050;
})():args__10149__auto__)));
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17051(key){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,null);
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_17052(key,not_found){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
}));

(cljs.core.TransientArrayMap.getBasis = (function cljs$core$fn_17053(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"editable?","editable?",-164945806,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"len","len",-1230778691,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null);
}));

(cljs.core.TransientArrayMap.cljs$lang$type = true);

(cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap");

(cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = (function cljs$core$fn_17054(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/TransientArrayMap");
}));

/**
 * Positional factory function for cljs.core/TransientArrayMap.
 */
cljs.core.__GT_TransientArrayMap = (function cljs$core$__GT_TransientArrayMap(editable_QMARK_,len,arr){
return (new cljs.core.TransientArrayMap(editable_QMARK_,len,arr));
});

cljs.core.array__GT_transient_hash_map = (function cljs$core$array__GT_transient_hash_map(len,arr){
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i = (0);
while(true){
if((i < len)){
var G__17058 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,(arr[i]),(arr[(i + (1))]));
var G__17059 = (i + (2));
out = G__17058;
i = G__17059;
continue;
} else {
return out;
}
break;
}
});

/**
* @constructor
*/
cljs.core.Box = (function (val){
this.val = val;
});

(cljs.core.Box.getBasis = (function cljs$core$fn_17060(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Box.cljs$lang$type = true);

(cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box");

(cljs.core.Box.cljs$lang$ctorPrWriter = (function cljs$core$fn_17061(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/Box");
}));

/**
 * Positional factory function for cljs.core/Box.
 */
cljs.core.__GT_Box = (function cljs$core$__GT_Box(val){
return (new cljs.core.Box(val));
});



cljs.core.mask = (function cljs$core$mask(hash,shift){
return ((hash >>> shift) & (31));
});
cljs.core.clone_and_set = (function cljs$core$clone_and_set(var_args){
var G__17063 = arguments.length;
switch (G__17063) {
case 3:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_17064(arr,i,a){
var G__17065 = cljs.core.aclone(arr);
(G__17065[i] = a);

return G__17065;
}));

(cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_17066(arr,i,a,j,b){
var G__17067 = cljs.core.aclone(arr);
(G__17067[i] = a);

(G__17067[j] = b);

return G__17067;
}));

(cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5);

cljs.core.remove_pair = (function cljs$core$remove_pair(arr,i){
var new_arr = (new Array((arr.length - (2))));
cljs.core.array_copy(arr,(0),new_arr,(0),((2) * i));

cljs.core.array_copy(arr,((2) * (i + (1))),new_arr,((2) * i),(new_arr.length - ((2) * i)));

return new_arr;
});
cljs.core.bitmap_indexed_node_index = (function cljs$core$bitmap_indexed_node_index(bitmap,bit){
return cljs.core.bit_count((bitmap & (bit - (1))));
});
cljs.core.bitpos = (function cljs$core$bitpos(hash,shift){
return ((1) << ((hash >>> shift) & 0x01f));
});
cljs.core.edit_and_set = (function cljs$core$edit_and_set(var_args){
var G__17070 = arguments.length;
switch (G__17070) {
case 4:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_17071(inode,edit,i,a){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

return editable;
}));

(cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_17072(inode,edit,i,a,j,b){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

(editable.arr[j] = b);

return editable;
}));

(cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6);

cljs.core.inode_kv_reduce = (function cljs$core$inode_kv_reduce(arr,f,init){
var len = arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var k = (arr[i]);
if((!((k == null)))){
var G__17074 = init__$1;
var G__17075 = k;
var G__17076 = (arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17074,G__17075,G__17076) : f.call(null,G__17074,G__17075,G__17076));
} else {
var node = (arr[(i + (1))]);
if((!((node == null)))){
return node.kv_reduce(f,init__$1);
} else {
return init__$1;
}
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
var G__17077 = (i + (2));
var G__17078 = init__$2;
i = G__17077;
init__$1 = G__17078;
continue;
}
} else {
return init__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.NodeIterator = (function (arr,i,next_entry,next_iter){
this.arr = arr;
this.i = i;
this.next_entry = next_entry;
this.next_iter = next_iter;
});
(cljs.core.NodeIterator.prototype.advance = (function cljs$core$fn_17079(){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if((self__.i < len)){
var key = (self__.arr[self__.i]);
var node_or_val = (self__.arr[(self__.i + (1))]);
var found = (((!((key == null))))?(self__.next_entry = (new cljs.core.MapEntry(key,node_or_val,null))):(((!((node_or_val == null))))?(function (){var new_iter = cljs.core._iterator(node_or_val);
if(new_iter.hasNext()){
return (self__.next_iter = new_iter);
} else {
return false;
}
})():false
));
(self__.i = (self__.i + (2)));

if(found){
return true;
} else {
continue;
}
} else {
return false;
}
break;
}
}));

(cljs.core.NodeIterator.prototype.hasNext = (function cljs$core$fn_17080(){
var self__ = this;
var this$ = this;
var or__9546__auto__ = (!((self__.next_entry == null)));
if(or__9546__auto__){
return or__9546__auto__;
} else {
var or__9546__auto____$1 = (!((self__.next_iter == null)));
if(or__9546__auto____$1){
return or__9546__auto____$1;
} else {
return this$.advance();
}
}
}));

(cljs.core.NodeIterator.prototype.next = (function cljs$core$fn_17081(){
var self__ = this;
var this$ = this;
if((!((self__.next_entry == null)))){
var ret = self__.next_entry;
(self__.next_entry = null);

return ret;
} else {
if((!((self__.next_iter == null)))){
var ret = self__.next_iter.next();
if(self__.next_iter.hasNext()){
} else {
(self__.next_iter = null);
}

return ret;
} else {
if(this$.advance()){
return this$.next();
} else {
throw (new Error("No such element"));

}
}
}
}));

(cljs.core.NodeIterator.prototype.remove = (function cljs$core$fn_17082(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.NodeIterator.getBasis = (function cljs$core$fn_17083(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-entry","next-entry",1091342476,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-iter","next-iter",1526626239,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.NodeIterator.cljs$lang$type = true);

(cljs.core.NodeIterator.cljs$lang$ctorStr = "cljs.core/NodeIterator");

(cljs.core.NodeIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_17084(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/NodeIterator");
}));

/**
 * Positional factory function for cljs.core/NodeIterator.
 */
cljs.core.__GT_NodeIterator = (function cljs$core$__GT_NodeIterator(arr,i,next_entry,next_iter){
return (new cljs.core.NodeIterator(arr,i,next_entry,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.BitmapIndexedNode = (function (edit,bitmap,arr){
this.edit = edit;
this.bitmap = bitmap;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.BitmapIndexedNode.prototype.ensure_editable = (function cljs$core$fn_17085(e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var n = cljs.core.bit_count(self__.bitmap);
var new_arr = (new Array((((n < (0)))?(4):((2) * (n + (1))))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * n));

return (new cljs.core.BitmapIndexedNode(e,self__.bitmap,new_arr));
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = (function cljs$core$fn_17086(edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
if((!((n == null)))){
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
} else {
if((self__.bitmap === bit)){
return null;
} else {
return inode.edit_and_remove_pair(edit__$1,bit,idx);

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
(removed_leaf_QMARK_.val = true);

return inode.edit_and_remove_pair(edit__$1,bit,idx);
} else {
return inode;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = (function cljs$core$fn_17087(e,bit,i){
var self__ = this;
var inode = this;
if((self__.bitmap === bit)){
return null;
} else {
var editable = inode.ensure_editable(e);
var earr = editable.arr;
var len = earr.length;
(editable.bitmap = (bit ^ editable.bitmap));

cljs.core.array_copy(earr,((2) * (i + (1))),earr,((2) * i),(len - ((2) * (i + (1)))));

(earr[(len - (2))] = null);

(earr[(len - (1))] = null);

return editable;
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_seq = (function cljs$core$fn_17088(){
var self__ = this;
var inode = this;
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr);
}));

(cljs.core.BitmapIndexedNode.prototype.kv_reduce = (function cljs$core$fn_17089(f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
}));

(cljs.core.BitmapIndexedNode.prototype.inode_lookup = (function cljs$core$fn_17090(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return val_or_node;
} else {
return not_found;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = (function cljs$core$fn_17091(edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((((2) * n) < self__.arr.length)){
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(added_leaf_QMARK_.val = true);

cljs.core.array_copy_downward(earr,((2) * idx),earr,((2) * (idx + (1))),((2) * (n - idx)));

(earr[((2) * idx)] = key);

(earr[(((2) * idx) + (1))] = val);

(editable.bitmap = (editable.bitmap | bit));

return editable;
} else {
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_17098 = (0);
var j_17099 = (0);
while(true){
if((i_17098 < (32))){
if((((self__.bitmap >>> i_17098) & (1)) === (0))){
var G__17100 = (i_17098 + (1));
var G__17101 = j_17099;
i_17098 = G__17100;
j_17099 = G__17101;
continue;
} else {
(nodes[i_17098] = (((!(((self__.arr[j_17099]) == null))))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),cljs.core.hash((self__.arr[j_17099])),(self__.arr[j_17099]),(self__.arr[(j_17099 + (1))]),added_leaf_QMARK_):(self__.arr[(j_17099 + (1))])));

var G__17102 = (i_17098 + (1));
var G__17103 = (j_17099 + (2));
i_17098 = G__17102;
j_17099 = G__17103;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(edit__$1,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (4)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

(added_leaf_QMARK_.val = true);

var editable = inode.ensure_editable(edit__$1);
(editable.arr = new_arr);

(editable.bitmap = (editable.bitmap | bit));

return editable;

}
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),val);
}
} else {
(added_leaf_QMARK_.val = true);

return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * idx),null,(((2) * idx) + (1)),cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(edit__$1,(shift + (5)),key_or_nil,val_or_node,hash,key,val));

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_assoc = (function cljs$core$fn_17092(shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_17104 = (0);
var j_17105 = (0);
while(true){
if((i_17104 < (32))){
if((((self__.bitmap >>> i_17104) & (1)) === (0))){
var G__17106 = (i_17104 + (1));
var G__17107 = j_17105;
i_17104 = G__17106;
j_17105 = G__17107;
continue;
} else {
(nodes[i_17104] = (((!(((self__.arr[j_17105]) == null))))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),cljs.core.hash((self__.arr[j_17105])),(self__.arr[j_17105]),(self__.arr[(j_17105 + (1))]),added_leaf_QMARK_):(self__.arr[(j_17105 + (1))])));

var G__17108 = (i_17104 + (1));
var G__17109 = (j_17105 + (2));
i_17104 = G__17108;
j_17105 = G__17109;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(null,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

(added_leaf_QMARK_.val = true);

return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap | bit),new_arr));
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),val)));
}
} else {
(added_leaf_QMARK_.val = true);

return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr,((2) * idx),null,(((2) * idx) + (1)),cljs.core.create_node.cljs$core$IFn$_invoke$arity$6((shift + (5)),key_or_nil,val_or_node,hash,key,val))));

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_find = (function cljs$core$fn_17093(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_find((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return (new cljs.core.MapEntry(key_or_nil,val_or_node,null));
} else {
return not_found;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_without = (function cljs$core$fn_17094(shift,hash,key){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without((shift + (5)),hash,key);
if((n === val_or_node)){
return inode;
} else {
if((!((n == null)))){
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
} else {
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));
}
} else {
return inode;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_17095(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
}));

(cljs.core.BitmapIndexedNode.getBasis = (function cljs$core$fn_17096(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"bitmap","bitmap",501334601,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.BitmapIndexedNode.cljs$lang$type = true);

(cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode");

(cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_17097(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/BitmapIndexedNode");
}));

/**
 * Positional factory function for cljs.core/BitmapIndexedNode.
 */
cljs.core.__GT_BitmapIndexedNode = (function cljs$core$__GT_BitmapIndexedNode(edit,bitmap,arr){
return (new cljs.core.BitmapIndexedNode(edit,bitmap,arr));
});

(cljs.core.BitmapIndexedNode.EMPTY = (new cljs.core.BitmapIndexedNode(null,(0),[])));
cljs.core.pack_array_node = (function cljs$core$pack_array_node(array_node,edit,idx){
var arr = array_node.arr;
var len = arr.length;
var new_arr = (new Array(((2) * (array_node.cnt - (1)))));
var i = (0);
var j = (1);
var bitmap = (0);
while(true){
if((i < len)){
if((((!((i === idx)))) && ((!(((arr[i]) == null)))))){
(new_arr[j] = (arr[i]));

var G__17110 = (i + (1));
var G__17111 = (j + (2));
var G__17112 = (bitmap | ((1) << i));
i = G__17110;
j = G__17111;
bitmap = G__17112;
continue;
} else {
var G__17113 = (i + (1));
var G__17114 = j;
var G__17115 = bitmap;
i = G__17113;
j = G__17114;
bitmap = G__17115;
continue;
}
} else {
return (new cljs.core.BitmapIndexedNode(edit,bitmap,new_arr));
}
break;
}
});

/**
* @constructor
*/
cljs.core.ArrayNodeIterator = (function (arr,i,next_iter){
this.arr = arr;
this.i = i;
this.next_iter = next_iter;
});
(cljs.core.ArrayNodeIterator.prototype.hasNext = (function cljs$core$fn_17116(){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if((!((((!((self__.next_iter == null)))) && (self__.next_iter.hasNext()))))){
if((self__.i < len)){
var node = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

if((!((node == null)))){
(self__.next_iter = cljs.core._iterator(node));
} else {
}

continue;
} else {
return false;
}
} else {
return true;
}
break;
}
}));

(cljs.core.ArrayNodeIterator.prototype.next = (function cljs$core$fn_17117(){
var self__ = this;
var this$ = this;
if(this$.hasNext()){
return self__.next_iter.next();
} else {
throw (new Error("No such element"));
}
}));

(cljs.core.ArrayNodeIterator.prototype.remove = (function cljs$core$fn_17118(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.ArrayNodeIterator.getBasis = (function cljs$core$fn_17119(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-iter","next-iter",1526626239,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayNodeIterator.cljs$lang$type = true);

(cljs.core.ArrayNodeIterator.cljs$lang$ctorStr = "cljs.core/ArrayNodeIterator");

(cljs.core.ArrayNodeIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_17120(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/ArrayNodeIterator");
}));

/**
 * Positional factory function for cljs.core/ArrayNodeIterator.
 */
cljs.core.__GT_ArrayNodeIterator = (function cljs$core$__GT_ArrayNodeIterator(arr,i,next_iter){
return (new cljs.core.ArrayNodeIterator(arr,i,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.ArrayNode = (function (edit,cnt,arr){
this.edit = edit;
this.cnt = cnt;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.ArrayNode.prototype.ensure_editable = (function cljs$core$fn_17121(e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
return (new cljs.core.ArrayNode(e,self__.cnt,cljs.core.aclone(self__.arr)));
}
}));

(cljs.core.ArrayNode.prototype.inode_without_BANG_ = (function cljs$core$fn_17122(edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return inode;
} else {
var n = node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,edit__$1,idx);
} else {
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
(editable.cnt = (editable.cnt - (1)));

return editable;
}
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);

}
}
}
}));

(cljs.core.ArrayNode.prototype.inode_seq = (function cljs$core$fn_17123(){
var self__ = this;
var inode = this;
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(self__.arr);
}));

(cljs.core.ArrayNode.prototype.kv_reduce = (function cljs$core$fn_17124(f,init){
var self__ = this;
var inode = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var node = (self__.arr[i]);
if((!((node == null)))){
var init__$2 = node.kv_reduce(f,init__$1);
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
var G__17133 = (i + (1));
var G__17134 = init__$2;
i = G__17133;
init__$1 = G__17134;
continue;
}
} else {
var G__17135 = (i + (1));
var G__17136 = init__$1;
i = G__17135;
init__$1 = G__17136;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.ArrayNode.prototype.inode_lookup = (function cljs$core$fn_17125(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
return node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
}));

(cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = (function cljs$core$fn_17126(edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));
(editable.cnt = (editable.cnt + (1)));

return editable;
} else {
var n = node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
}
}
}));

(cljs.core.ArrayNode.prototype.inode_assoc = (function cljs$core$fn_17127(shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return (new cljs.core.ArrayNode(null,(self__.cnt + (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_))));
} else {
var n = node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
}
}));

(cljs.core.ArrayNode.prototype.inode_find = (function cljs$core$fn_17128(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
return node.inode_find((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
}));

(cljs.core.ArrayNode.prototype.inode_without = (function cljs$core$fn_17129(shift,hash,key){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
var n = node.inode_without((shift + (5)),hash,key);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,null,idx);
} else {
return (new cljs.core.ArrayNode(null,(self__.cnt - (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));

}
}
} else {
return inode;
}
}));

(cljs.core.ArrayNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_17130(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeIterator(self__.arr,(0),null));
}));

(cljs.core.ArrayNode.getBasis = (function cljs$core$fn_17131(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayNode.cljs$lang$type = true);

(cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode");

(cljs.core.ArrayNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_17132(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/ArrayNode");
}));

/**
 * Positional factory function for cljs.core/ArrayNode.
 */
cljs.core.__GT_ArrayNode = (function cljs$core$__GT_ArrayNode(edit,cnt,arr){
return (new cljs.core.ArrayNode(edit,cnt,arr));
});

cljs.core.hash_collision_node_find_index = (function cljs$core$hash_collision_node_find_index(arr,cnt,key){
var lim = ((2) * cnt);
var i = (0);
while(true){
if((i < lim)){
if(cljs.core.key_test(key,(arr[i]))){
return i;
} else {
var G__17137 = (i + (2));
i = G__17137;
continue;
}
} else {
return (-1);
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.HashCollisionNode = (function (edit,collision_hash,cnt,arr){
this.edit = edit;
this.collision_hash = collision_hash;
this.cnt = cnt;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.HashCollisionNode.prototype.ensure_editable = (function cljs$core$fn_17138(e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var new_arr = (new Array(((2) * (self__.cnt + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * self__.cnt));

return (new cljs.core.HashCollisionNode(e,self__.collision_hash,self__.cnt,new_arr));
}
}));

(cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = (function cljs$core$fn_17139(edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
(removed_leaf_QMARK_.val = true);

if((self__.cnt === (1))){
return null;
} else {
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(earr[idx] = (earr[(((2) * self__.cnt) - (2))]));

(earr[(idx + (1))] = (earr[(((2) * self__.cnt) - (1))]));

(earr[(((2) * self__.cnt) - (1))] = null);

(earr[(((2) * self__.cnt) - (2))] = null);

(editable.cnt = (editable.cnt - (1)));

return editable;
}
}
}));

(cljs.core.HashCollisionNode.prototype.inode_seq = (function cljs$core$fn_17140(){
var self__ = this;
var inode = this;
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr);
}));

(cljs.core.HashCollisionNode.prototype.kv_reduce = (function cljs$core$fn_17141(f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
}));

(cljs.core.HashCollisionNode.prototype.inode_lookup = (function cljs$core$fn_17142(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (self__.arr[(idx + (1))]);
} else {
return not_found;

}
}
}));

(cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = (function cljs$core$fn_17143(edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
if((self__.arr.length > ((2) * self__.cnt))){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * self__.cnt),key,(((2) * self__.cnt) + (1)),val);
(added_leaf_QMARK_.val = true);

(editable.cnt = (editable.cnt + (1)));

return editable;
} else {
var len = self__.arr.length;
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

(added_leaf_QMARK_.val = true);

return inode.ensure_editable_array(edit__$1,(self__.cnt + (1)),new_arr);
}
} else {
if(((self__.arr[(idx + (1))]) === val)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(idx + (1)),val);
}
}
} else {
return (new cljs.core.BitmapIndexedNode(edit__$1,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode,null,null])).inode_assoc_BANG_(edit__$1,shift,hash,key,val,added_leaf_QMARK_);
}
}));

(cljs.core.HashCollisionNode.prototype.inode_assoc = (function cljs$core$fn_17144(shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
var len = ((2) * self__.cnt);
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

(added_leaf_QMARK_.val = true);

return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt + (1)),new_arr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(idx + (1))]),val)){
return inode;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(idx + (1)),val)));
}
}
} else {
return (new cljs.core.BitmapIndexedNode(null,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode])).inode_assoc(shift,hash,key,val,added_leaf_QMARK_);
}
}));

(cljs.core.HashCollisionNode.prototype.ensure_editable_array = (function cljs$core$fn_17145(e,count,array){
var self__ = this;
var inode = this;
if((e === self__.edit)){
(self__.arr = array);

(self__.cnt = count);

return inode;
} else {
return (new cljs.core.HashCollisionNode(self__.edit,self__.collision_hash,count,array));
}
}));

(cljs.core.HashCollisionNode.prototype.inode_find = (function cljs$core$fn_17146(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (new cljs.core.MapEntry((self__.arr[idx]),(self__.arr[(idx + (1))]),null));
} else {
return not_found;

}
}
}));

(cljs.core.HashCollisionNode.prototype.inode_without = (function cljs$core$fn_17147(shift,hash,key){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
if((self__.cnt === (1))){
return null;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt - (1)),cljs.core.remove_pair(self__.arr,cljs.core.quot(idx,(2)))));

}
}
}));

(cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_17148(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
}));

(cljs.core.HashCollisionNode.getBasis = (function cljs$core$fn_17149(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"collision-hash","collision-hash",-35831342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.HashCollisionNode.cljs$lang$type = true);

(cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode");

(cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_17150(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/HashCollisionNode");
}));

/**
 * Positional factory function for cljs.core/HashCollisionNode.
 */
cljs.core.__GT_HashCollisionNode = (function cljs$core$__GT_HashCollisionNode(edit,collision_hash,cnt,arr){
return (new cljs.core.HashCollisionNode(edit,collision_hash,cnt,arr));
});

cljs.core.create_node = (function cljs$core$create_node(var_args){
var G__17152 = arguments.length;
switch (G__17152) {
case 6:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_17153(shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc(shift,key2hash,key2,val2,added_leaf_QMARK_);
}
}));

(cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = (function cljs$core$fn_17154(edit,shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc_BANG_(edit,shift,key2hash,key2,val2,added_leaf_QMARK_);
}
}));

(cljs.core.create_node.cljs$lang$maxFixedArity = 7);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.NodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.NodeSeq.prototype.toString = (function cljs$core$fn_17156(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.NodeSeq.prototype.equiv = (function cljs$core$fn_17157(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.NodeSeq.prototype.indexOf = (function() {
var cljs$core$fn_17158 = null;
var cljs$core$fn_17158__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_17158__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17158 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17158__1.call(this,x);
case 2:
return cljs$core$fn_17158__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17158.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17158__1;
cljs$core$fn_17158.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17158__2;
return cljs$core$fn_17158;
})()
);

(cljs.core.NodeSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_17159 = null;
var cljs$core$fn_17159__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_17159__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17159 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17159__1.call(this,x);
case 2:
return cljs$core$fn_17159__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17159.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17159__1;
cljs$core$fn_17159.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17159__2;
return cljs$core$fn_17159;
})()
);

(cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17160(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.NodeSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_17161(coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,(self__.i + (2)),null);
} else {
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s));
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17162(coll){
var self__ = this;
var coll__$1 = this;
var h__10007__auto__ = self__.__hash;
if((!((h__10007__auto__ == null)))){
return h__10007__auto__;
} else {
var h__10007__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10007__auto____$1);

return h__10007__auto____$1;
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17163(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17164(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17165(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17166(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_17167(coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return (new cljs.core.MapEntry((self__.nodes[self__.i]),(self__.nodes[(self__.i + (1))]),null));
} else {
return cljs.core.first(self__.s);
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_17168(coll){
var self__ = this;
var coll__$1 = this;
var ret = (((self__.s == null))?cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,(self__.i + (2)),null):cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s)));
if((!((ret == null)))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17169(this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17170(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.NodeSeq(new_meta,self__.nodes,self__.i,self__.s,self__.__hash));
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17171(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.NodeSeq.getBasis = (function cljs$core$fn_17172(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"nodes","nodes",-459054278,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.NodeSeq.cljs$lang$type = true);

(cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq");

(cljs.core.NodeSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_17173(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/NodeSeq");
}));

/**
 * Positional factory function for cljs.core/NodeSeq.
 */
cljs.core.__GT_NodeSeq = (function cljs$core$__GT_NodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.NodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17174(){
var this__10736__auto__ = this;
return cljs.core.es6_iterator(this__10736__auto__);
}));
cljs.core.create_inode_seq = (function cljs$core$create_inode_seq(var_args){
var G__17176 = arguments.length;
switch (G__17176) {
case 1:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17177(nodes){
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
}));

(cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_17178(nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
if((!(((nodes[j]) == null)))){
return (new cljs.core.NodeSeq(null,nodes,j,null,null));
} else {
var temp__5718__auto__ = (nodes[(j + (1))]);
if(cljs.core.truth_(temp__5718__auto__)){
var node = temp__5718__auto__;
var temp__5718__auto____$1 = node.inode_seq();
if(cljs.core.truth_(temp__5718__auto____$1)){
var node_seq = temp__5718__auto____$1;
return (new cljs.core.NodeSeq(null,nodes,(j + (2)),node_seq,null));
} else {
var G__17180 = (j + (2));
j = G__17180;
continue;
}
} else {
var G__17181 = (j + (2));
j = G__17181;
continue;
}
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.NodeSeq(null,nodes,i,s,null));
}
}));

(cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayNodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ArrayNodeSeq.prototype.toString = (function cljs$core$fn_17182(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ArrayNodeSeq.prototype.equiv = (function cljs$core$fn_17183(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ArrayNodeSeq.prototype.indexOf = (function() {
var cljs$core$fn_17184 = null;
var cljs$core$fn_17184__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_17184__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17184 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17184__1.call(this,x);
case 2:
return cljs$core$fn_17184__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17184.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17184__1;
cljs$core$fn_17184.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17184__2;
return cljs$core$fn_17184;
})()
);

(cljs.core.ArrayNodeSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_17185 = null;
var cljs$core$fn_17185__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_17185__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17185 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17185__1.call(this,x);
case 2:
return cljs$core$fn_17185__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17185.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17185__1;
cljs$core$fn_17185.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17185__2;
return cljs$core$fn_17185;
})()
);

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17186(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_17187(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s));
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17188(coll){
var self__ = this;
var coll__$1 = this;
var h__10007__auto__ = self__.__hash;
if((!((h__10007__auto__ == null)))){
return h__10007__auto__;
} else {
var h__10007__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10007__auto____$1);

return h__10007__auto____$1;
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17189(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17190(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17191(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17192(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_17193(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.s);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_17194(coll){
var self__ = this;
var coll__$1 = this;
var ret = cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s));
if((!((ret == null)))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17195(this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17196(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ArrayNodeSeq(new_meta,self__.nodes,self__.i,self__.s,self__.__hash));
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17197(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.ArrayNodeSeq.getBasis = (function cljs$core$fn_17198(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"nodes","nodes",-459054278,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayNodeSeq.cljs$lang$type = true);

(cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq");

(cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_17199(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/ArrayNodeSeq");
}));

/**
 * Positional factory function for cljs.core/ArrayNodeSeq.
 */
cljs.core.__GT_ArrayNodeSeq = (function cljs$core$__GT_ArrayNodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17200(){
var this__10736__auto__ = this;
return cljs.core.es6_iterator(this__10736__auto__);
}));
cljs.core.create_array_node_seq = (function cljs$core$create_array_node_seq(var_args){
var G__17202 = arguments.length;
switch (G__17202) {
case 1:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17203(nodes){
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
}));

(cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_17204(nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
var temp__5718__auto__ = (nodes[j]);
if(cljs.core.truth_(temp__5718__auto__)){
var nj = temp__5718__auto__;
var temp__5718__auto____$1 = nj.inode_seq();
if(cljs.core.truth_(temp__5718__auto____$1)){
var ns = temp__5718__auto____$1;
return (new cljs.core.ArrayNodeSeq(null,nodes,(j + (1)),ns,null));
} else {
var G__17206 = (j + (1));
j = G__17206;
continue;
}
} else {
var G__17207 = (j + (1));
j = G__17207;
continue;
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.ArrayNodeSeq(null,nodes,i,s,null));
}
}));

(cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 3);


/**
* @constructor
*/
cljs.core.HashMapIter = (function (nil_val,root_iter,seen){
this.nil_val = nil_val;
this.root_iter = root_iter;
this.seen = seen;
});
(cljs.core.HashMapIter.prototype.hasNext = (function cljs$core$fn_17208(){
var self__ = this;
var _ = this;
return (((!(self__.seen))) || (self__.root_iter.hasNext()));
}));

(cljs.core.HashMapIter.prototype.next = (function cljs$core$fn_17209(){
var self__ = this;
var _ = this;
if((!(self__.seen))){
(self__.seen = true);

return (new cljs.core.MapEntry(null,self__.nil_val,null));
} else {
return self__.root_iter.next();
}
}));

(cljs.core.HashMapIter.prototype.remove = (function cljs$core$fn_17210(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.HashMapIter.getBasis = (function cljs$core$fn_17211(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),new cljs.core.Symbol(null,"root-iter","root-iter",1974672108,null),cljs.core.with_meta(new cljs.core.Symbol(null,"seen","seen",1121531738,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.HashMapIter.cljs$lang$type = true);

(cljs.core.HashMapIter.cljs$lang$ctorStr = "cljs.core/HashMapIter");

(cljs.core.HashMapIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_17212(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/HashMapIter");
}));

/**
 * Positional factory function for cljs.core/HashMapIter.
 */
cljs.core.__GT_HashMapIter = (function cljs$core$__GT_HashMapIter(nil_val,root_iter,seen){
return (new cljs.core.HashMapIter(nil_val,root_iter,seen));
});


/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentHashMap = (function (meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
this.meta = meta;
this.cnt = cnt;
this.root = root;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 139268;
});
(cljs.core.PersistentHashMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentHashMap.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_17214(coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.MapEntry(null,self__.nil_val,null));
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_find((0),cljs.core.hash(k),k,null);

}
}
}));

(cljs.core.PersistentHashMap.prototype.toString = (function cljs$core$fn_17215(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentHashMap.prototype.equiv = (function cljs$core$fn_17216(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentHashMap.prototype.keys = (function cljs$core$fn_17217(){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.keys(coll));
}));

(cljs.core.PersistentHashMap.prototype.entries = (function cljs$core$fn_17218(){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentHashMap.prototype.values = (function cljs$core$fn_17219(){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.vals(coll));
}));

(cljs.core.PersistentHashMap.prototype.has = (function cljs$core$fn_17220(k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
}));

(cljs.core.PersistentHashMap.prototype.get = (function cljs$core$fn_17221(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentHashMap.prototype.forEach = (function cljs$core$fn_17222(f){
var self__ = this;
var coll = this;
var seq__17223 = cljs.core.seq(coll);
var chunk__17224 = null;
var count__17225 = (0);
var i__17226 = (0);
while(true){
if((i__17226 < count__17225)){
var vec__17233 = chunk__17224.cljs$core$IIndexed$_nth$arity$2(null,i__17226);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17233,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17233,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__17265 = seq__17223;
var G__17266 = chunk__17224;
var G__17267 = count__17225;
var G__17268 = (i__17226 + (1));
seq__17223 = G__17265;
chunk__17224 = G__17266;
count__17225 = G__17267;
i__17226 = G__17268;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__17223);
if(temp__5720__auto__){
var seq__17223__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__17223__$1)){
var c__10518__auto__ = cljs.core.chunk_first(seq__17223__$1);
var G__17269 = cljs.core.chunk_rest(seq__17223__$1);
var G__17270 = c__10518__auto__;
var G__17271 = cljs.core.count(c__10518__auto__);
var G__17272 = (0);
seq__17223 = G__17269;
chunk__17224 = G__17270;
count__17225 = G__17271;
i__17226 = G__17272;
continue;
} else {
var vec__17236 = cljs.core.first(seq__17223__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17236,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17236,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__17273 = cljs.core.next(seq__17223__$1);
var G__17274 = null;
var G__17275 = (0);
var G__17276 = (0);
seq__17223 = G__17273;
chunk__17224 = G__17274;
count__17225 = G__17275;
i__17226 = G__17276;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_17239(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_17240(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function cljs$core$fn_17241(coll,f,init){
var self__ = this;
var coll__$1 = this;
var init__$1 = ((self__.has_nil_QMARK_)?(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(init,null,self__.nil_val) : f.call(null,init,null,self__.nil_val)):init);
if(cljs.core.reduced_QMARK_(init__$1)){
return cljs.core.deref(init__$1);
} else {
if((!((self__.root == null)))){
return cljs.core.unreduced(self__.root.kv_reduce(f,init__$1));
} else {
return init__$1;

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_17242(coll){
var self__ = this;
var coll__$1 = this;
var root_iter = ((self__.root)?cljs.core._iterator(self__.root):cljs.core.nil_iter());
if(self__.has_nil_QMARK_){
return (new cljs.core.HashMapIter(self__.nil_val,root_iter,false));
} else {
return root_iter;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17243(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_17244(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashMap(self__.meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17245(coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17246(coll){
var self__ = this;
var coll__$1 = this;
var h__10007__auto__ = self__.__hash;
if((!((h__10007__auto__ == null)))){
return h__10007__auto__;
} else {
var h__10007__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__10007__auto____$1);

return h__10007__auto____$1;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17247(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function cljs$core$fn_17248(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashMap(({}),self__.root,self__.cnt,self__.has_nil_QMARK_,self__.nil_val));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17251(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY,self__.meta);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function cljs$core$fn_17252(coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),self__.root,false,null,null));
} else {
return coll__$1;
}
} else {
if((self__.root == null)){
return coll__$1;
} else {
var new_root = self__.root.inode_without((0),cljs.core.hash(k),k);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_17253(coll,k,v){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(((self__.has_nil_QMARK_) && ((v === self__.nil_val)))){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((self__.has_nil_QMARK_)?self__.cnt:(self__.cnt + (1))),self__.root,true,v,null));
}
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var new_root = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc((0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((added_leaf_QMARK_.val)?(self__.cnt + (1)):self__.cnt),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_17254(coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
return self__.has_nil_QMARK_;
} else {
if((self__.root == null)){
return false;
} else {
return (!((self__.root.inode_lookup((0),cljs.core.hash(k),k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)));

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17255(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var s = (((!((self__.root == null))))?self__.root.inode_seq():null);
if(self__.has_nil_QMARK_){
return cljs.core.cons((new cljs.core.MapEntry(null,self__.nil_val,null)),s);
} else {
return s;
}
} else {
return null;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17256(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(new_meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17257(coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__17277 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__17278 = cljs.core.next(es);
ret = G__17277;
es = G__17278;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
}));

(cljs.core.PersistentHashMap.prototype.call = (function() {
var cljs$core$fn_17258 = null;
var cljs$core$fn_17258__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var cljs$core$fn_17258__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
cljs$core$fn_17258 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_17258__2.call(this,self__,k);
case 3:
return cljs$core$fn_17258__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_17258.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17258__2;
cljs$core$fn_17258.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_17258__3;
return cljs$core$fn_17258;
})()
);

(cljs.core.PersistentHashMap.prototype.apply = (function cljs$core$fn_17259(self__,args17213){
var self__ = this;
var self____$1 = this;
var args__10149__auto__ = cljs.core.aclone(args17213);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10149__auto__.length > (20)))?(function (){var G__17260 = args__10149__auto__.slice((0),(20));
G__17260.push(args__10149__auto__.slice((20)));

return G__17260;
})():args__10149__auto__)));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17261(k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_17262(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentHashMap.getBasis = (function cljs$core$fn_17263(){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"root","root",1191874074,null),cljs.core.with_meta(new cljs.core.Symbol(null,"has-nil?","has-nil?",825886722,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)], null)),new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentHashMap.cljs$lang$type = true);

(cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap");

(cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = (function cljs$core$fn_17264(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/PersistentHashMap");
}));

/**
 * Positional factory function for cljs.core/PersistentHashMap.
 */
cljs.core.__GT_PersistentHashMap = (function cljs$core$__GT_PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
return (new cljs.core.PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash));
});

(cljs.core.PersistentHashMap.EMPTY = (new cljs.core.PersistentHashMap(null,(0),null,false,null,cljs.core.empty_unordered_hash)));
(cljs.core.PersistentHashMap.fromArray = (function cljs$core$fn_17279(arr,no_clone){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__17280 = (i + (2));
var G__17281 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__17280;
ret = G__17281;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
}));
(cljs.core.PersistentHashMap.fromArrays = (function cljs$core$fn_17282(ks,vs){
var len = ks.length;
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
if((vs.length <= i)){
throw (new Error(["No value supplied for key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((ks[i]))].join('')));
} else {
var G__17283 = (i + (1));
var G__17284 = cljs.core._assoc_BANG_(out,(ks[i]),(vs[i]));
i = G__17283;
out = G__17284;
continue;
}
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}));
(cljs.core.PersistentHashMap.createWithCheck = (function cljs$core$fn_17285(arr){
var len = arr.length;
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i_17286 = (0);
while(true){
if((i_17286 < len)){
cljs.core._assoc_BANG_(ret,(arr[i_17286]),(arr[(i_17286 + (1))]));

if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core._count(ret),((i_17286 / (2)) + (1)))){
throw (new Error(["Duplicate key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arr[i_17286]))].join('')));
} else {
var G__17287 = (i_17286 + (2));
i_17286 = G__17287;
continue;
}
} else {
}
break;
}

return cljs.core._persistent_BANG_(ret);
}));
(cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17288(){
var this__10736__auto__ = this;
return cljs.core.es6_iterator(this__10736__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientHashMap = (function (edit,root,count,has_nil_QMARK_,nil_val){
this.edit = edit;
this.root = root;
this.count = count;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 56;
});
(cljs.core.TransientHashMap.prototype.conj_BANG_ = (function cljs$core$fn_17290(o){
var self__ = this;
var tcoll = this;
if(self__.edit){
if(cljs.core.map_entry_QMARK_(o)){
return tcoll.assoc_BANG_(cljs.core.key(o),cljs.core.val(o));
} else {
if(cljs.core.vector_QMARK_(o)){
return tcoll.assoc_BANG_((o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((0)) : o.call(null,(0))),(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((1)) : o.call(null,(1))));
} else {
var es = cljs.core.seq(o);
var tcoll__$1 = tcoll;
while(true){
var temp__5718__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__5718__auto__)){
var e = temp__5718__auto__;
var G__17308 = cljs.core.next(es);
var G__17309 = tcoll__$1.assoc_BANG_(cljs.core.key(e),cljs.core.val(e));
es = G__17308;
tcoll__$1 = G__17309;
continue;
} else {
return tcoll__$1;
}
break;
}

}
}
} else {
throw (new Error("conj! after persistent"));
}
}));

(cljs.core.TransientHashMap.prototype.assoc_BANG_ = (function cljs$core$fn_17291(k,v){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if((self__.nil_val === v)){
} else {
(self__.nil_val = v);
}

if(self__.has_nil_QMARK_){
} else {
(self__.count = (self__.count + (1)));

(self__.has_nil_QMARK_ = true);
}

return tcoll;
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var node = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc_BANG_(self__.edit,(0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((node === self__.root)){
} else {
(self__.root = node);
}

if(added_leaf_QMARK_.val){
(self__.count = (self__.count + (1)));
} else {
}

return tcoll;
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.without_BANG_ = (function cljs$core$fn_17292(k){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if(self__.has_nil_QMARK_){
(self__.has_nil_QMARK_ = false);

(self__.nil_val = null);

(self__.count = (self__.count - (1)));

return tcoll;
} else {
return tcoll;
}
} else {
if((self__.root == null)){
return tcoll;
} else {
var removed_leaf_QMARK_ = (new cljs.core.Box(false));
var node = self__.root.inode_without_BANG_(self__.edit,(0),cljs.core.hash(k),k,removed_leaf_QMARK_);
if((node === self__.root)){
} else {
(self__.root = node);
}

if(removed_leaf_QMARK_.val){
(self__.count = (self__.count - (1)));
} else {
}

return tcoll;
}
}
} else {
throw (new Error("dissoc! after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.persistent_BANG_ = (function cljs$core$fn_17293(){
var self__ = this;
var tcoll = this;
if(self__.edit){
(self__.edit = null);

return (new cljs.core.PersistentHashMap(null,self__.count,self__.root,self__.has_nil_QMARK_,self__.nil_val,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17294(coll){
var self__ = this;
var coll__$1 = this;
if(self__.edit){
return self__.count;
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_17295(tcoll,k){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k);
}
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_17296(tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);
}
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function cljs$core$fn_17297(tcoll,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.conj_BANG_(val);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function cljs$core$fn_17298(tcoll){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.persistent_BANG_();
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function cljs$core$fn_17299(tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.assoc_BANG_(key,val);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function cljs$core$fn_17300(tcoll,key){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.without_BANG_(key);
}));

(cljs.core.TransientHashMap.prototype.call = (function() {
var cljs$core$fn_17301 = null;
var cljs$core$fn_17301__2 = (function (self__,key){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$2(null,key);
});
var cljs$core$fn_17301__3 = (function (self__,key,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
});
cljs$core$fn_17301 = function(self__,key,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_17301__2.call(this,self__,key);
case 3:
return cljs$core$fn_17301__3.call(this,self__,key,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_17301.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17301__2;
cljs$core$fn_17301.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_17301__3;
return cljs$core$fn_17301;
})()
);

(cljs.core.TransientHashMap.prototype.apply = (function cljs$core$fn_17302(self__,args17289){
var self__ = this;
var self____$1 = this;
var args__10149__auto__ = cljs.core.aclone(args17289);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10149__auto__.length > (20)))?(function (){var G__17303 = args__10149__auto__.slice((0),(20));
G__17303.push(args__10149__auto__.slice((20)));

return G__17303;
})():args__10149__auto__)));
}));

(cljs.core.TransientHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17304(key){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$2(null,key);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_17305(key,not_found){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
}));

(cljs.core.TransientHashMap.getBasis = (function cljs$core$fn_17306(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"has-nil?","has-nil?",825886722,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.TransientHashMap.cljs$lang$type = true);

(cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap");

(cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = (function cljs$core$fn_17307(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/TransientHashMap");
}));

/**
 * Positional factory function for cljs.core/TransientHashMap.
 */
cljs.core.__GT_TransientHashMap = (function cljs$core$__GT_TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val){
return (new cljs.core.TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val));
});

cljs.core.tree_map_seq_push = (function cljs$core$tree_map_seq_push(node,stack,ascending_QMARK_){
var t = node;
var stack__$1 = stack;
while(true){
if((!((t == null)))){
var G__17310 = ((ascending_QMARK_)?t.left:t.right);
var G__17311 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1,t);
t = G__17310;
stack__$1 = G__17311;
continue;
} else {
return stack__$1;
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentTreeMapSeq = (function (meta,stack,ascending_QMARK_,cnt,__hash){
this.meta = meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.PersistentTreeMapSeq.prototype.toString = (function cljs$core$fn_17312(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentTreeMapSeq.prototype.equiv = (function cljs$core$fn_17313(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentTreeMapSeq.prototype.indexOf = (function() {
var cljs$core$fn_17314 = null;
var cljs$core$fn_17314__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_17314__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17314 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17314__1.call(this,x);
case 2:
return cljs$core$fn_17314__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17314.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17314__1;
cljs$core$fn_17314.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17314__2;
return cljs$core$fn_17314;
})()
);

(cljs.core.PersistentTreeMapSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_17315 = null;
var cljs$core$fn_17315__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_17315__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17315 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17315__1.call(this,x);
case 2:
return cljs$core$fn_17315__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17315.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17315__1;
cljs$core$fn_17315.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17315__2;
return cljs$core$fn_17315;
})()
);

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17316(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_17317(this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if((next_stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17318(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt < (0))){
return (cljs.core.count(cljs.core.next(coll__$1)) + (1));
} else {
return self__.cnt;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17319(coll){
var self__ = this;
var coll__$1 = this;
var h__10007__auto__ = self__.__hash;
if((!((h__10007__auto__ == null)))){
return h__10007__auto__;
} else {
var h__10007__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10007__auto____$1);

return h__10007__auto____$1;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17320(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17321(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17322(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17323(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_17324(this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.peek(self__.stack);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_17325(this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if((!((next_stack == null)))){
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17326(this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17327(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMapSeq(new_meta,self__.stack,self__.ascending_QMARK_,self__.cnt,self__.__hash));
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17328(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.getBasis = (function cljs$core$fn_17329(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"stack","stack",847125597,null),cljs.core.with_meta(new cljs.core.Symbol(null,"ascending?","ascending?",-1938452653,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)], null)),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentTreeMapSeq.cljs$lang$type = true);

(cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq");

(cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_17330(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/PersistentTreeMapSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentTreeMapSeq.
 */
cljs.core.__GT_PersistentTreeMapSeq = (function cljs$core$__GT_PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash){
return (new cljs.core.PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash));
});

(cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17331(){
var this__10736__auto__ = this;
return cljs.core.es6_iterator(this__10736__auto__);
}));
cljs.core.create_tree_map_seq = (function cljs$core$create_tree_map_seq(tree,ascending_QMARK_,cnt){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.tree_map_seq_push(tree,null,ascending_QMARK_),ascending_QMARK_,cnt,null));
});

cljs.core.balance_left = (function cljs$core$balance_left(key,val,ins,right){
if((ins instanceof cljs.core.RedNode)){
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,ins.left.blacken(),(new cljs.core.BlackNode(key,val,ins.right,right,null)),null));
} else {
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.right.key,ins.right.val,(new cljs.core.BlackNode(ins.key,ins.val,ins.left,ins.right.left,null)),(new cljs.core.BlackNode(key,val,ins.right.right,right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));
}
});
cljs.core.balance_right = (function cljs$core$balance_right(key,val,left,ins){
if((ins instanceof cljs.core.RedNode)){
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,(new cljs.core.BlackNode(key,val,left,ins.left,null)),ins.right.blacken(),null));
} else {
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.left.key,ins.left.val,(new cljs.core.BlackNode(key,val,left,ins.left.left,null)),(new cljs.core.BlackNode(ins.key,ins.val,ins.left.right,ins.right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));
}
});
cljs.core.balance_left_del = (function cljs$core$balance_left_del(key,val,del,right){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,del.blacken(),right,null));
} else {
if((right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right(key,val,del,right.redden());
} else {
if((((right instanceof cljs.core.RedNode)) && ((right.left instanceof cljs.core.BlackNode)))){
return (new cljs.core.RedNode(right.left.key,right.left.val,(new cljs.core.BlackNode(key,val,del,right.left.left,null)),cljs.core.balance_right(right.key,right.val,right.left.right,right.right.redden()),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.balance_right_del = (function cljs$core$balance_right_del(key,val,left,del){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,left,del.blacken(),null));
} else {
if((left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left(key,val,left.redden(),del);
} else {
if((((left instanceof cljs.core.RedNode)) && ((left.right instanceof cljs.core.BlackNode)))){
return (new cljs.core.RedNode(left.right.key,left.right.val,cljs.core.balance_left(left.key,left.val,left.left.redden(),left.right.left),(new cljs.core.BlackNode(key,val,left.right.right,del,null)),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.tree_map_kv_reduce = (function cljs$core$tree_map_kv_reduce(node,f,init){
var init__$1 = (((!((node.left == null))))?(function (){var G__17332 = node.left;
var G__17333 = f;
var G__17334 = init;
return (cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__17332,G__17333,G__17334) : cljs.core.tree_map_kv_reduce.call(null,G__17332,G__17333,G__17334));
})():init);
if(cljs.core.reduced_QMARK_(init__$1)){
return init__$1;
} else {
var init__$2 = (function (){var G__17335 = init__$1;
var G__17336 = node.key;
var G__17337 = node.val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17335,G__17336,G__17337) : f.call(null,G__17335,G__17336,G__17337));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
if((!((node.right == null)))){
var G__17338 = node.right;
var G__17339 = f;
var G__17340 = init__$2;
return (cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__17338,G__17339,G__17340) : cljs.core.tree_map_kv_reduce.call(null,G__17338,G__17339,G__17340));
} else {
return init__$2;
}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.BlackNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.BlackNode.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.BlackNode.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_17342(node,k){
var self__ = this;
var node__$1 = this;
var G__17343 = k;
switch (G__17343) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.BlackNode.prototype.lastIndexOf = (function() {
var cljs$core$fn_17344 = null;
var cljs$core$fn_17344__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_17344__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17344 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17344__1.call(this,x);
case 2:
return cljs$core$fn_17344__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17344.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17344__1;
cljs$core$fn_17344.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17344__2;
return cljs$core$fn_17344;
})()
);

(cljs.core.BlackNode.prototype.indexOf = (function() {
var cljs$core$fn_17345 = null;
var cljs$core$fn_17345__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_17345__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17345 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17345__1.call(this,x);
case 2:
return cljs$core$fn_17345__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17345.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17345__1;
cljs$core$fn_17345.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17345__2;
return cljs$core$fn_17345;
})()
);

(cljs.core.BlackNode.prototype.add_right = (function cljs$core$fn_17346(ins){
var self__ = this;
var node = this;
return ins.balance_right(node);
}));

(cljs.core.BlackNode.prototype.redden = (function cljs$core$fn_17347(){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,self__.right,null));
}));

(cljs.core.BlackNode.prototype.blacken = (function cljs$core$fn_17348(){
var self__ = this;
var node = this;
return node;
}));

(cljs.core.BlackNode.prototype.add_left = (function cljs$core$fn_17349(ins){
var self__ = this;
var node = this;
return ins.balance_left(node);
}));

(cljs.core.BlackNode.prototype.replace = (function cljs$core$fn_17350(key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(key__$1,val__$1,left__$1,right__$1,null));
}));

(cljs.core.BlackNode.prototype.balance_left = (function cljs$core$fn_17351(parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));
}));

(cljs.core.BlackNode.prototype.balance_right = (function cljs$core$fn_17352(parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));
}));

(cljs.core.BlackNode.prototype.remove_left = (function cljs$core$fn_17353(del){
var self__ = this;
var node = this;
return cljs.core.balance_left_del(self__.key,self__.val,del,self__.right);
}));

(cljs.core.BlackNode.prototype.kv_reduce = (function cljs$core$fn_17354(f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
}));

(cljs.core.BlackNode.prototype.remove_right = (function cljs$core$fn_17355(del){
var self__ = this;
var node = this;
return cljs.core.balance_right_del(self__.key,self__.val,self__.left,del);
}));

(cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_17356(node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
}));

(cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_17357(node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_17358(node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_17359(node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function cljs$core$fn_17360(node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
}));

(cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17361(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17362(node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function cljs$core$fn_17363(node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function cljs$core$fn_17364(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_17365(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_17366(node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.BlackNode.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_17367(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17368(coll){
var self__ = this;
var coll__$1 = this;
var h__10007__auto__ = self__.__hash;
if((!((h__10007__auto__ == null)))){
return h__10007__auto__;
} else {
var h__10007__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10007__auto____$1);

return h__10007__auto____$1;
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17369(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17370(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17371(node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
}));

(cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17372(node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
}));

(cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_17373(node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.BlackNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_17374(node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17375(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17376(node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core._with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17377(node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.BlackNode.prototype.call = (function() {
var cljs$core$fn_17378 = null;
var cljs$core$fn_17378__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var cljs$core$fn_17378__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
cljs$core$fn_17378 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_17378__2.call(this,self__,k);
case 3:
return cljs$core$fn_17378__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_17378.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17378__2;
cljs$core$fn_17378.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_17378__3;
return cljs$core$fn_17378;
})()
);

(cljs.core.BlackNode.prototype.apply = (function cljs$core$fn_17379(self__,args17341){
var self__ = this;
var self____$1 = this;
var args__10149__auto__ = cljs.core.aclone(args17341);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10149__auto__.length > (20)))?(function (){var G__17380 = args__10149__auto__.slice((0),(20));
G__17380.push(args__10149__auto__.slice((20)));

return G__17380;
})():args__10149__auto__)));
}));

(cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17381(k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_17382(k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.BlackNode.getBasis = (function cljs$core$fn_17383(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"left","left",1241415590,null),new cljs.core.Symbol(null,"right","right",1187949694,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.BlackNode.cljs$lang$type = true);

(cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode");

(cljs.core.BlackNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_17384(this__10223__auto__,writer__10224__auto__,opt__10225__auto__){
return cljs.core._write(writer__10224__auto__,"cljs.core/BlackNode");
}));

/**
 * Positional factory function for cljs.core/BlackNode.
 */
cljs.core.__GT_BlackNode = (function cljs$core$__GT_BlackNode(key,val,left,right,__hash){
return (new cljs.core.BlackNode(key,val,left,right,__hash));
});

(cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17386(){
var this__10736__auto__ = this;
return cljs.core.es6_iterator(this__10736__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RedNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.RedNode.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.RedNode.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_17388(node,k){
var self__ = this;
var node__$1 = this;
var G__17389 = k;
switch (G__17389) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.RedNode.prototype.lastIndexOf = (function() {
var cljs$core$fn_17390 = null;
var cljs$core$fn_17390__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_17390__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17390 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17390__1.call(this,x);
case 2:
return cljs$core$fn_17390__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17390.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17390__1;
cljs$core$fn_17390.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17390__2;
return cljs$core$fn_17390;
})()
);

(cljs.core.RedNode.prototype.indexOf = (function() {
var cljs$core$fn_17391 = null;
var cljs$core$fn_17391__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_17391__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17391 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17391__1.call(this,x);
case 2:
return cljs$core$fn_17391__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17391.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17391__1;
cljs$core$fn_17391.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17391__2;
return cljs$core$fn_17391;
})()
);

(cljs.core.RedNode.prototype.add_right = (function cljs$core$fn_17392(ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,ins,null));
}));

(cljs.core.RedNode.prototype.redden = (function cljs$core$fn_17393(){
var self__ = this;
var node = this;
throw (new Error("red-black tree invariant violation"));
}));

(cljs.core.RedNode.prototype.blacken = (function cljs$core$fn_17394(){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right,null));
}));

(cljs.core.RedNode.prototype.add_left = (function cljs$core$fn_17395(ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,ins,self__.right,null));
}));

(cljs.core.RedNode.prototype.replace = (function cljs$core$fn_17396(key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(key__$1,val__$1,left__$1,right__$1,null));
}));

(cljs.core.RedNode.prototype.balance_left = (function cljs$core$fn_17397(parent){
var self__ = this;
var node = this;
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,self__.left.blacken(),(new cljs.core.BlackNode(parent.key,parent.val,self__.right,parent.right,null)),null));
} else {
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.right.key,self__.right.val,(new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right.left,null)),(new cljs.core.BlackNode(parent.key,parent.val,self__.right.right,parent.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));

}
}
}));

(cljs.core.RedNode.prototype.balance_right = (function cljs$core$fn_17398(parent){
var self__ = this;
var node = this;
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left,null)),self__.right.blacken(),null));
} else {
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.left.key,self__.left.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left.left,null)),(new cljs.core.BlackNode(self__.key,self__.val,self__.left.right,self__.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));

}
}
}));

(cljs.core.RedNode.prototype.remove_left = (function cljs$core$fn_17399(del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,del,self__.right,null));
}));

(cljs.core.RedNode.prototype.kv_reduce = (function cljs$core$fn_17400(f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
}));

(cljs.core.RedNode.prototype.remove_right = (function cljs$core$fn_17401(del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,del,null));
}));

(cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_17402(node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
}));

(cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_17403(node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_17404(node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_17405(node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function cljs$core$fn_17406(node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
}));

(cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17407(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17408(node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function cljs$core$fn_17409(node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function cljs$core$fn_17410(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_17411(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_17412(node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.RedNode.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_17413(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17414(coll){
var self__ = this;
var coll__$1 = this;
var h__10007__auto__ = self__.__hash;
if((!((h__10007__auto__ == null)))){
return h__10007__auto__;
} else {
var h__10007__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__10007__auto____$1);

return h__10007__auto____$1;
}
}));

(cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17415(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17416(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17417(node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
}));

(cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17418(node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
}));

(cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_17419(node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.RedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_17420(node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17421(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17422(node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core._with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17423(node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.RedNode.prototype.call = (function() {
var cljs$core$fn_17424 = null;
var cljs$core$fn_17424__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var cljs$core$fn_17424__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
cljs$core$fn_17424 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_17424__2.call(this,self__,k);
case 3:
return cljs$core$fn_17424__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_17424.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17424__2;
cljs$core$fn_17424.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_17424__3;
return cljs$core$fn_17424;
})()
);

(cljs.core.RedNode.prototype.apply = (function cljs$core$fn_17425(self__,args17387){
var self__ = this;
var self____$1 = this;
var args__10149__auto__ = cljs.core.aclone(args17387);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10149__auto__.length > (20)))?(function (){var G__17426 = args__10149__auto__.slice((0),(20));
G__17426.push(args__10149__auto__.slice((20)));

return G__17426;
})():args__10149__auto__)));
}));

(cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17427(k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_17428(k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.RedNode.getBasis = (function cljs$core$fn_17429(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbo