// Compiled by ClojureScript 1.11.132 {:static-fns true, :optimizations :none}
goog.provide('cljs.core');
goog.require('goog.math.Integer');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.string.StringBuffer');
goog.require('goog.math.Long');
goog.scope(function(){
cljs.core.goog$module$goog$math$Long = goog.module.get('goog.math.Long');
});
goog.require('goog.object');
goog.scope(function(){
cljs.core.goog$module$goog$object = goog.module.get('goog.object');
});
goog.require('goog.array');
goog.scope(function(){
cljs.core.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core._STAR_clojurescript_version_STAR_ = "1.11.132";
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_unchecked_arrays_STAR_ = false;
cljs.core._STAR_warn_on_infer_STAR_ = false;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.PROTOCOL_SENTINEL !== 'undefined')){
} else {
cljs.core.PROTOCOL_SENTINEL = ({});
}
cljs.core.MODULE_URIS = null;
cljs.core.MODULE_INFOS = null;

/**
 * Var bound to the name value of the compiler build :target option.
 *   For example, if the compiler build :target is :nodejs, *target* will be bound
 *   to "nodejs". *target* is a Google Closure define and can be set by compiler
 *   :closure-defines option.
 * @define {string}
 */
cljs.core._STAR_target_STAR_ = goog.define("cljs.core._STAR_target_STAR_","default");

/**
 * Manually set the JavaScript global context. Only "window", "self"
 *   , and "global" supported. 
 * @define {string}
 */
cljs.core._STAR_global_STAR_ = goog.define("cljs.core._STAR_global_STAR_","default");
/**
 * Var bound to the current namespace. Only used for bootstrapping.
 * @type {*}
 */
cljs.core._STAR_ns_STAR_ = null;
/**
 * @type {*}
 */
cljs.core._STAR_out_STAR_ = null;
cljs.core._STAR_assert_STAR_ = true;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_print_fn_STAR_ !== 'undefined')){
} else {
/**
 * Each runtime environment provides a different way to print output.
 *   Whatever function *print-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_fn_STAR_ = null;
}
/**
 * Arranges to have tap functions executed via the supplied f, a
 *   function of no arguments. Returns true if successful, false otherwise.
 */
cljs.core._STAR_exec_tap_fn_STAR_ = (function cljs$core$_STAR_exec_tap_fn_STAR_(f){
return (((typeof setTimeout !== 'undefined')) && (cljs.core.boolean$(setTimeout(f,(0)))));
});
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_print_err_fn_STAR_ !== 'undefined')){
} else {
/**
 * Each runtime environment provides a different way to print error output.
 *   Whatever function *print-err-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_err_fn_STAR_ = null;
}
/**
 * Set *print-fn* to f.
 */
cljs.core.set_print_fn_BANG_ = (function cljs$core$set_print_fn_BANG_(f){
return (cljs.core._STAR_print_fn_STAR_ = f);
});
/**
 * Set *print-err-fn* to f.
 */
cljs.core.set_print_err_fn_BANG_ = (function cljs$core$set_print_err_fn_BANG_(f){
return (cljs.core._STAR_print_err_fn_STAR_ = f);
});
/**
 * When set to true, output will be flushed whenever a newline is printed.
 * 
 *   Defaults to true.
 */
cljs.core._STAR_flush_on_newline_STAR_ = true;
/**
 * When set to logical false will drop newlines from printing calls.
 *   This is to work around the implicit newlines emitted by standard JavaScript
 *   console objects.
 */
cljs.core._STAR_print_newline_STAR_ = true;
/**
 * When set to logical false, strings and characters will be printed with
 *   non-alphanumeric characters converted to the appropriate escape sequences.
 * 
 *   Defaults to true
 */
cljs.core._STAR_print_readably_STAR_ = true;
/**
 * If set to logical true, when printing an object, its metadata will also
 *   be printed in a form that can be read back by the reader.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_meta_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 *   their type when read in later.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_dup_STAR_ = false;
/**
 * *print-namespace-maps* controls whether the printer will print
 *   namespace map literal syntax.
 * 
 *   Defaults to false, but the REPL binds it to true.
 */
cljs.core._STAR_print_namespace_maps_STAR_ = false;
/**
 * *print-length* controls how many items of each collection the
 *   printer will print. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   number of items of each collection to print. If a collection contains
 *   more items, the printer will print items up to the limit followed by
 *   '...' to represent the remaining items. The root binding is nil
 *   indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_length_STAR_ = null;
/**
 * *print-level* controls how many levels deep the printer will
 *   print nested objects. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   level to print. Each argument to print is at level 0; if an argument is a
 *   collection, its items are at level 1; and so on. If an object is a
 *   collection and is at a level greater than or equal to the value bound to
 *   *print-level*, the printer prints '#' to represent it. The root binding
 *   is nil indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_level_STAR_ = null;
/**
 * *print-fns-bodies* controls whether functions print their source or
 *  only their names.
 */
cljs.core._STAR_print_fn_bodies_STAR_ = false;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_loaded_libs_STAR_ !== 'undefined')){
} else {
/**
 * @type {*}
 */
cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = (function cljs$core$pr_opts(){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939),cljs.core._STAR_flush_on_newline_STAR_,new cljs.core.Keyword(null,"readably","readably",1129599760),cljs.core._STAR_print_readably_STAR_,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core._STAR_print_meta_STAR_,new cljs.core.Keyword(null,"dup","dup",556298533),cljs.core._STAR_print_dup_STAR_,new cljs.core.Keyword(null,"print-length","print-length",1931866356),cljs.core._STAR_print_length_STAR_], null);
});
/**
 * Set *print-fn* to console.log
 */
cljs.core.enable_console_print_BANG_ = (function cljs$core$enable_console_print_BANG_(){
(cljs.core._STAR_print_newline_STAR_ = false);

cljs.core.set_print_fn_BANG_((function cljs$core$enable_console_print_BANG__$_fn_14092(){
var xs = arguments;
return console.log.apply(console,cljs.core.goog$module$goog$array.clone.call(null,xs));
}));

cljs.core.set_print_err_fn_BANG_((function cljs$core$enable_console_print_BANG__$_fn_14093(){
var xs = arguments;
return console.error.apply(console,cljs.core.goog$module$goog$array.clone.call(null,xs));
}));

return null;
});
/**
 * Internal - do not use!
 */
cljs.core.truth_ = (function cljs$core$truth_(x){
return (x != null && x !== false);
});
cljs.core.not_native = null;

/**
 * Tests if 2 arguments are the same object
 */
cljs.core.identical_QMARK_ = (function cljs$core$identical_QMARK_(x,y){
return (x === y);
});
/**
 * Returns true if x is nil, false otherwise.
 */
cljs.core.nil_QMARK_ = (function cljs$core$nil_QMARK_(x){
return (x == null);
});
/**
 * Returns true if x is a JavaScript array.
 */
cljs.core.array_QMARK_ = (function cljs$core$array_QMARK_(x){
if((cljs.core._STAR_target_STAR_ === "nodejs")){
return Array.isArray(x);
} else {
return (x instanceof Array);
}
});
/**
 * Returns true if x is a JavaScript number.
 */
cljs.core.number_QMARK_ = (function cljs$core$number_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true if x is logical false, false otherwise.
 */
cljs.core.not = (function cljs$core$not(x){
if((x == null)){
return true;
} else {
if(x === false){
return true;
} else {
return false;

}
}
});
/**
 * Returns true if x is not nil, false otherwise.
 */
cljs.core.some_QMARK_ = (function cljs$core$some_QMARK_(x){
return (!((x == null)));
});
/**
 * Returns true if x's constructor is Object
 */
cljs.core.object_QMARK_ = (function cljs$core$object_QMARK_(x){
if((!((x == null)))){
return (x.constructor === Object);
} else {
return false;
}
});
/**
 * Returns true if x is a JavaScript string.
 */
cljs.core.string_QMARK_ = (function cljs$core$string_QMARK_(x){
return ("string" === goog.typeOf(x));
});
/**
 * Returns true if x is a JavaScript string of length one.
 */
cljs.core.char_QMARK_ = (function cljs$core$char_QMARK_(x){
return ((typeof x === 'string') && (((1) === x.length)));
});
/**
 * Returns true if given any argument.
 */
cljs.core.any_QMARK_ = (function cljs$core$any_QMARK_(x){
return true;
});
/**
 * Internal - do not use!
 */
cljs.core.native_satisfies_QMARK_ = (function cljs$core$native_satisfies_QMARK_(p,x){
var x__$1 = (((x == null))?null:x);
if((p[goog.typeOf(x__$1)])){
return true;
} else {
if((p["_"])){
return true;
} else {
return false;

}
}
});
cljs.core.is_proto_ = (function cljs$core$is_proto_(x){
return (x.constructor.prototype === x);
});
/**
 * When compiled for a command-line target, whatever function
 *   *main-cli-fn* is set to will be called with the command-line
 *   argv as arguments
 */
cljs.core._STAR_main_cli_fn_STAR_ = null;
/**
 * A sequence of the supplied command line arguments, or nil if
 *   none were supplied
 */
cljs.core._STAR_command_line_args_STAR_ = null;
/**
 * Return x's constructor.
 */
cljs.core.type = (function cljs$core$type(x){
if((x == null)){
return null;
} else {
return x.constructor;
}
});
cljs.core.missing_protocol = (function cljs$core$missing_protocol(proto,obj){
var ty = cljs.core.type(obj);
var ty__$1 = (cljs.core.truth_((function (){var and__9521__auto__ = ty;
if(cljs.core.truth_(and__9521__auto__)){
return ty.cljs$lang$type;
} else {
return and__9521__auto__;
}
})())?ty.cljs$lang$ctorStr:goog.typeOf(obj));
return (new Error(["No protocol method ",proto," defined for type ",ty__$1,": ",obj].join("")));
});
cljs.core.type__GT_str = (function cljs$core$type__GT_str(ty){
var temp__5718__auto__ = ty.cljs$lang$ctorStr;
if(cljs.core.truth_(temp__5718__auto__)){
var s = temp__5718__auto__;
return s;
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(ty);
}
});
cljs.core.load_file = (function cljs$core$load_file(file){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
return goog.nodeGlobalRequire(file);
}
});
if((((typeof Symbol !== 'undefined')) && ((goog.typeOf(Symbol) === "function")))){
cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
cljs.core.ITER_SYMBOL = "@@iterator";
}
/**
 * @enum {string}
 */
cljs.core.CHAR_MAP = ({"]": "_RBRACK_", "'": "_SINGLEQUOTE_", "=": "_EQ_", "\"": "_DOUBLEQUOTE_", "!": "_BANG_", "*": "_STAR_", "%": "_PERCENT_", "|": "_BAR_", "~": "_TILDE_", "/": "_SLASH_", "\\": "_BSLASH_", "-": "_", "?": "_QMARK_", "&": "_AMPERSAND_", ":": "_COLON_", "<": "_LT_", "{": "_LBRACE_", "}": "_RBRACE_", "[": "_LBRACK_", "#": "_SHARP_", "^": "_CARET_", "+": "_PLUS_", "@": "_CIRCA_", ">": "_GT_"});
/**
 * @enum {string}
 */
cljs.core.DEMUNGE_MAP = ({"_RBRACE_": "}", "_COLON_": ":", "_BANG_": "!", "_QMARK_": "?", "_BSLASH_": "\\\\", "_SLASH_": "/", "_PERCENT_": "%", "_PLUS_": "+", "_SHARP_": "#", "_LBRACE_": "{", "_BAR_": "|", "_LBRACK_": "[", "_EQ_": "=", "_": "-", "_TILDE_": "~", "_RBRACK_": "]", "_GT_": ">", "_SINGLEQUOTE_": "'", "_CIRCA_": "@", "_AMPERSAND_": "&", "_DOUBLEQUOTE_": "\\\"", "_CARET_": "^", "_LT_": "<", "_STAR_": "*"});
cljs.core.DEMUNGE_PATTERN = null;
/**
 * Returns highest resolution time offered by host in milliseconds.
 */
cljs.core.system_time = (function cljs$core$system_time(){
if((((typeof performance !== 'undefined')) && ((!((performance.now == null)))))){
return performance.now();
} else {
if((((typeof process !== 'undefined')) && ((!((process.hrtime == null)))))){
var t = process.hrtime();
return ((((t[(0)]) * 1.0E9) + (t[(1)])) / 1000000.0);
} else {
return (new Date()).getTime();

}
}
});
/**
 * Construct a JavaScript array of the specified dimensions. Accepts ignored
 *   type argument for compatibility with Clojure. Note that there is no efficient
 *   way to allocate multi-dimensional arrays in JavaScript; as such, this function
 *   will run in polynomial time when called with 3 or more arguments.
 */
cljs.core.make_array = (function cljs$core$make_array(var_args){
var G__14098 = arguments.length;
switch (G__14098) {
case 1:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___14104 = arguments.length;
var i__10857__auto___14105 = (0);
while(true){
if((i__10857__auto___14105 < len__10856__auto___14104)){
args_arr__10885__auto__.push((arguments[i__10857__auto___14105]));

var G__14106 = (i__10857__auto___14105 + (1));
i__10857__auto___14105 = G__14106;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14099(size){
return (new Array(size));
}));

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14100(type,size){
return (new Array(size));
}));

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14101(type,size,more_sizes){
var dims = more_sizes;
var dimarray = (new Array(size));
var n__10615__auto___14107 = dimarray.length;
var i_14108 = (0);
while(true){
if((i_14108 < n__10615__auto___14107)){
(dimarray[i_14108] = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.make_array,null,dims));

var G__14109 = (i_14108 + (1));
i_14108 = G__14109;
continue;
} else {
}
break;
}

return dimarray;
}));

/** @this {Function} */
(cljs.core.make_array.cljs$lang$applyTo = (function cljs$core$fn_14102(seq14095){
var G__14096 = cljs.core.first(seq14095);
var seq14095__$1 = cljs.core.next(seq14095);
var G__14097 = cljs.core.first(seq14095__$1);
var seq14095__$2 = cljs.core.next(seq14095__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14096,G__14097,seq14095__$2);
}));

(cljs.core.make_array.cljs$lang$maxFixedArity = (2));

/**
 * Returns a javascript array, cloned from the passed in array
 */
cljs.core.aclone = (function cljs$core$aclone(arr){
var len = arr.length;
var new_arr = (new Array(len));
var n__10615__auto___14110 = len;
var i_14111 = (0);
while(true){
if((i_14111 < n__10615__auto___14110)){
(new_arr[i_14111] = (arr[i_14111]));

var G__14112 = (i_14111 + (1));
i_14111 = G__14112;
continue;
} else {
}
break;
}

return new_arr;
});
/**
 * Creates a new javascript array.
 * @param {...*} var_args
 */
cljs.core.array = (function cljs$core$array(var_args){
var a = (new Array(arguments.length));
var i = (0);
while(true){
if((i < a.length)){
(a[i] = (arguments[i]));

var G__14113 = (i + (1));
i = G__14113;
continue;
} else {
return a;
}
break;
}
});
cljs.core.maybe_warn = (function cljs$core$maybe_warn(e){
if(cljs.core.truth_(cljs.core._STAR_print_err_fn_STAR_)){
return (cljs.core._STAR_print_err_fn_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.core._STAR_print_err_fn_STAR_.cljs$core$IFn$_invoke$arity$1(e) : cljs.core._STAR_print_err_fn_STAR_.call(null,e));
} else {
return null;
}
});
cljs.core.checked_aget = (function cljs$core$checked_aget(var_args){
var G__14118 = arguments.length;
switch (G__14118) {
case 2:
return cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___14124 = arguments.length;
var i__10857__auto___14125 = (0);
while(true){
if((i__10857__auto___14125 < len__10856__auto___14124)){
args_arr__10885__auto__.push((arguments[i__10857__auto___14125]));

var G__14126 = (i__10857__auto___14125 + (1));
i__10857__auto___14125 = G__14126;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14119(array,idx){
try{if(cljs.core.truth_((function (){var or__9527__auto__ = cljs.core.array_QMARK_(array);
if(or__9527__auto__){
return or__9527__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}
}catch (e14120){var e_14127 = e14120;
cljs.core.maybe_warn(e_14127);
}
return (array[idx]);
}));

(cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14121(array,idx,idxs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.checked_aget,cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2(array,idx),idxs);
}));

/** @this {Function} */
(cljs.core.checked_aget.cljs$lang$applyTo = (function cljs$core$fn_14122(seq14115){
var G__14116 = cljs.core.first(seq14115);
var seq14115__$1 = cljs.core.next(seq14115);
var G__14117 = cljs.core.first(seq14115__$1);
var seq14115__$2 = cljs.core.next(seq14115__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14116,G__14117,seq14115__$2);
}));

(cljs.core.checked_aget.cljs$lang$maxFixedArity = (2));

cljs.core.checked_aset = (function cljs$core$checked_aset(var_args){
var G__14133 = arguments.length;
switch (G__14133) {
case 3:
return cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___14139 = arguments.length;
var i__10857__auto___14140 = (0);
while(true){
if((i__10857__auto___14140 < len__10856__auto___14139)){
args_arr__10885__auto__.push((arguments[i__10857__auto___14140]));

var G__14141 = (i__10857__auto___14140 + (1));
i__10857__auto___14140 = G__14141;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((3) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((3)),(0),null)):null);
return cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10886__auto__);

}
});

(cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14134(array,idx,val){
try{if(cljs.core.truth_((function (){var or__9527__auto__ = cljs.core.array_QMARK_(array);
if(or__9527__auto__){
return or__9527__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}
}catch (e14135){var e_14142 = e14135;
cljs.core.maybe_warn(e_14142);
}
return (array[idx] = val);
}));

(cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14136(array,idx,idx2,idxv){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.checked_aset,cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2(array,idx),idx2,idxv);
}));

/** @this {Function} */
(cljs.core.checked_aset.cljs$lang$applyTo = (function cljs$core$fn_14137(seq14129){
var G__14130 = cljs.core.first(seq14129);
var seq14129__$1 = cljs.core.next(seq14129);
var G__14131 = cljs.core.first(seq14129__$1);
var seq14129__$2 = cljs.core.next(seq14129__$1);
var G__14132 = cljs.core.first(seq14129__$2);
var seq14129__$3 = cljs.core.next(seq14129__$2);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14130,G__14131,G__14132,seq14129__$3);
}));

(cljs.core.checked_aset.cljs$lang$maxFixedArity = (3));

cljs.core.checked_aget_SINGLEQUOTE_ = (function cljs$core$checked_aget_SINGLEQUOTE_(var_args){
var G__14147 = arguments.length;
switch (G__14147) {
case 2:
return cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___14152 = arguments.length;
var i__10857__auto___14153 = (0);
while(true){
if((i__10857__auto___14153 < len__10856__auto___14152)){
args_arr__10885__auto__.push((arguments[i__10857__auto___14153]));

var G__14154 = (i__10857__auto___14153 + (1));
i__10857__auto___14153 = G__14154;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14148(array,idx){
if(cljs.core.truth_((function (){var or__9527__auto__ = cljs.core.array_QMARK_(array);
if(or__9527__auto__){
return or__9527__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}

return (array[idx]);
}));

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14149(array,idx,idxs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.checked_aget_SINGLEQUOTE_,cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(array,idx),idxs);
}));

/** @this {Function} */
(cljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$applyTo = (function cljs$core$fn_14150(seq14144){
var G__14145 = cljs.core.first(seq14144);
var seq14144__$1 = cljs.core.next(seq14144);
var G__14146 = cljs.core.first(seq14144__$1);
var seq14144__$2 = cljs.core.next(seq14144__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14145,G__14146,seq14144__$2);
}));

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$maxFixedArity = (2));

cljs.core.checked_aset_SINGLEQUOTE_ = (function cljs$core$checked_aset_SINGLEQUOTE_(var_args){
var G__14160 = arguments.length;
switch (G__14160) {
case 3:
return cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___14165 = arguments.length;
var i__10857__auto___14166 = (0);
while(true){
if((i__10857__auto___14166 < len__10856__auto___14165)){
args_arr__10885__auto__.push((arguments[i__10857__auto___14166]));

var G__14167 = (i__10857__auto___14166 + (1));
i__10857__auto___14166 = G__14167;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((3) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((3)),(0),null)):null);
return cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10886__auto__);

}
});

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14161(array,idx,val){
if(cljs.core.truth_((function (){var or__9527__auto__ = cljs.core.array_QMARK_(array);
if(or__9527__auto__){
return or__9527__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}

return (array[idx] = val);
}));

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14162(array,idx,idx2,idxv){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.checked_aset_SINGLEQUOTE_,cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(array,idx),idx2,idxv);
}));

/** @this {Function} */
(cljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$applyTo = (function cljs$core$fn_14163(seq14156){
var G__14157 = cljs.core.first(seq14156);
var seq14156__$1 = cljs.core.next(seq14156);
var G__14158 = cljs.core.first(seq14156__$1);
var seq14156__$2 = cljs.core.next(seq14156__$1);
var G__14159 = cljs.core.first(seq14156__$2);
var seq14156__$3 = cljs.core.next(seq14156__$2);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14157,G__14158,G__14159,seq14156__$3);
}));

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$maxFixedArity = (3));

/**
 * Returns the value at the index/indices. Works on JavaScript arrays.
 */
cljs.core.aget = (function cljs$core$aget(var_args){
var G__14172 = arguments.length;
switch (G__14172) {
case 2:
return cljs.core.aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___14177 = arguments.length;
var i__10857__auto___14178 = (0);
while(true){
if((i__10857__auto___14178 < len__10856__auto___14177)){
args_arr__10885__auto__.push((arguments[i__10857__auto___14178]));

var G__14179 = (i__10857__auto___14178 + (1));
i__10857__auto___14178 = G__14179;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14173(array,idx){
return (array[idx]);
}));

(cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14174(array,idx,idxs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.aget,(array[idx]),idxs);
}));

/** @this {Function} */
(cljs.core.aget.cljs$lang$applyTo = (function cljs$core$fn_14175(seq14169){
var G__14170 = cljs.core.first(seq14169);
var seq14169__$1 = cljs.core.next(seq14169);
var G__14171 = cljs.core.first(seq14169__$1);
var seq14169__$2 = cljs.core.next(seq14169__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14170,G__14171,seq14169__$2);
}));

(cljs.core.aget.cljs$lang$maxFixedArity = (2));

/**
 * Sets the value at the index/indices. Works on JavaScript arrays.
 *   Returns val.
 */
cljs.core.aset = (function cljs$core$aset(var_args){
var G__14185 = arguments.length;
switch (G__14185) {
case 3:
return cljs.core.aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___14190 = arguments.length;
var i__10857__auto___14191 = (0);
while(true){
if((i__10857__auto___14191 < len__10856__auto___14190)){
args_arr__10885__auto__.push((arguments[i__10857__auto___14191]));

var G__14192 = (i__10857__auto___14191 + (1));
i__10857__auto___14191 = G__14192;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((3) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((3)),(0),null)):null);
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10886__auto__);

}
});

(cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14186(array,idx,val){
return (array[idx] = val);
}));

(cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14187(array,idx,idx2,idxv){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.aset,(array[idx]),idx2,idxv);
}));

/** @this {Function} */
(cljs.core.aset.cljs$lang$applyTo = (function cljs$core$fn_14188(seq14181){
var G__14182 = cljs.core.first(seq14181);
var seq14181__$1 = cljs.core.next(seq14181);
var G__14183 = cljs.core.first(seq14181__$1);
var seq14181__$2 = cljs.core.next(seq14181__$1);
var G__14184 = cljs.core.first(seq14181__$2);
var seq14181__$3 = cljs.core.next(seq14181__$2);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14182,G__14183,G__14184,seq14181__$3);
}));

(cljs.core.aset.cljs$lang$maxFixedArity = (3));

/**
 * Returns the length of the array. Works on arrays of all types.
 */
cljs.core.alength = (function cljs$core$alength(array){
return array.length;
});
/**
 * Returns an array with components set to the values in aseq. Optional type
 *   argument accepted for compatibility with Clojure.
 */
cljs.core.into_array = (function cljs$core$into_array(var_args){
var G__14194 = arguments.length;
switch (G__14194) {
case 1:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14195(aseq){
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null,aseq);
}));

(cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14196(type,aseq){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function cljs$core$fn_14196_$_fn_14197(a,x){
a.push(x);

return a;
}),[],aseq);
}));

(cljs.core.into_array.cljs$lang$maxFixedArity = 2);

/**
 * Invoke JavaScript object method via string. Needed when the
 *   string is not a valid unquoted property name.
 */
cljs.core.js_invoke = (function cljs$core$js_invoke(var_args){
var args__10866__auto__ = [];
var len__10856__auto___14204 = arguments.length;
var i__10857__auto___14205 = (0);
while(true){
if((i__10857__auto___14205 < len__10856__auto___14204)){
args__10866__auto__.push((arguments[i__10857__auto___14205]));

var G__14206 = (i__10857__auto___14205 + (1));
i__10857__auto___14205 = G__14206;
continue;
} else {
}
break;
}

var argseq__10867__auto__ = ((((2) < args__10866__auto__.length))?(new cljs.core.IndexedSeq(args__10866__auto__.slice((2)),(0),null)):null);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10867__auto__);
});

(cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14202(obj,s,args){
return (obj[s]).apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
}));

(cljs.core.js_invoke.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(cljs.core.js_invoke.cljs$lang$applyTo = (function cljs$core$fn_14203(seq14199){
var G__14200 = cljs.core.first(seq14199);
var seq14199__$1 = cljs.core.next(seq14199);
var G__14201 = cljs.core.first(seq14199__$1);
var seq14199__$2 = cljs.core.next(seq14199__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14200,G__14201,seq14199__$2);
}));

/**
 * Returns true if x is an instance of Symbol
 */
cljs.core.js_symbol_QMARK_ = (function cljs$core$js_symbol_QMARK_(x){
return (((goog.typeOf(x) === "symbol")) || ((((typeof Symbol !== 'undefined')) && ((x instanceof Symbol)))));
});

/**
 * Marker protocol
 * @interface
 */
cljs.core.Fn = function(){};


/**
 * Protocol for adding the ability to invoke an object as a function.
 *   For example, a vector can also be used to look up a value:
 *   ([1 2 3 4] 1) => 2
 * @interface
 */
cljs.core.IFn = function(){};

var cljs$core$IFn$_invoke$dyn_14232 = (function() {
var cljs$core$fn_14207 = null;
var cljs$core$fn_14207__1 = (function (this$){
var x__10276__auto__ = (((this$ == null))?null:this$);
var m__10277__auto__ = (cljs.core._invoke[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__10277__auto__.call(null,this$));
} else {
var m__10275__auto__ = (cljs.core._invoke["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__10275__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14207__2 = (function (this$,a){
var x__10276__auto__ = (((this$ == null))?null:this$);
var m__10277__auto__ = (cljs.core._invoke[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__10277__auto__.call(null,this$,a));
} else {
var m__10275__auto__ = (cljs.core._invoke["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__10275__auto__.call(null,this$,a));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14207__3 = (function (this$,a,b){
var x__10276__auto__ = (((this$ == null))?null:this$);
var m__10277__auto__ = (cljs.core._invoke[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__10277__auto__.call(null,this$,a,b));
} else {
var m__10275__auto__ = (cljs.core._invoke["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__10275__auto__.call(null,this$,a,b));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14207__4 = (function (this$,a,b,c){
var x__10276__auto__ = (((this$ == null))?null:this$);
var m__10277__auto__ = (cljs.core._invoke[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$4 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__10277__auto__.call(null,this$,a,b,c));
} else {
var m__10275__auto__ = (cljs.core._invoke["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$4 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__10275__auto__.call(null,this$,a,b,c));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14207__5 = (function (this$,a,b,c,d){
var x__10276__auto__ = (((this$ == null))?null:this$);
var m__10277__auto__ = (cljs.core._invoke[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$5 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__10277__auto__.call(null,this$,a,b,c,d));
} else {
var m__10275__auto__ = (cljs.core._invoke["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$5 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__10275__auto__.call(null,this$,a,b,c,d));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14207__6 = (function (this$,a,b,c,d,e){
var x__10276__auto__ = (((this$ == null))?null:this$);
var m__10277__auto__ = (cljs.core._invoke[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$6 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__10277__auto__.call(null,this$,a,b,c,d,e));
} else {
var m__10275__auto__ = (cljs.core._invoke["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$6 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__10275__auto__.call(null,this$,a,b,c,d,e));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14207__7 = (function (this$,a,b,c,d,e,f){
var x__10276__auto__ = (((this$ == null))?null:this$);
var m__10277__auto__ = (cljs.core._invoke[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$7 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__10277__auto__.call(null,this$,a,b,c,d,e,f));
} else {
var m__10275__auto__ = (cljs.core._invoke["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$7 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__10275__auto__.call(null,this$,a,b,c,d,e,f));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14207__8 = (function (this$,a,b,c,d,e,f,g){
var x__10276__auto__ = (((this$ == null))?null:this$);
var m__10277__auto__ = (cljs.core._invoke[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$8 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__10277__auto__.call(null,this$,a,b,c,d,e,f,g));
} else {
var m__10275__auto__ = (cljs.core._invoke["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$8 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__10275__auto__.call(null,this$,a,b,c,d,e,f,g));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14207__9 = (function (this$,a,b,c,d,e,f,g,h){
var x__10276__auto__ = (((this$ == null))?null:this$);
var m__10277__auto__ = (cljs.core._invoke[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$9 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__10277__auto__.call(null,this$,a,b,c,d,e,f,g,h));
} else {
var m__10275__auto__ = (cljs.core._invoke["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$9 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__10275__auto__.call(null,this$,a,b,c,d,e,f,g,h));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14207__10 = (function (this$,a,b,c,d,e,f,g,h,i){
var x__10276__auto__ = (((this$ == null))?null:this$);
var m__10277__auto__ = (cljs.core._invoke[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$10 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__10277__auto__.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
var m__10275__auto__ = (cljs.core._invoke["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$10 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__10275__auto__.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14207__11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
var x__10276__auto__ = (((this$ == null))?null:this$);
var m__10277__auto__ = (cljs.core._invoke[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$11 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__10277__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
var m__10275__auto__ = (cljs.core._invoke["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$11 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__10275__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14207__12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
var x__10276__auto__ = (((this$ == null))?null:this$);
var m__10277__auto__ = (cljs.core._invoke[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$12 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__10277__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
var m__10275__auto__ = (cljs.core._invoke["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$12 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__10275__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14207__13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
var x__10276__auto__ = (((this$ == null))?null:this$);
var m__10277__auto__ = (cljs.core._invoke[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$13 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__10277__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
var m__10275__auto__ = (cljs.core._invoke["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$13 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__10275__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14207__14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
var x__10276__auto__ = (((this$ == null))?null:this$);
var m__10277__auto__ = (cljs.core._invoke[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$14 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__10277__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
var m__10275__auto__ = (cljs.core._invoke["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$14 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__10275__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14207__15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var x__10276__auto__ = (((this$ == null))?null:this$);
var m__10277__auto__ = (cljs.core._invoke[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$15 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__10277__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
var m__10275__auto__ = (cljs.core._invoke["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$15 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__10275__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14207__16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var x__10276__auto__ = (((this$ == null))?null:this$);
var m__10277__auto__ = (cljs.core._invoke[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$16 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__10277__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
var m__10275__auto__ = (cljs.core._invoke["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$16 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__10275__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14207__17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var x__10276__auto__ = (((this$ == null))?null:this$);
var m__10277__auto__ = (cljs.core._invoke[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$17 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__10277__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
var m__10275__auto__ = (cljs.core._invoke["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$17 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__10275__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14207__18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var x__10276__auto__ = (((this$ == null))?null:this$);
var m__10277__auto__ = (cljs.core._invoke[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$18 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__10277__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
var m__10275__auto__ = (cljs.core._invoke["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$18 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__10275__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14207__19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var x__10276__auto__ = (((this$ == null))?null:this$);
var m__10277__auto__ = (cljs.core._invoke[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$19 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__10277__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
var m__10275__auto__ = (cljs.core._invoke["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$19 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__10275__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14207__20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var x__10276__auto__ = (((this$ == null))?null:this$);
var m__10277__auto__ = (cljs.core._invoke[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$20 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__10277__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
var m__10275__auto__ = (cljs.core._invoke["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$20 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__10275__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14207__21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var x__10276__auto__ = (((this$ == null))?null:this$);
var m__10277__auto__ = (cljs.core._invoke[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$21 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__10277__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
var m__10275__auto__ = (cljs.core._invoke["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$21 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__10275__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14207__22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var x__10276__auto__ = (((this$ == null))?null:this$);
var m__10277__auto__ = (cljs.core._invoke[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$22 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__10277__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
var m__10275__auto__ = (cljs.core._invoke["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$22 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__10275__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
cljs$core$fn_14207 = function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return cljs$core$fn_14207__1.call(this,this$);
case 2:
return cljs$core$fn_14207__2.call(this,this$,a);
case 3:
return cljs$core$fn_14207__3.call(this,this$,a,b);
case 4:
return cljs$core$fn_14207__4.call(this,this$,a,b,c);
case 5:
return cljs$core$fn_14207__5.call(this,this$,a,b,c,d);
case 6:
return cljs$core$fn_14207__6.call(this,this$,a,b,c,d,e);
case 7:
return cljs$core$fn_14207__7.call(this,this$,a,b,c,d,e,f);
case 8:
return cljs$core$fn_14207__8.call(this,this$,a,b,c,d,e,f,g);
case 9:
return cljs$core$fn_14207__9.call(this,this$,a,b,c,d,e,f,g,h);
case 10:
return cljs$core$fn_14207__10.call(this,this$,a,b,c,d,e,f,g,h,i);
case 11:
return cljs$core$fn_14207__11.call(this,this$,a,b,c,d,e,f,g,h,i,j);
case 12:
return cljs$core$fn_14207__12.call(this,this$,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return cljs$core$fn_14207__13.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return cljs$core$fn_14207__14.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return cljs$core$fn_14207__15.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return cljs$core$fn_14207__16.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return cljs$core$fn_14207__17.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return cljs$core$fn_14207__18.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return cljs$core$fn_14207__19.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return cljs$core$fn_14207__20.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return cljs$core$fn_14207__21.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return cljs$core$fn_14207__22.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14207.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14207__1;
cljs$core$fn_14207.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14207__2;
cljs$core$fn_14207.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14207__3;
cljs$core$fn_14207.cljs$core$IFn$_invoke$arity$4 = cljs$core$fn_14207__4;
cljs$core$fn_14207.cljs$core$IFn$_invoke$arity$5 = cljs$core$fn_14207__5;
cljs$core$fn_14207.cljs$core$IFn$_invoke$arity$6 = cljs$core$fn_14207__6;
cljs$core$fn_14207.cljs$core$IFn$_invoke$arity$7 = cljs$core$fn_14207__7;
cljs$core$fn_14207.cljs$core$IFn$_invoke$arity$8 = cljs$core$fn_14207__8;
cljs$core$fn_14207.cljs$core$IFn$_invoke$arity$9 = cljs$core$fn_14207__9;
cljs$core$fn_14207.cljs$core$IFn$_invoke$arity$10 = cljs$core$fn_14207__10;
cljs$core$fn_14207.cljs$core$IFn$_invoke$arity$11 = cljs$core$fn_14207__11;
cljs$core$fn_14207.cljs$core$IFn$_invoke$arity$12 = cljs$core$fn_14207__12;
cljs$core$fn_14207.cljs$core$IFn$_invoke$arity$13 = cljs$core$fn_14207__13;
cljs$core$fn_14207.cljs$core$IFn$_invoke$arity$14 = cljs$core$fn_14207__14;
cljs$core$fn_14207.cljs$core$IFn$_invoke$arity$15 = cljs$core$fn_14207__15;
cljs$core$fn_14207.cljs$core$IFn$_invoke$arity$16 = cljs$core$fn_14207__16;
cljs$core$fn_14207.cljs$core$IFn$_invoke$arity$17 = cljs$core$fn_14207__17;
cljs$core$fn_14207.cljs$core$IFn$_invoke$arity$18 = cljs$core$fn_14207__18;
cljs$core$fn_14207.cljs$core$IFn$_invoke$arity$19 = cljs$core$fn_14207__19;
cljs$core$fn_14207.cljs$core$IFn$_invoke$arity$20 = cljs$core$fn_14207__20;
cljs$core$fn_14207.cljs$core$IFn$_invoke$arity$21 = cljs$core$fn_14207__21;
cljs$core$fn_14207.cljs$core$IFn$_invoke$arity$22 = cljs$core$fn_14207__22;
return cljs$core$fn_14207;
})()
;
cljs.core._invoke = (function cljs$core$_invoke(var_args){
var G__14209 = arguments.length;
switch (G__14209) {
case 1:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
case 9:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
case 11:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));

break;
case 12:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));

break;
case 13:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));

break;
case 14:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));

break;
case 15:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));

break;
case 16:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));

break;
case 17:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));

break;
case 18:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));

break;
case 19:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));

break;
case 20:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));

break;
case 21:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));

break;
case 22:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14210(this$){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$1 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$1(this$);
} else {
return cljs$core$IFn$_invoke$dyn_14232.cljs$core$IFn$_invoke$arity$1(this$);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14211(this$,a){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$2 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$2(this$,a);
} else {
return cljs$core$IFn$_invoke$dyn_14232.cljs$core$IFn$_invoke$arity$2(this$,a);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14212(this$,a,b){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$3 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);
} else {
return cljs$core$IFn$_invoke$dyn_14232.cljs$core$IFn$_invoke$arity$3(this$,a,b);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14213(this$,a,b,c){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$4 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
} else {
return cljs$core$IFn$_invoke$dyn_14232.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_14214(this$,a,b,c,d){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$5 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
} else {
return cljs$core$IFn$_invoke$dyn_14232.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_14215(this$,a,b,c,d,e){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$6 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
} else {
return cljs$core$IFn$_invoke$dyn_14232.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = (function cljs$core$fn_14216(this$,a,b,c,d,e,f){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$7 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
} else {
return cljs$core$IFn$_invoke$dyn_14232.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = (function cljs$core$fn_14217(this$,a,b,c,d,e,f,g){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$8 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
} else {
return cljs$core$IFn$_invoke$dyn_14232.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = (function cljs$core$fn_14218(this$,a,b,c,d,e,f,g,h){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$9 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
} else {
return cljs$core$IFn$_invoke$dyn_14232.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = (function cljs$core$fn_14219(this$,a,b,c,d,e,f,g,h,i){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$10 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
} else {
return cljs$core$IFn$_invoke$dyn_14232.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = (function cljs$core$fn_14220(this$,a,b,c,d,e,f,g,h,i,j){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$11 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
} else {
return cljs$core$IFn$_invoke$dyn_14232.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = (function cljs$core$fn_14221(this$,a,b,c,d,e,f,g,h,i,j,k){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$12 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
return cljs$core$IFn$_invoke$dyn_14232.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = (function cljs$core$fn_14222(this$,a,b,c,d,e,f,g,h,i,j,k,l){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$13 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
return cljs$core$IFn$_invoke$dyn_14232.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = (function cljs$core$fn_14223(this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$14 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
return cljs$core$IFn$_invoke$dyn_14232.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = (function cljs$core$fn_14224(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$15 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
return cljs$core$IFn$_invoke$dyn_14232.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = (function cljs$core$fn_14225(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$16 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
return cljs$core$IFn$_invoke$dyn_14232.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = (function cljs$core$fn_14226(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$17 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
return cljs$core$IFn$_invoke$dyn_14232.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = (function cljs$core$fn_14227(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$18 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
return cljs$core$IFn$_invoke$dyn_14232.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = (function cljs$core$fn_14228(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$19 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
return cljs$core$IFn$_invoke$dyn_14232.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = (function cljs$core$fn_14229(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$20 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
return cljs$core$IFn$_invoke$dyn_14232.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = (function cljs$core$fn_14230(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$21 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
return cljs$core$IFn$_invoke$dyn_14232.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = (function cljs$core$fn_14231(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$22 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
return cljs$core$IFn$_invoke$dyn_14232.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
}));

(cljs.core._invoke.cljs$lang$maxFixedArity = 22);



/**
 * Protocol for cloning a value.
 * @interface
 */
cljs.core.ICloneable = function(){};

var cljs$core$ICloneable$_clone$dyn_14235 = (function cljs$core$fn_14234(value){
var x__10276__auto__ = (((value == null))?null:value);
var m__10277__auto__ = (cljs.core._clone[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__10277__auto__.call(null,value));
} else {
var m__10275__auto__ = (cljs.core._clone["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__10275__auto__.call(null,value));
} else {
throw cljs.core.missing_protocol("ICloneable.-clone",value);
}
}
});
/**
 * Creates a clone of value.
 */
cljs.core._clone = (function cljs$core$_clone(value){
if((((!((value == null)))) && ((!((value.cljs$core$ICloneable$_clone$arity$1 == null)))))){
return value.cljs$core$ICloneable$_clone$arity$1(value);
} else {
return cljs$core$ICloneable$_clone$dyn_14235(value);
}
});


/**
 * Protocol for adding the ability to count a collection in constant time.
 * @interface
 */
cljs.core.ICounted = function(){};

var cljs$core$ICounted$_count$dyn_14237 = (function cljs$core$fn_14236(coll){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._count[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10277__auto__.call(null,coll));
} else {
var m__10275__auto__ = (cljs.core._count["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10275__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ICounted.-count",coll);
}
}
});
/**
 * Calculates the count of coll in constant time. Used by cljs.core/count.
 */
cljs.core._count = (function cljs$core$_count(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ICounted$_count$arity$1 == null)))))){
return coll.cljs$core$ICounted$_count$arity$1(coll);
} else {
return cljs$core$ICounted$_count$dyn_14237(coll);
}
});


/**
 * Protocol for creating an empty collection.
 * @interface
 */
cljs.core.IEmptyableCollection = function(){};

var cljs$core$IEmptyableCollection$_empty$dyn_14239 = (function cljs$core$fn_14238(coll){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._empty[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10277__auto__.call(null,coll));
} else {
var m__10275__auto__ = (cljs.core._empty["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10275__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEmptyableCollection.-empty",coll);
}
}
});
/**
 * Returns an empty collection of the same category as coll. Used
 *   by cljs.core/empty.
 */
cljs.core._empty = (function cljs$core$_empty(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IEmptyableCollection$_empty$arity$1 == null)))))){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else {
return cljs$core$IEmptyableCollection$_empty$dyn_14239(coll);
}
});


/**
 * Protocol for adding to a collection.
 * @interface
 */
cljs.core.ICollection = function(){};

var cljs$core$ICollection$_conj$dyn_14241 = (function cljs$core$fn_14240(coll,o){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._conj[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__10277__auto__.call(null,coll,o));
} else {
var m__10275__auto__ = (cljs.core._conj["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__10275__auto__.call(null,coll,o));
} else {
throw cljs.core.missing_protocol("ICollection.-conj",coll);
}
}
});
/**
 * Returns a new collection of coll with o added to it. The new item
 *   should be added to the most efficient place, e.g.
 *   (conj [1 2 3 4] 5) => [1 2 3 4 5]
 *   (conj '(2 3 4 5) 1) => '(1 2 3 4 5)
 */
cljs.core._conj = (function cljs$core$_conj(coll,o){
if((((!((coll == null)))) && ((!((coll.cljs$core$ICollection$_conj$arity$2 == null)))))){
return coll.cljs$core$ICollection$_conj$arity$2(coll,o);
} else {
return cljs$core$ICollection$_conj$dyn_14241(coll,o);
}
});


/**
 * Protocol for collections to provide indexed-based access to their items.
 * @interface
 */
cljs.core.IIndexed = function(){};

var cljs$core$IIndexed$_nth$dyn_14247 = (function() {
var cljs$core$fn_14242 = null;
var cljs$core$fn_14242__2 = (function (coll,n){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._nth[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__10277__auto__.call(null,coll,n));
} else {
var m__10275__auto__ = (cljs.core._nth["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__10275__auto__.call(null,coll,n));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
});
var cljs$core$fn_14242__3 = (function (coll,n,not_found){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._nth[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__10277__auto__.call(null,coll,n,not_found));
} else {
var m__10275__auto__ = (cljs.core._nth["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__10275__auto__.call(null,coll,n,not_found));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
});
cljs$core$fn_14242 = function(coll,n,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_14242__2.call(this,coll,n);
case 3:
return cljs$core$fn_14242__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14242.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14242__2;
cljs$core$fn_14242.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14242__3;
return cljs$core$fn_14242;
})()
;
/**
 * Returns the value at the index n in the collection coll.
 *   Returns not-found if index n is out of bounds and not-found is supplied.
 */
cljs.core._nth = (function cljs$core$_nth(var_args){
var G__14244 = arguments.length;
switch (G__14244) {
case 2:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14245(coll,n){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIndexed$_nth$arity$2 == null)))))){
return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else {
return cljs$core$IIndexed$_nth$dyn_14247.cljs$core$IFn$_invoke$arity$2(coll,n);
}
}));

(cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14246(coll,n,not_found){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIndexed$_nth$arity$3 == null)))))){
return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);
} else {
return cljs$core$IIndexed$_nth$dyn_14247.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
}
}));

(cljs.core._nth.cljs$lang$maxFixedArity = 3);



/**
 * Marker protocol indicating an array sequence.
 * @interface
 */
cljs.core.ASeq = function(){};


/**
 * Protocol for collections to provide access to their items as sequences.
 * @interface
 */
cljs.core.ISeq = function(){};

var cljs$core$ISeq$_first$dyn_14251 = (function cljs$core$fn_14249(coll){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._first[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10277__auto__.call(null,coll));
} else {
var m__10275__auto__ = (cljs.core._first["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10275__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-first",coll);
}
}
});
/**
 * Returns the first item in the collection coll. Used by cljs.core/first.
 */
cljs.core._first = (function cljs$core$_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISeq$_first$arity$1 == null)))))){
return coll.cljs$core$ISeq$_first$arity$1(coll);
} else {
return cljs$core$ISeq$_first$dyn_14251(coll);
}
});

var cljs$core$ISeq$_rest$dyn_14252 = (function cljs$core$fn_14250(coll){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._rest[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10277__auto__.call(null,coll));
} else {
var m__10275__auto__ = (cljs.core._rest["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10275__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-rest",coll);
}
}
});
/**
 * Returns a new collection of coll without the first item. It should
 *   always return a seq, e.g.
 *   (rest []) => ()
 *   (rest nil) => ()
 */
cljs.core._rest = (function cljs$core$_rest(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISeq$_rest$arity$1 == null)))))){
return coll.cljs$core$ISeq$_rest$arity$1(coll);
} else {
return cljs$core$ISeq$_rest$dyn_14252(coll);
}
});


/**
 * Protocol for accessing the next items of a collection.
 * @interface
 */
cljs.core.INext = function(){};

var cljs$core$INext$_next$dyn_14254 = (function cljs$core$fn_14253(coll){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._next[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10277__auto__.call(null,coll));
} else {
var m__10275__auto__ = (cljs.core._next["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10275__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("INext.-next",coll);
}
}
});
/**
 * Returns a new collection of coll without the first item. In contrast to
 *   rest, it should return nil if there are no more items, e.g.
 *   (next []) => nil
 *   (next nil) => nil
 */
cljs.core._next = (function cljs$core$_next(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$INext$_next$arity$1 == null)))))){
return coll.cljs$core$INext$_next$arity$1(coll);
} else {
return cljs$core$INext$_next$dyn_14254(coll);
}
});


/**
 * Protocol for looking up a value in a data structure.
 * @interface
 */
cljs.core.ILookup = function(){};

var cljs$core$ILookup$_lookup$dyn_14260 = (function() {
var cljs$core$fn_14255 = null;
var cljs$core$fn_14255__2 = (function (o,k){
var x__10276__auto__ = (((o == null))?null:o);
var m__10277__auto__ = (cljs.core._lookup[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__10277__auto__.call(null,o,k));
} else {
var m__10275__auto__ = (cljs.core._lookup["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__10275__auto__.call(null,o,k));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
});
var cljs$core$fn_14255__3 = (function (o,k,not_found){
var x__10276__auto__ = (((o == null))?null:o);
var m__10277__auto__ = (cljs.core._lookup[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__10277__auto__.call(null,o,k,not_found));
} else {
var m__10275__auto__ = (cljs.core._lookup["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__10275__auto__.call(null,o,k,not_found));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
});
cljs$core$fn_14255 = function(o,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_14255__2.call(this,o,k);
case 3:
return cljs$core$fn_14255__3.call(this,o,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14255.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14255__2;
cljs$core$fn_14255.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14255__3;
return cljs$core$fn_14255;
})()
;
/**
 * Use k to look up a value in o. If not-found is supplied and k is not
 *   a valid value that can be used for look up, not-found is returned.
 */
cljs.core._lookup = (function cljs$core$_lookup(var_args){
var G__14257 = arguments.length;
switch (G__14257) {
case 2:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14258(o,k){
if((((!((o == null)))) && ((!((o.cljs$core$ILookup$_lookup$arity$2 == null)))))){
return o.cljs$core$ILookup$_lookup$arity$2(o,k);
} else {
return cljs$core$ILookup$_lookup$dyn_14260.cljs$core$IFn$_invoke$arity$2(o,k);
}
}));

(cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14259(o,k,not_found){
if((((!((o == null)))) && ((!((o.cljs$core$ILookup$_lookup$arity$3 == null)))))){
return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);
} else {
return cljs$core$ILookup$_lookup$dyn_14260.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
}
}));

(cljs.core._lookup.cljs$lang$maxFixedArity = 3);



/**
 * Protocol for adding associativity to collections.
 * @interface
 */
cljs.core.IAssociative = function(){};

var cljs$core$IAssociative$_contains_key_QMARK_$dyn_14264 = (function cljs$core$fn_14262(coll,k){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._contains_key_QMARK_[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10277__auto__.call(null,coll,k));
} else {
var m__10275__auto__ = (cljs.core._contains_key_QMARK_["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10275__auto__.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IAssociative.-contains-key?",coll);
}
}
});
/**
 * Returns true if k is a key in coll.
 */
cljs.core._contains_key_QMARK_ = (function cljs$core$_contains_key_QMARK_(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 == null)))))){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);
} else {
return cljs$core$IAssociative$_contains_key_QMARK_$dyn_14264(coll,k);
}
});

var cljs$core$IAssociative$_assoc$dyn_14265 = (function cljs$core$fn_14263(coll,k,v){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._assoc[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__10277__auto__.call(null,coll,k,v));
} else {
var m__10275__auto__ = (cljs.core._assoc["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__10275__auto__.call(null,coll,k,v));
} else {
throw cljs.core.missing_protocol("IAssociative.-assoc",coll);
}
}
});
/**
 * Returns a new collection of coll with a mapping from key k to
 *   value v added to it.
 */
cljs.core._assoc = (function cljs$core$_assoc(coll,k,v){
if((((!((coll == null)))) && ((!((coll.cljs$core$IAssociative$_assoc$arity$3 == null)))))){
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);
} else {
return cljs$core$IAssociative$_assoc$dyn_14265(coll,k,v);
}
});


/**
 * Protocol for implementing entry finding in collections.
 * @interface
 */
cljs.core.IFind = function(){};

var cljs$core$IFind$_find$dyn_14267 = (function cljs$core$fn_14266(coll,k){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._find[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10277__auto__.call(null,coll,k));
} else {
var m__10275__auto__ = (cljs.core._find["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10275__auto__.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IFind.-find",coll);
}
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core._find = (function cljs$core$_find(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IFind$_find$arity$2 == null)))))){
return coll.cljs$core$IFind$_find$arity$2(coll,k);
} else {
return cljs$core$IFind$_find$dyn_14267(coll,k);
}
});


/**
 * Protocol for adding mapping functionality to collections.
 * @interface
 */
cljs.core.IMap = function(){};

var cljs$core$IMap$_dissoc$dyn_14269 = (function cljs$core$fn_14268(coll,k){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._dissoc[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10277__auto__.call(null,coll,k));
} else {
var m__10275__auto__ = (cljs.core._dissoc["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10275__auto__.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IMap.-dissoc",coll);
}
}
});
/**
 * Returns a new collection of coll without the mapping for key k.
 */
cljs.core._dissoc = (function cljs$core$_dissoc(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMap$_dissoc$arity$2 == null)))))){
return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);
} else {
return cljs$core$IMap$_dissoc$dyn_14269(coll,k);
}
});


/**
 * Protocol for examining a map entry.
 * @interface
 */
cljs.core.IMapEntry = function(){};

var cljs$core$IMapEntry$_key$dyn_14272 = (function cljs$core$fn_14270(coll){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._key[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10277__auto__.call(null,coll));
} else {
var m__10275__auto__ = (cljs.core._key["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10275__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-key",coll);
}
}
});
/**
 * Returns the key of the map entry.
 */
cljs.core._key = (function cljs$core$_key(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMapEntry$_key$arity$1 == null)))))){
return coll.cljs$core$IMapEntry$_key$arity$1(coll);
} else {
return cljs$core$IMapEntry$_key$dyn_14272(coll);
}
});

var cljs$core$IMapEntry$_val$dyn_14273 = (function cljs$core$fn_14271(coll){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._val[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10277__auto__.call(null,coll));
} else {
var m__10275__auto__ = (cljs.core._val["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10275__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-val",coll);
}
}
});
/**
 * Returns the value of the map entry.
 */
cljs.core._val = (function cljs$core$_val(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMapEntry$_val$arity$1 == null)))))){
return coll.cljs$core$IMapEntry$_val$arity$1(coll);
} else {
return cljs$core$IMapEntry$_val$dyn_14273(coll);
}
});


/**
 * Protocol for adding set functionality to a collection.
 * @interface
 */
cljs.core.ISet = function(){};

var cljs$core$ISet$_disjoin$dyn_14275 = (function cljs$core$fn_14274(coll,v){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._disjoin[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__10277__auto__.call(null,coll,v));
} else {
var m__10275__auto__ = (cljs.core._disjoin["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__10275__auto__.call(null,coll,v));
} else {
throw cljs.core.missing_protocol("ISet.-disjoin",coll);
}
}
});
/**
 * Returns a new collection of coll that does not contain v.
 */
cljs.core._disjoin = (function cljs$core$_disjoin(coll,v){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISet$_disjoin$arity$2 == null)))))){
return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);
} else {
return cljs$core$ISet$_disjoin$dyn_14275(coll,v);
}
});


/**
 * Protocol for collections to provide access to their items as stacks. The top
 *   of the stack should be accessed in the most efficient way for the different
 *   data structures.
 * @interface
 */
cljs.core.IStack = function(){};

var cljs$core$IStack$_peek$dyn_14278 = (function cljs$core$fn_14276(coll){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._peek[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10277__auto__.call(null,coll));
} else {
var m__10275__auto__ = (cljs.core._peek["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10275__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-peek",coll);
}
}
});
/**
 * Returns the item from the top of the stack. Is used by cljs.core/peek.
 */
cljs.core._peek = (function cljs$core$_peek(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IStack$_peek$arity$1 == null)))))){
return coll.cljs$core$IStack$_peek$arity$1(coll);
} else {
return cljs$core$IStack$_peek$dyn_14278(coll);
}
});

var cljs$core$IStack$_pop$dyn_14279 = (function cljs$core$fn_14277(coll){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._pop[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10277__auto__.call(null,coll));
} else {
var m__10275__auto__ = (cljs.core._pop["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10275__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-pop",coll);
}
}
});
/**
 * Returns a new stack without the item on top of the stack. Is used
 *   by cljs.core/pop.
 */
cljs.core._pop = (function cljs$core$_pop(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IStack$_pop$arity$1 == null)))))){
return coll.cljs$core$IStack$_pop$arity$1(coll);
} else {
return cljs$core$IStack$_pop$dyn_14279(coll);
}
});


/**
 * Protocol for adding vector functionality to collections.
 * @interface
 */
cljs.core.IVector = function(){};

var cljs$core$IVector$_assoc_n$dyn_14281 = (function cljs$core$fn_14280(coll,n,val){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._assoc_n[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__10277__auto__.call(null,coll,n,val));
} else {
var m__10275__auto__ = (cljs.core._assoc_n["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__10275__auto__.call(null,coll,n,val));
} else {
throw cljs.core.missing_protocol("IVector.-assoc-n",coll);
}
}
});
/**
 * Returns a new vector with value val added at position n.
 */
cljs.core._assoc_n = (function cljs$core$_assoc_n(coll,n,val){
if((((!((coll == null)))) && ((!((coll.cljs$core$IVector$_assoc_n$arity$3 == null)))))){
return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);
} else {
return cljs$core$IVector$_assoc_n$dyn_14281(coll,n,val);
}
});


/**
 * Protocol for adding dereference functionality to a reference.
 * @interface
 */
cljs.core.IDeref = function(){};

var cljs$core$IDeref$_deref$dyn_14283 = (function cljs$core$fn_14282(o){
var x__10276__auto__ = (((o == null))?null:o);
var m__10277__auto__ = (cljs.core._deref[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10277__auto__.call(null,o));
} else {
var m__10275__auto__ = (cljs.core._deref["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10275__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("IDeref.-deref",o);
}
}
});
/**
 * Returns the value of the reference o.
 */
cljs.core._deref = (function cljs$core$_deref(o){
if((((!((o == null)))) && ((!((o.cljs$core$IDeref$_deref$arity$1 == null)))))){
return o.cljs$core$IDeref$_deref$arity$1(o);
} else {
return cljs$core$IDeref$_deref$dyn_14283(o);
}
});


/**
 * @interface
 */
cljs.core.IDerefWithTimeout = function(){};

var cljs$core$IDerefWithTimeout$_deref_with_timeout$dyn_14285 = (function cljs$core$fn_14284(o,msec,timeout_val){
var x__10276__auto__ = (((o == null))?null:o);
var m__10277__auto__ = (cljs.core._deref_with_timeout[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__10277__auto__.call(null,o,msec,timeout_val));
} else {
var m__10275__auto__ = (cljs.core._deref_with_timeout["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__10275__auto__.call(null,o,msec,timeout_val));
} else {
throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout",o);
}
}
});
cljs.core._deref_with_timeout = (function cljs$core$_deref_with_timeout(o,msec,timeout_val){
if((((!((o == null)))) && ((!((o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3 == null)))))){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);
} else {
return cljs$core$IDerefWithTimeout$_deref_with_timeout$dyn_14285(o,msec,timeout_val);
}
});


/**
 * Protocol for accessing the metadata of an object.
 * @interface
 */
cljs.core.IMeta = function(){};

var cljs$core$IMeta$_meta$dyn_14287 = (function cljs$core$fn_14286(o){
var x__10276__auto__ = (((o == null))?null:o);
var m__10277__auto__ = (cljs.core._meta[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10277__auto__.call(null,o));
} else {
var m__10275__auto__ = (cljs.core._meta["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10275__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("IMeta.-meta",o);
}
}
});
/**
 * Returns the metadata of object o.
 */
cljs.core._meta = (function cljs$core$_meta(o){
if((((!((o == null)))) && ((!((o.cljs$core$IMeta$_meta$arity$1 == null)))))){
return o.cljs$core$IMeta$_meta$arity$1(o);
} else {
return cljs$core$IMeta$_meta$dyn_14287(o);
}
});


/**
 * Protocol for adding metadata to an object.
 * @interface
 */
cljs.core.IWithMeta = function(){};

var cljs$core$IWithMeta$_with_meta$dyn_14289 = (function cljs$core$fn_14288(o,meta){
var x__10276__auto__ = (((o == null))?null:o);
var m__10277__auto__ = (cljs.core._with_meta[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__10277__auto__.call(null,o,meta));
} else {
var m__10275__auto__ = (cljs.core._with_meta["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__10275__auto__.call(null,o,meta));
} else {
throw cljs.core.missing_protocol("IWithMeta.-with-meta",o);
}
}
});
/**
 * Returns a new object with value of o and metadata meta added to it.
 */
cljs.core._with_meta = (function cljs$core$_with_meta(o,meta){
if((((!((o == null)))) && ((!((o.cljs$core$IWithMeta$_with_meta$arity$2 == null)))))){
return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);
} else {
return cljs$core$IWithMeta$_with_meta$dyn_14289(o,meta);
}
});


/**
 * Protocol for seq types that can reduce themselves.
 *   Called by cljs.core/reduce.
 * @interface
 */
cljs.core.IReduce = function(){};

var cljs$core$IReduce$_reduce$dyn_14295 = (function() {
var cljs$core$fn_14290 = null;
var cljs$core$fn_14290__2 = (function (coll,f){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._reduce[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__10277__auto__.call(null,coll,f));
} else {
var m__10275__auto__ = (cljs.core._reduce["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__10275__auto__.call(null,coll,f));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
});
var cljs$core$fn_14290__3 = (function (coll,f,start){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._reduce[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__10277__auto__.call(null,coll,f,start));
} else {
var m__10275__auto__ = (cljs.core._reduce["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__10275__auto__.call(null,coll,f,start));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
});
cljs$core$fn_14290 = function(coll,f,start){
switch(arguments.length){
case 2:
return cljs$core$fn_14290__2.call(this,coll,f);
case 3:
return cljs$core$fn_14290__3.call(this,coll,f,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14290.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14290__2;
cljs$core$fn_14290.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14290__3;
return cljs$core$fn_14290;
})()
;
/**
 * f should be a function of 2 arguments. If start is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc.
 */
cljs.core._reduce = (function cljs$core$_reduce(var_args){
var G__14292 = arguments.length;
switch (G__14292) {
case 2:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14293(coll,f){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReduce$_reduce$arity$2 == null)))))){
return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);
} else {
return cljs$core$IReduce$_reduce$dyn_14295.cljs$core$IFn$_invoke$arity$2(coll,f);
}
}));

(cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14294(coll,f,start){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReduce$_reduce$arity$3 == null)))))){
return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);
} else {
return cljs$core$IReduce$_reduce$dyn_14295.cljs$core$IFn$_invoke$arity$3(coll,f,start);
}
}));

(cljs.core._reduce.cljs$lang$maxFixedArity = 3);



/**
 * Protocol for associative types that can reduce themselves
 *   via a function of key and val. Called by cljs.core/reduce-kv.
 * @interface
 */
cljs.core.IKVReduce = function(){};

var cljs$core$IKVReduce$_kv_reduce$dyn_14298 = (function cljs$core$fn_14297(coll,f,init){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._kv_reduce[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__10277__auto__.call(null,coll,f,init));
} else {
var m__10275__auto__ = (cljs.core._kv_reduce["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__10275__auto__.call(null,coll,f,init));
} else {
throw cljs.core.missing_protocol("IKVReduce.-kv-reduce",coll);
}
}
});
/**
 * Reduces an associative collection and returns the result. f should be
 *   a function that takes three arguments.
 */
cljs.core._kv_reduce = (function cljs$core$_kv_reduce(coll,f,init){
if((((!((coll == null)))) && ((!((coll.cljs$core$IKVReduce$_kv_reduce$arity$3 == null)))))){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);
} else {
return cljs$core$IKVReduce$_kv_reduce$dyn_14298(coll,f,init);
}
});


/**
 * Protocol for adding value comparison functionality to a type.
 * @interface
 */
cljs.core.IEquiv = function(){};

var cljs$core$IEquiv$_equiv$dyn_14300 = (function cljs$core$fn_14299(o,other){
var x__10276__auto__ = (((o == null))?null:o);
var m__10277__auto__ = (cljs.core._equiv[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__10277__auto__.call(null,o,other));
} else {
var m__10275__auto__ = (cljs.core._equiv["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__10275__auto__.call(null,o,other));
} else {
throw cljs.core.missing_protocol("IEquiv.-equiv",o);
}
}
});
/**
 * Returns true if o and other are equal, false otherwise.
 */
cljs.core._equiv = (function cljs$core$_equiv(o,other){
if((((!((o == null)))) && ((!((o.cljs$core$IEquiv$_equiv$arity$2 == null)))))){
return o.cljs$core$IEquiv$_equiv$arity$2(o,other);
} else {
return cljs$core$IEquiv$_equiv$dyn_14300(o,other);
}
});


/**
 * Protocol for adding hashing functionality to a type.
 * @interface
 */
cljs.core.IHash = function(){};

var cljs$core$IHash$_hash$dyn_14302 = (function cljs$core$fn_14301(o){
var x__10276__auto__ = (((o == null))?null:o);
var m__10277__auto__ = (cljs.core._hash[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10277__auto__.call(null,o));
} else {
var m__10275__auto__ = (cljs.core._hash["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10275__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("IHash.-hash",o);
}
}
});
/**
 * Returns the hash code of o.
 */
cljs.core._hash = (function cljs$core$_hash(o){
if((((!((o == null)))) && ((!((o.cljs$core$IHash$_hash$arity$1 == null)))))){
return o.cljs$core$IHash$_hash$arity$1(o);
} else {
return cljs$core$IHash$_hash$dyn_14302(o);
}
});


/**
 * Protocol for adding the ability to a type to be transformed into a sequence.
 * @interface
 */
cljs.core.ISeqable = function(){};

var cljs$core$ISeqable$_seq$dyn_14304 = (function cljs$core$fn_14303(o){
var x__10276__auto__ = (((o == null))?null:o);
var m__10277__auto__ = (cljs.core._seq[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10277__auto__.call(null,o));
} else {
var m__10275__auto__ = (cljs.core._seq["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10275__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("ISeqable.-seq",o);
}
}
});
/**
 * Returns a seq of o, or nil if o is empty.
 */
cljs.core._seq = (function cljs$core$_seq(o){
if((((!((o == null)))) && ((!((o.cljs$core$ISeqable$_seq$arity$1 == null)))))){
return o.cljs$core$ISeqable$_seq$arity$1(o);
} else {
return cljs$core$ISeqable$_seq$dyn_14304(o);
}
});


/**
 * Marker interface indicating a persistent collection of sequential items
 * @interface
 */
cljs.core.ISequential = function(){};


/**
 * Marker interface indicating a persistent list
 * @interface
 */
cljs.core.IList = function(){};


/**
 * Marker interface indicating a record object
 * @interface
 */
cljs.core.IRecord = function(){};


/**
 * Protocol for reversing a seq.
 * @interface
 */
cljs.core.IReversible = function(){};

var cljs$core$IReversible$_rseq$dyn_14306 = (function cljs$core$fn_14305(coll){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._rseq[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10277__auto__.call(null,coll));
} else {
var m__10275__auto__ = (cljs.core._rseq["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10275__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IReversible.-rseq",coll);
}
}
});
/**
 * Returns a seq of the items in coll in reversed order.
 */
cljs.core._rseq = (function cljs$core$_rseq(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReversible$_rseq$arity$1 == null)))))){
return coll.cljs$core$IReversible$_rseq$arity$1(coll);
} else {
return cljs$core$IReversible$_rseq$dyn_14306(coll);
}
});


/**
 * Protocol for a collection which can represent their items
 *   in a sorted manner. 
 * @interface
 */
cljs.core.ISorted = function(){};

var cljs$core$ISorted$_sorted_seq$dyn_14311 = (function cljs$core$fn_14307(coll,ascending_QMARK_){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._sorted_seq[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__10277__auto__.call(null,coll,ascending_QMARK_));
} else {
var m__10275__auto__ = (cljs.core._sorted_seq["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__10275__auto__.call(null,coll,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq",coll);
}
}
});
/**
 * Returns a sorted seq from coll in either ascending or descending order.
 */
cljs.core._sorted_seq = (function cljs$core$_sorted_seq(coll,ascending_QMARK_){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_sorted_seq$arity$2 == null)))))){
return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);
} else {
return cljs$core$ISorted$_sorted_seq$dyn_14311(coll,ascending_QMARK_);
}
});

var cljs$core$ISorted$_sorted_seq_from$dyn_14312 = (function cljs$core$fn_14308(coll,k,ascending_QMARK_){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._sorted_seq_from[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__10277__auto__.call(null,coll,k,ascending_QMARK_));
} else {
var m__10275__auto__ = (cljs.core._sorted_seq_from["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__10275__auto__.call(null,coll,k,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq-from",coll);
}
}
});
/**
 * Returns a sorted seq from coll in either ascending or descending order.
 *   If ascending is true, the result should contain all items which are > or >=
 *   than k. If ascending is false, the result should contain all items which
 *   are < or <= than k, e.g.
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)
 */
cljs.core._sorted_seq_from = (function cljs$core$_sorted_seq_from(coll,k,ascending_QMARK_){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_sorted_seq_from$arity$3 == null)))))){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);
} else {
return cljs$core$ISorted$_sorted_seq_from$dyn_14312(coll,k,ascending_QMARK_);
}
});

var cljs$core$ISorted$_entry_key$dyn_14313 = (function cljs$core$fn_14309(coll,entry){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._entry_key[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__10277__auto__.call(null,coll,entry));
} else {
var m__10275__auto__ = (cljs.core._entry_key["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__10275__auto__.call(null,coll,entry));
} else {
throw cljs.core.missing_protocol("ISorted.-entry-key",coll);
}
}
});
/**
 * Returns the key for entry.
 */
cljs.core._entry_key = (function cljs$core$_entry_key(coll,entry){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_entry_key$arity$2 == null)))))){
return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);
} else {
return cljs$core$ISorted$_entry_key$dyn_14313(coll,entry);
}
});

var cljs$core$ISorted$_comparator$dyn_14314 = (function cljs$core$fn_14310(coll){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._comparator[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10277__auto__.call(null,coll));
} else {
var m__10275__auto__ = (cljs.core._comparator["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10275__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISorted.-comparator",coll);
}
}
});
/**
 * Returns the comparator for coll.
 */
cljs.core._comparator = (function cljs$core$_comparator(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_comparator$arity$1 == null)))))){
return coll.cljs$core$ISorted$_comparator$arity$1(coll);
} else {
return cljs$core$ISorted$_comparator$dyn_14314(coll);
}
});


/**
 * Protocol for writing. Currently only implemented by StringBufferWriter.
 * @interface
 */
cljs.core.IWriter = function(){};

var cljs$core$IWriter$_write$dyn_14317 = (function cljs$core$fn_14315(writer,s){
var x__10276__auto__ = (((writer == null))?null:writer);
var m__10277__auto__ = (cljs.core._write[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__10277__auto__.call(null,writer,s));
} else {
var m__10275__auto__ = (cljs.core._write["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__10275__auto__.call(null,writer,s));
} else {
throw cljs.core.missing_protocol("IWriter.-write",writer);
}
}
});
/**
 * Writes s with writer and returns the result.
 */
cljs.core._write = (function cljs$core$_write(writer,s){
if((((!((writer == null)))) && ((!((writer.cljs$core$IWriter$_write$arity$2 == null)))))){
return writer.cljs$core$IWriter$_write$arity$2(writer,s);
} else {
return cljs$core$IWriter$_write$dyn_14317(writer,s);
}
});

var cljs$core$IWriter$_flush$dyn_14318 = (function cljs$core$fn_14316(writer){
var x__10276__auto__ = (((writer == null))?null:writer);
var m__10277__auto__ = (cljs.core._flush[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__10277__auto__.call(null,writer));
} else {
var m__10275__auto__ = (cljs.core._flush["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__10275__auto__.call(null,writer));
} else {
throw cljs.core.missing_protocol("IWriter.-flush",writer);
}
}
});
/**
 * Flush writer.
 */
cljs.core._flush = (function cljs$core$_flush(writer){
if((((!((writer == null)))) && ((!((writer.cljs$core$IWriter$_flush$arity$1 == null)))))){
return writer.cljs$core$IWriter$_flush$arity$1(writer);
} else {
return cljs$core$IWriter$_flush$dyn_14318(writer);
}
});


/**
 * The old IPrintable protocol's implementation consisted of building a giant
 * list of strings to concatenate.  This involved lots of concat calls,
 * intermediate vectors, and lazy-seqs, and was very slow in some older JS
 * engines.  IPrintWithWriter implements printing via the IWriter protocol, so it
 * be implemented efficiently in terms of e.g. a StringBuffer append.
 * @interface
 */
cljs.core.IPrintWithWriter = function(){};

var cljs$core$IPrintWithWriter$_pr_writer$dyn_14320 = (function cljs$core$fn_14319(o,writer,opts){
var x__10276__auto__ = (((o == null))?null:o);
var m__10277__auto__ = (cljs.core._pr_writer[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__10277__auto__.call(null,o,writer,opts));
} else {
var m__10275__auto__ = (cljs.core._pr_writer["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__10275__auto__.call(null,o,writer,opts));
} else {
throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer",o);
}
}
});
cljs.core._pr_writer = (function cljs$core$_pr_writer(o,writer,opts){
if((((!((o == null)))) && ((!((o.cljs$core$IPrintWithWriter$_pr_writer$arity$3 == null)))))){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);
} else {
return cljs$core$IPrintWithWriter$_pr_writer$dyn_14320(o,writer,opts);
}
});


/**
 * Protocol for types which can have a deferred realization. Currently only
 *   implemented by Delay and LazySeq.
 * @interface
 */
cljs.core.IPending = function(){};

var cljs$core$IPending$_realized_QMARK_$dyn_14322 = (function cljs$core$fn_14321(x){
var x__10276__auto__ = (((x == null))?null:x);
var m__10277__auto__ = (cljs.core._realized_QMARK_[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10277__auto__.call(null,x));
} else {
var m__10275__auto__ = (cljs.core._realized_QMARK_["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10275__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("IPending.-realized?",x);
}
}
});
/**
 * Returns true if a value for x has been produced, false otherwise.
 */
cljs.core._realized_QMARK_ = (function cljs$core$_realized_QMARK_(x){
if((((!((x == null)))) && ((!((x.cljs$core$IPending$_realized_QMARK_$arity$1 == null)))))){
return x.cljs$core$IPending$_realized_QMARK_$arity$1(x);
} else {
return cljs$core$IPending$_realized_QMARK_$dyn_14322(x);
}
});


/**
 * Protocol for types that can be watched. Currently only implemented by Atom.
 * @interface
 */
cljs.core.IWatchable = function(){};

var cljs$core$IWatchable$_notify_watches$dyn_14326 = (function cljs$core$fn_14323(this$,oldval,newval){
var x__10276__auto__ = (((this$ == null))?null:this$);
var m__10277__auto__ = (cljs.core._notify_watches[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__10277__auto__.call(null,this$,oldval,newval));
} else {
var m__10275__auto__ = (cljs.core._notify_watches["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__10275__auto__.call(null,this$,oldval,newval));
} else {
throw cljs.core.missing_protocol("IWatchable.-notify-watches",this$);
}
}
});
/**
 * Calls all watchers with this, oldval and newval.
 */
cljs.core._notify_watches = (function cljs$core$_notify_watches(this$,oldval,newval){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_notify_watches$arity$3 == null)))))){
return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);
} else {
return cljs$core$IWatchable$_notify_watches$dyn_14326(this$,oldval,newval);
}
});

var cljs$core$IWatchable$_add_watch$dyn_14327 = (function cljs$core$fn_14324(this$,key,f){
var x__10276__auto__ = (((this$ == null))?null:this$);
var m__10277__auto__ = (cljs.core._add_watch[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__10277__auto__.call(null,this$,key,f));
} else {
var m__10275__auto__ = (cljs.core._add_watch["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__10275__auto__.call(null,this$,key,f));
} else {
throw cljs.core.missing_protocol("IWatchable.-add-watch",this$);
}
}
});
/**
 * Adds a watcher function f to this. Keys must be unique per reference,
 *   and can be used to remove the watch with -remove-watch.
 */
cljs.core._add_watch = (function cljs$core$_add_watch(this$,key,f){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_add_watch$arity$3 == null)))))){
return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);
} else {
return cljs$core$IWatchable$_add_watch$dyn_14327(this$,key,f);
}
});

var cljs$core$IWatchable$_remove_watch$dyn_14328 = (function cljs$core$fn_14325(this$,key){
var x__10276__auto__ = (((this$ == null))?null:this$);
var m__10277__auto__ = (cljs.core._remove_watch[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__10277__auto__.call(null,this$,key));
} else {
var m__10275__auto__ = (cljs.core._remove_watch["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__10275__auto__.call(null,this$,key));
} else {
throw cljs.core.missing_protocol("IWatchable.-remove-watch",this$);
}
}
});
/**
 * Removes watcher that corresponds to key from this.
 */
cljs.core._remove_watch = (function cljs$core$_remove_watch(this$,key){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_remove_watch$arity$2 == null)))))){
return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);
} else {
return cljs$core$IWatchable$_remove_watch$dyn_14328(this$,key);
}
});


/**
 * Protocol for collections which can transformed to transients.
 * @interface
 */
cljs.core.IEditableCollection = function(){};

var cljs$core$IEditableCollection$_as_transient$dyn_14330 = (function cljs$core$fn_14329(coll){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._as_transient[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10277__auto__.call(null,coll));
} else {
var m__10275__auto__ = (cljs.core._as_transient["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10275__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEditableCollection.-as-transient",coll);
}
}
});
/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core._as_transient = (function cljs$core$_as_transient(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IEditableCollection$_as_transient$arity$1 == null)))))){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
} else {
return cljs$core$IEditableCollection$_as_transient$dyn_14330(coll);
}
});


/**
 * Protocol for adding basic functionality to transient collections.
 * @interface
 */
cljs.core.ITransientCollection = function(){};

var cljs$core$ITransientCollection$_conj_BANG_$dyn_14333 = (function cljs$core$fn_14331(tcoll,val){
var x__10276__auto__ = (((tcoll == null))?null:tcoll);
var m__10277__auto__ = (cljs.core._conj_BANG_[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__10277__auto__.call(null,tcoll,val));
} else {
var m__10275__auto__ = (cljs.core._conj_BANG_["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__10275__auto__.call(null,tcoll,val));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-conj!",tcoll);
}
}
});
/**
 * Adds value val to tcoll and returns tcoll.
 */
cljs.core._conj_BANG_ = (function cljs$core$_conj_BANG_(tcoll,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else {
return cljs$core$ITransientCollection$_conj_BANG_$dyn_14333(tcoll,val);
}
});

var cljs$core$ITransientCollection$_persistent_BANG_$dyn_14334 = (function cljs$core$fn_14332(tcoll){
var x__10276__auto__ = (((tcoll == null))?null:tcoll);
var m__10277__auto__ = (cljs.core._persistent_BANG_[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__10277__auto__.call(null,tcoll));
} else {
var m__10275__auto__ = (cljs.core._persistent_BANG_["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__10275__auto__.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-persistent!",tcoll);
}
}
});
/**
 * Creates a persistent data structure from tcoll and returns it.
 */
cljs.core._persistent_BANG_ = (function cljs$core$_persistent_BANG_(tcoll){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 == null)))))){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
} else {
return cljs$core$ITransientCollection$_persistent_BANG_$dyn_14334(tcoll);
}
});


/**
 * Protocol for adding associativity to transient collections.
 * @interface
 */
cljs.core.ITransientAssociative = function(){};

var cljs$core$ITransientAssociative$_assoc_BANG_$dyn_14336 = (function cljs$core$fn_14335(tcoll,key,val){
var x__10276__auto__ = (((tcoll == null))?null:tcoll);
var m__10277__auto__ = (cljs.core._assoc_BANG_[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__10277__auto__.call(null,tcoll,key,val));
} else {
var m__10275__auto__ = (cljs.core._assoc_BANG_["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__10275__auto__.call(null,tcoll,key,val));
} else {
throw cljs.core.missing_protocol("ITransientAssociative.-assoc!",tcoll);
}
}
});
/**
 * Returns a new transient collection of tcoll with a mapping from key to
 *   val added to it.
 */
cljs.core._assoc_BANG_ = (function cljs$core$_assoc_BANG_(tcoll,key,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 == null)))))){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);
} else {
return cljs$core$ITransientAssociative$_assoc_BANG_$dyn_14336(tcoll,key,val);
}
});


/**
 * Protocol for adding mapping functionality to transient collections.
 * @interface
 */
cljs.core.ITransientMap = function(){};

var cljs$core$ITransientMap$_dissoc_BANG_$dyn_14338 = (function cljs$core$fn_14337(tcoll,key){
var x__10276__auto__ = (((tcoll == null))?null:tcoll);
var m__10277__auto__ = (cljs.core._dissoc_BANG_[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__10277__auto__.call(null,tcoll,key));
} else {
var m__10275__auto__ = (cljs.core._dissoc_BANG_["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__10275__auto__.call(null,tcoll,key));
} else {
throw cljs.core.missing_protocol("ITransientMap.-dissoc!",tcoll);
}
}
});
/**
 * Returns a new transient collection of tcoll without the mapping for key.
 */
cljs.core._dissoc_BANG_ = (function cljs$core$_dissoc_BANG_(tcoll,key){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);
} else {
return cljs$core$ITransientMap$_dissoc_BANG_$dyn_14338(tcoll,key);
}
});


/**
 * Protocol for adding vector functionality to transient collections.
 * @interface
 */
cljs.core.ITransientVector = function(){};

var cljs$core$ITransientVector$_assoc_n_BANG_$dyn_14341 = (function cljs$core$fn_14339(tcoll,n,val){
var x__10276__auto__ = (((tcoll == null))?null:tcoll);
var m__10277__auto__ = (cljs.core._assoc_n_BANG_[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__10277__auto__.call(null,tcoll,n,val));
} else {
var m__10275__auto__ = (cljs.core._assoc_n_BANG_["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__10275__auto__.call(null,tcoll,n,val));
} else {
throw cljs.core.missing_protocol("ITransientVector.-assoc-n!",tcoll);
}
}
});
/**
 * Returns tcoll with value val added at position n.
 */
cljs.core._assoc_n_BANG_ = (function cljs$core$_assoc_n_BANG_(tcoll,n,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 == null)))))){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);
} else {
return cljs$core$ITransientVector$_assoc_n_BANG_$dyn_14341(tcoll,n,val);
}
});

var cljs$core$ITransientVector$_pop_BANG_$dyn_14342 = (function cljs$core$fn_14340(tcoll){
var x__10276__auto__ = (((tcoll == null))?null:tcoll);
var m__10277__auto__ = (cljs.core._pop_BANG_[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__10277__auto__.call(null,tcoll));
} else {
var m__10275__auto__ = (cljs.core._pop_BANG_["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__10275__auto__.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientVector.-pop!",tcoll);
}
}
});
/**
 * Returns tcoll with the last item removed from it.
 */
cljs.core._pop_BANG_ = (function cljs$core$_pop_BANG_(tcoll){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1 == null)))))){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
} else {
return cljs$core$ITransientVector$_pop_BANG_$dyn_14342(tcoll);
}
});


/**
 * Protocol for adding set functionality to a transient collection.
 * @interface
 */
cljs.core.ITransientSet = function(){};

var cljs$core$ITransientSet$_disjoin_BANG_$dyn_14344 = (function cljs$core$fn_14343(tcoll,v){
var x__10276__auto__ = (((tcoll == null))?null:tcoll);
var m__10277__auto__ = (cljs.core._disjoin_BANG_[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__10277__auto__.call(null,tcoll,v));
} else {
var m__10275__auto__ = (cljs.core._disjoin_BANG_["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__10275__auto__.call(null,tcoll,v));
} else {
throw cljs.core.missing_protocol("ITransientSet.-disjoin!",tcoll);
}
}
});
/**
 * Returns tcoll without v.
 */
cljs.core._disjoin_BANG_ = (function cljs$core$_disjoin_BANG_(tcoll,v){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);
} else {
return cljs$core$ITransientSet$_disjoin_BANG_$dyn_14344(tcoll,v);
}
});


/**
 * Protocol for values that can be compared.
 * @interface
 */
cljs.core.IComparable = function(){};

var cljs$core$IComparable$_compare$dyn_14346 = (function cljs$core$fn_14345(x,y){
var x__10276__auto__ = (((x == null))?null:x);
var m__10277__auto__ = (cljs.core._compare[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__10277__auto__.call(null,x,y));
} else {
var m__10275__auto__ = (cljs.core._compare["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__10275__auto__.call(null,x,y));
} else {
throw cljs.core.missing_protocol("IComparable.-compare",x);
}
}
});
/**
 * Returns a negative number, zero, or a positive number when x is logically
 *   'less than', 'equal to', or 'greater than' y.
 */
cljs.core._compare = (function cljs$core$_compare(x,y){
if((((!((x == null)))) && ((!((x.cljs$core$IComparable$_compare$arity$2 == null)))))){
return x.cljs$core$IComparable$_compare$arity$2(x,y);
} else {
return cljs$core$IComparable$_compare$dyn_14346(x,y);
}
});


/**
 * Protocol for accessing the items of a chunk.
 * @interface
 */
cljs.core.IChunk = function(){};

var cljs$core$IChunk$_drop_first$dyn_14348 = (function cljs$core$fn_14347(coll){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._drop_first[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10277__auto__.call(null,coll));
} else {
var m__10275__auto__ = (cljs.core._drop_first["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10275__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunk.-drop-first",coll);
}
}
});
/**
 * Return a new chunk of coll with the first item removed.
 */
cljs.core._drop_first = (function cljs$core$_drop_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunk$_drop_first$arity$1 == null)))))){
return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
} else {
return cljs$core$IChunk$_drop_first$dyn_14348(coll);
}
});


/**
 * Protocol for accessing a collection as sequential chunks.
 * @interface
 */
cljs.core.IChunkedSeq = function(){};

var cljs$core$IChunkedSeq$_chunked_first$dyn_14351 = (function cljs$core$fn_14349(coll){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._chunked_first[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10277__auto__.call(null,coll));
} else {
var m__10275__auto__ = (cljs.core._chunked_first["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10275__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first",coll);
}
}
});
/**
 * Returns the first chunk in coll.
 */
cljs.core._chunked_first = (function cljs$core$_chunked_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedSeq$_chunked_first$arity$1 == null)))))){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
} else {
return cljs$core$IChunkedSeq$_chunked_first$dyn_14351(coll);
}
});

var cljs$core$IChunkedSeq$_chunked_rest$dyn_14352 = (function cljs$core$fn_14350(coll){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._chunked_rest[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10277__auto__.call(null,coll));
} else {
var m__10275__auto__ = (cljs.core._chunked_rest["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10275__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest",coll);
}
}
});
/**
 * Return a new collection of coll with the first chunk removed.
 */
cljs.core._chunked_rest = (function cljs$core$_chunked_rest(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1 == null)))))){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
} else {
return cljs$core$IChunkedSeq$_chunked_rest$dyn_14352(coll);
}
});


/**
 * Protocol for accessing the chunks of a collection.
 * @interface
 */
cljs.core.IChunkedNext = function(){};

var cljs$core$IChunkedNext$_chunked_next$dyn_14354 = (function cljs$core$fn_14353(coll){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._chunked_next[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10277__auto__.call(null,coll));
} else {
var m__10275__auto__ = (cljs.core._chunked_next["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10275__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedNext.-chunked-next",coll);
}
}
});
/**
 * Returns a new collection of coll without the first chunk.
 */
cljs.core._chunked_next = (function cljs$core$_chunked_next(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedNext$_chunked_next$arity$1 == null)))))){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
} else {
return cljs$core$IChunkedNext$_chunked_next$dyn_14354(coll);
}
});


/**
 * Protocol for adding a name.
 * @interface
 */
cljs.core.INamed = function(){};

var cljs$core$INamed$_name$dyn_14357 = (function cljs$core$fn_14355(x){
var x__10276__auto__ = (((x == null))?null:x);
var m__10277__auto__ = (cljs.core._name[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10277__auto__.call(null,x));
} else {
var m__10275__auto__ = (cljs.core._name["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10275__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-name",x);
}
}
});
/**
 * Returns the name String of x.
 */
cljs.core._name = (function cljs$core$_name(x){
if((((!((x == null)))) && ((!((x.cljs$core$INamed$_name$arity$1 == null)))))){
return x.cljs$core$INamed$_name$arity$1(x);
} else {
return cljs$core$INamed$_name$dyn_14357(x);
}
});

var cljs$core$INamed$_namespace$dyn_14358 = (function cljs$core$fn_14356(x){
var x__10276__auto__ = (((x == null))?null:x);
var m__10277__auto__ = (cljs.core._namespace[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10277__auto__.call(null,x));
} else {
var m__10275__auto__ = (cljs.core._namespace["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10275__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-namespace",x);
}
}
});
/**
 * Returns the namespace String of x.
 */
cljs.core._namespace = (function cljs$core$_namespace(x){
if((((!((x == null)))) && ((!((x.cljs$core$INamed$_namespace$arity$1 == null)))))){
return x.cljs$core$INamed$_namespace$arity$1(x);
} else {
return cljs$core$INamed$_namespace$dyn_14358(x);
}
});


/**
 * Marker protocol indicating an atom.
 * @interface
 */
cljs.core.IAtom = function(){};


/**
 * Protocol for adding resetting functionality.
 * @interface
 */
cljs.core.IReset = function(){};

var cljs$core$IReset$_reset_BANG_$dyn_14360 = (function cljs$core$fn_14359(o,new_value){
var x__10276__auto__ = (((o == null))?null:o);
var m__10277__auto__ = (cljs.core._reset_BANG_[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__10277__auto__.call(null,o,new_value));
} else {
var m__10275__auto__ = (cljs.core._reset_BANG_["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__10275__auto__.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IReset.-reset!",o);
}
}
});
/**
 * Sets the value of o to new-value.
 */
cljs.core._reset_BANG_ = (function cljs$core$_reset_BANG_(o,new_value){
if((((!((o == null)))) && ((!((o.cljs$core$IReset$_reset_BANG_$arity$2 == null)))))){
return o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);
} else {
return cljs$core$IReset$_reset_BANG_$dyn_14360(o,new_value);
}
});


/**
 * Protocol for adding swapping functionality.
 * @interface
 */
cljs.core.ISwap = function(){};

var cljs$core$ISwap$_swap_BANG_$dyn_14368 = (function() {
var cljs$core$fn_14361 = null;
var cljs$core$fn_14361__2 = (function (o,f){
var x__10276__auto__ = (((o == null))?null:o);
var m__10277__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__10277__auto__.call(null,o,f));
} else {
var m__10275__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__10275__auto__.call(null,o,f));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
var cljs$core$fn_14361__3 = (function (o,f,a){
var x__10276__auto__ = (((o == null))?null:o);
var m__10277__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__10277__auto__.call(null,o,f,a));
} else {
var m__10275__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__10275__auto__.call(null,o,f,a));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
var cljs$core$fn_14361__4 = (function (o,f,a,b){
var x__10276__auto__ = (((o == null))?null:o);
var m__10277__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$4 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__10277__auto__.call(null,o,f,a,b));
} else {
var m__10275__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$4 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__10275__auto__.call(null,o,f,a,b));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
var cljs$core$fn_14361__5 = (function (o,f,a,b,xs){
var x__10276__auto__ = (((o == null))?null:o);
var m__10277__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$5 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__10277__auto__.call(null,o,f,a,b,xs));
} else {
var m__10275__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$5 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__10275__auto__.call(null,o,f,a,b,xs));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
cljs$core$fn_14361 = function(o,f,a,b,xs){
switch(arguments.length){
case 2:
return cljs$core$fn_14361__2.call(this,o,f);
case 3:
return cljs$core$fn_14361__3.call(this,o,f,a);
case 4:
return cljs$core$fn_14361__4.call(this,o,f,a,b);
case 5:
return cljs$core$fn_14361__5.call(this,o,f,a,b,xs);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14361.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14361__2;
cljs$core$fn_14361.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14361__3;
cljs$core$fn_14361.cljs$core$IFn$_invoke$arity$4 = cljs$core$fn_14361__4;
cljs$core$fn_14361.cljs$core$IFn$_invoke$arity$5 = cljs$core$fn_14361__5;
return cljs$core$fn_14361;
})()
;
/**
 * Swaps the value of o to be (apply f current-value-of-atom args).
 */
cljs.core._swap_BANG_ = (function cljs$core$_swap_BANG_(var_args){
var G__14363 = arguments.length;
switch (G__14363) {
case 2:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14364(o,f){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$2 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_14368.cljs$core$IFn$_invoke$arity$2(o,f);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14365(o,f,a){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$3 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_14368.cljs$core$IFn$_invoke$arity$3(o,f,a);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14366(o,f,a,b){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$4 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_14368.cljs$core$IFn$_invoke$arity$4(o,f,a,b);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_14367(o,f,a,b,xs){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$5 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_14368.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs);
}
}));

(cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5);



/**
 * Protocol for adding volatile functionality.
 * @interface
 */
cljs.core.IVolatile = function(){};

var cljs$core$IVolatile$_vreset_BANG_$dyn_14371 = (function cljs$core$fn_14370(o,new_value){
var x__10276__auto__ = (((o == null))?null:o);
var m__10277__auto__ = (cljs.core._vreset_BANG_[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__10277__auto__.call(null,o,new_value));
} else {
var m__10275__auto__ = (cljs.core._vreset_BANG_["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__10275__auto__.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IVolatile.-vreset!",o);
}
}
});
/**
 * Sets the value of volatile o to new-value without regard for the
 *   current value. Returns new-value.
 */
cljs.core._vreset_BANG_ = (function cljs$core$_vreset_BANG_(o,new_value){
if((((!((o == null)))) && ((!((o.cljs$core$IVolatile$_vreset_BANG_$arity$2 == null)))))){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);
} else {
return cljs$core$IVolatile$_vreset_BANG_$dyn_14371(o,new_value);
}
});


/**
 * Protocol for iterating over a collection.
 * @interface
 */
cljs.core.IIterable = function(){};

var cljs$core$IIterable$_iterator$dyn_14373 = (function cljs$core$fn_14372(coll){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._iterator[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10277__auto__.call(null,coll));
} else {
var m__10275__auto__ = (cljs.core._iterator["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10275__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IIterable.-iterator",coll);
}
}
});
/**
 * Returns an iterator for coll.
 */
cljs.core._iterator = (function cljs$core$_iterator(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIterable$_iterator$arity$1 == null)))))){
return coll.cljs$core$IIterable$_iterator$arity$1(coll);
} else {
return cljs$core$IIterable$_iterator$dyn_14373(coll);
}
});


/**
 * Protocol for persistent or algorithmically defined collections to provide a
 *   means of dropping N items that is more efficient than sequential walking.
 * @interface
 */
cljs.core.IDrop = function(){};

var cljs$core$IDrop$_drop$dyn_14375 = (function cljs$core$fn_14374(coll,n){
var x__10276__auto__ = (((coll == null))?null:coll);
var m__10277__auto__ = (cljs.core._drop[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__10277__auto__.call(null,coll,n));
} else {
var m__10275__auto__ = (cljs.core._drop["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__10275__auto__.call(null,coll,n));
} else {
throw cljs.core.missing_protocol("IDrop.-drop",coll);
}
}
});
/**
 * Returns a collection that is ISequential, ISeq, and IReduce, or nil if past
 *   the end. The number of items to drop n must be > 0. It is also useful if the
 *   returned coll implements IDrop for subsequent use in a partition-like scenario.
 */
cljs.core._drop = (function cljs$core$_drop(coll,n){
if((((!((coll == null)))) && ((!((coll.cljs$core$IDrop$_drop$arity$2 == null)))))){
return coll.cljs$core$IDrop$_drop$arity$2(coll,n);
} else {
return cljs$core$IDrop$_drop$dyn_14375(coll,n);
}
});


/**
* @constructor
 * @implements {cljs.core.IWriter}
*/
cljs.core.StringBufferWriter = (function (sb){
this.sb = sb;
this.cljs$lang$protocol_mask$partition0$ = 1073741824;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = (function cljs$core$fn_14376(_,s){
var self__ = this;
var ___$1 = this;
return self__.sb.append(s);
}));

(cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = (function cljs$core$fn_14377(_){
var self__ = this;
var ___$1 = this;
return null;
}));

(cljs.core.StringBufferWriter.getBasis = (function cljs$core$fn_14378(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"sb","sb",-1249746442,null)], null);
}));

(cljs.core.StringBufferWriter.cljs$lang$type = true);

(cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter");

(cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = (function cljs$core$fn_14379(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/StringBufferWriter");
}));

/**
 * Positional factory function for cljs.core/StringBufferWriter.
 */
cljs.core.__GT_StringBufferWriter = (function cljs$core$__GT_StringBufferWriter(sb){
return (new cljs.core.StringBufferWriter(sb));
});

/**
 * Support so that collections can implement toString without
 * loading all the printing machinery.
 */
cljs.core.pr_str_STAR_ = (function cljs$core$pr_str_STAR_(obj){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,cljs.core.pr_opts());

writer.cljs$core$IWriter$_flush$arity$1(null);

return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb);
});
cljs.core.int_rotate_left = (function cljs$core$int_rotate_left(x,n){
return ((x << n) | (x >>> (- n)));
});
if((((typeof Math !== 'undefined') && (typeof Math.imul !== 'undefined')) && ((!((Math.imul((4294967295),(5)) === (0))))))){
cljs.core.imul = (function cljs$core$imul(a,b){
return Math.imul(a,b);
});
} else {
cljs.core.imul = (function cljs$core$imul(a,b){
var ah = ((a >>> (16)) & (65535));
var al = (a & (65535));
var bh = ((b >>> (16)) & (65535));
var bl = (b & (65535));
return (((al * bl) + ((((ah * bl) + (al * bh)) << (16)) >>> (0))) | (0));
});
}
cljs.core.m3_seed = (0);
cljs.core.m3_C1 = ((3432918353) | (0));
cljs.core.m3_C2 = ((461845907) | (0));
cljs.core.m3_mix_K1 = (function cljs$core$m3_mix_K1(k1){
return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul((k1 | (0)),cljs.core.m3_C1),(15)),cljs.core.m3_C2);
});
cljs.core.m3_mix_H1 = (function cljs$core$m3_mix_H1(h1,k1){
return ((cljs.core.imul(cljs.core.int_rotate_left(((h1 | (0)) ^ (k1 | (0))),(13)),(5)) + ((3864292196) | (0))) | (0));
});
cljs.core.m3_fmix = (function cljs$core$m3_fmix(h1,len){
var h1__$1 = (h1 | (0));
var h1__$2 = (h1__$1 ^ len);
var h1__$3 = (h1__$2 ^ (h1__$2 >>> (16)));
var h1__$4 = cljs.core.imul(h1__$3,((2246822507) | (0)));
var h1__$5 = (h1__$4 ^ (h1__$4 >>> (13)));
var h1__$6 = cljs.core.imul(h1__$5,((3266489909) | (0)));
return (h1__$6 ^ (h1__$6 >>> (16)));
});
cljs.core.m3_hash_int = (function cljs$core$m3_hash_int(in$){
if((in$ === (0))){
return in$;
} else {
var k1 = cljs.core.m3_mix_K1(in$);
var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);
return cljs.core.m3_fmix(h1,(4));
}
});
cljs.core.hash_long = (function cljs$core$hash_long(high,low){
return (high ^ low);
});
cljs.core.hash_double = (function cljs$core$hash_double(f){
var arr = (function (){var G__14380 = (new Float64Array((1)));
(G__14380[(0)] = f);

return G__14380;
})();
var buf = arr.buffer;
var high = (new DataView(buf,(0),(4))).getInt32();
var low = (new DataView(buf,(4),(4))).getInt32();
return cljs.core.hash_long(high,low);
});
cljs.core.m3_hash_unencoded_chars = (function cljs$core$m3_hash_unencoded_chars(in$){
var h1 = (function (){var i = (1);
var h1 = cljs.core.m3_seed;
while(true){
if((i < in$.length)){
var G__14381 = (i + (2));
var G__14382 = cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1((in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) << (16)))));
i = G__14381;
h1 = G__14382;
continue;
} else {
return h1;
}
break;
}
})();
var h1__$1 = ((((in$.length & (1)) === (1)))?(h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt((in$.length - (1))))):h1);
return cljs.core.m3_fmix(h1__$1,cljs.core.imul((2),in$.length));
});



cljs.core.string_hash_cache = ({});
cljs.core.string_hash_cache_count = (0);
cljs.core.hash_string_STAR_ = (function cljs$core$hash_string_STAR_(s){
if((!((s == null)))){
var len = s.length;
if((len > (0))){
var i = (0);
var hash = (0);
while(true){
if((i < len)){
var G__14385 = (i + (1));
var G__14386 = (cljs.core.imul((31),hash) + s.charCodeAt(i));
i = G__14385;
hash = G__14386;
continue;
} else {
return hash;
}
break;
}
} else {
return (0);
}
} else {
return (0);
}
});
cljs.core.add_to_string_hash_cache = (function cljs$core$add_to_string_hash_cache(k){
var h = cljs.core.hash_string_STAR_(k);
cljs.core.goog$module$goog$object.set.call(null,cljs.core.string_hash_cache,k,h);

(cljs.core.string_hash_cache_count = (cljs.core.string_hash_cache_count + (1)));

return h;
});
cljs.core.hash_string = (function cljs$core$hash_string(k){
if((cljs.core.string_hash_cache_count > (255))){
(cljs.core.string_hash_cache = ({}));

(cljs.core.string_hash_cache_count = (0));
} else {
}

if((k == null)){
return (0);
} else {
var h = (cljs.core.string_hash_cache[k]);
if(typeof h === 'number'){
return h;
} else {
return cljs.core.add_to_string_hash_cache(k);
}
}
});
/**
 * Returns the hash code of its argument. Note this is the hash code
 * consistent with =.
 */
cljs.core.hash = (function cljs$core$hash(o){
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (4194304))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IHash$))))?true:false):false)){
return (o.cljs$core$IHash$_hash$arity$1(null) ^ (0));
} else {
if(typeof o === 'number'){
if(isFinite(o)){
if((!(Number.isSafeInteger(o)))){
return cljs.core.hash_double(o);
} else {
return (Math.floor(o) % (2147483647));
}
} else {
var G__14390 = o;
switch (G__14390) {
case Infinity:
return (2146435072);

break;
case -Infinity:
return (-1048576);

break;
default:
return (2146959360);

}
}
} else {
if(o === true){
return (1231);
} else {
if(o === false){
return (1237);
} else {
if(typeof o === 'string'){
return cljs.core.m3_hash_int(cljs.core.hash_string(o));
} else {
if((o instanceof Date)){
return (o.valueOf() ^ (0));
} else {
if((o == null)){
return (0);
} else {
return (cljs.core._hash(o) ^ (0));

}
}
}
}
}
}
}
});
cljs.core.hash_combine = (function cljs$core$hash_combine(seed,hash){
return (seed ^ (((hash + (2654435769)) + (seed << (6))) + (seed >> (2))));
});
/**
 * Evaluates x and tests if it is an instance of the type
 *   c. Returns true or false
 */
cljs.core.instance_QMARK_ = (function cljs$core$instance_QMARK_(c,x){
return (x instanceof c);
});
/**
 * Return true if x is a Symbol
 */
cljs.core.symbol_QMARK_ = (function cljs$core$symbol_QMARK_(x){
return (x instanceof cljs.core.Symbol);
});
cljs.core.hash_symbol = (function cljs$core$hash_symbol(sym){
return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns));
});
cljs.core.compare_symbols = (function cljs$core$compare_symbols(a,b){
if((a.str === b.str)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__9521__auto__ = cljs.core.not(a.ns);
if(and__9521__auto__){
return b.ns;
} else {
return and__9521__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__14392 = a.ns;
var G__14393 = b.ns;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__14392,G__14393);
})();
if(((0) === nsc)){
var G__14394 = a.name;
var G__14395 = b.name;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__14394,G__14395);
} else {
return nsc;
}
}
} else {
var G__14396 = a.name;
var G__14397 = b.name;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__14396,G__14397);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Symbol = (function (ns,name,str,_hash,_meta){
this.ns = ns;
this.name = name;
this.str = str;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2154168321;
this.cljs$lang$protocol_mask$partition1$ = 4096;
});
(cljs.core.Symbol.prototype.toString = (function cljs$core$fn_14399(){
var self__ = this;
var _ = this;
return self__.str;
}));

(cljs.core.Symbol.prototype.equiv = (function cljs$core$fn_14400(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_14401(_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Symbol)){
return (self__.str === other.str);
} else {
return false;
}
}));

(cljs.core.Symbol.prototype.call = (function() {
var cljs$core$fn_14402 = null;
var cljs$core$fn_14402__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym);
});
var cljs$core$fn_14402__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});
cljs$core$fn_14402 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_14402__2.call(this,self__,coll);
case 3:
return cljs$core$fn_14402__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_14402.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14402__2;
cljs$core$fn_14402.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14402__3;
return cljs$core$fn_14402;
})()
);

(cljs.core.Symbol.prototype.apply = (function cljs$core$fn_14403(self__,args14398){
var self__ = this;
var self____$1 = this;
var args__10130__auto__ = cljs.core.aclone(args14398);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10130__auto__.length > (20)))?(function (){var G__14404 = args__10130__auto__.slice((0),(20));
G__14404.push(args__10130__auto__.slice((20)));

return G__14404;
})():args__10130__auto__)));
}));

(cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14405(coll){
var self__ = this;
var sym = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym);
}));

(cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14406(coll,not_found){
var self__ = this;
var sym = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
}));

(cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_14407(_){
var self__ = this;
var ___$1 = this;
return self__._meta;
}));

(cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_14408(_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));
}));

(cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_14409(sym){
var self__ = this;
var sym__$1 = this;
var h__9988__auto__ = self__._hash;
if((!((h__9988__auto__ == null)))){
return h__9988__auto__;
} else {
var h__9988__auto____$1 = cljs.core.hash_symbol(sym__$1);
(self__._hash = h__9988__auto____$1);

return h__9988__auto____$1;
}
}));

(cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = (function cljs$core$fn_14410(_){
var self__ = this;
var ___$1 = this;
return self__.name;
}));

(cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = (function cljs$core$fn_14411(_){
var self__ = this;
var ___$1 = this;
return self__.ns;
}));

(cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function cljs$core$fn_14412(o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,self__.str);
}));

(cljs.core.Symbol.getBasis = (function cljs$core$fn_14413(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns","ns",2082130287,null),new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.Symbol.cljs$lang$type = true);

(cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol");

(cljs.core.Symbol.cljs$lang$ctorPrWriter = (function cljs$core$fn_14414(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/Symbol");
}));

/**
 * Positional factory function for cljs.core/Symbol.
 */
cljs.core.__GT_Symbol = (function cljs$core$__GT_Symbol(ns,name,str,_hash,_meta){
return (new cljs.core.Symbol(ns,name,str,_hash,_meta));
});

/**
 * Returns true if v is of type cljs.core.Var
 */
cljs.core.var_QMARK_ = (function cljs$core$var_QMARK_(v){
return (v instanceof cljs.core.Var);
});
/**
 * Returns a Symbol with the given namespace and name. Arity-1 works
 *   on strings, keywords, and vars.
 */
cljs.core.symbol = (function cljs$core$symbol(var_args){
var G__14416 = arguments.length;
switch (G__14416) {
case 1:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14417(name){
while(true){
if((name instanceof cljs.core.Symbol)){
return name;
} else {
if(typeof name === 'string'){
var idx = name.indexOf("/");
if((idx < (1))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null,name);
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(name.substring((0),idx),name.substring((idx + (1)),name.length));
}
} else {
if(cljs.core.var_QMARK_(name)){
return name.sym;
} else {
if((name instanceof cljs.core.Keyword)){
var G__14420 = name.fqn;
name = G__14420;
continue;
} else {
throw (new Error("no conversion to symbol"));

}
}
}
}
break;
}
}));

(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14418(ns,name){
var sym_str = (((!((ns == null))))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):name);
return (new cljs.core.Symbol(ns,name,sym_str,null,null));
}));

(cljs.core.symbol.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IDeref}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Var = (function (val,sym,_meta){
this.val = val;
this.sym = sym;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 6717441;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Var.prototype.isMacro = (function cljs$core$fn_14422(){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).cljs$lang$macro;
}));

(cljs.core.Var.prototype.toString = (function cljs$core$fn_14423(){
var self__ = this;
var _ = this;
return ["#'",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.sym)].join('');
}));

(cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = (function cljs$core$fn_14424(_){
var self__ = this;
var ___$1 = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
}));

(cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_14425(_){
var self__ = this;
var ___$1 = this;
return self__._meta;
}));

(cljs.core.Var.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_14426(_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Var(self__.val,self__.sym,new_meta));
}));

(cljs.core.Var.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_14427(this$,other){
var self__ = this;
var this$__$1 = this;
if((other instanceof cljs.core.Var)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this$__$1.sym,other.sym);
} else {
return false;
}
}));

(cljs.core.Var.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_14428(_){
var self__ = this;
var ___$1 = this;
return cljs.core.hash_symbol(self__.sym);
}));

(cljs.core.Var.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Var.prototype.call = (function() {
var cljs$core$fn_14429 = null;
var cljs$core$fn_14429__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14430 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14430.cljs$core$IFn$_invoke$arity$0 ? fexpr__14430.cljs$core$IFn$_invoke$arity$0() : fexpr__14430.call(null));
});
var cljs$core$fn_14429__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14431 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14431.cljs$core$IFn$_invoke$arity$1 ? fexpr__14431.cljs$core$IFn$_invoke$arity$1(a) : fexpr__14431.call(null,a));
});
var cljs$core$fn_14429__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14432 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14432.cljs$core$IFn$_invoke$arity$2 ? fexpr__14432.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__14432.call(null,a,b));
});
var cljs$core$fn_14429__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14433 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14433.cljs$core$IFn$_invoke$arity$3 ? fexpr__14433.cljs$core$IFn$_invoke$arity$3(a,b,c) : fexpr__14433.call(null,a,b,c));
});
var cljs$core$fn_14429__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14434 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14434.cljs$core$IFn$_invoke$arity$4 ? fexpr__14434.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : fexpr__14434.call(null,a,b,c,d));
});
var cljs$core$fn_14429__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14435 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14435.cljs$core$IFn$_invoke$arity$5 ? fexpr__14435.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : fexpr__14435.call(null,a,b,c,d,e));
});
var cljs$core$fn_14429__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14436 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14436.cljs$core$IFn$_invoke$arity$6 ? fexpr__14436.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : fexpr__14436.call(null,a,b,c,d,e,f));
});
var cljs$core$fn_14429__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14437 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14437.cljs$core$IFn$_invoke$arity$7 ? fexpr__14437.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : fexpr__14437.call(null,a,b,c,d,e,f,g));
});
var cljs$core$fn_14429__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14438 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14438.cljs$core$IFn$_invoke$arity$8 ? fexpr__14438.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : fexpr__14438.call(null,a,b,c,d,e,f,g,h));
});
var cljs$core$fn_14429__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14439 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14439.cljs$core$IFn$_invoke$arity$9 ? fexpr__14439.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : fexpr__14439.call(null,a,b,c,d,e,f,g,h,i));
});
var cljs$core$fn_14429__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14440 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14440.cljs$core$IFn$_invoke$arity$10 ? fexpr__14440.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : fexpr__14440.call(null,a,b,c,d,e,f,g,h,i,j));
});
var cljs$core$fn_14429__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14441 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14441.cljs$core$IFn$_invoke$arity$11 ? fexpr__14441.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : fexpr__14441.call(null,a,b,c,d,e,f,g,h,i,j,k));
});
var cljs$core$fn_14429__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14442 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14442.cljs$core$IFn$_invoke$arity$12 ? fexpr__14442.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : fexpr__14442.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});
var cljs$core$fn_14429__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14443 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14443.cljs$core$IFn$_invoke$arity$13 ? fexpr__14443.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : fexpr__14443.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});
var cljs$core$fn_14429__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14444 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14444.cljs$core$IFn$_invoke$arity$14 ? fexpr__14444.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : fexpr__14444.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});
var cljs$core$fn_14429__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14445 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14445.cljs$core$IFn$_invoke$arity$15 ? fexpr__14445.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : fexpr__14445.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});
var cljs$core$fn_14429__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14446 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14446.cljs$core$IFn$_invoke$arity$16 ? fexpr__14446.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : fexpr__14446.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});
var cljs$core$fn_14429__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14447 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14447.cljs$core$IFn$_invoke$arity$17 ? fexpr__14447.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : fexpr__14447.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});
var cljs$core$fn_14429__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14448 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14448.cljs$core$IFn$_invoke$arity$18 ? fexpr__14448.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : fexpr__14448.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});
var cljs$core$fn_14429__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14449 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14449.cljs$core$IFn$_invoke$arity$19 ? fexpr__14449.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : fexpr__14449.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});
var cljs$core$fn_14429__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14450 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14450.cljs$core$IFn$_invoke$arity$20 ? fexpr__14450.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : fexpr__14450.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});
var cljs$core$fn_14429__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)),a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
});
cljs$core$fn_14429 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return cljs$core$fn_14429__1.call(this,self__);
case 2:
return cljs$core$fn_14429__2.call(this,self__,a);
case 3:
return cljs$core$fn_14429__3.call(this,self__,a,b);
case 4:
return cljs$core$fn_14429__4.call(this,self__,a,b,c);
case 5:
return cljs$core$fn_14429__5.call(this,self__,a,b,c,d);
case 6:
return cljs$core$fn_14429__6.call(this,self__,a,b,c,d,e);
case 7:
return cljs$core$fn_14429__7.call(this,self__,a,b,c,d,e,f);
case 8:
return cljs$core$fn_14429__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return cljs$core$fn_14429__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return cljs$core$fn_14429__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return cljs$core$fn_14429__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return cljs$core$fn_14429__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return cljs$core$fn_14429__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return cljs$core$fn_14429__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return cljs$core$fn_14429__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return cljs$core$fn_14429__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return cljs$core$fn_14429__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return cljs$core$fn_14429__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return cljs$core$fn_14429__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return cljs$core$fn_14429__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return cljs$core$fn_14429__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return cljs$core$fn_14429__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_14429.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14429__1;
cljs$core$fn_14429.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14429__2;
cljs$core$fn_14429.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14429__3;
cljs$core$fn_14429.cljs$core$IFn$_invoke$arity$4 = cljs$core$fn_14429__4;
cljs$core$fn_14429.cljs$core$IFn$_invoke$arity$5 = cljs$core$fn_14429__5;
cljs$core$fn_14429.cljs$core$IFn$_invoke$arity$6 = cljs$core$fn_14429__6;
cljs$core$fn_14429.cljs$core$IFn$_invoke$arity$7 = cljs$core$fn_14429__7;
cljs$core$fn_14429.cljs$core$IFn$_invoke$arity$8 = cljs$core$fn_14429__8;
cljs$core$fn_14429.cljs$core$IFn$_invoke$arity$9 = cljs$core$fn_14429__9;
cljs$core$fn_14429.cljs$core$IFn$_invoke$arity$10 = cljs$core$fn_14429__10;
cljs$core$fn_14429.cljs$core$IFn$_invoke$arity$11 = cljs$core$fn_14429__11;
cljs$core$fn_14429.cljs$core$IFn$_invoke$arity$12 = cljs$core$fn_14429__12;
cljs$core$fn_14429.cljs$core$IFn$_invoke$arity$13 = cljs$core$fn_14429__13;
cljs$core$fn_14429.cljs$core$IFn$_invoke$arity$14 = cljs$core$fn_14429__14;
cljs$core$fn_14429.cljs$core$IFn$_invoke$arity$15 = cljs$core$fn_14429__15;
cljs$core$fn_14429.cljs$core$IFn$_invoke$arity$16 = cljs$core$fn_14429__16;
cljs$core$fn_14429.cljs$core$IFn$_invoke$arity$17 = cljs$core$fn_14429__17;
cljs$core$fn_14429.cljs$core$IFn$_invoke$arity$18 = cljs$core$fn_14429__18;
cljs$core$fn_14429.cljs$core$IFn$_invoke$arity$19 = cljs$core$fn_14429__19;
cljs$core$fn_14429.cljs$core$IFn$_invoke$arity$20 = cljs$core$fn_14429__20;
cljs$core$fn_14429.cljs$core$IFn$_invoke$arity$21 = cljs$core$fn_14429__21;
cljs$core$fn_14429.cljs$core$IFn$_invoke$arity$22 = cljs$core$fn_14429__22;
return cljs$core$fn_14429;
})()
);

(cljs.core.Var.prototype.apply = (function cljs$core$fn_14451(self__,args14421){
var self__ = this;
var self____$1 = this;
var args__10130__auto__ = cljs.core.aclone(args14421);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10130__auto__.length > (20)))?(function (){var G__14452 = args__10130__auto__.slice((0),(20));
G__14452.push(args__10130__auto__.slice((20)));

return G__14452;
})():args__10130__auto__)));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14453(){
var self__ = this;
var _ = this;
var fexpr__14454 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14454.cljs$core$IFn$_invoke$arity$0 ? fexpr__14454.cljs$core$IFn$_invoke$arity$0() : fexpr__14454.call(null));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14455(a){
var self__ = this;
var _ = this;
var fexpr__14456 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14456.cljs$core$IFn$_invoke$arity$1 ? fexpr__14456.cljs$core$IFn$_invoke$arity$1(a) : fexpr__14456.call(null,a));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14457(a,b){
var self__ = this;
var _ = this;
var fexpr__14458 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14458.cljs$core$IFn$_invoke$arity$2 ? fexpr__14458.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__14458.call(null,a,b));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14459(a,b,c){
var self__ = this;
var _ = this;
var fexpr__14460 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14460.cljs$core$IFn$_invoke$arity$3 ? fexpr__14460.cljs$core$IFn$_invoke$arity$3(a,b,c) : fexpr__14460.call(null,a,b,c));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14461(a,b,c,d){
var self__ = this;
var _ = this;
var fexpr__14462 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14462.cljs$core$IFn$_invoke$arity$4 ? fexpr__14462.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : fexpr__14462.call(null,a,b,c,d));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_14463(a,b,c,d,e){
var self__ = this;
var _ = this;
var fexpr__14464 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14464.cljs$core$IFn$_invoke$arity$5 ? fexpr__14464.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : fexpr__14464.call(null,a,b,c,d,e));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_14465(a,b,c,d,e,f){
var self__ = this;
var _ = this;
var fexpr__14466 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14466.cljs$core$IFn$_invoke$arity$6 ? fexpr__14466.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : fexpr__14466.call(null,a,b,c,d,e,f));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = (function cljs$core$fn_14467(a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
var fexpr__14468 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14468.cljs$core$IFn$_invoke$arity$7 ? fexpr__14468.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : fexpr__14468.call(null,a,b,c,d,e,f,g));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = (function cljs$core$fn_14469(a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
var fexpr__14470 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14470.cljs$core$IFn$_invoke$arity$8 ? fexpr__14470.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : fexpr__14470.call(null,a,b,c,d,e,f,g,h));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = (function cljs$core$fn_14471(a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
var fexpr__14472 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14472.cljs$core$IFn$_invoke$arity$9 ? fexpr__14472.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : fexpr__14472.call(null,a,b,c,d,e,f,g,h,i));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = (function cljs$core$fn_14473(a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
var fexpr__14474 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14474.cljs$core$IFn$_invoke$arity$10 ? fexpr__14474.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : fexpr__14474.call(null,a,b,c,d,e,f,g,h,i,j));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = (function cljs$core$fn_14475(a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
var fexpr__14476 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14476.cljs$core$IFn$_invoke$arity$11 ? fexpr__14476.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : fexpr__14476.call(null,a,b,c,d,e,f,g,h,i,j,k));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = (function cljs$core$fn_14477(a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
var fexpr__14478 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14478.cljs$core$IFn$_invoke$arity$12 ? fexpr__14478.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : fexpr__14478.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = (function cljs$core$fn_14479(a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
var fexpr__14480 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14480.cljs$core$IFn$_invoke$arity$13 ? fexpr__14480.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : fexpr__14480.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = (function cljs$core$fn_14481(a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
var fexpr__14482 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14482.cljs$core$IFn$_invoke$arity$14 ? fexpr__14482.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : fexpr__14482.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = (function cljs$core$fn_14483(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
var fexpr__14484 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14484.cljs$core$IFn$_invoke$arity$15 ? fexpr__14484.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : fexpr__14484.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = (function cljs$core$fn_14485(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
var fexpr__14486 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14486.cljs$core$IFn$_invoke$arity$16 ? fexpr__14486.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : fexpr__14486.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = (function cljs$core$fn_14487(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
var fexpr__14488 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14488.cljs$core$IFn$_invoke$arity$17 ? fexpr__14488.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : fexpr__14488.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = (function cljs$core$fn_14489(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
var fexpr__14490 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14490.cljs$core$IFn$_invoke$arity$18 ? fexpr__14490.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : fexpr__14490.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = (function cljs$core$fn_14491(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
var fexpr__14492 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14492.cljs$core$IFn$_invoke$arity$19 ? fexpr__14492.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : fexpr__14492.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = (function cljs$core$fn_14493(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
var fexpr__14494 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14494.cljs$core$IFn$_invoke$arity$20 ? fexpr__14494.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : fexpr__14494.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = (function cljs$core$fn_14495(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)),a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
}));

(cljs.core.Var.getBasis = (function cljs$core$fn_14496(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"sym","sym",195671222,null),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.Var.cljs$lang$type = true);

(cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var");

(cljs.core.Var.cljs$lang$ctorPrWriter = (function cljs$core$fn_14497(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/Var");
}));

/**
 * Positional factory function for cljs.core/Var.
 */
cljs.core.__GT_Var = (function cljs$core$__GT_Var(val,sym,_meta){
return (new cljs.core.Var(val,sym,_meta));
});



/**
 * Return true if x implements IIterable protocol.
 */
cljs.core.iterable_QMARK_ = (function cljs$core$iterable_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition1$ & (131072))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIterable$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
}
});
/**
 * Return true if x has a JavaScript iterator property
 */
cljs.core.js_iterable_QMARK_ = (function cljs$core$js_iterable_QMARK_(x){
return (((!((x == null)))) && ((!((x[cljs.core.ITER_SYMBOL] == null)))));
});
/**
 * Clone the supplied value which must implement ICloneable.
 */
cljs.core.clone = (function cljs$core$clone(value){
return cljs.core._clone(value);
});
/**
 * Return true if x implements ICloneable protocol.
 */
cljs.core.cloneable_QMARK_ = (function cljs$core$cloneable_QMARK_(value){
if((!((value == null)))){
if((((value.cljs$lang$protocol_mask$partition1$ & (8192))) || ((cljs.core.PROTOCOL_SENTINEL === value.cljs$core$ICloneable$)))){
return true;
} else {
if((!value.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
}
});
/**
 * Returns a seq on the collection. If the collection is
 *   empty, returns nil.  (seq nil) returns nil. seq also works on
 *   Strings.
 */
cljs.core.seq = (function cljs$core$seq(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$))))?true:false):false)){
return coll.cljs$core$ISeqable$_seq$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(typeof coll === 'string'){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(cljs.core.js_iterable_QMARK_(coll)){
return cljs.core.es6_iterator_seq(cljs.core.goog$module$goog$object.get.call(null,coll,cljs.core.ITER_SYMBOL).call(coll));
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,coll)){
return cljs.core._seq(coll);
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll)," is not ISeqable"].join('')));

}
}
}
}
}
}
});
/**
 * Returns the first item in the collection. Calls seq on its
 *   argument. If coll is nil, returns nil.
 */
cljs.core.first = (function cljs$core$first(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return coll.cljs$core$ISeq$_first$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if((s == null)){
return null;
} else {
return cljs.core._first(s);
}
}
}
});
/**
 * Returns a possibly empty seq of the items after the first. Calls seq on its
 *   argument.
 */
cljs.core.rest = (function cljs$core$rest(coll){
if((!((coll == null)))){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return coll.cljs$core$ISeq$_rest$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if(s){
return s.cljs$core$ISeq$_rest$arity$1(null);
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a seq of the items after the first. Calls seq on its
 *   argument.  If there are no more items, returns nil
 */
cljs.core.next = (function cljs$core$next(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$))))?true:false):false)){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
}
});
/**
 * Equality. Returns true if x equals y, false if not. Compares
 *   numbers and collections in a type-independent manner.  Clojure's immutable data
 *   structures define -equiv (and thus =) as a value, not an identity,
 *   comparison.
 */
cljs.core._EQ_ = (function cljs$core$_EQ_(var_args){
var G__14508 = arguments.length;
switch (G__14508) {
case 1:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___14514 = arguments.length;
var i__10857__auto___14515 = (0);
while(true){
if((i__10857__auto___14515 < len__10856__auto___14514)){
args_arr__10885__auto__.push((arguments[i__10857__auto___14515]));

var G__14516 = (i__10857__auto___14515 + (1));
i__10857__auto___14515 = G__14516;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14509(x){
return true;
}));

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14510(x,y){
if((x == null)){
return (y == null);
} else {
return (((x === y)) || (cljs.core._equiv(x,y)));
}
}));

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14511(x,y,more){
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__14517 = y;
var G__14518 = cljs.core.first(more);
var G__14519 = cljs.core.next(more);
x = G__14517;
y = G__14518;
more = G__14519;
continue;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._EQ_.cljs$lang$applyTo = (function cljs$core$fn_14512(seq14505){
var G__14506 = cljs.core.first(seq14505);
var seq14505__$1 = cljs.core.next(seq14505);
var G__14507 = cljs.core.first(seq14505__$1);
var seq14505__$2 = cljs.core.next(seq14505__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14506,G__14507,seq14505__$2);
}));

(cljs.core._EQ_.cljs$lang$maxFixedArity = (2));


/**
* @constructor
*/
cljs.core.ES6Iterator = (function (s){
this.s = s;
});
(cljs.core.ES6Iterator.prototype.next = (function cljs$core$fn_14520(){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var x = cljs.core.first(self__.s);
(self__.s = cljs.core.next(self__.s));

return ({"value": x, "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6Iterator.getBasis = (function cljs$core$fn_14521(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6Iterator.cljs$lang$type = true);

(cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator");

(cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_14522(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/ES6Iterator");
}));

/**
 * Positional factory function for cljs.core/ES6Iterator.
 */
cljs.core.__GT_ES6Iterator = (function cljs$core$__GT_ES6Iterator(s){
return (new cljs.core.ES6Iterator(s));
});

/**
 * Return a ES2015+ compatible iterator for coll.
 */
cljs.core.es6_iterator = (function cljs$core$es6_iterator(coll){
return (new cljs.core.ES6Iterator(cljs.core.seq(coll)));
});

/**
* @constructor
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
*/
cljs.core.ES6IteratorSeq = (function (value,iter,_rest){
this.value = value;
this.iter = iter;
this._rest = _rest;
this.cljs$lang$protocol_mask$partition0$ = 8388672;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_14523(this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_14524(_){
var self__ = this;
var ___$1 = this;
return self__.value;
}));

(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_14525(_){
var self__ = this;
var ___$1 = this;
if((self__._rest == null)){
(self__._rest = cljs.core.es6_iterator_seq(self__.iter));
} else {
}

return self__._rest;
}));

(cljs.core.ES6IteratorSeq.getBasis = (function cljs$core$fn_14526(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"value","value",1946509744,null),new cljs.core.Symbol(null,"iter","iter",-1346195486,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_rest","_rest",-2100466189,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6IteratorSeq.cljs$lang$type = true);

(cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq");

(cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_14527(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/ES6IteratorSeq");
}));

/**
 * Positional factory function for cljs.core/ES6IteratorSeq.
 */
cljs.core.__GT_ES6IteratorSeq = (function cljs$core$__GT_ES6IteratorSeq(value,iter,_rest){
return (new cljs.core.ES6IteratorSeq(value,iter,_rest));
});

/**
 * Given an ES2015+ compatible iterator return a seq.
 */
cljs.core.es6_iterator_seq = (function cljs$core$es6_iterator_seq(iter){
var v = iter.next();
if(cljs.core.truth_(v.done)){
return null;
} else {
return (new cljs.core.ES6IteratorSeq(v.value,iter,null));
}
});
/**
 * Mix final collection hash for ordered or unordered collections.
 * hash-basis is the combined collection hash, count is the number
 * of elements included in the basis. Note this is the hash code
 * consistent with =, different from .hashCode.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.mix_collection_hash = (function cljs$core$mix_collection_hash(hash_basis,count){
var h1 = cljs.core.m3_seed;
var k1 = cljs.core.m3_mix_K1(hash_basis);
var h1__$1 = cljs.core.m3_mix_H1(h1,k1);
return cljs.core.m3_fmix(h1__$1,count);
});
/**
 * Returns the hash code, consistent with =, for an external ordered
 * collection implementing Iterable.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_ordered_coll = (function cljs$core$hash_ordered_coll(coll){
var n = (0);
var hash_code = (1);
var coll__$1 = cljs.core.seq(coll);
while(true){
if((!((coll__$1 == null)))){
var G__14528 = (n + (1));
var G__14529 = ((cljs.core.imul((31),hash_code) + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__14530 = cljs.core.next(coll__$1);
n = G__14528;
hash_code = G__14529;
coll__$1 = G__14530;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash((1),(0));
/**
 * Returns the hash code, consistent with =, for an external unordered
 * collection implementing Iterable. For maps, the iterator should
 * return map entries whose hash is computed as
 *   (hash-ordered-coll [k v]).
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_unordered_coll = (function cljs$core$hash_unordered_coll(coll){
var n = (0);
var hash_code = (0);
var coll__$1 = cljs.core.seq(coll);
while(true){
if((!((coll__$1 == null)))){
var G__14531 = (n + (1));
var G__14532 = ((hash_code + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__14533 = cljs.core.next(coll__$1);
n = G__14531;
hash_code = G__14532;
coll__$1 = G__14533;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash((0),(0));


(cljs.core.ICounted["null"] = true);

(cljs.core._count["null"] = (function cljs$core$fn_14534(_){
return (0);
}));
(Date.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_14535(o,other){
var o__$1 = this;
return (((other instanceof Date)) && ((o__$1.valueOf() === other.valueOf())));
}));

(Date.prototype.cljs$core$IComparable$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$IComparable$_compare$arity$2 = (function cljs$core$fn_14536(this$,other){
var this$__$1 = this;
if((other instanceof Date)){
var G__14537 = this$__$1.valueOf();
var G__14538 = other.valueOf();
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__14537,G__14538);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(this$__$1)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(other)].join('')));
}
}));

/**
 * @interface
 */
cljs.core.Inst = function(){};

var cljs$core$Inst$inst_ms_STAR_$dyn_14540 = (function cljs$core$fn_14539(inst){
var x__10276__auto__ = (((inst == null))?null:inst);
var m__10277__auto__ = (cljs.core.inst_ms_STAR_[goog.typeOf(x__10276__auto__)]);
if((!((m__10277__auto__ == null)))){
return (m__10277__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10277__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__10277__auto__.call(null,inst));
} else {
var m__10275__auto__ = (cljs.core.inst_ms_STAR_["_"]);
if((!((m__10275__auto__ == null)))){
return (m__10275__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10275__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__10275__auto__.call(null,inst));
} else {
throw cljs.core.missing_protocol("Inst.inst-ms*",inst);
}
}
});
cljs.core.inst_ms_STAR_ = (function cljs$core$inst_ms_STAR_(inst){
if((((!((inst == null)))) && ((!((inst.cljs$core$Inst$inst_ms_STAR_$arity$1 == null)))))){
return inst.cljs$core$Inst$inst_ms_STAR_$arity$1(inst);
} else {
return cljs$core$Inst$inst_ms_STAR_$dyn_14540(inst);
}
});

(Date.prototype.cljs$core$Inst$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$Inst$inst_ms_STAR_$arity$1 = (function cljs$core$fn_14541(inst){
var inst__$1 = this;
return inst__$1.getTime();
}));
/**
 * Return the number of milliseconds since January 1, 1970, 00:00:00 GMT
 */
cljs.core.inst_ms = (function cljs$core$inst_ms(inst){
return cljs.core.inst_ms_STAR_(inst);
});
/**
 * Return true if x satisfies Inst
 */
cljs.core.inst_QMARK_ = (function cljs$core$inst_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$Inst$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);
}
});
(cljs.core.IEquiv["number"] = true);

(cljs.core._equiv["number"] = (function cljs$core$fn_14543(x,o){
return (x === o);
}));
(cljs.core.Fn["function"] = true);

(cljs.core.IMeta["function"] = true);

(cljs.core._meta["function"] = (function cljs$core$fn_14544(_){
return null;
}));
(cljs.core.IHash["_"] = true);

(cljs.core._hash["_"] = (function cljs$core$fn_14545(o){
return goog.getUid(o);
}));
/**
 * Returns a number one greater than num.
 */
cljs.core.inc = (function cljs$core$inc(x){
return (x + (1));
});

/**
* @constructor
 * @implements {cljs.core.IDeref}
*/
cljs.core.Reduced = (function (val){
this.val = val;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = (function cljs$core$fn_14546(o){
var self__ = this;
var o__$1 = this;
return self__.val;
}));

(cljs.core.Reduced.getBasis = (function cljs$core$fn_14547(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null)], null);
}));

(cljs.core.Reduced.cljs$lang$type = true);

(cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced");

(cljs.core.Reduced.cljs$lang$ctorPrWriter = (function cljs$core$fn_14548(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/Reduced");
}));

/**
 * Positional factory function for cljs.core/Reduced.
 */
cljs.core.__GT_Reduced = (function cljs$core$__GT_Reduced(val){
return (new cljs.core.Reduced(val));
});

/**
 * Wraps x in a way such that a reduce will terminate with the value x
 */
cljs.core.reduced = (function cljs$core$reduced(x){
return (new cljs.core.Reduced(x));
});
/**
 * Returns true if x is the result of a call to reduced
 */
cljs.core.reduced_QMARK_ = (function cljs$core$reduced_QMARK_(r){
return (r instanceof cljs.core.Reduced);
});
/**
 * If x is already reduced?, returns it, else returns (reduced x)
 */
cljs.core.ensure_reduced = (function cljs$core$ensure_reduced(x){
if(cljs.core.reduced_QMARK_(x)){
return x;
} else {
return cljs.core.reduced(x);
}
});
/**
 * If x is reduced?, returns (deref x), else returns x
 */
cljs.core.unreduced = (function cljs$core$unreduced(x){
if(cljs.core.reduced_QMARK_(x)){
return cljs.core.deref(x);
} else {
return x;
}
});
/**
 * Also reader macro: @var/@atom/@delay. Returns the
 * most-recently-committed value of ref. When applied to a var
 * or atom, returns its current state. When applied to a delay, forces
 * it if not already forced. See also - realized?.
 */
cljs.core.deref = (function cljs$core$deref(o){
return cljs.core._deref(o);
});
/**
 * Accepts any collection which satisfies the ICount and IIndexed protocols and
 * reduces them without incurring seq initialization
 */
cljs.core.ci_reduce = (function cljs$core$ci_reduce(var_args){
var G__14550 = arguments.length;
switch (G__14550) {
case 2:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14551(cicoll,f){
var cnt = cicoll.cljs$core$ICounted$_count$arity$1(null);
if((cnt === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = cicoll.cljs$core$IIndexed$_nth$arity$2(null,(0));
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__14552 = val;
var G__14553 = cicoll.cljs$core$IIndexed$_nth$arity$2(null,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14552,G__14553) : f.call(null,G__14552,G__14553));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14558 = nval;
var G__14559 = (n + (1));
val = G__14558;
n = G__14559;
continue;
}
} else {
return val;
}
break;
}
}
}));

(cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14554(cicoll,f,val){
var cnt = cicoll.cljs$core$ICounted$_count$arity$1(null);
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__14555 = val__$1;
var G__14556 = cicoll.cljs$core$IIndexed$_nth$arity$2(null,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14555,G__14556) : f.call(null,G__14555,G__14556));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14560 = nval;
var G__14561 = (n + (1));
val__$1 = G__14560;
n = G__14561;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.ci_reduce.cljs$lang$maxFixedArity = 3);

cljs.core.array_reduce = (function cljs$core$array_reduce(var_args){
var G__14563 = arguments.length;
switch (G__14563) {
case 2:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14564(arr,f){
var cnt = arr.length;
if((arr.length === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = (arr[(0)]);
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__14565 = val;
var G__14566 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14565,G__14566) : f.call(null,G__14565,G__14566));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14574 = nval;
var G__14575 = (n + (1));
val = G__14574;
n = G__14575;
continue;
}
} else {
return val;
}
break;
}
}
}));

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14567(arr,f,val){
var cnt = arr.length;
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__14568 = val__$1;
var G__14569 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14568,G__14569) : f.call(null,G__14568,G__14569));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14576 = nval;
var G__14577 = (n + (1));
val__$1 = G__14576;
n = G__14577;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14570(arr,f,val,idx){
var cnt = arr.length;
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__14571 = val__$1;
var G__14572 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14571,G__14572) : f.call(null,G__14571,G__14572));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14578 = nval;
var G__14579 = (n + (1));
val__$1 = G__14578;
n = G__14579;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.array_reduce.cljs$lang$maxFixedArity = 4);







/**
 * Returns true if coll implements count in constant time
 */
cljs.core.counted_QMARK_ = (function cljs$core$counted_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICounted$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
}
});
/**
 * Returns true if coll implements nth in constant time
 */
cljs.core.indexed_QMARK_ = (function cljs$core$indexed_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIndexed$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
}
});
cljs.core._indexOf = (function cljs$core$_indexOf(var_args){
var G__14583 = arguments.length;
switch (G__14583) {
case 2:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14584(coll,x){
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
}));

(cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14585(coll,x,start){
var len = cljs.core.count(coll);
if((start >= len)){
return (-1);
} else {
var idx = (((start > (0)))?start:(((start < (0)))?(function (){var x__9884__auto__ = (0);
var y__9885__auto__ = (start + len);
return ((x__9884__auto__ > y__9885__auto__) ? x__9884__auto__ : y__9885__auto__);
})():start
));
while(true){
if((idx < len)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx),x)){
return idx;
} else {
var G__14587 = (idx + (1));
idx = G__14587;
continue;
}
} else {
return (-1);
}
break;
}
}
}));

(cljs.core._indexOf.cljs$lang$maxFixedArity = 3);

cljs.core._lastIndexOf = (function cljs$core$_lastIndexOf(var_args){
var G__14589 = arguments.length;
switch (G__14589) {
case 2:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14590(coll,x){
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
}));

(cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14591(coll,x,start){
var len = cljs.core.count(coll);
if((len === (0))){
return (-1);
} else {
var idx = (((start > (0)))?(function (){var x__9891__auto__ = (len - (1));
var y__9892__auto__ = start;
return ((x__9891__auto__ < y__9892__auto__) ? x__9891__auto__ : y__9892__auto__);
})():(((start < (0)))?(len + start):start
));
while(true){
if((idx >= (0))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx),x)){
return idx;
} else {
var G__14593 = (idx - (1));
idx = G__14593;
continue;
}
} else {
return (-1);
}
break;
}
}
}));

(cljs.core._lastIndexOf.cljs$lang$maxFixedArity = 3);


/**
* @constructor
*/
cljs.core.IndexedSeqIterator = (function (arr,i){
this.arr = arr;
this.i = i;
});
(cljs.core.IndexedSeqIterator.prototype.hasNext = (function cljs$core$fn_14594(){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
}));

(cljs.core.IndexedSeqIterator.prototype.next = (function cljs$core$fn_14595(){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.IndexedSeqIterator.getBasis = (function cljs$core$fn_14596(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.IndexedSeqIterator.cljs$lang$type = true);

(cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator");

(cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_14597(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/IndexedSeqIterator");
}));

/**
 * Positional factory function for cljs.core/IndexedSeqIterator.
 */
cljs.core.__GT_IndexedSeqIterator = (function cljs$core$__GT_IndexedSeqIterator(arr,i){
return (new cljs.core.IndexedSeqIterator(arr,i));
});


/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.IndexedSeq = (function (arr,i,meta){
this.arr = arr;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 166592766;
this.cljs$lang$protocol_mask$partition1$ = 401408;
});
(cljs.core.IndexedSeq.prototype.toString = (function cljs$core$fn_14598(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.IndexedSeq.prototype.equiv = (function cljs$core$fn_14599(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.IndexedSeq.prototype.indexOf = (function() {
var cljs$core$fn_14600 = null;
var cljs$core$fn_14600__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_14600__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_14600 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_14600__1.call(this,x);
case 2:
return cljs$core$fn_14600__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14600.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14600__1;
cljs$core$fn_14600.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14600__2;
return cljs$core$fn_14600;
})()
);

(cljs.core.IndexedSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_14601 = null;
var cljs$core$fn_14601__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_14601__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_14601 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_14601__1.call(this,x);
case 2:
return cljs$core$fn_14601__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14601.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14601__1;
cljs$core$fn_14601.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14601__2;
return cljs$core$fn_14601;
})()
);

(cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_14602(coll,n){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if(((((0) <= i__$1)) && ((i__$1 < self__.arr.length)))){
return (self__.arr[i__$1]);
} else {
throw (new Error("Index out of bounds"));
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_14603(coll,n,not_found){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if(((((0) <= i__$1)) && ((i__$1 < self__.arr.length)))){
return (self__.arr[i__$1]);
} else {
return not_found;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_14604(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_14605(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_14606(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i,self__.meta));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_14607(_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_14608(_){
var self__ = this;
var ___$1 = this;
var x__9884__auto__ = (0);
var y__9885__auto__ = (self__.arr.length - self__.i);
return ((x__9884__auto__ > y__9885__auto__) ? x__9884__auto__ : y__9885__auto__);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_14609(coll){
var self__ = this;
var coll__$1 = this;
var c = coll__$1.cljs$core$ICounted$_count$arity$1(null);
if((c > (0))){
return (new cljs.core.RSeq(coll__$1,(c - (1)),null));
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_14610(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_14611(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_14612(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_14613(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_14614(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_14615(_){
var self__ = this;
var ___$1 = this;
return (self__.arr[self__.i]);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_14616(_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_14617(this$){
var self__ = this;
var this$__$1 = this;
if((self__.i < self__.arr.length)){
return this$__$1;
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_14618(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.IndexedSeq(self__.arr,self__.i,new_meta));
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_14619(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IDrop$_drop$arity$2 = (function cljs$core$fn_14620(coll,n){
var self__ = this;
var coll__$1 = this;
if((n > (0))){
if(((self__.i + n) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + n),null));
} else {
return null;
}
} else {
return coll__$1;
}
}));

(cljs.core.IndexedSeq.getBasis = (function cljs$core$fn_14621(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.IndexedSeq.cljs$lang$type = true);

(cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq");

(cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_14622(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/IndexedSeq");
}));

/**
 * Positional factory function for cljs.core/IndexedSeq.
 */
cljs.core.__GT_IndexedSeq = (function cljs$core$__GT_IndexedSeq(arr,i,meta){
return (new cljs.core.IndexedSeq(arr,i,meta));
});

(cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_14623(){
var this__10717__auto__ = this;
return cljs.core.es6_iterator(this__10717__auto__);
}));
/**
 * Create seq from a primitive JavaScript Array-like.
 */
cljs.core.prim_seq = (function cljs$core$prim_seq(var_args){
var G__14625 = arguments.length;
switch (G__14625) {
case 1:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14626(prim){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim,(0));
}));

(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14627(prim,i){
if((i < prim.length)){
return (new cljs.core.IndexedSeq(prim,i,null));
} else {
return null;
}
}));

(cljs.core.prim_seq.cljs$lang$maxFixedArity = 2);

/**
 * Create a seq from a JavaScript array.
 */
cljs.core.array_seq = (function cljs$core$array_seq(var_args){
var G__14630 = arguments.length;
switch (G__14630) {
case 1:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14631(array){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,(0));
}));

(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14632(array,i){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i);
}));

(cljs.core.array_seq.cljs$lang$maxFixedArity = 2);



/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RSeq = (function (ci,i,meta){
this.ci = ci;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.RSeq.prototype.toString = (function cljs$core$fn_14634(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.RSeq.prototype.equiv = (function cljs$core$fn_14635(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.RSeq.prototype.indexOf = (function() {
var cljs$core$fn_14636 = null;
var cljs$core$fn_14636__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_14636__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_14636 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_14636__1.call(this,x);
case 2:
return cljs$core$fn_14636__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14636.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14636__1;
cljs$core$fn_14636.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14636__2;
return cljs$core$fn_14636;
})()
);

(cljs.core.RSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_14637 = null;
var cljs$core$fn_14637__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_14637__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_14637 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_14637__1.call(this,x);
case 2:
return cljs$core$fn_14637__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14637.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14637__1;
cljs$core$fn_14637.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14637__2;
return cljs$core$fn_14637;
})()
);

(cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_14638(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_14639(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));
}));

(cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_14640(coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return null;
}
}));

(cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_14641(coll){
var self__ = this;
var coll__$1 = this;
return (self__.i + (1));
}));

(cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_14642(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_14643(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_14644(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_14645(col,f){
var self__ = this;
var col__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,col__$1);
}));

(cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_14646(col,f,start){
var self__ = this;
var col__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,col__$1);
}));

(cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_14647(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci,self__.i);
}));

(cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_14648(coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_14649(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_14650(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.RSeq(self__.ci,self__.i,new_meta));
}
}));

(cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_14651(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.RSeq.getBasis = (function cljs$core$fn_14652(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ci","ci",2049808339,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.RSeq.cljs$lang$type = true);

(cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq");

(cljs.core.RSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_14653(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/RSeq");
}));

/**
 * Positional factory function for cljs.core/RSeq.
 */
cljs.core.__GT_RSeq = (function cljs$core$__GT_RSeq(ci,i,meta){
return (new cljs.core.RSeq(ci,i,meta));
});

(cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_14654(){
var this__10717__auto__ = this;
return cljs.core.es6_iterator(this__10717__auto__);
}));
/**
 * Same as (first (next x))
 */
cljs.core.second = (function cljs$core$second(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (first (first x))
 */
cljs.core.ffirst = (function cljs$core$ffirst(coll){
return cljs.core.first(cljs.core.first(coll));
});
/**
 * Same as (next (first x))
 */
cljs.core.nfirst = (function cljs$core$nfirst(coll){
return cljs.core.next(cljs.core.first(coll));
});
/**
 * Same as (first (next x))
 */
cljs.core.fnext = (function cljs$core$fnext(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (next (next x))
 */
cljs.core.nnext = (function cljs$core$nnext(coll){
return cljs.core.next(cljs.core.next(coll));
});
/**
 * Return the last item in coll, in linear time
 */
cljs.core.last = (function cljs$core$last(s){
while(true){
var sn = cljs.core.next(s);
if((!((sn == null)))){
var G__14655 = sn;
s = G__14655;
continue;
} else {
return cljs.core.first(s);
}
break;
}
});
(cljs.core.IEquiv["_"] = true);

(cljs.core._equiv["_"] = (function cljs$core$fn_14656(x,o){
return (x === o);
}));
/**
 * conj[oin]. Returns a new collection with the xs
 *   'added'. (conj nil item) returns (item).
 *   (conj coll) returns coll. (conj) returns [].
 *   The 'addition' may happen at different 'places' depending
 *   on the concrete type.
 */
cljs.core.conj = (function cljs$core$conj(var_args){
var G__14661 = arguments.length;
switch (G__14661) {
case 0:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___14668 = arguments.length;
var i__10857__auto___14669 = (0);
while(true){
if((i__10857__auto___14669 < len__10856__auto___14668)){
args_arr__10885__auto__.push((arguments[i__10857__auto___14669]));

var G__14670 = (i__10857__auto___14669 + (1));
i__10857__auto___14669 = G__14670;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14662(){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14663(coll){
return coll;
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14664(coll,x){
if((!((coll == null)))){
return cljs.core._conj(coll,x);
} else {
return (new cljs.core.List(null,x,null,(1),null));
}
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14665(coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__14671 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
var G__14672 = cljs.core.first(xs);
var G__14673 = cljs.core.next(xs);
coll = G__14671;
x = G__14672;
xs = G__14673;
continue;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
break;
}
}));

/** @this {Function} */
(cljs.core.conj.cljs$lang$applyTo = (function cljs$core$fn_14666(seq14658){
var G__14659 = cljs.core.first(seq14658);
var seq14658__$1 = cljs.core.next(seq14658);
var G__14660 = cljs.core.first(seq14658__$1);
var seq14658__$2 = cljs.core.next(seq14658__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14659,G__14660,seq14658__$2);
}));

(cljs.core.conj.cljs$lang$maxFixedArity = (2));

/**
 * Returns an empty collection of the same category as coll, or nil
 */
cljs.core.empty = (function cljs$core$empty(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IEmptyableCollection$))))?true:false):false)){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(null);
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IEmptyableCollection$))))?true:(((!coll.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IEmptyableCollection,coll):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IEmptyableCollection,coll))){
return cljs.core._empty(coll);
} else {
return null;

}
}
}
});
cljs.core.accumulating_seq_count = (function cljs$core$accumulating_seq_count(coll){
var s = cljs.core.seq(coll);
var acc = (0);
while(true){
if(cljs.core.counted_QMARK_(s)){
return (acc + cljs.core._count(s));
} else {
var G__14676 = cljs.core.next(s);
var G__14677 = (acc + (1));
s = G__14676;
acc = G__14677;
continue;
}
break;
}
});
/**
 * Returns the number of items in the collection. (count nil) returns
 *   0.  Also works on strings, arrays, and Maps
 */
cljs.core.count = (function cljs$core$count(coll){
if((!((coll == null)))){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ICounted$))))?true:false):false)){
return coll.cljs$core$ICounted$_count$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
return coll.length;
} else {
if(typeof coll === 'string'){
return coll.length;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$))))?true:false):false)){
return cljs.core.accumulating_seq_count(coll);
} else {
return cljs.core._count(coll);

}
}
}
}
} else {
return (0);
}
});
cljs.core.linear_traversal_nth = (function cljs$core$linear_traversal_nth(var_args){
var G__14681 = arguments.length;
switch (G__14681) {
case 2:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14682(coll,n){
while(true){
if((coll == null)){
throw (new Error("Index out of bounds"));
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.seq(coll)){
var G__14685 = cljs.core.next(coll);
var G__14686 = (n - (1));
coll = G__14685;
n = G__14686;
continue;
} else {
throw (new Error("Index out of bounds"));

}
}
}
}
break;
}
}));

(cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14683(coll,n,not_found){
while(true){
if((coll == null)){
return not_found;
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
return not_found;
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.seq(coll)){
var G__14687 = cljs.core.next(coll);
var G__14688 = (n - (1));
var G__14689 = not_found;
coll = G__14687;
n = G__14688;
not_found = G__14689;
continue;
} else {
return not_found;

}
}
}
}
break;
}
}));

(cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3);

/**
 * Returns the value at the index. get returns nil if index out of
 *   bounds, nth throws an exception unless not-found is supplied.  nth
 *   also works for strings, arrays, regex Matchers and Lists, and,
 *   in O(n) time, for sequences.
 */
cljs.core.nth = (function cljs$core$nth(var_args){
var G__14691 = arguments.length;
switch (G__14691) {
case 2:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14692(coll,n){
if((!(typeof n === 'number'))){
throw (new Error("Index argument to nth must be a number"));
} else {
if((coll == null)){
return coll;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$))))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
if(cljs.core.array_QMARK_(coll)){
if(((((-1) < n)) && ((n < coll.length)))){
return (coll[(n | (0))]);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(typeof coll === 'string'){
if(((((-1) < n)) && ((n < coll.length)))){
return coll.charAt((n | (0)));
} else {
throw (new Error("Index out of bounds"));
}
} else {
if((function (){var or__9527__auto__ = (((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false);
if(or__9527__auto__){
return or__9527__auto__;
} else {
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISequential$)))){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
if((n < (0))){
throw (new Error("Index out of bounds"));
} else {
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error(["nth not supported on this type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
}));

(cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14696(coll,n,not_found){
if((!(typeof n === 'number'))){
throw (new Error("Index argument to nth must be a number."));
} else {
if((coll == null)){
return not_found;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$))))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$3(null,n,not_found);
} else {
if(cljs.core.array_QMARK_(coll)){
if(((((-1) < n)) && ((n < coll.length)))){
return (coll[(n | (0))]);
} else {
return not_found;
}
} else {
if(typeof coll === 'string'){
if(((((-1) < n)) && ((n < coll.length)))){
return coll.charAt((n | (0)));
} else {
return not_found;
}
} else {
if((function (){var or__9527__auto__ = (((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false);
if(or__9527__auto__){
return or__9527__auto__;
} else {
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISequential$)))){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
if((n < (0))){
return not_found;
} else {
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
throw (new Error(["nth not supported on this type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
}));

(cljs.core.nth.cljs$lang$maxFixedArity = 3);

/**
 * Returns the nth rest of coll, coll when n is 0.
 */
cljs.core.nthrest = (function cljs$core$nthrest(coll,n){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition1$ & (262144))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IDrop$))))?true:false):false)){
if((n > (0))){
var or__9527__auto__ = coll.cljs$core$IDrop$_drop$arity$2(null,Math.ceil(n));
if(cljs.core.truth_(or__9527__auto__)){
return or__9527__auto__;
} else {
return cljs.core.List.EMPTY;
}
} else {
return coll;
}
} else {
var n__$1 = n;
var xs = coll;
while(true){
var temp__5718__auto__ = (((n__$1 > (0))) && (cljs.core.seq(xs)));
if(temp__5718__auto__){
var xs__$1 = temp__5718__auto__;
var G__14702 = (n__$1 - (1));
var G__14703 = cljs.core.rest(xs__$1);
n__$1 = G__14702;
xs = G__14703;
continue;
} else {
return xs;
}
break;
}
}
});
/**
 * Returns the value mapped to key, not-found or nil if key not present
 *   in associative collection, set, string, array, or ILookup instance.
 */
cljs.core.get = (function cljs$core$get(var_args){
var G__14705 = arguments.length;
switch (G__14705) {
case 2:
return cljs.core.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.get.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14706(o,k){
if((o == null)){
return null;
} else {
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$))))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$2(null,k);
} else {
if(cljs.core.array_QMARK_(o)){
if((((!((k == null)))) && ((k < o.length)))){
return (o[(k | (0))]);
} else {
return null;
}
} else {
if(typeof o === 'string'){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return o.charAt((k | (0)));
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o,k);
} else {
return null;

}
}
}
}
}
}));

(cljs.core.get.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14708(o,k,not_found){
if((!((o == null)))){
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$))))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
} else {
if(cljs.core.array_QMARK_(o)){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return (o[(k | (0))]);
} else {
return not_found;
}
} else {
if(typeof o === 'string'){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return o.charAt((k | (0)));
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
} else {
return not_found;

}
}
}
}
} else {
return not_found;
}
}));

(cljs.core.get.cljs$lang$maxFixedArity = 3);



/**
 * assoc[iate]. When applied to a map, returns a new map of the
 * same (hashed/sorted) type, that contains the mapping of key(s) to
 * val(s). When applied to a vector, returns a new vector that
 * contains val at index. Note - index must be <= (count vector).
 */
cljs.core.assoc = (function cljs$core$assoc(var_args){
var G__14716 = arguments.length;
switch (G__14716) {
case 3:
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___14722 = arguments.length;
var i__10857__auto___14723 = (0);
while(true){
if((i__10857__auto___14723 < len__10856__auto___14722)){
args_arr__10885__auto__.push((arguments[i__10857__auto___14723]));

var G__14724 = (i__10857__auto___14723 + (1));
i__10857__auto___14723 = G__14724;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((3) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((3)),(0),null)):null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10886__auto__);

}
});

(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14717(coll,k,v){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IAssociative$))))?true:false):false)){
return coll.cljs$core$IAssociative$_assoc$arity$3(null,k,v);
} else {
if((!((coll == null)))){
return cljs.core._assoc(coll,k,v);
} else {
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k,v]);
}
}
}));

(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14719(coll,k,v,kvs){
while(true){
var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);
if(cljs.core.truth_(kvs)){
var G__14725 = ret;
var G__14726 = cljs.core.first(kvs);
var G__14727 = cljs.core.second(kvs);
var G__14728 = cljs.core.nnext(kvs);
coll = G__14725;
k = G__14726;
v = G__14727;
kvs = G__14728;
continue;
} else {
return ret;
}
break;
}
}));

/** @this {Function} */
(cljs.core.assoc.cljs$lang$applyTo = (function cljs$core$fn_14720(seq14712){
var G__14713 = cljs.core.first(seq14712);
var seq14712__$1 = cljs.core.next(seq14712);
var G__14714 = cljs.core.first(seq14712__$1);
var seq14712__$2 = cljs.core.next(seq14712__$1);
var G__14715 = cljs.core.first(seq14712__$2);
var seq14712__$3 = cljs.core.next(seq14712__$2);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14713,G__14714,G__14715,seq14712__$3);
}));

(cljs.core.assoc.cljs$lang$maxFixedArity = (3));

/**
 * dissoc[iate]. Returns a new map of the same (hashed/sorted) type,
 *   that does not contain a mapping for key(s).
 */
cljs.core.dissoc = (function cljs$core$dissoc(var_args){
var G__14733 = arguments.length;
switch (G__14733) {
case 1:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___14739 = arguments.length;
var i__10857__auto___14740 = (0);
while(true){
if((i__10857__auto___14740 < len__10856__auto___14739)){
args_arr__10885__auto__.push((arguments[i__10857__auto___14740]));

var G__14741 = (i__10857__auto___14740 + (1));
i__10857__auto___14740 = G__14741;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14734(coll){
return coll;
}));

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14735(coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._dissoc(coll,k);
}
}));

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14736(coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__14742 = ret;
var G__14743 = cljs.core.first(ks);
var G__14744 = cljs.core.next(ks);
coll = G__14742;
k = G__14743;
ks = G__14744;
continue;
} else {
return ret;
}
}
break;
}
}));

/** @this {Function} */
(cljs.core.dissoc.cljs$lang$applyTo = (function cljs$core$fn_14737(seq14730){
var G__14731 = cljs.core.first(seq14730);
var seq14730__$1 = cljs.core.next(seq14730);
var G__14732 = cljs.core.first(seq14730__$1);
var seq14730__$2 = cljs.core.next(seq14730__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14731,G__14732,seq14730__$2);
}));

(cljs.core.dissoc.cljs$lang$maxFixedArity = (2));

/**
 * Return true if f is a JavaScript function or satisfies the Fn protocol.
 */
cljs.core.fn_QMARK_ = (function cljs$core$fn_QMARK_(f){
var or__9527__auto__ = typeof f === 'function';
if(or__9527__auto__){
return or__9527__auto__;
} else {
if((!((f == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$Fn$)))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
}
}
});

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.MetaFn = (function (afn,meta){
this.afn = afn;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 393217;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_14747(_){
var self__ = this;
var ___$1 = this;
return self__.meta;
}));

(cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_14748(_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.MetaFn(self__.afn,new_meta));
}));

(cljs.core.MetaFn.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.MetaFn.prototype.call = (function() {
var cljs$core$fn_14749 = null;
var cljs$core$fn_14749__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});
var cljs$core$fn_14749__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));
});
var cljs$core$fn_14749__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));
});
var cljs$core$fn_14749__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));
});
var cljs$core$fn_14749__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));
});
var cljs$core$fn_14749__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));
});
var cljs$core$fn_14749__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));
});
var cljs$core$fn_14749__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));
});
var cljs$core$fn_14749__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));
});
var cljs$core$fn_14749__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));
});
var cljs$core$fn_14749__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));
});
var cljs$core$fn_14749__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));
});
var cljs$core$fn_14749__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});
var cljs$core$fn_14749__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});
var cljs$core$fn_14749__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});
var cljs$core$fn_14749__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});
var cljs$core$fn_14749__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});
var cljs$core$fn_14749__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});
var cljs$core$fn_14749__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});
var cljs$core$fn_14749__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});
var cljs$core$fn_14749__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});
var cljs$core$fn_14749__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(self__.afn,a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
});
cljs$core$fn_14749 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return cljs$core$fn_14749__1.call(this,self__);
case 2:
return cljs$core$fn_14749__2.call(this,self__,a);
case 3:
return cljs$core$fn_14749__3.call(this,self__,a,b);
case 4:
return cljs$core$fn_14749__4.call(this,self__,a,b,c);
case 5:
return cljs$core$fn_14749__5.call(this,self__,a,b,c,d);
case 6:
return cljs$core$fn_14749__6.call(this,self__,a,b,c,d,e);
case 7:
return cljs$core$fn_14749__7.call(this,self__,a,b,c,d,e,f);
case 8:
return cljs$core$fn_14749__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return cljs$core$fn_14749__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return cljs$core$fn_14749__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return cljs$core$fn_14749__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return cljs$core$fn_14749__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return cljs$core$fn_14749__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return cljs$core$fn_14749__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return cljs$core$fn_14749__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return cljs$core$fn_14749__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return cljs$core$fn_14749__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return cljs$core$fn_14749__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return cljs$core$fn_14749__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return cljs$core$fn_14749__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return cljs$core$fn_14749__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return cljs$core$fn_14749__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_14749.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14749__1;
cljs$core$fn_14749.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14749__2;
cljs$core$fn_14749.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14749__3;
cljs$core$fn_14749.cljs$core$IFn$_invoke$arity$4 = cljs$core$fn_14749__4;
cljs$core$fn_14749.cljs$core$IFn$_invoke$arity$5 = cljs$core$fn_14749__5;
cljs$core$fn_14749.cljs$core$IFn$_invoke$arity$6 = cljs$core$fn_14749__6;
cljs$core$fn_14749.cljs$core$IFn$_invoke$arity$7 = cljs$core$fn_14749__7;
cljs$core$fn_14749.cljs$core$IFn$_invoke$arity$8 = cljs$core$fn_14749__8;
cljs$core$fn_14749.cljs$core$IFn$_invoke$arity$9 = cljs$core$fn_14749__9;
cljs$core$fn_14749.cljs$core$IFn$_invoke$arity$10 = cljs$core$fn_14749__10;
cljs$core$fn_14749.cljs$core$IFn$_invoke$arity$11 = cljs$core$fn_14749__11;
cljs$core$fn_14749.cljs$core$IFn$_invoke$arity$12 = cljs$core$fn_14749__12;
cljs$core$fn_14749.cljs$core$IFn$_invoke$arity$13 = cljs$core$fn_14749__13;
cljs$core$fn_14749.cljs$core$IFn$_invoke$arity$14 = cljs$core$fn_14749__14;
cljs$core$fn_14749.cljs$core$IFn$_invoke$arity$15 = cljs$core$fn_14749__15;
cljs$core$fn_14749.cljs$core$IFn$_invoke$arity$16 = cljs$core$fn_14749__16;
cljs$core$fn_14749.cljs$core$IFn$_invoke$arity$17 = cljs$core$fn_14749__17;
cljs$core$fn_14749.cljs$core$IFn$_invoke$arity$18 = cljs$core$fn_14749__18;
cljs$core$fn_14749.cljs$core$IFn$_invoke$arity$19 = cljs$core$fn_14749__19;
cljs$core$fn_14749.cljs$core$IFn$_invoke$arity$20 = cljs$core$fn_14749__20;
cljs$core$fn_14749.cljs$core$IFn$_invoke$arity$21 = cljs$core$fn_14749__21;
cljs$core$fn_14749.cljs$core$IFn$_invoke$arity$22 = cljs$core$fn_14749__22;
return cljs$core$fn_14749;
})()
);

(cljs.core.MetaFn.prototype.apply = (function cljs$core$fn_14750(self__,args14746){
var self__ = this;
var self____$1 = this;
var args__10130__auto__ = cljs.core.aclone(args14746);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10130__auto__.length > (20)))?(function (){var G__14751 = args__10130__auto__.slice((0),(20));
G__14751.push(args__10130__auto__.slice((20)));

return G__14751;
})():args__10130__auto__)));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14752(){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14753(a){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14754(a,b){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14755(a,b,c){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14756(a,b,c,d){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_14757(a,b,c,d,e){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_14758(a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function cljs$core$fn_14759(a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function cljs$core$fn_14760(a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function cljs$core$fn_14761(a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function cljs$core$fn_14762(a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function cljs$core$fn_14763(a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function cljs$core$fn_14764(a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function cljs$core$fn_14765(a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function cljs$core$fn_14766(a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function cljs$core$fn_14767(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function cljs$core$fn_14768(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function cljs$core$fn_14769(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function cljs$core$fn_14770(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function cljs$core$fn_14771(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function cljs$core$fn_14772(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function cljs$core$fn_14773(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(self__.afn,a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
}));

(cljs.core.MetaFn.getBasis = (function cljs$core$fn_14774(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.MetaFn.cljs$lang$type = true);

(cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn");

(cljs.core.MetaFn.cljs$lang$ctorPrWriter = (function cljs$core$fn_14775(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/MetaFn");
}));

/**
 * Positional factory function for cljs.core/MetaFn.
 */
cljs.core.__GT_MetaFn = (function cljs$core$__GT_MetaFn(afn,meta){
return (new cljs.core.MetaFn(afn,meta));
});

/**
 * Returns an object of the same type and value as obj, with
 *   map m as its metadata.
 */
cljs.core.with_meta = (function cljs$core$with_meta(o,meta){
if(typeof o === 'function'){
return (new cljs.core.MetaFn(o,meta));
} else {
if((o == null)){
return null;
} else {
return cljs.core._with_meta(o,meta);
}
}
});
/**
 * Returns the metadata of obj, returns nil if there is no metadata.
 */
cljs.core.meta = (function cljs$core$meta(o){
if((function (){var and__9521__auto__ = (!((o == null)));
if(and__9521__auto__){
if((!((o == null)))){
if((((o.cljs$lang$protocol_mask$partition0$ & (131072))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMeta$)))){
return true;
} else {
if((!o.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
}
} else {
return and__9521__auto__;
}
})()){
return cljs.core._meta(o);
} else {
return null;
}
});
/**
 * For a list or queue, same as first, for a vector, same as, but much
 *   more efficient than, last. If the collection is empty, returns nil.
 */
cljs.core.peek = (function cljs$core$peek(coll){
if((coll == null)){
return null;
} else {
return cljs.core._peek(coll);
}
});
/**
 * For a list or queue, returns a new list/queue without the first
 *   item, for a vector, returns a new vector without the last item.
 *   Note - not the same as next/butlast.
 */
cljs.core.pop = (function cljs$core$pop(coll){
if((coll == null)){
return null;
} else {
return cljs.core._pop(coll);
}
});
/**
 * disj[oin]. Returns a new set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj = (function cljs$core$disj(var_args){
var G__14781 = arguments.length;
switch (G__14781) {
case 1:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___14787 = arguments.length;
var i__10857__auto___14788 = (0);
while(true){
if((i__10857__auto___14788 < len__10856__auto___14787)){
args_arr__10885__auto__.push((arguments[i__10857__auto___14788]));

var G__14789 = (i__10857__auto___14788 + (1));
i__10857__auto___14788 = G__14789;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14782(coll){
return coll;
}));

(cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14783(coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._disjoin(coll,k);
}
}));

(cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14784(coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__14790 = ret;
var G__14791 = cljs.core.first(ks);
var G__14792 = cljs.core.next(ks);
coll = G__14790;
k = G__14791;
ks = G__14792;
continue;
} else {
return ret;
}
}
break;
}
}));

/** @this {Function} */
(cljs.core.disj.cljs$lang$applyTo = (function cljs$core$fn_14785(seq14778){
var G__14779 = cljs.core.first(seq14778);
var seq14778__$1 = cljs.core.next(seq14778);
var G__14780 = cljs.core.first(seq14778__$1);
var seq14778__$2 = cljs.core.next(seq14778__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14779,G__14780,seq14778__$2);
}));

(cljs.core.disj.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if coll has no items. To check the emptiness of a seq,
 *   please use the idiom (seq x) rather than (not (empty? x))
 */
cljs.core.empty_QMARK_ = (function cljs$core$empty_QMARK_(coll){
if((coll == null)){
return true;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ICounted$))))?true:(((!coll.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,coll):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,coll))){
return (cljs.core._count(coll) === (0));
} else {
return cljs.core.not(cljs.core.seq(coll));

}
}
});
/**
 * Returns true if x satisfies ICollection
 */
cljs.core.coll_QMARK_ = (function cljs$core$coll_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (8))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICollection$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
}
}
});
/**
 * Returns true if x satisfies ISet
 */
cljs.core.set_QMARK_ = (function cljs$core$set_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
}
}
});
/**
 * Returns true if coll implements IAssociative
 */
cljs.core.associative_QMARK_ = (function cljs$core$associative_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IAssociative$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
}
});
/**
 * Returns true if coll implements IFind
 */
cljs.core.ifind_QMARK_ = (function cljs$core$ifind_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IFind$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x);
}
});
/**
 * Returns true if coll satisfies ISequential
 */
cljs.core.sequential_QMARK_ = (function cljs$core$sequential_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
}
});
/**
 * Returns true if coll satisfies ISorted
 */
cljs.core.sorted_QMARK_ = (function cljs$core$sorted_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (268435456))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISorted$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
}
});
/**
 * Returns true if coll satisfies IReduce
 */
cljs.core.reduceable_QMARK_ = (function cljs$core$reduceable_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IReduce$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
}
});
/**
 * Return true if x satisfies IMap
 */
cljs.core.map_QMARK_ = (function cljs$core$map_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
}
}
});
/**
 * Return true if x satisfies IRecord
 */
cljs.core.record_QMARK_ = (function cljs$core$record_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (67108864))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IRecord$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
}
});
/**
 * Return true if x satisfies IVector
 */
cljs.core.vector_QMARK_ = (function cljs$core$vector_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16384))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IVector$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
}
});

/**
 * Return true if x satisfies IChunkedSeq.
 */
cljs.core.chunked_seq_QMARK_ = (function cljs$core$chunked_seq_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition1$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IChunkedSeq$)))){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Create JavaSript object from an even number arguments representing
 *   interleaved keys and values.
 */
cljs.core.js_obj = (function cljs$core$js_obj(var_args){
var G__14807 = arguments.length;
switch (G__14807) {
case 0:
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___14814 = arguments.length;
var i__10857__auto___14815 = (0);
while(true){
if((i__10857__auto___14815 < len__10856__auto___14814)){
args_arr__10885__auto__.push((arguments[i__10857__auto___14815]));

var G__14816 = (i__10857__auto___14815 + (1));
i__10857__auto___14815 = G__14816;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((0) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((0)),(0),null)):null);
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__10886__auto__);

}
});

(cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14808(){
return ({});
}));

(cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14811(keyvals){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.goog$module$goog$object.create,keyvals);
}));

/** @this {Function} */
(cljs.core.js_obj.cljs$lang$applyTo = (function cljs$core$fn_14812(seq14806){
var self__10842__auto__ = this;
return self__10842__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq14806));
}));

(cljs.core.js_obj.cljs$lang$maxFixedArity = (0));

/**
 * Return the JavaScript keys for an object.
 */
cljs.core.js_keys = (function cljs$core$js_keys(obj){
return cljs.core.goog$module$goog$object.getKeys.call(null,obj);
});
/**
 * Delete a property from a JavaScript object.
 *   Returns true upon success, false otherwise.
 */
cljs.core.js_delete = (function cljs$core$js_delete(obj,key){
return delete obj[key];
});
cljs.core.array_copy = (function cljs$core$array_copy(from,i,to,j,len){
var i__$1 = i;
var j__$1 = j;
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__14817 = (i__$1 + (1));
var G__14818 = (j__$1 + (1));
var G__14819 = (len__$1 - (1));
i__$1 = G__14817;
j__$1 = G__14818;
len__$1 = G__14819;
continue;
}
break;
}
});
cljs.core.array_copy_downward = (function cljs$core$array_copy_downward(from,i,to,j,len){
var i__$1 = (i + (len - (1)));
var j__$1 = (j + (len - (1)));
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__14820 = (i__$1 - (1));
var G__14821 = (j__$1 - (1));
var G__14822 = (len__$1 - (1));
i__$1 = G__14820;
j__$1 = G__14821;
len__$1 = G__14822;
continue;
}
break;
}
});
cljs.core.lookup_sentinel = ({});
/**
 * Returns true if x is the value false, false otherwise.
 */
cljs.core.false_QMARK_ = (function cljs$core$false_QMARK_(x){
return x === false;
});
/**
 * Returns true if x is the value true, false otherwise.
 */
cljs.core.true_QMARK_ = (function cljs$core$true_QMARK_(x){
return x === true;
});
/**
 * Return true if x is a Boolean
 */
cljs.core.boolean_QMARK_ = (function cljs$core$boolean_QMARK_(x){
return ((x === true) || (x === false));
});
/**
 * Returns true if x identical to the JavaScript undefined value.
 */
cljs.core.undefined_QMARK_ = (function cljs$core$undefined_QMARK_(x){
return (void 0 === x);
});
/**
 * Return true if s satisfies ISeq
 */
cljs.core.seq_QMARK_ = (function cljs$core$seq_QMARK_(s){
if((s == null)){
return false;
} else {
if((!((s == null)))){
if((((s.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeq$)))){
return true;
} else {
if((!s.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
}
}
});
/**
 * Return true if the seq function is supported for s
 */
cljs.core.seqable_QMARK_ = (function cljs$core$seqable_QMARK_(s){
var or__9527__auto__ = (s == null);
if(or__9527__auto__){
return or__9527__auto__;
} else {
var or__9527__auto____$1 = (((!((s == null))))?(((((s.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeqable$))))?true:(((!s.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s));
if(or__9527__auto____$1){
return or__9527__auto____$1;
} else {
return ((cljs.core.array_QMARK_(s)) || (typeof s === 'string'));
}
}
});
/**
 * Coerce to boolean
 */
cljs.core.boolean$ = (function cljs$core$boolean(x){
if((x == null)){
return false;
} else {
if(x === false){
return false;
} else {
return true;

}
}
});
/**
 * Returns true if f returns true for fn? or satisfies IFn.
 */
cljs.core.ifn_QMARK_ = (function cljs$core$ifn_QMARK_(f){
var or__9527__auto__ = cljs.core.fn_QMARK_(f);
if(or__9527__auto__){
return or__9527__auto__;
} else {
if((!((f == null)))){
if((((f.cljs$lang$protocol_mask$partition0$ & (1))) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$IFn$)))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
}
}
});
/**
 * Returns true if n is a JavaScript number with no decimal part.
 */
cljs.core.integer_QMARK_ = (function cljs$core$integer_QMARK_(n){
return ((typeof n === 'number') && ((((!(isNaN(n)))) && ((((!((n === Infinity)))) && ((parseFloat(n) === parseInt(n,(10)))))))));
});
/**
 * INTERNAL: do not use
 */
cljs.core.LongImpl = cljs.core.goog$module$goog$math$Long;
/**
 * Return true if x satisfies integer? or is an instance of goog.math.Integer
 * or goog.math.Long.
 */
cljs.core.int_QMARK_ = (function cljs$core$int_QMARK_(x){
return ((cljs.core.integer_QMARK_(x)) || ((((x instanceof goog.math.Integer)) || ((x instanceof cljs.core.goog$module$goog$math$Long)))));
});
/**
 * Return true if x satisfies int? and is positive.
 */
cljs.core.pos_int_QMARK_ = (function cljs$core$pos_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (x > (0));
} else {
if((x instanceof goog.math.Integer)){
return ((cljs.core.not(x.isNegative())) && (cljs.core.not(x.isZero())));
} else {
if((x instanceof cljs.core.goog$module$goog$math$Long)){
return ((cljs.core.not(x.isNegative())) && (cljs.core.not(x.isZero())));
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is negative.
 */
cljs.core.neg_int_QMARK_ = (function cljs$core$neg_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (x < (0));
} else {
if((x instanceof goog.math.Integer)){
return x.isNegative();
} else {
if((x instanceof cljs.core.goog$module$goog$math$Long)){
return x.isNegative();
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is a natural integer value.
 */
cljs.core.nat_int_QMARK_ = (function cljs$core$nat_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (!((x < (0))));
} else {
if((x instanceof goog.math.Integer)){
return cljs.core.not(x.isNegative());
} else {
if((x instanceof cljs.core.goog$module$goog$math$Long)){
return cljs.core.not(x.isNegative());
} else {
return false;

}
}
}
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.float_QMARK_ = (function cljs$core$float_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.double_QMARK_ = (function cljs$core$double_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for Infinity and -Infinity values.
 */
cljs.core.infinite_QMARK_ = (function cljs$core$infinite_QMARK_(x){
return (((x === Number.POSITIVE_INFINITY)) || ((x === Number.NEGATIVE_INFINITY)));
});
/**
 * Returns true if key is present in the given collection, otherwise
 *   returns false.  Note that for numerically indexed collections like
 *   vectors and arrays, this tests if the numeric key is within the
 *   range of indexes. 'contains?' operates constant or logarithmic time;
 *   it will not perform a linear search for a value.  See also 'some'.
 */
cljs.core.contains_QMARK_ = (function cljs$core$contains_QMARK_(coll,v){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IAssociative$))))?true:false):false)){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(null,v);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,coll)){
return cljs.core._contains_key_QMARK_(coll,v);
} else {
if((cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return false;
} else {
return true;

}
}
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core.find = (function cljs$core$find(coll,k){
if(cljs.core.ifind_QMARK_(coll)){
return cljs.core._find(coll,k);
} else {
if((((!((coll == null)))) && (((cljs.core.associative_QMARK_(coll)) && (cljs.core.contains_QMARK_(coll,k)))))){
return (new cljs.core.MapEntry(k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k),null));
} else {
return null;
}
}
});
/**
 * Returns true if no two of the arguments are =
 */
cljs.core.distinct_QMARK_ = (function cljs$core$distinct_QMARK_(var_args){
var G__14833 = arguments.length;
switch (G__14833) {
case 1:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___14839 = arguments.length;
var i__10857__auto___14840 = (0);
while(true){
if((i__10857__auto___14840 < len__10856__auto___14839)){
args_arr__10885__auto__.push((arguments[i__10857__auto___14840]));

var G__14841 = (i__10857__auto___14840 + (1));
i__10857__auto___14840 = G__14841;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14834(x){
return true;
}));

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14835(x,y){
return (!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)));
}));

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14836(x,y,more){
if((!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)))){
var s = cljs.core.PersistentHashSet.createAsIfByAssoc([x,y]);
var xs = more;
while(true){
var x__$1 = cljs.core.first(xs);
var etc = cljs.core.next(xs);
if(cljs.core.truth_(xs)){
if(cljs.core.contains_QMARK_(s,x__$1)){
return false;
} else {
var G__14842 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);
var G__14843 = etc;
s = G__14842;
xs = G__14843;
continue;
}
} else {
return true;
}
break;
}
} else {
return false;
}
}));

/** @this {Function} */
(cljs.core.distinct_QMARK_.cljs$lang$applyTo = (function cljs$core$fn_14837(seq14830){
var G__14831 = cljs.core.first(seq14830);
var seq14830__$1 = cljs.core.next(seq14830);
var G__14832 = cljs.core.first(seq14830__$1);
var seq14830__$2 = cljs.core.next(seq14830__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14831,G__14832,seq14830__$2);
}));

(cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = (2));

/**
 * Comparator. Returns a negative number, zero, or a positive number
 *   when x is logically 'less than', 'equal to', or 'greater than'
 *   y. Uses IComparable if available and google.array.defaultCompare for objects
 *  of the same type and special-cases nil to be less than any other object.
 */
cljs.core.compare = (function cljs$core$compare(x,y){
if((x === y)){
return (0);
} else {
if((x == null)){
return (-1);
} else {
if((y == null)){
return (1);
} else {
if(typeof x === 'number'){
if(typeof y === 'number'){
return cljs.core.goog$module$goog$array.defaultCompare.call(null,x,y);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join('')));
}
} else {
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition1$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IComparable$))))?true:(((!x.cljs$lang$protocol_mask$partition1$))?cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x))){
return cljs.core._compare(x,y);
} else {
if(((((typeof x === 'string') || (((cljs.core.array_QMARK_(x)) || (((x === true) || (x === false))))))) && ((cljs.core.type(x) === cljs.core.type(y))))){
return cljs.core.goog$module$goog$array.defaultCompare.call(null,x,y);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join('')));
}

}
}
}
}
}
});
/**
 * Compare indexed collection.
 */
cljs.core.compare_indexed = (function cljs$core$compare_indexed(var_args){
var G__14846 = arguments.length;
switch (G__14846) {
case 2:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14847(xs,ys){
var xl = cljs.core.count(xs);
var yl = cljs.core.count(ys);
if((xl < yl)){
return (-1);
} else {
if((xl > yl)){
return (1);
} else {
if((xl === (0))){
return (0);
} else {
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,(0));

}
}
}
}));

(cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14848(xs,ys,len,n){
while(true){
var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));
if((((d === (0))) && (((n + (1)) < len)))){
var G__14850 = xs;
var G__14851 = ys;
var G__14852 = len;
var G__14853 = (n + (1));
xs = G__14850;
ys = G__14851;
len = G__14852;
n = G__14853;
continue;
} else {
return d;
}
break;
}
}));

(cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4);

/**
 * Given a fn that might be boolean valued or a comparator,
 * return a fn that is a comparator.
 */
cljs.core.fn__GT_comparator = (function cljs$core$fn__GT_comparator(f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare)){
return cljs.core.compare;
} else {
return (function cljs$core$fn__GT_comparator_$_fn_14854(x,y){
var r = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
if(typeof r === 'number'){
return r;
} else {
if(cljs.core.truth_(r)){
return (-1);
} else {
if(cljs.core.truth_((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(y,x) : f.call(null,y,x)))){
return (1);
} else {
return (0);
}
}
}
});
}
});
/**
 * Returns a sorted sequence of the items in coll. Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort = (function cljs$core$sort(var_args){
var G__14856 = arguments.length;
switch (G__14856) {
case 1:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14857(coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll);
}));

(cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14858(comp,coll){
if(cljs.core.seq(coll)){
var a = cljs.core.to_array(coll);
var G__14859_14862 = a;
var G__14860_14863 = cljs.core.fn__GT_comparator(comp);
cljs.core.goog$module$goog$array.stableSort.call(null,G__14859_14862,G__14860_14863);

return cljs.core.with_meta(cljs.core.seq(a),cljs.core.meta(coll));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.sort.cljs$lang$maxFixedArity = 2);

/**
 * Returns a sorted sequence of the items in coll, where the sort
 * order is determined by comparing (keyfn item).  Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort_by = (function cljs$core$sort_by(var_args){
var G__14865 = arguments.length;
switch (G__14865) {
case 2:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14866(keyfn,coll){
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll);
}));

(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14867(keyfn,comp,coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function cljs$core$fn_14867_$_fn_14868(x,y){
var G__14870 = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(x) : keyfn.call(null,x));
var G__14871 = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(y) : keyfn.call(null,y));
var fexpr__14869 = cljs.core.fn__GT_comparator(comp);
return (fexpr__14869.cljs$core$IFn$_invoke$arity$2 ? fexpr__14869.cljs$core$IFn$_invoke$arity$2(G__14870,G__14871) : fexpr__14869.call(null,G__14870,G__14871));
}),coll);
}));

(cljs.core.sort_by.cljs$lang$maxFixedArity = 3);

cljs.core.seq_reduce = (function cljs$core$seq_reduce(var_args){
var G__14874 = arguments.length;
switch (G__14874) {
case 2:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14875(f,coll){
var temp__5718__auto__ = cljs.core.seq(coll);
if(temp__5718__auto__){
var s = temp__5718__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f,cljs.core.first(s),cljs.core.next(s));
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
}));

(cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14876(f,val,coll){
var val__$1 = val;
var coll__$1 = cljs.core.seq(coll);
while(true){
if(coll__$1){
var nval = (function (){var G__14877 = val__$1;
var G__14878 = cljs.core.first(coll__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14877,G__14878) : f.call(null,G__14877,G__14878));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14880 = nval;
var G__14881 = cljs.core.next(coll__$1);
val__$1 = G__14880;
coll__$1 = G__14881;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3);

/**
 * Return a random permutation of coll
 */
cljs.core.shuffle = (function cljs$core$shuffle(coll){
var a = cljs.core.to_array(coll);
cljs.core.goog$module$goog$array.shuffle.call(null,a);

return cljs.core.vec(a);
});
cljs.core.iter_reduce = (function cljs$core$iter_reduce(var_args){
var G__14883 = arguments.length;
switch (G__14883) {
case 2:
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14884(coll,f){
var iter = cljs.core._iterator(coll);
if(cljs.core.truth_(iter.hasNext())){
var init = iter.next();
var acc = init;
while(true){
if(iter.hasNext()){
var nacc = (function (){var G__14885 = acc;
var G__14886 = iter.next();
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14885,G__14886) : f.call(null,G__14885,G__14886));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__14891 = nacc;
acc = G__14891;
continue;
}
} else {
return acc;
}
break;
}
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
}));

(cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14887(coll,f,init){
var iter = cljs.core._iterator(coll);
var acc = init;
while(true){
if(iter.hasNext()){
var nacc = (function (){var G__14888 = acc;
var G__14889 = iter.next();
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14888,G__14889) : f.call(null,G__14888,G__14889));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__14892 = nacc;
acc = G__14892;
continue;
}
} else {
return acc;
}
break;
}
}));

(cljs.core.iter_reduce.cljs$lang$maxFixedArity = 3);

/**
 * f should be a function of 2 arguments. If val is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc. If coll contains no
 *   items, f must accept no arguments as well, and reduce returns the
 *   result of calling f with no arguments.  If coll has only 1 item, it
 *   is returned and f is not called.  If val is supplied, returns the
 *   result of applying f to val and the first item in coll, then
 *   applying f to that result and the 2nd item, etc. If coll contains no
 *   items, returns val and f is not called.
 */
cljs.core.reduce = (function cljs$core$reduce(var_args){
var G__14894 = arguments.length;
switch (G__14894) {
case 2:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14895(f,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$))))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$2(null,f);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll);

}
}
}
}
}
}));

(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14897(f,val,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$))))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$3(null,f,val);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll);

}
}
}
}
}
}));

(cljs.core.reduce.cljs$lang$maxFixedArity = 3);

/**
 * Reduces an associative collection. f should be a function of 3
 *   arguments. Returns the result of applying f to init, the first key
 *   and the first value in coll, then applying f to that result and the
 *   2nd key and value, etc. If coll contains no entries, returns init
 *   and f is not called. Note that reduce-kv is supported on vectors,
 *   where the keys will be the ordinals.
 */
cljs.core.reduce_kv = (function cljs$core$reduce_kv(f,init,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (1048576))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IKVReduce$))))?true:(((!coll.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,coll):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,coll))){
return cljs.core._kv_reduce(coll,f,init);
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function cljs$core$reduce_kv_$_fn_14901(ret,me){
var G__14902 = ret;
var G__14903 = cljs.core._key(me);
var G__14904 = cljs.core._val(me);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__14902,G__14903,G__14904) : f.call(null,G__14902,G__14903,G__14904));
}),init,coll);
}
});
/**
 * Returns its argument.
 */
cljs.core.identity = (function cljs$core$identity(x){
return x;
});
/**
 * Takes a reducing function f of 2 args and returns a fn suitable for
 *   transduce by adding an arity-1 signature that calls cf (default -
 *   identity) on the result argument.
 */
cljs.core.completing = (function cljs$core$completing(var_args){
var G__14906 = arguments.length;
switch (G__14906) {
case 1:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14907(f){
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity);
}));

(cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14908(f,cf){
return (function() {
var cljs$core$fn_14908_$_fn_14909 = null;
var cljs$core$fn_14908_$_fn_14909__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
var cljs$core$fn_14908_$_fn_14909__1 = (function (x){
return (cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(x) : cf.call(null,x));
});
var cljs$core$fn_14908_$_fn_14909__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
});
cljs$core$fn_14908_$_fn_14909 = function(x,y){
switch(arguments.length){
case 0:
return cljs$core$fn_14908_$_fn_14909__0.call(this);
case 1:
return cljs$core$fn_14908_$_fn_14909__1.call(this,x);
case 2:
return cljs$core$fn_14908_$_fn_14909__2.call(this,x,y);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14908_$_fn_14909.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_14908_$_fn_14909__0;
cljs$core$fn_14908_$_fn_14909.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14908_$_fn_14909__1;
cljs$core$fn_14908_$_fn_14909.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14908_$_fn_14909__2;
return cljs$core$fn_14908_$_fn_14909;
})()
}));

(cljs.core.completing.cljs$lang$maxFixedArity = 2);

/**
 * reduce with a transformation of f (xf). If init is not
 *   supplied, (f) will be called to produce it. f should be a reducing
 *   step function that accepts both 1 and 2 arguments, if it accepts
 *   only 2 you can add the arity-1 with 'completing'. Returns the result
 *   of applying (the transformed) xf to init and the first item in coll,
 *   then applying xf to that result and the 2nd item, etc. If coll
 *   contains no items, returns init and f is not called. Note that
 *   certain transforms may inject or skip items.
 */
cljs.core.transduce = (function cljs$core$transduce(var_args){
var G__14912 = arguments.length;
switch (G__14912) {
case 3:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14913(xform,f,coll){
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,f,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),coll);
}));

(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14914(xform,f,init,coll){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);
return (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(ret) : f__$1.call(null,ret));
}));

(cljs.core.transduce.cljs$lang$maxFixedArity = 4);

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core._PLUS_ = (function cljs$core$_PLUS_(var_args){
var G__14920 = arguments.length;
switch (G__14920) {
case 0:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___14927 = arguments.length;
var i__10857__auto___14928 = (0);
while(true){
if((i__10857__auto___14928 < len__10856__auto___14927)){
args_arr__10885__auto__.push((arguments[i__10857__auto___14928]));

var G__14929 = (i__10857__auto___14928 + (1));
i__10857__auto___14928 = G__14929;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14921(){
return (0);
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14922(x){
return x;
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14923(x,y){
return (x + y);
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14924(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(x + y),more);
}));

/** @this {Function} */
(cljs.core._PLUS_.cljs$lang$applyTo = (function cljs$core$fn_14925(seq14917){
var G__14918 = cljs.core.first(seq14917);
var seq14917__$1 = cljs.core.next(seq14917);
var G__14919 = cljs.core.first(seq14917__$1);
var seq14917__$2 = cljs.core.next(seq14917__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14918,G__14919,seq14917__$2);
}));

(cljs.core._PLUS_.cljs$lang$maxFixedArity = (2));

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core._ = (function cljs$core$_(var_args){
var G__14934 = arguments.length;
switch (G__14934) {
case 1:
return cljs.core._.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___14940 = arguments.length;
var i__10857__auto___14941 = (0);
while(true){
if((i__10857__auto___14941 < len__10856__auto___14940)){
args_arr__10885__auto__.push((arguments[i__10857__auto___14941]));

var G__14942 = (i__10857__auto___14941 + (1));
i__10857__auto___14941 = G__14942;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core._.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14935(x){
return (- x);
}));

(cljs.core._.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14936(x,y){
return (x - y);
}));

(cljs.core._.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14937(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,(x - y),more);
}));

/** @this {Function} */
(cljs.core._.cljs$lang$applyTo = (function cljs$core$fn_14938(seq14931){
var G__14932 = cljs.core.first(seq14931);
var seq14931__$1 = cljs.core.next(seq14931);
var G__14933 = cljs.core.first(seq14931__$1);
var seq14931__$2 = cljs.core.next(seq14931__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14932,G__14933,seq14931__$2);
}));

(cljs.core._.cljs$lang$maxFixedArity = (2));

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core._STAR_ = (function cljs$core$_STAR_(var_args){
var G__14947 = arguments.length;
switch (G__14947) {
case 0:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___14954 = arguments.length;
var i__10857__auto___14955 = (0);
while(true){
if((i__10857__auto___14955 < len__10856__auto___14954)){
args_arr__10885__auto__.push((arguments[i__10857__auto___14955]));

var G__14956 = (i__10857__auto___14955 + (1));
i__10857__auto___14955 = G__14956;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14948(){
return (1);
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14949(x){
return x;
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14950(x,y){
return (x * y);
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14951(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,(x * y),more);
}));

/** @this {Function} */
(cljs.core._STAR_.cljs$lang$applyTo = (function cljs$core$fn_14952(seq14944){
var G__14945 = cljs.core.first(seq14944);
var seq14944__$1 = cljs.core.next(seq14944);
var G__14946 = cljs.core.first(seq14944__$1);
var seq14944__$2 = cljs.core.next(seq14944__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14945,G__14946,seq14944__$2);
}));

(cljs.core._STAR_.cljs$lang$maxFixedArity = (2));

/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core._SLASH_ = (function cljs$core$_SLASH_(var_args){
var G__14961 = arguments.length;
switch (G__14961) {
case 1:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___14967 = arguments.length;
var i__10857__auto___14968 = (0);
while(true){
if((i__10857__auto___14968 < len__10856__auto___14967)){
args_arr__10885__auto__.push((arguments[i__10857__auto___14968]));

var G__14969 = (i__10857__auto___14968 + (1));
i__10857__auto___14968 = G__14969;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14962(x){
return ((1) / x);
}));

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14963(x,y){
return (x / y);
}));

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14964(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(x / y),more);
}));

/** @this {Function} */
(cljs.core._SLASH_.cljs$lang$applyTo = (function cljs$core$fn_14965(seq14958){
var G__14959 = cljs.core.first(seq14958);
var seq14958__$1 = cljs.core.next(seq14958);
var G__14960 = cljs.core.first(seq14958__$1);
var seq14958__$2 = cljs.core.next(seq14958__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14959,G__14960,seq14958__$2);
}));

(cljs.core._SLASH_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically increasing order,
 *   otherwise false.
 */
cljs.core._LT_ = (function cljs$core$_LT_(var_args){
var G__14974 = arguments.length;
switch (G__14974) {
case 1:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___14980 = arguments.length;
var i__10857__auto___14981 = (0);
while(true){
if((i__10857__auto___14981 < len__10856__auto___14980)){
args_arr__10885__auto__.push((arguments[i__10857__auto___14981]));

var G__14982 = (i__10857__auto___14981 + (1));
i__10857__auto___14981 = G__14982;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14975(x){
return true;
}));

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14976(x,y){
return (x < y);
}));

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14977(x,y,more){
while(true){
if((x < y)){
if(cljs.core.next(more)){
var G__14983 = y;
var G__14984 = cljs.core.first(more);
var G__14985 = cljs.core.next(more);
x = G__14983;
y = G__14984;
more = G__14985;
continue;
} else {
return (y < cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._LT_.cljs$lang$applyTo = (function cljs$core$fn_14978(seq14971){
var G__14972 = cljs.core.first(seq14971);
var seq14971__$1 = cljs.core.next(seq14971);
var G__14973 = cljs.core.first(seq14971__$1);
var seq14971__$2 = cljs.core.next(seq14971__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14972,G__14973,seq14971__$2);
}));

(cljs.core._LT_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 *   otherwise false.
 */
cljs.core._LT__EQ_ = (function cljs$core$_LT__EQ_(var_args){
var G__14990 = arguments.length;
switch (G__14990) {
case 1:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___14996 = arguments.length;
var i__10857__auto___14997 = (0);
while(true){
if((i__10857__auto___14997 < len__10856__auto___14996)){
args_arr__10885__auto__.push((arguments[i__10857__auto___14997]));

var G__14998 = (i__10857__auto___14997 + (1));
i__10857__auto___14997 = G__14998;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14991(x){
return true;
}));

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14992(x,y){
return (x <= y);
}));

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14993(x,y,more){
while(true){
if((x <= y)){
if(cljs.core.next(more)){
var G__14999 = y;
var G__15000 = cljs.core.first(more);
var G__15001 = cljs.core.next(more);
x = G__14999;
y = G__15000;
more = G__15001;
continue;
} else {
return (y <= cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._LT__EQ_.cljs$lang$applyTo = (function cljs$core$fn_14994(seq14987){
var G__14988 = cljs.core.first(seq14987);
var seq14987__$1 = cljs.core.next(seq14987);
var G__14989 = cljs.core.first(seq14987__$1);
var seq14987__$2 = cljs.core.next(seq14987__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14988,G__14989,seq14987__$2);
}));

(cljs.core._LT__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically decreasing order,
 *   otherwise false.
 */
cljs.core._GT_ = (function cljs$core$_GT_(var_args){
var G__15006 = arguments.length;
switch (G__15006) {
case 1:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15012 = arguments.length;
var i__10857__auto___15013 = (0);
while(true){
if((i__10857__auto___15013 < len__10856__auto___15012)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15013]));

var G__15014 = (i__10857__auto___15013 + (1));
i__10857__auto___15013 = G__15014;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15007(x){
return true;
}));

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15008(x,y){
return (x > y);
}));

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15009(x,y,more){
while(true){
if((x > y)){
if(cljs.core.next(more)){
var G__15015 = y;
var G__15016 = cljs.core.first(more);
var G__15017 = cljs.core.next(more);
x = G__15015;
y = G__15016;
more = G__15017;
continue;
} else {
return (y > cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._GT_.cljs$lang$applyTo = (function cljs$core$fn_15010(seq15003){
var G__15004 = cljs.core.first(seq15003);
var seq15003__$1 = cljs.core.next(seq15003);
var G__15005 = cljs.core.first(seq15003__$1);
var seq15003__$2 = cljs.core.next(seq15003__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15004,G__15005,seq15003__$2);
}));

(cljs.core._GT_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 *   otherwise false.
 */
cljs.core._GT__EQ_ = (function cljs$core$_GT__EQ_(var_args){
var G__15022 = arguments.length;
switch (G__15022) {
case 1:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15028 = arguments.length;
var i__10857__auto___15029 = (0);
while(true){
if((i__10857__auto___15029 < len__10856__auto___15028)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15029]));

var G__15030 = (i__10857__auto___15029 + (1));
i__10857__auto___15029 = G__15030;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15023(x){
return true;
}));

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15024(x,y){
return (x >= y);
}));

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15025(x,y,more){
while(true){
if((x >= y)){
if(cljs.core.next(more)){
var G__15031 = y;
var G__15032 = cljs.core.first(more);
var G__15033 = cljs.core.next(more);
x = G__15031;
y = G__15032;
more = G__15033;
continue;
} else {
return (y >= cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._GT__EQ_.cljs$lang$applyTo = (function cljs$core$fn_15026(seq15019){
var G__15020 = cljs.core.first(seq15019);
var seq15019__$1 = cljs.core.next(seq15019);
var G__15021 = cljs.core.first(seq15019__$1);
var seq15019__$2 = cljs.core.next(seq15019__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15020,G__15021,seq15019__$2);
}));

(cljs.core._GT__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns a number one less than num.
 */
cljs.core.dec = (function cljs$core$dec(x){
return (x - (1));
});
/**
 * Returns the absolute value of a.
 */
cljs.core.abs = (function cljs$core$abs(a){
return Math.abs(a);
});
/**
 * Returns the greatest of the nums.
 */
cljs.core.max = (function cljs$core$max(var_args){
var G__15038 = arguments.length;
switch (G__15038) {
case 1:
return cljs.core.max.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.max.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15044 = arguments.length;
var i__10857__auto___15045 = (0);
while(true){
if((i__10857__auto___15045 < len__10856__auto___15044)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15045]));

var G__15046 = (i__10857__auto___15045 + (1));
i__10857__auto___15045 = G__15046;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.max.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15039(x){
return x;
}));

(cljs.core.max.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15040(x,y){
var x__9884__auto__ = x;
var y__9885__auto__ = y;
return ((x__9884__auto__ > y__9885__auto__) ? x__9884__auto__ : y__9885__auto__);
}));

(cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15041(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(function (){var x__9884__auto__ = x;
var y__9885__auto__ = y;
return ((x__9884__auto__ > y__9885__auto__) ? x__9884__auto__ : y__9885__auto__);
})(),more);
}));

/** @this {Function} */
(cljs.core.max.cljs$lang$applyTo = (function cljs$core$fn_15042(seq15035){
var G__15036 = cljs.core.first(seq15035);
var seq15035__$1 = cljs.core.next(seq15035);
var G__15037 = cljs.core.first(seq15035__$1);
var seq15035__$2 = cljs.core.next(seq15035__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15036,G__15037,seq15035__$2);
}));

(cljs.core.max.cljs$lang$maxFixedArity = (2));

/**
 * Returns the least of the nums.
 */
cljs.core.min = (function cljs$core$min(var_args){
var G__15051 = arguments.length;
switch (G__15051) {
case 1:
return cljs.core.min.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.min.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15057 = arguments.length;
var i__10857__auto___15058 = (0);
while(true){
if((i__10857__auto___15058 < len__10856__auto___15057)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15058]));

var G__15059 = (i__10857__auto___15058 + (1));
i__10857__auto___15058 = G__15059;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.min.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15052(x){
return x;
}));

(cljs.core.min.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15053(x,y){
var x__9891__auto__ = x;
var y__9892__auto__ = y;
return ((x__9891__auto__ < y__9892__auto__) ? x__9891__auto__ : y__9892__auto__);
}));

(cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15054(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min,(function (){var x__9891__auto__ = x;
var y__9892__auto__ = y;
return ((x__9891__auto__ < y__9892__auto__) ? x__9891__auto__ : y__9892__auto__);
})(),more);
}));

/** @this {Function} */
(cljs.core.min.cljs$lang$applyTo = (function cljs$core$fn_15055(seq15048){
var G__15049 = cljs.core.first(seq15048);
var seq15048__$1 = cljs.core.next(seq15048);
var G__15050 = cljs.core.first(seq15048__$1);
var seq15048__$2 = cljs.core.next(seq15048__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15049,G__15050,seq15048__$2);
}));

(cljs.core.min.cljs$lang$maxFixedArity = (2));

cljs.core.byte$ = (function cljs$core$byte(x){
return x;
});
/**
 * Coerce to char
 */
cljs.core.char$ = (function cljs$core$char(x){
if(typeof x === 'number'){
return String.fromCharCode(x);
} else {
if(((typeof x === 'string') && ((x.length === (1))))){
return x;
} else {
throw (new Error("Argument to char must be a character or number"));

}
}
});
cljs.core.short$ = (function cljs$core$short(x){
return x;
});
cljs.core.float$ = (function cljs$core$float(x){
return x;
});
cljs.core.double$ = (function cljs$core$double(x){
return x;
});
cljs.core.unchecked_byte = (function cljs$core$unchecked_byte(x){
return x;
});
cljs.core.unchecked_char = (function cljs$core$unchecked_char(x){
return x;
});
cljs.core.unchecked_short = (function cljs$core$unchecked_short(x){
return x;
});
cljs.core.unchecked_float = (function cljs$core$unchecked_float(x){
return x;
});
cljs.core.unchecked_double = (function cljs$core$unchecked_double(x){
return x;
});
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add = (function cljs$core$unchecked_add(var_args){
var G__15064 = arguments.length;
switch (G__15064) {
case 0:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15071 = arguments.length;
var i__10857__auto___15072 = (0);
while(true){
if((i__10857__auto___15072 < len__10856__auto___15071)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15072]));

var G__15073 = (i__10857__auto___15072 + (1));
i__10857__auto___15072 = G__15073;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15065(){
return (0);
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15066(x){
return x;
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15067(x,y){
return (x + y);
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15068(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add,(x + y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_add.cljs$lang$applyTo = (function cljs$core$fn_15069(seq15061){
var G__15062 = cljs.core.first(seq15061);
var seq15061__$1 = cljs.core.next(seq15061);
var G__15063 = cljs.core.first(seq15061__$1);
var seq15061__$2 = cljs.core.next(seq15061__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15062,G__15063,seq15061__$2);
}));

(cljs.core.unchecked_add.cljs$lang$maxFixedArity = (2));

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add_int = (function cljs$core$unchecked_add_int(var_args){
var G__15078 = arguments.length;
switch (G__15078) {
case 0:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15085 = arguments.length;
var i__10857__auto___15086 = (0);
while(true){
if((i__10857__auto___15086 < len__10856__auto___15085)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15086]));

var G__15087 = (i__10857__auto___15086 + (1));
i__10857__auto___15086 = G__15087;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15079(){
return (0);
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15080(x){
return x;
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15081(x,y){
return (x + y);
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15082(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int,(x + y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_add_int.cljs$lang$applyTo = (function cljs$core$fn_15083(seq15075){
var G__15076 = cljs.core.first(seq15075);
var seq15075__$1 = cljs.core.next(seq15075);
var G__15077 = cljs.core.first(seq15075__$1);
var seq15075__$2 = cljs.core.next(seq15075__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15076,G__15077,seq15075__$2);
}));

(cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = (2));

/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec = (function cljs$core$unchecked_dec(x){
return (x - (1));
});
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec_int = (function cljs$core$unchecked_dec_int(x){
return (x - (1));
});
/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core.unchecked_divide_int = (function cljs$core$unchecked_divide_int(var_args){
var G__15092 = arguments.length;
switch (G__15092) {
case 1:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15098 = arguments.length;
var i__10857__auto___15099 = (0);
while(true){
if((i__10857__auto___15099 < len__10856__auto___15098)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15099]));

var G__15100 = (i__10857__auto___15099 + (1));
i__10857__auto___15099 = G__15100;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15093(x){
return ((1) / x);
}));

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15094(x,y){
return (x / y);
}));

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15095(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int,(x / y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_divide_int.cljs$lang$applyTo = (function cljs$core$fn_15096(seq15089){
var G__15090 = cljs.core.first(seq15089);
var seq15089__$1 = cljs.core.next(seq15089);
var G__15091 = cljs.core.first(seq15089__$1);
var seq15089__$2 = cljs.core.next(seq15089__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15090,G__15091,seq15089__$2);
}));

(cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = (2));

cljs.core.unchecked_inc = (function cljs$core$unchecked_inc(x){
return (x + (1));
});
cljs.core.unchecked_inc_int = (function cljs$core$unchecked_inc_int(x){
return (x + (1));
});
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply = (function cljs$core$unchecked_multiply(var_args){
var G__15105 = arguments.length;
switch (G__15105) {
case 0:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15112 = arguments.length;
var i__10857__auto___15113 = (0);
while(true){
if((i__10857__auto___15113 < len__10856__auto___15112)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15113]));

var G__15114 = (i__10857__auto___15113 + (1));
i__10857__auto___15113 = G__15114;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15106(){
return (1);
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15107(x){
return x;
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15108(x,y){
return (x * y);
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15109(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply,(x * y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_multiply.cljs$lang$applyTo = (function cljs$core$fn_15110(seq15102){
var G__15103 = cljs.core.first(seq15102);
var seq15102__$1 = cljs.core.next(seq15102);
var G__15104 = cljs.core.first(seq15102__$1);
var seq15102__$2 = cljs.core.next(seq15102__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15103,G__15104,seq15102__$2);
}));

(cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = (2));

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply_int = (function cljs$core$unchecked_multiply_int(var_args){
var G__15119 = arguments.length;
switch (G__15119) {
case 0:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15126 = arguments.length;
var i__10857__auto___15127 = (0);
while(true){
if((i__10857__auto___15127 < len__10856__auto___15126)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15127]));

var G__15128 = (i__10857__auto___15127 + (1));
i__10857__auto___15127 = G__15128;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15120(){
return (1);
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15121(x){
return x;
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15122(x,y){
return (x * y);
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15123(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int,(x * y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_multiply_int.cljs$lang$applyTo = (function cljs$core$fn_15124(seq15116){
var G__15117 = cljs.core.first(seq15116);
var seq15116__$1 = cljs.core.next(seq15116);
var G__15118 = cljs.core.first(seq15116__$1);
var seq15116__$2 = cljs.core.next(seq15116__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15117,G__15118,seq15116__$2);
}));

(cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = (2));

cljs.core.unchecked_negate = (function cljs$core$unchecked_negate(x){
return (- x);
});
cljs.core.unchecked_negate_int = (function cljs$core$unchecked_negate_int(x){
return (- x);
});
cljs.core.unchecked_remainder_int = (function cljs$core$unchecked_remainder_int(x,n){
return cljs.core.mod(x,n);
});
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract = (function cljs$core$unchecked_subtract(var_args){
var G__15133 = arguments.length;
switch (G__15133) {
case 1:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15139 = arguments.length;
var i__10857__auto___15140 = (0);
while(true){
if((i__10857__auto___15140 < len__10856__auto___15139)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15140]));

var G__15141 = (i__10857__auto___15140 + (1));
i__10857__auto___15140 = G__15141;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15134(x){
return (- x);
}));

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15135(x,y){
return (x - y);
}));

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15136(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract,(x - y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_subtract.cljs$lang$applyTo = (function cljs$core$fn_15137(seq15130){
var G__15131 = cljs.core.first(seq15130);
var seq15130__$1 = cljs.core.next(seq15130);
var G__15132 = cljs.core.first(seq15130__$1);
var seq15130__$2 = cljs.core.next(seq15130__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15131,G__15132,seq15130__$2);
}));

(cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = (2));

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract_int = (function cljs$core$unchecked_subtract_int(var_args){
var G__15146 = arguments.length;
switch (G__15146) {
case 1:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15152 = arguments.length;
var i__10857__auto___15153 = (0);
while(true){
if((i__10857__auto___15153 < len__10856__auto___15152)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15153]));

var G__15154 = (i__10857__auto___15153 + (1));
i__10857__auto___15153 = G__15154;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15147(x){
return (- x);
}));

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15148(x,y){
return (x - y);
}));

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15149(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int,(x - y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_subtract_int.cljs$lang$applyTo = (function cljs$core$fn_15150(seq15143){
var G__15144 = cljs.core.first(seq15143);
var seq15143__$1 = cljs.core.next(seq15143);
var G__15145 = cljs.core.first(seq15143__$1);
var seq15143__$2 = cljs.core.next(seq15143__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15144,G__15145,seq15143__$2);
}));

(cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = (2));

cljs.core.fix = (function cljs$core$fix(q){
if((q >= (0))){
return Math.floor(q);
} else {
return Math.ceil(q);
}
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.int$ = (function cljs$core$int(x){
return (x | (0));
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.unchecked_int = (function cljs$core$unchecked_int(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.long$ = (function cljs$core$long(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.unchecked_long = (function cljs$core$unchecked_long(x){
return cljs.core.fix(x);
});
cljs.core.booleans = (function cljs$core$booleans(x){
return x;
});
cljs.core.bytes = (function cljs$core$bytes(x){
return x;
});
cljs.core.chars = (function cljs$core$chars(x){
return x;
});
cljs.core.shorts = (function cljs$core$shorts(x){
return x;
});
cljs.core.ints = (function cljs$core$ints(x){
return x;
});
cljs.core.floats = (function cljs$core$floats(x){
return x;
});
cljs.core.doubles = (function cljs$core$doubles(x){
return x;
});
cljs.core.longs = (function cljs$core$longs(x){
return x;
});
/**
 * Modulus of num and div with original javascript behavior. i.e. bug for negative numbers
 */
cljs.core.js_mod = (function cljs$core$js_mod(n,d){
return (n % d);
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
cljs.core.mod = (function cljs$core$mod(n,d){
return (((n % d) + d) % d);
});
/**
 * quot[ient] of dividing numerator by denominator.
 */
cljs.core.quot = (function cljs$core$quot(n,d){
var rem = (n % d);
return cljs.core.fix(((n - rem) / d));
});
/**
 * remainder of dividing numerator by denominator.
 */
cljs.core.rem = (function cljs$core$rem(n,d){
var q = cljs.core.quot(n,d);
return (n - (d * q));
});
/**
 * Bitwise exclusive or
 */
cljs.core.bit_xor = (function cljs$core$bit_xor(var_args){
var G__15159 = arguments.length;
switch (G__15159) {
case 2:
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15164 = arguments.length;
var i__10857__auto___15165 = (0);
while(true){
if((i__10857__auto___15165 < len__10856__auto___15164)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15165]));

var G__15166 = (i__10857__auto___15165 + (1));
i__10857__auto___15165 = G__15166;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15160(x,y){
return (x ^ y);
}));

(cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15161(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor,(x ^ y),more);
}));

/** @this {Function} */
(cljs.core.bit_xor.cljs$lang$applyTo = (function cljs$core$fn_15162(seq15156){
var G__15157 = cljs.core.first(seq15156);
var seq15156__$1 = cljs.core.next(seq15156);
var G__15158 = cljs.core.first(seq15156__$1);
var seq15156__$2 = cljs.core.next(seq15156__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15157,G__15158,seq15156__$2);
}));

(cljs.core.bit_xor.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise and
 */
cljs.core.bit_and = (function cljs$core$bit_and(var_args){
var G__15171 = arguments.length;
switch (G__15171) {
case 2:
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15176 = arguments.length;
var i__10857__auto___15177 = (0);
while(true){
if((i__10857__auto___15177 < len__10856__auto___15176)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15177]));

var G__15178 = (i__10857__auto___15177 + (1));
i__10857__auto___15177 = G__15178;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15172(x,y){
return (x & y);
}));

(cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15173(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and,(x & y),more);
}));

/** @this {Function} */
(cljs.core.bit_and.cljs$lang$applyTo = (function cljs$core$fn_15174(seq15168){
var G__15169 = cljs.core.first(seq15168);
var seq15168__$1 = cljs.core.next(seq15168);
var G__15170 = cljs.core.first(seq15168__$1);
var seq15168__$2 = cljs.core.next(seq15168__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15169,G__15170,seq15168__$2);
}));

(cljs.core.bit_and.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise or
 */
cljs.core.bit_or = (function cljs$core$bit_or(var_args){
var G__15183 = arguments.length;
switch (G__15183) {
case 2:
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15188 = arguments.length;
var i__10857__auto___15189 = (0);
while(true){
if((i__10857__auto___15189 < len__10856__auto___15188)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15189]));

var G__15190 = (i__10857__auto___15189 + (1));
i__10857__auto___15189 = G__15190;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15184(x,y){
return (x | y);
}));

(cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15185(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or,(x | y),more);
}));

/** @this {Function} */
(cljs.core.bit_or.cljs$lang$applyTo = (function cljs$core$fn_15186(seq15180){
var G__15181 = cljs.core.first(seq15180);
var seq15180__$1 = cljs.core.next(seq15180);
var G__15182 = cljs.core.first(seq15180__$1);
var seq15180__$2 = cljs.core.next(seq15180__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15181,G__15182,seq15180__$2);
}));

(cljs.core.bit_or.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise and with complement
 */
cljs.core.bit_and_not = (function cljs$core$bit_and_not(var_args){
var G__15195 = arguments.length;
switch (G__15195) {
case 2:
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15200 = arguments.length;
var i__10857__auto___15201 = (0);
while(true){
if((i__10857__auto___15201 < len__10856__auto___15200)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15201]));

var G__15202 = (i__10857__auto___15201 + (1));
i__10857__auto___15201 = G__15202;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15196(x,y){
return (x & ~y);
}));

(cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15197(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not,(x & ~y),more);
}));

/** @this {Function} */
(cljs.core.bit_and_not.cljs$lang$applyTo = (function cljs$core$fn_15198(seq15192){
var G__15193 = cljs.core.first(seq15192);
var seq15192__$1 = cljs.core.next(seq15192);
var G__15194 = cljs.core.first(seq15192__$1);
var seq15192__$2 = cljs.core.next(seq15192__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15193,G__15194,seq15192__$2);
}));

(cljs.core.bit_and_not.cljs$lang$maxFixedArity = (2));

/**
 * Clear bit at index n
 */
cljs.core.bit_clear = (function cljs$core$bit_clear(x,n){
return (x & ~(1 << n));
});
/**
 * Flip bit at index n
 */
cljs.core.bit_flip = (function cljs$core$bit_flip(x,n){
return (x ^ (1 << n));
});
/**
 * Bitwise complement
 */
cljs.core.bit_not = (function cljs$core$bit_not(x){
return (~ x);
});
/**
 * Set bit at index n
 */
cljs.core.bit_set = (function cljs$core$bit_set(x,n){
return (x | (1 << n));
});
/**
 * Test bit at index n
 */
cljs.core.bit_test = (function cljs$core$bit_test(x,n){
return ((x & (1 << n)) != 0);
});
/**
 * Bitwise shift left
 */
cljs.core.bit_shift_left = (function cljs$core$bit_shift_left(x,n){
return (x << n);
});
/**
 * Bitwise shift right
 */
cljs.core.bit_shift_right = (function cljs$core$bit_shift_right(x,n){
return (x >> n);
});
/**
 * DEPRECATED: Bitwise shift right with zero fill
 */
cljs.core.bit_shift_right_zero_fill = (function cljs$core$bit_shift_right_zero_fill(x,n){
return (x >>> n);
});
/**
 * Bitwise shift right with zero fill
 */
cljs.core.unsigned_bit_shift_right = (function cljs$core$unsigned_bit_shift_right(x,n){
return (x >>> n);
});
/**
 * Counts the number of bits set in n
 */
cljs.core.bit_count = (function cljs$core$bit_count(v){
var v__$1 = (v - ((v >> (1)) & (1431655765)));
var v__$2 = ((v__$1 & (858993459)) + ((v__$1 >> (2)) & (858993459)));
return ((((v__$2 + (v__$2 >> (4))) & (252645135)) * (16843009)) >> (24));
});
/**
 * Returns non-nil if nums all have the equivalent
 *   value, otherwise false. Behavior on non nums is
 *   undefined.
 */
cljs.core._EQ__EQ_ = (function cljs$core$_EQ__EQ_(var_args){
var G__15207 = arguments.length;
switch (G__15207) {
case 1:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15213 = arguments.length;
var i__10857__auto___15214 = (0);
while(true){
if((i__10857__auto___15214 < len__10856__auto___15213)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15214]));

var G__15215 = (i__10857__auto___15214 + (1));
i__10857__auto___15214 = G__15215;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15208(x){
return true;
}));

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15209(x,y){
return cljs.core._equiv(x,y);
}));

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15210(x,y,more){
while(true){
if((x === y)){
if(cljs.core.next(more)){
var G__15216 = y;
var G__15217 = cljs.core.first(more);
var G__15218 = cljs.core.next(more);
x = G__15216;
y = G__15217;
more = G__15218;
continue;
} else {
return (y === cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._EQ__EQ_.cljs$lang$applyTo = (function cljs$core$fn_15211(seq15204){
var G__15205 = cljs.core.first(seq15204);
var seq15204__$1 = cljs.core.next(seq15204);
var G__15206 = cljs.core.first(seq15204__$1);
var seq15204__$2 = cljs.core.next(seq15204__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15205,G__15206,seq15204__$2);
}));

(cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if num is greater than zero, else false
 */
cljs.core.pos_QMARK_ = (function cljs$core$pos_QMARK_(x){
return (x > (0));
});
/**
 * Returns true if num is zero, else false
 */
cljs.core.zero_QMARK_ = (function cljs$core$zero_QMARK_(x){
return (x === (0));
});
/**
 * Returns true if num is less than zero, else false
 */
cljs.core.neg_QMARK_ = (function cljs$core$neg_QMARK_(x){
return (x < (0));
});
/**
 * Returns the nth next of coll, (seq coll) when n is 0.
 */
cljs.core.nthnext = (function cljs$core$nthnext(coll,n){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition1$ & (262144))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IDrop$))))?true:false):false)){
if((n > (0))){
return coll.cljs$core$IDrop$_drop$arity$2(null,Math.ceil(n));
} else {
return cljs.core.seq(coll);
}
} else {
var n__$1 = n;
var xs = cljs.core.seq(coll);
while(true){
if(((xs) && ((n__$1 > (0))))){
var G__15220 = (n__$1 - (1));
var G__15221 = cljs.core.next(xs);
n__$1 = G__15220;
xs = G__15221;
continue;
} else {
return xs;
}
break;
}
}
});
/**
 * With no args, returns the empty string. With one arg x, returns
 *   x.toString().  (str nil) returns the empty string. With more than
 *   one arg, returns the concatenation of the str values of the args.
 */
cljs.core.str = (function cljs$core$str(var_args){
var G__15225 = arguments.length;
switch (G__15225) {
case 0:
return cljs.core.str.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15231 = arguments.length;
var i__10857__auto___15232 = (0);
while(true){
if((i__10857__auto___15232 < len__10856__auto___15231)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15232]));

var G__15233 = (i__10857__auto___15232 + (1));
i__10857__auto___15232 = G__15233;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((1) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((1)),(0),null)):null);
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10886__auto__);

}
});

(cljs.core.str.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15226(){
return "";
}));

(cljs.core.str.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15227(x){
if((x == null)){
return "";
} else {
return [x].join("");
}
}));

(cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15228(x,ys){
var sb = (new goog.string.StringBuffer(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)));
var more = ys;
while(true){
if(cljs.core.truth_(more)){
var G__15234 = sb.append(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(more)));
var G__15235 = cljs.core.next(more);
sb = G__15234;
more = G__15235;
continue;
} else {
return sb.toString();
}
break;
}
}));

/** @this {Function} */
(cljs.core.str.cljs$lang$applyTo = (function cljs$core$fn_15229(seq15223){
var G__15224 = cljs.core.first(seq15223);
var seq15223__$1 = cljs.core.next(seq15223);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15224,seq15223__$1);
}));

(cljs.core.str.cljs$lang$maxFixedArity = (1));

/**
 * Returns the substring of s beginning at start inclusive, and ending
 *   at end (defaults to length of string), exclusive.
 */
cljs.core.subs = (function cljs$core$subs(var_args){
var G__15237 = arguments.length;
switch (G__15237) {
case 2:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15238(s,start){
return s.substring(start);
}));

(cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15239(s,start,end){
return s.substring(start,end);
}));

(cljs.core.subs.cljs$lang$maxFixedArity = 3);


/**
 * Assumes x is sequential. Returns true if x equals y, otherwise
 *   returns false.
 */
cljs.core.equiv_sequential = (function cljs$core$equiv_sequential(x,y){
return cljs.core.boolean$(((cljs.core.sequential_QMARK_(y))?((((cljs.core.counted_QMARK_(x)) && (((cljs.core.counted_QMARK_(y)) && ((!((cljs.core.count(x) === cljs.core.count(y)))))))))?false:(function (){var xs = cljs.core.seq(x);
var ys = cljs.core.seq(y);
while(true){
if((xs == null)){
return (ys == null);
} else {
if((ys == null)){
return false;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){
var G__15241 = cljs.core.next(xs);
var G__15242 = cljs.core.next(ys);
xs = G__15241;
ys = G__15242;
continue;
} else {
return false;

}
}
}
break;
}
})()):null));
});
cljs.core.hash_coll = (function cljs$core$hash_coll(coll){
if(cljs.core.seq(coll)){
var res = cljs.core.hash(cljs.core.first(coll));
var s = cljs.core.next(coll);
while(true){
if((s == null)){
return res;
} else {
var G__15243 = cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));
var G__15244 = cljs.core.next(s);
res = G__15243;
s = G__15244;
continue;
}
break;
}
} else {
return (0);
}
});

cljs.core.hash_imap = (function cljs$core$hash_imap(m){
var h = (0);
var s = cljs.core.seq(m);
while(true){
if(s){
var e = cljs.core.first(s);
var G__15245 = ((h + (cljs.core.hash(cljs.core.key(e)) ^ cljs.core.hash(cljs.core.val(e)))) % (4503599627370496));
var G__15246 = cljs.core.next(s);
h = G__15245;
s = G__15246;
continue;
} else {
return h;
}
break;
}
});
cljs.core.hash_iset = (function cljs$core$hash_iset(s){
var h = (0);
var s__$1 = cljs.core.seq(s);
while(true){
if(s__$1){
var e = cljs.core.first(s__$1);
var G__15247 = ((h + cljs.core.hash(e)) % (4503599627370496));
var G__15248 = cljs.core.next(s__$1);
h = G__15247;
s__$1 = G__15248;
continue;
} else {
return h;
}
break;
}
});


/**
 * Takes a JavaScript object and a map of names to functions and
 *   attaches said functions as methods on the object.  Any references to
 *   JavaScript's implicit this (via the this-as macro) will resolve to the
 *   object that the function is attached.
 */
cljs.core.extend_object_BANG_ = (function cljs$core$extend_object_BANG_(obj,fn_map){
var seq__15249_15265 = cljs.core.seq(fn_map);
var chunk__15250_15266 = null;
var count__15251_15267 = (0);
var i__15252_15268 = (0);
while(true){
if((i__15252_15268 < count__15251_15267)){
var vec__15259_15269 = chunk__15250_15266.cljs$core$IIndexed$_nth$arity$2(null,i__15252_15268);
var key_name_15270 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15259_15269,(0),null);
var f_15271 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15259_15269,(1),null);
var str_name_15272 = cljs.core.name(key_name_15270);
cljs.core.goog$module$goog$object.set.call(null,obj,str_name_15272,f_15271);


var G__15273 = seq__15249_15265;
var G__15274 = chunk__15250_15266;
var G__15275 = count__15251_15267;
var G__15276 = (i__15252_15268 + (1));
seq__15249_15265 = G__15273;
chunk__15250_15266 = G__15274;
count__15251_15267 = G__15275;
i__15252_15268 = G__15276;
continue;
} else {
var temp__5720__auto___15277 = cljs.core.seq(seq__15249_15265);
if(temp__5720__auto___15277){
var seq__15249_15278__$1 = temp__5720__auto___15277;
if(cljs.core.chunked_seq_QMARK_(seq__15249_15278__$1)){
var c__10499__auto___15279 = cljs.core.chunk_first(seq__15249_15278__$1);
var G__15280 = cljs.core.chunk_rest(seq__15249_15278__$1);
var G__15281 = c__10499__auto___15279;
var G__15282 = cljs.core.count(c__10499__auto___15279);
var G__15283 = (0);
seq__15249_15265 = G__15280;
chunk__15250_15266 = G__15281;
count__15251_15267 = G__15282;
i__15252_15268 = G__15283;
continue;
} else {
var vec__15262_15284 = cljs.core.first(seq__15249_15278__$1);
var key_name_15285 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15262_15284,(0),null);
var f_15286 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15262_15284,(1),null);
var str_name_15287 = cljs.core.name(key_name_15285);
cljs.core.goog$module$goog$object.set.call(null,obj,str_name_15287,f_15286);


var G__15288 = cljs.core.next(seq__15249_15278__$1);
var G__15289 = null;
var G__15290 = (0);
var G__15291 = (0);
seq__15249_15265 = G__15288;
chunk__15250_15266 = G__15289;
count__15251_15267 = G__15290;
i__15252_15268 = G__15291;
continue;
}
} else {
}
}
break;
}

return obj;
});

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.List = (function (meta,first,rest,count,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.count = count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65937646;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.List.prototype.toString = (function cljs$core$fn_15292(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.List.prototype.equiv = (function cljs$core$fn_15293(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.List.prototype.indexOf = (function() {
var cljs$core$fn_15294 = null;
var cljs$core$fn_15294__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_15294__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15294 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15294__1.call(this,x);
case 2:
return cljs$core$fn_15294__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15294.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15294__1;
cljs$core$fn_15294.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15294__2;
return cljs$core$fn_15294;
})()
);

(cljs.core.List.prototype.lastIndexOf = (function() {
var cljs$core$fn_15295 = null;
var cljs$core$fn_15295__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,self__.count);
});
var cljs$core$fn_15295__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15295 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15295__1.call(this,x);
case 2:
return cljs$core$fn_15295__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15295.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15295__1;
cljs$core$fn_15295.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15295__2;
return cljs$core$fn_15295;
})()
);

(cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15296(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_15297(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));
}));

(cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_15298(coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return null;
} else {
return self__.rest;
}
}));

(cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_15299(coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
}));

(cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_15300(coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_15301(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
}));

(cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15302(coll){
var self__ = this;
var coll__$1 = this;
var h__9988__auto__ = self__.__hash;
if((!((h__9988__auto__ == null)))){
return h__9988__auto__;
} else {
var h__9988__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9988__auto____$1);

return h__9988__auto____$1;
}
}));

(cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15303(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_15304(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_15305(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_15306(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_15307(coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_15308(coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
}));

(cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_15309(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_15310(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.List(new_meta,self__.first,self__.rest,self__.count,self__.__hash));
}
}));

(cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_15311(coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));
}));

(cljs.core.List.getBasis = (function cljs$core$fn_15312(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"count","count",-514511684,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.List.cljs$lang$type = true);

(cljs.core.List.cljs$lang$ctorStr = "cljs.core/List");

(cljs.core.List.cljs$lang$ctorPrWriter = (function cljs$core$fn_15313(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/List");
}));

/**
 * Positional factory function for cljs.core/List.
 */
cljs.core.__GT_List = (function cljs$core$__GT_List(meta,first,rest,count,__hash){
return (new cljs.core.List(meta,first,rest,count,__hash));
});

/**
 * Returns true if x implements IList
 */
cljs.core.list_QMARK_ = (function cljs$core$list_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (33554432))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IList$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
}
});
(cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15315(){
var this__10717__auto__ = this;
return cljs.core.es6_iterator(this__10717__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.EmptyList = (function (meta){
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 65937614;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.EmptyList.prototype.toString = (function cljs$core$fn_15316(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.EmptyList.prototype.equiv = (function cljs$core$fn_15317(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.EmptyList.prototype.indexOf = (function() {
var cljs$core$fn_15318 = null;
var cljs$core$fn_15318__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_15318__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15318 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15318__1.call(this,x);
case 2:
return cljs$core$fn_15318__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15318.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15318__1;
cljs$core$fn_15318.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15318__2;
return cljs$core$fn_15318;
})()
);

(cljs.core.EmptyList.prototype.lastIndexOf = (function() {
var cljs$core$fn_15319 = null;
var cljs$core$fn_15319__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_15319__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15319 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15319__1.call(this,x);
case 2:
return cljs$core$fn_15319__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15319.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15319__1;
cljs$core$fn_15319.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15319__2;
return cljs$core$fn_15319;
})()
);

(cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15320(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_15321(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.EmptyList(self__.meta));
}));

(cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_15322(coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_15323(coll){
var self__ = this;
var coll__$1 = this;
return (0);
}));

(cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_15324(coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_15325(coll){
var self__ = this;
var coll__$1 = this;
throw (new Error("Can't pop empty list"));
}));

(cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15326(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.empty_ordered_hash;
}));

(cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15327(coll,other){
var self__ = this;
var coll__$1 = this;
if(((cljs.core.list_QMARK_(other)) || (cljs.core.sequential_QMARK_(other)))){
return (cljs.core.seq(other) == null);
} else {
return false;
}
}));

(cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_15328(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_15329(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_15330(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_15331(coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_15332(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_15333(coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_15334(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.EmptyList(new_meta));
}
}));

(cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_15335(coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,null,(1),null));
}));

(cljs.core.EmptyList.getBasis = (function cljs$core$fn_15336(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.EmptyList.cljs$lang$type = true);

(cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList");

(cljs.core.EmptyList.cljs$lang$ctorPrWriter = (function cljs$core$fn_15337(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/EmptyList");
}));

/**
 * Positional factory function for cljs.core/EmptyList.
 */
cljs.core.__GT_EmptyList = (function cljs$core$__GT_EmptyList(meta){
return (new cljs.core.EmptyList(meta));
});

(cljs.core.List.EMPTY = (new cljs.core.EmptyList(null)));
(cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15338(){
var this__10717__auto__ = this;
return cljs.core.es6_iterator(this__10717__auto__);
}));
/**
 * Returns true if coll satisfies? IReversible.
 */
cljs.core.reversible_QMARK_ = (function cljs$core$reversible_QMARK_(coll){
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (134217728))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReversible$)))){
return true;
} else {
if((!coll.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
}
});
/**
 * Returns, in constant time, a seq of the items in rev (which
 *   can be a vector or sorted-map), in reverse order. If rev is empty returns nil
 */
cljs.core.rseq = (function cljs$core$rseq(rev){
return cljs.core._rseq(rev);
});
/**
 * Returns a seq of the items in coll in reverse order. Not lazy.
 */
cljs.core.reverse = (function cljs$core$reverse(coll){
if(cljs.core.reversible_QMARK_(coll)){
var or__9527__auto__ = cljs.core.rseq(coll);
if(or__9527__auto__){
return or__9527__auto__;
} else {
return cljs.core.List.EMPTY;
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll);
}
});
/**
 * Creates a new list containing the items.
 */
cljs.core.list = (function cljs$core$list(var_args){
var args__10866__auto__ = [];
var len__10856__auto___15343 = arguments.length;
var i__10857__auto___15344 = (0);
while(true){
if((i__10857__auto___15344 < len__10856__auto___15343)){
args__10866__auto__.push((arguments[i__10857__auto___15344]));

var G__15345 = (i__10857__auto___15344 + (1));
i__10857__auto___15344 = G__15345;
continue;
} else {
}
break;
}

var argseq__10867__auto__ = ((((0) < args__10866__auto__.length))?(new cljs.core.IndexedSeq(args__10866__auto__.slice((0)),(0),null)):null);
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__10867__auto__);
});

(cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15341(xs){
var arr = (((((xs instanceof cljs.core.IndexedSeq)) && ((xs.i === (0)))))?xs.arr:(function (){var arr = [];
var xs__$1 = xs;
while(true){
if((!((xs__$1 == null)))){
arr.push(cljs.core._first(xs__$1));

var G__15346 = cljs.core._next(xs__$1);
xs__$1 = G__15346;
continue;
} else {
return arr;
}
break;
}
})());
var i = arr.length;
var r = cljs.core.List.EMPTY;
while(true){
if((i > (0))){
var G__15347 = (i - (1));
var G__15348 = cljs.core._conj(r,(arr[(i - (1))]));
i = G__15347;
r = G__15348;
continue;
} else {
return r;
}
break;
}
}));

(cljs.core.list.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.list.cljs$lang$applyTo = (function cljs$core$fn_15342(seq15340){
var self__10842__auto__ = this;
return self__10842__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq15340));
}));


/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Cons = (function (meta,first,rest,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65929452;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.Cons.prototype.toString = (function cljs$core$fn_15349(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Cons.prototype.equiv = (function cljs$core$fn_15350(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Cons.prototype.indexOf = (function() {
var cljs$core$fn_15351 = null;
var cljs$core$fn_15351__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_15351__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15351 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15351__1.call(this,x);
case 2:
return cljs$core$fn_15351__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15351.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15351__1;
cljs$core$fn_15351.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15351__2;
return cljs$core$fn_15351;
})()
);

(cljs.core.Cons.prototype.lastIndexOf = (function() {
var cljs$core$fn_15352 = null;
var cljs$core$fn_15352__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_15352__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15352 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15352__1.call(this,x);
case 2:
return cljs$core$fn_15352__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15352.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15352__1;
cljs$core$fn_15352.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15352__2;
return cljs$core$fn_15352;
})()
);

(cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15353(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_15354(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));
}));

(cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_15355(coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return null;
} else {
return cljs.core.seq(self__.rest);
}
}));

(cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15356(coll){
var self__ = this;
var coll__$1 = this;
var h__9988__auto__ = self__.__hash;
if((!((h__9988__auto__ == null)))){
return h__9988__auto__;
} else {
var h__9988__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9988__auto____$1);

return h__9988__auto____$1;
}
}));

(cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15357(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_15358(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_15359(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_15360(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_15361(coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_15362(coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
}));

(cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_15363(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_15364(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Cons(new_meta,self__.first,self__.rest,self__.__hash));
}
}));

(cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_15365(coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(null,o,coll__$1,null));
}));

(cljs.core.Cons.getBasis = (function cljs$core$fn_15366(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rest","rest",398835108,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Cons.cljs$lang$type = true);

(cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons");

(cljs.core.Cons.cljs$lang$ctorPrWriter = (function cljs$core$fn_15367(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/Cons");
}));

/**
 * Positional factory function for cljs.core/Cons.
 */
cljs.core.__GT_Cons = (function cljs$core$__GT_Cons(meta,first,rest,__hash){
return (new cljs.core.Cons(meta,first,rest,__hash));
});

(cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15368(){
var this__10717__auto__ = this;
return cljs.core.es6_iterator(this__10717__auto__);
}));
/**
 * Returns a new seq where x is the first element and coll is the rest.
 */
cljs.core.cons = (function cljs$core$cons(x,coll){
if((coll == null)){
return (new cljs.core.List(null,x,null,(1),null));
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return (new cljs.core.Cons(null,x,coll,null));
} else {
return (new cljs.core.Cons(null,x,cljs.core.seq(coll),null));

}
}
});
cljs.core.hash_keyword = (function cljs$core$hash_keyword(k){
return ((cljs.core.hash_symbol(k) + (2654435769)) | (0));
});
cljs.core.compare_keywords = (function cljs$core$compare_keywords(a,b){
if((a.fqn === b.fqn)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__9521__auto__ = cljs.core.not(a.ns);
if(and__9521__auto__){
return b.ns;
} else {
return and__9521__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__15370 = a.ns;
var G__15371 = b.ns;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__15370,G__15371);
})();
if(((0) === nsc)){
var G__15372 = a.name;
var G__15373 = b.name;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__15372,G__15373);
} else {
return nsc;
}
}
} else {
var G__15374 = a.name;
var G__15375 = b.name;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__15374,G__15375);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IPrintWithWriter}
*/
cljs.core.Keyword = (function (ns,name,fqn,_hash){
this.ns = ns;
this.name = name;
this.fqn = fqn;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 2153775105;
this.cljs$lang$protocol_mask$partition1$ = 4096;
});
(cljs.core.Keyword.prototype.toString = (function cljs$core$fn_15377(){
var self__ = this;
var _ = this;
return [":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join('');
}));

(cljs.core.Keyword.prototype.equiv = (function cljs$core$fn_15378(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15379(_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Keyword)){
return (self__.fqn === other.fqn);
} else {
return false;
}
}));

(cljs.core.Keyword.prototype.call = (function() {
var cljs$core$fn_15380 = null;
var cljs$core$fn_15380__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});
var cljs$core$fn_15380__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});
cljs$core$fn_15380 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_15380__2.call(this,self__,coll);
case 3:
return cljs$core$fn_15380__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_15380.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15380__2;
cljs$core$fn_15380.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15380__3;
return cljs$core$fn_15380;
})()
);

(cljs.core.Keyword.prototype.apply = (function cljs$core$fn_15381(self__,args15376){
var self__ = this;
var self____$1 = this;
var args__10130__auto__ = cljs.core.aclone(args15376);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10130__auto__.length > (20)))?(function (){var G__15382 = args__10130__auto__.slice((0),(20));
G__15382.push(args__10130__auto__.slice((20)));

return G__15382;
})():args__10130__auto__)));
}));

(cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15383(coll){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
}));

(cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15384(coll,not_found){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
}));

(cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15385(this$){
var self__ = this;
var this$__$1 = this;
var h__9988__auto__ = self__._hash;
if((!((h__9988__auto__ == null)))){
return h__9988__auto__;
} else {
var h__9988__auto____$1 = cljs.core.hash_keyword(this$__$1);
(self__._hash = h__9988__auto____$1);

return h__9988__auto____$1;
}
}));

(cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = (function cljs$core$fn_15386(_){
var self__ = this;
var ___$1 = this;
return self__.name;
}));

(cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = (function cljs$core$fn_15387(_){
var self__ = this;
var ___$1 = this;
return self__.ns;
}));

(cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function cljs$core$fn_15388(o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join(''));
}));

(cljs.core.Keyword.getBasis = (function cljs$core$fn_15389(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns","ns",2082130287,null),new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"fqn","fqn",-1749334463,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Keyword.cljs$lang$type = true);

(cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword");

(cljs.core.Keyword.cljs$lang$ctorPrWriter = (function cljs$core$fn_15390(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/Keyword");
}));

/**
 * Positional factory function for cljs.core/Keyword.
 */
cljs.core.__GT_Keyword = (function cljs$core$__GT_Keyword(ns,name,fqn,_hash){
return (new cljs.core.Keyword(ns,name,fqn,_hash));
});

/**
 * Return true if x is a Keyword
 */
cljs.core.keyword_QMARK_ = (function cljs$core$keyword_QMARK_(x){
return (x instanceof cljs.core.Keyword);
});
/**
 * Efficient test to determine that two keywords are identical.
 */
cljs.core.keyword_identical_QMARK_ = (function cljs$core$keyword_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if((((x instanceof cljs.core.Keyword)) && ((y instanceof cljs.core.Keyword)))){
return (x.fqn === y.fqn);
} else {
return false;
}
}
});
/**
 * Efficient test to determine that two symbols are identical.
 */
cljs.core.symbol_identical_QMARK_ = (function cljs$core$symbol_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if((((x instanceof cljs.core.Symbol)) && ((y instanceof cljs.core.Symbol)))){
return (x.str === y.str);
} else {
return false;
}
}
});
/**
 * Returns the namespace String of a symbol or keyword, or nil if not present.
 */
cljs.core.namespace = (function cljs$core$namespace(x){
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition1$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$INamed$))))?true:false):false)){
return x.cljs$core$INamed$_namespace$arity$1(null);
} else {
throw (new Error(["Doesn't support namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('')));
}
});
/**
 * Return true if x is a symbol or keyword
 */
cljs.core.ident_QMARK_ = (function cljs$core$ident_QMARK_(x){
return (((x instanceof cljs.core.Keyword)) || ((x instanceof cljs.core.Symbol)));
});
/**
 * Return true if x is a symbol or keyword without a namespace
 */
cljs.core.simple_ident_QMARK_ = (function cljs$core$simple_ident_QMARK_(x){
return ((cljs.core.ident_QMARK_(x)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a symbol or keyword with a namespace
 */
cljs.core.qualified_ident_QMARK_ = (function cljs$core$qualified_ident_QMARK_(x){
return cljs.core.boolean$((function (){var and__9521__auto__ = cljs.core.ident_QMARK_(x);
if(and__9521__auto__){
var and__9521__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__9521__auto____$1)){
return true;
} else {
return and__9521__auto____$1;
}
} else {
return and__9521__auto__;
}
})());
});
/**
 * Return true if x is a symbol without a namespace
 */
cljs.core.simple_symbol_QMARK_ = (function cljs$core$simple_symbol_QMARK_(x){
return (((x instanceof cljs.core.Symbol)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a symbol with a namespace
 */
cljs.core.qualified_symbol_QMARK_ = (function cljs$core$qualified_symbol_QMARK_(x){
return cljs.core.boolean$((function (){var and__9521__auto__ = (x instanceof cljs.core.Symbol);
if(and__9521__auto__){
var and__9521__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__9521__auto____$1)){
return true;
} else {
return and__9521__auto____$1;
}
} else {
return and__9521__auto__;
}
})());
});
/**
 * Return true if x is a keyword without a namespace
 */
cljs.core.simple_keyword_QMARK_ = (function cljs$core$simple_keyword_QMARK_(x){
return (((x instanceof cljs.core.Keyword)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a keyword with a namespace
 */
cljs.core.qualified_keyword_QMARK_ = (function cljs$core$qualified_keyword_QMARK_(x){
return cljs.core.boolean$((function (){var and__9521__auto__ = (x instanceof cljs.core.Keyword);
if(and__9521__auto__){
var and__9521__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__9521__auto____$1)){
return true;
} else {
return and__9521__auto____$1;
}
} else {
return and__9521__auto__;
}
})());
});
/**
 * Returns a Keyword with the given namespace and name.  Do not use :
 *   in the keyword strings, it will be added automatically.
 */
cljs.core.keyword = (function cljs$core$keyword(var_args){
var G__15393 = arguments.length;
switch (G__15393) {
case 1:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15394(name){
if((name instanceof cljs.core.Keyword)){
return name;
} else {
if((name instanceof cljs.core.Symbol)){
return (new cljs.core.Keyword(cljs.core.namespace(name),cljs.core.name(name),name.str,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("/",name)){
return (new cljs.core.Keyword(null,name,name,null));
} else {
if(typeof name === 'string'){
var parts = name.split("/");
if((parts.length === (2))){
return (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));
} else {
return (new cljs.core.Keyword(null,(parts[(0)]),name,null));
}
} else {
return null;
}
}
}
}
}));

(cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15395(ns,name){
var ns__$1 = (((ns instanceof cljs.core.Keyword))?cljs.core.name(ns):(((ns instanceof cljs.core.Symbol))?cljs.core.name(ns):ns
));
var name__$1 = (((name instanceof cljs.core.Keyword))?cljs.core.name(name):(((name instanceof cljs.core.Symbol))?cljs.core.name(name):name
));
return (new cljs.core.Keyword(ns__$1,name__$1,[(cljs.core.truth_(ns__$1)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns__$1),"/"].join(''):null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(name__$1)].join(''),null));
}));

(cljs.core.keyword.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.LazySeq = (function (meta,fn,s,__hash){
this.meta = meta;
this.fn = fn;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.LazySeq.prototype.toString = (function cljs$core$fn_15397(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.LazySeq.prototype.equiv = (function cljs$core$fn_15398(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.LazySeq.prototype.sval = (function cljs$core$fn_15399(){
var self__ = this;
var coll = this;
if((self__.fn == null)){
return self__.s;
} else {
(self__.s = (self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null)));

(self__.fn = null);

return self__.s;
}
}));

(cljs.core.LazySeq.prototype.indexOf = (function() {
var cljs$core$fn_15400 = null;
var cljs$core$fn_15400__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_15400__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15400 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15400__1.call(this,x);
case 2:
return cljs$core$fn_15400__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15400.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15400__1;
cljs$core$fn_15400.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15400__2;
return cljs$core$fn_15400;
})()
);

(cljs.core.LazySeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_15401 = null;
var cljs$core$fn_15401__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_15401__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15401 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15401__1.call(this,x);
case 2:
return cljs$core$fn_15401__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15401.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15401__1;
cljs$core$fn_15401.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15401__2;
return cljs$core$fn_15401;
})()
);

(cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15402(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_15403(coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((self__.s == null)){
return null;
} else {
return cljs.core.next(self__.s);
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15404(coll){
var self__ = this;
var coll__$1 = this;
var h__9988__auto__ = self__.__hash;
if((!((h__9988__auto__ == null)))){
return h__9988__auto__;
} else {
var h__9988__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9988__auto____$1);

return h__9988__auto____$1;
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15405(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_15406(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.LazySeq.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function cljs$core$fn_15407(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.not(self__.fn);
}));

(cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_15408(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_15409(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_15410(coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((self__.s == null)){
return null;
} else {
return cljs.core.first(self__.s);
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_15411(coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((!((self__.s == null)))){
return cljs.core.rest(self__.s);
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_15412(coll){
var self__ = this;
var coll__$1 = this;
coll__$1.sval();

if((self__.s == null)){
return null;
} else {
var ls = self__.s;
while(true){
if((ls instanceof cljs.core.LazySeq)){
var G__15418 = ls.sval();
ls = G__15418;
continue;
} else {
(self__.s = ls);

return cljs.core.seq(self__.s);
}
break;
}
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_15413(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.LazySeq(new_meta,(function cljs$core$fn_15413_$_fn_15414(){
return coll__$1.cljs$core$ISeqable$_seq$arity$1(null);
}),null,self__.__hash));
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_15415(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.LazySeq.getBasis = (function cljs$core$fn_15416(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"fn","fn",465265323,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.LazySeq.cljs$lang$type = true);

(cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq");

(cljs.core.LazySeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_15417(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/LazySeq");
}));

/**
 * Positional factory function for cljs.core/LazySeq.
 */
cljs.core.__GT_LazySeq = (function cljs$core$__GT_LazySeq(meta,fn,s,__hash){
return (new cljs.core.LazySeq(meta,fn,s,__hash));
});

(cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15419(){
var this__10717__auto__ = this;
return cljs.core.es6_iterator(this__10717__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ICounted}
*/
cljs.core.ChunkBuffer = (function (buf,end){
this.buf = buf;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 2;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ChunkBuffer.prototype.add = (function cljs$core$fn_15420(o){
var self__ = this;
var _ = this;
(self__.buf[self__.end] = o);

return (self__.end = (self__.end + (1)));
}));

(cljs.core.ChunkBuffer.prototype.chunk = (function cljs$core$fn_15421(){
var self__ = this;
var _ = this;
var ret = (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));
(self__.buf = null);

return ret;
}));

(cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_15422(_){
var self__ = this;
var ___$1 = this;
return self__.end;
}));

(cljs.core.ChunkBuffer.getBasis = (function cljs$core$fn_15423(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"buf","buf",1426618187,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ChunkBuffer.cljs$lang$type = true);

(cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer");

(cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = (function cljs$core$fn_15424(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/ChunkBuffer");
}));

/**
 * Positional factory function for cljs.core/ChunkBuffer.
 */
cljs.core.__GT_ChunkBuffer = (function cljs$core$__GT_ChunkBuffer(buf,end){
return (new cljs.core.ChunkBuffer(buf,end));
});

cljs.core.chunk_buffer = (function cljs$core$chunk_buffer(capacity){
return (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.IChunk}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayChunk = (function (arr,off,end){
this.arr = arr;
this.off = off;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 524306;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_15425(_){
var self__ = this;
var ___$1 = this;
return (self__.end - self__.off);
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_15426(coll,i){
var self__ = this;
var coll__$1 = this;
return (self__.arr[(self__.off + i)]);
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_15427(coll,i,not_found){
var self__ = this;
var coll__$1 = this;
if((((i >= (0))) && ((i < (self__.end - self__.off))))){
return (self__.arr[(self__.off + i)]);
} else {
return not_found;
}
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function cljs$core$fn_15428(coll){
var self__ = this;
var coll__$1 = this;
if((self__.off === self__.end)){
throw (new Error("-drop-first of empty chunk"));
} else {
return (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));
}
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_15429(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_15430(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off);
}));

(cljs.core.ArrayChunk.getBasis = (function cljs$core$fn_15431(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null);
}));

(cljs.core.ArrayChunk.cljs$lang$type = true);

(cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk");

(cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = (function cljs$core$fn_15432(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/ArrayChunk");
}));

/**
 * Positional factory function for cljs.core/ArrayChunk.
 */
cljs.core.__GT_ArrayChunk = (function cljs$core$__GT_ArrayChunk(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk = (function cljs$core$array_chunk(var_args){
var G__15434 = arguments.length;
switch (G__15434) {
case 1:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15435(arr){
return (new cljs.core.ArrayChunk(arr,(0),arr.length));
}));

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15436(arr,off){
return (new cljs.core.ArrayChunk(arr,off,arr.length));
}));

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15437(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
}));

(cljs.core.array_chunk.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.ChunkedCons = (function (chunk,more,meta,__hash){
this.chunk = chunk;
this.more = more;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850732;
this.cljs$lang$protocol_mask$partition1$ = 1536;
});
(cljs.core.ChunkedCons.prototype.toString = (function cljs$core$fn_15439(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ChunkedCons.prototype.equiv = (function cljs$core$fn_15440(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ChunkedCons.prototype.indexOf = (function() {
var cljs$core$fn_15441 = null;
var cljs$core$fn_15441__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_15441__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15441 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15441__1.call(this,x);
case 2:
return cljs$core$fn_15441__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15441.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15441__1;
cljs$core$fn_15441.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15441__2;
return cljs$core$fn_15441;
})()
);

(cljs.core.ChunkedCons.prototype.lastIndexOf = (function() {
var cljs$core$fn_15442 = null;
var cljs$core$fn_15442__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_15442__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15442 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15442__1.call(this,x);
case 2:
return cljs$core$fn_15442__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15442.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15442__1;
cljs$core$fn_15442.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15442__2;
return cljs$core$fn_15442;
})()
);

(cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15443(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_15444(coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,null,null));
} else {
if((self__.more == null)){
return null;
} else {
return cljs.core._seq(self__.more);
}
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15445(coll){
var self__ = this;
var coll__$1 = this;
var h__9988__auto__ = self__.__hash;
if((!((h__9988__auto__ == null)))){
return h__9988__auto__;
} else {
var h__9988__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9988__auto____$1);

return h__9988__auto____$1;
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15446(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_15447(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_15448(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk,(0));
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_15449(coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,null,null));
} else {
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_15450(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function cljs$core$fn_15451(coll){
var self__ = this;
var coll__$1 = this;
return self__.chunk;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function cljs$core$fn_15452(coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_15453(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ChunkedCons(self__.chunk,self__.more,new_meta,self__.__hash));
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_15454(this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,this$__$1);
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function cljs$core$fn_15455(coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return null;
} else {
return self__.more;
}
}));

(cljs.core.ChunkedCons.getBasis = (function cljs$core$fn_15456(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"chunk","chunk",449371907,null),new cljs.core.Symbol(null,"more","more",-418290273,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ChunkedCons.cljs$lang$type = true);

(cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons");

(cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = (function cljs$core$fn_15457(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/ChunkedCons");
}));

/**
 * Positional factory function for cljs.core/ChunkedCons.
 */
cljs.core.__GT_ChunkedCons = (function cljs$core$__GT_ChunkedCons(chunk,more,meta,__hash){
return (new cljs.core.ChunkedCons(chunk,more,meta,__hash));
});

(cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15458(){
var this__10717__auto__ = this;
return cljs.core.es6_iterator(this__10717__auto__);
}));
cljs.core.chunk_cons = (function cljs$core$chunk_cons(chunk,rest){
if((cljs.core._count(chunk) === (0))){
return rest;
} else {
return (new cljs.core.ChunkedCons(chunk,rest,null,null));
}
});
cljs.core.chunk_append = (function cljs$core$chunk_append(b,x){
return b.add(x);
});
cljs.core.chunk = (function cljs$core$chunk(b){
return b.chunk();
});
cljs.core.chunk_first = (function cljs$core$chunk_first(s){
return cljs.core._chunked_first(s);
});
cljs.core.chunk_rest = (function cljs$core$chunk_rest(s){
return cljs.core._chunked_rest(s);
});
cljs.core.chunk_next = (function cljs$core$chunk_next(s){
if((((!((s == null))))?(((((s.cljs$lang$protocol_mask$partition1$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$IChunkedNext$))))?true:false):false)){
return s.cljs$core$IChunkedNext$_chunked_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core._chunked_rest(s));
}
});
/**
 * Returns an array containing the contents of coll.
 */
cljs.core.to_array = (function cljs$core$to_array(coll){
var ary = [];
var s = cljs.core.seq(coll);
while(true){
if((!((s == null)))){
ary.push(cljs.core.first(s));

var G__15460 = cljs.core.next(s);
s = G__15460;
continue;
} else {
return ary;
}
break;
}
});
/**
 * Returns a (potentially-ragged) 2-dimensional array
 *   containing the contents of coll.
 */
cljs.core.to_array_2d = (function cljs$core$to_array_2d(coll){
var ret = (new Array(cljs.core.count(coll)));
var i_15461 = (0);
var xs_15462 = cljs.core.seq(coll);
while(true){
if((xs_15462 == null)){
} else {
(ret[i_15461] = cljs.core.to_array(cljs.core.first(xs_15462)));

var G__15463 = (i_15461 + (1));
var G__15464 = cljs.core.next(xs_15462);
i_15461 = G__15463;
xs_15462 = G__15464;
continue;
}
break;
}

return ret;
});
/**
 * Creates an array of ints. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.int_array = (function cljs$core$int_array(var_args){
var G__15466 = arguments.length;
switch (G__15466) {
case 1:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15467(size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15468(size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__15470 = (i + (1));
var G__15471 = cljs.core.next(s__$1);
i = G__15470;
s__$1 = G__15471;
continue;
} else {
return a;
}
break;
}
} else {
var n__10615__auto___15472 = size;
var i_15473 = (0);
while(true){
if((i_15473 < n__10615__auto___15472)){
(a[i_15473] = init_val_or_seq);

var G__15474 = (i_15473 + (1));
i_15473 = G__15474;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.int_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of longs. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.long_array = (function cljs$core$long_array(var_args){
var G__15476 = arguments.length;
switch (G__15476) {
case 1:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15477(size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15478(size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__15480 = (i + (1));
var G__15481 = cljs.core.next(s__$1);
i = G__15480;
s__$1 = G__15481;
continue;
} else {
return a;
}
break;
}
} else {
var n__10615__auto___15482 = size;
var i_15483 = (0);
while(true){
if((i_15483 < n__10615__auto___15482)){
(a[i_15483] = init_val_or_seq);

var G__15484 = (i_15483 + (1));
i_15483 = G__15484;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.long_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of doubles. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.double_array = (function cljs$core$double_array(var_args){
var G__15486 = arguments.length;
switch (G__15486) {
case 1:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15487(size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15488(size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__15490 = (i + (1));
var G__15491 = cljs.core.next(s__$1);
i = G__15490;
s__$1 = G__15491;
continue;
} else {
return a;
}
break;
}
} else {
var n__10615__auto___15492 = size;
var i_15493 = (0);
while(true){
if((i_15493 < n__10615__auto___15492)){
(a[i_15493] = init_val_or_seq);

var G__15494 = (i_15493 + (1));
i_15493 = G__15494;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.double_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of objects. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.object_array = (function cljs$core$object_array(var_args){
var G__15496 = arguments.length;
switch (G__15496) {
case 1:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15497(size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15498(size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__15500 = (i + (1));
var G__15501 = cljs.core.next(s__$1);
i = G__15500;
s__$1 = G__15501;
continue;
} else {
return a;
}
break;
}
} else {
var n__10615__auto___15502 = size;
var i_15503 = (0);
while(true){
if((i_15503 < n__10615__auto___15502)){
(a[i_15503] = init_val_or_seq);

var G__15504 = (i_15503 + (1));
i_15503 = G__15504;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.object_array.cljs$lang$maxFixedArity = 2);

/**
 * If coll is counted? returns its count, else will count at most the first n
 * elements of coll using its seq
 */
cljs.core.bounded_count = (function cljs$core$bounded_count(n,coll){
if(cljs.core.counted_QMARK_(coll)){
return cljs.core.count(coll);
} else {
var i = (0);
var s = cljs.core.seq(coll);
while(true){
if((((!((s == null)))) && ((i < n)))){
var G__15505 = (i + (1));
var G__15506 = cljs.core.next(s);
i = G__15505;
s = G__15506;
continue;
} else {
return i;
}
break;
}
}
});
cljs.core.spread = (function cljs$core$spread(arglist){
if((arglist == null)){
return null;
} else {
var n = cljs.core.next(arglist);
if((n == null)){
return cljs.core.seq(cljs.core.first(arglist));
} else {
return cljs.core.cons(cljs.core.first(arglist),(cljs.core.spread.cljs$core$IFn$_invoke$arity$1 ? cljs.core.spread.cljs$core$IFn$_invoke$arity$1(n) : cljs.core.spread.call(null,n)));
}
}
});
/**
 * Returns a lazy seq representing the concatenation of the elements in the supplied colls.
 */
cljs.core.concat = (function cljs$core$concat(var_args){
var G__15511 = arguments.length;
switch (G__15511) {
case 0:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15522 = arguments.length;
var i__10857__auto___15523 = (0);
while(true){
if((i__10857__auto___15523 < len__10856__auto___15522)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15523]));

var G__15524 = (i__10857__auto___15523 + (1));
i__10857__auto___15523 = G__15524;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15512(){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15512_$_fn_15513(){
return null;
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15514(x){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15514_$_fn_15515(){
return x;
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15516(x,y){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15516_$_fn_15517(){
var s = cljs.core.seq(x);
if(s){
if(cljs.core.chunked_seq_QMARK_(s)){
return cljs.core.chunk_cons(cljs.core.chunk_first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));
} else {
return cljs.core.cons(cljs.core.first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));
}
} else {
return y;
}
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15518(x,y,zs){
var cat = (function cljs$core$fn_15518_$_cat(xys,zs__$1){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15518_$_cat_$_fn_15519(){
var xys__$1 = cljs.core.seq(xys);
if(xys__$1){
if(cljs.core.chunked_seq_QMARK_(xys__$1)){
return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cljs$core$fn_15518_$_cat(cljs.core.chunk_rest(xys__$1),zs__$1));
} else {
return cljs.core.cons(cljs.core.first(xys__$1),cljs$core$fn_15518_$_cat(cljs.core.rest(xys__$1),zs__$1));
}
} else {
if(cljs.core.truth_(zs__$1)){
return cljs$core$fn_15518_$_cat(cljs.core.first(zs__$1),cljs.core.next(zs__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x,y),zs);
}));

/** @this {Function} */
(cljs.core.concat.cljs$lang$applyTo = (function cljs$core$fn_15520(seq15508){
var G__15509 = cljs.core.first(seq15508);
var seq15508__$1 = cljs.core.next(seq15508);
var G__15510 = cljs.core.first(seq15508__$1);
var seq15508__$2 = cljs.core.next(seq15508__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15509,G__15510,seq15508__$2);
}));

(cljs.core.concat.cljs$lang$maxFixedArity = (2));

/**
 * Creates a new list containing the items prepended to the rest, the
 *   last of which will be treated as a sequence.
 */
cljs.core.list_STAR_ = (function cljs$core$list_STAR_(var_args){
var G__15531 = arguments.length;
switch (G__15531) {
case 1:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15539 = arguments.length;
var i__10857__auto___15540 = (0);
while(true){
if((i__10857__auto___15540 < len__10856__auto___15539)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15540]));

var G__15541 = (i__10857__auto___15540 + (1));
i__10857__auto___15540 = G__15541;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((4) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((4)),(0),null)):null);
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10886__auto__);

}
});

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15532(args){
return cljs.core.seq(args);
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15533(a,args){
return cljs.core.cons(a,args);
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15534(a,b,args){
return cljs.core.cons(a,cljs.core.cons(b,args));
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15535(a,b,c,args){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)));
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15536(a,b,c,d,more){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))));
}));

/** @this {Function} */
(cljs.core.list_STAR_.cljs$lang$applyTo = (function cljs$core$fn_15537(seq15526){
var G__15527 = cljs.core.first(seq15526);
var seq15526__$1 = cljs.core.next(seq15526);
var G__15528 = cljs.core.first(seq15526__$1);
var seq15526__$2 = cljs.core.next(seq15526__$1);
var G__15529 = cljs.core.first(seq15526__$2);
var seq15526__$3 = cljs.core.next(seq15526__$2);
var G__15530 = cljs.core.first(seq15526__$3);
var seq15526__$4 = cljs.core.next(seq15526__$3);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15527,G__15528,G__15529,G__15530,seq15526__$4);
}));

(cljs.core.list_STAR_.cljs$lang$maxFixedArity = (4));

/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core.transient$ = (function cljs$core$transient(coll){
return cljs.core._as_transient(coll);
});
/**
 * Returns a new, persistent version of the transient collection, in
 *   constant time. The transient collection cannot be used after this
 *   call, any such use will throw an exception.
 */
cljs.core.persistent_BANG_ = (function cljs$core$persistent_BANG_(tcoll){
return cljs.core._persistent_BANG_(tcoll);
});
/**
 * Adds val to the transient collection, and return tcoll. The 'addition'
 *   may happen at different 'places' depending on the concrete type.
 */
cljs.core.conj_BANG_ = (function cljs$core$conj_BANG_(var_args){
var G__15546 = arguments.length;
switch (G__15546) {
case 0:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15553 = arguments.length;
var i__10857__auto___15554 = (0);
while(true){
if((i__10857__auto___15554 < len__10856__auto___15553)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15554]));

var G__15555 = (i__10857__auto___15554 + (1));
i__10857__auto___15554 = G__15555;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15547(){
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15548(tcoll){
return tcoll;
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15549(tcoll,val){
return cljs.core._conj_BANG_(tcoll,val);
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15550(tcoll,val,vals){
while(true){
var ntcoll = cljs.core._conj_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__15556 = ntcoll;
var G__15557 = cljs.core.first(vals);
var G__15558 = cljs.core.next(vals);
tcoll = G__15556;
val = G__15557;
vals = G__15558;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.conj_BANG_.cljs$lang$applyTo = (function cljs$core$fn_15551(seq15543){
var G__15544 = cljs.core.first(seq15543);
var seq15543__$1 = cljs.core.next(seq15543);
var G__15545 = cljs.core.first(seq15543__$1);
var seq15543__$2 = cljs.core.next(seq15543__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15544,G__15545,seq15543__$2);
}));

(cljs.core.conj_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * When applied to a transient map, adds mapping of key(s) to
 *   val(s). When applied to a transient vector, sets the val at index.
 *   Note - index must be <= (count vector). Returns coll.
 */
cljs.core.assoc_BANG_ = (function cljs$core$assoc_BANG_(var_args){
var G__15564 = arguments.length;
switch (G__15564) {
case 3:
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15569 = arguments.length;
var i__10857__auto___15570 = (0);
while(true){
if((i__10857__auto___15570 < len__10856__auto___15569)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15570]));

var G__15571 = (i__10857__auto___15570 + (1));
i__10857__auto___15570 = G__15571;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((3) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((3)),(0),null)):null);
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10886__auto__);

}
});

(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15565(tcoll,key,val){
return cljs.core._assoc_BANG_(tcoll,key,val);
}));

(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15566(tcoll,key,val,kvs){
while(true){
var ntcoll = cljs.core._assoc_BANG_(tcoll,key,val);
if(cljs.core.truth_(kvs)){
var G__15572 = ntcoll;
var G__15573 = cljs.core.first(kvs);
var G__15574 = cljs.core.second(kvs);
var G__15575 = cljs.core.nnext(kvs);
tcoll = G__15572;
key = G__15573;
val = G__15574;
kvs = G__15575;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.assoc_BANG_.cljs$lang$applyTo = (function cljs$core$fn_15567(seq15560){
var G__15561 = cljs.core.first(seq15560);
var seq15560__$1 = cljs.core.next(seq15560);
var G__15562 = cljs.core.first(seq15560__$1);
var seq15560__$2 = cljs.core.next(seq15560__$1);
var G__15563 = cljs.core.first(seq15560__$2);
var seq15560__$3 = cljs.core.next(seq15560__$2);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15561,G__15562,G__15563,seq15560__$3);
}));

(cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = (3));

/**
 * Returns a transient map that doesn't contain a mapping for key(s).
 */
cljs.core.dissoc_BANG_ = (function cljs$core$dissoc_BANG_(var_args){
var G__15580 = arguments.length;
switch (G__15580) {
case 2:
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15585 = arguments.length;
var i__10857__auto___15586 = (0);
while(true){
if((i__10857__auto___15586 < len__10856__auto___15585)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15586]));

var G__15587 = (i__10857__auto___15586 + (1));
i__10857__auto___15586 = G__15587;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15581(tcoll,key){
return cljs.core._dissoc_BANG_(tcoll,key);
}));

(cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15582(tcoll,key,ks){
while(true){
var ntcoll = cljs.core._dissoc_BANG_(tcoll,key);
if(cljs.core.truth_(ks)){
var G__15588 = ntcoll;
var G__15589 = cljs.core.first(ks);
var G__15590 = cljs.core.next(ks);
tcoll = G__15588;
key = G__15589;
ks = G__15590;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.dissoc_BANG_.cljs$lang$applyTo = (function cljs$core$fn_15583(seq15577){
var G__15578 = cljs.core.first(seq15577);
var seq15577__$1 = cljs.core.next(seq15577);
var G__15579 = cljs.core.first(seq15577__$1);
var seq15577__$2 = cljs.core.next(seq15577__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15578,G__15579,seq15577__$2);
}));

(cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Removes the last item from a transient vector. If
 *   the collection is empty, throws an exception. Returns tcoll
 */
cljs.core.pop_BANG_ = (function cljs$core$pop_BANG_(tcoll){
return cljs.core._pop_BANG_(tcoll);
});
/**
 * disj[oin]. Returns a transient set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj_BANG_ = (function cljs$core$disj_BANG_(var_args){
var G__15595 = arguments.length;
switch (G__15595) {
case 2:
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15600 = arguments.length;
var i__10857__auto___15601 = (0);
while(true){
if((i__10857__auto___15601 < len__10856__auto___15600)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15601]));

var G__15602 = (i__10857__auto___15601 + (1));
i__10857__auto___15601 = G__15602;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15596(tcoll,val){
return cljs.core._disjoin_BANG_(tcoll,val);
}));

(cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15597(tcoll,val,vals){
while(true){
var ntcoll = cljs.core._disjoin_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__15603 = ntcoll;
var G__15604 = cljs.core.first(vals);
var G__15605 = cljs.core.next(vals);
tcoll = G__15603;
val = G__15604;
vals = G__15605;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.disj_BANG_.cljs$lang$applyTo = (function cljs$core$fn_15598(seq15592){
var G__15593 = cljs.core.first(seq15592);
var seq15592__$1 = cljs.core.next(seq15592);
var G__15594 = cljs.core.first(seq15592__$1);
var seq15592__$2 = cljs.core.next(seq15592__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15593,G__15594,seq15592__$2);
}));

(cljs.core.disj_BANG_.cljs$lang$maxFixedArity = (2));


cljs.core.apply_to = (function cljs$core$apply_to(f,argc,args){
var args__$1 = cljs.core.seq(args);
if((argc === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var a10659 = cljs.core._first(args__$1);
var args__$2 = cljs.core._rest(args__$1);
if((argc === (1))){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(a10659) : f.call(null,a10659));
} else {
var b10660 = cljs.core._first(args__$2);
var args__$3 = cljs.core._rest(args__$2);
if((argc === (2))){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(a10659,b10660) : f.call(null,a10659,b10660));
} else {
var c10661 = cljs.core._first(args__$3);
var args__$4 = cljs.core._rest(args__$3);
if((argc === (3))){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(a10659,b10660,c10661) : f.call(null,a10659,b10660,c10661));
} else {
var d10662 = cljs.core._first(args__$4);
var args__$5 = cljs.core._rest(args__$4);
if((argc === (4))){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(a10659,b10660,c10661,d10662) : f.call(null,a10659,b10660,c10661,d10662));
} else {
var e10663 = cljs.core._first(args__$5);
var args__$6 = cljs.core._rest(args__$5);
if((argc === (5))){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(a10659,b10660,c10661,d10662,e10663) : f.call(null,a10659,b10660,c10661,d10662,e10663));
} else {
var f10664 = cljs.core._first(args__$6);
var args__$7 = cljs.core._rest(args__$6);
if((argc === (6))){
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(a10659,b10660,c10661,d10662,e10663,f10664) : f.call(null,a10659,b10660,c10661,d10662,e10663,f10664));
} else {
var g10665 = cljs.core._first(args__$7);
var args__$8 = cljs.core._rest(args__$7);
if((argc === (7))){
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(a10659,b10660,c10661,d10662,e10663,f10664,g10665) : f.call(null,a10659,b10660,c10661,d10662,e10663,f10664,g10665));
} else {
var h10666 = cljs.core._first(args__$8);
var args__$9 = cljs.core._rest(args__$8);
if((argc === (8))){
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666) : f.call(null,a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666));
} else {
var i10667 = cljs.core._first(args__$9);
var args__$10 = cljs.core._rest(args__$9);
if((argc === (9))){
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666,i10667) : f.call(null,a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666,i10667));
} else {
var j10668 = cljs.core._first(args__$10);
var args__$11 = cljs.core._rest(args__$10);
if((argc === (10))){
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666,i10667,j10668) : f.call(null,a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666,i10667,j10668));
} else {
var k10669 = cljs.core._first(args__$11);
var args__$12 = cljs.core._rest(args__$11);
if((argc === (11))){
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666,i10667,j10668,k10669) : f.call(null,a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666,i10667,j10668,k10669));
} else {
var l10670 = cljs.core._first(args__$12);
var args__$13 = cljs.core._rest(args__$12);
if((argc === (12))){
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666,i10667,j10668,k10669,l10670) : f.call(null,a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666,i10667,j10668,k10669,l10670));
} else {
var m10671 = cljs.core._first(args__$13);
var args__$14 = cljs.core._rest(args__$13);
if((argc === (13))){
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666,i10667,j10668,k10669,l10670,m10671) : f.call(null,a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666,i10667,j10668,k10669,l10670,m10671));
} else {
var n10672 = cljs.core._first(args__$14);
var args__$15 = cljs.core._rest(args__$14);
if((argc === (14))){
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666,i10667,j10668,k10669,l10670,m10671,n10672) : f.call(null,a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666,i10667,j10668,k10669,l10670,m10671,n10672));
} else {
var o10673 = cljs.core._first(args__$15);
var args__$16 = cljs.core._rest(args__$15);
if((argc === (15))){
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666,i10667,j10668,k10669,l10670,m10671,n10672,o10673) : f.call(null,a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666,i10667,j10668,k10669,l10670,m10671,n10672,o10673));
} else {
var p10674 = cljs.core._first(args__$16);
var args__$17 = cljs.core._rest(args__$16);
if((argc === (16))){
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666,i10667,j10668,k10669,l10670,m10671,n10672,o10673,p10674) : f.call(null,a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666,i10667,j10668,k10669,l10670,m10671,n10672,o10673,p10674));
} else {
var q10675 = cljs.core._first(args__$17);
var args__$18 = cljs.core._rest(args__$17);
if((argc === (17))){
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666,i10667,j10668,k10669,l10670,m10671,n10672,o10673,p10674,q10675) : f.call(null,a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666,i10667,j10668,k10669,l10670,m10671,n10672,o10673,p10674,q10675));
} else {
var r10676 = cljs.core._first(args__$18);
var args__$19 = cljs.core._rest(args__$18);
if((argc === (18))){
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666,i10667,j10668,k10669,l10670,m10671,n10672,o10673,p10674,q10675,r10676) : f.call(null,a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666,i10667,j10668,k10669,l10670,m10671,n10672,o10673,p10674,q10675,r10676));
} else {
var s10677 = cljs.core._first(args__$19);
var args__$20 = cljs.core._rest(args__$19);
if((argc === (19))){
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666,i10667,j10668,k10669,l10670,m10671,n10672,o10673,p10674,q10675,r10676,s10677) : f.call(null,a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666,i10667,j10668,k10669,l10670,m10671,n10672,o10673,p10674,q10675,r10676,s10677));
} else {
var t10678 = cljs.core._first(args__$20);
var args__$21 = cljs.core._rest(args__$20);
if((argc === (20))){
return (f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666,i10667,j10668,k10669,l10670,m10671,n10672,o10673,p10674,q10675,r10676,s10677,t10678) : f.call(null,a10659,b10660,c10661,d10662,e10663,f10664,g10665,h10666,i10667,j10668,k10669,l10670,m10671,n10672,o10673,p10674,q10675,r10676,s10677,t10678));
} else {
throw (new Error("Only up to 20 arguments supported on functions"));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

/**
 * Internal. DO NOT USE! Next without the nil? check.
 */
cljs.core.next_STAR_ = (function cljs$core$next_STAR_(coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$))))?true:false):false)){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
});
/**
 * Internal. DO NOT USE!
 *   Assumes args was already called with seq beforehand!
 */
cljs.core.apply_to_simple = (function cljs$core$apply_to_simple(var_args){
var G__15608 = arguments.length;
switch (G__15608) {
case 2:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15609(f,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$0){
return f.cljs$core$IFn$_invoke$arity$0();
} else {
return f.call(f);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(f,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15610(f,a0,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$1){
return f.cljs$core$IFn$_invoke$arity$1(a0);
} else {
return f.call(f,a0);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(f,a0,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15611(f,a0,a1,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$2){
return f.cljs$core$IFn$_invoke$arity$2(a0,a1);
} else {
return f.call(f,a0,a1);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(f,a0,a1,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_15612(f,a0,a1,a2,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$3){
return f.cljs$core$IFn$_invoke$arity$3(a0,a1,a2);
} else {
return f.call(f,a0,a1,a2);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(f,a0,a1,a2,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_15613(f,a0,a1,a2,a3,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$4){
return f.cljs$core$IFn$_invoke$arity$4(a0,a1,a2,a3);
} else {
return f.call(f,a0,a1,a2,a3);
}
} else {
var a4 = cljs.core._first(args);
var next_4 = cljs.core.next(args);
if((next_4 == null)){
if(f.cljs$core$IFn$_invoke$arity$5){
return f.cljs$core$IFn$_invoke$arity$5(a0,a1,a2,a3,a4);
} else {
return f.call(f,a0,a1,a2,a3,a4);
}
} else {
var a5 = cljs.core._first(next_4);
var next_5 = cljs.core.next(next_4);
if((next_5 == null)){
if(f.cljs$core$IFn$_invoke$arity$6){
return f.cljs$core$IFn$_invoke$arity$6(a0,a1,a2,a3,a4,a5);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5);
}
} else {
var a6 = cljs.core._first(next_5);
var next_6 = cljs.core.next(next_5);
if((next_6 == null)){
if(f.cljs$core$IFn$_invoke$arity$7){
return f.cljs$core$IFn$_invoke$arity$7(a0,a1,a2,a3,a4,a5,a6);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6);
}
} else {
var a7 = cljs.core._first(next_6);
var next_7 = cljs.core.next(next_6);
if((next_7 == null)){
if(f.cljs$core$IFn$_invoke$arity$8){
return f.cljs$core$IFn$_invoke$arity$8(a0,a1,a2,a3,a4,a5,a6,a7);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7);
}
} else {
var a8 = cljs.core._first(next_7);
var next_8 = cljs.core.next(next_7);
if((next_8 == null)){
if(f.cljs$core$IFn$_invoke$arity$9){
return f.cljs$core$IFn$_invoke$arity$9(a0,a1,a2,a3,a4,a5,a6,a7,a8);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8);
}
} else {
var a9 = cljs.core._first(next_8);
var next_9 = cljs.core.next(next_8);
if((next_9 == null)){
if(f.cljs$core$IFn$_invoke$arity$10){
return f.cljs$core$IFn$_invoke$arity$10(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);
}
} else {
var a10 = cljs.core._first(next_9);
var next_10 = cljs.core.next(next_9);
if((next_10 == null)){
if(f.cljs$core$IFn$_invoke$arity$11){
return f.cljs$core$IFn$_invoke$arity$11(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
}
} else {
var a11 = cljs.core._first(next_10);
var next_11 = cljs.core.next(next_10);
if((next_11 == null)){
if(f.cljs$core$IFn$_invoke$arity$12){
return f.cljs$core$IFn$_invoke$arity$12(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
}
} else {
var a12 = cljs.core._first(next_11);
var next_12 = cljs.core.next(next_11);
if((next_12 == null)){
if(f.cljs$core$IFn$_invoke$arity$13){
return f.cljs$core$IFn$_invoke$arity$13(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);
}
} else {
var a13 = cljs.core._first(next_12);
var next_13 = cljs.core.next(next_12);
if((next_13 == null)){
if(f.cljs$core$IFn$_invoke$arity$14){
return f.cljs$core$IFn$_invoke$arity$14(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13);
}
} else {
var a14 = cljs.core._first(next_13);
var next_14 = cljs.core.next(next_13);
if((next_14 == null)){
if(f.cljs$core$IFn$_invoke$arity$15){
return f.cljs$core$IFn$_invoke$arity$15(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14);
}
} else {
var a15 = cljs.core._first(next_14);
var next_15 = cljs.core.next(next_14);
if((next_15 == null)){
if(f.cljs$core$IFn$_invoke$arity$16){
return f.cljs$core$IFn$_invoke$arity$16(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);
}
} else {
var a16 = cljs.core._first(next_15);
var next_16 = cljs.core.next(next_15);
if((next_16 == null)){
if(f.cljs$core$IFn$_invoke$arity$17){
return f.cljs$core$IFn$_invoke$arity$17(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16);
}
} else {
var a17 = cljs.core._first(next_16);
var next_17 = cljs.core.next(next_16);
if((next_17 == null)){
if(f.cljs$core$IFn$_invoke$arity$18){
return f.cljs$core$IFn$_invoke$arity$18(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17);
}
} else {
var a18 = cljs.core._first(next_17);
var next_18 = cljs.core.next(next_17);
if((next_18 == null)){
if(f.cljs$core$IFn$_invoke$arity$19){
return f.cljs$core$IFn$_invoke$arity$19(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18);
}
} else {
var a19 = cljs.core._first(next_18);
var next_19 = cljs.core.next(next_18);
if((next_19 == null)){
if(f.cljs$core$IFn$_invoke$arity$20){
return f.cljs$core$IFn$_invoke$arity$20(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19);
}
} else {
var arr__10687__auto__ = [a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19];
var s__10688__auto___15615 = next_19;
while(true){
if(s__10688__auto___15615){
arr__10687__auto__.push(cljs.core._first(s__10688__auto___15615));

var G__15616 = cljs.core.next(s__10688__auto___15615);
s__10688__auto___15615 = G__15616;
continue;
} else {
}
break;
}

return f.apply(f,arr__10687__auto__);
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(cljs.core.apply_to_simple.cljs$lang$maxFixedArity = 6);

/**
 * Applies fn f to the argument list formed by prepending intervening arguments to args.
 */
cljs.core.apply = (function cljs$core$apply(var_args){
var G__15624 = arguments.length;
switch (G__15624) {
case 2:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15632 = arguments.length;
var i__10857__auto___15633 = (0);
while(true){
if((i__10857__auto___15633 < len__10856__auto___15632)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15633]));

var G__15634 = (i__10857__auto___15633 + (1));
i__10857__auto___15633 = G__15634;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((5) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((5)),(0),null)):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__10886__auto__);

}
});

(cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15625(f,args){
if(f.cljs$lang$applyTo){
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = cljs.core.bounded_count((fixed_arity + (1)),args);
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,args);
} else {
return f.cljs$lang$applyTo(args);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2(f,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15626(f,x,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = (cljs.core.bounded_count(fixed_arity,args) + (1));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(f,x,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15627(f,x,y,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x,y,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((2) + cljs.core.bounded_count((fixed_arity - (1)),args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(f,x,y,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_15628(f,x,y,z,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x,y,z,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((3) + cljs.core.bounded_count((fixed_arity - (2)),args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(f,x,y,z,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15629(f,a,b,c,d,args){
if(f.cljs$lang$applyTo){
var spread_args = cljs.core.spread(args);
var arglist = cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,spread_args))));
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((4) + cljs.core.bounded_count((fixed_arity - (3)),spread_args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(f,a,b,c,d,cljs.core.spread(args));
}
}));

/** @this {Function} */
(cljs.core.apply.cljs$lang$applyTo = (function cljs$core$fn_15630(seq15618){
var G__15619 = cljs.core.first(seq15618);
var seq15618__$1 = cljs.core.next(seq15618);
var G__15620 = cljs.core.first(seq15618__$1);
var seq15618__$2 = cljs.core.next(seq15618__$1);
var G__15621 = cljs.core.first(seq15618__$2);
var seq15618__$3 = cljs.core.next(seq15618__$2);
var G__15622 = cljs.core.first(seq15618__$3);
var seq15618__$4 = cljs.core.next(seq15618__$3);
var G__15623 = cljs.core.first(seq15618__$4);
var seq15618__$5 = cljs.core.next(seq15618__$4);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15619,G__15620,G__15621,G__15622,G__15623,seq15618__$5);
}));

(cljs.core.apply.cljs$lang$maxFixedArity = (5));

cljs.core.__destructure_map = (function cljs$core$__destructure_map(gmap){
if((((!((gmap == null))))?(((((gmap.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === gmap.cljs$core$ISeq$))))?true:false):false)){
if(cljs.core.next(gmap)){
return cljs.core.PersistentArrayMap.createAsIfByAssoc(cljs.core.to_array(gmap));
} else {
if(cljs.core.seq(gmap)){
return cljs.core.first(gmap);
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
}
} else {
return gmap;
}
});
/**
 * Returns an object of the same type and value as obj, with
 *   (apply f (meta obj) args) as its metadata.
 */
cljs.core.vary_meta = (function cljs$core$vary_meta(var_args){
var G__15644 = arguments.length;
switch (G__15644) {
case 2:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15668 = arguments.length;
var i__10857__auto___15669 = (0);
while(true){
if((i__10857__auto___15669 < len__10856__auto___15668)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15669]));

var G__15670 = (i__10857__auto___15669 + (1));
i__10857__auto___15669 = G__15670;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((6) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((6)),(0),null)):null);
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__10886__auto__);

}
});

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15645(obj,f){
return cljs.core.with_meta(obj,(function (){var G__15646 = cljs.core.meta(obj);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15646) : f.call(null,G__15646));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15647(obj,f,a){
return cljs.core.with_meta(obj,(function (){var G__15648 = cljs.core.meta(obj);
var G__15649 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15648,G__15649) : f.call(null,G__15648,G__15649));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15650(obj,f,a,b){
return cljs.core.with_meta(obj,(function (){var G__15651 = cljs.core.meta(obj);
var G__15652 = a;
var G__15653 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15651,G__15652,G__15653) : f.call(null,G__15651,G__15652,G__15653));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_15654(obj,f,a,b,c){
return cljs.core.with_meta(obj,(function (){var G__15655 = cljs.core.meta(obj);
var G__15656 = a;
var G__15657 = b;
var G__15658 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__15655,G__15656,G__15657,G__15658) : f.call(null,G__15655,G__15656,G__15657,G__15658));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_15659(obj,f,a,b,c,d){
return cljs.core.with_meta(obj,(function (){var G__15660 = cljs.core.meta(obj);
var G__15661 = a;
var G__15662 = b;
var G__15663 = c;
var G__15664 = d;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__15660,G__15661,G__15662,G__15663,G__15664) : f.call(null,G__15660,G__15661,G__15662,G__15663,G__15664));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15665(obj,f,a,b,c,d,args){
return cljs.core.with_meta(obj,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.meta(obj),a,b,c,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([d,args], 0)));
}));

/** @this {Function} */
(cljs.core.vary_meta.cljs$lang$applyTo = (function cljs$core$fn_15666(seq15637){
var G__15638 = cljs.core.first(seq15637);
var seq15637__$1 = cljs.core.next(seq15637);
var G__15639 = cljs.core.first(seq15637__$1);
var seq15637__$2 = cljs.core.next(seq15637__$1);
var G__15640 = cljs.core.first(seq15637__$2);
var seq15637__$3 = cljs.core.next(seq15637__$2);
var G__15641 = cljs.core.first(seq15637__$3);
var seq15637__$4 = cljs.core.next(seq15637__$3);
var G__15642 = cljs.core.first(seq15637__$4);
var seq15637__$5 = cljs.core.next(seq15637__$4);
var G__15643 = cljs.core.first(seq15637__$5);
var seq15637__$6 = cljs.core.next(seq15637__$5);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15638,G__15639,G__15640,G__15641,G__15642,G__15643,seq15637__$6);
}));

(cljs.core.vary_meta.cljs$lang$maxFixedArity = (6));

/**
 * Same as (not (= obj1 obj2))
 */
cljs.core.not_EQ_ = (function cljs$core$not_EQ_(var_args){
var G__15675 = arguments.length;
switch (G__15675) {
case 1:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15681 = arguments.length;
var i__10857__auto___15682 = (0);
while(true){
if((i__10857__auto___15682 < len__10856__auto___15681)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15682]));

var G__15683 = (i__10857__auto___15682 + (1));
i__10857__auto___15682 = G__15683;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15676(x){
return false;
}));

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15677(x,y){
return (!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)));
}));

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15678(x,y,more){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more));
}));

/** @this {Function} */
(cljs.core.not_EQ_.cljs$lang$applyTo = (function cljs$core$fn_15679(seq15672){
var G__15673 = cljs.core.first(seq15672);
var seq15672__$1 = cljs.core.next(seq15672);
var G__15674 = cljs.core.first(seq15672__$1);
var seq15672__$2 = cljs.core.next(seq15672__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15673,G__15674,seq15672__$2);
}));

(cljs.core.not_EQ_.cljs$lang$maxFixedArity = (2));

/**
 * If coll is empty, returns nil, else coll
 */
cljs.core.not_empty = (function cljs$core$not_empty(coll){
if(cljs.core.seq(coll)){
return coll;
} else {
return null;
}
});
cljs.core.nil_iter = (function cljs$core$nil_iter(){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.t_cljs$core15684 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.t_cljs$core15684 = (function (meta15685){
this.meta15685 = meta15685;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.t_cljs$core15684.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$nil_iter_$_fn_15687(_15686,meta15685__$1){
var self__ = this;
var _15686__$1 = this;
return (new cljs.core.t_cljs$core15684(meta15685__$1));
}));

(cljs.core.t_cljs$core15684.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$nil_iter_$_fn_15688(_15686){
var self__ = this;
var _15686__$1 = this;
return self__.meta15685;
}));

(cljs.core.t_cljs$core15684.prototype.hasNext = (function cljs$core$nil_iter_$_fn_15689(){
var self__ = this;
var _ = this;
return false;
}));

(cljs.core.t_cljs$core15684.prototype.next = (function cljs$core$nil_iter_$_fn_15690(){
var self__ = this;
var _ = this;
return (new Error("No such element"));
}));

(cljs.core.t_cljs$core15684.prototype.remove = (function cljs$core$nil_iter_$_fn_15691(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.t_cljs$core15684.getBasis = (function cljs$core$nil_iter_$_fn_15692(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta15685","meta15685",-1351952820,null)], null);
}));

(cljs.core.t_cljs$core15684.cljs$lang$type = true);

(cljs.core.t_cljs$core15684.cljs$lang$ctorStr = "cljs.core/t_cljs$core15684");

(cljs.core.t_cljs$core15684.cljs$lang$ctorPrWriter = (function cljs$core$nil_iter_$_fn_15693(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/t_cljs$core15684");
}));

/**
 * Positional factory function for cljs.core/t_cljs$core15684.
 */
cljs.core.__GT_t_cljs$core15684 = (function cljs$core$nil_iter_$___GT_t_cljs$core15684(meta15685){
return (new cljs.core.t_cljs$core15684(meta15685));
});

}

return (new cljs.core.t_cljs$core15684(cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
*/
cljs.core.StringIter = (function (s,i){
this.s = s;
this.i = i;
});
(cljs.core.StringIter.prototype.hasNext = (function cljs$core$fn_15694(){
var self__ = this;
var _ = this;
return (self__.i < self__.s.length);
}));

(cljs.core.StringIter.prototype.next = (function cljs$core$fn_15695(){
var self__ = this;
var _ = this;
var ret = self__.s.charAt(self__.i);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.StringIter.prototype.remove = (function cljs$core$fn_15696(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.StringIter.getBasis = (function cljs$core$fn_15697(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.StringIter.cljs$lang$type = true);

(cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter");

(cljs.core.StringIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_15698(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/StringIter");
}));

/**
 * Positional factory function for cljs.core/StringIter.
 */
cljs.core.__GT_StringIter = (function cljs$core$__GT_StringIter(s,i){
return (new cljs.core.StringIter(s,i));
});

cljs.core.string_iter = (function cljs$core$string_iter(x){
return (new cljs.core.StringIter(x,(0)));
});

/**
* @constructor
*/
cljs.core.ArrayIter = (function (arr,i){
this.arr = arr;
this.i = i;
});
(cljs.core.ArrayIter.prototype.hasNext = (function cljs$core$fn_15699(){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
}));

(cljs.core.ArrayIter.prototype.next = (function cljs$core$fn_15700(){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.ArrayIter.prototype.remove = (function cljs$core$fn_15701(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.ArrayIter.getBasis = (function cljs$core$fn_15702(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayIter.cljs$lang$type = true);

(cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter");

(cljs.core.ArrayIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_15703(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/ArrayIter");
}));

/**
 * Positional factory function for cljs.core/ArrayIter.
 */
cljs.core.__GT_ArrayIter = (function cljs$core$__GT_ArrayIter(arr,i){
return (new cljs.core.ArrayIter(arr,i));
});

cljs.core.array_iter = (function cljs$core$array_iter(x){
return (new cljs.core.ArrayIter(x,(0)));
});
cljs.core.INIT = ({});
cljs.core.START = ({});

/**
* @constructor
*/
cljs.core.SeqIter = (function (_seq,_next){
this._seq = _seq;
this._next = _next;
});
(cljs.core.SeqIter.prototype.hasNext = (function cljs$core$fn_15704(){
var self__ = this;
var _ = this;
if((self__._seq === cljs.core.INIT)){
(self__._seq = cljs.core.START);

(self__._next = cljs.core.seq(self__._next));
} else {
if((self__._seq === self__._next)){
(self__._next = cljs.core.next(self__._seq));
} else {
}
}

return (!((self__._next == null)));
}));

(cljs.core.SeqIter.prototype.next = (function cljs$core$fn_15705(){
var self__ = this;
var this$ = this;
if((!(this$.hasNext()))){
throw (new Error("No such element"));
} else {
(self__._seq = self__._next);

return cljs.core.first(self__._next);
}
}));

(cljs.core.SeqIter.prototype.remove = (function cljs$core$fn_15706(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.SeqIter.getBasis = (function cljs$core$fn_15707(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"_seq","_seq",-449557847,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.SeqIter.cljs$lang$type = true);

(cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter");

(cljs.core.SeqIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_15708(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/SeqIter");
}));

/**
 * Positional factory function for cljs.core/SeqIter.
 */
cljs.core.__GT_SeqIter = (function cljs$core$__GT_SeqIter(_seq,_next){
return (new cljs.core.SeqIter(_seq,_next));
});

cljs.core.seq_iter = (function cljs$core$seq_iter(coll){
return (new cljs.core.SeqIter(cljs.core.INIT,coll));
});
cljs.core.iter = (function cljs$core$iter(coll){
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core._iterator(coll);
} else {
if((coll == null)){
return cljs.core.nil_iter();
} else {
if(typeof coll === 'string'){
return cljs.core.string_iter(coll);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_iter(coll);
} else {
if(cljs.core.seqable_QMARK_(coll)){
return cljs.core.seq_iter(coll);
} else {
throw (new Error(["Cannot create iterator from ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll)].join('')));

}
}
}
}
}
});

/**
* @constructor
*/
cljs.core.Many = (function (vals){
this.vals = vals;
});
(cljs.core.Many.prototype.add = (function cljs$core$fn_15709(o){
var self__ = this;
var this$ = this;
self__.vals.push(o);

return this$;
}));

(cljs.core.Many.prototype.remove = (function cljs$core$fn_15710(){
var self__ = this;
var this$ = this;
return self__.vals.shift();
}));

(cljs.core.Many.prototype.isEmpty = (function cljs$core$fn_15711(){
var self__ = this;
var this$ = this;
return (self__.vals.length === (0));
}));

(cljs.core.Many.prototype.toString = (function cljs$core$fn_15712(){
var self__ = this;
var this$ = this;
return ["Many: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.vals)].join('');
}));

(cljs.core.Many.getBasis = (function cljs$core$fn_15713(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"vals","vals",-1886377036,null)], null);
}));

(cljs.core.Many.cljs$lang$type = true);

(cljs.core.Many.cljs$lang$ctorStr = "cljs.core/Many");

(cljs.core.Many.cljs$lang$ctorPrWriter = (function cljs$core$fn_15714(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/Many");
}));

/**
 * Positional factory function for cljs.core/Many.
 */
cljs.core.__GT_Many = (function cljs$core$__GT_Many(vals){
return (new cljs.core.Many(vals));
});

cljs.core.NONE = ({});

/**
* @constructor
*/
cljs.core.Single = (function (val){
this.val = val;
});
(cljs.core.Single.prototype.add = (function cljs$core$fn_15715(o){
var self__ = this;
var this$ = this;
if((self__.val === cljs.core.NONE)){
(self__.val = o);

return this$;
} else {
return (new cljs.core.Many([self__.val,o]));
}
}));

(cljs.core.Single.prototype.remove = (function cljs$core$fn_15716(){
var self__ = this;
var this$ = this;
if((self__.val === cljs.core.NONE)){
throw (new Error("Removing object from empty buffer"));
} else {
var ret = self__.val;
(self__.val = cljs.core.NONE);

return ret;
}
}));

(cljs.core.Single.prototype.isEmpty = (function cljs$core$fn_15717(){
var self__ = this;
var this$ = this;
return (self__.val === cljs.core.NONE);
}));

(cljs.core.Single.prototype.toString = (function cljs$core$fn_15718(){
var self__ = this;
var this$ = this;
return ["Single: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.val)].join('');
}));

(cljs.core.Single.getBasis = (function cljs$core$fn_15719(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Single.cljs$lang$type = true);

(cljs.core.Single.cljs$lang$ctorStr = "cljs.core/Single");

(cljs.core.Single.cljs$lang$ctorPrWriter = (function cljs$core$fn_15720(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/Single");
}));

/**
 * Positional factory function for cljs.core/Single.
 */
cljs.core.__GT_Single = (function cljs$core$__GT_Single(val){
return (new cljs.core.Single(val));
});


/**
* @constructor
*/
cljs.core.Empty = (function (){
});
(cljs.core.Empty.prototype.add = (function cljs$core$fn_15721(o){
var self__ = this;
var this$ = this;
return (new cljs.core.Single(o));
}));

(cljs.core.Empty.prototype.remove = (function cljs$core$fn_15722(){
var self__ = this;
var this$ = this;
throw (new Error("Removing object from empty buffer"));
}));

(cljs.core.Empty.prototype.isEmpty = (function cljs$core$fn_15723(){
var self__ = this;
var this$ = this;
return true;
}));

(cljs.core.Empty.prototype.toString = (function cljs$core$fn_15724(){
var self__ = this;
var this$ = this;
return "Empty";
}));

(cljs.core.Empty.getBasis = (function cljs$core$fn_15725(){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.Empty.cljs$lang$type = true);

(cljs.core.Empty.cljs$lang$ctorStr = "cljs.core/Empty");

(cljs.core.Empty.cljs$lang$ctorPrWriter = (function cljs$core$fn_15726(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/Empty");
}));

/**
 * Positional factory function for cljs.core/Empty.
 */
cljs.core.__GT_Empty = (function cljs$core$__GT_Empty(){
return (new cljs.core.Empty());
});

cljs.core.EMPTY = (new cljs.core.Empty());

/**
* @constructor
*/
cljs.core.MultiIterator = (function (iters){
this.iters = iters;
});
(cljs.core.MultiIterator.prototype.hasNext = (function cljs$core$fn_15727(){
var self__ = this;
var _ = this;
var iters__$1 = cljs.core.seq(self__.iters);
while(true){
if((!((iters__$1 == null)))){
var iter = cljs.core.first(iters__$1);
if((!(iter.hasNext()))){
return false;
} else {
var G__15731 = cljs.core.next(iters__$1);
iters__$1 = G__15731;
continue;
}
} else {
return true;
}
break;
}
}));

(cljs.core.MultiIterator.prototype.next = (function cljs$core$fn_15728(){
var self__ = this;
var _ = this;
var nexts = [];
var n__10615__auto___15732 = self__.iters.length;
var i_15733 = (0);
while(true){
if((i_15733 < n__10615__auto___15732)){
(nexts[i_15733] = (self__.iters[i_15733]).next());

var G__15734 = (i_15733 + (1));
i_15733 = G__15734;
continue;
} else {
}
break;
}

return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(nexts,(0));
}));

(cljs.core.MultiIterator.getBasis = (function cljs$core$fn_15729(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"iters","iters",719353031,null)], null);
}));

(cljs.core.MultiIterator.cljs$lang$type = true);

(cljs.core.MultiIterator.cljs$lang$ctorStr = "cljs.core/MultiIterator");

(cljs.core.MultiIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_15730(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/MultiIterator");
}));

/**
 * Positional factory function for cljs.core/MultiIterator.
 */
cljs.core.__GT_MultiIterator = (function cljs$core$__GT_MultiIterator(iters){
return (new cljs.core.MultiIterator(iters));
});

cljs.core.chunkIteratorSeq = (function cljs$core$chunkIteratorSeq(iter){
return (new cljs.core.LazySeq(null,(function cljs$core$chunkIteratorSeq_$_fn_15735(){
if(iter.hasNext()){
var arr = [];
var n = (0);
while(true){
if(cljs.core.truth_((function (){var and__9521__auto__ = iter.hasNext();
if(cljs.core.truth_(and__9521__auto__)){
return (n < (32));
} else {
return and__9521__auto__;
}
})())){
(arr[n] = iter.next());

var G__15736 = (n + (1));
n = G__15736;
continue;
} else {
return cljs.core.chunk_cons(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3(arr,(0),n),(cljs.core.chunkIteratorSeq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunkIteratorSeq.cljs$core$IFn$_invoke$arity$1(iter) : cljs.core.chunkIteratorSeq.call(null,iter)));
}
break;
}
} else {
return null;
}
}),null,null));
});

/**
* @constructor
*/
cljs.core.TransformerIterator = (function (buffer,_next,completed,xf,sourceIter,multi){
this.buffer = buffer;
this._next = _next;
this.completed = completed;
this.xf = xf;
this.sourceIter = sourceIter;
this.multi = multi;
});
(cljs.core.TransformerIterator.prototype.step = (function cljs$core$fn_15737(){
var self__ = this;
var this$ = this;
if((!((self__._next === cljs.core.NONE)))){
return true;
} else {
while(true){
if((self__._next === cljs.core.NONE)){
if(self__.buffer.isEmpty()){
if(self__.completed){
return false;
} else {
if(self__.sourceIter.hasNext()){
var iter = ((self__.multi)?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xf,cljs.core.cons(null,self__.sourceIter.next())):(function (){var G__15738 = null;
var G__15739 = self__.sourceIter.next();
return (self__.xf.cljs$core$IFn$_invoke$arity$2 ? self__.xf.cljs$core$IFn$_invoke$arity$2(G__15738,G__15739) : self__.xf.call(null,G__15738,G__15739));
})());
if(cljs.core.reduced_QMARK_(iter)){
(self__.xf.cljs$core$IFn$_invoke$arity$1 ? self__.xf.cljs$core$IFn$_invoke$arity$1(null) : self__.xf.call(null,null));

(self__.completed = true);
} else {
}

continue;
} else {
(self__.xf.cljs$core$IFn$_invoke$arity$1 ? self__.xf.cljs$core$IFn$_invoke$arity$1(null) : self__.xf.call(null,null));

(self__.completed = true);

continue;
}
}
} else {
(self__._next = self__.buffer.remove());

continue;
}
} else {
return true;
}
break;
}
}
}));

(cljs.core.TransformerIterator.prototype.hasNext = (function cljs$core$fn_15740(){
var self__ = this;
var this$ = this;
return this$.step();
}));

(cljs.core.TransformerIterator.prototype.next = (function cljs$core$fn_15741(){
var self__ = this;
var this$ = this;
if(this$.hasNext()){
var ret = self__._next;
(self__._next = cljs.core.NONE);

return ret;
} else {
throw (new Error("No such element"));
}
}));

(cljs.core.TransformerIterator.prototype.remove = (function cljs$core$fn_15742(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.TransformerIterator.getBasis = (function cljs$core$fn_15743(){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"buffer","buffer",-2037140571,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"completed","completed",1154475024,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"xf","xf",2042434515,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"sourceIter","sourceIter",1068220306,null),new cljs.core.Symbol(null,"multi","multi",1450238522,null)], null);
}));

(cljs.core.TransformerIterator.cljs$lang$type = true);

(cljs.core.TransformerIterator.cljs$lang$ctorStr = "cljs.core/TransformerIterator");

(cljs.core.TransformerIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_15744(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/TransformerIterator");
}));

/**
 * Positional factory function for cljs.core/TransformerIterator.
 */
cljs.core.__GT_TransformerIterator = (function cljs$core$__GT_TransformerIterator(buffer,_next,completed,xf,sourceIter,multi){
return (new cljs.core.TransformerIterator(buffer,_next,completed,xf,sourceIter,multi));
});

(cljs.core.TransformerIterator.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15745(){
var this__10717__auto__ = this;
return cljs.core.es6_iterator(this__10717__auto__);
}));
cljs.core.transformer_iterator = (function cljs$core$transformer_iterator(xform,sourceIter,multi){
var iterator = (new cljs.core.TransformerIterator(cljs.core.EMPTY,cljs.core.NONE,false,null,sourceIter,multi));
(iterator.xf = (function (){var G__15746 = (function() {
var cljs$core$transformer_iterator_$_fn_15747 = null;
var cljs$core$transformer_iterator_$_fn_15747__0 = (function (){
return null;
});
var cljs$core$transformer_iterator_$_fn_15747__1 = (function (acc){
return acc;
});
var cljs$core$transformer_iterator_$_fn_15747__2 = (function (acc,o){
(iterator.buffer = iterator.buffer.add(o));

return acc;
});
cljs$core$transformer_iterator_$_fn_15747 = function(acc,o){
switch(arguments.length){
case 0:
return cljs$core$transformer_iterator_$_fn_15747__0.call(this);
case 1:
return cljs$core$transformer_iterator_$_fn_15747__1.call(this,acc);
case 2:
return cljs$core$transformer_iterator_$_fn_15747__2.call(this,acc,o);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$transformer_iterator_$_fn_15747.cljs$core$IFn$_invoke$arity$0 = cljs$core$transformer_iterator_$_fn_15747__0;
cljs$core$transformer_iterator_$_fn_15747.cljs$core$IFn$_invoke$arity$1 = cljs$core$transformer_iterator_$_fn_15747__1;
cljs$core$transformer_iterator_$_fn_15747.cljs$core$IFn$_invoke$arity$2 = cljs$core$transformer_iterator_$_fn_15747__2;
return cljs$core$transformer_iterator_$_fn_15747;
})()
;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__15746) : xform.call(null,G__15746));
})());

return iterator;
});
(cljs.core.TransformerIterator.create = (function cljs$core$fn_15748(xform,source){
return cljs.core.transformer_iterator(xform,source,false);
}));
(cljs.core.TransformerIterator.createMulti = (function cljs$core$fn_15749(xform,sources){
return cljs.core.transformer_iterator(xform,(new cljs.core.MultiIterator(cljs.core.to_array(sources))),true);
}));
/**
 * Coerces coll to a (possibly empty) sequence, if it is not already
 *   one. Will not force a lazy seq. (sequence nil) yields (), When a
 *   transducer is supplied, returns a lazy sequence of applications of
 *   the transform to the items in coll(s), i.e. to the set of first
 *   items of each coll, followed by the set of second
 *   items in each coll, until any one of the colls is exhausted.  Any
 *   remaining items in other colls are ignored. The transform should accept
 *   number-of-colls arguments
 */
cljs.core.sequence = (function cljs$core$sequence(var_args){
var G__15754 = arguments.length;
switch (G__15754) {
case 1:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15760 = arguments.length;
var i__10857__auto___15761 = (0);
while(true){
if((i__10857__auto___15761 < len__10856__auto___15760)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15761]));

var G__15762 = (i__10857__auto___15761 + (1));
i__10857__auto___15761 = G__15762;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15755(coll){
if(cljs.core.seq_QMARK_(coll)){
return coll;
} else {
var or__9527__auto__ = cljs.core.seq(coll);
if(or__9527__auto__){
return or__9527__auto__;
} else {
return cljs.core.List.EMPTY;
}
}
}));

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15756(xform,coll){
var or__9527__auto__ = cljs.core.chunkIteratorSeq(cljs.core.TransformerIterator.create(xform,cljs.core.iter(coll)));
if(cljs.core.truth_(or__9527__auto__)){
return or__9527__auto__;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15757(xform,coll,colls){
var or__9527__auto__ = cljs.core.chunkIteratorSeq(cljs.core.TransformerIterator.createMulti(xform,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.iter,cljs.core.cons(coll,colls))));
if(cljs.core.truth_(or__9527__auto__)){
return or__9527__auto__;
} else {
return cljs.core.List.EMPTY;
}
}));

/** @this {Function} */
(cljs.core.sequence.cljs$lang$applyTo = (function cljs$core$fn_15758(seq15751){
var G__15752 = cljs.core.first(seq15751);
var seq15751__$1 = cljs.core.next(seq15751);
var G__15753 = cljs.core.first(seq15751__$1);
var seq15751__$2 = cljs.core.next(seq15751__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15752,G__15753,seq15751__$2);
}));

(cljs.core.sequence.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if (pred x) is logical true for every x in coll, else
 *   false.
 */
cljs.core.every_QMARK_ = (function cljs$core$every_QMARK_(pred,coll){
while(true){
if((cljs.core.seq(coll) == null)){
return true;
} else {
if(cljs.core.truth_((function (){var G__15763 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__15763) : pred.call(null,G__15763));
})())){
var G__15764 = pred;
var G__15765 = cljs.core.next(coll);
pred = G__15764;
coll = G__15765;
continue;
} else {
return false;

}
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for every x in
 *   coll, else true.
 */
cljs.core.not_every_QMARK_ = (function cljs$core$not_every_QMARK_(pred,coll){
return (!(cljs.core.every_QMARK_(pred,coll)));
});
/**
 * Returns the first logical true value of (pred x) for any x in coll,
 *   else nil.  One common idiom is to use a set as pred, for example
 *   this will return :fred if :fred is in the sequence, otherwise nil:
 *   (some #{:fred} coll)
 */
cljs.core.some = (function cljs$core$some(pred,coll){
while(true){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
var or__9527__auto__ = (function (){var G__15766 = cljs.core.first(s);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__15766) : pred.call(null,G__15766));
})();
if(cljs.core.truth_(or__9527__auto__)){
return or__9527__auto__;
} else {
var G__15767 = pred;
var G__15768 = cljs.core.next(s);
pred = G__15767;
coll = G__15768;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for any x in coll,
 *   else true.
 */
cljs.core.not_any_QMARK_ = (function cljs$core$not_any_QMARK_(pred,coll){
return cljs.core.not(cljs.core.some(pred,coll));
});
/**
 * Returns true if n is even, throws an exception if n is not an integer
 */
cljs.core.even_QMARK_ = (function cljs$core$even_QMARK_(n){
if(cljs.core.integer_QMARK_(n)){
return ((n & (1)) === (0));
} else {
throw (new Error(["Argument must be an integer: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)].join('')));
}
});
/**
 * Returns true if n is odd, throws an exception if n is not an integer
 */
cljs.core.odd_QMARK_ = (function cljs$core$odd_QMARK_(n){
return (!(cljs.core.even_QMARK_(n)));
});
/**
 * Takes a fn f and returns a fn that takes the same arguments as f,
 *   has the same effects, if any, and returns the opposite truth value.
 */
cljs.core.complement = (function cljs$core$complement(f){
return (function() {
var cljs$core$complement_$_fn_15769 = null;
var cljs$core$complement_$_fn_15769__0 = (function (){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});
var cljs$core$complement_$_fn_15769__1 = (function (x){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)));
});
var cljs$core$complement_$_fn_15769__2 = (function (x,y){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y)));
});
var cljs$core$complement_$_fn_15769__3 = (function() { 
var G__15770__delegate = function (x,y,zs){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,x,y,zs));
};
var G__15770 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__15771__i = 0, G__15771__a = new Array(arguments.length -  2);
while (G__15771__i < G__15771__a.length) {G__15771__a[G__15771__i] = arguments[G__15771__i + 2]; ++G__15771__i;}
  zs = new cljs.core.IndexedSeq(G__15771__a,0,null);
} 
return G__15770__delegate.call(this,x,y,zs);};
G__15770.cljs$lang$maxFixedArity = 2;
G__15770.cljs$lang$applyTo = (function (arglist__15772){
var x = cljs.core.first(arglist__15772);
arglist__15772 = cljs.core.next(arglist__15772);
var y = cljs.core.first(arglist__15772);
var zs = cljs.core.rest(arglist__15772);
return G__15770__delegate(x,y,zs);
});
G__15770.cljs$core$IFn$_invoke$arity$variadic = G__15770__delegate;
return G__15770;
})()
;
cljs$core$complement_$_fn_15769 = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return cljs$core$complement_$_fn_15769__0.call(this);
case 1:
return cljs$core$complement_$_fn_15769__1.call(this,x);
case 2:
return cljs$core$complement_$_fn_15769__2.call(this,x,y);
default:
var G__15773 = null;
if (arguments.length > 2) {
var G__15774__i = 0, G__15774__a = new Array(arguments.length -  2);
while (G__15774__i < G__15774__a.length) {G__15774__a[G__15774__i] = arguments[G__15774__i + 2]; ++G__15774__i;}
G__15773 = new cljs.core.IndexedSeq(G__15774__a,0,null);
}
return cljs$core$complement_$_fn_15769__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__15773);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$complement_$_fn_15769.cljs$lang$maxFixedArity = 2;
cljs$core$complement_$_fn_15769.cljs$lang$applyTo = cljs$core$complement_$_fn_15769__3.cljs$lang$applyTo;
cljs$core$complement_$_fn_15769.cljs$core$IFn$_invoke$arity$0 = cljs$core$complement_$_fn_15769__0;
cljs$core$complement_$_fn_15769.cljs$core$IFn$_invoke$arity$1 = cljs$core$complement_$_fn_15769__1;
cljs$core$complement_$_fn_15769.cljs$core$IFn$_invoke$arity$2 = cljs$core$complement_$_fn_15769__2;
cljs$core$complement_$_fn_15769.cljs$core$IFn$_invoke$arity$variadic = cljs$core$complement_$_fn_15769__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$complement_$_fn_15769;
})()
});
/**
 * Returns a function that takes any number of arguments and returns x.
 */
cljs.core.constantly = (function cljs$core$constantly(x){
return (function() { 
var cljs$core$constantly_$_fn_15775__delegate = function (args){
return x;
};
var cljs$core$constantly_$_fn_15775 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__15776__i = 0, G__15776__a = new Array(arguments.length -  0);
while (G__15776__i < G__15776__a.length) {G__15776__a[G__15776__i] = arguments[G__15776__i + 0]; ++G__15776__i;}
  args = new cljs.core.IndexedSeq(G__15776__a,0,null);
} 
return cljs$core$constantly_$_fn_15775__delegate.call(this,args);};
cljs$core$constantly_$_fn_15775.cljs$lang$maxFixedArity = 0;
cljs$core$constantly_$_fn_15775.cljs$lang$applyTo = (function (arglist__15777){
var args = cljs.core.seq(arglist__15777);
return cljs$core$constantly_$_fn_15775__delegate(args);
});
cljs$core$constantly_$_fn_15775.cljs$core$IFn$_invoke$arity$variadic = cljs$core$constantly_$_fn_15775__delegate;
return cljs$core$constantly_$_fn_15775;
})()
;
});
/**
 * Takes a set of functions and returns a fn that is the composition
 *   of those fns.  The returned fn takes a variable number of args,
 *   applies the rightmost of fns to the args, the next
 *   fn (right-to-left) to the result, etc.
 */
cljs.core.comp = (function cljs$core$comp(var_args){
var G__15783 = arguments.length;
switch (G__15783) {
case 0:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15810 = arguments.length;
var i__10857__auto___15811 = (0);
while(true){
if((i__10857__auto___15811 < len__10856__auto___15810)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15811]));

var G__15812 = (i__10857__auto___15811 + (1));
i__10857__auto___15811 = G__15812;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((3) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((3)),(0),null)):null);
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10886__auto__);

}
});

(cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15784(){
return cljs.core.identity;
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15785(f){
return f;
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15786(f,g){
return (function() {
var cljs$core$fn_15786_$_fn_15787 = null;
var cljs$core$fn_15786_$_fn_15787__0 = (function (){
var G__15788 = (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15788) : f.call(null,G__15788));
});
var cljs$core$fn_15786_$_fn_15787__1 = (function (x){
var G__15789 = (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null,x));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15789) : f.call(null,G__15789));
});
var cljs$core$fn_15786_$_fn_15787__2 = (function (x,y){
var G__15790 = (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x,y) : g.call(null,x,y));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15790) : f.call(null,G__15790));
});
var cljs$core$fn_15786_$_fn_15787__3 = (function (x,y,z){
var G__15791 = (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x,y,z) : g.call(null,x,y,z));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15791) : f.call(null,G__15791));
});
var cljs$core$fn_15786_$_fn_15787__4 = (function() { 
var G__15813__delegate = function (x,y,z,args){
var G__15792 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15792) : f.call(null,G__15792));
};
var G__15813 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__15814__i = 0, G__15814__a = new Array(arguments.length -  3);
while (G__15814__i < G__15814__a.length) {G__15814__a[G__15814__i] = arguments[G__15814__i + 3]; ++G__15814__i;}
  args = new cljs.core.IndexedSeq(G__15814__a,0,null);
} 
return G__15813__delegate.call(this,x,y,z,args);};
G__15813.cljs$lang$maxFixedArity = 3;
G__15813.cljs$lang$applyTo = (function (arglist__15815){
var x = cljs.core.first(arglist__15815);
arglist__15815 = cljs.core.next(arglist__15815);
var y = cljs.core.first(arglist__15815);
arglist__15815 = cljs.core.next(arglist__15815);
var z = cljs.core.first(arglist__15815);
var args = cljs.core.rest(arglist__15815);
return G__15813__delegate(x,y,z,args);
});
G__15813.cljs$core$IFn$_invoke$arity$variadic = G__15813__delegate;
return G__15813;
})()
;
cljs$core$fn_15786_$_fn_15787 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_15786_$_fn_15787__0.call(this);
case 1:
return cljs$core$fn_15786_$_fn_15787__1.call(this,x);
case 2:
return cljs$core$fn_15786_$_fn_15787__2.call(this,x,y);
case 3:
return cljs$core$fn_15786_$_fn_15787__3.call(this,x,y,z);
default:
var G__15816 = null;
if (arguments.length > 3) {
var G__15817__i = 0, G__15817__a = new Array(arguments.length -  3);
while (G__15817__i < G__15817__a.length) {G__15817__a[G__15817__i] = arguments[G__15817__i + 3]; ++G__15817__i;}
G__15816 = new cljs.core.IndexedSeq(G__15817__a,0,null);
}
return cljs$core$fn_15786_$_fn_15787__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__15816);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15786_$_fn_15787.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15786_$_fn_15787.cljs$lang$applyTo = cljs$core$fn_15786_$_fn_15787__4.cljs$lang$applyTo;
cljs$core$fn_15786_$_fn_15787.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15786_$_fn_15787__0;
cljs$core$fn_15786_$_fn_15787.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15786_$_fn_15787__1;
cljs$core$fn_15786_$_fn_15787.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15786_$_fn_15787__2;
cljs$core$fn_15786_$_fn_15787.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15786_$_fn_15787__3;
cljs$core$fn_15786_$_fn_15787.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15786_$_fn_15787__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15786_$_fn_15787;
})()
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15793(f,g,h){
return (function() {
var cljs$core$fn_15793_$_fn_15794 = null;
var cljs$core$fn_15793_$_fn_15794__0 = (function (){
var G__15795 = (function (){var G__15796 = (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15796) : g.call(null,G__15796));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15795) : f.call(null,G__15795));
});
var cljs$core$fn_15793_$_fn_15794__1 = (function (x){
var G__15797 = (function (){var G__15798 = (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(x) : h.call(null,x));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15798) : g.call(null,G__15798));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15797) : f.call(null,G__15797));
});
var cljs$core$fn_15793_$_fn_15794__2 = (function (x,y){
var G__15799 = (function (){var G__15800 = (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(x,y) : h.call(null,x,y));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15800) : g.call(null,G__15800));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15799) : f.call(null,G__15799));
});
var cljs$core$fn_15793_$_fn_15794__3 = (function (x,y,z){
var G__15801 = (function (){var G__15802 = (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(x,y,z) : h.call(null,x,y,z));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15802) : g.call(null,G__15802));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15801) : f.call(null,G__15801));
});
var cljs$core$fn_15793_$_fn_15794__4 = (function() { 
var G__15818__delegate = function (x,y,z,args){
var G__15803 = (function (){var G__15804 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args);
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15804) : g.call(null,G__15804));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15803) : f.call(null,G__15803));
};
var G__15818 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__15819__i = 0, G__15819__a = new Array(arguments.length -  3);
while (G__15819__i < G__15819__a.length) {G__15819__a[G__15819__i] = arguments[G__15819__i + 3]; ++G__15819__i;}
  args = new cljs.core.IndexedSeq(G__15819__a,0,null);
} 
return G__15818__delegate.call(this,x,y,z,args);};
G__15818.cljs$lang$maxFixedArity = 3;
G__15818.cljs$lang$applyTo = (function (arglist__15820){
var x = cljs.core.first(arglist__15820);
arglist__15820 = cljs.core.next(arglist__15820);
var y = cljs.core.first(arglist__15820);
arglist__15820 = cljs.core.next(arglist__15820);
var z = cljs.core.first(arglist__15820);
var args = cljs.core.rest(arglist__15820);
return G__15818__delegate(x,y,z,args);
});
G__15818.cljs$core$IFn$_invoke$arity$variadic = G__15818__delegate;
return G__15818;
})()
;
cljs$core$fn_15793_$_fn_15794 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_15793_$_fn_15794__0.call(this);
case 1:
return cljs$core$fn_15793_$_fn_15794__1.call(this,x);
case 2:
return cljs$core$fn_15793_$_fn_15794__2.call(this,x,y);
case 3:
return cljs$core$fn_15793_$_fn_15794__3.call(this,x,y,z);
default:
var G__15821 = null;
if (arguments.length > 3) {
var G__15822__i = 0, G__15822__a = new Array(arguments.length -  3);
while (G__15822__i < G__15822__a.length) {G__15822__a[G__15822__i] = arguments[G__15822__i + 3]; ++G__15822__i;}
G__15821 = new cljs.core.IndexedSeq(G__15822__a,0,null);
}
return cljs$core$fn_15793_$_fn_15794__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__15821);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15793_$_fn_15794.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15793_$_fn_15794.cljs$lang$applyTo = cljs$core$fn_15793_$_fn_15794__4.cljs$lang$applyTo;
cljs$core$fn_15793_$_fn_15794.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15793_$_fn_15794__0;
cljs$core$fn_15793_$_fn_15794.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15793_$_fn_15794__1;
cljs$core$fn_15793_$_fn_15794.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15793_$_fn_15794__2;
cljs$core$fn_15793_$_fn_15794.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15793_$_fn_15794__3;
cljs$core$fn_15793_$_fn_15794.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15793_$_fn_15794__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15793_$_fn_15794;
})()
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15805(f1,f2,f3,fs){
var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1,f2,f3,fs));
return (function() { 
var cljs$core$fn_15805_$_fn_15806__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1),args);
var fs__$2 = cljs.core.next(fs__$1);
while(true){
if(fs__$2){
var G__15823 = (function (){var fexpr__15807 = cljs.core.first(fs__$2);
return (fexpr__15807.cljs$core$IFn$_invoke$arity$1 ? fexpr__15807.cljs$core$IFn$_invoke$arity$1(ret) : fexpr__15807.call(null,ret));
})();
var G__15824 = cljs.core.next(fs__$2);
ret = G__15823;
fs__$2 = G__15824;
continue;
} else {
return ret;
}
break;
}
};
var cljs$core$fn_15805_$_fn_15806 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__15825__i = 0, G__15825__a = new Array(arguments.length -  0);
while (G__15825__i < G__15825__a.length) {G__15825__a[G__15825__i] = arguments[G__15825__i + 0]; ++G__15825__i;}
  args = new cljs.core.IndexedSeq(G__15825__a,0,null);
} 
return cljs$core$fn_15805_$_fn_15806__delegate.call(this,args);};
cljs$core$fn_15805_$_fn_15806.cljs$lang$maxFixedArity = 0;
cljs$core$fn_15805_$_fn_15806.cljs$lang$applyTo = (function (arglist__15826){
var args = cljs.core.seq(arglist__15826);
return cljs$core$fn_15805_$_fn_15806__delegate(args);
});
cljs$core$fn_15805_$_fn_15806.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15805_$_fn_15806__delegate;
return cljs$core$fn_15805_$_fn_15806;
})()
;
}));

/** @this {Function} */
(cljs.core.comp.cljs$lang$applyTo = (function cljs$core$fn_15808(seq15779){
var G__15780 = cljs.core.first(seq15779);
var seq15779__$1 = cljs.core.next(seq15779);
var G__15781 = cljs.core.first(seq15779__$1);
var seq15779__$2 = cljs.core.next(seq15779__$1);
var G__15782 = cljs.core.first(seq15779__$2);
var seq15779__$3 = cljs.core.next(seq15779__$2);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15780,G__15781,G__15782,seq15779__$3);
}));

(cljs.core.comp.cljs$lang$maxFixedArity = (3));

/**
 * Takes a function f and fewer than the normal arguments to f, and
 *   returns a fn that takes a variable number of additional args. When
 *   called, the returned function calls f with args + additional args.
 */
cljs.core.partial = (function cljs$core$partial(var_args){
var G__15833 = arguments.length;
switch (G__15833) {
case 1:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15845 = arguments.length;
var i__10857__auto___15846 = (0);
while(true){
if((i__10857__auto___15846 < len__10856__auto___15845)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15846]));

var G__15847 = (i__10857__auto___15846 + (1));
i__10857__auto___15846 = G__15847;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((4) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((4)),(0),null)):null);
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10886__auto__);

}
});

(cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15834(f){
return f;
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15835(f,arg1){
return (function() {
var cljs$core$fn_15835_$_fn_15836 = null;
var cljs$core$fn_15835_$_fn_15836__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(arg1) : f.call(null,arg1));
});
var cljs$core$fn_15835_$_fn_15836__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,x) : f.call(null,arg1,x));
});
var cljs$core$fn_15835_$_fn_15836__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,x,y) : f.call(null,arg1,x,y));
});
var cljs$core$fn_15835_$_fn_15836__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,x,y,z) : f.call(null,arg1,x,y,z));
});
var cljs$core$fn_15835_$_fn_15836__4 = (function() { 
var G__15848__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,x,y,z,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
};
var G__15848 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__15849__i = 0, G__15849__a = new Array(arguments.length -  3);
while (G__15849__i < G__15849__a.length) {G__15849__a[G__15849__i] = arguments[G__15849__i + 3]; ++G__15849__i;}
  args = new cljs.core.IndexedSeq(G__15849__a,0,null);
} 
return G__15848__delegate.call(this,x,y,z,args);};
G__15848.cljs$lang$maxFixedArity = 3;
G__15848.cljs$lang$applyTo = (function (arglist__15850){
var x = cljs.core.first(arglist__15850);
arglist__15850 = cljs.core.next(arglist__15850);
var y = cljs.core.first(arglist__15850);
arglist__15850 = cljs.core.next(arglist__15850);
var z = cljs.core.first(arglist__15850);
var args = cljs.core.rest(arglist__15850);
return G__15848__delegate(x,y,z,args);
});
G__15848.cljs$core$IFn$_invoke$arity$variadic = G__15848__delegate;
return G__15848;
})()
;
cljs$core$fn_15835_$_fn_15836 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_15835_$_fn_15836__0.call(this);
case 1:
return cljs$core$fn_15835_$_fn_15836__1.call(this,x);
case 2:
return cljs$core$fn_15835_$_fn_15836__2.call(this,x,y);
case 3:
return cljs$core$fn_15835_$_fn_15836__3.call(this,x,y,z);
default:
var G__15851 = null;
if (arguments.length > 3) {
var G__15852__i = 0, G__15852__a = new Array(arguments.length -  3);
while (G__15852__i < G__15852__a.length) {G__15852__a[G__15852__i] = arguments[G__15852__i + 3]; ++G__15852__i;}
G__15851 = new cljs.core.IndexedSeq(G__15852__a,0,null);
}
return cljs$core$fn_15835_$_fn_15836__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__15851);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15835_$_fn_15836.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15835_$_fn_15836.cljs$lang$applyTo = cljs$core$fn_15835_$_fn_15836__4.cljs$lang$applyTo;
cljs$core$fn_15835_$_fn_15836.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15835_$_fn_15836__0;
cljs$core$fn_15835_$_fn_15836.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15835_$_fn_15836__1;
cljs$core$fn_15835_$_fn_15836.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15835_$_fn_15836__2;
cljs$core$fn_15835_$_fn_15836.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15835_$_fn_15836__3;
cljs$core$fn_15835_$_fn_15836.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15835_$_fn_15836__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15835_$_fn_15836;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15837(f,arg1,arg2){
return (function() {
var cljs$core$fn_15837_$_fn_15838 = null;
var cljs$core$fn_15837_$_fn_15838__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,arg2) : f.call(null,arg1,arg2));
});
var cljs$core$fn_15837_$_fn_15838__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,x) : f.call(null,arg1,arg2,x));
});
var cljs$core$fn_15837_$_fn_15838__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,x,y) : f.call(null,arg1,arg2,x,y));
});
var cljs$core$fn_15837_$_fn_15838__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,x,y,z) : f.call(null,arg1,arg2,x,y,z));
});
var cljs$core$fn_15837_$_fn_15838__4 = (function() { 
var G__15853__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,x,y,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([z,args], 0));
};
var G__15853 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__15854__i = 0, G__15854__a = new Array(arguments.length -  3);
while (G__15854__i < G__15854__a.length) {G__15854__a[G__15854__i] = arguments[G__15854__i + 3]; ++G__15854__i;}
  args = new cljs.core.IndexedSeq(G__15854__a,0,null);
} 
return G__15853__delegate.call(this,x,y,z,args);};
G__15853.cljs$lang$maxFixedArity = 3;
G__15853.cljs$lang$applyTo = (function (arglist__15855){
var x = cljs.core.first(arglist__15855);
arglist__15855 = cljs.core.next(arglist__15855);
var y = cljs.core.first(arglist__15855);
arglist__15855 = cljs.core.next(arglist__15855);
var z = cljs.core.first(arglist__15855);
var args = cljs.core.rest(arglist__15855);
return G__15853__delegate(x,y,z,args);
});
G__15853.cljs$core$IFn$_invoke$arity$variadic = G__15853__delegate;
return G__15853;
})()
;
cljs$core$fn_15837_$_fn_15838 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_15837_$_fn_15838__0.call(this);
case 1:
return cljs$core$fn_15837_$_fn_15838__1.call(this,x);
case 2:
return cljs$core$fn_15837_$_fn_15838__2.call(this,x,y);
case 3:
return cljs$core$fn_15837_$_fn_15838__3.call(this,x,y,z);
default:
var G__15856 = null;
if (arguments.length > 3) {
var G__15857__i = 0, G__15857__a = new Array(arguments.length -  3);
while (G__15857__i < G__15857__a.length) {G__15857__a[G__15857__i] = arguments[G__15857__i + 3]; ++G__15857__i;}
G__15856 = new cljs.core.IndexedSeq(G__15857__a,0,null);
}
return cljs$core$fn_15837_$_fn_15838__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__15856);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15837_$_fn_15838.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15837_$_fn_15838.cljs$lang$applyTo = cljs$core$fn_15837_$_fn_15838__4.cljs$lang$applyTo;
cljs$core$fn_15837_$_fn_15838.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15837_$_fn_15838__0;
cljs$core$fn_15837_$_fn_15838.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15837_$_fn_15838__1;
cljs$core$fn_15837_$_fn_15838.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15837_$_fn_15838__2;
cljs$core$fn_15837_$_fn_15838.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15837_$_fn_15838__3;
cljs$core$fn_15837_$_fn_15838.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15837_$_fn_15838__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15837_$_fn_15838;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15839(f,arg1,arg2,arg3){
return (function() {
var cljs$core$fn_15839_$_fn_15840 = null;
var cljs$core$fn_15839_$_fn_15840__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,arg3) : f.call(null,arg1,arg2,arg3));
});
var cljs$core$fn_15839_$_fn_15840__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,arg3,x) : f.call(null,arg1,arg2,arg3,x));
});
var cljs$core$fn_15839_$_fn_15840__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,arg3,x,y) : f.call(null,arg1,arg2,arg3,x,y));
});
var cljs$core$fn_15839_$_fn_15840__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(arg1,arg2,arg3,x,y,z) : f.call(null,arg1,arg2,arg3,x,y,z));
});
var cljs$core$fn_15839_$_fn_15840__4 = (function() { 
var G__15858__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3,x,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([y,z,args], 0));
};
var G__15858 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__15859__i = 0, G__15859__a = new Array(arguments.length -  3);
while (G__15859__i < G__15859__a.length) {G__15859__a[G__15859__i] = arguments[G__15859__i + 3]; ++G__15859__i;}
  args = new cljs.core.IndexedSeq(G__15859__a,0,null);
} 
return G__15858__delegate.call(this,x,y,z,args);};
G__15858.cljs$lang$maxFixedArity = 3;
G__15858.cljs$lang$applyTo = (function (arglist__15860){
var x = cljs.core.first(arglist__15860);
arglist__15860 = cljs.core.next(arglist__15860);
var y = cljs.core.first(arglist__15860);
arglist__15860 = cljs.core.next(arglist__15860);
var z = cljs.core.first(arglist__15860);
var args = cljs.core.rest(arglist__15860);
return G__15858__delegate(x,y,z,args);
});
G__15858.cljs$core$IFn$_invoke$arity$variadic = G__15858__delegate;
return G__15858;
})()
;
cljs$core$fn_15839_$_fn_15840 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_15839_$_fn_15840__0.call(this);
case 1:
return cljs$core$fn_15839_$_fn_15840__1.call(this,x);
case 2:
return cljs$core$fn_15839_$_fn_15840__2.call(this,x,y);
case 3:
return cljs$core$fn_15839_$_fn_15840__3.call(this,x,y,z);
default:
var G__15861 = null;
if (arguments.length > 3) {
var G__15862__i = 0, G__15862__a = new Array(arguments.length -  3);
while (G__15862__i < G__15862__a.length) {G__15862__a[G__15862__i] = arguments[G__15862__i + 3]; ++G__15862__i;}
G__15861 = new cljs.core.IndexedSeq(G__15862__a,0,null);
}
return cljs$core$fn_15839_$_fn_15840__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__15861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15839_$_fn_15840.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15839_$_fn_15840.cljs$lang$applyTo = cljs$core$fn_15839_$_fn_15840__4.cljs$lang$applyTo;
cljs$core$fn_15839_$_fn_15840.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15839_$_fn_15840__0;
cljs$core$fn_15839_$_fn_15840.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15839_$_fn_15840__1;
cljs$core$fn_15839_$_fn_15840.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15839_$_fn_15840__2;
cljs$core$fn_15839_$_fn_15840.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15839_$_fn_15840__3;
cljs$core$fn_15839_$_fn_15840.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15839_$_fn_15840__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15839_$_fn_15840;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15841(f,arg1,arg2,arg3,more){
return (function() { 
var cljs$core$fn_15841_$_fn_15842__delegate = function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,arg1,arg2,arg3,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more,args));
};
var cljs$core$fn_15841_$_fn_15842 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__15863__i = 0, G__15863__a = new Array(arguments.length -  0);
while (G__15863__i < G__15863__a.length) {G__15863__a[G__15863__i] = arguments[G__15863__i + 0]; ++G__15863__i;}
  args = new cljs.core.IndexedSeq(G__15863__a,0,null);
} 
return cljs$core$fn_15841_$_fn_15842__delegate.call(this,args);};
cljs$core$fn_15841_$_fn_15842.cljs$lang$maxFixedArity = 0;
cljs$core$fn_15841_$_fn_15842.cljs$lang$applyTo = (function (arglist__15864){
var args = cljs.core.seq(arglist__15864);
return cljs$core$fn_15841_$_fn_15842__delegate(args);
});
cljs$core$fn_15841_$_fn_15842.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15841_$_fn_15842__delegate;
return cljs$core$fn_15841_$_fn_15842;
})()
;
}));

/** @this {Function} */
(cljs.core.partial.cljs$lang$applyTo = (function cljs$core$fn_15843(seq15828){
var G__15829 = cljs.core.first(seq15828);
var seq15828__$1 = cljs.core.next(seq15828);
var G__15830 = cljs.core.first(seq15828__$1);
var seq15828__$2 = cljs.core.next(seq15828__$1);
var G__15831 = cljs.core.first(seq15828__$2);
var seq15828__$3 = cljs.core.next(seq15828__$2);
var G__15832 = cljs.core.first(seq15828__$3);
var seq15828__$4 = cljs.core.next(seq15828__$3);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15829,G__15830,G__15831,G__15832,seq15828__$4);
}));

(cljs.core.partial.cljs$lang$maxFixedArity = (4));

/**
 * Takes a function f, and returns a function that calls f, replacing
 *   a nil first argument to f with the supplied value x. Higher arity
 *   versions can replace arguments in the second and third
 *   positions (y, z). Note that the function f can take any number of
 *   arguments, not just the one(s) being nil-patched.
 */
cljs.core.fnil = (function cljs$core$fnil(var_args){
var G__15866 = arguments.length;
switch (G__15866) {
case 2:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15867(f,x){
return (function() {
var cljs$core$fn_15867_$_fn_15868 = null;
var cljs$core$fn_15867_$_fn_15868__1 = (function (a){
var G__15869 = (((a == null))?x:a);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15869) : f.call(null,G__15869));
});
var cljs$core$fn_15867_$_fn_15868__2 = (function (a,b){
var G__15870 = (((a == null))?x:a);
var G__15871 = b;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15870,G__15871) : f.call(null,G__15870,G__15871));
});
var cljs$core$fn_15867_$_fn_15868__3 = (function (a,b,c){
var G__15872 = (((a == null))?x:a);
var G__15873 = b;
var G__15874 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15872,G__15873,G__15874) : f.call(null,G__15872,G__15873,G__15874));
});
var cljs$core$fn_15867_$_fn_15868__4 = (function() { 
var G__15890__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),b,c,ds);
};
var G__15890 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__15891__i = 0, G__15891__a = new Array(arguments.length -  3);
while (G__15891__i < G__15891__a.length) {G__15891__a[G__15891__i] = arguments[G__15891__i + 3]; ++G__15891__i;}
  ds = new cljs.core.IndexedSeq(G__15891__a,0,null);
} 
return G__15890__delegate.call(this,a,b,c,ds);};
G__15890.cljs$lang$maxFixedArity = 3;
G__15890.cljs$lang$applyTo = (function (arglist__15892){
var a = cljs.core.first(arglist__15892);
arglist__15892 = cljs.core.next(arglist__15892);
var b = cljs.core.first(arglist__15892);
arglist__15892 = cljs.core.next(arglist__15892);
var c = cljs.core.first(arglist__15892);
var ds = cljs.core.rest(arglist__15892);
return G__15890__delegate(a,b,c,ds);
});
G__15890.cljs$core$IFn$_invoke$arity$variadic = G__15890__delegate;
return G__15890;
})()
;
cljs$core$fn_15867_$_fn_15868 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 1:
return cljs$core$fn_15867_$_fn_15868__1.call(this,a);
case 2:
return cljs$core$fn_15867_$_fn_15868__2.call(this,a,b);
case 3:
return cljs$core$fn_15867_$_fn_15868__3.call(this,a,b,c);
default:
var G__15893 = null;
if (arguments.length > 3) {
var G__15894__i = 0, G__15894__a = new Array(arguments.length -  3);
while (G__15894__i < G__15894__a.length) {G__15894__a[G__15894__i] = arguments[G__15894__i + 3]; ++G__15894__i;}
G__15893 = new cljs.core.IndexedSeq(G__15894__a,0,null);
}
return cljs$core$fn_15867_$_fn_15868__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__15893);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15867_$_fn_15868.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15867_$_fn_15868.cljs$lang$applyTo = cljs$core$fn_15867_$_fn_15868__4.cljs$lang$applyTo;
cljs$core$fn_15867_$_fn_15868.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15867_$_fn_15868__1;
cljs$core$fn_15867_$_fn_15868.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15867_$_fn_15868__2;
cljs$core$fn_15867_$_fn_15868.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15867_$_fn_15868__3;
cljs$core$fn_15867_$_fn_15868.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15867_$_fn_15868__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15867_$_fn_15868;
})()
}));

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15875(f,x,y){
return (function() {
var cljs$core$fn_15875_$_fn_15876 = null;
var cljs$core$fn_15875_$_fn_15876__2 = (function (a,b){
var G__15877 = (((a == null))?x:a);
var G__15878 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15877,G__15878) : f.call(null,G__15877,G__15878));
});
var cljs$core$fn_15875_$_fn_15876__3 = (function (a,b,c){
var G__15879 = (((a == null))?x:a);
var G__15880 = (((b == null))?y:b);
var G__15881 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15879,G__15880,G__15881) : f.call(null,G__15879,G__15880,G__15881));
});
var cljs$core$fn_15875_$_fn_15876__4 = (function() { 
var G__15895__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),c,ds);
};
var G__15895 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__15896__i = 0, G__15896__a = new Array(arguments.length -  3);
while (G__15896__i < G__15896__a.length) {G__15896__a[G__15896__i] = arguments[G__15896__i + 3]; ++G__15896__i;}
  ds = new cljs.core.IndexedSeq(G__15896__a,0,null);
} 
return G__15895__delegate.call(this,a,b,c,ds);};
G__15895.cljs$lang$maxFixedArity = 3;
G__15895.cljs$lang$applyTo = (function (arglist__15897){
var a = cljs.core.first(arglist__15897);
arglist__15897 = cljs.core.next(arglist__15897);
var b = cljs.core.first(arglist__15897);
arglist__15897 = cljs.core.next(arglist__15897);
var c = cljs.core.first(arglist__15897);
var ds = cljs.core.rest(arglist__15897);
return G__15895__delegate(a,b,c,ds);
});
G__15895.cljs$core$IFn$_invoke$arity$variadic = G__15895__delegate;
return G__15895;
})()
;
cljs$core$fn_15875_$_fn_15876 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return cljs$core$fn_15875_$_fn_15876__2.call(this,a,b);
case 3:
return cljs$core$fn_15875_$_fn_15876__3.call(this,a,b,c);
default:
var G__15898 = null;
if (arguments.length > 3) {
var G__15899__i = 0, G__15899__a = new Array(arguments.length -  3);
while (G__15899__i < G__15899__a.length) {G__15899__a[G__15899__i] = arguments[G__15899__i + 3]; ++G__15899__i;}
G__15898 = new cljs.core.IndexedSeq(G__15899__a,0,null);
}
return cljs$core$fn_15875_$_fn_15876__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__15898);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15875_$_fn_15876.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15875_$_fn_15876.cljs$lang$applyTo = cljs$core$fn_15875_$_fn_15876__4.cljs$lang$applyTo;
cljs$core$fn_15875_$_fn_15876.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15875_$_fn_15876__2;
cljs$core$fn_15875_$_fn_15876.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15875_$_fn_15876__3;
cljs$core$fn_15875_$_fn_15876.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15875_$_fn_15876__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15875_$_fn_15876;
})()
}));

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15882(f,x,y,z){
return (function() {
var cljs$core$fn_15882_$_fn_15883 = null;
var cljs$core$fn_15882_$_fn_15883__2 = (function (a,b){
var G__15884 = (((a == null))?x:a);
var G__15885 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15884,G__15885) : f.call(null,G__15884,G__15885));
});
var cljs$core$fn_15882_$_fn_15883__3 = (function (a,b,c){
var G__15886 = (((a == null))?x:a);
var G__15887 = (((b == null))?y:b);
var G__15888 = (((c == null))?z:c);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15886,G__15887,G__15888) : f.call(null,G__15886,G__15887,G__15888));
});
var cljs$core$fn_15882_$_fn_15883__4 = (function() { 
var G__15900__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c),ds);
};
var G__15900 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__15901__i = 0, G__15901__a = new Array(arguments.length -  3);
while (G__15901__i < G__15901__a.length) {G__15901__a[G__15901__i] = arguments[G__15901__i + 3]; ++G__15901__i;}
  ds = new cljs.core.IndexedSeq(G__15901__a,0,null);
} 
return G__15900__delegate.call(this,a,b,c,ds);};
G__15900.cljs$lang$maxFixedArity = 3;
G__15900.cljs$lang$applyTo = (function (arglist__15902){
var a = cljs.core.first(arglist__15902);
arglist__15902 = cljs.core.next(arglist__15902);
var b = cljs.core.first(arglist__15902);
arglist__15902 = cljs.core.next(arglist__15902);
var c = cljs.core.first(arglist__15902);
var ds = cljs.core.rest(arglist__15902);
return G__15900__delegate(a,b,c,ds);
});
G__15900.cljs$core$IFn$_invoke$arity$variadic = G__15900__delegate;
return G__15900;
})()
;
cljs$core$fn_15882_$_fn_15883 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return cljs$core$fn_15882_$_fn_15883__2.call(this,a,b);
case 3:
return cljs$core$fn_15882_$_fn_15883__3.call(this,a,b,c);
default:
var G__15903 = null;
if (arguments.length > 3) {
var G__15904__i = 0, G__15904__a = new Array(arguments.length -  3);
while (G__15904__i < G__15904__a.length) {G__15904__a[G__15904__i] = arguments[G__15904__i + 3]; ++G__15904__i;}
G__15903 = new cljs.core.IndexedSeq(G__15904__a,0,null);
}
return cljs$core$fn_15882_$_fn_15883__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__15903);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15882_$_fn_15883.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15882_$_fn_15883.cljs$lang$applyTo = cljs$core$fn_15882_$_fn_15883__4.cljs$lang$applyTo;
cljs$core$fn_15882_$_fn_15883.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15882_$_fn_15883__2;
cljs$core$fn_15882_$_fn_15883.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15882_$_fn_15883__3;
cljs$core$fn_15882_$_fn_15883.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15882_$_fn_15883__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15882_$_fn_15883;
})()
}));

(cljs.core.fnil.cljs$lang$maxFixedArity = 4);

/**
 * Returns a lazy sequence consisting of the result of applying f to 0
 *   and the first item of coll, followed by applying f to 1 and the second
 *   item in coll, etc, until coll is exhausted. Thus function f should
 *   accept 2 arguments, index and item. Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.map_indexed = (function cljs$core$map_indexed(var_args){
var G__15906 = arguments.length;
switch (G__15906) {
case 1:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15907(f){
return (function cljs$core$fn_15907_$_fn_15908(rf){
var i = cljs.core.volatile_BANG_((-1));
return (function() {
var cljs$core$fn_15907_$_fn_15908_$_fn_15909 = null;
var cljs$core$fn_15907_$_fn_15908_$_fn_15909__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_15907_$_fn_15908_$_fn_15909__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_15907_$_fn_15908_$_fn_15909__2 = (function (result,input){
var G__15910 = result;
var G__15911 = (function (){var G__15912 = i.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(i.cljs$core$IDeref$_deref$arity$1(null) + (1)));
var G__15913 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15912,G__15913) : f.call(null,G__15912,G__15913));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__15910,G__15911) : rf.call(null,G__15910,G__15911));
});
cljs$core$fn_15907_$_fn_15908_$_fn_15909 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_15907_$_fn_15908_$_fn_15909__0.call(this);
case 1:
return cljs$core$fn_15907_$_fn_15908_$_fn_15909__1.call(this,result);
case 2:
return cljs$core$fn_15907_$_fn_15908_$_fn_15909__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15907_$_fn_15908_$_fn_15909.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15907_$_fn_15908_$_fn_15909__0;
cljs$core$fn_15907_$_fn_15908_$_fn_15909.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15907_$_fn_15908_$_fn_15909__1;
cljs$core$fn_15907_$_fn_15908_$_fn_15909.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15907_$_fn_15908_$_fn_15909__2;
return cljs$core$fn_15907_$_fn_15908_$_fn_15909;
})()
});
}));

(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15914(f,coll){
var mapi = (function cljs$core$fn_15914_$_mapi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15914_$_mapi_$_fn_15920(){
var temp__5720__auto__ = cljs.core.seq(coll__$1);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__10615__auto___15926 = size;
var i_15927 = (0);
while(true){
if((i_15927 < n__10615__auto___15926)){
cljs.core.chunk_append(b,(function (){var G__15921 = (idx + i_15927);
var G__15922 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_15927);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15921,G__15922) : f.call(null,G__15921,G__15922));
})());

var G__15928 = (i_15927 + (1));
i_15927 = G__15928;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$fn_15914_$_mapi((idx + size),cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__15923 = idx;
var G__15924 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15923,G__15924) : f.call(null,G__15923,G__15924));
})(),cljs$core$fn_15914_$_mapi((idx + (1)),cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
return mapi((0),coll);
}));

(cljs.core.map_indexed.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the non-nil results of (f item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a transducer when no collection is provided.
 */
cljs.core.keep = (function cljs$core$keep(var_args){
var G__15930 = arguments.length;
switch (G__15930) {
case 1:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15931(f){
return (function cljs$core$fn_15931_$_fn_15932(rf){
return (function() {
var cljs$core$fn_15931_$_fn_15932_$_fn_15933 = null;
var cljs$core$fn_15931_$_fn_15932_$_fn_15933__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_15931_$_fn_15932_$_fn_15933__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_15931_$_fn_15932_$_fn_15933__2 = (function (result,input){
var v = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
cljs$core$fn_15931_$_fn_15932_$_fn_15933 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_15931_$_fn_15932_$_fn_15933__0.call(this);
case 1:
return cljs$core$fn_15931_$_fn_15932_$_fn_15933__1.call(this,result);
case 2:
return cljs$core$fn_15931_$_fn_15932_$_fn_15933__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15931_$_fn_15932_$_fn_15933.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15931_$_fn_15932_$_fn_15933__0;
cljs$core$fn_15931_$_fn_15932_$_fn_15933.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15931_$_fn_15932_$_fn_15933__1;
cljs$core$fn_15931_$_fn_15932_$_fn_15933.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15931_$_fn_15932_$_fn_15933__2;
return cljs$core$fn_15931_$_fn_15932_$_fn_15933;
})()
});
}));

(cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15934(f,coll){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15934_$_fn_15935(){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__10615__auto___15939 = size;
var i_15940 = (0);
while(true){
if((i_15940 < n__10615__auto___15939)){
var x_15941 = (function (){var G__15936 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_15940);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15936) : f.call(null,G__15936));
})();
if((x_15941 == null)){
} else {
cljs.core.chunk_append(b,x_15941);
}

var G__15942 = (i_15940 + (1));
i_15940 = G__15942;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__15937 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15937) : f.call(null,G__15937));
})();
if((x == null)){
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.keep.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IWatchable}
 * @implements {cljs.core.IAtom}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Atom = (function (state,meta,validator,watches){
this.state = state;
this.meta = meta;
this.validator = validator;
this.watches = watches;
this.cljs$lang$protocol_mask$partition1$ = 16386;
this.cljs$lang$protocol_mask$partition0$ = 6455296;
});
(cljs.core.Atom.prototype.equiv = (function cljs$core$fn_15943(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15944(o,other){
var self__ = this;
var o__$1 = this;
return (o__$1 === other);
}));

(cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = (function cljs$core$fn_15945(_){
var self__ = this;
var ___$1 = this;
return self__.state;
}));

(cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15946(_){
var self__ = this;
var ___$1 = this;
return self__.meta;
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function cljs$core$fn_15947(this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
var seq__15948 = cljs.core.seq(self__.watches);
var chunk__15949 = null;
var count__15950 = (0);
var i__15951 = (0);
while(true){
if((i__15951 < count__15950)){
var vec__15958 = chunk__15949.cljs$core$IIndexed$_nth$arity$2(null,i__15951);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15958,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15958,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));


var G__15969 = seq__15948;
var G__15970 = chunk__15949;
var G__15971 = count__15950;
var G__15972 = (i__15951 + (1));
seq__15948 = G__15969;
chunk__15949 = G__15970;
count__15950 = G__15971;
i__15951 = G__15972;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__15948);
if(temp__5720__auto__){
var seq__15948__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15948__$1)){
var c__10499__auto__ = cljs.core.chunk_first(seq__15948__$1);
var G__15973 = cljs.core.chunk_rest(seq__15948__$1);
var G__15974 = c__10499__auto__;
var G__15975 = cljs.core.count(c__10499__auto__);
var G__15976 = (0);
seq__15948 = G__15973;
chunk__15949 = G__15974;
count__15950 = G__15975;
i__15951 = G__15976;
continue;
} else {
var vec__15961 = cljs.core.first(seq__15948__$1);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15961,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15961,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));


var G__15977 = cljs.core.next(seq__15948__$1);
var G__15978 = null;
var G__15979 = (0);
var G__15980 = (0);
seq__15948 = G__15977;
chunk__15949 = G__15978;
count__15950 = G__15979;
i__15951 = G__15980;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function cljs$core$fn_15964(this$,key,f){
var self__ = this;
var this$__$1 = this;
(this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches,key,f));

return this$__$1;
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function cljs$core$fn_15965(this$,key){
var self__ = this;
var this$__$1 = this;
return (this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches,key));
}));

(cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15966(this$){
var self__ = this;
var this$__$1 = this;
return goog.getUid(this$__$1);
}));

(cljs.core.Atom.getBasis = (function cljs$core$fn_15967(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"validator","validator",-325659154,null),new cljs.core.Symbol(null,"watches","watches",1367433992,null)], null);
}));

(cljs.core.Atom.cljs$lang$type = true);

(cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom");

(cljs.core.Atom.cljs$lang$ctorPrWriter = (function cljs$core$fn_15968(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/Atom");
}));

/**
 * Positional factory function for cljs.core/Atom.
 */
cljs.core.__GT_Atom = (function cljs$core$__GT_Atom(state,meta,validator,watches){
return (new cljs.core.Atom(state,meta,validator,watches));
});

/**
 * Creates and returns an Atom with an initial value of x and zero or
 *   more options (in any order):
 * 
 *   :meta metadata-map
 * 
 *   :validator validate-fn
 * 
 *   If metadata-map is supplied, it will become the metadata on the
 *   atom. validate-fn must be nil or a side-effect-free fn of one
 *   argument, which will be passed the intended new state on any state
 *   change. If the new state is unacceptable, the validate-fn should
 *   return false or throw an Error.  If either of these error conditions
 *   occur, then the value of the atom will not change.
 */
cljs.core.atom = (function cljs$core$atom(var_args){
var G__15984 = arguments.length;
switch (G__15984) {
case 1:
return cljs.core.atom.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___15991 = arguments.length;
var i__10857__auto___15992 = (0);
while(true){
if((i__10857__auto___15992 < len__10856__auto___15991)){
args_arr__10885__auto__.push((arguments[i__10857__auto___15992]));

var G__15993 = (i__10857__auto___15992 + (1));
i__10857__auto___15992 = G__15993;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((1) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((1)),(0),null)):null);
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10886__auto__);

}
});

(cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15985(x){
return (new cljs.core.Atom(x,null,null,null));
}));

(cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15987(x,p__15986){
var map__15988 = p__15986;
var map__15988__$1 = cljs.core.__destructure_map(map__15988);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15988__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15988__$1,new cljs.core.Keyword(null,"validator","validator",-1966190681));
return (new cljs.core.Atom(x,meta,validator,null));
}));

/** @this {Function} */
(cljs.core.atom.cljs$lang$applyTo = (function cljs$core$fn_15989(seq15982){
var G__15983 = cljs.core.first(seq15982);
var seq15982__$1 = cljs.core.next(seq15982);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15983,seq15982__$1);
}));

(cljs.core.atom.cljs$lang$maxFixedArity = (1));

/**
 * Sets the value of atom to newval without regard for the
 *   current value. Returns new-value.
 */
cljs.core.reset_BANG_ = (function cljs$core$reset_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null,new_value)))){
} else {
throw (new Error("Validator rejected reference state"));
}
}

var old_value = a.state;
(a.state = new_value);

if((a.watches == null)){
} else {
a.cljs$core$IWatchable$_notify_watches$arity$3(null,old_value,new_value);
}

return new_value;
} else {
return cljs.core._reset_BANG_(a,new_value);
}
});
/**
 * Sets the value of atom to newval. Returns [old new], the value of the
 * atom before and after the reset.
 */
cljs.core.reset_vals_BANG_ = (function cljs$core$reset_vals_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null,new_value)))){
} else {
throw (new Error("Validator rejected reference state"));
}
}

var old_value = a.state;
(a.state = new_value);

if((a.watches == null)){
} else {
a.cljs$core$IWatchable$_notify_watches$arity$3(null,old_value,new_value);
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_value,new_value], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._reset_BANG_(a,new_value)], null);
}
});
/**
 * Atomically swaps the value of atom to be:
 *   (apply f current-value-of-atom args). Note that f may be called
 *   multiple times, and thus should be free of side effects.  Returns
 *   the value that was swapped in.
 */
cljs.core.swap_BANG_ = (function cljs$core$swap_BANG_(var_args){
var G__16000 = arguments.length;
switch (G__16000) {
case 2:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___16013 = arguments.length;
var i__10857__auto___16014 = (0);
while(true){
if((i__10857__auto___16014 < len__10856__auto___16013)){
args_arr__10885__auto__.push((arguments[i__10857__auto___16014]));

var G__16015 = (i__10857__auto___16014 + (1));
i__10857__auto___16014 = G__16015;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((4) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((4)),(0),null)):null);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10886__auto__);

}
});

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16001(a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__16002 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16002) : f.call(null,G__16002));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16003(a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__16004 = a.state;
var G__16005 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16004,G__16005) : f.call(null,G__16004,G__16005));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16006(a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__16007 = a.state;
var G__16008 = x;
var G__16009 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16007,G__16008,G__16009) : f.call(null,G__16007,G__16008,G__16009));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16010(a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more);
}
}));

/** @this {Function} */
(cljs.core.swap_BANG_.cljs$lang$applyTo = (function cljs$core$fn_16011(seq15995){
var G__15996 = cljs.core.first(seq15995);
var seq15995__$1 = cljs.core.next(seq15995);
var G__15997 = cljs.core.first(seq15995__$1);
var seq15995__$2 = cljs.core.next(seq15995__$1);
var G__15998 = cljs.core.first(seq15995__$2);
var seq15995__$3 = cljs.core.next(seq15995__$2);
var G__15999 = cljs.core.first(seq15995__$3);
var seq15995__$4 = cljs.core.next(seq15995__$3);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15996,G__15997,G__15998,G__15999,seq15995__$4);
}));

(cljs.core.swap_BANG_.cljs$lang$maxFixedArity = (4));

/**
 * Atomically swaps the value of atom to be:
 *   (apply f current-value-of-atom args). Note that f may be called
 *   multiple times, and thus should be free of side effects.
 *   Returns [old new], the value of the atom before and after the swap.
 */
cljs.core.swap_vals_BANG_ = (function cljs$core$swap_vals_BANG_(var_args){
var G__16022 = arguments.length;
switch (G__16022) {
case 2:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___16035 = arguments.length;
var i__10857__auto___16036 = (0);
while(true){
if((i__10857__auto___16036 < len__10856__auto___16035)){
args_arr__10885__auto__.push((arguments[i__10857__auto___16036]));

var G__16037 = (i__10857__auto___16036 + (1));
i__10857__auto___16036 = G__16037;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((4) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((4)),(0),null)):null);
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10886__auto__);

}
});

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16023(a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_vals_BANG_(a,(function (){var G__16024 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16024) : f.call(null,G__16024));
})());
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f)], null);
}
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16025(a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_vals_BANG_(a,(function (){var G__16026 = a.state;
var G__16027 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16026,G__16027) : f.call(null,G__16026,G__16027));
})());
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x)], null);
}
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16028(a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_vals_BANG_(a,(function (){var G__16029 = a.state;
var G__16030 = x;
var G__16031 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16029,G__16030,G__16031) : f.call(null,G__16029,G__16030,G__16031));
})());
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y)], null);
}
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16032(a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_vals_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more)], null);
}
}));

/** @this {Function} */
(cljs.core.swap_vals_BANG_.cljs$lang$applyTo = (function cljs$core$fn_16033(seq16017){
var G__16018 = cljs.core.first(seq16017);
var seq16017__$1 = cljs.core.next(seq16017);
var G__16019 = cljs.core.first(seq16017__$1);
var seq16017__$2 = cljs.core.next(seq16017__$1);
var G__16020 = cljs.core.first(seq16017__$2);
var seq16017__$3 = cljs.core.next(seq16017__$2);
var G__16021 = cljs.core.first(seq16017__$3);
var seq16017__$4 = cljs.core.next(seq16017__$3);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16018,G__16019,G__16020,G__16021,seq16017__$4);
}));

(cljs.core.swap_vals_BANG_.cljs$lang$maxFixedArity = (4));

/**
 * Atomically sets the value of atom to newval if and only if the
 *   current value of the atom is equal to oldval. Returns true if
 *   set happened, else false.
 */
cljs.core.compare_and_set_BANG_ = (function cljs$core$compare_and_set_BANG_(a,oldval,newval){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null),oldval)){
cljs.core.reset_BANG_(a,newval);

return true;
} else {
return false;
}
});
/**
 * Sets the validator-fn for an atom. validator-fn must be nil or a
 *   side-effect-free fn of one argument, which will be passed the intended
 *   new state on any state change. If the new state is unacceptable, the
 *   validator-fn should return false or throw an Error. If the current state
 *   is not acceptable to the new validator, an Error will be thrown and the
 *   validator will not be changed.
 */
cljs.core.set_validator_BANG_ = (function cljs$core$set_validator_BANG_(iref,val){
if((((!((val == null)))) && (cljs.core.not((function (){var G__16038 = cljs.core._deref(iref);
return (val.cljs$core$IFn$_invoke$arity$1 ? val.cljs$core$IFn$_invoke$arity$1(G__16038) : val.call(null,G__16038));
})())))){
throw (new Error("Validator rejected reference state"));
} else {
}

return (iref.validator = val);
});
/**
 * Gets the validator-fn for a var/ref/agent/atom.
 */
cljs.core.get_validator = (function cljs$core$get_validator(iref){
return iref.validator;
});

/**
* @constructor
 * @implements {cljs.core.IVolatile}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Volatile = (function (state){
this.state = state;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Volatile.prototype.cljs$core$IVolatile$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = (function cljs$core$fn_16039(_,new_state){
var self__ = this;
var ___$1 = this;
return (self__.state = new_state);
}));

(cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = (function cljs$core$fn_16040(_){
var self__ = this;
var ___$1 = this;
return self__.state;
}));

(cljs.core.Volatile.getBasis = (function cljs$core$fn_16041(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Volatile.cljs$lang$type = true);

(cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile");

(cljs.core.Volatile.cljs$lang$ctorPrWriter = (function cljs$core$fn_16042(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/Volatile");
}));

/**
 * Positional factory function for cljs.core/Volatile.
 */
cljs.core.__GT_Volatile = (function cljs$core$__GT_Volatile(state){
return (new cljs.core.Volatile(state));
});

/**
 * Creates and returns a Volatile with an initial value of val.
 */
cljs.core.volatile_BANG_ = (function cljs$core$volatile_BANG_(val){
return (new cljs.core.Volatile(val));
});
/**
 * Returns true if x is a volatile.
 */
cljs.core.volatile_QMARK_ = (function cljs$core$volatile_QMARK_(x){
return (x instanceof cljs.core.Volatile);
});
/**
 * Sets the value of volatile to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.vreset_BANG_ = (function cljs$core$vreset_BANG_(vol,newval){
return cljs.core._vreset_BANG_(vol,newval);
});
/**
 * Returns a lazy sequence of the non-nil results of (f index item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a stateful transducer when no collection is
 *   provided.
 */
cljs.core.keep_indexed = (function cljs$core$keep_indexed(var_args){
var G__16044 = arguments.length;
switch (G__16044) {
case 1:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16045(f){
return (function cljs$core$fn_16045_$_fn_16046(rf){
var ia = cljs.core.volatile_BANG_((-1));
return (function() {
var cljs$core$fn_16045_$_fn_16046_$_fn_16047 = null;
var cljs$core$fn_16045_$_fn_16046_$_fn_16047__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16045_$_fn_16046_$_fn_16047__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16045_$_fn_16046_$_fn_16047__2 = (function (result,input){
var i = ia.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(ia.cljs$core$IDeref$_deref$arity$1(null) + (1)));
var v = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(i,input) : f.call(null,i,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
cljs$core$fn_16045_$_fn_16046_$_fn_16047 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16045_$_fn_16046_$_fn_16047__0.call(this);
case 1:
return cljs$core$fn_16045_$_fn_16046_$_fn_16047__1.call(this,result);
case 2:
return cljs$core$fn_16045_$_fn_16046_$_fn_16047__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16045_$_fn_16046_$_fn_16047.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16045_$_fn_16046_$_fn_16047__0;
cljs$core$fn_16045_$_fn_16046_$_fn_16047.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16045_$_fn_16046_$_fn_16047__1;
cljs$core$fn_16045_$_fn_16046_$_fn_16047.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16045_$_fn_16046_$_fn_16047__2;
return cljs$core$fn_16045_$_fn_16046_$_fn_16047;
})()
});
}));

(cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16048(f,coll){
var keepi = (function cljs$core$fn_16048_$_keepi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16048_$_keepi_$_fn_16054(){
var temp__5720__auto__ = cljs.core.seq(coll__$1);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__10615__auto___16060 = size;
var i_16061 = (0);
while(true){
if((i_16061 < n__10615__auto___16060)){
var x_16062 = (function (){var G__16055 = (idx + i_16061);
var G__16056 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_16061);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16055,G__16056) : f.call(null,G__16055,G__16056));
})();
if((x_16062 == null)){
} else {
cljs.core.chunk_append(b,x_16062);
}

var G__16063 = (i_16061 + (1));
i_16061 = G__16063;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$fn_16048_$_keepi((idx + size),cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__16057 = idx;
var G__16058 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16057,G__16058) : f.call(null,G__16057,G__16058));
})();
if((x == null)){
return cljs$core$fn_16048_$_keepi((idx + (1)),cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs$core$fn_16048_$_keepi((idx + (1)),cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
return keepi((0),coll);
}));

(cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2);

/**
 * Takes a set of predicates and returns a function f that returns true if all of its
 *   composing predicates return a logical true value against all of its arguments, else it returns
 *   false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical false result against the original predicates.
 */
cljs.core.every_pred = (function cljs$core$every_pred(var_args){
var G__16075 = arguments.length;
switch (G__16075) {
case 1:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___16088 = arguments.length;
var i__10857__auto___16089 = (0);
while(true){
if((i__10857__auto___16089 < len__10856__auto___16088)){
args_arr__10885__auto__.push((arguments[i__10857__auto___16089]));

var G__16090 = (i__10857__auto___16089 + (1));
i__10857__auto___16089 = G__16090;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((3) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((3)),(0),null)):null);
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10886__auto__);

}
});

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16076(p){
return (function() {
var cljs$core$fn_16076_$_ep1 = null;
var cljs$core$fn_16076_$_ep1__0 = (function (){
return true;
});
var cljs$core$fn_16076_$_ep1__1 = (function (x){
return cljs.core.boolean$((p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x)));
});
var cljs$core$fn_16076_$_ep1__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__9521__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__9521__auto__)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
} else {
return and__9521__auto__;
}
})());
});
var cljs$core$fn_16076_$_ep1__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__9521__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__9521__auto__)){
var and__9521__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(and__9521__auto____$1)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
} else {
return and__9521__auto____$1;
}
} else {
return and__9521__auto__;
}
})());
});
var cljs$core$fn_16076_$_ep1__4 = (function() { 
var G__16091__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__9521__auto__ = cljs$core$fn_16076_$_ep1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__9521__auto__)){
return cljs.core.every_QMARK_(p,args);
} else {
return and__9521__auto__;
}
})());
};
var G__16091 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16092__i = 0, G__16092__a = new Array(arguments.length -  3);
while (G__16092__i < G__16092__a.length) {G__16092__a[G__16092__i] = arguments[G__16092__i + 3]; ++G__16092__i;}
  args = new cljs.core.IndexedSeq(G__16092__a,0,null);
} 
return G__16091__delegate.call(this,x,y,z,args);};
G__16091.cljs$lang$maxFixedArity = 3;
G__16091.cljs$lang$applyTo = (function (arglist__16093){
var x = cljs.core.first(arglist__16093);
arglist__16093 = cljs.core.next(arglist__16093);
var y = cljs.core.first(arglist__16093);
arglist__16093 = cljs.core.next(arglist__16093);
var z = cljs.core.first(arglist__16093);
var args = cljs.core.rest(arglist__16093);
return G__16091__delegate(x,y,z,args);
});
G__16091.cljs$core$IFn$_invoke$arity$variadic = G__16091__delegate;
return G__16091;
})()
;
cljs$core$fn_16076_$_ep1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16076_$_ep1__0.call(this);
case 1:
return cljs$core$fn_16076_$_ep1__1.call(this,x);
case 2:
return cljs$core$fn_16076_$_ep1__2.call(this,x,y);
case 3:
return cljs$core$fn_16076_$_ep1__3.call(this,x,y,z);
default:
var G__16094 = null;
if (arguments.length > 3) {
var G__16095__i = 0, G__16095__a = new Array(arguments.length -  3);
while (G__16095__i < G__16095__a.length) {G__16095__a[G__16095__i] = arguments[G__16095__i + 3]; ++G__16095__i;}
G__16094 = new cljs.core.IndexedSeq(G__16095__a,0,null);
}
return cljs$core$fn_16076_$_ep1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16094);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16076_$_ep1.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16076_$_ep1.cljs$lang$applyTo = cljs$core$fn_16076_$_ep1__4.cljs$lang$applyTo;
cljs$core$fn_16076_$_ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16076_$_ep1__0;
cljs$core$fn_16076_$_ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16076_$_ep1__1;
cljs$core$fn_16076_$_ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16076_$_ep1__2;
cljs$core$fn_16076_$_ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16076_$_ep1__3;
cljs$core$fn_16076_$_ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16076_$_ep1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16076_$_ep1;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16077(p1,p2){
return (function() {
var cljs$core$fn_16077_$_ep2 = null;
var cljs$core$fn_16077_$_ep2__0 = (function (){
return true;
});
var cljs$core$fn_16077_$_ep2__1 = (function (x){
return cljs.core.boolean$((function (){var and__9521__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9521__auto__)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
} else {
return and__9521__auto__;
}
})());
});
var cljs$core$fn_16077_$_ep2__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__9521__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9521__auto__)){
var and__9521__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__9521__auto____$1)){
var and__9521__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__9521__auto____$2)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
} else {
return and__9521__auto____$2;
}
} else {
return and__9521__auto____$1;
}
} else {
return and__9521__auto__;
}
})());
});
var cljs$core$fn_16077_$_ep2__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__9521__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9521__auto__)){
var and__9521__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__9521__auto____$1)){
var and__9521__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__9521__auto____$2)){
var and__9521__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__9521__auto____$3)){
var and__9521__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__9521__auto____$4)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
} else {
return and__9521__auto____$4;
}
} else {
return and__9521__auto____$3;
}
} else {
return and__9521__auto____$2;
}
} else {
return and__9521__auto____$1;
}
} else {
return and__9521__auto__;
}
})());
});
var cljs$core$fn_16077_$_ep2__4 = (function() { 
var G__16096__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__9521__auto__ = cljs$core$fn_16077_$_ep2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__9521__auto__)){
return cljs.core.every_QMARK_((function cljs$core$fn_16077_$_ep2_$_fn_16078(p1__16064_SHARP_){
var and__9521__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__16064_SHARP_) : p1.call(null,p1__16064_SHARP_));
if(cljs.core.truth_(and__9521__auto____$1)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__16064_SHARP_) : p2.call(null,p1__16064_SHARP_));
} else {
return and__9521__auto____$1;
}
}),args);
} else {
return and__9521__auto__;
}
})());
};
var G__16096 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16097__i = 0, G__16097__a = new Array(arguments.length -  3);
while (G__16097__i < G__16097__a.length) {G__16097__a[G__16097__i] = arguments[G__16097__i + 3]; ++G__16097__i;}
  args = new cljs.core.IndexedSeq(G__16097__a,0,null);
} 
return G__16096__delegate.call(this,x,y,z,args);};
G__16096.cljs$lang$maxFixedArity = 3;
G__16096.cljs$lang$applyTo = (function (arglist__16098){
var x = cljs.core.first(arglist__16098);
arglist__16098 = cljs.core.next(arglist__16098);
var y = cljs.core.first(arglist__16098);
arglist__16098 = cljs.core.next(arglist__16098);
var z = cljs.core.first(arglist__16098);
var args = cljs.core.rest(arglist__16098);
return G__16096__delegate(x,y,z,args);
});
G__16096.cljs$core$IFn$_invoke$arity$variadic = G__16096__delegate;
return G__16096;
})()
;
cljs$core$fn_16077_$_ep2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16077_$_ep2__0.call(this);
case 1:
return cljs$core$fn_16077_$_ep2__1.call(this,x);
case 2:
return cljs$core$fn_16077_$_ep2__2.call(this,x,y);
case 3:
return cljs$core$fn_16077_$_ep2__3.call(this,x,y,z);
default:
var G__16099 = null;
if (arguments.length > 3) {
var G__16100__i = 0, G__16100__a = new Array(arguments.length -  3);
while (G__16100__i < G__16100__a.length) {G__16100__a[G__16100__i] = arguments[G__16100__i + 3]; ++G__16100__i;}
G__16099 = new cljs.core.IndexedSeq(G__16100__a,0,null);
}
return cljs$core$fn_16077_$_ep2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16099);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16077_$_ep2.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16077_$_ep2.cljs$lang$applyTo = cljs$core$fn_16077_$_ep2__4.cljs$lang$applyTo;
cljs$core$fn_16077_$_ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16077_$_ep2__0;
cljs$core$fn_16077_$_ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16077_$_ep2__1;
cljs$core$fn_16077_$_ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16077_$_ep2__2;
cljs$core$fn_16077_$_ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16077_$_ep2__3;
cljs$core$fn_16077_$_ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16077_$_ep2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16077_$_ep2;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16079(p1,p2,p3){
return (function() {
var cljs$core$fn_16079_$_ep3 = null;
var cljs$core$fn_16079_$_ep3__0 = (function (){
return true;
});
var cljs$core$fn_16079_$_ep3__1 = (function (x){
return cljs.core.boolean$((function (){var and__9521__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9521__auto__)){
var and__9521__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__9521__auto____$1)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
} else {
return and__9521__auto____$1;
}
} else {
return and__9521__auto__;
}
})());
});
var cljs$core$fn_16079_$_ep3__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__9521__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9521__auto__)){
var and__9521__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__9521__auto____$1)){
var and__9521__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__9521__auto____$2)){
var and__9521__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__9521__auto____$3)){
var and__9521__auto____$4 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__9521__auto____$4)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
} else {
return and__9521__auto____$4;
}
} else {
return and__9521__auto____$3;
}
} else {
return and__9521__auto____$2;
}
} else {
return and__9521__auto____$1;
}
} else {
return and__9521__auto__;
}
})());
});
var cljs$core$fn_16079_$_ep3__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__9521__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9521__auto__)){
var and__9521__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__9521__auto____$1)){
var and__9521__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__9521__auto____$2)){
var and__9521__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__9521__auto____$3)){
var and__9521__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__9521__auto____$4)){
var and__9521__auto____$5 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(and__9521__auto____$5)){
var and__9521__auto____$6 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__9521__auto____$6)){
var and__9521__auto____$7 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(and__9521__auto____$7)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
} else {
return and__9521__auto____$7;
}
} else {
return and__9521__auto____$6;
}
} else {
return and__9521__auto____$5;
}
} else {
return and__9521__auto____$4;
}
} else {
return and__9521__auto____$3;
}
} else {
return and__9521__auto____$2;
}
} else {
return and__9521__auto____$1;
}
} else {
return and__9521__auto__;
}
})());
});
var cljs$core$fn_16079_$_ep3__4 = (function() { 
var G__16101__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__9521__auto__ = cljs$core$fn_16079_$_ep3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__9521__auto__)){
return cljs.core.every_QMARK_((function cljs$core$fn_16079_$_ep3_$_fn_16080(p1__16065_SHARP_){
var and__9521__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__16065_SHARP_) : p1.call(null,p1__16065_SHARP_));
if(cljs.core.truth_(and__9521__auto____$1)){
var and__9521__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__16065_SHARP_) : p2.call(null,p1__16065_SHARP_));
if(cljs.core.truth_(and__9521__auto____$2)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__16065_SHARP_) : p3.call(null,p1__16065_SHARP_));
} else {
return and__9521__auto____$2;
}
} else {
return and__9521__auto____$1;
}
}),args);
} else {
return and__9521__auto__;
}
})());
};
var G__16101 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16102__i = 0, G__16102__a = new Array(arguments.length -  3);
while (G__16102__i < G__16102__a.length) {G__16102__a[G__16102__i] = arguments[G__16102__i + 3]; ++G__16102__i;}
  args = new cljs.core.IndexedSeq(G__16102__a,0,null);
} 
return G__16101__delegate.call(this,x,y,z,args);};
G__16101.cljs$lang$maxFixedArity = 3;
G__16101.cljs$lang$applyTo = (function (arglist__16103){
var x = cljs.core.first(arglist__16103);
arglist__16103 = cljs.core.next(arglist__16103);
var y = cljs.core.first(arglist__16103);
arglist__16103 = cljs.core.next(arglist__16103);
var z = cljs.core.first(arglist__16103);
var args = cljs.core.rest(arglist__16103);
return G__16101__delegate(x,y,z,args);
});
G__16101.cljs$core$IFn$_invoke$arity$variadic = G__16101__delegate;
return G__16101;
})()
;
cljs$core$fn_16079_$_ep3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16079_$_ep3__0.call(this);
case 1:
return cljs$core$fn_16079_$_ep3__1.call(this,x);
case 2:
return cljs$core$fn_16079_$_ep3__2.call(this,x,y);
case 3:
return cljs$core$fn_16079_$_ep3__3.call(this,x,y,z);
default:
var G__16104 = null;
if (arguments.length > 3) {
var G__16105__i = 0, G__16105__a = new Array(arguments.length -  3);
while (G__16105__i < G__16105__a.length) {G__16105__a[G__16105__i] = arguments[G__16105__i + 3]; ++G__16105__i;}
G__16104 = new cljs.core.IndexedSeq(G__16105__a,0,null);
}
return cljs$core$fn_16079_$_ep3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16104);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16079_$_ep3.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16079_$_ep3.cljs$lang$applyTo = cljs$core$fn_16079_$_ep3__4.cljs$lang$applyTo;
cljs$core$fn_16079_$_ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16079_$_ep3__0;
cljs$core$fn_16079_$_ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16079_$_ep3__1;
cljs$core$fn_16079_$_ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16079_$_ep3__2;
cljs$core$fn_16079_$_ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16079_$_ep3__3;
cljs$core$fn_16079_$_ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16079_$_ep3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16079_$_ep3;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16081(p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return (function() {
var cljs$core$fn_16081_$_epn = null;
var cljs$core$fn_16081_$_epn__0 = (function (){
return true;
});
var cljs$core$fn_16081_$_epn__1 = (function (x){
return cljs.core.every_QMARK_((function cljs$core$fn_16081_$_epn_$_fn_16082(p1__16066_SHARP_){
return (p1__16066_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16066_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16066_SHARP_.call(null,x));
}),ps__$1);
});
var cljs$core$fn_16081_$_epn__2 = (function (x,y){
return cljs.core.every_QMARK_((function cljs$core$fn_16081_$_epn_$_fn_16083(p1__16067_SHARP_){
var and__9521__auto__ = (p1__16067_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16067_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16067_SHARP_.call(null,x));
if(cljs.core.truth_(and__9521__auto__)){
return (p1__16067_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16067_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__16067_SHARP_.call(null,y));
} else {
return and__9521__auto__;
}
}),ps__$1);
});
var cljs$core$fn_16081_$_epn__3 = (function (x,y,z){
return cljs.core.every_QMARK_((function cljs$core$fn_16081_$_epn_$_fn_16084(p1__16068_SHARP_){
var and__9521__auto__ = (p1__16068_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16068_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16068_SHARP_.call(null,x));
if(cljs.core.truth_(and__9521__auto__)){
var and__9521__auto____$1 = (p1__16068_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16068_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__16068_SHARP_.call(null,y));
if(cljs.core.truth_(and__9521__auto____$1)){
return (p1__16068_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16068_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__16068_SHARP_.call(null,z));
} else {
return and__9521__auto____$1;
}
} else {
return and__9521__auto__;
}
}),ps__$1);
});
var cljs$core$fn_16081_$_epn__4 = (function() { 
var G__16106__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__9521__auto__ = cljs$core$fn_16081_$_epn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__9521__auto__)){
return cljs.core.every_QMARK_((function cljs$core$fn_16081_$_epn_$_fn_16085(p1__16069_SHARP_){
return cljs.core.every_QMARK_(p1__16069_SHARP_,args);
}),ps__$1);
} else {
return and__9521__auto__;
}
})());
};
var G__16106 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16107__i = 0, G__16107__a = new Array(arguments.length -  3);
while (G__16107__i < G__16107__a.length) {G__16107__a[G__16107__i] = arguments[G__16107__i + 3]; ++G__16107__i;}
  args = new cljs.core.IndexedSeq(G__16107__a,0,null);
} 
return G__16106__delegate.call(this,x,y,z,args);};
G__16106.cljs$lang$maxFixedArity = 3;
G__16106.cljs$lang$applyTo = (function (arglist__16108){
var x = cljs.core.first(arglist__16108);
arglist__16108 = cljs.core.next(arglist__16108);
var y = cljs.core.first(arglist__16108);
arglist__16108 = cljs.core.next(arglist__16108);
var z = cljs.core.first(arglist__16108);
var args = cljs.core.rest(arglist__16108);
return G__16106__delegate(x,y,z,args);
});
G__16106.cljs$core$IFn$_invoke$arity$variadic = G__16106__delegate;
return G__16106;
})()
;
cljs$core$fn_16081_$_epn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16081_$_epn__0.call(this);
case 1:
return cljs$core$fn_16081_$_epn__1.call(this,x);
case 2:
return cljs$core$fn_16081_$_epn__2.call(this,x,y);
case 3:
return cljs$core$fn_16081_$_epn__3.call(this,x,y,z);
default:
var G__16109 = null;
if (arguments.length > 3) {
var G__16110__i = 0, G__16110__a = new Array(arguments.length -  3);
while (G__16110__i < G__16110__a.length) {G__16110__a[G__16110__i] = arguments[G__16110__i + 3]; ++G__16110__i;}
G__16109 = new cljs.core.IndexedSeq(G__16110__a,0,null);
}
return cljs$core$fn_16081_$_epn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16109);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16081_$_epn.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16081_$_epn.cljs$lang$applyTo = cljs$core$fn_16081_$_epn__4.cljs$lang$applyTo;
cljs$core$fn_16081_$_epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16081_$_epn__0;
cljs$core$fn_16081_$_epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16081_$_epn__1;
cljs$core$fn_16081_$_epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16081_$_epn__2;
cljs$core$fn_16081_$_epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16081_$_epn__3;
cljs$core$fn_16081_$_epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16081_$_epn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16081_$_epn;
})()
}));

/** @this {Function} */
(cljs.core.every_pred.cljs$lang$applyTo = (function cljs$core$fn_16086(seq16071){
var G__16072 = cljs.core.first(seq16071);
var seq16071__$1 = cljs.core.next(seq16071);
var G__16073 = cljs.core.first(seq16071__$1);
var seq16071__$2 = cljs.core.next(seq16071__$1);
var G__16074 = cljs.core.first(seq16071__$2);
var seq16071__$3 = cljs.core.next(seq16071__$2);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16072,G__16073,G__16074,seq16071__$3);
}));

(cljs.core.every_pred.cljs$lang$maxFixedArity = (3));

/**
 * Takes a set of predicates and returns a function f that returns the first logical true value
 *   returned by one of its composing predicates against any of its arguments, else it returns
 *   logical false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical true result against the original predicates.
 */
cljs.core.some_fn = (function cljs$core$some_fn(var_args){
var G__16122 = arguments.length;
switch (G__16122) {
case 1:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___16135 = arguments.length;
var i__10857__auto___16136 = (0);
while(true){
if((i__10857__auto___16136 < len__10856__auto___16135)){
args_arr__10885__auto__.push((arguments[i__10857__auto___16136]));

var G__16137 = (i__10857__auto___16136 + (1));
i__10857__auto___16136 = G__16137;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((3) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((3)),(0),null)):null);
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10886__auto__);

}
});

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16123(p){
return (function() {
var cljs$core$fn_16123_$_sp1 = null;
var cljs$core$fn_16123_$_sp1__0 = (function (){
return null;
});
var cljs$core$fn_16123_$_sp1__1 = (function (x){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
});
var cljs$core$fn_16123_$_sp1__2 = (function (x,y){
var or__9527__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__9527__auto__)){
return or__9527__auto__;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
}
});
var cljs$core$fn_16123_$_sp1__3 = (function (x,y,z){
var or__9527__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__9527__auto__)){
return or__9527__auto__;
} else {
var or__9527__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(or__9527__auto____$1)){
return or__9527__auto____$1;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
}
}
});
var cljs$core$fn_16123_$_sp1__4 = (function() { 
var G__16138__delegate = function (x,y,z,args){
var or__9527__auto__ = cljs$core$fn_16123_$_sp1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__9527__auto__)){
return or__9527__auto__;
} else {
return cljs.core.some(p,args);
}
};
var G__16138 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16139__i = 0, G__16139__a = new Array(arguments.length -  3);
while (G__16139__i < G__16139__a.length) {G__16139__a[G__16139__i] = arguments[G__16139__i + 3]; ++G__16139__i;}
  args = new cljs.core.IndexedSeq(G__16139__a,0,null);
} 
return G__16138__delegate.call(this,x,y,z,args);};
G__16138.cljs$lang$maxFixedArity = 3;
G__16138.cljs$lang$applyTo = (function (arglist__16140){
var x = cljs.core.first(arglist__16140);
arglist__16140 = cljs.core.next(arglist__16140);
var y = cljs.core.first(arglist__16140);
arglist__16140 = cljs.core.next(arglist__16140);
var z = cljs.core.first(arglist__16140);
var args = cljs.core.rest(arglist__16140);
return G__16138__delegate(x,y,z,args);
});
G__16138.cljs$core$IFn$_invoke$arity$variadic = G__16138__delegate;
return G__16138;
})()
;
cljs$core$fn_16123_$_sp1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16123_$_sp1__0.call(this);
case 1:
return cljs$core$fn_16123_$_sp1__1.call(this,x);
case 2:
return cljs$core$fn_16123_$_sp1__2.call(this,x,y);
case 3:
return cljs$core$fn_16123_$_sp1__3.call(this,x,y,z);
default:
var G__16141 = null;
if (arguments.length > 3) {
var G__16142__i = 0, G__16142__a = new Array(arguments.length -  3);
while (G__16142__i < G__16142__a.length) {G__16142__a[G__16142__i] = arguments[G__16142__i + 3]; ++G__16142__i;}
G__16141 = new cljs.core.IndexedSeq(G__16142__a,0,null);
}
return cljs$core$fn_16123_$_sp1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16141);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16123_$_sp1.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16123_$_sp1.cljs$lang$applyTo = cljs$core$fn_16123_$_sp1__4.cljs$lang$applyTo;
cljs$core$fn_16123_$_sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16123_$_sp1__0;
cljs$core$fn_16123_$_sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16123_$_sp1__1;
cljs$core$fn_16123_$_sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16123_$_sp1__2;
cljs$core$fn_16123_$_sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16123_$_sp1__3;
cljs$core$fn_16123_$_sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16123_$_sp1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16123_$_sp1;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16124(p1,p2){
return (function() {
var cljs$core$fn_16124_$_sp2 = null;
var cljs$core$fn_16124_$_sp2__0 = (function (){
return null;
});
var cljs$core$fn_16124_$_sp2__1 = (function (x){
var or__9527__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9527__auto__)){
return or__9527__auto__;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
}
});
var cljs$core$fn_16124_$_sp2__2 = (function (x,y){
var or__9527__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9527__auto__)){
return or__9527__auto__;
} else {
var or__9527__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__9527__auto____$1)){
return or__9527__auto____$1;
} else {
var or__9527__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__9527__auto____$2)){
return or__9527__auto____$2;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
}
}
}
});
var cljs$core$fn_16124_$_sp2__3 = (function (x,y,z){
var or__9527__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9527__auto__)){
return or__9527__auto__;
} else {
var or__9527__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__9527__auto____$1)){
return or__9527__auto____$1;
} else {
var or__9527__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__9527__auto____$2)){
return or__9527__auto____$2;
} else {
var or__9527__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__9527__auto____$3)){
return or__9527__auto____$3;
} else {
var or__9527__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__9527__auto____$4)){
return or__9527__auto____$4;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
}
}
}
}
}
});
var cljs$core$fn_16124_$_sp2__4 = (function() { 
var G__16143__delegate = function (x,y,z,args){
var or__9527__auto__ = cljs$core$fn_16124_$_sp2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__9527__auto__)){
return or__9527__auto__;
} else {
return cljs.core.some((function cljs$core$fn_16124_$_sp2_$_fn_16125(p1__16111_SHARP_){
var or__9527__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__16111_SHARP_) : p1.call(null,p1__16111_SHARP_));
if(cljs.core.truth_(or__9527__auto____$1)){
return or__9527__auto____$1;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__16111_SHARP_) : p2.call(null,p1__16111_SHARP_));
}
}),args);
}
};
var G__16143 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16144__i = 0, G__16144__a = new Array(arguments.length -  3);
while (G__16144__i < G__16144__a.length) {G__16144__a[G__16144__i] = arguments[G__16144__i + 3]; ++G__16144__i;}
  args = new cljs.core.IndexedSeq(G__16144__a,0,null);
} 
return G__16143__delegate.call(this,x,y,z,args);};
G__16143.cljs$lang$maxFixedArity = 3;
G__16143.cljs$lang$applyTo = (function (arglist__16145){
var x = cljs.core.first(arglist__16145);
arglist__16145 = cljs.core.next(arglist__16145);
var y = cljs.core.first(arglist__16145);
arglist__16145 = cljs.core.next(arglist__16145);
var z = cljs.core.first(arglist__16145);
var args = cljs.core.rest(arglist__16145);
return G__16143__delegate(x,y,z,args);
});
G__16143.cljs$core$IFn$_invoke$arity$variadic = G__16143__delegate;
return G__16143;
})()
;
cljs$core$fn_16124_$_sp2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16124_$_sp2__0.call(this);
case 1:
return cljs$core$fn_16124_$_sp2__1.call(this,x);
case 2:
return cljs$core$fn_16124_$_sp2__2.call(this,x,y);
case 3:
return cljs$core$fn_16124_$_sp2__3.call(this,x,y,z);
default:
var G__16146 = null;
if (arguments.length > 3) {
var G__16147__i = 0, G__16147__a = new Array(arguments.length -  3);
while (G__16147__i < G__16147__a.length) {G__16147__a[G__16147__i] = arguments[G__16147__i + 3]; ++G__16147__i;}
G__16146 = new cljs.core.IndexedSeq(G__16147__a,0,null);
}
return cljs$core$fn_16124_$_sp2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16146);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16124_$_sp2.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16124_$_sp2.cljs$lang$applyTo = cljs$core$fn_16124_$_sp2__4.cljs$lang$applyTo;
cljs$core$fn_16124_$_sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16124_$_sp2__0;
cljs$core$fn_16124_$_sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16124_$_sp2__1;
cljs$core$fn_16124_$_sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16124_$_sp2__2;
cljs$core$fn_16124_$_sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16124_$_sp2__3;
cljs$core$fn_16124_$_sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16124_$_sp2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16124_$_sp2;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16126(p1,p2,p3){
return (function() {
var cljs$core$fn_16126_$_sp3 = null;
var cljs$core$fn_16126_$_sp3__0 = (function (){
return null;
});
var cljs$core$fn_16126_$_sp3__1 = (function (x){
var or__9527__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9527__auto__)){
return or__9527__auto__;
} else {
var or__9527__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__9527__auto____$1)){
return or__9527__auto____$1;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
}
}
});
var cljs$core$fn_16126_$_sp3__2 = (function (x,y){
var or__9527__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9527__auto__)){
return or__9527__auto__;
} else {
var or__9527__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__9527__auto____$1)){
return or__9527__auto____$1;
} else {
var or__9527__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__9527__auto____$2)){
return or__9527__auto____$2;
} else {
var or__9527__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__9527__auto____$3)){
return or__9527__auto____$3;
} else {
var or__9527__auto____$4 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__9527__auto____$4)){
return or__9527__auto____$4;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
}
}
}
}
}
});
var cljs$core$fn_16126_$_sp3__3 = (function (x,y,z){
var or__9527__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9527__auto__)){
return or__9527__auto__;
} else {
var or__9527__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__9527__auto____$1)){
return or__9527__auto____$1;
} else {
var or__9527__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__9527__auto____$2)){
return or__9527__auto____$2;
} else {
var or__9527__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__9527__auto____$3)){
return or__9527__auto____$3;
} else {
var or__9527__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__9527__auto____$4)){
return or__9527__auto____$4;
} else {
var or__9527__auto____$5 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(or__9527__auto____$5)){
return or__9527__auto____$5;
} else {
var or__9527__auto____$6 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__9527__auto____$6)){
return or__9527__auto____$6;
} else {
var or__9527__auto____$7 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(or__9527__auto____$7)){
return or__9527__auto____$7;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
}
}
}
}
}
}
}
}
});
var cljs$core$fn_16126_$_sp3__4 = (function() { 
var G__16148__delegate = function (x,y,z,args){
var or__9527__auto__ = cljs$core$fn_16126_$_sp3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__9527__auto__)){
return or__9527__auto__;
} else {
return cljs.core.some((function cljs$core$fn_16126_$_sp3_$_fn_16127(p1__16112_SHARP_){
var or__9527__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__16112_SHARP_) : p1.call(null,p1__16112_SHARP_));
if(cljs.core.truth_(or__9527__auto____$1)){
return or__9527__auto____$1;
} else {
var or__9527__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__16112_SHARP_) : p2.call(null,p1__16112_SHARP_));
if(cljs.core.truth_(or__9527__auto____$2)){
return or__9527__auto____$2;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__16112_SHARP_) : p3.call(null,p1__16112_SHARP_));
}
}
}),args);
}
};
var G__16148 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16149__i = 0, G__16149__a = new Array(arguments.length -  3);
while (G__16149__i < G__16149__a.length) {G__16149__a[G__16149__i] = arguments[G__16149__i + 3]; ++G__16149__i;}
  args = new cljs.core.IndexedSeq(G__16149__a,0,null);
} 
return G__16148__delegate.call(this,x,y,z,args);};
G__16148.cljs$lang$maxFixedArity = 3;
G__16148.cljs$lang$applyTo = (function (arglist__16150){
var x = cljs.core.first(arglist__16150);
arglist__16150 = cljs.core.next(arglist__16150);
var y = cljs.core.first(arglist__16150);
arglist__16150 = cljs.core.next(arglist__16150);
var z = cljs.core.first(arglist__16150);
var args = cljs.core.rest(arglist__16150);
return G__16148__delegate(x,y,z,args);
});
G__16148.cljs$core$IFn$_invoke$arity$variadic = G__16148__delegate;
return G__16148;
})()
;
cljs$core$fn_16126_$_sp3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16126_$_sp3__0.call(this);
case 1:
return cljs$core$fn_16126_$_sp3__1.call(this,x);
case 2:
return cljs$core$fn_16126_$_sp3__2.call(this,x,y);
case 3:
return cljs$core$fn_16126_$_sp3__3.call(this,x,y,z);
default:
var G__16151 = null;
if (arguments.length > 3) {
var G__16152__i = 0, G__16152__a = new Array(arguments.length -  3);
while (G__16152__i < G__16152__a.length) {G__16152__a[G__16152__i] = arguments[G__16152__i + 3]; ++G__16152__i;}
G__16151 = new cljs.core.IndexedSeq(G__16152__a,0,null);
}
return cljs$core$fn_16126_$_sp3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16151);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16126_$_sp3.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16126_$_sp3.cljs$lang$applyTo = cljs$core$fn_16126_$_sp3__4.cljs$lang$applyTo;
cljs$core$fn_16126_$_sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16126_$_sp3__0;
cljs$core$fn_16126_$_sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16126_$_sp3__1;
cljs$core$fn_16126_$_sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16126_$_sp3__2;
cljs$core$fn_16126_$_sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16126_$_sp3__3;
cljs$core$fn_16126_$_sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16126_$_sp3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16126_$_sp3;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16128(p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return (function() {
var cljs$core$fn_16128_$_spn = null;
var cljs$core$fn_16128_$_spn__0 = (function (){
return null;
});
var cljs$core$fn_16128_$_spn__1 = (function (x){
return cljs.core.some((function cljs$core$fn_16128_$_spn_$_fn_16129(p1__16113_SHARP_){
return (p1__16113_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16113_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16113_SHARP_.call(null,x));
}),ps__$1);
});
var cljs$core$fn_16128_$_spn__2 = (function (x,y){
return cljs.core.some((function cljs$core$fn_16128_$_spn_$_fn_16130(p1__16114_SHARP_){
var or__9527__auto__ = (p1__16114_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16114_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16114_SHARP_.call(null,x));
if(cljs.core.truth_(or__9527__auto__)){
return or__9527__auto__;
} else {
return (p1__16114_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16114_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__16114_SHARP_.call(null,y));
}
}),ps__$1);
});
var cljs$core$fn_16128_$_spn__3 = (function (x,y,z){
return cljs.core.some((function cljs$core$fn_16128_$_spn_$_fn_16131(p1__16115_SHARP_){
var or__9527__auto__ = (p1__16115_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16115_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16115_SHARP_.call(null,x));
if(cljs.core.truth_(or__9527__auto__)){
return or__9527__auto__;
} else {
var or__9527__auto____$1 = (p1__16115_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16115_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__16115_SHARP_.call(null,y));
if(cljs.core.truth_(or__9527__auto____$1)){
return or__9527__auto____$1;
} else {
return (p1__16115_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16115_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__16115_SHARP_.call(null,z));
}
}
}),ps__$1);
});
var cljs$core$fn_16128_$_spn__4 = (function() { 
var G__16153__delegate = function (x,y,z,args){
var or__9527__auto__ = cljs$core$fn_16128_$_spn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__9527__auto__)){
return or__9527__auto__;
} else {
return cljs.core.some((function cljs$core$fn_16128_$_spn_$_fn_16132(p1__16116_SHARP_){
return cljs.core.some(p1__16116_SHARP_,args);
}),ps__$1);
}
};
var G__16153 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16154__i = 0, G__16154__a = new Array(arguments.length -  3);
while (G__16154__i < G__16154__a.length) {G__16154__a[G__16154__i] = arguments[G__16154__i + 3]; ++G__16154__i;}
  args = new cljs.core.IndexedSeq(G__16154__a,0,null);
} 
return G__16153__delegate.call(this,x,y,z,args);};
G__16153.cljs$lang$maxFixedArity = 3;
G__16153.cljs$lang$applyTo = (function (arglist__16155){
var x = cljs.core.first(arglist__16155);
arglist__16155 = cljs.core.next(arglist__16155);
var y = cljs.core.first(arglist__16155);
arglist__16155 = cljs.core.next(arglist__16155);
var z = cljs.core.first(arglist__16155);
var args = cljs.core.rest(arglist__16155);
return G__16153__delegate(x,y,z,args);
});
G__16153.cljs$core$IFn$_invoke$arity$variadic = G__16153__delegate;
return G__16153;
})()
;
cljs$core$fn_16128_$_spn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16128_$_spn__0.call(this);
case 1:
return cljs$core$fn_16128_$_spn__1.call(this,x);
case 2:
return cljs$core$fn_16128_$_spn__2.call(this,x,y);
case 3:
return cljs$core$fn_16128_$_spn__3.call(this,x,y,z);
default:
var G__16156 = null;
if (arguments.length > 3) {
var G__16157__i = 0, G__16157__a = new Array(arguments.length -  3);
while (G__16157__i < G__16157__a.length) {G__16157__a[G__16157__i] = arguments[G__16157__i + 3]; ++G__16157__i;}
G__16156 = new cljs.core.IndexedSeq(G__16157__a,0,null);
}
return cljs$core$fn_16128_$_spn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16128_$_spn.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16128_$_spn.cljs$lang$applyTo = cljs$core$fn_16128_$_spn__4.cljs$lang$applyTo;
cljs$core$fn_16128_$_spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16128_$_spn__0;
cljs$core$fn_16128_$_spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16128_$_spn__1;
cljs$core$fn_16128_$_spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16128_$_spn__2;
cljs$core$fn_16128_$_spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16128_$_spn__3;
cljs$core$fn_16128_$_spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16128_$_spn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16128_$_spn;
})()
}));

/** @this {Function} */
(cljs.core.some_fn.cljs$lang$applyTo = (function cljs$core$fn_16133(seq16118){
var G__16119 = cljs.core.first(seq16118);
var seq16118__$1 = cljs.core.next(seq16118);
var G__16120 = cljs.core.first(seq16118__$1);
var seq16118__$2 = cljs.core.next(seq16118__$1);
var G__16121 = cljs.core.first(seq16118__$2);
var seq16118__$3 = cljs.core.next(seq16118__$2);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16119,G__16120,G__16121,seq16118__$3);
}));

(cljs.core.some_fn.cljs$lang$maxFixedArity = (3));

/**
 * Returns a lazy sequence consisting of the result of applying f to
 *   the set of first items of each coll, followed by applying f to the
 *   set of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments. Returns a transducer when
 *   no collection is provided.
 */
cljs.core.map = (function cljs$core$map(var_args){
var G__16165 = arguments.length;
switch (G__16165) {
case 1:
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.map.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___16191 = arguments.length;
var i__10857__auto___16192 = (0);
while(true){
if((i__10857__auto___16192 < len__10856__auto___16191)){
args_arr__10885__auto__.push((arguments[i__10857__auto___16192]));

var G__16193 = (i__10857__auto___16192 + (1));
i__10857__auto___16192 = G__16193;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((4) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((4)),(0),null)):null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10886__auto__);

}
});

(cljs.core.map.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16166(f){
return (function cljs$core$fn_16166_$_fn_16167(rf){
return (function() {
var cljs$core$fn_16166_$_fn_16167_$_fn_16168 = null;
var cljs$core$fn_16166_$_fn_16167_$_fn_16168__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16166_$_fn_16167_$_fn_16168__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16166_$_fn_16167_$_fn_16168__2 = (function (result,input){
var G__16169 = result;
var G__16170 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__16169,G__16170) : rf.call(null,G__16169,G__16170));
});
var cljs$core$fn_16166_$_fn_16167_$_fn_16168__3 = (function() { 
var G__16194__delegate = function (result,input,inputs){
var G__16171 = result;
var G__16172 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,input,inputs);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__16171,G__16172) : rf.call(null,G__16171,G__16172));
};
var G__16194 = function (result,input,var_args){
var inputs = null;
if (arguments.length > 2) {
var G__16195__i = 0, G__16195__a = new Array(arguments.length -  2);
while (G__16195__i < G__16195__a.length) {G__16195__a[G__16195__i] = arguments[G__16195__i + 2]; ++G__16195__i;}
  inputs = new cljs.core.IndexedSeq(G__16195__a,0,null);
} 
return G__16194__delegate.call(this,result,input,inputs);};
G__16194.cljs$lang$maxFixedArity = 2;
G__16194.cljs$lang$applyTo = (function (arglist__16196){
var result = cljs.core.first(arglist__16196);
arglist__16196 = cljs.core.next(arglist__16196);
var input = cljs.core.first(arglist__16196);
var inputs = cljs.core.rest(arglist__16196);
return G__16194__delegate(result,input,inputs);
});
G__16194.cljs$core$IFn$_invoke$arity$variadic = G__16194__delegate;
return G__16194;
})()
;
cljs$core$fn_16166_$_fn_16167_$_fn_16168 = function(result,input,var_args){
var inputs = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16166_$_fn_16167_$_fn_16168__0.call(this);
case 1:
return cljs$core$fn_16166_$_fn_16167_$_fn_16168__1.call(this,result);
case 2:
return cljs$core$fn_16166_$_fn_16167_$_fn_16168__2.call(this,result,input);
default:
var G__16197 = null;
if (arguments.length > 2) {
var G__16198__i = 0, G__16198__a = new Array(arguments.length -  2);
while (G__16198__i < G__16198__a.length) {G__16198__a[G__16198__i] = arguments[G__16198__i + 2]; ++G__16198__i;}
G__16197 = new cljs.core.IndexedSeq(G__16198__a,0,null);
}
return cljs$core$fn_16166_$_fn_16167_$_fn_16168__3.cljs$core$IFn$_invoke$arity$variadic(result,input, G__16197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16166_$_fn_16167_$_fn_16168.cljs$lang$maxFixedArity = 2;
cljs$core$fn_16166_$_fn_16167_$_fn_16168.cljs$lang$applyTo = cljs$core$fn_16166_$_fn_16167_$_fn_16168__3.cljs$lang$applyTo;
cljs$core$fn_16166_$_fn_16167_$_fn_16168.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16166_$_fn_16167_$_fn_16168__0;
cljs$core$fn_16166_$_fn_16167_$_fn_16168.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16166_$_fn_16167_$_fn_16168__1;
cljs$core$fn_16166_$_fn_16167_$_fn_16168.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16166_$_fn_16167_$_fn_16168__2;
cljs$core$fn_16166_$_fn_16167_$_fn_16168.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16166_$_fn_16167_$_fn_16168__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16166_$_fn_16167_$_fn_16168;
})()
});
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16173(f,coll){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16173_$_fn_16174(){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__10615__auto___16199 = size;
var i_16200 = (0);
while(true){
if((i_16200 < n__10615__auto___16199)){
cljs.core.chunk_append(b,(function (){var G__16175 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_16200);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16175) : f.call(null,G__16175));
})());

var G__16201 = (i_16200 + (1));
i_16200 = G__16201;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__16176 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16176) : f.call(null,G__16176));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16177(f,c1,c2){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16177_$_fn_16178(){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if(((s1) && (s2))){
return cljs.core.cons((function (){var G__16179 = cljs.core.first(s1);
var G__16180 = cljs.core.first(s2);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16179,G__16180) : f.call(null,G__16179,G__16180));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,cljs.core.rest(s1),cljs.core.rest(s2)));
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16181(f,c1,c2,c3){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16181_$_fn_16182(){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
var s3 = cljs.core.seq(c3);
if(((s1) && (((s2) && (s3))))){
return cljs.core.cons((function (){var G__16183 = cljs.core.first(s1);
var G__16184 = cljs.core.first(s2);
var G__16185 = cljs.core.first(s3);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16183,G__16184,G__16185) : f.call(null,G__16183,G__16184,G__16185));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,cljs.core.rest(s1),cljs.core.rest(s2),cljs.core.rest(s3)));
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16186(f,c1,c2,c3,colls){
var step = (function cljs$core$fn_16186_$_step(cs){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16186_$_step_$_fn_16187(){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cs);
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs$core$fn_16186_$_step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function cljs$core$fn_16186_$_fn_16188(p1__16158_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,p1__16158_SHARP_);
}),step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c3,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c2,c1], 0))));
}));

/** @this {Function} */
(cljs.core.map.cljs$lang$applyTo = (function cljs$core$fn_16189(seq16160){
var G__16161 = cljs.core.first(seq16160);
var seq16160__$1 = cljs.core.next(seq16160);
var G__16162 = cljs.core.first(seq16160__$1);
var seq16160__$2 = cljs.core.next(seq16160__$1);
var G__16163 = cljs.core.first(seq16160__$2);
var seq16160__$3 = cljs.core.next(seq16160__$2);
var G__16164 = cljs.core.first(seq16160__$3);
var seq16160__$4 = cljs.core.next(seq16160__$3);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16161,G__16162,G__16163,G__16164,seq16160__$4);
}));

(cljs.core.map.cljs$lang$maxFixedArity = (4));

/**
 * Returns a lazy sequence of the first n items in coll, or all items if
 *   there are fewer than n.  Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.take = (function cljs$core$take(var_args){
var G__16203 = arguments.length;
switch (G__16203) {
case 1:
return cljs.core.take.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.take.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16204(n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function cljs$core$fn_16204_$_fn_16205(rf){
var na = cljs.core.volatile_BANG_(n);
return (function() {
var cljs$core$fn_16204_$_fn_16205_$_fn_16206 = null;
var cljs$core$fn_16204_$_fn_16205_$_fn_16206__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16204_$_fn_16205_$_fn_16206__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16204_$_fn_16205_$_fn_16206__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
var nn = na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));
var result__$1 = (((n__$1 > (0)))?(rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input)):result);
if((!((nn > (0))))){
return cljs.core.ensure_reduced(result__$1);
} else {
return result__$1;
}
});
cljs$core$fn_16204_$_fn_16205_$_fn_16206 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16204_$_fn_16205_$_fn_16206__0.call(this);
case 1:
return cljs$core$fn_16204_$_fn_16205_$_fn_16206__1.call(this,result);
case 2:
return cljs$core$fn_16204_$_fn_16205_$_fn_16206__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16204_$_fn_16205_$_fn_16206.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16204_$_fn_16205_$_fn_16206__0;
cljs$core$fn_16204_$_fn_16205_$_fn_16206.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16204_$_fn_16205_$_fn_16206__1;
cljs$core$fn_16204_$_fn_16205_$_fn_16206.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16204_$_fn_16205_$_fn_16206__2;
return cljs$core$fn_16204_$_fn_16205_$_fn_16206;
})()
});
}));

(cljs.core.take.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16207(n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (new cljs.core.LazySeq(null,(function cljs$core$fn_16207_$_fn_16208(){
if((n > (0))){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
return cljs.core.cons(cljs.core.first(s),cljs.core.take.cljs$core$IFn$_invoke$arity$2((n - (1)),cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.take.cljs$lang$maxFixedArity = 2);

/**
 * Returns a laziness-preserving sequence of all but the first n items in coll.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.drop = (function cljs$core$drop(var_args){
var G__16211 = arguments.length;
switch (G__16211) {
case 1:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16212(n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function cljs$core$fn_16212_$_fn_16213(rf){
var na = cljs.core.volatile_BANG_(n);
return (function() {
var cljs$core$fn_16212_$_fn_16213_$_fn_16214 = null;
var cljs$core$fn_16212_$_fn_16213_$_fn_16214__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16212_$_fn_16213_$_fn_16214__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16212_$_fn_16213_$_fn_16214__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));

if((n__$1 > (0))){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
cljs$core$fn_16212_$_fn_16213_$_fn_16214 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16212_$_fn_16213_$_fn_16214__0.call(this);
case 1:
return cljs$core$fn_16212_$_fn_16213_$_fn_16214__1.call(this,result);
case 2:
return cljs$core$fn_16212_$_fn_16213_$_fn_16214__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16212_$_fn_16213_$_fn_16214.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16212_$_fn_16213_$_fn_16214__0;
cljs$core$fn_16212_$_fn_16213_$_fn_16214.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16212_$_fn_16213_$_fn_16214__1;
cljs$core$fn_16212_$_fn_16213_$_fn_16214.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16212_$_fn_16213_$_fn_16214__2;
return cljs$core$fn_16212_$_fn_16213_$_fn_16214;
})()
});
}));

(cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16215(n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition1$ & (262144))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IDrop$))))?true:false):false)){
var or__9527__auto__ = (((n > (0)))?coll.cljs$core$IDrop$_drop$arity$2(null,Math.ceil(n)):cljs.core.seq(coll));
if(cljs.core.truth_(or__9527__auto__)){
return or__9527__auto__;
} else {
return cljs.core.List.EMPTY;
}
} else {
var step = (function cljs$core$fn_16215_$_fn_16217(n__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if((((n__$1 > (0))) && (s))){
var G__16220 = (n__$1 - (1));
var G__16221 = cljs.core.rest(s);
n__$1 = G__16220;
coll__$1 = G__16221;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16215_$_fn_16218(){
return step(n,coll);
}),null,null));
}
}));

(cljs.core.drop.cljs$lang$maxFixedArity = 2);

/**
 * Return a lazy sequence of all but the last n (default 1) items in coll
 */
cljs.core.drop_last = (function cljs$core$drop_last(var_args){
var G__16223 = arguments.length;
switch (G__16223) {
case 1:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16224(s){
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((1),s);
}));

(cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16225(n,s){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((function cljs$core$fn_16225_$_fn_16226(x,_){
return x;
}),s,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s));
}));

(cljs.core.drop_last.cljs$lang$maxFixedArity = 2);

/**
 * Returns a seq of the last n items in coll.  Depending on the type
 *   of coll may be no better than linear time.  For vectors, see also subvec.
 */
cljs.core.take_last = (function cljs$core$take_last(n,coll){
var s = cljs.core.seq(coll);
var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll));
while(true){
if(lead){
var G__16228 = cljs.core.next(s);
var G__16229 = cljs.core.next(lead);
s = G__16228;
lead = G__16229;
continue;
} else {
return s;
}
break;
}
});
/**
 * Returns a lazy sequence of the items in coll starting from the
 *   first item for which (pred item) returns logical false.  Returns a
 *   stateful transducer when no collection is provided.
 */
cljs.core.drop_while = (function cljs$core$drop_while(var_args){
var G__16231 = arguments.length;
switch (G__16231) {
case 1:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16232(pred){
return (function cljs$core$fn_16232_$_fn_16233(rf){
var da = cljs.core.volatile_BANG_(true);
return (function() {
var cljs$core$fn_16232_$_fn_16233_$_fn_16234 = null;
var cljs$core$fn_16232_$_fn_16233_$_fn_16234__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16232_$_fn_16233_$_fn_16234__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16232_$_fn_16233_$_fn_16234__2 = (function (result,input){
var drop_QMARK_ = cljs.core.deref(da);
if(cljs.core.truth_((function (){var and__9521__auto__ = drop_QMARK_;
if(cljs.core.truth_(and__9521__auto__)){
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input));
} else {
return and__9521__auto__;
}
})())){
return result;
} else {
cljs.core.vreset_BANG_(da,null);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
cljs$core$fn_16232_$_fn_16233_$_fn_16234 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16232_$_fn_16233_$_fn_16234__0.call(this);
case 1:
return cljs$core$fn_16232_$_fn_16233_$_fn_16234__1.call(this,result);
case 2:
return cljs$core$fn_16232_$_fn_16233_$_fn_16234__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16232_$_fn_16233_$_fn_16234.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16232_$_fn_16233_$_fn_16234__0;
cljs$core$fn_16232_$_fn_16233_$_fn_16234.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16232_$_fn_16233_$_fn_16234__1;
cljs$core$fn_16232_$_fn_16233_$_fn_16234.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16232_$_fn_16233_$_fn_16234__2;
return cljs$core$fn_16232_$_fn_16233_$_fn_16234;
})()
});
}));

(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16235(pred,coll){
var step = (function cljs$core$fn_16235_$_fn_16236(pred__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(cljs.core.truth_((function (){var and__9521__auto__ = s;
if(and__9521__auto__){
var G__16237 = cljs.core.first(s);
return (pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__16237) : pred__$1.call(null,G__16237));
} else {
return and__9521__auto__;
}
})())){
var G__16240 = pred__$1;
var G__16241 = cljs.core.rest(s);
pred__$1 = G__16240;
coll__$1 = G__16241;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16235_$_fn_16238(){
return step(pred,coll);
}),null,null));
}));

(cljs.core.drop_while.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Cycle = (function (meta,all,prev,current,_next){
this.meta = meta;
this.all = all;
this.prev = prev;
this.current = current;
this._next = _next;
this.cljs$lang$protocol_mask$partition0$ = 26083532;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.Cycle.prototype.toString = (function cljs$core$fn_16242(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Cycle.prototype.currentval = (function cljs$core$fn_16243(){
var self__ = this;
var coll = this;
if(self__.current){
} else {
var temp__5718__auto___16263 = cljs.core.next(self__.prev);
if(temp__5718__auto___16263){
var c_16264 = temp__5718__auto___16263;
(self__.current = c_16264);
} else {
(self__.current = self__.all);
}
}

return self__.current;
}));

(cljs.core.Cycle.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16244(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Cycle.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16245(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
}));

(cljs.core.Cycle.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16246(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Cycle.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function cljs$core$fn_16247(coll){
var self__ = this;
var coll__$1 = this;
return (!((self__.current == null)));
}));

(cljs.core.Cycle.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16248(coll,f){
var self__ = this;
var coll__$1 = this;
var s = coll__$1.currentval();
var ret = cljs.core.first(s);
while(true){
var s__$1 = (function (){var or__9527__auto__ = cljs.core.next(s);
if(or__9527__auto__){
return or__9527__auto__;
} else {
return self__.all;
}
})();
var ret__$1 = (function (){var G__16251 = ret;
var G__16252 = cljs.core.first(s__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16251,G__16252) : f.call(null,G__16251,G__16252));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__16265 = s__$1;
var G__16266 = ret__$1;
s = G__16265;
ret = G__16266;
continue;
}
break;
}
}));

(cljs.core.Cycle.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16253(coll,f,start){
var self__ = this;
var coll__$1 = this;
var s = coll__$1.currentval();
var ret = start;
while(true){
var ret__$1 = (function (){var G__16254 = ret;
var G__16255 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16254,G__16255) : f.call(null,G__16254,G__16255));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__16267 = (function (){var or__9527__auto__ = cljs.core.next(s);
if(or__9527__auto__){
return or__9527__auto__;
} else {
return self__.all;
}
})();
var G__16268 = ret__$1;
s = G__16267;
ret = G__16268;
continue;
}
break;
}
}));

(cljs.core.Cycle.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16256(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(coll__$1.currentval());
}));

(cljs.core.Cycle.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16257(coll){
var self__ = this;
var coll__$1 = this;
if((self__._next == null)){
(self__._next = (new cljs.core.Cycle(null,self__.all,coll__$1.currentval(),null,null)));
} else {
}

return self__._next;
}));

(cljs.core.Cycle.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16258(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Cycle.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16259(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Cycle(new_meta,self__.all,self__.prev,self__.current,self__._next));
}
}));

(cljs.core.Cycle.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16260(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.Cycle.getBasis = (function cljs$core$fn_16261(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"all","all",-1762306027,null),new cljs.core.Symbol(null,"prev","prev",43462301,null),cljs.core.with_meta(new cljs.core.Symbol(null,"current","current",552492924,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Cycle.cljs$lang$type = true);

(cljs.core.Cycle.cljs$lang$ctorStr = "cljs.core/Cycle");

(cljs.core.Cycle.cljs$lang$ctorPrWriter = (function cljs$core$fn_16262(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/Cycle");
}));

/**
 * Positional factory function for cljs.core/Cycle.
 */
cljs.core.__GT_Cycle = (function cljs$core$__GT_Cycle(meta,all,prev,current,_next){
return (new cljs.core.Cycle(meta,all,prev,current,_next));
});

/**
 * Returns a lazy (infinite!) sequence of repetitions of the items in coll.
 */
cljs.core.cycle = (function cljs$core$cycle(coll){
var temp__5718__auto__ = cljs.core.seq(coll);
if(temp__5718__auto__){
var vals = temp__5718__auto__;
return (new cljs.core.Cycle(null,vals,null,vals,null));
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a vector of [(take n coll) (drop n coll)]
 */
cljs.core.split_at = (function cljs$core$split_at(n,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll),cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll)], null);
});

/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Repeat = (function (meta,count,val,next,__hash){
this.meta = meta;
this.count = count;
this.val = val;
this.next = next;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 262145;
});
(cljs.core.Repeat.prototype.toString = (function cljs$core$fn_16269(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Repeat.prototype.equiv = (function cljs$core$fn_16270(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Repeat.prototype.indexOf = (function() {
var cljs$core$fn_16271 = null;
var cljs$core$fn_16271__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16271__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16271 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16271__1.call(this,x);
case 2:
return cljs$core$fn_16271__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16271.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16271__1;
cljs$core$fn_16271.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16271__2;
return cljs$core$fn_16271;
})()
);

(cljs.core.Repeat.prototype.lastIndexOf = (function() {
var cljs$core$fn_16272 = null;
var cljs$core$fn_16272__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,self__.count);
});
var cljs$core$fn_16272__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16272 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16272__1.call(this,x);
case 2:
return cljs$core$fn_16272__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16272.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16272__1;
cljs$core$fn_16272.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16272__2;
return cljs$core$fn_16272;
})()
);

(cljs.core.Repeat.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16273(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Repeat.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16274(coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
if((self__.count > (1))){
(self__.next = (new cljs.core.Repeat(null,(self__.count - (1)),self__.val,null,null)));

return self__.next;
} else {
if(((-1) === self__.count)){
return coll__$1;
} else {
return null;
}
}
} else {
return self__.next;
}
}));

(cljs.core.Repeat.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16275(coll){
var self__ = this;
var coll__$1 = this;
var h__9988__auto__ = self__.__hash;
if((!((h__9988__auto__ == null)))){
return h__9988__auto__;
} else {
var h__9988__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9988__auto____$1);

return h__9988__auto____$1;
}
}));

(cljs.core.Repeat.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16276(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.Repeat.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16277(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Repeat.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function cljs$core$fn_16278(coll){
var self__ = this;
var coll__$1 = this;
return false;
}));

(cljs.core.Repeat.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16279(coll,f){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
var ret = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(self__.val,self__.val) : f.call(null,self__.val,self__.val));
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var G__16289 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
ret = G__16289;
continue;
}
break;
}
} else {
var i = (1);
var ret = self__.val;
while(true){
if((i < self__.count)){
var ret__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__16290 = (i + (1));
var G__16291 = ret__$1;
i = G__16290;
ret = G__16291;
continue;
}
} else {
return ret;
}
break;
}
}
}));

(cljs.core.Repeat.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16280(coll,f,start){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
var ret = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(start,self__.val) : f.call(null,start,self__.val));
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var G__16292 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
ret = G__16292;
continue;
}
break;
}
} else {
var i = (0);
var ret = start;
while(true){
if((i < self__.count)){
var ret__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__16293 = (i + (1));
var G__16294 = ret__$1;
i = G__16293;
ret = G__16294;
continue;
}
} else {
return ret;
}
break;
}
}
}));

(cljs.core.Repeat.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16281(coll){
var self__ = this;
var coll__$1 = this;
return self__.val;
}));

(cljs.core.Repeat.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16282(coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
if((self__.count > (1))){
(self__.next = (new cljs.core.Repeat(null,(self__.count - (1)),self__.val,null,null)));

return self__.next;
} else {
if(((-1) === self__.count)){
return coll__$1;
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return self__.next;
}
}));

(cljs.core.Repeat.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16283(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Repeat.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16284(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Repeat(new_meta,self__.count,self__.val,self__.next,null));
}
}));

(cljs.core.Repeat.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16285(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.Repeat.prototype.cljs$core$IDrop$_drop$arity$2 = (function cljs$core$fn_16286(coll,n){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
return coll__$1;
} else {
var dropped_count = (self__.count - n);
if((dropped_count > (0))){
return (new cljs.core.Repeat(null,dropped_count,self__.val,null,null));
} else {
return null;
}
}
}));

(cljs.core.Repeat.getBasis = (function cljs$core$fn_16287(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.with_meta(new cljs.core.Symbol(null,"next","next",1522830042,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Repeat.cljs$lang$type = true);

(cljs.core.Repeat.cljs$lang$ctorStr = "cljs.core/Repeat");

(cljs.core.Repeat.cljs$lang$ctorPrWriter = (function cljs$core$fn_16288(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/Repeat");
}));

/**
 * Positional factory function for cljs.core/Repeat.
 */
cljs.core.__GT_Repeat = (function cljs$core$__GT_Repeat(meta,count,val,next,__hash){
return (new cljs.core.Repeat(meta,count,val,next,__hash));
});

/**
 * Returns a lazy (infinite!, or length n if supplied) sequence of xs.
 */
cljs.core.repeat = (function cljs$core$repeat(var_args){
var G__16296 = arguments.length;
switch (G__16296) {
case 1:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16297(x){
return (new cljs.core.Repeat(null,(-1),x,null,null));
}));

(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16298(n,x){
if((n > (0))){
return (new cljs.core.Repeat(null,n,x,null,null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.repeat.cljs$lang$maxFixedArity = 2);

/**
 * DEPRECATED: Use 'repeat' instead.
 *   Returns a lazy seq of n xs.
 */
cljs.core.replicate = (function cljs$core$replicate(n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});
/**
 * Takes a function of no args, presumably with side effects, and
 *   returns an infinite (or length n if supplied) lazy sequence of calls
 *   to it
 */
cljs.core.repeatedly = (function cljs$core$repeatedly(var_args){
var G__16301 = arguments.length;
switch (G__16301) {
case 1:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16302(f){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16302_$_fn_16303(){
return cljs.core.cons((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}),null,null));
}));

(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16304(n,f){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}));

(cljs.core.repeatedly.cljs$lang$maxFixedArity = 2);

cljs.core.UNREALIZED_SEED = ({});

/**
* @constructor
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Iterate = (function (meta,f,prev_seed,seed,next){
this.meta = meta;
this.f = f;
this.prev_seed = prev_seed;
this.seed = seed;
this.next = next;
this.cljs$lang$protocol_mask$partition0$ = 26083532;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.Iterate.prototype.toString = (function cljs$core$fn_16306(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Iterate.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16307(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Iterate.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16308(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
}));

(cljs.core.Iterate.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16309(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Iterate.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function cljs$core$fn_16310(coll){
var self__ = this;
var coll__$1 = this;
return (!((self__.seed === cljs.core.UNREALIZED_SEED)));
}));

(cljs.core.Iterate.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16311(coll,rf){
var self__ = this;
var coll__$1 = this;
var first = coll__$1.cljs$core$ISeq$_first$arity$1(null);
var v = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(first) : self__.f.call(null,first));
var ret = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(first,v) : rf.call(null,first,v));
var v__$1 = v;
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var v__$2 = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(v__$1) : self__.f.call(null,v__$1));
var G__16320 = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(ret,v__$2) : rf.call(null,ret,v__$2));
var G__16321 = v__$2;
ret = G__16320;
v__$1 = G__16321;
continue;
}
break;
}
}));

(cljs.core.Iterate.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16312(coll,rf,start){
var self__ = this;
var coll__$1 = this;
var v = coll__$1.cljs$core$ISeq$_first$arity$1(null);
var ret = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(start,v) : rf.call(null,start,v));
var v__$1 = v;
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var v__$2 = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(v__$1) : self__.f.call(null,v__$1));
var G__16322 = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(ret,v__$2) : rf.call(null,ret,v__$2));
var G__16323 = v__$2;
ret = G__16322;
v__$1 = G__16323;
continue;
}
break;
}
}));

(cljs.core.Iterate.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16313(coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.UNREALIZED_SEED === self__.seed)){
(self__.seed = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(self__.prev_seed) : self__.f.call(null,self__.prev_seed)));
} else {
}

return self__.seed;
}));

(cljs.core.Iterate.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16314(coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
(self__.next = (new cljs.core.Iterate(null,self__.f,coll__$1.cljs$core$ISeq$_first$arity$1(null),cljs.core.UNREALIZED_SEED,null)));
} else {
}

return self__.next;
}));

(cljs.core.Iterate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16315(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Iterate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16316(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Iterate(new_meta,self__.f,self__.prev_seed,self__.seed,self__.next));
}
}));

(cljs.core.Iterate.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16317(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.Iterate.getBasis = (function cljs$core$fn_16318(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"prev-seed","prev-seed",2126381367,null),cljs.core.with_meta(new cljs.core.Symbol(null,"seed","seed",1709144854,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next","next",1522830042,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Iterate.cljs$lang$type = true);

(cljs.core.Iterate.cljs$lang$ctorStr = "cljs.core/Iterate");

(cljs.core.Iterate.cljs$lang$ctorPrWriter = (function cljs$core$fn_16319(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/Iterate");
}));

/**
 * Positional factory function for cljs.core/Iterate.
 */
cljs.core.__GT_Iterate = (function cljs$core$__GT_Iterate(meta,f,prev_seed,seed,next){
return (new cljs.core.Iterate(meta,f,prev_seed,seed,next));
});

/**
 * Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects
 */
cljs.core.iterate = (function cljs$core$iterate(f,x){
return (new cljs.core.Iterate(null,f,null,x,null));
});
/**
 * Returns a lazy seq of the first item in each coll, then the second etc.
 */
cljs.core.interleave = (function cljs$core$interleave(var_args){
var G__16328 = arguments.length;
switch (G__16328) {
case 0:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___16338 = arguments.length;
var i__10857__auto___16339 = (0);
while(true){
if((i__10857__auto___16339 < len__10856__auto___16338)){
args_arr__10885__auto__.push((arguments[i__10857__auto___16339]));

var G__16340 = (i__10857__auto___16339 + (1));
i__10857__auto___16339 = G__16340;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((2) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((2)),(0),null)):null);
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10886__auto__);

}
});

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_16329(){
return cljs.core.List.EMPTY;
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16330(c1){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16330_$_fn_16331(){
return c1;
}),null,null));
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16332(c1,c2){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16332_$_fn_16333(){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if(((s1) && (s2))){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
return null;
}
}),null,null));
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16334(c1,c2,colls){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16334_$_fn_16335(){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c1], 0)));
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
}));

/** @this {Function} */
(cljs.core.interleave.cljs$lang$applyTo = (function cljs$core$fn_16336(seq16325){
var G__16326 = cljs.core.first(seq16325);
var seq16325__$1 = cljs.core.next(seq16325);
var G__16327 = cljs.core.first(seq16325__$1);
var seq16325__$2 = cljs.core.next(seq16325__$1);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16326,G__16327,seq16325__$2);
}));

(cljs.core.interleave.cljs$lang$maxFixedArity = (2));

/**
 * Returns a lazy seq of the elements of coll separated by sep.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.interpose = (function cljs$core$interpose(var_args){
var G__16342 = arguments.length;
switch (G__16342) {
case 1:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16343(sep){
return (function cljs$core$fn_16343_$_fn_16344(rf){
var started = cljs.core.volatile_BANG_(false);
return (function() {
var cljs$core$fn_16343_$_fn_16344_$_fn_16345 = null;
var cljs$core$fn_16343_$_fn_16344_$_fn_16345__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16343_$_fn_16344_$_fn_16345__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16343_$_fn_16344_$_fn_16345__2 = (function (result,input){
if(cljs.core.truth_(cljs.core.deref(started))){
var sepr = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,sep) : rf.call(null,result,sep));
if(cljs.core.reduced_QMARK_(sepr)){
return sepr;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(sepr,input) : rf.call(null,sepr,input));
}
} else {
cljs.core.vreset_BANG_(started,true);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
cljs$core$fn_16343_$_fn_16344_$_fn_16345 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16343_$_fn_16344_$_fn_16345__0.call(this);
case 1:
return cljs$core$fn_16343_$_fn_16344_$_fn_16345__1.call(this,result);
case 2:
return cljs$core$fn_16343_$_fn_16344_$_fn_16345__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16343_$_fn_16344_$_fn_16345.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16343_$_fn_16344_$_fn_16345__0;
cljs$core$fn_16343_$_fn_16344_$_fn_16345.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16343_$_fn_16344_$_fn_16345__1;
cljs$core$fn_16343_$_fn_16344_$_fn_16345.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16343_$_fn_16344_$_fn_16345__2;
return cljs$core$fn_16343_$_fn_16344_$_fn_16345;
})()
});
}));

(cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16346(sep,coll){
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep),coll));
}));

(cljs.core.interpose.cljs$lang$maxFixedArity = 2);

/**
 * Take a collection of collections, and return a lazy seq
 *   of items from the inner collection
 */
cljs.core.flatten1 = (function cljs$core$flatten1(colls){
var cat = (function cljs$core$flatten1_$_cat(coll,colls__$1){
return (new cljs.core.LazySeq(null,(function cljs$core$flatten1_$_cat_$_fn_16348(){
var temp__5718__auto__ = cljs.core.seq(coll);
if(temp__5718__auto__){
var coll__$1 = temp__5718__auto__;
return cljs.core.cons(cljs.core.first(coll__$1),cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1),colls__$1));
} else {
if(cljs.core.seq(colls__$1)){
return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1),cljs.core.rest(colls__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(null,colls);
});
/**
 * Returns the result of applying concat to the result of applying map
 *   to f and colls.  Thus function f should return a collection. Returns
 *   a transducer when no collections are provided
 */
cljs.core.mapcat = (function cljs$core$mapcat(var_args){
var G__16352 = arguments.length;
switch (G__16352) {
case 1:
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___16357 = arguments.length;
var i__10857__auto___16358 = (0);
while(true){
if((i__10857__auto___16358 < len__10856__auto___16357)){
args_arr__10885__auto__.push((arguments[i__10857__auto___16358]));

var G__16359 = (i__10857__auto___16358 + (1));
i__10857__auto___16358 = G__16359;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((1) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((1)),(0),null)):null);
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10886__auto__);

}
});

(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16353(f){
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f),cljs.core.cat);
}));

(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16354(f,colls){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map,f,colls));
}));

/** @this {Function} */
(cljs.core.mapcat.cljs$lang$applyTo = (function cljs$core$fn_16355(seq16350){
var G__16351 = cljs.core.first(seq16350);
var seq16350__$1 = cljs.core.next(seq16350);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16351,seq16350__$1);
}));

(cljs.core.mapcat.cljs$lang$maxFixedArity = (1));

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns logical true. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.filter = (function cljs$core$filter(var_args){
var G__16361 = arguments.length;
switch (G__16361) {
case 1:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16362(pred){
return (function cljs$core$fn_16362_$_fn_16363(rf){
return (function() {
var cljs$core$fn_16362_$_fn_16363_$_fn_16364 = null;
var cljs$core$fn_16362_$_fn_16363_$_fn_16364__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16362_$_fn_16363_$_fn_16364__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16362_$_fn_16363_$_fn_16364__2 = (function (result,input){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input)))){
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
} else {
return result;
}
});
cljs$core$fn_16362_$_fn_16363_$_fn_16364 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16362_$_fn_16363_$_fn_16364__0.call(this);
case 1:
return cljs$core$fn_16362_$_fn_16363_$_fn_16364__1.call(this,result);
case 2:
return cljs$core$fn_16362_$_fn_16363_$_fn_16364__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16362_$_fn_16363_$_fn_16364.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16362_$_fn_16363_$_fn_16364__0;
cljs$core$fn_16362_$_fn_16363_$_fn_16364.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16362_$_fn_16363_$_fn_16364__1;
cljs$core$fn_16362_$_fn_16363_$_fn_16364.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16362_$_fn_16363_$_fn_16364__2;
return cljs$core$fn_16362_$_fn_16363_$_fn_16364;
})()
});
}));

(cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16365(pred,coll){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16365_$_fn_16366(){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__10615__auto___16369 = size;
var i_16370 = (0);
while(true){
if((i_16370 < n__10615__auto___16369)){
if(cljs.core.truth_((function (){var G__16367 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_16370);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__16367) : pred.call(null,G__16367));
})())){
cljs.core.chunk_append(b,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_16370));
} else {
}

var G__16371 = (i_16370 + (1));
i_16370 = G__16371;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.chunk_rest(s)));
} else {
var f = cljs.core.first(s);
var r = cljs.core.rest(s);
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(f) : pred.call(null,f)))){
return cljs.core.cons(f,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r));
} else {
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r);
}
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.filter.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns logical false. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.remove = (function cljs$core$remove(var_args){
var G__16373 = arguments.length;
switch (G__16373) {
case 1:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16374(pred){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
}));

(cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16375(pred,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred),coll);
}));

(cljs.core.remove.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the nodes in a tree, via a depth-first walk.
 *   branch? must be a fn of one arg that returns true if passed a node
 *   that can have children (but may not).  children must be a fn of one
 *   arg that returns a sequence of the children. Will only be called on
 *   nodes for which branch? returns true. Root is the root node of the
 *   tree.
 */
cljs.core.tree_seq = (function cljs$core$tree_seq(branch_QMARK_,children,root){
var walk = (function cljs$core$tree_seq_$_walk(node){
return (new cljs.core.LazySeq(null,(function cljs$core$tree_seq_$_walk_$_fn_16377(){
return cljs.core.cons(node,(cljs.core.truth_((branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(node) : branch_QMARK_.call(null,node)))?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(node) : children.call(null,node))], 0)):null));
}),null,null));
});
return walk(root);
});
/**
 * Takes any nested combination of sequential things (lists, vectors,
 *   etc.) and returns their contents as a single, flat sequence.
 *   (flatten nil) returns nil.
 */
cljs.core.flatten = (function cljs$core$flatten(x){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function cljs$core$flatten_$_fn_16379(p1__16378_SHARP_){
return (!(cljs.core.sequential_QMARK_(p1__16378_SHARP_)));
}),cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_,cljs.core.seq,x)));
});
/**
 * Returns a new coll consisting of to-coll with all of the items of
 *   from-coll conjoined. A transducer may be supplied.
 */
cljs.core.into = (function cljs$core$into(var_args){
var G__16381 = arguments.length;
switch (G__16381) {
case 0:
return cljs.core.into.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.into.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.into.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.into.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_16382(){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16383(to){
return to;
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16384(to,from){
if((!((to == null)))){
if((((!((to == null))))?(((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$))))?true:false):false)){
return cljs.core._with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,to,from);
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,to,from);
}
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16386(to,xform,from){
if((((!((to == null))))?(((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$))))?true:false):false)){
var tm = cljs.core.meta(to);
var rf = (function() {
var cljs$core$fn_16386_$_fn_16388 = null;
var cljs$core$fn_16386_$_fn_16388__1 = (function (coll){
return cljs.core._with_meta(cljs.core.persistent_BANG_(coll),tm);
});
var cljs$core$fn_16386_$_fn_16388__2 = (function (coll,v){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(coll,v);
});
cljs$core$fn_16386_$_fn_16388 = function(coll,v){
switch(arguments.length){
case 1:
return cljs$core$fn_16386_$_fn_16388__1.call(this,coll);
case 2:
return cljs$core$fn_16386_$_fn_16388__2.call(this,coll,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16386_$_fn_16388.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16386_$_fn_16388__1;
cljs$core$fn_16386_$_fn_16388.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16386_$_fn_16388__2;
return cljs$core$fn_16386_$_fn_16388;
})()
;
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,rf,cljs.core.transient$(to),from);
} else {
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj,to,from);
}
}));

(cljs.core.into.cljs$lang$maxFixedArity = 3);

/**
 * Returns a vector consisting of the result of applying f to the
 *   set of first items of each coll, followed by applying f to the set
 *   of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments.
 */
cljs.core.mapv = (function cljs$core$mapv(var_args){
var G__16396 = arguments.length;
switch (G__16396) {
case 2:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___16404 = arguments.length;
var i__10857__auto___16405 = (0);
while(true){
if((i__10857__auto___16405 < len__10856__auto___16404)){
args_arr__10885__auto__.push((arguments[i__10857__auto___16405]));

var G__16406 = (i__10857__auto___16405 + (1));
i__10857__auto___16405 = G__16406;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((4) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((4)),(0),null)):null);
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10886__auto__);

}
});

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16397(f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function cljs$core$fn_16397_$_fn_16398(v,o){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(o) : f.call(null,o)));
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16399(f,c1,c2){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,c1,c2));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16400(f,c1,c2,c3){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,c1,c2,c3));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16401(f,c1,c2,c3,colls){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,f,c1,c2,c3,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([colls], 0)));
}));

/** @this {Function} */
(cljs.core.mapv.cljs$lang$applyTo = (function cljs$core$fn_16402(seq16391){
var G__16392 = cljs.core.first(seq16391);
var seq16391__$1 = cljs.core.next(seq16391);
var G__16393 = cljs.core.first(seq16391__$1);
var seq16391__$2 = cljs.core.next(seq16391__$1);
var G__16394 = cljs.core.first(seq16391__$2);
var seq16391__$3 = cljs.core.next(seq16391__$2);
var G__16395 = cljs.core.first(seq16391__$3);
var seq16391__$4 = cljs.core.next(seq16391__$3);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16392,G__16393,G__16394,G__16395,seq16391__$4);
}));

(cljs.core.mapv.cljs$lang$maxFixedArity = (4));

/**
 * Returns a vector of the items in coll for which
 *   (pred item) returns logical true. pred must be free of side-effects.
 */
cljs.core.filterv = (function cljs$core$filterv(pred,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function cljs$core$filterv_$_fn_16407(v,o){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(o) : pred.call(null,o)))){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,o);
} else {
return v;
}
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
/**
 * Returns a lazy sequence of lists of n items each, at offsets step
 *   apart. If step is not supplied, defaults to n, i.e. the partitions
 *   do not overlap. If a pad collection is supplied, use its elements as
 *   necessary to complete last partition up to n items. In case there are
 *   not enough padding elements, return a partition with less than n items.
 */
cljs.core.partition = (function cljs$core$partition(var_args){
var G__16409 = arguments.length;
switch (G__16409) {
case 2:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16410(n,coll){
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,n,coll);
}));

(cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16411(n,step,coll){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16411_$_fn_16412(){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16413(n,step,pad,coll){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16413_$_fn_16414(){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n,step,pad,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return (new cljs.core.List(null,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p,pad)),null,(1),null));
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.partition.cljs$lang$maxFixedArity = 4);

/**
 * Returns the value in a nested associative structure,
 *   where ks is a sequence of keys. Returns nil if the key is not present,
 *   or the not-found value if supplied.
 */
cljs.core.get_in = (function cljs$core$get_in(var_args){
var G__16417 = arguments.length;
switch (G__16417) {
case 2:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16418(m,ks){
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if((ks__$1 == null)){
return m__$1;
} else {
var G__16421 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m__$1,cljs.core.first(ks__$1));
var G__16422 = cljs.core.next(ks__$1);
m__$1 = G__16421;
ks__$1 = G__16422;
continue;
}
break;
}
}));

(cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16419(m,ks,not_found){
var sentinel = cljs.core.lookup_sentinel;
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if((!((ks__$1 == null)))){
var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.first(ks__$1),sentinel);
if((sentinel === m__$2)){
return not_found;
} else {
var G__16423 = sentinel;
var G__16424 = m__$2;
var G__16425 = cljs.core.next(ks__$1);
sentinel = G__16423;
m__$1 = G__16424;
ks__$1 = G__16425;
continue;
}
} else {
return m__$1;
}
break;
}
}));

(cljs.core.get_in.cljs$lang$maxFixedArity = 3);

/**
 * Associates a value in a nested associative structure, where ks is a
 *   sequence of keys and v is the new value and returns a new nested structure.
 *   If any levels do not exist, hash-maps will be created.
 */
cljs.core.assoc_in = (function cljs$core$assoc_in(m,p__16426,v){
var vec__16427 = p__16426;
var seq__16428 = cljs.core.seq(vec__16427);
var first__16429 = cljs.core.first(seq__16428);
var seq__16428__$1 = cljs.core.next(seq__16428);
var k = first__16429;
var ks = seq__16428__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16430 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16431 = ks;
var G__16432 = v;
return (cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3 ? cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3(G__16430,G__16431,G__16432) : cljs.core.assoc_in.call(null,G__16430,G__16431,G__16432));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
/**
 * 'Updates' a value in a nested associative structure, where ks is a
 *   sequence of keys and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   nested structure.  If any levels do not exist, hash-maps will be
 *   created.
 */
cljs.core.update_in = (function cljs$core$update_in(var_args){
var G__16441 = arguments.length;
switch (G__16441) {
case 3:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___16479 = arguments.length;
var i__10857__auto___16480 = (0);
while(true){
if((i__10857__auto___16480 < len__10856__auto___16479)){
args_arr__10885__auto__.push((arguments[i__10857__auto___16480]));

var G__16481 = (i__10857__auto___16480 + (1));
i__10857__auto___16480 = G__16481;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((6) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((6)),(0),null)):null);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__10886__auto__);

}
});

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16443(m,p__16442,f){
var vec__16444 = p__16442;
var seq__16445 = cljs.core.seq(vec__16444);
var first__16446 = cljs.core.first(seq__16445);
var seq__16445__$1 = cljs.core.next(seq__16445);
var k = first__16446;
var ks = seq__16445__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16447 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16447) : f.call(null,G__16447));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16449(m,p__16448,f,a){
var vec__16450 = p__16448;
var seq__16451 = cljs.core.seq(vec__16450);
var first__16452 = cljs.core.first(seq__16451);
var seq__16451__$1 = cljs.core.next(seq__16451);
var k = first__16452;
var ks = seq__16451__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16453 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16454 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16453,G__16454) : f.call(null,G__16453,G__16454));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_16456(m,p__16455,f,a,b){
var vec__16457 = p__16455;
var seq__16458 = cljs.core.seq(vec__16457);
var first__16459 = cljs.core.first(seq__16458);
var seq__16458__$1 = cljs.core.next(seq__16458);
var k = first__16459;
var ks = seq__16458__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16460 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16461 = a;
var G__16462 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16460,G__16461,G__16462) : f.call(null,G__16460,G__16461,G__16462));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_16464(m,p__16463,f,a,b,c){
var vec__16465 = p__16463;
var seq__16466 = cljs.core.seq(vec__16465);
var first__16467 = cljs.core.first(seq__16466);
var seq__16466__$1 = cljs.core.next(seq__16466);
var k = first__16467;
var ks = seq__16466__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b,c));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16468 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16469 = a;
var G__16470 = b;
var G__16471 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__16468,G__16469,G__16470,G__16471) : f.call(null,G__16468,G__16469,G__16470,G__16471));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16473(m,p__16472,f,a,b,c,args){
var vec__16474 = p__16472;
var seq__16475 = cljs.core.seq(vec__16474);
var first__16476 = cljs.core.first(seq__16475);
var seq__16475__$1 = cljs.core.next(seq__16475);
var k = first__16476;
var ks = seq__16475__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([b,c,args], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),a,b,c,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0)));
}
}));

/** @this {Function} */
(cljs.core.update_in.cljs$lang$applyTo = (function cljs$core$fn_16477(seq16434){
var G__16435 = cljs.core.first(seq16434);
var seq16434__$1 = cljs.core.next(seq16434);
var G__16436 = cljs.core.first(seq16434__$1);
var seq16434__$2 = cljs.core.next(seq16434__$1);
var G__16437 = cljs.core.first(seq16434__$2);
var seq16434__$3 = cljs.core.next(seq16434__$2);
var G__16438 = cljs.core.first(seq16434__$3);
var seq16434__$4 = cljs.core.next(seq16434__$3);
var G__16439 = cljs.core.first(seq16434__$4);
var seq16434__$5 = cljs.core.next(seq16434__$4);
var G__16440 = cljs.core.first(seq16434__$5);
var seq16434__$6 = cljs.core.next(seq16434__$5);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16435,G__16436,G__16437,G__16438,G__16439,G__16440,seq16434__$6);
}));

(cljs.core.update_in.cljs$lang$maxFixedArity = (6));

/**
 * 'Updates' a value in an associative structure, where k is a
 *   key and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   structure.  If the key does not exist, nil is passed as the old value.
 */
cljs.core.update = (function cljs$core$update(var_args){
var G__16490 = arguments.length;
switch (G__16490) {
case 3:
return cljs.core.update.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__10885__auto__ = [];
var len__10856__auto___16508 = arguments.length;
var i__10857__auto___16509 = (0);
while(true){
if((i__10857__auto___16509 < len__10856__auto___16508)){
args_arr__10885__auto__.push((arguments[i__10857__auto___16509]));

var G__16510 = (i__10857__auto___16509 + (1));
i__10857__auto___16509 = G__16510;
continue;
} else {
}
break;
}

var argseq__10886__auto__ = ((((6) < args_arr__10885__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10885__auto__.slice((6)),(0),null)):null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__10886__auto__);

}
});

(cljs.core.update.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16491(m,k,f){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16492 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16492) : f.call(null,G__16492));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16493(m,k,f,x){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16494 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16495 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16494,G__16495) : f.call(null,G__16494,G__16495));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_16496(m,k,f,x,y){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16497 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16498 = x;
var G__16499 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16497,G__16498,G__16499) : f.call(null,G__16497,G__16498,G__16499));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_16500(m,k,f,x,y,z){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16501 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16502 = x;
var G__16503 = y;
var G__16504 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__16501,G__16502,G__16503,G__16504) : f.call(null,G__16501,G__16502,G__16503,G__16504));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16505(m,k,f,x,y,z,more){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),x,y,z,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([more], 0)));
}));

/** @this {Function} */
(cljs.core.update.cljs$lang$applyTo = (function cljs$core$fn_16506(seq16483){
var G__16484 = cljs.core.first(seq16483);
var seq16483__$1 = cljs.core.next(seq16483);
var G__16485 = cljs.core.first(seq16483__$1);
var seq16483__$2 = cljs.core.next(seq16483__$1);
var G__16486 = cljs.core.first(seq16483__$2);
var seq16483__$3 = cljs.core.next(seq16483__$2);
var G__16487 = cljs.core.first(seq16483__$3);
var seq16483__$4 = cljs.core.next(seq16483__$3);
var G__16488 = cljs.core.first(seq16483__$4);
var seq16483__$5 = cljs.core.next(seq16483__$4);
var G__16489 = cljs.core.first(seq16483__$5);
var seq16483__$6 = cljs.core.next(seq16483__$5);
var self__10841__auto__ = this;
return self__10841__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16484,G__16485,G__16486,G__16487,G__16488,G__16489,seq16483__$6);
}));

(cljs.core.update.cljs$lang$maxFixedArity = (6));


/**
* @constructor
*/
cljs.core.VectorNode = (function (edit,arr){
this.edit = edit;
this.arr = arr;
});

(cljs.core.VectorNode.getBasis = (function cljs$core$fn_16511(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null);
}));

(cljs.core.VectorNode.cljs$lang$type = true);

(cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode");

(cljs.core.VectorNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_16512(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/VectorNode");
}));

/**
 * Positional factory function for cljs.core/VectorNode.
 */
cljs.core.__GT_VectorNode = (function cljs$core$__GT_VectorNode(edit,arr){
return (new cljs.core.VectorNode(edit,arr));
});

cljs.core.pv_fresh_node = (function cljs$core$pv_fresh_node(edit){
return (new cljs.core.VectorNode(edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
});
cljs.core.pv_aget = (function cljs$core$pv_aget(node,idx){
return (node.arr[idx]);
});
cljs.core.pv_aset = (function cljs$core$pv_aset(node,idx,val){
return (node.arr[idx] = val);
});
cljs.core.pv_clone_node = (function cljs$core$pv_clone_node(node){
return (new cljs.core.VectorNode(node.edit,cljs.core.aclone(node.arr)));
});
cljs.core.tail_off = (function cljs$core$tail_off(pv){
var cnt = pv.cnt;
if((cnt < (32))){
return (0);
} else {
return (((cnt - (1)) >>> (5)) << (5));
}
});
cljs.core.new_path = (function cljs$core$new_path(edit,level,node){
var ll = level;
var ret = node;
while(true){
if((ll === (0))){
return ret;
} else {
var embed = ret;
var r = cljs.core.pv_fresh_node(edit);
var _ = cljs.core.pv_aset(r,(0),embed);
var G__16513 = (ll - (5));
var G__16514 = r;
ll = G__16513;
ret = G__16514;
continue;
}
break;
}
});
cljs.core.push_tail = (function cljs$core$push_tail(pv,level,parent,tailnode){
var ret = cljs.core.pv_clone_node(parent);
var subidx = (((pv.cnt - (1)) >>> level) & (31));
if(((5) === level)){
cljs.core.pv_aset(ret,subidx,tailnode);

return ret;
} else {
var child = cljs.core.pv_aget(parent,subidx);
if((!((child == null)))){
var node_to_insert = (function (){var G__16515 = pv;
var G__16516 = (level - (5));
var G__16517 = child;
var G__16518 = tailnode;
return (cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4(G__16515,G__16516,G__16517,G__16518) : cljs.core.push_tail.call(null,G__16515,G__16516,G__16517,G__16518));
})();
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
} else {
var node_to_insert = cljs.core.new_path(null,(level - (5)),tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
}
}
});
cljs.core.vector_index_out_of_bounds = (function cljs$core$vector_index_out_of_bounds(i,cnt){
throw (new Error(["No item ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i)," in vector of length ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cnt)].join('')));
});
cljs.core.first_array_for_longvec = (function cljs$core$first_array_for_longvec(pv){
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__16519 = cljs.core.pv_aget(node,(0));
var G__16520 = (level - (5));
node = G__16519;
level = G__16520;
continue;
} else {
return node.arr;
}
break;
}
});
cljs.core.unchecked_array_for = (function cljs$core$unchecked_array_for(pv,i){
if((i >= cljs.core.tail_off(pv))){
return pv.tail;
} else {
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__16521 = cljs.core.pv_aget(node,((i >>> level) & (31)));
var G__16522 = (level - (5));
node = G__16521;
level = G__16522;
continue;
} else {
return node.arr;
}
break;
}
}
});
cljs.core.array_for = (function cljs$core$array_for(pv,i){
if(((((0) <= i)) && ((i < pv.cnt)))){
return cljs.core.unchecked_array_for(pv,i);
} else {
return cljs.core.vector_index_out_of_bounds(i,pv.cnt);
}
});
cljs.core.do_assoc = (function cljs$core$do_assoc(pv,level,node,i,val){
var ret = cljs.core.pv_clone_node(node);
if((level === (0))){
cljs.core.pv_aset(ret,(i & (31)),val);

return ret;
} else {
var subidx = ((i >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(function (){var G__16523 = pv;
var G__16524 = (level - (5));
var G__16525 = cljs.core.pv_aget(node,subidx);
var G__16526 = i;
var G__16527 = val;
return (cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5 ? cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5(G__16523,G__16524,G__16525,G__16526,G__16527) : cljs.core.do_assoc.call(null,G__16523,G__16524,G__16525,G__16526,G__16527));
})());

return ret;
}
});
cljs.core.pop_tail = (function cljs$core$pop_tail(pv,level,node){
var subidx = (((pv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = (function (){var G__16528 = pv;
var G__16529 = (level - (5));
var G__16530 = cljs.core.pv_aget(node,subidx);
return (cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3(G__16528,G__16529,G__16530) : cljs.core.pop_tail.call(null,G__16528,G__16529,G__16530));
})();
if((((new_child == null)) && ((subidx === (0))))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,new_child);

return ret;
}
} else {
if((subidx === (0))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,null);

return ret;

}
}
});

/**
* @constructor
*/
cljs.core.RangedIterator = (function (i,base,arr,v,start,end){
this.i = i;
this.base = base;
this.arr = arr;
this.v = v;
this.start = start;
this.end = end;
});
(cljs.core.RangedIterator.prototype.hasNext = (function cljs$core$fn_16531(){
var self__ = this;
var this$ = this;
return (self__.i < self__.end);
}));

(cljs.core.RangedIterator.prototype.next = (function cljs$core$fn_16532(){
var self__ = this;
var this$ = this;
if(((self__.i - self__.base) === (32))){
(self__.arr = cljs.core.unchecked_array_for(self__.v,self__.i));

(self__.base = (self__.base + (32)));
} else {
}

var ret = (self__.arr[(self__.i & (31))]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.RangedIterator.getBasis = (function cljs$core$fn_16533(){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"base","base",1825810849,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null);
}));

(cljs.core.RangedIterator.cljs$lang$type = true);

(cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator");

(cljs.core.RangedIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_16534(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/RangedIterator");
}));

/**
 * Positional factory function for cljs.core/RangedIterator.
 */
cljs.core.__GT_RangedIterator = (function cljs$core$__GT_RangedIterator(i,base,arr,v,start,end){
return (new cljs.core.RangedIterator(i,base,arr,v,start,end));
});

cljs.core.ranged_iterator = (function cljs$core$ranged_iterator(v,start,end){
var i = start;
return (new cljs.core.RangedIterator(i,(i - (i % (32))),(((start < cljs.core.count(v)))?cljs.core.unchecked_array_for(v,i):null),v,start,end));
});
cljs.core.pv_reduce = (function cljs$core$pv_reduce(var_args){
var G__16536 = arguments.length;
switch (G__16536) {
case 4:
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16537(pv,f,start,end){
if((start < end)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(pv,f,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pv,start),(start + (1)),end);
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
}));

(cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_16538(pv,f,init,start,end){
var acc = init;
var i = start;
var arr = cljs.core.unchecked_array_for(pv,start);
while(true){
if((i < end)){
var j = (i & (31));
var arr__$1 = (((j === (0)))?cljs.core.unchecked_array_for(pv,i):arr);
var nacc = (function (){var G__16539 = acc;
var G__16540 = (arr__$1[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16539,G__16540) : f.call(null,G__16539,G__16540));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__16542 = nacc;
var G__16543 = (i + (1));
var G__16544 = arr__$1;
acc = G__16542;
i = G__16543;
arr = G__16544;
continue;
}
} else {
return acc;
}
break;
}
}));

(cljs.core.pv_reduce.cljs$lang$maxFixedArity = 5);







/**
 * Marker protocol
 * @interface
 */
cljs.core.APersistentVector = function(){};


/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.APersistentVector}
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentVector = (function (meta,cnt,shift,root,tail,__hash){
this.meta = meta;
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 401412;
});
(cljs.core.PersistentVector.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_16546(coll,n){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return (new cljs.core.MapEntry(n,(cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]),null));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.toString = (function cljs$core$fn_16547(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentVector.prototype.equiv = (function cljs$core$fn_16548(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentVector.prototype.indexOf = (function() {
var cljs$core$fn_16549 = null;
var cljs$core$fn_16549__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16549__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16549 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16549__1.call(this,x);
case 2:
return cljs$core$fn_16549__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16549.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16549__1;
cljs$core$fn_16549.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16549__2;
return cljs$core$fn_16549;
})()
);

(cljs.core.PersistentVector.prototype.lastIndexOf = (function() {
var cljs$core$fn_16550 = null;
var cljs$core$fn_16550__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16550__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16550 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16550__1.call(this,x);
case 2:
return cljs$core$fn_16550__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16550.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16550__1;
cljs$core$fn_16550.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16550__2;
return cljs$core$fn_16550;
})()
);

(cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16551(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16552(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function cljs$core$fn_16553(v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__16554 = init__$2;
var G__16555 = (j + i);
var G__16556 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16554,G__16555,G__16556) : f.call(null,G__16554,G__16555,G__16556));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__16587 = (j + (1));
var G__16588 = init__$3;
j = G__16587;
init__$2 = G__16588;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__16589 = (i + len);
var G__16590 = init__$2;
i = G__16589;
init__$1 = G__16590;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$APersistentVector$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_16557(coll,n){
var self__ = this;
var coll__$1 = this;
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_16558(coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return (cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]);
} else {
return not_found;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function cljs$core$fn_16559(coll,n,val){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
if((cljs.core.tail_off(coll__$1) <= n)){
var new_tail = cljs.core.aclone(self__.tail);
(new_tail[(n & (31))] = val);

return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,cljs.core.do_assoc(coll__$1,self__.shift,self__.root,n,val),self__.tail,null));
}
} else {
if((n === self__.cnt)){
return coll__$1.cljs$core$ICollection$_conj$arity$2(null,val);
} else {
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds  [0,",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt),"]"].join('')));

}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_16560(this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.ranged_iterator(this$__$1,(0),self__.cnt);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16561(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_16562(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16563(coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_16564(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return coll__$1.cljs$core$IIndexed$_nth$arity$2(null,(self__.cnt - (1)));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_16565(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
} else {
if(((1) < (self__.cnt - cljs.core.tail_off(coll__$1)))){
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt - (1)),self__.shift,self__.root,self__.tail.slice((0),(-1)),null));
} else {
var new_tail = cljs.core.unchecked_array_for(coll__$1,(self__.cnt - (2)));
var nr = cljs.core.pop_tail(coll__$1,self__.shift,self__.root);
var new_root = (((nr == null))?cljs.core.PersistentVector.EMPTY_NODE:nr);
var cnt_1 = (self__.cnt - (1));
if(((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null)))){
return (new cljs.core.PersistentVector(self__.meta,cnt_1,(self__.shift - (5)),cljs.core.pv_aget(new_root,(0)),new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift,new_root,new_tail,null));
}

}
}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_16566(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return (new cljs.core.RSeq(coll__$1,(self__.cnt - (1)),null));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16567(coll){
var self__ = this;
var coll__$1 = this;
var h__9988__auto__ = self__.__hash;
if((!((h__9988__auto__ == null)))){
return h__9988__auto__;
} else {
var h__9988__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9988__auto____$1);

return h__9988__auto____$1;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16568(coll,other){
var self__ = this;
var coll__$1 = this;
if((other instanceof cljs.core.PersistentVector)){
if((self__.cnt === cljs.core.count(other))){
var me_iter = coll__$1.cljs$core$IIterable$_iterator$arity$1(null);
var you_iter = other.cljs$core$IIterable$_iterator$arity$1(null);
while(true){
if(me_iter.hasNext()){
var x = me_iter.next();
var y = you_iter.next();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_sequential(coll__$1,other);
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function cljs$core$fn_16569(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientVector(self__.cnt,self__.shift,cljs.core.tv_editable_root(self__.root),cljs.core.tv_editable_tail(self__.tail)));
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16570(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16571(v,f){
var self__ = this;
var v__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(v__$1,f,(0),self__.cnt);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16572(v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__16573 = init__$2;
var G__16574 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16573,G__16574) : f.call(null,G__16573,G__16574));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__16591 = (j + (1));
var G__16592 = init__$3;
j = G__16591;
init__$2 = G__16592;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__16593 = (i + len);
var G__16594 = init__$2;
i = G__16593;
init__$1 = G__16594;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_16575(coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IVector$_assoc_n$arity$3(null,k,v);
} else {
throw (new Error("Vector's key for assoc must be a number."));
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_16576(coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.integer_QMARK_(k)){
return ((((0) <= k)) && ((k < self__.cnt)));
} else {
return false;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16577(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
return null;
} else {
if((self__.cnt <= (32))){
return (new cljs.core.IndexedSeq(self__.tail,(0),null));
} else {
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(coll__$1,cljs.core.first_array_for_longvec(coll__$1),(0),(0));

}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16578(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentVector(new_meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16579(coll,o){
var self__ = this;
var coll__$1 = this;
if(((self__.cnt - cljs.core.tail_off(coll__$1)) < (32))){
var len = self__.tail.length;
var new_tail = (new Array((len + (1))));
var n__10615__auto___16595 = len;
var i_16596 = (0);
while(true){
if((i_16596 < n__10615__auto___16595)){
(new_tail[i_16596] = (self__.tail[i_16596]));

var G__16597 = (i_16596 + (1));
i_16596 = G__16597;
continue;
} else {
}
break;
}

(new_tail[len] = o);

return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),self__.shift,self__.root,new_tail,null));
} else {
var root_overflow_QMARK_ = ((self__.cnt >>> (5)) > ((1) << self__.shift));
var new_shift = ((root_overflow_QMARK_)?(self__.shift + (5)):self__.shift);
var new_root = ((root_overflow_QMARK_)?(function (){var n_r = cljs.core.pv_fresh_node(null);
cljs.core.pv_aset(n_r,(0),self__.root);

cljs.core.pv_aset(n_r,(1),cljs.core.new_path(null,self__.shift,(new cljs.core.VectorNode(null,self__.tail))));

return n_r;
})():cljs.core.push_tail(coll__$1,self__.shift,self__.root,(new cljs.core.VectorNode(null,self__.tail))));
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),new_shift,new_root,[o],null));
}
}));

(cljs.core.PersistentVector.prototype.call = (function cljs$core$fn_16580(self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
if(typeof k === 'number'){
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
} else {
throw (new Error("Key must be integer"));
}
}));

(cljs.core.PersistentVector.prototype.apply = (function cljs$core$fn_16581(self__,args16545){
var self__ = this;
var self____$1 = this;
var args__10130__auto__ = cljs.core.aclone(args16545);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10130__auto__.length > (20)))?(function (){var G__16582 = args__10130__auto__.slice((0),(20));
G__16582.push(args__10130__auto__.slice((20)));

return G__16582;
})():args__10130__auto__)));
}));

(cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16583(k){
var self__ = this;
var coll = this;
if(typeof k === 'number'){
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
} else {
throw (new Error("Key must be integer"));
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IDrop$_drop$arity$2 = (function cljs$core$fn_16584(coll,n){
var self__ = this;
var coll__$1 = this;
if((n < self__.cnt)){
var offset = (n % (32));
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(coll__$1,cljs.core.unchecked_array_for(coll__$1,n),(n - offset),offset);
} else {
return null;
}
}));

(cljs.core.PersistentVector.getBasis = (function cljs$core$fn_16585(){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"tail","tail",494507963,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentVector.cljs$lang$type = true);

(cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector");

(cljs.core.PersistentVector.cljs$lang$ctorPrWriter = (function cljs$core$fn_16586(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/PersistentVector");
}));

/**
 * Positional factory function for cljs.core/PersistentVector.
 */
cljs.core.__GT_PersistentVector = (function cljs$core$__GT_PersistentVector(meta,cnt,shift,root,tail,__hash){
return (new cljs.core.PersistentVector(meta,cnt,shift,root,tail,__hash));
});

(cljs.core.PersistentVector.EMPTY_NODE = (new cljs.core.VectorNode(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null])));
(cljs.core.PersistentVector.EMPTY = (new cljs.core.PersistentVector(null,(0),(5),cljs.core.PersistentVector.EMPTY_NODE,[],cljs.core.empty_ordered_hash)));
(cljs.core.PersistentVector.fromArray = (function cljs$core$fn_16598(xs,no_clone){
var l = xs.length;
var xs__$1 = ((no_clone)?xs:cljs.core.aclone(xs));
if((l < (32))){
return (new cljs.core.PersistentVector(null,l,(5),cljs.core.PersistentVector.EMPTY_NODE,xs__$1,null));
} else {
var node = xs__$1.slice((0),(32));
var v = (new cljs.core.PersistentVector(null,(32),(5),cljs.core.PersistentVector.EMPTY_NODE,node,null));
var i = (32);
var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
while(true){
if((i < l)){
var G__16599 = (i + (1));
var G__16600 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out,(xs__$1[i]));
i = G__16599;
out = G__16600;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}
}));
(cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16601(){
var this__10717__auto__ = this;
return cljs.core.es6_iterator(this__10717__auto__);
}));
/**
 * Creates a new vector containing the contents of coll. JavaScript arrays
 *   will be aliased and should not be modified.
 */
cljs.core.vec = (function cljs$core$vec(coll){
if(cljs.core.map_entry_QMARK_(coll)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.key(coll),cljs.core.val(coll)], null);
} else {
if(cljs.core.vector_QMARK_(coll)){
return cljs.core.with_meta(coll,null);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.PersistentVector.fromArray(coll,true);
} else {
return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core._as_transient(cljs.core.PersistentVector.EMPTY),coll));

}
}
}
});
/**
 * Creates a new vector containing the args.
 */
cljs.core.vector = (function cljs$core$vector(var_args){
var args__10866__auto__ = [];
var len__10856__auto___16605 = arguments.length;
var i__10857__auto___16606 = (0);
while(true){
if((i__10857__auto___16606 < len__10856__auto___16605)){
args__10866__auto__.push((arguments[i__10857__auto___16606]));

var G__16607 = (i__10857__auto___16606 + (1));
i__10857__auto___16606 = G__16607;
continue;
} else {
}
break;
}

var argseq__10867__auto__ = ((((0) < args__10866__auto__.length))?(new cljs.core.IndexedSeq(args__10866__auto__.slice((0)),(0),null)):null);
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__10867__auto__);
});

(cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16603(args){
if((((args instanceof cljs.core.IndexedSeq)) && ((args.i === (0))))){
return cljs.core.PersistentVector.fromArray(args.arr,(!(cljs.core.array_QMARK_(args.arr))));
} else {
return cljs.core.vec(args);
}
}));

(cljs.core.vector.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.vector.cljs$lang$applyTo = (function cljs$core$fn_16604(seq16602){
var self__10842__auto__ = this;
return self__10842__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq16602));
}));


/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ChunkedSeq = (function (vec,node,i,off,meta,__hash){
this.vec = vec;
this.node = node;
this.i = i;
this.off = off;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375020;
this.cljs$lang$protocol_mask$partition1$ = 263680;
});
(cljs.core.ChunkedSeq.prototype.toString = (function cljs$core$fn_16608(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ChunkedSeq.prototype.equiv = (function cljs$core$fn_16609(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ChunkedSeq.prototype.indexOf = (function() {
var cljs$core$fn_16610 = null;
var cljs$core$fn_16610__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16610__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16610 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16610__1.call(this,x);
case 2:
return cljs$core$fn_16610__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16610.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16610__1;
cljs$core$fn_16610.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16610__2;
return cljs$core$fn_16610;
})()
);

(cljs.core.ChunkedSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_16611 = null;
var cljs$core$fn_16611__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16611__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16611 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16611__1.call(this,x);
case 2:
return cljs$core$fn_16611__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16611.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16611__1;
cljs$core$fn_16611.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16611__2;
return cljs$core$fn_16611;
})()
);

(cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16612(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16613(coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,self__.node,self__.i,(self__.off + (1)));
if((s == null)){
return null;
} else {
return s;
}
} else {
return coll__$1.cljs$core$IChunkedNext$_chunked_next$arity$1(null);
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16614(coll){
var self__ = this;
var coll__$1 = this;
var h__9988__auto__ = self__.__hash;
if((!((h__9988__auto__ == null)))){
return h__9988__auto__;
} else {
var h__9988__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9988__auto____$1);

return h__9988__auto____$1;
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16615(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16616(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16617(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(self__.vec,f,(self__.i + self__.off),cljs.core.count(self__.vec));
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16618(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(self__.vec,f,start,(self__.i + self__.off),cljs.core.count(self__.vec));
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16619(coll){
var self__ = this;
var coll__$1 = this;
return (self__.node[self__.off]);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16620(coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,self__.node,self__.i,(self__.off + (1)));
if((s == null)){
return cljs.core.List.EMPTY;
} else {
return s;
}
} else {
return coll__$1.cljs$core$IChunkedSeq$_chunked_rest$arity$1(null);
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16621(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function cljs$core$fn_16622(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node,self__.off);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function cljs$core$fn_16623(coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,cljs.core.unchecked_array_for(self__.vec,end),end,(0));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16624(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(self__.vec,self__.node,self__.i,self__.off,new_meta);
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16625(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IDrop$_drop$arity$2 = (function cljs$core$fn_16626(coll,n){
var self__ = this;
var coll__$1 = this;
var o = (self__.off + n);
if((o < self__.node.length)){
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,self__.node,self__.i,o);
} else {
var i__$1 = (self__.i + o);
if((i__$1 < cljs.core._count(self__.vec))){
var new_offset = (i__$1 % (32));
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,cljs.core.unchecked_array_for(self__.vec,i__$1),(i__$1 - new_offset),new_offset);
} else {
return null;
}
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function cljs$core$fn_16627(coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,cljs.core.unchecked_array_for(self__.vec,end),end,(0));
} else {
return null;
}
}));

(cljs.core.ChunkedSeq.getBasis = (function cljs$core$fn_16628(){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"vec","vec",982683596,null),new cljs.core.Symbol(null,"node","node",-2073234571,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ChunkedSeq.cljs$lang$type = true);

(cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq");

(cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_16629(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/ChunkedSeq");
}));

/**
 * Positional factory function for cljs.core/ChunkedSeq.
 */
cljs.core.__GT_ChunkedSeq = (function cljs$core$__GT_ChunkedSeq(vec,node,i,off,meta,__hash){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,__hash));
});

(cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16630(){
var this__10717__auto__ = this;
return cljs.core.es6_iterator(this__10717__auto__);
}));
cljs.core.chunked_seq = (function cljs$core$chunked_seq(var_args){
var G__16632 = arguments.length;
switch (G__16632) {
case 3:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16633(vec,i,off){
return (new cljs.core.ChunkedSeq(vec,cljs.core.array_for(vec,i),i,off,null,null));
}));

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16634(vec,node,i,off){
return (new cljs.core.ChunkedSeq(vec,node,i,off,null,null));
}));

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_16635(vec,node,i,off,meta){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,null));
}));

(cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5);


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Subvec = (function (meta,v,start,end,__hash){
this.meta = meta;
this.v = v;
this.start = start;
this.end = end;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(cljs.core.Subvec.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Subvec.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_16638(coll,n){
var self__ = this;
var coll__$1 = this;
if((n < (0))){
return null;
} else {
var idx = (self__.start + n);
if((idx < self__.end)){
return (new cljs.core.MapEntry(n,cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.v,idx),null));
} else {
return null;
}
}
}));

(cljs.core.Subvec.prototype.toString = (function cljs$core$fn_16639(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Subvec.prototype.equiv = (function cljs$core$fn_16640(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Subvec.prototype.indexOf = (function() {
var cljs$core$fn_16641 = null;
var cljs$core$fn_16641__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16641__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
cljs$core$fn_16641 = function(x,start__$1){
switch(arguments.length){
case 1:
return cljs$core$fn_16641__1.call(this,x);
case 2:
return cljs$core$fn_16641__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16641.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16641__1;
cljs$core$fn_16641.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16641__2;
return cljs$core$fn_16641;
})()
);

(cljs.core.Subvec.prototype.lastIndexOf = (function() {
var cljs$core$fn_16642 = null;
var cljs$core$fn_16642__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16642__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
cljs$core$fn_16642 = function(x,start__$1){
switch(arguments.length){
case 1:
return cljs$core$fn_16642__1.call(this,x);
case 2:
return cljs$core$fn_16642__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16642.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16642__1;
cljs$core$fn_16642.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16642__2;
return cljs$core$fn_16642;
})()
);

(cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16643(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16644(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function cljs$core$fn_16645(coll,f,init){
var self__ = this;
var coll__$1 = this;
var i = self__.start;
var j = (0);
var init__$1 = init;
while(true){
if((i < self__.end)){
var init__$2 = (function (){var G__16646 = init__$1;
var G__16647 = j;
var G__16648 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16646,G__16647,G__16648) : f.call(null,G__16646,G__16647,G__16648));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__16680 = (i + (1));
var G__16681 = (j + (1));
var G__16682 = init__$2;
i = G__16680;
j = G__16681;
init__$1 = G__16682;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_16649(coll,n){
var self__ = this;
var coll__$1 = this;
if((((n < (0))) || ((self__.end <= (self__.start + n))))){
return cljs.core.vector_index_out_of_bounds(n,(self__.end - self__.start));
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.start + n));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_16650(coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((n < (0))) || ((self__.end <= (self__.start + n))))){
return not_found;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v,(self__.start + n),not_found);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function cljs$core$fn_16651(coll,n,val){
var self__ = this;
var coll__$1 = this;
var v_pos = (self__.start + n);
if((((n < (0))) || (((self__.end + (1)) <= v_pos)))){
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds [0,",cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll__$1.cljs$core$ICounted$_count$arity$1(null)),"]"].join('')));
} else {
return cljs.core.build_subvec(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v,v_pos,val),self__.start,(function (){var x__9884__auto__ = self__.end;
var y__9885__auto__ = (v_pos + (1));
return ((x__9884__auto__ > y__9885__auto__) ? x__9884__auto__ : y__9885__auto__);
})(),null);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_16652(coll){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.ranged_iterator(self__.v,self__.start,self__.end);
} else {
return cljs.core.seq_iter(coll__$1);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16654(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_16655(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Subvec(self__.meta,self__.v,self__.start,self__.end,self__.__hash));
}));

(cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16656(coll){
var self__ = this;
var coll__$1 = this;
return (self__.end - self__.start);
}));

(cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_16657(coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
return null;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.end - (1)));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_16658(coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
throw (new Error("Can't pop empty vector"));
} else {
return cljs.core.build_subvec(self__.meta,self__.v,self__.start,(self__.end - (1)),null);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_16659(coll){
var self__ = this;
var coll__$1 = this;
if((!((self__.start === self__.end)))){
return (new cljs.core.RSeq(coll__$1,((self__.end - self__.start) - (1)),null));
} else {
return null;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16660(coll){
var self__ = this;
var coll__$1 = this;
var h__9988__auto__ = self__.__hash;
if((!((h__9988__auto__ == null)))){
return h__9988__auto__;
} else {
var h__9988__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9988__auto____$1);

return h__9988__auto____$1;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16661(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16662(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
}));

(cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16663(coll,f){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(self__.v,f,self__.start,self__.end);
} else {
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16665(coll,f,init){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(self__.v,f,init,self__.start,self__.end);
} else {
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,init);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_16667(coll,key,val){
var self__ = this;
var coll__$1 = this;
if(typeof key === 'number'){
return coll__$1.cljs$core$IVector$_assoc_n$arity$3(null,key,val);
} else {
throw (new Error("Subvec's key for assoc must be a number."));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_16668(coll,key){
var self__ = this;
var coll__$1 = this;
if(cljs.core.integer_QMARK_(key)){
return ((((0) <= key)) && ((key < (self__.end - self__.start))));
} else {
return false;
}
}));

(cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16669(coll){
var self__ = this;
var coll__$1 = this;
var subvec_seq = (function cljs$core$fn_16669_$_subvec_seq(i){
if((i === self__.end)){
return null;
} else {
return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i),(new cljs.core.LazySeq(null,(function cljs$core$fn_16669_$_subvec_seq_$_fn_16670(){
return cljs$core$fn_16669_$_subvec_seq((i + (1)));
}),null,null)));
}
});
return subvec_seq(self__.start);
}));

(cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16671(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return cljs.core.build_subvec(new_meta,self__.v,self__.start,self__.end,self__.__hash);
}
}));

(cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16672(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.build_subvec(self__.meta,cljs.core._assoc_n(self__.v,self__.end,o),self__.start,(self__.end + (1)),null);
}));

(cljs.core.Subvec.prototype.call = (function() {
var cljs$core$fn_16673 = null;
var cljs$core$fn_16673__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var cljs$core$fn_16673__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
cljs$core$fn_16673 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_16673__2.call(this,self__,k);
case 3:
return cljs$core$fn_16673__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_16673.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16673__2;
cljs$core$fn_16673.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16673__3;
return cljs$core$fn_16673;
})()
);

(cljs.core.Subvec.prototype.apply = (function cljs$core$fn_16674(self__,args16637){
var self__ = this;
var self____$1 = this;
var args__10130__auto__ = cljs.core.aclone(args16637);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10130__auto__.length > (20)))?(function (){var G__16675 = args__10130__auto__.slice((0),(20));
G__16675.push(args__10130__auto__.slice((20)));

return G__16675;
})():args__10130__auto__)));
}));

(cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16676(k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16677(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.Subvec.getBasis = (function cljs$core$fn_16678(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Subvec.cljs$lang$type = true);

(cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec");

(cljs.core.Subvec.cljs$lang$ctorPrWriter = (function cljs$core$fn_16679(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/Subvec");
}));

/**
 * Positional factory function for cljs.core/Subvec.
 */
cljs.core.__GT_Subvec = (function cljs$core$__GT_Subvec(meta,v,start,end,__hash){
return (new cljs.core.Subvec(meta,v,start,end,__hash));
});

(cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16683(){
var this__10717__auto__ = this;
return cljs.core.es6_iterator(this__10717__auto__);
}));
cljs.core.build_subvec = (function cljs$core$build_subvec(meta,v,start,end,__hash){
while(true){
if((v instanceof cljs.core.Subvec)){
var G__16684 = meta;
var G__16685 = v.v;
var G__16686 = (v.start + start);
var G__16687 = (v.start + end);
var G__16688 = __hash;
meta = G__16684;
v = G__16685;
start = G__16686;
end = G__16687;
__hash = G__16688;
continue;
} else {
if(cljs.core.vector_QMARK_(v)){
} else {
throw (new Error("v must satisfy IVector"));
}

if((((start < (0))) || ((((end < start)) || ((end > cljs.core.count(v))))))){
throw (new Error("Index out of bounds"));
} else {
}

return (new cljs.core.Subvec(meta,v,start,end,__hash));
}
break;
}
});
/**
 * Returns a persistent vector of the items in vector from
 *   start (inclusive) to end (exclusive).  If end is not supplied,
 *   defaults to (count vector). This operation is O(1) and very fast, as
 *   the resulting vector shares structure with the original and no
 *   trimming is done.
 */
cljs.core.subvec = (function cljs$core$subvec(var_args){
var G__16690 = arguments.length;
switch (G__16690) {
case 2:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16691(v,start){
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v,start,cljs.core.count(v));
}));

(cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16692(v,start,end){
if((((!((start == null)))) && ((!((end == null)))))){
} else {
throw (new Error("Assert failed: (and (not (nil? start)) (not (nil? end)))"));
}

return cljs.core.build_subvec(null,v,(start | (0)),(end | (0)),null);
}));

(cljs.core.subvec.cljs$lang$maxFixedArity = 3);

cljs.core.tv_ensure_editable = (function cljs$core$tv_ensure_editable(edit,node){
if((edit === node.edit)){
return node;
} else {
return (new cljs.core.VectorNode(edit,cljs.core.aclone(node.arr)));
}
});
cljs.core.tv_editable_root = (function cljs$core$tv_editable_root(node){
return (new cljs.core.VectorNode(({}),cljs.core.aclone(node.arr)));
});
cljs.core.tv_editable_tail = (function cljs$core$tv_editable_tail(tl){
var ret = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
cljs.core.array_copy(tl,(0),ret,(0),tl.length);

return ret;
});
cljs.core.tv_push_tail = (function cljs$core$tv_push_tail(tv,level,parent,tail_node){
var ret = cljs.core.tv_ensure_editable(tv.root.edit,parent);
var subidx = (((tv.cnt - (1)) >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(((level === (5)))?tail_node:(function (){var child = cljs.core.pv_aget(ret,subidx);
if((!((child == null)))){
var G__16696 = tv;
var G__16697 = (level - (5));
var G__16698 = child;
var G__16699 = tail_node;
return (cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4(G__16696,G__16697,G__16698,G__16699) : cljs.core.tv_push_tail.call(null,G__16696,G__16697,G__16698,G__16699));
} else {
return cljs.core.new_path(tv.root.edit,(level - (5)),tail_node);
}
})()));

return ret;
});
cljs.core.tv_pop_tail = (function cljs$core$tv_pop_tail(tv,level,node){
var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit,node);
var subidx = (((tv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = (function (){var G__16700 = tv;
var G__16701 = (level - (5));
var G__16702 = cljs.core.pv_aget(node__$1,subidx);
return (cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3(G__16700,G__16701,G__16702) : cljs.core.tv_pop_tail.call(null,G__16700,G__16701,G__16702));
})();
if((((new_child == null)) && ((subidx === (0))))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,new_child);

return node__$1;
}
} else {
if((subidx === (0))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,null);

return node__$1;

}
}
});
cljs.core.unchecked_editable_array_for = (function cljs$core$unchecked_editable_array_for(tv,i){
if((i >= cljs.core.tail_off(tv))){
return tv.tail;
} else {
var root = tv.root;
var node = root;
var level = tv.shift;
while(true){
if((level > (0))){
var G__16703 = cljs.core.tv_ensure_editable(root.edit,cljs.core.pv_aget(node,((i >>> level) & (31))));
var G__16704 = (level - (5));
node = G__16703;
level = G__16704;
continue;
} else {
return node.arr;
}
break;
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientVector}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientVector = (function (cnt,shift,root,tail){
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.cljs$lang$protocol_mask$partition1$ = 88;
this.cljs$lang$protocol_mask$partition0$ = 275;
});
(cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function cljs$core$fn_16706(tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((self__.cnt - cljs.core.tail_off(tcoll__$1)) < (32))){
(self__.tail[(self__.cnt & (31))] = o);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
} else {
var tail_node = (new cljs.core.VectorNode(self__.root.edit,self__.tail));
var new_tail = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(new_tail[(0)] = o);

(self__.tail = new_tail);

if(((self__.cnt >>> (5)) > ((1) << self__.shift))){
var new_root_array = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var new_shift = (self__.shift + (5));
(new_root_array[(0)] = self__.root);

(new_root_array[(1)] = cljs.core.new_path(self__.root.edit,self__.shift,tail_node));

(self__.root = (new cljs.core.VectorNode(self__.root.edit,new_root_array)));

(self__.shift = new_shift);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
} else {
var new_root = cljs.core.tv_push_tail(tcoll__$1,self__.shift,self__.root,tail_node);
(self__.root = new_root);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function cljs$core$fn_16707(tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
(self__.root.edit = null);

var len = (self__.cnt - cljs.core.tail_off(tcoll__$1));
var trimmed_tail = (new Array(len));
cljs.core.array_copy(self__.tail,(0),trimmed_tail,(0),len);

return (new cljs.core.PersistentVector(null,self__.cnt,self__.shift,self__.root,trimmed_tail,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function cljs$core$fn_16708(tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(typeof key === 'number'){
return tcoll__$1.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(null,key,val);
} else {
throw (new Error("TransientVector's key for assoc! must be a number."));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = (function cljs$core$fn_16709(tcoll,n,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((((0) <= n)) && ((n < self__.cnt)))){
if((cljs.core.tail_off(tcoll__$1) <= n)){
(self__.tail[(n & (31))] = val);

return tcoll__$1;
} else {
var new_root = (function (){var fexpr__16710 = (function cljs$core$fn_16709_$_go(level,node){
var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit,node);
if((level === (0))){
cljs.core.pv_aset(node__$1,(n & (31)),val);

return node__$1;
} else {
var subidx = ((n >>> level) & (31));
cljs.core.pv_aset(node__$1,subidx,cljs$core$fn_16709_$_go((level - (5)),cljs.core.pv_aget(node__$1,subidx)));

return node__$1;
}
});
return fexpr__16710(self__.shift,self__.root);
})();
(self__.root = new_root);

return tcoll__$1;
}
} else {
if((n === self__.cnt)){
return tcoll__$1.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,val);
} else {
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds for TransientVector of length",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt)].join('')));

}
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = (function cljs$core$fn_16711(tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
(self__.cnt = (0));

return tcoll__$1;
} else {
if((((self__.cnt - (1)) & (31)) > (0))){
(self__.cnt = (self__.cnt - (1)));

return tcoll__$1;
} else {
var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1,(self__.cnt - (2)));
var new_root = (function (){var nr = cljs.core.tv_pop_tail(tcoll__$1,self__.shift,self__.root);
if((!((nr == null)))){
return nr;
} else {
return (new cljs.core.VectorNode(self__.root.edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
}
})();
if(((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null)))){
var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit,cljs.core.pv_aget(new_root,(0)));
(self__.root = new_root__$1);

(self__.shift = (self__.shift - (5)));

(self__.cnt = (self__.cnt - (1)));

(self__.tail = new_tail);

return tcoll__$1;
} else {
(self__.root = new_root);

(self__.cnt = (self__.cnt - (1)));

(self__.tail = new_tail);

return tcoll__$1;
}

}
}
}
} else {
throw (new Error("pop! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16712(coll){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return self__.cnt;
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_16713(coll,n){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
} else {
throw (new Error("nth after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_16714(coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return coll__$1.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
return not_found;
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16715(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16716(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((!(self__.root.edit))){
throw (new Error("lookup after persistent!"));
} else {
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;

}
}
}));

(cljs.core.TransientVector.prototype.call = (function() {
var cljs$core$fn_16717 = null;
var cljs$core$fn_16717__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var cljs$core$fn_16717__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
cljs$core$fn_16717 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_16717__2.call(this,self__,k);
case 3:
return cljs$core$fn_16717__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_16717.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16717__2;
cljs$core$fn_16717.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16717__3;
return cljs$core$fn_16717;
})()
);

(cljs.core.TransientVector.prototype.apply = (function cljs$core$fn_16718(self__,args16705){
var self__ = this;
var self____$1 = this;
var args__10130__auto__ = cljs.core.aclone(args16705);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10130__auto__.length > (20)))?(function (){var G__16719 = args__10130__auto__.slice((0),(20));
G__16719.push(args__10130__auto__.slice((20)));

return G__16719;
})():args__10130__auto__)));
}));

(cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16720(k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16721(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.TransientVector.getBasis = (function cljs$core$fn_16722(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"tail","tail",494507963,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.TransientVector.cljs$lang$type = true);

(cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector");

(cljs.core.TransientVector.cljs$lang$ctorPrWriter = (function cljs$core$fn_16723(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/TransientVector");
}));

/**
 * Positional factory function for cljs.core/TransientVector.
 */
cljs.core.__GT_TransientVector = (function cljs$core$__GT_TransientVector(cnt,shift,root,tail){
return (new cljs.core.TransientVector(cnt,shift,root,tail));
});


/**
* @constructor
*/
cljs.core.PersistentQueueIter = (function (fseq,riter){
this.fseq = fseq;
this.riter = riter;
});
(cljs.core.PersistentQueueIter.prototype.hasNext = (function cljs$core$fn_16724(){
var self__ = this;
var _ = this;
var or__9527__auto__ = (((!((self__.fseq == null)))) && (cljs.core.seq(self__.fseq)));
if(or__9527__auto__){
return or__9527__auto__;
} else {
var and__9521__auto__ = (!((self__.riter == null)));
if(and__9521__auto__){
return self__.riter.hasNext();
} else {
return and__9521__auto__;
}
}
}));

(cljs.core.PersistentQueueIter.prototype.next = (function cljs$core$fn_16725(){
var self__ = this;
var _ = this;
if((!((self__.fseq == null)))){
var ret = cljs.core.first(self__.fseq);
(self__.fseq = cljs.core.next(self__.fseq));

return ret;
} else {
if((((!((self__.riter == null)))) && (self__.riter.hasNext()))){
return self__.riter.next();
} else {
throw (new Error("No such element"));

}
}
}));

(cljs.core.PersistentQueueIter.prototype.remove = (function cljs$core$fn_16726(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.PersistentQueueIter.getBasis = (function cljs$core$fn_16727(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fseq","fseq",-1466412450,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"riter","riter",-237834262,null)], null);
}));

(cljs.core.PersistentQueueIter.cljs$lang$type = true);

(cljs.core.PersistentQueueIter.cljs$lang$ctorStr = "cljs.core/PersistentQueueIter");

(cljs.core.PersistentQueueIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_16728(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/PersistentQueueIter");
}));

/**
 * Positional factory function for cljs.core/PersistentQueueIter.
 */
cljs.core.__GT_PersistentQueueIter = (function cljs$core$__GT_PersistentQueueIter(fseq,riter){
return (new cljs.core.PersistentQueueIter(fseq,riter));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueueSeq = (function (meta,front,rear,__hash){
this.meta = meta;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850700;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.PersistentQueueSeq.prototype.toString = (function cljs$core$fn_16729(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentQueueSeq.prototype.equiv = (function cljs$core$fn_16730(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentQueueSeq.prototype.indexOf = (function() {
var cljs$core$fn_16731 = null;
var cljs$core$fn_16731__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16731__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16731 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16731__1.call(this,x);
case 2:
return cljs$core$fn_16731__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16731.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16731__1;
cljs$core$fn_16731.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16731__2;
return cljs$core$fn_16731;
})()
);

(cljs.core.PersistentQueueSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_16732 = null;
var cljs$core$fn_16732__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16732__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16732 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16732__1.call(this,x);
case 2:
return cljs$core$fn_16732__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16732.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16732__1;
cljs$core$fn_16732.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16732__2;
return cljs$core$fn_16732;
})()
);

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16733(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16734(coll){
var self__ = this;
var coll__$1 = this;
var temp__5718__auto__ = cljs.core.next(self__.front);
if(temp__5718__auto__){
var f1 = temp__5718__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((!((self__.rear == null)))){
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
} else {
return null;
}
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16735(coll){
var self__ = this;
var coll__$1 = this;
var h__9988__auto__ = self__.__hash;
if((!((h__9988__auto__ == null)))){
return h__9988__auto__;
} else {
var h__9988__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9988__auto____$1);

return h__9988__auto____$1;
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16736(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16737(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16738(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16739(coll){
var self__ = this;
var coll__$1 = this;
var temp__5718__auto__ = cljs.core.next(self__.front);
if(temp__5718__auto__){
var f1 = temp__5718__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((self__.rear == null)){
return coll__$1.cljs$core$IEmptyableCollection$_empty$arity$1(null);
} else {
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
}
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16740(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16741(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentQueueSeq(new_meta,self__.front,self__.rear,self__.__hash));
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16742(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.PersistentQueueSeq.getBasis = (function cljs$core$fn_16743(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"front","front",117022539,null),new cljs.core.Symbol(null,"rear","rear",-900164830,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentQueueSeq.cljs$lang$type = true);

(cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq");

(cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_16744(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/PersistentQueueSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentQueueSeq.
 */
cljs.core.__GT_PersistentQueueSeq = (function cljs$core$__GT_PersistentQueueSeq(meta,front,rear,__hash){
return (new cljs.core.PersistentQueueSeq(meta,front,rear,__hash));
});

(cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16745(){
var this__10717__auto__ = this;
return cljs.core.es6_iterator(this__10717__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueue = (function (meta,count,front,rear,__hash){
this.meta = meta;
this.count = count;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 139264;
this.cljs$lang$protocol_mask$partition0$ = 31858766;
});
(cljs.core.PersistentQueue.prototype.toString = (function cljs$core$fn_16746(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentQueue.prototype.equiv = (function cljs$core$fn_16747(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentQueue.prototype.indexOf = (function() {
var cljs$core$fn_16748 = null;
var cljs$core$fn_16748__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16748__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16748 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16748__1.call(this,x);
case 2:
return cljs$core$fn_16748__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16748.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16748__1;
cljs$core$fn_16748.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16748__2;
return cljs$core$fn_16748;
})()
);

(cljs.core.PersistentQueue.prototype.lastIndexOf = (function() {
var cljs$core$fn_16749 = null;
var cljs$core$fn_16749__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(self__.count.cljs$core$IFn$_invoke$arity$1 ? self__.count.cljs$core$IFn$_invoke$arity$1(coll) : self__.count.call(null,coll)));
});
var cljs$core$fn_16749__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16749 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16749__1.call(this,x);
case 2:
return cljs$core$fn_16749__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16749.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16749__1;
cljs$core$fn_16749.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16749__2;
return cljs$core$fn_16749;
})()
);

(cljs.core.PersistentQueue.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_16750(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueIter(self__.front,cljs.core._iterator(self__.rear)));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16751(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_16752(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(self__.meta,self__.count,self__.front,self__.rear,self__.__hash));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16753(coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_16754(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_16755(coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
var temp__5718__auto__ = cljs.core.next(self__.front);
if(temp__5718__auto__){
var f1 = temp__5718__auto__;
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),f1,self__.rear,null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),cljs.core.seq(self__.rear),cljs.core.PersistentVector.EMPTY,null));
}
} else {
return coll__$1;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16756(coll){
var self__ = this;
var coll__$1 = this;
var h__9988__auto__ = self__.__hash;
if((!((h__9988__auto__ == null)))){
return h__9988__auto__;
} else {
var h__9988__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9988__auto____$1);

return h__9988__auto____$1;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16757(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16758(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentQueue.EMPTY,self__.meta);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16759(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16760(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.rest(cljs.core.seq(coll__$1));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16761(coll){
var self__ = this;
var coll__$1 = this;
var rear__$1 = cljs.core.seq(self__.rear);
if(cljs.core.truth_((function (){var or__9527__auto__ = self__.front;
if(cljs.core.truth_(or__9527__auto__)){
return or__9527__auto__;
} else {
return rear__$1;
}
})())){
return (new cljs.core.PersistentQueueSeq(null,self__.front,cljs.core.seq(rear__$1),null));
} else {
return null;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16762(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentQueue(new_meta,self__.count,self__.front,self__.rear,self__.__hash));
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16763(coll,o){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),self__.front,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__9527__auto__ = self__.rear;
if(cljs.core.truth_(or__9527__auto__)){
return or__9527__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),o),null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front,o),cljs.core.PersistentVector.EMPTY,null));
}
}));

(cljs.core.PersistentQueue.getBasis = (function cljs$core$fn_16764(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"front","front",117022539,null),new cljs.core.Symbol(null,"rear","rear",-900164830,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentQueue.cljs$lang$type = true);

(cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue");

(cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = (function cljs$core$fn_16765(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/PersistentQueue");
}));

/**
 * Positional factory function for cljs.core/PersistentQueue.
 */
cljs.core.__GT_PersistentQueue = (function cljs$core$__GT_PersistentQueue(meta,count,front,rear,__hash){
return (new cljs.core.PersistentQueue(meta,count,front,rear,__hash));
});

(cljs.core.PersistentQueue.EMPTY = (new cljs.core.PersistentQueue(null,(0),null,cljs.core.PersistentVector.EMPTY,cljs.core.empty_ordered_hash)));
(cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16766(){
var this__10717__auto__ = this;
return cljs.core.es6_iterator(this__10717__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
*/
cljs.core.NeverEquiv = (function (){
this.cljs$lang$protocol_mask$partition0$ = 2097152;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.NeverEquiv.prototype.equiv = (function cljs$core$fn_16767(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16768(o,other){
var self__ = this;
var o__$1 = this;
return false;
}));

(cljs.core.NeverEquiv.getBasis = (function cljs$core$fn_16769(){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.NeverEquiv.cljs$lang$type = true);

(cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv");

(cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = (function cljs$core$fn_16770(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/NeverEquiv");
}));

/**
 * Positional factory function for cljs.core/NeverEquiv.
 */
cljs.core.__GT_NeverEquiv = (function cljs$core$__GT_NeverEquiv(){
return (new cljs.core.NeverEquiv());
});

cljs.core.never_equiv = (new cljs.core.NeverEquiv());
/**
 * Test map equivalence. Returns true if x equals y, otherwise returns false.
 */
cljs.core.equiv_map = (function cljs$core$equiv_map(x,y){
return cljs.core.boolean$(((((cljs.core.map_QMARK_(y)) && ((!(cljs.core.record_QMARK_(y))))))?(((cljs.core.count(x) === cljs.core.count(y)))?(((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition0$ & (1048576))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IKVReduce$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,x)))?cljs.core.reduce_kv((function cljs$core$equiv_map_$_fn_16772(_,k,v){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,k,cljs.core.never_equiv),v)){
return true;
} else {
return cljs.core.reduced(false);
}
}),true,x):cljs.core.every_QMARK_((function cljs$core$equiv_map_$_fn_16773(xkv){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,cljs.core.first(xkv),cljs.core.never_equiv),cljs.core.second(xkv));
}),x)):null):null));
});
cljs.core.scan_array = (function cljs$core$scan_array(incr,k,array){
var len = array.length;
var i = (0);
while(true){
if((i < len)){
if((k === (array[i]))){
return i;
} else {
var G__16774 = (i + incr);
i = G__16774;
continue;
}
} else {
return null;
}
break;
}
});
cljs.core.obj_map_compare_keys = (function cljs$core$obj_map_compare_keys(a,b){
var a__$1 = cljs.core.hash(a);
var b__$1 = cljs.core.hash(b);
if((a__$1 < b__$1)){
return (-1);
} else {
if((a__$1 > b__$1)){
return (1);
} else {
return (0);

}
}
});
cljs.core.obj_map__GT_hash_map = (function cljs$core$obj_map__GT_hash_map(m,k,v){
var ks = m.keys;
var len = ks.length;
var so = m.strobj;
var mm = cljs.core.meta(m);
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var k__$1 = (ks[i]);
var G__16775 = (i + (1));
var G__16776 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k__$1,cljs.core.goog$module$goog$object.get.call(null,so,k__$1));
i = G__16775;
out = G__16776;
continue;
} else {
return cljs.core._with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k,v)),mm);
}
break;
}
});
cljs.core.obj_clone = (function cljs$core$obj_clone(obj,ks){
var new_obj = ({});
var l = ks.length;
var i_16782 = (0);
while(true){
if((i_16782 < l)){
var k_16783 = (ks[i_16782]);
var G__16779_16784 = new_obj;
var G__16780_16785 = k_16783;
var G__16781_16786 = cljs.core.goog$module$goog$object.get.call(null,obj,k_16783);
cljs.core.goog$module$goog$object.set.call(null,G__16779_16784,G__16780_16785,G__16781_16786);

var G__16787 = (i_16782 + (1));
i_16782 = G__16787;
continue;
} else {
}
break;
}

return new_obj;
});

/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.ObjMap = (function (meta,keys,strobj,update_count,__hash){
this.meta = meta;
this.keys = keys;
this.strobj = strobj;
this.update_count = update_count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 4;
});
(cljs.core.ObjMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.ObjMap.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_16790(coll,k){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return (new cljs.core.MapEntry(k,(self__.strobj[k]),null));
} else {
return null;
}
}));

(cljs.core.ObjMap.prototype.toString = (function cljs$core$fn_16791(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ObjMap.prototype.equiv = (function cljs$core$fn_16792(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16793(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16794(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return (self__.strobj[k]);
} else {
return not_found;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function cljs$core$fn_16795(coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.keys.length;
var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
var init__$1 = init;
while(true){
if(cljs.core.seq(keys__$1)){
var k = cljs.core.first(keys__$1);
var init__$2 = (function (){var G__16796 = init__$1;
var G__16797 = k;
var G__16798 = (self__.strobj[k]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16796,G__16797,G__16798) : f.call(null,G__16796,G__16797,G__16798));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__16819 = cljs.core.rest(keys__$1);
var G__16820 = init__$2;
keys__$1 = G__16819;
init__$1 = G__16820;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16799(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16800(coll){
var self__ = this;
var coll__$1 = this;
return self__.keys.length;
}));

(cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16801(coll){
var self__ = this;
var coll__$1 = this;
var h__9988__auto__ = self__.__hash;
if((!((h__9988__auto__ == null)))){
return h__9988__auto__;
} else {
var h__9988__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__9988__auto____$1);

return h__9988__auto____$1;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16802(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
}));

(cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function cljs$core$fn_16803(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1));
}));

(cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16804(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.ObjMap.EMPTY,self__.meta);
}));

(cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function cljs$core$fn_16805(coll,k){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
var new_keys = cljs.core.aclone(self__.keys);
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
new_keys.splice(cljs.core.scan_array((1),k,new_keys),(1));

delete new_strobj[k];

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
} else {
return coll__$1;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_16806(coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'string'){
if((((self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD)) || ((self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD)))){
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
} else {
if((!((cljs.core.scan_array((1),k,self__.keys) == null)))){
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
cljs.core.goog$module$goog$object.set.call(null,new_strobj,k,v);

return (new cljs.core.ObjMap(self__.meta,self__.keys,new_strobj,(self__.update_count + (1)),null));
} else {
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
var new_keys = cljs.core.aclone(self__.keys);
cljs.core.goog$module$goog$object.set.call(null,new_strobj,k,v);

new_keys.push(k);

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
}
}
} else {
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_16807(coll,k){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return true;
} else {
return false;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16808(coll){
var self__ = this;
var coll__$1 = this;
if((self__.keys.length > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function cljs$core$fn_16808_$_fn_16809(p1__16788_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__16788_SHARP_,(self__.strobj[p1__16788_SHARP_])],null));
}),self__.keys.sort(cljs.core.obj_map_compare_keys));
} else {
return null;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16810(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ObjMap(new_meta,self__.keys,self__.strobj,self__.update_count,self__.__hash));
}
}));

(cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16811(coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,coll__$1,entry);
}
}));

(cljs.core.ObjMap.prototype.call = (function() {
var cljs$core$fn_16812 = null;
var cljs$core$fn_16812__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var cljs$core$fn_16812__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
cljs$core$fn_16812 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_16812__2.call(this,self__,k);
case 3:
return cljs$core$fn_16812__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_16812.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16812__2;
cljs$core$fn_16812.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16812__3;
return cljs$core$fn_16812;
})()
);

(cljs.core.ObjMap.prototype.apply = (function cljs$core$fn_16813(self__,args16789){
var self__ = this;
var self____$1 = this;
var args__10130__auto__ = cljs.core.aclone(args16789);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10130__auto__.length > (20)))?(function (){var G__16814 = args__10130__auto__.slice((0),(20));
G__16814.push(args__10130__auto__.slice((20)));

return G__16814;
})():args__10130__auto__)));
}));

(cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16815(k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16816(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.ObjMap.getBasis = (function cljs$core$fn_16817(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"keys","keys",-1586012071,null),new cljs.core.Symbol(null,"strobj","strobj",1088091283,null),new cljs.core.Symbol(null,"update-count","update-count",-411982269,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ObjMap.cljs$lang$type = true);

(cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap");

(cljs.core.ObjMap.cljs$lang$ctorPrWriter = (function cljs$core$fn_16818(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/ObjMap");
}));

/**
 * Positional factory function for cljs.core/ObjMap.
 */
cljs.core.__GT_ObjMap = (function cljs$core$__GT_ObjMap(meta,keys,strobj,update_count,__hash){
return (new cljs.core.ObjMap(meta,keys,strobj,update_count,__hash));
});

(cljs.core.ObjMap.EMPTY = (new cljs.core.ObjMap(null,[],({}),(0),cljs.core.empty_unordered_hash)));
(cljs.core.ObjMap.HASHMAP_THRESHOLD = (8));
(cljs.core.ObjMap.fromObject = (function cljs$core$fn_16823(ks,obj){
return (new cljs.core.ObjMap(null,ks,obj,(0),null));
}));

/**
* @constructor
*/
cljs.core.RecordIter = (function (i,record,base_count,fields,ext_map_iter){
this.i = i;
this.record = record;
this.base_count = base_count;
this.fields = fields;
this.ext_map_iter = ext_map_iter;
});
(cljs.core.RecordIter.prototype.hasNext = (function cljs$core$fn_16824(){
var self__ = this;
var _ = this;
var or__9527__auto__ = (self__.i < self__.base_count);
if(or__9527__auto__){
return or__9527__auto__;
} else {
return self__.ext_map_iter.hasNext();
}
}));

(cljs.core.RecordIter.prototype.next = (function cljs$core$fn_16825(){
var self__ = this;
var _ = this;
if((self__.i < self__.base_count)){
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.fields,self__.i);
(self__.i = (self__.i + (1)));

return (new cljs.core.MapEntry(k,cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.record,k),null));
} else {
return self__.ext_map_iter.next();
}
}));

(cljs.core.RecordIter.prototype.remove = (function cljs$core$fn_16826(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.RecordIter.getBasis = (function cljs$core$fn_16827(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"record","record",861424668,null),new cljs.core.Symbol(null,"base-count","base-count",-1180647182,null),new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.Symbol(null,"ext-map-iter","ext-map-iter",-1215982757,null)], null);
}));

(cljs.core.RecordIter.cljs$lang$type = true);

(cljs.core.RecordIter.cljs$lang$ctorStr = "cljs.core/RecordIter");

(cljs.core.RecordIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_16828(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/RecordIter");
}));

/**
 * Positional factory function for cljs.core/RecordIter.
 */
cljs.core.__GT_RecordIter = (function cljs$core$__GT_RecordIter(i,record,base_count,fields,ext_map_iter){
return (new cljs.core.RecordIter(i,record,base_count,fields,ext_map_iter));
});


/**
* @constructor
*/
cljs.core.ES6EntriesIterator = (function (s){
this.s = s;
});
(cljs.core.ES6EntriesIterator.prototype.next = (function cljs$core$fn_16829(){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var vec__16830 = cljs.core.first(self__.s);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16830,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16830,(1),null);
(self__.s = cljs.core.next(self__.s));

return ({"value": [k,v], "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6EntriesIterator.getBasis = (function cljs$core$fn_16833(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6EntriesIterator.cljs$lang$type = true);

(cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator");

(cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_16834(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/ES6EntriesIterator");
}));

/**
 * Positional factory function for cljs.core/ES6EntriesIterator.
 */
cljs.core.__GT_ES6EntriesIterator = (function cljs$core$__GT_ES6EntriesIterator(s){
return (new cljs.core.ES6EntriesIterator(s));
});

cljs.core.es6_entries_iterator = (function cljs$core$es6_entries_iterator(coll){
return (new cljs.core.ES6EntriesIterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6SetEntriesIterator = (function (s){
this.s = s;
});
(cljs.core.ES6SetEntriesIterator.prototype.next = (function cljs$core$fn_16835(){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var x = cljs.core.first(self__.s);
(self__.s = cljs.core.next(self__.s));

return ({"value": [x,x], "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6SetEntriesIterator.getBasis = (function cljs$core$fn_16836(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6SetEntriesIterator.cljs$lang$type = true);

(cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator");

(cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_16837(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/ES6SetEntriesIterator");
}));

/**
 * Positional factory function for cljs.core/ES6SetEntriesIterator.
 */
cljs.core.__GT_ES6SetEntriesIterator = (function cljs$core$__GT_ES6SetEntriesIterator(s){
return (new cljs.core.ES6SetEntriesIterator(s));
});

cljs.core.es6_set_entries_iterator = (function cljs$core$es6_set_entries_iterator(coll){
return (new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll)));
});
cljs.core.array_index_of_nil_QMARK_ = (function cljs$core$array_index_of_nil_QMARK_(arr){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((arr[i]) == null)){
return i;
} else {
var G__16838 = (i + (2));
i = G__16838;
continue;

}
}
break;
}
});
cljs.core.array_index_of_keyword_QMARK_ = (function cljs$core$array_index_of_keyword_QMARK_(arr,k){
var len = arr.length;
var kstr = k.fqn;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((((arr[i]) instanceof cljs.core.Keyword)) && ((kstr === (arr[i]).fqn)))){
return i;
} else {
var G__16839 = (i + (2));
i = G__16839;
continue;

}
}
break;
}
});
cljs.core.array_index_of_symbol_QMARK_ = (function cljs$core$array_index_of_symbol_QMARK_(arr,k){
var len = arr.length;
var kstr = k.str;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((((arr[i]) instanceof cljs.core.Symbol)) && ((kstr === (arr[i]).str)))){
return i;
} else {
var G__16840 = (i + (2));
i = G__16840;
continue;

}
}
break;
}
});
cljs.core.array_index_of_identical_QMARK_ = (function cljs$core$array_index_of_identical_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((k === (arr[i]))){
return i;
} else {
var G__16841 = (i + (2));
i = G__16841;
continue;

}
}
break;
}
});
cljs.core.array_index_of_equiv_QMARK_ = (function cljs$core$array_index_of_equiv_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(arr[i]))){
return i;
} else {
var G__16842 = (i + (2));
i = G__16842;
continue;

}
}
break;
}
});
cljs.core.array_index_of = (function cljs$core$array_index_of(arr,k){
if((k instanceof cljs.core.Keyword)){
return cljs.core.array_index_of_keyword_QMARK_(arr,k);
} else {
if(((typeof k === 'string') || (typeof k === 'number'))){
return cljs.core.array_index_of_identical_QMARK_(arr,k);
} else {
if((k instanceof cljs.core.Symbol)){
return cljs.core.array_index_of_symbol_QMARK_(arr,k);
} else {
if((k == null)){
return cljs.core.array_index_of_nil_QMARK_(arr);
} else {
return cljs.core.array_index_of_equiv_QMARK_(arr,k);

}
}
}
}
});
cljs.core.array_map_index_of = (function cljs$core$array_map_index_of(m,k){
return cljs.core.array_index_of(m.arr,k);
});
cljs.core.array_extend_kv = (function cljs$core$array_extend_kv(arr,k,v){
var l = arr.length;
var narr = (new Array((l + (2))));
var i_16843 = (0);
while(true){
if((i_16843 < l)){
(narr[i_16843] = (arr[i_16843]));

var G__16844 = (i_16843 + (1));
i_16843 = G__16844;
continue;
} else {
}
break;
}

(narr[l] = k);

(narr[(l + (1))] = v);

return narr;
});
cljs.core.array_map_extend_kv = (function cljs$core$array_map_extend_kv(m,k,v){
return cljs.core.array_extend_kv(m.arr,k,v);
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.MapEntry = (function (key,val,__hash){
this.key = key;
this.val = val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.MapEntry.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.MapEntry.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_16846(node,k){
var self__ = this;
var node__$1 = this;
var G__16847 = k;
switch (G__16847) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.MapEntry.prototype.indexOf = (function() {
var cljs$core$fn_16848 = null;
var cljs$core$fn_16848__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16848__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16848 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16848__1.call(this,x);
case 2:
return cljs$core$fn_16848__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16848.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16848__1;
cljs$core$fn_16848.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16848__2;
return cljs$core$fn_16848;
})()
);

(cljs.core.MapEntry.prototype.lastIndexOf = (function() {
var cljs$core$fn_16849 = null;
var cljs$core$fn_16849__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16849__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16849 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16849__1.call(this,x);
case 2:
return cljs$core$fn_16849__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16849.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16849__1;
cljs$core$fn_16849.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16849__2;
return cljs$core$fn_16849;
})()
);

(cljs.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16850(node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
}));

(cljs.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16851(node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.MapEntry.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_16852(node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_16853(node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function cljs$core$fn_16854(node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
}));

(cljs.core.MapEntry.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16855(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.MapEntry.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16856(node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.MapEntry.prototype.cljs$core$IMapEntry$_key$arity$1 = (function cljs$core$fn_16857(node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.MapEntry.prototype.cljs$core$IMapEntry$_val$arity$1 = (function cljs$core$fn_16858(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.MapEntry.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_16859(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.MapEntry.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_16860(node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.MapEntry.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_16861(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.MapEntry.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16862(coll){
var self__ = this;
var coll__$1 = this;
var h__9988__auto__ = self__.__hash;
if((!((h__9988__auto__ == null)))){
return h__9988__auto__;
} else {
var h__9988__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9988__auto____$1);

return h__9988__auto____$1;
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16863(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.MapEntry.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16864(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.MapEntry.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16865(node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
}));

(cljs.core.MapEntry.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16866(node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
}));

(cljs.core.MapEntry.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_16867(node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.MapEntry.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_16868(node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.MapEntry.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16869(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.MapEntry.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16870(node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.MapEntry.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16871(node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.MapEntry.prototype.call = (function() {
var cljs$core$fn_16872 = null;
var cljs$core$fn_16872__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var cljs$core$fn_16872__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
cljs$core$fn_16872 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_16872__2.call(this,self__,k);
case 3:
return cljs$core$fn_16872__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_16872.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16872__2;
cljs$core$fn_16872.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16872__3;
return cljs$core$fn_16872;
})()
);

(cljs.core.MapEntry.prototype.apply = (function cljs$core$fn_16873(self__,args16845){
var self__ = this;
var self____$1 = this;
var args__10130__auto__ = cljs.core.aclone(args16845);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10130__auto__.length > (20)))?(function (){var G__16874 = args__10130__auto__.slice((0),(20));
G__16874.push(args__10130__auto__.slice((20)));

return G__16874;
})():args__10130__auto__)));
}));

(cljs.core.MapEntry.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16875(k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.MapEntry.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16876(k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.MapEntry.getBasis = (function cljs$core$fn_16877(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.MapEntry.cljs$lang$type = true);

(cljs.core.MapEntry.cljs$lang$ctorStr = "cljs.core/MapEntry");

(cljs.core.MapEntry.cljs$lang$ctorPrWriter = (function cljs$core$fn_16878(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/MapEntry");
}));

/**
 * Positional factory function for cljs.core/MapEntry.
 */
cljs.core.__GT_MapEntry = (function cljs$core$__GT_MapEntry(key,val,__hash){
return (new cljs.core.MapEntry(key,val,__hash));
});

/**
 * Returns true if x satisfies IMapEntry
 */
cljs.core.map_entry_QMARK_ = (function cljs$core$map_entry_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMapEntry$)))){
return true;
} else {
return false;
}
} else {
return false;
}
});

/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMapSeq = (function (arr,i,_meta){
this.arr = arr;
this.i = i;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 262144;
});
(cljs.core.PersistentArrayMapSeq.prototype.toString = (function cljs$core$fn_16881(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentArrayMapSeq.prototype.equiv = (function cljs$core$fn_16882(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentArrayMapSeq.prototype.indexOf = (function() {
var cljs$core$fn_16883 = null;
var cljs$core$fn_16883__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16883__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16883 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16883__1.call(this,x);
case 2:
return cljs$core$fn_16883__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16883.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16883__1;
cljs$core$fn_16883.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16883__2;
return cljs$core$fn_16883;
})()
);

(cljs.core.PersistentArrayMapSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_16884 = null;
var cljs$core$fn_16884__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16884__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16884 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16884__1.call(this,x);
case 2:
return cljs$core$fn_16884__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16884.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16884__1;
cljs$core$fn_16884.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16884__2;
return cljs$core$fn_16884;
})()
);

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16885(coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16886(coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),null));
} else {
return null;
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16887(coll){
var self__ = this;
var coll__$1 = this;
return ((self__.arr.length - self__.i) / (2));
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16888(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16889(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16890(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16891(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16892(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16893(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.MapEntry((self__.arr[self__.i]),(self__.arr[(self__.i + (1))]),null));
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16894(coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16895(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16896(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__._meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentArrayMapSeq(self__.arr,self__.i,new_meta));
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16897(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IDrop$_drop$arity$2 = (function cljs$core$fn_16898(coll,n){
var self__ = this;
var coll__$1 = this;
if((n < coll__$1.cljs$core$ICounted$_count$arity$1(null))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + ((2) * n)),null));
} else {
return null;
}
}));

(cljs.core.PersistentArrayMapSeq.getBasis = (function cljs$core$fn_16899(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.PersistentArrayMapSeq.cljs$lang$type = true);

(cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq");

(cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_16900(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/PersistentArrayMapSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMapSeq.
 */
cljs.core.__GT_PersistentArrayMapSeq = (function cljs$core$__GT_PersistentArrayMapSeq(arr,i,_meta){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
});

(cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16901(){
var this__10717__auto__ = this;
return cljs.core.es6_iterator(this__10717__auto__);
}));
cljs.core.persistent_array_map_seq = (function cljs$core$persistent_array_map_seq(arr,i,_meta){
if((i <= (arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
} else {
return null;
}
});


/**
* @constructor
*/
cljs.core.PersistentArrayMapIterator = (function (arr,i,cnt){
this.arr = arr;
this.i = i;
this.cnt = cnt;
});
(cljs.core.PersistentArrayMapIterator.prototype.hasNext = (function cljs$core$fn_16902(){
var self__ = this;
var _ = this;
return (self__.i < self__.cnt);
}));

(cljs.core.PersistentArrayMapIterator.prototype.next = (function cljs$core$fn_16903(){
var self__ = this;
var _ = this;
var ret = (new cljs.core.MapEntry((self__.arr[self__.i]),(self__.arr[(self__.i + (1))]),null));
(self__.i = (self__.i + (2)));

return ret;
}));

(cljs.core.PersistentArrayMapIterator.getBasis = (function cljs$core$fn_16904(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null)], null);
}));

(cljs.core.PersistentArrayMapIterator.cljs$lang$type = true);

(cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator");

(cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_16905(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/PersistentArrayMapIterator");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMapIterator.
 */
cljs.core.__GT_PersistentArrayMapIterator = (function cljs$core$__GT_PersistentArrayMapIterator(arr,i,cnt){
return (new cljs.core.PersistentArrayMapIterator(arr,i,cnt));
});


/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMap = (function (meta,cnt,arr,__hash){
this.meta = meta;
this.cnt = cnt;
this.arr = arr;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16647951;
this.cljs$lang$protocol_mask$partition1$ = 401412;
});
(cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_16907(coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return null;
} else {
return (new cljs.core.MapEntry((self__.arr[idx]),(self__.arr[(idx + (1))]),null));
}
}));

(cljs.core.PersistentArrayMap.prototype.toString = (function cljs$core$fn_16908(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentArrayMap.prototype.equiv = (function cljs$core$fn_16909(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentArrayMap.prototype.keys = (function cljs$core$fn_16910(){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.keys(coll));
}));

(cljs.core.PersistentArrayMap.prototype.entries = (function cljs$core$fn_16911(){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentArrayMap.prototype.values = (function cljs$core$fn_16912(){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.vals(coll));
}));

(cljs.core.PersistentArrayMap.prototype.has = (function cljs$core$fn_16913(k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
}));

(cljs.core.PersistentArrayMap.prototype.get = (function cljs$core$fn_16914(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentArrayMap.prototype.forEach = (function cljs$core$fn_16915(f){
var self__ = this;
var coll = this;
var seq__16916 = cljs.core.seq(coll);
var chunk__16917 = null;
var count__16918 = (0);
var i__16919 = (0);
while(true){
if((i__16919 < count__16918)){
var vec__16926 = chunk__16917.cljs$core$IIndexed$_nth$arity$2(null,i__16919);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16926,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16926,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__16965 = seq__16916;
var G__16966 = chunk__16917;
var G__16967 = count__16918;
var G__16968 = (i__16919 + (1));
seq__16916 = G__16965;
chunk__16917 = G__16966;
count__16918 = G__16967;
i__16919 = G__16968;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__16916);
if(temp__5720__auto__){
var seq__16916__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__16916__$1)){
var c__10499__auto__ = cljs.core.chunk_first(seq__16916__$1);
var G__16969 = cljs.core.chunk_rest(seq__16916__$1);
var G__16970 = c__10499__auto__;
var G__16971 = cljs.core.count(c__10499__auto__);
var G__16972 = (0);
seq__16916 = G__16969;
chunk__16917 = G__16970;
count__16918 = G__16971;
i__16919 = G__16972;
continue;
} else {
var vec__16929 = cljs.core.first(seq__16916__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16929,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16929,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__16973 = cljs.core.next(seq__16916__$1);
var G__16974 = null;
var G__16975 = (0);
var G__16976 = (0);
seq__16916 = G__16973;
chunk__16917 = G__16974;
count__16918 = G__16975;
i__16919 = G__16976;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16932(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16933(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function cljs$core$fn_16934(coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var G__16935 = init__$1;
var G__16936 = (self__.arr[i]);
var G__16937 = (self__.arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16935,G__16936,G__16937) : f.call(null,G__16935,G__16936,G__16937));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__16977 = (i + (2));
var G__16978 = init__$2;
i = G__16977;
init__$1 = G__16978;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_16938(this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.PersistentArrayMapIterator(self__.arr,(0),(self__.cnt * (2))));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16939(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_16940(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,self__.arr,self__.__hash));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16941(coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16942(coll){
var self__ = this;
var coll__$1 = this;
var h__9988__auto__ = self__.__hash;
if((!((h__9988__auto__ == null)))){
return h__9988__auto__;
} else {
var h__9988__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__9988__auto____$1);

return h__9988__auto____$1;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16943(coll,other){
var self__ = this;
var coll__$1 = this;
if(((cljs.core.map_QMARK_(other)) && ((!(cljs.core.record_QMARK_(other)))))){
var alen = self__.arr.length;
var other__$1 = other;
if((self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null))){
var i = (0);
while(true){
if((i < alen)){
var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null,(self__.arr[i]),cljs.core.lookup_sentinel);
if((!((v === cljs.core.lookup_sentinel)))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(i + (1))]),v)){
var G__16979 = (i + (2));
i = G__16979;
continue;
} else {
return false;
}
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return false;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function cljs$core$fn_16944(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientArrayMap(({}),self__.arr.length,cljs.core.aclone(self__.arr)));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16947(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY,self__.meta);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16948(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16949(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,start);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function cljs$core$fn_16950(coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx >= (0))){
var len = self__.arr.length;
var new_len = (len - (2));
if((new_len === (0))){
return coll__$1.cljs$core$IEmptyableCollection$_empty$arity$1(null);
} else {
var new_arr = (new Array(new_len));
var s = (0);
var d = (0);
while(true){
if((s >= len)){
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt - (1)),new_arr,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(self__.arr[s]))){
var G__16980 = (s + (2));
var G__16981 = d;
s = G__16980;
d = G__16981;
continue;
} else {
(new_arr[d] = (self__.arr[s]));

(new_arr[(d + (1))] = (self__.arr[(s + (1))]));

var G__16982 = (s + (2));
var G__16983 = (d + (2));
s = G__16982;
d = G__16983;
continue;

}
}
break;
}
}
} else {
return coll__$1;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_16951(coll,k,v){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
if((self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr__$1 = cljs.core.array_map_extend_kv(coll__$1,k,v);
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt + (1)),arr__$1,null));
} else {
return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1),k,v),self__.meta);
}
} else {
if((v === (self__.arr[(idx + (1))]))){
return coll__$1;
} else {
var arr__$1 = (function (){var G__16952 = cljs.core.aclone(self__.arr);
(G__16952[(idx + (1))] = v);

return G__16952;
})();
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,arr__$1,null));

}
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_16953(coll,k){
var self__ = this;
var coll__$1 = this;
return (!((cljs.core.array_map_index_of(coll__$1,k) === (-1))));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16954(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.persistent_array_map_seq(self__.arr,(0),null);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16955(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentArrayMap(new_meta,self__.cnt,self__.arr,self__.__hash));
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16956(coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__16984 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__16985 = cljs.core.next(es);
ret = G__16984;
es = G__16985;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
}));

(cljs.core.PersistentArrayMap.prototype.call = (function() {
var cljs$core$fn_16957 = null;
var cljs$core$fn_16957__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var cljs$core$fn_16957__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
cljs$core$fn_16957 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_16957__2.call(this,self__,k);
case 3:
return cljs$core$fn_16957__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_16957.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16957__2;
cljs$core$fn_16957.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16957__3;
return cljs$core$fn_16957;
})()
);

(cljs.core.PersistentArrayMap.prototype.apply = (function cljs$core$fn_16958(self__,args16906){
var self__ = this;
var self____$1 = this;
var args__10130__auto__ = cljs.core.aclone(args16906);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10130__auto__.length > (20)))?(function (){var G__16959 = args__10130__auto__.slice((0),(20));
G__16959.push(args__10130__auto__.slice((20)));

return G__16959;
})():args__10130__auto__)));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16960(k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16961(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IDrop$_drop$arity$2 = (function cljs$core$fn_16962(coll,n){
var self__ = this;
var coll__$1 = this;
var temp__5724__auto__ = coll__$1.cljs$core$ISeqable$_seq$arity$1(null);
if((temp__5724__auto__ == null)){
return null;
} else {
var s = temp__5724__auto__;
return cljs.core._drop(s,n);
}
}));

(cljs.core.PersistentArrayMap.getBasis = (function cljs$core$fn_16963(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentArrayMap.cljs$lang$type = true);

(cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap");

(cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = (function cljs$core$fn_16964(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/PersistentArrayMap");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMap.
 */
cljs.core.__GT_PersistentArrayMap = (function cljs$core$__GT_PersistentArrayMap(meta,cnt,arr,__hash){
return (new cljs.core.PersistentArrayMap(meta,cnt,arr,__hash));
});

(cljs.core.PersistentArrayMap.EMPTY = (new cljs.core.PersistentArrayMap(null,(0),[],cljs.core.empty_unordered_hash)));
(cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = (8));
(cljs.core.PersistentArrayMap.fromArray = (function cljs$core$fn_16986(arr,no_clone,no_check){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var arr__$2 = ((no_check)?arr__$1:(function (){var ret = [];
var i_16987 = (0);
while(true){
if((i_16987 < arr__$1.length)){
var k_16988 = (arr__$1[i_16987]);
var v_16989 = (arr__$1[(i_16987 + (1))]);
var idx_16990 = cljs.core.array_index_of(ret,k_16988);
if((idx_16990 === (-1))){
ret.push(k_16988);

ret.push(v_16989);
} else {
}

var G__16991 = (i_16987 + (2));
i_16987 = G__16991;
continue;
} else {
}
break;
}

return ret;
})());
var cnt = (arr__$2.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr__$2,null));
}));
(cljs.core.PersistentArrayMap.createWithCheck = (function cljs$core$fn_16992(arr){
var ret = [];
var i_16994 = (0);
while(true){
if((i_16994 < arr.length)){
var k_16995 = (arr[i_16994]);
var v_16996 = (arr[(i_16994 + (1))]);
var idx_16997 = cljs.core.array_index_of(ret,k_16995);
if((idx_16997 === (-1))){
var G__16993_16998 = ret;
G__16993_16998.push(k_16995);

G__16993_16998.push(v_16996);

} else {
throw (new Error(["Duplicate key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k_16995)].join('')));
}

var G__16999 = (i_16994 + (2));
i_16994 = G__16999;
continue;
} else {
}
break;
}

var cnt = (arr.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr,null));
}));
cljs.core.key_test = (function cljs$core$key_test(key,other){
if((key === other)){
return true;
} else {
if(cljs.core.keyword_identical_QMARK_(key,other)){
return true;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,other);

}
}
});
cljs.core.pam_dupes_QMARK_ = (function cljs$core$pam_dupes_QMARK_(arr){
var i = (0);
while(true){
if((i < arr.length)){
var dupe_QMARK_ = (function (){var j = (0);
while(true){
if((j < i)){
var or__9527__auto__ = cljs.core.key_test((arr[i]),(arr[j]));
if(or__9527__auto__){
return or__9527__auto__;
} else {
var G__17000 = ((2) + j);
j = G__17000;
continue;
}
} else {
return false;
}
break;
}
})();
var or__9527__auto__ = dupe_QMARK_;
if(or__9527__auto__){
return or__9527__auto__;
} else {
var G__17001 = ((2) + i);
i = G__17001;
continue;
}
} else {
return false;
}
break;
}
});
cljs.core.pam_new_size = (function cljs$core$pam_new_size(arr){
var i = (0);
var n = (0);
while(true){
if((i < arr.length)){
var dupe_QMARK_ = (function (){var j = (0);
while(true){
if((j < i)){
var or__9527__auto__ = cljs.core.key_test((arr[i]),(arr[j]));
if(or__9527__auto__){
return or__9527__auto__;
} else {
var G__17002 = ((2) + j);
j = G__17002;
continue;
}
} else {
return false;
}
break;
}
})();
var G__17003 = ((2) + i);
var G__17004 = ((dupe_QMARK_)?n:(n + (2)));
i = G__17003;
n = G__17004;
continue;
} else {
return n;
}
break;
}
});
cljs.core.pam_grow_seed_array = (function cljs$core$pam_grow_seed_array(seed,trailing){
var seed_cnt = (seed.length - (1));
var extra_kvs = cljs.core.seq(trailing);
var ret = (new Array((seed_cnt + ((2) * cljs.core.count(extra_kvs)))));
var ret__$1 = cljs.core.array_copy(seed,(0),ret,(0),seed_cnt);
var i = seed_cnt;
var extra_kvs__$1 = extra_kvs;
while(true){
if(extra_kvs__$1){
var kv = cljs.core.first(extra_kvs__$1);
(ret__$1[i] = cljs.core._key(kv));

(ret__$1[(i + (1))] = cljs.core._val(kv));

var G__17005 = ((2) + seed_cnt);
var G__17006 = cljs.core.next(extra_kvs__$1);
i = G__17005;
extra_kvs__$1 = G__17006;
continue;
} else {
return ret__$1;
}
break;
}
});
(cljs.core.PersistentArrayMap.createAsIfByAssoc = (function cljs$core$fn_17007(init){
var len = init.length;
var has_trailing_QMARK_ = ((1) === (len & (1)));
if((!(((has_trailing_QMARK_) || (cljs.core.pam_dupes_QMARK_(init)))))){
return (new cljs.core.PersistentArrayMap(null,(len / (2)),init,null));
} else {
return cljs.core.PersistentArrayMap.createAsIfByAssocComplexPath(init,has_trailing_QMARK_);
}
}));
(cljs.core.PersistentArrayMap.createAsIfByAssocComplexPath = (function cljs$core$fn_17008(init,has_trailing_QMARK_){
var init__$1 = ((has_trailing_QMARK_)?cljs.core.pam_grow_seed_array(init,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(init[(init.length - (1))]))):init);
var n = cljs.core.pam_new_size(init__$1);
var len = init__$1.length;
if((n < len)){
var nodups = (new Array(n));
var i_17009 = (0);
var m_17010 = (0);
while(true){
if((i_17009 < len)){
var dupe_QMARK__17011 = (function (){var j = (0);
while(true){
if((j < m_17010)){
var or__9527__auto__ = cljs.core.key_test((init__$1[i_17009]),(init__$1[j]));
if(or__9527__auto__){
return or__9527__auto__;
} else {
var G__17012 = ((2) + j);
j = G__17012;
continue;
}
} else {
return false;
}
break;
}
})();
if((!(dupe_QMARK__17011))){
var j_17013 = (function (){var j_17013 = (len - (2));
while(true){
if((j_17013 >= i_17009)){
if(cljs.core.key_test((init__$1[i_17009]),(init__$1[j_17013]))){
return j_17013;
} else {
var G__17014 = (j_17013 - (2));
j_17013 = G__17014;
continue;
}
} else {
return j_17013;
}
break;
}
})();
(nodups[m_17010] = (init__$1[i_17009]));

(nodups[(m_17010 + (1))] = (init__$1[(j_17013 + (1))]));

var G__17015 = ((2) + i_17009);
var G__17016 = ((2) + m_17010);
i_17009 = G__17015;
m_17010 = G__17016;
continue;
} else {
var G__17017 = ((2) + i_17009);
var G__17018 = m_17010;
i_17009 = G__17017;
m_17010 = G__17018;
continue;
}
} else {
}
break;
}

return (new cljs.core.PersistentArrayMap(null,(nodups.length / (2)),nodups,null));
} else {
return (new cljs.core.PersistentArrayMap(null,(init__$1.length / (2)),init__$1,null));
}
}));
(cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17019(){
var this__10717__auto__ = this;
return cljs.core.es6_iterator(this__10717__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientArrayMap = (function (editable_QMARK_,len,arr){
this.editable_QMARK_ = editable_QMARK_;
this.len = len;
this.arr = arr;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 56;
});
(cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17021(tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
return cljs.core.quot(self__.len,(2));
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_17022(tcoll,k){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_17023(tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of(tcoll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
} else {
throw (new Error("lookup after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function cljs$core$fn_17024(tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
if(cljs.core.map_entry_QMARK_(o)){
return tcoll__$1.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,cljs.core.key(o),cljs.core.val(o));
} else {
if(cljs.core.vector_QMARK_(o)){
return tcoll__$1.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((0)) : o.call(null,(0))),(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((1)) : o.call(null,(1))));
} else {
var es = cljs.core.seq(o);
var tcoll__$2 = tcoll__$1;
while(true){
var temp__5718__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__5718__auto__)){
var e = temp__5718__auto__;
var G__17036 = cljs.core.next(es);
var G__17037 = cljs.core._assoc_BANG_(tcoll__$2,cljs.core.key(e),cljs.core.val(e));
es = G__17036;
tcoll__$2 = G__17037;
continue;
} else {
return tcoll__$2;
}
break;
}

}
}
} else {
throw (new Error("conj! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function cljs$core$fn_17025(tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
(self__.editable_QMARK_ = false);

return (new cljs.core.PersistentArrayMap(null,cljs.core.quot(self__.len,(2)),self__.arr,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function cljs$core$fn_17026(tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx === (-1))){
if(((self__.len + (2)) <= ((2) * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD))){
(self__.len = (self__.len + (2)));

self__.arr.push(key);

self__.arr.push(val);

return tcoll__$1;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.array__GT_transient_hash_map(self__.len,self__.arr),key,val);
}
} else {
if((val === (self__.arr[(idx + (1))]))){
return tcoll__$1;
} else {
(self__.arr[(idx + (1))] = val);

return tcoll__$1;
}
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function cljs$core$fn_17027(tcoll,key){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx >= (0))){
(self__.arr[idx] = (self__.arr[(self__.len - (2))]));

(self__.arr[(idx + (1))] = (self__.arr[(self__.len - (1))]));

var G__17028_17038 = self__.arr;
G__17028_17038.pop();

G__17028_17038.pop();


(self__.len = (self__.len - (2)));
} else {
}

return tcoll__$1;
} else {
throw (new Error("dissoc! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.call = (function() {
var cljs$core$fn_17029 = null;
var cljs$core$fn_17029__2 = (function (self__,key){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,null);
});
var cljs$core$fn_17029__3 = (function (self__,key,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
});
cljs$core$fn_17029 = function(self__,key,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_17029__2.call(this,self__,key);
case 3:
return cljs$core$fn_17029__3.call(this,self__,key,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_17029.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17029__2;
cljs$core$fn_17029.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_17029__3;
return cljs$core$fn_17029;
})()
);

(cljs.core.TransientArrayMap.prototype.apply = (function cljs$core$fn_17030(self__,args17020){
var self__ = this;
var self____$1 = this;
var args__10130__auto__ = cljs.core.aclone(args17020);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10130__auto__.length > (20)))?(function (){var G__17031 = args__10130__auto__.slice((0),(20));
G__17031.push(args__10130__auto__.slice((20)));

return G__17031;
})():args__10130__auto__)));
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17032(key){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,null);
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_17033(key,not_found){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
}));

(cljs.core.TransientArrayMap.getBasis = (function cljs$core$fn_17034(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"editable?","editable?",-164945806,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"len","len",-1230778691,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null);
}));

(cljs.core.TransientArrayMap.cljs$lang$type = true);

(cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap");

(cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = (function cljs$core$fn_17035(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/TransientArrayMap");
}));

/**
 * Positional factory function for cljs.core/TransientArrayMap.
 */
cljs.core.__GT_TransientArrayMap = (function cljs$core$__GT_TransientArrayMap(editable_QMARK_,len,arr){
return (new cljs.core.TransientArrayMap(editable_QMARK_,len,arr));
});

cljs.core.array__GT_transient_hash_map = (function cljs$core$array__GT_transient_hash_map(len,arr){
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i = (0);
while(true){
if((i < len)){
var G__17039 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,(arr[i]),(arr[(i + (1))]));
var G__17040 = (i + (2));
out = G__17039;
i = G__17040;
continue;
} else {
return out;
}
break;
}
});

/**
* @constructor
*/
cljs.core.Box = (function (val){
this.val = val;
});

(cljs.core.Box.getBasis = (function cljs$core$fn_17041(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Box.cljs$lang$type = true);

(cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box");

(cljs.core.Box.cljs$lang$ctorPrWriter = (function cljs$core$fn_17042(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/Box");
}));

/**
 * Positional factory function for cljs.core/Box.
 */
cljs.core.__GT_Box = (function cljs$core$__GT_Box(val){
return (new cljs.core.Box(val));
});



cljs.core.mask = (function cljs$core$mask(hash,shift){
return ((hash >>> shift) & (31));
});
cljs.core.clone_and_set = (function cljs$core$clone_and_set(var_args){
var G__17044 = arguments.length;
switch (G__17044) {
case 3:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_17045(arr,i,a){
var G__17046 = cljs.core.aclone(arr);
(G__17046[i] = a);

return G__17046;
}));

(cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_17047(arr,i,a,j,b){
var G__17048 = cljs.core.aclone(arr);
(G__17048[i] = a);

(G__17048[j] = b);

return G__17048;
}));

(cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5);

cljs.core.remove_pair = (function cljs$core$remove_pair(arr,i){
var new_arr = (new Array((arr.length - (2))));
cljs.core.array_copy(arr,(0),new_arr,(0),((2) * i));

cljs.core.array_copy(arr,((2) * (i + (1))),new_arr,((2) * i),(new_arr.length - ((2) * i)));

return new_arr;
});
cljs.core.bitmap_indexed_node_index = (function cljs$core$bitmap_indexed_node_index(bitmap,bit){
return cljs.core.bit_count((bitmap & (bit - (1))));
});
cljs.core.bitpos = (function cljs$core$bitpos(hash,shift){
return ((1) << ((hash >>> shift) & 0x01f));
});
cljs.core.edit_and_set = (function cljs$core$edit_and_set(var_args){
var G__17051 = arguments.length;
switch (G__17051) {
case 4:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_17052(inode,edit,i,a){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

return editable;
}));

(cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_17053(inode,edit,i,a,j,b){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

(editable.arr[j] = b);

return editable;
}));

(cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6);

cljs.core.inode_kv_reduce = (function cljs$core$inode_kv_reduce(arr,f,init){
var len = arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var k = (arr[i]);
if((!((k == null)))){
var G__17055 = init__$1;
var G__17056 = k;
var G__17057 = (arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17055,G__17056,G__17057) : f.call(null,G__17055,G__17056,G__17057));
} else {
var node = (arr[(i + (1))]);
if((!((node == null)))){
return node.kv_reduce(f,init__$1);
} else {
return init__$1;
}
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
var G__17058 = (i + (2));
var G__17059 = init__$2;
i = G__17058;
init__$1 = G__17059;
continue;
}
} else {
return init__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.NodeIterator = (function (arr,i,next_entry,next_iter){
this.arr = arr;
this.i = i;
this.next_entry = next_entry;
this.next_iter = next_iter;
});
(cljs.core.NodeIterator.prototype.advance = (function cljs$core$fn_17060(){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if((self__.i < len)){
var key = (self__.arr[self__.i]);
var node_or_val = (self__.arr[(self__.i + (1))]);
var found = (((!((key == null))))?(self__.next_entry = (new cljs.core.MapEntry(key,node_or_val,null))):(((!((node_or_val == null))))?(function (){var new_iter = cljs.core._iterator(node_or_val);
if(new_iter.hasNext()){
return (self__.next_iter = new_iter);
} else {
return false;
}
})():false
));
(self__.i = (self__.i + (2)));

if(found){
return true;
} else {
continue;
}
} else {
return false;
}
break;
}
}));

(cljs.core.NodeIterator.prototype.hasNext = (function cljs$core$fn_17061(){
var self__ = this;
var this$ = this;
var or__9527__auto__ = (!((self__.next_entry == null)));
if(or__9527__auto__){
return or__9527__auto__;
} else {
var or__9527__auto____$1 = (!((self__.next_iter == null)));
if(or__9527__auto____$1){
return or__9527__auto____$1;
} else {
return this$.advance();
}
}
}));

(cljs.core.NodeIterator.prototype.next = (function cljs$core$fn_17062(){
var self__ = this;
var this$ = this;
if((!((self__.next_entry == null)))){
var ret = self__.next_entry;
(self__.next_entry = null);

return ret;
} else {
if((!((self__.next_iter == null)))){
var ret = self__.next_iter.next();
if(self__.next_iter.hasNext()){
} else {
(self__.next_iter = null);
}

return ret;
} else {
if(this$.advance()){
return this$.next();
} else {
throw (new Error("No such element"));

}
}
}
}));

(cljs.core.NodeIterator.prototype.remove = (function cljs$core$fn_17063(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.NodeIterator.getBasis = (function cljs$core$fn_17064(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-entry","next-entry",1091342476,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-iter","next-iter",1526626239,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.NodeIterator.cljs$lang$type = true);

(cljs.core.NodeIterator.cljs$lang$ctorStr = "cljs.core/NodeIterator");

(cljs.core.NodeIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_17065(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/NodeIterator");
}));

/**
 * Positional factory function for cljs.core/NodeIterator.
 */
cljs.core.__GT_NodeIterator = (function cljs$core$__GT_NodeIterator(arr,i,next_entry,next_iter){
return (new cljs.core.NodeIterator(arr,i,next_entry,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.BitmapIndexedNode = (function (edit,bitmap,arr){
this.edit = edit;
this.bitmap = bitmap;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.BitmapIndexedNode.prototype.ensure_editable = (function cljs$core$fn_17066(e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var n = cljs.core.bit_count(self__.bitmap);
var new_arr = (new Array((((n < (0)))?(4):((2) * (n + (1))))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * n));

return (new cljs.core.BitmapIndexedNode(e,self__.bitmap,new_arr));
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = (function cljs$core$fn_17067(edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
if((!((n == null)))){
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
} else {
if((self__.bitmap === bit)){
return null;
} else {
return inode.edit_and_remove_pair(edit__$1,bit,idx);

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
(removed_leaf_QMARK_.val = true);

return inode.edit_and_remove_pair(edit__$1,bit,idx);
} else {
return inode;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = (function cljs$core$fn_17068(e,bit,i){
var self__ = this;
var inode = this;
if((self__.bitmap === bit)){
return null;
} else {
var editable = inode.ensure_editable(e);
var earr = editable.arr;
var len = earr.length;
(editable.bitmap = (bit ^ editable.bitmap));

cljs.core.array_copy(earr,((2) * (i + (1))),earr,((2) * i),(len - ((2) * (i + (1)))));

(earr[(len - (2))] = null);

(earr[(len - (1))] = null);

return editable;
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_seq = (function cljs$core$fn_17069(){
var self__ = this;
var inode = this;
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr);
}));

(cljs.core.BitmapIndexedNode.prototype.kv_reduce = (function cljs$core$fn_17070(f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
}));

(cljs.core.BitmapIndexedNode.prototype.inode_lookup = (function cljs$core$fn_17071(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return val_or_node;
} else {
return not_found;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = (function cljs$core$fn_17072(edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((((2) * n) < self__.arr.length)){
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(added_leaf_QMARK_.val = true);

cljs.core.array_copy_downward(earr,((2) * idx),earr,((2) * (idx + (1))),((2) * (n - idx)));

(earr[((2) * idx)] = key);

(earr[(((2) * idx) + (1))] = val);

(editable.bitmap = (editable.bitmap | bit));

return editable;
} else {
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_17079 = (0);
var j_17080 = (0);
while(true){
if((i_17079 < (32))){
if((((self__.bitmap >>> i_17079) & (1)) === (0))){
var G__17081 = (i_17079 + (1));
var G__17082 = j_17080;
i_17079 = G__17081;
j_17080 = G__17082;
continue;
} else {
(nodes[i_17079] = (((!(((self__.arr[j_17080]) == null))))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),cljs.core.hash((self__.arr[j_17080])),(self__.arr[j_17080]),(self__.arr[(j_17080 + (1))]),added_leaf_QMARK_):(self__.arr[(j_17080 + (1))])));

var G__17083 = (i_17079 + (1));
var G__17084 = (j_17080 + (2));
i_17079 = G__17083;
j_17080 = G__17084;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(edit__$1,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (4)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

(added_leaf_QMARK_.val = true);

var editable = inode.ensure_editable(edit__$1);
(editable.arr = new_arr);

(editable.bitmap = (editable.bitmap | bit));

return editable;

}
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),val);
}
} else {
(added_leaf_QMARK_.val = true);

return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * idx),null,(((2) * idx) + (1)),cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(edit__$1,(shift + (5)),key_or_nil,val_or_node,hash,key,val));

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_assoc = (function cljs$core$fn_17073(shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_17085 = (0);
var j_17086 = (0);
while(true){
if((i_17085 < (32))){
if((((self__.bitmap >>> i_17085) & (1)) === (0))){
var G__17087 = (i_17085 + (1));
var G__17088 = j_17086;
i_17085 = G__17087;
j_17086 = G__17088;
continue;
} else {
(nodes[i_17085] = (((!(((self__.arr[j_17086]) == null))))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),cljs.core.hash((self__.arr[j_17086])),(self__.arr[j_17086]),(self__.arr[(j_17086 + (1))]),added_leaf_QMARK_):(self__.arr[(j_17086 + (1))])));

var G__17089 = (i_17085 + (1));
var G__17090 = (j_17086 + (2));
i_17085 = G__17089;
j_17086 = G__17090;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(null,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

(added_leaf_QMARK_.val = true);

return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap | bit),new_arr));
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),val)));
}
} else {
(added_leaf_QMARK_.val = true);

return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr,((2) * idx),null,(((2) * idx) + (1)),cljs.core.create_node.cljs$core$IFn$_invoke$arity$6((shift + (5)),key_or_nil,val_or_node,hash,key,val))));

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_find = (function cljs$core$fn_17074(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_find((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return (new cljs.core.MapEntry(key_or_nil,val_or_node,null));
} else {
return not_found;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_without = (function cljs$core$fn_17075(shift,hash,key){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without((shift + (5)),hash,key);
if((n === val_or_node)){
return inode;
} else {
if((!((n == null)))){
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
} else {
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));
}
} else {
return inode;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_17076(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
}));

(cljs.core.BitmapIndexedNode.getBasis = (function cljs$core$fn_17077(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"bitmap","bitmap",501334601,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.BitmapIndexedNode.cljs$lang$type = true);

(cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode");

(cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_17078(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/BitmapIndexedNode");
}));

/**
 * Positional factory function for cljs.core/BitmapIndexedNode.
 */
cljs.core.__GT_BitmapIndexedNode = (function cljs$core$__GT_BitmapIndexedNode(edit,bitmap,arr){
return (new cljs.core.BitmapIndexedNode(edit,bitmap,arr));
});

(cljs.core.BitmapIndexedNode.EMPTY = (new cljs.core.BitmapIndexedNode(null,(0),[])));
cljs.core.pack_array_node = (function cljs$core$pack_array_node(array_node,edit,idx){
var arr = array_node.arr;
var len = arr.length;
var new_arr = (new Array(((2) * (array_node.cnt - (1)))));
var i = (0);
var j = (1);
var bitmap = (0);
while(true){
if((i < len)){
if((((!((i === idx)))) && ((!(((arr[i]) == null)))))){
(new_arr[j] = (arr[i]));

var G__17091 = (i + (1));
var G__17092 = (j + (2));
var G__17093 = (bitmap | ((1) << i));
i = G__17091;
j = G__17092;
bitmap = G__17093;
continue;
} else {
var G__17094 = (i + (1));
var G__17095 = j;
var G__17096 = bitmap;
i = G__17094;
j = G__17095;
bitmap = G__17096;
continue;
}
} else {
return (new cljs.core.BitmapIndexedNode(edit,bitmap,new_arr));
}
break;
}
});

/**
* @constructor
*/
cljs.core.ArrayNodeIterator = (function (arr,i,next_iter){
this.arr = arr;
this.i = i;
this.next_iter = next_iter;
});
(cljs.core.ArrayNodeIterator.prototype.hasNext = (function cljs$core$fn_17097(){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if((!((((!((self__.next_iter == null)))) && (self__.next_iter.hasNext()))))){
if((self__.i < len)){
var node = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

if((!((node == null)))){
(self__.next_iter = cljs.core._iterator(node));
} else {
}

continue;
} else {
return false;
}
} else {
return true;
}
break;
}
}));

(cljs.core.ArrayNodeIterator.prototype.next = (function cljs$core$fn_17098(){
var self__ = this;
var this$ = this;
if(this$.hasNext()){
return self__.next_iter.next();
} else {
throw (new Error("No such element"));
}
}));

(cljs.core.ArrayNodeIterator.prototype.remove = (function cljs$core$fn_17099(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.ArrayNodeIterator.getBasis = (function cljs$core$fn_17100(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-iter","next-iter",1526626239,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayNodeIterator.cljs$lang$type = true);

(cljs.core.ArrayNodeIterator.cljs$lang$ctorStr = "cljs.core/ArrayNodeIterator");

(cljs.core.ArrayNodeIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_17101(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/ArrayNodeIterator");
}));

/**
 * Positional factory function for cljs.core/ArrayNodeIterator.
 */
cljs.core.__GT_ArrayNodeIterator = (function cljs$core$__GT_ArrayNodeIterator(arr,i,next_iter){
return (new cljs.core.ArrayNodeIterator(arr,i,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.ArrayNode = (function (edit,cnt,arr){
this.edit = edit;
this.cnt = cnt;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.ArrayNode.prototype.ensure_editable = (function cljs$core$fn_17102(e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
return (new cljs.core.ArrayNode(e,self__.cnt,cljs.core.aclone(self__.arr)));
}
}));

(cljs.core.ArrayNode.prototype.inode_without_BANG_ = (function cljs$core$fn_17103(edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return inode;
} else {
var n = node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,edit__$1,idx);
} else {
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
(editable.cnt = (editable.cnt - (1)));

return editable;
}
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);

}
}
}
}));

(cljs.core.ArrayNode.prototype.inode_seq = (function cljs$core$fn_17104(){
var self__ = this;
var inode = this;
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(self__.arr);
}));

(cljs.core.ArrayNode.prototype.kv_reduce = (function cljs$core$fn_17105(f,init){
var self__ = this;
var inode = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var node = (self__.arr[i]);
if((!((node == null)))){
var init__$2 = node.kv_reduce(f,init__$1);
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
var G__17114 = (i + (1));
var G__17115 = init__$2;
i = G__17114;
init__$1 = G__17115;
continue;
}
} else {
var G__17116 = (i + (1));
var G__17117 = init__$1;
i = G__17116;
init__$1 = G__17117;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.ArrayNode.prototype.inode_lookup = (function cljs$core$fn_17106(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
return node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
}));

(cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = (function cljs$core$fn_17107(edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));
(editable.cnt = (editable.cnt + (1)));

return editable;
} else {
var n = node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
}
}
}));

(cljs.core.ArrayNode.prototype.inode_assoc = (function cljs$core$fn_17108(shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return (new cljs.core.ArrayNode(null,(self__.cnt + (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_))));
} else {
var n = node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
}
}));

(cljs.core.ArrayNode.prototype.inode_find = (function cljs$core$fn_17109(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
return node.inode_find((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
}));

(cljs.core.ArrayNode.prototype.inode_without = (function cljs$core$fn_17110(shift,hash,key){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
var n = node.inode_without((shift + (5)),hash,key);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,null,idx);
} else {
return (new cljs.core.ArrayNode(null,(self__.cnt - (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));

}
}
} else {
return inode;
}
}));

(cljs.core.ArrayNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_17111(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeIterator(self__.arr,(0),null));
}));

(cljs.core.ArrayNode.getBasis = (function cljs$core$fn_17112(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayNode.cljs$lang$type = true);

(cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode");

(cljs.core.ArrayNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_17113(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/ArrayNode");
}));

/**
 * Positional factory function for cljs.core/ArrayNode.
 */
cljs.core.__GT_ArrayNode = (function cljs$core$__GT_ArrayNode(edit,cnt,arr){
return (new cljs.core.ArrayNode(edit,cnt,arr));
});

cljs.core.hash_collision_node_find_index = (function cljs$core$hash_collision_node_find_index(arr,cnt,key){
var lim = ((2) * cnt);
var i = (0);
while(true){
if((i < lim)){
if(cljs.core.key_test(key,(arr[i]))){
return i;
} else {
var G__17118 = (i + (2));
i = G__17118;
continue;
}
} else {
return (-1);
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.HashCollisionNode = (function (edit,collision_hash,cnt,arr){
this.edit = edit;
this.collision_hash = collision_hash;
this.cnt = cnt;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.HashCollisionNode.prototype.ensure_editable = (function cljs$core$fn_17119(e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var new_arr = (new Array(((2) * (self__.cnt + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * self__.cnt));

return (new cljs.core.HashCollisionNode(e,self__.collision_hash,self__.cnt,new_arr));
}
}));

(cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = (function cljs$core$fn_17120(edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
(removed_leaf_QMARK_.val = true);

if((self__.cnt === (1))){
return null;
} else {
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(earr[idx] = (earr[(((2) * self__.cnt) - (2))]));

(earr[(idx + (1))] = (earr[(((2) * self__.cnt) - (1))]));

(earr[(((2) * self__.cnt) - (1))] = null);

(earr[(((2) * self__.cnt) - (2))] = null);

(editable.cnt = (editable.cnt - (1)));

return editable;
}
}
}));

(cljs.core.HashCollisionNode.prototype.inode_seq = (function cljs$core$fn_17121(){
var self__ = this;
var inode = this;
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr);
}));

(cljs.core.HashCollisionNode.prototype.kv_reduce = (function cljs$core$fn_17122(f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
}));

(cljs.core.HashCollisionNode.prototype.inode_lookup = (function cljs$core$fn_17123(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (self__.arr[(idx + (1))]);
} else {
return not_found;

}
}
}));

(cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = (function cljs$core$fn_17124(edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
if((self__.arr.length > ((2) * self__.cnt))){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * self__.cnt),key,(((2) * self__.cnt) + (1)),val);
(added_leaf_QMARK_.val = true);

(editable.cnt = (editable.cnt + (1)));

return editable;
} else {
var len = self__.arr.length;
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

(added_leaf_QMARK_.val = true);

return inode.ensure_editable_array(edit__$1,(self__.cnt + (1)),new_arr);
}
} else {
if(((self__.arr[(idx + (1))]) === val)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(idx + (1)),val);
}
}
} else {
return (new cljs.core.BitmapIndexedNode(edit__$1,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode,null,null])).inode_assoc_BANG_(edit__$1,shift,hash,key,val,added_leaf_QMARK_);
}
}));

(cljs.core.HashCollisionNode.prototype.inode_assoc = (function cljs$core$fn_17125(shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
var len = ((2) * self__.cnt);
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

(added_leaf_QMARK_.val = true);

return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt + (1)),new_arr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(idx + (1))]),val)){
return inode;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(idx + (1)),val)));
}
}
} else {
return (new cljs.core.BitmapIndexedNode(null,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode])).inode_assoc(shift,hash,key,val,added_leaf_QMARK_);
}
}));

(cljs.core.HashCollisionNode.prototype.ensure_editable_array = (function cljs$core$fn_17126(e,count,array){
var self__ = this;
var inode = this;
if((e === self__.edit)){
(self__.arr = array);

(self__.cnt = count);

return inode;
} else {
return (new cljs.core.HashCollisionNode(self__.edit,self__.collision_hash,count,array));
}
}));

(cljs.core.HashCollisionNode.prototype.inode_find = (function cljs$core$fn_17127(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (new cljs.core.MapEntry((self__.arr[idx]),(self__.arr[(idx + (1))]),null));
} else {
return not_found;

}
}
}));

(cljs.core.HashCollisionNode.prototype.inode_without = (function cljs$core$fn_17128(shift,hash,key){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
if((self__.cnt === (1))){
return null;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt - (1)),cljs.core.remove_pair(self__.arr,cljs.core.quot(idx,(2)))));

}
}
}));

(cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_17129(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
}));

(cljs.core.HashCollisionNode.getBasis = (function cljs$core$fn_17130(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"collision-hash","collision-hash",-35831342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.HashCollisionNode.cljs$lang$type = true);

(cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode");

(cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_17131(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/HashCollisionNode");
}));

/**
 * Positional factory function for cljs.core/HashCollisionNode.
 */
cljs.core.__GT_HashCollisionNode = (function cljs$core$__GT_HashCollisionNode(edit,collision_hash,cnt,arr){
return (new cljs.core.HashCollisionNode(edit,collision_hash,cnt,arr));
});

cljs.core.create_node = (function cljs$core$create_node(var_args){
var G__17133 = arguments.length;
switch (G__17133) {
case 6:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_17134(shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc(shift,key2hash,key2,val2,added_leaf_QMARK_);
}
}));

(cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = (function cljs$core$fn_17135(edit,shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc_BANG_(edit,shift,key2hash,key2,val2,added_leaf_QMARK_);
}
}));

(cljs.core.create_node.cljs$lang$maxFixedArity = 7);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.NodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.NodeSeq.prototype.toString = (function cljs$core$fn_17137(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.NodeSeq.prototype.equiv = (function cljs$core$fn_17138(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.NodeSeq.prototype.indexOf = (function() {
var cljs$core$fn_17139 = null;
var cljs$core$fn_17139__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_17139__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17139 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17139__1.call(this,x);
case 2:
return cljs$core$fn_17139__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17139.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17139__1;
cljs$core$fn_17139.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17139__2;
return cljs$core$fn_17139;
})()
);

(cljs.core.NodeSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_17140 = null;
var cljs$core$fn_17140__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_17140__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17140 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17140__1.call(this,x);
case 2:
return cljs$core$fn_17140__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17140.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17140__1;
cljs$core$fn_17140.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17140__2;
return cljs$core$fn_17140;
})()
);

(cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17141(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.NodeSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_17142(coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,(self__.i + (2)),null);
} else {
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s));
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17143(coll){
var self__ = this;
var coll__$1 = this;
var h__9988__auto__ = self__.__hash;
if((!((h__9988__auto__ == null)))){
return h__9988__auto__;
} else {
var h__9988__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9988__auto____$1);

return h__9988__auto____$1;
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17144(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17145(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17146(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17147(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_17148(coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return (new cljs.core.MapEntry((self__.nodes[self__.i]),(self__.nodes[(self__.i + (1))]),null));
} else {
return cljs.core.first(self__.s);
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_17149(coll){
var self__ = this;
var coll__$1 = this;
var ret = (((self__.s == null))?cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,(self__.i + (2)),null):cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s)));
if((!((ret == null)))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17150(this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17151(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.NodeSeq(new_meta,self__.nodes,self__.i,self__.s,self__.__hash));
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17152(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.NodeSeq.getBasis = (function cljs$core$fn_17153(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"nodes","nodes",-459054278,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.NodeSeq.cljs$lang$type = true);

(cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq");

(cljs.core.NodeSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_17154(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/NodeSeq");
}));

/**
 * Positional factory function for cljs.core/NodeSeq.
 */
cljs.core.__GT_NodeSeq = (function cljs$core$__GT_NodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.NodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17155(){
var this__10717__auto__ = this;
return cljs.core.es6_iterator(this__10717__auto__);
}));
cljs.core.create_inode_seq = (function cljs$core$create_inode_seq(var_args){
var G__17157 = arguments.length;
switch (G__17157) {
case 1:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17158(nodes){
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
}));

(cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_17159(nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
if((!(((nodes[j]) == null)))){
return (new cljs.core.NodeSeq(null,nodes,j,null,null));
} else {
var temp__5718__auto__ = (nodes[(j + (1))]);
if(cljs.core.truth_(temp__5718__auto__)){
var node = temp__5718__auto__;
var temp__5718__auto____$1 = node.inode_seq();
if(cljs.core.truth_(temp__5718__auto____$1)){
var node_seq = temp__5718__auto____$1;
return (new cljs.core.NodeSeq(null,nodes,(j + (2)),node_seq,null));
} else {
var G__17161 = (j + (2));
j = G__17161;
continue;
}
} else {
var G__17162 = (j + (2));
j = G__17162;
continue;
}
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.NodeSeq(null,nodes,i,s,null));
}
}));

(cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayNodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ArrayNodeSeq.prototype.toString = (function cljs$core$fn_17163(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ArrayNodeSeq.prototype.equiv = (function cljs$core$fn_17164(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ArrayNodeSeq.prototype.indexOf = (function() {
var cljs$core$fn_17165 = null;
var cljs$core$fn_17165__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_17165__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17165 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17165__1.call(this,x);
case 2:
return cljs$core$fn_17165__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17165.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17165__1;
cljs$core$fn_17165.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17165__2;
return cljs$core$fn_17165;
})()
);

(cljs.core.ArrayNodeSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_17166 = null;
var cljs$core$fn_17166__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_17166__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17166 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17166__1.call(this,x);
case 2:
return cljs$core$fn_17166__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17166.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17166__1;
cljs$core$fn_17166.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17166__2;
return cljs$core$fn_17166;
})()
);

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17167(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_17168(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s));
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17169(coll){
var self__ = this;
var coll__$1 = this;
var h__9988__auto__ = self__.__hash;
if((!((h__9988__auto__ == null)))){
return h__9988__auto__;
} else {
var h__9988__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9988__auto____$1);

return h__9988__auto____$1;
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17170(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17171(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17172(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17173(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_17174(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.s);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_17175(coll){
var self__ = this;
var coll__$1 = this;
var ret = cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s));
if((!((ret == null)))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17176(this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17177(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ArrayNodeSeq(new_meta,self__.nodes,self__.i,self__.s,self__.__hash));
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17178(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.ArrayNodeSeq.getBasis = (function cljs$core$fn_17179(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"nodes","nodes",-459054278,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayNodeSeq.cljs$lang$type = true);

(cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq");

(cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_17180(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/ArrayNodeSeq");
}));

/**
 * Positional factory function for cljs.core/ArrayNodeSeq.
 */
cljs.core.__GT_ArrayNodeSeq = (function cljs$core$__GT_ArrayNodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17181(){
var this__10717__auto__ = this;
return cljs.core.es6_iterator(this__10717__auto__);
}));
cljs.core.create_array_node_seq = (function cljs$core$create_array_node_seq(var_args){
var G__17183 = arguments.length;
switch (G__17183) {
case 1:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17184(nodes){
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
}));

(cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_17185(nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
var temp__5718__auto__ = (nodes[j]);
if(cljs.core.truth_(temp__5718__auto__)){
var nj = temp__5718__auto__;
var temp__5718__auto____$1 = nj.inode_seq();
if(cljs.core.truth_(temp__5718__auto____$1)){
var ns = temp__5718__auto____$1;
return (new cljs.core.ArrayNodeSeq(null,nodes,(j + (1)),ns,null));
} else {
var G__17187 = (j + (1));
j = G__17187;
continue;
}
} else {
var G__17188 = (j + (1));
j = G__17188;
continue;
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.ArrayNodeSeq(null,nodes,i,s,null));
}
}));

(cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 3);


/**
* @constructor
*/
cljs.core.HashMapIter = (function (nil_val,root_iter,seen){
this.nil_val = nil_val;
this.root_iter = root_iter;
this.seen = seen;
});
(cljs.core.HashMapIter.prototype.hasNext = (function cljs$core$fn_17189(){
var self__ = this;
var _ = this;
return (((!(self__.seen))) || (self__.root_iter.hasNext()));
}));

(cljs.core.HashMapIter.prototype.next = (function cljs$core$fn_17190(){
var self__ = this;
var _ = this;
if((!(self__.seen))){
(self__.seen = true);

return (new cljs.core.MapEntry(null,self__.nil_val,null));
} else {
return self__.root_iter.next();
}
}));

(cljs.core.HashMapIter.prototype.remove = (function cljs$core$fn_17191(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.HashMapIter.getBasis = (function cljs$core$fn_17192(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),new cljs.core.Symbol(null,"root-iter","root-iter",1974672108,null),cljs.core.with_meta(new cljs.core.Symbol(null,"seen","seen",1121531738,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.HashMapIter.cljs$lang$type = true);

(cljs.core.HashMapIter.cljs$lang$ctorStr = "cljs.core/HashMapIter");

(cljs.core.HashMapIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_17193(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/HashMapIter");
}));

/**
 * Positional factory function for cljs.core/HashMapIter.
 */
cljs.core.__GT_HashMapIter = (function cljs$core$__GT_HashMapIter(nil_val,root_iter,seen){
return (new cljs.core.HashMapIter(nil_val,root_iter,seen));
});


/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentHashMap = (function (meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
this.meta = meta;
this.cnt = cnt;
this.root = root;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 139268;
});
(cljs.core.PersistentHashMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentHashMap.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_17195(coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.MapEntry(null,self__.nil_val,null));
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_find((0),cljs.core.hash(k),k,null);

}
}
}));

(cljs.core.PersistentHashMap.prototype.toString = (function cljs$core$fn_17196(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentHashMap.prototype.equiv = (function cljs$core$fn_17197(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentHashMap.prototype.keys = (function cljs$core$fn_17198(){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.keys(coll));
}));

(cljs.core.PersistentHashMap.prototype.entries = (function cljs$core$fn_17199(){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentHashMap.prototype.values = (function cljs$core$fn_17200(){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.vals(coll));
}));

(cljs.core.PersistentHashMap.prototype.has = (function cljs$core$fn_17201(k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
}));

(cljs.core.PersistentHashMap.prototype.get = (function cljs$core$fn_17202(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentHashMap.prototype.forEach = (function cljs$core$fn_17203(f){
var self__ = this;
var coll = this;
var seq__17204 = cljs.core.seq(coll);
var chunk__17205 = null;
var count__17206 = (0);
var i__17207 = (0);
while(true){
if((i__17207 < count__17206)){
var vec__17214 = chunk__17205.cljs$core$IIndexed$_nth$arity$2(null,i__17207);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17214,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17214,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__17246 = seq__17204;
var G__17247 = chunk__17205;
var G__17248 = count__17206;
var G__17249 = (i__17207 + (1));
seq__17204 = G__17246;
chunk__17205 = G__17247;
count__17206 = G__17248;
i__17207 = G__17249;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__17204);
if(temp__5720__auto__){
var seq__17204__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__17204__$1)){
var c__10499__auto__ = cljs.core.chunk_first(seq__17204__$1);
var G__17250 = cljs.core.chunk_rest(seq__17204__$1);
var G__17251 = c__10499__auto__;
var G__17252 = cljs.core.count(c__10499__auto__);
var G__17253 = (0);
seq__17204 = G__17250;
chunk__17205 = G__17251;
count__17206 = G__17252;
i__17207 = G__17253;
continue;
} else {
var vec__17217 = cljs.core.first(seq__17204__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17217,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17217,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__17254 = cljs.core.next(seq__17204__$1);
var G__17255 = null;
var G__17256 = (0);
var G__17257 = (0);
seq__17204 = G__17254;
chunk__17205 = G__17255;
count__17206 = G__17256;
i__17207 = G__17257;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_17220(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_17221(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function cljs$core$fn_17222(coll,f,init){
var self__ = this;
var coll__$1 = this;
var init__$1 = ((self__.has_nil_QMARK_)?(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(init,null,self__.nil_val) : f.call(null,init,null,self__.nil_val)):init);
if(cljs.core.reduced_QMARK_(init__$1)){
return cljs.core.deref(init__$1);
} else {
if((!((self__.root == null)))){
return cljs.core.unreduced(self__.root.kv_reduce(f,init__$1));
} else {
return init__$1;

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_17223(coll){
var self__ = this;
var coll__$1 = this;
var root_iter = ((self__.root)?cljs.core._iterator(self__.root):cljs.core.nil_iter());
if(self__.has_nil_QMARK_){
return (new cljs.core.HashMapIter(self__.nil_val,root_iter,false));
} else {
return root_iter;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17224(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_17225(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashMap(self__.meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17226(coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17227(coll){
var self__ = this;
var coll__$1 = this;
var h__9988__auto__ = self__.__hash;
if((!((h__9988__auto__ == null)))){
return h__9988__auto__;
} else {
var h__9988__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__9988__auto____$1);

return h__9988__auto____$1;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17228(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function cljs$core$fn_17229(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashMap(({}),self__.root,self__.cnt,self__.has_nil_QMARK_,self__.nil_val));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17232(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY,self__.meta);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function cljs$core$fn_17233(coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),self__.root,false,null,null));
} else {
return coll__$1;
}
} else {
if((self__.root == null)){
return coll__$1;
} else {
var new_root = self__.root.inode_without((0),cljs.core.hash(k),k);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_17234(coll,k,v){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(((self__.has_nil_QMARK_) && ((v === self__.nil_val)))){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((self__.has_nil_QMARK_)?self__.cnt:(self__.cnt + (1))),self__.root,true,v,null));
}
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var new_root = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc((0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((added_leaf_QMARK_.val)?(self__.cnt + (1)):self__.cnt),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_17235(coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
return self__.has_nil_QMARK_;
} else {
if((self__.root == null)){
return false;
} else {
return (!((self__.root.inode_lookup((0),cljs.core.hash(k),k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)));

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17236(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var s = (((!((self__.root == null))))?self__.root.inode_seq():null);
if(self__.has_nil_QMARK_){
return cljs.core.cons((new cljs.core.MapEntry(null,self__.nil_val,null)),s);
} else {
return s;
}
} else {
return null;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17237(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(new_meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17238(coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__17258 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__17259 = cljs.core.next(es);
ret = G__17258;
es = G__17259;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
}));

(cljs.core.PersistentHashMap.prototype.call = (function() {
var cljs$core$fn_17239 = null;
var cljs$core$fn_17239__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var cljs$core$fn_17239__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
cljs$core$fn_17239 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_17239__2.call(this,self__,k);
case 3:
return cljs$core$fn_17239__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_17239.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17239__2;
cljs$core$fn_17239.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_17239__3;
return cljs$core$fn_17239;
})()
);

(cljs.core.PersistentHashMap.prototype.apply = (function cljs$core$fn_17240(self__,args17194){
var self__ = this;
var self____$1 = this;
var args__10130__auto__ = cljs.core.aclone(args17194);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10130__auto__.length > (20)))?(function (){var G__17241 = args__10130__auto__.slice((0),(20));
G__17241.push(args__10130__auto__.slice((20)));

return G__17241;
})():args__10130__auto__)));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17242(k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_17243(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentHashMap.getBasis = (function cljs$core$fn_17244(){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"root","root",1191874074,null),cljs.core.with_meta(new cljs.core.Symbol(null,"has-nil?","has-nil?",825886722,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)], null)),new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentHashMap.cljs$lang$type = true);

(cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap");

(cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = (function cljs$core$fn_17245(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/PersistentHashMap");
}));

/**
 * Positional factory function for cljs.core/PersistentHashMap.
 */
cljs.core.__GT_PersistentHashMap = (function cljs$core$__GT_PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
return (new cljs.core.PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash));
});

(cljs.core.PersistentHashMap.EMPTY = (new cljs.core.PersistentHashMap(null,(0),null,false,null,cljs.core.empty_unordered_hash)));
(cljs.core.PersistentHashMap.fromArray = (function cljs$core$fn_17260(arr,no_clone){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__17261 = (i + (2));
var G__17262 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__17261;
ret = G__17262;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
}));
(cljs.core.PersistentHashMap.fromArrays = (function cljs$core$fn_17263(ks,vs){
var len = ks.length;
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
if((vs.length <= i)){
throw (new Error(["No value supplied for key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((ks[i]))].join('')));
} else {
var G__17264 = (i + (1));
var G__17265 = cljs.core._assoc_BANG_(out,(ks[i]),(vs[i]));
i = G__17264;
out = G__17265;
continue;
}
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}));
(cljs.core.PersistentHashMap.createWithCheck = (function cljs$core$fn_17266(arr){
var len = arr.length;
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i_17267 = (0);
while(true){
if((i_17267 < len)){
cljs.core._assoc_BANG_(ret,(arr[i_17267]),(arr[(i_17267 + (1))]));

if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core._count(ret),((i_17267 / (2)) + (1)))){
throw (new Error(["Duplicate key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arr[i_17267]))].join('')));
} else {
var G__17268 = (i_17267 + (2));
i_17267 = G__17268;
continue;
}
} else {
}
break;
}

return cljs.core._persistent_BANG_(ret);
}));
(cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17269(){
var this__10717__auto__ = this;
return cljs.core.es6_iterator(this__10717__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientHashMap = (function (edit,root,count,has_nil_QMARK_,nil_val){
this.edit = edit;
this.root = root;
this.count = count;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 56;
});
(cljs.core.TransientHashMap.prototype.conj_BANG_ = (function cljs$core$fn_17271(o){
var self__ = this;
var tcoll = this;
if(self__.edit){
if(cljs.core.map_entry_QMARK_(o)){
return tcoll.assoc_BANG_(cljs.core.key(o),cljs.core.val(o));
} else {
if(cljs.core.vector_QMARK_(o)){
return tcoll.assoc_BANG_((o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((0)) : o.call(null,(0))),(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((1)) : o.call(null,(1))));
} else {
var es = cljs.core.seq(o);
var tcoll__$1 = tcoll;
while(true){
var temp__5718__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__5718__auto__)){
var e = temp__5718__auto__;
var G__17289 = cljs.core.next(es);
var G__17290 = tcoll__$1.assoc_BANG_(cljs.core.key(e),cljs.core.val(e));
es = G__17289;
tcoll__$1 = G__17290;
continue;
} else {
return tcoll__$1;
}
break;
}

}
}
} else {
throw (new Error("conj! after persistent"));
}
}));

(cljs.core.TransientHashMap.prototype.assoc_BANG_ = (function cljs$core$fn_17272(k,v){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if((self__.nil_val === v)){
} else {
(self__.nil_val = v);
}

if(self__.has_nil_QMARK_){
} else {
(self__.count = (self__.count + (1)));

(self__.has_nil_QMARK_ = true);
}

return tcoll;
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var node = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc_BANG_(self__.edit,(0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((node === self__.root)){
} else {
(self__.root = node);
}

if(added_leaf_QMARK_.val){
(self__.count = (self__.count + (1)));
} else {
}

return tcoll;
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.without_BANG_ = (function cljs$core$fn_17273(k){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if(self__.has_nil_QMARK_){
(self__.has_nil_QMARK_ = false);

(self__.nil_val = null);

(self__.count = (self__.count - (1)));

return tcoll;
} else {
return tcoll;
}
} else {
if((self__.root == null)){
return tcoll;
} else {
var removed_leaf_QMARK_ = (new cljs.core.Box(false));
var node = self__.root.inode_without_BANG_(self__.edit,(0),cljs.core.hash(k),k,removed_leaf_QMARK_);
if((node === self__.root)){
} else {
(self__.root = node);
}

if(removed_leaf_QMARK_.val){
(self__.count = (self__.count - (1)));
} else {
}

return tcoll;
}
}
} else {
throw (new Error("dissoc! after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.persistent_BANG_ = (function cljs$core$fn_17274(){
var self__ = this;
var tcoll = this;
if(self__.edit){
(self__.edit = null);

return (new cljs.core.PersistentHashMap(null,self__.count,self__.root,self__.has_nil_QMARK_,self__.nil_val,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17275(coll){
var self__ = this;
var coll__$1 = this;
if(self__.edit){
return self__.count;
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_17276(tcoll,k){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k);
}
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_17277(tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);
}
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function cljs$core$fn_17278(tcoll,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.conj_BANG_(val);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function cljs$core$fn_17279(tcoll){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.persistent_BANG_();
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function cljs$core$fn_17280(tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.assoc_BANG_(key,val);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function cljs$core$fn_17281(tcoll,key){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.without_BANG_(key);
}));

(cljs.core.TransientHashMap.prototype.call = (function() {
var cljs$core$fn_17282 = null;
var cljs$core$fn_17282__2 = (function (self__,key){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$2(null,key);
});
var cljs$core$fn_17282__3 = (function (self__,key,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
});
cljs$core$fn_17282 = function(self__,key,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_17282__2.call(this,self__,key);
case 3:
return cljs$core$fn_17282__3.call(this,self__,key,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_17282.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17282__2;
cljs$core$fn_17282.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_17282__3;
return cljs$core$fn_17282;
})()
);

(cljs.core.TransientHashMap.prototype.apply = (function cljs$core$fn_17283(self__,args17270){
var self__ = this;
var self____$1 = this;
var args__10130__auto__ = cljs.core.aclone(args17270);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10130__auto__.length > (20)))?(function (){var G__17284 = args__10130__auto__.slice((0),(20));
G__17284.push(args__10130__auto__.slice((20)));

return G__17284;
})():args__10130__auto__)));
}));

(cljs.core.TransientHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17285(key){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$2(null,key);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_17286(key,not_found){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
}));

(cljs.core.TransientHashMap.getBasis = (function cljs$core$fn_17287(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"has-nil?","has-nil?",825886722,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.TransientHashMap.cljs$lang$type = true);

(cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap");

(cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = (function cljs$core$fn_17288(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/TransientHashMap");
}));

/**
 * Positional factory function for cljs.core/TransientHashMap.
 */
cljs.core.__GT_TransientHashMap = (function cljs$core$__GT_TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val){
return (new cljs.core.TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val));
});

cljs.core.tree_map_seq_push = (function cljs$core$tree_map_seq_push(node,stack,ascending_QMARK_){
var t = node;
var stack__$1 = stack;
while(true){
if((!((t == null)))){
var G__17291 = ((ascending_QMARK_)?t.left:t.right);
var G__17292 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1,t);
t = G__17291;
stack__$1 = G__17292;
continue;
} else {
return stack__$1;
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentTreeMapSeq = (function (meta,stack,ascending_QMARK_,cnt,__hash){
this.meta = meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.PersistentTreeMapSeq.prototype.toString = (function cljs$core$fn_17293(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentTreeMapSeq.prototype.equiv = (function cljs$core$fn_17294(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentTreeMapSeq.prototype.indexOf = (function() {
var cljs$core$fn_17295 = null;
var cljs$core$fn_17295__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_17295__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17295 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17295__1.call(this,x);
case 2:
return cljs$core$fn_17295__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17295.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17295__1;
cljs$core$fn_17295.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17295__2;
return cljs$core$fn_17295;
})()
);

(cljs.core.PersistentTreeMapSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_17296 = null;
var cljs$core$fn_17296__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_17296__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17296 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17296__1.call(this,x);
case 2:
return cljs$core$fn_17296__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17296.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17296__1;
cljs$core$fn_17296.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17296__2;
return cljs$core$fn_17296;
})()
);

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17297(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_17298(this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if((next_stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17299(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt < (0))){
return (cljs.core.count(cljs.core.next(coll__$1)) + (1));
} else {
return self__.cnt;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17300(coll){
var self__ = this;
var coll__$1 = this;
var h__9988__auto__ = self__.__hash;
if((!((h__9988__auto__ == null)))){
return h__9988__auto__;
} else {
var h__9988__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9988__auto____$1);

return h__9988__auto____$1;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17301(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17302(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17303(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17304(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_17305(this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.peek(self__.stack);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_17306(this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if((!((next_stack == null)))){
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17307(this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17308(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMapSeq(new_meta,self__.stack,self__.ascending_QMARK_,self__.cnt,self__.__hash));
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17309(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.getBasis = (function cljs$core$fn_17310(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"stack","stack",847125597,null),cljs.core.with_meta(new cljs.core.Symbol(null,"ascending?","ascending?",-1938452653,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)], null)),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentTreeMapSeq.cljs$lang$type = true);

(cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq");

(cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_17311(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/PersistentTreeMapSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentTreeMapSeq.
 */
cljs.core.__GT_PersistentTreeMapSeq = (function cljs$core$__GT_PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash){
return (new cljs.core.PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash));
});

(cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17312(){
var this__10717__auto__ = this;
return cljs.core.es6_iterator(this__10717__auto__);
}));
cljs.core.create_tree_map_seq = (function cljs$core$create_tree_map_seq(tree,ascending_QMARK_,cnt){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.tree_map_seq_push(tree,null,ascending_QMARK_),ascending_QMARK_,cnt,null));
});

cljs.core.balance_left = (function cljs$core$balance_left(key,val,ins,right){
if((ins instanceof cljs.core.RedNode)){
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,ins.left.blacken(),(new cljs.core.BlackNode(key,val,ins.right,right,null)),null));
} else {
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.right.key,ins.right.val,(new cljs.core.BlackNode(ins.key,ins.val,ins.left,ins.right.left,null)),(new cljs.core.BlackNode(key,val,ins.right.right,right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));
}
});
cljs.core.balance_right = (function cljs$core$balance_right(key,val,left,ins){
if((ins instanceof cljs.core.RedNode)){
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,(new cljs.core.BlackNode(key,val,left,ins.left,null)),ins.right.blacken(),null));
} else {
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.left.key,ins.left.val,(new cljs.core.BlackNode(key,val,left,ins.left.left,null)),(new cljs.core.BlackNode(ins.key,ins.val,ins.left.right,ins.right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));
}
});
cljs.core.balance_left_del = (function cljs$core$balance_left_del(key,val,del,right){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,del.blacken(),right,null));
} else {
if((right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right(key,val,del,right.redden());
} else {
if((((right instanceof cljs.core.RedNode)) && ((right.left instanceof cljs.core.BlackNode)))){
return (new cljs.core.RedNode(right.left.key,right.left.val,(new cljs.core.BlackNode(key,val,del,right.left.left,null)),cljs.core.balance_right(right.key,right.val,right.left.right,right.right.redden()),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.balance_right_del = (function cljs$core$balance_right_del(key,val,left,del){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,left,del.blacken(),null));
} else {
if((left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left(key,val,left.redden(),del);
} else {
if((((left instanceof cljs.core.RedNode)) && ((left.right instanceof cljs.core.BlackNode)))){
return (new cljs.core.RedNode(left.right.key,left.right.val,cljs.core.balance_left(left.key,left.val,left.left.redden(),left.right.left),(new cljs.core.BlackNode(key,val,left.right.right,del,null)),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.tree_map_kv_reduce = (function cljs$core$tree_map_kv_reduce(node,f,init){
var init__$1 = (((!((node.left == null))))?(function (){var G__17313 = node.left;
var G__17314 = f;
var G__17315 = init;
return (cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__17313,G__17314,G__17315) : cljs.core.tree_map_kv_reduce.call(null,G__17313,G__17314,G__17315));
})():init);
if(cljs.core.reduced_QMARK_(init__$1)){
return init__$1;
} else {
var init__$2 = (function (){var G__17316 = init__$1;
var G__17317 = node.key;
var G__17318 = node.val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17316,G__17317,G__17318) : f.call(null,G__17316,G__17317,G__17318));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
if((!((node.right == null)))){
var G__17319 = node.right;
var G__17320 = f;
var G__17321 = init__$2;
return (cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__17319,G__17320,G__17321) : cljs.core.tree_map_kv_reduce.call(null,G__17319,G__17320,G__17321));
} else {
return init__$2;
}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.BlackNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.BlackNode.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.BlackNode.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_17323(node,k){
var self__ = this;
var node__$1 = this;
var G__17324 = k;
switch (G__17324) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.BlackNode.prototype.lastIndexOf = (function() {
var cljs$core$fn_17325 = null;
var cljs$core$fn_17325__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_17325__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17325 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17325__1.call(this,x);
case 2:
return cljs$core$fn_17325__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17325.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17325__1;
cljs$core$fn_17325.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17325__2;
return cljs$core$fn_17325;
})()
);

(cljs.core.BlackNode.prototype.indexOf = (function() {
var cljs$core$fn_17326 = null;
var cljs$core$fn_17326__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_17326__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17326 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17326__1.call(this,x);
case 2:
return cljs$core$fn_17326__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17326.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17326__1;
cljs$core$fn_17326.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17326__2;
return cljs$core$fn_17326;
})()
);

(cljs.core.BlackNode.prototype.add_right = (function cljs$core$fn_17327(ins){
var self__ = this;
var node = this;
return ins.balance_right(node);
}));

(cljs.core.BlackNode.prototype.redden = (function cljs$core$fn_17328(){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,self__.right,null));
}));

(cljs.core.BlackNode.prototype.blacken = (function cljs$core$fn_17329(){
var self__ = this;
var node = this;
return node;
}));

(cljs.core.BlackNode.prototype.add_left = (function cljs$core$fn_17330(ins){
var self__ = this;
var node = this;
return ins.balance_left(node);
}));

(cljs.core.BlackNode.prototype.replace = (function cljs$core$fn_17331(key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(key__$1,val__$1,left__$1,right__$1,null));
}));

(cljs.core.BlackNode.prototype.balance_left = (function cljs$core$fn_17332(parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));
}));

(cljs.core.BlackNode.prototype.balance_right = (function cljs$core$fn_17333(parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));
}));

(cljs.core.BlackNode.prototype.remove_left = (function cljs$core$fn_17334(del){
var self__ = this;
var node = this;
return cljs.core.balance_left_del(self__.key,self__.val,del,self__.right);
}));

(cljs.core.BlackNode.prototype.kv_reduce = (function cljs$core$fn_17335(f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
}));

(cljs.core.BlackNode.prototype.remove_right = (function cljs$core$fn_17336(del){
var self__ = this;
var node = this;
return cljs.core.balance_right_del(self__.key,self__.val,self__.left,del);
}));

(cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_17337(node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
}));

(cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_17338(node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_17339(node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_17340(node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function cljs$core$fn_17341(node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
}));

(cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17342(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17343(node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function cljs$core$fn_17344(node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function cljs$core$fn_17345(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_17346(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_17347(node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.BlackNode.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_17348(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17349(coll){
var self__ = this;
var coll__$1 = this;
var h__9988__auto__ = self__.__hash;
if((!((h__9988__auto__ == null)))){
return h__9988__auto__;
} else {
var h__9988__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9988__auto____$1);

return h__9988__auto____$1;
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17350(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17351(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17352(node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
}));

(cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17353(node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
}));

(cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_17354(node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.BlackNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_17355(node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17356(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17357(node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core._with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17358(node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.BlackNode.prototype.call = (function() {
var cljs$core$fn_17359 = null;
var cljs$core$fn_17359__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var cljs$core$fn_17359__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
cljs$core$fn_17359 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_17359__2.call(this,self__,k);
case 3:
return cljs$core$fn_17359__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_17359.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17359__2;
cljs$core$fn_17359.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_17359__3;
return cljs$core$fn_17359;
})()
);

(cljs.core.BlackNode.prototype.apply = (function cljs$core$fn_17360(self__,args17322){
var self__ = this;
var self____$1 = this;
var args__10130__auto__ = cljs.core.aclone(args17322);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10130__auto__.length > (20)))?(function (){var G__17361 = args__10130__auto__.slice((0),(20));
G__17361.push(args__10130__auto__.slice((20)));

return G__17361;
})():args__10130__auto__)));
}));

(cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17362(k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_17363(k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.BlackNode.getBasis = (function cljs$core$fn_17364(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"left","left",1241415590,null),new cljs.core.Symbol(null,"right","right",1187949694,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.BlackNode.cljs$lang$type = true);

(cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode");

(cljs.core.BlackNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_17365(this__10204__auto__,writer__10205__auto__,opt__10206__auto__){
return cljs.core._write(writer__10205__auto__,"cljs.core/BlackNode");
}));

/**
 * Positional factory function for cljs.core/BlackNode.
 */
cljs.core.__GT_BlackNode = (function cljs$core$__GT_BlackNode(key,val,left,right,__hash){
return (new cljs.core.BlackNode(key,val,left,right,__hash));
});

(cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17367(){
var this__10717__auto__ = this;
return cljs.core.es6_iterator(this__10717__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RedNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.RedNode.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.RedNode.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_17369(node,k){
var self__ = this;
var node__$1 = this;
var G__17370 = k;
switch (G__17370) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.RedNode.prototype.lastIndexOf = (function() {
var cljs$core$fn_17371 = null;
var cljs$core$fn_17371__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_17371__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17371 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17371__1.call(this,x);
case 2:
return cljs$core$fn_17371__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17371.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17371__1;
cljs$core$fn_17371.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17371__2;
return cljs$core$fn_17371;
})()
);

(cljs.core.RedNode.prototype.indexOf = (function() {
var cljs$core$fn_17372 = null;
var cljs$core$fn_17372__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_17372__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17372 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17372__1.call(this,x);
case 2:
return cljs$core$fn_17372__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17372.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17372__1;
cljs$core$fn_17372.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17372__2;
return cljs$core$fn_17372;
})()
);

(cljs.core.RedNode.prototype.add_right = (function cljs$core$fn_17373(ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,ins,null));
}));

(cljs.core.RedNode.prototype.redden = (function cljs$core$fn_17374(){
var self__ = this;
var node = this;
throw (new Error("red-black tree invariant violation"));
}));

(cljs.core.RedNode.prototype.blacken = (function cljs$core$fn_17375(){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right,null));
}));

(cljs.core.RedNode.prototype.add_left = (function cljs$core$fn_17376(ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,ins,self__.right,null));
}));

(cljs.core.RedNode.prototype.replace = (function cljs$core$fn_17377(key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(key__$1,val__$1,left__$1,right__$1,null));
}));

(cljs.core.RedNode.prototype.balance_left = (function cljs$core$fn_17378(parent){
var self__ = this;
var node = this;
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,self__.left.blacken(),(new cljs.core.BlackNode(parent.key,parent.val,self__.right,parent.right,null)),null));
} else {
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.right.key,self__.right.val,(new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right.left,null)),(new cljs.core.BlackNode(parent.key,parent.val,self__.right.right,parent.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));

}
}
}));

(cljs.core.RedNode.prototype.balance_right = (function cljs$core$fn_17379(parent){
var self__ = this;
var node = this;
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left,null)),self__.right.blacken(),null));
} else {
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.left.key,self__.left.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left.left,null)),(new cljs.core.BlackNode(self__.key,self__.val,self__.left.right,self__.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));

}
}
}));

(cljs.core.RedNode.prototype.remove_left = (function cljs$core$fn_17380(del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,del,self__.right,null));
}));

(cljs.core.RedNode.prototype.kv_reduce = (function cljs$core$fn_17381(f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
}));

(cljs.core.RedNode.prototype.remove_right = (function cljs$core$fn_17382(del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,del,null));
}));

(cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_17383(node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
}));

(cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_17384(node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_17385(node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_17386(node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function cljs$core$fn_17387(node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
}));

(cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17388(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17389(node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function cljs$core$fn_17390(node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function cljs$core$fn_17391(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_17392(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_17393(node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.RedNode.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_17394(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17395(coll){
var self__ = this;
var coll__$1 = this;
var h__9988__auto__ = self__.__hash;
if((!((h__9988__auto__ == null)))){
return h__9988__auto__;
} else {
var h__9988__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9988__auto____$1);

return h__9988__auto____$1;
}
}));

(cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17396(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17397(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17398(node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
}));

(cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17399(node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
}));

(cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_17400(node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.RedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_17401(node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17402(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17403(node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core._with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17404(node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.RedNode.prototype.call = (function() {
var cljs$core$fn_17405 = null;
var cljs$core$fn_17405__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var cljs$core$fn_17405__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
cljs$core$fn_17405 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_17405__2.call(this,self__,k);
case 3:
return cljs$core$fn_17405__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_17405.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17405__2;
cljs$core$fn_17405.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_17405__3;
return cljs$core$fn_17405;
})()
);

(cljs.core.RedNode.prototype.apply = (function cljs$core$fn_17406(self__,args17368){
var self__ = this;
var self____$1 = this;
var args__10130__auto__ = cljs.core.aclone(args17368);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10130__auto__.length > (20)))?(function (){var G__17407 = args__10130__auto__.slice((0),(20));
G__17407.push(args__10130__auto__.slice((20)));

return G__17407;
})():args__10130__auto__)));
}));

(cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17408(k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_17409(k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.RedNode.getBasis = (function cljs$core$fn_17410(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"left","left",1241415590,null),new cljs.core.Symbol(null,"right