// Compiled by ClojureScript 1.11.132 {:static-fns true, :optimizations :none}
goog.provide('cljs.core');
goog.require('goog.math.Integer');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.string.StringBuffer');
goog.require('goog.math.Long');
goog.scope(function(){
cljs.core.goog$module$goog$math$Long = goog.module.get('goog.math.Long');
});
goog.require('goog.object');
goog.scope(function(){
cljs.core.goog$module$goog$object = goog.module.get('goog.object');
});
goog.require('goog.array');
goog.scope(function(){
cljs.core.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core._STAR_clojurescript_version_STAR_ = "1.11.132";
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_unchecked_arrays_STAR_ = false;
cljs.core._STAR_warn_on_infer_STAR_ = false;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.PROTOCOL_SENTINEL !== 'undefined')){
} else {
cljs.core.PROTOCOL_SENTINEL = ({});
}
cljs.core.MODULE_URIS = null;
cljs.core.MODULE_INFOS = null;

/**
 * Var bound to the name value of the compiler build :target option.
 *   For example, if the compiler build :target is :nodejs, *target* will be bound
 *   to "nodejs". *target* is a Google Closure define and can be set by compiler
 *   :closure-defines option.
 * @define {string}
 */
cljs.core._STAR_target_STAR_ = goog.define("cljs.core._STAR_target_STAR_","default");

/**
 * Manually set the JavaScript global context. Only "window", "self"
 *   , and "global" supported. 
 * @define {string}
 */
cljs.core._STAR_global_STAR_ = goog.define("cljs.core._STAR_global_STAR_","default");
/**
 * Var bound to the current namespace. Only used for bootstrapping.
 * @type {*}
 */
cljs.core._STAR_ns_STAR_ = null;
/**
 * @type {*}
 */
cljs.core._STAR_out_STAR_ = null;
cljs.core._STAR_assert_STAR_ = true;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_print_fn_STAR_ !== 'undefined')){
} else {
/**
 * Each runtime environment provides a different way to print output.
 *   Whatever function *print-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_fn_STAR_ = null;
}
/**
 * Arranges to have tap functions executed via the supplied f, a
 *   function of no arguments. Returns true if successful, false otherwise.
 */
cljs.core._STAR_exec_tap_fn_STAR_ = (function cljs$core$_STAR_exec_tap_fn_STAR_(f){
return (((typeof setTimeout !== 'undefined')) && (cljs.core.boolean$(setTimeout(f,(0)))));
});
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_print_err_fn_STAR_ !== 'undefined')){
} else {
/**
 * Each runtime environment provides a different way to print error output.
 *   Whatever function *print-err-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_err_fn_STAR_ = null;
}
/**
 * Set *print-fn* to f.
 */
cljs.core.set_print_fn_BANG_ = (function cljs$core$set_print_fn_BANG_(f){
return (cljs.core._STAR_print_fn_STAR_ = f);
});
/**
 * Set *print-err-fn* to f.
 */
cljs.core.set_print_err_fn_BANG_ = (function cljs$core$set_print_err_fn_BANG_(f){
return (cljs.core._STAR_print_err_fn_STAR_ = f);
});
/**
 * When set to true, output will be flushed whenever a newline is printed.
 * 
 *   Defaults to true.
 */
cljs.core._STAR_flush_on_newline_STAR_ = true;
/**
 * When set to logical false will drop newlines from printing calls.
 *   This is to work around the implicit newlines emitted by standard JavaScript
 *   console objects.
 */
cljs.core._STAR_print_newline_STAR_ = true;
/**
 * When set to logical false, strings and characters will be printed with
 *   non-alphanumeric characters converted to the appropriate escape sequences.
 * 
 *   Defaults to true
 */
cljs.core._STAR_print_readably_STAR_ = true;
/**
 * If set to logical true, when printing an object, its metadata will also
 *   be printed in a form that can be read back by the reader.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_meta_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 *   their type when read in later.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_dup_STAR_ = false;
/**
 * *print-namespace-maps* controls whether the printer will print
 *   namespace map literal syntax.
 * 
 *   Defaults to false, but the REPL binds it to true.
 */
cljs.core._STAR_print_namespace_maps_STAR_ = false;
/**
 * *print-length* controls how many items of each collection the
 *   printer will print. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   number of items of each collection to print. If a collection contains
 *   more items, the printer will print items up to the limit followed by
 *   '...' to represent the remaining items. The root binding is nil
 *   indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_length_STAR_ = null;
/**
 * *print-level* controls how many levels deep the printer will
 *   print nested objects. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   level to print. Each argument to print is at level 0; if an argument is a
 *   collection, its items are at level 1; and so on. If an object is a
 *   collection and is at a level greater than or equal to the value bound to
 *   *print-level*, the printer prints '#' to represent it. The root binding
 *   is nil indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_level_STAR_ = null;
/**
 * *print-fns-bodies* controls whether functions print their source or
 *  only their names.
 */
cljs.core._STAR_print_fn_bodies_STAR_ = false;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_loaded_libs_STAR_ !== 'undefined')){
} else {
/**
 * @type {*}
 */
cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = (function cljs$core$pr_opts(){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939),cljs.core._STAR_flush_on_newline_STAR_,new cljs.core.Keyword(null,"readably","readably",1129599760),cljs.core._STAR_print_readably_STAR_,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core._STAR_print_meta_STAR_,new cljs.core.Keyword(null,"dup","dup",556298533),cljs.core._STAR_print_dup_STAR_,new cljs.core.Keyword(null,"print-length","print-length",1931866356),cljs.core._STAR_print_length_STAR_], null);
});
/**
 * Set *print-fn* to console.log
 */
cljs.core.enable_console_print_BANG_ = (function cljs$core$enable_console_print_BANG_(){
(cljs.core._STAR_print_newline_STAR_ = false);

cljs.core.set_print_fn_BANG_((function cljs$core$enable_console_print_BANG__$_fn_14082(){
var xs = arguments;
return console.log.apply(console,cljs.core.goog$module$goog$array.clone.call(null,xs));
}));

cljs.core.set_print_err_fn_BANG_((function cljs$core$enable_console_print_BANG__$_fn_14083(){
var xs = arguments;
return console.error.apply(console,cljs.core.goog$module$goog$array.clone.call(null,xs));
}));

return null;
});
/**
 * Internal - do not use!
 */
cljs.core.truth_ = (function cljs$core$truth_(x){
return (x != null && x !== false);
});
cljs.core.not_native = null;

/**
 * Tests if 2 arguments are the same object
 */
cljs.core.identical_QMARK_ = (function cljs$core$identical_QMARK_(x,y){
return (x === y);
});
/**
 * Returns true if x is nil, false otherwise.
 */
cljs.core.nil_QMARK_ = (function cljs$core$nil_QMARK_(x){
return (x == null);
});
/**
 * Returns true if x is a JavaScript array.
 */
cljs.core.array_QMARK_ = (function cljs$core$array_QMARK_(x){
if((cljs.core._STAR_target_STAR_ === "nodejs")){
return Array.isArray(x);
} else {
return (x instanceof Array);
}
});
/**
 * Returns true if x is a JavaScript number.
 */
cljs.core.number_QMARK_ = (function cljs$core$number_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true if x is logical false, false otherwise.
 */
cljs.core.not = (function cljs$core$not(x){
if((x == null)){
return true;
} else {
if(x === false){
return true;
} else {
return false;

}
}
});
/**
 * Returns true if x is not nil, false otherwise.
 */
cljs.core.some_QMARK_ = (function cljs$core$some_QMARK_(x){
return (!((x == null)));
});
/**
 * Returns true if x's constructor is Object
 */
cljs.core.object_QMARK_ = (function cljs$core$object_QMARK_(x){
if((!((x == null)))){
return (x.constructor === Object);
} else {
return false;
}
});
/**
 * Returns true if x is a JavaScript string.
 */
cljs.core.string_QMARK_ = (function cljs$core$string_QMARK_(x){
return ("string" === goog.typeOf(x));
});
/**
 * Returns true if x is a JavaScript string of length one.
 */
cljs.core.char_QMARK_ = (function cljs$core$char_QMARK_(x){
return ((typeof x === 'string') && (((1) === x.length)));
});
/**
 * Returns true if given any argument.
 */
cljs.core.any_QMARK_ = (function cljs$core$any_QMARK_(x){
return true;
});
/**
 * Internal - do not use!
 */
cljs.core.native_satisfies_QMARK_ = (function cljs$core$native_satisfies_QMARK_(p,x){
var x__$1 = (((x == null))?null:x);
if((p[goog.typeOf(x__$1)])){
return true;
} else {
if((p["_"])){
return true;
} else {
return false;

}
}
});
cljs.core.is_proto_ = (function cljs$core$is_proto_(x){
return (x.constructor.prototype === x);
});
/**
 * When compiled for a command-line target, whatever function
 *   *main-cli-fn* is set to will be called with the command-line
 *   argv as arguments
 */
cljs.core._STAR_main_cli_fn_STAR_ = null;
/**
 * A sequence of the supplied command line arguments, or nil if
 *   none were supplied
 */
cljs.core._STAR_command_line_args_STAR_ = null;
/**
 * Return x's constructor.
 */
cljs.core.type = (function cljs$core$type(x){
if((x == null)){
return null;
} else {
return x.constructor;
}
});
cljs.core.missing_protocol = (function cljs$core$missing_protocol(proto,obj){
var ty = cljs.core.type(obj);
var ty__$1 = (cljs.core.truth_((function (){var and__9511__auto__ = ty;
if(cljs.core.truth_(and__9511__auto__)){
return ty.cljs$lang$type;
} else {
return and__9511__auto__;
}
})())?ty.cljs$lang$ctorStr:goog.typeOf(obj));
return (new Error(["No protocol method ",proto," defined for type ",ty__$1,": ",obj].join("")));
});
cljs.core.type__GT_str = (function cljs$core$type__GT_str(ty){
var temp__5718__auto__ = ty.cljs$lang$ctorStr;
if(cljs.core.truth_(temp__5718__auto__)){
var s = temp__5718__auto__;
return s;
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(ty);
}
});
cljs.core.load_file = (function cljs$core$load_file(file){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
return goog.nodeGlobalRequire(file);
}
});
if((((typeof Symbol !== 'undefined')) && ((goog.typeOf(Symbol) === "function")))){
cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
cljs.core.ITER_SYMBOL = "@@iterator";
}
/**
 * @enum {string}
 */
cljs.core.CHAR_MAP = ({"]": "_RBRACK_", "'": "_SINGLEQUOTE_", "=": "_EQ_", "\"": "_DOUBLEQUOTE_", "!": "_BANG_", "*": "_STAR_", "%": "_PERCENT_", "|": "_BAR_", "~": "_TILDE_", "/": "_SLASH_", "\\": "_BSLASH_", "-": "_", "?": "_QMARK_", "&": "_AMPERSAND_", ":": "_COLON_", "<": "_LT_", "{": "_LBRACE_", "}": "_RBRACE_", "[": "_LBRACK_", "#": "_SHARP_", "^": "_CARET_", "+": "_PLUS_", "@": "_CIRCA_", ">": "_GT_"});
/**
 * @enum {string}
 */
cljs.core.DEMUNGE_MAP = ({"_RBRACE_": "}", "_COLON_": ":", "_BANG_": "!", "_QMARK_": "?", "_BSLASH_": "\\\\", "_SLASH_": "/", "_PERCENT_": "%", "_PLUS_": "+", "_SHARP_": "#", "_LBRACE_": "{", "_BAR_": "|", "_LBRACK_": "[", "_EQ_": "=", "_": "-", "_TILDE_": "~", "_RBRACK_": "]", "_GT_": ">", "_SINGLEQUOTE_": "'", "_CIRCA_": "@", "_AMPERSAND_": "&", "_DOUBLEQUOTE_": "\\\"", "_CARET_": "^", "_LT_": "<", "_STAR_": "*"});
cljs.core.DEMUNGE_PATTERN = null;
/**
 * Returns highest resolution time offered by host in milliseconds.
 */
cljs.core.system_time = (function cljs$core$system_time(){
if((((typeof performance !== 'undefined')) && ((!((performance.now == null)))))){
return performance.now();
} else {
if((((typeof process !== 'undefined')) && ((!((process.hrtime == null)))))){
var t = process.hrtime();
return ((((t[(0)]) * 1.0E9) + (t[(1)])) / 1000000.0);
} else {
return (new Date()).getTime();

}
}
});
/**
 * Construct a JavaScript array of the specified dimensions. Accepts ignored
 *   type argument for compatibility with Clojure. Note that there is no efficient
 *   way to allocate multi-dimensional arrays in JavaScript; as such, this function
 *   will run in polynomial time when called with 3 or more arguments.
 */
cljs.core.make_array = (function cljs$core$make_array(var_args){
var G__14088 = arguments.length;
switch (G__14088) {
case 1:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___14094 = arguments.length;
var i__10847__auto___14095 = (0);
while(true){
if((i__10847__auto___14095 < len__10846__auto___14094)){
args_arr__10875__auto__.push((arguments[i__10847__auto___14095]));

var G__14096 = (i__10847__auto___14095 + (1));
i__10847__auto___14095 = G__14096;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14089(size){
return (new Array(size));
}));

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14090(type,size){
return (new Array(size));
}));

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14091(type,size,more_sizes){
var dims = more_sizes;
var dimarray = (new Array(size));
var n__10605__auto___14097 = dimarray.length;
var i_14098 = (0);
while(true){
if((i_14098 < n__10605__auto___14097)){
(dimarray[i_14098] = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.make_array,null,dims));

var G__14099 = (i_14098 + (1));
i_14098 = G__14099;
continue;
} else {
}
break;
}

return dimarray;
}));

/** @this {Function} */
(cljs.core.make_array.cljs$lang$applyTo = (function cljs$core$fn_14092(seq14085){
var G__14086 = cljs.core.first(seq14085);
var seq14085__$1 = cljs.core.next(seq14085);
var G__14087 = cljs.core.first(seq14085__$1);
var seq14085__$2 = cljs.core.next(seq14085__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14086,G__14087,seq14085__$2);
}));

(cljs.core.make_array.cljs$lang$maxFixedArity = (2));

/**
 * Returns a javascript array, cloned from the passed in array
 */
cljs.core.aclone = (function cljs$core$aclone(arr){
var len = arr.length;
var new_arr = (new Array(len));
var n__10605__auto___14100 = len;
var i_14101 = (0);
while(true){
if((i_14101 < n__10605__auto___14100)){
(new_arr[i_14101] = (arr[i_14101]));

var G__14102 = (i_14101 + (1));
i_14101 = G__14102;
continue;
} else {
}
break;
}

return new_arr;
});
/**
 * Creates a new javascript array.
 * @param {...*} var_args
 */
cljs.core.array = (function cljs$core$array(var_args){
var a = (new Array(arguments.length));
var i = (0);
while(true){
if((i < a.length)){
(a[i] = (arguments[i]));

var G__14103 = (i + (1));
i = G__14103;
continue;
} else {
return a;
}
break;
}
});
cljs.core.maybe_warn = (function cljs$core$maybe_warn(e){
if(cljs.core.truth_(cljs.core._STAR_print_err_fn_STAR_)){
return (cljs.core._STAR_print_err_fn_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.core._STAR_print_err_fn_STAR_.cljs$core$IFn$_invoke$arity$1(e) : cljs.core._STAR_print_err_fn_STAR_.call(null,e));
} else {
return null;
}
});
cljs.core.checked_aget = (function cljs$core$checked_aget(var_args){
var G__14108 = arguments.length;
switch (G__14108) {
case 2:
return cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___14114 = arguments.length;
var i__10847__auto___14115 = (0);
while(true){
if((i__10847__auto___14115 < len__10846__auto___14114)){
args_arr__10875__auto__.push((arguments[i__10847__auto___14115]));

var G__14116 = (i__10847__auto___14115 + (1));
i__10847__auto___14115 = G__14116;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14109(array,idx){
try{if(cljs.core.truth_((function (){var or__9517__auto__ = cljs.core.array_QMARK_(array);
if(or__9517__auto__){
return or__9517__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}
}catch (e14110){var e_14117 = e14110;
cljs.core.maybe_warn(e_14117);
}
return (array[idx]);
}));

(cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14111(array,idx,idxs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.checked_aget,cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2(array,idx),idxs);
}));

/** @this {Function} */
(cljs.core.checked_aget.cljs$lang$applyTo = (function cljs$core$fn_14112(seq14105){
var G__14106 = cljs.core.first(seq14105);
var seq14105__$1 = cljs.core.next(seq14105);
var G__14107 = cljs.core.first(seq14105__$1);
var seq14105__$2 = cljs.core.next(seq14105__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14106,G__14107,seq14105__$2);
}));

(cljs.core.checked_aget.cljs$lang$maxFixedArity = (2));

cljs.core.checked_aset = (function cljs$core$checked_aset(var_args){
var G__14123 = arguments.length;
switch (G__14123) {
case 3:
return cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___14129 = arguments.length;
var i__10847__auto___14130 = (0);
while(true){
if((i__10847__auto___14130 < len__10846__auto___14129)){
args_arr__10875__auto__.push((arguments[i__10847__auto___14130]));

var G__14131 = (i__10847__auto___14130 + (1));
i__10847__auto___14130 = G__14131;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((3) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((3)),(0),null)):null);
return cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10876__auto__);

}
});

(cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14124(array,idx,val){
try{if(cljs.core.truth_((function (){var or__9517__auto__ = cljs.core.array_QMARK_(array);
if(or__9517__auto__){
return or__9517__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}
}catch (e14125){var e_14132 = e14125;
cljs.core.maybe_warn(e_14132);
}
return (array[idx] = val);
}));

(cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14126(array,idx,idx2,idxv){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.checked_aset,cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2(array,idx),idx2,idxv);
}));

/** @this {Function} */
(cljs.core.checked_aset.cljs$lang$applyTo = (function cljs$core$fn_14127(seq14119){
var G__14120 = cljs.core.first(seq14119);
var seq14119__$1 = cljs.core.next(seq14119);
var G__14121 = cljs.core.first(seq14119__$1);
var seq14119__$2 = cljs.core.next(seq14119__$1);
var G__14122 = cljs.core.first(seq14119__$2);
var seq14119__$3 = cljs.core.next(seq14119__$2);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14120,G__14121,G__14122,seq14119__$3);
}));

(cljs.core.checked_aset.cljs$lang$maxFixedArity = (3));

cljs.core.checked_aget_SINGLEQUOTE_ = (function cljs$core$checked_aget_SINGLEQUOTE_(var_args){
var G__14137 = arguments.length;
switch (G__14137) {
case 2:
return cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___14142 = arguments.length;
var i__10847__auto___14143 = (0);
while(true){
if((i__10847__auto___14143 < len__10846__auto___14142)){
args_arr__10875__auto__.push((arguments[i__10847__auto___14143]));

var G__14144 = (i__10847__auto___14143 + (1));
i__10847__auto___14143 = G__14144;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14138(array,idx){
if(cljs.core.truth_((function (){var or__9517__auto__ = cljs.core.array_QMARK_(array);
if(or__9517__auto__){
return or__9517__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}

return (array[idx]);
}));

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14139(array,idx,idxs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.checked_aget_SINGLEQUOTE_,cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(array,idx),idxs);
}));

/** @this {Function} */
(cljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$applyTo = (function cljs$core$fn_14140(seq14134){
var G__14135 = cljs.core.first(seq14134);
var seq14134__$1 = cljs.core.next(seq14134);
var G__14136 = cljs.core.first(seq14134__$1);
var seq14134__$2 = cljs.core.next(seq14134__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14135,G__14136,seq14134__$2);
}));

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$maxFixedArity = (2));

cljs.core.checked_aset_SINGLEQUOTE_ = (function cljs$core$checked_aset_SINGLEQUOTE_(var_args){
var G__14150 = arguments.length;
switch (G__14150) {
case 3:
return cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___14155 = arguments.length;
var i__10847__auto___14156 = (0);
while(true){
if((i__10847__auto___14156 < len__10846__auto___14155)){
args_arr__10875__auto__.push((arguments[i__10847__auto___14156]));

var G__14157 = (i__10847__auto___14156 + (1));
i__10847__auto___14156 = G__14157;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((3) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((3)),(0),null)):null);
return cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10876__auto__);

}
});

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14151(array,idx,val){
if(cljs.core.truth_((function (){var or__9517__auto__ = cljs.core.array_QMARK_(array);
if(or__9517__auto__){
return or__9517__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}

return (array[idx] = val);
}));

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14152(array,idx,idx2,idxv){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.checked_aset_SINGLEQUOTE_,cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(array,idx),idx2,idxv);
}));

/** @this {Function} */
(cljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$applyTo = (function cljs$core$fn_14153(seq14146){
var G__14147 = cljs.core.first(seq14146);
var seq14146__$1 = cljs.core.next(seq14146);
var G__14148 = cljs.core.first(seq14146__$1);
var seq14146__$2 = cljs.core.next(seq14146__$1);
var G__14149 = cljs.core.first(seq14146__$2);
var seq14146__$3 = cljs.core.next(seq14146__$2);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14147,G__14148,G__14149,seq14146__$3);
}));

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$maxFixedArity = (3));

/**
 * Returns the value at the index/indices. Works on JavaScript arrays.
 */
cljs.core.aget = (function cljs$core$aget(var_args){
var G__14162 = arguments.length;
switch (G__14162) {
case 2:
return cljs.core.aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___14167 = arguments.length;
var i__10847__auto___14168 = (0);
while(true){
if((i__10847__auto___14168 < len__10846__auto___14167)){
args_arr__10875__auto__.push((arguments[i__10847__auto___14168]));

var G__14169 = (i__10847__auto___14168 + (1));
i__10847__auto___14168 = G__14169;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14163(array,idx){
return (array[idx]);
}));

(cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14164(array,idx,idxs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.aget,(array[idx]),idxs);
}));

/** @this {Function} */
(cljs.core.aget.cljs$lang$applyTo = (function cljs$core$fn_14165(seq14159){
var G__14160 = cljs.core.first(seq14159);
var seq14159__$1 = cljs.core.next(seq14159);
var G__14161 = cljs.core.first(seq14159__$1);
var seq14159__$2 = cljs.core.next(seq14159__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14160,G__14161,seq14159__$2);
}));

(cljs.core.aget.cljs$lang$maxFixedArity = (2));

/**
 * Sets the value at the index/indices. Works on JavaScript arrays.
 *   Returns val.
 */
cljs.core.aset = (function cljs$core$aset(var_args){
var G__14175 = arguments.length;
switch (G__14175) {
case 3:
return cljs.core.aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___14180 = arguments.length;
var i__10847__auto___14181 = (0);
while(true){
if((i__10847__auto___14181 < len__10846__auto___14180)){
args_arr__10875__auto__.push((arguments[i__10847__auto___14181]));

var G__14182 = (i__10847__auto___14181 + (1));
i__10847__auto___14181 = G__14182;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((3) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((3)),(0),null)):null);
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10876__auto__);

}
});

(cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14176(array,idx,val){
return (array[idx] = val);
}));

(cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14177(array,idx,idx2,idxv){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.aset,(array[idx]),idx2,idxv);
}));

/** @this {Function} */
(cljs.core.aset.cljs$lang$applyTo = (function cljs$core$fn_14178(seq14171){
var G__14172 = cljs.core.first(seq14171);
var seq14171__$1 = cljs.core.next(seq14171);
var G__14173 = cljs.core.first(seq14171__$1);
var seq14171__$2 = cljs.core.next(seq14171__$1);
var G__14174 = cljs.core.first(seq14171__$2);
var seq14171__$3 = cljs.core.next(seq14171__$2);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14172,G__14173,G__14174,seq14171__$3);
}));

(cljs.core.aset.cljs$lang$maxFixedArity = (3));

/**
 * Returns the length of the array. Works on arrays of all types.
 */
cljs.core.alength = (function cljs$core$alength(array){
return array.length;
});
/**
 * Returns an array with components set to the values in aseq. Optional type
 *   argument accepted for compatibility with Clojure.
 */
cljs.core.into_array = (function cljs$core$into_array(var_args){
var G__14184 = arguments.length;
switch (G__14184) {
case 1:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14185(aseq){
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null,aseq);
}));

(cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14186(type,aseq){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function cljs$core$fn_14186_$_fn_14187(a,x){
a.push(x);

return a;
}),[],aseq);
}));

(cljs.core.into_array.cljs$lang$maxFixedArity = 2);

/**
 * Invoke JavaScript object method via string. Needed when the
 *   string is not a valid unquoted property name.
 */
cljs.core.js_invoke = (function cljs$core$js_invoke(var_args){
var args__10856__auto__ = [];
var len__10846__auto___14194 = arguments.length;
var i__10847__auto___14195 = (0);
while(true){
if((i__10847__auto___14195 < len__10846__auto___14194)){
args__10856__auto__.push((arguments[i__10847__auto___14195]));

var G__14196 = (i__10847__auto___14195 + (1));
i__10847__auto___14195 = G__14196;
continue;
} else {
}
break;
}

var argseq__10857__auto__ = ((((2) < args__10856__auto__.length))?(new cljs.core.IndexedSeq(args__10856__auto__.slice((2)),(0),null)):null);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10857__auto__);
});

(cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14192(obj,s,args){
return (obj[s]).apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
}));

(cljs.core.js_invoke.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(cljs.core.js_invoke.cljs$lang$applyTo = (function cljs$core$fn_14193(seq14189){
var G__14190 = cljs.core.first(seq14189);
var seq14189__$1 = cljs.core.next(seq14189);
var G__14191 = cljs.core.first(seq14189__$1);
var seq14189__$2 = cljs.core.next(seq14189__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14190,G__14191,seq14189__$2);
}));

/**
 * Returns true if x is an instance of Symbol
 */
cljs.core.js_symbol_QMARK_ = (function cljs$core$js_symbol_QMARK_(x){
return (((goog.typeOf(x) === "symbol")) || ((((typeof Symbol !== 'undefined')) && ((x instanceof Symbol)))));
});

/**
 * Marker protocol
 * @interface
 */
cljs.core.Fn = function(){};


/**
 * Protocol for adding the ability to invoke an object as a function.
 *   For example, a vector can also be used to look up a value:
 *   ([1 2 3 4] 1) => 2
 * @interface
 */
cljs.core.IFn = function(){};

var cljs$core$IFn$_invoke$dyn_14222 = (function() {
var cljs$core$fn_14197 = null;
var cljs$core$fn_14197__1 = (function (this$){
var x__10266__auto__ = (((this$ == null))?null:this$);
var m__10267__auto__ = (cljs.core._invoke[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__10267__auto__.call(null,this$));
} else {
var m__10265__auto__ = (cljs.core._invoke["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__10265__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14197__2 = (function (this$,a){
var x__10266__auto__ = (((this$ == null))?null:this$);
var m__10267__auto__ = (cljs.core._invoke[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__10267__auto__.call(null,this$,a));
} else {
var m__10265__auto__ = (cljs.core._invoke["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__10265__auto__.call(null,this$,a));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14197__3 = (function (this$,a,b){
var x__10266__auto__ = (((this$ == null))?null:this$);
var m__10267__auto__ = (cljs.core._invoke[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__10267__auto__.call(null,this$,a,b));
} else {
var m__10265__auto__ = (cljs.core._invoke["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__10265__auto__.call(null,this$,a,b));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14197__4 = (function (this$,a,b,c){
var x__10266__auto__ = (((this$ == null))?null:this$);
var m__10267__auto__ = (cljs.core._invoke[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$4 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__10267__auto__.call(null,this$,a,b,c));
} else {
var m__10265__auto__ = (cljs.core._invoke["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$4 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__10265__auto__.call(null,this$,a,b,c));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14197__5 = (function (this$,a,b,c,d){
var x__10266__auto__ = (((this$ == null))?null:this$);
var m__10267__auto__ = (cljs.core._invoke[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$5 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__10267__auto__.call(null,this$,a,b,c,d));
} else {
var m__10265__auto__ = (cljs.core._invoke["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$5 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__10265__auto__.call(null,this$,a,b,c,d));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14197__6 = (function (this$,a,b,c,d,e){
var x__10266__auto__ = (((this$ == null))?null:this$);
var m__10267__auto__ = (cljs.core._invoke[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$6 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__10267__auto__.call(null,this$,a,b,c,d,e));
} else {
var m__10265__auto__ = (cljs.core._invoke["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$6 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__10265__auto__.call(null,this$,a,b,c,d,e));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14197__7 = (function (this$,a,b,c,d,e,f){
var x__10266__auto__ = (((this$ == null))?null:this$);
var m__10267__auto__ = (cljs.core._invoke[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$7 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__10267__auto__.call(null,this$,a,b,c,d,e,f));
} else {
var m__10265__auto__ = (cljs.core._invoke["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$7 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__10265__auto__.call(null,this$,a,b,c,d,e,f));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14197__8 = (function (this$,a,b,c,d,e,f,g){
var x__10266__auto__ = (((this$ == null))?null:this$);
var m__10267__auto__ = (cljs.core._invoke[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$8 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__10267__auto__.call(null,this$,a,b,c,d,e,f,g));
} else {
var m__10265__auto__ = (cljs.core._invoke["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$8 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__10265__auto__.call(null,this$,a,b,c,d,e,f,g));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14197__9 = (function (this$,a,b,c,d,e,f,g,h){
var x__10266__auto__ = (((this$ == null))?null:this$);
var m__10267__auto__ = (cljs.core._invoke[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$9 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__10267__auto__.call(null,this$,a,b,c,d,e,f,g,h));
} else {
var m__10265__auto__ = (cljs.core._invoke["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$9 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__10265__auto__.call(null,this$,a,b,c,d,e,f,g,h));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14197__10 = (function (this$,a,b,c,d,e,f,g,h,i){
var x__10266__auto__ = (((this$ == null))?null:this$);
var m__10267__auto__ = (cljs.core._invoke[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$10 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__10267__auto__.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
var m__10265__auto__ = (cljs.core._invoke["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$10 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__10265__auto__.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14197__11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
var x__10266__auto__ = (((this$ == null))?null:this$);
var m__10267__auto__ = (cljs.core._invoke[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$11 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__10267__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
var m__10265__auto__ = (cljs.core._invoke["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$11 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__10265__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14197__12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
var x__10266__auto__ = (((this$ == null))?null:this$);
var m__10267__auto__ = (cljs.core._invoke[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$12 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__10267__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
var m__10265__auto__ = (cljs.core._invoke["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$12 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__10265__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14197__13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
var x__10266__auto__ = (((this$ == null))?null:this$);
var m__10267__auto__ = (cljs.core._invoke[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$13 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__10267__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
var m__10265__auto__ = (cljs.core._invoke["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$13 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__10265__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14197__14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
var x__10266__auto__ = (((this$ == null))?null:this$);
var m__10267__auto__ = (cljs.core._invoke[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$14 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__10267__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
var m__10265__auto__ = (cljs.core._invoke["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$14 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__10265__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14197__15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var x__10266__auto__ = (((this$ == null))?null:this$);
var m__10267__auto__ = (cljs.core._invoke[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$15 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__10267__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
var m__10265__auto__ = (cljs.core._invoke["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$15 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__10265__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14197__16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var x__10266__auto__ = (((this$ == null))?null:this$);
var m__10267__auto__ = (cljs.core._invoke[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$16 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__10267__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
var m__10265__auto__ = (cljs.core._invoke["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$16 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__10265__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14197__17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var x__10266__auto__ = (((this$ == null))?null:this$);
var m__10267__auto__ = (cljs.core._invoke[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$17 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__10267__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
var m__10265__auto__ = (cljs.core._invoke["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$17 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__10265__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14197__18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var x__10266__auto__ = (((this$ == null))?null:this$);
var m__10267__auto__ = (cljs.core._invoke[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$18 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__10267__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
var m__10265__auto__ = (cljs.core._invoke["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$18 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__10265__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14197__19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var x__10266__auto__ = (((this$ == null))?null:this$);
var m__10267__auto__ = (cljs.core._invoke[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$19 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__10267__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
var m__10265__auto__ = (cljs.core._invoke["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$19 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__10265__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14197__20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var x__10266__auto__ = (((this$ == null))?null:this$);
var m__10267__auto__ = (cljs.core._invoke[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$20 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__10267__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
var m__10265__auto__ = (cljs.core._invoke["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$20 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__10265__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14197__21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var x__10266__auto__ = (((this$ == null))?null:this$);
var m__10267__auto__ = (cljs.core._invoke[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$21 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__10267__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
var m__10265__auto__ = (cljs.core._invoke["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$21 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__10265__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14197__22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var x__10266__auto__ = (((this$ == null))?null:this$);
var m__10267__auto__ = (cljs.core._invoke[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$22 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__10267__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
var m__10265__auto__ = (cljs.core._invoke["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$22 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__10265__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
cljs$core$fn_14197 = function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return cljs$core$fn_14197__1.call(this,this$);
case 2:
return cljs$core$fn_14197__2.call(this,this$,a);
case 3:
return cljs$core$fn_14197__3.call(this,this$,a,b);
case 4:
return cljs$core$fn_14197__4.call(this,this$,a,b,c);
case 5:
return cljs$core$fn_14197__5.call(this,this$,a,b,c,d);
case 6:
return cljs$core$fn_14197__6.call(this,this$,a,b,c,d,e);
case 7:
return cljs$core$fn_14197__7.call(this,this$,a,b,c,d,e,f);
case 8:
return cljs$core$fn_14197__8.call(this,this$,a,b,c,d,e,f,g);
case 9:
return cljs$core$fn_14197__9.call(this,this$,a,b,c,d,e,f,g,h);
case 10:
return cljs$core$fn_14197__10.call(this,this$,a,b,c,d,e,f,g,h,i);
case 11:
return cljs$core$fn_14197__11.call(this,this$,a,b,c,d,e,f,g,h,i,j);
case 12:
return cljs$core$fn_14197__12.call(this,this$,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return cljs$core$fn_14197__13.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return cljs$core$fn_14197__14.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return cljs$core$fn_14197__15.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return cljs$core$fn_14197__16.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return cljs$core$fn_14197__17.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return cljs$core$fn_14197__18.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return cljs$core$fn_14197__19.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return cljs$core$fn_14197__20.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return cljs$core$fn_14197__21.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return cljs$core$fn_14197__22.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14197.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14197__1;
cljs$core$fn_14197.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14197__2;
cljs$core$fn_14197.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14197__3;
cljs$core$fn_14197.cljs$core$IFn$_invoke$arity$4 = cljs$core$fn_14197__4;
cljs$core$fn_14197.cljs$core$IFn$_invoke$arity$5 = cljs$core$fn_14197__5;
cljs$core$fn_14197.cljs$core$IFn$_invoke$arity$6 = cljs$core$fn_14197__6;
cljs$core$fn_14197.cljs$core$IFn$_invoke$arity$7 = cljs$core$fn_14197__7;
cljs$core$fn_14197.cljs$core$IFn$_invoke$arity$8 = cljs$core$fn_14197__8;
cljs$core$fn_14197.cljs$core$IFn$_invoke$arity$9 = cljs$core$fn_14197__9;
cljs$core$fn_14197.cljs$core$IFn$_invoke$arity$10 = cljs$core$fn_14197__10;
cljs$core$fn_14197.cljs$core$IFn$_invoke$arity$11 = cljs$core$fn_14197__11;
cljs$core$fn_14197.cljs$core$IFn$_invoke$arity$12 = cljs$core$fn_14197__12;
cljs$core$fn_14197.cljs$core$IFn$_invoke$arity$13 = cljs$core$fn_14197__13;
cljs$core$fn_14197.cljs$core$IFn$_invoke$arity$14 = cljs$core$fn_14197__14;
cljs$core$fn_14197.cljs$core$IFn$_invoke$arity$15 = cljs$core$fn_14197__15;
cljs$core$fn_14197.cljs$core$IFn$_invoke$arity$16 = cljs$core$fn_14197__16;
cljs$core$fn_14197.cljs$core$IFn$_invoke$arity$17 = cljs$core$fn_14197__17;
cljs$core$fn_14197.cljs$core$IFn$_invoke$arity$18 = cljs$core$fn_14197__18;
cljs$core$fn_14197.cljs$core$IFn$_invoke$arity$19 = cljs$core$fn_14197__19;
cljs$core$fn_14197.cljs$core$IFn$_invoke$arity$20 = cljs$core$fn_14197__20;
cljs$core$fn_14197.cljs$core$IFn$_invoke$arity$21 = cljs$core$fn_14197__21;
cljs$core$fn_14197.cljs$core$IFn$_invoke$arity$22 = cljs$core$fn_14197__22;
return cljs$core$fn_14197;
})()
;
cljs.core._invoke = (function cljs$core$_invoke(var_args){
var G__14199 = arguments.length;
switch (G__14199) {
case 1:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
case 9:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
case 11:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));

break;
case 12:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));

break;
case 13:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));

break;
case 14:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));

break;
case 15:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));

break;
case 16:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));

break;
case 17:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));

break;
case 18:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));

break;
case 19:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));

break;
case 20:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));

break;
case 21:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));

break;
case 22:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14200(this$){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$1 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$1(this$);
} else {
return cljs$core$IFn$_invoke$dyn_14222.cljs$core$IFn$_invoke$arity$1(this$);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14201(this$,a){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$2 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$2(this$,a);
} else {
return cljs$core$IFn$_invoke$dyn_14222.cljs$core$IFn$_invoke$arity$2(this$,a);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14202(this$,a,b){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$3 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);
} else {
return cljs$core$IFn$_invoke$dyn_14222.cljs$core$IFn$_invoke$arity$3(this$,a,b);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14203(this$,a,b,c){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$4 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
} else {
return cljs$core$IFn$_invoke$dyn_14222.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_14204(this$,a,b,c,d){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$5 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
} else {
return cljs$core$IFn$_invoke$dyn_14222.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_14205(this$,a,b,c,d,e){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$6 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
} else {
return cljs$core$IFn$_invoke$dyn_14222.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = (function cljs$core$fn_14206(this$,a,b,c,d,e,f){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$7 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
} else {
return cljs$core$IFn$_invoke$dyn_14222.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = (function cljs$core$fn_14207(this$,a,b,c,d,e,f,g){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$8 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
} else {
return cljs$core$IFn$_invoke$dyn_14222.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = (function cljs$core$fn_14208(this$,a,b,c,d,e,f,g,h){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$9 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
} else {
return cljs$core$IFn$_invoke$dyn_14222.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = (function cljs$core$fn_14209(this$,a,b,c,d,e,f,g,h,i){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$10 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
} else {
return cljs$core$IFn$_invoke$dyn_14222.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = (function cljs$core$fn_14210(this$,a,b,c,d,e,f,g,h,i,j){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$11 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
} else {
return cljs$core$IFn$_invoke$dyn_14222.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = (function cljs$core$fn_14211(this$,a,b,c,d,e,f,g,h,i,j,k){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$12 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
return cljs$core$IFn$_invoke$dyn_14222.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = (function cljs$core$fn_14212(this$,a,b,c,d,e,f,g,h,i,j,k,l){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$13 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
return cljs$core$IFn$_invoke$dyn_14222.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = (function cljs$core$fn_14213(this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$14 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
return cljs$core$IFn$_invoke$dyn_14222.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = (function cljs$core$fn_14214(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$15 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
return cljs$core$IFn$_invoke$dyn_14222.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = (function cljs$core$fn_14215(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$16 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
return cljs$core$IFn$_invoke$dyn_14222.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = (function cljs$core$fn_14216(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$17 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
return cljs$core$IFn$_invoke$dyn_14222.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = (function cljs$core$fn_14217(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$18 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
return cljs$core$IFn$_invoke$dyn_14222.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = (function cljs$core$fn_14218(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$19 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
return cljs$core$IFn$_invoke$dyn_14222.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = (function cljs$core$fn_14219(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$20 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
return cljs$core$IFn$_invoke$dyn_14222.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = (function cljs$core$fn_14220(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$21 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
return cljs$core$IFn$_invoke$dyn_14222.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = (function cljs$core$fn_14221(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$22 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
return cljs$core$IFn$_invoke$dyn_14222.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
}));

(cljs.core._invoke.cljs$lang$maxFixedArity = 22);



/**
 * Protocol for cloning a value.
 * @interface
 */
cljs.core.ICloneable = function(){};

var cljs$core$ICloneable$_clone$dyn_14225 = (function cljs$core$fn_14224(value){
var x__10266__auto__ = (((value == null))?null:value);
var m__10267__auto__ = (cljs.core._clone[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__10267__auto__.call(null,value));
} else {
var m__10265__auto__ = (cljs.core._clone["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__10265__auto__.call(null,value));
} else {
throw cljs.core.missing_protocol("ICloneable.-clone",value);
}
}
});
/**
 * Creates a clone of value.
 */
cljs.core._clone = (function cljs$core$_clone(value){
if((((!((value == null)))) && ((!((value.cljs$core$ICloneable$_clone$arity$1 == null)))))){
return value.cljs$core$ICloneable$_clone$arity$1(value);
} else {
return cljs$core$ICloneable$_clone$dyn_14225(value);
}
});


/**
 * Protocol for adding the ability to count a collection in constant time.
 * @interface
 */
cljs.core.ICounted = function(){};

var cljs$core$ICounted$_count$dyn_14227 = (function cljs$core$fn_14226(coll){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._count[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10267__auto__.call(null,coll));
} else {
var m__10265__auto__ = (cljs.core._count["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10265__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ICounted.-count",coll);
}
}
});
/**
 * Calculates the count of coll in constant time. Used by cljs.core/count.
 */
cljs.core._count = (function cljs$core$_count(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ICounted$_count$arity$1 == null)))))){
return coll.cljs$core$ICounted$_count$arity$1(coll);
} else {
return cljs$core$ICounted$_count$dyn_14227(coll);
}
});


/**
 * Protocol for creating an empty collection.
 * @interface
 */
cljs.core.IEmptyableCollection = function(){};

var cljs$core$IEmptyableCollection$_empty$dyn_14229 = (function cljs$core$fn_14228(coll){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._empty[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10267__auto__.call(null,coll));
} else {
var m__10265__auto__ = (cljs.core._empty["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10265__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEmptyableCollection.-empty",coll);
}
}
});
/**
 * Returns an empty collection of the same category as coll. Used
 *   by cljs.core/empty.
 */
cljs.core._empty = (function cljs$core$_empty(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IEmptyableCollection$_empty$arity$1 == null)))))){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else {
return cljs$core$IEmptyableCollection$_empty$dyn_14229(coll);
}
});


/**
 * Protocol for adding to a collection.
 * @interface
 */
cljs.core.ICollection = function(){};

var cljs$core$ICollection$_conj$dyn_14231 = (function cljs$core$fn_14230(coll,o){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._conj[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__10267__auto__.call(null,coll,o));
} else {
var m__10265__auto__ = (cljs.core._conj["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__10265__auto__.call(null,coll,o));
} else {
throw cljs.core.missing_protocol("ICollection.-conj",coll);
}
}
});
/**
 * Returns a new collection of coll with o added to it. The new item
 *   should be added to the most efficient place, e.g.
 *   (conj [1 2 3 4] 5) => [1 2 3 4 5]
 *   (conj '(2 3 4 5) 1) => '(1 2 3 4 5)
 */
cljs.core._conj = (function cljs$core$_conj(coll,o){
if((((!((coll == null)))) && ((!((coll.cljs$core$ICollection$_conj$arity$2 == null)))))){
return coll.cljs$core$ICollection$_conj$arity$2(coll,o);
} else {
return cljs$core$ICollection$_conj$dyn_14231(coll,o);
}
});


/**
 * Protocol for collections to provide indexed-based access to their items.
 * @interface
 */
cljs.core.IIndexed = function(){};

var cljs$core$IIndexed$_nth$dyn_14237 = (function() {
var cljs$core$fn_14232 = null;
var cljs$core$fn_14232__2 = (function (coll,n){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._nth[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__10267__auto__.call(null,coll,n));
} else {
var m__10265__auto__ = (cljs.core._nth["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__10265__auto__.call(null,coll,n));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
});
var cljs$core$fn_14232__3 = (function (coll,n,not_found){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._nth[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__10267__auto__.call(null,coll,n,not_found));
} else {
var m__10265__auto__ = (cljs.core._nth["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__10265__auto__.call(null,coll,n,not_found));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
});
cljs$core$fn_14232 = function(coll,n,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_14232__2.call(this,coll,n);
case 3:
return cljs$core$fn_14232__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14232.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14232__2;
cljs$core$fn_14232.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14232__3;
return cljs$core$fn_14232;
})()
;
/**
 * Returns the value at the index n in the collection coll.
 *   Returns not-found if index n is out of bounds and not-found is supplied.
 */
cljs.core._nth = (function cljs$core$_nth(var_args){
var G__14234 = arguments.length;
switch (G__14234) {
case 2:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14235(coll,n){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIndexed$_nth$arity$2 == null)))))){
return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else {
return cljs$core$IIndexed$_nth$dyn_14237.cljs$core$IFn$_invoke$arity$2(coll,n);
}
}));

(cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14236(coll,n,not_found){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIndexed$_nth$arity$3 == null)))))){
return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);
} else {
return cljs$core$IIndexed$_nth$dyn_14237.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
}
}));

(cljs.core._nth.cljs$lang$maxFixedArity = 3);



/**
 * Marker protocol indicating an array sequence.
 * @interface
 */
cljs.core.ASeq = function(){};


/**
 * Protocol for collections to provide access to their items as sequences.
 * @interface
 */
cljs.core.ISeq = function(){};

var cljs$core$ISeq$_first$dyn_14241 = (function cljs$core$fn_14239(coll){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._first[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10267__auto__.call(null,coll));
} else {
var m__10265__auto__ = (cljs.core._first["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10265__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-first",coll);
}
}
});
/**
 * Returns the first item in the collection coll. Used by cljs.core/first.
 */
cljs.core._first = (function cljs$core$_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISeq$_first$arity$1 == null)))))){
return coll.cljs$core$ISeq$_first$arity$1(coll);
} else {
return cljs$core$ISeq$_first$dyn_14241(coll);
}
});

var cljs$core$ISeq$_rest$dyn_14242 = (function cljs$core$fn_14240(coll){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._rest[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10267__auto__.call(null,coll));
} else {
var m__10265__auto__ = (cljs.core._rest["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10265__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-rest",coll);
}
}
});
/**
 * Returns a new collection of coll without the first item. It should
 *   always return a seq, e.g.
 *   (rest []) => ()
 *   (rest nil) => ()
 */
cljs.core._rest = (function cljs$core$_rest(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISeq$_rest$arity$1 == null)))))){
return coll.cljs$core$ISeq$_rest$arity$1(coll);
} else {
return cljs$core$ISeq$_rest$dyn_14242(coll);
}
});


/**
 * Protocol for accessing the next items of a collection.
 * @interface
 */
cljs.core.INext = function(){};

var cljs$core$INext$_next$dyn_14244 = (function cljs$core$fn_14243(coll){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._next[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10267__auto__.call(null,coll));
} else {
var m__10265__auto__ = (cljs.core._next["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10265__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("INext.-next",coll);
}
}
});
/**
 * Returns a new collection of coll without the first item. In contrast to
 *   rest, it should return nil if there are no more items, e.g.
 *   (next []) => nil
 *   (next nil) => nil
 */
cljs.core._next = (function cljs$core$_next(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$INext$_next$arity$1 == null)))))){
return coll.cljs$core$INext$_next$arity$1(coll);
} else {
return cljs$core$INext$_next$dyn_14244(coll);
}
});


/**
 * Protocol for looking up a value in a data structure.
 * @interface
 */
cljs.core.ILookup = function(){};

var cljs$core$ILookup$_lookup$dyn_14250 = (function() {
var cljs$core$fn_14245 = null;
var cljs$core$fn_14245__2 = (function (o,k){
var x__10266__auto__ = (((o == null))?null:o);
var m__10267__auto__ = (cljs.core._lookup[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__10267__auto__.call(null,o,k));
} else {
var m__10265__auto__ = (cljs.core._lookup["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__10265__auto__.call(null,o,k));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
});
var cljs$core$fn_14245__3 = (function (o,k,not_found){
var x__10266__auto__ = (((o == null))?null:o);
var m__10267__auto__ = (cljs.core._lookup[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__10267__auto__.call(null,o,k,not_found));
} else {
var m__10265__auto__ = (cljs.core._lookup["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__10265__auto__.call(null,o,k,not_found));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
});
cljs$core$fn_14245 = function(o,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_14245__2.call(this,o,k);
case 3:
return cljs$core$fn_14245__3.call(this,o,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14245.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14245__2;
cljs$core$fn_14245.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14245__3;
return cljs$core$fn_14245;
})()
;
/**
 * Use k to look up a value in o. If not-found is supplied and k is not
 *   a valid value that can be used for look up, not-found is returned.
 */
cljs.core._lookup = (function cljs$core$_lookup(var_args){
var G__14247 = arguments.length;
switch (G__14247) {
case 2:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14248(o,k){
if((((!((o == null)))) && ((!((o.cljs$core$ILookup$_lookup$arity$2 == null)))))){
return o.cljs$core$ILookup$_lookup$arity$2(o,k);
} else {
return cljs$core$ILookup$_lookup$dyn_14250.cljs$core$IFn$_invoke$arity$2(o,k);
}
}));

(cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14249(o,k,not_found){
if((((!((o == null)))) && ((!((o.cljs$core$ILookup$_lookup$arity$3 == null)))))){
return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);
} else {
return cljs$core$ILookup$_lookup$dyn_14250.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
}
}));

(cljs.core._lookup.cljs$lang$maxFixedArity = 3);



/**
 * Protocol for adding associativity to collections.
 * @interface
 */
cljs.core.IAssociative = function(){};

var cljs$core$IAssociative$_contains_key_QMARK_$dyn_14254 = (function cljs$core$fn_14252(coll,k){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._contains_key_QMARK_[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10267__auto__.call(null,coll,k));
} else {
var m__10265__auto__ = (cljs.core._contains_key_QMARK_["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10265__auto__.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IAssociative.-contains-key?",coll);
}
}
});
/**
 * Returns true if k is a key in coll.
 */
cljs.core._contains_key_QMARK_ = (function cljs$core$_contains_key_QMARK_(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 == null)))))){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);
} else {
return cljs$core$IAssociative$_contains_key_QMARK_$dyn_14254(coll,k);
}
});

var cljs$core$IAssociative$_assoc$dyn_14255 = (function cljs$core$fn_14253(coll,k,v){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._assoc[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__10267__auto__.call(null,coll,k,v));
} else {
var m__10265__auto__ = (cljs.core._assoc["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__10265__auto__.call(null,coll,k,v));
} else {
throw cljs.core.missing_protocol("IAssociative.-assoc",coll);
}
}
});
/**
 * Returns a new collection of coll with a mapping from key k to
 *   value v added to it.
 */
cljs.core._assoc = (function cljs$core$_assoc(coll,k,v){
if((((!((coll == null)))) && ((!((coll.cljs$core$IAssociative$_assoc$arity$3 == null)))))){
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);
} else {
return cljs$core$IAssociative$_assoc$dyn_14255(coll,k,v);
}
});


/**
 * Protocol for implementing entry finding in collections.
 * @interface
 */
cljs.core.IFind = function(){};

var cljs$core$IFind$_find$dyn_14257 = (function cljs$core$fn_14256(coll,k){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._find[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10267__auto__.call(null,coll,k));
} else {
var m__10265__auto__ = (cljs.core._find["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10265__auto__.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IFind.-find",coll);
}
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core._find = (function cljs$core$_find(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IFind$_find$arity$2 == null)))))){
return coll.cljs$core$IFind$_find$arity$2(coll,k);
} else {
return cljs$core$IFind$_find$dyn_14257(coll,k);
}
});


/**
 * Protocol for adding mapping functionality to collections.
 * @interface
 */
cljs.core.IMap = function(){};

var cljs$core$IMap$_dissoc$dyn_14259 = (function cljs$core$fn_14258(coll,k){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._dissoc[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10267__auto__.call(null,coll,k));
} else {
var m__10265__auto__ = (cljs.core._dissoc["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10265__auto__.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IMap.-dissoc",coll);
}
}
});
/**
 * Returns a new collection of coll without the mapping for key k.
 */
cljs.core._dissoc = (function cljs$core$_dissoc(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMap$_dissoc$arity$2 == null)))))){
return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);
} else {
return cljs$core$IMap$_dissoc$dyn_14259(coll,k);
}
});


/**
 * Protocol for examining a map entry.
 * @interface
 */
cljs.core.IMapEntry = function(){};

var cljs$core$IMapEntry$_key$dyn_14262 = (function cljs$core$fn_14260(coll){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._key[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10267__auto__.call(null,coll));
} else {
var m__10265__auto__ = (cljs.core._key["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10265__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-key",coll);
}
}
});
/**
 * Returns the key of the map entry.
 */
cljs.core._key = (function cljs$core$_key(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMapEntry$_key$arity$1 == null)))))){
return coll.cljs$core$IMapEntry$_key$arity$1(coll);
} else {
return cljs$core$IMapEntry$_key$dyn_14262(coll);
}
});

var cljs$core$IMapEntry$_val$dyn_14263 = (function cljs$core$fn_14261(coll){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._val[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10267__auto__.call(null,coll));
} else {
var m__10265__auto__ = (cljs.core._val["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10265__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-val",coll);
}
}
});
/**
 * Returns the value of the map entry.
 */
cljs.core._val = (function cljs$core$_val(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMapEntry$_val$arity$1 == null)))))){
return coll.cljs$core$IMapEntry$_val$arity$1(coll);
} else {
return cljs$core$IMapEntry$_val$dyn_14263(coll);
}
});


/**
 * Protocol for adding set functionality to a collection.
 * @interface
 */
cljs.core.ISet = function(){};

var cljs$core$ISet$_disjoin$dyn_14265 = (function cljs$core$fn_14264(coll,v){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._disjoin[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__10267__auto__.call(null,coll,v));
} else {
var m__10265__auto__ = (cljs.core._disjoin["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__10265__auto__.call(null,coll,v));
} else {
throw cljs.core.missing_protocol("ISet.-disjoin",coll);
}
}
});
/**
 * Returns a new collection of coll that does not contain v.
 */
cljs.core._disjoin = (function cljs$core$_disjoin(coll,v){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISet$_disjoin$arity$2 == null)))))){
return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);
} else {
return cljs$core$ISet$_disjoin$dyn_14265(coll,v);
}
});


/**
 * Protocol for collections to provide access to their items as stacks. The top
 *   of the stack should be accessed in the most efficient way for the different
 *   data structures.
 * @interface
 */
cljs.core.IStack = function(){};

var cljs$core$IStack$_peek$dyn_14268 = (function cljs$core$fn_14266(coll){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._peek[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10267__auto__.call(null,coll));
} else {
var m__10265__auto__ = (cljs.core._peek["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10265__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-peek",coll);
}
}
});
/**
 * Returns the item from the top of the stack. Is used by cljs.core/peek.
 */
cljs.core._peek = (function cljs$core$_peek(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IStack$_peek$arity$1 == null)))))){
return coll.cljs$core$IStack$_peek$arity$1(coll);
} else {
return cljs$core$IStack$_peek$dyn_14268(coll);
}
});

var cljs$core$IStack$_pop$dyn_14269 = (function cljs$core$fn_14267(coll){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._pop[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10267__auto__.call(null,coll));
} else {
var m__10265__auto__ = (cljs.core._pop["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10265__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-pop",coll);
}
}
});
/**
 * Returns a new stack without the item on top of the stack. Is used
 *   by cljs.core/pop.
 */
cljs.core._pop = (function cljs$core$_pop(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IStack$_pop$arity$1 == null)))))){
return coll.cljs$core$IStack$_pop$arity$1(coll);
} else {
return cljs$core$IStack$_pop$dyn_14269(coll);
}
});


/**
 * Protocol for adding vector functionality to collections.
 * @interface
 */
cljs.core.IVector = function(){};

var cljs$core$IVector$_assoc_n$dyn_14271 = (function cljs$core$fn_14270(coll,n,val){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._assoc_n[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__10267__auto__.call(null,coll,n,val));
} else {
var m__10265__auto__ = (cljs.core._assoc_n["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__10265__auto__.call(null,coll,n,val));
} else {
throw cljs.core.missing_protocol("IVector.-assoc-n",coll);
}
}
});
/**
 * Returns a new vector with value val added at position n.
 */
cljs.core._assoc_n = (function cljs$core$_assoc_n(coll,n,val){
if((((!((coll == null)))) && ((!((coll.cljs$core$IVector$_assoc_n$arity$3 == null)))))){
return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);
} else {
return cljs$core$IVector$_assoc_n$dyn_14271(coll,n,val);
}
});


/**
 * Protocol for adding dereference functionality to a reference.
 * @interface
 */
cljs.core.IDeref = function(){};

var cljs$core$IDeref$_deref$dyn_14273 = (function cljs$core$fn_14272(o){
var x__10266__auto__ = (((o == null))?null:o);
var m__10267__auto__ = (cljs.core._deref[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10267__auto__.call(null,o));
} else {
var m__10265__auto__ = (cljs.core._deref["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10265__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("IDeref.-deref",o);
}
}
});
/**
 * Returns the value of the reference o.
 */
cljs.core._deref = (function cljs$core$_deref(o){
if((((!((o == null)))) && ((!((o.cljs$core$IDeref$_deref$arity$1 == null)))))){
return o.cljs$core$IDeref$_deref$arity$1(o);
} else {
return cljs$core$IDeref$_deref$dyn_14273(o);
}
});


/**
 * @interface
 */
cljs.core.IDerefWithTimeout = function(){};

var cljs$core$IDerefWithTimeout$_deref_with_timeout$dyn_14275 = (function cljs$core$fn_14274(o,msec,timeout_val){
var x__10266__auto__ = (((o == null))?null:o);
var m__10267__auto__ = (cljs.core._deref_with_timeout[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__10267__auto__.call(null,o,msec,timeout_val));
} else {
var m__10265__auto__ = (cljs.core._deref_with_timeout["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__10265__auto__.call(null,o,msec,timeout_val));
} else {
throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout",o);
}
}
});
cljs.core._deref_with_timeout = (function cljs$core$_deref_with_timeout(o,msec,timeout_val){
if((((!((o == null)))) && ((!((o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3 == null)))))){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);
} else {
return cljs$core$IDerefWithTimeout$_deref_with_timeout$dyn_14275(o,msec,timeout_val);
}
});


/**
 * Protocol for accessing the metadata of an object.
 * @interface
 */
cljs.core.IMeta = function(){};

var cljs$core$IMeta$_meta$dyn_14277 = (function cljs$core$fn_14276(o){
var x__10266__auto__ = (((o == null))?null:o);
var m__10267__auto__ = (cljs.core._meta[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10267__auto__.call(null,o));
} else {
var m__10265__auto__ = (cljs.core._meta["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10265__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("IMeta.-meta",o);
}
}
});
/**
 * Returns the metadata of object o.
 */
cljs.core._meta = (function cljs$core$_meta(o){
if((((!((o == null)))) && ((!((o.cljs$core$IMeta$_meta$arity$1 == null)))))){
return o.cljs$core$IMeta$_meta$arity$1(o);
} else {
return cljs$core$IMeta$_meta$dyn_14277(o);
}
});


/**
 * Protocol for adding metadata to an object.
 * @interface
 */
cljs.core.IWithMeta = function(){};

var cljs$core$IWithMeta$_with_meta$dyn_14279 = (function cljs$core$fn_14278(o,meta){
var x__10266__auto__ = (((o == null))?null:o);
var m__10267__auto__ = (cljs.core._with_meta[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__10267__auto__.call(null,o,meta));
} else {
var m__10265__auto__ = (cljs.core._with_meta["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__10265__auto__.call(null,o,meta));
} else {
throw cljs.core.missing_protocol("IWithMeta.-with-meta",o);
}
}
});
/**
 * Returns a new object with value of o and metadata meta added to it.
 */
cljs.core._with_meta = (function cljs$core$_with_meta(o,meta){
if((((!((o == null)))) && ((!((o.cljs$core$IWithMeta$_with_meta$arity$2 == null)))))){
return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);
} else {
return cljs$core$IWithMeta$_with_meta$dyn_14279(o,meta);
}
});


/**
 * Protocol for seq types that can reduce themselves.
 *   Called by cljs.core/reduce.
 * @interface
 */
cljs.core.IReduce = function(){};

var cljs$core$IReduce$_reduce$dyn_14285 = (function() {
var cljs$core$fn_14280 = null;
var cljs$core$fn_14280__2 = (function (coll,f){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._reduce[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__10267__auto__.call(null,coll,f));
} else {
var m__10265__auto__ = (cljs.core._reduce["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__10265__auto__.call(null,coll,f));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
});
var cljs$core$fn_14280__3 = (function (coll,f,start){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._reduce[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__10267__auto__.call(null,coll,f,start));
} else {
var m__10265__auto__ = (cljs.core._reduce["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__10265__auto__.call(null,coll,f,start));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
});
cljs$core$fn_14280 = function(coll,f,start){
switch(arguments.length){
case 2:
return cljs$core$fn_14280__2.call(this,coll,f);
case 3:
return cljs$core$fn_14280__3.call(this,coll,f,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14280.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14280__2;
cljs$core$fn_14280.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14280__3;
return cljs$core$fn_14280;
})()
;
/**
 * f should be a function of 2 arguments. If start is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc.
 */
cljs.core._reduce = (function cljs$core$_reduce(var_args){
var G__14282 = arguments.length;
switch (G__14282) {
case 2:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14283(coll,f){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReduce$_reduce$arity$2 == null)))))){
return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);
} else {
return cljs$core$IReduce$_reduce$dyn_14285.cljs$core$IFn$_invoke$arity$2(coll,f);
}
}));

(cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14284(coll,f,start){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReduce$_reduce$arity$3 == null)))))){
return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);
} else {
return cljs$core$IReduce$_reduce$dyn_14285.cljs$core$IFn$_invoke$arity$3(coll,f,start);
}
}));

(cljs.core._reduce.cljs$lang$maxFixedArity = 3);



/**
 * Protocol for associative types that can reduce themselves
 *   via a function of key and val. Called by cljs.core/reduce-kv.
 * @interface
 */
cljs.core.IKVReduce = function(){};

var cljs$core$IKVReduce$_kv_reduce$dyn_14288 = (function cljs$core$fn_14287(coll,f,init){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._kv_reduce[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__10267__auto__.call(null,coll,f,init));
} else {
var m__10265__auto__ = (cljs.core._kv_reduce["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__10265__auto__.call(null,coll,f,init));
} else {
throw cljs.core.missing_protocol("IKVReduce.-kv-reduce",coll);
}
}
});
/**
 * Reduces an associative collection and returns the result. f should be
 *   a function that takes three arguments.
 */
cljs.core._kv_reduce = (function cljs$core$_kv_reduce(coll,f,init){
if((((!((coll == null)))) && ((!((coll.cljs$core$IKVReduce$_kv_reduce$arity$3 == null)))))){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);
} else {
return cljs$core$IKVReduce$_kv_reduce$dyn_14288(coll,f,init);
}
});


/**
 * Protocol for adding value comparison functionality to a type.
 * @interface
 */
cljs.core.IEquiv = function(){};

var cljs$core$IEquiv$_equiv$dyn_14290 = (function cljs$core$fn_14289(o,other){
var x__10266__auto__ = (((o == null))?null:o);
var m__10267__auto__ = (cljs.core._equiv[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__10267__auto__.call(null,o,other));
} else {
var m__10265__auto__ = (cljs.core._equiv["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__10265__auto__.call(null,o,other));
} else {
throw cljs.core.missing_protocol("IEquiv.-equiv",o);
}
}
});
/**
 * Returns true if o and other are equal, false otherwise.
 */
cljs.core._equiv = (function cljs$core$_equiv(o,other){
if((((!((o == null)))) && ((!((o.cljs$core$IEquiv$_equiv$arity$2 == null)))))){
return o.cljs$core$IEquiv$_equiv$arity$2(o,other);
} else {
return cljs$core$IEquiv$_equiv$dyn_14290(o,other);
}
});


/**
 * Protocol for adding hashing functionality to a type.
 * @interface
 */
cljs.core.IHash = function(){};

var cljs$core$IHash$_hash$dyn_14292 = (function cljs$core$fn_14291(o){
var x__10266__auto__ = (((o == null))?null:o);
var m__10267__auto__ = (cljs.core._hash[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10267__auto__.call(null,o));
} else {
var m__10265__auto__ = (cljs.core._hash["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10265__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("IHash.-hash",o);
}
}
});
/**
 * Returns the hash code of o.
 */
cljs.core._hash = (function cljs$core$_hash(o){
if((((!((o == null)))) && ((!((o.cljs$core$IHash$_hash$arity$1 == null)))))){
return o.cljs$core$IHash$_hash$arity$1(o);
} else {
return cljs$core$IHash$_hash$dyn_14292(o);
}
});


/**
 * Protocol for adding the ability to a type to be transformed into a sequence.
 * @interface
 */
cljs.core.ISeqable = function(){};

var cljs$core$ISeqable$_seq$dyn_14294 = (function cljs$core$fn_14293(o){
var x__10266__auto__ = (((o == null))?null:o);
var m__10267__auto__ = (cljs.core._seq[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10267__auto__.call(null,o));
} else {
var m__10265__auto__ = (cljs.core._seq["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10265__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("ISeqable.-seq",o);
}
}
});
/**
 * Returns a seq of o, or nil if o is empty.
 */
cljs.core._seq = (function cljs$core$_seq(o){
if((((!((o == null)))) && ((!((o.cljs$core$ISeqable$_seq$arity$1 == null)))))){
return o.cljs$core$ISeqable$_seq$arity$1(o);
} else {
return cljs$core$ISeqable$_seq$dyn_14294(o);
}
});


/**
 * Marker interface indicating a persistent collection of sequential items
 * @interface
 */
cljs.core.ISequential = function(){};


/**
 * Marker interface indicating a persistent list
 * @interface
 */
cljs.core.IList = function(){};


/**
 * Marker interface indicating a record object
 * @interface
 */
cljs.core.IRecord = function(){};


/**
 * Protocol for reversing a seq.
 * @interface
 */
cljs.core.IReversible = function(){};

var cljs$core$IReversible$_rseq$dyn_14296 = (function cljs$core$fn_14295(coll){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._rseq[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10267__auto__.call(null,coll));
} else {
var m__10265__auto__ = (cljs.core._rseq["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10265__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IReversible.-rseq",coll);
}
}
});
/**
 * Returns a seq of the items in coll in reversed order.
 */
cljs.core._rseq = (function cljs$core$_rseq(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReversible$_rseq$arity$1 == null)))))){
return coll.cljs$core$IReversible$_rseq$arity$1(coll);
} else {
return cljs$core$IReversible$_rseq$dyn_14296(coll);
}
});


/**
 * Protocol for a collection which can represent their items
 *   in a sorted manner. 
 * @interface
 */
cljs.core.ISorted = function(){};

var cljs$core$ISorted$_sorted_seq$dyn_14301 = (function cljs$core$fn_14297(coll,ascending_QMARK_){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._sorted_seq[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__10267__auto__.call(null,coll,ascending_QMARK_));
} else {
var m__10265__auto__ = (cljs.core._sorted_seq["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__10265__auto__.call(null,coll,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq",coll);
}
}
});
/**
 * Returns a sorted seq from coll in either ascending or descending order.
 */
cljs.core._sorted_seq = (function cljs$core$_sorted_seq(coll,ascending_QMARK_){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_sorted_seq$arity$2 == null)))))){
return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);
} else {
return cljs$core$ISorted$_sorted_seq$dyn_14301(coll,ascending_QMARK_);
}
});

var cljs$core$ISorted$_sorted_seq_from$dyn_14302 = (function cljs$core$fn_14298(coll,k,ascending_QMARK_){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._sorted_seq_from[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__10267__auto__.call(null,coll,k,ascending_QMARK_));
} else {
var m__10265__auto__ = (cljs.core._sorted_seq_from["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__10265__auto__.call(null,coll,k,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq-from",coll);
}
}
});
/**
 * Returns a sorted seq from coll in either ascending or descending order.
 *   If ascending is true, the result should contain all items which are > or >=
 *   than k. If ascending is false, the result should contain all items which
 *   are < or <= than k, e.g.
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)
 */
cljs.core._sorted_seq_from = (function cljs$core$_sorted_seq_from(coll,k,ascending_QMARK_){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_sorted_seq_from$arity$3 == null)))))){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);
} else {
return cljs$core$ISorted$_sorted_seq_from$dyn_14302(coll,k,ascending_QMARK_);
}
});

var cljs$core$ISorted$_entry_key$dyn_14303 = (function cljs$core$fn_14299(coll,entry){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._entry_key[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__10267__auto__.call(null,coll,entry));
} else {
var m__10265__auto__ = (cljs.core._entry_key["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__10265__auto__.call(null,coll,entry));
} else {
throw cljs.core.missing_protocol("ISorted.-entry-key",coll);
}
}
});
/**
 * Returns the key for entry.
 */
cljs.core._entry_key = (function cljs$core$_entry_key(coll,entry){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_entry_key$arity$2 == null)))))){
return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);
} else {
return cljs$core$ISorted$_entry_key$dyn_14303(coll,entry);
}
});

var cljs$core$ISorted$_comparator$dyn_14304 = (function cljs$core$fn_14300(coll){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._comparator[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10267__auto__.call(null,coll));
} else {
var m__10265__auto__ = (cljs.core._comparator["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10265__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISorted.-comparator",coll);
}
}
});
/**
 * Returns the comparator for coll.
 */
cljs.core._comparator = (function cljs$core$_comparator(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_comparator$arity$1 == null)))))){
return coll.cljs$core$ISorted$_comparator$arity$1(coll);
} else {
return cljs$core$ISorted$_comparator$dyn_14304(coll);
}
});


/**
 * Protocol for writing. Currently only implemented by StringBufferWriter.
 * @interface
 */
cljs.core.IWriter = function(){};

var cljs$core$IWriter$_write$dyn_14307 = (function cljs$core$fn_14305(writer,s){
var x__10266__auto__ = (((writer == null))?null:writer);
var m__10267__auto__ = (cljs.core._write[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__10267__auto__.call(null,writer,s));
} else {
var m__10265__auto__ = (cljs.core._write["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__10265__auto__.call(null,writer,s));
} else {
throw cljs.core.missing_protocol("IWriter.-write",writer);
}
}
});
/**
 * Writes s with writer and returns the result.
 */
cljs.core._write = (function cljs$core$_write(writer,s){
if((((!((writer == null)))) && ((!((writer.cljs$core$IWriter$_write$arity$2 == null)))))){
return writer.cljs$core$IWriter$_write$arity$2(writer,s);
} else {
return cljs$core$IWriter$_write$dyn_14307(writer,s);
}
});

var cljs$core$IWriter$_flush$dyn_14308 = (function cljs$core$fn_14306(writer){
var x__10266__auto__ = (((writer == null))?null:writer);
var m__10267__auto__ = (cljs.core._flush[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__10267__auto__.call(null,writer));
} else {
var m__10265__auto__ = (cljs.core._flush["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__10265__auto__.call(null,writer));
} else {
throw cljs.core.missing_protocol("IWriter.-flush",writer);
}
}
});
/**
 * Flush writer.
 */
cljs.core._flush = (function cljs$core$_flush(writer){
if((((!((writer == null)))) && ((!((writer.cljs$core$IWriter$_flush$arity$1 == null)))))){
return writer.cljs$core$IWriter$_flush$arity$1(writer);
} else {
return cljs$core$IWriter$_flush$dyn_14308(writer);
}
});


/**
 * The old IPrintable protocol's implementation consisted of building a giant
 * list of strings to concatenate.  This involved lots of concat calls,
 * intermediate vectors, and lazy-seqs, and was very slow in some older JS
 * engines.  IPrintWithWriter implements printing via the IWriter protocol, so it
 * be implemented efficiently in terms of e.g. a StringBuffer append.
 * @interface
 */
cljs.core.IPrintWithWriter = function(){};

var cljs$core$IPrintWithWriter$_pr_writer$dyn_14310 = (function cljs$core$fn_14309(o,writer,opts){
var x__10266__auto__ = (((o == null))?null:o);
var m__10267__auto__ = (cljs.core._pr_writer[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__10267__auto__.call(null,o,writer,opts));
} else {
var m__10265__auto__ = (cljs.core._pr_writer["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__10265__auto__.call(null,o,writer,opts));
} else {
throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer",o);
}
}
});
cljs.core._pr_writer = (function cljs$core$_pr_writer(o,writer,opts){
if((((!((o == null)))) && ((!((o.cljs$core$IPrintWithWriter$_pr_writer$arity$3 == null)))))){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);
} else {
return cljs$core$IPrintWithWriter$_pr_writer$dyn_14310(o,writer,opts);
}
});


/**
 * Protocol for types which can have a deferred realization. Currently only
 *   implemented by Delay and LazySeq.
 * @interface
 */
cljs.core.IPending = function(){};

var cljs$core$IPending$_realized_QMARK_$dyn_14312 = (function cljs$core$fn_14311(x){
var x__10266__auto__ = (((x == null))?null:x);
var m__10267__auto__ = (cljs.core._realized_QMARK_[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10267__auto__.call(null,x));
} else {
var m__10265__auto__ = (cljs.core._realized_QMARK_["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10265__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("IPending.-realized?",x);
}
}
});
/**
 * Returns true if a value for x has been produced, false otherwise.
 */
cljs.core._realized_QMARK_ = (function cljs$core$_realized_QMARK_(x){
if((((!((x == null)))) && ((!((x.cljs$core$IPending$_realized_QMARK_$arity$1 == null)))))){
return x.cljs$core$IPending$_realized_QMARK_$arity$1(x);
} else {
return cljs$core$IPending$_realized_QMARK_$dyn_14312(x);
}
});


/**
 * Protocol for types that can be watched. Currently only implemented by Atom.
 * @interface
 */
cljs.core.IWatchable = function(){};

var cljs$core$IWatchable$_notify_watches$dyn_14316 = (function cljs$core$fn_14313(this$,oldval,newval){
var x__10266__auto__ = (((this$ == null))?null:this$);
var m__10267__auto__ = (cljs.core._notify_watches[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__10267__auto__.call(null,this$,oldval,newval));
} else {
var m__10265__auto__ = (cljs.core._notify_watches["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__10265__auto__.call(null,this$,oldval,newval));
} else {
throw cljs.core.missing_protocol("IWatchable.-notify-watches",this$);
}
}
});
/**
 * Calls all watchers with this, oldval and newval.
 */
cljs.core._notify_watches = (function cljs$core$_notify_watches(this$,oldval,newval){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_notify_watches$arity$3 == null)))))){
return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);
} else {
return cljs$core$IWatchable$_notify_watches$dyn_14316(this$,oldval,newval);
}
});

var cljs$core$IWatchable$_add_watch$dyn_14317 = (function cljs$core$fn_14314(this$,key,f){
var x__10266__auto__ = (((this$ == null))?null:this$);
var m__10267__auto__ = (cljs.core._add_watch[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__10267__auto__.call(null,this$,key,f));
} else {
var m__10265__auto__ = (cljs.core._add_watch["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__10265__auto__.call(null,this$,key,f));
} else {
throw cljs.core.missing_protocol("IWatchable.-add-watch",this$);
}
}
});
/**
 * Adds a watcher function f to this. Keys must be unique per reference,
 *   and can be used to remove the watch with -remove-watch.
 */
cljs.core._add_watch = (function cljs$core$_add_watch(this$,key,f){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_add_watch$arity$3 == null)))))){
return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);
} else {
return cljs$core$IWatchable$_add_watch$dyn_14317(this$,key,f);
}
});

var cljs$core$IWatchable$_remove_watch$dyn_14318 = (function cljs$core$fn_14315(this$,key){
var x__10266__auto__ = (((this$ == null))?null:this$);
var m__10267__auto__ = (cljs.core._remove_watch[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__10267__auto__.call(null,this$,key));
} else {
var m__10265__auto__ = (cljs.core._remove_watch["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__10265__auto__.call(null,this$,key));
} else {
throw cljs.core.missing_protocol("IWatchable.-remove-watch",this$);
}
}
});
/**
 * Removes watcher that corresponds to key from this.
 */
cljs.core._remove_watch = (function cljs$core$_remove_watch(this$,key){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_remove_watch$arity$2 == null)))))){
return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);
} else {
return cljs$core$IWatchable$_remove_watch$dyn_14318(this$,key);
}
});


/**
 * Protocol for collections which can transformed to transients.
 * @interface
 */
cljs.core.IEditableCollection = function(){};

var cljs$core$IEditableCollection$_as_transient$dyn_14320 = (function cljs$core$fn_14319(coll){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._as_transient[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10267__auto__.call(null,coll));
} else {
var m__10265__auto__ = (cljs.core._as_transient["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10265__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEditableCollection.-as-transient",coll);
}
}
});
/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core._as_transient = (function cljs$core$_as_transient(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IEditableCollection$_as_transient$arity$1 == null)))))){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
} else {
return cljs$core$IEditableCollection$_as_transient$dyn_14320(coll);
}
});


/**
 * Protocol for adding basic functionality to transient collections.
 * @interface
 */
cljs.core.ITransientCollection = function(){};

var cljs$core$ITransientCollection$_conj_BANG_$dyn_14323 = (function cljs$core$fn_14321(tcoll,val){
var x__10266__auto__ = (((tcoll == null))?null:tcoll);
var m__10267__auto__ = (cljs.core._conj_BANG_[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__10267__auto__.call(null,tcoll,val));
} else {
var m__10265__auto__ = (cljs.core._conj_BANG_["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__10265__auto__.call(null,tcoll,val));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-conj!",tcoll);
}
}
});
/**
 * Adds value val to tcoll and returns tcoll.
 */
cljs.core._conj_BANG_ = (function cljs$core$_conj_BANG_(tcoll,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else {
return cljs$core$ITransientCollection$_conj_BANG_$dyn_14323(tcoll,val);
}
});

var cljs$core$ITransientCollection$_persistent_BANG_$dyn_14324 = (function cljs$core$fn_14322(tcoll){
var x__10266__auto__ = (((tcoll == null))?null:tcoll);
var m__10267__auto__ = (cljs.core._persistent_BANG_[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__10267__auto__.call(null,tcoll));
} else {
var m__10265__auto__ = (cljs.core._persistent_BANG_["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__10265__auto__.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-persistent!",tcoll);
}
}
});
/**
 * Creates a persistent data structure from tcoll and returns it.
 */
cljs.core._persistent_BANG_ = (function cljs$core$_persistent_BANG_(tcoll){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 == null)))))){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
} else {
return cljs$core$ITransientCollection$_persistent_BANG_$dyn_14324(tcoll);
}
});


/**
 * Protocol for adding associativity to transient collections.
 * @interface
 */
cljs.core.ITransientAssociative = function(){};

var cljs$core$ITransientAssociative$_assoc_BANG_$dyn_14326 = (function cljs$core$fn_14325(tcoll,key,val){
var x__10266__auto__ = (((tcoll == null))?null:tcoll);
var m__10267__auto__ = (cljs.core._assoc_BANG_[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__10267__auto__.call(null,tcoll,key,val));
} else {
var m__10265__auto__ = (cljs.core._assoc_BANG_["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__10265__auto__.call(null,tcoll,key,val));
} else {
throw cljs.core.missing_protocol("ITransientAssociative.-assoc!",tcoll);
}
}
});
/**
 * Returns a new transient collection of tcoll with a mapping from key to
 *   val added to it.
 */
cljs.core._assoc_BANG_ = (function cljs$core$_assoc_BANG_(tcoll,key,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 == null)))))){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);
} else {
return cljs$core$ITransientAssociative$_assoc_BANG_$dyn_14326(tcoll,key,val);
}
});


/**
 * Protocol for adding mapping functionality to transient collections.
 * @interface
 */
cljs.core.ITransientMap = function(){};

var cljs$core$ITransientMap$_dissoc_BANG_$dyn_14328 = (function cljs$core$fn_14327(tcoll,key){
var x__10266__auto__ = (((tcoll == null))?null:tcoll);
var m__10267__auto__ = (cljs.core._dissoc_BANG_[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__10267__auto__.call(null,tcoll,key));
} else {
var m__10265__auto__ = (cljs.core._dissoc_BANG_["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__10265__auto__.call(null,tcoll,key));
} else {
throw cljs.core.missing_protocol("ITransientMap.-dissoc!",tcoll);
}
}
});
/**
 * Returns a new transient collection of tcoll without the mapping for key.
 */
cljs.core._dissoc_BANG_ = (function cljs$core$_dissoc_BANG_(tcoll,key){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);
} else {
return cljs$core$ITransientMap$_dissoc_BANG_$dyn_14328(tcoll,key);
}
});


/**
 * Protocol for adding vector functionality to transient collections.
 * @interface
 */
cljs.core.ITransientVector = function(){};

var cljs$core$ITransientVector$_assoc_n_BANG_$dyn_14331 = (function cljs$core$fn_14329(tcoll,n,val){
var x__10266__auto__ = (((tcoll == null))?null:tcoll);
var m__10267__auto__ = (cljs.core._assoc_n_BANG_[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__10267__auto__.call(null,tcoll,n,val));
} else {
var m__10265__auto__ = (cljs.core._assoc_n_BANG_["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__10265__auto__.call(null,tcoll,n,val));
} else {
throw cljs.core.missing_protocol("ITransientVector.-assoc-n!",tcoll);
}
}
});
/**
 * Returns tcoll with value val added at position n.
 */
cljs.core._assoc_n_BANG_ = (function cljs$core$_assoc_n_BANG_(tcoll,n,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 == null)))))){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);
} else {
return cljs$core$ITransientVector$_assoc_n_BANG_$dyn_14331(tcoll,n,val);
}
});

var cljs$core$ITransientVector$_pop_BANG_$dyn_14332 = (function cljs$core$fn_14330(tcoll){
var x__10266__auto__ = (((tcoll == null))?null:tcoll);
var m__10267__auto__ = (cljs.core._pop_BANG_[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__10267__auto__.call(null,tcoll));
} else {
var m__10265__auto__ = (cljs.core._pop_BANG_["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__10265__auto__.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientVector.-pop!",tcoll);
}
}
});
/**
 * Returns tcoll with the last item removed from it.
 */
cljs.core._pop_BANG_ = (function cljs$core$_pop_BANG_(tcoll){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1 == null)))))){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
} else {
return cljs$core$ITransientVector$_pop_BANG_$dyn_14332(tcoll);
}
});


/**
 * Protocol for adding set functionality to a transient collection.
 * @interface
 */
cljs.core.ITransientSet = function(){};

var cljs$core$ITransientSet$_disjoin_BANG_$dyn_14334 = (function cljs$core$fn_14333(tcoll,v){
var x__10266__auto__ = (((tcoll == null))?null:tcoll);
var m__10267__auto__ = (cljs.core._disjoin_BANG_[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__10267__auto__.call(null,tcoll,v));
} else {
var m__10265__auto__ = (cljs.core._disjoin_BANG_["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__10265__auto__.call(null,tcoll,v));
} else {
throw cljs.core.missing_protocol("ITransientSet.-disjoin!",tcoll);
}
}
});
/**
 * Returns tcoll without v.
 */
cljs.core._disjoin_BANG_ = (function cljs$core$_disjoin_BANG_(tcoll,v){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);
} else {
return cljs$core$ITransientSet$_disjoin_BANG_$dyn_14334(tcoll,v);
}
});


/**
 * Protocol for values that can be compared.
 * @interface
 */
cljs.core.IComparable = function(){};

var cljs$core$IComparable$_compare$dyn_14336 = (function cljs$core$fn_14335(x,y){
var x__10266__auto__ = (((x == null))?null:x);
var m__10267__auto__ = (cljs.core._compare[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__10267__auto__.call(null,x,y));
} else {
var m__10265__auto__ = (cljs.core._compare["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__10265__auto__.call(null,x,y));
} else {
throw cljs.core.missing_protocol("IComparable.-compare",x);
}
}
});
/**
 * Returns a negative number, zero, or a positive number when x is logically
 *   'less than', 'equal to', or 'greater than' y.
 */
cljs.core._compare = (function cljs$core$_compare(x,y){
if((((!((x == null)))) && ((!((x.cljs$core$IComparable$_compare$arity$2 == null)))))){
return x.cljs$core$IComparable$_compare$arity$2(x,y);
} else {
return cljs$core$IComparable$_compare$dyn_14336(x,y);
}
});


/**
 * Protocol for accessing the items of a chunk.
 * @interface
 */
cljs.core.IChunk = function(){};

var cljs$core$IChunk$_drop_first$dyn_14338 = (function cljs$core$fn_14337(coll){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._drop_first[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10267__auto__.call(null,coll));
} else {
var m__10265__auto__ = (cljs.core._drop_first["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10265__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunk.-drop-first",coll);
}
}
});
/**
 * Return a new chunk of coll with the first item removed.
 */
cljs.core._drop_first = (function cljs$core$_drop_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunk$_drop_first$arity$1 == null)))))){
return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
} else {
return cljs$core$IChunk$_drop_first$dyn_14338(coll);
}
});


/**
 * Protocol for accessing a collection as sequential chunks.
 * @interface
 */
cljs.core.IChunkedSeq = function(){};

var cljs$core$IChunkedSeq$_chunked_first$dyn_14341 = (function cljs$core$fn_14339(coll){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._chunked_first[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10267__auto__.call(null,coll));
} else {
var m__10265__auto__ = (cljs.core._chunked_first["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10265__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first",coll);
}
}
});
/**
 * Returns the first chunk in coll.
 */
cljs.core._chunked_first = (function cljs$core$_chunked_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedSeq$_chunked_first$arity$1 == null)))))){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
} else {
return cljs$core$IChunkedSeq$_chunked_first$dyn_14341(coll);
}
});

var cljs$core$IChunkedSeq$_chunked_rest$dyn_14342 = (function cljs$core$fn_14340(coll){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._chunked_rest[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10267__auto__.call(null,coll));
} else {
var m__10265__auto__ = (cljs.core._chunked_rest["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10265__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest",coll);
}
}
});
/**
 * Return a new collection of coll with the first chunk removed.
 */
cljs.core._chunked_rest = (function cljs$core$_chunked_rest(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1 == null)))))){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
} else {
return cljs$core$IChunkedSeq$_chunked_rest$dyn_14342(coll);
}
});


/**
 * Protocol for accessing the chunks of a collection.
 * @interface
 */
cljs.core.IChunkedNext = function(){};

var cljs$core$IChunkedNext$_chunked_next$dyn_14344 = (function cljs$core$fn_14343(coll){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._chunked_next[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10267__auto__.call(null,coll));
} else {
var m__10265__auto__ = (cljs.core._chunked_next["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10265__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedNext.-chunked-next",coll);
}
}
});
/**
 * Returns a new collection of coll without the first chunk.
 */
cljs.core._chunked_next = (function cljs$core$_chunked_next(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedNext$_chunked_next$arity$1 == null)))))){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
} else {
return cljs$core$IChunkedNext$_chunked_next$dyn_14344(coll);
}
});


/**
 * Protocol for adding a name.
 * @interface
 */
cljs.core.INamed = function(){};

var cljs$core$INamed$_name$dyn_14347 = (function cljs$core$fn_14345(x){
var x__10266__auto__ = (((x == null))?null:x);
var m__10267__auto__ = (cljs.core._name[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10267__auto__.call(null,x));
} else {
var m__10265__auto__ = (cljs.core._name["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10265__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-name",x);
}
}
});
/**
 * Returns the name String of x.
 */
cljs.core._name = (function cljs$core$_name(x){
if((((!((x == null)))) && ((!((x.cljs$core$INamed$_name$arity$1 == null)))))){
return x.cljs$core$INamed$_name$arity$1(x);
} else {
return cljs$core$INamed$_name$dyn_14347(x);
}
});

var cljs$core$INamed$_namespace$dyn_14348 = (function cljs$core$fn_14346(x){
var x__10266__auto__ = (((x == null))?null:x);
var m__10267__auto__ = (cljs.core._namespace[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10267__auto__.call(null,x));
} else {
var m__10265__auto__ = (cljs.core._namespace["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10265__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-namespace",x);
}
}
});
/**
 * Returns the namespace String of x.
 */
cljs.core._namespace = (function cljs$core$_namespace(x){
if((((!((x == null)))) && ((!((x.cljs$core$INamed$_namespace$arity$1 == null)))))){
return x.cljs$core$INamed$_namespace$arity$1(x);
} else {
return cljs$core$INamed$_namespace$dyn_14348(x);
}
});


/**
 * Marker protocol indicating an atom.
 * @interface
 */
cljs.core.IAtom = function(){};


/**
 * Protocol for adding resetting functionality.
 * @interface
 */
cljs.core.IReset = function(){};

var cljs$core$IReset$_reset_BANG_$dyn_14350 = (function cljs$core$fn_14349(o,new_value){
var x__10266__auto__ = (((o == null))?null:o);
var m__10267__auto__ = (cljs.core._reset_BANG_[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__10267__auto__.call(null,o,new_value));
} else {
var m__10265__auto__ = (cljs.core._reset_BANG_["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__10265__auto__.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IReset.-reset!",o);
}
}
});
/**
 * Sets the value of o to new-value.
 */
cljs.core._reset_BANG_ = (function cljs$core$_reset_BANG_(o,new_value){
if((((!((o == null)))) && ((!((o.cljs$core$IReset$_reset_BANG_$arity$2 == null)))))){
return o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);
} else {
return cljs$core$IReset$_reset_BANG_$dyn_14350(o,new_value);
}
});


/**
 * Protocol for adding swapping functionality.
 * @interface
 */
cljs.core.ISwap = function(){};

var cljs$core$ISwap$_swap_BANG_$dyn_14358 = (function() {
var cljs$core$fn_14351 = null;
var cljs$core$fn_14351__2 = (function (o,f){
var x__10266__auto__ = (((o == null))?null:o);
var m__10267__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__10267__auto__.call(null,o,f));
} else {
var m__10265__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__10265__auto__.call(null,o,f));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
var cljs$core$fn_14351__3 = (function (o,f,a){
var x__10266__auto__ = (((o == null))?null:o);
var m__10267__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__10267__auto__.call(null,o,f,a));
} else {
var m__10265__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__10265__auto__.call(null,o,f,a));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
var cljs$core$fn_14351__4 = (function (o,f,a,b){
var x__10266__auto__ = (((o == null))?null:o);
var m__10267__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$4 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__10267__auto__.call(null,o,f,a,b));
} else {
var m__10265__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$4 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__10265__auto__.call(null,o,f,a,b));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
var cljs$core$fn_14351__5 = (function (o,f,a,b,xs){
var x__10266__auto__ = (((o == null))?null:o);
var m__10267__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$5 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__10267__auto__.call(null,o,f,a,b,xs));
} else {
var m__10265__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$5 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__10265__auto__.call(null,o,f,a,b,xs));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
cljs$core$fn_14351 = function(o,f,a,b,xs){
switch(arguments.length){
case 2:
return cljs$core$fn_14351__2.call(this,o,f);
case 3:
return cljs$core$fn_14351__3.call(this,o,f,a);
case 4:
return cljs$core$fn_14351__4.call(this,o,f,a,b);
case 5:
return cljs$core$fn_14351__5.call(this,o,f,a,b,xs);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14351.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14351__2;
cljs$core$fn_14351.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14351__3;
cljs$core$fn_14351.cljs$core$IFn$_invoke$arity$4 = cljs$core$fn_14351__4;
cljs$core$fn_14351.cljs$core$IFn$_invoke$arity$5 = cljs$core$fn_14351__5;
return cljs$core$fn_14351;
})()
;
/**
 * Swaps the value of o to be (apply f current-value-of-atom args).
 */
cljs.core._swap_BANG_ = (function cljs$core$_swap_BANG_(var_args){
var G__14353 = arguments.length;
switch (G__14353) {
case 2:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14354(o,f){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$2 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_14358.cljs$core$IFn$_invoke$arity$2(o,f);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14355(o,f,a){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$3 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_14358.cljs$core$IFn$_invoke$arity$3(o,f,a);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14356(o,f,a,b){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$4 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_14358.cljs$core$IFn$_invoke$arity$4(o,f,a,b);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_14357(o,f,a,b,xs){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$5 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_14358.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs);
}
}));

(cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5);



/**
 * Protocol for adding volatile functionality.
 * @interface
 */
cljs.core.IVolatile = function(){};

var cljs$core$IVolatile$_vreset_BANG_$dyn_14361 = (function cljs$core$fn_14360(o,new_value){
var x__10266__auto__ = (((o == null))?null:o);
var m__10267__auto__ = (cljs.core._vreset_BANG_[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__10267__auto__.call(null,o,new_value));
} else {
var m__10265__auto__ = (cljs.core._vreset_BANG_["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__10265__auto__.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IVolatile.-vreset!",o);
}
}
});
/**
 * Sets the value of volatile o to new-value without regard for the
 *   current value. Returns new-value.
 */
cljs.core._vreset_BANG_ = (function cljs$core$_vreset_BANG_(o,new_value){
if((((!((o == null)))) && ((!((o.cljs$core$IVolatile$_vreset_BANG_$arity$2 == null)))))){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);
} else {
return cljs$core$IVolatile$_vreset_BANG_$dyn_14361(o,new_value);
}
});


/**
 * Protocol for iterating over a collection.
 * @interface
 */
cljs.core.IIterable = function(){};

var cljs$core$IIterable$_iterator$dyn_14363 = (function cljs$core$fn_14362(coll){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._iterator[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10267__auto__.call(null,coll));
} else {
var m__10265__auto__ = (cljs.core._iterator["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10265__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IIterable.-iterator",coll);
}
}
});
/**
 * Returns an iterator for coll.
 */
cljs.core._iterator = (function cljs$core$_iterator(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIterable$_iterator$arity$1 == null)))))){
return coll.cljs$core$IIterable$_iterator$arity$1(coll);
} else {
return cljs$core$IIterable$_iterator$dyn_14363(coll);
}
});


/**
 * Protocol for persistent or algorithmically defined collections to provide a
 *   means of dropping N items that is more efficient than sequential walking.
 * @interface
 */
cljs.core.IDrop = function(){};

var cljs$core$IDrop$_drop$dyn_14365 = (function cljs$core$fn_14364(coll,n){
var x__10266__auto__ = (((coll == null))?null:coll);
var m__10267__auto__ = (cljs.core._drop[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__10267__auto__.call(null,coll,n));
} else {
var m__10265__auto__ = (cljs.core._drop["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__10265__auto__.call(null,coll,n));
} else {
throw cljs.core.missing_protocol("IDrop.-drop",coll);
}
}
});
/**
 * Returns a collection that is ISequential, ISeq, and IReduce, or nil if past
 *   the end. The number of items to drop n must be > 0. It is also useful if the
 *   returned coll implements IDrop for subsequent use in a partition-like scenario.
 */
cljs.core._drop = (function cljs$core$_drop(coll,n){
if((((!((coll == null)))) && ((!((coll.cljs$core$IDrop$_drop$arity$2 == null)))))){
return coll.cljs$core$IDrop$_drop$arity$2(coll,n);
} else {
return cljs$core$IDrop$_drop$dyn_14365(coll,n);
}
});


/**
* @constructor
 * @implements {cljs.core.IWriter}
*/
cljs.core.StringBufferWriter = (function (sb){
this.sb = sb;
this.cljs$lang$protocol_mask$partition0$ = 1073741824;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = (function cljs$core$fn_14366(_,s){
var self__ = this;
var ___$1 = this;
return self__.sb.append(s);
}));

(cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = (function cljs$core$fn_14367(_){
var self__ = this;
var ___$1 = this;
return null;
}));

(cljs.core.StringBufferWriter.getBasis = (function cljs$core$fn_14368(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"sb","sb",-1249746442,null)], null);
}));

(cljs.core.StringBufferWriter.cljs$lang$type = true);

(cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter");

(cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = (function cljs$core$fn_14369(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/StringBufferWriter");
}));

/**
 * Positional factory function for cljs.core/StringBufferWriter.
 */
cljs.core.__GT_StringBufferWriter = (function cljs$core$__GT_StringBufferWriter(sb){
return (new cljs.core.StringBufferWriter(sb));
});

/**
 * Support so that collections can implement toString without
 * loading all the printing machinery.
 */
cljs.core.pr_str_STAR_ = (function cljs$core$pr_str_STAR_(obj){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,cljs.core.pr_opts());

writer.cljs$core$IWriter$_flush$arity$1(null);

return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb);
});
cljs.core.int_rotate_left = (function cljs$core$int_rotate_left(x,n){
return ((x << n) | (x >>> (- n)));
});
if((((typeof Math !== 'undefined') && (typeof Math.imul !== 'undefined')) && ((!((Math.imul((4294967295),(5)) === (0))))))){
cljs.core.imul = (function cljs$core$imul(a,b){
return Math.imul(a,b);
});
} else {
cljs.core.imul = (function cljs$core$imul(a,b){
var ah = ((a >>> (16)) & (65535));
var al = (a & (65535));
var bh = ((b >>> (16)) & (65535));
var bl = (b & (65535));
return (((al * bl) + ((((ah * bl) + (al * bh)) << (16)) >>> (0))) | (0));
});
}
cljs.core.m3_seed = (0);
cljs.core.m3_C1 = ((3432918353) | (0));
cljs.core.m3_C2 = ((461845907) | (0));
cljs.core.m3_mix_K1 = (function cljs$core$m3_mix_K1(k1){
return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul((k1 | (0)),cljs.core.m3_C1),(15)),cljs.core.m3_C2);
});
cljs.core.m3_mix_H1 = (function cljs$core$m3_mix_H1(h1,k1){
return ((cljs.core.imul(cljs.core.int_rotate_left(((h1 | (0)) ^ (k1 | (0))),(13)),(5)) + ((3864292196) | (0))) | (0));
});
cljs.core.m3_fmix = (function cljs$core$m3_fmix(h1,len){
var h1__$1 = (h1 | (0));
var h1__$2 = (h1__$1 ^ len);
var h1__$3 = (h1__$2 ^ (h1__$2 >>> (16)));
var h1__$4 = cljs.core.imul(h1__$3,((2246822507) | (0)));
var h1__$5 = (h1__$4 ^ (h1__$4 >>> (13)));
var h1__$6 = cljs.core.imul(h1__$5,((3266489909) | (0)));
return (h1__$6 ^ (h1__$6 >>> (16)));
});
cljs.core.m3_hash_int = (function cljs$core$m3_hash_int(in$){
if((in$ === (0))){
return in$;
} else {
var k1 = cljs.core.m3_mix_K1(in$);
var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);
return cljs.core.m3_fmix(h1,(4));
}
});
cljs.core.hash_long = (function cljs$core$hash_long(high,low){
return (high ^ low);
});
cljs.core.hash_double = (function cljs$core$hash_double(f){
var arr = (function (){var G__14370 = (new Float64Array((1)));
(G__14370[(0)] = f);

return G__14370;
})();
var buf = arr.buffer;
var high = (new DataView(buf,(0),(4))).getInt32();
var low = (new DataView(buf,(4),(4))).getInt32();
return cljs.core.hash_long(high,low);
});
cljs.core.m3_hash_unencoded_chars = (function cljs$core$m3_hash_unencoded_chars(in$){
var h1 = (function (){var i = (1);
var h1 = cljs.core.m3_seed;
while(true){
if((i < in$.length)){
var G__14371 = (i + (2));
var G__14372 = cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1((in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) << (16)))));
i = G__14371;
h1 = G__14372;
continue;
} else {
return h1;
}
break;
}
})();
var h1__$1 = ((((in$.length & (1)) === (1)))?(h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt((in$.length - (1))))):h1);
return cljs.core.m3_fmix(h1__$1,cljs.core.imul((2),in$.length));
});



cljs.core.string_hash_cache = ({});
cljs.core.string_hash_cache_count = (0);
cljs.core.hash_string_STAR_ = (function cljs$core$hash_string_STAR_(s){
if((!((s == null)))){
var len = s.length;
if((len > (0))){
var i = (0);
var hash = (0);
while(true){
if((i < len)){
var G__14375 = (i + (1));
var G__14376 = (cljs.core.imul((31),hash) + s.charCodeAt(i));
i = G__14375;
hash = G__14376;
continue;
} else {
return hash;
}
break;
}
} else {
return (0);
}
} else {
return (0);
}
});
cljs.core.add_to_string_hash_cache = (function cljs$core$add_to_string_hash_cache(k){
var h = cljs.core.hash_string_STAR_(k);
cljs.core.goog$module$goog$object.set.call(null,cljs.core.string_hash_cache,k,h);

(cljs.core.string_hash_cache_count = (cljs.core.string_hash_cache_count + (1)));

return h;
});
cljs.core.hash_string = (function cljs$core$hash_string(k){
if((cljs.core.string_hash_cache_count > (255))){
(cljs.core.string_hash_cache = ({}));

(cljs.core.string_hash_cache_count = (0));
} else {
}

if((k == null)){
return (0);
} else {
var h = (cljs.core.string_hash_cache[k]);
if(typeof h === 'number'){
return h;
} else {
return cljs.core.add_to_string_hash_cache(k);
}
}
});
/**
 * Returns the hash code of its argument. Note this is the hash code
 * consistent with =.
 */
cljs.core.hash = (function cljs$core$hash(o){
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (4194304))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IHash$))))?true:false):false)){
return (o.cljs$core$IHash$_hash$arity$1(null) ^ (0));
} else {
if(typeof o === 'number'){
if(isFinite(o)){
if((!(Number.isSafeInteger(o)))){
return cljs.core.hash_double(o);
} else {
return (Math.floor(o) % (2147483647));
}
} else {
var G__14380 = o;
switch (G__14380) {
case Infinity:
return (2146435072);

break;
case -Infinity:
return (-1048576);

break;
default:
return (2146959360);

}
}
} else {
if(o === true){
return (1231);
} else {
if(o === false){
return (1237);
} else {
if(typeof o === 'string'){
return cljs.core.m3_hash_int(cljs.core.hash_string(o));
} else {
if((o instanceof Date)){
return (o.valueOf() ^ (0));
} else {
if((o == null)){
return (0);
} else {
return (cljs.core._hash(o) ^ (0));

}
}
}
}
}
}
}
});
cljs.core.hash_combine = (function cljs$core$hash_combine(seed,hash){
return (seed ^ (((hash + (2654435769)) + (seed << (6))) + (seed >> (2))));
});
/**
 * Evaluates x and tests if it is an instance of the type
 *   c. Returns true or false
 */
cljs.core.instance_QMARK_ = (function cljs$core$instance_QMARK_(c,x){
return (x instanceof c);
});
/**
 * Return true if x is a Symbol
 */
cljs.core.symbol_QMARK_ = (function cljs$core$symbol_QMARK_(x){
return (x instanceof cljs.core.Symbol);
});
cljs.core.hash_symbol = (function cljs$core$hash_symbol(sym){
return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns));
});
cljs.core.compare_symbols = (function cljs$core$compare_symbols(a,b){
if((a.str === b.str)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__9511__auto__ = cljs.core.not(a.ns);
if(and__9511__auto__){
return b.ns;
} else {
return and__9511__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__14382 = a.ns;
var G__14383 = b.ns;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__14382,G__14383);
})();
if(((0) === nsc)){
var G__14384 = a.name;
var G__14385 = b.name;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__14384,G__14385);
} else {
return nsc;
}
}
} else {
var G__14386 = a.name;
var G__14387 = b.name;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__14386,G__14387);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Symbol = (function (ns,name,str,_hash,_meta){
this.ns = ns;
this.name = name;
this.str = str;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2154168321;
this.cljs$lang$protocol_mask$partition1$ = 4096;
});
(cljs.core.Symbol.prototype.toString = (function cljs$core$fn_14389(){
var self__ = this;
var _ = this;
return self__.str;
}));

(cljs.core.Symbol.prototype.equiv = (function cljs$core$fn_14390(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_14391(_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Symbol)){
return (self__.str === other.str);
} else {
return false;
}
}));

(cljs.core.Symbol.prototype.call = (function() {
var cljs$core$fn_14392 = null;
var cljs$core$fn_14392__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym);
});
var cljs$core$fn_14392__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});
cljs$core$fn_14392 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_14392__2.call(this,self__,coll);
case 3:
return cljs$core$fn_14392__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_14392.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14392__2;
cljs$core$fn_14392.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14392__3;
return cljs$core$fn_14392;
})()
);

(cljs.core.Symbol.prototype.apply = (function cljs$core$fn_14393(self__,args14388){
var self__ = this;
var self____$1 = this;
var args__10120__auto__ = cljs.core.aclone(args14388);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10120__auto__.length > (20)))?(function (){var G__14394 = args__10120__auto__.slice((0),(20));
G__14394.push(args__10120__auto__.slice((20)));

return G__14394;
})():args__10120__auto__)));
}));

(cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14395(coll){
var self__ = this;
var sym = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym);
}));

(cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14396(coll,not_found){
var self__ = this;
var sym = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
}));

(cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_14397(_){
var self__ = this;
var ___$1 = this;
return self__._meta;
}));

(cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_14398(_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));
}));

(cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_14399(sym){
var self__ = this;
var sym__$1 = this;
var h__9978__auto__ = self__._hash;
if((!((h__9978__auto__ == null)))){
return h__9978__auto__;
} else {
var h__9978__auto____$1 = cljs.core.hash_symbol(sym__$1);
(self__._hash = h__9978__auto____$1);

return h__9978__auto____$1;
}
}));

(cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = (function cljs$core$fn_14400(_){
var self__ = this;
var ___$1 = this;
return self__.name;
}));

(cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = (function cljs$core$fn_14401(_){
var self__ = this;
var ___$1 = this;
return self__.ns;
}));

(cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function cljs$core$fn_14402(o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,self__.str);
}));

(cljs.core.Symbol.getBasis = (function cljs$core$fn_14403(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns","ns",2082130287,null),new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.Symbol.cljs$lang$type = true);

(cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol");

(cljs.core.Symbol.cljs$lang$ctorPrWriter = (function cljs$core$fn_14404(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/Symbol");
}));

/**
 * Positional factory function for cljs.core/Symbol.
 */
cljs.core.__GT_Symbol = (function cljs$core$__GT_Symbol(ns,name,str,_hash,_meta){
return (new cljs.core.Symbol(ns,name,str,_hash,_meta));
});

/**
 * Returns true if v is of type cljs.core.Var
 */
cljs.core.var_QMARK_ = (function cljs$core$var_QMARK_(v){
return (v instanceof cljs.core.Var);
});
/**
 * Returns a Symbol with the given namespace and name. Arity-1 works
 *   on strings, keywords, and vars.
 */
cljs.core.symbol = (function cljs$core$symbol(var_args){
var G__14406 = arguments.length;
switch (G__14406) {
case 1:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14407(name){
while(true){
if((name instanceof cljs.core.Symbol)){
return name;
} else {
if(typeof name === 'string'){
var idx = name.indexOf("/");
if((idx < (1))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null,name);
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(name.substring((0),idx),name.substring((idx + (1)),name.length));
}
} else {
if(cljs.core.var_QMARK_(name)){
return name.sym;
} else {
if((name instanceof cljs.core.Keyword)){
var G__14410 = name.fqn;
name = G__14410;
continue;
} else {
throw (new Error("no conversion to symbol"));

}
}
}
}
break;
}
}));

(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14408(ns,name){
var sym_str = (((!((ns == null))))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):name);
return (new cljs.core.Symbol(ns,name,sym_str,null,null));
}));

(cljs.core.symbol.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IDeref}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Var = (function (val,sym,_meta){
this.val = val;
this.sym = sym;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 6717441;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Var.prototype.isMacro = (function cljs$core$fn_14412(){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).cljs$lang$macro;
}));

(cljs.core.Var.prototype.toString = (function cljs$core$fn_14413(){
var self__ = this;
var _ = this;
return ["#'",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.sym)].join('');
}));

(cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = (function cljs$core$fn_14414(_){
var self__ = this;
var ___$1 = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
}));

(cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_14415(_){
var self__ = this;
var ___$1 = this;
return self__._meta;
}));

(cljs.core.Var.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_14416(_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Var(self__.val,self__.sym,new_meta));
}));

(cljs.core.Var.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_14417(this$,other){
var self__ = this;
var this$__$1 = this;
if((other instanceof cljs.core.Var)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this$__$1.sym,other.sym);
} else {
return false;
}
}));

(cljs.core.Var.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_14418(_){
var self__ = this;
var ___$1 = this;
return cljs.core.hash_symbol(self__.sym);
}));

(cljs.core.Var.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Var.prototype.call = (function() {
var cljs$core$fn_14419 = null;
var cljs$core$fn_14419__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14420 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14420.cljs$core$IFn$_invoke$arity$0 ? fexpr__14420.cljs$core$IFn$_invoke$arity$0() : fexpr__14420.call(null));
});
var cljs$core$fn_14419__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14421 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14421.cljs$core$IFn$_invoke$arity$1 ? fexpr__14421.cljs$core$IFn$_invoke$arity$1(a) : fexpr__14421.call(null,a));
});
var cljs$core$fn_14419__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14422 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14422.cljs$core$IFn$_invoke$arity$2 ? fexpr__14422.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__14422.call(null,a,b));
});
var cljs$core$fn_14419__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14423 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14423.cljs$core$IFn$_invoke$arity$3 ? fexpr__14423.cljs$core$IFn$_invoke$arity$3(a,b,c) : fexpr__14423.call(null,a,b,c));
});
var cljs$core$fn_14419__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14424 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14424.cljs$core$IFn$_invoke$arity$4 ? fexpr__14424.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : fexpr__14424.call(null,a,b,c,d));
});
var cljs$core$fn_14419__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14425 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14425.cljs$core$IFn$_invoke$arity$5 ? fexpr__14425.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : fexpr__14425.call(null,a,b,c,d,e));
});
var cljs$core$fn_14419__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14426 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14426.cljs$core$IFn$_invoke$arity$6 ? fexpr__14426.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : fexpr__14426.call(null,a,b,c,d,e,f));
});
var cljs$core$fn_14419__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14427 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14427.cljs$core$IFn$_invoke$arity$7 ? fexpr__14427.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : fexpr__14427.call(null,a,b,c,d,e,f,g));
});
var cljs$core$fn_14419__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14428 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14428.cljs$core$IFn$_invoke$arity$8 ? fexpr__14428.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : fexpr__14428.call(null,a,b,c,d,e,f,g,h));
});
var cljs$core$fn_14419__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14429 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14429.cljs$core$IFn$_invoke$arity$9 ? fexpr__14429.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : fexpr__14429.call(null,a,b,c,d,e,f,g,h,i));
});
var cljs$core$fn_14419__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14430 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14430.cljs$core$IFn$_invoke$arity$10 ? fexpr__14430.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : fexpr__14430.call(null,a,b,c,d,e,f,g,h,i,j));
});
var cljs$core$fn_14419__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14431 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14431.cljs$core$IFn$_invoke$arity$11 ? fexpr__14431.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : fexpr__14431.call(null,a,b,c,d,e,f,g,h,i,j,k));
});
var cljs$core$fn_14419__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14432 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14432.cljs$core$IFn$_invoke$arity$12 ? fexpr__14432.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : fexpr__14432.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});
var cljs$core$fn_14419__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14433 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14433.cljs$core$IFn$_invoke$arity$13 ? fexpr__14433.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : fexpr__14433.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});
var cljs$core$fn_14419__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14434 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14434.cljs$core$IFn$_invoke$arity$14 ? fexpr__14434.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : fexpr__14434.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});
var cljs$core$fn_14419__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14435 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14435.cljs$core$IFn$_invoke$arity$15 ? fexpr__14435.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : fexpr__14435.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});
var cljs$core$fn_14419__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14436 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14436.cljs$core$IFn$_invoke$arity$16 ? fexpr__14436.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : fexpr__14436.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});
var cljs$core$fn_14419__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14437 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14437.cljs$core$IFn$_invoke$arity$17 ? fexpr__14437.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : fexpr__14437.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});
var cljs$core$fn_14419__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14438 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14438.cljs$core$IFn$_invoke$arity$18 ? fexpr__14438.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : fexpr__14438.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});
var cljs$core$fn_14419__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14439 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14439.cljs$core$IFn$_invoke$arity$19 ? fexpr__14439.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : fexpr__14439.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});
var cljs$core$fn_14419__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14440 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14440.cljs$core$IFn$_invoke$arity$20 ? fexpr__14440.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : fexpr__14440.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});
var cljs$core$fn_14419__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)),a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
});
cljs$core$fn_14419 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return cljs$core$fn_14419__1.call(this,self__);
case 2:
return cljs$core$fn_14419__2.call(this,self__,a);
case 3:
return cljs$core$fn_14419__3.call(this,self__,a,b);
case 4:
return cljs$core$fn_14419__4.call(this,self__,a,b,c);
case 5:
return cljs$core$fn_14419__5.call(this,self__,a,b,c,d);
case 6:
return cljs$core$fn_14419__6.call(this,self__,a,b,c,d,e);
case 7:
return cljs$core$fn_14419__7.call(this,self__,a,b,c,d,e,f);
case 8:
return cljs$core$fn_14419__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return cljs$core$fn_14419__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return cljs$core$fn_14419__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return cljs$core$fn_14419__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return cljs$core$fn_14419__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return cljs$core$fn_14419__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return cljs$core$fn_14419__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return cljs$core$fn_14419__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return cljs$core$fn_14419__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return cljs$core$fn_14419__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return cljs$core$fn_14419__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return cljs$core$fn_14419__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return cljs$core$fn_14419__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return cljs$core$fn_14419__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return cljs$core$fn_14419__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_14419.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14419__1;
cljs$core$fn_14419.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14419__2;
cljs$core$fn_14419.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14419__3;
cljs$core$fn_14419.cljs$core$IFn$_invoke$arity$4 = cljs$core$fn_14419__4;
cljs$core$fn_14419.cljs$core$IFn$_invoke$arity$5 = cljs$core$fn_14419__5;
cljs$core$fn_14419.cljs$core$IFn$_invoke$arity$6 = cljs$core$fn_14419__6;
cljs$core$fn_14419.cljs$core$IFn$_invoke$arity$7 = cljs$core$fn_14419__7;
cljs$core$fn_14419.cljs$core$IFn$_invoke$arity$8 = cljs$core$fn_14419__8;
cljs$core$fn_14419.cljs$core$IFn$_invoke$arity$9 = cljs$core$fn_14419__9;
cljs$core$fn_14419.cljs$core$IFn$_invoke$arity$10 = cljs$core$fn_14419__10;
cljs$core$fn_14419.cljs$core$IFn$_invoke$arity$11 = cljs$core$fn_14419__11;
cljs$core$fn_14419.cljs$core$IFn$_invoke$arity$12 = cljs$core$fn_14419__12;
cljs$core$fn_14419.cljs$core$IFn$_invoke$arity$13 = cljs$core$fn_14419__13;
cljs$core$fn_14419.cljs$core$IFn$_invoke$arity$14 = cljs$core$fn_14419__14;
cljs$core$fn_14419.cljs$core$IFn$_invoke$arity$15 = cljs$core$fn_14419__15;
cljs$core$fn_14419.cljs$core$IFn$_invoke$arity$16 = cljs$core$fn_14419__16;
cljs$core$fn_14419.cljs$core$IFn$_invoke$arity$17 = cljs$core$fn_14419__17;
cljs$core$fn_14419.cljs$core$IFn$_invoke$arity$18 = cljs$core$fn_14419__18;
cljs$core$fn_14419.cljs$core$IFn$_invoke$arity$19 = cljs$core$fn_14419__19;
cljs$core$fn_14419.cljs$core$IFn$_invoke$arity$20 = cljs$core$fn_14419__20;
cljs$core$fn_14419.cljs$core$IFn$_invoke$arity$21 = cljs$core$fn_14419__21;
cljs$core$fn_14419.cljs$core$IFn$_invoke$arity$22 = cljs$core$fn_14419__22;
return cljs$core$fn_14419;
})()
);

(cljs.core.Var.prototype.apply = (function cljs$core$fn_14441(self__,args14411){
var self__ = this;
var self____$1 = this;
var args__10120__auto__ = cljs.core.aclone(args14411);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10120__auto__.length > (20)))?(function (){var G__14442 = args__10120__auto__.slice((0),(20));
G__14442.push(args__10120__auto__.slice((20)));

return G__14442;
})():args__10120__auto__)));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14443(){
var self__ = this;
var _ = this;
var fexpr__14444 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14444.cljs$core$IFn$_invoke$arity$0 ? fexpr__14444.cljs$core$IFn$_invoke$arity$0() : fexpr__14444.call(null));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14445(a){
var self__ = this;
var _ = this;
var fexpr__14446 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14446.cljs$core$IFn$_invoke$arity$1 ? fexpr__14446.cljs$core$IFn$_invoke$arity$1(a) : fexpr__14446.call(null,a));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14447(a,b){
var self__ = this;
var _ = this;
var fexpr__14448 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14448.cljs$core$IFn$_invoke$arity$2 ? fexpr__14448.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__14448.call(null,a,b));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14449(a,b,c){
var self__ = this;
var _ = this;
var fexpr__14450 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14450.cljs$core$IFn$_invoke$arity$3 ? fexpr__14450.cljs$core$IFn$_invoke$arity$3(a,b,c) : fexpr__14450.call(null,a,b,c));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14451(a,b,c,d){
var self__ = this;
var _ = this;
var fexpr__14452 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14452.cljs$core$IFn$_invoke$arity$4 ? fexpr__14452.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : fexpr__14452.call(null,a,b,c,d));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_14453(a,b,c,d,e){
var self__ = this;
var _ = this;
var fexpr__14454 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14454.cljs$core$IFn$_invoke$arity$5 ? fexpr__14454.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : fexpr__14454.call(null,a,b,c,d,e));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_14455(a,b,c,d,e,f){
var self__ = this;
var _ = this;
var fexpr__14456 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14456.cljs$core$IFn$_invoke$arity$6 ? fexpr__14456.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : fexpr__14456.call(null,a,b,c,d,e,f));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = (function cljs$core$fn_14457(a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
var fexpr__14458 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14458.cljs$core$IFn$_invoke$arity$7 ? fexpr__14458.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : fexpr__14458.call(null,a,b,c,d,e,f,g));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = (function cljs$core$fn_14459(a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
var fexpr__14460 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14460.cljs$core$IFn$_invoke$arity$8 ? fexpr__14460.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : fexpr__14460.call(null,a,b,c,d,e,f,g,h));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = (function cljs$core$fn_14461(a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
var fexpr__14462 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14462.cljs$core$IFn$_invoke$arity$9 ? fexpr__14462.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : fexpr__14462.call(null,a,b,c,d,e,f,g,h,i));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = (function cljs$core$fn_14463(a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
var fexpr__14464 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14464.cljs$core$IFn$_invoke$arity$10 ? fexpr__14464.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : fexpr__14464.call(null,a,b,c,d,e,f,g,h,i,j));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = (function cljs$core$fn_14465(a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
var fexpr__14466 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14466.cljs$core$IFn$_invoke$arity$11 ? fexpr__14466.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : fexpr__14466.call(null,a,b,c,d,e,f,g,h,i,j,k));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = (function cljs$core$fn_14467(a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
var fexpr__14468 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14468.cljs$core$IFn$_invoke$arity$12 ? fexpr__14468.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : fexpr__14468.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = (function cljs$core$fn_14469(a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
var fexpr__14470 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14470.cljs$core$IFn$_invoke$arity$13 ? fexpr__14470.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : fexpr__14470.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = (function cljs$core$fn_14471(a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
var fexpr__14472 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14472.cljs$core$IFn$_invoke$arity$14 ? fexpr__14472.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : fexpr__14472.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = (function cljs$core$fn_14473(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
var fexpr__14474 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14474.cljs$core$IFn$_invoke$arity$15 ? fexpr__14474.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : fexpr__14474.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = (function cljs$core$fn_14475(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
var fexpr__14476 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14476.cljs$core$IFn$_invoke$arity$16 ? fexpr__14476.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : fexpr__14476.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = (function cljs$core$fn_14477(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
var fexpr__14478 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14478.cljs$core$IFn$_invoke$arity$17 ? fexpr__14478.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : fexpr__14478.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = (function cljs$core$fn_14479(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
var fexpr__14480 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14480.cljs$core$IFn$_invoke$arity$18 ? fexpr__14480.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : fexpr__14480.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = (function cljs$core$fn_14481(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
var fexpr__14482 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14482.cljs$core$IFn$_invoke$arity$19 ? fexpr__14482.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : fexpr__14482.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = (function cljs$core$fn_14483(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
var fexpr__14484 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14484.cljs$core$IFn$_invoke$arity$20 ? fexpr__14484.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : fexpr__14484.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = (function cljs$core$fn_14485(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)),a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
}));

(cljs.core.Var.getBasis = (function cljs$core$fn_14486(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"sym","sym",195671222,null),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.Var.cljs$lang$type = true);

(cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var");

(cljs.core.Var.cljs$lang$ctorPrWriter = (function cljs$core$fn_14487(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/Var");
}));

/**
 * Positional factory function for cljs.core/Var.
 */
cljs.core.__GT_Var = (function cljs$core$__GT_Var(val,sym,_meta){
return (new cljs.core.Var(val,sym,_meta));
});



/**
 * Return true if x implements IIterable protocol.
 */
cljs.core.iterable_QMARK_ = (function cljs$core$iterable_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition1$ & (131072))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIterable$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
}
});
/**
 * Return true if x has a JavaScript iterator property
 */
cljs.core.js_iterable_QMARK_ = (function cljs$core$js_iterable_QMARK_(x){
return (((!((x == null)))) && ((!((x[cljs.core.ITER_SYMBOL] == null)))));
});
/**
 * Clone the supplied value which must implement ICloneable.
 */
cljs.core.clone = (function cljs$core$clone(value){
return cljs.core._clone(value);
});
/**
 * Return true if x implements ICloneable protocol.
 */
cljs.core.cloneable_QMARK_ = (function cljs$core$cloneable_QMARK_(value){
if((!((value == null)))){
if((((value.cljs$lang$protocol_mask$partition1$ & (8192))) || ((cljs.core.PROTOCOL_SENTINEL === value.cljs$core$ICloneable$)))){
return true;
} else {
if((!value.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
}
});
/**
 * Returns a seq on the collection. If the collection is
 *   empty, returns nil.  (seq nil) returns nil. seq also works on
 *   Strings.
 */
cljs.core.seq = (function cljs$core$seq(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$))))?true:false):false)){
return coll.cljs$core$ISeqable$_seq$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(typeof coll === 'string'){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(cljs.core.js_iterable_QMARK_(coll)){
return cljs.core.es6_iterator_seq(cljs.core.goog$module$goog$object.get.call(null,coll,cljs.core.ITER_SYMBOL).call(coll));
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,coll)){
return cljs.core._seq(coll);
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll)," is not ISeqable"].join('')));

}
}
}
}
}
}
});
/**
 * Returns the first item in the collection. Calls seq on its
 *   argument. If coll is nil, returns nil.
 */
cljs.core.first = (function cljs$core$first(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return coll.cljs$core$ISeq$_first$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if((s == null)){
return null;
} else {
return cljs.core._first(s);
}
}
}
});
/**
 * Returns a possibly empty seq of the items after the first. Calls seq on its
 *   argument.
 */
cljs.core.rest = (function cljs$core$rest(coll){
if((!((coll == null)))){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return coll.cljs$core$ISeq$_rest$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if(s){
return s.cljs$core$ISeq$_rest$arity$1(null);
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a seq of the items after the first. Calls seq on its
 *   argument.  If there are no more items, returns nil
 */
cljs.core.next = (function cljs$core$next(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$))))?true:false):false)){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
}
});
/**
 * Equality. Returns true if x equals y, false if not. Compares
 *   numbers and collections in a type-independent manner.  Clojure's immutable data
 *   structures define -equiv (and thus =) as a value, not an identity,
 *   comparison.
 */
cljs.core._EQ_ = (function cljs$core$_EQ_(var_args){
var G__14498 = arguments.length;
switch (G__14498) {
case 1:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___14504 = arguments.length;
var i__10847__auto___14505 = (0);
while(true){
if((i__10847__auto___14505 < len__10846__auto___14504)){
args_arr__10875__auto__.push((arguments[i__10847__auto___14505]));

var G__14506 = (i__10847__auto___14505 + (1));
i__10847__auto___14505 = G__14506;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14499(x){
return true;
}));

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14500(x,y){
if((x == null)){
return (y == null);
} else {
return (((x === y)) || (cljs.core._equiv(x,y)));
}
}));

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14501(x,y,more){
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__14507 = y;
var G__14508 = cljs.core.first(more);
var G__14509 = cljs.core.next(more);
x = G__14507;
y = G__14508;
more = G__14509;
continue;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._EQ_.cljs$lang$applyTo = (function cljs$core$fn_14502(seq14495){
var G__14496 = cljs.core.first(seq14495);
var seq14495__$1 = cljs.core.next(seq14495);
var G__14497 = cljs.core.first(seq14495__$1);
var seq14495__$2 = cljs.core.next(seq14495__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14496,G__14497,seq14495__$2);
}));

(cljs.core._EQ_.cljs$lang$maxFixedArity = (2));


/**
* @constructor
*/
cljs.core.ES6Iterator = (function (s){
this.s = s;
});
(cljs.core.ES6Iterator.prototype.next = (function cljs$core$fn_14510(){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var x = cljs.core.first(self__.s);
(self__.s = cljs.core.next(self__.s));

return ({"value": x, "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6Iterator.getBasis = (function cljs$core$fn_14511(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6Iterator.cljs$lang$type = true);

(cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator");

(cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_14512(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/ES6Iterator");
}));

/**
 * Positional factory function for cljs.core/ES6Iterator.
 */
cljs.core.__GT_ES6Iterator = (function cljs$core$__GT_ES6Iterator(s){
return (new cljs.core.ES6Iterator(s));
});

/**
 * Return a ES2015+ compatible iterator for coll.
 */
cljs.core.es6_iterator = (function cljs$core$es6_iterator(coll){
return (new cljs.core.ES6Iterator(cljs.core.seq(coll)));
});

/**
* @constructor
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
*/
cljs.core.ES6IteratorSeq = (function (value,iter,_rest){
this.value = value;
this.iter = iter;
this._rest = _rest;
this.cljs$lang$protocol_mask$partition0$ = 8388672;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_14513(this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_14514(_){
var self__ = this;
var ___$1 = this;
return self__.value;
}));

(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_14515(_){
var self__ = this;
var ___$1 = this;
if((self__._rest == null)){
(self__._rest = cljs.core.es6_iterator_seq(self__.iter));
} else {
}

return self__._rest;
}));

(cljs.core.ES6IteratorSeq.getBasis = (function cljs$core$fn_14516(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"value","value",1946509744,null),new cljs.core.Symbol(null,"iter","iter",-1346195486,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_rest","_rest",-2100466189,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6IteratorSeq.cljs$lang$type = true);

(cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq");

(cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_14517(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/ES6IteratorSeq");
}));

/**
 * Positional factory function for cljs.core/ES6IteratorSeq.
 */
cljs.core.__GT_ES6IteratorSeq = (function cljs$core$__GT_ES6IteratorSeq(value,iter,_rest){
return (new cljs.core.ES6IteratorSeq(value,iter,_rest));
});

/**
 * Given an ES2015+ compatible iterator return a seq.
 */
cljs.core.es6_iterator_seq = (function cljs$core$es6_iterator_seq(iter){
var v = iter.next();
if(cljs.core.truth_(v.done)){
return null;
} else {
return (new cljs.core.ES6IteratorSeq(v.value,iter,null));
}
});
/**
 * Mix final collection hash for ordered or unordered collections.
 * hash-basis is the combined collection hash, count is the number
 * of elements included in the basis. Note this is the hash code
 * consistent with =, different from .hashCode.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.mix_collection_hash = (function cljs$core$mix_collection_hash(hash_basis,count){
var h1 = cljs.core.m3_seed;
var k1 = cljs.core.m3_mix_K1(hash_basis);
var h1__$1 = cljs.core.m3_mix_H1(h1,k1);
return cljs.core.m3_fmix(h1__$1,count);
});
/**
 * Returns the hash code, consistent with =, for an external ordered
 * collection implementing Iterable.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_ordered_coll = (function cljs$core$hash_ordered_coll(coll){
var n = (0);
var hash_code = (1);
var coll__$1 = cljs.core.seq(coll);
while(true){
if((!((coll__$1 == null)))){
var G__14518 = (n + (1));
var G__14519 = ((cljs.core.imul((31),hash_code) + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__14520 = cljs.core.next(coll__$1);
n = G__14518;
hash_code = G__14519;
coll__$1 = G__14520;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash((1),(0));
/**
 * Returns the hash code, consistent with =, for an external unordered
 * collection implementing Iterable. For maps, the iterator should
 * return map entries whose hash is computed as
 *   (hash-ordered-coll [k v]).
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_unordered_coll = (function cljs$core$hash_unordered_coll(coll){
var n = (0);
var hash_code = (0);
var coll__$1 = cljs.core.seq(coll);
while(true){
if((!((coll__$1 == null)))){
var G__14521 = (n + (1));
var G__14522 = ((hash_code + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__14523 = cljs.core.next(coll__$1);
n = G__14521;
hash_code = G__14522;
coll__$1 = G__14523;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash((0),(0));


(cljs.core.ICounted["null"] = true);

(cljs.core._count["null"] = (function cljs$core$fn_14524(_){
return (0);
}));
(Date.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_14525(o,other){
var o__$1 = this;
return (((other instanceof Date)) && ((o__$1.valueOf() === other.valueOf())));
}));

(Date.prototype.cljs$core$IComparable$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$IComparable$_compare$arity$2 = (function cljs$core$fn_14526(this$,other){
var this$__$1 = this;
if((other instanceof Date)){
var G__14527 = this$__$1.valueOf();
var G__14528 = other.valueOf();
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__14527,G__14528);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(this$__$1)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(other)].join('')));
}
}));

/**
 * @interface
 */
cljs.core.Inst = function(){};

var cljs$core$Inst$inst_ms_STAR_$dyn_14530 = (function cljs$core$fn_14529(inst){
var x__10266__auto__ = (((inst == null))?null:inst);
var m__10267__auto__ = (cljs.core.inst_ms_STAR_[goog.typeOf(x__10266__auto__)]);
if((!((m__10267__auto__ == null)))){
return (m__10267__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10267__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__10267__auto__.call(null,inst));
} else {
var m__10265__auto__ = (cljs.core.inst_ms_STAR_["_"]);
if((!((m__10265__auto__ == null)))){
return (m__10265__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10265__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__10265__auto__.call(null,inst));
} else {
throw cljs.core.missing_protocol("Inst.inst-ms*",inst);
}
}
});
cljs.core.inst_ms_STAR_ = (function cljs$core$inst_ms_STAR_(inst){
if((((!((inst == null)))) && ((!((inst.cljs$core$Inst$inst_ms_STAR_$arity$1 == null)))))){
return inst.cljs$core$Inst$inst_ms_STAR_$arity$1(inst);
} else {
return cljs$core$Inst$inst_ms_STAR_$dyn_14530(inst);
}
});

(Date.prototype.cljs$core$Inst$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$Inst$inst_ms_STAR_$arity$1 = (function cljs$core$fn_14531(inst){
var inst__$1 = this;
return inst__$1.getTime();
}));
/**
 * Return the number of milliseconds since January 1, 1970, 00:00:00 GMT
 */
cljs.core.inst_ms = (function cljs$core$inst_ms(inst){
return cljs.core.inst_ms_STAR_(inst);
});
/**
 * Return true if x satisfies Inst
 */
cljs.core.inst_QMARK_ = (function cljs$core$inst_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$Inst$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);
}
});
(cljs.core.IEquiv["number"] = true);

(cljs.core._equiv["number"] = (function cljs$core$fn_14533(x,o){
return (x === o);
}));
(cljs.core.Fn["function"] = true);

(cljs.core.IMeta["function"] = true);

(cljs.core._meta["function"] = (function cljs$core$fn_14534(_){
return null;
}));
(cljs.core.IHash["_"] = true);

(cljs.core._hash["_"] = (function cljs$core$fn_14535(o){
return goog.getUid(o);
}));
/**
 * Returns a number one greater than num.
 */
cljs.core.inc = (function cljs$core$inc(x){
return (x + (1));
});

/**
* @constructor
 * @implements {cljs.core.IDeref}
*/
cljs.core.Reduced = (function (val){
this.val = val;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = (function cljs$core$fn_14536(o){
var self__ = this;
var o__$1 = this;
return self__.val;
}));

(cljs.core.Reduced.getBasis = (function cljs$core$fn_14537(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null)], null);
}));

(cljs.core.Reduced.cljs$lang$type = true);

(cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced");

(cljs.core.Reduced.cljs$lang$ctorPrWriter = (function cljs$core$fn_14538(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/Reduced");
}));

/**
 * Positional factory function for cljs.core/Reduced.
 */
cljs.core.__GT_Reduced = (function cljs$core$__GT_Reduced(val){
return (new cljs.core.Reduced(val));
});

/**
 * Wraps x in a way such that a reduce will terminate with the value x
 */
cljs.core.reduced = (function cljs$core$reduced(x){
return (new cljs.core.Reduced(x));
});
/**
 * Returns true if x is the result of a call to reduced
 */
cljs.core.reduced_QMARK_ = (function cljs$core$reduced_QMARK_(r){
return (r instanceof cljs.core.Reduced);
});
/**
 * If x is already reduced?, returns it, else returns (reduced x)
 */
cljs.core.ensure_reduced = (function cljs$core$ensure_reduced(x){
if(cljs.core.reduced_QMARK_(x)){
return x;
} else {
return cljs.core.reduced(x);
}
});
/**
 * If x is reduced?, returns (deref x), else returns x
 */
cljs.core.unreduced = (function cljs$core$unreduced(x){
if(cljs.core.reduced_QMARK_(x)){
return cljs.core.deref(x);
} else {
return x;
}
});
/**
 * Also reader macro: @var/@atom/@delay. Returns the
 * most-recently-committed value of ref. When applied to a var
 * or atom, returns its current state. When applied to a delay, forces
 * it if not already forced. See also - realized?.
 */
cljs.core.deref = (function cljs$core$deref(o){
return cljs.core._deref(o);
});
/**
 * Accepts any collection which satisfies the ICount and IIndexed protocols and
 * reduces them without incurring seq initialization
 */
cljs.core.ci_reduce = (function cljs$core$ci_reduce(var_args){
var G__14540 = arguments.length;
switch (G__14540) {
case 2:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14541(cicoll,f){
var cnt = cicoll.cljs$core$ICounted$_count$arity$1(null);
if((cnt === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = cicoll.cljs$core$IIndexed$_nth$arity$2(null,(0));
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__14542 = val;
var G__14543 = cicoll.cljs$core$IIndexed$_nth$arity$2(null,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14542,G__14543) : f.call(null,G__14542,G__14543));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14548 = nval;
var G__14549 = (n + (1));
val = G__14548;
n = G__14549;
continue;
}
} else {
return val;
}
break;
}
}
}));

(cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14544(cicoll,f,val){
var cnt = cicoll.cljs$core$ICounted$_count$arity$1(null);
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__14545 = val__$1;
var G__14546 = cicoll.cljs$core$IIndexed$_nth$arity$2(null,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14545,G__14546) : f.call(null,G__14545,G__14546));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14550 = nval;
var G__14551 = (n + (1));
val__$1 = G__14550;
n = G__14551;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.ci_reduce.cljs$lang$maxFixedArity = 3);

cljs.core.array_reduce = (function cljs$core$array_reduce(var_args){
var G__14553 = arguments.length;
switch (G__14553) {
case 2:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14554(arr,f){
var cnt = arr.length;
if((arr.length === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = (arr[(0)]);
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__14555 = val;
var G__14556 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14555,G__14556) : f.call(null,G__14555,G__14556));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14564 = nval;
var G__14565 = (n + (1));
val = G__14564;
n = G__14565;
continue;
}
} else {
return val;
}
break;
}
}
}));

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14557(arr,f,val){
var cnt = arr.length;
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__14558 = val__$1;
var G__14559 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14558,G__14559) : f.call(null,G__14558,G__14559));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14566 = nval;
var G__14567 = (n + (1));
val__$1 = G__14566;
n = G__14567;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14560(arr,f,val,idx){
var cnt = arr.length;
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__14561 = val__$1;
var G__14562 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14561,G__14562) : f.call(null,G__14561,G__14562));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14568 = nval;
var G__14569 = (n + (1));
val__$1 = G__14568;
n = G__14569;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.array_reduce.cljs$lang$maxFixedArity = 4);







/**
 * Returns true if coll implements count in constant time
 */
cljs.core.counted_QMARK_ = (function cljs$core$counted_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICounted$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
}
});
/**
 * Returns true if coll implements nth in constant time
 */
cljs.core.indexed_QMARK_ = (function cljs$core$indexed_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIndexed$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
}
});
cljs.core._indexOf = (function cljs$core$_indexOf(var_args){
var G__14573 = arguments.length;
switch (G__14573) {
case 2:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14574(coll,x){
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
}));

(cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14575(coll,x,start){
var len = cljs.core.count(coll);
if((start >= len)){
return (-1);
} else {
var idx = (((start > (0)))?start:(((start < (0)))?(function (){var x__9874__auto__ = (0);
var y__9875__auto__ = (start + len);
return ((x__9874__auto__ > y__9875__auto__) ? x__9874__auto__ : y__9875__auto__);
})():start
));
while(true){
if((idx < len)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx),x)){
return idx;
} else {
var G__14577 = (idx + (1));
idx = G__14577;
continue;
}
} else {
return (-1);
}
break;
}
}
}));

(cljs.core._indexOf.cljs$lang$maxFixedArity = 3);

cljs.core._lastIndexOf = (function cljs$core$_lastIndexOf(var_args){
var G__14579 = arguments.length;
switch (G__14579) {
case 2:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14580(coll,x){
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
}));

(cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14581(coll,x,start){
var len = cljs.core.count(coll);
if((len === (0))){
return (-1);
} else {
var idx = (((start > (0)))?(function (){var x__9881__auto__ = (len - (1));
var y__9882__auto__ = start;
return ((x__9881__auto__ < y__9882__auto__) ? x__9881__auto__ : y__9882__auto__);
})():(((start < (0)))?(len + start):start
));
while(true){
if((idx >= (0))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx),x)){
return idx;
} else {
var G__14583 = (idx - (1));
idx = G__14583;
continue;
}
} else {
return (-1);
}
break;
}
}
}));

(cljs.core._lastIndexOf.cljs$lang$maxFixedArity = 3);


/**
* @constructor
*/
cljs.core.IndexedSeqIterator = (function (arr,i){
this.arr = arr;
this.i = i;
});
(cljs.core.IndexedSeqIterator.prototype.hasNext = (function cljs$core$fn_14584(){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
}));

(cljs.core.IndexedSeqIterator.prototype.next = (function cljs$core$fn_14585(){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.IndexedSeqIterator.getBasis = (function cljs$core$fn_14586(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.IndexedSeqIterator.cljs$lang$type = true);

(cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator");

(cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_14587(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/IndexedSeqIterator");
}));

/**
 * Positional factory function for cljs.core/IndexedSeqIterator.
 */
cljs.core.__GT_IndexedSeqIterator = (function cljs$core$__GT_IndexedSeqIterator(arr,i){
return (new cljs.core.IndexedSeqIterator(arr,i));
});


/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.IndexedSeq = (function (arr,i,meta){
this.arr = arr;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 166592766;
this.cljs$lang$protocol_mask$partition1$ = 401408;
});
(cljs.core.IndexedSeq.prototype.toString = (function cljs$core$fn_14588(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.IndexedSeq.prototype.equiv = (function cljs$core$fn_14589(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.IndexedSeq.prototype.indexOf = (function() {
var cljs$core$fn_14590 = null;
var cljs$core$fn_14590__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_14590__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_14590 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_14590__1.call(this,x);
case 2:
return cljs$core$fn_14590__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14590.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14590__1;
cljs$core$fn_14590.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14590__2;
return cljs$core$fn_14590;
})()
);

(cljs.core.IndexedSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_14591 = null;
var cljs$core$fn_14591__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_14591__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_14591 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_14591__1.call(this,x);
case 2:
return cljs$core$fn_14591__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14591.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14591__1;
cljs$core$fn_14591.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14591__2;
return cljs$core$fn_14591;
})()
);

(cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_14592(coll,n){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if(((((0) <= i__$1)) && ((i__$1 < self__.arr.length)))){
return (self__.arr[i__$1]);
} else {
throw (new Error("Index out of bounds"));
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_14593(coll,n,not_found){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if(((((0) <= i__$1)) && ((i__$1 < self__.arr.length)))){
return (self__.arr[i__$1]);
} else {
return not_found;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_14594(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_14595(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_14596(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i,self__.meta));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_14597(_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_14598(_){
var self__ = this;
var ___$1 = this;
var x__9874__auto__ = (0);
var y__9875__auto__ = (self__.arr.length - self__.i);
return ((x__9874__auto__ > y__9875__auto__) ? x__9874__auto__ : y__9875__auto__);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_14599(coll){
var self__ = this;
var coll__$1 = this;
var c = coll__$1.cljs$core$ICounted$_count$arity$1(null);
if((c > (0))){
return (new cljs.core.RSeq(coll__$1,(c - (1)),null));
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_14600(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_14601(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_14602(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_14603(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_14604(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_14605(_){
var self__ = this;
var ___$1 = this;
return (self__.arr[self__.i]);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_14606(_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_14607(this$){
var self__ = this;
var this$__$1 = this;
if((self__.i < self__.arr.length)){
return this$__$1;
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_14608(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.IndexedSeq(self__.arr,self__.i,new_meta));
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_14609(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IDrop$_drop$arity$2 = (function cljs$core$fn_14610(coll,n){
var self__ = this;
var coll__$1 = this;
if((n > (0))){
if(((self__.i + n) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + n),null));
} else {
return null;
}
} else {
return coll__$1;
}
}));

(cljs.core.IndexedSeq.getBasis = (function cljs$core$fn_14611(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.IndexedSeq.cljs$lang$type = true);

(cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq");

(cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_14612(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/IndexedSeq");
}));

/**
 * Positional factory function for cljs.core/IndexedSeq.
 */
cljs.core.__GT_IndexedSeq = (function cljs$core$__GT_IndexedSeq(arr,i,meta){
return (new cljs.core.IndexedSeq(arr,i,meta));
});

(cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_14613(){
var this__10707__auto__ = this;
return cljs.core.es6_iterator(this__10707__auto__);
}));
/**
 * Create seq from a primitive JavaScript Array-like.
 */
cljs.core.prim_seq = (function cljs$core$prim_seq(var_args){
var G__14615 = arguments.length;
switch (G__14615) {
case 1:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14616(prim){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim,(0));
}));

(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14617(prim,i){
if((i < prim.length)){
return (new cljs.core.IndexedSeq(prim,i,null));
} else {
return null;
}
}));

(cljs.core.prim_seq.cljs$lang$maxFixedArity = 2);

/**
 * Create a seq from a JavaScript array.
 */
cljs.core.array_seq = (function cljs$core$array_seq(var_args){
var G__14620 = arguments.length;
switch (G__14620) {
case 1:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14621(array){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,(0));
}));

(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14622(array,i){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i);
}));

(cljs.core.array_seq.cljs$lang$maxFixedArity = 2);



/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RSeq = (function (ci,i,meta){
this.ci = ci;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.RSeq.prototype.toString = (function cljs$core$fn_14624(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.RSeq.prototype.equiv = (function cljs$core$fn_14625(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.RSeq.prototype.indexOf = (function() {
var cljs$core$fn_14626 = null;
var cljs$core$fn_14626__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_14626__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_14626 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_14626__1.call(this,x);
case 2:
return cljs$core$fn_14626__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14626.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14626__1;
cljs$core$fn_14626.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14626__2;
return cljs$core$fn_14626;
})()
);

(cljs.core.RSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_14627 = null;
var cljs$core$fn_14627__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_14627__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_14627 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_14627__1.call(this,x);
case 2:
return cljs$core$fn_14627__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14627.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14627__1;
cljs$core$fn_14627.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14627__2;
return cljs$core$fn_14627;
})()
);

(cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_14628(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_14629(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));
}));

(cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_14630(coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return null;
}
}));

(cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_14631(coll){
var self__ = this;
var coll__$1 = this;
return (self__.i + (1));
}));

(cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_14632(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_14633(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_14634(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_14635(col,f){
var self__ = this;
var col__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,col__$1);
}));

(cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_14636(col,f,start){
var self__ = this;
var col__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,col__$1);
}));

(cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_14637(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci,self__.i);
}));

(cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_14638(coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_14639(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_14640(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.RSeq(self__.ci,self__.i,new_meta));
}
}));

(cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_14641(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.RSeq.getBasis = (function cljs$core$fn_14642(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ci","ci",2049808339,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.RSeq.cljs$lang$type = true);

(cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq");

(cljs.core.RSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_14643(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/RSeq");
}));

/**
 * Positional factory function for cljs.core/RSeq.
 */
cljs.core.__GT_RSeq = (function cljs$core$__GT_RSeq(ci,i,meta){
return (new cljs.core.RSeq(ci,i,meta));
});

(cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_14644(){
var this__10707__auto__ = this;
return cljs.core.es6_iterator(this__10707__auto__);
}));
/**
 * Same as (first (next x))
 */
cljs.core.second = (function cljs$core$second(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (first (first x))
 */
cljs.core.ffirst = (function cljs$core$ffirst(coll){
return cljs.core.first(cljs.core.first(coll));
});
/**
 * Same as (next (first x))
 */
cljs.core.nfirst = (function cljs$core$nfirst(coll){
return cljs.core.next(cljs.core.first(coll));
});
/**
 * Same as (first (next x))
 */
cljs.core.fnext = (function cljs$core$fnext(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (next (next x))
 */
cljs.core.nnext = (function cljs$core$nnext(coll){
return cljs.core.next(cljs.core.next(coll));
});
/**
 * Return the last item in coll, in linear time
 */
cljs.core.last = (function cljs$core$last(s){
while(true){
var sn = cljs.core.next(s);
if((!((sn == null)))){
var G__14645 = sn;
s = G__14645;
continue;
} else {
return cljs.core.first(s);
}
break;
}
});
(cljs.core.IEquiv["_"] = true);

(cljs.core._equiv["_"] = (function cljs$core$fn_14646(x,o){
return (x === o);
}));
/**
 * conj[oin]. Returns a new collection with the xs
 *   'added'. (conj nil item) returns (item).
 *   (conj coll) returns coll. (conj) returns [].
 *   The 'addition' may happen at different 'places' depending
 *   on the concrete type.
 */
cljs.core.conj = (function cljs$core$conj(var_args){
var G__14651 = arguments.length;
switch (G__14651) {
case 0:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___14658 = arguments.length;
var i__10847__auto___14659 = (0);
while(true){
if((i__10847__auto___14659 < len__10846__auto___14658)){
args_arr__10875__auto__.push((arguments[i__10847__auto___14659]));

var G__14660 = (i__10847__auto___14659 + (1));
i__10847__auto___14659 = G__14660;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14652(){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14653(coll){
return coll;
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14654(coll,x){
if((!((coll == null)))){
return cljs.core._conj(coll,x);
} else {
return (new cljs.core.List(null,x,null,(1),null));
}
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14655(coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__14661 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
var G__14662 = cljs.core.first(xs);
var G__14663 = cljs.core.next(xs);
coll = G__14661;
x = G__14662;
xs = G__14663;
continue;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
break;
}
}));

/** @this {Function} */
(cljs.core.conj.cljs$lang$applyTo = (function cljs$core$fn_14656(seq14648){
var G__14649 = cljs.core.first(seq14648);
var seq14648__$1 = cljs.core.next(seq14648);
var G__14650 = cljs.core.first(seq14648__$1);
var seq14648__$2 = cljs.core.next(seq14648__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14649,G__14650,seq14648__$2);
}));

(cljs.core.conj.cljs$lang$maxFixedArity = (2));

/**
 * Returns an empty collection of the same category as coll, or nil
 */
cljs.core.empty = (function cljs$core$empty(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IEmptyableCollection$))))?true:false):false)){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(null);
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IEmptyableCollection$))))?true:(((!coll.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IEmptyableCollection,coll):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IEmptyableCollection,coll))){
return cljs.core._empty(coll);
} else {
return null;

}
}
}
});
cljs.core.accumulating_seq_count = (function cljs$core$accumulating_seq_count(coll){
var s = cljs.core.seq(coll);
var acc = (0);
while(true){
if(cljs.core.counted_QMARK_(s)){
return (acc + cljs.core._count(s));
} else {
var G__14666 = cljs.core.next(s);
var G__14667 = (acc + (1));
s = G__14666;
acc = G__14667;
continue;
}
break;
}
});
/**
 * Returns the number of items in the collection. (count nil) returns
 *   0.  Also works on strings, arrays, and Maps
 */
cljs.core.count = (function cljs$core$count(coll){
if((!((coll == null)))){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ICounted$))))?true:false):false)){
return coll.cljs$core$ICounted$_count$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
return coll.length;
} else {
if(typeof coll === 'string'){
return coll.length;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$))))?true:false):false)){
return cljs.core.accumulating_seq_count(coll);
} else {
return cljs.core._count(coll);

}
}
}
}
} else {
return (0);
}
});
cljs.core.linear_traversal_nth = (function cljs$core$linear_traversal_nth(var_args){
var G__14671 = arguments.length;
switch (G__14671) {
case 2:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14672(coll,n){
while(true){
if((coll == null)){
throw (new Error("Index out of bounds"));
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.seq(coll)){
var G__14675 = cljs.core.next(coll);
var G__14676 = (n - (1));
coll = G__14675;
n = G__14676;
continue;
} else {
throw (new Error("Index out of bounds"));

}
}
}
}
break;
}
}));

(cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14673(coll,n,not_found){
while(true){
if((coll == null)){
return not_found;
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
return not_found;
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.seq(coll)){
var G__14677 = cljs.core.next(coll);
var G__14678 = (n - (1));
var G__14679 = not_found;
coll = G__14677;
n = G__14678;
not_found = G__14679;
continue;
} else {
return not_found;

}
}
}
}
break;
}
}));

(cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3);

/**
 * Returns the value at the index. get returns nil if index out of
 *   bounds, nth throws an exception unless not-found is supplied.  nth
 *   also works for strings, arrays, regex Matchers and Lists, and,
 *   in O(n) time, for sequences.
 */
cljs.core.nth = (function cljs$core$nth(var_args){
var G__14681 = arguments.length;
switch (G__14681) {
case 2:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14682(coll,n){
if((!(typeof n === 'number'))){
throw (new Error("Index argument to nth must be a number"));
} else {
if((coll == null)){
return coll;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$))))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
if(cljs.core.array_QMARK_(coll)){
if(((((-1) < n)) && ((n < coll.length)))){
return (coll[(n | (0))]);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(typeof coll === 'string'){
if(((((-1) < n)) && ((n < coll.length)))){
return coll.charAt((n | (0)));
} else {
throw (new Error("Index out of bounds"));
}
} else {
if((function (){var or__9517__auto__ = (((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false);
if(or__9517__auto__){
return or__9517__auto__;
} else {
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISequential$)))){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
if((n < (0))){
throw (new Error("Index out of bounds"));
} else {
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error(["nth not supported on this type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
}));

(cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14686(coll,n,not_found){
if((!(typeof n === 'number'))){
throw (new Error("Index argument to nth must be a number."));
} else {
if((coll == null)){
return not_found;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$))))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$3(null,n,not_found);
} else {
if(cljs.core.array_QMARK_(coll)){
if(((((-1) < n)) && ((n < coll.length)))){
return (coll[(n | (0))]);
} else {
return not_found;
}
} else {
if(typeof coll === 'string'){
if(((((-1) < n)) && ((n < coll.length)))){
return coll.charAt((n | (0)));
} else {
return not_found;
}
} else {
if((function (){var or__9517__auto__ = (((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false);
if(or__9517__auto__){
return or__9517__auto__;
} else {
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISequential$)))){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
if((n < (0))){
return not_found;
} else {
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
throw (new Error(["nth not supported on this type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
}));

(cljs.core.nth.cljs$lang$maxFixedArity = 3);

/**
 * Returns the nth rest of coll, coll when n is 0.
 */
cljs.core.nthrest = (function cljs$core$nthrest(coll,n){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition1$ & (262144))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IDrop$))))?true:false):false)){
if((n > (0))){
var or__9517__auto__ = coll.cljs$core$IDrop$_drop$arity$2(null,Math.ceil(n));
if(cljs.core.truth_(or__9517__auto__)){
return or__9517__auto__;
} else {
return cljs.core.List.EMPTY;
}
} else {
return coll;
}
} else {
var n__$1 = n;
var xs = coll;
while(true){
var temp__5718__auto__ = (((n__$1 > (0))) && (cljs.core.seq(xs)));
if(temp__5718__auto__){
var xs__$1 = temp__5718__auto__;
var G__14692 = (n__$1 - (1));
var G__14693 = cljs.core.rest(xs__$1);
n__$1 = G__14692;
xs = G__14693;
continue;
} else {
return xs;
}
break;
}
}
});
/**
 * Returns the value mapped to key, not-found or nil if key not present
 *   in associative collection, set, string, array, or ILookup instance.
 */
cljs.core.get = (function cljs$core$get(var_args){
var G__14695 = arguments.length;
switch (G__14695) {
case 2:
return cljs.core.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.get.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14696(o,k){
if((o == null)){
return null;
} else {
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$))))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$2(null,k);
} else {
if(cljs.core.array_QMARK_(o)){
if((((!((k == null)))) && ((k < o.length)))){
return (o[(k | (0))]);
} else {
return null;
}
} else {
if(typeof o === 'string'){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return o.charAt((k | (0)));
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o,k);
} else {
return null;

}
}
}
}
}
}));

(cljs.core.get.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14698(o,k,not_found){
if((!((o == null)))){
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$))))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
} else {
if(cljs.core.array_QMARK_(o)){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return (o[(k | (0))]);
} else {
return not_found;
}
} else {
if(typeof o === 'string'){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return o.charAt((k | (0)));
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
} else {
return not_found;

}
}
}
}
} else {
return not_found;
}
}));

(cljs.core.get.cljs$lang$maxFixedArity = 3);



/**
 * assoc[iate]. When applied to a map, returns a new map of the
 * same (hashed/sorted) type, that contains the mapping of key(s) to
 * val(s). When applied to a vector, returns a new vector that
 * contains val at index. Note - index must be <= (count vector).
 */
cljs.core.assoc = (function cljs$core$assoc(var_args){
var G__14706 = arguments.length;
switch (G__14706) {
case 3:
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___14712 = arguments.length;
var i__10847__auto___14713 = (0);
while(true){
if((i__10847__auto___14713 < len__10846__auto___14712)){
args_arr__10875__auto__.push((arguments[i__10847__auto___14713]));

var G__14714 = (i__10847__auto___14713 + (1));
i__10847__auto___14713 = G__14714;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((3) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((3)),(0),null)):null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10876__auto__);

}
});

(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14707(coll,k,v){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IAssociative$))))?true:false):false)){
return coll.cljs$core$IAssociative$_assoc$arity$3(null,k,v);
} else {
if((!((coll == null)))){
return cljs.core._assoc(coll,k,v);
} else {
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k,v]);
}
}
}));

(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14709(coll,k,v,kvs){
while(true){
var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);
if(cljs.core.truth_(kvs)){
var G__14715 = ret;
var G__14716 = cljs.core.first(kvs);
var G__14717 = cljs.core.second(kvs);
var G__14718 = cljs.core.nnext(kvs);
coll = G__14715;
k = G__14716;
v = G__14717;
kvs = G__14718;
continue;
} else {
return ret;
}
break;
}
}));

/** @this {Function} */
(cljs.core.assoc.cljs$lang$applyTo = (function cljs$core$fn_14710(seq14702){
var G__14703 = cljs.core.first(seq14702);
var seq14702__$1 = cljs.core.next(seq14702);
var G__14704 = cljs.core.first(seq14702__$1);
var seq14702__$2 = cljs.core.next(seq14702__$1);
var G__14705 = cljs.core.first(seq14702__$2);
var seq14702__$3 = cljs.core.next(seq14702__$2);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14703,G__14704,G__14705,seq14702__$3);
}));

(cljs.core.assoc.cljs$lang$maxFixedArity = (3));

/**
 * dissoc[iate]. Returns a new map of the same (hashed/sorted) type,
 *   that does not contain a mapping for key(s).
 */
cljs.core.dissoc = (function cljs$core$dissoc(var_args){
var G__14723 = arguments.length;
switch (G__14723) {
case 1:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___14729 = arguments.length;
var i__10847__auto___14730 = (0);
while(true){
if((i__10847__auto___14730 < len__10846__auto___14729)){
args_arr__10875__auto__.push((arguments[i__10847__auto___14730]));

var G__14731 = (i__10847__auto___14730 + (1));
i__10847__auto___14730 = G__14731;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14724(coll){
return coll;
}));

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14725(coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._dissoc(coll,k);
}
}));

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14726(coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__14732 = ret;
var G__14733 = cljs.core.first(ks);
var G__14734 = cljs.core.next(ks);
coll = G__14732;
k = G__14733;
ks = G__14734;
continue;
} else {
return ret;
}
}
break;
}
}));

/** @this {Function} */
(cljs.core.dissoc.cljs$lang$applyTo = (function cljs$core$fn_14727(seq14720){
var G__14721 = cljs.core.first(seq14720);
var seq14720__$1 = cljs.core.next(seq14720);
var G__14722 = cljs.core.first(seq14720__$1);
var seq14720__$2 = cljs.core.next(seq14720__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14721,G__14722,seq14720__$2);
}));

(cljs.core.dissoc.cljs$lang$maxFixedArity = (2));

/**
 * Return true if f is a JavaScript function or satisfies the Fn protocol.
 */
cljs.core.fn_QMARK_ = (function cljs$core$fn_QMARK_(f){
var or__9517__auto__ = typeof f === 'function';
if(or__9517__auto__){
return or__9517__auto__;
} else {
if((!((f == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$Fn$)))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
}
}
});

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.MetaFn = (function (afn,meta){
this.afn = afn;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 393217;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_14737(_){
var self__ = this;
var ___$1 = this;
return self__.meta;
}));

(cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_14738(_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.MetaFn(self__.afn,new_meta));
}));

(cljs.core.MetaFn.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.MetaFn.prototype.call = (function() {
var cljs$core$fn_14739 = null;
var cljs$core$fn_14739__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});
var cljs$core$fn_14739__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));
});
var cljs$core$fn_14739__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));
});
var cljs$core$fn_14739__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));
});
var cljs$core$fn_14739__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));
});
var cljs$core$fn_14739__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));
});
var cljs$core$fn_14739__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));
});
var cljs$core$fn_14739__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));
});
var cljs$core$fn_14739__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));
});
var cljs$core$fn_14739__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));
});
var cljs$core$fn_14739__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));
});
var cljs$core$fn_14739__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));
});
var cljs$core$fn_14739__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});
var cljs$core$fn_14739__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});
var cljs$core$fn_14739__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});
var cljs$core$fn_14739__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});
var cljs$core$fn_14739__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});
var cljs$core$fn_14739__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});
var cljs$core$fn_14739__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});
var cljs$core$fn_14739__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});
var cljs$core$fn_14739__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});
var cljs$core$fn_14739__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(self__.afn,a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
});
cljs$core$fn_14739 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return cljs$core$fn_14739__1.call(this,self__);
case 2:
return cljs$core$fn_14739__2.call(this,self__,a);
case 3:
return cljs$core$fn_14739__3.call(this,self__,a,b);
case 4:
return cljs$core$fn_14739__4.call(this,self__,a,b,c);
case 5:
return cljs$core$fn_14739__5.call(this,self__,a,b,c,d);
case 6:
return cljs$core$fn_14739__6.call(this,self__,a,b,c,d,e);
case 7:
return cljs$core$fn_14739__7.call(this,self__,a,b,c,d,e,f);
case 8:
return cljs$core$fn_14739__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return cljs$core$fn_14739__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return cljs$core$fn_14739__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return cljs$core$fn_14739__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return cljs$core$fn_14739__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return cljs$core$fn_14739__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return cljs$core$fn_14739__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return cljs$core$fn_14739__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return cljs$core$fn_14739__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return cljs$core$fn_14739__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return cljs$core$fn_14739__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return cljs$core$fn_14739__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return cljs$core$fn_14739__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return cljs$core$fn_14739__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return cljs$core$fn_14739__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_14739.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14739__1;
cljs$core$fn_14739.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14739__2;
cljs$core$fn_14739.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14739__3;
cljs$core$fn_14739.cljs$core$IFn$_invoke$arity$4 = cljs$core$fn_14739__4;
cljs$core$fn_14739.cljs$core$IFn$_invoke$arity$5 = cljs$core$fn_14739__5;
cljs$core$fn_14739.cljs$core$IFn$_invoke$arity$6 = cljs$core$fn_14739__6;
cljs$core$fn_14739.cljs$core$IFn$_invoke$arity$7 = cljs$core$fn_14739__7;
cljs$core$fn_14739.cljs$core$IFn$_invoke$arity$8 = cljs$core$fn_14739__8;
cljs$core$fn_14739.cljs$core$IFn$_invoke$arity$9 = cljs$core$fn_14739__9;
cljs$core$fn_14739.cljs$core$IFn$_invoke$arity$10 = cljs$core$fn_14739__10;
cljs$core$fn_14739.cljs$core$IFn$_invoke$arity$11 = cljs$core$fn_14739__11;
cljs$core$fn_14739.cljs$core$IFn$_invoke$arity$12 = cljs$core$fn_14739__12;
cljs$core$fn_14739.cljs$core$IFn$_invoke$arity$13 = cljs$core$fn_14739__13;
cljs$core$fn_14739.cljs$core$IFn$_invoke$arity$14 = cljs$core$fn_14739__14;
cljs$core$fn_14739.cljs$core$IFn$_invoke$arity$15 = cljs$core$fn_14739__15;
cljs$core$fn_14739.cljs$core$IFn$_invoke$arity$16 = cljs$core$fn_14739__16;
cljs$core$fn_14739.cljs$core$IFn$_invoke$arity$17 = cljs$core$fn_14739__17;
cljs$core$fn_14739.cljs$core$IFn$_invoke$arity$18 = cljs$core$fn_14739__18;
cljs$core$fn_14739.cljs$core$IFn$_invoke$arity$19 = cljs$core$fn_14739__19;
cljs$core$fn_14739.cljs$core$IFn$_invoke$arity$20 = cljs$core$fn_14739__20;
cljs$core$fn_14739.cljs$core$IFn$_invoke$arity$21 = cljs$core$fn_14739__21;
cljs$core$fn_14739.cljs$core$IFn$_invoke$arity$22 = cljs$core$fn_14739__22;
return cljs$core$fn_14739;
})()
);

(cljs.core.MetaFn.prototype.apply = (function cljs$core$fn_14740(self__,args14736){
var self__ = this;
var self____$1 = this;
var args__10120__auto__ = cljs.core.aclone(args14736);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10120__auto__.length > (20)))?(function (){var G__14741 = args__10120__auto__.slice((0),(20));
G__14741.push(args__10120__auto__.slice((20)));

return G__14741;
})():args__10120__auto__)));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14742(){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14743(a){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14744(a,b){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14745(a,b,c){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14746(a,b,c,d){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_14747(a,b,c,d,e){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_14748(a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function cljs$core$fn_14749(a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function cljs$core$fn_14750(a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function cljs$core$fn_14751(a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function cljs$core$fn_14752(a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function cljs$core$fn_14753(a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function cljs$core$fn_14754(a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function cljs$core$fn_14755(a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function cljs$core$fn_14756(a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function cljs$core$fn_14757(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function cljs$core$fn_14758(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function cljs$core$fn_14759(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function cljs$core$fn_14760(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function cljs$core$fn_14761(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function cljs$core$fn_14762(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function cljs$core$fn_14763(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(self__.afn,a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
}));

(cljs.core.MetaFn.getBasis = (function cljs$core$fn_14764(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.MetaFn.cljs$lang$type = true);

(cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn");

(cljs.core.MetaFn.cljs$lang$ctorPrWriter = (function cljs$core$fn_14765(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/MetaFn");
}));

/**
 * Positional factory function for cljs.core/MetaFn.
 */
cljs.core.__GT_MetaFn = (function cljs$core$__GT_MetaFn(afn,meta){
return (new cljs.core.MetaFn(afn,meta));
});

/**
 * Returns an object of the same type and value as obj, with
 *   map m as its metadata.
 */
cljs.core.with_meta = (function cljs$core$with_meta(o,meta){
if(typeof o === 'function'){
return (new cljs.core.MetaFn(o,meta));
} else {
if((o == null)){
return null;
} else {
return cljs.core._with_meta(o,meta);
}
}
});
/**
 * Returns the metadata of obj, returns nil if there is no metadata.
 */
cljs.core.meta = (function cljs$core$meta(o){
if((function (){var and__9511__auto__ = (!((o == null)));
if(and__9511__auto__){
if((!((o == null)))){
if((((o.cljs$lang$protocol_mask$partition0$ & (131072))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMeta$)))){
return true;
} else {
if((!o.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
}
} else {
return and__9511__auto__;
}
})()){
return cljs.core._meta(o);
} else {
return null;
}
});
/**
 * For a list or queue, same as first, for a vector, same as, but much
 *   more efficient than, last. If the collection is empty, returns nil.
 */
cljs.core.peek = (function cljs$core$peek(coll){
if((coll == null)){
return null;
} else {
return cljs.core._peek(coll);
}
});
/**
 * For a list or queue, returns a new list/queue without the first
 *   item, for a vector, returns a new vector without the last item.
 *   Note - not the same as next/butlast.
 */
cljs.core.pop = (function cljs$core$pop(coll){
if((coll == null)){
return null;
} else {
return cljs.core._pop(coll);
}
});
/**
 * disj[oin]. Returns a new set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj = (function cljs$core$disj(var_args){
var G__14771 = arguments.length;
switch (G__14771) {
case 1:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___14777 = arguments.length;
var i__10847__auto___14778 = (0);
while(true){
if((i__10847__auto___14778 < len__10846__auto___14777)){
args_arr__10875__auto__.push((arguments[i__10847__auto___14778]));

var G__14779 = (i__10847__auto___14778 + (1));
i__10847__auto___14778 = G__14779;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14772(coll){
return coll;
}));

(cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14773(coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._disjoin(coll,k);
}
}));

(cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14774(coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__14780 = ret;
var G__14781 = cljs.core.first(ks);
var G__14782 = cljs.core.next(ks);
coll = G__14780;
k = G__14781;
ks = G__14782;
continue;
} else {
return ret;
}
}
break;
}
}));

/** @this {Function} */
(cljs.core.disj.cljs$lang$applyTo = (function cljs$core$fn_14775(seq14768){
var G__14769 = cljs.core.first(seq14768);
var seq14768__$1 = cljs.core.next(seq14768);
var G__14770 = cljs.core.first(seq14768__$1);
var seq14768__$2 = cljs.core.next(seq14768__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14769,G__14770,seq14768__$2);
}));

(cljs.core.disj.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if coll has no items. To check the emptiness of a seq,
 *   please use the idiom (seq x) rather than (not (empty? x))
 */
cljs.core.empty_QMARK_ = (function cljs$core$empty_QMARK_(coll){
if((coll == null)){
return true;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ICounted$))))?true:(((!coll.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,coll):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,coll))){
return (cljs.core._count(coll) === (0));
} else {
return cljs.core.not(cljs.core.seq(coll));

}
}
});
/**
 * Returns true if x satisfies ICollection
 */
cljs.core.coll_QMARK_ = (function cljs$core$coll_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (8))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICollection$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
}
}
});
/**
 * Returns true if x satisfies ISet
 */
cljs.core.set_QMARK_ = (function cljs$core$set_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
}
}
});
/**
 * Returns true if coll implements IAssociative
 */
cljs.core.associative_QMARK_ = (function cljs$core$associative_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IAssociative$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
}
});
/**
 * Returns true if coll implements IFind
 */
cljs.core.ifind_QMARK_ = (function cljs$core$ifind_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IFind$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x);
}
});
/**
 * Returns true if coll satisfies ISequential
 */
cljs.core.sequential_QMARK_ = (function cljs$core$sequential_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
}
});
/**
 * Returns true if coll satisfies ISorted
 */
cljs.core.sorted_QMARK_ = (function cljs$core$sorted_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (268435456))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISorted$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
}
});
/**
 * Returns true if coll satisfies IReduce
 */
cljs.core.reduceable_QMARK_ = (function cljs$core$reduceable_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IReduce$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
}
});
/**
 * Return true if x satisfies IMap
 */
cljs.core.map_QMARK_ = (function cljs$core$map_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
}
}
});
/**
 * Return true if x satisfies IRecord
 */
cljs.core.record_QMARK_ = (function cljs$core$record_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (67108864))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IRecord$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
}
});
/**
 * Return true if x satisfies IVector
 */
cljs.core.vector_QMARK_ = (function cljs$core$vector_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16384))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IVector$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
}
});

/**
 * Return true if x satisfies IChunkedSeq.
 */
cljs.core.chunked_seq_QMARK_ = (function cljs$core$chunked_seq_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition1$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IChunkedSeq$)))){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Create JavaSript object from an even number arguments representing
 *   interleaved keys and values.
 */
cljs.core.js_obj = (function cljs$core$js_obj(var_args){
var G__14797 = arguments.length;
switch (G__14797) {
case 0:
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___14804 = arguments.length;
var i__10847__auto___14805 = (0);
while(true){
if((i__10847__auto___14805 < len__10846__auto___14804)){
args_arr__10875__auto__.push((arguments[i__10847__auto___14805]));

var G__14806 = (i__10847__auto___14805 + (1));
i__10847__auto___14805 = G__14806;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((0) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((0)),(0),null)):null);
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__10876__auto__);

}
});

(cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14798(){
return ({});
}));

(cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14801(keyvals){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.goog$module$goog$object.create,keyvals);
}));

/** @this {Function} */
(cljs.core.js_obj.cljs$lang$applyTo = (function cljs$core$fn_14802(seq14796){
var self__10832__auto__ = this;
return self__10832__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq14796));
}));

(cljs.core.js_obj.cljs$lang$maxFixedArity = (0));

/**
 * Return the JavaScript keys for an object.
 */
cljs.core.js_keys = (function cljs$core$js_keys(obj){
return cljs.core.goog$module$goog$object.getKeys.call(null,obj);
});
/**
 * Delete a property from a JavaScript object.
 *   Returns true upon success, false otherwise.
 */
cljs.core.js_delete = (function cljs$core$js_delete(obj,key){
return delete obj[key];
});
cljs.core.array_copy = (function cljs$core$array_copy(from,i,to,j,len){
var i__$1 = i;
var j__$1 = j;
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__14807 = (i__$1 + (1));
var G__14808 = (j__$1 + (1));
var G__14809 = (len__$1 - (1));
i__$1 = G__14807;
j__$1 = G__14808;
len__$1 = G__14809;
continue;
}
break;
}
});
cljs.core.array_copy_downward = (function cljs$core$array_copy_downward(from,i,to,j,len){
var i__$1 = (i + (len - (1)));
var j__$1 = (j + (len - (1)));
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__14810 = (i__$1 - (1));
var G__14811 = (j__$1 - (1));
var G__14812 = (len__$1 - (1));
i__$1 = G__14810;
j__$1 = G__14811;
len__$1 = G__14812;
continue;
}
break;
}
});
cljs.core.lookup_sentinel = ({});
/**
 * Returns true if x is the value false, false otherwise.
 */
cljs.core.false_QMARK_ = (function cljs$core$false_QMARK_(x){
return x === false;
});
/**
 * Returns true if x is the value true, false otherwise.
 */
cljs.core.true_QMARK_ = (function cljs$core$true_QMARK_(x){
return x === true;
});
/**
 * Return true if x is a Boolean
 */
cljs.core.boolean_QMARK_ = (function cljs$core$boolean_QMARK_(x){
return ((x === true) || (x === false));
});
/**
 * Returns true if x identical to the JavaScript undefined value.
 */
cljs.core.undefined_QMARK_ = (function cljs$core$undefined_QMARK_(x){
return (void 0 === x);
});
/**
 * Return true if s satisfies ISeq
 */
cljs.core.seq_QMARK_ = (function cljs$core$seq_QMARK_(s){
if((s == null)){
return false;
} else {
if((!((s == null)))){
if((((s.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeq$)))){
return true;
} else {
if((!s.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
}
}
});
/**
 * Return true if the seq function is supported for s
 */
cljs.core.seqable_QMARK_ = (function cljs$core$seqable_QMARK_(s){
var or__9517__auto__ = (s == null);
if(or__9517__auto__){
return or__9517__auto__;
} else {
var or__9517__auto____$1 = (((!((s == null))))?(((((s.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeqable$))))?true:(((!s.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s));
if(or__9517__auto____$1){
return or__9517__auto____$1;
} else {
return ((cljs.core.array_QMARK_(s)) || (typeof s === 'string'));
}
}
});
/**
 * Coerce to boolean
 */
cljs.core.boolean$ = (function cljs$core$boolean(x){
if((x == null)){
return false;
} else {
if(x === false){
return false;
} else {
return true;

}
}
});
/**
 * Returns true if f returns true for fn? or satisfies IFn.
 */
cljs.core.ifn_QMARK_ = (function cljs$core$ifn_QMARK_(f){
var or__9517__auto__ = cljs.core.fn_QMARK_(f);
if(or__9517__auto__){
return or__9517__auto__;
} else {
if((!((f == null)))){
if((((f.cljs$lang$protocol_mask$partition0$ & (1))) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$IFn$)))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
}
}
});
/**
 * Returns true if n is a JavaScript number with no decimal part.
 */
cljs.core.integer_QMARK_ = (function cljs$core$integer_QMARK_(n){
return ((typeof n === 'number') && ((((!(isNaN(n)))) && ((((!((n === Infinity)))) && ((parseFloat(n) === parseInt(n,(10)))))))));
});
/**
 * INTERNAL: do not use
 */
cljs.core.LongImpl = cljs.core.goog$module$goog$math$Long;
/**
 * Return true if x satisfies integer? or is an instance of goog.math.Integer
 * or goog.math.Long.
 */
cljs.core.int_QMARK_ = (function cljs$core$int_QMARK_(x){
return ((cljs.core.integer_QMARK_(x)) || ((((x instanceof goog.math.Integer)) || ((x instanceof cljs.core.goog$module$goog$math$Long)))));
});
/**
 * Return true if x satisfies int? and is positive.
 */
cljs.core.pos_int_QMARK_ = (function cljs$core$pos_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (x > (0));
} else {
if((x instanceof goog.math.Integer)){
return ((cljs.core.not(x.isNegative())) && (cljs.core.not(x.isZero())));
} else {
if((x instanceof cljs.core.goog$module$goog$math$Long)){
return ((cljs.core.not(x.isNegative())) && (cljs.core.not(x.isZero())));
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is negative.
 */
cljs.core.neg_int_QMARK_ = (function cljs$core$neg_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (x < (0));
} else {
if((x instanceof goog.math.Integer)){
return x.isNegative();
} else {
if((x instanceof cljs.core.goog$module$goog$math$Long)){
return x.isNegative();
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is a natural integer value.
 */
cljs.core.nat_int_QMARK_ = (function cljs$core$nat_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (!((x < (0))));
} else {
if((x instanceof goog.math.Integer)){
return cljs.core.not(x.isNegative());
} else {
if((x instanceof cljs.core.goog$module$goog$math$Long)){
return cljs.core.not(x.isNegative());
} else {
return false;

}
}
}
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.float_QMARK_ = (function cljs$core$float_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.double_QMARK_ = (function cljs$core$double_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for Infinity and -Infinity values.
 */
cljs.core.infinite_QMARK_ = (function cljs$core$infinite_QMARK_(x){
return (((x === Number.POSITIVE_INFINITY)) || ((x === Number.NEGATIVE_INFINITY)));
});
/**
 * Returns true if key is present in the given collection, otherwise
 *   returns false.  Note that for numerically indexed collections like
 *   vectors and arrays, this tests if the numeric key is within the
 *   range of indexes. 'contains?' operates constant or logarithmic time;
 *   it will not perform a linear search for a value.  See also 'some'.
 */
cljs.core.contains_QMARK_ = (function cljs$core$contains_QMARK_(coll,v){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IAssociative$))))?true:false):false)){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(null,v);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,coll)){
return cljs.core._contains_key_QMARK_(coll,v);
} else {
if((cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return false;
} else {
return true;

}
}
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core.find = (function cljs$core$find(coll,k){
if(cljs.core.ifind_QMARK_(coll)){
return cljs.core._find(coll,k);
} else {
if((((!((coll == null)))) && (((cljs.core.associative_QMARK_(coll)) && (cljs.core.contains_QMARK_(coll,k)))))){
return (new cljs.core.MapEntry(k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k),null));
} else {
return null;
}
}
});
/**
 * Returns true if no two of the arguments are =
 */
cljs.core.distinct_QMARK_ = (function cljs$core$distinct_QMARK_(var_args){
var G__14823 = arguments.length;
switch (G__14823) {
case 1:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___14829 = arguments.length;
var i__10847__auto___14830 = (0);
while(true){
if((i__10847__auto___14830 < len__10846__auto___14829)){
args_arr__10875__auto__.push((arguments[i__10847__auto___14830]));

var G__14831 = (i__10847__auto___14830 + (1));
i__10847__auto___14830 = G__14831;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14824(x){
return true;
}));

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14825(x,y){
return (!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)));
}));

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14826(x,y,more){
if((!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)))){
var s = cljs.core.PersistentHashSet.createAsIfByAssoc([x,y]);
var xs = more;
while(true){
var x__$1 = cljs.core.first(xs);
var etc = cljs.core.next(xs);
if(cljs.core.truth_(xs)){
if(cljs.core.contains_QMARK_(s,x__$1)){
return false;
} else {
var G__14832 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);
var G__14833 = etc;
s = G__14832;
xs = G__14833;
continue;
}
} else {
return true;
}
break;
}
} else {
return false;
}
}));

/** @this {Function} */
(cljs.core.distinct_QMARK_.cljs$lang$applyTo = (function cljs$core$fn_14827(seq14820){
var G__14821 = cljs.core.first(seq14820);
var seq14820__$1 = cljs.core.next(seq14820);
var G__14822 = cljs.core.first(seq14820__$1);
var seq14820__$2 = cljs.core.next(seq14820__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14821,G__14822,seq14820__$2);
}));

(cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = (2));

/**
 * Comparator. Returns a negative number, zero, or a positive number
 *   when x is logically 'less than', 'equal to', or 'greater than'
 *   y. Uses IComparable if available and google.array.defaultCompare for objects
 *  of the same type and special-cases nil to be less than any other object.
 */
cljs.core.compare = (function cljs$core$compare(x,y){
if((x === y)){
return (0);
} else {
if((x == null)){
return (-1);
} else {
if((y == null)){
return (1);
} else {
if(typeof x === 'number'){
if(typeof y === 'number'){
return cljs.core.goog$module$goog$array.defaultCompare.call(null,x,y);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join('')));
}
} else {
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition1$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IComparable$))))?true:(((!x.cljs$lang$protocol_mask$partition1$))?cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x))){
return cljs.core._compare(x,y);
} else {
if(((((typeof x === 'string') || (((cljs.core.array_QMARK_(x)) || (((x === true) || (x === false))))))) && ((cljs.core.type(x) === cljs.core.type(y))))){
return cljs.core.goog$module$goog$array.defaultCompare.call(null,x,y);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join('')));
}

}
}
}
}
}
});
/**
 * Compare indexed collection.
 */
cljs.core.compare_indexed = (function cljs$core$compare_indexed(var_args){
var G__14836 = arguments.length;
switch (G__14836) {
case 2:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14837(xs,ys){
var xl = cljs.core.count(xs);
var yl = cljs.core.count(ys);
if((xl < yl)){
return (-1);
} else {
if((xl > yl)){
return (1);
} else {
if((xl === (0))){
return (0);
} else {
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,(0));

}
}
}
}));

(cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14838(xs,ys,len,n){
while(true){
var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));
if((((d === (0))) && (((n + (1)) < len)))){
var G__14840 = xs;
var G__14841 = ys;
var G__14842 = len;
var G__14843 = (n + (1));
xs = G__14840;
ys = G__14841;
len = G__14842;
n = G__14843;
continue;
} else {
return d;
}
break;
}
}));

(cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4);

/**
 * Given a fn that might be boolean valued or a comparator,
 * return a fn that is a comparator.
 */
cljs.core.fn__GT_comparator = (function cljs$core$fn__GT_comparator(f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare)){
return cljs.core.compare;
} else {
return (function cljs$core$fn__GT_comparator_$_fn_14844(x,y){
var r = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
if(typeof r === 'number'){
return r;
} else {
if(cljs.core.truth_(r)){
return (-1);
} else {
if(cljs.core.truth_((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(y,x) : f.call(null,y,x)))){
return (1);
} else {
return (0);
}
}
}
});
}
});
/**
 * Returns a sorted sequence of the items in coll. Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort = (function cljs$core$sort(var_args){
var G__14846 = arguments.length;
switch (G__14846) {
case 1:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14847(coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll);
}));

(cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14848(comp,coll){
if(cljs.core.seq(coll)){
var a = cljs.core.to_array(coll);
var G__14849_14852 = a;
var G__14850_14853 = cljs.core.fn__GT_comparator(comp);
cljs.core.goog$module$goog$array.stableSort.call(null,G__14849_14852,G__14850_14853);

return cljs.core.with_meta(cljs.core.seq(a),cljs.core.meta(coll));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.sort.cljs$lang$maxFixedArity = 2);

/**
 * Returns a sorted sequence of the items in coll, where the sort
 * order is determined by comparing (keyfn item).  Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort_by = (function cljs$core$sort_by(var_args){
var G__14855 = arguments.length;
switch (G__14855) {
case 2:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14856(keyfn,coll){
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll);
}));

(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14857(keyfn,comp,coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function cljs$core$fn_14857_$_fn_14858(x,y){
var G__14860 = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(x) : keyfn.call(null,x));
var G__14861 = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(y) : keyfn.call(null,y));
var fexpr__14859 = cljs.core.fn__GT_comparator(comp);
return (fexpr__14859.cljs$core$IFn$_invoke$arity$2 ? fexpr__14859.cljs$core$IFn$_invoke$arity$2(G__14860,G__14861) : fexpr__14859.call(null,G__14860,G__14861));
}),coll);
}));

(cljs.core.sort_by.cljs$lang$maxFixedArity = 3);

cljs.core.seq_reduce = (function cljs$core$seq_reduce(var_args){
var G__14864 = arguments.length;
switch (G__14864) {
case 2:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14865(f,coll){
var temp__5718__auto__ = cljs.core.seq(coll);
if(temp__5718__auto__){
var s = temp__5718__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f,cljs.core.first(s),cljs.core.next(s));
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
}));

(cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14866(f,val,coll){
var val__$1 = val;
var coll__$1 = cljs.core.seq(coll);
while(true){
if(coll__$1){
var nval = (function (){var G__14867 = val__$1;
var G__14868 = cljs.core.first(coll__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14867,G__14868) : f.call(null,G__14867,G__14868));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14870 = nval;
var G__14871 = cljs.core.next(coll__$1);
val__$1 = G__14870;
coll__$1 = G__14871;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3);

/**
 * Return a random permutation of coll
 */
cljs.core.shuffle = (function cljs$core$shuffle(coll){
var a = cljs.core.to_array(coll);
cljs.core.goog$module$goog$array.shuffle.call(null,a);

return cljs.core.vec(a);
});
cljs.core.iter_reduce = (function cljs$core$iter_reduce(var_args){
var G__14873 = arguments.length;
switch (G__14873) {
case 2:
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14874(coll,f){
var iter = cljs.core._iterator(coll);
if(cljs.core.truth_(iter.hasNext())){
var init = iter.next();
var acc = init;
while(true){
if(iter.hasNext()){
var nacc = (function (){var G__14875 = acc;
var G__14876 = iter.next();
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14875,G__14876) : f.call(null,G__14875,G__14876));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__14881 = nacc;
acc = G__14881;
continue;
}
} else {
return acc;
}
break;
}
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
}));

(cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14877(coll,f,init){
var iter = cljs.core._iterator(coll);
var acc = init;
while(true){
if(iter.hasNext()){
var nacc = (function (){var G__14878 = acc;
var G__14879 = iter.next();
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14878,G__14879) : f.call(null,G__14878,G__14879));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__14882 = nacc;
acc = G__14882;
continue;
}
} else {
return acc;
}
break;
}
}));

(cljs.core.iter_reduce.cljs$lang$maxFixedArity = 3);

/**
 * f should be a function of 2 arguments. If val is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc. If coll contains no
 *   items, f must accept no arguments as well, and reduce returns the
 *   result of calling f with no arguments.  If coll has only 1 item, it
 *   is returned and f is not called.  If val is supplied, returns the
 *   result of applying f to val and the first item in coll, then
 *   applying f to that result and the 2nd item, etc. If coll contains no
 *   items, returns val and f is not called.
 */
cljs.core.reduce = (function cljs$core$reduce(var_args){
var G__14884 = arguments.length;
switch (G__14884) {
case 2:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14885(f,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$))))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$2(null,f);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll);

}
}
}
}
}
}));

(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14887(f,val,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$))))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$3(null,f,val);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll);

}
}
}
}
}
}));

(cljs.core.reduce.cljs$lang$maxFixedArity = 3);

/**
 * Reduces an associative collection. f should be a function of 3
 *   arguments. Returns the result of applying f to init, the first key
 *   and the first value in coll, then applying f to that result and the
 *   2nd key and value, etc. If coll contains no entries, returns init
 *   and f is not called. Note that reduce-kv is supported on vectors,
 *   where the keys will be the ordinals.
 */
cljs.core.reduce_kv = (function cljs$core$reduce_kv(f,init,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (1048576))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IKVReduce$))))?true:(((!coll.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,coll):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,coll))){
return cljs.core._kv_reduce(coll,f,init);
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function cljs$core$reduce_kv_$_fn_14891(ret,me){
var G__14892 = ret;
var G__14893 = cljs.core._key(me);
var G__14894 = cljs.core._val(me);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__14892,G__14893,G__14894) : f.call(null,G__14892,G__14893,G__14894));
}),init,coll);
}
});
/**
 * Returns its argument.
 */
cljs.core.identity = (function cljs$core$identity(x){
return x;
});
/**
 * Takes a reducing function f of 2 args and returns a fn suitable for
 *   transduce by adding an arity-1 signature that calls cf (default -
 *   identity) on the result argument.
 */
cljs.core.completing = (function cljs$core$completing(var_args){
var G__14896 = arguments.length;
switch (G__14896) {
case 1:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14897(f){
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity);
}));

(cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14898(f,cf){
return (function() {
var cljs$core$fn_14898_$_fn_14899 = null;
var cljs$core$fn_14898_$_fn_14899__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
var cljs$core$fn_14898_$_fn_14899__1 = (function (x){
return (cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(x) : cf.call(null,x));
});
var cljs$core$fn_14898_$_fn_14899__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
});
cljs$core$fn_14898_$_fn_14899 = function(x,y){
switch(arguments.length){
case 0:
return cljs$core$fn_14898_$_fn_14899__0.call(this);
case 1:
return cljs$core$fn_14898_$_fn_14899__1.call(this,x);
case 2:
return cljs$core$fn_14898_$_fn_14899__2.call(this,x,y);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14898_$_fn_14899.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_14898_$_fn_14899__0;
cljs$core$fn_14898_$_fn_14899.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14898_$_fn_14899__1;
cljs$core$fn_14898_$_fn_14899.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14898_$_fn_14899__2;
return cljs$core$fn_14898_$_fn_14899;
})()
}));

(cljs.core.completing.cljs$lang$maxFixedArity = 2);

/**
 * reduce with a transformation of f (xf). If init is not
 *   supplied, (f) will be called to produce it. f should be a reducing
 *   step function that accepts both 1 and 2 arguments, if it accepts
 *   only 2 you can add the arity-1 with 'completing'. Returns the result
 *   of applying (the transformed) xf to init and the first item in coll,
 *   then applying xf to that result and the 2nd item, etc. If coll
 *   contains no items, returns init and f is not called. Note that
 *   certain transforms may inject or skip items.
 */
cljs.core.transduce = (function cljs$core$transduce(var_args){
var G__14902 = arguments.length;
switch (G__14902) {
case 3:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14903(xform,f,coll){
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,f,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),coll);
}));

(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14904(xform,f,init,coll){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);
return (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(ret) : f__$1.call(null,ret));
}));

(cljs.core.transduce.cljs$lang$maxFixedArity = 4);

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core._PLUS_ = (function cljs$core$_PLUS_(var_args){
var G__14910 = arguments.length;
switch (G__14910) {
case 0:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___14917 = arguments.length;
var i__10847__auto___14918 = (0);
while(true){
if((i__10847__auto___14918 < len__10846__auto___14917)){
args_arr__10875__auto__.push((arguments[i__10847__auto___14918]));

var G__14919 = (i__10847__auto___14918 + (1));
i__10847__auto___14918 = G__14919;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14911(){
return (0);
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14912(x){
return x;
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14913(x,y){
return (x + y);
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14914(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(x + y),more);
}));

/** @this {Function} */
(cljs.core._PLUS_.cljs$lang$applyTo = (function cljs$core$fn_14915(seq14907){
var G__14908 = cljs.core.first(seq14907);
var seq14907__$1 = cljs.core.next(seq14907);
var G__14909 = cljs.core.first(seq14907__$1);
var seq14907__$2 = cljs.core.next(seq14907__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14908,G__14909,seq14907__$2);
}));

(cljs.core._PLUS_.cljs$lang$maxFixedArity = (2));

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core._ = (function cljs$core$_(var_args){
var G__14924 = arguments.length;
switch (G__14924) {
case 1:
return cljs.core._.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___14930 = arguments.length;
var i__10847__auto___14931 = (0);
while(true){
if((i__10847__auto___14931 < len__10846__auto___14930)){
args_arr__10875__auto__.push((arguments[i__10847__auto___14931]));

var G__14932 = (i__10847__auto___14931 + (1));
i__10847__auto___14931 = G__14932;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core._.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14925(x){
return (- x);
}));

(cljs.core._.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14926(x,y){
return (x - y);
}));

(cljs.core._.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14927(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,(x - y),more);
}));

/** @this {Function} */
(cljs.core._.cljs$lang$applyTo = (function cljs$core$fn_14928(seq14921){
var G__14922 = cljs.core.first(seq14921);
var seq14921__$1 = cljs.core.next(seq14921);
var G__14923 = cljs.core.first(seq14921__$1);
var seq14921__$2 = cljs.core.next(seq14921__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14922,G__14923,seq14921__$2);
}));

(cljs.core._.cljs$lang$maxFixedArity = (2));

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core._STAR_ = (function cljs$core$_STAR_(var_args){
var G__14937 = arguments.length;
switch (G__14937) {
case 0:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___14944 = arguments.length;
var i__10847__auto___14945 = (0);
while(true){
if((i__10847__auto___14945 < len__10846__auto___14944)){
args_arr__10875__auto__.push((arguments[i__10847__auto___14945]));

var G__14946 = (i__10847__auto___14945 + (1));
i__10847__auto___14945 = G__14946;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14938(){
return (1);
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14939(x){
return x;
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14940(x,y){
return (x * y);
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14941(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,(x * y),more);
}));

/** @this {Function} */
(cljs.core._STAR_.cljs$lang$applyTo = (function cljs$core$fn_14942(seq14934){
var G__14935 = cljs.core.first(seq14934);
var seq14934__$1 = cljs.core.next(seq14934);
var G__14936 = cljs.core.first(seq14934__$1);
var seq14934__$2 = cljs.core.next(seq14934__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14935,G__14936,seq14934__$2);
}));

(cljs.core._STAR_.cljs$lang$maxFixedArity = (2));

/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core._SLASH_ = (function cljs$core$_SLASH_(var_args){
var G__14951 = arguments.length;
switch (G__14951) {
case 1:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___14957 = arguments.length;
var i__10847__auto___14958 = (0);
while(true){
if((i__10847__auto___14958 < len__10846__auto___14957)){
args_arr__10875__auto__.push((arguments[i__10847__auto___14958]));

var G__14959 = (i__10847__auto___14958 + (1));
i__10847__auto___14958 = G__14959;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14952(x){
return ((1) / x);
}));

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14953(x,y){
return (x / y);
}));

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14954(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(x / y),more);
}));

/** @this {Function} */
(cljs.core._SLASH_.cljs$lang$applyTo = (function cljs$core$fn_14955(seq14948){
var G__14949 = cljs.core.first(seq14948);
var seq14948__$1 = cljs.core.next(seq14948);
var G__14950 = cljs.core.first(seq14948__$1);
var seq14948__$2 = cljs.core.next(seq14948__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14949,G__14950,seq14948__$2);
}));

(cljs.core._SLASH_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically increasing order,
 *   otherwise false.
 */
cljs.core._LT_ = (function cljs$core$_LT_(var_args){
var G__14964 = arguments.length;
switch (G__14964) {
case 1:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___14970 = arguments.length;
var i__10847__auto___14971 = (0);
while(true){
if((i__10847__auto___14971 < len__10846__auto___14970)){
args_arr__10875__auto__.push((arguments[i__10847__auto___14971]));

var G__14972 = (i__10847__auto___14971 + (1));
i__10847__auto___14971 = G__14972;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14965(x){
return true;
}));

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14966(x,y){
return (x < y);
}));

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14967(x,y,more){
while(true){
if((x < y)){
if(cljs.core.next(more)){
var G__14973 = y;
var G__14974 = cljs.core.first(more);
var G__14975 = cljs.core.next(more);
x = G__14973;
y = G__14974;
more = G__14975;
continue;
} else {
return (y < cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._LT_.cljs$lang$applyTo = (function cljs$core$fn_14968(seq14961){
var G__14962 = cljs.core.first(seq14961);
var seq14961__$1 = cljs.core.next(seq14961);
var G__14963 = cljs.core.first(seq14961__$1);
var seq14961__$2 = cljs.core.next(seq14961__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14962,G__14963,seq14961__$2);
}));

(cljs.core._LT_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 *   otherwise false.
 */
cljs.core._LT__EQ_ = (function cljs$core$_LT__EQ_(var_args){
var G__14980 = arguments.length;
switch (G__14980) {
case 1:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___14986 = arguments.length;
var i__10847__auto___14987 = (0);
while(true){
if((i__10847__auto___14987 < len__10846__auto___14986)){
args_arr__10875__auto__.push((arguments[i__10847__auto___14987]));

var G__14988 = (i__10847__auto___14987 + (1));
i__10847__auto___14987 = G__14988;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14981(x){
return true;
}));

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14982(x,y){
return (x <= y);
}));

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14983(x,y,more){
while(true){
if((x <= y)){
if(cljs.core.next(more)){
var G__14989 = y;
var G__14990 = cljs.core.first(more);
var G__14991 = cljs.core.next(more);
x = G__14989;
y = G__14990;
more = G__14991;
continue;
} else {
return (y <= cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._LT__EQ_.cljs$lang$applyTo = (function cljs$core$fn_14984(seq14977){
var G__14978 = cljs.core.first(seq14977);
var seq14977__$1 = cljs.core.next(seq14977);
var G__14979 = cljs.core.first(seq14977__$1);
var seq14977__$2 = cljs.core.next(seq14977__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14978,G__14979,seq14977__$2);
}));

(cljs.core._LT__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically decreasing order,
 *   otherwise false.
 */
cljs.core._GT_ = (function cljs$core$_GT_(var_args){
var G__14996 = arguments.length;
switch (G__14996) {
case 1:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15002 = arguments.length;
var i__10847__auto___15003 = (0);
while(true){
if((i__10847__auto___15003 < len__10846__auto___15002)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15003]));

var G__15004 = (i__10847__auto___15003 + (1));
i__10847__auto___15003 = G__15004;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14997(x){
return true;
}));

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14998(x,y){
return (x > y);
}));

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14999(x,y,more){
while(true){
if((x > y)){
if(cljs.core.next(more)){
var G__15005 = y;
var G__15006 = cljs.core.first(more);
var G__15007 = cljs.core.next(more);
x = G__15005;
y = G__15006;
more = G__15007;
continue;
} else {
return (y > cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._GT_.cljs$lang$applyTo = (function cljs$core$fn_15000(seq14993){
var G__14994 = cljs.core.first(seq14993);
var seq14993__$1 = cljs.core.next(seq14993);
var G__14995 = cljs.core.first(seq14993__$1);
var seq14993__$2 = cljs.core.next(seq14993__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14994,G__14995,seq14993__$2);
}));

(cljs.core._GT_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 *   otherwise false.
 */
cljs.core._GT__EQ_ = (function cljs$core$_GT__EQ_(var_args){
var G__15012 = arguments.length;
switch (G__15012) {
case 1:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15018 = arguments.length;
var i__10847__auto___15019 = (0);
while(true){
if((i__10847__auto___15019 < len__10846__auto___15018)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15019]));

var G__15020 = (i__10847__auto___15019 + (1));
i__10847__auto___15019 = G__15020;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15013(x){
return true;
}));

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15014(x,y){
return (x >= y);
}));

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15015(x,y,more){
while(true){
if((x >= y)){
if(cljs.core.next(more)){
var G__15021 = y;
var G__15022 = cljs.core.first(more);
var G__15023 = cljs.core.next(more);
x = G__15021;
y = G__15022;
more = G__15023;
continue;
} else {
return (y >= cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._GT__EQ_.cljs$lang$applyTo = (function cljs$core$fn_15016(seq15009){
var G__15010 = cljs.core.first(seq15009);
var seq15009__$1 = cljs.core.next(seq15009);
var G__15011 = cljs.core.first(seq15009__$1);
var seq15009__$2 = cljs.core.next(seq15009__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15010,G__15011,seq15009__$2);
}));

(cljs.core._GT__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns a number one less than num.
 */
cljs.core.dec = (function cljs$core$dec(x){
return (x - (1));
});
/**
 * Returns the absolute value of a.
 */
cljs.core.abs = (function cljs$core$abs(a){
return Math.abs(a);
});
/**
 * Returns the greatest of the nums.
 */
cljs.core.max = (function cljs$core$max(var_args){
var G__15028 = arguments.length;
switch (G__15028) {
case 1:
return cljs.core.max.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.max.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15034 = arguments.length;
var i__10847__auto___15035 = (0);
while(true){
if((i__10847__auto___15035 < len__10846__auto___15034)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15035]));

var G__15036 = (i__10847__auto___15035 + (1));
i__10847__auto___15035 = G__15036;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.max.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15029(x){
return x;
}));

(cljs.core.max.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15030(x,y){
var x__9874__auto__ = x;
var y__9875__auto__ = y;
return ((x__9874__auto__ > y__9875__auto__) ? x__9874__auto__ : y__9875__auto__);
}));

(cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15031(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(function (){var x__9874__auto__ = x;
var y__9875__auto__ = y;
return ((x__9874__auto__ > y__9875__auto__) ? x__9874__auto__ : y__9875__auto__);
})(),more);
}));

/** @this {Function} */
(cljs.core.max.cljs$lang$applyTo = (function cljs$core$fn_15032(seq15025){
var G__15026 = cljs.core.first(seq15025);
var seq15025__$1 = cljs.core.next(seq15025);
var G__15027 = cljs.core.first(seq15025__$1);
var seq15025__$2 = cljs.core.next(seq15025__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15026,G__15027,seq15025__$2);
}));

(cljs.core.max.cljs$lang$maxFixedArity = (2));

/**
 * Returns the least of the nums.
 */
cljs.core.min = (function cljs$core$min(var_args){
var G__15041 = arguments.length;
switch (G__15041) {
case 1:
return cljs.core.min.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.min.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15047 = arguments.length;
var i__10847__auto___15048 = (0);
while(true){
if((i__10847__auto___15048 < len__10846__auto___15047)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15048]));

var G__15049 = (i__10847__auto___15048 + (1));
i__10847__auto___15048 = G__15049;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.min.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15042(x){
return x;
}));

(cljs.core.min.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15043(x,y){
var x__9881__auto__ = x;
var y__9882__auto__ = y;
return ((x__9881__auto__ < y__9882__auto__) ? x__9881__auto__ : y__9882__auto__);
}));

(cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15044(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min,(function (){var x__9881__auto__ = x;
var y__9882__auto__ = y;
return ((x__9881__auto__ < y__9882__auto__) ? x__9881__auto__ : y__9882__auto__);
})(),more);
}));

/** @this {Function} */
(cljs.core.min.cljs$lang$applyTo = (function cljs$core$fn_15045(seq15038){
var G__15039 = cljs.core.first(seq15038);
var seq15038__$1 = cljs.core.next(seq15038);
var G__15040 = cljs.core.first(seq15038__$1);
var seq15038__$2 = cljs.core.next(seq15038__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15039,G__15040,seq15038__$2);
}));

(cljs.core.min.cljs$lang$maxFixedArity = (2));

cljs.core.byte$ = (function cljs$core$byte(x){
return x;
});
/**
 * Coerce to char
 */
cljs.core.char$ = (function cljs$core$char(x){
if(typeof x === 'number'){
return String.fromCharCode(x);
} else {
if(((typeof x === 'string') && ((x.length === (1))))){
return x;
} else {
throw (new Error("Argument to char must be a character or number"));

}
}
});
cljs.core.short$ = (function cljs$core$short(x){
return x;
});
cljs.core.float$ = (function cljs$core$float(x){
return x;
});
cljs.core.double$ = (function cljs$core$double(x){
return x;
});
cljs.core.unchecked_byte = (function cljs$core$unchecked_byte(x){
return x;
});
cljs.core.unchecked_char = (function cljs$core$unchecked_char(x){
return x;
});
cljs.core.unchecked_short = (function cljs$core$unchecked_short(x){
return x;
});
cljs.core.unchecked_float = (function cljs$core$unchecked_float(x){
return x;
});
cljs.core.unchecked_double = (function cljs$core$unchecked_double(x){
return x;
});
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add = (function cljs$core$unchecked_add(var_args){
var G__15054 = arguments.length;
switch (G__15054) {
case 0:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15061 = arguments.length;
var i__10847__auto___15062 = (0);
while(true){
if((i__10847__auto___15062 < len__10846__auto___15061)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15062]));

var G__15063 = (i__10847__auto___15062 + (1));
i__10847__auto___15062 = G__15063;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15055(){
return (0);
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15056(x){
return x;
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15057(x,y){
return (x + y);
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15058(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add,(x + y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_add.cljs$lang$applyTo = (function cljs$core$fn_15059(seq15051){
var G__15052 = cljs.core.first(seq15051);
var seq15051__$1 = cljs.core.next(seq15051);
var G__15053 = cljs.core.first(seq15051__$1);
var seq15051__$2 = cljs.core.next(seq15051__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15052,G__15053,seq15051__$2);
}));

(cljs.core.unchecked_add.cljs$lang$maxFixedArity = (2));

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add_int = (function cljs$core$unchecked_add_int(var_args){
var G__15068 = arguments.length;
switch (G__15068) {
case 0:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15075 = arguments.length;
var i__10847__auto___15076 = (0);
while(true){
if((i__10847__auto___15076 < len__10846__auto___15075)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15076]));

var G__15077 = (i__10847__auto___15076 + (1));
i__10847__auto___15076 = G__15077;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15069(){
return (0);
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15070(x){
return x;
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15071(x,y){
return (x + y);
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15072(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int,(x + y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_add_int.cljs$lang$applyTo = (function cljs$core$fn_15073(seq15065){
var G__15066 = cljs.core.first(seq15065);
var seq15065__$1 = cljs.core.next(seq15065);
var G__15067 = cljs.core.first(seq15065__$1);
var seq15065__$2 = cljs.core.next(seq15065__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15066,G__15067,seq15065__$2);
}));

(cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = (2));

/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec = (function cljs$core$unchecked_dec(x){
return (x - (1));
});
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec_int = (function cljs$core$unchecked_dec_int(x){
return (x - (1));
});
/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core.unchecked_divide_int = (function cljs$core$unchecked_divide_int(var_args){
var G__15082 = arguments.length;
switch (G__15082) {
case 1:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15088 = arguments.length;
var i__10847__auto___15089 = (0);
while(true){
if((i__10847__auto___15089 < len__10846__auto___15088)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15089]));

var G__15090 = (i__10847__auto___15089 + (1));
i__10847__auto___15089 = G__15090;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15083(x){
return ((1) / x);
}));

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15084(x,y){
return (x / y);
}));

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15085(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int,(x / y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_divide_int.cljs$lang$applyTo = (function cljs$core$fn_15086(seq15079){
var G__15080 = cljs.core.first(seq15079);
var seq15079__$1 = cljs.core.next(seq15079);
var G__15081 = cljs.core.first(seq15079__$1);
var seq15079__$2 = cljs.core.next(seq15079__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15080,G__15081,seq15079__$2);
}));

(cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = (2));

cljs.core.unchecked_inc = (function cljs$core$unchecked_inc(x){
return (x + (1));
});
cljs.core.unchecked_inc_int = (function cljs$core$unchecked_inc_int(x){
return (x + (1));
});
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply = (function cljs$core$unchecked_multiply(var_args){
var G__15095 = arguments.length;
switch (G__15095) {
case 0:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15102 = arguments.length;
var i__10847__auto___15103 = (0);
while(true){
if((i__10847__auto___15103 < len__10846__auto___15102)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15103]));

var G__15104 = (i__10847__auto___15103 + (1));
i__10847__auto___15103 = G__15104;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15096(){
return (1);
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15097(x){
return x;
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15098(x,y){
return (x * y);
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15099(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply,(x * y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_multiply.cljs$lang$applyTo = (function cljs$core$fn_15100(seq15092){
var G__15093 = cljs.core.first(seq15092);
var seq15092__$1 = cljs.core.next(seq15092);
var G__15094 = cljs.core.first(seq15092__$1);
var seq15092__$2 = cljs.core.next(seq15092__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15093,G__15094,seq15092__$2);
}));

(cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = (2));

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply_int = (function cljs$core$unchecked_multiply_int(var_args){
var G__15109 = arguments.length;
switch (G__15109) {
case 0:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15116 = arguments.length;
var i__10847__auto___15117 = (0);
while(true){
if((i__10847__auto___15117 < len__10846__auto___15116)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15117]));

var G__15118 = (i__10847__auto___15117 + (1));
i__10847__auto___15117 = G__15118;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15110(){
return (1);
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15111(x){
return x;
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15112(x,y){
return (x * y);
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15113(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int,(x * y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_multiply_int.cljs$lang$applyTo = (function cljs$core$fn_15114(seq15106){
var G__15107 = cljs.core.first(seq15106);
var seq15106__$1 = cljs.core.next(seq15106);
var G__15108 = cljs.core.first(seq15106__$1);
var seq15106__$2 = cljs.core.next(seq15106__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15107,G__15108,seq15106__$2);
}));

(cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = (2));

cljs.core.unchecked_negate = (function cljs$core$unchecked_negate(x){
return (- x);
});
cljs.core.unchecked_negate_int = (function cljs$core$unchecked_negate_int(x){
return (- x);
});
cljs.core.unchecked_remainder_int = (function cljs$core$unchecked_remainder_int(x,n){
return cljs.core.mod(x,n);
});
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract = (function cljs$core$unchecked_subtract(var_args){
var G__15123 = arguments.length;
switch (G__15123) {
case 1:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15129 = arguments.length;
var i__10847__auto___15130 = (0);
while(true){
if((i__10847__auto___15130 < len__10846__auto___15129)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15130]));

var G__15131 = (i__10847__auto___15130 + (1));
i__10847__auto___15130 = G__15131;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15124(x){
return (- x);
}));

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15125(x,y){
return (x - y);
}));

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15126(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract,(x - y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_subtract.cljs$lang$applyTo = (function cljs$core$fn_15127(seq15120){
var G__15121 = cljs.core.first(seq15120);
var seq15120__$1 = cljs.core.next(seq15120);
var G__15122 = cljs.core.first(seq15120__$1);
var seq15120__$2 = cljs.core.next(seq15120__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15121,G__15122,seq15120__$2);
}));

(cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = (2));

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract_int = (function cljs$core$unchecked_subtract_int(var_args){
var G__15136 = arguments.length;
switch (G__15136) {
case 1:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15142 = arguments.length;
var i__10847__auto___15143 = (0);
while(true){
if((i__10847__auto___15143 < len__10846__auto___15142)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15143]));

var G__15144 = (i__10847__auto___15143 + (1));
i__10847__auto___15143 = G__15144;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15137(x){
return (- x);
}));

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15138(x,y){
return (x - y);
}));

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15139(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int,(x - y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_subtract_int.cljs$lang$applyTo = (function cljs$core$fn_15140(seq15133){
var G__15134 = cljs.core.first(seq15133);
var seq15133__$1 = cljs.core.next(seq15133);
var G__15135 = cljs.core.first(seq15133__$1);
var seq15133__$2 = cljs.core.next(seq15133__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15134,G__15135,seq15133__$2);
}));

(cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = (2));

cljs.core.fix = (function cljs$core$fix(q){
if((q >= (0))){
return Math.floor(q);
} else {
return Math.ceil(q);
}
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.int$ = (function cljs$core$int(x){
return (x | (0));
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.unchecked_int = (function cljs$core$unchecked_int(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.long$ = (function cljs$core$long(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.unchecked_long = (function cljs$core$unchecked_long(x){
return cljs.core.fix(x);
});
cljs.core.booleans = (function cljs$core$booleans(x){
return x;
});
cljs.core.bytes = (function cljs$core$bytes(x){
return x;
});
cljs.core.chars = (function cljs$core$chars(x){
return x;
});
cljs.core.shorts = (function cljs$core$shorts(x){
return x;
});
cljs.core.ints = (function cljs$core$ints(x){
return x;
});
cljs.core.floats = (function cljs$core$floats(x){
return x;
});
cljs.core.doubles = (function cljs$core$doubles(x){
return x;
});
cljs.core.longs = (function cljs$core$longs(x){
return x;
});
/**
 * Modulus of num and div with original javascript behavior. i.e. bug for negative numbers
 */
cljs.core.js_mod = (function cljs$core$js_mod(n,d){
return (n % d);
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
cljs.core.mod = (function cljs$core$mod(n,d){
return (((n % d) + d) % d);
});
/**
 * quot[ient] of dividing numerator by denominator.
 */
cljs.core.quot = (function cljs$core$quot(n,d){
var rem = (n % d);
return cljs.core.fix(((n - rem) / d));
});
/**
 * remainder of dividing numerator by denominator.
 */
cljs.core.rem = (function cljs$core$rem(n,d){
var q = cljs.core.quot(n,d);
return (n - (d * q));
});
/**
 * Bitwise exclusive or
 */
cljs.core.bit_xor = (function cljs$core$bit_xor(var_args){
var G__15149 = arguments.length;
switch (G__15149) {
case 2:
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15154 = arguments.length;
var i__10847__auto___15155 = (0);
while(true){
if((i__10847__auto___15155 < len__10846__auto___15154)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15155]));

var G__15156 = (i__10847__auto___15155 + (1));
i__10847__auto___15155 = G__15156;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15150(x,y){
return (x ^ y);
}));

(cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15151(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor,(x ^ y),more);
}));

/** @this {Function} */
(cljs.core.bit_xor.cljs$lang$applyTo = (function cljs$core$fn_15152(seq15146){
var G__15147 = cljs.core.first(seq15146);
var seq15146__$1 = cljs.core.next(seq15146);
var G__15148 = cljs.core.first(seq15146__$1);
var seq15146__$2 = cljs.core.next(seq15146__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15147,G__15148,seq15146__$2);
}));

(cljs.core.bit_xor.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise and
 */
cljs.core.bit_and = (function cljs$core$bit_and(var_args){
var G__15161 = arguments.length;
switch (G__15161) {
case 2:
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15166 = arguments.length;
var i__10847__auto___15167 = (0);
while(true){
if((i__10847__auto___15167 < len__10846__auto___15166)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15167]));

var G__15168 = (i__10847__auto___15167 + (1));
i__10847__auto___15167 = G__15168;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15162(x,y){
return (x & y);
}));

(cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15163(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and,(x & y),more);
}));

/** @this {Function} */
(cljs.core.bit_and.cljs$lang$applyTo = (function cljs$core$fn_15164(seq15158){
var G__15159 = cljs.core.first(seq15158);
var seq15158__$1 = cljs.core.next(seq15158);
var G__15160 = cljs.core.first(seq15158__$1);
var seq15158__$2 = cljs.core.next(seq15158__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15159,G__15160,seq15158__$2);
}));

(cljs.core.bit_and.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise or
 */
cljs.core.bit_or = (function cljs$core$bit_or(var_args){
var G__15173 = arguments.length;
switch (G__15173) {
case 2:
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15178 = arguments.length;
var i__10847__auto___15179 = (0);
while(true){
if((i__10847__auto___15179 < len__10846__auto___15178)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15179]));

var G__15180 = (i__10847__auto___15179 + (1));
i__10847__auto___15179 = G__15180;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15174(x,y){
return (x | y);
}));

(cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15175(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or,(x | y),more);
}));

/** @this {Function} */
(cljs.core.bit_or.cljs$lang$applyTo = (function cljs$core$fn_15176(seq15170){
var G__15171 = cljs.core.first(seq15170);
var seq15170__$1 = cljs.core.next(seq15170);
var G__15172 = cljs.core.first(seq15170__$1);
var seq15170__$2 = cljs.core.next(seq15170__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15171,G__15172,seq15170__$2);
}));

(cljs.core.bit_or.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise and with complement
 */
cljs.core.bit_and_not = (function cljs$core$bit_and_not(var_args){
var G__15185 = arguments.length;
switch (G__15185) {
case 2:
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15190 = arguments.length;
var i__10847__auto___15191 = (0);
while(true){
if((i__10847__auto___15191 < len__10846__auto___15190)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15191]));

var G__15192 = (i__10847__auto___15191 + (1));
i__10847__auto___15191 = G__15192;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15186(x,y){
return (x & ~y);
}));

(cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15187(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not,(x & ~y),more);
}));

/** @this {Function} */
(cljs.core.bit_and_not.cljs$lang$applyTo = (function cljs$core$fn_15188(seq15182){
var G__15183 = cljs.core.first(seq15182);
var seq15182__$1 = cljs.core.next(seq15182);
var G__15184 = cljs.core.first(seq15182__$1);
var seq15182__$2 = cljs.core.next(seq15182__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15183,G__15184,seq15182__$2);
}));

(cljs.core.bit_and_not.cljs$lang$maxFixedArity = (2));

/**
 * Clear bit at index n
 */
cljs.core.bit_clear = (function cljs$core$bit_clear(x,n){
return (x & ~(1 << n));
});
/**
 * Flip bit at index n
 */
cljs.core.bit_flip = (function cljs$core$bit_flip(x,n){
return (x ^ (1 << n));
});
/**
 * Bitwise complement
 */
cljs.core.bit_not = (function cljs$core$bit_not(x){
return (~ x);
});
/**
 * Set bit at index n
 */
cljs.core.bit_set = (function cljs$core$bit_set(x,n){
return (x | (1 << n));
});
/**
 * Test bit at index n
 */
cljs.core.bit_test = (function cljs$core$bit_test(x,n){
return ((x & (1 << n)) != 0);
});
/**
 * Bitwise shift left
 */
cljs.core.bit_shift_left = (function cljs$core$bit_shift_left(x,n){
return (x << n);
});
/**
 * Bitwise shift right
 */
cljs.core.bit_shift_right = (function cljs$core$bit_shift_right(x,n){
return (x >> n);
});
/**
 * DEPRECATED: Bitwise shift right with zero fill
 */
cljs.core.bit_shift_right_zero_fill = (function cljs$core$bit_shift_right_zero_fill(x,n){
return (x >>> n);
});
/**
 * Bitwise shift right with zero fill
 */
cljs.core.unsigned_bit_shift_right = (function cljs$core$unsigned_bit_shift_right(x,n){
return (x >>> n);
});
/**
 * Counts the number of bits set in n
 */
cljs.core.bit_count = (function cljs$core$bit_count(v){
var v__$1 = (v - ((v >> (1)) & (1431655765)));
var v__$2 = ((v__$1 & (858993459)) + ((v__$1 >> (2)) & (858993459)));
return ((((v__$2 + (v__$2 >> (4))) & (252645135)) * (16843009)) >> (24));
});
/**
 * Returns non-nil if nums all have the equivalent
 *   value, otherwise false. Behavior on non nums is
 *   undefined.
 */
cljs.core._EQ__EQ_ = (function cljs$core$_EQ__EQ_(var_args){
var G__15197 = arguments.length;
switch (G__15197) {
case 1:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15203 = arguments.length;
var i__10847__auto___15204 = (0);
while(true){
if((i__10847__auto___15204 < len__10846__auto___15203)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15204]));

var G__15205 = (i__10847__auto___15204 + (1));
i__10847__auto___15204 = G__15205;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15198(x){
return true;
}));

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15199(x,y){
return cljs.core._equiv(x,y);
}));

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15200(x,y,more){
while(true){
if((x === y)){
if(cljs.core.next(more)){
var G__15206 = y;
var G__15207 = cljs.core.first(more);
var G__15208 = cljs.core.next(more);
x = G__15206;
y = G__15207;
more = G__15208;
continue;
} else {
return (y === cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._EQ__EQ_.cljs$lang$applyTo = (function cljs$core$fn_15201(seq15194){
var G__15195 = cljs.core.first(seq15194);
var seq15194__$1 = cljs.core.next(seq15194);
var G__15196 = cljs.core.first(seq15194__$1);
var seq15194__$2 = cljs.core.next(seq15194__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15195,G__15196,seq15194__$2);
}));

(cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if num is greater than zero, else false
 */
cljs.core.pos_QMARK_ = (function cljs$core$pos_QMARK_(x){
return (x > (0));
});
/**
 * Returns true if num is zero, else false
 */
cljs.core.zero_QMARK_ = (function cljs$core$zero_QMARK_(x){
return (x === (0));
});
/**
 * Returns true if num is less than zero, else false
 */
cljs.core.neg_QMARK_ = (function cljs$core$neg_QMARK_(x){
return (x < (0));
});
/**
 * Returns the nth next of coll, (seq coll) when n is 0.
 */
cljs.core.nthnext = (function cljs$core$nthnext(coll,n){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition1$ & (262144))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IDrop$))))?true:false):false)){
if((n > (0))){
return coll.cljs$core$IDrop$_drop$arity$2(null,Math.ceil(n));
} else {
return cljs.core.seq(coll);
}
} else {
var n__$1 = n;
var xs = cljs.core.seq(coll);
while(true){
if(((xs) && ((n__$1 > (0))))){
var G__15210 = (n__$1 - (1));
var G__15211 = cljs.core.next(xs);
n__$1 = G__15210;
xs = G__15211;
continue;
} else {
return xs;
}
break;
}
}
});
/**
 * With no args, returns the empty string. With one arg x, returns
 *   x.toString().  (str nil) returns the empty string. With more than
 *   one arg, returns the concatenation of the str values of the args.
 */
cljs.core.str = (function cljs$core$str(var_args){
var G__15215 = arguments.length;
switch (G__15215) {
case 0:
return cljs.core.str.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15221 = arguments.length;
var i__10847__auto___15222 = (0);
while(true){
if((i__10847__auto___15222 < len__10846__auto___15221)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15222]));

var G__15223 = (i__10847__auto___15222 + (1));
i__10847__auto___15222 = G__15223;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((1) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((1)),(0),null)):null);
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10876__auto__);

}
});

(cljs.core.str.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15216(){
return "";
}));

(cljs.core.str.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15217(x){
if((x == null)){
return "";
} else {
return [x].join("");
}
}));

(cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15218(x,ys){
var sb = (new goog.string.StringBuffer(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)));
var more = ys;
while(true){
if(cljs.core.truth_(more)){
var G__15224 = sb.append(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(more)));
var G__15225 = cljs.core.next(more);
sb = G__15224;
more = G__15225;
continue;
} else {
return sb.toString();
}
break;
}
}));

/** @this {Function} */
(cljs.core.str.cljs$lang$applyTo = (function cljs$core$fn_15219(seq15213){
var G__15214 = cljs.core.first(seq15213);
var seq15213__$1 = cljs.core.next(seq15213);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15214,seq15213__$1);
}));

(cljs.core.str.cljs$lang$maxFixedArity = (1));

/**
 * Returns the substring of s beginning at start inclusive, and ending
 *   at end (defaults to length of string), exclusive.
 */
cljs.core.subs = (function cljs$core$subs(var_args){
var G__15227 = arguments.length;
switch (G__15227) {
case 2:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15228(s,start){
return s.substring(start);
}));

(cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15229(s,start,end){
return s.substring(start,end);
}));

(cljs.core.subs.cljs$lang$maxFixedArity = 3);


/**
 * Assumes x is sequential. Returns true if x equals y, otherwise
 *   returns false.
 */
cljs.core.equiv_sequential = (function cljs$core$equiv_sequential(x,y){
return cljs.core.boolean$(((cljs.core.sequential_QMARK_(y))?((((cljs.core.counted_QMARK_(x)) && (((cljs.core.counted_QMARK_(y)) && ((!((cljs.core.count(x) === cljs.core.count(y)))))))))?false:(function (){var xs = cljs.core.seq(x);
var ys = cljs.core.seq(y);
while(true){
if((xs == null)){
return (ys == null);
} else {
if((ys == null)){
return false;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){
var G__15231 = cljs.core.next(xs);
var G__15232 = cljs.core.next(ys);
xs = G__15231;
ys = G__15232;
continue;
} else {
return false;

}
}
}
break;
}
})()):null));
});
cljs.core.hash_coll = (function cljs$core$hash_coll(coll){
if(cljs.core.seq(coll)){
var res = cljs.core.hash(cljs.core.first(coll));
var s = cljs.core.next(coll);
while(true){
if((s == null)){
return res;
} else {
var G__15233 = cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));
var G__15234 = cljs.core.next(s);
res = G__15233;
s = G__15234;
continue;
}
break;
}
} else {
return (0);
}
});

cljs.core.hash_imap = (function cljs$core$hash_imap(m){
var h = (0);
var s = cljs.core.seq(m);
while(true){
if(s){
var e = cljs.core.first(s);
var G__15235 = ((h + (cljs.core.hash(cljs.core.key(e)) ^ cljs.core.hash(cljs.core.val(e)))) % (4503599627370496));
var G__15236 = cljs.core.next(s);
h = G__15235;
s = G__15236;
continue;
} else {
return h;
}
break;
}
});
cljs.core.hash_iset = (function cljs$core$hash_iset(s){
var h = (0);
var s__$1 = cljs.core.seq(s);
while(true){
if(s__$1){
var e = cljs.core.first(s__$1);
var G__15237 = ((h + cljs.core.hash(e)) % (4503599627370496));
var G__15238 = cljs.core.next(s__$1);
h = G__15237;
s__$1 = G__15238;
continue;
} else {
return h;
}
break;
}
});


/**
 * Takes a JavaScript object and a map of names to functions and
 *   attaches said functions as methods on the object.  Any references to
 *   JavaScript's implicit this (via the this-as macro) will resolve to the
 *   object that the function is attached.
 */
cljs.core.extend_object_BANG_ = (function cljs$core$extend_object_BANG_(obj,fn_map){
var seq__15239_15255 = cljs.core.seq(fn_map);
var chunk__15240_15256 = null;
var count__15241_15257 = (0);
var i__15242_15258 = (0);
while(true){
if((i__15242_15258 < count__15241_15257)){
var vec__15249_15259 = chunk__15240_15256.cljs$core$IIndexed$_nth$arity$2(null,i__15242_15258);
var key_name_15260 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15249_15259,(0),null);
var f_15261 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15249_15259,(1),null);
var str_name_15262 = cljs.core.name(key_name_15260);
cljs.core.goog$module$goog$object.set.call(null,obj,str_name_15262,f_15261);


var G__15263 = seq__15239_15255;
var G__15264 = chunk__15240_15256;
var G__15265 = count__15241_15257;
var G__15266 = (i__15242_15258 + (1));
seq__15239_15255 = G__15263;
chunk__15240_15256 = G__15264;
count__15241_15257 = G__15265;
i__15242_15258 = G__15266;
continue;
} else {
var temp__5720__auto___15267 = cljs.core.seq(seq__15239_15255);
if(temp__5720__auto___15267){
var seq__15239_15268__$1 = temp__5720__auto___15267;
if(cljs.core.chunked_seq_QMARK_(seq__15239_15268__$1)){
var c__10489__auto___15269 = cljs.core.chunk_first(seq__15239_15268__$1);
var G__15270 = cljs.core.chunk_rest(seq__15239_15268__$1);
var G__15271 = c__10489__auto___15269;
var G__15272 = cljs.core.count(c__10489__auto___15269);
var G__15273 = (0);
seq__15239_15255 = G__15270;
chunk__15240_15256 = G__15271;
count__15241_15257 = G__15272;
i__15242_15258 = G__15273;
continue;
} else {
var vec__15252_15274 = cljs.core.first(seq__15239_15268__$1);
var key_name_15275 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15252_15274,(0),null);
var f_15276 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15252_15274,(1),null);
var str_name_15277 = cljs.core.name(key_name_15275);
cljs.core.goog$module$goog$object.set.call(null,obj,str_name_15277,f_15276);


var G__15278 = cljs.core.next(seq__15239_15268__$1);
var G__15279 = null;
var G__15280 = (0);
var G__15281 = (0);
seq__15239_15255 = G__15278;
chunk__15240_15256 = G__15279;
count__15241_15257 = G__15280;
i__15242_15258 = G__15281;
continue;
}
} else {
}
}
break;
}

return obj;
});

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.List = (function (meta,first,rest,count,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.count = count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65937646;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.List.prototype.toString = (function cljs$core$fn_15282(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.List.prototype.equiv = (function cljs$core$fn_15283(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.List.prototype.indexOf = (function() {
var cljs$core$fn_15284 = null;
var cljs$core$fn_15284__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_15284__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15284 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15284__1.call(this,x);
case 2:
return cljs$core$fn_15284__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15284.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15284__1;
cljs$core$fn_15284.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15284__2;
return cljs$core$fn_15284;
})()
);

(cljs.core.List.prototype.lastIndexOf = (function() {
var cljs$core$fn_15285 = null;
var cljs$core$fn_15285__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,self__.count);
});
var cljs$core$fn_15285__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15285 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15285__1.call(this,x);
case 2:
return cljs$core$fn_15285__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15285.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15285__1;
cljs$core$fn_15285.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15285__2;
return cljs$core$fn_15285;
})()
);

(cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15286(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_15287(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));
}));

(cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_15288(coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return null;
} else {
return self__.rest;
}
}));

(cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_15289(coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
}));

(cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_15290(coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_15291(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
}));

(cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15292(coll){
var self__ = this;
var coll__$1 = this;
var h__9978__auto__ = self__.__hash;
if((!((h__9978__auto__ == null)))){
return h__9978__auto__;
} else {
var h__9978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9978__auto____$1);

return h__9978__auto____$1;
}
}));

(cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15293(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_15294(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_15295(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_15296(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_15297(coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_15298(coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
}));

(cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_15299(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_15300(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.List(new_meta,self__.first,self__.rest,self__.count,self__.__hash));
}
}));

(cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_15301(coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));
}));

(cljs.core.List.getBasis = (function cljs$core$fn_15302(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"count","count",-514511684,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.List.cljs$lang$type = true);

(cljs.core.List.cljs$lang$ctorStr = "cljs.core/List");

(cljs.core.List.cljs$lang$ctorPrWriter = (function cljs$core$fn_15303(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/List");
}));

/**
 * Positional factory function for cljs.core/List.
 */
cljs.core.__GT_List = (function cljs$core$__GT_List(meta,first,rest,count,__hash){
return (new cljs.core.List(meta,first,rest,count,__hash));
});

/**
 * Returns true if x implements IList
 */
cljs.core.list_QMARK_ = (function cljs$core$list_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (33554432))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IList$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
}
});
(cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15305(){
var this__10707__auto__ = this;
return cljs.core.es6_iterator(this__10707__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.EmptyList = (function (meta){
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 65937614;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.EmptyList.prototype.toString = (function cljs$core$fn_15306(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.EmptyList.prototype.equiv = (function cljs$core$fn_15307(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.EmptyList.prototype.indexOf = (function() {
var cljs$core$fn_15308 = null;
var cljs$core$fn_15308__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_15308__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15308 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15308__1.call(this,x);
case 2:
return cljs$core$fn_15308__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15308.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15308__1;
cljs$core$fn_15308.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15308__2;
return cljs$core$fn_15308;
})()
);

(cljs.core.EmptyList.prototype.lastIndexOf = (function() {
var cljs$core$fn_15309 = null;
var cljs$core$fn_15309__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_15309__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15309 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15309__1.call(this,x);
case 2:
return cljs$core$fn_15309__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15309.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15309__1;
cljs$core$fn_15309.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15309__2;
return cljs$core$fn_15309;
})()
);

(cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15310(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_15311(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.EmptyList(self__.meta));
}));

(cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_15312(coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_15313(coll){
var self__ = this;
var coll__$1 = this;
return (0);
}));

(cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_15314(coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_15315(coll){
var self__ = this;
var coll__$1 = this;
throw (new Error("Can't pop empty list"));
}));

(cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15316(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.empty_ordered_hash;
}));

(cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15317(coll,other){
var self__ = this;
var coll__$1 = this;
if(((cljs.core.list_QMARK_(other)) || (cljs.core.sequential_QMARK_(other)))){
return (cljs.core.seq(other) == null);
} else {
return false;
}
}));

(cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_15318(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_15319(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_15320(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_15321(coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_15322(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_15323(coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_15324(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.EmptyList(new_meta));
}
}));

(cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_15325(coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,null,(1),null));
}));

(cljs.core.EmptyList.getBasis = (function cljs$core$fn_15326(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.EmptyList.cljs$lang$type = true);

(cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList");

(cljs.core.EmptyList.cljs$lang$ctorPrWriter = (function cljs$core$fn_15327(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/EmptyList");
}));

/**
 * Positional factory function for cljs.core/EmptyList.
 */
cljs.core.__GT_EmptyList = (function cljs$core$__GT_EmptyList(meta){
return (new cljs.core.EmptyList(meta));
});

(cljs.core.List.EMPTY = (new cljs.core.EmptyList(null)));
(cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15328(){
var this__10707__auto__ = this;
return cljs.core.es6_iterator(this__10707__auto__);
}));
/**
 * Returns true if coll satisfies? IReversible.
 */
cljs.core.reversible_QMARK_ = (function cljs$core$reversible_QMARK_(coll){
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (134217728))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReversible$)))){
return true;
} else {
if((!coll.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
}
});
/**
 * Returns, in constant time, a seq of the items in rev (which
 *   can be a vector or sorted-map), in reverse order. If rev is empty returns nil
 */
cljs.core.rseq = (function cljs$core$rseq(rev){
return cljs.core._rseq(rev);
});
/**
 * Returns a seq of the items in coll in reverse order. Not lazy.
 */
cljs.core.reverse = (function cljs$core$reverse(coll){
if(cljs.core.reversible_QMARK_(coll)){
var or__9517__auto__ = cljs.core.rseq(coll);
if(or__9517__auto__){
return or__9517__auto__;
} else {
return cljs.core.List.EMPTY;
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll);
}
});
/**
 * Creates a new list containing the items.
 */
cljs.core.list = (function cljs$core$list(var_args){
var args__10856__auto__ = [];
var len__10846__auto___15333 = arguments.length;
var i__10847__auto___15334 = (0);
while(true){
if((i__10847__auto___15334 < len__10846__auto___15333)){
args__10856__auto__.push((arguments[i__10847__auto___15334]));

var G__15335 = (i__10847__auto___15334 + (1));
i__10847__auto___15334 = G__15335;
continue;
} else {
}
break;
}

var argseq__10857__auto__ = ((((0) < args__10856__auto__.length))?(new cljs.core.IndexedSeq(args__10856__auto__.slice((0)),(0),null)):null);
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__10857__auto__);
});

(cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15331(xs){
var arr = (((((xs instanceof cljs.core.IndexedSeq)) && ((xs.i === (0)))))?xs.arr:(function (){var arr = [];
var xs__$1 = xs;
while(true){
if((!((xs__$1 == null)))){
arr.push(cljs.core._first(xs__$1));

var G__15336 = cljs.core._next(xs__$1);
xs__$1 = G__15336;
continue;
} else {
return arr;
}
break;
}
})());
var i = arr.length;
var r = cljs.core.List.EMPTY;
while(true){
if((i > (0))){
var G__15337 = (i - (1));
var G__15338 = cljs.core._conj(r,(arr[(i - (1))]));
i = G__15337;
r = G__15338;
continue;
} else {
return r;
}
break;
}
}));

(cljs.core.list.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.list.cljs$lang$applyTo = (function cljs$core$fn_15332(seq15330){
var self__10832__auto__ = this;
return self__10832__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq15330));
}));


/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Cons = (function (meta,first,rest,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65929452;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.Cons.prototype.toString = (function cljs$core$fn_15339(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Cons.prototype.equiv = (function cljs$core$fn_15340(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Cons.prototype.indexOf = (function() {
var cljs$core$fn_15341 = null;
var cljs$core$fn_15341__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_15341__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15341 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15341__1.call(this,x);
case 2:
return cljs$core$fn_15341__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15341.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15341__1;
cljs$core$fn_15341.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15341__2;
return cljs$core$fn_15341;
})()
);

(cljs.core.Cons.prototype.lastIndexOf = (function() {
var cljs$core$fn_15342 = null;
var cljs$core$fn_15342__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_15342__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15342 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15342__1.call(this,x);
case 2:
return cljs$core$fn_15342__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15342.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15342__1;
cljs$core$fn_15342.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15342__2;
return cljs$core$fn_15342;
})()
);

(cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15343(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_15344(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));
}));

(cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_15345(coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return null;
} else {
return cljs.core.seq(self__.rest);
}
}));

(cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15346(coll){
var self__ = this;
var coll__$1 = this;
var h__9978__auto__ = self__.__hash;
if((!((h__9978__auto__ == null)))){
return h__9978__auto__;
} else {
var h__9978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9978__auto____$1);

return h__9978__auto____$1;
}
}));

(cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15347(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_15348(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_15349(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_15350(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_15351(coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_15352(coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
}));

(cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_15353(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_15354(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Cons(new_meta,self__.first,self__.rest,self__.__hash));
}
}));

(cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_15355(coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(null,o,coll__$1,null));
}));

(cljs.core.Cons.getBasis = (function cljs$core$fn_15356(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rest","rest",398835108,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Cons.cljs$lang$type = true);

(cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons");

(cljs.core.Cons.cljs$lang$ctorPrWriter = (function cljs$core$fn_15357(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/Cons");
}));

/**
 * Positional factory function for cljs.core/Cons.
 */
cljs.core.__GT_Cons = (function cljs$core$__GT_Cons(meta,first,rest,__hash){
return (new cljs.core.Cons(meta,first,rest,__hash));
});

(cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15358(){
var this__10707__auto__ = this;
return cljs.core.es6_iterator(this__10707__auto__);
}));
/**
 * Returns a new seq where x is the first element and coll is the rest.
 */
cljs.core.cons = (function cljs$core$cons(x,coll){
if((coll == null)){
return (new cljs.core.List(null,x,null,(1),null));
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return (new cljs.core.Cons(null,x,coll,null));
} else {
return (new cljs.core.Cons(null,x,cljs.core.seq(coll),null));

}
}
});
cljs.core.hash_keyword = (function cljs$core$hash_keyword(k){
return ((cljs.core.hash_symbol(k) + (2654435769)) | (0));
});
cljs.core.compare_keywords = (function cljs$core$compare_keywords(a,b){
if((a.fqn === b.fqn)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__9511__auto__ = cljs.core.not(a.ns);
if(and__9511__auto__){
return b.ns;
} else {
return and__9511__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__15360 = a.ns;
var G__15361 = b.ns;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__15360,G__15361);
})();
if(((0) === nsc)){
var G__15362 = a.name;
var G__15363 = b.name;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__15362,G__15363);
} else {
return nsc;
}
}
} else {
var G__15364 = a.name;
var G__15365 = b.name;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__15364,G__15365);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IPrintWithWriter}
*/
cljs.core.Keyword = (function (ns,name,fqn,_hash){
this.ns = ns;
this.name = name;
this.fqn = fqn;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 2153775105;
this.cljs$lang$protocol_mask$partition1$ = 4096;
});
(cljs.core.Keyword.prototype.toString = (function cljs$core$fn_15367(){
var self__ = this;
var _ = this;
return [":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join('');
}));

(cljs.core.Keyword.prototype.equiv = (function cljs$core$fn_15368(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15369(_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Keyword)){
return (self__.fqn === other.fqn);
} else {
return false;
}
}));

(cljs.core.Keyword.prototype.call = (function() {
var cljs$core$fn_15370 = null;
var cljs$core$fn_15370__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});
var cljs$core$fn_15370__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});
cljs$core$fn_15370 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_15370__2.call(this,self__,coll);
case 3:
return cljs$core$fn_15370__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_15370.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15370__2;
cljs$core$fn_15370.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15370__3;
return cljs$core$fn_15370;
})()
);

(cljs.core.Keyword.prototype.apply = (function cljs$core$fn_15371(self__,args15366){
var self__ = this;
var self____$1 = this;
var args__10120__auto__ = cljs.core.aclone(args15366);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10120__auto__.length > (20)))?(function (){var G__15372 = args__10120__auto__.slice((0),(20));
G__15372.push(args__10120__auto__.slice((20)));

return G__15372;
})():args__10120__auto__)));
}));

(cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15373(coll){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
}));

(cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15374(coll,not_found){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
}));

(cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15375(this$){
var self__ = this;
var this$__$1 = this;
var h__9978__auto__ = self__._hash;
if((!((h__9978__auto__ == null)))){
return h__9978__auto__;
} else {
var h__9978__auto____$1 = cljs.core.hash_keyword(this$__$1);
(self__._hash = h__9978__auto____$1);

return h__9978__auto____$1;
}
}));

(cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = (function cljs$core$fn_15376(_){
var self__ = this;
var ___$1 = this;
return self__.name;
}));

(cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = (function cljs$core$fn_15377(_){
var self__ = this;
var ___$1 = this;
return self__.ns;
}));

(cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function cljs$core$fn_15378(o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join(''));
}));

(cljs.core.Keyword.getBasis = (function cljs$core$fn_15379(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns","ns",2082130287,null),new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"fqn","fqn",-1749334463,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Keyword.cljs$lang$type = true);

(cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword");

(cljs.core.Keyword.cljs$lang$ctorPrWriter = (function cljs$core$fn_15380(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/Keyword");
}));

/**
 * Positional factory function for cljs.core/Keyword.
 */
cljs.core.__GT_Keyword = (function cljs$core$__GT_Keyword(ns,name,fqn,_hash){
return (new cljs.core.Keyword(ns,name,fqn,_hash));
});

/**
 * Return true if x is a Keyword
 */
cljs.core.keyword_QMARK_ = (function cljs$core$keyword_QMARK_(x){
return (x instanceof cljs.core.Keyword);
});
/**
 * Efficient test to determine that two keywords are identical.
 */
cljs.core.keyword_identical_QMARK_ = (function cljs$core$keyword_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if((((x instanceof cljs.core.Keyword)) && ((y instanceof cljs.core.Keyword)))){
return (x.fqn === y.fqn);
} else {
return false;
}
}
});
/**
 * Efficient test to determine that two symbols are identical.
 */
cljs.core.symbol_identical_QMARK_ = (function cljs$core$symbol_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if((((x instanceof cljs.core.Symbol)) && ((y instanceof cljs.core.Symbol)))){
return (x.str === y.str);
} else {
return false;
}
}
});
/**
 * Returns the namespace String of a symbol or keyword, or nil if not present.
 */
cljs.core.namespace = (function cljs$core$namespace(x){
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition1$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$INamed$))))?true:false):false)){
return x.cljs$core$INamed$_namespace$arity$1(null);
} else {
throw (new Error(["Doesn't support namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('')));
}
});
/**
 * Return true if x is a symbol or keyword
 */
cljs.core.ident_QMARK_ = (function cljs$core$ident_QMARK_(x){
return (((x instanceof cljs.core.Keyword)) || ((x instanceof cljs.core.Symbol)));
});
/**
 * Return true if x is a symbol or keyword without a namespace
 */
cljs.core.simple_ident_QMARK_ = (function cljs$core$simple_ident_QMARK_(x){
return ((cljs.core.ident_QMARK_(x)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a symbol or keyword with a namespace
 */
cljs.core.qualified_ident_QMARK_ = (function cljs$core$qualified_ident_QMARK_(x){
return cljs.core.boolean$((function (){var and__9511__auto__ = cljs.core.ident_QMARK_(x);
if(and__9511__auto__){
var and__9511__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__9511__auto____$1)){
return true;
} else {
return and__9511__auto____$1;
}
} else {
return and__9511__auto__;
}
})());
});
/**
 * Return true if x is a symbol without a namespace
 */
cljs.core.simple_symbol_QMARK_ = (function cljs$core$simple_symbol_QMARK_(x){
return (((x instanceof cljs.core.Symbol)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a symbol with a namespace
 */
cljs.core.qualified_symbol_QMARK_ = (function cljs$core$qualified_symbol_QMARK_(x){
return cljs.core.boolean$((function (){var and__9511__auto__ = (x instanceof cljs.core.Symbol);
if(and__9511__auto__){
var and__9511__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__9511__auto____$1)){
return true;
} else {
return and__9511__auto____$1;
}
} else {
return and__9511__auto__;
}
})());
});
/**
 * Return true if x is a keyword without a namespace
 */
cljs.core.simple_keyword_QMARK_ = (function cljs$core$simple_keyword_QMARK_(x){
return (((x instanceof cljs.core.Keyword)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a keyword with a namespace
 */
cljs.core.qualified_keyword_QMARK_ = (function cljs$core$qualified_keyword_QMARK_(x){
return cljs.core.boolean$((function (){var and__9511__auto__ = (x instanceof cljs.core.Keyword);
if(and__9511__auto__){
var and__9511__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__9511__auto____$1)){
return true;
} else {
return and__9511__auto____$1;
}
} else {
return and__9511__auto__;
}
})());
});
/**
 * Returns a Keyword with the given namespace and name.  Do not use :
 *   in the keyword strings, it will be added automatically.
 */
cljs.core.keyword = (function cljs$core$keyword(var_args){
var G__15383 = arguments.length;
switch (G__15383) {
case 1:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15384(name){
if((name instanceof cljs.core.Keyword)){
return name;
} else {
if((name instanceof cljs.core.Symbol)){
return (new cljs.core.Keyword(cljs.core.namespace(name),cljs.core.name(name),name.str,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("/",name)){
return (new cljs.core.Keyword(null,name,name,null));
} else {
if(typeof name === 'string'){
var parts = name.split("/");
if((parts.length === (2))){
return (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));
} else {
return (new cljs.core.Keyword(null,(parts[(0)]),name,null));
}
} else {
return null;
}
}
}
}
}));

(cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15385(ns,name){
var ns__$1 = (((ns instanceof cljs.core.Keyword))?cljs.core.name(ns):(((ns instanceof cljs.core.Symbol))?cljs.core.name(ns):ns
));
var name__$1 = (((name instanceof cljs.core.Keyword))?cljs.core.name(name):(((name instanceof cljs.core.Symbol))?cljs.core.name(name):name
));
return (new cljs.core.Keyword(ns__$1,name__$1,[(cljs.core.truth_(ns__$1)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns__$1),"/"].join(''):null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(name__$1)].join(''),null));
}));

(cljs.core.keyword.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.LazySeq = (function (meta,fn,s,__hash){
this.meta = meta;
this.fn = fn;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.LazySeq.prototype.toString = (function cljs$core$fn_15387(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.LazySeq.prototype.equiv = (function cljs$core$fn_15388(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.LazySeq.prototype.sval = (function cljs$core$fn_15389(){
var self__ = this;
var coll = this;
if((self__.fn == null)){
return self__.s;
} else {
(self__.s = (self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null)));

(self__.fn = null);

return self__.s;
}
}));

(cljs.core.LazySeq.prototype.indexOf = (function() {
var cljs$core$fn_15390 = null;
var cljs$core$fn_15390__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_15390__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15390 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15390__1.call(this,x);
case 2:
return cljs$core$fn_15390__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15390.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15390__1;
cljs$core$fn_15390.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15390__2;
return cljs$core$fn_15390;
})()
);

(cljs.core.LazySeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_15391 = null;
var cljs$core$fn_15391__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_15391__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15391 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15391__1.call(this,x);
case 2:
return cljs$core$fn_15391__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15391.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15391__1;
cljs$core$fn_15391.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15391__2;
return cljs$core$fn_15391;
})()
);

(cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15392(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_15393(coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((self__.s == null)){
return null;
} else {
return cljs.core.next(self__.s);
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15394(coll){
var self__ = this;
var coll__$1 = this;
var h__9978__auto__ = self__.__hash;
if((!((h__9978__auto__ == null)))){
return h__9978__auto__;
} else {
var h__9978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9978__auto____$1);

return h__9978__auto____$1;
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15395(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_15396(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.LazySeq.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function cljs$core$fn_15397(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.not(self__.fn);
}));

(cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_15398(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_15399(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_15400(coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((self__.s == null)){
return null;
} else {
return cljs.core.first(self__.s);
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_15401(coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((!((self__.s == null)))){
return cljs.core.rest(self__.s);
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_15402(coll){
var self__ = this;
var coll__$1 = this;
coll__$1.sval();

if((self__.s == null)){
return null;
} else {
var ls = self__.s;
while(true){
if((ls instanceof cljs.core.LazySeq)){
var G__15408 = ls.sval();
ls = G__15408;
continue;
} else {
(self__.s = ls);

return cljs.core.seq(self__.s);
}
break;
}
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_15403(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.LazySeq(new_meta,(function cljs$core$fn_15403_$_fn_15404(){
return coll__$1.cljs$core$ISeqable$_seq$arity$1(null);
}),null,self__.__hash));
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_15405(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.LazySeq.getBasis = (function cljs$core$fn_15406(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"fn","fn",465265323,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.LazySeq.cljs$lang$type = true);

(cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq");

(cljs.core.LazySeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_15407(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/LazySeq");
}));

/**
 * Positional factory function for cljs.core/LazySeq.
 */
cljs.core.__GT_LazySeq = (function cljs$core$__GT_LazySeq(meta,fn,s,__hash){
return (new cljs.core.LazySeq(meta,fn,s,__hash));
});

(cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15409(){
var this__10707__auto__ = this;
return cljs.core.es6_iterator(this__10707__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ICounted}
*/
cljs.core.ChunkBuffer = (function (buf,end){
this.buf = buf;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 2;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ChunkBuffer.prototype.add = (function cljs$core$fn_15410(o){
var self__ = this;
var _ = this;
(self__.buf[self__.end] = o);

return (self__.end = (self__.end + (1)));
}));

(cljs.core.ChunkBuffer.prototype.chunk = (function cljs$core$fn_15411(){
var self__ = this;
var _ = this;
var ret = (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));
(self__.buf = null);

return ret;
}));

(cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_15412(_){
var self__ = this;
var ___$1 = this;
return self__.end;
}));

(cljs.core.ChunkBuffer.getBasis = (function cljs$core$fn_15413(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"buf","buf",1426618187,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ChunkBuffer.cljs$lang$type = true);

(cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer");

(cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = (function cljs$core$fn_15414(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/ChunkBuffer");
}));

/**
 * Positional factory function for cljs.core/ChunkBuffer.
 */
cljs.core.__GT_ChunkBuffer = (function cljs$core$__GT_ChunkBuffer(buf,end){
return (new cljs.core.ChunkBuffer(buf,end));
});

cljs.core.chunk_buffer = (function cljs$core$chunk_buffer(capacity){
return (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.IChunk}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayChunk = (function (arr,off,end){
this.arr = arr;
this.off = off;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 524306;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_15415(_){
var self__ = this;
var ___$1 = this;
return (self__.end - self__.off);
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_15416(coll,i){
var self__ = this;
var coll__$1 = this;
return (self__.arr[(self__.off + i)]);
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_15417(coll,i,not_found){
var self__ = this;
var coll__$1 = this;
if((((i >= (0))) && ((i < (self__.end - self__.off))))){
return (self__.arr[(self__.off + i)]);
} else {
return not_found;
}
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function cljs$core$fn_15418(coll){
var self__ = this;
var coll__$1 = this;
if((self__.off === self__.end)){
throw (new Error("-drop-first of empty chunk"));
} else {
return (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));
}
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_15419(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_15420(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off);
}));

(cljs.core.ArrayChunk.getBasis = (function cljs$core$fn_15421(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null);
}));

(cljs.core.ArrayChunk.cljs$lang$type = true);

(cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk");

(cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = (function cljs$core$fn_15422(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/ArrayChunk");
}));

/**
 * Positional factory function for cljs.core/ArrayChunk.
 */
cljs.core.__GT_ArrayChunk = (function cljs$core$__GT_ArrayChunk(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk = (function cljs$core$array_chunk(var_args){
var G__15424 = arguments.length;
switch (G__15424) {
case 1:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15425(arr){
return (new cljs.core.ArrayChunk(arr,(0),arr.length));
}));

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15426(arr,off){
return (new cljs.core.ArrayChunk(arr,off,arr.length));
}));

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15427(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
}));

(cljs.core.array_chunk.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.ChunkedCons = (function (chunk,more,meta,__hash){
this.chunk = chunk;
this.more = more;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850732;
this.cljs$lang$protocol_mask$partition1$ = 1536;
});
(cljs.core.ChunkedCons.prototype.toString = (function cljs$core$fn_15429(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ChunkedCons.prototype.equiv = (function cljs$core$fn_15430(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ChunkedCons.prototype.indexOf = (function() {
var cljs$core$fn_15431 = null;
var cljs$core$fn_15431__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_15431__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15431 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15431__1.call(this,x);
case 2:
return cljs$core$fn_15431__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15431.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15431__1;
cljs$core$fn_15431.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15431__2;
return cljs$core$fn_15431;
})()
);

(cljs.core.ChunkedCons.prototype.lastIndexOf = (function() {
var cljs$core$fn_15432 = null;
var cljs$core$fn_15432__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_15432__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15432 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15432__1.call(this,x);
case 2:
return cljs$core$fn_15432__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15432.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15432__1;
cljs$core$fn_15432.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15432__2;
return cljs$core$fn_15432;
})()
);

(cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15433(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_15434(coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,null,null));
} else {
if((self__.more == null)){
return null;
} else {
return cljs.core._seq(self__.more);
}
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15435(coll){
var self__ = this;
var coll__$1 = this;
var h__9978__auto__ = self__.__hash;
if((!((h__9978__auto__ == null)))){
return h__9978__auto__;
} else {
var h__9978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9978__auto____$1);

return h__9978__auto____$1;
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15436(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_15437(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_15438(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk,(0));
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_15439(coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,null,null));
} else {
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_15440(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function cljs$core$fn_15441(coll){
var self__ = this;
var coll__$1 = this;
return self__.chunk;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function cljs$core$fn_15442(coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_15443(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ChunkedCons(self__.chunk,self__.more,new_meta,self__.__hash));
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_15444(this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,this$__$1);
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function cljs$core$fn_15445(coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return null;
} else {
return self__.more;
}
}));

(cljs.core.ChunkedCons.getBasis = (function cljs$core$fn_15446(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"chunk","chunk",449371907,null),new cljs.core.Symbol(null,"more","more",-418290273,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ChunkedCons.cljs$lang$type = true);

(cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons");

(cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = (function cljs$core$fn_15447(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/ChunkedCons");
}));

/**
 * Positional factory function for cljs.core/ChunkedCons.
 */
cljs.core.__GT_ChunkedCons = (function cljs$core$__GT_ChunkedCons(chunk,more,meta,__hash){
return (new cljs.core.ChunkedCons(chunk,more,meta,__hash));
});

(cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15448(){
var this__10707__auto__ = this;
return cljs.core.es6_iterator(this__10707__auto__);
}));
cljs.core.chunk_cons = (function cljs$core$chunk_cons(chunk,rest){
if((cljs.core._count(chunk) === (0))){
return rest;
} else {
return (new cljs.core.ChunkedCons(chunk,rest,null,null));
}
});
cljs.core.chunk_append = (function cljs$core$chunk_append(b,x){
return b.add(x);
});
cljs.core.chunk = (function cljs$core$chunk(b){
return b.chunk();
});
cljs.core.chunk_first = (function cljs$core$chunk_first(s){
return cljs.core._chunked_first(s);
});
cljs.core.chunk_rest = (function cljs$core$chunk_rest(s){
return cljs.core._chunked_rest(s);
});
cljs.core.chunk_next = (function cljs$core$chunk_next(s){
if((((!((s == null))))?(((((s.cljs$lang$protocol_mask$partition1$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$IChunkedNext$))))?true:false):false)){
return s.cljs$core$IChunkedNext$_chunked_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core._chunked_rest(s));
}
});
/**
 * Returns an array containing the contents of coll.
 */
cljs.core.to_array = (function cljs$core$to_array(coll){
var ary = [];
var s = cljs.core.seq(coll);
while(true){
if((!((s == null)))){
ary.push(cljs.core.first(s));

var G__15450 = cljs.core.next(s);
s = G__15450;
continue;
} else {
return ary;
}
break;
}
});
/**
 * Returns a (potentially-ragged) 2-dimensional array
 *   containing the contents of coll.
 */
cljs.core.to_array_2d = (function cljs$core$to_array_2d(coll){
var ret = (new Array(cljs.core.count(coll)));
var i_15451 = (0);
var xs_15452 = cljs.core.seq(coll);
while(true){
if((xs_15452 == null)){
} else {
(ret[i_15451] = cljs.core.to_array(cljs.core.first(xs_15452)));

var G__15453 = (i_15451 + (1));
var G__15454 = cljs.core.next(xs_15452);
i_15451 = G__15453;
xs_15452 = G__15454;
continue;
}
break;
}

return ret;
});
/**
 * Creates an array of ints. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.int_array = (function cljs$core$int_array(var_args){
var G__15456 = arguments.length;
switch (G__15456) {
case 1:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15457(size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15458(size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__15460 = (i + (1));
var G__15461 = cljs.core.next(s__$1);
i = G__15460;
s__$1 = G__15461;
continue;
} else {
return a;
}
break;
}
} else {
var n__10605__auto___15462 = size;
var i_15463 = (0);
while(true){
if((i_15463 < n__10605__auto___15462)){
(a[i_15463] = init_val_or_seq);

var G__15464 = (i_15463 + (1));
i_15463 = G__15464;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.int_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of longs. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.long_array = (function cljs$core$long_array(var_args){
var G__15466 = arguments.length;
switch (G__15466) {
case 1:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15467(size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15468(size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__15470 = (i + (1));
var G__15471 = cljs.core.next(s__$1);
i = G__15470;
s__$1 = G__15471;
continue;
} else {
return a;
}
break;
}
} else {
var n__10605__auto___15472 = size;
var i_15473 = (0);
while(true){
if((i_15473 < n__10605__auto___15472)){
(a[i_15473] = init_val_or_seq);

var G__15474 = (i_15473 + (1));
i_15473 = G__15474;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.long_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of doubles. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.double_array = (function cljs$core$double_array(var_args){
var G__15476 = arguments.length;
switch (G__15476) {
case 1:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15477(size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15478(size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__15480 = (i + (1));
var G__15481 = cljs.core.next(s__$1);
i = G__15480;
s__$1 = G__15481;
continue;
} else {
return a;
}
break;
}
} else {
var n__10605__auto___15482 = size;
var i_15483 = (0);
while(true){
if((i_15483 < n__10605__auto___15482)){
(a[i_15483] = init_val_or_seq);

var G__15484 = (i_15483 + (1));
i_15483 = G__15484;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.double_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of objects. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.object_array = (function cljs$core$object_array(var_args){
var G__15486 = arguments.length;
switch (G__15486) {
case 1:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15487(size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15488(size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__15490 = (i + (1));
var G__15491 = cljs.core.next(s__$1);
i = G__15490;
s__$1 = G__15491;
continue;
} else {
return a;
}
break;
}
} else {
var n__10605__auto___15492 = size;
var i_15493 = (0);
while(true){
if((i_15493 < n__10605__auto___15492)){
(a[i_15493] = init_val_or_seq);

var G__15494 = (i_15493 + (1));
i_15493 = G__15494;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.object_array.cljs$lang$maxFixedArity = 2);

/**
 * If coll is counted? returns its count, else will count at most the first n
 * elements of coll using its seq
 */
cljs.core.bounded_count = (function cljs$core$bounded_count(n,coll){
if(cljs.core.counted_QMARK_(coll)){
return cljs.core.count(coll);
} else {
var i = (0);
var s = cljs.core.seq(coll);
while(true){
if((((!((s == null)))) && ((i < n)))){
var G__15495 = (i + (1));
var G__15496 = cljs.core.next(s);
i = G__15495;
s = G__15496;
continue;
} else {
return i;
}
break;
}
}
});
cljs.core.spread = (function cljs$core$spread(arglist){
if((arglist == null)){
return null;
} else {
var n = cljs.core.next(arglist);
if((n == null)){
return cljs.core.seq(cljs.core.first(arglist));
} else {
return cljs.core.cons(cljs.core.first(arglist),(cljs.core.spread.cljs$core$IFn$_invoke$arity$1 ? cljs.core.spread.cljs$core$IFn$_invoke$arity$1(n) : cljs.core.spread.call(null,n)));
}
}
});
/**
 * Returns a lazy seq representing the concatenation of the elements in the supplied colls.
 */
cljs.core.concat = (function cljs$core$concat(var_args){
var G__15501 = arguments.length;
switch (G__15501) {
case 0:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15512 = arguments.length;
var i__10847__auto___15513 = (0);
while(true){
if((i__10847__auto___15513 < len__10846__auto___15512)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15513]));

var G__15514 = (i__10847__auto___15513 + (1));
i__10847__auto___15513 = G__15514;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15502(){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15502_$_fn_15503(){
return null;
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15504(x){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15504_$_fn_15505(){
return x;
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15506(x,y){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15506_$_fn_15507(){
var s = cljs.core.seq(x);
if(s){
if(cljs.core.chunked_seq_QMARK_(s)){
return cljs.core.chunk_cons(cljs.core.chunk_first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));
} else {
return cljs.core.cons(cljs.core.first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));
}
} else {
return y;
}
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15508(x,y,zs){
var cat = (function cljs$core$fn_15508_$_cat(xys,zs__$1){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15508_$_cat_$_fn_15509(){
var xys__$1 = cljs.core.seq(xys);
if(xys__$1){
if(cljs.core.chunked_seq_QMARK_(xys__$1)){
return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cljs$core$fn_15508_$_cat(cljs.core.chunk_rest(xys__$1),zs__$1));
} else {
return cljs.core.cons(cljs.core.first(xys__$1),cljs$core$fn_15508_$_cat(cljs.core.rest(xys__$1),zs__$1));
}
} else {
if(cljs.core.truth_(zs__$1)){
return cljs$core$fn_15508_$_cat(cljs.core.first(zs__$1),cljs.core.next(zs__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x,y),zs);
}));

/** @this {Function} */
(cljs.core.concat.cljs$lang$applyTo = (function cljs$core$fn_15510(seq15498){
var G__15499 = cljs.core.first(seq15498);
var seq15498__$1 = cljs.core.next(seq15498);
var G__15500 = cljs.core.first(seq15498__$1);
var seq15498__$2 = cljs.core.next(seq15498__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15499,G__15500,seq15498__$2);
}));

(cljs.core.concat.cljs$lang$maxFixedArity = (2));

/**
 * Creates a new list containing the items prepended to the rest, the
 *   last of which will be treated as a sequence.
 */
cljs.core.list_STAR_ = (function cljs$core$list_STAR_(var_args){
var G__15521 = arguments.length;
switch (G__15521) {
case 1:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15529 = arguments.length;
var i__10847__auto___15530 = (0);
while(true){
if((i__10847__auto___15530 < len__10846__auto___15529)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15530]));

var G__15531 = (i__10847__auto___15530 + (1));
i__10847__auto___15530 = G__15531;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((4) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((4)),(0),null)):null);
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10876__auto__);

}
});

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15522(args){
return cljs.core.seq(args);
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15523(a,args){
return cljs.core.cons(a,args);
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15524(a,b,args){
return cljs.core.cons(a,cljs.core.cons(b,args));
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15525(a,b,c,args){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)));
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15526(a,b,c,d,more){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))));
}));

/** @this {Function} */
(cljs.core.list_STAR_.cljs$lang$applyTo = (function cljs$core$fn_15527(seq15516){
var G__15517 = cljs.core.first(seq15516);
var seq15516__$1 = cljs.core.next(seq15516);
var G__15518 = cljs.core.first(seq15516__$1);
var seq15516__$2 = cljs.core.next(seq15516__$1);
var G__15519 = cljs.core.first(seq15516__$2);
var seq15516__$3 = cljs.core.next(seq15516__$2);
var G__15520 = cljs.core.first(seq15516__$3);
var seq15516__$4 = cljs.core.next(seq15516__$3);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15517,G__15518,G__15519,G__15520,seq15516__$4);
}));

(cljs.core.list_STAR_.cljs$lang$maxFixedArity = (4));

/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core.transient$ = (function cljs$core$transient(coll){
return cljs.core._as_transient(coll);
});
/**
 * Returns a new, persistent version of the transient collection, in
 *   constant time. The transient collection cannot be used after this
 *   call, any such use will throw an exception.
 */
cljs.core.persistent_BANG_ = (function cljs$core$persistent_BANG_(tcoll){
return cljs.core._persistent_BANG_(tcoll);
});
/**
 * Adds val to the transient collection, and return tcoll. The 'addition'
 *   may happen at different 'places' depending on the concrete type.
 */
cljs.core.conj_BANG_ = (function cljs$core$conj_BANG_(var_args){
var G__15536 = arguments.length;
switch (G__15536) {
case 0:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15543 = arguments.length;
var i__10847__auto___15544 = (0);
while(true){
if((i__10847__auto___15544 < len__10846__auto___15543)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15544]));

var G__15545 = (i__10847__auto___15544 + (1));
i__10847__auto___15544 = G__15545;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15537(){
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15538(tcoll){
return tcoll;
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15539(tcoll,val){
return cljs.core._conj_BANG_(tcoll,val);
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15540(tcoll,val,vals){
while(true){
var ntcoll = cljs.core._conj_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__15546 = ntcoll;
var G__15547 = cljs.core.first(vals);
var G__15548 = cljs.core.next(vals);
tcoll = G__15546;
val = G__15547;
vals = G__15548;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.conj_BANG_.cljs$lang$applyTo = (function cljs$core$fn_15541(seq15533){
var G__15534 = cljs.core.first(seq15533);
var seq15533__$1 = cljs.core.next(seq15533);
var G__15535 = cljs.core.first(seq15533__$1);
var seq15533__$2 = cljs.core.next(seq15533__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15534,G__15535,seq15533__$2);
}));

(cljs.core.conj_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * When applied to a transient map, adds mapping of key(s) to
 *   val(s). When applied to a transient vector, sets the val at index.
 *   Note - index must be <= (count vector). Returns coll.
 */
cljs.core.assoc_BANG_ = (function cljs$core$assoc_BANG_(var_args){
var G__15554 = arguments.length;
switch (G__15554) {
case 3:
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15559 = arguments.length;
var i__10847__auto___15560 = (0);
while(true){
if((i__10847__auto___15560 < len__10846__auto___15559)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15560]));

var G__15561 = (i__10847__auto___15560 + (1));
i__10847__auto___15560 = G__15561;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((3) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((3)),(0),null)):null);
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10876__auto__);

}
});

(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15555(tcoll,key,val){
return cljs.core._assoc_BANG_(tcoll,key,val);
}));

(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15556(tcoll,key,val,kvs){
while(true){
var ntcoll = cljs.core._assoc_BANG_(tcoll,key,val);
if(cljs.core.truth_(kvs)){
var G__15562 = ntcoll;
var G__15563 = cljs.core.first(kvs);
var G__15564 = cljs.core.second(kvs);
var G__15565 = cljs.core.nnext(kvs);
tcoll = G__15562;
key = G__15563;
val = G__15564;
kvs = G__15565;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.assoc_BANG_.cljs$lang$applyTo = (function cljs$core$fn_15557(seq15550){
var G__15551 = cljs.core.first(seq15550);
var seq15550__$1 = cljs.core.next(seq15550);
var G__15552 = cljs.core.first(seq15550__$1);
var seq15550__$2 = cljs.core.next(seq15550__$1);
var G__15553 = cljs.core.first(seq15550__$2);
var seq15550__$3 = cljs.core.next(seq15550__$2);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15551,G__15552,G__15553,seq15550__$3);
}));

(cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = (3));

/**
 * Returns a transient map that doesn't contain a mapping for key(s).
 */
cljs.core.dissoc_BANG_ = (function cljs$core$dissoc_BANG_(var_args){
var G__15570 = arguments.length;
switch (G__15570) {
case 2:
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15575 = arguments.length;
var i__10847__auto___15576 = (0);
while(true){
if((i__10847__auto___15576 < len__10846__auto___15575)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15576]));

var G__15577 = (i__10847__auto___15576 + (1));
i__10847__auto___15576 = G__15577;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15571(tcoll,key){
return cljs.core._dissoc_BANG_(tcoll,key);
}));

(cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15572(tcoll,key,ks){
while(true){
var ntcoll = cljs.core._dissoc_BANG_(tcoll,key);
if(cljs.core.truth_(ks)){
var G__15578 = ntcoll;
var G__15579 = cljs.core.first(ks);
var G__15580 = cljs.core.next(ks);
tcoll = G__15578;
key = G__15579;
ks = G__15580;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.dissoc_BANG_.cljs$lang$applyTo = (function cljs$core$fn_15573(seq15567){
var G__15568 = cljs.core.first(seq15567);
var seq15567__$1 = cljs.core.next(seq15567);
var G__15569 = cljs.core.first(seq15567__$1);
var seq15567__$2 = cljs.core.next(seq15567__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15568,G__15569,seq15567__$2);
}));

(cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Removes the last item from a transient vector. If
 *   the collection is empty, throws an exception. Returns tcoll
 */
cljs.core.pop_BANG_ = (function cljs$core$pop_BANG_(tcoll){
return cljs.core._pop_BANG_(tcoll);
});
/**
 * disj[oin]. Returns a transient set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj_BANG_ = (function cljs$core$disj_BANG_(var_args){
var G__15585 = arguments.length;
switch (G__15585) {
case 2:
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15590 = arguments.length;
var i__10847__auto___15591 = (0);
while(true){
if((i__10847__auto___15591 < len__10846__auto___15590)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15591]));

var G__15592 = (i__10847__auto___15591 + (1));
i__10847__auto___15591 = G__15592;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15586(tcoll,val){
return cljs.core._disjoin_BANG_(tcoll,val);
}));

(cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15587(tcoll,val,vals){
while(true){
var ntcoll = cljs.core._disjoin_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__15593 = ntcoll;
var G__15594 = cljs.core.first(vals);
var G__15595 = cljs.core.next(vals);
tcoll = G__15593;
val = G__15594;
vals = G__15595;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.disj_BANG_.cljs$lang$applyTo = (function cljs$core$fn_15588(seq15582){
var G__15583 = cljs.core.first(seq15582);
var seq15582__$1 = cljs.core.next(seq15582);
var G__15584 = cljs.core.first(seq15582__$1);
var seq15582__$2 = cljs.core.next(seq15582__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15583,G__15584,seq15582__$2);
}));

(cljs.core.disj_BANG_.cljs$lang$maxFixedArity = (2));


cljs.core.apply_to = (function cljs$core$apply_to(f,argc,args){
var args__$1 = cljs.core.seq(args);
if((argc === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var a10649 = cljs.core._first(args__$1);
var args__$2 = cljs.core._rest(args__$1);
if((argc === (1))){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(a10649) : f.call(null,a10649));
} else {
var b10650 = cljs.core._first(args__$2);
var args__$3 = cljs.core._rest(args__$2);
if((argc === (2))){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(a10649,b10650) : f.call(null,a10649,b10650));
} else {
var c10651 = cljs.core._first(args__$3);
var args__$4 = cljs.core._rest(args__$3);
if((argc === (3))){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(a10649,b10650,c10651) : f.call(null,a10649,b10650,c10651));
} else {
var d10652 = cljs.core._first(args__$4);
var args__$5 = cljs.core._rest(args__$4);
if((argc === (4))){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(a10649,b10650,c10651,d10652) : f.call(null,a10649,b10650,c10651,d10652));
} else {
var e10653 = cljs.core._first(args__$5);
var args__$6 = cljs.core._rest(args__$5);
if((argc === (5))){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(a10649,b10650,c10651,d10652,e10653) : f.call(null,a10649,b10650,c10651,d10652,e10653));
} else {
var f10654 = cljs.core._first(args__$6);
var args__$7 = cljs.core._rest(args__$6);
if((argc === (6))){
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(a10649,b10650,c10651,d10652,e10653,f10654) : f.call(null,a10649,b10650,c10651,d10652,e10653,f10654));
} else {
var g10655 = cljs.core._first(args__$7);
var args__$8 = cljs.core._rest(args__$7);
if((argc === (7))){
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(a10649,b10650,c10651,d10652,e10653,f10654,g10655) : f.call(null,a10649,b10650,c10651,d10652,e10653,f10654,g10655));
} else {
var h10656 = cljs.core._first(args__$8);
var args__$9 = cljs.core._rest(args__$8);
if((argc === (8))){
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656) : f.call(null,a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656));
} else {
var i10657 = cljs.core._first(args__$9);
var args__$10 = cljs.core._rest(args__$9);
if((argc === (9))){
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656,i10657) : f.call(null,a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656,i10657));
} else {
var j10658 = cljs.core._first(args__$10);
var args__$11 = cljs.core._rest(args__$10);
if((argc === (10))){
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656,i10657,j10658) : f.call(null,a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656,i10657,j10658));
} else {
var k10659 = cljs.core._first(args__$11);
var args__$12 = cljs.core._rest(args__$11);
if((argc === (11))){
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656,i10657,j10658,k10659) : f.call(null,a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656,i10657,j10658,k10659));
} else {
var l10660 = cljs.core._first(args__$12);
var args__$13 = cljs.core._rest(args__$12);
if((argc === (12))){
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656,i10657,j10658,k10659,l10660) : f.call(null,a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656,i10657,j10658,k10659,l10660));
} else {
var m10661 = cljs.core._first(args__$13);
var args__$14 = cljs.core._rest(args__$13);
if((argc === (13))){
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656,i10657,j10658,k10659,l10660,m10661) : f.call(null,a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656,i10657,j10658,k10659,l10660,m10661));
} else {
var n10662 = cljs.core._first(args__$14);
var args__$15 = cljs.core._rest(args__$14);
if((argc === (14))){
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656,i10657,j10658,k10659,l10660,m10661,n10662) : f.call(null,a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656,i10657,j10658,k10659,l10660,m10661,n10662));
} else {
var o10663 = cljs.core._first(args__$15);
var args__$16 = cljs.core._rest(args__$15);
if((argc === (15))){
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656,i10657,j10658,k10659,l10660,m10661,n10662,o10663) : f.call(null,a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656,i10657,j10658,k10659,l10660,m10661,n10662,o10663));
} else {
var p10664 = cljs.core._first(args__$16);
var args__$17 = cljs.core._rest(args__$16);
if((argc === (16))){
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656,i10657,j10658,k10659,l10660,m10661,n10662,o10663,p10664) : f.call(null,a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656,i10657,j10658,k10659,l10660,m10661,n10662,o10663,p10664));
} else {
var q10665 = cljs.core._first(args__$17);
var args__$18 = cljs.core._rest(args__$17);
if((argc === (17))){
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656,i10657,j10658,k10659,l10660,m10661,n10662,o10663,p10664,q10665) : f.call(null,a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656,i10657,j10658,k10659,l10660,m10661,n10662,o10663,p10664,q10665));
} else {
var r10666 = cljs.core._first(args__$18);
var args__$19 = cljs.core._rest(args__$18);
if((argc === (18))){
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656,i10657,j10658,k10659,l10660,m10661,n10662,o10663,p10664,q10665,r10666) : f.call(null,a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656,i10657,j10658,k10659,l10660,m10661,n10662,o10663,p10664,q10665,r10666));
} else {
var s10667 = cljs.core._first(args__$19);
var args__$20 = cljs.core._rest(args__$19);
if((argc === (19))){
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656,i10657,j10658,k10659,l10660,m10661,n10662,o10663,p10664,q10665,r10666,s10667) : f.call(null,a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656,i10657,j10658,k10659,l10660,m10661,n10662,o10663,p10664,q10665,r10666,s10667));
} else {
var t10668 = cljs.core._first(args__$20);
var args__$21 = cljs.core._rest(args__$20);
if((argc === (20))){
return (f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656,i10657,j10658,k10659,l10660,m10661,n10662,o10663,p10664,q10665,r10666,s10667,t10668) : f.call(null,a10649,b10650,c10651,d10652,e10653,f10654,g10655,h10656,i10657,j10658,k10659,l10660,m10661,n10662,o10663,p10664,q10665,r10666,s10667,t10668));
} else {
throw (new Error("Only up to 20 arguments supported on functions"));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

/**
 * Internal. DO NOT USE! Next without the nil? check.
 */
cljs.core.next_STAR_ = (function cljs$core$next_STAR_(coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$))))?true:false):false)){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
});
/**
 * Internal. DO NOT USE!
 *   Assumes args was already called with seq beforehand!
 */
cljs.core.apply_to_simple = (function cljs$core$apply_to_simple(var_args){
var G__15598 = arguments.length;
switch (G__15598) {
case 2:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15599(f,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$0){
return f.cljs$core$IFn$_invoke$arity$0();
} else {
return f.call(f);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(f,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15600(f,a0,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$1){
return f.cljs$core$IFn$_invoke$arity$1(a0);
} else {
return f.call(f,a0);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(f,a0,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15601(f,a0,a1,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$2){
return f.cljs$core$IFn$_invoke$arity$2(a0,a1);
} else {
return f.call(f,a0,a1);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(f,a0,a1,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_15602(f,a0,a1,a2,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$3){
return f.cljs$core$IFn$_invoke$arity$3(a0,a1,a2);
} else {
return f.call(f,a0,a1,a2);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(f,a0,a1,a2,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_15603(f,a0,a1,a2,a3,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$4){
return f.cljs$core$IFn$_invoke$arity$4(a0,a1,a2,a3);
} else {
return f.call(f,a0,a1,a2,a3);
}
} else {
var a4 = cljs.core._first(args);
var next_4 = cljs.core.next(args);
if((next_4 == null)){
if(f.cljs$core$IFn$_invoke$arity$5){
return f.cljs$core$IFn$_invoke$arity$5(a0,a1,a2,a3,a4);
} else {
return f.call(f,a0,a1,a2,a3,a4);
}
} else {
var a5 = cljs.core._first(next_4);
var next_5 = cljs.core.next(next_4);
if((next_5 == null)){
if(f.cljs$core$IFn$_invoke$arity$6){
return f.cljs$core$IFn$_invoke$arity$6(a0,a1,a2,a3,a4,a5);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5);
}
} else {
var a6 = cljs.core._first(next_5);
var next_6 = cljs.core.next(next_5);
if((next_6 == null)){
if(f.cljs$core$IFn$_invoke$arity$7){
return f.cljs$core$IFn$_invoke$arity$7(a0,a1,a2,a3,a4,a5,a6);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6);
}
} else {
var a7 = cljs.core._first(next_6);
var next_7 = cljs.core.next(next_6);
if((next_7 == null)){
if(f.cljs$core$IFn$_invoke$arity$8){
return f.cljs$core$IFn$_invoke$arity$8(a0,a1,a2,a3,a4,a5,a6,a7);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7);
}
} else {
var a8 = cljs.core._first(next_7);
var next_8 = cljs.core.next(next_7);
if((next_8 == null)){
if(f.cljs$core$IFn$_invoke$arity$9){
return f.cljs$core$IFn$_invoke$arity$9(a0,a1,a2,a3,a4,a5,a6,a7,a8);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8);
}
} else {
var a9 = cljs.core._first(next_8);
var next_9 = cljs.core.next(next_8);
if((next_9 == null)){
if(f.cljs$core$IFn$_invoke$arity$10){
return f.cljs$core$IFn$_invoke$arity$10(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);
}
} else {
var a10 = cljs.core._first(next_9);
var next_10 = cljs.core.next(next_9);
if((next_10 == null)){
if(f.cljs$core$IFn$_invoke$arity$11){
return f.cljs$core$IFn$_invoke$arity$11(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
}
} else {
var a11 = cljs.core._first(next_10);
var next_11 = cljs.core.next(next_10);
if((next_11 == null)){
if(f.cljs$core$IFn$_invoke$arity$12){
return f.cljs$core$IFn$_invoke$arity$12(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
}
} else {
var a12 = cljs.core._first(next_11);
var next_12 = cljs.core.next(next_11);
if((next_12 == null)){
if(f.cljs$core$IFn$_invoke$arity$13){
return f.cljs$core$IFn$_invoke$arity$13(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);
}
} else {
var a13 = cljs.core._first(next_12);
var next_13 = cljs.core.next(next_12);
if((next_13 == null)){
if(f.cljs$core$IFn$_invoke$arity$14){
return f.cljs$core$IFn$_invoke$arity$14(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13);
}
} else {
var a14 = cljs.core._first(next_13);
var next_14 = cljs.core.next(next_13);
if((next_14 == null)){
if(f.cljs$core$IFn$_invoke$arity$15){
return f.cljs$core$IFn$_invoke$arity$15(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14);
}
} else {
var a15 = cljs.core._first(next_14);
var next_15 = cljs.core.next(next_14);
if((next_15 == null)){
if(f.cljs$core$IFn$_invoke$arity$16){
return f.cljs$core$IFn$_invoke$arity$16(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);
}
} else {
var a16 = cljs.core._first(next_15);
var next_16 = cljs.core.next(next_15);
if((next_16 == null)){
if(f.cljs$core$IFn$_invoke$arity$17){
return f.cljs$core$IFn$_invoke$arity$17(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16);
}
} else {
var a17 = cljs.core._first(next_16);
var next_17 = cljs.core.next(next_16);
if((next_17 == null)){
if(f.cljs$core$IFn$_invoke$arity$18){
return f.cljs$core$IFn$_invoke$arity$18(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17);
}
} else {
var a18 = cljs.core._first(next_17);
var next_18 = cljs.core.next(next_17);
if((next_18 == null)){
if(f.cljs$core$IFn$_invoke$arity$19){
return f.cljs$core$IFn$_invoke$arity$19(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18);
}
} else {
var a19 = cljs.core._first(next_18);
var next_19 = cljs.core.next(next_18);
if((next_19 == null)){
if(f.cljs$core$IFn$_invoke$arity$20){
return f.cljs$core$IFn$_invoke$arity$20(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19);
}
} else {
var arr__10677__auto__ = [a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19];
var s__10678__auto___15605 = next_19;
while(true){
if(s__10678__auto___15605){
arr__10677__auto__.push(cljs.core._first(s__10678__auto___15605));

var G__15606 = cljs.core.next(s__10678__auto___15605);
s__10678__auto___15605 = G__15606;
continue;
} else {
}
break;
}

return f.apply(f,arr__10677__auto__);
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(cljs.core.apply_to_simple.cljs$lang$maxFixedArity = 6);

/**
 * Applies fn f to the argument list formed by prepending intervening arguments to args.
 */
cljs.core.apply = (function cljs$core$apply(var_args){
var G__15614 = arguments.length;
switch (G__15614) {
case 2:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15622 = arguments.length;
var i__10847__auto___15623 = (0);
while(true){
if((i__10847__auto___15623 < len__10846__auto___15622)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15623]));

var G__15624 = (i__10847__auto___15623 + (1));
i__10847__auto___15623 = G__15624;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((5) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((5)),(0),null)):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__10876__auto__);

}
});

(cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15615(f,args){
if(f.cljs$lang$applyTo){
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = cljs.core.bounded_count((fixed_arity + (1)),args);
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,args);
} else {
return f.cljs$lang$applyTo(args);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2(f,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15616(f,x,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = (cljs.core.bounded_count(fixed_arity,args) + (1));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(f,x,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15617(f,x,y,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x,y,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((2) + cljs.core.bounded_count((fixed_arity - (1)),args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(f,x,y,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_15618(f,x,y,z,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x,y,z,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((3) + cljs.core.bounded_count((fixed_arity - (2)),args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(f,x,y,z,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15619(f,a,b,c,d,args){
if(f.cljs$lang$applyTo){
var spread_args = cljs.core.spread(args);
var arglist = cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,spread_args))));
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((4) + cljs.core.bounded_count((fixed_arity - (3)),spread_args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(f,a,b,c,d,cljs.core.spread(args));
}
}));

/** @this {Function} */
(cljs.core.apply.cljs$lang$applyTo = (function cljs$core$fn_15620(seq15608){
var G__15609 = cljs.core.first(seq15608);
var seq15608__$1 = cljs.core.next(seq15608);
var G__15610 = cljs.core.first(seq15608__$1);
var seq15608__$2 = cljs.core.next(seq15608__$1);
var G__15611 = cljs.core.first(seq15608__$2);
var seq15608__$3 = cljs.core.next(seq15608__$2);
var G__15612 = cljs.core.first(seq15608__$3);
var seq15608__$4 = cljs.core.next(seq15608__$3);
var G__15613 = cljs.core.first(seq15608__$4);
var seq15608__$5 = cljs.core.next(seq15608__$4);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15609,G__15610,G__15611,G__15612,G__15613,seq15608__$5);
}));

(cljs.core.apply.cljs$lang$maxFixedArity = (5));

cljs.core.__destructure_map = (function cljs$core$__destructure_map(gmap){
if((((!((gmap == null))))?(((((gmap.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === gmap.cljs$core$ISeq$))))?true:false):false)){
if(cljs.core.next(gmap)){
return cljs.core.PersistentArrayMap.createAsIfByAssoc(cljs.core.to_array(gmap));
} else {
if(cljs.core.seq(gmap)){
return cljs.core.first(gmap);
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
}
} else {
return gmap;
}
});
/**
 * Returns an object of the same type and value as obj, with
 *   (apply f (meta obj) args) as its metadata.
 */
cljs.core.vary_meta = (function cljs$core$vary_meta(var_args){
var G__15634 = arguments.length;
switch (G__15634) {
case 2:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15658 = arguments.length;
var i__10847__auto___15659 = (0);
while(true){
if((i__10847__auto___15659 < len__10846__auto___15658)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15659]));

var G__15660 = (i__10847__auto___15659 + (1));
i__10847__auto___15659 = G__15660;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((6) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((6)),(0),null)):null);
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__10876__auto__);

}
});

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15635(obj,f){
return cljs.core.with_meta(obj,(function (){var G__15636 = cljs.core.meta(obj);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15636) : f.call(null,G__15636));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15637(obj,f,a){
return cljs.core.with_meta(obj,(function (){var G__15638 = cljs.core.meta(obj);
var G__15639 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15638,G__15639) : f.call(null,G__15638,G__15639));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15640(obj,f,a,b){
return cljs.core.with_meta(obj,(function (){var G__15641 = cljs.core.meta(obj);
var G__15642 = a;
var G__15643 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15641,G__15642,G__15643) : f.call(null,G__15641,G__15642,G__15643));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_15644(obj,f,a,b,c){
return cljs.core.with_meta(obj,(function (){var G__15645 = cljs.core.meta(obj);
var G__15646 = a;
var G__15647 = b;
var G__15648 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__15645,G__15646,G__15647,G__15648) : f.call(null,G__15645,G__15646,G__15647,G__15648));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_15649(obj,f,a,b,c,d){
return cljs.core.with_meta(obj,(function (){var G__15650 = cljs.core.meta(obj);
var G__15651 = a;
var G__15652 = b;
var G__15653 = c;
var G__15654 = d;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__15650,G__15651,G__15652,G__15653,G__15654) : f.call(null,G__15650,G__15651,G__15652,G__15653,G__15654));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15655(obj,f,a,b,c,d,args){
return cljs.core.with_meta(obj,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.meta(obj),a,b,c,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([d,args], 0)));
}));

/** @this {Function} */
(cljs.core.vary_meta.cljs$lang$applyTo = (function cljs$core$fn_15656(seq15627){
var G__15628 = cljs.core.first(seq15627);
var seq15627__$1 = cljs.core.next(seq15627);
var G__15629 = cljs.core.first(seq15627__$1);
var seq15627__$2 = cljs.core.next(seq15627__$1);
var G__15630 = cljs.core.first(seq15627__$2);
var seq15627__$3 = cljs.core.next(seq15627__$2);
var G__15631 = cljs.core.first(seq15627__$3);
var seq15627__$4 = cljs.core.next(seq15627__$3);
var G__15632 = cljs.core.first(seq15627__$4);
var seq15627__$5 = cljs.core.next(seq15627__$4);
var G__15633 = cljs.core.first(seq15627__$5);
var seq15627__$6 = cljs.core.next(seq15627__$5);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15628,G__15629,G__15630,G__15631,G__15632,G__15633,seq15627__$6);
}));

(cljs.core.vary_meta.cljs$lang$maxFixedArity = (6));

/**
 * Same as (not (= obj1 obj2))
 */
cljs.core.not_EQ_ = (function cljs$core$not_EQ_(var_args){
var G__15665 = arguments.length;
switch (G__15665) {
case 1:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15671 = arguments.length;
var i__10847__auto___15672 = (0);
while(true){
if((i__10847__auto___15672 < len__10846__auto___15671)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15672]));

var G__15673 = (i__10847__auto___15672 + (1));
i__10847__auto___15672 = G__15673;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15666(x){
return false;
}));

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15667(x,y){
return (!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)));
}));

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15668(x,y,more){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more));
}));

/** @this {Function} */
(cljs.core.not_EQ_.cljs$lang$applyTo = (function cljs$core$fn_15669(seq15662){
var G__15663 = cljs.core.first(seq15662);
var seq15662__$1 = cljs.core.next(seq15662);
var G__15664 = cljs.core.first(seq15662__$1);
var seq15662__$2 = cljs.core.next(seq15662__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15663,G__15664,seq15662__$2);
}));

(cljs.core.not_EQ_.cljs$lang$maxFixedArity = (2));

/**
 * If coll is empty, returns nil, else coll
 */
cljs.core.not_empty = (function cljs$core$not_empty(coll){
if(cljs.core.seq(coll)){
return coll;
} else {
return null;
}
});
cljs.core.nil_iter = (function cljs$core$nil_iter(){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.t_cljs$core15674 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.t_cljs$core15674 = (function (meta15675){
this.meta15675 = meta15675;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.t_cljs$core15674.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$nil_iter_$_fn_15677(_15676,meta15675__$1){
var self__ = this;
var _15676__$1 = this;
return (new cljs.core.t_cljs$core15674(meta15675__$1));
}));

(cljs.core.t_cljs$core15674.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$nil_iter_$_fn_15678(_15676){
var self__ = this;
var _15676__$1 = this;
return self__.meta15675;
}));

(cljs.core.t_cljs$core15674.prototype.hasNext = (function cljs$core$nil_iter_$_fn_15679(){
var self__ = this;
var _ = this;
return false;
}));

(cljs.core.t_cljs$core15674.prototype.next = (function cljs$core$nil_iter_$_fn_15680(){
var self__ = this;
var _ = this;
return (new Error("No such element"));
}));

(cljs.core.t_cljs$core15674.prototype.remove = (function cljs$core$nil_iter_$_fn_15681(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.t_cljs$core15674.getBasis = (function cljs$core$nil_iter_$_fn_15682(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta15675","meta15675",-1391224304,null)], null);
}));

(cljs.core.t_cljs$core15674.cljs$lang$type = true);

(cljs.core.t_cljs$core15674.cljs$lang$ctorStr = "cljs.core/t_cljs$core15674");

(cljs.core.t_cljs$core15674.cljs$lang$ctorPrWriter = (function cljs$core$nil_iter_$_fn_15683(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/t_cljs$core15674");
}));

/**
 * Positional factory function for cljs.core/t_cljs$core15674.
 */
cljs.core.__GT_t_cljs$core15674 = (function cljs$core$nil_iter_$___GT_t_cljs$core15674(meta15675){
return (new cljs.core.t_cljs$core15674(meta15675));
});

}

return (new cljs.core.t_cljs$core15674(cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
*/
cljs.core.StringIter = (function (s,i){
this.s = s;
this.i = i;
});
(cljs.core.StringIter.prototype.hasNext = (function cljs$core$fn_15684(){
var self__ = this;
var _ = this;
return (self__.i < self__.s.length);
}));

(cljs.core.StringIter.prototype.next = (function cljs$core$fn_15685(){
var self__ = this;
var _ = this;
var ret = self__.s.charAt(self__.i);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.StringIter.prototype.remove = (function cljs$core$fn_15686(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.StringIter.getBasis = (function cljs$core$fn_15687(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.StringIter.cljs$lang$type = true);

(cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter");

(cljs.core.StringIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_15688(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/StringIter");
}));

/**
 * Positional factory function for cljs.core/StringIter.
 */
cljs.core.__GT_StringIter = (function cljs$core$__GT_StringIter(s,i){
return (new cljs.core.StringIter(s,i));
});

cljs.core.string_iter = (function cljs$core$string_iter(x){
return (new cljs.core.StringIter(x,(0)));
});

/**
* @constructor
*/
cljs.core.ArrayIter = (function (arr,i){
this.arr = arr;
this.i = i;
});
(cljs.core.ArrayIter.prototype.hasNext = (function cljs$core$fn_15689(){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
}));

(cljs.core.ArrayIter.prototype.next = (function cljs$core$fn_15690(){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.ArrayIter.prototype.remove = (function cljs$core$fn_15691(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.ArrayIter.getBasis = (function cljs$core$fn_15692(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayIter.cljs$lang$type = true);

(cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter");

(cljs.core.ArrayIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_15693(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/ArrayIter");
}));

/**
 * Positional factory function for cljs.core/ArrayIter.
 */
cljs.core.__GT_ArrayIter = (function cljs$core$__GT_ArrayIter(arr,i){
return (new cljs.core.ArrayIter(arr,i));
});

cljs.core.array_iter = (function cljs$core$array_iter(x){
return (new cljs.core.ArrayIter(x,(0)));
});
cljs.core.INIT = ({});
cljs.core.START = ({});

/**
* @constructor
*/
cljs.core.SeqIter = (function (_seq,_next){
this._seq = _seq;
this._next = _next;
});
(cljs.core.SeqIter.prototype.hasNext = (function cljs$core$fn_15694(){
var self__ = this;
var _ = this;
if((self__._seq === cljs.core.INIT)){
(self__._seq = cljs.core.START);

(self__._next = cljs.core.seq(self__._next));
} else {
if((self__._seq === self__._next)){
(self__._next = cljs.core.next(self__._seq));
} else {
}
}

return (!((self__._next == null)));
}));

(cljs.core.SeqIter.prototype.next = (function cljs$core$fn_15695(){
var self__ = this;
var this$ = this;
if((!(this$.hasNext()))){
throw (new Error("No such element"));
} else {
(self__._seq = self__._next);

return cljs.core.first(self__._next);
}
}));

(cljs.core.SeqIter.prototype.remove = (function cljs$core$fn_15696(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.SeqIter.getBasis = (function cljs$core$fn_15697(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"_seq","_seq",-449557847,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.SeqIter.cljs$lang$type = true);

(cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter");

(cljs.core.SeqIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_15698(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/SeqIter");
}));

/**
 * Positional factory function for cljs.core/SeqIter.
 */
cljs.core.__GT_SeqIter = (function cljs$core$__GT_SeqIter(_seq,_next){
return (new cljs.core.SeqIter(_seq,_next));
});

cljs.core.seq_iter = (function cljs$core$seq_iter(coll){
return (new cljs.core.SeqIter(cljs.core.INIT,coll));
});
cljs.core.iter = (function cljs$core$iter(coll){
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core._iterator(coll);
} else {
if((coll == null)){
return cljs.core.nil_iter();
} else {
if(typeof coll === 'string'){
return cljs.core.string_iter(coll);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_iter(coll);
} else {
if(cljs.core.seqable_QMARK_(coll)){
return cljs.core.seq_iter(coll);
} else {
throw (new Error(["Cannot create iterator from ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll)].join('')));

}
}
}
}
}
});

/**
* @constructor
*/
cljs.core.Many = (function (vals){
this.vals = vals;
});
(cljs.core.Many.prototype.add = (function cljs$core$fn_15699(o){
var self__ = this;
var this$ = this;
self__.vals.push(o);

return this$;
}));

(cljs.core.Many.prototype.remove = (function cljs$core$fn_15700(){
var self__ = this;
var this$ = this;
return self__.vals.shift();
}));

(cljs.core.Many.prototype.isEmpty = (function cljs$core$fn_15701(){
var self__ = this;
var this$ = this;
return (self__.vals.length === (0));
}));

(cljs.core.Many.prototype.toString = (function cljs$core$fn_15702(){
var self__ = this;
var this$ = this;
return ["Many: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.vals)].join('');
}));

(cljs.core.Many.getBasis = (function cljs$core$fn_15703(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"vals","vals",-1886377036,null)], null);
}));

(cljs.core.Many.cljs$lang$type = true);

(cljs.core.Many.cljs$lang$ctorStr = "cljs.core/Many");

(cljs.core.Many.cljs$lang$ctorPrWriter = (function cljs$core$fn_15704(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/Many");
}));

/**
 * Positional factory function for cljs.core/Many.
 */
cljs.core.__GT_Many = (function cljs$core$__GT_Many(vals){
return (new cljs.core.Many(vals));
});

cljs.core.NONE = ({});

/**
* @constructor
*/
cljs.core.Single = (function (val){
this.val = val;
});
(cljs.core.Single.prototype.add = (function cljs$core$fn_15705(o){
var self__ = this;
var this$ = this;
if((self__.val === cljs.core.NONE)){
(self__.val = o);

return this$;
} else {
return (new cljs.core.Many([self__.val,o]));
}
}));

(cljs.core.Single.prototype.remove = (function cljs$core$fn_15706(){
var self__ = this;
var this$ = this;
if((self__.val === cljs.core.NONE)){
throw (new Error("Removing object from empty buffer"));
} else {
var ret = self__.val;
(self__.val = cljs.core.NONE);

return ret;
}
}));

(cljs.core.Single.prototype.isEmpty = (function cljs$core$fn_15707(){
var self__ = this;
var this$ = this;
return (self__.val === cljs.core.NONE);
}));

(cljs.core.Single.prototype.toString = (function cljs$core$fn_15708(){
var self__ = this;
var this$ = this;
return ["Single: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.val)].join('');
}));

(cljs.core.Single.getBasis = (function cljs$core$fn_15709(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Single.cljs$lang$type = true);

(cljs.core.Single.cljs$lang$ctorStr = "cljs.core/Single");

(cljs.core.Single.cljs$lang$ctorPrWriter = (function cljs$core$fn_15710(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/Single");
}));

/**
 * Positional factory function for cljs.core/Single.
 */
cljs.core.__GT_Single = (function cljs$core$__GT_Single(val){
return (new cljs.core.Single(val));
});


/**
* @constructor
*/
cljs.core.Empty = (function (){
});
(cljs.core.Empty.prototype.add = (function cljs$core$fn_15711(o){
var self__ = this;
var this$ = this;
return (new cljs.core.Single(o));
}));

(cljs.core.Empty.prototype.remove = (function cljs$core$fn_15712(){
var self__ = this;
var this$ = this;
throw (new Error("Removing object from empty buffer"));
}));

(cljs.core.Empty.prototype.isEmpty = (function cljs$core$fn_15713(){
var self__ = this;
var this$ = this;
return true;
}));

(cljs.core.Empty.prototype.toString = (function cljs$core$fn_15714(){
var self__ = this;
var this$ = this;
return "Empty";
}));

(cljs.core.Empty.getBasis = (function cljs$core$fn_15715(){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.Empty.cljs$lang$type = true);

(cljs.core.Empty.cljs$lang$ctorStr = "cljs.core/Empty");

(cljs.core.Empty.cljs$lang$ctorPrWriter = (function cljs$core$fn_15716(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/Empty");
}));

/**
 * Positional factory function for cljs.core/Empty.
 */
cljs.core.__GT_Empty = (function cljs$core$__GT_Empty(){
return (new cljs.core.Empty());
});

cljs.core.EMPTY = (new cljs.core.Empty());

/**
* @constructor
*/
cljs.core.MultiIterator = (function (iters){
this.iters = iters;
});
(cljs.core.MultiIterator.prototype.hasNext = (function cljs$core$fn_15717(){
var self__ = this;
var _ = this;
var iters__$1 = cljs.core.seq(self__.iters);
while(true){
if((!((iters__$1 == null)))){
var iter = cljs.core.first(iters__$1);
if((!(iter.hasNext()))){
return false;
} else {
var G__15721 = cljs.core.next(iters__$1);
iters__$1 = G__15721;
continue;
}
} else {
return true;
}
break;
}
}));

(cljs.core.MultiIterator.prototype.next = (function cljs$core$fn_15718(){
var self__ = this;
var _ = this;
var nexts = [];
var n__10605__auto___15722 = self__.iters.length;
var i_15723 = (0);
while(true){
if((i_15723 < n__10605__auto___15722)){
(nexts[i_15723] = (self__.iters[i_15723]).next());

var G__15724 = (i_15723 + (1));
i_15723 = G__15724;
continue;
} else {
}
break;
}

return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(nexts,(0));
}));

(cljs.core.MultiIterator.getBasis = (function cljs$core$fn_15719(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"iters","iters",719353031,null)], null);
}));

(cljs.core.MultiIterator.cljs$lang$type = true);

(cljs.core.MultiIterator.cljs$lang$ctorStr = "cljs.core/MultiIterator");

(cljs.core.MultiIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_15720(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/MultiIterator");
}));

/**
 * Positional factory function for cljs.core/MultiIterator.
 */
cljs.core.__GT_MultiIterator = (function cljs$core$__GT_MultiIterator(iters){
return (new cljs.core.MultiIterator(iters));
});

cljs.core.chunkIteratorSeq = (function cljs$core$chunkIteratorSeq(iter){
return (new cljs.core.LazySeq(null,(function cljs$core$chunkIteratorSeq_$_fn_15725(){
if(iter.hasNext()){
var arr = [];
var n = (0);
while(true){
if(cljs.core.truth_((function (){var and__9511__auto__ = iter.hasNext();
if(cljs.core.truth_(and__9511__auto__)){
return (n < (32));
} else {
return and__9511__auto__;
}
})())){
(arr[n] = iter.next());

var G__15726 = (n + (1));
n = G__15726;
continue;
} else {
return cljs.core.chunk_cons(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3(arr,(0),n),(cljs.core.chunkIteratorSeq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunkIteratorSeq.cljs$core$IFn$_invoke$arity$1(iter) : cljs.core.chunkIteratorSeq.call(null,iter)));
}
break;
}
} else {
return null;
}
}),null,null));
});

/**
* @constructor
*/
cljs.core.TransformerIterator = (function (buffer,_next,completed,xf,sourceIter,multi){
this.buffer = buffer;
this._next = _next;
this.completed = completed;
this.xf = xf;
this.sourceIter = sourceIter;
this.multi = multi;
});
(cljs.core.TransformerIterator.prototype.step = (function cljs$core$fn_15727(){
var self__ = this;
var this$ = this;
if((!((self__._next === cljs.core.NONE)))){
return true;
} else {
while(true){
if((self__._next === cljs.core.NONE)){
if(self__.buffer.isEmpty()){
if(self__.completed){
return false;
} else {
if(self__.sourceIter.hasNext()){
var iter = ((self__.multi)?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xf,cljs.core.cons(null,self__.sourceIter.next())):(function (){var G__15728 = null;
var G__15729 = self__.sourceIter.next();
return (self__.xf.cljs$core$IFn$_invoke$arity$2 ? self__.xf.cljs$core$IFn$_invoke$arity$2(G__15728,G__15729) : self__.xf.call(null,G__15728,G__15729));
})());
if(cljs.core.reduced_QMARK_(iter)){
(self__.xf.cljs$core$IFn$_invoke$arity$1 ? self__.xf.cljs$core$IFn$_invoke$arity$1(null) : self__.xf.call(null,null));

(self__.completed = true);
} else {
}

continue;
} else {
(self__.xf.cljs$core$IFn$_invoke$arity$1 ? self__.xf.cljs$core$IFn$_invoke$arity$1(null) : self__.xf.call(null,null));

(self__.completed = true);

continue;
}
}
} else {
(self__._next = self__.buffer.remove());

continue;
}
} else {
return true;
}
break;
}
}
}));

(cljs.core.TransformerIterator.prototype.hasNext = (function cljs$core$fn_15730(){
var self__ = this;
var this$ = this;
return this$.step();
}));

(cljs.core.TransformerIterator.prototype.next = (function cljs$core$fn_15731(){
var self__ = this;
var this$ = this;
if(this$.hasNext()){
var ret = self__._next;
(self__._next = cljs.core.NONE);

return ret;
} else {
throw (new Error("No such element"));
}
}));

(cljs.core.TransformerIterator.prototype.remove = (function cljs$core$fn_15732(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.TransformerIterator.getBasis = (function cljs$core$fn_15733(){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"buffer","buffer",-2037140571,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"completed","completed",1154475024,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"xf","xf",2042434515,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"sourceIter","sourceIter",1068220306,null),new cljs.core.Symbol(null,"multi","multi",1450238522,null)], null);
}));

(cljs.core.TransformerIterator.cljs$lang$type = true);

(cljs.core.TransformerIterator.cljs$lang$ctorStr = "cljs.core/TransformerIterator");

(cljs.core.TransformerIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_15734(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/TransformerIterator");
}));

/**
 * Positional factory function for cljs.core/TransformerIterator.
 */
cljs.core.__GT_TransformerIterator = (function cljs$core$__GT_TransformerIterator(buffer,_next,completed,xf,sourceIter,multi){
return (new cljs.core.TransformerIterator(buffer,_next,completed,xf,sourceIter,multi));
});

(cljs.core.TransformerIterator.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15735(){
var this__10707__auto__ = this;
return cljs.core.es6_iterator(this__10707__auto__);
}));
cljs.core.transformer_iterator = (function cljs$core$transformer_iterator(xform,sourceIter,multi){
var iterator = (new cljs.core.TransformerIterator(cljs.core.EMPTY,cljs.core.NONE,false,null,sourceIter,multi));
(iterator.xf = (function (){var G__15736 = (function() {
var cljs$core$transformer_iterator_$_fn_15737 = null;
var cljs$core$transformer_iterator_$_fn_15737__0 = (function (){
return null;
});
var cljs$core$transformer_iterator_$_fn_15737__1 = (function (acc){
return acc;
});
var cljs$core$transformer_iterator_$_fn_15737__2 = (function (acc,o){
(iterator.buffer = iterator.buffer.add(o));

return acc;
});
cljs$core$transformer_iterator_$_fn_15737 = function(acc,o){
switch(arguments.length){
case 0:
return cljs$core$transformer_iterator_$_fn_15737__0.call(this);
case 1:
return cljs$core$transformer_iterator_$_fn_15737__1.call(this,acc);
case 2:
return cljs$core$transformer_iterator_$_fn_15737__2.call(this,acc,o);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$transformer_iterator_$_fn_15737.cljs$core$IFn$_invoke$arity$0 = cljs$core$transformer_iterator_$_fn_15737__0;
cljs$core$transformer_iterator_$_fn_15737.cljs$core$IFn$_invoke$arity$1 = cljs$core$transformer_iterator_$_fn_15737__1;
cljs$core$transformer_iterator_$_fn_15737.cljs$core$IFn$_invoke$arity$2 = cljs$core$transformer_iterator_$_fn_15737__2;
return cljs$core$transformer_iterator_$_fn_15737;
})()
;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__15736) : xform.call(null,G__15736));
})());

return iterator;
});
(cljs.core.TransformerIterator.create = (function cljs$core$fn_15738(xform,source){
return cljs.core.transformer_iterator(xform,source,false);
}));
(cljs.core.TransformerIterator.createMulti = (function cljs$core$fn_15739(xform,sources){
return cljs.core.transformer_iterator(xform,(new cljs.core.MultiIterator(cljs.core.to_array(sources))),true);
}));
/**
 * Coerces coll to a (possibly empty) sequence, if it is not already
 *   one. Will not force a lazy seq. (sequence nil) yields (), When a
 *   transducer is supplied, returns a lazy sequence of applications of
 *   the transform to the items in coll(s), i.e. to the set of first
 *   items of each coll, followed by the set of second
 *   items in each coll, until any one of the colls is exhausted.  Any
 *   remaining items in other colls are ignored. The transform should accept
 *   number-of-colls arguments
 */
cljs.core.sequence = (function cljs$core$sequence(var_args){
var G__15744 = arguments.length;
switch (G__15744) {
case 1:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15750 = arguments.length;
var i__10847__auto___15751 = (0);
while(true){
if((i__10847__auto___15751 < len__10846__auto___15750)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15751]));

var G__15752 = (i__10847__auto___15751 + (1));
i__10847__auto___15751 = G__15752;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15745(coll){
if(cljs.core.seq_QMARK_(coll)){
return coll;
} else {
var or__9517__auto__ = cljs.core.seq(coll);
if(or__9517__auto__){
return or__9517__auto__;
} else {
return cljs.core.List.EMPTY;
}
}
}));

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15746(xform,coll){
var or__9517__auto__ = cljs.core.chunkIteratorSeq(cljs.core.TransformerIterator.create(xform,cljs.core.iter(coll)));
if(cljs.core.truth_(or__9517__auto__)){
return or__9517__auto__;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15747(xform,coll,colls){
var or__9517__auto__ = cljs.core.chunkIteratorSeq(cljs.core.TransformerIterator.createMulti(xform,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.iter,cljs.core.cons(coll,colls))));
if(cljs.core.truth_(or__9517__auto__)){
return or__9517__auto__;
} else {
return cljs.core.List.EMPTY;
}
}));

/** @this {Function} */
(cljs.core.sequence.cljs$lang$applyTo = (function cljs$core$fn_15748(seq15741){
var G__15742 = cljs.core.first(seq15741);
var seq15741__$1 = cljs.core.next(seq15741);
var G__15743 = cljs.core.first(seq15741__$1);
var seq15741__$2 = cljs.core.next(seq15741__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15742,G__15743,seq15741__$2);
}));

(cljs.core.sequence.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if (pred x) is logical true for every x in coll, else
 *   false.
 */
cljs.core.every_QMARK_ = (function cljs$core$every_QMARK_(pred,coll){
while(true){
if((cljs.core.seq(coll) == null)){
return true;
} else {
if(cljs.core.truth_((function (){var G__15753 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__15753) : pred.call(null,G__15753));
})())){
var G__15754 = pred;
var G__15755 = cljs.core.next(coll);
pred = G__15754;
coll = G__15755;
continue;
} else {
return false;

}
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for every x in
 *   coll, else true.
 */
cljs.core.not_every_QMARK_ = (function cljs$core$not_every_QMARK_(pred,coll){
return (!(cljs.core.every_QMARK_(pred,coll)));
});
/**
 * Returns the first logical true value of (pred x) for any x in coll,
 *   else nil.  One common idiom is to use a set as pred, for example
 *   this will return :fred if :fred is in the sequence, otherwise nil:
 *   (some #{:fred} coll)
 */
cljs.core.some = (function cljs$core$some(pred,coll){
while(true){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
var or__9517__auto__ = (function (){var G__15756 = cljs.core.first(s);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__15756) : pred.call(null,G__15756));
})();
if(cljs.core.truth_(or__9517__auto__)){
return or__9517__auto__;
} else {
var G__15757 = pred;
var G__15758 = cljs.core.next(s);
pred = G__15757;
coll = G__15758;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for any x in coll,
 *   else true.
 */
cljs.core.not_any_QMARK_ = (function cljs$core$not_any_QMARK_(pred,coll){
return cljs.core.not(cljs.core.some(pred,coll));
});
/**
 * Returns true if n is even, throws an exception if n is not an integer
 */
cljs.core.even_QMARK_ = (function cljs$core$even_QMARK_(n){
if(cljs.core.integer_QMARK_(n)){
return ((n & (1)) === (0));
} else {
throw (new Error(["Argument must be an integer: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)].join('')));
}
});
/**
 * Returns true if n is odd, throws an exception if n is not an integer
 */
cljs.core.odd_QMARK_ = (function cljs$core$odd_QMARK_(n){
return (!(cljs.core.even_QMARK_(n)));
});
/**
 * Takes a fn f and returns a fn that takes the same arguments as f,
 *   has the same effects, if any, and returns the opposite truth value.
 */
cljs.core.complement = (function cljs$core$complement(f){
return (function() {
var cljs$core$complement_$_fn_15759 = null;
var cljs$core$complement_$_fn_15759__0 = (function (){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});
var cljs$core$complement_$_fn_15759__1 = (function (x){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)));
});
var cljs$core$complement_$_fn_15759__2 = (function (x,y){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y)));
});
var cljs$core$complement_$_fn_15759__3 = (function() { 
var G__15760__delegate = function (x,y,zs){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,x,y,zs));
};
var G__15760 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__15761__i = 0, G__15761__a = new Array(arguments.length -  2);
while (G__15761__i < G__15761__a.length) {G__15761__a[G__15761__i] = arguments[G__15761__i + 2]; ++G__15761__i;}
  zs = new cljs.core.IndexedSeq(G__15761__a,0,null);
} 
return G__15760__delegate.call(this,x,y,zs);};
G__15760.cljs$lang$maxFixedArity = 2;
G__15760.cljs$lang$applyTo = (function (arglist__15762){
var x = cljs.core.first(arglist__15762);
arglist__15762 = cljs.core.next(arglist__15762);
var y = cljs.core.first(arglist__15762);
var zs = cljs.core.rest(arglist__15762);
return G__15760__delegate(x,y,zs);
});
G__15760.cljs$core$IFn$_invoke$arity$variadic = G__15760__delegate;
return G__15760;
})()
;
cljs$core$complement_$_fn_15759 = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return cljs$core$complement_$_fn_15759__0.call(this);
case 1:
return cljs$core$complement_$_fn_15759__1.call(this,x);
case 2:
return cljs$core$complement_$_fn_15759__2.call(this,x,y);
default:
var G__15763 = null;
if (arguments.length > 2) {
var G__15764__i = 0, G__15764__a = new Array(arguments.length -  2);
while (G__15764__i < G__15764__a.length) {G__15764__a[G__15764__i] = arguments[G__15764__i + 2]; ++G__15764__i;}
G__15763 = new cljs.core.IndexedSeq(G__15764__a,0,null);
}
return cljs$core$complement_$_fn_15759__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__15763);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$complement_$_fn_15759.cljs$lang$maxFixedArity = 2;
cljs$core$complement_$_fn_15759.cljs$lang$applyTo = cljs$core$complement_$_fn_15759__3.cljs$lang$applyTo;
cljs$core$complement_$_fn_15759.cljs$core$IFn$_invoke$arity$0 = cljs$core$complement_$_fn_15759__0;
cljs$core$complement_$_fn_15759.cljs$core$IFn$_invoke$arity$1 = cljs$core$complement_$_fn_15759__1;
cljs$core$complement_$_fn_15759.cljs$core$IFn$_invoke$arity$2 = cljs$core$complement_$_fn_15759__2;
cljs$core$complement_$_fn_15759.cljs$core$IFn$_invoke$arity$variadic = cljs$core$complement_$_fn_15759__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$complement_$_fn_15759;
})()
});
/**
 * Returns a function that takes any number of arguments and returns x.
 */
cljs.core.constantly = (function cljs$core$constantly(x){
return (function() { 
var cljs$core$constantly_$_fn_15765__delegate = function (args){
return x;
};
var cljs$core$constantly_$_fn_15765 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__15766__i = 0, G__15766__a = new Array(arguments.length -  0);
while (G__15766__i < G__15766__a.length) {G__15766__a[G__15766__i] = arguments[G__15766__i + 0]; ++G__15766__i;}
  args = new cljs.core.IndexedSeq(G__15766__a,0,null);
} 
return cljs$core$constantly_$_fn_15765__delegate.call(this,args);};
cljs$core$constantly_$_fn_15765.cljs$lang$maxFixedArity = 0;
cljs$core$constantly_$_fn_15765.cljs$lang$applyTo = (function (arglist__15767){
var args = cljs.core.seq(arglist__15767);
return cljs$core$constantly_$_fn_15765__delegate(args);
});
cljs$core$constantly_$_fn_15765.cljs$core$IFn$_invoke$arity$variadic = cljs$core$constantly_$_fn_15765__delegate;
return cljs$core$constantly_$_fn_15765;
})()
;
});
/**
 * Takes a set of functions and returns a fn that is the composition
 *   of those fns.  The returned fn takes a variable number of args,
 *   applies the rightmost of fns to the args, the next
 *   fn (right-to-left) to the result, etc.
 */
cljs.core.comp = (function cljs$core$comp(var_args){
var G__15773 = arguments.length;
switch (G__15773) {
case 0:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15800 = arguments.length;
var i__10847__auto___15801 = (0);
while(true){
if((i__10847__auto___15801 < len__10846__auto___15800)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15801]));

var G__15802 = (i__10847__auto___15801 + (1));
i__10847__auto___15801 = G__15802;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((3) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((3)),(0),null)):null);
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10876__auto__);

}
});

(cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15774(){
return cljs.core.identity;
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15775(f){
return f;
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15776(f,g){
return (function() {
var cljs$core$fn_15776_$_fn_15777 = null;
var cljs$core$fn_15776_$_fn_15777__0 = (function (){
var G__15778 = (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15778) : f.call(null,G__15778));
});
var cljs$core$fn_15776_$_fn_15777__1 = (function (x){
var G__15779 = (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null,x));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15779) : f.call(null,G__15779));
});
var cljs$core$fn_15776_$_fn_15777__2 = (function (x,y){
var G__15780 = (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x,y) : g.call(null,x,y));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15780) : f.call(null,G__15780));
});
var cljs$core$fn_15776_$_fn_15777__3 = (function (x,y,z){
var G__15781 = (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x,y,z) : g.call(null,x,y,z));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15781) : f.call(null,G__15781));
});
var cljs$core$fn_15776_$_fn_15777__4 = (function() { 
var G__15803__delegate = function (x,y,z,args){
var G__15782 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15782) : f.call(null,G__15782));
};
var G__15803 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__15804__i = 0, G__15804__a = new Array(arguments.length -  3);
while (G__15804__i < G__15804__a.length) {G__15804__a[G__15804__i] = arguments[G__15804__i + 3]; ++G__15804__i;}
  args = new cljs.core.IndexedSeq(G__15804__a,0,null);
} 
return G__15803__delegate.call(this,x,y,z,args);};
G__15803.cljs$lang$maxFixedArity = 3;
G__15803.cljs$lang$applyTo = (function (arglist__15805){
var x = cljs.core.first(arglist__15805);
arglist__15805 = cljs.core.next(arglist__15805);
var y = cljs.core.first(arglist__15805);
arglist__15805 = cljs.core.next(arglist__15805);
var z = cljs.core.first(arglist__15805);
var args = cljs.core.rest(arglist__15805);
return G__15803__delegate(x,y,z,args);
});
G__15803.cljs$core$IFn$_invoke$arity$variadic = G__15803__delegate;
return G__15803;
})()
;
cljs$core$fn_15776_$_fn_15777 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_15776_$_fn_15777__0.call(this);
case 1:
return cljs$core$fn_15776_$_fn_15777__1.call(this,x);
case 2:
return cljs$core$fn_15776_$_fn_15777__2.call(this,x,y);
case 3:
return cljs$core$fn_15776_$_fn_15777__3.call(this,x,y,z);
default:
var G__15806 = null;
if (arguments.length > 3) {
var G__15807__i = 0, G__15807__a = new Array(arguments.length -  3);
while (G__15807__i < G__15807__a.length) {G__15807__a[G__15807__i] = arguments[G__15807__i + 3]; ++G__15807__i;}
G__15806 = new cljs.core.IndexedSeq(G__15807__a,0,null);
}
return cljs$core$fn_15776_$_fn_15777__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__15806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15776_$_fn_15777.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15776_$_fn_15777.cljs$lang$applyTo = cljs$core$fn_15776_$_fn_15777__4.cljs$lang$applyTo;
cljs$core$fn_15776_$_fn_15777.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15776_$_fn_15777__0;
cljs$core$fn_15776_$_fn_15777.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15776_$_fn_15777__1;
cljs$core$fn_15776_$_fn_15777.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15776_$_fn_15777__2;
cljs$core$fn_15776_$_fn_15777.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15776_$_fn_15777__3;
cljs$core$fn_15776_$_fn_15777.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15776_$_fn_15777__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15776_$_fn_15777;
})()
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15783(f,g,h){
return (function() {
var cljs$core$fn_15783_$_fn_15784 = null;
var cljs$core$fn_15783_$_fn_15784__0 = (function (){
var G__15785 = (function (){var G__15786 = (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15786) : g.call(null,G__15786));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15785) : f.call(null,G__15785));
});
var cljs$core$fn_15783_$_fn_15784__1 = (function (x){
var G__15787 = (function (){var G__15788 = (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(x) : h.call(null,x));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15788) : g.call(null,G__15788));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15787) : f.call(null,G__15787));
});
var cljs$core$fn_15783_$_fn_15784__2 = (function (x,y){
var G__15789 = (function (){var G__15790 = (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(x,y) : h.call(null,x,y));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15790) : g.call(null,G__15790));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15789) : f.call(null,G__15789));
});
var cljs$core$fn_15783_$_fn_15784__3 = (function (x,y,z){
var G__15791 = (function (){var G__15792 = (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(x,y,z) : h.call(null,x,y,z));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15792) : g.call(null,G__15792));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15791) : f.call(null,G__15791));
});
var cljs$core$fn_15783_$_fn_15784__4 = (function() { 
var G__15808__delegate = function (x,y,z,args){
var G__15793 = (function (){var G__15794 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args);
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15794) : g.call(null,G__15794));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15793) : f.call(null,G__15793));
};
var G__15808 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__15809__i = 0, G__15809__a = new Array(arguments.length -  3);
while (G__15809__i < G__15809__a.length) {G__15809__a[G__15809__i] = arguments[G__15809__i + 3]; ++G__15809__i;}
  args = new cljs.core.IndexedSeq(G__15809__a,0,null);
} 
return G__15808__delegate.call(this,x,y,z,args);};
G__15808.cljs$lang$maxFixedArity = 3;
G__15808.cljs$lang$applyTo = (function (arglist__15810){
var x = cljs.core.first(arglist__15810);
arglist__15810 = cljs.core.next(arglist__15810);
var y = cljs.core.first(arglist__15810);
arglist__15810 = cljs.core.next(arglist__15810);
var z = cljs.core.first(arglist__15810);
var args = cljs.core.rest(arglist__15810);
return G__15808__delegate(x,y,z,args);
});
G__15808.cljs$core$IFn$_invoke$arity$variadic = G__15808__delegate;
return G__15808;
})()
;
cljs$core$fn_15783_$_fn_15784 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_15783_$_fn_15784__0.call(this);
case 1:
return cljs$core$fn_15783_$_fn_15784__1.call(this,x);
case 2:
return cljs$core$fn_15783_$_fn_15784__2.call(this,x,y);
case 3:
return cljs$core$fn_15783_$_fn_15784__3.call(this,x,y,z);
default:
var G__15811 = null;
if (arguments.length > 3) {
var G__15812__i = 0, G__15812__a = new Array(arguments.length -  3);
while (G__15812__i < G__15812__a.length) {G__15812__a[G__15812__i] = arguments[G__15812__i + 3]; ++G__15812__i;}
G__15811 = new cljs.core.IndexedSeq(G__15812__a,0,null);
}
return cljs$core$fn_15783_$_fn_15784__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__15811);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15783_$_fn_15784.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15783_$_fn_15784.cljs$lang$applyTo = cljs$core$fn_15783_$_fn_15784__4.cljs$lang$applyTo;
cljs$core$fn_15783_$_fn_15784.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15783_$_fn_15784__0;
cljs$core$fn_15783_$_fn_15784.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15783_$_fn_15784__1;
cljs$core$fn_15783_$_fn_15784.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15783_$_fn_15784__2;
cljs$core$fn_15783_$_fn_15784.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15783_$_fn_15784__3;
cljs$core$fn_15783_$_fn_15784.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15783_$_fn_15784__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15783_$_fn_15784;
})()
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15795(f1,f2,f3,fs){
var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1,f2,f3,fs));
return (function() { 
var cljs$core$fn_15795_$_fn_15796__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1),args);
var fs__$2 = cljs.core.next(fs__$1);
while(true){
if(fs__$2){
var G__15813 = (function (){var fexpr__15797 = cljs.core.first(fs__$2);
return (fexpr__15797.cljs$core$IFn$_invoke$arity$1 ? fexpr__15797.cljs$core$IFn$_invoke$arity$1(ret) : fexpr__15797.call(null,ret));
})();
var G__15814 = cljs.core.next(fs__$2);
ret = G__15813;
fs__$2 = G__15814;
continue;
} else {
return ret;
}
break;
}
};
var cljs$core$fn_15795_$_fn_15796 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__15815__i = 0, G__15815__a = new Array(arguments.length -  0);
while (G__15815__i < G__15815__a.length) {G__15815__a[G__15815__i] = arguments[G__15815__i + 0]; ++G__15815__i;}
  args = new cljs.core.IndexedSeq(G__15815__a,0,null);
} 
return cljs$core$fn_15795_$_fn_15796__delegate.call(this,args);};
cljs$core$fn_15795_$_fn_15796.cljs$lang$maxFixedArity = 0;
cljs$core$fn_15795_$_fn_15796.cljs$lang$applyTo = (function (arglist__15816){
var args = cljs.core.seq(arglist__15816);
return cljs$core$fn_15795_$_fn_15796__delegate(args);
});
cljs$core$fn_15795_$_fn_15796.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15795_$_fn_15796__delegate;
return cljs$core$fn_15795_$_fn_15796;
})()
;
}));

/** @this {Function} */
(cljs.core.comp.cljs$lang$applyTo = (function cljs$core$fn_15798(seq15769){
var G__15770 = cljs.core.first(seq15769);
var seq15769__$1 = cljs.core.next(seq15769);
var G__15771 = cljs.core.first(seq15769__$1);
var seq15769__$2 = cljs.core.next(seq15769__$1);
var G__15772 = cljs.core.first(seq15769__$2);
var seq15769__$3 = cljs.core.next(seq15769__$2);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15770,G__15771,G__15772,seq15769__$3);
}));

(cljs.core.comp.cljs$lang$maxFixedArity = (3));

/**
 * Takes a function f and fewer than the normal arguments to f, and
 *   returns a fn that takes a variable number of additional args. When
 *   called, the returned function calls f with args + additional args.
 */
cljs.core.partial = (function cljs$core$partial(var_args){
var G__15823 = arguments.length;
switch (G__15823) {
case 1:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15835 = arguments.length;
var i__10847__auto___15836 = (0);
while(true){
if((i__10847__auto___15836 < len__10846__auto___15835)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15836]));

var G__15837 = (i__10847__auto___15836 + (1));
i__10847__auto___15836 = G__15837;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((4) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((4)),(0),null)):null);
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10876__auto__);

}
});

(cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15824(f){
return f;
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15825(f,arg1){
return (function() {
var cljs$core$fn_15825_$_fn_15826 = null;
var cljs$core$fn_15825_$_fn_15826__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(arg1) : f.call(null,arg1));
});
var cljs$core$fn_15825_$_fn_15826__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,x) : f.call(null,arg1,x));
});
var cljs$core$fn_15825_$_fn_15826__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,x,y) : f.call(null,arg1,x,y));
});
var cljs$core$fn_15825_$_fn_15826__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,x,y,z) : f.call(null,arg1,x,y,z));
});
var cljs$core$fn_15825_$_fn_15826__4 = (function() { 
var G__15838__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,x,y,z,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
};
var G__15838 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__15839__i = 0, G__15839__a = new Array(arguments.length -  3);
while (G__15839__i < G__15839__a.length) {G__15839__a[G__15839__i] = arguments[G__15839__i + 3]; ++G__15839__i;}
  args = new cljs.core.IndexedSeq(G__15839__a,0,null);
} 
return G__15838__delegate.call(this,x,y,z,args);};
G__15838.cljs$lang$maxFixedArity = 3;
G__15838.cljs$lang$applyTo = (function (arglist__15840){
var x = cljs.core.first(arglist__15840);
arglist__15840 = cljs.core.next(arglist__15840);
var y = cljs.core.first(arglist__15840);
arglist__15840 = cljs.core.next(arglist__15840);
var z = cljs.core.first(arglist__15840);
var args = cljs.core.rest(arglist__15840);
return G__15838__delegate(x,y,z,args);
});
G__15838.cljs$core$IFn$_invoke$arity$variadic = G__15838__delegate;
return G__15838;
})()
;
cljs$core$fn_15825_$_fn_15826 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_15825_$_fn_15826__0.call(this);
case 1:
return cljs$core$fn_15825_$_fn_15826__1.call(this,x);
case 2:
return cljs$core$fn_15825_$_fn_15826__2.call(this,x,y);
case 3:
return cljs$core$fn_15825_$_fn_15826__3.call(this,x,y,z);
default:
var G__15841 = null;
if (arguments.length > 3) {
var G__15842__i = 0, G__15842__a = new Array(arguments.length -  3);
while (G__15842__i < G__15842__a.length) {G__15842__a[G__15842__i] = arguments[G__15842__i + 3]; ++G__15842__i;}
G__15841 = new cljs.core.IndexedSeq(G__15842__a,0,null);
}
return cljs$core$fn_15825_$_fn_15826__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__15841);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15825_$_fn_15826.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15825_$_fn_15826.cljs$lang$applyTo = cljs$core$fn_15825_$_fn_15826__4.cljs$lang$applyTo;
cljs$core$fn_15825_$_fn_15826.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15825_$_fn_15826__0;
cljs$core$fn_15825_$_fn_15826.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15825_$_fn_15826__1;
cljs$core$fn_15825_$_fn_15826.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15825_$_fn_15826__2;
cljs$core$fn_15825_$_fn_15826.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15825_$_fn_15826__3;
cljs$core$fn_15825_$_fn_15826.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15825_$_fn_15826__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15825_$_fn_15826;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15827(f,arg1,arg2){
return (function() {
var cljs$core$fn_15827_$_fn_15828 = null;
var cljs$core$fn_15827_$_fn_15828__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,arg2) : f.call(null,arg1,arg2));
});
var cljs$core$fn_15827_$_fn_15828__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,x) : f.call(null,arg1,arg2,x));
});
var cljs$core$fn_15827_$_fn_15828__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,x,y) : f.call(null,arg1,arg2,x,y));
});
var cljs$core$fn_15827_$_fn_15828__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,x,y,z) : f.call(null,arg1,arg2,x,y,z));
});
var cljs$core$fn_15827_$_fn_15828__4 = (function() { 
var G__15843__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,x,y,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([z,args], 0));
};
var G__15843 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__15844__i = 0, G__15844__a = new Array(arguments.length -  3);
while (G__15844__i < G__15844__a.length) {G__15844__a[G__15844__i] = arguments[G__15844__i + 3]; ++G__15844__i;}
  args = new cljs.core.IndexedSeq(G__15844__a,0,null);
} 
return G__15843__delegate.call(this,x,y,z,args);};
G__15843.cljs$lang$maxFixedArity = 3;
G__15843.cljs$lang$applyTo = (function (arglist__15845){
var x = cljs.core.first(arglist__15845);
arglist__15845 = cljs.core.next(arglist__15845);
var y = cljs.core.first(arglist__15845);
arglist__15845 = cljs.core.next(arglist__15845);
var z = cljs.core.first(arglist__15845);
var args = cljs.core.rest(arglist__15845);
return G__15843__delegate(x,y,z,args);
});
G__15843.cljs$core$IFn$_invoke$arity$variadic = G__15843__delegate;
return G__15843;
})()
;
cljs$core$fn_15827_$_fn_15828 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_15827_$_fn_15828__0.call(this);
case 1:
return cljs$core$fn_15827_$_fn_15828__1.call(this,x);
case 2:
return cljs$core$fn_15827_$_fn_15828__2.call(this,x,y);
case 3:
return cljs$core$fn_15827_$_fn_15828__3.call(this,x,y,z);
default:
var G__15846 = null;
if (arguments.length > 3) {
var G__15847__i = 0, G__15847__a = new Array(arguments.length -  3);
while (G__15847__i < G__15847__a.length) {G__15847__a[G__15847__i] = arguments[G__15847__i + 3]; ++G__15847__i;}
G__15846 = new cljs.core.IndexedSeq(G__15847__a,0,null);
}
return cljs$core$fn_15827_$_fn_15828__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__15846);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15827_$_fn_15828.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15827_$_fn_15828.cljs$lang$applyTo = cljs$core$fn_15827_$_fn_15828__4.cljs$lang$applyTo;
cljs$core$fn_15827_$_fn_15828.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15827_$_fn_15828__0;
cljs$core$fn_15827_$_fn_15828.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15827_$_fn_15828__1;
cljs$core$fn_15827_$_fn_15828.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15827_$_fn_15828__2;
cljs$core$fn_15827_$_fn_15828.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15827_$_fn_15828__3;
cljs$core$fn_15827_$_fn_15828.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15827_$_fn_15828__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15827_$_fn_15828;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15829(f,arg1,arg2,arg3){
return (function() {
var cljs$core$fn_15829_$_fn_15830 = null;
var cljs$core$fn_15829_$_fn_15830__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,arg3) : f.call(null,arg1,arg2,arg3));
});
var cljs$core$fn_15829_$_fn_15830__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,arg3,x) : f.call(null,arg1,arg2,arg3,x));
});
var cljs$core$fn_15829_$_fn_15830__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,arg3,x,y) : f.call(null,arg1,arg2,arg3,x,y));
});
var cljs$core$fn_15829_$_fn_15830__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(arg1,arg2,arg3,x,y,z) : f.call(null,arg1,arg2,arg3,x,y,z));
});
var cljs$core$fn_15829_$_fn_15830__4 = (function() { 
var G__15848__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3,x,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([y,z,args], 0));
};
var G__15848 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__15849__i = 0, G__15849__a = new Array(arguments.length -  3);
while (G__15849__i < G__15849__a.length) {G__15849__a[G__15849__i] = arguments[G__15849__i + 3]; ++G__15849__i;}
  args = new cljs.core.IndexedSeq(G__15849__a,0,null);
} 
return G__15848__delegate.call(this,x,y,z,args);};
G__15848.cljs$lang$maxFixedArity = 3;
G__15848.cljs$lang$applyTo = (function (arglist__15850){
var x = cljs.core.first(arglist__15850);
arglist__15850 = cljs.core.next(arglist__15850);
var y = cljs.core.first(arglist__15850);
arglist__15850 = cljs.core.next(arglist__15850);
var z = cljs.core.first(arglist__15850);
var args = cljs.core.rest(arglist__15850);
return G__15848__delegate(x,y,z,args);
});
G__15848.cljs$core$IFn$_invoke$arity$variadic = G__15848__delegate;
return G__15848;
})()
;
cljs$core$fn_15829_$_fn_15830 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_15829_$_fn_15830__0.call(this);
case 1:
return cljs$core$fn_15829_$_fn_15830__1.call(this,x);
case 2:
return cljs$core$fn_15829_$_fn_15830__2.call(this,x,y);
case 3:
return cljs$core$fn_15829_$_fn_15830__3.call(this,x,y,z);
default:
var G__15851 = null;
if (arguments.length > 3) {
var G__15852__i = 0, G__15852__a = new Array(arguments.length -  3);
while (G__15852__i < G__15852__a.length) {G__15852__a[G__15852__i] = arguments[G__15852__i + 3]; ++G__15852__i;}
G__15851 = new cljs.core.IndexedSeq(G__15852__a,0,null);
}
return cljs$core$fn_15829_$_fn_15830__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__15851);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15829_$_fn_15830.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15829_$_fn_15830.cljs$lang$applyTo = cljs$core$fn_15829_$_fn_15830__4.cljs$lang$applyTo;
cljs$core$fn_15829_$_fn_15830.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15829_$_fn_15830__0;
cljs$core$fn_15829_$_fn_15830.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15829_$_fn_15830__1;
cljs$core$fn_15829_$_fn_15830.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15829_$_fn_15830__2;
cljs$core$fn_15829_$_fn_15830.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15829_$_fn_15830__3;
cljs$core$fn_15829_$_fn_15830.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15829_$_fn_15830__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15829_$_fn_15830;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15831(f,arg1,arg2,arg3,more){
return (function() { 
var cljs$core$fn_15831_$_fn_15832__delegate = function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,arg1,arg2,arg3,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more,args));
};
var cljs$core$fn_15831_$_fn_15832 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__15853__i = 0, G__15853__a = new Array(arguments.length -  0);
while (G__15853__i < G__15853__a.length) {G__15853__a[G__15853__i] = arguments[G__15853__i + 0]; ++G__15853__i;}
  args = new cljs.core.IndexedSeq(G__15853__a,0,null);
} 
return cljs$core$fn_15831_$_fn_15832__delegate.call(this,args);};
cljs$core$fn_15831_$_fn_15832.cljs$lang$maxFixedArity = 0;
cljs$core$fn_15831_$_fn_15832.cljs$lang$applyTo = (function (arglist__15854){
var args = cljs.core.seq(arglist__15854);
return cljs$core$fn_15831_$_fn_15832__delegate(args);
});
cljs$core$fn_15831_$_fn_15832.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15831_$_fn_15832__delegate;
return cljs$core$fn_15831_$_fn_15832;
})()
;
}));

/** @this {Function} */
(cljs.core.partial.cljs$lang$applyTo = (function cljs$core$fn_15833(seq15818){
var G__15819 = cljs.core.first(seq15818);
var seq15818__$1 = cljs.core.next(seq15818);
var G__15820 = cljs.core.first(seq15818__$1);
var seq15818__$2 = cljs.core.next(seq15818__$1);
var G__15821 = cljs.core.first(seq15818__$2);
var seq15818__$3 = cljs.core.next(seq15818__$2);
var G__15822 = cljs.core.first(seq15818__$3);
var seq15818__$4 = cljs.core.next(seq15818__$3);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15819,G__15820,G__15821,G__15822,seq15818__$4);
}));

(cljs.core.partial.cljs$lang$maxFixedArity = (4));

/**
 * Takes a function f, and returns a function that calls f, replacing
 *   a nil first argument to f with the supplied value x. Higher arity
 *   versions can replace arguments in the second and third
 *   positions (y, z). Note that the function f can take any number of
 *   arguments, not just the one(s) being nil-patched.
 */
cljs.core.fnil = (function cljs$core$fnil(var_args){
var G__15856 = arguments.length;
switch (G__15856) {
case 2:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15857(f,x){
return (function() {
var cljs$core$fn_15857_$_fn_15858 = null;
var cljs$core$fn_15857_$_fn_15858__1 = (function (a){
var G__15859 = (((a == null))?x:a);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15859) : f.call(null,G__15859));
});
var cljs$core$fn_15857_$_fn_15858__2 = (function (a,b){
var G__15860 = (((a == null))?x:a);
var G__15861 = b;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15860,G__15861) : f.call(null,G__15860,G__15861));
});
var cljs$core$fn_15857_$_fn_15858__3 = (function (a,b,c){
var G__15862 = (((a == null))?x:a);
var G__15863 = b;
var G__15864 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15862,G__15863,G__15864) : f.call(null,G__15862,G__15863,G__15864));
});
var cljs$core$fn_15857_$_fn_15858__4 = (function() { 
var G__15880__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),b,c,ds);
};
var G__15880 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__15881__i = 0, G__15881__a = new Array(arguments.length -  3);
while (G__15881__i < G__15881__a.length) {G__15881__a[G__15881__i] = arguments[G__15881__i + 3]; ++G__15881__i;}
  ds = new cljs.core.IndexedSeq(G__15881__a,0,null);
} 
return G__15880__delegate.call(this,a,b,c,ds);};
G__15880.cljs$lang$maxFixedArity = 3;
G__15880.cljs$lang$applyTo = (function (arglist__15882){
var a = cljs.core.first(arglist__15882);
arglist__15882 = cljs.core.next(arglist__15882);
var b = cljs.core.first(arglist__15882);
arglist__15882 = cljs.core.next(arglist__15882);
var c = cljs.core.first(arglist__15882);
var ds = cljs.core.rest(arglist__15882);
return G__15880__delegate(a,b,c,ds);
});
G__15880.cljs$core$IFn$_invoke$arity$variadic = G__15880__delegate;
return G__15880;
})()
;
cljs$core$fn_15857_$_fn_15858 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 1:
return cljs$core$fn_15857_$_fn_15858__1.call(this,a);
case 2:
return cljs$core$fn_15857_$_fn_15858__2.call(this,a,b);
case 3:
return cljs$core$fn_15857_$_fn_15858__3.call(this,a,b,c);
default:
var G__15883 = null;
if (arguments.length > 3) {
var G__15884__i = 0, G__15884__a = new Array(arguments.length -  3);
while (G__15884__i < G__15884__a.length) {G__15884__a[G__15884__i] = arguments[G__15884__i + 3]; ++G__15884__i;}
G__15883 = new cljs.core.IndexedSeq(G__15884__a,0,null);
}
return cljs$core$fn_15857_$_fn_15858__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__15883);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15857_$_fn_15858.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15857_$_fn_15858.cljs$lang$applyTo = cljs$core$fn_15857_$_fn_15858__4.cljs$lang$applyTo;
cljs$core$fn_15857_$_fn_15858.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15857_$_fn_15858__1;
cljs$core$fn_15857_$_fn_15858.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15857_$_fn_15858__2;
cljs$core$fn_15857_$_fn_15858.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15857_$_fn_15858__3;
cljs$core$fn_15857_$_fn_15858.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15857_$_fn_15858__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15857_$_fn_15858;
})()
}));

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15865(f,x,y){
return (function() {
var cljs$core$fn_15865_$_fn_15866 = null;
var cljs$core$fn_15865_$_fn_15866__2 = (function (a,b){
var G__15867 = (((a == null))?x:a);
var G__15868 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15867,G__15868) : f.call(null,G__15867,G__15868));
});
var cljs$core$fn_15865_$_fn_15866__3 = (function (a,b,c){
var G__15869 = (((a == null))?x:a);
var G__15870 = (((b == null))?y:b);
var G__15871 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15869,G__15870,G__15871) : f.call(null,G__15869,G__15870,G__15871));
});
var cljs$core$fn_15865_$_fn_15866__4 = (function() { 
var G__15885__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),c,ds);
};
var G__15885 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__15886__i = 0, G__15886__a = new Array(arguments.length -  3);
while (G__15886__i < G__15886__a.length) {G__15886__a[G__15886__i] = arguments[G__15886__i + 3]; ++G__15886__i;}
  ds = new cljs.core.IndexedSeq(G__15886__a,0,null);
} 
return G__15885__delegate.call(this,a,b,c,ds);};
G__15885.cljs$lang$maxFixedArity = 3;
G__15885.cljs$lang$applyTo = (function (arglist__15887){
var a = cljs.core.first(arglist__15887);
arglist__15887 = cljs.core.next(arglist__15887);
var b = cljs.core.first(arglist__15887);
arglist__15887 = cljs.core.next(arglist__15887);
var c = cljs.core.first(arglist__15887);
var ds = cljs.core.rest(arglist__15887);
return G__15885__delegate(a,b,c,ds);
});
G__15885.cljs$core$IFn$_invoke$arity$variadic = G__15885__delegate;
return G__15885;
})()
;
cljs$core$fn_15865_$_fn_15866 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return cljs$core$fn_15865_$_fn_15866__2.call(this,a,b);
case 3:
return cljs$core$fn_15865_$_fn_15866__3.call(this,a,b,c);
default:
var G__15888 = null;
if (arguments.length > 3) {
var G__15889__i = 0, G__15889__a = new Array(arguments.length -  3);
while (G__15889__i < G__15889__a.length) {G__15889__a[G__15889__i] = arguments[G__15889__i + 3]; ++G__15889__i;}
G__15888 = new cljs.core.IndexedSeq(G__15889__a,0,null);
}
return cljs$core$fn_15865_$_fn_15866__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__15888);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15865_$_fn_15866.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15865_$_fn_15866.cljs$lang$applyTo = cljs$core$fn_15865_$_fn_15866__4.cljs$lang$applyTo;
cljs$core$fn_15865_$_fn_15866.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15865_$_fn_15866__2;
cljs$core$fn_15865_$_fn_15866.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15865_$_fn_15866__3;
cljs$core$fn_15865_$_fn_15866.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15865_$_fn_15866__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15865_$_fn_15866;
})()
}));

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15872(f,x,y,z){
return (function() {
var cljs$core$fn_15872_$_fn_15873 = null;
var cljs$core$fn_15872_$_fn_15873__2 = (function (a,b){
var G__15874 = (((a == null))?x:a);
var G__15875 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15874,G__15875) : f.call(null,G__15874,G__15875));
});
var cljs$core$fn_15872_$_fn_15873__3 = (function (a,b,c){
var G__15876 = (((a == null))?x:a);
var G__15877 = (((b == null))?y:b);
var G__15878 = (((c == null))?z:c);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15876,G__15877,G__15878) : f.call(null,G__15876,G__15877,G__15878));
});
var cljs$core$fn_15872_$_fn_15873__4 = (function() { 
var G__15890__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c),ds);
};
var G__15890 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__15891__i = 0, G__15891__a = new Array(arguments.length -  3);
while (G__15891__i < G__15891__a.length) {G__15891__a[G__15891__i] = arguments[G__15891__i + 3]; ++G__15891__i;}
  ds = new cljs.core.IndexedSeq(G__15891__a,0,null);
} 
return G__15890__delegate.call(this,a,b,c,ds);};
G__15890.cljs$lang$maxFixedArity = 3;
G__15890.cljs$lang$applyTo = (function (arglist__15892){
var a = cljs.core.first(arglist__15892);
arglist__15892 = cljs.core.next(arglist__15892);
var b = cljs.core.first(arglist__15892);
arglist__15892 = cljs.core.next(arglist__15892);
var c = cljs.core.first(arglist__15892);
var ds = cljs.core.rest(arglist__15892);
return G__15890__delegate(a,b,c,ds);
});
G__15890.cljs$core$IFn$_invoke$arity$variadic = G__15890__delegate;
return G__15890;
})()
;
cljs$core$fn_15872_$_fn_15873 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return cljs$core$fn_15872_$_fn_15873__2.call(this,a,b);
case 3:
return cljs$core$fn_15872_$_fn_15873__3.call(this,a,b,c);
default:
var G__15893 = null;
if (arguments.length > 3) {
var G__15894__i = 0, G__15894__a = new Array(arguments.length -  3);
while (G__15894__i < G__15894__a.length) {G__15894__a[G__15894__i] = arguments[G__15894__i + 3]; ++G__15894__i;}
G__15893 = new cljs.core.IndexedSeq(G__15894__a,0,null);
}
return cljs$core$fn_15872_$_fn_15873__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__15893);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15872_$_fn_15873.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15872_$_fn_15873.cljs$lang$applyTo = cljs$core$fn_15872_$_fn_15873__4.cljs$lang$applyTo;
cljs$core$fn_15872_$_fn_15873.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15872_$_fn_15873__2;
cljs$core$fn_15872_$_fn_15873.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15872_$_fn_15873__3;
cljs$core$fn_15872_$_fn_15873.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15872_$_fn_15873__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15872_$_fn_15873;
})()
}));

(cljs.core.fnil.cljs$lang$maxFixedArity = 4);

/**
 * Returns a lazy sequence consisting of the result of applying f to 0
 *   and the first item of coll, followed by applying f to 1 and the second
 *   item in coll, etc, until coll is exhausted. Thus function f should
 *   accept 2 arguments, index and item. Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.map_indexed = (function cljs$core$map_indexed(var_args){
var G__15896 = arguments.length;
switch (G__15896) {
case 1:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15897(f){
return (function cljs$core$fn_15897_$_fn_15898(rf){
var i = cljs.core.volatile_BANG_((-1));
return (function() {
var cljs$core$fn_15897_$_fn_15898_$_fn_15899 = null;
var cljs$core$fn_15897_$_fn_15898_$_fn_15899__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_15897_$_fn_15898_$_fn_15899__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_15897_$_fn_15898_$_fn_15899__2 = (function (result,input){
var G__15900 = result;
var G__15901 = (function (){var G__15902 = i.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(i.cljs$core$IDeref$_deref$arity$1(null) + (1)));
var G__15903 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15902,G__15903) : f.call(null,G__15902,G__15903));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__15900,G__15901) : rf.call(null,G__15900,G__15901));
});
cljs$core$fn_15897_$_fn_15898_$_fn_15899 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_15897_$_fn_15898_$_fn_15899__0.call(this);
case 1:
return cljs$core$fn_15897_$_fn_15898_$_fn_15899__1.call(this,result);
case 2:
return cljs$core$fn_15897_$_fn_15898_$_fn_15899__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15897_$_fn_15898_$_fn_15899.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15897_$_fn_15898_$_fn_15899__0;
cljs$core$fn_15897_$_fn_15898_$_fn_15899.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15897_$_fn_15898_$_fn_15899__1;
cljs$core$fn_15897_$_fn_15898_$_fn_15899.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15897_$_fn_15898_$_fn_15899__2;
return cljs$core$fn_15897_$_fn_15898_$_fn_15899;
})()
});
}));

(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15904(f,coll){
var mapi = (function cljs$core$fn_15904_$_mapi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15904_$_mapi_$_fn_15910(){
var temp__5720__auto__ = cljs.core.seq(coll__$1);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__10605__auto___15916 = size;
var i_15917 = (0);
while(true){
if((i_15917 < n__10605__auto___15916)){
cljs.core.chunk_append(b,(function (){var G__15911 = (idx + i_15917);
var G__15912 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_15917);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15911,G__15912) : f.call(null,G__15911,G__15912));
})());

var G__15918 = (i_15917 + (1));
i_15917 = G__15918;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$fn_15904_$_mapi((idx + size),cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__15913 = idx;
var G__15914 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15913,G__15914) : f.call(null,G__15913,G__15914));
})(),cljs$core$fn_15904_$_mapi((idx + (1)),cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
return mapi((0),coll);
}));

(cljs.core.map_indexed.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the non-nil results of (f item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a transducer when no collection is provided.
 */
cljs.core.keep = (function cljs$core$keep(var_args){
var G__15920 = arguments.length;
switch (G__15920) {
case 1:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15921(f){
return (function cljs$core$fn_15921_$_fn_15922(rf){
return (function() {
var cljs$core$fn_15921_$_fn_15922_$_fn_15923 = null;
var cljs$core$fn_15921_$_fn_15922_$_fn_15923__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_15921_$_fn_15922_$_fn_15923__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_15921_$_fn_15922_$_fn_15923__2 = (function (result,input){
var v = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
cljs$core$fn_15921_$_fn_15922_$_fn_15923 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_15921_$_fn_15922_$_fn_15923__0.call(this);
case 1:
return cljs$core$fn_15921_$_fn_15922_$_fn_15923__1.call(this,result);
case 2:
return cljs$core$fn_15921_$_fn_15922_$_fn_15923__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15921_$_fn_15922_$_fn_15923.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15921_$_fn_15922_$_fn_15923__0;
cljs$core$fn_15921_$_fn_15922_$_fn_15923.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15921_$_fn_15922_$_fn_15923__1;
cljs$core$fn_15921_$_fn_15922_$_fn_15923.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15921_$_fn_15922_$_fn_15923__2;
return cljs$core$fn_15921_$_fn_15922_$_fn_15923;
})()
});
}));

(cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15924(f,coll){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15924_$_fn_15925(){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__10605__auto___15929 = size;
var i_15930 = (0);
while(true){
if((i_15930 < n__10605__auto___15929)){
var x_15931 = (function (){var G__15926 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_15930);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15926) : f.call(null,G__15926));
})();
if((x_15931 == null)){
} else {
cljs.core.chunk_append(b,x_15931);
}

var G__15932 = (i_15930 + (1));
i_15930 = G__15932;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__15927 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15927) : f.call(null,G__15927));
})();
if((x == null)){
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.keep.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IWatchable}
 * @implements {cljs.core.IAtom}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Atom = (function (state,meta,validator,watches){
this.state = state;
this.meta = meta;
this.validator = validator;
this.watches = watches;
this.cljs$lang$protocol_mask$partition1$ = 16386;
this.cljs$lang$protocol_mask$partition0$ = 6455296;
});
(cljs.core.Atom.prototype.equiv = (function cljs$core$fn_15933(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15934(o,other){
var self__ = this;
var o__$1 = this;
return (o__$1 === other);
}));

(cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = (function cljs$core$fn_15935(_){
var self__ = this;
var ___$1 = this;
return self__.state;
}));

(cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15936(_){
var self__ = this;
var ___$1 = this;
return self__.meta;
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function cljs$core$fn_15937(this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
var seq__15938 = cljs.core.seq(self__.watches);
var chunk__15939 = null;
var count__15940 = (0);
var i__15941 = (0);
while(true){
if((i__15941 < count__15940)){
var vec__15948 = chunk__15939.cljs$core$IIndexed$_nth$arity$2(null,i__15941);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15948,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15948,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));


var G__15959 = seq__15938;
var G__15960 = chunk__15939;
var G__15961 = count__15940;
var G__15962 = (i__15941 + (1));
seq__15938 = G__15959;
chunk__15939 = G__15960;
count__15940 = G__15961;
i__15941 = G__15962;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__15938);
if(temp__5720__auto__){
var seq__15938__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15938__$1)){
var c__10489__auto__ = cljs.core.chunk_first(seq__15938__$1);
var G__15963 = cljs.core.chunk_rest(seq__15938__$1);
var G__15964 = c__10489__auto__;
var G__15965 = cljs.core.count(c__10489__auto__);
var G__15966 = (0);
seq__15938 = G__15963;
chunk__15939 = G__15964;
count__15940 = G__15965;
i__15941 = G__15966;
continue;
} else {
var vec__15951 = cljs.core.first(seq__15938__$1);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15951,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15951,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));


var G__15967 = cljs.core.next(seq__15938__$1);
var G__15968 = null;
var G__15969 = (0);
var G__15970 = (0);
seq__15938 = G__15967;
chunk__15939 = G__15968;
count__15940 = G__15969;
i__15941 = G__15970;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function cljs$core$fn_15954(this$,key,f){
var self__ = this;
var this$__$1 = this;
(this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches,key,f));

return this$__$1;
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function cljs$core$fn_15955(this$,key){
var self__ = this;
var this$__$1 = this;
return (this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches,key));
}));

(cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15956(this$){
var self__ = this;
var this$__$1 = this;
return goog.getUid(this$__$1);
}));

(cljs.core.Atom.getBasis = (function cljs$core$fn_15957(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"validator","validator",-325659154,null),new cljs.core.Symbol(null,"watches","watches",1367433992,null)], null);
}));

(cljs.core.Atom.cljs$lang$type = true);

(cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom");

(cljs.core.Atom.cljs$lang$ctorPrWriter = (function cljs$core$fn_15958(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/Atom");
}));

/**
 * Positional factory function for cljs.core/Atom.
 */
cljs.core.__GT_Atom = (function cljs$core$__GT_Atom(state,meta,validator,watches){
return (new cljs.core.Atom(state,meta,validator,watches));
});

/**
 * Creates and returns an Atom with an initial value of x and zero or
 *   more options (in any order):
 * 
 *   :meta metadata-map
 * 
 *   :validator validate-fn
 * 
 *   If metadata-map is supplied, it will become the metadata on the
 *   atom. validate-fn must be nil or a side-effect-free fn of one
 *   argument, which will be passed the intended new state on any state
 *   change. If the new state is unacceptable, the validate-fn should
 *   return false or throw an Error.  If either of these error conditions
 *   occur, then the value of the atom will not change.
 */
cljs.core.atom = (function cljs$core$atom(var_args){
var G__15974 = arguments.length;
switch (G__15974) {
case 1:
return cljs.core.atom.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___15981 = arguments.length;
var i__10847__auto___15982 = (0);
while(true){
if((i__10847__auto___15982 < len__10846__auto___15981)){
args_arr__10875__auto__.push((arguments[i__10847__auto___15982]));

var G__15983 = (i__10847__auto___15982 + (1));
i__10847__auto___15982 = G__15983;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((1) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((1)),(0),null)):null);
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10876__auto__);

}
});

(cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15975(x){
return (new cljs.core.Atom(x,null,null,null));
}));

(cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15977(x,p__15976){
var map__15978 = p__15976;
var map__15978__$1 = cljs.core.__destructure_map(map__15978);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15978__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15978__$1,new cljs.core.Keyword(null,"validator","validator",-1966190681));
return (new cljs.core.Atom(x,meta,validator,null));
}));

/** @this {Function} */
(cljs.core.atom.cljs$lang$applyTo = (function cljs$core$fn_15979(seq15972){
var G__15973 = cljs.core.first(seq15972);
var seq15972__$1 = cljs.core.next(seq15972);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15973,seq15972__$1);
}));

(cljs.core.atom.cljs$lang$maxFixedArity = (1));

/**
 * Sets the value of atom to newval without regard for the
 *   current value. Returns new-value.
 */
cljs.core.reset_BANG_ = (function cljs$core$reset_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null,new_value)))){
} else {
throw (new Error("Validator rejected reference state"));
}
}

var old_value = a.state;
(a.state = new_value);

if((a.watches == null)){
} else {
a.cljs$core$IWatchable$_notify_watches$arity$3(null,old_value,new_value);
}

return new_value;
} else {
return cljs.core._reset_BANG_(a,new_value);
}
});
/**
 * Sets the value of atom to newval. Returns [old new], the value of the
 * atom before and after the reset.
 */
cljs.core.reset_vals_BANG_ = (function cljs$core$reset_vals_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null,new_value)))){
} else {
throw (new Error("Validator rejected reference state"));
}
}

var old_value = a.state;
(a.state = new_value);

if((a.watches == null)){
} else {
a.cljs$core$IWatchable$_notify_watches$arity$3(null,old_value,new_value);
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_value,new_value], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._reset_BANG_(a,new_value)], null);
}
});
/**
 * Atomically swaps the value of atom to be:
 *   (apply f current-value-of-atom args). Note that f may be called
 *   multiple times, and thus should be free of side effects.  Returns
 *   the value that was swapped in.
 */
cljs.core.swap_BANG_ = (function cljs$core$swap_BANG_(var_args){
var G__15990 = arguments.length;
switch (G__15990) {
case 2:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___16003 = arguments.length;
var i__10847__auto___16004 = (0);
while(true){
if((i__10847__auto___16004 < len__10846__auto___16003)){
args_arr__10875__auto__.push((arguments[i__10847__auto___16004]));

var G__16005 = (i__10847__auto___16004 + (1));
i__10847__auto___16004 = G__16005;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((4) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((4)),(0),null)):null);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10876__auto__);

}
});

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15991(a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__15992 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15992) : f.call(null,G__15992));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15993(a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__15994 = a.state;
var G__15995 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15994,G__15995) : f.call(null,G__15994,G__15995));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15996(a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__15997 = a.state;
var G__15998 = x;
var G__15999 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15997,G__15998,G__15999) : f.call(null,G__15997,G__15998,G__15999));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16000(a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more);
}
}));

/** @this {Function} */
(cljs.core.swap_BANG_.cljs$lang$applyTo = (function cljs$core$fn_16001(seq15985){
var G__15986 = cljs.core.first(seq15985);
var seq15985__$1 = cljs.core.next(seq15985);
var G__15987 = cljs.core.first(seq15985__$1);
var seq15985__$2 = cljs.core.next(seq15985__$1);
var G__15988 = cljs.core.first(seq15985__$2);
var seq15985__$3 = cljs.core.next(seq15985__$2);
var G__15989 = cljs.core.first(seq15985__$3);
var seq15985__$4 = cljs.core.next(seq15985__$3);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15986,G__15987,G__15988,G__15989,seq15985__$4);
}));

(cljs.core.swap_BANG_.cljs$lang$maxFixedArity = (4));

/**
 * Atomically swaps the value of atom to be:
 *   (apply f current-value-of-atom args). Note that f may be called
 *   multiple times, and thus should be free of side effects.
 *   Returns [old new], the value of the atom before and after the swap.
 */
cljs.core.swap_vals_BANG_ = (function cljs$core$swap_vals_BANG_(var_args){
var G__16012 = arguments.length;
switch (G__16012) {
case 2:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___16025 = arguments.length;
var i__10847__auto___16026 = (0);
while(true){
if((i__10847__auto___16026 < len__10846__auto___16025)){
args_arr__10875__auto__.push((arguments[i__10847__auto___16026]));

var G__16027 = (i__10847__auto___16026 + (1));
i__10847__auto___16026 = G__16027;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((4) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((4)),(0),null)):null);
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10876__auto__);

}
});

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16013(a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_vals_BANG_(a,(function (){var G__16014 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16014) : f.call(null,G__16014));
})());
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f)], null);
}
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16015(a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_vals_BANG_(a,(function (){var G__16016 = a.state;
var G__16017 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16016,G__16017) : f.call(null,G__16016,G__16017));
})());
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x)], null);
}
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16018(a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_vals_BANG_(a,(function (){var G__16019 = a.state;
var G__16020 = x;
var G__16021 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16019,G__16020,G__16021) : f.call(null,G__16019,G__16020,G__16021));
})());
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y)], null);
}
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16022(a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_vals_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more)], null);
}
}));

/** @this {Function} */
(cljs.core.swap_vals_BANG_.cljs$lang$applyTo = (function cljs$core$fn_16023(seq16007){
var G__16008 = cljs.core.first(seq16007);
var seq16007__$1 = cljs.core.next(seq16007);
var G__16009 = cljs.core.first(seq16007__$1);
var seq16007__$2 = cljs.core.next(seq16007__$1);
var G__16010 = cljs.core.first(seq16007__$2);
var seq16007__$3 = cljs.core.next(seq16007__$2);
var G__16011 = cljs.core.first(seq16007__$3);
var seq16007__$4 = cljs.core.next(seq16007__$3);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16008,G__16009,G__16010,G__16011,seq16007__$4);
}));

(cljs.core.swap_vals_BANG_.cljs$lang$maxFixedArity = (4));

/**
 * Atomically sets the value of atom to newval if and only if the
 *   current value of the atom is equal to oldval. Returns true if
 *   set happened, else false.
 */
cljs.core.compare_and_set_BANG_ = (function cljs$core$compare_and_set_BANG_(a,oldval,newval){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null),oldval)){
cljs.core.reset_BANG_(a,newval);

return true;
} else {
return false;
}
});
/**
 * Sets the validator-fn for an atom. validator-fn must be nil or a
 *   side-effect-free fn of one argument, which will be passed the intended
 *   new state on any state change. If the new state is unacceptable, the
 *   validator-fn should return false or throw an Error. If the current state
 *   is not acceptable to the new validator, an Error will be thrown and the
 *   validator will not be changed.
 */
cljs.core.set_validator_BANG_ = (function cljs$core$set_validator_BANG_(iref,val){
if((((!((val == null)))) && (cljs.core.not((function (){var G__16028 = cljs.core._deref(iref);
return (val.cljs$core$IFn$_invoke$arity$1 ? val.cljs$core$IFn$_invoke$arity$1(G__16028) : val.call(null,G__16028));
})())))){
throw (new Error("Validator rejected reference state"));
} else {
}

return (iref.validator = val);
});
/**
 * Gets the validator-fn for a var/ref/agent/atom.
 */
cljs.core.get_validator = (function cljs$core$get_validator(iref){
return iref.validator;
});

/**
* @constructor
 * @implements {cljs.core.IVolatile}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Volatile = (function (state){
this.state = state;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Volatile.prototype.cljs$core$IVolatile$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = (function cljs$core$fn_16029(_,new_state){
var self__ = this;
var ___$1 = this;
return (self__.state = new_state);
}));

(cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = (function cljs$core$fn_16030(_){
var self__ = this;
var ___$1 = this;
return self__.state;
}));

(cljs.core.Volatile.getBasis = (function cljs$core$fn_16031(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Volatile.cljs$lang$type = true);

(cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile");

(cljs.core.Volatile.cljs$lang$ctorPrWriter = (function cljs$core$fn_16032(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/Volatile");
}));

/**
 * Positional factory function for cljs.core/Volatile.
 */
cljs.core.__GT_Volatile = (function cljs$core$__GT_Volatile(state){
return (new cljs.core.Volatile(state));
});

/**
 * Creates and returns a Volatile with an initial value of val.
 */
cljs.core.volatile_BANG_ = (function cljs$core$volatile_BANG_(val){
return (new cljs.core.Volatile(val));
});
/**
 * Returns true if x is a volatile.
 */
cljs.core.volatile_QMARK_ = (function cljs$core$volatile_QMARK_(x){
return (x instanceof cljs.core.Volatile);
});
/**
 * Sets the value of volatile to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.vreset_BANG_ = (function cljs$core$vreset_BANG_(vol,newval){
return cljs.core._vreset_BANG_(vol,newval);
});
/**
 * Returns a lazy sequence of the non-nil results of (f index item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a stateful transducer when no collection is
 *   provided.
 */
cljs.core.keep_indexed = (function cljs$core$keep_indexed(var_args){
var G__16034 = arguments.length;
switch (G__16034) {
case 1:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16035(f){
return (function cljs$core$fn_16035_$_fn_16036(rf){
var ia = cljs.core.volatile_BANG_((-1));
return (function() {
var cljs$core$fn_16035_$_fn_16036_$_fn_16037 = null;
var cljs$core$fn_16035_$_fn_16036_$_fn_16037__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16035_$_fn_16036_$_fn_16037__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16035_$_fn_16036_$_fn_16037__2 = (function (result,input){
var i = ia.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(ia.cljs$core$IDeref$_deref$arity$1(null) + (1)));
var v = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(i,input) : f.call(null,i,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
cljs$core$fn_16035_$_fn_16036_$_fn_16037 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16035_$_fn_16036_$_fn_16037__0.call(this);
case 1:
return cljs$core$fn_16035_$_fn_16036_$_fn_16037__1.call(this,result);
case 2:
return cljs$core$fn_16035_$_fn_16036_$_fn_16037__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16035_$_fn_16036_$_fn_16037.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16035_$_fn_16036_$_fn_16037__0;
cljs$core$fn_16035_$_fn_16036_$_fn_16037.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16035_$_fn_16036_$_fn_16037__1;
cljs$core$fn_16035_$_fn_16036_$_fn_16037.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16035_$_fn_16036_$_fn_16037__2;
return cljs$core$fn_16035_$_fn_16036_$_fn_16037;
})()
});
}));

(cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16038(f,coll){
var keepi = (function cljs$core$fn_16038_$_keepi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16038_$_keepi_$_fn_16044(){
var temp__5720__auto__ = cljs.core.seq(coll__$1);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__10605__auto___16050 = size;
var i_16051 = (0);
while(true){
if((i_16051 < n__10605__auto___16050)){
var x_16052 = (function (){var G__16045 = (idx + i_16051);
var G__16046 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_16051);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16045,G__16046) : f.call(null,G__16045,G__16046));
})();
if((x_16052 == null)){
} else {
cljs.core.chunk_append(b,x_16052);
}

var G__16053 = (i_16051 + (1));
i_16051 = G__16053;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$fn_16038_$_keepi((idx + size),cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__16047 = idx;
var G__16048 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16047,G__16048) : f.call(null,G__16047,G__16048));
})();
if((x == null)){
return cljs$core$fn_16038_$_keepi((idx + (1)),cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs$core$fn_16038_$_keepi((idx + (1)),cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
return keepi((0),coll);
}));

(cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2);

/**
 * Takes a set of predicates and returns a function f that returns true if all of its
 *   composing predicates return a logical true value against all of its arguments, else it returns
 *   false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical false result against the original predicates.
 */
cljs.core.every_pred = (function cljs$core$every_pred(var_args){
var G__16065 = arguments.length;
switch (G__16065) {
case 1:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___16078 = arguments.length;
var i__10847__auto___16079 = (0);
while(true){
if((i__10847__auto___16079 < len__10846__auto___16078)){
args_arr__10875__auto__.push((arguments[i__10847__auto___16079]));

var G__16080 = (i__10847__auto___16079 + (1));
i__10847__auto___16079 = G__16080;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((3) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((3)),(0),null)):null);
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10876__auto__);

}
});

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16066(p){
return (function() {
var cljs$core$fn_16066_$_ep1 = null;
var cljs$core$fn_16066_$_ep1__0 = (function (){
return true;
});
var cljs$core$fn_16066_$_ep1__1 = (function (x){
return cljs.core.boolean$((p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x)));
});
var cljs$core$fn_16066_$_ep1__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__9511__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__9511__auto__)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
} else {
return and__9511__auto__;
}
})());
});
var cljs$core$fn_16066_$_ep1__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__9511__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__9511__auto__)){
var and__9511__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(and__9511__auto____$1)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
} else {
return and__9511__auto____$1;
}
} else {
return and__9511__auto__;
}
})());
});
var cljs$core$fn_16066_$_ep1__4 = (function() { 
var G__16081__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__9511__auto__ = cljs$core$fn_16066_$_ep1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__9511__auto__)){
return cljs.core.every_QMARK_(p,args);
} else {
return and__9511__auto__;
}
})());
};
var G__16081 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16082__i = 0, G__16082__a = new Array(arguments.length -  3);
while (G__16082__i < G__16082__a.length) {G__16082__a[G__16082__i] = arguments[G__16082__i + 3]; ++G__16082__i;}
  args = new cljs.core.IndexedSeq(G__16082__a,0,null);
} 
return G__16081__delegate.call(this,x,y,z,args);};
G__16081.cljs$lang$maxFixedArity = 3;
G__16081.cljs$lang$applyTo = (function (arglist__16083){
var x = cljs.core.first(arglist__16083);
arglist__16083 = cljs.core.next(arglist__16083);
var y = cljs.core.first(arglist__16083);
arglist__16083 = cljs.core.next(arglist__16083);
var z = cljs.core.first(arglist__16083);
var args = cljs.core.rest(arglist__16083);
return G__16081__delegate(x,y,z,args);
});
G__16081.cljs$core$IFn$_invoke$arity$variadic = G__16081__delegate;
return G__16081;
})()
;
cljs$core$fn_16066_$_ep1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16066_$_ep1__0.call(this);
case 1:
return cljs$core$fn_16066_$_ep1__1.call(this,x);
case 2:
return cljs$core$fn_16066_$_ep1__2.call(this,x,y);
case 3:
return cljs$core$fn_16066_$_ep1__3.call(this,x,y,z);
default:
var G__16084 = null;
if (arguments.length > 3) {
var G__16085__i = 0, G__16085__a = new Array(arguments.length -  3);
while (G__16085__i < G__16085__a.length) {G__16085__a[G__16085__i] = arguments[G__16085__i + 3]; ++G__16085__i;}
G__16084 = new cljs.core.IndexedSeq(G__16085__a,0,null);
}
return cljs$core$fn_16066_$_ep1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16084);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16066_$_ep1.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16066_$_ep1.cljs$lang$applyTo = cljs$core$fn_16066_$_ep1__4.cljs$lang$applyTo;
cljs$core$fn_16066_$_ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16066_$_ep1__0;
cljs$core$fn_16066_$_ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16066_$_ep1__1;
cljs$core$fn_16066_$_ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16066_$_ep1__2;
cljs$core$fn_16066_$_ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16066_$_ep1__3;
cljs$core$fn_16066_$_ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16066_$_ep1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16066_$_ep1;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16067(p1,p2){
return (function() {
var cljs$core$fn_16067_$_ep2 = null;
var cljs$core$fn_16067_$_ep2__0 = (function (){
return true;
});
var cljs$core$fn_16067_$_ep2__1 = (function (x){
return cljs.core.boolean$((function (){var and__9511__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9511__auto__)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
} else {
return and__9511__auto__;
}
})());
});
var cljs$core$fn_16067_$_ep2__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__9511__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9511__auto__)){
var and__9511__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__9511__auto____$1)){
var and__9511__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__9511__auto____$2)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
} else {
return and__9511__auto____$2;
}
} else {
return and__9511__auto____$1;
}
} else {
return and__9511__auto__;
}
})());
});
var cljs$core$fn_16067_$_ep2__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__9511__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9511__auto__)){
var and__9511__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__9511__auto____$1)){
var and__9511__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__9511__auto____$2)){
var and__9511__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__9511__auto____$3)){
var and__9511__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__9511__auto____$4)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
} else {
return and__9511__auto____$4;
}
} else {
return and__9511__auto____$3;
}
} else {
return and__9511__auto____$2;
}
} else {
return and__9511__auto____$1;
}
} else {
return and__9511__auto__;
}
})());
});
var cljs$core$fn_16067_$_ep2__4 = (function() { 
var G__16086__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__9511__auto__ = cljs$core$fn_16067_$_ep2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__9511__auto__)){
return cljs.core.every_QMARK_((function cljs$core$fn_16067_$_ep2_$_fn_16068(p1__16054_SHARP_){
var and__9511__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__16054_SHARP_) : p1.call(null,p1__16054_SHARP_));
if(cljs.core.truth_(and__9511__auto____$1)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__16054_SHARP_) : p2.call(null,p1__16054_SHARP_));
} else {
return and__9511__auto____$1;
}
}),args);
} else {
return and__9511__auto__;
}
})());
};
var G__16086 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16087__i = 0, G__16087__a = new Array(arguments.length -  3);
while (G__16087__i < G__16087__a.length) {G__16087__a[G__16087__i] = arguments[G__16087__i + 3]; ++G__16087__i;}
  args = new cljs.core.IndexedSeq(G__16087__a,0,null);
} 
return G__16086__delegate.call(this,x,y,z,args);};
G__16086.cljs$lang$maxFixedArity = 3;
G__16086.cljs$lang$applyTo = (function (arglist__16088){
var x = cljs.core.first(arglist__16088);
arglist__16088 = cljs.core.next(arglist__16088);
var y = cljs.core.first(arglist__16088);
arglist__16088 = cljs.core.next(arglist__16088);
var z = cljs.core.first(arglist__16088);
var args = cljs.core.rest(arglist__16088);
return G__16086__delegate(x,y,z,args);
});
G__16086.cljs$core$IFn$_invoke$arity$variadic = G__16086__delegate;
return G__16086;
})()
;
cljs$core$fn_16067_$_ep2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16067_$_ep2__0.call(this);
case 1:
return cljs$core$fn_16067_$_ep2__1.call(this,x);
case 2:
return cljs$core$fn_16067_$_ep2__2.call(this,x,y);
case 3:
return cljs$core$fn_16067_$_ep2__3.call(this,x,y,z);
default:
var G__16089 = null;
if (arguments.length > 3) {
var G__16090__i = 0, G__16090__a = new Array(arguments.length -  3);
while (G__16090__i < G__16090__a.length) {G__16090__a[G__16090__i] = arguments[G__16090__i + 3]; ++G__16090__i;}
G__16089 = new cljs.core.IndexedSeq(G__16090__a,0,null);
}
return cljs$core$fn_16067_$_ep2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16067_$_ep2.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16067_$_ep2.cljs$lang$applyTo = cljs$core$fn_16067_$_ep2__4.cljs$lang$applyTo;
cljs$core$fn_16067_$_ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16067_$_ep2__0;
cljs$core$fn_16067_$_ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16067_$_ep2__1;
cljs$core$fn_16067_$_ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16067_$_ep2__2;
cljs$core$fn_16067_$_ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16067_$_ep2__3;
cljs$core$fn_16067_$_ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16067_$_ep2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16067_$_ep2;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16069(p1,p2,p3){
return (function() {
var cljs$core$fn_16069_$_ep3 = null;
var cljs$core$fn_16069_$_ep3__0 = (function (){
return true;
});
var cljs$core$fn_16069_$_ep3__1 = (function (x){
return cljs.core.boolean$((function (){var and__9511__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9511__auto__)){
var and__9511__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__9511__auto____$1)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
} else {
return and__9511__auto____$1;
}
} else {
return and__9511__auto__;
}
})());
});
var cljs$core$fn_16069_$_ep3__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__9511__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9511__auto__)){
var and__9511__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__9511__auto____$1)){
var and__9511__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__9511__auto____$2)){
var and__9511__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__9511__auto____$3)){
var and__9511__auto____$4 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__9511__auto____$4)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
} else {
return and__9511__auto____$4;
}
} else {
return and__9511__auto____$3;
}
} else {
return and__9511__auto____$2;
}
} else {
return and__9511__auto____$1;
}
} else {
return and__9511__auto__;
}
})());
});
var cljs$core$fn_16069_$_ep3__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__9511__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9511__auto__)){
var and__9511__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__9511__auto____$1)){
var and__9511__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__9511__auto____$2)){
var and__9511__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__9511__auto____$3)){
var and__9511__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__9511__auto____$4)){
var and__9511__auto____$5 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(and__9511__auto____$5)){
var and__9511__auto____$6 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__9511__auto____$6)){
var and__9511__auto____$7 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(and__9511__auto____$7)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
} else {
return and__9511__auto____$7;
}
} else {
return and__9511__auto____$6;
}
} else {
return and__9511__auto____$5;
}
} else {
return and__9511__auto____$4;
}
} else {
return and__9511__auto____$3;
}
} else {
return and__9511__auto____$2;
}
} else {
return and__9511__auto____$1;
}
} else {
return and__9511__auto__;
}
})());
});
var cljs$core$fn_16069_$_ep3__4 = (function() { 
var G__16091__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__9511__auto__ = cljs$core$fn_16069_$_ep3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__9511__auto__)){
return cljs.core.every_QMARK_((function cljs$core$fn_16069_$_ep3_$_fn_16070(p1__16055_SHARP_){
var and__9511__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__16055_SHARP_) : p1.call(null,p1__16055_SHARP_));
if(cljs.core.truth_(and__9511__auto____$1)){
var and__9511__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__16055_SHARP_) : p2.call(null,p1__16055_SHARP_));
if(cljs.core.truth_(and__9511__auto____$2)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__16055_SHARP_) : p3.call(null,p1__16055_SHARP_));
} else {
return and__9511__auto____$2;
}
} else {
return and__9511__auto____$1;
}
}),args);
} else {
return and__9511__auto__;
}
})());
};
var G__16091 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16092__i = 0, G__16092__a = new Array(arguments.length -  3);
while (G__16092__i < G__16092__a.length) {G__16092__a[G__16092__i] = arguments[G__16092__i + 3]; ++G__16092__i;}
  args = new cljs.core.IndexedSeq(G__16092__a,0,null);
} 
return G__16091__delegate.call(this,x,y,z,args);};
G__16091.cljs$lang$maxFixedArity = 3;
G__16091.cljs$lang$applyTo = (function (arglist__16093){
var x = cljs.core.first(arglist__16093);
arglist__16093 = cljs.core.next(arglist__16093);
var y = cljs.core.first(arglist__16093);
arglist__16093 = cljs.core.next(arglist__16093);
var z = cljs.core.first(arglist__16093);
var args = cljs.core.rest(arglist__16093);
return G__16091__delegate(x,y,z,args);
});
G__16091.cljs$core$IFn$_invoke$arity$variadic = G__16091__delegate;
return G__16091;
})()
;
cljs$core$fn_16069_$_ep3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16069_$_ep3__0.call(this);
case 1:
return cljs$core$fn_16069_$_ep3__1.call(this,x);
case 2:
return cljs$core$fn_16069_$_ep3__2.call(this,x,y);
case 3:
return cljs$core$fn_16069_$_ep3__3.call(this,x,y,z);
default:
var G__16094 = null;
if (arguments.length > 3) {
var G__16095__i = 0, G__16095__a = new Array(arguments.length -  3);
while (G__16095__i < G__16095__a.length) {G__16095__a[G__16095__i] = arguments[G__16095__i + 3]; ++G__16095__i;}
G__16094 = new cljs.core.IndexedSeq(G__16095__a,0,null);
}
return cljs$core$fn_16069_$_ep3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16094);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16069_$_ep3.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16069_$_ep3.cljs$lang$applyTo = cljs$core$fn_16069_$_ep3__4.cljs$lang$applyTo;
cljs$core$fn_16069_$_ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16069_$_ep3__0;
cljs$core$fn_16069_$_ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16069_$_ep3__1;
cljs$core$fn_16069_$_ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16069_$_ep3__2;
cljs$core$fn_16069_$_ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16069_$_ep3__3;
cljs$core$fn_16069_$_ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16069_$_ep3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16069_$_ep3;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16071(p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return (function() {
var cljs$core$fn_16071_$_epn = null;
var cljs$core$fn_16071_$_epn__0 = (function (){
return true;
});
var cljs$core$fn_16071_$_epn__1 = (function (x){
return cljs.core.every_QMARK_((function cljs$core$fn_16071_$_epn_$_fn_16072(p1__16056_SHARP_){
return (p1__16056_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16056_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16056_SHARP_.call(null,x));
}),ps__$1);
});
var cljs$core$fn_16071_$_epn__2 = (function (x,y){
return cljs.core.every_QMARK_((function cljs$core$fn_16071_$_epn_$_fn_16073(p1__16057_SHARP_){
var and__9511__auto__ = (p1__16057_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16057_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16057_SHARP_.call(null,x));
if(cljs.core.truth_(and__9511__auto__)){
return (p1__16057_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16057_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__16057_SHARP_.call(null,y));
} else {
return and__9511__auto__;
}
}),ps__$1);
});
var cljs$core$fn_16071_$_epn__3 = (function (x,y,z){
return cljs.core.every_QMARK_((function cljs$core$fn_16071_$_epn_$_fn_16074(p1__16058_SHARP_){
var and__9511__auto__ = (p1__16058_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16058_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16058_SHARP_.call(null,x));
if(cljs.core.truth_(and__9511__auto__)){
var and__9511__auto____$1 = (p1__16058_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16058_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__16058_SHARP_.call(null,y));
if(cljs.core.truth_(and__9511__auto____$1)){
return (p1__16058_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16058_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__16058_SHARP_.call(null,z));
} else {
return and__9511__auto____$1;
}
} else {
return and__9511__auto__;
}
}),ps__$1);
});
var cljs$core$fn_16071_$_epn__4 = (function() { 
var G__16096__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__9511__auto__ = cljs$core$fn_16071_$_epn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__9511__auto__)){
return cljs.core.every_QMARK_((function cljs$core$fn_16071_$_epn_$_fn_16075(p1__16059_SHARP_){
return cljs.core.every_QMARK_(p1__16059_SHARP_,args);
}),ps__$1);
} else {
return and__9511__auto__;
}
})());
};
var G__16096 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16097__i = 0, G__16097__a = new Array(arguments.length -  3);
while (G__16097__i < G__16097__a.length) {G__16097__a[G__16097__i] = arguments[G__16097__i + 3]; ++G__16097__i;}
  args = new cljs.core.IndexedSeq(G__16097__a,0,null);
} 
return G__16096__delegate.call(this,x,y,z,args);};
G__16096.cljs$lang$maxFixedArity = 3;
G__16096.cljs$lang$applyTo = (function (arglist__16098){
var x = cljs.core.first(arglist__16098);
arglist__16098 = cljs.core.next(arglist__16098);
var y = cljs.core.first(arglist__16098);
arglist__16098 = cljs.core.next(arglist__16098);
var z = cljs.core.first(arglist__16098);
var args = cljs.core.rest(arglist__16098);
return G__16096__delegate(x,y,z,args);
});
G__16096.cljs$core$IFn$_invoke$arity$variadic = G__16096__delegate;
return G__16096;
})()
;
cljs$core$fn_16071_$_epn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16071_$_epn__0.call(this);
case 1:
return cljs$core$fn_16071_$_epn__1.call(this,x);
case 2:
return cljs$core$fn_16071_$_epn__2.call(this,x,y);
case 3:
return cljs$core$fn_16071_$_epn__3.call(this,x,y,z);
default:
var G__16099 = null;
if (arguments.length > 3) {
var G__16100__i = 0, G__16100__a = new Array(arguments.length -  3);
while (G__16100__i < G__16100__a.length) {G__16100__a[G__16100__i] = arguments[G__16100__i + 3]; ++G__16100__i;}
G__16099 = new cljs.core.IndexedSeq(G__16100__a,0,null);
}
return cljs$core$fn_16071_$_epn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16099);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16071_$_epn.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16071_$_epn.cljs$lang$applyTo = cljs$core$fn_16071_$_epn__4.cljs$lang$applyTo;
cljs$core$fn_16071_$_epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16071_$_epn__0;
cljs$core$fn_16071_$_epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16071_$_epn__1;
cljs$core$fn_16071_$_epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16071_$_epn__2;
cljs$core$fn_16071_$_epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16071_$_epn__3;
cljs$core$fn_16071_$_epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16071_$_epn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16071_$_epn;
})()
}));

/** @this {Function} */
(cljs.core.every_pred.cljs$lang$applyTo = (function cljs$core$fn_16076(seq16061){
var G__16062 = cljs.core.first(seq16061);
var seq16061__$1 = cljs.core.next(seq16061);
var G__16063 = cljs.core.first(seq16061__$1);
var seq16061__$2 = cljs.core.next(seq16061__$1);
var G__16064 = cljs.core.first(seq16061__$2);
var seq16061__$3 = cljs.core.next(seq16061__$2);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16062,G__16063,G__16064,seq16061__$3);
}));

(cljs.core.every_pred.cljs$lang$maxFixedArity = (3));

/**
 * Takes a set of predicates and returns a function f that returns the first logical true value
 *   returned by one of its composing predicates against any of its arguments, else it returns
 *   logical false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical true result against the original predicates.
 */
cljs.core.some_fn = (function cljs$core$some_fn(var_args){
var G__16112 = arguments.length;
switch (G__16112) {
case 1:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___16125 = arguments.length;
var i__10847__auto___16126 = (0);
while(true){
if((i__10847__auto___16126 < len__10846__auto___16125)){
args_arr__10875__auto__.push((arguments[i__10847__auto___16126]));

var G__16127 = (i__10847__auto___16126 + (1));
i__10847__auto___16126 = G__16127;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((3) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((3)),(0),null)):null);
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10876__auto__);

}
});

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16113(p){
return (function() {
var cljs$core$fn_16113_$_sp1 = null;
var cljs$core$fn_16113_$_sp1__0 = (function (){
return null;
});
var cljs$core$fn_16113_$_sp1__1 = (function (x){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
});
var cljs$core$fn_16113_$_sp1__2 = (function (x,y){
var or__9517__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__9517__auto__)){
return or__9517__auto__;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
}
});
var cljs$core$fn_16113_$_sp1__3 = (function (x,y,z){
var or__9517__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__9517__auto__)){
return or__9517__auto__;
} else {
var or__9517__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(or__9517__auto____$1)){
return or__9517__auto____$1;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
}
}
});
var cljs$core$fn_16113_$_sp1__4 = (function() { 
var G__16128__delegate = function (x,y,z,args){
var or__9517__auto__ = cljs$core$fn_16113_$_sp1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__9517__auto__)){
return or__9517__auto__;
} else {
return cljs.core.some(p,args);
}
};
var G__16128 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16129__i = 0, G__16129__a = new Array(arguments.length -  3);
while (G__16129__i < G__16129__a.length) {G__16129__a[G__16129__i] = arguments[G__16129__i + 3]; ++G__16129__i;}
  args = new cljs.core.IndexedSeq(G__16129__a,0,null);
} 
return G__16128__delegate.call(this,x,y,z,args);};
G__16128.cljs$lang$maxFixedArity = 3;
G__16128.cljs$lang$applyTo = (function (arglist__16130){
var x = cljs.core.first(arglist__16130);
arglist__16130 = cljs.core.next(arglist__16130);
var y = cljs.core.first(arglist__16130);
arglist__16130 = cljs.core.next(arglist__16130);
var z = cljs.core.first(arglist__16130);
var args = cljs.core.rest(arglist__16130);
return G__16128__delegate(x,y,z,args);
});
G__16128.cljs$core$IFn$_invoke$arity$variadic = G__16128__delegate;
return G__16128;
})()
;
cljs$core$fn_16113_$_sp1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16113_$_sp1__0.call(this);
case 1:
return cljs$core$fn_16113_$_sp1__1.call(this,x);
case 2:
return cljs$core$fn_16113_$_sp1__2.call(this,x,y);
case 3:
return cljs$core$fn_16113_$_sp1__3.call(this,x,y,z);
default:
var G__16131 = null;
if (arguments.length > 3) {
var G__16132__i = 0, G__16132__a = new Array(arguments.length -  3);
while (G__16132__i < G__16132__a.length) {G__16132__a[G__16132__i] = arguments[G__16132__i + 3]; ++G__16132__i;}
G__16131 = new cljs.core.IndexedSeq(G__16132__a,0,null);
}
return cljs$core$fn_16113_$_sp1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16131);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16113_$_sp1.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16113_$_sp1.cljs$lang$applyTo = cljs$core$fn_16113_$_sp1__4.cljs$lang$applyTo;
cljs$core$fn_16113_$_sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16113_$_sp1__0;
cljs$core$fn_16113_$_sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16113_$_sp1__1;
cljs$core$fn_16113_$_sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16113_$_sp1__2;
cljs$core$fn_16113_$_sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16113_$_sp1__3;
cljs$core$fn_16113_$_sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16113_$_sp1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16113_$_sp1;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16114(p1,p2){
return (function() {
var cljs$core$fn_16114_$_sp2 = null;
var cljs$core$fn_16114_$_sp2__0 = (function (){
return null;
});
var cljs$core$fn_16114_$_sp2__1 = (function (x){
var or__9517__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9517__auto__)){
return or__9517__auto__;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
}
});
var cljs$core$fn_16114_$_sp2__2 = (function (x,y){
var or__9517__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9517__auto__)){
return or__9517__auto__;
} else {
var or__9517__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__9517__auto____$1)){
return or__9517__auto____$1;
} else {
var or__9517__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__9517__auto____$2)){
return or__9517__auto____$2;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
}
}
}
});
var cljs$core$fn_16114_$_sp2__3 = (function (x,y,z){
var or__9517__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9517__auto__)){
return or__9517__auto__;
} else {
var or__9517__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__9517__auto____$1)){
return or__9517__auto____$1;
} else {
var or__9517__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__9517__auto____$2)){
return or__9517__auto____$2;
} else {
var or__9517__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__9517__auto____$3)){
return or__9517__auto____$3;
} else {
var or__9517__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__9517__auto____$4)){
return or__9517__auto____$4;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
}
}
}
}
}
});
var cljs$core$fn_16114_$_sp2__4 = (function() { 
var G__16133__delegate = function (x,y,z,args){
var or__9517__auto__ = cljs$core$fn_16114_$_sp2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__9517__auto__)){
return or__9517__auto__;
} else {
return cljs.core.some((function cljs$core$fn_16114_$_sp2_$_fn_16115(p1__16101_SHARP_){
var or__9517__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__16101_SHARP_) : p1.call(null,p1__16101_SHARP_));
if(cljs.core.truth_(or__9517__auto____$1)){
return or__9517__auto____$1;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__16101_SHARP_) : p2.call(null,p1__16101_SHARP_));
}
}),args);
}
};
var G__16133 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16134__i = 0, G__16134__a = new Array(arguments.length -  3);
while (G__16134__i < G__16134__a.length) {G__16134__a[G__16134__i] = arguments[G__16134__i + 3]; ++G__16134__i;}
  args = new cljs.core.IndexedSeq(G__16134__a,0,null);
} 
return G__16133__delegate.call(this,x,y,z,args);};
G__16133.cljs$lang$maxFixedArity = 3;
G__16133.cljs$lang$applyTo = (function (arglist__16135){
var x = cljs.core.first(arglist__16135);
arglist__16135 = cljs.core.next(arglist__16135);
var y = cljs.core.first(arglist__16135);
arglist__16135 = cljs.core.next(arglist__16135);
var z = cljs.core.first(arglist__16135);
var args = cljs.core.rest(arglist__16135);
return G__16133__delegate(x,y,z,args);
});
G__16133.cljs$core$IFn$_invoke$arity$variadic = G__16133__delegate;
return G__16133;
})()
;
cljs$core$fn_16114_$_sp2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16114_$_sp2__0.call(this);
case 1:
return cljs$core$fn_16114_$_sp2__1.call(this,x);
case 2:
return cljs$core$fn_16114_$_sp2__2.call(this,x,y);
case 3:
return cljs$core$fn_16114_$_sp2__3.call(this,x,y,z);
default:
var G__16136 = null;
if (arguments.length > 3) {
var G__16137__i = 0, G__16137__a = new Array(arguments.length -  3);
while (G__16137__i < G__16137__a.length) {G__16137__a[G__16137__i] = arguments[G__16137__i + 3]; ++G__16137__i;}
G__16136 = new cljs.core.IndexedSeq(G__16137__a,0,null);
}
return cljs$core$fn_16114_$_sp2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16136);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16114_$_sp2.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16114_$_sp2.cljs$lang$applyTo = cljs$core$fn_16114_$_sp2__4.cljs$lang$applyTo;
cljs$core$fn_16114_$_sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16114_$_sp2__0;
cljs$core$fn_16114_$_sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16114_$_sp2__1;
cljs$core$fn_16114_$_sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16114_$_sp2__2;
cljs$core$fn_16114_$_sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16114_$_sp2__3;
cljs$core$fn_16114_$_sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16114_$_sp2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16114_$_sp2;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16116(p1,p2,p3){
return (function() {
var cljs$core$fn_16116_$_sp3 = null;
var cljs$core$fn_16116_$_sp3__0 = (function (){
return null;
});
var cljs$core$fn_16116_$_sp3__1 = (function (x){
var or__9517__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9517__auto__)){
return or__9517__auto__;
} else {
var or__9517__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__9517__auto____$1)){
return or__9517__auto____$1;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
}
}
});
var cljs$core$fn_16116_$_sp3__2 = (function (x,y){
var or__9517__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9517__auto__)){
return or__9517__auto__;
} else {
var or__9517__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__9517__auto____$1)){
return or__9517__auto____$1;
} else {
var or__9517__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__9517__auto____$2)){
return or__9517__auto____$2;
} else {
var or__9517__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__9517__auto____$3)){
return or__9517__auto____$3;
} else {
var or__9517__auto____$4 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__9517__auto____$4)){
return or__9517__auto____$4;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
}
}
}
}
}
});
var cljs$core$fn_16116_$_sp3__3 = (function (x,y,z){
var or__9517__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9517__auto__)){
return or__9517__auto__;
} else {
var or__9517__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__9517__auto____$1)){
return or__9517__auto____$1;
} else {
var or__9517__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__9517__auto____$2)){
return or__9517__auto____$2;
} else {
var or__9517__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__9517__auto____$3)){
return or__9517__auto____$3;
} else {
var or__9517__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__9517__auto____$4)){
return or__9517__auto____$4;
} else {
var or__9517__auto____$5 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(or__9517__auto____$5)){
return or__9517__auto____$5;
} else {
var or__9517__auto____$6 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__9517__auto____$6)){
return or__9517__auto____$6;
} else {
var or__9517__auto____$7 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(or__9517__auto____$7)){
return or__9517__auto____$7;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
}
}
}
}
}
}
}
}
});
var cljs$core$fn_16116_$_sp3__4 = (function() { 
var G__16138__delegate = function (x,y,z,args){
var or__9517__auto__ = cljs$core$fn_16116_$_sp3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__9517__auto__)){
return or__9517__auto__;
} else {
return cljs.core.some((function cljs$core$fn_16116_$_sp3_$_fn_16117(p1__16102_SHARP_){
var or__9517__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__16102_SHARP_) : p1.call(null,p1__16102_SHARP_));
if(cljs.core.truth_(or__9517__auto____$1)){
return or__9517__auto____$1;
} else {
var or__9517__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__16102_SHARP_) : p2.call(null,p1__16102_SHARP_));
if(cljs.core.truth_(or__9517__auto____$2)){
return or__9517__auto____$2;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__16102_SHARP_) : p3.call(null,p1__16102_SHARP_));
}
}
}),args);
}
};
var G__16138 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16139__i = 0, G__16139__a = new Array(arguments.length -  3);
while (G__16139__i < G__16139__a.length) {G__16139__a[G__16139__i] = arguments[G__16139__i + 3]; ++G__16139__i;}
  args = new cljs.core.IndexedSeq(G__16139__a,0,null);
} 
return G__16138__delegate.call(this,x,y,z,args);};
G__16138.cljs$lang$maxFixedArity = 3;
G__16138.cljs$lang$applyTo = (function (arglist__16140){
var x = cljs.core.first(arglist__16140);
arglist__16140 = cljs.core.next(arglist__16140);
var y = cljs.core.first(arglist__16140);
arglist__16140 = cljs.core.next(arglist__16140);
var z = cljs.core.first(arglist__16140);
var args = cljs.core.rest(arglist__16140);
return G__16138__delegate(x,y,z,args);
});
G__16138.cljs$core$IFn$_invoke$arity$variadic = G__16138__delegate;
return G__16138;
})()
;
cljs$core$fn_16116_$_sp3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16116_$_sp3__0.call(this);
case 1:
return cljs$core$fn_16116_$_sp3__1.call(this,x);
case 2:
return cljs$core$fn_16116_$_sp3__2.call(this,x,y);
case 3:
return cljs$core$fn_16116_$_sp3__3.call(this,x,y,z);
default:
var G__16141 = null;
if (arguments.length > 3) {
var G__16142__i = 0, G__16142__a = new Array(arguments.length -  3);
while (G__16142__i < G__16142__a.length) {G__16142__a[G__16142__i] = arguments[G__16142__i + 3]; ++G__16142__i;}
G__16141 = new cljs.core.IndexedSeq(G__16142__a,0,null);
}
return cljs$core$fn_16116_$_sp3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16141);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16116_$_sp3.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16116_$_sp3.cljs$lang$applyTo = cljs$core$fn_16116_$_sp3__4.cljs$lang$applyTo;
cljs$core$fn_16116_$_sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16116_$_sp3__0;
cljs$core$fn_16116_$_sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16116_$_sp3__1;
cljs$core$fn_16116_$_sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16116_$_sp3__2;
cljs$core$fn_16116_$_sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16116_$_sp3__3;
cljs$core$fn_16116_$_sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16116_$_sp3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16116_$_sp3;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16118(p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return (function() {
var cljs$core$fn_16118_$_spn = null;
var cljs$core$fn_16118_$_spn__0 = (function (){
return null;
});
var cljs$core$fn_16118_$_spn__1 = (function (x){
return cljs.core.some((function cljs$core$fn_16118_$_spn_$_fn_16119(p1__16103_SHARP_){
return (p1__16103_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16103_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16103_SHARP_.call(null,x));
}),ps__$1);
});
var cljs$core$fn_16118_$_spn__2 = (function (x,y){
return cljs.core.some((function cljs$core$fn_16118_$_spn_$_fn_16120(p1__16104_SHARP_){
var or__9517__auto__ = (p1__16104_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16104_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16104_SHARP_.call(null,x));
if(cljs.core.truth_(or__9517__auto__)){
return or__9517__auto__;
} else {
return (p1__16104_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16104_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__16104_SHARP_.call(null,y));
}
}),ps__$1);
});
var cljs$core$fn_16118_$_spn__3 = (function (x,y,z){
return cljs.core.some((function cljs$core$fn_16118_$_spn_$_fn_16121(p1__16105_SHARP_){
var or__9517__auto__ = (p1__16105_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16105_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16105_SHARP_.call(null,x));
if(cljs.core.truth_(or__9517__auto__)){
return or__9517__auto__;
} else {
var or__9517__auto____$1 = (p1__16105_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16105_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__16105_SHARP_.call(null,y));
if(cljs.core.truth_(or__9517__auto____$1)){
return or__9517__auto____$1;
} else {
return (p1__16105_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16105_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__16105_SHARP_.call(null,z));
}
}
}),ps__$1);
});
var cljs$core$fn_16118_$_spn__4 = (function() { 
var G__16143__delegate = function (x,y,z,args){
var or__9517__auto__ = cljs$core$fn_16118_$_spn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__9517__auto__)){
return or__9517__auto__;
} else {
return cljs.core.some((function cljs$core$fn_16118_$_spn_$_fn_16122(p1__16106_SHARP_){
return cljs.core.some(p1__16106_SHARP_,args);
}),ps__$1);
}
};
var G__16143 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16144__i = 0, G__16144__a = new Array(arguments.length -  3);
while (G__16144__i < G__16144__a.length) {G__16144__a[G__16144__i] = arguments[G__16144__i + 3]; ++G__16144__i;}
  args = new cljs.core.IndexedSeq(G__16144__a,0,null);
} 
return G__16143__delegate.call(this,x,y,z,args);};
G__16143.cljs$lang$maxFixedArity = 3;
G__16143.cljs$lang$applyTo = (function (arglist__16145){
var x = cljs.core.first(arglist__16145);
arglist__16145 = cljs.core.next(arglist__16145);
var y = cljs.core.first(arglist__16145);
arglist__16145 = cljs.core.next(arglist__16145);
var z = cljs.core.first(arglist__16145);
var args = cljs.core.rest(arglist__16145);
return G__16143__delegate(x,y,z,args);
});
G__16143.cljs$core$IFn$_invoke$arity$variadic = G__16143__delegate;
return G__16143;
})()
;
cljs$core$fn_16118_$_spn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16118_$_spn__0.call(this);
case 1:
return cljs$core$fn_16118_$_spn__1.call(this,x);
case 2:
return cljs$core$fn_16118_$_spn__2.call(this,x,y);
case 3:
return cljs$core$fn_16118_$_spn__3.call(this,x,y,z);
default:
var G__16146 = null;
if (arguments.length > 3) {
var G__16147__i = 0, G__16147__a = new Array(arguments.length -  3);
while (G__16147__i < G__16147__a.length) {G__16147__a[G__16147__i] = arguments[G__16147__i + 3]; ++G__16147__i;}
G__16146 = new cljs.core.IndexedSeq(G__16147__a,0,null);
}
return cljs$core$fn_16118_$_spn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16146);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16118_$_spn.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16118_$_spn.cljs$lang$applyTo = cljs$core$fn_16118_$_spn__4.cljs$lang$applyTo;
cljs$core$fn_16118_$_spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16118_$_spn__0;
cljs$core$fn_16118_$_spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16118_$_spn__1;
cljs$core$fn_16118_$_spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16118_$_spn__2;
cljs$core$fn_16118_$_spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16118_$_spn__3;
cljs$core$fn_16118_$_spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16118_$_spn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16118_$_spn;
})()
}));

/** @this {Function} */
(cljs.core.some_fn.cljs$lang$applyTo = (function cljs$core$fn_16123(seq16108){
var G__16109 = cljs.core.first(seq16108);
var seq16108__$1 = cljs.core.next(seq16108);
var G__16110 = cljs.core.first(seq16108__$1);
var seq16108__$2 = cljs.core.next(seq16108__$1);
var G__16111 = cljs.core.first(seq16108__$2);
var seq16108__$3 = cljs.core.next(seq16108__$2);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16109,G__16110,G__16111,seq16108__$3);
}));

(cljs.core.some_fn.cljs$lang$maxFixedArity = (3));

/**
 * Returns a lazy sequence consisting of the result of applying f to
 *   the set of first items of each coll, followed by applying f to the
 *   set of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments. Returns a transducer when
 *   no collection is provided.
 */
cljs.core.map = (function cljs$core$map(var_args){
var G__16155 = arguments.length;
switch (G__16155) {
case 1:
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.map.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___16181 = arguments.length;
var i__10847__auto___16182 = (0);
while(true){
if((i__10847__auto___16182 < len__10846__auto___16181)){
args_arr__10875__auto__.push((arguments[i__10847__auto___16182]));

var G__16183 = (i__10847__auto___16182 + (1));
i__10847__auto___16182 = G__16183;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((4) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((4)),(0),null)):null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10876__auto__);

}
});

(cljs.core.map.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16156(f){
return (function cljs$core$fn_16156_$_fn_16157(rf){
return (function() {
var cljs$core$fn_16156_$_fn_16157_$_fn_16158 = null;
var cljs$core$fn_16156_$_fn_16157_$_fn_16158__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16156_$_fn_16157_$_fn_16158__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16156_$_fn_16157_$_fn_16158__2 = (function (result,input){
var G__16159 = result;
var G__16160 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__16159,G__16160) : rf.call(null,G__16159,G__16160));
});
var cljs$core$fn_16156_$_fn_16157_$_fn_16158__3 = (function() { 
var G__16184__delegate = function (result,input,inputs){
var G__16161 = result;
var G__16162 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,input,inputs);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__16161,G__16162) : rf.call(null,G__16161,G__16162));
};
var G__16184 = function (result,input,var_args){
var inputs = null;
if (arguments.length > 2) {
var G__16185__i = 0, G__16185__a = new Array(arguments.length -  2);
while (G__16185__i < G__16185__a.length) {G__16185__a[G__16185__i] = arguments[G__16185__i + 2]; ++G__16185__i;}
  inputs = new cljs.core.IndexedSeq(G__16185__a,0,null);
} 
return G__16184__delegate.call(this,result,input,inputs);};
G__16184.cljs$lang$maxFixedArity = 2;
G__16184.cljs$lang$applyTo = (function (arglist__16186){
var result = cljs.core.first(arglist__16186);
arglist__16186 = cljs.core.next(arglist__16186);
var input = cljs.core.first(arglist__16186);
var inputs = cljs.core.rest(arglist__16186);
return G__16184__delegate(result,input,inputs);
});
G__16184.cljs$core$IFn$_invoke$arity$variadic = G__16184__delegate;
return G__16184;
})()
;
cljs$core$fn_16156_$_fn_16157_$_fn_16158 = function(result,input,var_args){
var inputs = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16156_$_fn_16157_$_fn_16158__0.call(this);
case 1:
return cljs$core$fn_16156_$_fn_16157_$_fn_16158__1.call(this,result);
case 2:
return cljs$core$fn_16156_$_fn_16157_$_fn_16158__2.call(this,result,input);
default:
var G__16187 = null;
if (arguments.length > 2) {
var G__16188__i = 0, G__16188__a = new Array(arguments.length -  2);
while (G__16188__i < G__16188__a.length) {G__16188__a[G__16188__i] = arguments[G__16188__i + 2]; ++G__16188__i;}
G__16187 = new cljs.core.IndexedSeq(G__16188__a,0,null);
}
return cljs$core$fn_16156_$_fn_16157_$_fn_16158__3.cljs$core$IFn$_invoke$arity$variadic(result,input, G__16187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16156_$_fn_16157_$_fn_16158.cljs$lang$maxFixedArity = 2;
cljs$core$fn_16156_$_fn_16157_$_fn_16158.cljs$lang$applyTo = cljs$core$fn_16156_$_fn_16157_$_fn_16158__3.cljs$lang$applyTo;
cljs$core$fn_16156_$_fn_16157_$_fn_16158.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16156_$_fn_16157_$_fn_16158__0;
cljs$core$fn_16156_$_fn_16157_$_fn_16158.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16156_$_fn_16157_$_fn_16158__1;
cljs$core$fn_16156_$_fn_16157_$_fn_16158.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16156_$_fn_16157_$_fn_16158__2;
cljs$core$fn_16156_$_fn_16157_$_fn_16158.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16156_$_fn_16157_$_fn_16158__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16156_$_fn_16157_$_fn_16158;
})()
});
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16163(f,coll){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16163_$_fn_16164(){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__10605__auto___16189 = size;
var i_16190 = (0);
while(true){
if((i_16190 < n__10605__auto___16189)){
cljs.core.chunk_append(b,(function (){var G__16165 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_16190);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16165) : f.call(null,G__16165));
})());

var G__16191 = (i_16190 + (1));
i_16190 = G__16191;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__16166 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16166) : f.call(null,G__16166));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16167(f,c1,c2){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16167_$_fn_16168(){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if(((s1) && (s2))){
return cljs.core.cons((function (){var G__16169 = cljs.core.first(s1);
var G__16170 = cljs.core.first(s2);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16169,G__16170) : f.call(null,G__16169,G__16170));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,cljs.core.rest(s1),cljs.core.rest(s2)));
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16171(f,c1,c2,c3){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16171_$_fn_16172(){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
var s3 = cljs.core.seq(c3);
if(((s1) && (((s2) && (s3))))){
return cljs.core.cons((function (){var G__16173 = cljs.core.first(s1);
var G__16174 = cljs.core.first(s2);
var G__16175 = cljs.core.first(s3);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16173,G__16174,G__16175) : f.call(null,G__16173,G__16174,G__16175));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,cljs.core.rest(s1),cljs.core.rest(s2),cljs.core.rest(s3)));
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16176(f,c1,c2,c3,colls){
var step = (function cljs$core$fn_16176_$_step(cs){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16176_$_step_$_fn_16177(){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cs);
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs$core$fn_16176_$_step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function cljs$core$fn_16176_$_fn_16178(p1__16148_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,p1__16148_SHARP_);
}),step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c3,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c2,c1], 0))));
}));

/** @this {Function} */
(cljs.core.map.cljs$lang$applyTo = (function cljs$core$fn_16179(seq16150){
var G__16151 = cljs.core.first(seq16150);
var seq16150__$1 = cljs.core.next(seq16150);
var G__16152 = cljs.core.first(seq16150__$1);
var seq16150__$2 = cljs.core.next(seq16150__$1);
var G__16153 = cljs.core.first(seq16150__$2);
var seq16150__$3 = cljs.core.next(seq16150__$2);
var G__16154 = cljs.core.first(seq16150__$3);
var seq16150__$4 = cljs.core.next(seq16150__$3);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16151,G__16152,G__16153,G__16154,seq16150__$4);
}));

(cljs.core.map.cljs$lang$maxFixedArity = (4));

/**
 * Returns a lazy sequence of the first n items in coll, or all items if
 *   there are fewer than n.  Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.take = (function cljs$core$take(var_args){
var G__16193 = arguments.length;
switch (G__16193) {
case 1:
return cljs.core.take.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.take.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16194(n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function cljs$core$fn_16194_$_fn_16195(rf){
var na = cljs.core.volatile_BANG_(n);
return (function() {
var cljs$core$fn_16194_$_fn_16195_$_fn_16196 = null;
var cljs$core$fn_16194_$_fn_16195_$_fn_16196__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16194_$_fn_16195_$_fn_16196__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16194_$_fn_16195_$_fn_16196__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
var nn = na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));
var result__$1 = (((n__$1 > (0)))?(rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input)):result);
if((!((nn > (0))))){
return cljs.core.ensure_reduced(result__$1);
} else {
return result__$1;
}
});
cljs$core$fn_16194_$_fn_16195_$_fn_16196 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16194_$_fn_16195_$_fn_16196__0.call(this);
case 1:
return cljs$core$fn_16194_$_fn_16195_$_fn_16196__1.call(this,result);
case 2:
return cljs$core$fn_16194_$_fn_16195_$_fn_16196__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16194_$_fn_16195_$_fn_16196.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16194_$_fn_16195_$_fn_16196__0;
cljs$core$fn_16194_$_fn_16195_$_fn_16196.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16194_$_fn_16195_$_fn_16196__1;
cljs$core$fn_16194_$_fn_16195_$_fn_16196.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16194_$_fn_16195_$_fn_16196__2;
return cljs$core$fn_16194_$_fn_16195_$_fn_16196;
})()
});
}));

(cljs.core.take.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16197(n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (new cljs.core.LazySeq(null,(function cljs$core$fn_16197_$_fn_16198(){
if((n > (0))){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
return cljs.core.cons(cljs.core.first(s),cljs.core.take.cljs$core$IFn$_invoke$arity$2((n - (1)),cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.take.cljs$lang$maxFixedArity = 2);

/**
 * Returns a laziness-preserving sequence of all but the first n items in coll.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.drop = (function cljs$core$drop(var_args){
var G__16201 = arguments.length;
switch (G__16201) {
case 1:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16202(n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function cljs$core$fn_16202_$_fn_16203(rf){
var na = cljs.core.volatile_BANG_(n);
return (function() {
var cljs$core$fn_16202_$_fn_16203_$_fn_16204 = null;
var cljs$core$fn_16202_$_fn_16203_$_fn_16204__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16202_$_fn_16203_$_fn_16204__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16202_$_fn_16203_$_fn_16204__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));

if((n__$1 > (0))){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
cljs$core$fn_16202_$_fn_16203_$_fn_16204 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16202_$_fn_16203_$_fn_16204__0.call(this);
case 1:
return cljs$core$fn_16202_$_fn_16203_$_fn_16204__1.call(this,result);
case 2:
return cljs$core$fn_16202_$_fn_16203_$_fn_16204__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16202_$_fn_16203_$_fn_16204.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16202_$_fn_16203_$_fn_16204__0;
cljs$core$fn_16202_$_fn_16203_$_fn_16204.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16202_$_fn_16203_$_fn_16204__1;
cljs$core$fn_16202_$_fn_16203_$_fn_16204.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16202_$_fn_16203_$_fn_16204__2;
return cljs$core$fn_16202_$_fn_16203_$_fn_16204;
})()
});
}));

(cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16205(n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition1$ & (262144))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IDrop$))))?true:false):false)){
var or__9517__auto__ = (((n > (0)))?coll.cljs$core$IDrop$_drop$arity$2(null,Math.ceil(n)):cljs.core.seq(coll));
if(cljs.core.truth_(or__9517__auto__)){
return or__9517__auto__;
} else {
return cljs.core.List.EMPTY;
}
} else {
var step = (function cljs$core$fn_16205_$_fn_16207(n__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if((((n__$1 > (0))) && (s))){
var G__16210 = (n__$1 - (1));
var G__16211 = cljs.core.rest(s);
n__$1 = G__16210;
coll__$1 = G__16211;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16205_$_fn_16208(){
return step(n,coll);
}),null,null));
}
}));

(cljs.core.drop.cljs$lang$maxFixedArity = 2);

/**
 * Return a lazy sequence of all but the last n (default 1) items in coll
 */
cljs.core.drop_last = (function cljs$core$drop_last(var_args){
var G__16213 = arguments.length;
switch (G__16213) {
case 1:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16214(s){
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((1),s);
}));

(cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16215(n,s){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((function cljs$core$fn_16215_$_fn_16216(x,_){
return x;
}),s,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s));
}));

(cljs.core.drop_last.cljs$lang$maxFixedArity = 2);

/**
 * Returns a seq of the last n items in coll.  Depending on the type
 *   of coll may be no better than linear time.  For vectors, see also subvec.
 */
cljs.core.take_last = (function cljs$core$take_last(n,coll){
var s = cljs.core.seq(coll);
var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll));
while(true){
if(lead){
var G__16218 = cljs.core.next(s);
var G__16219 = cljs.core.next(lead);
s = G__16218;
lead = G__16219;
continue;
} else {
return s;
}
break;
}
});
/**
 * Returns a lazy sequence of the items in coll starting from the
 *   first item for which (pred item) returns logical false.  Returns a
 *   stateful transducer when no collection is provided.
 */
cljs.core.drop_while = (function cljs$core$drop_while(var_args){
var G__16221 = arguments.length;
switch (G__16221) {
case 1:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16222(pred){
return (function cljs$core$fn_16222_$_fn_16223(rf){
var da = cljs.core.volatile_BANG_(true);
return (function() {
var cljs$core$fn_16222_$_fn_16223_$_fn_16224 = null;
var cljs$core$fn_16222_$_fn_16223_$_fn_16224__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16222_$_fn_16223_$_fn_16224__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16222_$_fn_16223_$_fn_16224__2 = (function (result,input){
var drop_QMARK_ = cljs.core.deref(da);
if(cljs.core.truth_((function (){var and__9511__auto__ = drop_QMARK_;
if(cljs.core.truth_(and__9511__auto__)){
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input));
} else {
return and__9511__auto__;
}
})())){
return result;
} else {
cljs.core.vreset_BANG_(da,null);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
cljs$core$fn_16222_$_fn_16223_$_fn_16224 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16222_$_fn_16223_$_fn_16224__0.call(this);
case 1:
return cljs$core$fn_16222_$_fn_16223_$_fn_16224__1.call(this,result);
case 2:
return cljs$core$fn_16222_$_fn_16223_$_fn_16224__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16222_$_fn_16223_$_fn_16224.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16222_$_fn_16223_$_fn_16224__0;
cljs$core$fn_16222_$_fn_16223_$_fn_16224.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16222_$_fn_16223_$_fn_16224__1;
cljs$core$fn_16222_$_fn_16223_$_fn_16224.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16222_$_fn_16223_$_fn_16224__2;
return cljs$core$fn_16222_$_fn_16223_$_fn_16224;
})()
});
}));

(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16225(pred,coll){
var step = (function cljs$core$fn_16225_$_fn_16226(pred__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(cljs.core.truth_((function (){var and__9511__auto__ = s;
if(and__9511__auto__){
var G__16227 = cljs.core.first(s);
return (pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__16227) : pred__$1.call(null,G__16227));
} else {
return and__9511__auto__;
}
})())){
var G__16230 = pred__$1;
var G__16231 = cljs.core.rest(s);
pred__$1 = G__16230;
coll__$1 = G__16231;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16225_$_fn_16228(){
return step(pred,coll);
}),null,null));
}));

(cljs.core.drop_while.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Cycle = (function (meta,all,prev,current,_next){
this.meta = meta;
this.all = all;
this.prev = prev;
this.current = current;
this._next = _next;
this.cljs$lang$protocol_mask$partition0$ = 26083532;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.Cycle.prototype.toString = (function cljs$core$fn_16232(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Cycle.prototype.currentval = (function cljs$core$fn_16233(){
var self__ = this;
var coll = this;
if(self__.current){
} else {
var temp__5718__auto___16253 = cljs.core.next(self__.prev);
if(temp__5718__auto___16253){
var c_16254 = temp__5718__auto___16253;
(self__.current = c_16254);
} else {
(self__.current = self__.all);
}
}

return self__.current;
}));

(cljs.core.Cycle.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16234(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Cycle.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16235(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
}));

(cljs.core.Cycle.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16236(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Cycle.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function cljs$core$fn_16237(coll){
var self__ = this;
var coll__$1 = this;
return (!((self__.current == null)));
}));

(cljs.core.Cycle.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16238(coll,f){
var self__ = this;
var coll__$1 = this;
var s = coll__$1.currentval();
var ret = cljs.core.first(s);
while(true){
var s__$1 = (function (){var or__9517__auto__ = cljs.core.next(s);
if(or__9517__auto__){
return or__9517__auto__;
} else {
return self__.all;
}
})();
var ret__$1 = (function (){var G__16241 = ret;
var G__16242 = cljs.core.first(s__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16241,G__16242) : f.call(null,G__16241,G__16242));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__16255 = s__$1;
var G__16256 = ret__$1;
s = G__16255;
ret = G__16256;
continue;
}
break;
}
}));

(cljs.core.Cycle.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16243(coll,f,start){
var self__ = this;
var coll__$1 = this;
var s = coll__$1.currentval();
var ret = start;
while(true){
var ret__$1 = (function (){var G__16244 = ret;
var G__16245 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16244,G__16245) : f.call(null,G__16244,G__16245));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__16257 = (function (){var or__9517__auto__ = cljs.core.next(s);
if(or__9517__auto__){
return or__9517__auto__;
} else {
return self__.all;
}
})();
var G__16258 = ret__$1;
s = G__16257;
ret = G__16258;
continue;
}
break;
}
}));

(cljs.core.Cycle.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16246(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(coll__$1.currentval());
}));

(cljs.core.Cycle.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16247(coll){
var self__ = this;
var coll__$1 = this;
if((self__._next == null)){
(self__._next = (new cljs.core.Cycle(null,self__.all,coll__$1.currentval(),null,null)));
} else {
}

return self__._next;
}));

(cljs.core.Cycle.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16248(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Cycle.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16249(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Cycle(new_meta,self__.all,self__.prev,self__.current,self__._next));
}
}));

(cljs.core.Cycle.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16250(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.Cycle.getBasis = (function cljs$core$fn_16251(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"all","all",-1762306027,null),new cljs.core.Symbol(null,"prev","prev",43462301,null),cljs.core.with_meta(new cljs.core.Symbol(null,"current","current",552492924,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Cycle.cljs$lang$type = true);

(cljs.core.Cycle.cljs$lang$ctorStr = "cljs.core/Cycle");

(cljs.core.Cycle.cljs$lang$ctorPrWriter = (function cljs$core$fn_16252(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/Cycle");
}));

/**
 * Positional factory function for cljs.core/Cycle.
 */
cljs.core.__GT_Cycle = (function cljs$core$__GT_Cycle(meta,all,prev,current,_next){
return (new cljs.core.Cycle(meta,all,prev,current,_next));
});

/**
 * Returns a lazy (infinite!) sequence of repetitions of the items in coll.
 */
cljs.core.cycle = (function cljs$core$cycle(coll){
var temp__5718__auto__ = cljs.core.seq(coll);
if(temp__5718__auto__){
var vals = temp__5718__auto__;
return (new cljs.core.Cycle(null,vals,null,vals,null));
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a vector of [(take n coll) (drop n coll)]
 */
cljs.core.split_at = (function cljs$core$split_at(n,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll),cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll)], null);
});

/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Repeat = (function (meta,count,val,next,__hash){
this.meta = meta;
this.count = count;
this.val = val;
this.next = next;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 262145;
});
(cljs.core.Repeat.prototype.toString = (function cljs$core$fn_16259(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Repeat.prototype.equiv = (function cljs$core$fn_16260(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Repeat.prototype.indexOf = (function() {
var cljs$core$fn_16261 = null;
var cljs$core$fn_16261__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16261__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16261 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16261__1.call(this,x);
case 2:
return cljs$core$fn_16261__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16261.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16261__1;
cljs$core$fn_16261.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16261__2;
return cljs$core$fn_16261;
})()
);

(cljs.core.Repeat.prototype.lastIndexOf = (function() {
var cljs$core$fn_16262 = null;
var cljs$core$fn_16262__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,self__.count);
});
var cljs$core$fn_16262__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16262 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16262__1.call(this,x);
case 2:
return cljs$core$fn_16262__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16262.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16262__1;
cljs$core$fn_16262.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16262__2;
return cljs$core$fn_16262;
})()
);

(cljs.core.Repeat.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16263(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Repeat.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16264(coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
if((self__.count > (1))){
(self__.next = (new cljs.core.Repeat(null,(self__.count - (1)),self__.val,null,null)));

return self__.next;
} else {
if(((-1) === self__.count)){
return coll__$1;
} else {
return null;
}
}
} else {
return self__.next;
}
}));

(cljs.core.Repeat.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16265(coll){
var self__ = this;
var coll__$1 = this;
var h__9978__auto__ = self__.__hash;
if((!((h__9978__auto__ == null)))){
return h__9978__auto__;
} else {
var h__9978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9978__auto____$1);

return h__9978__auto____$1;
}
}));

(cljs.core.Repeat.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16266(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.Repeat.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16267(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Repeat.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function cljs$core$fn_16268(coll){
var self__ = this;
var coll__$1 = this;
return false;
}));

(cljs.core.Repeat.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16269(coll,f){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
var ret = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(self__.val,self__.val) : f.call(null,self__.val,self__.val));
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var G__16279 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
ret = G__16279;
continue;
}
break;
}
} else {
var i = (1);
var ret = self__.val;
while(true){
if((i < self__.count)){
var ret__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__16280 = (i + (1));
var G__16281 = ret__$1;
i = G__16280;
ret = G__16281;
continue;
}
} else {
return ret;
}
break;
}
}
}));

(cljs.core.Repeat.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16270(coll,f,start){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
var ret = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(start,self__.val) : f.call(null,start,self__.val));
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var G__16282 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
ret = G__16282;
continue;
}
break;
}
} else {
var i = (0);
var ret = start;
while(true){
if((i < self__.count)){
var ret__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__16283 = (i + (1));
var G__16284 = ret__$1;
i = G__16283;
ret = G__16284;
continue;
}
} else {
return ret;
}
break;
}
}
}));

(cljs.core.Repeat.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16271(coll){
var self__ = this;
var coll__$1 = this;
return self__.val;
}));

(cljs.core.Repeat.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16272(coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
if((self__.count > (1))){
(self__.next = (new cljs.core.Repeat(null,(self__.count - (1)),self__.val,null,null)));

return self__.next;
} else {
if(((-1) === self__.count)){
return coll__$1;
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return self__.next;
}
}));

(cljs.core.Repeat.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16273(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Repeat.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16274(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Repeat(new_meta,self__.count,self__.val,self__.next,null));
}
}));

(cljs.core.Repeat.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16275(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.Repeat.prototype.cljs$core$IDrop$_drop$arity$2 = (function cljs$core$fn_16276(coll,n){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
return coll__$1;
} else {
var dropped_count = (self__.count - n);
if((dropped_count > (0))){
return (new cljs.core.Repeat(null,dropped_count,self__.val,null,null));
} else {
return null;
}
}
}));

(cljs.core.Repeat.getBasis = (function cljs$core$fn_16277(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.with_meta(new cljs.core.Symbol(null,"next","next",1522830042,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Repeat.cljs$lang$type = true);

(cljs.core.Repeat.cljs$lang$ctorStr = "cljs.core/Repeat");

(cljs.core.Repeat.cljs$lang$ctorPrWriter = (function cljs$core$fn_16278(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/Repeat");
}));

/**
 * Positional factory function for cljs.core/Repeat.
 */
cljs.core.__GT_Repeat = (function cljs$core$__GT_Repeat(meta,count,val,next,__hash){
return (new cljs.core.Repeat(meta,count,val,next,__hash));
});

/**
 * Returns a lazy (infinite!, or length n if supplied) sequence of xs.
 */
cljs.core.repeat = (function cljs$core$repeat(var_args){
var G__16286 = arguments.length;
switch (G__16286) {
case 1:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16287(x){
return (new cljs.core.Repeat(null,(-1),x,null,null));
}));

(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16288(n,x){
if((n > (0))){
return (new cljs.core.Repeat(null,n,x,null,null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.repeat.cljs$lang$maxFixedArity = 2);

/**
 * DEPRECATED: Use 'repeat' instead.
 *   Returns a lazy seq of n xs.
 */
cljs.core.replicate = (function cljs$core$replicate(n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});
/**
 * Takes a function of no args, presumably with side effects, and
 *   returns an infinite (or length n if supplied) lazy sequence of calls
 *   to it
 */
cljs.core.repeatedly = (function cljs$core$repeatedly(var_args){
var G__16291 = arguments.length;
switch (G__16291) {
case 1:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16292(f){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16292_$_fn_16293(){
return cljs.core.cons((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}),null,null));
}));

(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16294(n,f){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}));

(cljs.core.repeatedly.cljs$lang$maxFixedArity = 2);

cljs.core.UNREALIZED_SEED = ({});

/**
* @constructor
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Iterate = (function (meta,f,prev_seed,seed,next){
this.meta = meta;
this.f = f;
this.prev_seed = prev_seed;
this.seed = seed;
this.next = next;
this.cljs$lang$protocol_mask$partition0$ = 26083532;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.Iterate.prototype.toString = (function cljs$core$fn_16296(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Iterate.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16297(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Iterate.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16298(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
}));

(cljs.core.Iterate.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16299(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Iterate.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function cljs$core$fn_16300(coll){
var self__ = this;
var coll__$1 = this;
return (!((self__.seed === cljs.core.UNREALIZED_SEED)));
}));

(cljs.core.Iterate.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16301(coll,rf){
var self__ = this;
var coll__$1 = this;
var first = coll__$1.cljs$core$ISeq$_first$arity$1(null);
var v = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(first) : self__.f.call(null,first));
var ret = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(first,v) : rf.call(null,first,v));
var v__$1 = v;
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var v__$2 = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(v__$1) : self__.f.call(null,v__$1));
var G__16310 = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(ret,v__$2) : rf.call(null,ret,v__$2));
var G__16311 = v__$2;
ret = G__16310;
v__$1 = G__16311;
continue;
}
break;
}
}));

(cljs.core.Iterate.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16302(coll,rf,start){
var self__ = this;
var coll__$1 = this;
var v = coll__$1.cljs$core$ISeq$_first$arity$1(null);
var ret = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(start,v) : rf.call(null,start,v));
var v__$1 = v;
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var v__$2 = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(v__$1) : self__.f.call(null,v__$1));
var G__16312 = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(ret,v__$2) : rf.call(null,ret,v__$2));
var G__16313 = v__$2;
ret = G__16312;
v__$1 = G__16313;
continue;
}
break;
}
}));

(cljs.core.Iterate.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16303(coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.UNREALIZED_SEED === self__.seed)){
(self__.seed = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(self__.prev_seed) : self__.f.call(null,self__.prev_seed)));
} else {
}

return self__.seed;
}));

(cljs.core.Iterate.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16304(coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
(self__.next = (new cljs.core.Iterate(null,self__.f,coll__$1.cljs$core$ISeq$_first$arity$1(null),cljs.core.UNREALIZED_SEED,null)));
} else {
}

return self__.next;
}));

(cljs.core.Iterate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16305(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Iterate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16306(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Iterate(new_meta,self__.f,self__.prev_seed,self__.seed,self__.next));
}
}));

(cljs.core.Iterate.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16307(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.Iterate.getBasis = (function cljs$core$fn_16308(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"prev-seed","prev-seed",2126381367,null),cljs.core.with_meta(new cljs.core.Symbol(null,"seed","seed",1709144854,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next","next",1522830042,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Iterate.cljs$lang$type = true);

(cljs.core.Iterate.cljs$lang$ctorStr = "cljs.core/Iterate");

(cljs.core.Iterate.cljs$lang$ctorPrWriter = (function cljs$core$fn_16309(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/Iterate");
}));

/**
 * Positional factory function for cljs.core/Iterate.
 */
cljs.core.__GT_Iterate = (function cljs$core$__GT_Iterate(meta,f,prev_seed,seed,next){
return (new cljs.core.Iterate(meta,f,prev_seed,seed,next));
});

/**
 * Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects
 */
cljs.core.iterate = (function cljs$core$iterate(f,x){
return (new cljs.core.Iterate(null,f,null,x,null));
});
/**
 * Returns a lazy seq of the first item in each coll, then the second etc.
 */
cljs.core.interleave = (function cljs$core$interleave(var_args){
var G__16318 = arguments.length;
switch (G__16318) {
case 0:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___16328 = arguments.length;
var i__10847__auto___16329 = (0);
while(true){
if((i__10847__auto___16329 < len__10846__auto___16328)){
args_arr__10875__auto__.push((arguments[i__10847__auto___16329]));

var G__16330 = (i__10847__auto___16329 + (1));
i__10847__auto___16329 = G__16330;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((2) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((2)),(0),null)):null);
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10876__auto__);

}
});

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_16319(){
return cljs.core.List.EMPTY;
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16320(c1){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16320_$_fn_16321(){
return c1;
}),null,null));
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16322(c1,c2){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16322_$_fn_16323(){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if(((s1) && (s2))){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
return null;
}
}),null,null));
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16324(c1,c2,colls){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16324_$_fn_16325(){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c1], 0)));
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
}));

/** @this {Function} */
(cljs.core.interleave.cljs$lang$applyTo = (function cljs$core$fn_16326(seq16315){
var G__16316 = cljs.core.first(seq16315);
var seq16315__$1 = cljs.core.next(seq16315);
var G__16317 = cljs.core.first(seq16315__$1);
var seq16315__$2 = cljs.core.next(seq16315__$1);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16316,G__16317,seq16315__$2);
}));

(cljs.core.interleave.cljs$lang$maxFixedArity = (2));

/**
 * Returns a lazy seq of the elements of coll separated by sep.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.interpose = (function cljs$core$interpose(var_args){
var G__16332 = arguments.length;
switch (G__16332) {
case 1:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16333(sep){
return (function cljs$core$fn_16333_$_fn_16334(rf){
var started = cljs.core.volatile_BANG_(false);
return (function() {
var cljs$core$fn_16333_$_fn_16334_$_fn_16335 = null;
var cljs$core$fn_16333_$_fn_16334_$_fn_16335__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16333_$_fn_16334_$_fn_16335__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16333_$_fn_16334_$_fn_16335__2 = (function (result,input){
if(cljs.core.truth_(cljs.core.deref(started))){
var sepr = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,sep) : rf.call(null,result,sep));
if(cljs.core.reduced_QMARK_(sepr)){
return sepr;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(sepr,input) : rf.call(null,sepr,input));
}
} else {
cljs.core.vreset_BANG_(started,true);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
cljs$core$fn_16333_$_fn_16334_$_fn_16335 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16333_$_fn_16334_$_fn_16335__0.call(this);
case 1:
return cljs$core$fn_16333_$_fn_16334_$_fn_16335__1.call(this,result);
case 2:
return cljs$core$fn_16333_$_fn_16334_$_fn_16335__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16333_$_fn_16334_$_fn_16335.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16333_$_fn_16334_$_fn_16335__0;
cljs$core$fn_16333_$_fn_16334_$_fn_16335.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16333_$_fn_16334_$_fn_16335__1;
cljs$core$fn_16333_$_fn_16334_$_fn_16335.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16333_$_fn_16334_$_fn_16335__2;
return cljs$core$fn_16333_$_fn_16334_$_fn_16335;
})()
});
}));

(cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16336(sep,coll){
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep),coll));
}));

(cljs.core.interpose.cljs$lang$maxFixedArity = 2);

/**
 * Take a collection of collections, and return a lazy seq
 *   of items from the inner collection
 */
cljs.core.flatten1 = (function cljs$core$flatten1(colls){
var cat = (function cljs$core$flatten1_$_cat(coll,colls__$1){
return (new cljs.core.LazySeq(null,(function cljs$core$flatten1_$_cat_$_fn_16338(){
var temp__5718__auto__ = cljs.core.seq(coll);
if(temp__5718__auto__){
var coll__$1 = temp__5718__auto__;
return cljs.core.cons(cljs.core.first(coll__$1),cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1),colls__$1));
} else {
if(cljs.core.seq(colls__$1)){
return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1),cljs.core.rest(colls__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(null,colls);
});
/**
 * Returns the result of applying concat to the result of applying map
 *   to f and colls.  Thus function f should return a collection. Returns
 *   a transducer when no collections are provided
 */
cljs.core.mapcat = (function cljs$core$mapcat(var_args){
var G__16342 = arguments.length;
switch (G__16342) {
case 1:
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___16347 = arguments.length;
var i__10847__auto___16348 = (0);
while(true){
if((i__10847__auto___16348 < len__10846__auto___16347)){
args_arr__10875__auto__.push((arguments[i__10847__auto___16348]));

var G__16349 = (i__10847__auto___16348 + (1));
i__10847__auto___16348 = G__16349;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((1) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((1)),(0),null)):null);
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10876__auto__);

}
});

(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16343(f){
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f),cljs.core.cat);
}));

(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16344(f,colls){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map,f,colls));
}));

/** @this {Function} */
(cljs.core.mapcat.cljs$lang$applyTo = (function cljs$core$fn_16345(seq16340){
var G__16341 = cljs.core.first(seq16340);
var seq16340__$1 = cljs.core.next(seq16340);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16341,seq16340__$1);
}));

(cljs.core.mapcat.cljs$lang$maxFixedArity = (1));

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns logical true. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.filter = (function cljs$core$filter(var_args){
var G__16351 = arguments.length;
switch (G__16351) {
case 1:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16352(pred){
return (function cljs$core$fn_16352_$_fn_16353(rf){
return (function() {
var cljs$core$fn_16352_$_fn_16353_$_fn_16354 = null;
var cljs$core$fn_16352_$_fn_16353_$_fn_16354__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16352_$_fn_16353_$_fn_16354__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16352_$_fn_16353_$_fn_16354__2 = (function (result,input){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input)))){
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
} else {
return result;
}
});
cljs$core$fn_16352_$_fn_16353_$_fn_16354 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16352_$_fn_16353_$_fn_16354__0.call(this);
case 1:
return cljs$core$fn_16352_$_fn_16353_$_fn_16354__1.call(this,result);
case 2:
return cljs$core$fn_16352_$_fn_16353_$_fn_16354__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16352_$_fn_16353_$_fn_16354.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16352_$_fn_16353_$_fn_16354__0;
cljs$core$fn_16352_$_fn_16353_$_fn_16354.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16352_$_fn_16353_$_fn_16354__1;
cljs$core$fn_16352_$_fn_16353_$_fn_16354.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16352_$_fn_16353_$_fn_16354__2;
return cljs$core$fn_16352_$_fn_16353_$_fn_16354;
})()
});
}));

(cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16355(pred,coll){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16355_$_fn_16356(){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__10605__auto___16359 = size;
var i_16360 = (0);
while(true){
if((i_16360 < n__10605__auto___16359)){
if(cljs.core.truth_((function (){var G__16357 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_16360);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__16357) : pred.call(null,G__16357));
})())){
cljs.core.chunk_append(b,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_16360));
} else {
}

var G__16361 = (i_16360 + (1));
i_16360 = G__16361;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.chunk_rest(s)));
} else {
var f = cljs.core.first(s);
var r = cljs.core.rest(s);
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(f) : pred.call(null,f)))){
return cljs.core.cons(f,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r));
} else {
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r);
}
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.filter.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns logical false. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.remove = (function cljs$core$remove(var_args){
var G__16363 = arguments.length;
switch (G__16363) {
case 1:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16364(pred){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
}));

(cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16365(pred,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred),coll);
}));

(cljs.core.remove.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the nodes in a tree, via a depth-first walk.
 *   branch? must be a fn of one arg that returns true if passed a node
 *   that can have children (but may not).  children must be a fn of one
 *   arg that returns a sequence of the children. Will only be called on
 *   nodes for which branch? returns true. Root is the root node of the
 *   tree.
 */
cljs.core.tree_seq = (function cljs$core$tree_seq(branch_QMARK_,children,root){
var walk = (function cljs$core$tree_seq_$_walk(node){
return (new cljs.core.LazySeq(null,(function cljs$core$tree_seq_$_walk_$_fn_16367(){
return cljs.core.cons(node,(cljs.core.truth_((branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(node) : branch_QMARK_.call(null,node)))?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(node) : children.call(null,node))], 0)):null));
}),null,null));
});
return walk(root);
});
/**
 * Takes any nested combination of sequential things (lists, vectors,
 *   etc.) and returns their contents as a single, flat sequence.
 *   (flatten nil) returns nil.
 */
cljs.core.flatten = (function cljs$core$flatten(x){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function cljs$core$flatten_$_fn_16369(p1__16368_SHARP_){
return (!(cljs.core.sequential_QMARK_(p1__16368_SHARP_)));
}),cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_,cljs.core.seq,x)));
});
/**
 * Returns a new coll consisting of to-coll with all of the items of
 *   from-coll conjoined. A transducer may be supplied.
 */
cljs.core.into = (function cljs$core$into(var_args){
var G__16371 = arguments.length;
switch (G__16371) {
case 0:
return cljs.core.into.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.into.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.into.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.into.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_16372(){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16373(to){
return to;
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16374(to,from){
if((!((to == null)))){
if((((!((to == null))))?(((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$))))?true:false):false)){
return cljs.core._with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,to,from);
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,to,from);
}
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16376(to,xform,from){
if((((!((to == null))))?(((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$))))?true:false):false)){
var tm = cljs.core.meta(to);
var rf = (function() {
var cljs$core$fn_16376_$_fn_16378 = null;
var cljs$core$fn_16376_$_fn_16378__1 = (function (coll){
return cljs.core._with_meta(cljs.core.persistent_BANG_(coll),tm);
});
var cljs$core$fn_16376_$_fn_16378__2 = (function (coll,v){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(coll,v);
});
cljs$core$fn_16376_$_fn_16378 = function(coll,v){
switch(arguments.length){
case 1:
return cljs$core$fn_16376_$_fn_16378__1.call(this,coll);
case 2:
return cljs$core$fn_16376_$_fn_16378__2.call(this,coll,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16376_$_fn_16378.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16376_$_fn_16378__1;
cljs$core$fn_16376_$_fn_16378.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16376_$_fn_16378__2;
return cljs$core$fn_16376_$_fn_16378;
})()
;
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,rf,cljs.core.transient$(to),from);
} else {
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj,to,from);
}
}));

(cljs.core.into.cljs$lang$maxFixedArity = 3);

/**
 * Returns a vector consisting of the result of applying f to the
 *   set of first items of each coll, followed by applying f to the set
 *   of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments.
 */
cljs.core.mapv = (function cljs$core$mapv(var_args){
var G__16386 = arguments.length;
switch (G__16386) {
case 2:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___16394 = arguments.length;
var i__10847__auto___16395 = (0);
while(true){
if((i__10847__auto___16395 < len__10846__auto___16394)){
args_arr__10875__auto__.push((arguments[i__10847__auto___16395]));

var G__16396 = (i__10847__auto___16395 + (1));
i__10847__auto___16395 = G__16396;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((4) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((4)),(0),null)):null);
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10876__auto__);

}
});

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16387(f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function cljs$core$fn_16387_$_fn_16388(v,o){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(o) : f.call(null,o)));
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16389(f,c1,c2){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,c1,c2));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16390(f,c1,c2,c3){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,c1,c2,c3));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16391(f,c1,c2,c3,colls){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,f,c1,c2,c3,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([colls], 0)));
}));

/** @this {Function} */
(cljs.core.mapv.cljs$lang$applyTo = (function cljs$core$fn_16392(seq16381){
var G__16382 = cljs.core.first(seq16381);
var seq16381__$1 = cljs.core.next(seq16381);
var G__16383 = cljs.core.first(seq16381__$1);
var seq16381__$2 = cljs.core.next(seq16381__$1);
var G__16384 = cljs.core.first(seq16381__$2);
var seq16381__$3 = cljs.core.next(seq16381__$2);
var G__16385 = cljs.core.first(seq16381__$3);
var seq16381__$4 = cljs.core.next(seq16381__$3);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16382,G__16383,G__16384,G__16385,seq16381__$4);
}));

(cljs.core.mapv.cljs$lang$maxFixedArity = (4));

/**
 * Returns a vector of the items in coll for which
 *   (pred item) returns logical true. pred must be free of side-effects.
 */
cljs.core.filterv = (function cljs$core$filterv(pred,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function cljs$core$filterv_$_fn_16397(v,o){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(o) : pred.call(null,o)))){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,o);
} else {
return v;
}
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
/**
 * Returns a lazy sequence of lists of n items each, at offsets step
 *   apart. If step is not supplied, defaults to n, i.e. the partitions
 *   do not overlap. If a pad collection is supplied, use its elements as
 *   necessary to complete last partition up to n items. In case there are
 *   not enough padding elements, return a partition with less than n items.
 */
cljs.core.partition = (function cljs$core$partition(var_args){
var G__16399 = arguments.length;
switch (G__16399) {
case 2:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16400(n,coll){
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,n,coll);
}));

(cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16401(n,step,coll){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16401_$_fn_16402(){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16403(n,step,pad,coll){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16403_$_fn_16404(){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n,step,pad,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return (new cljs.core.List(null,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p,pad)),null,(1),null));
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.partition.cljs$lang$maxFixedArity = 4);

/**
 * Returns the value in a nested associative structure,
 *   where ks is a sequence of keys. Returns nil if the key is not present,
 *   or the not-found value if supplied.
 */
cljs.core.get_in = (function cljs$core$get_in(var_args){
var G__16407 = arguments.length;
switch (G__16407) {
case 2:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16408(m,ks){
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if((ks__$1 == null)){
return m__$1;
} else {
var G__16411 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m__$1,cljs.core.first(ks__$1));
var G__16412 = cljs.core.next(ks__$1);
m__$1 = G__16411;
ks__$1 = G__16412;
continue;
}
break;
}
}));

(cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16409(m,ks,not_found){
var sentinel = cljs.core.lookup_sentinel;
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if((!((ks__$1 == null)))){
var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.first(ks__$1),sentinel);
if((sentinel === m__$2)){
return not_found;
} else {
var G__16413 = sentinel;
var G__16414 = m__$2;
var G__16415 = cljs.core.next(ks__$1);
sentinel = G__16413;
m__$1 = G__16414;
ks__$1 = G__16415;
continue;
}
} else {
return m__$1;
}
break;
}
}));

(cljs.core.get_in.cljs$lang$maxFixedArity = 3);

/**
 * Associates a value in a nested associative structure, where ks is a
 *   sequence of keys and v is the new value and returns a new nested structure.
 *   If any levels do not exist, hash-maps will be created.
 */
cljs.core.assoc_in = (function cljs$core$assoc_in(m,p__16416,v){
var vec__16417 = p__16416;
var seq__16418 = cljs.core.seq(vec__16417);
var first__16419 = cljs.core.first(seq__16418);
var seq__16418__$1 = cljs.core.next(seq__16418);
var k = first__16419;
var ks = seq__16418__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16420 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16421 = ks;
var G__16422 = v;
return (cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3 ? cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3(G__16420,G__16421,G__16422) : cljs.core.assoc_in.call(null,G__16420,G__16421,G__16422));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
/**
 * 'Updates' a value in a nested associative structure, where ks is a
 *   sequence of keys and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   nested structure.  If any levels do not exist, hash-maps will be
 *   created.
 */
cljs.core.update_in = (function cljs$core$update_in(var_args){
var G__16431 = arguments.length;
switch (G__16431) {
case 3:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___16469 = arguments.length;
var i__10847__auto___16470 = (0);
while(true){
if((i__10847__auto___16470 < len__10846__auto___16469)){
args_arr__10875__auto__.push((arguments[i__10847__auto___16470]));

var G__16471 = (i__10847__auto___16470 + (1));
i__10847__auto___16470 = G__16471;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((6) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((6)),(0),null)):null);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__10876__auto__);

}
});

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16433(m,p__16432,f){
var vec__16434 = p__16432;
var seq__16435 = cljs.core.seq(vec__16434);
var first__16436 = cljs.core.first(seq__16435);
var seq__16435__$1 = cljs.core.next(seq__16435);
var k = first__16436;
var ks = seq__16435__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16437 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16437) : f.call(null,G__16437));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16439(m,p__16438,f,a){
var vec__16440 = p__16438;
var seq__16441 = cljs.core.seq(vec__16440);
var first__16442 = cljs.core.first(seq__16441);
var seq__16441__$1 = cljs.core.next(seq__16441);
var k = first__16442;
var ks = seq__16441__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16443 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16444 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16443,G__16444) : f.call(null,G__16443,G__16444));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_16446(m,p__16445,f,a,b){
var vec__16447 = p__16445;
var seq__16448 = cljs.core.seq(vec__16447);
var first__16449 = cljs.core.first(seq__16448);
var seq__16448__$1 = cljs.core.next(seq__16448);
var k = first__16449;
var ks = seq__16448__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16450 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16451 = a;
var G__16452 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16450,G__16451,G__16452) : f.call(null,G__16450,G__16451,G__16452));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_16454(m,p__16453,f,a,b,c){
var vec__16455 = p__16453;
var seq__16456 = cljs.core.seq(vec__16455);
var first__16457 = cljs.core.first(seq__16456);
var seq__16456__$1 = cljs.core.next(seq__16456);
var k = first__16457;
var ks = seq__16456__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b,c));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16458 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16459 = a;
var G__16460 = b;
var G__16461 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__16458,G__16459,G__16460,G__16461) : f.call(null,G__16458,G__16459,G__16460,G__16461));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16463(m,p__16462,f,a,b,c,args){
var vec__16464 = p__16462;
var seq__16465 = cljs.core.seq(vec__16464);
var first__16466 = cljs.core.first(seq__16465);
var seq__16465__$1 = cljs.core.next(seq__16465);
var k = first__16466;
var ks = seq__16465__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([b,c,args], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),a,b,c,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0)));
}
}));

/** @this {Function} */
(cljs.core.update_in.cljs$lang$applyTo = (function cljs$core$fn_16467(seq16424){
var G__16425 = cljs.core.first(seq16424);
var seq16424__$1 = cljs.core.next(seq16424);
var G__16426 = cljs.core.first(seq16424__$1);
var seq16424__$2 = cljs.core.next(seq16424__$1);
var G__16427 = cljs.core.first(seq16424__$2);
var seq16424__$3 = cljs.core.next(seq16424__$2);
var G__16428 = cljs.core.first(seq16424__$3);
var seq16424__$4 = cljs.core.next(seq16424__$3);
var G__16429 = cljs.core.first(seq16424__$4);
var seq16424__$5 = cljs.core.next(seq16424__$4);
var G__16430 = cljs.core.first(seq16424__$5);
var seq16424__$6 = cljs.core.next(seq16424__$5);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16425,G__16426,G__16427,G__16428,G__16429,G__16430,seq16424__$6);
}));

(cljs.core.update_in.cljs$lang$maxFixedArity = (6));

/**
 * 'Updates' a value in an associative structure, where k is a
 *   key and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   structure.  If the key does not exist, nil is passed as the old value.
 */
cljs.core.update = (function cljs$core$update(var_args){
var G__16480 = arguments.length;
switch (G__16480) {
case 3:
return cljs.core.update.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__10875__auto__ = [];
var len__10846__auto___16498 = arguments.length;
var i__10847__auto___16499 = (0);
while(true){
if((i__10847__auto___16499 < len__10846__auto___16498)){
args_arr__10875__auto__.push((arguments[i__10847__auto___16499]));

var G__16500 = (i__10847__auto___16499 + (1));
i__10847__auto___16499 = G__16500;
continue;
} else {
}
break;
}

var argseq__10876__auto__ = ((((6) < args_arr__10875__auto__.length))?(new cljs.core.IndexedSeq(args_arr__10875__auto__.slice((6)),(0),null)):null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__10876__auto__);

}
});

(cljs.core.update.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16481(m,k,f){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16482 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16482) : f.call(null,G__16482));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16483(m,k,f,x){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16484 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16485 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16484,G__16485) : f.call(null,G__16484,G__16485));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_16486(m,k,f,x,y){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16487 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16488 = x;
var G__16489 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16487,G__16488,G__16489) : f.call(null,G__16487,G__16488,G__16489));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_16490(m,k,f,x,y,z){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16491 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16492 = x;
var G__16493 = y;
var G__16494 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__16491,G__16492,G__16493,G__16494) : f.call(null,G__16491,G__16492,G__16493,G__16494));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16495(m,k,f,x,y,z,more){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),x,y,z,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([more], 0)));
}));

/** @this {Function} */
(cljs.core.update.cljs$lang$applyTo = (function cljs$core$fn_16496(seq16473){
var G__16474 = cljs.core.first(seq16473);
var seq16473__$1 = cljs.core.next(seq16473);
var G__16475 = cljs.core.first(seq16473__$1);
var seq16473__$2 = cljs.core.next(seq16473__$1);
var G__16476 = cljs.core.first(seq16473__$2);
var seq16473__$3 = cljs.core.next(seq16473__$2);
var G__16477 = cljs.core.first(seq16473__$3);
var seq16473__$4 = cljs.core.next(seq16473__$3);
var G__16478 = cljs.core.first(seq16473__$4);
var seq16473__$5 = cljs.core.next(seq16473__$4);
var G__16479 = cljs.core.first(seq16473__$5);
var seq16473__$6 = cljs.core.next(seq16473__$5);
var self__10831__auto__ = this;
return self__10831__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16474,G__16475,G__16476,G__16477,G__16478,G__16479,seq16473__$6);
}));

(cljs.core.update.cljs$lang$maxFixedArity = (6));


/**
* @constructor
*/
cljs.core.VectorNode = (function (edit,arr){
this.edit = edit;
this.arr = arr;
});

(cljs.core.VectorNode.getBasis = (function cljs$core$fn_16501(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null);
}));

(cljs.core.VectorNode.cljs$lang$type = true);

(cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode");

(cljs.core.VectorNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_16502(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/VectorNode");
}));

/**
 * Positional factory function for cljs.core/VectorNode.
 */
cljs.core.__GT_VectorNode = (function cljs$core$__GT_VectorNode(edit,arr){
return (new cljs.core.VectorNode(edit,arr));
});

cljs.core.pv_fresh_node = (function cljs$core$pv_fresh_node(edit){
return (new cljs.core.VectorNode(edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
});
cljs.core.pv_aget = (function cljs$core$pv_aget(node,idx){
return (node.arr[idx]);
});
cljs.core.pv_aset = (function cljs$core$pv_aset(node,idx,val){
return (node.arr[idx] = val);
});
cljs.core.pv_clone_node = (function cljs$core$pv_clone_node(node){
return (new cljs.core.VectorNode(node.edit,cljs.core.aclone(node.arr)));
});
cljs.core.tail_off = (function cljs$core$tail_off(pv){
var cnt = pv.cnt;
if((cnt < (32))){
return (0);
} else {
return (((cnt - (1)) >>> (5)) << (5));
}
});
cljs.core.new_path = (function cljs$core$new_path(edit,level,node){
var ll = level;
var ret = node;
while(true){
if((ll === (0))){
return ret;
} else {
var embed = ret;
var r = cljs.core.pv_fresh_node(edit);
var _ = cljs.core.pv_aset(r,(0),embed);
var G__16503 = (ll - (5));
var G__16504 = r;
ll = G__16503;
ret = G__16504;
continue;
}
break;
}
});
cljs.core.push_tail = (function cljs$core$push_tail(pv,level,parent,tailnode){
var ret = cljs.core.pv_clone_node(parent);
var subidx = (((pv.cnt - (1)) >>> level) & (31));
if(((5) === level)){
cljs.core.pv_aset(ret,subidx,tailnode);

return ret;
} else {
var child = cljs.core.pv_aget(parent,subidx);
if((!((child == null)))){
var node_to_insert = (function (){var G__16505 = pv;
var G__16506 = (level - (5));
var G__16507 = child;
var G__16508 = tailnode;
return (cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4(G__16505,G__16506,G__16507,G__16508) : cljs.core.push_tail.call(null,G__16505,G__16506,G__16507,G__16508));
})();
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
} else {
var node_to_insert = cljs.core.new_path(null,(level - (5)),tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
}
}
});
cljs.core.vector_index_out_of_bounds = (function cljs$core$vector_index_out_of_bounds(i,cnt){
throw (new Error(["No item ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i)," in vector of length ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cnt)].join('')));
});
cljs.core.first_array_for_longvec = (function cljs$core$first_array_for_longvec(pv){
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__16509 = cljs.core.pv_aget(node,(0));
var G__16510 = (level - (5));
node = G__16509;
level = G__16510;
continue;
} else {
return node.arr;
}
break;
}
});
cljs.core.unchecked_array_for = (function cljs$core$unchecked_array_for(pv,i){
if((i >= cljs.core.tail_off(pv))){
return pv.tail;
} else {
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__16511 = cljs.core.pv_aget(node,((i >>> level) & (31)));
var G__16512 = (level - (5));
node = G__16511;
level = G__16512;
continue;
} else {
return node.arr;
}
break;
}
}
});
cljs.core.array_for = (function cljs$core$array_for(pv,i){
if(((((0) <= i)) && ((i < pv.cnt)))){
return cljs.core.unchecked_array_for(pv,i);
} else {
return cljs.core.vector_index_out_of_bounds(i,pv.cnt);
}
});
cljs.core.do_assoc = (function cljs$core$do_assoc(pv,level,node,i,val){
var ret = cljs.core.pv_clone_node(node);
if((level === (0))){
cljs.core.pv_aset(ret,(i & (31)),val);

return ret;
} else {
var subidx = ((i >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(function (){var G__16513 = pv;
var G__16514 = (level - (5));
var G__16515 = cljs.core.pv_aget(node,subidx);
var G__16516 = i;
var G__16517 = val;
return (cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5 ? cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5(G__16513,G__16514,G__16515,G__16516,G__16517) : cljs.core.do_assoc.call(null,G__16513,G__16514,G__16515,G__16516,G__16517));
})());

return ret;
}
});
cljs.core.pop_tail = (function cljs$core$pop_tail(pv,level,node){
var subidx = (((pv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = (function (){var G__16518 = pv;
var G__16519 = (level - (5));
var G__16520 = cljs.core.pv_aget(node,subidx);
return (cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3(G__16518,G__16519,G__16520) : cljs.core.pop_tail.call(null,G__16518,G__16519,G__16520));
})();
if((((new_child == null)) && ((subidx === (0))))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,new_child);

return ret;
}
} else {
if((subidx === (0))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,null);

return ret;

}
}
});

/**
* @constructor
*/
cljs.core.RangedIterator = (function (i,base,arr,v,start,end){
this.i = i;
this.base = base;
this.arr = arr;
this.v = v;
this.start = start;
this.end = end;
});
(cljs.core.RangedIterator.prototype.hasNext = (function cljs$core$fn_16521(){
var self__ = this;
var this$ = this;
return (self__.i < self__.end);
}));

(cljs.core.RangedIterator.prototype.next = (function cljs$core$fn_16522(){
var self__ = this;
var this$ = this;
if(((self__.i - self__.base) === (32))){
(self__.arr = cljs.core.unchecked_array_for(self__.v,self__.i));

(self__.base = (self__.base + (32)));
} else {
}

var ret = (self__.arr[(self__.i & (31))]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.RangedIterator.getBasis = (function cljs$core$fn_16523(){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"base","base",1825810849,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null);
}));

(cljs.core.RangedIterator.cljs$lang$type = true);

(cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator");

(cljs.core.RangedIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_16524(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/RangedIterator");
}));

/**
 * Positional factory function for cljs.core/RangedIterator.
 */
cljs.core.__GT_RangedIterator = (function cljs$core$__GT_RangedIterator(i,base,arr,v,start,end){
return (new cljs.core.RangedIterator(i,base,arr,v,start,end));
});

cljs.core.ranged_iterator = (function cljs$core$ranged_iterator(v,start,end){
var i = start;
return (new cljs.core.RangedIterator(i,(i - (i % (32))),(((start < cljs.core.count(v)))?cljs.core.unchecked_array_for(v,i):null),v,start,end));
});
cljs.core.pv_reduce = (function cljs$core$pv_reduce(var_args){
var G__16526 = arguments.length;
switch (G__16526) {
case 4:
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16527(pv,f,start,end){
if((start < end)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(pv,f,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pv,start),(start + (1)),end);
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
}));

(cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_16528(pv,f,init,start,end){
var acc = init;
var i = start;
var arr = cljs.core.unchecked_array_for(pv,start);
while(true){
if((i < end)){
var j = (i & (31));
var arr__$1 = (((j === (0)))?cljs.core.unchecked_array_for(pv,i):arr);
var nacc = (function (){var G__16529 = acc;
var G__16530 = (arr__$1[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16529,G__16530) : f.call(null,G__16529,G__16530));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__16532 = nacc;
var G__16533 = (i + (1));
var G__16534 = arr__$1;
acc = G__16532;
i = G__16533;
arr = G__16534;
continue;
}
} else {
return acc;
}
break;
}
}));

(cljs.core.pv_reduce.cljs$lang$maxFixedArity = 5);







/**
 * Marker protocol
 * @interface
 */
cljs.core.APersistentVector = function(){};


/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.APersistentVector}
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentVector = (function (meta,cnt,shift,root,tail,__hash){
this.meta = meta;
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 401412;
});
(cljs.core.PersistentVector.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_16536(coll,n){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return (new cljs.core.MapEntry(n,(cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]),null));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.toString = (function cljs$core$fn_16537(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentVector.prototype.equiv = (function cljs$core$fn_16538(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentVector.prototype.indexOf = (function() {
var cljs$core$fn_16539 = null;
var cljs$core$fn_16539__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16539__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16539 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16539__1.call(this,x);
case 2:
return cljs$core$fn_16539__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16539.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16539__1;
cljs$core$fn_16539.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16539__2;
return cljs$core$fn_16539;
})()
);

(cljs.core.PersistentVector.prototype.lastIndexOf = (function() {
var cljs$core$fn_16540 = null;
var cljs$core$fn_16540__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16540__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16540 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16540__1.call(this,x);
case 2:
return cljs$core$fn_16540__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16540.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16540__1;
cljs$core$fn_16540.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16540__2;
return cljs$core$fn_16540;
})()
);

(cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16541(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16542(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function cljs$core$fn_16543(v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__16544 = init__$2;
var G__16545 = (j + i);
var G__16546 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16544,G__16545,G__16546) : f.call(null,G__16544,G__16545,G__16546));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__16577 = (j + (1));
var G__16578 = init__$3;
j = G__16577;
init__$2 = G__16578;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__16579 = (i + len);
var G__16580 = init__$2;
i = G__16579;
init__$1 = G__16580;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$APersistentVector$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_16547(coll,n){
var self__ = this;
var coll__$1 = this;
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_16548(coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return (cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]);
} else {
return not_found;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function cljs$core$fn_16549(coll,n,val){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
if((cljs.core.tail_off(coll__$1) <= n)){
var new_tail = cljs.core.aclone(self__.tail);
(new_tail[(n & (31))] = val);

return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,cljs.core.do_assoc(coll__$1,self__.shift,self__.root,n,val),self__.tail,null));
}
} else {
if((n === self__.cnt)){
return coll__$1.cljs$core$ICollection$_conj$arity$2(null,val);
} else {
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds  [0,",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt),"]"].join('')));

}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_16550(this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.ranged_iterator(this$__$1,(0),self__.cnt);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16551(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_16552(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16553(coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_16554(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return coll__$1.cljs$core$IIndexed$_nth$arity$2(null,(self__.cnt - (1)));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_16555(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
} else {
if(((1) < (self__.cnt - cljs.core.tail_off(coll__$1)))){
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt - (1)),self__.shift,self__.root,self__.tail.slice((0),(-1)),null));
} else {
var new_tail = cljs.core.unchecked_array_for(coll__$1,(self__.cnt - (2)));
var nr = cljs.core.pop_tail(coll__$1,self__.shift,self__.root);
var new_root = (((nr == null))?cljs.core.PersistentVector.EMPTY_NODE:nr);
var cnt_1 = (self__.cnt - (1));
if(((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null)))){
return (new cljs.core.PersistentVector(self__.meta,cnt_1,(self__.shift - (5)),cljs.core.pv_aget(new_root,(0)),new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift,new_root,new_tail,null));
}

}
}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_16556(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return (new cljs.core.RSeq(coll__$1,(self__.cnt - (1)),null));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16557(coll){
var self__ = this;
var coll__$1 = this;
var h__9978__auto__ = self__.__hash;
if((!((h__9978__auto__ == null)))){
return h__9978__auto__;
} else {
var h__9978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9978__auto____$1);

return h__9978__auto____$1;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16558(coll,other){
var self__ = this;
var coll__$1 = this;
if((other instanceof cljs.core.PersistentVector)){
if((self__.cnt === cljs.core.count(other))){
var me_iter = coll__$1.cljs$core$IIterable$_iterator$arity$1(null);
var you_iter = other.cljs$core$IIterable$_iterator$arity$1(null);
while(true){
if(me_iter.hasNext()){
var x = me_iter.next();
var y = you_iter.next();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_sequential(coll__$1,other);
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function cljs$core$fn_16559(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientVector(self__.cnt,self__.shift,cljs.core.tv_editable_root(self__.root),cljs.core.tv_editable_tail(self__.tail)));
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16560(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16561(v,f){
var self__ = this;
var v__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(v__$1,f,(0),self__.cnt);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16562(v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__16563 = init__$2;
var G__16564 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16563,G__16564) : f.call(null,G__16563,G__16564));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__16581 = (j + (1));
var G__16582 = init__$3;
j = G__16581;
init__$2 = G__16582;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__16583 = (i + len);
var G__16584 = init__$2;
i = G__16583;
init__$1 = G__16584;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_16565(coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IVector$_assoc_n$arity$3(null,k,v);
} else {
throw (new Error("Vector's key for assoc must be a number."));
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_16566(coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.integer_QMARK_(k)){
return ((((0) <= k)) && ((k < self__.cnt)));
} else {
return false;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16567(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
return null;
} else {
if((self__.cnt <= (32))){
return (new cljs.core.IndexedSeq(self__.tail,(0),null));
} else {
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(coll__$1,cljs.core.first_array_for_longvec(coll__$1),(0),(0));

}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16568(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentVector(new_meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16569(coll,o){
var self__ = this;
var coll__$1 = this;
if(((self__.cnt - cljs.core.tail_off(coll__$1)) < (32))){
var len = self__.tail.length;
var new_tail = (new Array((len + (1))));
var n__10605__auto___16585 = len;
var i_16586 = (0);
while(true){
if((i_16586 < n__10605__auto___16585)){
(new_tail[i_16586] = (self__.tail[i_16586]));

var G__16587 = (i_16586 + (1));
i_16586 = G__16587;
continue;
} else {
}
break;
}

(new_tail[len] = o);

return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),self__.shift,self__.root,new_tail,null));
} else {
var root_overflow_QMARK_ = ((self__.cnt >>> (5)) > ((1) << self__.shift));
var new_shift = ((root_overflow_QMARK_)?(self__.shift + (5)):self__.shift);
var new_root = ((root_overflow_QMARK_)?(function (){var n_r = cljs.core.pv_fresh_node(null);
cljs.core.pv_aset(n_r,(0),self__.root);

cljs.core.pv_aset(n_r,(1),cljs.core.new_path(null,self__.shift,(new cljs.core.VectorNode(null,self__.tail))));

return n_r;
})():cljs.core.push_tail(coll__$1,self__.shift,self__.root,(new cljs.core.VectorNode(null,self__.tail))));
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),new_shift,new_root,[o],null));
}
}));

(cljs.core.PersistentVector.prototype.call = (function cljs$core$fn_16570(self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
if(typeof k === 'number'){
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
} else {
throw (new Error("Key must be integer"));
}
}));

(cljs.core.PersistentVector.prototype.apply = (function cljs$core$fn_16571(self__,args16535){
var self__ = this;
var self____$1 = this;
var args__10120__auto__ = cljs.core.aclone(args16535);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10120__auto__.length > (20)))?(function (){var G__16572 = args__10120__auto__.slice((0),(20));
G__16572.push(args__10120__auto__.slice((20)));

return G__16572;
})():args__10120__auto__)));
}));

(cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16573(k){
var self__ = this;
var coll = this;
if(typeof k === 'number'){
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
} else {
throw (new Error("Key must be integer"));
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IDrop$_drop$arity$2 = (function cljs$core$fn_16574(coll,n){
var self__ = this;
var coll__$1 = this;
if((n < self__.cnt)){
var offset = (n % (32));
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(coll__$1,cljs.core.unchecked_array_for(coll__$1,n),(n - offset),offset);
} else {
return null;
}
}));

(cljs.core.PersistentVector.getBasis = (function cljs$core$fn_16575(){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"tail","tail",494507963,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentVector.cljs$lang$type = true);

(cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector");

(cljs.core.PersistentVector.cljs$lang$ctorPrWriter = (function cljs$core$fn_16576(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/PersistentVector");
}));

/**
 * Positional factory function for cljs.core/PersistentVector.
 */
cljs.core.__GT_PersistentVector = (function cljs$core$__GT_PersistentVector(meta,cnt,shift,root,tail,__hash){
return (new cljs.core.PersistentVector(meta,cnt,shift,root,tail,__hash));
});

(cljs.core.PersistentVector.EMPTY_NODE = (new cljs.core.VectorNode(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null])));
(cljs.core.PersistentVector.EMPTY = (new cljs.core.PersistentVector(null,(0),(5),cljs.core.PersistentVector.EMPTY_NODE,[],cljs.core.empty_ordered_hash)));
(cljs.core.PersistentVector.fromArray = (function cljs$core$fn_16588(xs,no_clone){
var l = xs.length;
var xs__$1 = ((no_clone)?xs:cljs.core.aclone(xs));
if((l < (32))){
return (new cljs.core.PersistentVector(null,l,(5),cljs.core.PersistentVector.EMPTY_NODE,xs__$1,null));
} else {
var node = xs__$1.slice((0),(32));
var v = (new cljs.core.PersistentVector(null,(32),(5),cljs.core.PersistentVector.EMPTY_NODE,node,null));
var i = (32);
var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
while(true){
if((i < l)){
var G__16589 = (i + (1));
var G__16590 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out,(xs__$1[i]));
i = G__16589;
out = G__16590;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}
}));
(cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16591(){
var this__10707__auto__ = this;
return cljs.core.es6_iterator(this__10707__auto__);
}));
/**
 * Creates a new vector containing the contents of coll. JavaScript arrays
 *   will be aliased and should not be modified.
 */
cljs.core.vec = (function cljs$core$vec(coll){
if(cljs.core.map_entry_QMARK_(coll)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.key(coll),cljs.core.val(coll)], null);
} else {
if(cljs.core.vector_QMARK_(coll)){
return cljs.core.with_meta(coll,null);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.PersistentVector.fromArray(coll,true);
} else {
return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core._as_transient(cljs.core.PersistentVector.EMPTY),coll));

}
}
}
});
/**
 * Creates a new vector containing the args.
 */
cljs.core.vector = (function cljs$core$vector(var_args){
var args__10856__auto__ = [];
var len__10846__auto___16595 = arguments.length;
var i__10847__auto___16596 = (0);
while(true){
if((i__10847__auto___16596 < len__10846__auto___16595)){
args__10856__auto__.push((arguments[i__10847__auto___16596]));

var G__16597 = (i__10847__auto___16596 + (1));
i__10847__auto___16596 = G__16597;
continue;
} else {
}
break;
}

var argseq__10857__auto__ = ((((0) < args__10856__auto__.length))?(new cljs.core.IndexedSeq(args__10856__auto__.slice((0)),(0),null)):null);
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__10857__auto__);
});

(cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16593(args){
if((((args instanceof cljs.core.IndexedSeq)) && ((args.i === (0))))){
return cljs.core.PersistentVector.fromArray(args.arr,(!(cljs.core.array_QMARK_(args.arr))));
} else {
return cljs.core.vec(args);
}
}));

(cljs.core.vector.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.vector.cljs$lang$applyTo = (function cljs$core$fn_16594(seq16592){
var self__10832__auto__ = this;
return self__10832__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq16592));
}));


/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ChunkedSeq = (function (vec,node,i,off,meta,__hash){
this.vec = vec;
this.node = node;
this.i = i;
this.off = off;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375020;
this.cljs$lang$protocol_mask$partition1$ = 263680;
});
(cljs.core.ChunkedSeq.prototype.toString = (function cljs$core$fn_16598(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ChunkedSeq.prototype.equiv = (function cljs$core$fn_16599(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ChunkedSeq.prototype.indexOf = (function() {
var cljs$core$fn_16600 = null;
var cljs$core$fn_16600__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16600__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16600 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16600__1.call(this,x);
case 2:
return cljs$core$fn_16600__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16600.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16600__1;
cljs$core$fn_16600.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16600__2;
return cljs$core$fn_16600;
})()
);

(cljs.core.ChunkedSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_16601 = null;
var cljs$core$fn_16601__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16601__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16601 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16601__1.call(this,x);
case 2:
return cljs$core$fn_16601__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16601.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16601__1;
cljs$core$fn_16601.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16601__2;
return cljs$core$fn_16601;
})()
);

(cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16602(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16603(coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,self__.node,self__.i,(self__.off + (1)));
if((s == null)){
return null;
} else {
return s;
}
} else {
return coll__$1.cljs$core$IChunkedNext$_chunked_next$arity$1(null);
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16604(coll){
var self__ = this;
var coll__$1 = this;
var h__9978__auto__ = self__.__hash;
if((!((h__9978__auto__ == null)))){
return h__9978__auto__;
} else {
var h__9978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9978__auto____$1);

return h__9978__auto____$1;
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16605(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16606(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16607(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(self__.vec,f,(self__.i + self__.off),cljs.core.count(self__.vec));
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16608(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(self__.vec,f,start,(self__.i + self__.off),cljs.core.count(self__.vec));
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16609(coll){
var self__ = this;
var coll__$1 = this;
return (self__.node[self__.off]);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16610(coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,self__.node,self__.i,(self__.off + (1)));
if((s == null)){
return cljs.core.List.EMPTY;
} else {
return s;
}
} else {
return coll__$1.cljs$core$IChunkedSeq$_chunked_rest$arity$1(null);
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16611(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function cljs$core$fn_16612(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node,self__.off);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function cljs$core$fn_16613(coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,cljs.core.unchecked_array_for(self__.vec,end),end,(0));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16614(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(self__.vec,self__.node,self__.i,self__.off,new_meta);
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16615(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IDrop$_drop$arity$2 = (function cljs$core$fn_16616(coll,n){
var self__ = this;
var coll__$1 = this;
var o = (self__.off + n);
if((o < self__.node.length)){
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,self__.node,self__.i,o);
} else {
var i__$1 = (self__.i + o);
if((i__$1 < cljs.core._count(self__.vec))){
var new_offset = (i__$1 % (32));
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,cljs.core.unchecked_array_for(self__.vec,i__$1),(i__$1 - new_offset),new_offset);
} else {
return null;
}
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function cljs$core$fn_16617(coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,cljs.core.unchecked_array_for(self__.vec,end),end,(0));
} else {
return null;
}
}));

(cljs.core.ChunkedSeq.getBasis = (function cljs$core$fn_16618(){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"vec","vec",982683596,null),new cljs.core.Symbol(null,"node","node",-2073234571,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ChunkedSeq.cljs$lang$type = true);

(cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq");

(cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_16619(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/ChunkedSeq");
}));

/**
 * Positional factory function for cljs.core/ChunkedSeq.
 */
cljs.core.__GT_ChunkedSeq = (function cljs$core$__GT_ChunkedSeq(vec,node,i,off,meta,__hash){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,__hash));
});

(cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16620(){
var this__10707__auto__ = this;
return cljs.core.es6_iterator(this__10707__auto__);
}));
cljs.core.chunked_seq = (function cljs$core$chunked_seq(var_args){
var G__16622 = arguments.length;
switch (G__16622) {
case 3:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16623(vec,i,off){
return (new cljs.core.ChunkedSeq(vec,cljs.core.array_for(vec,i),i,off,null,null));
}));

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16624(vec,node,i,off){
return (new cljs.core.ChunkedSeq(vec,node,i,off,null,null));
}));

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_16625(vec,node,i,off,meta){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,null));
}));

(cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5);


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Subvec = (function (meta,v,start,end,__hash){
this.meta = meta;
this.v = v;
this.start = start;
this.end = end;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(cljs.core.Subvec.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Subvec.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_16628(coll,n){
var self__ = this;
var coll__$1 = this;
if((n < (0))){
return null;
} else {
var idx = (self__.start + n);
if((idx < self__.end)){
return (new cljs.core.MapEntry(n,cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.v,idx),null));
} else {
return null;
}
}
}));

(cljs.core.Subvec.prototype.toString = (function cljs$core$fn_16629(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Subvec.prototype.equiv = (function cljs$core$fn_16630(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Subvec.prototype.indexOf = (function() {
var cljs$core$fn_16631 = null;
var cljs$core$fn_16631__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16631__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
cljs$core$fn_16631 = function(x,start__$1){
switch(arguments.length){
case 1:
return cljs$core$fn_16631__1.call(this,x);
case 2:
return cljs$core$fn_16631__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16631.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16631__1;
cljs$core$fn_16631.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16631__2;
return cljs$core$fn_16631;
})()
);

(cljs.core.Subvec.prototype.lastIndexOf = (function() {
var cljs$core$fn_16632 = null;
var cljs$core$fn_16632__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16632__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
cljs$core$fn_16632 = function(x,start__$1){
switch(arguments.length){
case 1:
return cljs$core$fn_16632__1.call(this,x);
case 2:
return cljs$core$fn_16632__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16632.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16632__1;
cljs$core$fn_16632.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16632__2;
return cljs$core$fn_16632;
})()
);

(cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16633(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16634(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function cljs$core$fn_16635(coll,f,init){
var self__ = this;
var coll__$1 = this;
var i = self__.start;
var j = (0);
var init__$1 = init;
while(true){
if((i < self__.end)){
var init__$2 = (function (){var G__16636 = init__$1;
var G__16637 = j;
var G__16638 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16636,G__16637,G__16638) : f.call(null,G__16636,G__16637,G__16638));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__16670 = (i + (1));
var G__16671 = (j + (1));
var G__16672 = init__$2;
i = G__16670;
j = G__16671;
init__$1 = G__16672;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_16639(coll,n){
var self__ = this;
var coll__$1 = this;
if((((n < (0))) || ((self__.end <= (self__.start + n))))){
return cljs.core.vector_index_out_of_bounds(n,(self__.end - self__.start));
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.start + n));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_16640(coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((n < (0))) || ((self__.end <= (self__.start + n))))){
return not_found;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v,(self__.start + n),not_found);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function cljs$core$fn_16641(coll,n,val){
var self__ = this;
var coll__$1 = this;
var v_pos = (self__.start + n);
if((((n < (0))) || (((self__.end + (1)) <= v_pos)))){
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds [0,",cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll__$1.cljs$core$ICounted$_count$arity$1(null)),"]"].join('')));
} else {
return cljs.core.build_subvec(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v,v_pos,val),self__.start,(function (){var x__9874__auto__ = self__.end;
var y__9875__auto__ = (v_pos + (1));
return ((x__9874__auto__ > y__9875__auto__) ? x__9874__auto__ : y__9875__auto__);
})(),null);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_16642(coll){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.ranged_iterator(self__.v,self__.start,self__.end);
} else {
return cljs.core.seq_iter(coll__$1);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16644(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_16645(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Subvec(self__.meta,self__.v,self__.start,self__.end,self__.__hash));
}));

(cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16646(coll){
var self__ = this;
var coll__$1 = this;
return (self__.end - self__.start);
}));

(cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_16647(coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
return null;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.end - (1)));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_16648(coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
throw (new Error("Can't pop empty vector"));
} else {
return cljs.core.build_subvec(self__.meta,self__.v,self__.start,(self__.end - (1)),null);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_16649(coll){
var self__ = this;
var coll__$1 = this;
if((!((self__.start === self__.end)))){
return (new cljs.core.RSeq(coll__$1,((self__.end - self__.start) - (1)),null));
} else {
return null;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16650(coll){
var self__ = this;
var coll__$1 = this;
var h__9978__auto__ = self__.__hash;
if((!((h__9978__auto__ == null)))){
return h__9978__auto__;
} else {
var h__9978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9978__auto____$1);

return h__9978__auto____$1;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16651(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16652(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
}));

(cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16653(coll,f){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(self__.v,f,self__.start,self__.end);
} else {
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16655(coll,f,init){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(self__.v,f,init,self__.start,self__.end);
} else {
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,init);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_16657(coll,key,val){
var self__ = this;
var coll__$1 = this;
if(typeof key === 'number'){
return coll__$1.cljs$core$IVector$_assoc_n$arity$3(null,key,val);
} else {
throw (new Error("Subvec's key for assoc must be a number."));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_16658(coll,key){
var self__ = this;
var coll__$1 = this;
if(cljs.core.integer_QMARK_(key)){
return ((((0) <= key)) && ((key < (self__.end - self__.start))));
} else {
return false;
}
}));

(cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16659(coll){
var self__ = this;
var coll__$1 = this;
var subvec_seq = (function cljs$core$fn_16659_$_subvec_seq(i){
if((i === self__.end)){
return null;
} else {
return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i),(new cljs.core.LazySeq(null,(function cljs$core$fn_16659_$_subvec_seq_$_fn_16660(){
return cljs$core$fn_16659_$_subvec_seq((i + (1)));
}),null,null)));
}
});
return subvec_seq(self__.start);
}));

(cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16661(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return cljs.core.build_subvec(new_meta,self__.v,self__.start,self__.end,self__.__hash);
}
}));

(cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16662(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.build_subvec(self__.meta,cljs.core._assoc_n(self__.v,self__.end,o),self__.start,(self__.end + (1)),null);
}));

(cljs.core.Subvec.prototype.call = (function() {
var cljs$core$fn_16663 = null;
var cljs$core$fn_16663__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var cljs$core$fn_16663__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
cljs$core$fn_16663 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_16663__2.call(this,self__,k);
case 3:
return cljs$core$fn_16663__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_16663.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16663__2;
cljs$core$fn_16663.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16663__3;
return cljs$core$fn_16663;
})()
);

(cljs.core.Subvec.prototype.apply = (function cljs$core$fn_16664(self__,args16627){
var self__ = this;
var self____$1 = this;
var args__10120__auto__ = cljs.core.aclone(args16627);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10120__auto__.length > (20)))?(function (){var G__16665 = args__10120__auto__.slice((0),(20));
G__16665.push(args__10120__auto__.slice((20)));

return G__16665;
})():args__10120__auto__)));
}));

(cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16666(k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16667(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.Subvec.getBasis = (function cljs$core$fn_16668(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Subvec.cljs$lang$type = true);

(cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec");

(cljs.core.Subvec.cljs$lang$ctorPrWriter = (function cljs$core$fn_16669(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/Subvec");
}));

/**
 * Positional factory function for cljs.core/Subvec.
 */
cljs.core.__GT_Subvec = (function cljs$core$__GT_Subvec(meta,v,start,end,__hash){
return (new cljs.core.Subvec(meta,v,start,end,__hash));
});

(cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16673(){
var this__10707__auto__ = this;
return cljs.core.es6_iterator(this__10707__auto__);
}));
cljs.core.build_subvec = (function cljs$core$build_subvec(meta,v,start,end,__hash){
while(true){
if((v instanceof cljs.core.Subvec)){
var G__16674 = meta;
var G__16675 = v.v;
var G__16676 = (v.start + start);
var G__16677 = (v.start + end);
var G__16678 = __hash;
meta = G__16674;
v = G__16675;
start = G__16676;
end = G__16677;
__hash = G__16678;
continue;
} else {
if(cljs.core.vector_QMARK_(v)){
} else {
throw (new Error("v must satisfy IVector"));
}

if((((start < (0))) || ((((end < start)) || ((end > cljs.core.count(v))))))){
throw (new Error("Index out of bounds"));
} else {
}

return (new cljs.core.Subvec(meta,v,start,end,__hash));
}
break;
}
});
/**
 * Returns a persistent vector of the items in vector from
 *   start (inclusive) to end (exclusive).  If end is not supplied,
 *   defaults to (count vector). This operation is O(1) and very fast, as
 *   the resulting vector shares structure with the original and no
 *   trimming is done.
 */
cljs.core.subvec = (function cljs$core$subvec(var_args){
var G__16680 = arguments.length;
switch (G__16680) {
case 2:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16681(v,start){
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v,start,cljs.core.count(v));
}));

(cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16682(v,start,end){
if((((!((start == null)))) && ((!((end == null)))))){
} else {
throw (new Error("Assert failed: (and (not (nil? start)) (not (nil? end)))"));
}

return cljs.core.build_subvec(null,v,(start | (0)),(end | (0)),null);
}));

(cljs.core.subvec.cljs$lang$maxFixedArity = 3);

cljs.core.tv_ensure_editable = (function cljs$core$tv_ensure_editable(edit,node){
if((edit === node.edit)){
return node;
} else {
return (new cljs.core.VectorNode(edit,cljs.core.aclone(node.arr)));
}
});
cljs.core.tv_editable_root = (function cljs$core$tv_editable_root(node){
return (new cljs.core.VectorNode(({}),cljs.core.aclone(node.arr)));
});
cljs.core.tv_editable_tail = (function cljs$core$tv_editable_tail(tl){
var ret = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
cljs.core.array_copy(tl,(0),ret,(0),tl.length);

return ret;
});
cljs.core.tv_push_tail = (function cljs$core$tv_push_tail(tv,level,parent,tail_node){
var ret = cljs.core.tv_ensure_editable(tv.root.edit,parent);
var subidx = (((tv.cnt - (1)) >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(((level === (5)))?tail_node:(function (){var child = cljs.core.pv_aget(ret,subidx);
if((!((child == null)))){
var G__16686 = tv;
var G__16687 = (level - (5));
var G__16688 = child;
var G__16689 = tail_node;
return (cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4(G__16686,G__16687,G__16688,G__16689) : cljs.core.tv_push_tail.call(null,G__16686,G__16687,G__16688,G__16689));
} else {
return cljs.core.new_path(tv.root.edit,(level - (5)),tail_node);
}
})()));

return ret;
});
cljs.core.tv_pop_tail = (function cljs$core$tv_pop_tail(tv,level,node){
var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit,node);
var subidx = (((tv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = (function (){var G__16690 = tv;
var G__16691 = (level - (5));
var G__16692 = cljs.core.pv_aget(node__$1,subidx);
return (cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3(G__16690,G__16691,G__16692) : cljs.core.tv_pop_tail.call(null,G__16690,G__16691,G__16692));
})();
if((((new_child == null)) && ((subidx === (0))))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,new_child);

return node__$1;
}
} else {
if((subidx === (0))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,null);

return node__$1;

}
}
});
cljs.core.unchecked_editable_array_for = (function cljs$core$unchecked_editable_array_for(tv,i){
if((i >= cljs.core.tail_off(tv))){
return tv.tail;
} else {
var root = tv.root;
var node = root;
var level = tv.shift;
while(true){
if((level > (0))){
var G__16693 = cljs.core.tv_ensure_editable(root.edit,cljs.core.pv_aget(node,((i >>> level) & (31))));
var G__16694 = (level - (5));
node = G__16693;
level = G__16694;
continue;
} else {
return node.arr;
}
break;
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientVector}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientVector = (function (cnt,shift,root,tail){
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.cljs$lang$protocol_mask$partition1$ = 88;
this.cljs$lang$protocol_mask$partition0$ = 275;
});
(cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function cljs$core$fn_16696(tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((self__.cnt - cljs.core.tail_off(tcoll__$1)) < (32))){
(self__.tail[(self__.cnt & (31))] = o);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
} else {
var tail_node = (new cljs.core.VectorNode(self__.root.edit,self__.tail));
var new_tail = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(new_tail[(0)] = o);

(self__.tail = new_tail);

if(((self__.cnt >>> (5)) > ((1) << self__.shift))){
var new_root_array = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var new_shift = (self__.shift + (5));
(new_root_array[(0)] = self__.root);

(new_root_array[(1)] = cljs.core.new_path(self__.root.edit,self__.shift,tail_node));

(self__.root = (new cljs.core.VectorNode(self__.root.edit,new_root_array)));

(self__.shift = new_shift);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
} else {
var new_root = cljs.core.tv_push_tail(tcoll__$1,self__.shift,self__.root,tail_node);
(self__.root = new_root);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function cljs$core$fn_16697(tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
(self__.root.edit = null);

var len = (self__.cnt - cljs.core.tail_off(tcoll__$1));
var trimmed_tail = (new Array(len));
cljs.core.array_copy(self__.tail,(0),trimmed_tail,(0),len);

return (new cljs.core.PersistentVector(null,self__.cnt,self__.shift,self__.root,trimmed_tail,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function cljs$core$fn_16698(tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(typeof key === 'number'){
return tcoll__$1.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(null,key,val);
} else {
throw (new Error("TransientVector's key for assoc! must be a number."));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = (function cljs$core$fn_16699(tcoll,n,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((((0) <= n)) && ((n < self__.cnt)))){
if((cljs.core.tail_off(tcoll__$1) <= n)){
(self__.tail[(n & (31))] = val);

return tcoll__$1;
} else {
var new_root = (function (){var fexpr__16700 = (function cljs$core$fn_16699_$_go(level,node){
var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit,node);
if((level === (0))){
cljs.core.pv_aset(node__$1,(n & (31)),val);

return node__$1;
} else {
var subidx = ((n >>> level) & (31));
cljs.core.pv_aset(node__$1,subidx,cljs$core$fn_16699_$_go((level - (5)),cljs.core.pv_aget(node__$1,subidx)));

return node__$1;
}
});
return fexpr__16700(self__.shift,self__.root);
})();
(self__.root = new_root);

return tcoll__$1;
}
} else {
if((n === self__.cnt)){
return tcoll__$1.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,val);
} else {
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds for TransientVector of length",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt)].join('')));

}
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = (function cljs$core$fn_16701(tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
(self__.cnt = (0));

return tcoll__$1;
} else {
if((((self__.cnt - (1)) & (31)) > (0))){
(self__.cnt = (self__.cnt - (1)));

return tcoll__$1;
} else {
var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1,(self__.cnt - (2)));
var new_root = (function (){var nr = cljs.core.tv_pop_tail(tcoll__$1,self__.shift,self__.root);
if((!((nr == null)))){
return nr;
} else {
return (new cljs.core.VectorNode(self__.root.edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
}
})();
if(((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null)))){
var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit,cljs.core.pv_aget(new_root,(0)));
(self__.root = new_root__$1);

(self__.shift = (self__.shift - (5)));

(self__.cnt = (self__.cnt - (1)));

(self__.tail = new_tail);

return tcoll__$1;
} else {
(self__.root = new_root);

(self__.cnt = (self__.cnt - (1)));

(self__.tail = new_tail);

return tcoll__$1;
}

}
}
}
} else {
throw (new Error("pop! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16702(coll){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return self__.cnt;
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_16703(coll,n){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
} else {
throw (new Error("nth after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_16704(coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return coll__$1.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
return not_found;
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16705(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16706(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((!(self__.root.edit))){
throw (new Error("lookup after persistent!"));
} else {
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;

}
}
}));

(cljs.core.TransientVector.prototype.call = (function() {
var cljs$core$fn_16707 = null;
var cljs$core$fn_16707__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var cljs$core$fn_16707__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
cljs$core$fn_16707 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_16707__2.call(this,self__,k);
case 3:
return cljs$core$fn_16707__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_16707.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16707__2;
cljs$core$fn_16707.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16707__3;
return cljs$core$fn_16707;
})()
);

(cljs.core.TransientVector.prototype.apply = (function cljs$core$fn_16708(self__,args16695){
var self__ = this;
var self____$1 = this;
var args__10120__auto__ = cljs.core.aclone(args16695);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10120__auto__.length > (20)))?(function (){var G__16709 = args__10120__auto__.slice((0),(20));
G__16709.push(args__10120__auto__.slice((20)));

return G__16709;
})():args__10120__auto__)));
}));

(cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16710(k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16711(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.TransientVector.getBasis = (function cljs$core$fn_16712(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"tail","tail",494507963,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.TransientVector.cljs$lang$type = true);

(cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector");

(cljs.core.TransientVector.cljs$lang$ctorPrWriter = (function cljs$core$fn_16713(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/TransientVector");
}));

/**
 * Positional factory function for cljs.core/TransientVector.
 */
cljs.core.__GT_TransientVector = (function cljs$core$__GT_TransientVector(cnt,shift,root,tail){
return (new cljs.core.TransientVector(cnt,shift,root,tail));
});


/**
* @constructor
*/
cljs.core.PersistentQueueIter = (function (fseq,riter){
this.fseq = fseq;
this.riter = riter;
});
(cljs.core.PersistentQueueIter.prototype.hasNext = (function cljs$core$fn_16714(){
var self__ = this;
var _ = this;
var or__9517__auto__ = (((!((self__.fseq == null)))) && (cljs.core.seq(self__.fseq)));
if(or__9517__auto__){
return or__9517__auto__;
} else {
var and__9511__auto__ = (!((self__.riter == null)));
if(and__9511__auto__){
return self__.riter.hasNext();
} else {
return and__9511__auto__;
}
}
}));

(cljs.core.PersistentQueueIter.prototype.next = (function cljs$core$fn_16715(){
var self__ = this;
var _ = this;
if((!((self__.fseq == null)))){
var ret = cljs.core.first(self__.fseq);
(self__.fseq = cljs.core.next(self__.fseq));

return ret;
} else {
if((((!((self__.riter == null)))) && (self__.riter.hasNext()))){
return self__.riter.next();
} else {
throw (new Error("No such element"));

}
}
}));

(cljs.core.PersistentQueueIter.prototype.remove = (function cljs$core$fn_16716(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.PersistentQueueIter.getBasis = (function cljs$core$fn_16717(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fseq","fseq",-1466412450,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"riter","riter",-237834262,null)], null);
}));

(cljs.core.PersistentQueueIter.cljs$lang$type = true);

(cljs.core.PersistentQueueIter.cljs$lang$ctorStr = "cljs.core/PersistentQueueIter");

(cljs.core.PersistentQueueIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_16718(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/PersistentQueueIter");
}));

/**
 * Positional factory function for cljs.core/PersistentQueueIter.
 */
cljs.core.__GT_PersistentQueueIter = (function cljs$core$__GT_PersistentQueueIter(fseq,riter){
return (new cljs.core.PersistentQueueIter(fseq,riter));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueueSeq = (function (meta,front,rear,__hash){
this.meta = meta;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850700;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.PersistentQueueSeq.prototype.toString = (function cljs$core$fn_16719(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentQueueSeq.prototype.equiv = (function cljs$core$fn_16720(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentQueueSeq.prototype.indexOf = (function() {
var cljs$core$fn_16721 = null;
var cljs$core$fn_16721__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16721__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16721 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16721__1.call(this,x);
case 2:
return cljs$core$fn_16721__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16721.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16721__1;
cljs$core$fn_16721.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16721__2;
return cljs$core$fn_16721;
})()
);

(cljs.core.PersistentQueueSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_16722 = null;
var cljs$core$fn_16722__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16722__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16722 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16722__1.call(this,x);
case 2:
return cljs$core$fn_16722__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16722.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16722__1;
cljs$core$fn_16722.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16722__2;
return cljs$core$fn_16722;
})()
);

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16723(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16724(coll){
var self__ = this;
var coll__$1 = this;
var temp__5718__auto__ = cljs.core.next(self__.front);
if(temp__5718__auto__){
var f1 = temp__5718__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((!((self__.rear == null)))){
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
} else {
return null;
}
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16725(coll){
var self__ = this;
var coll__$1 = this;
var h__9978__auto__ = self__.__hash;
if((!((h__9978__auto__ == null)))){
return h__9978__auto__;
} else {
var h__9978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9978__auto____$1);

return h__9978__auto____$1;
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16726(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16727(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16728(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16729(coll){
var self__ = this;
var coll__$1 = this;
var temp__5718__auto__ = cljs.core.next(self__.front);
if(temp__5718__auto__){
var f1 = temp__5718__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((self__.rear == null)){
return coll__$1.cljs$core$IEmptyableCollection$_empty$arity$1(null);
} else {
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
}
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16730(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16731(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentQueueSeq(new_meta,self__.front,self__.rear,self__.__hash));
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16732(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.PersistentQueueSeq.getBasis = (function cljs$core$fn_16733(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"front","front",117022539,null),new cljs.core.Symbol(null,"rear","rear",-900164830,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentQueueSeq.cljs$lang$type = true);

(cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq");

(cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_16734(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/PersistentQueueSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentQueueSeq.
 */
cljs.core.__GT_PersistentQueueSeq = (function cljs$core$__GT_PersistentQueueSeq(meta,front,rear,__hash){
return (new cljs.core.PersistentQueueSeq(meta,front,rear,__hash));
});

(cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16735(){
var this__10707__auto__ = this;
return cljs.core.es6_iterator(this__10707__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueue = (function (meta,count,front,rear,__hash){
this.meta = meta;
this.count = count;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 139264;
this.cljs$lang$protocol_mask$partition0$ = 31858766;
});
(cljs.core.PersistentQueue.prototype.toString = (function cljs$core$fn_16736(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentQueue.prototype.equiv = (function cljs$core$fn_16737(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentQueue.prototype.indexOf = (function() {
var cljs$core$fn_16738 = null;
var cljs$core$fn_16738__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16738__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16738 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16738__1.call(this,x);
case 2:
return cljs$core$fn_16738__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16738.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16738__1;
cljs$core$fn_16738.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16738__2;
return cljs$core$fn_16738;
})()
);

(cljs.core.PersistentQueue.prototype.lastIndexOf = (function() {
var cljs$core$fn_16739 = null;
var cljs$core$fn_16739__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(self__.count.cljs$core$IFn$_invoke$arity$1 ? self__.count.cljs$core$IFn$_invoke$arity$1(coll) : self__.count.call(null,coll)));
});
var cljs$core$fn_16739__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16739 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16739__1.call(this,x);
case 2:
return cljs$core$fn_16739__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16739.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16739__1;
cljs$core$fn_16739.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16739__2;
return cljs$core$fn_16739;
})()
);

(cljs.core.PersistentQueue.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_16740(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueIter(self__.front,cljs.core._iterator(self__.rear)));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16741(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_16742(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(self__.meta,self__.count,self__.front,self__.rear,self__.__hash));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16743(coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_16744(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_16745(coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
var temp__5718__auto__ = cljs.core.next(self__.front);
if(temp__5718__auto__){
var f1 = temp__5718__auto__;
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),f1,self__.rear,null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),cljs.core.seq(self__.rear),cljs.core.PersistentVector.EMPTY,null));
}
} else {
return coll__$1;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16746(coll){
var self__ = this;
var coll__$1 = this;
var h__9978__auto__ = self__.__hash;
if((!((h__9978__auto__ == null)))){
return h__9978__auto__;
} else {
var h__9978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9978__auto____$1);

return h__9978__auto____$1;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16747(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16748(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentQueue.EMPTY,self__.meta);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16749(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16750(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.rest(cljs.core.seq(coll__$1));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16751(coll){
var self__ = this;
var coll__$1 = this;
var rear__$1 = cljs.core.seq(self__.rear);
if(cljs.core.truth_((function (){var or__9517__auto__ = self__.front;
if(cljs.core.truth_(or__9517__auto__)){
return or__9517__auto__;
} else {
return rear__$1;
}
})())){
return (new cljs.core.PersistentQueueSeq(null,self__.front,cljs.core.seq(rear__$1),null));
} else {
return null;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16752(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentQueue(new_meta,self__.count,self__.front,self__.rear,self__.__hash));
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16753(coll,o){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),self__.front,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__9517__auto__ = self__.rear;
if(cljs.core.truth_(or__9517__auto__)){
return or__9517__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),o),null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front,o),cljs.core.PersistentVector.EMPTY,null));
}
}));

(cljs.core.PersistentQueue.getBasis = (function cljs$core$fn_16754(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"front","front",117022539,null),new cljs.core.Symbol(null,"rear","rear",-900164830,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentQueue.cljs$lang$type = true);

(cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue");

(cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = (function cljs$core$fn_16755(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/PersistentQueue");
}));

/**
 * Positional factory function for cljs.core/PersistentQueue.
 */
cljs.core.__GT_PersistentQueue = (function cljs$core$__GT_PersistentQueue(meta,count,front,rear,__hash){
return (new cljs.core.PersistentQueue(meta,count,front,rear,__hash));
});

(cljs.core.PersistentQueue.EMPTY = (new cljs.core.PersistentQueue(null,(0),null,cljs.core.PersistentVector.EMPTY,cljs.core.empty_ordered_hash)));
(cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16756(){
var this__10707__auto__ = this;
return cljs.core.es6_iterator(this__10707__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
*/
cljs.core.NeverEquiv = (function (){
this.cljs$lang$protocol_mask$partition0$ = 2097152;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.NeverEquiv.prototype.equiv = (function cljs$core$fn_16757(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16758(o,other){
var self__ = this;
var o__$1 = this;
return false;
}));

(cljs.core.NeverEquiv.getBasis = (function cljs$core$fn_16759(){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.NeverEquiv.cljs$lang$type = true);

(cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv");

(cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = (function cljs$core$fn_16760(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/NeverEquiv");
}));

/**
 * Positional factory function for cljs.core/NeverEquiv.
 */
cljs.core.__GT_NeverEquiv = (function cljs$core$__GT_NeverEquiv(){
return (new cljs.core.NeverEquiv());
});

cljs.core.never_equiv = (new cljs.core.NeverEquiv());
/**
 * Test map equivalence. Returns true if x equals y, otherwise returns false.
 */
cljs.core.equiv_map = (function cljs$core$equiv_map(x,y){
return cljs.core.boolean$(((((cljs.core.map_QMARK_(y)) && ((!(cljs.core.record_QMARK_(y))))))?(((cljs.core.count(x) === cljs.core.count(y)))?(((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition0$ & (1048576))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IKVReduce$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,x)))?cljs.core.reduce_kv((function cljs$core$equiv_map_$_fn_16762(_,k,v){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,k,cljs.core.never_equiv),v)){
return true;
} else {
return cljs.core.reduced(false);
}
}),true,x):cljs.core.every_QMARK_((function cljs$core$equiv_map_$_fn_16763(xkv){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,cljs.core.first(xkv),cljs.core.never_equiv),cljs.core.second(xkv));
}),x)):null):null));
});
cljs.core.scan_array = (function cljs$core$scan_array(incr,k,array){
var len = array.length;
var i = (0);
while(true){
if((i < len)){
if((k === (array[i]))){
return i;
} else {
var G__16764 = (i + incr);
i = G__16764;
continue;
}
} else {
return null;
}
break;
}
});
cljs.core.obj_map_compare_keys = (function cljs$core$obj_map_compare_keys(a,b){
var a__$1 = cljs.core.hash(a);
var b__$1 = cljs.core.hash(b);
if((a__$1 < b__$1)){
return (-1);
} else {
if((a__$1 > b__$1)){
return (1);
} else {
return (0);

}
}
});
cljs.core.obj_map__GT_hash_map = (function cljs$core$obj_map__GT_hash_map(m,k,v){
var ks = m.keys;
var len = ks.length;
var so = m.strobj;
var mm = cljs.core.meta(m);
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var k__$1 = (ks[i]);
var G__16765 = (i + (1));
var G__16766 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k__$1,cljs.core.goog$module$goog$object.get.call(null,so,k__$1));
i = G__16765;
out = G__16766;
continue;
} else {
return cljs.core._with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k,v)),mm);
}
break;
}
});
cljs.core.obj_clone = (function cljs$core$obj_clone(obj,ks){
var new_obj = ({});
var l = ks.length;
var i_16772 = (0);
while(true){
if((i_16772 < l)){
var k_16773 = (ks[i_16772]);
var G__16769_16774 = new_obj;
var G__16770_16775 = k_16773;
var G__16771_16776 = cljs.core.goog$module$goog$object.get.call(null,obj,k_16773);
cljs.core.goog$module$goog$object.set.call(null,G__16769_16774,G__16770_16775,G__16771_16776);

var G__16777 = (i_16772 + (1));
i_16772 = G__16777;
continue;
} else {
}
break;
}

return new_obj;
});

/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.ObjMap = (function (meta,keys,strobj,update_count,__hash){
this.meta = meta;
this.keys = keys;
this.strobj = strobj;
this.update_count = update_count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 4;
});
(cljs.core.ObjMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.ObjMap.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_16780(coll,k){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return (new cljs.core.MapEntry(k,(self__.strobj[k]),null));
} else {
return null;
}
}));

(cljs.core.ObjMap.prototype.toString = (function cljs$core$fn_16781(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ObjMap.prototype.equiv = (function cljs$core$fn_16782(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16783(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16784(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return (self__.strobj[k]);
} else {
return not_found;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function cljs$core$fn_16785(coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.keys.length;
var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
var init__$1 = init;
while(true){
if(cljs.core.seq(keys__$1)){
var k = cljs.core.first(keys__$1);
var init__$2 = (function (){var G__16786 = init__$1;
var G__16787 = k;
var G__16788 = (self__.strobj[k]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16786,G__16787,G__16788) : f.call(null,G__16786,G__16787,G__16788));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__16809 = cljs.core.rest(keys__$1);
var G__16810 = init__$2;
keys__$1 = G__16809;
init__$1 = G__16810;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16789(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16790(coll){
var self__ = this;
var coll__$1 = this;
return self__.keys.length;
}));

(cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16791(coll){
var self__ = this;
var coll__$1 = this;
var h__9978__auto__ = self__.__hash;
if((!((h__9978__auto__ == null)))){
return h__9978__auto__;
} else {
var h__9978__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__9978__auto____$1);

return h__9978__auto____$1;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16792(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
}));

(cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function cljs$core$fn_16793(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1));
}));

(cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16794(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.ObjMap.EMPTY,self__.meta);
}));

(cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function cljs$core$fn_16795(coll,k){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
var new_keys = cljs.core.aclone(self__.keys);
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
new_keys.splice(cljs.core.scan_array((1),k,new_keys),(1));

delete new_strobj[k];

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
} else {
return coll__$1;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_16796(coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'string'){
if((((self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD)) || ((self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD)))){
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
} else {
if((!((cljs.core.scan_array((1),k,self__.keys) == null)))){
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
cljs.core.goog$module$goog$object.set.call(null,new_strobj,k,v);

return (new cljs.core.ObjMap(self__.meta,self__.keys,new_strobj,(self__.update_count + (1)),null));
} else {
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
var new_keys = cljs.core.aclone(self__.keys);
cljs.core.goog$module$goog$object.set.call(null,new_strobj,k,v);

new_keys.push(k);

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
}
}
} else {
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_16797(coll,k){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return true;
} else {
return false;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16798(coll){
var self__ = this;
var coll__$1 = this;
if((self__.keys.length > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function cljs$core$fn_16798_$_fn_16799(p1__16778_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__16778_SHARP_,(self__.strobj[p1__16778_SHARP_])],null));
}),self__.keys.sort(cljs.core.obj_map_compare_keys));
} else {
return null;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16800(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ObjMap(new_meta,self__.keys,self__.strobj,self__.update_count,self__.__hash));
}
}));

(cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16801(coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,coll__$1,entry);
}
}));

(cljs.core.ObjMap.prototype.call = (function() {
var cljs$core$fn_16802 = null;
var cljs$core$fn_16802__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var cljs$core$fn_16802__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
cljs$core$fn_16802 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_16802__2.call(this,self__,k);
case 3:
return cljs$core$fn_16802__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_16802.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16802__2;
cljs$core$fn_16802.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16802__3;
return cljs$core$fn_16802;
})()
);

(cljs.core.ObjMap.prototype.apply = (function cljs$core$fn_16803(self__,args16779){
var self__ = this;
var self____$1 = this;
var args__10120__auto__ = cljs.core.aclone(args16779);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10120__auto__.length > (20)))?(function (){var G__16804 = args__10120__auto__.slice((0),(20));
G__16804.push(args__10120__auto__.slice((20)));

return G__16804;
})():args__10120__auto__)));
}));

(cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16805(k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16806(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.ObjMap.getBasis = (function cljs$core$fn_16807(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"keys","keys",-1586012071,null),new cljs.core.Symbol(null,"strobj","strobj",1088091283,null),new cljs.core.Symbol(null,"update-count","update-count",-411982269,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ObjMap.cljs$lang$type = true);

(cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap");

(cljs.core.ObjMap.cljs$lang$ctorPrWriter = (function cljs$core$fn_16808(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/ObjMap");
}));

/**
 * Positional factory function for cljs.core/ObjMap.
 */
cljs.core.__GT_ObjMap = (function cljs$core$__GT_ObjMap(meta,keys,strobj,update_count,__hash){
return (new cljs.core.ObjMap(meta,keys,strobj,update_count,__hash));
});

(cljs.core.ObjMap.EMPTY = (new cljs.core.ObjMap(null,[],({}),(0),cljs.core.empty_unordered_hash)));
(cljs.core.ObjMap.HASHMAP_THRESHOLD = (8));
(cljs.core.ObjMap.fromObject = (function cljs$core$fn_16813(ks,obj){
return (new cljs.core.ObjMap(null,ks,obj,(0),null));
}));

/**
* @constructor
*/
cljs.core.RecordIter = (function (i,record,base_count,fields,ext_map_iter){
this.i = i;
this.record = record;
this.base_count = base_count;
this.fields = fields;
this.ext_map_iter = ext_map_iter;
});
(cljs.core.RecordIter.prototype.hasNext = (function cljs$core$fn_16814(){
var self__ = this;
var _ = this;
var or__9517__auto__ = (self__.i < self__.base_count);
if(or__9517__auto__){
return or__9517__auto__;
} else {
return self__.ext_map_iter.hasNext();
}
}));

(cljs.core.RecordIter.prototype.next = (function cljs$core$fn_16815(){
var self__ = this;
var _ = this;
if((self__.i < self__.base_count)){
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.fields,self__.i);
(self__.i = (self__.i + (1)));

return (new cljs.core.MapEntry(k,cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.record,k),null));
} else {
return self__.ext_map_iter.next();
}
}));

(cljs.core.RecordIter.prototype.remove = (function cljs$core$fn_16816(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.RecordIter.getBasis = (function cljs$core$fn_16817(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"record","record",861424668,null),new cljs.core.Symbol(null,"base-count","base-count",-1180647182,null),new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.Symbol(null,"ext-map-iter","ext-map-iter",-1215982757,null)], null);
}));

(cljs.core.RecordIter.cljs$lang$type = true);

(cljs.core.RecordIter.cljs$lang$ctorStr = "cljs.core/RecordIter");

(cljs.core.RecordIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_16818(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/RecordIter");
}));

/**
 * Positional factory function for cljs.core/RecordIter.
 */
cljs.core.__GT_RecordIter = (function cljs$core$__GT_RecordIter(i,record,base_count,fields,ext_map_iter){
return (new cljs.core.RecordIter(i,record,base_count,fields,ext_map_iter));
});


/**
* @constructor
*/
cljs.core.ES6EntriesIterator = (function (s){
this.s = s;
});
(cljs.core.ES6EntriesIterator.prototype.next = (function cljs$core$fn_16819(){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var vec__16820 = cljs.core.first(self__.s);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16820,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16820,(1),null);
(self__.s = cljs.core.next(self__.s));

return ({"value": [k,v], "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6EntriesIterator.getBasis = (function cljs$core$fn_16823(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6EntriesIterator.cljs$lang$type = true);

(cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator");

(cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_16824(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/ES6EntriesIterator");
}));

/**
 * Positional factory function for cljs.core/ES6EntriesIterator.
 */
cljs.core.__GT_ES6EntriesIterator = (function cljs$core$__GT_ES6EntriesIterator(s){
return (new cljs.core.ES6EntriesIterator(s));
});

cljs.core.es6_entries_iterator = (function cljs$core$es6_entries_iterator(coll){
return (new cljs.core.ES6EntriesIterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6SetEntriesIterator = (function (s){
this.s = s;
});
(cljs.core.ES6SetEntriesIterator.prototype.next = (function cljs$core$fn_16825(){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var x = cljs.core.first(self__.s);
(self__.s = cljs.core.next(self__.s));

return ({"value": [x,x], "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6SetEntriesIterator.getBasis = (function cljs$core$fn_16826(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6SetEntriesIterator.cljs$lang$type = true);

(cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator");

(cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_16827(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/ES6SetEntriesIterator");
}));

/**
 * Positional factory function for cljs.core/ES6SetEntriesIterator.
 */
cljs.core.__GT_ES6SetEntriesIterator = (function cljs$core$__GT_ES6SetEntriesIterator(s){
return (new cljs.core.ES6SetEntriesIterator(s));
});

cljs.core.es6_set_entries_iterator = (function cljs$core$es6_set_entries_iterator(coll){
return (new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll)));
});
cljs.core.array_index_of_nil_QMARK_ = (function cljs$core$array_index_of_nil_QMARK_(arr){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((arr[i]) == null)){
return i;
} else {
var G__16828 = (i + (2));
i = G__16828;
continue;

}
}
break;
}
});
cljs.core.array_index_of_keyword_QMARK_ = (function cljs$core$array_index_of_keyword_QMARK_(arr,k){
var len = arr.length;
var kstr = k.fqn;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((((arr[i]) instanceof cljs.core.Keyword)) && ((kstr === (arr[i]).fqn)))){
return i;
} else {
var G__16829 = (i + (2));
i = G__16829;
continue;

}
}
break;
}
});
cljs.core.array_index_of_symbol_QMARK_ = (function cljs$core$array_index_of_symbol_QMARK_(arr,k){
var len = arr.length;
var kstr = k.str;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((((arr[i]) instanceof cljs.core.Symbol)) && ((kstr === (arr[i]).str)))){
return i;
} else {
var G__16830 = (i + (2));
i = G__16830;
continue;

}
}
break;
}
});
cljs.core.array_index_of_identical_QMARK_ = (function cljs$core$array_index_of_identical_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((k === (arr[i]))){
return i;
} else {
var G__16831 = (i + (2));
i = G__16831;
continue;

}
}
break;
}
});
cljs.core.array_index_of_equiv_QMARK_ = (function cljs$core$array_index_of_equiv_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(arr[i]))){
return i;
} else {
var G__16832 = (i + (2));
i = G__16832;
continue;

}
}
break;
}
});
cljs.core.array_index_of = (function cljs$core$array_index_of(arr,k){
if((k instanceof cljs.core.Keyword)){
return cljs.core.array_index_of_keyword_QMARK_(arr,k);
} else {
if(((typeof k === 'string') || (typeof k === 'number'))){
return cljs.core.array_index_of_identical_QMARK_(arr,k);
} else {
if((k instanceof cljs.core.Symbol)){
return cljs.core.array_index_of_symbol_QMARK_(arr,k);
} else {
if((k == null)){
return cljs.core.array_index_of_nil_QMARK_(arr);
} else {
return cljs.core.array_index_of_equiv_QMARK_(arr,k);

}
}
}
}
});
cljs.core.array_map_index_of = (function cljs$core$array_map_index_of(m,k){
return cljs.core.array_index_of(m.arr,k);
});
cljs.core.array_extend_kv = (function cljs$core$array_extend_kv(arr,k,v){
var l = arr.length;
var narr = (new Array((l + (2))));
var i_16833 = (0);
while(true){
if((i_16833 < l)){
(narr[i_16833] = (arr[i_16833]));

var G__16834 = (i_16833 + (1));
i_16833 = G__16834;
continue;
} else {
}
break;
}

(narr[l] = k);

(narr[(l + (1))] = v);

return narr;
});
cljs.core.array_map_extend_kv = (function cljs$core$array_map_extend_kv(m,k,v){
return cljs.core.array_extend_kv(m.arr,k,v);
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.MapEntry = (function (key,val,__hash){
this.key = key;
this.val = val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.MapEntry.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.MapEntry.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_16836(node,k){
var self__ = this;
var node__$1 = this;
var G__16837 = k;
switch (G__16837) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.MapEntry.prototype.indexOf = (function() {
var cljs$core$fn_16838 = null;
var cljs$core$fn_16838__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16838__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16838 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16838__1.call(this,x);
case 2:
return cljs$core$fn_16838__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16838.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16838__1;
cljs$core$fn_16838.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16838__2;
return cljs$core$fn_16838;
})()
);

(cljs.core.MapEntry.prototype.lastIndexOf = (function() {
var cljs$core$fn_16839 = null;
var cljs$core$fn_16839__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16839__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16839 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16839__1.call(this,x);
case 2:
return cljs$core$fn_16839__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16839.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16839__1;
cljs$core$fn_16839.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16839__2;
return cljs$core$fn_16839;
})()
);

(cljs.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16840(node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
}));

(cljs.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16841(node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.MapEntry.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_16842(node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_16843(node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function cljs$core$fn_16844(node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
}));

(cljs.core.MapEntry.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16845(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.MapEntry.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16846(node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.MapEntry.prototype.cljs$core$IMapEntry$_key$arity$1 = (function cljs$core$fn_16847(node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.MapEntry.prototype.cljs$core$IMapEntry$_val$arity$1 = (function cljs$core$fn_16848(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.MapEntry.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_16849(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.MapEntry.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_16850(node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.MapEntry.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_16851(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.MapEntry.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16852(coll){
var self__ = this;
var coll__$1 = this;
var h__9978__auto__ = self__.__hash;
if((!((h__9978__auto__ == null)))){
return h__9978__auto__;
} else {
var h__9978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9978__auto____$1);

return h__9978__auto____$1;
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16853(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.MapEntry.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16854(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.MapEntry.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16855(node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
}));

(cljs.core.MapEntry.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16856(node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
}));

(cljs.core.MapEntry.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_16857(node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.MapEntry.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_16858(node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.MapEntry.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16859(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.MapEntry.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16860(node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.MapEntry.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16861(node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.MapEntry.prototype.call = (function() {
var cljs$core$fn_16862 = null;
var cljs$core$fn_16862__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var cljs$core$fn_16862__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
cljs$core$fn_16862 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_16862__2.call(this,self__,k);
case 3:
return cljs$core$fn_16862__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_16862.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16862__2;
cljs$core$fn_16862.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16862__3;
return cljs$core$fn_16862;
})()
);

(cljs.core.MapEntry.prototype.apply = (function cljs$core$fn_16863(self__,args16835){
var self__ = this;
var self____$1 = this;
var args__10120__auto__ = cljs.core.aclone(args16835);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10120__auto__.length > (20)))?(function (){var G__16864 = args__10120__auto__.slice((0),(20));
G__16864.push(args__10120__auto__.slice((20)));

return G__16864;
})():args__10120__auto__)));
}));

(cljs.core.MapEntry.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16865(k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.MapEntry.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16866(k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.MapEntry.getBasis = (function cljs$core$fn_16867(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.MapEntry.cljs$lang$type = true);

(cljs.core.MapEntry.cljs$lang$ctorStr = "cljs.core/MapEntry");

(cljs.core.MapEntry.cljs$lang$ctorPrWriter = (function cljs$core$fn_16868(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/MapEntry");
}));

/**
 * Positional factory function for cljs.core/MapEntry.
 */
cljs.core.__GT_MapEntry = (function cljs$core$__GT_MapEntry(key,val,__hash){
return (new cljs.core.MapEntry(key,val,__hash));
});

/**
 * Returns true if x satisfies IMapEntry
 */
cljs.core.map_entry_QMARK_ = (function cljs$core$map_entry_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMapEntry$)))){
return true;
} else {
return false;
}
} else {
return false;
}
});

/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMapSeq = (function (arr,i,_meta){
this.arr = arr;
this.i = i;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 262144;
});
(cljs.core.PersistentArrayMapSeq.prototype.toString = (function cljs$core$fn_16871(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentArrayMapSeq.prototype.equiv = (function cljs$core$fn_16872(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentArrayMapSeq.prototype.indexOf = (function() {
var cljs$core$fn_16873 = null;
var cljs$core$fn_16873__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16873__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16873 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16873__1.call(this,x);
case 2:
return cljs$core$fn_16873__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16873.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16873__1;
cljs$core$fn_16873.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16873__2;
return cljs$core$fn_16873;
})()
);

(cljs.core.PersistentArrayMapSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_16874 = null;
var cljs$core$fn_16874__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16874__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16874 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16874__1.call(this,x);
case 2:
return cljs$core$fn_16874__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16874.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16874__1;
cljs$core$fn_16874.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16874__2;
return cljs$core$fn_16874;
})()
);

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16875(coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16876(coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),null));
} else {
return null;
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16877(coll){
var self__ = this;
var coll__$1 = this;
return ((self__.arr.length - self__.i) / (2));
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16878(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16879(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16880(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16881(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16882(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16883(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.MapEntry((self__.arr[self__.i]),(self__.arr[(self__.i + (1))]),null));
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16884(coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16885(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16886(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__._meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentArrayMapSeq(self__.arr,self__.i,new_meta));
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16887(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IDrop$_drop$arity$2 = (function cljs$core$fn_16888(coll,n){
var self__ = this;
var coll__$1 = this;
if((n < coll__$1.cljs$core$ICounted$_count$arity$1(null))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + ((2) * n)),null));
} else {
return null;
}
}));

(cljs.core.PersistentArrayMapSeq.getBasis = (function cljs$core$fn_16889(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.PersistentArrayMapSeq.cljs$lang$type = true);

(cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq");

(cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_16890(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/PersistentArrayMapSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMapSeq.
 */
cljs.core.__GT_PersistentArrayMapSeq = (function cljs$core$__GT_PersistentArrayMapSeq(arr,i,_meta){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
});

(cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16891(){
var this__10707__auto__ = this;
return cljs.core.es6_iterator(this__10707__auto__);
}));
cljs.core.persistent_array_map_seq = (function cljs$core$persistent_array_map_seq(arr,i,_meta){
if((i <= (arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
} else {
return null;
}
});


/**
* @constructor
*/
cljs.core.PersistentArrayMapIterator = (function (arr,i,cnt){
this.arr = arr;
this.i = i;
this.cnt = cnt;
});
(cljs.core.PersistentArrayMapIterator.prototype.hasNext = (function cljs$core$fn_16892(){
var self__ = this;
var _ = this;
return (self__.i < self__.cnt);
}));

(cljs.core.PersistentArrayMapIterator.prototype.next = (function cljs$core$fn_16893(){
var self__ = this;
var _ = this;
var ret = (new cljs.core.MapEntry((self__.arr[self__.i]),(self__.arr[(self__.i + (1))]),null));
(self__.i = (self__.i + (2)));

return ret;
}));

(cljs.core.PersistentArrayMapIterator.getBasis = (function cljs$core$fn_16894(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null)], null);
}));

(cljs.core.PersistentArrayMapIterator.cljs$lang$type = true);

(cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator");

(cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_16895(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/PersistentArrayMapIterator");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMapIterator.
 */
cljs.core.__GT_PersistentArrayMapIterator = (function cljs$core$__GT_PersistentArrayMapIterator(arr,i,cnt){
return (new cljs.core.PersistentArrayMapIterator(arr,i,cnt));
});


/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMap = (function (meta,cnt,arr,__hash){
this.meta = meta;
this.cnt = cnt;
this.arr = arr;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16647951;
this.cljs$lang$protocol_mask$partition1$ = 401412;
});
(cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_16897(coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return null;
} else {
return (new cljs.core.MapEntry((self__.arr[idx]),(self__.arr[(idx + (1))]),null));
}
}));

(cljs.core.PersistentArrayMap.prototype.toString = (function cljs$core$fn_16898(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentArrayMap.prototype.equiv = (function cljs$core$fn_16899(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentArrayMap.prototype.keys = (function cljs$core$fn_16900(){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.keys(coll));
}));

(cljs.core.PersistentArrayMap.prototype.entries = (function cljs$core$fn_16901(){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentArrayMap.prototype.values = (function cljs$core$fn_16902(){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.vals(coll));
}));

(cljs.core.PersistentArrayMap.prototype.has = (function cljs$core$fn_16903(k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
}));

(cljs.core.PersistentArrayMap.prototype.get = (function cljs$core$fn_16904(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentArrayMap.prototype.forEach = (function cljs$core$fn_16905(f){
var self__ = this;
var coll = this;
var seq__16906 = cljs.core.seq(coll);
var chunk__16907 = null;
var count__16908 = (0);
var i__16909 = (0);
while(true){
if((i__16909 < count__16908)){
var vec__16916 = chunk__16907.cljs$core$IIndexed$_nth$arity$2(null,i__16909);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16916,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16916,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__16955 = seq__16906;
var G__16956 = chunk__16907;
var G__16957 = count__16908;
var G__16958 = (i__16909 + (1));
seq__16906 = G__16955;
chunk__16907 = G__16956;
count__16908 = G__16957;
i__16909 = G__16958;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__16906);
if(temp__5720__auto__){
var seq__16906__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__16906__$1)){
var c__10489__auto__ = cljs.core.chunk_first(seq__16906__$1);
var G__16959 = cljs.core.chunk_rest(seq__16906__$1);
var G__16960 = c__10489__auto__;
var G__16961 = cljs.core.count(c__10489__auto__);
var G__16962 = (0);
seq__16906 = G__16959;
chunk__16907 = G__16960;
count__16908 = G__16961;
i__16909 = G__16962;
continue;
} else {
var vec__16919 = cljs.core.first(seq__16906__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16919,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16919,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__16963 = cljs.core.next(seq__16906__$1);
var G__16964 = null;
var G__16965 = (0);
var G__16966 = (0);
seq__16906 = G__16963;
chunk__16907 = G__16964;
count__16908 = G__16965;
i__16909 = G__16966;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16922(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16923(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function cljs$core$fn_16924(coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var G__16925 = init__$1;
var G__16926 = (self__.arr[i]);
var G__16927 = (self__.arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16925,G__16926,G__16927) : f.call(null,G__16925,G__16926,G__16927));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__16967 = (i + (2));
var G__16968 = init__$2;
i = G__16967;
init__$1 = G__16968;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_16928(this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.PersistentArrayMapIterator(self__.arr,(0),(self__.cnt * (2))));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16929(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_16930(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,self__.arr,self__.__hash));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16931(coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16932(coll){
var self__ = this;
var coll__$1 = this;
var h__9978__auto__ = self__.__hash;
if((!((h__9978__auto__ == null)))){
return h__9978__auto__;
} else {
var h__9978__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__9978__auto____$1);

return h__9978__auto____$1;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16933(coll,other){
var self__ = this;
var coll__$1 = this;
if(((cljs.core.map_QMARK_(other)) && ((!(cljs.core.record_QMARK_(other)))))){
var alen = self__.arr.length;
var other__$1 = other;
if((self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null))){
var i = (0);
while(true){
if((i < alen)){
var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null,(self__.arr[i]),cljs.core.lookup_sentinel);
if((!((v === cljs.core.lookup_sentinel)))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(i + (1))]),v)){
var G__16969 = (i + (2));
i = G__16969;
continue;
} else {
return false;
}
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return false;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function cljs$core$fn_16934(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientArrayMap(({}),self__.arr.length,cljs.core.aclone(self__.arr)));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16937(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY,self__.meta);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16938(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16939(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,start);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function cljs$core$fn_16940(coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx >= (0))){
var len = self__.arr.length;
var new_len = (len - (2));
if((new_len === (0))){
return coll__$1.cljs$core$IEmptyableCollection$_empty$arity$1(null);
} else {
var new_arr = (new Array(new_len));
var s = (0);
var d = (0);
while(true){
if((s >= len)){
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt - (1)),new_arr,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(self__.arr[s]))){
var G__16970 = (s + (2));
var G__16971 = d;
s = G__16970;
d = G__16971;
continue;
} else {
(new_arr[d] = (self__.arr[s]));

(new_arr[(d + (1))] = (self__.arr[(s + (1))]));

var G__16972 = (s + (2));
var G__16973 = (d + (2));
s = G__16972;
d = G__16973;
continue;

}
}
break;
}
}
} else {
return coll__$1;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_16941(coll,k,v){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
if((self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr__$1 = cljs.core.array_map_extend_kv(coll__$1,k,v);
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt + (1)),arr__$1,null));
} else {
return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1),k,v),self__.meta);
}
} else {
if((v === (self__.arr[(idx + (1))]))){
return coll__$1;
} else {
var arr__$1 = (function (){var G__16942 = cljs.core.aclone(self__.arr);
(G__16942[(idx + (1))] = v);

return G__16942;
})();
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,arr__$1,null));

}
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_16943(coll,k){
var self__ = this;
var coll__$1 = this;
return (!((cljs.core.array_map_index_of(coll__$1,k) === (-1))));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16944(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.persistent_array_map_seq(self__.arr,(0),null);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16945(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentArrayMap(new_meta,self__.cnt,self__.arr,self__.__hash));
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16946(coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__16974 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__16975 = cljs.core.next(es);
ret = G__16974;
es = G__16975;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
}));

(cljs.core.PersistentArrayMap.prototype.call = (function() {
var cljs$core$fn_16947 = null;
var cljs$core$fn_16947__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var cljs$core$fn_16947__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
cljs$core$fn_16947 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_16947__2.call(this,self__,k);
case 3:
return cljs$core$fn_16947__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_16947.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16947__2;
cljs$core$fn_16947.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16947__3;
return cljs$core$fn_16947;
})()
);

(cljs.core.PersistentArrayMap.prototype.apply = (function cljs$core$fn_16948(self__,args16896){
var self__ = this;
var self____$1 = this;
var args__10120__auto__ = cljs.core.aclone(args16896);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10120__auto__.length > (20)))?(function (){var G__16949 = args__10120__auto__.slice((0),(20));
G__16949.push(args__10120__auto__.slice((20)));

return G__16949;
})():args__10120__auto__)));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16950(k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16951(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IDrop$_drop$arity$2 = (function cljs$core$fn_16952(coll,n){
var self__ = this;
var coll__$1 = this;
var temp__5724__auto__ = coll__$1.cljs$core$ISeqable$_seq$arity$1(null);
if((temp__5724__auto__ == null)){
return null;
} else {
var s = temp__5724__auto__;
return cljs.core._drop(s,n);
}
}));

(cljs.core.PersistentArrayMap.getBasis = (function cljs$core$fn_16953(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentArrayMap.cljs$lang$type = true);

(cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap");

(cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = (function cljs$core$fn_16954(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/PersistentArrayMap");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMap.
 */
cljs.core.__GT_PersistentArrayMap = (function cljs$core$__GT_PersistentArrayMap(meta,cnt,arr,__hash){
return (new cljs.core.PersistentArrayMap(meta,cnt,arr,__hash));
});

(cljs.core.PersistentArrayMap.EMPTY = (new cljs.core.PersistentArrayMap(null,(0),[],cljs.core.empty_unordered_hash)));
(cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = (8));
(cljs.core.PersistentArrayMap.fromArray = (function cljs$core$fn_16976(arr,no_clone,no_check){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var arr__$2 = ((no_check)?arr__$1:(function (){var ret = [];
var i_16977 = (0);
while(true){
if((i_16977 < arr__$1.length)){
var k_16978 = (arr__$1[i_16977]);
var v_16979 = (arr__$1[(i_16977 + (1))]);
var idx_16980 = cljs.core.array_index_of(ret,k_16978);
if((idx_16980 === (-1))){
ret.push(k_16978);

ret.push(v_16979);
} else {
}

var G__16981 = (i_16977 + (2));
i_16977 = G__16981;
continue;
} else {
}
break;
}

return ret;
})());
var cnt = (arr__$2.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr__$2,null));
}));
(cljs.core.PersistentArrayMap.createWithCheck = (function cljs$core$fn_16982(arr){
var ret = [];
var i_16984 = (0);
while(true){
if((i_16984 < arr.length)){
var k_16985 = (arr[i_16984]);
var v_16986 = (arr[(i_16984 + (1))]);
var idx_16987 = cljs.core.array_index_of(ret,k_16985);
if((idx_16987 === (-1))){
var G__16983_16988 = ret;
G__16983_16988.push(k_16985);

G__16983_16988.push(v_16986);

} else {
throw (new Error(["Duplicate key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k_16985)].join('')));
}

var G__16989 = (i_16984 + (2));
i_16984 = G__16989;
continue;
} else {
}
break;
}

var cnt = (arr.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr,null));
}));
cljs.core.key_test = (function cljs$core$key_test(key,other){
if((key === other)){
return true;
} else {
if(cljs.core.keyword_identical_QMARK_(key,other)){
return true;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,other);

}
}
});
cljs.core.pam_dupes_QMARK_ = (function cljs$core$pam_dupes_QMARK_(arr){
var i = (0);
while(true){
if((i < arr.length)){
var dupe_QMARK_ = (function (){var j = (0);
while(true){
if((j < i)){
var or__9517__auto__ = cljs.core.key_test((arr[i]),(arr[j]));
if(or__9517__auto__){
return or__9517__auto__;
} else {
var G__16990 = ((2) + j);
j = G__16990;
continue;
}
} else {
return false;
}
break;
}
})();
var or__9517__auto__ = dupe_QMARK_;
if(or__9517__auto__){
return or__9517__auto__;
} else {
var G__16991 = ((2) + i);
i = G__16991;
continue;
}
} else {
return false;
}
break;
}
});
cljs.core.pam_new_size = (function cljs$core$pam_new_size(arr){
var i = (0);
var n = (0);
while(true){
if((i < arr.length)){
var dupe_QMARK_ = (function (){var j = (0);
while(true){
if((j < i)){
var or__9517__auto__ = cljs.core.key_test((arr[i]),(arr[j]));
if(or__9517__auto__){
return or__9517__auto__;
} else {
var G__16992 = ((2) + j);
j = G__16992;
continue;
}
} else {
return false;
}
break;
}
})();
var G__16993 = ((2) + i);
var G__16994 = ((dupe_QMARK_)?n:(n + (2)));
i = G__16993;
n = G__16994;
continue;
} else {
return n;
}
break;
}
});
cljs.core.pam_grow_seed_array = (function cljs$core$pam_grow_seed_array(seed,trailing){
var seed_cnt = (seed.length - (1));
var extra_kvs = cljs.core.seq(trailing);
var ret = (new Array((seed_cnt + ((2) * cljs.core.count(extra_kvs)))));
var ret__$1 = cljs.core.array_copy(seed,(0),ret,(0),seed_cnt);
var i = seed_cnt;
var extra_kvs__$1 = extra_kvs;
while(true){
if(extra_kvs__$1){
var kv = cljs.core.first(extra_kvs__$1);
(ret__$1[i] = cljs.core._key(kv));

(ret__$1[(i + (1))] = cljs.core._val(kv));

var G__16995 = ((2) + seed_cnt);
var G__16996 = cljs.core.next(extra_kvs__$1);
i = G__16995;
extra_kvs__$1 = G__16996;
continue;
} else {
return ret__$1;
}
break;
}
});
(cljs.core.PersistentArrayMap.createAsIfByAssoc = (function cljs$core$fn_16997(init){
var len = init.length;
var has_trailing_QMARK_ = ((1) === (len & (1)));
if((!(((has_trailing_QMARK_) || (cljs.core.pam_dupes_QMARK_(init)))))){
return (new cljs.core.PersistentArrayMap(null,(len / (2)),init,null));
} else {
return cljs.core.PersistentArrayMap.createAsIfByAssocComplexPath(init,has_trailing_QMARK_);
}
}));
(cljs.core.PersistentArrayMap.createAsIfByAssocComplexPath = (function cljs$core$fn_16998(init,has_trailing_QMARK_){
var init__$1 = ((has_trailing_QMARK_)?cljs.core.pam_grow_seed_array(init,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(init[(init.length - (1))]))):init);
var n = cljs.core.pam_new_size(init__$1);
var len = init__$1.length;
if((n < len)){
var nodups = (new Array(n));
var i_16999 = (0);
var m_17000 = (0);
while(true){
if((i_16999 < len)){
var dupe_QMARK__17001 = (function (){var j = (0);
while(true){
if((j < m_17000)){
var or__9517__auto__ = cljs.core.key_test((init__$1[i_16999]),(init__$1[j]));
if(or__9517__auto__){
return or__9517__auto__;
} else {
var G__17002 = ((2) + j);
j = G__17002;
continue;
}
} else {
return false;
}
break;
}
})();
if((!(dupe_QMARK__17001))){
var j_17003 = (function (){var j_17003 = (len - (2));
while(true){
if((j_17003 >= i_16999)){
if(cljs.core.key_test((init__$1[i_16999]),(init__$1[j_17003]))){
return j_17003;
} else {
var G__17004 = (j_17003 - (2));
j_17003 = G__17004;
continue;
}
} else {
return j_17003;
}
break;
}
})();
(nodups[m_17000] = (init__$1[i_16999]));

(nodups[(m_17000 + (1))] = (init__$1[(j_17003 + (1))]));

var G__17005 = ((2) + i_16999);
var G__17006 = ((2) + m_17000);
i_16999 = G__17005;
m_17000 = G__17006;
continue;
} else {
var G__17007 = ((2) + i_16999);
var G__17008 = m_17000;
i_16999 = G__17007;
m_17000 = G__17008;
continue;
}
} else {
}
break;
}

return (new cljs.core.PersistentArrayMap(null,(nodups.length / (2)),nodups,null));
} else {
return (new cljs.core.PersistentArrayMap(null,(init__$1.length / (2)),init__$1,null));
}
}));
(cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17009(){
var this__10707__auto__ = this;
return cljs.core.es6_iterator(this__10707__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientArrayMap = (function (editable_QMARK_,len,arr){
this.editable_QMARK_ = editable_QMARK_;
this.len = len;
this.arr = arr;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 56;
});
(cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17011(tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
return cljs.core.quot(self__.len,(2));
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_17012(tcoll,k){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_17013(tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of(tcoll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
} else {
throw (new Error("lookup after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function cljs$core$fn_17014(tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
if(cljs.core.map_entry_QMARK_(o)){
return tcoll__$1.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,cljs.core.key(o),cljs.core.val(o));
} else {
if(cljs.core.vector_QMARK_(o)){
return tcoll__$1.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((0)) : o.call(null,(0))),(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((1)) : o.call(null,(1))));
} else {
var es = cljs.core.seq(o);
var tcoll__$2 = tcoll__$1;
while(true){
var temp__5718__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__5718__auto__)){
var e = temp__5718__auto__;
var G__17026 = cljs.core.next(es);
var G__17027 = cljs.core._assoc_BANG_(tcoll__$2,cljs.core.key(e),cljs.core.val(e));
es = G__17026;
tcoll__$2 = G__17027;
continue;
} else {
return tcoll__$2;
}
break;
}

}
}
} else {
throw (new Error("conj! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function cljs$core$fn_17015(tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
(self__.editable_QMARK_ = false);

return (new cljs.core.PersistentArrayMap(null,cljs.core.quot(self__.len,(2)),self__.arr,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function cljs$core$fn_17016(tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx === (-1))){
if(((self__.len + (2)) <= ((2) * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD))){
(self__.len = (self__.len + (2)));

self__.arr.push(key);

self__.arr.push(val);

return tcoll__$1;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.array__GT_transient_hash_map(self__.len,self__.arr),key,val);
}
} else {
if((val === (self__.arr[(idx + (1))]))){
return tcoll__$1;
} else {
(self__.arr[(idx + (1))] = val);

return tcoll__$1;
}
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function cljs$core$fn_17017(tcoll,key){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx >= (0))){
(self__.arr[idx] = (self__.arr[(self__.len - (2))]));

(self__.arr[(idx + (1))] = (self__.arr[(self__.len - (1))]));

var G__17018_17028 = self__.arr;
G__17018_17028.pop();

G__17018_17028.pop();


(self__.len = (self__.len - (2)));
} else {
}

return tcoll__$1;
} else {
throw (new Error("dissoc! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.call = (function() {
var cljs$core$fn_17019 = null;
var cljs$core$fn_17019__2 = (function (self__,key){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,null);
});
var cljs$core$fn_17019__3 = (function (self__,key,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
});
cljs$core$fn_17019 = function(self__,key,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_17019__2.call(this,self__,key);
case 3:
return cljs$core$fn_17019__3.call(this,self__,key,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_17019.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17019__2;
cljs$core$fn_17019.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_17019__3;
return cljs$core$fn_17019;
})()
);

(cljs.core.TransientArrayMap.prototype.apply = (function cljs$core$fn_17020(self__,args17010){
var self__ = this;
var self____$1 = this;
var args__10120__auto__ = cljs.core.aclone(args17010);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10120__auto__.length > (20)))?(function (){var G__17021 = args__10120__auto__.slice((0),(20));
G__17021.push(args__10120__auto__.slice((20)));

return G__17021;
})():args__10120__auto__)));
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17022(key){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,null);
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_17023(key,not_found){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
}));

(cljs.core.TransientArrayMap.getBasis = (function cljs$core$fn_17024(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"editable?","editable?",-164945806,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"len","len",-1230778691,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null);
}));

(cljs.core.TransientArrayMap.cljs$lang$type = true);

(cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap");

(cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = (function cljs$core$fn_17025(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/TransientArrayMap");
}));

/**
 * Positional factory function for cljs.core/TransientArrayMap.
 */
cljs.core.__GT_TransientArrayMap = (function cljs$core$__GT_TransientArrayMap(editable_QMARK_,len,arr){
return (new cljs.core.TransientArrayMap(editable_QMARK_,len,arr));
});

cljs.core.array__GT_transient_hash_map = (function cljs$core$array__GT_transient_hash_map(len,arr){
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i = (0);
while(true){
if((i < len)){
var G__17029 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,(arr[i]),(arr[(i + (1))]));
var G__17030 = (i + (2));
out = G__17029;
i = G__17030;
continue;
} else {
return out;
}
break;
}
});

/**
* @constructor
*/
cljs.core.Box = (function (val){
this.val = val;
});

(cljs.core.Box.getBasis = (function cljs$core$fn_17031(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Box.cljs$lang$type = true);

(cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box");

(cljs.core.Box.cljs$lang$ctorPrWriter = (function cljs$core$fn_17032(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/Box");
}));

/**
 * Positional factory function for cljs.core/Box.
 */
cljs.core.__GT_Box = (function cljs$core$__GT_Box(val){
return (new cljs.core.Box(val));
});



cljs.core.mask = (function cljs$core$mask(hash,shift){
return ((hash >>> shift) & (31));
});
cljs.core.clone_and_set = (function cljs$core$clone_and_set(var_args){
var G__17034 = arguments.length;
switch (G__17034) {
case 3:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_17035(arr,i,a){
var G__17036 = cljs.core.aclone(arr);
(G__17036[i] = a);

return G__17036;
}));

(cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_17037(arr,i,a,j,b){
var G__17038 = cljs.core.aclone(arr);
(G__17038[i] = a);

(G__17038[j] = b);

return G__17038;
}));

(cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5);

cljs.core.remove_pair = (function cljs$core$remove_pair(arr,i){
var new_arr = (new Array((arr.length - (2))));
cljs.core.array_copy(arr,(0),new_arr,(0),((2) * i));

cljs.core.array_copy(arr,((2) * (i + (1))),new_arr,((2) * i),(new_arr.length - ((2) * i)));

return new_arr;
});
cljs.core.bitmap_indexed_node_index = (function cljs$core$bitmap_indexed_node_index(bitmap,bit){
return cljs.core.bit_count((bitmap & (bit - (1))));
});
cljs.core.bitpos = (function cljs$core$bitpos(hash,shift){
return ((1) << ((hash >>> shift) & 0x01f));
});
cljs.core.edit_and_set = (function cljs$core$edit_and_set(var_args){
var G__17041 = arguments.length;
switch (G__17041) {
case 4:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_17042(inode,edit,i,a){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

return editable;
}));

(cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_17043(inode,edit,i,a,j,b){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

(editable.arr[j] = b);

return editable;
}));

(cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6);

cljs.core.inode_kv_reduce = (function cljs$core$inode_kv_reduce(arr,f,init){
var len = arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var k = (arr[i]);
if((!((k == null)))){
var G__17045 = init__$1;
var G__17046 = k;
var G__17047 = (arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17045,G__17046,G__17047) : f.call(null,G__17045,G__17046,G__17047));
} else {
var node = (arr[(i + (1))]);
if((!((node == null)))){
return node.kv_reduce(f,init__$1);
} else {
return init__$1;
}
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
var G__17048 = (i + (2));
var G__17049 = init__$2;
i = G__17048;
init__$1 = G__17049;
continue;
}
} else {
return init__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.NodeIterator = (function (arr,i,next_entry,next_iter){
this.arr = arr;
this.i = i;
this.next_entry = next_entry;
this.next_iter = next_iter;
});
(cljs.core.NodeIterator.prototype.advance = (function cljs$core$fn_17050(){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if((self__.i < len)){
var key = (self__.arr[self__.i]);
var node_or_val = (self__.arr[(self__.i + (1))]);
var found = (((!((key == null))))?(self__.next_entry = (new cljs.core.MapEntry(key,node_or_val,null))):(((!((node_or_val == null))))?(function (){var new_iter = cljs.core._iterator(node_or_val);
if(new_iter.hasNext()){
return (self__.next_iter = new_iter);
} else {
return false;
}
})():false
));
(self__.i = (self__.i + (2)));

if(found){
return true;
} else {
continue;
}
} else {
return false;
}
break;
}
}));

(cljs.core.NodeIterator.prototype.hasNext = (function cljs$core$fn_17051(){
var self__ = this;
var this$ = this;
var or__9517__auto__ = (!((self__.next_entry == null)));
if(or__9517__auto__){
return or__9517__auto__;
} else {
var or__9517__auto____$1 = (!((self__.next_iter == null)));
if(or__9517__auto____$1){
return or__9517__auto____$1;
} else {
return this$.advance();
}
}
}));

(cljs.core.NodeIterator.prototype.next = (function cljs$core$fn_17052(){
var self__ = this;
var this$ = this;
if((!((self__.next_entry == null)))){
var ret = self__.next_entry;
(self__.next_entry = null);

return ret;
} else {
if((!((self__.next_iter == null)))){
var ret = self__.next_iter.next();
if(self__.next_iter.hasNext()){
} else {
(self__.next_iter = null);
}

return ret;
} else {
if(this$.advance()){
return this$.next();
} else {
throw (new Error("No such element"));

}
}
}
}));

(cljs.core.NodeIterator.prototype.remove = (function cljs$core$fn_17053(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.NodeIterator.getBasis = (function cljs$core$fn_17054(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-entry","next-entry",1091342476,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-iter","next-iter",1526626239,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.NodeIterator.cljs$lang$type = true);

(cljs.core.NodeIterator.cljs$lang$ctorStr = "cljs.core/NodeIterator");

(cljs.core.NodeIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_17055(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/NodeIterator");
}));

/**
 * Positional factory function for cljs.core/NodeIterator.
 */
cljs.core.__GT_NodeIterator = (function cljs$core$__GT_NodeIterator(arr,i,next_entry,next_iter){
return (new cljs.core.NodeIterator(arr,i,next_entry,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.BitmapIndexedNode = (function (edit,bitmap,arr){
this.edit = edit;
this.bitmap = bitmap;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.BitmapIndexedNode.prototype.ensure_editable = (function cljs$core$fn_17056(e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var n = cljs.core.bit_count(self__.bitmap);
var new_arr = (new Array((((n < (0)))?(4):((2) * (n + (1))))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * n));

return (new cljs.core.BitmapIndexedNode(e,self__.bitmap,new_arr));
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = (function cljs$core$fn_17057(edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
if((!((n == null)))){
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
} else {
if((self__.bitmap === bit)){
return null;
} else {
return inode.edit_and_remove_pair(edit__$1,bit,idx);

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
(removed_leaf_QMARK_.val = true);

return inode.edit_and_remove_pair(edit__$1,bit,idx);
} else {
return inode;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = (function cljs$core$fn_17058(e,bit,i){
var self__ = this;
var inode = this;
if((self__.bitmap === bit)){
return null;
} else {
var editable = inode.ensure_editable(e);
var earr = editable.arr;
var len = earr.length;
(editable.bitmap = (bit ^ editable.bitmap));

cljs.core.array_copy(earr,((2) * (i + (1))),earr,((2) * i),(len - ((2) * (i + (1)))));

(earr[(len - (2))] = null);

(earr[(len - (1))] = null);

return editable;
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_seq = (function cljs$core$fn_17059(){
var self__ = this;
var inode = this;
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr);
}));

(cljs.core.BitmapIndexedNode.prototype.kv_reduce = (function cljs$core$fn_17060(f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
}));

(cljs.core.BitmapIndexedNode.prototype.inode_lookup = (function cljs$core$fn_17061(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return val_or_node;
} else {
return not_found;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = (function cljs$core$fn_17062(edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((((2) * n) < self__.arr.length)){
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(added_leaf_QMARK_.val = true);

cljs.core.array_copy_downward(earr,((2) * idx),earr,((2) * (idx + (1))),((2) * (n - idx)));

(earr[((2) * idx)] = key);

(earr[(((2) * idx) + (1))] = val);

(editable.bitmap = (editable.bitmap | bit));

return editable;
} else {
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_17069 = (0);
var j_17070 = (0);
while(true){
if((i_17069 < (32))){
if((((self__.bitmap >>> i_17069) & (1)) === (0))){
var G__17071 = (i_17069 + (1));
var G__17072 = j_17070;
i_17069 = G__17071;
j_17070 = G__17072;
continue;
} else {
(nodes[i_17069] = (((!(((self__.arr[j_17070]) == null))))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),cljs.core.hash((self__.arr[j_17070])),(self__.arr[j_17070]),(self__.arr[(j_17070 + (1))]),added_leaf_QMARK_):(self__.arr[(j_17070 + (1))])));

var G__17073 = (i_17069 + (1));
var G__17074 = (j_17070 + (2));
i_17069 = G__17073;
j_17070 = G__17074;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(edit__$1,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (4)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

(added_leaf_QMARK_.val = true);

var editable = inode.ensure_editable(edit__$1);
(editable.arr = new_arr);

(editable.bitmap = (editable.bitmap | bit));

return editable;

}
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),val);
}
} else {
(added_leaf_QMARK_.val = true);

return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * idx),null,(((2) * idx) + (1)),cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(edit__$1,(shift + (5)),key_or_nil,val_or_node,hash,key,val));

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_assoc = (function cljs$core$fn_17063(shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_17075 = (0);
var j_17076 = (0);
while(true){
if((i_17075 < (32))){
if((((self__.bitmap >>> i_17075) & (1)) === (0))){
var G__17077 = (i_17075 + (1));
var G__17078 = j_17076;
i_17075 = G__17077;
j_17076 = G__17078;
continue;
} else {
(nodes[i_17075] = (((!(((self__.arr[j_17076]) == null))))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),cljs.core.hash((self__.arr[j_17076])),(self__.arr[j_17076]),(self__.arr[(j_17076 + (1))]),added_leaf_QMARK_):(self__.arr[(j_17076 + (1))])));

var G__17079 = (i_17075 + (1));
var G__17080 = (j_17076 + (2));
i_17075 = G__17079;
j_17076 = G__17080;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(null,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

(added_leaf_QMARK_.val = true);

return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap | bit),new_arr));
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),val)));
}
} else {
(added_leaf_QMARK_.val = true);

return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr,((2) * idx),null,(((2) * idx) + (1)),cljs.core.create_node.cljs$core$IFn$_invoke$arity$6((shift + (5)),key_or_nil,val_or_node,hash,key,val))));

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_find = (function cljs$core$fn_17064(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_find((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return (new cljs.core.MapEntry(key_or_nil,val_or_node,null));
} else {
return not_found;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_without = (function cljs$core$fn_17065(shift,hash,key){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without((shift + (5)),hash,key);
if((n === val_or_node)){
return inode;
} else {
if((!((n == null)))){
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
} else {
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));
}
} else {
return inode;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_17066(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
}));

(cljs.core.BitmapIndexedNode.getBasis = (function cljs$core$fn_17067(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"bitmap","bitmap",501334601,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.BitmapIndexedNode.cljs$lang$type = true);

(cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode");

(cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_17068(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/BitmapIndexedNode");
}));

/**
 * Positional factory function for cljs.core/BitmapIndexedNode.
 */
cljs.core.__GT_BitmapIndexedNode = (function cljs$core$__GT_BitmapIndexedNode(edit,bitmap,arr){
return (new cljs.core.BitmapIndexedNode(edit,bitmap,arr));
});

(cljs.core.BitmapIndexedNode.EMPTY = (new cljs.core.BitmapIndexedNode(null,(0),[])));
cljs.core.pack_array_node = (function cljs$core$pack_array_node(array_node,edit,idx){
var arr = array_node.arr;
var len = arr.length;
var new_arr = (new Array(((2) * (array_node.cnt - (1)))));
var i = (0);
var j = (1);
var bitmap = (0);
while(true){
if((i < len)){
if((((!((i === idx)))) && ((!(((arr[i]) == null)))))){
(new_arr[j] = (arr[i]));

var G__17081 = (i + (1));
var G__17082 = (j + (2));
var G__17083 = (bitmap | ((1) << i));
i = G__17081;
j = G__17082;
bitmap = G__17083;
continue;
} else {
var G__17084 = (i + (1));
var G__17085 = j;
var G__17086 = bitmap;
i = G__17084;
j = G__17085;
bitmap = G__17086;
continue;
}
} else {
return (new cljs.core.BitmapIndexedNode(edit,bitmap,new_arr));
}
break;
}
});

/**
* @constructor
*/
cljs.core.ArrayNodeIterator = (function (arr,i,next_iter){
this.arr = arr;
this.i = i;
this.next_iter = next_iter;
});
(cljs.core.ArrayNodeIterator.prototype.hasNext = (function cljs$core$fn_17087(){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if((!((((!((self__.next_iter == null)))) && (self__.next_iter.hasNext()))))){
if((self__.i < len)){
var node = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

if((!((node == null)))){
(self__.next_iter = cljs.core._iterator(node));
} else {
}

continue;
} else {
return false;
}
} else {
return true;
}
break;
}
}));

(cljs.core.ArrayNodeIterator.prototype.next = (function cljs$core$fn_17088(){
var self__ = this;
var this$ = this;
if(this$.hasNext()){
return self__.next_iter.next();
} else {
throw (new Error("No such element"));
}
}));

(cljs.core.ArrayNodeIterator.prototype.remove = (function cljs$core$fn_17089(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.ArrayNodeIterator.getBasis = (function cljs$core$fn_17090(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-iter","next-iter",1526626239,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayNodeIterator.cljs$lang$type = true);

(cljs.core.ArrayNodeIterator.cljs$lang$ctorStr = "cljs.core/ArrayNodeIterator");

(cljs.core.ArrayNodeIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_17091(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/ArrayNodeIterator");
}));

/**
 * Positional factory function for cljs.core/ArrayNodeIterator.
 */
cljs.core.__GT_ArrayNodeIterator = (function cljs$core$__GT_ArrayNodeIterator(arr,i,next_iter){
return (new cljs.core.ArrayNodeIterator(arr,i,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.ArrayNode = (function (edit,cnt,arr){
this.edit = edit;
this.cnt = cnt;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.ArrayNode.prototype.ensure_editable = (function cljs$core$fn_17092(e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
return (new cljs.core.ArrayNode(e,self__.cnt,cljs.core.aclone(self__.arr)));
}
}));

(cljs.core.ArrayNode.prototype.inode_without_BANG_ = (function cljs$core$fn_17093(edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return inode;
} else {
var n = node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,edit__$1,idx);
} else {
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
(editable.cnt = (editable.cnt - (1)));

return editable;
}
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);

}
}
}
}));

(cljs.core.ArrayNode.prototype.inode_seq = (function cljs$core$fn_17094(){
var self__ = this;
var inode = this;
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(self__.arr);
}));

(cljs.core.ArrayNode.prototype.kv_reduce = (function cljs$core$fn_17095(f,init){
var self__ = this;
var inode = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var node = (self__.arr[i]);
if((!((node == null)))){
var init__$2 = node.kv_reduce(f,init__$1);
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
var G__17104 = (i + (1));
var G__17105 = init__$2;
i = G__17104;
init__$1 = G__17105;
continue;
}
} else {
var G__17106 = (i + (1));
var G__17107 = init__$1;
i = G__17106;
init__$1 = G__17107;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.ArrayNode.prototype.inode_lookup = (function cljs$core$fn_17096(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
return node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
}));

(cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = (function cljs$core$fn_17097(edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));
(editable.cnt = (editable.cnt + (1)));

return editable;
} else {
var n = node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
}
}
}));

(cljs.core.ArrayNode.prototype.inode_assoc = (function cljs$core$fn_17098(shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return (new cljs.core.ArrayNode(null,(self__.cnt + (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_))));
} else {
var n = node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
}
}));

(cljs.core.ArrayNode.prototype.inode_find = (function cljs$core$fn_17099(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
return node.inode_find((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
}));

(cljs.core.ArrayNode.prototype.inode_without = (function cljs$core$fn_17100(shift,hash,key){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
var n = node.inode_without((shift + (5)),hash,key);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,null,idx);
} else {
return (new cljs.core.ArrayNode(null,(self__.cnt - (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));

}
}
} else {
return inode;
}
}));

(cljs.core.ArrayNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_17101(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeIterator(self__.arr,(0),null));
}));

(cljs.core.ArrayNode.getBasis = (function cljs$core$fn_17102(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayNode.cljs$lang$type = true);

(cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode");

(cljs.core.ArrayNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_17103(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/ArrayNode");
}));

/**
 * Positional factory function for cljs.core/ArrayNode.
 */
cljs.core.__GT_ArrayNode = (function cljs$core$__GT_ArrayNode(edit,cnt,arr){
return (new cljs.core.ArrayNode(edit,cnt,arr));
});

cljs.core.hash_collision_node_find_index = (function cljs$core$hash_collision_node_find_index(arr,cnt,key){
var lim = ((2) * cnt);
var i = (0);
while(true){
if((i < lim)){
if(cljs.core.key_test(key,(arr[i]))){
return i;
} else {
var G__17108 = (i + (2));
i = G__17108;
continue;
}
} else {
return (-1);
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.HashCollisionNode = (function (edit,collision_hash,cnt,arr){
this.edit = edit;
this.collision_hash = collision_hash;
this.cnt = cnt;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.HashCollisionNode.prototype.ensure_editable = (function cljs$core$fn_17109(e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var new_arr = (new Array(((2) * (self__.cnt + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * self__.cnt));

return (new cljs.core.HashCollisionNode(e,self__.collision_hash,self__.cnt,new_arr));
}
}));

(cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = (function cljs$core$fn_17110(edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
(removed_leaf_QMARK_.val = true);

if((self__.cnt === (1))){
return null;
} else {
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(earr[idx] = (earr[(((2) * self__.cnt) - (2))]));

(earr[(idx + (1))] = (earr[(((2) * self__.cnt) - (1))]));

(earr[(((2) * self__.cnt) - (1))] = null);

(earr[(((2) * self__.cnt) - (2))] = null);

(editable.cnt = (editable.cnt - (1)));

return editable;
}
}
}));

(cljs.core.HashCollisionNode.prototype.inode_seq = (function cljs$core$fn_17111(){
var self__ = this;
var inode = this;
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr);
}));

(cljs.core.HashCollisionNode.prototype.kv_reduce = (function cljs$core$fn_17112(f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
}));

(cljs.core.HashCollisionNode.prototype.inode_lookup = (function cljs$core$fn_17113(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (self__.arr[(idx + (1))]);
} else {
return not_found;

}
}
}));

(cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = (function cljs$core$fn_17114(edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
if((self__.arr.length > ((2) * self__.cnt))){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * self__.cnt),key,(((2) * self__.cnt) + (1)),val);
(added_leaf_QMARK_.val = true);

(editable.cnt = (editable.cnt + (1)));

return editable;
} else {
var len = self__.arr.length;
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

(added_leaf_QMARK_.val = true);

return inode.ensure_editable_array(edit__$1,(self__.cnt + (1)),new_arr);
}
} else {
if(((self__.arr[(idx + (1))]) === val)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(idx + (1)),val);
}
}
} else {
return (new cljs.core.BitmapIndexedNode(edit__$1,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode,null,null])).inode_assoc_BANG_(edit__$1,shift,hash,key,val,added_leaf_QMARK_);
}
}));

(cljs.core.HashCollisionNode.prototype.inode_assoc = (function cljs$core$fn_17115(shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
var len = ((2) * self__.cnt);
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

(added_leaf_QMARK_.val = true);

return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt + (1)),new_arr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(idx + (1))]),val)){
return inode;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(idx + (1)),val)));
}
}
} else {
return (new cljs.core.BitmapIndexedNode(null,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode])).inode_assoc(shift,hash,key,val,added_leaf_QMARK_);
}
}));

(cljs.core.HashCollisionNode.prototype.ensure_editable_array = (function cljs$core$fn_17116(e,count,array){
var self__ = this;
var inode = this;
if((e === self__.edit)){
(self__.arr = array);

(self__.cnt = count);

return inode;
} else {
return (new cljs.core.HashCollisionNode(self__.edit,self__.collision_hash,count,array));
}
}));

(cljs.core.HashCollisionNode.prototype.inode_find = (function cljs$core$fn_17117(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (new cljs.core.MapEntry((self__.arr[idx]),(self__.arr[(idx + (1))]),null));
} else {
return not_found;

}
}
}));

(cljs.core.HashCollisionNode.prototype.inode_without = (function cljs$core$fn_17118(shift,hash,key){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
if((self__.cnt === (1))){
return null;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt - (1)),cljs.core.remove_pair(self__.arr,cljs.core.quot(idx,(2)))));

}
}
}));

(cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_17119(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
}));

(cljs.core.HashCollisionNode.getBasis = (function cljs$core$fn_17120(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"collision-hash","collision-hash",-35831342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.HashCollisionNode.cljs$lang$type = true);

(cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode");

(cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_17121(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/HashCollisionNode");
}));

/**
 * Positional factory function for cljs.core/HashCollisionNode.
 */
cljs.core.__GT_HashCollisionNode = (function cljs$core$__GT_HashCollisionNode(edit,collision_hash,cnt,arr){
return (new cljs.core.HashCollisionNode(edit,collision_hash,cnt,arr));
});

cljs.core.create_node = (function cljs$core$create_node(var_args){
var G__17123 = arguments.length;
switch (G__17123) {
case 6:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_17124(shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc(shift,key2hash,key2,val2,added_leaf_QMARK_);
}
}));

(cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = (function cljs$core$fn_17125(edit,shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc_BANG_(edit,shift,key2hash,key2,val2,added_leaf_QMARK_);
}
}));

(cljs.core.create_node.cljs$lang$maxFixedArity = 7);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.NodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.NodeSeq.prototype.toString = (function cljs$core$fn_17127(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.NodeSeq.prototype.equiv = (function cljs$core$fn_17128(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.NodeSeq.prototype.indexOf = (function() {
var cljs$core$fn_17129 = null;
var cljs$core$fn_17129__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_17129__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17129 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17129__1.call(this,x);
case 2:
return cljs$core$fn_17129__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17129.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17129__1;
cljs$core$fn_17129.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17129__2;
return cljs$core$fn_17129;
})()
);

(cljs.core.NodeSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_17130 = null;
var cljs$core$fn_17130__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_17130__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17130 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17130__1.call(this,x);
case 2:
return cljs$core$fn_17130__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17130.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17130__1;
cljs$core$fn_17130.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17130__2;
return cljs$core$fn_17130;
})()
);

(cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17131(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.NodeSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_17132(coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,(self__.i + (2)),null);
} else {
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s));
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17133(coll){
var self__ = this;
var coll__$1 = this;
var h__9978__auto__ = self__.__hash;
if((!((h__9978__auto__ == null)))){
return h__9978__auto__;
} else {
var h__9978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9978__auto____$1);

return h__9978__auto____$1;
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17134(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17135(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17136(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17137(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_17138(coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return (new cljs.core.MapEntry((self__.nodes[self__.i]),(self__.nodes[(self__.i + (1))]),null));
} else {
return cljs.core.first(self__.s);
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_17139(coll){
var self__ = this;
var coll__$1 = this;
var ret = (((self__.s == null))?cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,(self__.i + (2)),null):cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s)));
if((!((ret == null)))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17140(this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17141(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.NodeSeq(new_meta,self__.nodes,self__.i,self__.s,self__.__hash));
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17142(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.NodeSeq.getBasis = (function cljs$core$fn_17143(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"nodes","nodes",-459054278,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.NodeSeq.cljs$lang$type = true);

(cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq");

(cljs.core.NodeSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_17144(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/NodeSeq");
}));

/**
 * Positional factory function for cljs.core/NodeSeq.
 */
cljs.core.__GT_NodeSeq = (function cljs$core$__GT_NodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.NodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17145(){
var this__10707__auto__ = this;
return cljs.core.es6_iterator(this__10707__auto__);
}));
cljs.core.create_inode_seq = (function cljs$core$create_inode_seq(var_args){
var G__17147 = arguments.length;
switch (G__17147) {
case 1:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17148(nodes){
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
}));

(cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_17149(nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
if((!(((nodes[j]) == null)))){
return (new cljs.core.NodeSeq(null,nodes,j,null,null));
} else {
var temp__5718__auto__ = (nodes[(j + (1))]);
if(cljs.core.truth_(temp__5718__auto__)){
var node = temp__5718__auto__;
var temp__5718__auto____$1 = node.inode_seq();
if(cljs.core.truth_(temp__5718__auto____$1)){
var node_seq = temp__5718__auto____$1;
return (new cljs.core.NodeSeq(null,nodes,(j + (2)),node_seq,null));
} else {
var G__17151 = (j + (2));
j = G__17151;
continue;
}
} else {
var G__17152 = (j + (2));
j = G__17152;
continue;
}
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.NodeSeq(null,nodes,i,s,null));
}
}));

(cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayNodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ArrayNodeSeq.prototype.toString = (function cljs$core$fn_17153(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ArrayNodeSeq.prototype.equiv = (function cljs$core$fn_17154(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ArrayNodeSeq.prototype.indexOf = (function() {
var cljs$core$fn_17155 = null;
var cljs$core$fn_17155__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_17155__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17155 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17155__1.call(this,x);
case 2:
return cljs$core$fn_17155__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17155.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17155__1;
cljs$core$fn_17155.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17155__2;
return cljs$core$fn_17155;
})()
);

(cljs.core.ArrayNodeSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_17156 = null;
var cljs$core$fn_17156__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_17156__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17156 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17156__1.call(this,x);
case 2:
return cljs$core$fn_17156__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17156.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17156__1;
cljs$core$fn_17156.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17156__2;
return cljs$core$fn_17156;
})()
);

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17157(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_17158(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s));
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17159(coll){
var self__ = this;
var coll__$1 = this;
var h__9978__auto__ = self__.__hash;
if((!((h__9978__auto__ == null)))){
return h__9978__auto__;
} else {
var h__9978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9978__auto____$1);

return h__9978__auto____$1;
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17160(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17161(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17162(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17163(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_17164(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.s);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_17165(coll){
var self__ = this;
var coll__$1 = this;
var ret = cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s));
if((!((ret == null)))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17166(this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17167(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ArrayNodeSeq(new_meta,self__.nodes,self__.i,self__.s,self__.__hash));
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17168(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.ArrayNodeSeq.getBasis = (function cljs$core$fn_17169(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"nodes","nodes",-459054278,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayNodeSeq.cljs$lang$type = true);

(cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq");

(cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_17170(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/ArrayNodeSeq");
}));

/**
 * Positional factory function for cljs.core/ArrayNodeSeq.
 */
cljs.core.__GT_ArrayNodeSeq = (function cljs$core$__GT_ArrayNodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17171(){
var this__10707__auto__ = this;
return cljs.core.es6_iterator(this__10707__auto__);
}));
cljs.core.create_array_node_seq = (function cljs$core$create_array_node_seq(var_args){
var G__17173 = arguments.length;
switch (G__17173) {
case 1:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17174(nodes){
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
}));

(cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_17175(nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
var temp__5718__auto__ = (nodes[j]);
if(cljs.core.truth_(temp__5718__auto__)){
var nj = temp__5718__auto__;
var temp__5718__auto____$1 = nj.inode_seq();
if(cljs.core.truth_(temp__5718__auto____$1)){
var ns = temp__5718__auto____$1;
return (new cljs.core.ArrayNodeSeq(null,nodes,(j + (1)),ns,null));
} else {
var G__17177 = (j + (1));
j = G__17177;
continue;
}
} else {
var G__17178 = (j + (1));
j = G__17178;
continue;
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.ArrayNodeSeq(null,nodes,i,s,null));
}
}));

(cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 3);


/**
* @constructor
*/
cljs.core.HashMapIter = (function (nil_val,root_iter,seen){
this.nil_val = nil_val;
this.root_iter = root_iter;
this.seen = seen;
});
(cljs.core.HashMapIter.prototype.hasNext = (function cljs$core$fn_17179(){
var self__ = this;
var _ = this;
return (((!(self__.seen))) || (self__.root_iter.hasNext()));
}));

(cljs.core.HashMapIter.prototype.next = (function cljs$core$fn_17180(){
var self__ = this;
var _ = this;
if((!(self__.seen))){
(self__.seen = true);

return (new cljs.core.MapEntry(null,self__.nil_val,null));
} else {
return self__.root_iter.next();
}
}));

(cljs.core.HashMapIter.prototype.remove = (function cljs$core$fn_17181(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.HashMapIter.getBasis = (function cljs$core$fn_17182(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),new cljs.core.Symbol(null,"root-iter","root-iter",1974672108,null),cljs.core.with_meta(new cljs.core.Symbol(null,"seen","seen",1121531738,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.HashMapIter.cljs$lang$type = true);

(cljs.core.HashMapIter.cljs$lang$ctorStr = "cljs.core/HashMapIter");

(cljs.core.HashMapIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_17183(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/HashMapIter");
}));

/**
 * Positional factory function for cljs.core/HashMapIter.
 */
cljs.core.__GT_HashMapIter = (function cljs$core$__GT_HashMapIter(nil_val,root_iter,seen){
return (new cljs.core.HashMapIter(nil_val,root_iter,seen));
});


/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentHashMap = (function (meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
this.meta = meta;
this.cnt = cnt;
this.root = root;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 139268;
});
(cljs.core.PersistentHashMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentHashMap.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_17185(coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.MapEntry(null,self__.nil_val,null));
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_find((0),cljs.core.hash(k),k,null);

}
}
}));

(cljs.core.PersistentHashMap.prototype.toString = (function cljs$core$fn_17186(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentHashMap.prototype.equiv = (function cljs$core$fn_17187(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentHashMap.prototype.keys = (function cljs$core$fn_17188(){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.keys(coll));
}));

(cljs.core.PersistentHashMap.prototype.entries = (function cljs$core$fn_17189(){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentHashMap.prototype.values = (function cljs$core$fn_17190(){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.vals(coll));
}));

(cljs.core.PersistentHashMap.prototype.has = (function cljs$core$fn_17191(k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
}));

(cljs.core.PersistentHashMap.prototype.get = (function cljs$core$fn_17192(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentHashMap.prototype.forEach = (function cljs$core$fn_17193(f){
var self__ = this;
var coll = this;
var seq__17194 = cljs.core.seq(coll);
var chunk__17195 = null;
var count__17196 = (0);
var i__17197 = (0);
while(true){
if((i__17197 < count__17196)){
var vec__17204 = chunk__17195.cljs$core$IIndexed$_nth$arity$2(null,i__17197);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17204,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17204,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__17236 = seq__17194;
var G__17237 = chunk__17195;
var G__17238 = count__17196;
var G__17239 = (i__17197 + (1));
seq__17194 = G__17236;
chunk__17195 = G__17237;
count__17196 = G__17238;
i__17197 = G__17239;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__17194);
if(temp__5720__auto__){
var seq__17194__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__17194__$1)){
var c__10489__auto__ = cljs.core.chunk_first(seq__17194__$1);
var G__17240 = cljs.core.chunk_rest(seq__17194__$1);
var G__17241 = c__10489__auto__;
var G__17242 = cljs.core.count(c__10489__auto__);
var G__17243 = (0);
seq__17194 = G__17240;
chunk__17195 = G__17241;
count__17196 = G__17242;
i__17197 = G__17243;
continue;
} else {
var vec__17207 = cljs.core.first(seq__17194__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17207,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17207,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__17244 = cljs.core.next(seq__17194__$1);
var G__17245 = null;
var G__17246 = (0);
var G__17247 = (0);
seq__17194 = G__17244;
chunk__17195 = G__17245;
count__17196 = G__17246;
i__17197 = G__17247;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_17210(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_17211(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function cljs$core$fn_17212(coll,f,init){
var self__ = this;
var coll__$1 = this;
var init__$1 = ((self__.has_nil_QMARK_)?(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(init,null,self__.nil_val) : f.call(null,init,null,self__.nil_val)):init);
if(cljs.core.reduced_QMARK_(init__$1)){
return cljs.core.deref(init__$1);
} else {
if((!((self__.root == null)))){
return cljs.core.unreduced(self__.root.kv_reduce(f,init__$1));
} else {
return init__$1;

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_17213(coll){
var self__ = this;
var coll__$1 = this;
var root_iter = ((self__.root)?cljs.core._iterator(self__.root):cljs.core.nil_iter());
if(self__.has_nil_QMARK_){
return (new cljs.core.HashMapIter(self__.nil_val,root_iter,false));
} else {
return root_iter;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17214(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_17215(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashMap(self__.meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17216(coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17217(coll){
var self__ = this;
var coll__$1 = this;
var h__9978__auto__ = self__.__hash;
if((!((h__9978__auto__ == null)))){
return h__9978__auto__;
} else {
var h__9978__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__9978__auto____$1);

return h__9978__auto____$1;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17218(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function cljs$core$fn_17219(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashMap(({}),self__.root,self__.cnt,self__.has_nil_QMARK_,self__.nil_val));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17222(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY,self__.meta);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function cljs$core$fn_17223(coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),self__.root,false,null,null));
} else {
return coll__$1;
}
} else {
if((self__.root == null)){
return coll__$1;
} else {
var new_root = self__.root.inode_without((0),cljs.core.hash(k),k);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_17224(coll,k,v){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(((self__.has_nil_QMARK_) && ((v === self__.nil_val)))){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((self__.has_nil_QMARK_)?self__.cnt:(self__.cnt + (1))),self__.root,true,v,null));
}
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var new_root = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc((0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((added_leaf_QMARK_.val)?(self__.cnt + (1)):self__.cnt),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_17225(coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
return self__.has_nil_QMARK_;
} else {
if((self__.root == null)){
return false;
} else {
return (!((self__.root.inode_lookup((0),cljs.core.hash(k),k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)));

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17226(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var s = (((!((self__.root == null))))?self__.root.inode_seq():null);
if(self__.has_nil_QMARK_){
return cljs.core.cons((new cljs.core.MapEntry(null,self__.nil_val,null)),s);
} else {
return s;
}
} else {
return null;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17227(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(new_meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17228(coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__17248 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__17249 = cljs.core.next(es);
ret = G__17248;
es = G__17249;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
}));

(cljs.core.PersistentHashMap.prototype.call = (function() {
var cljs$core$fn_17229 = null;
var cljs$core$fn_17229__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var cljs$core$fn_17229__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
cljs$core$fn_17229 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_17229__2.call(this,self__,k);
case 3:
return cljs$core$fn_17229__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_17229.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17229__2;
cljs$core$fn_17229.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_17229__3;
return cljs$core$fn_17229;
})()
);

(cljs.core.PersistentHashMap.prototype.apply = (function cljs$core$fn_17230(self__,args17184){
var self__ = this;
var self____$1 = this;
var args__10120__auto__ = cljs.core.aclone(args17184);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10120__auto__.length > (20)))?(function (){var G__17231 = args__10120__auto__.slice((0),(20));
G__17231.push(args__10120__auto__.slice((20)));

return G__17231;
})():args__10120__auto__)));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17232(k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_17233(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentHashMap.getBasis = (function cljs$core$fn_17234(){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"root","root",1191874074,null),cljs.core.with_meta(new cljs.core.Symbol(null,"has-nil?","has-nil?",825886722,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)], null)),new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentHashMap.cljs$lang$type = true);

(cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap");

(cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = (function cljs$core$fn_17235(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/PersistentHashMap");
}));

/**
 * Positional factory function for cljs.core/PersistentHashMap.
 */
cljs.core.__GT_PersistentHashMap = (function cljs$core$__GT_PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
return (new cljs.core.PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash));
});

(cljs.core.PersistentHashMap.EMPTY = (new cljs.core.PersistentHashMap(null,(0),null,false,null,cljs.core.empty_unordered_hash)));
(cljs.core.PersistentHashMap.fromArray = (function cljs$core$fn_17250(arr,no_clone){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__17251 = (i + (2));
var G__17252 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__17251;
ret = G__17252;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
}));
(cljs.core.PersistentHashMap.fromArrays = (function cljs$core$fn_17253(ks,vs){
var len = ks.length;
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
if((vs.length <= i)){
throw (new Error(["No value supplied for key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((ks[i]))].join('')));
} else {
var G__17254 = (i + (1));
var G__17255 = cljs.core._assoc_BANG_(out,(ks[i]),(vs[i]));
i = G__17254;
out = G__17255;
continue;
}
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}));
(cljs.core.PersistentHashMap.createWithCheck = (function cljs$core$fn_17256(arr){
var len = arr.length;
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i_17257 = (0);
while(true){
if((i_17257 < len)){
cljs.core._assoc_BANG_(ret,(arr[i_17257]),(arr[(i_17257 + (1))]));

if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core._count(ret),((i_17257 / (2)) + (1)))){
throw (new Error(["Duplicate key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arr[i_17257]))].join('')));
} else {
var G__17258 = (i_17257 + (2));
i_17257 = G__17258;
continue;
}
} else {
}
break;
}

return cljs.core._persistent_BANG_(ret);
}));
(cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17259(){
var this__10707__auto__ = this;
return cljs.core.es6_iterator(this__10707__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientHashMap = (function (edit,root,count,has_nil_QMARK_,nil_val){
this.edit = edit;
this.root = root;
this.count = count;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 56;
});
(cljs.core.TransientHashMap.prototype.conj_BANG_ = (function cljs$core$fn_17261(o){
var self__ = this;
var tcoll = this;
if(self__.edit){
if(cljs.core.map_entry_QMARK_(o)){
return tcoll.assoc_BANG_(cljs.core.key(o),cljs.core.val(o));
} else {
if(cljs.core.vector_QMARK_(o)){
return tcoll.assoc_BANG_((o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((0)) : o.call(null,(0))),(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((1)) : o.call(null,(1))));
} else {
var es = cljs.core.seq(o);
var tcoll__$1 = tcoll;
while(true){
var temp__5718__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__5718__auto__)){
var e = temp__5718__auto__;
var G__17279 = cljs.core.next(es);
var G__17280 = tcoll__$1.assoc_BANG_(cljs.core.key(e),cljs.core.val(e));
es = G__17279;
tcoll__$1 = G__17280;
continue;
} else {
return tcoll__$1;
}
break;
}

}
}
} else {
throw (new Error("conj! after persistent"));
}
}));

(cljs.core.TransientHashMap.prototype.assoc_BANG_ = (function cljs$core$fn_17262(k,v){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if((self__.nil_val === v)){
} else {
(self__.nil_val = v);
}

if(self__.has_nil_QMARK_){
} else {
(self__.count = (self__.count + (1)));

(self__.has_nil_QMARK_ = true);
}

return tcoll;
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var node = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc_BANG_(self__.edit,(0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((node === self__.root)){
} else {
(self__.root = node);
}

if(added_leaf_QMARK_.val){
(self__.count = (self__.count + (1)));
} else {
}

return tcoll;
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.without_BANG_ = (function cljs$core$fn_17263(k){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if(self__.has_nil_QMARK_){
(self__.has_nil_QMARK_ = false);

(self__.nil_val = null);

(self__.count = (self__.count - (1)));

return tcoll;
} else {
return tcoll;
}
} else {
if((self__.root == null)){
return tcoll;
} else {
var removed_leaf_QMARK_ = (new cljs.core.Box(false));
var node = self__.root.inode_without_BANG_(self__.edit,(0),cljs.core.hash(k),k,removed_leaf_QMARK_);
if((node === self__.root)){
} else {
(self__.root = node);
}

if(removed_leaf_QMARK_.val){
(self__.count = (self__.count - (1)));
} else {
}

return tcoll;
}
}
} else {
throw (new Error("dissoc! after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.persistent_BANG_ = (function cljs$core$fn_17264(){
var self__ = this;
var tcoll = this;
if(self__.edit){
(self__.edit = null);

return (new cljs.core.PersistentHashMap(null,self__.count,self__.root,self__.has_nil_QMARK_,self__.nil_val,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17265(coll){
var self__ = this;
var coll__$1 = this;
if(self__.edit){
return self__.count;
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_17266(tcoll,k){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k);
}
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_17267(tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);
}
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function cljs$core$fn_17268(tcoll,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.conj_BANG_(val);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function cljs$core$fn_17269(tcoll){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.persistent_BANG_();
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function cljs$core$fn_17270(tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.assoc_BANG_(key,val);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function cljs$core$fn_17271(tcoll,key){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.without_BANG_(key);
}));

(cljs.core.TransientHashMap.prototype.call = (function() {
var cljs$core$fn_17272 = null;
var cljs$core$fn_17272__2 = (function (self__,key){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$2(null,key);
});
var cljs$core$fn_17272__3 = (function (self__,key,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
});
cljs$core$fn_17272 = function(self__,key,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_17272__2.call(this,self__,key);
case 3:
return cljs$core$fn_17272__3.call(this,self__,key,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_17272.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17272__2;
cljs$core$fn_17272.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_17272__3;
return cljs$core$fn_17272;
})()
);

(cljs.core.TransientHashMap.prototype.apply = (function cljs$core$fn_17273(self__,args17260){
var self__ = this;
var self____$1 = this;
var args__10120__auto__ = cljs.core.aclone(args17260);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10120__auto__.length > (20)))?(function (){var G__17274 = args__10120__auto__.slice((0),(20));
G__17274.push(args__10120__auto__.slice((20)));

return G__17274;
})():args__10120__auto__)));
}));

(cljs.core.TransientHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17275(key){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$2(null,key);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_17276(key,not_found){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
}));

(cljs.core.TransientHashMap.getBasis = (function cljs$core$fn_17277(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"has-nil?","has-nil?",825886722,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.TransientHashMap.cljs$lang$type = true);

(cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap");

(cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = (function cljs$core$fn_17278(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/TransientHashMap");
}));

/**
 * Positional factory function for cljs.core/TransientHashMap.
 */
cljs.core.__GT_TransientHashMap = (function cljs$core$__GT_TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val){
return (new cljs.core.TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val));
});

cljs.core.tree_map_seq_push = (function cljs$core$tree_map_seq_push(node,stack,ascending_QMARK_){
var t = node;
var stack__$1 = stack;
while(true){
if((!((t == null)))){
var G__17281 = ((ascending_QMARK_)?t.left:t.right);
var G__17282 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1,t);
t = G__17281;
stack__$1 = G__17282;
continue;
} else {
return stack__$1;
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentTreeMapSeq = (function (meta,stack,ascending_QMARK_,cnt,__hash){
this.meta = meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.PersistentTreeMapSeq.prototype.toString = (function cljs$core$fn_17283(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentTreeMapSeq.prototype.equiv = (function cljs$core$fn_17284(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentTreeMapSeq.prototype.indexOf = (function() {
var cljs$core$fn_17285 = null;
var cljs$core$fn_17285__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_17285__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17285 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17285__1.call(this,x);
case 2:
return cljs$core$fn_17285__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17285.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17285__1;
cljs$core$fn_17285.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17285__2;
return cljs$core$fn_17285;
})()
);

(cljs.core.PersistentTreeMapSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_17286 = null;
var cljs$core$fn_17286__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_17286__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17286 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17286__1.call(this,x);
case 2:
return cljs$core$fn_17286__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17286.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17286__1;
cljs$core$fn_17286.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17286__2;
return cljs$core$fn_17286;
})()
);

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17287(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_17288(this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if((next_stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17289(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt < (0))){
return (cljs.core.count(cljs.core.next(coll__$1)) + (1));
} else {
return self__.cnt;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17290(coll){
var self__ = this;
var coll__$1 = this;
var h__9978__auto__ = self__.__hash;
if((!((h__9978__auto__ == null)))){
return h__9978__auto__;
} else {
var h__9978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9978__auto____$1);

return h__9978__auto____$1;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17291(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17292(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17293(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17294(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_17295(this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.peek(self__.stack);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_17296(this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if((!((next_stack == null)))){
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17297(this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17298(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMapSeq(new_meta,self__.stack,self__.ascending_QMARK_,self__.cnt,self__.__hash));
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17299(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.getBasis = (function cljs$core$fn_17300(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"stack","stack",847125597,null),cljs.core.with_meta(new cljs.core.Symbol(null,"ascending?","ascending?",-1938452653,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)], null)),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentTreeMapSeq.cljs$lang$type = true);

(cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq");

(cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_17301(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/PersistentTreeMapSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentTreeMapSeq.
 */
cljs.core.__GT_PersistentTreeMapSeq = (function cljs$core$__GT_PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash){
return (new cljs.core.PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash));
});

(cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17302(){
var this__10707__auto__ = this;
return cljs.core.es6_iterator(this__10707__auto__);
}));
cljs.core.create_tree_map_seq = (function cljs$core$create_tree_map_seq(tree,ascending_QMARK_,cnt){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.tree_map_seq_push(tree,null,ascending_QMARK_),ascending_QMARK_,cnt,null));
});

cljs.core.balance_left = (function cljs$core$balance_left(key,val,ins,right){
if((ins instanceof cljs.core.RedNode)){
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,ins.left.blacken(),(new cljs.core.BlackNode(key,val,ins.right,right,null)),null));
} else {
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.right.key,ins.right.val,(new cljs.core.BlackNode(ins.key,ins.val,ins.left,ins.right.left,null)),(new cljs.core.BlackNode(key,val,ins.right.right,right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));
}
});
cljs.core.balance_right = (function cljs$core$balance_right(key,val,left,ins){
if((ins instanceof cljs.core.RedNode)){
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,(new cljs.core.BlackNode(key,val,left,ins.left,null)),ins.right.blacken(),null));
} else {
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.left.key,ins.left.val,(new cljs.core.BlackNode(key,val,left,ins.left.left,null)),(new cljs.core.BlackNode(ins.key,ins.val,ins.left.right,ins.right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));
}
});
cljs.core.balance_left_del = (function cljs$core$balance_left_del(key,val,del,right){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,del.blacken(),right,null));
} else {
if((right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right(key,val,del,right.redden());
} else {
if((((right instanceof cljs.core.RedNode)) && ((right.left instanceof cljs.core.BlackNode)))){
return (new cljs.core.RedNode(right.left.key,right.left.val,(new cljs.core.BlackNode(key,val,del,right.left.left,null)),cljs.core.balance_right(right.key,right.val,right.left.right,right.right.redden()),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.balance_right_del = (function cljs$core$balance_right_del(key,val,left,del){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,left,del.blacken(),null));
} else {
if((left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left(key,val,left.redden(),del);
} else {
if((((left instanceof cljs.core.RedNode)) && ((left.right instanceof cljs.core.BlackNode)))){
return (new cljs.core.RedNode(left.right.key,left.right.val,cljs.core.balance_left(left.key,left.val,left.left.redden(),left.right.left),(new cljs.core.BlackNode(key,val,left.right.right,del,null)),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.tree_map_kv_reduce = (function cljs$core$tree_map_kv_reduce(node,f,init){
var init__$1 = (((!((node.left == null))))?(function (){var G__17303 = node.left;
var G__17304 = f;
var G__17305 = init;
return (cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__17303,G__17304,G__17305) : cljs.core.tree_map_kv_reduce.call(null,G__17303,G__17304,G__17305));
})():init);
if(cljs.core.reduced_QMARK_(init__$1)){
return init__$1;
} else {
var init__$2 = (function (){var G__17306 = init__$1;
var G__17307 = node.key;
var G__17308 = node.val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17306,G__17307,G__17308) : f.call(null,G__17306,G__17307,G__17308));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
if((!((node.right == null)))){
var G__17309 = node.right;
var G__17310 = f;
var G__17311 = init__$2;
return (cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__17309,G__17310,G__17311) : cljs.core.tree_map_kv_reduce.call(null,G__17309,G__17310,G__17311));
} else {
return init__$2;
}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.BlackNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.BlackNode.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.BlackNode.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_17313(node,k){
var self__ = this;
var node__$1 = this;
var G__17314 = k;
switch (G__17314) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.BlackNode.prototype.lastIndexOf = (function() {
var cljs$core$fn_17315 = null;
var cljs$core$fn_17315__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_17315__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17315 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17315__1.call(this,x);
case 2:
return cljs$core$fn_17315__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17315.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17315__1;
cljs$core$fn_17315.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17315__2;
return cljs$core$fn_17315;
})()
);

(cljs.core.BlackNode.prototype.indexOf = (function() {
var cljs$core$fn_17316 = null;
var cljs$core$fn_17316__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_17316__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17316 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17316__1.call(this,x);
case 2:
return cljs$core$fn_17316__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17316.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17316__1;
cljs$core$fn_17316.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17316__2;
return cljs$core$fn_17316;
})()
);

(cljs.core.BlackNode.prototype.add_right = (function cljs$core$fn_17317(ins){
var self__ = this;
var node = this;
return ins.balance_right(node);
}));

(cljs.core.BlackNode.prototype.redden = (function cljs$core$fn_17318(){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,self__.right,null));
}));

(cljs.core.BlackNode.prototype.blacken = (function cljs$core$fn_17319(){
var self__ = this;
var node = this;
return node;
}));

(cljs.core.BlackNode.prototype.add_left = (function cljs$core$fn_17320(ins){
var self__ = this;
var node = this;
return ins.balance_left(node);
}));

(cljs.core.BlackNode.prototype.replace = (function cljs$core$fn_17321(key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(key__$1,val__$1,left__$1,right__$1,null));
}));

(cljs.core.BlackNode.prototype.balance_left = (function cljs$core$fn_17322(parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));
}));

(cljs.core.BlackNode.prototype.balance_right = (function cljs$core$fn_17323(parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));
}));

(cljs.core.BlackNode.prototype.remove_left = (function cljs$core$fn_17324(del){
var self__ = this;
var node = this;
return cljs.core.balance_left_del(self__.key,self__.val,del,self__.right);
}));

(cljs.core.BlackNode.prototype.kv_reduce = (function cljs$core$fn_17325(f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
}));

(cljs.core.BlackNode.prototype.remove_right = (function cljs$core$fn_17326(del){
var self__ = this;
var node = this;
return cljs.core.balance_right_del(self__.key,self__.val,self__.left,del);
}));

(cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_17327(node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
}));

(cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_17328(node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_17329(node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_17330(node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function cljs$core$fn_17331(node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
}));

(cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17332(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17333(node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function cljs$core$fn_17334(node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function cljs$core$fn_17335(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_17336(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_17337(node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.BlackNode.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_17338(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17339(coll){
var self__ = this;
var coll__$1 = this;
var h__9978__auto__ = self__.__hash;
if((!((h__9978__auto__ == null)))){
return h__9978__auto__;
} else {
var h__9978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9978__auto____$1);

return h__9978__auto____$1;
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17340(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17341(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17342(node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
}));

(cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17343(node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
}));

(cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_17344(node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.BlackNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_17345(node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17346(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17347(node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core._with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17348(node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.BlackNode.prototype.call = (function() {
var cljs$core$fn_17349 = null;
var cljs$core$fn_17349__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var cljs$core$fn_17349__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
cljs$core$fn_17349 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_17349__2.call(this,self__,k);
case 3:
return cljs$core$fn_17349__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_17349.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17349__2;
cljs$core$fn_17349.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_17349__3;
return cljs$core$fn_17349;
})()
);

(cljs.core.BlackNode.prototype.apply = (function cljs$core$fn_17350(self__,args17312){
var self__ = this;
var self____$1 = this;
var args__10120__auto__ = cljs.core.aclone(args17312);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10120__auto__.length > (20)))?(function (){var G__17351 = args__10120__auto__.slice((0),(20));
G__17351.push(args__10120__auto__.slice((20)));

return G__17351;
})():args__10120__auto__)));
}));

(cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17352(k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_17353(k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.BlackNode.getBasis = (function cljs$core$fn_17354(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"left","left",1241415590,null),new cljs.core.Symbol(null,"right","right",1187949694,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.BlackNode.cljs$lang$type = true);

(cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode");

(cljs.core.BlackNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_17355(this__10194__auto__,writer__10195__auto__,opt__10196__auto__){
return cljs.core._write(writer__10195__auto__,"cljs.core/BlackNode");
}));

/**
 * Positional factory function for cljs.core/BlackNode.
 */
cljs.core.__GT_BlackNode = (function cljs$core$__GT_BlackNode(key,val,left,right,__hash){
return (new cljs.core.BlackNode(key,val,left,right,__hash));
});

(cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17357(){
var this__10707__auto__ = this;
return cljs.core.es6_iterator(this__10707__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RedNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.RedNode.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.RedNode.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_17359(node,k){
var self__ = this;
var node__$1 = this;
var G__17360 = k;
switch (G__17360) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.RedNode.prototype.lastIndexOf = (function() {
var cljs$core$fn_17361 = null;
var cljs$core$fn_17361__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_17361__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17361 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17361__1.call(this,x);
case 2:
return cljs$core$fn_17361__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17361.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17361__1;
cljs$core$fn_17361.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17361__2;
return cljs$core$fn_17361;
})()
);

(cljs.core.RedNode.prototype.indexOf = (function() {
var cljs$core$fn_17362 = null;
var cljs$core$fn_17362__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_17362__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17362 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17362__1.call(this,x);
case 2:
return cljs$core$fn_17362__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17362.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17362__1;
cljs$core$fn_17362.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17362__2;
return cljs$core$fn_17362;
})()
);

(cljs.core.RedNode.prototype.add_right = (function cljs$core$fn_17363(ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,ins,null));
}));

(cljs.core.RedNode.prototype.redden = (function cljs$core$fn_17364(){
var self__ = this;
var node = this;
throw (new Error("red-black tree invariant violation"));
}));

(cljs.core.RedNode.prototype.blacken = (function cljs$core$fn_17365(){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right,null));
}));

(cljs.core.RedNode.prototype.add_left = (function cljs$core$fn_17366(ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,ins,self__.right,null));
}));

(cljs.core.RedNode.prototype.replace = (function cljs$core$fn_17367(key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(key__$1,val__$1,left__$1,right__$1,null));
}));

(cljs.core.RedNode.prototype.balance_left = (function cljs$core$fn_17368(parent){
var self__ = this;
var node = this;
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,self__.left.blacken(),(new cljs.core.BlackNode(parent.key,parent.val,self__.right,parent.right,null)),null));
} else {
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.right.key,self__.right.val,(new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right.left,null)),(new cljs.core.BlackNode(parent.key,parent.val,self__.right.right,parent.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));

}
}
}));

(cljs.core.RedNode.prototype.balance_right = (function cljs$core$fn_17369(parent){
var self__ = this;
var node = this;
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left,null)),self__.right.blacken(),null));
} else {
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.left.key,self__.left.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left.left,null)),(new cljs.core.BlackNode(self__.key,self__.val,self__.left.right,self__.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));

}
}
}));

(cljs.core.RedNode.prototype.remove_left = (function cljs$core$fn_17370(del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,del,self__.right,null));
}));

(cljs.core.RedNode.prototype.kv_reduce = (function cljs$core$fn_17371(f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
}));

(cljs.core.RedNode.prototype.remove_right = (function cljs$core$fn_17372(del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,del,null));
}));

(cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_17373(node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
}));

(cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_17374(node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_17375(node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_17376(node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function cljs$core$fn_17377(node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
}));

(cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17378(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17379(node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function cljs$core$fn_17380(node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function cljs$core$fn_17381(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_17382(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_17383(node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.RedNode.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_17384(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17385(coll){
var self__ = this;
var coll__$1 = this;
var h__9978__auto__ = self__.__hash;
if((!((h__9978__auto__ == null)))){
return h__9978__auto__;
} else {
var h__9978__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9978__auto____$1);

return h__9978__auto____$1;
}
}));

(cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17386(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17387(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17388(node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
}));

(cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17389(node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
}));

(cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_17390(node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.RedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_17391(node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17392(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17393(node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core._with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17394(node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.RedNode.prototype.call = (function() {
var cljs$core$fn_17395 = null;
var cljs$core$fn_17395__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var cljs$core$fn_17395__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
cljs$core$fn_17395 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_17395__2.call(this,self__,k);
case 3:
return cljs$core$fn_17395__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_17395.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17395__2;
cljs$core$fn_17395.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_17395__3;
return cljs$core$fn_17395;
})()
);

(cljs.core.RedNode.prototype.apply = (function cljs$core$fn_17396(self__,args17358){
var self__ = this;
var self____$1 = this;
var args__10120__auto__ = cljs.core.aclone(args17358);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10120__auto__.length > (20)))?(function (){var G__17397 = args__10120__auto__.slice((0),(20));
G__17397.push(args__10120__auto__.slice((20)));

return G__17397;
})():args__10120__auto__)));
}));

(cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17398(k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_17399(k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.RedNode.getBasis = (function cljs$core$fn_17400(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"left","left",1241415590,null),new cljs.core.Symbol(null,"right