/*
 * Decompiled with CFR 0.152.
 */
package clojure.storm;

import clojure.lang.ISeq;
import clojure.lang.Keyword;
import clojure.lang.Symbol;
import clojure.storm.IForm;

public class FormObject
implements IForm {
    private int formId;
    private Object form;
    private String nsName;
    private String sourceFile;
    private int line;
    public static final Keyword EXTEND_PROTOCOL_KEY = Keyword.intern(null, "extend-protocol");
    public static final Keyword EXTEND_TYPE_KEY = Keyword.intern(null, "extend-type");
    public static final Keyword DEFMETHOD_KEY = Keyword.intern(null, "defmethod");
    public static final Keyword DEFRECORD_KEY = Keyword.intern(null, "defrecord");
    public static final Keyword DEFTYPE_KEY = Keyword.intern(null, "deftype");
    public static final Keyword DEFN_KEY = Keyword.intern(null, "defn");
    public static final Keyword UNKNOWN_KEY = Keyword.intern(null, "unknown");

    public FormObject(int formId, String nsName, String sourceFile, int line, Object form) {
        this.formId = formId;
        this.form = form;
        this.nsName = nsName;
        this.sourceFile = sourceFile;
        this.line = line;
    }

    @Override
    public Object getForm() {
        return this.form;
    }

    @Override
    public Integer getId() {
        return this.formId;
    }

    @Override
    public String getNs() {
        return this.nsName;
    }

    @Override
    public String getSourceFile() {
        return this.sourceFile;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    public static String multiMethodDispatchVal(ISeq form) {
        String val2 = null;
        if (form != null && form.next() != null && form.next().next() != null) {
            val2 = form.next().next().first() == null ? "nil" : form.next().next().first().toString();
        } else {
            System.out.println("Storm warning, couldn't parse multimethod dispatch value from " + form.toString());
            return "STORM-ERROR";
        }
        return val2;
    }

    public static Keyword formKind(Object form) {
        if (form instanceof ISeq) {
            ISeq frm = (ISeq)form;
            if (frm.count() > 2 && frm.first() instanceof Symbol) {
                Symbol s = (Symbol)frm.first();
                String sName = s.getName();
                if (sName.equals("extend-protocol")) {
                    return EXTEND_PROTOCOL_KEY;
                }
                if (sName.equals("extend-type")) {
                    return EXTEND_TYPE_KEY;
                }
                if (sName.equals("defmethod")) {
                    return DEFMETHOD_KEY;
                }
                if (sName.equals("defrecord")) {
                    return DEFRECORD_KEY;
                }
                if (sName.equals("deftype")) {
                    return DEFTYPE_KEY;
                }
                if (sName.equals("defn")) {
                    return DEFN_KEY;
                }
                return UNKNOWN_KEY;
            }
            return UNKNOWN_KEY;
        }
        return UNKNOWN_KEY;
    }
}

