/*
 * Decompiled with CFR 0.152.
 */
package clojure.storm;

import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.Keyword;
import clojure.storm.FormLocation;
import clojure.storm.FormObject;
import clojure.storm.FormRegistry;

public class Tracer {
    private static IFn traceFnCallFn = null;
    private static IFn traceFnReturnFn = null;
    private static IFn traceExprFn = null;
    private static IFn traceBindFn = null;
    private static IFn handleExceptionFn = null;
    private static Keyword TRACE_FN_CALL_FN_KEY = Keyword.intern(null, "trace-fn-call-fn-key");
    private static Keyword TRACE_FN_RETURN_FN_KEY = Keyword.intern(null, "trace-fn-return-fn-key");
    private static Keyword TRACE_EXPR_FN_KEY = Keyword.intern(null, "trace-expr-fn-key");
    private static Keyword TRACE_BIND_FN_KEY = Keyword.intern(null, "trace-bind-fn-key");
    private static Keyword HANDLE_EXCEPTION_FN_KEY = Keyword.intern(null, "handle-exception-fn-key");
    private static Keyword TRACE_FN_CALL_FN = Keyword.intern(null, "trace-fn-call-fn");
    private static Keyword TRACE_FN_RETURN_FN = Keyword.intern(null, "trace-fn-return-fn");
    private static Keyword TRACE_EXPR_FN = Keyword.intern(null, "trace-expr-fn");
    private static Keyword TRACE_BIND_FN = Keyword.intern(null, "trace-bind-fn");
    private static Keyword HANDLE_EXCEPTION_FN = Keyword.intern(null, "handle-exception-fn");

    public static void handleThreadException(Thread thread2, Throwable ex) {
        if (handleExceptionFn != null) {
            handleExceptionFn.invoke(thread2, ex);
        }
    }

    public static void traceFnCall(IPersistentVector fnArgs, String fnNs, String fnName, int formId) {
        if (traceFnCallFn != null) {
            traceFnCallFn.invoke(null, fnNs, fnName, fnArgs, formId);
        }
    }

    public static void traceExpr(Object val2, String coord) {
        if (traceExprFn != null) {
            traceExprFn.invoke(null, val2, coord, 0);
        }
    }

    public static void traceFnReturn(Object retVal, String coord) {
        if (traceFnReturnFn != null) {
            traceFnReturnFn.invoke(null, retVal, coord, 0);
        }
    }

    public static void traceBind(Object val2, String coord, String symName) {
        if (traceBindFn != null) {
            traceBindFn.invoke(null, coord, symName, val2);
        }
    }

    public static void registerFormLocation(int formId, int line, String ns2, String sourceFile) {
        FormRegistry.registerForm(formId, new FormLocation(formId, sourceFile, ns2, line));
    }

    public static void registerFormObject(int formId, String nsName, String sourceFile, int line, Object form) {
        FormRegistry.registerForm(formId, new FormObject(formId, nsName, sourceFile, line, form));
    }

    public static void setTraceFnsCallbacks(IPersistentMap callbacks) {
        if (callbacks.valAt(TRACE_FN_CALL_FN_KEY) != null) {
            traceFnCallFn = (IFn)callbacks.valAt(TRACE_FN_CALL_FN_KEY);
        }
        if (callbacks.valAt(TRACE_FN_RETURN_FN_KEY) != null) {
            traceFnReturnFn = (IFn)callbacks.valAt(TRACE_FN_RETURN_FN_KEY);
        }
        if (callbacks.valAt(TRACE_EXPR_FN_KEY) != null) {
            traceExprFn = (IFn)callbacks.valAt(TRACE_EXPR_FN_KEY);
        }
        if (callbacks.valAt(TRACE_BIND_FN_KEY) != null) {
            traceBindFn = (IFn)callbacks.valAt(TRACE_BIND_FN_KEY);
        }
        if (callbacks.valAt(HANDLE_EXCEPTION_FN_KEY) != null) {
            handleExceptionFn = (IFn)callbacks.valAt(HANDLE_EXCEPTION_FN_KEY);
        }
        if (callbacks.valAt(TRACE_FN_CALL_FN) != null) {
            traceFnCallFn = (IFn)callbacks.valAt(TRACE_FN_CALL_FN);
        }
        if (callbacks.valAt(TRACE_FN_RETURN_FN) != null) {
            traceFnReturnFn = (IFn)callbacks.valAt(TRACE_FN_RETURN_FN);
        }
        if (callbacks.valAt(TRACE_EXPR_FN) != null) {
            traceExprFn = (IFn)callbacks.valAt(TRACE_EXPR_FN);
        }
        if (callbacks.valAt(TRACE_BIND_FN) != null) {
            traceBindFn = (IFn)callbacks.valAt(TRACE_BIND_FN);
        }
        if (callbacks.valAt(HANDLE_EXCEPTION_FN) != null) {
            handleExceptionFn = (IFn)callbacks.valAt(HANDLE_EXCEPTION_FN);
        }
    }

    static {
        Thread.setDefaultUncaughtExceptionHandler((t, e2) -> Tracer.handleThreadException(t, e2));
    }
}

