(ns narcissus.core
  (:import (java.lang.invoke MethodHandle MethodHandles)
           (narcissus FieldReflector)))

(defn get-field [input-class object field-class field-name]
  (let [reflector ^FieldReflector (FieldReflector. input-class field-name field-class)]
    (.getField reflector object)))

(defn set-field [input-class object field-class field-name field-value]
  (let [reflector ^FieldReflector (FieldReflector. input-class field-name field-class)]
    (.setField reflector object field-value)))

(defn call-private-method
  ([obj method-name args]
   (call-private-method obj method-name args (clojure.core/map class args)))
  ([obj method-name args arg-types]
   (let [lookup (MethodHandles/privateLookupIn (class obj) (MethodHandles/lookup))
         method-handle ^MethodHandle (->> (.getDeclaredMethod (class obj) method-name (into-array Class arg-types))
                                          (.unreflect lookup))]
     (.invokeWithArguments method-handle (into-array Object (cons obj args))))))
