package narcissus;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

public class FieldReflector {
    private final VarHandle handle;

    public FieldReflector(Class<?>  inputClass, String fieldName, Class<?> fieldClass) throws IllegalAccessException, NoSuchFieldException {
        this.handle = MethodHandles
                .privateLookupIn(inputClass, MethodHandles.lookup())
                .findVarHandle(inputClass, fieldName, fieldClass);
    }

    public Object getField(Object input) {
        return handle.get(input);
    }

    public void setField(Object input, Object fieldValue) {
        this.handle.set(input, fieldValue);
    }
}
