/*
 * Decompiled with CFR 0.152.
 */
package redis.util;

import com.google.common.primitives.SignedBytes;
import java.util.Comparator;
import redis.util.BytesValue;

public class BytesKey
extends BytesValue
implements Comparable<BytesKey> {
    private static final Comparator<byte[]> COMPARATOR = SignedBytes.lexicographicalComparator();
    private final int hashCode;

    @Override
    public boolean equals(Object o) {
        if (o instanceof BytesKey) {
            BytesKey other = (BytesKey)o;
            return this.hashCode == other.hashCode && BytesKey.equals(this.bytes, other.bytes);
        }
        return false;
    }

    public BytesKey(byte[] bytes) {
        super(bytes);
        int hashCode = 0;
        for (byte aByte : this.bytes) {
            hashCode += 43 * aByte;
        }
        this.hashCode = hashCode;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(BytesKey o) {
        return COMPARATOR.compare(this.bytes, o.bytes);
    }
}

