/*
 * Decompiled with CFR 0.152.
 */
package redis.netty4;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.charset.Charset;
import redis.netty4.Reply;
import redis.util.Encoding;

public class BulkReply
implements Reply<ByteBuf> {
    public static final BulkReply NIL_REPLY = new BulkReply();
    public static final char MARKER = '$';
    private final ByteBuf bytes;
    private final int capacity;

    private BulkReply() {
        this.bytes = null;
        this.capacity = -1;
    }

    public BulkReply(byte[] bytes) {
        this.bytes = Unpooled.wrappedBuffer((byte[])bytes);
        this.capacity = bytes.length;
    }

    public BulkReply(ByteBuf bytes) {
        this.bytes = bytes;
        this.capacity = bytes.capacity();
    }

    @Override
    public ByteBuf data() {
        return this.bytes;
    }

    public String asAsciiString() {
        if (this.bytes == null) {
            return null;
        }
        return this.bytes.toString(Charsets.US_ASCII);
    }

    public String asUTF8String() {
        if (this.bytes == null) {
            return null;
        }
        return this.bytes.toString(Charsets.UTF_8);
    }

    public String asString(Charset charset) {
        if (this.bytes == null) {
            return null;
        }
        return this.bytes.toString(charset);
    }

    @Override
    public void write(ByteBuf os) throws IOException {
        os.writeByte(36);
        os.writeBytes(Encoding.numToBytes((long)this.capacity, (boolean)true));
        if (this.capacity > 0) {
            os.writeBytes(this.bytes);
            os.writeBytes(CRLF);
        }
    }

    public String toString() {
        return this.asUTF8String();
    }
}

